(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  13315702,     594550]*)
(*NotebookOutlinePosition[  16618437,     672005]*)
(*  CellTagsIndexPosition[  16532554,     669520]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Abort", "ObjectName",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Abort[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " generates an interrupt to abort a computation. "
}], "Usage",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can call ",
  StyleBox["Abort", "MR"],
  " anywhere within a computation. It has the same effect as an interactive \
interrupt in which you select the abort option. "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["Abort", "MR"],
  " as an \[OpenCurlyDoubleQuote]emergency stop\[CloseCurlyDoubleQuote] in a \
computation. "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once ",
  StyleBox["Abort", "MR"],
  " has been called, ",
  StyleBox["Mathematica", "TI"],
  " functions currently being evaluated return as quickly as possible. "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] In an interactive session, the final result from an \
aborted computation is ",
  ButtonBox["$Aborted",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  ButtonBox["CheckAbort",
    ButtonStyle->"RefGuideLink"],
  " to \[OpenCurlyDoubleQuote]catch\[CloseCurlyDoubleQuote] returns from an \
abort. "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.6.14",
    ButtonData:>{"2.6.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Throw",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TimeConstrained",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["MemoryConstrained",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Return",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Abort"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1001", "Abort"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbortProtect", "ObjectName",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbortProtect[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " evaluates ",
  StyleBox["expr", "TI"],
  ", saving any aborts until the evaluation is complete. "
}], "Usage",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell[TextData[{
  "\[FilledSmallSquare] Aborts that are generated during an ",
  StyleBox["AbortProtect", "MR"],
  " take effect as soon as the execution of the ",
  StyleBox["AbortProtect", "MR"],
  " is over. "
}], "Notes",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["CheckAbort",
    ButtonStyle->"RefGuideLink"],
  " can be used inside ",
  StyleBox["AbortProtect", "MR"],
  " to catch and absorb any aborts that occur. "
}], "Notes",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbortProtect", "MR"],
  " also protects against aborts generated by ",
  ButtonBox["TimeConstrained",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["MemoryConstrained",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.6.14",
    ButtonData:>{"2.6.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1002", "AbortProtect"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1002", "AbortProtect"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abs", "ObjectName",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Abs[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the absolute value of the real or complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] For complex numbers ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["Abs[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the modulus ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[VerticalSeparator]", 
          StyleBox["z",
            "TI"], "\[VerticalSeparator]"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Abs[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is left unevaluated if ",
  StyleBox["z", "TI"],
  " is not a numeric quantity. "
}], "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.1.3",
    ButtonData:>{"1.1.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.1.5",
    ButtonData:>{"1.1.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.2.2",
    ButtonData:>{"3.2.2", "2.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Re",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Im",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Arg",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Mod",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ComplexExpand",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Norm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1003", "Abs"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Abs"],

Cell[TextData[{
  "The absolute value (or modulus) of a complex number ",
  StyleBox["z", "MR"],
  " is the distance from ",
  StyleBox["z", "MR"],
  " to the origin. "
}], "ExampleText",
  CellTags->"Abs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs[{\(-5\), 
        5 + 12\ \[ImaginaryI], \[ExponentialE]\^\(\@\(-2\)\)}]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Abs"],

Cell[BoxData[
    \({5, 13, 1}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Abs"]
}, Open  ]],

Cell["\<\
This shows the correspondence between the Cartesian and polar forms \
for complex numbers. \
\>", "ExampleText",
  CellTags->"Abs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[
      Abs[w] \((Cos[Arg[w]] + \[ImaginaryI]  Sin[Arg[w]])\) == w]\)], "Input",\

  CellLabel->"In[2]:= ",
  CellTags->"Abs"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Abs"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsoluteDashing", "ObjectName",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteDashing[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " is a graphics directive which specifies that lines which follow are to be \
drawn dashed, with successive segments having absolute lengths ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["d",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  " (repeated cyclically). "
}], "Usage",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] The absolute lengths are measured in units of \
printer's points, approximately equal to ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula"],
  " of an inch. "
}], "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteDashing[{", "MR"],
  " ",
  StyleBox["}]", "MR"],
  " specifies that lines should be solid. "
}], "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteDashing", "MR"],
  " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. \
"
}], "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.3",
    ButtonData:>{"2.10.3", "3.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Dashing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteThickness",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Offset",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Thickness",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GrayLevel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Hue",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RGBColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1004", "AbsoluteDashing"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AbsoluteDashing"],

Cell["\<\
This draws two dashed lines; one with the spaces twice as long as \
the dashes and the other with the reverse. \
\>", "ExampleText",
  CellTags->"AbsoluteDashing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{AbsoluteDashing[{10, 5}], Line[{{0, 1}, {1, 0}}], 
          AbsoluteDashing[{5, 10}], Line[{{0, 0}, {1, 1}}]}]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AbsoluteDashing"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ 10 5 ] 0 Mabsdash
.02381 .60332 m
.97619 .01472 L
s
[ 5 10 ] 0 Mabsdash
.02381 .01472 m
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AbsoluteDashing"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsoluteOptions", "ObjectName",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives the absolute settings of options specified in an expression such as \
a graphics object. \n\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["name", "TI"],
  StyleBox["]", "MR"],
  " gives the absolute setting for the option ",
  StyleBox["name", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["name",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["name",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " gives a list of the absolute settings for the options ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["name",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions[", "MR"],
  StyleBox["object", "TI"],
  StyleBox["]", "MR"],
  " gives the absolute settings for options associated with an external \
object such as a ",
  ButtonBox["NotebookObject",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Usage",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions", "MR"],
  " gives the actual settings for options used internally by ",
  StyleBox["Mathematica", "TI"],
  " when the setting given is ",
  ButtonBox["Automatic",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["All",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteOptions", "MR"],
  " returns lists of rules, just like ",
  ButtonBox["Options",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["AbsoluteOptions", "MR"],
  " on graphics options such as ",
  ButtonBox["PlotRange",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Ticks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you ask for ",
  StyleBox["AbsoluteOptions[NotebookObject[", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["],", "MR"],
  " ",
  StyleBox["name", "TI"],
  StyleBox["]", "MR"],
  " the kernel will send a request to the front end to find the result. "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.4",
    ButtonData:>{"1.9.4", "4.7"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.1",
    ButtonData:>{"2.10.1", "1.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Options",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FullGraphics",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["Utilities`FilterOptions`",
    ButtonData:>{"Utilities`FilterOptions`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1005", "AbsoluteOptions"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsolutePointSize", "ObjectName",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsolutePointSize[", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " is a graphics directive which specifies that points which follow are to \
be shown if possible as circular regions with absolute diameter ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[TextData[{
  "\[FilledSmallSquare] The absolute diameter is measured in units of \
printer's points, approximately equal to ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula"],
  " of an inch. "
}], "Notes",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsolutePointSize", "MR"],
  " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. \
"
}], "Notes",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.3",
    ButtonData:>{"2.10.3", "3.12"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Offset",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PointSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteThickness",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Thickness",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell["\<\
\[FilledSmallSquare] New in Version 2; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1006", "AbsolutePointSize"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AbsolutePointSize"],

Cell[TextData[{
  "The point size of the points on the diagonal range from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`10\)], "InlineFormula"],
  " printer's points; the circled point is shown at the default point size. "
}], "ExampleText",
  CellTags->"AbsolutePointSize"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Table[{AbsolutePointSize[d], Point[{d\/10, d\/10}]}, {d, 
              10}], Point[{1, 0}], Circle[{1, 0}, 0.05]}]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AbsolutePointSize"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.907029 0.0427438 0.560575 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
1 Mabswid
.11451 .0988 Mdot
2 Mabswid
.20522 .15486 Mdot
3 Mabswid
.29592 .21092 Mdot
4 Mabswid
.38662 .26697 Mdot
5 Mabswid
.47732 .32303 Mdot
6 Mabswid
.56803 .37909 Mdot
7 Mabswid
.65873 .43515 Mdot
8 Mabswid
.74943 .4912 Mdot
9 Mabswid
.84014 .54726 Mdot
10 Mabswid
.93084 .60332 Mdot
.008 w
.93084 .04274 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0453515 0.0280288 scale
20.525 1.52486 1 0 365.73 arc
setmatrix s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AbsolutePointSize"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsoluteThickness", "ObjectName",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteThickness[", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " is a graphics directive which specifies that lines which follow are to be \
drawn with absolute thickness ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[TextData[{
  "\[FilledSmallSquare] The absolute thickness is measured in units of \
printer's points, approximately equal to ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula"],
  " of an inch. "
}], "Notes",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteThickness", "MR"],
  " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. \
"
}], "Notes",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.3",
    ButtonData:>{"2.10.3", "3.15"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Thickness",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Offset",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteDashing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsolutePointSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PointSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Dashing",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1007", "AbsoluteThickness"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AbsoluteThickness"],

Cell["\<\
The thickness of the group of five lines varies from 1 to 5 \
printer's points; the single line is shown at the default thickness. \
\>", \
"ExampleText",
  CellTags->"AbsoluteThickness"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Table[{AbsoluteThickness[d], Line[{{0, 0}, {1, d}}]}, {d, 
              5}], Line[{{0, 5}, {1, 0}}]}]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AbsoluteThickness"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.117721 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
1 Mabswid
[ ] 0 setdash
.02381 .01472 m
.97619 .13244 L
s
2 Mabswid
.02381 .01472 m
.97619 .25016 L
s
3 Mabswid
.02381 .01472 m
.97619 .36788 L
s
4 Mabswid
.02381 .01472 m
.97619 .4856 L
s
5 Mabswid
.02381 .01472 m
.97619 .60332 L
s
.5 Mabswid
.02381 .60332 m
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AbsoluteThickness"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsoluteTime", "ObjectName",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTime[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the total number of seconds since the beginning of January 1, 1900, \
in your time zone. "
}], "Usage",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTime[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " uses whatever date and time have been set on your computer system. It \
performs no corrections for time zones, daylight saving time, etc. "
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTime[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the result for time zone ",
  StyleBox["z", "TI"],
  ". This is inferred by knowing your local date and time, and local time \
zone. The time zone is given as the number of hours to be added to Greenwich \
mean time to obtain local time. "
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTime[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is always accurate down to a granularity of ",
  ButtonBox["$TimeUnit",
    ButtonStyle->"RefGuideLink"],
  " seconds, but on many systems is much more accurate. "
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell["\<\
\[FilledSmallSquare] There are 2208988800 seconds from the \
beginning of January 1, 1900 to the beginning of January 1, 1970 and \
2840140800 seconds to the beginning of January 1, 1990. \
\>", "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.14.3",
    ButtonData:>{"2.14.3", "3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Date",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SessionTime",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TimeUsed",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteTiming",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Timing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TimeZone",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ToDate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FromDate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1008", "AbsoluteTime"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AbsoluteTiming", "ObjectName",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTiming[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " evaluates ",
  StyleBox["expr", "TI"],
  ", returning a list of the absolute time that has elapsed, together with \
the result obtained. "
}], "Usage",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTiming", "MR"],
  " gives the absolute number of seconds of real time that have elapsed, \
multiplied by the symbol ",
  StyleBox["Second", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTiming", "MR"],
  " has attribute ",
  ButtonBox["HoldAll",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTiming[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[";]", "MR"],
  " will give ",
  StyleBox["{", "MR"],
  StyleBox["timing", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Null}", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["First[AbsoluteTiming[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[";]]", "MR"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["Second->1", "MR"],
  " yields just the number of seconds of time elapsed in the evaluation of ",
  StyleBox["expr", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AbsoluteTiming", "MR"],
  " is always accurate down to a granularity of ",
  ButtonBox["$TimeUnit",
    ButtonStyle->"RefGuideLink"],
  " seconds, but on many systems is much more accurate. "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.14.3",
    ButtonData:>{"2.14.3", "3.12"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Timing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TimeConstrained",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SessionTime",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteTime",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1009", "AbsoluteTiming"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AbsoluteTiming"],

Cell["This operation takes very little cpu time. ", "ExampleText",
  CellTags->"AbsoluteTiming"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[Pause[1]; ]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AbsoluteTiming"],

Cell[BoxData[
    \({0.`\ Second, Null}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AbsoluteTiming"]
}, Open  ]],

Cell["\<\
However it does take about a second of wall\[Hyphen]clock time. \
\
\>", "ExampleText",
  CellTags->"AbsoluteTiming"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AbsoluteTiming[Pause[1]; ]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AbsoluteTiming"],

Cell[BoxData[
    \({1.008494`6.455218312232518\ Second, Null}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AbsoluteTiming"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AccountingForm", "ObjectName",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccountingForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " prints with all numbers in ",
  StyleBox["expr", "TI"],
  " given in standard accounting notation. \n\[FilledSmallSquare] ",
  StyleBox["AccountingForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " prints with numbers given to ",
  StyleBox["n", "TI"],
  "\[Hyphen]digit precision. "
}], "Usage",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccountingForm", "MR"],
  " never uses scientific notation. "
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccountingForm", "MR"],
  " uses parentheses to indicate negative numbers. "
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccountingForm", "MR"],
  " takes the same options as ",
  ButtonBox["NumberForm",
    ButtonStyle->"RefGuideLink"],
  ", but uses a different default function for ",
  ButtonBox["ExponentFunction",
    ButtonStyle->"RefGuideLink"],
  ", and a different default for ",
  ButtonBox["NumberSigns",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccountingForm", "MR"],
  " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.7",
    ButtonData:>{"2.9.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["PaddedForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NumberForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1010", "AccountingForm"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AccountingForm"],

Cell["\<\
This converts the numbers in the list to an accounting form. \
\>", \
"ExampleText",
  CellTags->"AccountingForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AccountingForm[{5.6, \(-6.700000000000001\), 5.556, 
        10. \^7}]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AccountingForm"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"5.6\"\>",
            5.5999999999999996,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"(6.7)\"\>",
            -6.7000000000000011,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"5.556\"\>",
            5.556,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"10000000.\"\>",
            10000000,
            AutoDelete->True]}], "}"}],
      AccountingForm]], "Output",
  CellLabel->"Out[1]//AccountingForm= ",
  CellTags->"AccountingForm"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Accuracy", "ObjectName",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the effective number of digits to the right of the decimal point in \
the number ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives a measure of the absolute uncertainty in the value of ",
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] With uncertainty ",
  StyleBox["dx", "TI"],
  ", ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is ",
  StyleBox["-Log[10,", "MR"],
  " ",
  StyleBox["dx", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] For exact numbers such as integers, ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is ",
  ButtonBox["Infinity",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " does not normally yield an integer result, and need not be positive. "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] For machine\[Hyphen]precision numbers, ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the same as ",
  StyleBox["$MachinePrecision", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["Log[10,", "MR"],
  " ",
  StyleBox["Abs[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Accuracy[0.]", "MR"],
  " is ",
  StyleBox["Log[10,", "MR"],
  " ",
  StyleBox["$MinMachineNumber]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] Numbers entered in the form ",
  StyleBox["digits", "TI"],
  StyleBox["``", "MR"],
  StyleBox["a", "TI"],
  " are taken to have accuracy ",
  StyleBox["a", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["x", "TI"],
  " is not a number, ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the minimum value of ",
  StyleBox["Accuracy", "MR"],
  " for all the numbers that appear in ",
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.1.4",
    ButtonData:>{"3.1.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Precision",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["N",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Chop",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SetAccuracy",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 5.\
\>", "Notes",
  CellTags->{"S0.1011", "Accuracy"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Accuracy"],

Cell["The accuracy of an exact number is infinite. ", "ExampleText",
  CellTags->"Accuracy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      Accuracy, {123, 
        123\/2, \@123, \[Pi], \[ExponentialE], \[ImaginaryI]}]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \({\[Infinity], \[Infinity], \[Infinity], \[Infinity], \[Infinity], \
\[Infinity]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell[TextData[{
  "The accuracy of a machine real number depends on the value of ",
  StyleBox["$MachinePrecision", "MR"],
  " on your computer. "
}], "ExampleText",
  CellTags->"Accuracy"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MachinePrecision\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \(15.954589770191003`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell["Here is a list of numbers. ", "ExampleText",
  CellTags->"Accuracy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(xx = {1.618034, 21.618034, 321.618034}\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \({1.618034`, 21.618034`, 321.618034`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell["\<\
The accuracy of a machine number is computed by subtracting off the \
decimal scale of the number. \
\>", "ExampleText",
  CellTags->"Accuracy"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MachinePrecision - Log[10. , Abs[xx]]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \({15.745602126921398`, 14.619773574642846`, 
      13.447249377356194`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Accuracy /@ xx\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \({15.745602126921398`, 14.619773574642847`, 
      13.447249377356195`}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell["\<\
The accuracy of arbitrary\[Hyphen]precision real numbers is machine\
\[Hyphen]independent. \
\>", "ExampleText",
  CellTags->"Accuracy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Accuracy /@ {1.12345678901234567890123456789, \ 
        21.12345678901234567890123456789, 
        321.12345678901234567890123456789}\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Accuracy"],

Cell[BoxData[
    \({29.`, 29.`, 29.000000000000004`}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"Accuracy"]
}, Open  ]],

Cell[BoxData[
    \(Clear[xx]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Accuracy"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AccuracyGoal", "ObjectName",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccuracyGoal", "MR"],
  " is an option for various numerical operations which specifies how many \
effective digits of accuracy should be sought in the final result. "
}], "Usage",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccuracyGoal", "MR"],
  " is an option for such functions as ",
  ButtonBox["NIntegrate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FindRoot",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccuracyGoal", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " normally yields an accuracy goal equal to half the setting for ",
  ButtonBox["WorkingPrecision",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccuracyGoal", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  " specifies that accuracy should not be used as the criterion for \
terminating the numerical procedure. ",
  ButtonBox["PrecisionGoal",
    ButtonStyle->"RefGuideLink"],
  " is typically used in this case. "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] Even though you may specify ",
  StyleBox["AccuracyGoal->", "MR"],
  StyleBox["n", "TI"],
  ", the results you get may sometimes have much less than ",
  StyleBox["n", "TI"],
  "\[Hyphen]digit accuracy. "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] In most cases, you must set ",
  ButtonBox["WorkingPrecision",
    ButtonStyle->"RefGuideLink"],
  " to be at least as large as ",
  StyleBox["AccuracyGoal", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AccuracyGoal", "MR"],
  " effectively specifies the absolute error allowed in a numerical \
procedure. "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["AccuracyGoal->", "MR"],
  StyleBox["a", "TI"],
  " and ",
  StyleBox["PrecisionGoal->", "MR"],
  StyleBox["p", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " attempts to make the numerical error in a result of size ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " be less than ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["10", 
            RowBox[{"-", 
              StyleBox["a",
                "TI"]}]], "+", "\[VerticalSeparator]", 
          StyleBox["x",
            "TI"], "\[VerticalSeparator]", 
          SuperscriptBox["10", 
            RowBox[{"-", 
              StyleBox["p",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.9.4",
    ButtonData:>{"3.9.4", "4.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.9.9",
    ButtonData:>{"3.9.9", "9.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["PrecisionGoal",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WorkingPrecision",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 5.\
\>", "Notes",
  CellTags->{"S0.1012", "AccuracyGoal"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Active", "ObjectName",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Active", "MR"],
  " is an option for ",
  ButtonBox["ButtonBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Notebook",
    ButtonStyle->"RefGuideLink"],
  " which specifies whether a button should be active. "
}], "Usage",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active->False", "MR"],
  " the contents of a button can be edited. "
}], "Notes",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active->True", "MR"],
  " a button will perform an action when it is clicked. "
}], "Notes",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] Active cells are indicated by an ",
  StyleBox["A", "MR"],
  " in their cell bracket. "
}], "Notes",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.10",
    ButtonData:>{"2.9.10", "10.27"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1013", "Active"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Evaluator",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1013", "Active"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1013", "Active"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AddTo", "ObjectName",
  CellTags->{"S0.1014", "AddTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+=", "MR"],
  " ",
  StyleBox["dx", "TI"],
  " adds ",
  StyleBox["dx", "TI"],
  " to ",
  StyleBox["x", "TI"],
  " and returns the new value of ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1014", "AddTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AddTo", "MR"],
  " has the attribute ",
  ButtonBox["HoldFirst",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "AddTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+=", "MR"],
  " ",
  StyleBox["dx", "TI"],
  " is equivalent to ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["dx", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "AddTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.5.4",
    ButtonData:>{"2.5.4", "4.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1014", "AddTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Increment",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PreIncrement",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Set",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PrependTo",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "AddTo"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1014", "AddTo"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AddTo"],

Cell[TextData[{
  "This initializes the variable ",
  StyleBox["i", "MR"],
  " to the value 7, adds to it, checks its value, and clears it at the end. "
}], "ExampleText",
  CellTags->"AddTo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i = 7\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AddTo"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AddTo"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(i += 5\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AddTo"],

Cell[BoxData[
    \(12\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AddTo"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(i\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AddTo"],

Cell[BoxData[
    \(12\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AddTo"]
}, Open  ]],

Cell["i =.", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AddTo"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AdjustmentBox", "ObjectName",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AdjustmentBox[", "MR"],
  StyleBox["box", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["opts", "TI"],
  StyleBox["]", "MR"],
  " displays with the placement of ",
  StyleBox["box", "TI"],
  " adjusted using the options given. "
}], "Usage",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] In the notebook front end, ",
  StyleBox["AdjustmentBox", "MR"],
  " objects can typically be inserted and modified using \[ControlKey]\
\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftArrow] \)], "InlineFormula"],
  "\[RightModified], \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  "\[RightModified], \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[UpArrow]\)], "InlineFormula"],
  "\[RightModified] and \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[DownArrow]\)], "InlineFormula"],
  "\[RightModified]. These keys move your current selection by one pixel at \
the current screen magnification. "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell["\<\
\[FilledSmallSquare] The following options can be given: \
\>", \
"Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BoxMargins", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{{", "MR"],
              StyleBox["left", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["right", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["bottom", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["top", "TI"],
              StyleBox["}}", "MR"],
              " "
            }]], Cell["margins to leave around the contents of the box "]},
          {Cell[TextData[{
              StyleBox["BoxBaselineShift", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["up", "TI"],
              " "
            }]], 
            Cell["\<\
how much the baseline should be shifted relative to \
those of neighboring boxes \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "3ColumnTable",
  CellTags->{"AdjustmentBox", "S0.1015"}],

Cell["\<\
\[FilledSmallSquare] Horizontal motion specifications are in ems; \
vertical ones in x\[Hyphen]heights. \
\>", "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell["\<\
\[FilledSmallSquare] Motion specifications can be either positive \
or negative numbers. \
\>", "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] Positive margin specifications increase the spacing \
around ",
  StyleBox["box", "TI"],
  "; negative ones decrease it. "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] Moving the baseline affects for example vertical \
alignment in a ",
  ButtonBox["RowBox",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] Top and bottom margins affect for example placement \
in a ",
  ButtonBox["FractionBox",
    ButtonStyle->"RefGuideLink"],
  " or an ",
  ButtonBox["OverscriptBox",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  " input, ",
  StyleBox["AdjustmentBox", "MR"],
  " is by default ignored, so that ",
  StyleBox["AdjustmentBox[", "MR"],
  StyleBox["box", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["opts", "TI"],
  StyleBox["]", "MR"],
  " is interpreted just as ",
  StyleBox["box", "TI"],
  " would be. "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] Inserting an explicit spacing character such as \
\[Backslash]",
  StyleBox["[ThinSpace]", "MR"],
  " can have the same effect for display as ",
  StyleBox["AdjustmentBox", "MR"],
  ", but the spacing character by default affects interpretation. "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AdjustmentBox[", "MR"],
  StyleBox["box", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["opts", "TI"],
  StyleBox["]", "MR"],
  " uses the options given only to adjust the position of ",
  StyleBox["box", "TI"],
  " itself. Unlike ",
  ButtonBox["StyleBox",
    ButtonStyle->"RefGuideLink"],
  ", it does not propagate the options to subboxes. "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.30"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["StyleBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GridBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptBaselineShifts",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1015", "AdjustmentBox"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AiryAi", "ObjectName",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryAi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ai", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ai", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is a solution to the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", 
          StyleBox["x",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Ai", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " tends to zero as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "\[RightArrow]", "\[Infinity]"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryAi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is an entire function of ",
  StyleBox["z", "TI"],
  " with no branch cut discontinuities. "
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AiryAiPrime",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryBi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryBiPrime",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1016", "AiryAi"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AiryAi"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"AiryAi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z AiryAi[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AiryAi"],

Cell[BoxData[
    \(AiryAiPrime[z]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AiryAi"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"AiryAi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]AiryAi[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AiryAi"],

Cell[BoxData[
    \(\(-\(\((z\ \((\(-3\)\ Gamma[1\/3]\ Gamma[
                    5\/3]\ HypergeometricPFQ[{1\/3}, {2\/3, 4\/3}, z\^3\/9] + 
                3\^\(1/3\)\ z\ Gamma[2\/3]\^2\ HypergeometricPFQ[{2\/3}, \
{4\/3, 5\/3}, z\^3\/9])\))\)/\((9\ 3\^\(2/3\)\ Gamma[2\/3]\ Gamma[
              4\/3]\ Gamma[5\/3])\)\)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AiryAi"]
}, Open  ]],

Cell["This verifies the defining differential equation. ", "ExampleText",
  CellTags->"AiryAi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_{z, 2}AiryAi[z]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AiryAi"],

Cell[BoxData[
    \(z\ AiryAi[z]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AiryAi"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AiryAi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[AiryAi[z], {z, 0, 5}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AiryAi"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/\(3\^\(2/3\)\ Gamma[2\/3]\)\), 
        "-", \(z\/\(3\^\(1/3\)\ Gamma[1\/3]\)\), 
        "+", \(z\^3\/\(6\ 3\^\(2/3\)\ Gamma[2\/3]\)\), 
        "-", \(z\^4\/\(12\ \((3\^\(1/3\)\ Gamma[1\/3])\)\)\), "+", 
        InterpretationBox[\(O[z]\^6\),
          SeriesData[ z, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ z, 0, {
        Times[ 
          Power[ 3, 
            Rational[ -2, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ -1, 
          Power[ 3, 
            Rational[ -1, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]], 0, 
        Times[ 
          Rational[ 1, 6], 
          Power[ 3, 
            Rational[ -2, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ 
          Rational[ -1, 12], 
          Power[ 3, 
            Rational[ -1, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"AiryAi"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AiryAiPrime", "ObjectName",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryAiPrime[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the derivative of the Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Ai\^\[Prime]\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  ButtonBox["AiryAi",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AiryBi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryBiPrime",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1017", "AiryAiPrime"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AiryAiPrime"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"AiryAiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z AiryAiPrime[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AiryAiPrime"],

Cell[BoxData[
    \(z\ AiryAi[z]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AiryAiPrime"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"AiryAiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]AiryAiPrime[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AiryAiPrime"],

Cell[BoxData[
    \(AiryAi[z]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AiryAiPrime"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`4\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AiryAiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[AiryAiPrime[z], {z, 0, 4}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AiryAiPrime"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(-\(1\/\(3\^\(1/3\)\ Gamma[1\/3]\)\)\), 
        "+", \(z\^2\/\(2\ 3\^\(2/3\)\ Gamma[2\/3]\)\), 
        "-", \(z\^3\/\(3\ \((3\^\(1/3\)\ Gamma[1\/3])\)\)\), "+", 
        InterpretationBox[\(O[z]\^5\),
          SeriesData[ z, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ z, 0, {
        Times[ -1, 
          Power[ 3, 
            Rational[ -1, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]], 0, 
        Times[ 
          Rational[ 1, 2], 
          Power[ 3, 
            Rational[ -2, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ 
          Rational[ -1, 3], 
          Power[ 3, 
            Rational[ -1, 3]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AiryAiPrime"]
}, Open  ]],

Cell[TextData[{
  "Here is an integral involving ",
  StyleBox["AiryAiPrime", "MR"],
  ". "
}], "ExampleText",
  CellTags->"AiryAiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1\( AiryAiPrime[x]\^2\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AiryAiPrime"],

Cell[BoxData[
    \(\(1\/\(9\ \[Pi]\)\) \((\@3 - 3\ \[Pi]\ AiryAi[1]\^2 + 
          6\ \[Pi]\ AiryAi[1]\ AiryAiPrime[1] + 
          3\ \[Pi]\ AiryAiPrime[1]\^2)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"AiryAiPrime"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AiryBi", "ObjectName",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryBi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Bi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Bi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " is a solution to the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "-", 
          StyleBox["x",
            "TI"], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Bi", 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " increases exponentially as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            "TI"], "\[RightArrow]", "\[Infinity]"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryBi[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is an entire function of ",
  StyleBox["z", "TI"],
  " with no branch cut discontinuities. "
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AiryAi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryBiPrime",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1018", "AiryBi"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AiryBi"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"AiryBi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z AiryBi[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AiryBi"],

Cell[BoxData[
    \(AiryBiPrime[z]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AiryBi"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"AiryBi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]AiryBi[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AiryBi"],

Cell[BoxData[
    \(\((z\ \((3\^\(2/3\)\ Gamma[1\/3]\ Gamma[
                  5\/3]\ HypergeometricPFQ[{1\/3}, {2\/3, 4\/3}, z\^3\/9] + 
              z\ Gamma[2\/3]\^2\ HypergeometricPFQ[{2\/3}, {4\/3, 5\/3}, 
                  z\^3\/9])\))\)/\((3\ 3\^\(5/6\)\ Gamma[2\/3]\ Gamma[
            4\/3]\ Gamma[5\/3])\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AiryBi"]
}, Open  ]],

Cell["This verifies the defining differential equation. ", "ExampleText",
  CellTags->"AiryBi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_{z, 2}AiryBi[z]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AiryBi"],

Cell[BoxData[
    \(z\ AiryBi[z]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AiryBi"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AiryBi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[AiryBi[z], {z, 0, 5}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AiryBi"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/\(3\^\(1/6\)\ Gamma[2\/3]\)\), 
        "+", \(\(3\^\(1/6\)\ z\)\/Gamma[1\/3]\), 
        "+", \(z\^3\/\(6\ 3\^\(1/6\)\ Gamma[2\/3]\)\), 
        "+", \(z\^4\/\(4\ 3\^\(5/6\)\ Gamma[1\/3]\)\), "+", 
        InterpretationBox[\(O[z]\^6\),
          SeriesData[ z, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ z, 0, {
        Times[ 
          Power[ 3, 
            Rational[ -1, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ 
          Power[ 3, 
            Rational[ 1, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]], 0, 
        Times[ 
          Rational[ 1, 6], 
          Power[ 3, 
            Rational[ -1, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ 
          Rational[ 1, 4], 
          Power[ 3, 
            Rational[ -5, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"AiryBi"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AiryBiPrime", "ObjectName",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AiryBiPrime[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the derivative of the Airy function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Bi\^\[Prime]\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  ButtonBox["AiryBi",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AiryAi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryAiPrime",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1019", "AiryBiPrime"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AiryBiPrime"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"AiryBiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z AiryBiPrime[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AiryBiPrime"],

Cell[BoxData[
    \(z\ AiryBi[z]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AiryBiPrime"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"AiryBiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]AiryBiPrime[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AiryBiPrime"],

Cell[BoxData[
    \(AiryBi[z]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AiryBiPrime"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`4\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AiryBiPrime"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[AiryBiPrime[z], {z, 0, 4}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AiryBiPrime"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(3\^\(1/6\)\/Gamma[1\/3]\), 
        "+", \(z\^2\/\(2\ 3\^\(1/6\)\ Gamma[2\/3]\)\), 
        "+", \(z\^3\/\(3\^\(5/6\)\ Gamma[1\/3]\)\), "+", 
        InterpretationBox[\(O[z]\^5\),
          SeriesData[ z, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ z, 0, {
        Times[ 
          Power[ 3, 
            Rational[ 1, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]], 0, 
        Times[ 
          Rational[ 1, 2], 
          Power[ 3, 
            Rational[ -1, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 2, 3]], -1]], 
        Times[ 
          Power[ 3, 
            Rational[ -5, 6]], 
          Power[ 
            Gamma[ 
              Rational[ 1, 3]], -1]]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AiryBiPrime"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraics", "ObjectName",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Algebraics", "MR"],
  " represents the domain of algebraic numbers, as in ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Algebraics", "MR"],
  ". "
}], "Usage",
  CellTags->{"S0.1020", "Algebraics"}],

Cell["\<\
\[FilledSmallSquare] Algebraic numbers are defined to be numbers \
that solve polynomial equations with rational coefficients. \
\>", "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Algebraics", "MR"],
  " evaluates immediately only for quantities ",
  StyleBox["x", "TI"],
  " that are explicitly constructed from rational numbers, radicals and ",
  ButtonBox["Root",
    ButtonStyle->"RefGuideLink"],
  " objects, or are known to be transcendental. "
}], "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Simplify[", "MR"],
  StyleBox["expr", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Algebraics]", "MR"],
  " can be used to try to determine whether an expression corresponds to an \
algebraic number. "
}], "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Algebraics", "MR"],
  " is output in ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalA]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.3.11",
    ButtonData:>{"3.3.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Element",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Integers",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Root",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Extension",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Reals",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1020", "Algebraics"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Algebraics"],

Cell["Here is an algebraic number. ", "ExampleText",
  CellTags->"Algebraics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((6 + \@5\ \[ImaginaryI])\)\^\(1/3\) \[Element] Algebraics\)], "Input",\

  CellLabel->"In[1]:= ",
  CellTags->"Algebraics"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Algebraics"]
}, Open  ]],

Cell["\<\
Under the given conditions, this expression is also an algebraic \
number. \
\>", "ExampleText",
  CellTags->"Algebraics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\@b + b\^\(-n\) \[Element] Algebraics, 
      b \[Element] Algebraics && b \[NotEqual] 0 && 
        n \[Element] Integers]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Algebraics"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Algebraics"]
}, Open  ]],

Cell["Here is a number that is not algebraic. ", "ExampleText",
  CellTags->"Algebraics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\^\(\@2\) \[Element] Algebraics\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Algebraics"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Algebraics"]
}, Open  ]],

Cell[TextData[{
  "Current mathematics has not established whether ",
  StyleBox["EulerGamma", "MR"],
  " is an algebraic number or not. "
}], "ExampleText",
  CellTags->"Algebraics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EulerGamma \[Element] Algebraics\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Algebraics"],

Cell[BoxData[
    \(EulerGamma \[Element] Algebraics\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Algebraics"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["All", "ObjectName",
  CellTags->{"S0.1021", "All"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["All", "MR"],
  " is a setting used for certain options. \n\[FilledSmallSquare] In ",
  ButtonBox["Part",
    ButtonStyle->"RefGuideLink"],
  " and related functions, ",
  StyleBox["All", "MR"],
  " specifies all parts at a particular level. "
}], "Usage",
  CellTags->{"S0.1021", "All"}],

Cell[TextData[{
  "\[FilledSmallSquare] For example, ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  " specifies that all points are to be included in a plot. "
}], "Notes",
  CellTags->{"S0.1021", "All"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.8.6",
    ButtonData:>{"1.8.6", "6.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1021", "All"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Automatic",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["None",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Full",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Part",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1021", "All"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 4.\
\>", "Notes",
  CellTags->{"S0.1021", "All"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"All"],

Cell["\<\
The range of the plot is restricted to its most interesting part. \
\
\>", "ExampleText",
  CellTags->"All"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x\^5 - 4  x\^4 + 2  x\^2 - 7, {x, \(-10\), 15}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"All"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.0380952 0.330315 0.00113307 [
[.02381 .31782 -9 -9 ]
[.02381 .31782 9 0 ]
[.21429 .31782 -6 -9 ]
[.21429 .31782 6 0 ]
[.59524 .31782 -3 -9 ]
[.59524 .31782 3 0 ]
[.78571 .31782 -6 -9 ]
[.78571 .31782 6 0 ]
[.97619 .31782 -6 -9 ]
[.97619 .31782 6 0 ]
[.39226 .1037 -24 -4.5 ]
[.39226 .1037 0 4.5 ]
[.39226 .21701 -24 -4.5 ]
[.39226 .21701 0 4.5 ]
[.39226 .44362 -18 -4.5 ]
[.39226 .44362 0 4.5 ]
[.39226 .55693 -18 -4.5 ]
[.39226 .55693 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .33032 m
.02381 .33657 L
s
[(-10)] .02381 .31782 0 1 Mshowa
.21429 .33032 m
.21429 .33657 L
s
[(-5)] .21429 .31782 0 1 Mshowa
.59524 .33032 m
.59524 .33657 L
s
[(5)] .59524 .31782 0 1 Mshowa
.78571 .33032 m
.78571 .33657 L
s
[(10)] .78571 .31782 0 1 Mshowa
.97619 .33032 m
.97619 .33657 L
s
[(15)] .97619 .31782 0 1 Mshowa
.125 Mabswid
.0619 .33032 m
.0619 .33407 L
s
.1 .33032 m
.1 .33407 L
s
.1381 .33032 m
.1381 .33407 L
s
.17619 .33032 m
.17619 .33407 L
s
.25238 .33032 m
.25238 .33407 L
s
.29048 .33032 m
.29048 .33407 L
s
.32857 .33032 m
.32857 .33407 L
s
.36667 .33032 m
.36667 .33407 L
s
.44286 .33032 m
.44286 .33407 L
s
.48095 .33032 m
.48095 .33407 L
s
.51905 .33032 m
.51905 .33407 L
s
.55714 .33032 m
.55714 .33407 L
s
.63333 .33032 m
.63333 .33407 L
s
.67143 .33032 m
.67143 .33407 L
s
.70952 .33032 m
.70952 .33407 L
s
.74762 .33032 m
.74762 .33407 L
s
.82381 .33032 m
.82381 .33407 L
s
.8619 .33032 m
.8619 .33407 L
s
.9 .33032 m
.9 .33407 L
s
.9381 .33032 m
.9381 .33407 L
s
.25 Mabswid
0 .33032 m
1 .33032 L
s
.40476 .1037 m
.41101 .1037 L
s
[(-200)] .39226 .1037 1 0 Mshowa
.40476 .21701 m
.41101 .21701 L
s
[(-100)] .39226 .21701 1 0 Mshowa
.40476 .44362 m
.41101 .44362 L
s
[(100)] .39226 .44362 1 0 Mshowa
.40476 .55693 m
.41101 .55693 L
s
[(200)] .39226 .55693 1 0 Mshowa
.125 Mabswid
.40476 .12636 m
.40851 .12636 L
s
.40476 .14902 m
.40851 .14902 L
s
.40476 .17169 m
.40851 .17169 L
s
.40476 .19435 m
.40851 .19435 L
s
.40476 .23967 m
.40851 .23967 L
s
.40476 .26233 m
.40851 .26233 L
s
.40476 .28499 m
.40851 .28499 L
s
.40476 .30765 m
.40851 .30765 L
s
.40476 .35298 m
.40851 .35298 L
s
.40476 .37564 m
.40851 .37564 L
s
.40476 .3983 m
.40851 .3983 L
s
.40476 .42096 m
.40851 .42096 L
s
.40476 .46628 m
.40851 .46628 L
s
.40476 .48895 m
.40851 .48895 L
s
.40476 .51161 m
.40851 .51161 L
s
.40476 .53427 m
.40851 .53427 L
s
.40476 .08104 m
.40851 .08104 L
s
.40476 .05838 m
.40851 .05838 L
s
.40476 .03572 m
.40851 .03572 L
s
.40476 .01306 m
.40851 .01306 L
s
.40476 .57959 m
.40851 .57959 L
s
.40476 .60225 m
.40851 .60225 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.30602 0 m
.31119 .06972 L
.31603 .12356 L
.32114 .17034 L
.32576 .20485 L
.33083 .23544 L
.3351 .25613 L
.33975 .27413 L
.34499 .28972 L
.34995 .30067 L
.35479 .30846 L
.35926 .31364 L
.36174 .31582 L
.36408 .3175 L
.36685 .31908 L
.3694 .32019 L
.37192 .32103 L
.37458 .32167 L
.37597 .32192 L
.37725 .32211 L
.37866 .32228 L
.38017 .32241 L
.3814 .3225 L
.38276 .32256 L
.38344 .32259 L
.38418 .32261 L
.38487 .32262 L
.3855 .32263 L
.38671 .32264 L
.38802 .32263 L
.38926 .32262 L
.39041 .32261 L
.39624 .32248 L
.39878 .32244 L
.40011 .32242 L
.40084 .32241 L
.40152 .3224 L
.40277 .32239 L
.40343 .32239 L
.40414 .32238 L
.4054 .32238 L
.40655 .32239 L
.40771 .3224 L
.40898 .32241 L
.41017 .32243 L
.41128 .32245 L
.41628 .32256 L
.41891 .32262 L
.42034 .32265 L
.42167 .32267 L
Mistroke
.42284 .32269 L
.42408 .3227 L
.42479 .32271 L
.42546 .32271 L
.42671 .32271 L
.42786 .3227 L
.42892 .32268 L
.43009 .32265 L
.43132 .3226 L
.4324 .32255 L
.43355 .32248 L
.43563 .32231 L
.43811 .32204 L
.44037 .32171 L
.443 .32122 L
.44544 .32065 L
.45096 .31889 L
.45582 .31673 L
.46099 .31375 L
.47034 .30643 L
.48044 .2958 L
.49871 .27188 L
.50372 .26533 L
.50907 .259 L
.51167 .25634 L
.51413 .25416 L
.51636 .2525 L
.51872 .25115 L
.51992 .25065 L
.52123 .25024 L
.52243 .25003 L
.52355 .24996 L
.52487 .25006 L
.52608 .25034 L
.52674 .25057 L
.52747 .25089 L
.52879 .25166 L
.53024 .25279 L
.53156 .2541 L
.53451 .25809 L
.53724 .26322 L
.53981 .26946 L
.54447 .2847 L
.54959 .3082 L
.55493 .34168 L
.55991 .38259 L
.56883 .48398 L
.57383 .55953 L
Mfstroke
.57383 .55953 m
.57706 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"All"]
}, Open  ]],

Cell[TextData[{
  "Setting the ",
  StyleBox["PlotRange", "MR"],
  " to ",
  StyleBox["All", "MR"],
  " option shows the plot over the whole of the specified range. "
}], "ExampleText",
  CellTags->"All"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x\^5 - 4  x\^4 + 2  x\^2 - 7, {x, \(-10\), 15}, 
      PlotRange \[Rule] All]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"All"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.0380952 0.132758 8.44331e-07 [
[.02381 .12026 -9 -9 ]
[.02381 .12026 9 0 ]
[.21429 .12026 -6 -9 ]
[.21429 .12026 6 0 ]
[.59524 .12026 -3 -9 ]
[.59524 .12026 3 0 ]
[.78571 .12026 -6 -9 ]
[.78571 .12026 6 0 ]
[.97619 .12026 -6 -9 ]
[.97619 .12026 6 0 ]
[.39226 .04833 -42 -4.5 ]
[.39226 .04833 0 4.5 ]
[.39226 .21719 -36 -4.5 ]
[.39226 .21719 0 4.5 ]
[.39226 .30162 -36 -4.5 ]
[.39226 .30162 0 4.5 ]
[.39226 .38606 -36 -4.5 ]
[.39226 .38606 0 4.5 ]
[.39226 .47049 -36 -4.5 ]
[.39226 .47049 0 4.5 ]
[.39226 .55492 -36 -4.5 ]
[.39226 .55492 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .13276 m
.02381 .13901 L
s
[(-10)] .02381 .12026 0 1 Mshowa
.21429 .13276 m
.21429 .13901 L
s
[(-5)] .21429 .12026 0 1 Mshowa
.59524 .13276 m
.59524 .13901 L
s
[(5)] .59524 .12026 0 1 Mshowa
.78571 .13276 m
.78571 .13901 L
s
[(10)] .78571 .12026 0 1 Mshowa
.97619 .13276 m
.97619 .13901 L
s
[(15)] .97619 .12026 0 1 Mshowa
.125 Mabswid
.0619 .13276 m
.0619 .13651 L
s
.1 .13276 m
.1 .13651 L
s
.1381 .13276 m
.1381 .13651 L
s
.17619 .13276 m
.17619 .13651 L
s
.25238 .13276 m
.25238 .13651 L
s
.29048 .13276 m
.29048 .13651 L
s
.32857 .13276 m
.32857 .13651 L
s
.36667 .13276 m
.36667 .13651 L
s
.44286 .13276 m
.44286 .13651 L
s
.48095 .13276 m
.48095 .13651 L
s
.51905 .13276 m
.51905 .13651 L
s
.55714 .13276 m
.55714 .13651 L
s
.63333 .13276 m
.63333 .13651 L
s
.67143 .13276 m
.67143 .13651 L
s
.70952 .13276 m
.70952 .13651 L
s
.74762 .13276 m
.74762 .13651 L
s
.82381 .13276 m
.82381 .13651 L
s
.8619 .13276 m
.8619 .13651 L
s
.9 .13276 m
.9 .13651 L
s
.9381 .13276 m
.9381 .13651 L
s
.25 Mabswid
0 .13276 m
1 .13276 L
s
.40476 .04833 m
.41101 .04833 L
s
[(-100000)] .39226 .04833 1 0 Mshowa
.40476 .21719 m
.41101 .21719 L
s
[(100000)] .39226 .21719 1 0 Mshowa
.40476 .30162 m
.41101 .30162 L
s
[(200000)] .39226 .30162 1 0 Mshowa
.40476 .38606 m
.41101 .38606 L
s
[(300000)] .39226 .38606 1 0 Mshowa
.40476 .47049 m
.41101 .47049 L
s
[(400000)] .39226 .47049 1 0 Mshowa
.40476 .55492 m
.41101 .55492 L
s
[(500000)] .39226 .55492 1 0 Mshowa
.125 Mabswid
.40476 .06521 m
.40851 .06521 L
s
.40476 .0821 m
.40851 .0821 L
s
.40476 .09899 m
.40851 .09899 L
s
.40476 .11587 m
.40851 .11587 L
s
.40476 .14964 m
.40851 .14964 L
s
.40476 .16653 m
.40851 .16653 L
s
.40476 .18342 m
.40851 .18342 L
s
.40476 .2003 m
.40851 .2003 L
s
.40476 .23408 m
.40851 .23408 L
s
.40476 .25096 m
.40851 .25096 L
s
.40476 .26785 m
.40851 .26785 L
s
.40476 .28474 m
.40851 .28474 L
s
.40476 .31851 m
.40851 .31851 L
s
.40476 .3354 m
.40851 .3354 L
s
.40476 .35228 m
.40851 .35228 L
s
.40476 .36917 m
.40851 .36917 L
s
.40476 .40294 m
.40851 .40294 L
s
.40476 .41983 m
.40851 .41983 L
s
.40476 .43672 m
.40851 .43672 L
s
.40476 .4536 m
.40851 .4536 L
s
.40476 .48738 m
.40851 .48738 L
s
.40476 .50426 m
.40851 .50426 L
s
.40476 .52115 m
.40851 .52115 L
s
.40476 .53804 m
.40851 .53804 L
s
.40476 .03144 m
.40851 .03144 L
s
.40476 .01455 m
.40851 .01455 L
s
.40476 .57181 m
.40851 .57181 L
s
.40476 .5887 m
.40851 .5887 L
s
.40476 .60558 m
.40851 .60558 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
.5 Mabswid
.02381 .01472 m
.04262 .03977 L
.06244 .0614 L
.08426 .08036 L
.10458 .09419 L
.12297 .10403 L
.14264 .11224 L
.16394 .1189 L
.18408 .1235 L
.20406 .12677 L
.2225 .1289 L
.23216 .12975 L
.24122 .13041 L
.25179 .13102 L
.26185 .13148 L
.27153 .13183 L
.28209 .13211 L
.2917 .13231 L
.30062 .13245 L
.30569 .13251 L
.31119 .13256 L
.31603 .1326 L
.32114 .13264 L
.32576 .13266 L
.33083 .13269 L
.3351 .1327 L
.33975 .13272 L
.34499 .13273 L
.34995 .13274 L
.35479 .13274 L
.35926 .13275 L
.36174 .13275 L
.36408 .13275 L
.36685 .13275 L
.3694 .13275 L
.37192 .13275 L
.37458 .13275 L
.37597 .13275 L
.37725 .13275 L
.37866 .13275 L
.38017 .13275 L
.3814 .13275 L
.38276 .13275 L
.38344 .13275 L
.38418 .13275 L
.38487 .13275 L
.3855 .13275 L
.38671 .13275 L
.38802 .13275 L
.38926 .13275 L
Mistroke
.39041 .13275 L
.39624 .13275 L
.39878 .13275 L
.40011 .13275 L
.40084 .13275 L
.40152 .13275 L
.40277 .13275 L
.40343 .13275 L
.40414 .13275 L
.4054 .13275 L
.40655 .13275 L
.40771 .13275 L
.40898 .13275 L
.41017 .13275 L
.41128 .13275 L
.41628 .13275 L
.41891 .13275 L
.42034 .13275 L
.42167 .13275 L
.42284 .13275 L
.42408 .13275 L
.42479 .13275 L
.42546 .13275 L
.42671 .13275 L
.42786 .13275 L
.42892 .13275 L
.43009 .13275 L
.43132 .13275 L
.4324 .13275 L
.43355 .13275 L
.43563 .13275 L
.43811 .13275 L
.44037 .13275 L
.443 .13275 L
.44544 .13275 L
.45096 .13275 L
.45582 .13275 L
.46099 .13275 L
.47034 .13274 L
.48044 .13273 L
.49871 .13271 L
.50372 .13271 L
.50907 .13271 L
.51167 .1327 L
.51413 .1327 L
.51636 .1327 L
.51872 .1327 L
.51992 .1327 L
.52123 .1327 L
.52243 .1327 L
Mistroke
.52355 .1327 L
.52487 .1327 L
.52608 .1327 L
.52674 .1327 L
.52747 .1327 L
.52879 .1327 L
.53024 .1327 L
.53156 .1327 L
.53451 .1327 L
.53724 .13271 L
.53981 .13271 L
.54447 .13272 L
.54959 .13274 L
.55493 .13277 L
.55991 .1328 L
.56883 .13287 L
.57383 .13293 L
.57839 .13299 L
.58831 .13316 L
.59748 .13338 L
.60756 .1337 L
.61825 .13414 L
.62763 .13464 L
.63774 .13531 L
.65602 .13697 L
.6656 .13812 L
.67608 .13962 L
.69718 .14363 L
.71681 .1488 L
.73776 .15625 L
.75912 .16641 L
.77928 .17891 L
.81777 .21275 L
.83766 .23664 L
.8587 .26775 L
.89661 .3421 L
.93697 .45377 L
.97582 .60167 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"All"]
}, Open  ]],

Cell[TextData[{
  "Here is an ",
  Cell[BoxData[
      \(TraditionalForm\`8\[Cross]9\)], "InlineFormula"],
  " matrix. "
}], "ExampleText",
  CellTags->"All"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\[ScriptM] = Table[j + 10  i, {i, 8}, {j, 9}])\) // 
      MatrixForm\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"All"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"11", "12", "13", "14", "15", "16", "17", "18", "19"},
            {"21", "22", "23", "24", "25", "26", "27", "28", "29"},
            {"31", "32", "33", "34", "35", "36", "37", "38", "39"},
            {"41", "42", "43", "44", "45", "46", "47", "48", "49"},
            {"51", "52", "53", "54", "55", "56", "57", "58", "59"},
            {"61", "62", "63", "64", "65", "66", "67", "68", "69"},
            {"71", "72", "73", "74", "75", "76", "77", "78", "79"},
            {"81", "82", "83", "84", "85", "86", "87", "88", "89"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm= ",
  CellTags->"All"]
}, Open  ]],

Cell[TextData[{
  "This gives the third column of ",
  Cell[BoxData[
      \(\[ScriptM]\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"All"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[ScriptM][\([\)\(All, 3\)\(]\)] // MatrixForm\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"All"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", 
        TagBox[GridBox[{
              {"13"},
              {"23"},
              {"33"},
              {"43"},
              {"53"},
              {"63"},
              {"73"},
              {"83"}
              },
            RowSpacings->1,
            ColumnAlignments->{Left}],
          Column], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm= ",
  CellTags->"All"]
}, Open  ]],

Cell[TextData[{
  "This extracts a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]5\)], "InlineFormula"],
  " submatrix from ",
  Cell[BoxData[
      \(\[ScriptM]\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"All"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[ScriptM][\([\)\(Range[3]\)\(]\)]\)[\([\)\(All, Range[5]\)\(]\)] // 
      MatrixForm\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"All"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"11", "12", "13", "14", "15"},
            {"21", "22", "23", "24", "25"},
            {"31", "32", "33", "34", "35"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//MatrixForm= ",
  CellTags->"All"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alternatives", "ObjectName",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["|", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["|", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  " is a pattern object which represents any of the patterns ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[TextData[{
  "\[FilledSmallSquare] Example: ",
  StyleBox["_Integer", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["_Real", "MR"],
  " represents an object with head either ",
  ButtonBox["Integer",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["Real",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[TextData[{
  "\[FilledSmallSquare] Unless the same set of pattern names appears in all \
of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["p",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", you cannot use these pattern names on the right\[Hyphen]hand side of \
transformation rules for the pattern. Thus, for example, you can use ",
  StyleBox["x", "MR"],
  " in ",
  StyleBox["a[x_]", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["b[x_]", "MR"],
  ", but you can use neither ",
  StyleBox["x", "MR"],
  " nor ",
  StyleBox["y", "MR"],
  " in ",
  StyleBox["a[x_]", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["b[y_]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.6",
    ButtonData:>{"2.3.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Optional",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Except",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1022", "Alternatives"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1022", "Alternatives"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Alternatives"],

Cell[TextData[{
  "The rule replaces either ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  " and nothing else. "
}], "ExampleText",
  CellTags->"Alternatives"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, 0, 1} /. a | b \[Rule] t\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Alternatives"],

Cell[BoxData[
    \({t, 0, 1}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Alternatives"]
}, Open  ]],

Cell[TextData[{
  "The defined function ",
  StyleBox["ff", "MR"],
  " takes the logarithm of expressions whose heads are ",
  StyleBox["Integer", "MR"],
  ", ",
  StyleBox["Rational", "MR"],
  " or ",
  StyleBox["Plus", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Alternatives"],

Cell[BoxData[
    \(ff[x : \((_Integer | _Rational | _Plus)\)] := Log[x]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Alternatives"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ff /@ {2, 3\/4, aa + bb, \[Pi], 7 + \[ImaginaryI]}\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Alternatives"],

Cell[BoxData[
    \({Log[2], \(-Log[4\/3]\), Log[aa + bb], ff[\[Pi]], 
      ff[7 + \[ImaginaryI]]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Alternatives"]
}, Open  ]],

Cell[BoxData[
    \(Clear[ff]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Alternatives"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AmbientLight", "ObjectName",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AmbientLight", "MR"],
  " is an option for ",
  ButtonBox["Graphics3D",
    ButtonStyle->"RefGuideLink"],
  " and related functions that gives the level of simulated ambient \
illumination in a three\[Hyphen]dimensional picture. "
}], "Usage",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting for ",
  StyleBox["AmbientLight", "MR"],
  " must be a ",
  ButtonBox["GrayLevel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Hue",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["RGBColor",
    ButtonStyle->"RefGuideLink"],
  " directive. "
}], "Notes",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.12",
    ButtonData:>{"2.10.12", "12.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LightSources",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SurfaceColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1023", "AmbientLight"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AmbientLight"],

Cell[TextData[{
  "The first plot uses GrayLevel[0], the default setting for ",
  StyleBox["AmbientLight", "MR"],
  "; the second plot uses Hue[1]. "
}], "ExampleText",
  CellTags->"AmbientLight"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Sin[x\ y], {x, 0, \(3  Pi\)\/2}, {y, 0, \(3  Pi\)\/2}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AmbientLight"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.49366e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.15339 .19666 -5.94672 -9 ]
[.15339 .19666 .05328 0 ]
[.2857 .14461 -5.68126 -9 ]
[.2857 .14461 .31874 0 ]
[.42503 .08982 -5.4158 -9 ]
[.42503 .08982 .5842 0 ]
[.57193 .03208 -5.15034 -9 ]
[.57193 .03208 .84966 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.77131 .10294 0 -6.15612 ]
[.77131 .10294 6 2.84388 ]
[.83516 .20071 0 -6.0622 ]
[.83516 .20071 6 2.9378 ]
[.89336 .28984 0 -5.97836 ]
[.89336 .28984 6 3.02164 ]
[.94663 .37142 0 -5.90306 ]
[.94663 .37142 6 3.09694 ]
[.02411 .2651 -12 -2.74231 ]
[.02411 .2651 0 6.25769 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48796 -6 -2.93176 ]
[-0.01144 .48796 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.759 .10747 m
.75284 .10974 L
s
[(1)] .77131 .10294 -1 .36803 Mshowa
.82276 .20501 m
.81656 .20717 L
s
[(2)] .83516 .20071 -1 .34716 Mshowa
.88089 .29393 m
.87466 .29598 L
s
[(3)] .89336 .28984 -1 .32852 Mshowa
.93411 .37533 m
.92784 .37728 L
s
[(4)] .94663 .37142 -1 .31179 Mshowa
.125 Mabswid
.70336 .02236 m
.69968 .02378 L
s
.71768 .04428 m
.714 .04568 L
s
.73173 .06576 m
.72804 .06715 L
s
.7455 .08682 m
.74181 .0882 L
s
.77224 .12773 m
.76854 .12908 L
s
.78523 .1476 m
.78153 .14893 L
s
.79798 .1671 m
.79427 .16842 L
s
.81049 .18623 m
.80677 .18754 L
s
.83481 .22345 m
.83109 .22473 L
s
.84665 .24155 m
.84292 .24282 L
s
.85827 .25933 m
.85454 .26058 L
s
.86968 .27678 m
.86595 .27803 L
s
.89191 .31078 m
.88817 .312 L
s
.90273 .32734 m
.89899 .32855 L
s
.91337 .34361 m
.90962 .34481 L
s
.92383 .35961 m
.92007 .36079 L
s
.94421 .39079 m
.94045 .39195 L
s
.95415 .40599 m
.95039 .40714 L
s
.96393 .42094 m
.96016 .42208 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25794 L
s
[(-1)] .02411 .2651 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48364 m
.00714 .48148 L
s
[(1)] -0.01144 .48796 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .28129 m
.03669 .27987 L
s
.03134 .29188 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40055 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43643 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .47171 m
.00655 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.935 .58 .321 r
.38853 .69037 .40169 .70185 .4213 .77838 .40801 .76464 Metetra
0 .265 .755 r
.40801 .76464 .4213 .77838 .44359 .78967 .43022 .78043 Metetra
.91 .761 .683 r
.43022 .78043 .44359 .78967 .4676 .71984 .45443 .71926 Metetra
.953 .775 .624 r
.45443 .71926 .4676 .71984 .49125 .62349 .47858 .62499 Metetra
.961 .829 .667 r
.47858 .62499 .49125 .62349 .51378 .57147 .50155 .56248 Metetra
.111 .541 .915 r
.50155 .56248 .51378 .57147 .53615 .59682 .52395 .56943 Metetra
.832 .466 0 r
.52395 .56943 .53615 .59682 .55967 .67724 .5471 .63738 Metetra
0 0 .213 r
.5471 .63738 .55967 .67724 .58435 .74586 .57159 .71503 Metetra
.222 .33 .763 r
.57159 .71503 .58435 .74586 .60848 .73841 .59634 .73764 Metetra
.964 .851 .682 r
.59634 .73764 .60848 .73841 .6305 .65527 .61955 .6808 Metetra
.968 .855 .45 r
.61955 .6808 .6305 .65527 .65127 .56135 .64095 .58487 Metetra
.871 .853 .396 r
.64095 .58487 .65127 .56135 .67351 .52377 .66241 .51623 Metetra
.395 .737 .992 r
.66241 .51623 .67351 .52377 .69957 .56463 .68653 .51656 Metetra
0 0 .547 r
.68653 .51656 .69957 .56463 .72914 .65005 .71456 .58147 Metetra
0 .048 .561 r
.71456 .58147 .72914 .65005 .75841 .70735 .74486 .66201 Metetra
.319 .328 .713 r
.74486 .66201 .75841 .70735 .78268 .68051 .77309 .69145 Metetra
.909 .924 .541 r
.77309 .69145 .78268 .68051 .80145 .58681 .79573 .63943 Metetra
0 0 .101 r
.79573 .63943 .80145 .58681 .81963 .49861 .81404 .5423 Metetra
0 0 .128 r
.81404 .5423 .81963 .49861 .8432 .4769 .8333 .46765 Metetra
.626 .812 .972 r
.8333 .46765 .8432 .4769 .8748 .53214 .85865 .4611 Metetra
.242 .223 .637 r
.85865 .4611 .8748 .53214 .91119 .61927 .89169 .52242 Metetra
.253 .209 .613 r
.89169 .52242 .91119 .61927 .94401 .66208 .92863 .60533 Metetra
.356 .329 .691 r
.92863 .60533 .94401 .66208 .96648 .61601 .96141 .64155 Metetra
0 0 .053 r
.96141 .64155 .96648 .61601 .98107 .51498 .98404 .59481 Metetra
.934 .574 .312 r
.37517 .67871 .38853 .69037 .40801 .76464 .39453 .75059 Metetra
0 .102 .611 r
.39453 .75059 .40801 .76464 .43022 .78043 .41664 .77041 Metetra
.9 .765 .704 r
.41664 .77041 .43022 .78043 .45443 .71926 .44099 .718 Metetra
.951 .776 .63 r
.44099 .718 .45443 .71926 .47858 .62499 .46559 .62748 Metetra
.966 .821 .65 r
.46559 .62748 .47858 .62499 .50155 .56248 .48907 .55682 Metetra
.718 .878 .956 r
.48907 .55682 .50155 .56248 .52395 .56943 .51165 .54614 Metetra
.762 .369 0 r
.51165 .54614 .52395 .56943 .5471 .63738 .53455 .59809 Metetra
.708 .403 0 r
.53455 .59809 .5471 .63738 .57159 .71503 .5587 .67672 Metetra
0 .013 .578 r
.5587 .67672 .57159 .71503 .59634 .73764 .5837 .72375 Metetra
.822 .77 .804 r
.5837 .72375 .59634 .73764 .61955 .6808 .60798 .69879 Metetra
.986 .876 .523 r
.60798 .69879 .61955 .6808 .64095 .58487 .63042 .6153 Metetra
.882 .826 .354 r
.63042 .6153 .64095 .58487 .66241 .51623 .65184 .52822 Metetra
.82 .932 .558 r
.65184 .52822 .66241 .51623 .68653 .51656 .6745 .48954 Metetra
.034 .227 .73 r
.6745 .48954 .68653 .51656 .71456 .58147 .70046 .51834 Metetra
0 .039 .561 r
.70046 .51834 .71456 .58147 .74486 .66201 .72994 .59342 Metetra
.114 .136 .605 r
.72994 .59342 .74486 .66201 .77309 .69145 .76039 .66122 Metetra
.507 .514 .799 r
.76039 .66122 .77309 .69145 .79573 .63943 .78758 .66721 Metetra
.78758 .66721 .79573 .63943 .81404 .5423 .8092 .60086 Metetra
0 0 .184 r
.8092 .60086 .81404 .5423 .8333 .46765 .82755 .50588 Metetra
0 0 .113 r
.82755 .50588 .8333 .46765 .85865 .4611 .84777 .44158 Metetra
.535 .611 .876 r
.84777 .44158 .85865 .4611 .89169 .52242 .87433 .44279 Metetra
.282 .242 .634 r
.87433 .44279 .89169 .52242 .92863 .60533 .90825 .50461 Metetra
.283 .227 .617 r
.90825 .50461 .92863 .60533 .96141 .64155 .94573 .58394 Metetra
.358 .33 .69 r
.94573 .58394 .96141 .64155 .98404 .59481 .97924 .62007 Metetra
.932 .568 .301 r
.36161 .66687 .37517 .67871 .39453 .75059 .38087 .73621 Metetra
.521 .029 0 r
.38087 .73621 .39453 .75059 .41664 .77041 .40285 .75957 Metetra
.884 .769 .729 r
.40285 .75957 .41664 .77041 .44099 .718 .42727 .71591 Metetra
.948 .779 .639 r
.42727 .71591 .44099 .718 .46559 .62748 .45227 .63063 Metetra
.968 .816 .64 r
.45227 .63063 .46559 .62748 .48907 .55682 .4763 .5543 Metetra
.892 .901 .827 r
.4763 .5543 .48907 .55682 .51165 .54614 .49921 .52748 Metetra
0 0 .402 r
.49921 .52748 .51165 .54614 .53455 .59809 .52199 .56127 Metetra
.701 .386 0 r
.52199 .56127 .53455 .59809 .5587 .67672 .54575 .63357 Metetra
0 0 .435 r
.54575 .63357 .5587 .67672 .5837 .72375 .5707 .69681 Metetra
.463 .51 .821 r
.5707 .69681 .5837 .72375 .60798 .69879 .59574 .70414 Metetra
.982 .894 .654 r
.59574 .70414 .60798 .69879 .63042 .6153 .61939 .6452 Metetra
.906 .839 .381 r
.61939 .6452 .63042 .6153 .65184 .52822 .64145 .55539 Metetra
.791 .807 .32 r
.64145 .55539 .65184 .52822 .6745 .48954 .6634 .48667 Metetra
.704 .947 .957 r
.6634 .48667 .6745 .48954 .70046 .51834 .68742 .47405 Metetra
.046 .142 .642 r
.68742 .47405 .70046 .51834 .72994 .59342 .71495 .52066 Metetra
.066 .095 .581 r
.71495 .52066 .72994 .59342 .76039 .66122 .74541 .59666 Metetra
.206 .208 .64 r
.74541 .59666 .76039 .66122 .78758 .66721 .7758 .65063 Metetra
.686 .728 .882 r
.7758 .65063 .78758 .66721 .8092 .60086 .80227 .64058 Metetra
0 0 .046 r
.80227 .64058 .8092 .60086 .82755 .50588 .82345 .56802 Metetra
0 0 .236 r
.82345 .56802 .82755 .50588 .84777 .44158 .84203 .47677 Metetra
0 0 .102 r
.84203 .47677 .84777 .44158 .87433 .44279 .86289 .41805 Metetra
.537 .565 .831 r
.86289 .41805 .87433 .44279 .90825 .50461 .89002 .42024 Metetra
.321 .264 .636 r
.89002 .42024 .90825 .50461 .94573 .58394 .92431 .47827 Metetra
.309 .242 .618 r
.92431 .47827 .94573 .58394 .97924 .62007 .96238 .55494 Metetra
.93 .561 .289 r
.34784 .65485 .36161 .66687 .38087 .73621 .36702 .72151 Metetra
.618 .125 0 r
.36702 .72151 .38087 .73621 .40285 .75957 .38886 .74791 Metetra
.863 .772 .76 r
.38886 .74791 .40285 .75957 .42727 .71591 .41328 .71283 Metetra
.944 .782 .65 r
.41328 .71283 .42727 .71591 .45227 .63063 .43861 .6341 Metetra
.968 .814 .636 r
.43861 .6341 .45227 .63063 .4763 .5543 .4632 .55464 Metetra
.944 .885 .744 r
.4632 .55464 .4763 .5543 .49921 .52748 .48656 .51375 Metetra
0 .32 .8 r
.48656 .51375 .49921 .52748 .52199 .56127 .50939 .52856 Metetra
0 0 .266 r
.50939 .52856 .52199 .56127 .54575 .63357 .53282 .5886 Metetra
0 0 .369 r
.53282 .5886 .54575 .63357 .5707 .69681 .5575 .65867 Metetra
.065 .188 .683 r
.5575 .65867 .5707 .69681 .59574 .70414 .5829 .69363 Metetra
.852 .82 .816 r
.5829 .69363 .59574 .70414 .61939 .6452 .60767 .66661 Metetra
.946 .883 .478 r
.60767 .66661 .61939 .6452 .64145 .55539 .63083 .59009 Metetra
.786 .775 .269 r
.63083 .59009 .64145 .55539 .6634 .48667 .65291 .50598 Metetra
.749 .841 .391 r
.65291 .50598 .6634 .48667 .68742 .47405 .67565 .45642 Metetra
.404 .568 .902 r
.67565 .45642 .68742 .47405 .71495 .52066 .70095 .46264 Metetra
.109 .149 .623 r
.70095 .46264 .71495 .52066 .74541 .59666 .72972 .51824 Metetra
.143 .143 .598 r
.72972 .51824 .74541 .59666 .7758 .65063 .76087 .59068 Metetra
.27 .262 .666 r
.76087 .59068 .7758 .65063 .80227 .64058 .79126 .63383 Metetra
.797 .915 .919 r
.79126 .63383 .80227 .64058 .82345 .56802 .81749 .61548 Metetra
0 0 .156 r
.81749 .61548 .82345 .56802 .84203 .47677 .83868 .54224 Metetra
0 0 .274 r
.83868 .54224 .84203 .47677 .86289 .41805 .85756 .45429 Metetra
0 0 .127 r
.85756 .45429 .86289 .41805 .89002 .42024 .87864 .39621 Metetra
.595 .606 .833 r
.87864 .39621 .89002 .42024 .92431 .47827 .90567 .39338 Metetra
.361 .29 .642 r
.90567 .39338 .92431 .47827 .96238 .55494 .93976 .44352 Metetra
.928 .553 .275 r
.33385 .64264 .34784 .65485 .36702 .72151 .35297 .70649 Metetra
.68 .192 0 r
.35297 .70649 .36702 .72151 .38886 .74791 .37468 .7354 Metetra
.831 .772 .796 r
.37468 .7354 .38886 .74791 .41328 .71283 .39904 .70861 Metetra
.939 .786 .665 r
.39904 .70861 .41328 .71283 .43861 .6341 .42462 .63752 Metetra
.968 .814 .637 r
.42462 .63752 .43861 .6341 .4632 .55464 .44974 .55744 Metetra
.964 .871 .696 r
.44974 .55744 .4632 .55464 .48656 .51375 .47364 .50506 Metetra
.561 .79 .985 r
.47364 .50506 .48656 .51375 .50939 .52856 .4967 .50127 Metetra
0 0 .417 r
.4967 .50127 .50939 .52856 .53282 .5886 .51993 .54485 Metetra
0 0 .365 r
.51993 .54485 .53282 .5886 .5575 .65867 .54422 .61264 Metetra
0 0 .553 r
.54422 .61264 .5575 .65867 .5829 .69363 .56963 .66666 Metetra
.478 .524 .826 r
.56963 .66666 .5829 .69363 .60767 .66661 .59518 .67259 Metetra
.969 .932 .677 r
.59518 .67259 .60767 .66661 .63083 .59009 .61962 .62242 Metetra
.817 .804 .313 r
.61962 .62242 .63083 .59009 .65291 .50598 .64254 .5406 Metetra
.64254 .5406 .65291 .50598 .67565 .45642 .6649 .46663 Metetra
.781 .94 .591 r
.6649 .46663 .67565 .45642 .70095 .46264 .68847 .43244 Metetra
.318 .396 .785 r
.68847 .43244 .70095 .46264 .72972 .51824 .71486 .45002 Metetra
.173 .176 .62 r
.71486 .45002 .72972 .51824 .76087 .59068 .74457 .50842 Metetra
.201 .18 .609 r
.74457 .50842 .76087 .59068 .79126 .63383 .77627 .57629 Metetra
.306 .293 .68 r
.77627 .57629 .79126 .63383 .81749 .61548 .80692 .61346 Metetra
.775 .985 .902 r
.80692 .61346 .81749 .61548 .83868 .54224 .83344 .59379 Metetra
0 0 .216 r
.83344 .59379 .83868 .54224 .85756 .45429 .85509 .52395 Metetra
.011 0 .307 r
.85509 .52395 .85756 .45429 .87864 .39621 .87429 .43855 Metetra
0 0 .192 r
.87429 .43855 .87864 .39621 .90567 .39338 .89518 .37696 Metetra
.722 .751 .875 r
.89518 .37696 .90567 .39338 .93976 .44352 .92143 .36379 Metetra
.924 .544 .259 r
.31963 .63024 .33385 .64264 .35297 .70649 .33873 .69114 Metetra
.721 .237 0 r
.33873 .69114 .35297 .70649 .37468 .7354 .36029 .72203 Metetra
.785 .767 .837 r
.36029 .72203 .37468 .7354 .39904 .70861 .38454 .7031 Metetra
.93 .79 .684 r
.38454 .7031 .39904 .70861 .42462 .63752 .41028 .64048 Metetra
.966 .816 .643 r
.41028 .64048 .42462 .63752 .44974 .55744 .43588 .5622 Metetra
.973 .863 .669 r
.43588 .5622 .44974 .55744 .47364 .50506 .46038 .50124 Metetra
.846 .91 .878 r
.46038 .50124 .47364 .50506 .4967 .50127 .48383 .48033 Metetra
0 .134 .681 r
.48383 .48033 .4967 .50127 .51993 .54485 .50704 .50512 Metetra
0 0 .42 r
.50704 .50512 .51993 .54485 .54422 .61264 .53098 .5629 Metetra
0 0 .493 r
.53098 .5629 .54422 .61264 .56963 .66666 .55611 .62544 Metetra
.129 .22 .691 r
.55611 .62544 .56963 .66666 .59518 .67259 .58202 .65902 Metetra
.768 .786 .867 r
.58202 .65902 .59518 .67259 .61962 .62242 .60756 .64209 Metetra
.895 .897 .481 r
.60756 .64209 .61962 .62242 .64254 .5406 .63177 .57946 Metetra
.63177 .57946 .64254 .5406 .6649 .46663 .65467 .49906 Metetra
.65467 .49906 .6649 .46663 .68847 .43244 .67744 .43477 Metetra
.819 1 .813 r
.67744 .43477 .68847 .43244 .71486 .45002 .70175 .41049 Metetra
.328 .354 .736 r
.70175 .41049 .71486 .45002 .74457 .50842 .72895 .43291 Metetra
.23 .206 .623 r
.72895 .43291 .74457 .50842 .77627 .57629 .75934 .49015 Metetra
.245 .207 .616 r
.75934 .49015 .77627 .57629 .80692 .61346 .79158 .55419 Metetra
.321 .3 .68 r
.79158 .55419 .80692 .61346 .83344 .59379 .82284 .59042 Metetra
.693 .959 .947 r
.82284 .59042 .83344 .59379 .85509 .52395 .85023 .57555 Metetra
.007 0 .244 r
.85023 .57555 .85509 .52395 .87429 .43855 .8728 .51298 Metetra
.079 0 .335 r
.8728 .51298 .87429 .43855 .89518 .37696 .89245 .43048 Metetra
.01 0 .271 r
.89245 .43048 .89518 .37696 .92143 .36379 .91288 .36281 Metetra
.921 .533 .24 r
.3052 .61764 .31963 .63024 .33873 .69114 .32428 .67547 Metetra
.745 .267 0 r
.32428 .67547 .33873 .69114 .36029 .72203 .34571 .70781 Metetra
.716 .75 .88 r
.34571 .70781 .36029 .72203 .38454 .7031 .3698 .6962 Metetra
.919 .795 .708 r
.3698 .6962 .38454 .7031 .41028 .64048 .39561 .64261 Metetra
.963 .819 .653 r
.39561 .64261 .41028 .64048 .43588 .5622 .42162 .56834 Metetra
.977 .859 .655 r
.42162 .56834 .43588 .5622 .46038 .50124 .44672 .50192 Metetra
.934 .916 .775 r
.44672 .50192 .46038 .50124 .48383 .48033 .4707 .46626 Metetra
.327 .591 .94 r
.4707 .46626 .48383 .48033 .50704 .50512 .49409 .47169 Metetra
0 0 .544 r
.49409 .47169 .50704 .50512 .53098 .5629 .5178 .51387 Metetra
0 0 .495 r
.5178 .51387 .53098 .5629 .55611 .62544 .54254 .57448 Metetra
0 .067 .594 r
.54254 .57448 .55611 .62544 .58202 .65902 .56839 .6257 Metetra
.356 .413 .783 r
.56839 .6257 .58202 .65902 .60756 .64209 .59463 .64102 Metetra
.91 .948 .813 r
.59463 .64102 .60756 .64209 .63177 .57946 .62015 .60932 Metetra
.723 .779 .288 r
.62015 .60932 .63177 .57946 .65467 .49906 .64428 .54186 Metetra
.64428 .54186 .65467 .49906 .67744 .43477 .66734 .46535 Metetra
.66734 .46535 .67744 .43477 .70175 .41049 .69052 .40786 Metetra
.815 .971 .9 r
.69052 .40786 .70175 .41049 .72895 .43291 .71536 .38787 Metetra
.368 .361 .72 r
.71536 .38787 .72895 .43291 .75934 .49015 .74308 .40976 Metetra
.28 .235 .628 r
.74308 .40976 .75934 .49015 .79158 .55419 .77391 .46304 Metetra
.281 .228 .618 r
.77391 .46304 .79158 .55419 .82284 .59042 .80669 .5242 Metetra
.326 .292 .666 r
.80669 .5242 .82284 .59042 .85023 .57555 .8389 .56363 Metetra
.567 .775 .976 r
.8389 .56363 .85023 .57555 .8728 .51298 .86774 .55897 Metetra
.068 0 .237 r
.86774 .55897 .8728 .51298 .89245 .43048 .89185 .50824 Metetra
.141 0 .356 r
.89185 .50824 .89245 .43048 .91288 .36281 .91237 .43117 Metetra
.915 .519 .218 r
.29053 .60484 .3052 .61764 .32428 .67547 .30964 .65947 Metetra
.759 .284 0 r
.30964 .65947 .32428 .67547 .34571 .70781 .33094 .69273 Metetra
.616 .716 .917 r
.33094 .69273 .34571 .70781 .3698 .6962 .35484 .68777 Metetra
.901 .799 .738 r
.35484 .68777 .3698 .6962 .39561 .64261 .38062 .6435 Metetra
.959 .824 .668 r
.38062 .6435 .39561 .64261 .42162 .56834 .40693 .57518 Metetra
.979 .859 .651 r
.40693 .57518 .42162 .56834 .44672 .50192 .43262 .50649 Metetra
.964 .908 .712 r
.43262 .50649 .44672 .50192 .4707 .46626 .45721 .45915 Metetra
.744 .871 .939 r
.45721 .45915 .4707 .46626 .49409 .47169 .48098 .44625 Metetra
0 .229 .741 r
.48098 .44625 .49409 .47169 .5178 .51387 .50465 .46963 Metetra
0 0 .552 r
.50465 .46963 .5178 .51387 .54254 .57448 .52902 .51959 Metetra
0 .024 .562 r
.52902 .51959 .54254 .57448 .56839 .6257 .55454 .57647 Metetra
.126 .189 .659 r
.55454 .57647 .56839 .6257 .59463 .64102 .58098 .61582 Metetra
.515 .569 .848 r
.58098 .61582 .59463 .64102 .62015 .60932 .60749 .61817 Metetra
.881 .975 .67 r
.60749 .61817 .62015 .60932 .64428 .54186 .63309 .57898 Metetra
.63309 .57898 .64428 .54186 .66734 .46535 .65732 .51131 Metetra
0 0 .012 r
.65732 .51131 .66734 .46535 .69052 .40786 .68061 .43872 Metetra
.68061 .43872 .69052 .40786 .71536 .38787 .70412 .38444 Metetra
.825 .964 .897 r
.70412 .38444 .71536 .38787 .74308 .40976 .72927 .36367 Metetra
.422 .394 .723 r
.72927 .36367 .74308 .40976 .77391 .46304 .75718 .38047 Metetra
.329 .266 .634 r
.75718 .38047 .77391 .46304 .80669 .5242 .78818 .42713 Metetra
.315 .246 .618 r
.78818 .42713 .80669 .5242 .8389 .56363 .82142 .48528 Metetra
.334 .28 .647 r
.82142 .48528 .8389 .56363 .86774 .55897 .85479 .53018 Metetra
.427 .498 .829 r
.85479 .53018 .86774 .55897 .89185 .50824 .88562 .53997 Metetra
.09 0 .145 r
.88562 .53997 .89185 .50824 .91237 .43117 .91205 .50658 Metetra
.909 .503 .191 r
.27563 .59183 .29053 .60484 .30964 .65947 .29478 .64315 Metetra
.764 .29 0 r
.29478 .64315 .30964 .65947 .33094 .69273 .31598 .67679 Metetra
.481 .655 .937 r
.31598 .67679 .33094 .69273 .35484 .68777 .33966 .67775 Metetra
.874 .801 .774 r
.33966 .67775 .35484 .68777 .38062 .6435 .36533 .64276 Metetra
.951 .83 .689 r
.36533 .64276 .38062 .6435 .40693 .57518 .39184 .58199 Metetra
.978 .862 .655 r
.39184 .58199 .40693 .57518 .43262 .50649 .41804 .51414 Metetra
.976 .903 .676 r
.41804 .51414 .43262 .50649 .45721 .45915 .44328 .45867 Metetra
.903 .938 .824 r
.44328 .45867 .45721 .45915 .48098 .44625 .46758 .42979 Metetra
.416 .607 .926 r
.46758 .42979 .48098 .44625 .50465 .46963 .49144 .43353 Metetra
0 .144 .665 r
.49144 .43353 .50465 .46963 .52902 .51959 .51561 .46688 Metetra
0 .055 .583 r
.51561 .46688 .52902 .51959 .55454 .57647 .5407 .51817 Metetra
.056 .113 .606 r
.5407 .51817 .55454 .57647 .58098 .61582 .56692 .56899 Metetra
.234 .274 .699 r
.56692 .56899 .58098 .61582 .60749 .61817 .59387 .59916 Metetra
.604 .68 .895 r
.59387 .59916 .60749 .61817 .63309 .57898 .62069 .59448 Metetra
.731 .892 .5 r
.62069 .59448 .63309 .57898 .65732 .51131 .64652 .55351 Metetra
.64652 .55351 .65732 .51131 .68061 .43872 .67101 .48837 Metetra
0 0 .086 r
.67101 .48837 .68061 .43872 .70412 .38444 .69459 .41889 Metetra
.69459 .41889 .70412 .38444 .72927 .36367 .71834 .36455 Metetra
.838 .999 .819 r
.71834 .36455 .72927 .36367 .75718 .38047 .74353 .33876 Metetra
.495 .457 .744 r
.74353 .33876 .75718 .38047 .78818 .42713 .77128 .34639 Metetra
.379 .303 .644 r
.77128 .34639 .78818 .42713 .82142 .48528 .80209 .38319 Metetra
.351 .267 .619 r
.80209 .38319 .82142 .48528 .85479 .53018 .83551 .43619 Metetra
.351 .275 .63 r
.83551 .43619 .85479 .53018 .88562 .53997 .86998 .48596 Metetra
.375 .354 .708 r
.86998 .48596 .88562 .53997 .91205 .50658 .90311 .51207 Metetra
.9 .484 .159 r
.26048 .57861 .27563 .59183 .29478 .64315 .27972 .6265 Metetra
.76 .287 0 r
.27972 .6265 .29478 .64315 .31598 .67679 .30083 .66 Metetra
.321 .568 .927 r
.30083 .66 .31598 .67679 .33966 .67775 .32429 .66604 Metetra
.834 .797 .816 r
.32429 .66604 .33966 .67775 .36533 .64276 .34977 .64004 Metetra
.938 .836 .718 r
.34977 .64004 .36533 .64276 .39184 .58199 .37634 .58799 Metetra
.975 .868 .668 r
.37634 .58799 .39184 .58199 .41804 .51414 .40295 .52383 Metetra
.98 .903 .66 r
.40295 .52383 .41804 .51414 .44328 .45867 .42883 .46403 Metetra
.951 .943 .734 r
.42883 .46403 .44328 .45867 .46758 .42979 .45377 .42257 Metetra
.766 .878 .928 r
.45377 .42257 .46758 .42979 .49144 .43353 .47804 .40788 Metetra
.265 .412 .823 r
.47804 .40788 .49144 .43353 .51561 .46688 .50223 .4217 Metetra
.067 .159 .652 r
.50223 .4217 .51561 .46688 .5407 .51817 .52698 .45894 Metetra
.074 .122 .608 r
.52698 .45894 .5407 .51817 .56692 .56899 .55276 .50813 Metetra
.153 .177 .632 r
.55276 .50813 .56692 .56899 .59387 .59916 .57961 .55333 Metetra
.295 .321 .718 r
.57961 .55333 .59387 .59916 .62069 .59448 .60707 .57824 Metetra
.621 .728 .923 r
.60707 .57824 .62069 .59448 .64652 .55351 .6343 .57197 Metetra
.6343 .57197 .64652 .55351 .67101 .48837 .66055 .53372 Metetra
0 0 .066 r
.66055 .53372 .67101 .48837 .69459 .41889 .68548 .47317 Metetra
0 0 .153 r
.68548 .47317 .69459 .41889 .71834 .36455 .70944 .40637 Metetra
0 0 .083 r
.70944 .40637 .71834 .36455 .74353 .33876 .73334 .34978 Metetra
.67 .882 .514 r
.73334 .34978 .74353 .33876 .77128 .34639 .75836 .31585 Metetra
.608 .579 .796 r
.75836 .31585 .77128 .34639 .80209 .38319 .7856 .31073 Metetra
.439 .353 .662 r
.7856 .31073 .80209 .38319 .83551 .43619 .81576 .3337 Metetra
.392 .294 .623 r
.81576 .3337 .83551 .43619 .86998 .48596 .84884 .37715 Metetra
.377 .282 .619 r
.84884 .37715 .86998 .48596 .90311 .51207 .88392 .42743 Metetra
.888 .459 .121 r
.24509 .56518 .26048 .57861 .27972 .6265 .26444 .60953 Metetra
.749 .273 0 r
.26444 .60953 .27972 .6265 .30083 .66 .2855 .64237 Metetra
.158 .466 .89 r
.2855 .64237 .30083 .66 .32429 .66604 .30873 .6526 Metetra
.773 .782 .86 r
.30873 .6526 .32429 .66604 .34977 .64004 .33396 .63503 Metetra
.917 .84 .754 r
.33396 .63503 .34977 .64004 .37634 .58799 .36048 .59241 Metetra
.968 .876 .691 r
.36048 .59241 .37634 .58799 .40295 .52383 .38736 .53438 Metetra
.98 .907 .658 r
.38736 .53438 .40295 .52383 .42883 .46403 .41381 .47407 Metetra
.964 .94 .679 r
.41381 .47407 .42883 .46403 .45377 .42257 .43944 .42411 Metetra
.906 .962 .813 r
.43944 .42411 .45377 .42257 .47804 .40788 .46429 .39389 Metetra
.619 .742 .934 r
.46429 .39389 .47804 .40788 .50223 .4217 .48875 .38815 Metetra
.264 .351 .766 r
.48875 .38815 .50223 .4217 .52698 .45894 .51338 .40652 Metetra
.159 .198 .653 r
.51338 .40652 .52698 .45894 .55276 .50813 .53874 .44355 Metetra
.167 .176 .624 r
.53874 .44355 .55276 .50813 .57961 .55333 .56515 .48922 Metetra
.222 .218 .643 r
.56515 .48922 .57961 .55333 .60707 .57824 .59257 .53039 Metetra
.323 .334 .716 r
.59257 .53039 .60707 .57824 .6343 .57197 .62056 .5539 Metetra
.569 .688 .921 r
.62056 .5539 .6343 .57197 .66055 .53372 .64836 .55065 Metetra
.64836 .55065 .66055 .53372 .68548 .47317 .67525 .51899 Metetra
0 0 .114 r
.67525 .51899 .68548 .47317 .70944 .40637 .70085 .46543 Metetra
0 0 .21 r
.70085 .46543 .70944 .40637 .73334 .34978 .72534 .40218 Metetra
0 0 .187 r
.72534 .40218 .73334 .34978 .75836 .31585 .74945 .34296 Metetra
.74945 .34296 .75836 .31585 .7856 .31073 .77419 .29942 Metetra
.811 .864 .887 r
.77419 .29942 .7856 .31073 .81576 .3337 .80063 .279 Metetra
.525 .441 .703 r
.80063 .279 .81576 .3337 .84884 .37715 .82964 .28411 Metetra
.443 .335 .636 r
.82964 .28411 .84884 .37715 .88392 .42743 .86164 .31196 Metetra
.871 .428 .073 r
.22944 .55152 .24509 .56518 .26444 .60953 .24895 .59223 Metetra
.728 .25 0 r
.24895 .59223 .26444 .60953 .2855 .64237 .26999 .62393 Metetra
.02 .37 .838 r
.26999 .62393 .2855 .64237 .30873 .6526 .29301 .63742 Metetra
.686 .749 .9 r
.29301 .63742 .30873 .6526 .33396 .63503 .31795 .62744 Metetra
.882 .839 .798 r
.31795 .62744 .33396 .63503 .36048 .59241 .34431 .59446 Metetra
.954 .884 .724 r
.34431 .59446 .36048 .59241 .38736 .53438 .37131 .54449 Metetra
.975 .916 .672 r
.37131 .54449 .38736 .53438 .41381 .47407 .3982 .48721 Metetra
.963 .94 .651 r
.3982 .48721 .41381 .47407 .43944 .42411 .42449 .4332 Metetra
.935 .968 .707 r
.42449 .4332 .43944 .42411 .46429 .39389 .45002 .3916 Metetra
.854 .948 .878 r
.45002 .3916 .46429 .39389 .48875 .38815 .47498 .36864 Metetra
.553 .644 .894 r
.47498 .36864 .48875 .38815 .51338 .40652 .49976 .367 Metetra
.313 .351 .741 r
.49976 .367 .51338 .40652 .53874 .44355 .52489 .38562 Metetra
.241 .241 .658 r
.52489 .38562 .53874 .44355 .56515 .48922 .5508 .41976 Metetra
.241 .219 .633 r
.5508 .41976 .56515 .48922 .59257 .53039 .57776 .46135 Metetra
.273 .245 .644 r
.57776 .46135 .59257 .53039 .62056 .5539 .60573 .50002 Metetra
.335 .324 .698 r
.60573 .50002 .62056 .5539 .64836 .55065 .63431 .52511 Metetra
.482 .566 .864 r
.63431 .52511 .64836 .55065 .67525 .51899 .66283 .52846 Metetra
.439 .815 .565 r
.66283 .52846 .67525 .51899 .70085 .46543 .69061 .50696 Metetra
0 0 .119 r
.69061 .50696 .70085 .46543 .72534 .40218 .71718 .46367 Metetra
.073 0 .247 r
.71718 .46367 .72534 .40218 .74945 .34296 .74251 .40679 Metetra
.079 0 .263 r
.74251 .40679 .74945 .34296 .77419 .29942 .76705 .34706 Metetra
0 0 .185 r
.76705 .34706 .77419 .29942 .80063 .279 .79162 .29502 Metetra
.79162 .29502 .80063 .279 .82964 .28411 .81718 .25886 Metetra
.71 .678 .816 r
.81718 .25886 .82964 .28411 .86164 .31196 .84468 .24343 Metetra
.847 .388 .014 r
.21353 .53763 .22944 .55152 .24895 .59223 .23323 .5746 Metetra
.695 .214 0 r
.23323 .5746 .24895 .59223 .26999 .62393 .2543 .60468 Metetra
0 .296 .791 r
.2543 .60468 .26999 .62393 .29301 .63742 .27714 .62048 Metetra
.574 .695 .924 r
.27714 .62048 .29301 .63742 .31795 .62744 .30178 .61707 Metetra
.828 .826 .847 r
.30178 .61707 .31795 .62744 .34431 .59446 .32788 .59345 Metetra
.93 .89 .77 r
.32788 .59345 .34431 .59446 .37131 .54449 .35484 .55279 Metetra
.966 .928 .701 r
.35484 .55279 .37131 .54449 .3982 .48721 .38202 .50157 Metetra
.955 .946 .646 r
.38202 .50157 .3982 .48721 .42449 .4332 .40886 .44793 Metetra
.923 .958 .636 r
.40886 .44793 .42449 .4332 .45002 .3916 .4351 .39984 Metetra
.9 .985 .73 r
.4351 .39984 .45002 .3916 .47498 .36864 .46071 .36383 Metetra
.818 .926 .906 r
.46071 .36383 .47498 .36864 .49976 .367 .48591 .34418 Metetra
.556 .613 .865 r
.48591 .34418 .49976 .367 .52489 .38562 .5111 .34262 Metetra
.377 .379 .734 r
.5111 .34262 .52489 .38562 .5508 .41976 .5367 .35821 Metetra
.314 .283 .664 r
.5367 .35821 .5508 .41976 .57776 .46135 .56309 .38741 Metetra
.303 .255 .637 r
.56309 .38741 .57776 .46135 .60573 .50002 .59052 .42424 Metetra
.316 .264 .639 r
.59052 .42424 .60573 .50002 .63431 .52511 .61898 .46093 Metetra
.347 .308 .672 r
.61898 .46093 .63431 .52511 .66283 .52846 .64816 .48902 Metetra
.415 .434 .771 r
.64816 .48902 .66283 .52846 .69061 .50696 .67752 .50112 Metetra
.547 .881 .989 r
.67752 .50112 .69061 .50696 .71718 .46367 .70643 .49277 Metetra
.012 0 .017 r
.70643 .49277 .71718 .46367 .74251 .40679 .73434 .46373 Metetra
.144 0 .25 r
.73434 .46373 .74251 .40679 .76705 .34706 .76097 .41807 Metetra
.172 0 .304 r
.76097 .41807 .76705 .34706 .79162 .29502 .78646 .36304 Metetra
.154 0 .298 r
.78646 .36304 .79162 .29502 .81718 .25886 .81132 .30716 Metetra
.06 0 .211 r
.81132 .30716 .81718 .25886 .84468 .24343 .83632 .25847 Metetra
.812 .335 0 r
.19735 .52351 .21353 .53763 .23323 .5746 .21728 .55664 Metetra
.646 .163 0 r
.21728 .55664 .23323 .5746 .2543 .60468 .23842 .58467 Metetra
0 .253 .761 r
.23842 .58467 .2543 .60468 .27714 .62048 .26113 .60181 Metetra
.451 .623 .926 r
.26113 .60181 .27714 .62048 .30178 .61707 .28547 .60378 Metetra
.746 .793 .891 r
.28547 .60378 .30178 .61707 .32788 .59345 .31126 .58877 Metetra
.887 .885 .824 r
.31126 .58877 .32788 .59345 .35484 .55279 .33805 .55793 Metetra
.947 .94 .749 r
.33805 .55793 .35484 .55279 .38202 .50157 .36532 .51505 Metetra
.942 .958 .667 r
.36532 .51505 .38202 .50157 .40886 .44793 .39257 .46575 Metetra
.896 .951 .601 r
.39257 .46575 .40886 .44793 .4351 .39984 .41943 .41629 Metetra
.854 .952 .6 r
.41943 .41629 .4351 .39984 .46071 .36383 .44575 .37256 Metetra
.858 .99 .725 r
.44575 .37256 .46071 .36383 .48591 .34418 .47158 .33928 Metetra
.815 .93 .909 r
.47158 .33928 .48591 .34418 .5111 .34262 .49714 .31961 Metetra
.6 .637 .859 r
.49714 .31961 .5111 .34262 .5367 .35821 .52274 .31495 Metetra
.445 .423 .74 r
.52274 .31495 .5367 .35821 .56309 .38741 .54876 .32486 Metetra
.381 .327 .672 r
.54876 .32486 .56309 .38741 .59052 .42424 .57555 .34713 Metetra
.359 .289 .641 r
.57555 .34713 .59052 .42424 .61898 .46093 .60333 .37779 Metetra
.358 .282 .634 r
.60333 .37779 .61898 .46093 .64816 .48902 .63216 .41144 Metetra
.369 .3 .647 r
.63216 .41144 .64816 .48902 .67752 .50112 .66187 .44178 Metetra
.394 .353 .694 r
.66187 .44178 .67752 .50112 .70643 .49277 .69209 .46252 Metetra
.453 .519 .836 r
.69209 .46252 .70643 .49277 .73434 .46373 .72226 .46856 Metetra
.72226 .46856 .73434 .46373 .76097 .41807 .75182 .45716 Metetra
.172 0 .163 r
.75182 .45716 .76097 .41807 .78646 .36304 .78031 .42859 Metetra
.235 0 .302 r
.78031 .42859 .78646 .36304 .81132 .30716 .80752 .38611 Metetra
.247 .007 .34 r
.80752 .38611 .81132 .30716 .83632 .25847 .83359 .33516 Metetra
.76 .264 0 r
.1809 .50916 .19735 .52351 .21728 .55664 .20111 .53835 Metetra
.575 .093 0 r
.20111 .53835 .21728 .55664 .23842 .58467 .22237 .5639 Metetra
0 .241 .754 r
.22237 .5639 .23842 .58467 .26113 .60181 .24499 .58145 Metetra
.341 .549 .909 r
.24499 .58145 .26113 .60181 .28547 .60378 .26907 .58748 Metetra
.641 .735 .917 r
.26907 .58748 .28547 .60378 .31126 .58877 .29451 .57994 Metetra
.816 .858 .88 r
.29451 .57994 .31126 .58877 .33805 .55793 .32103 .55868 Metetra
.909 .942 .815 r
.32103 .55868 .33805 .55793 .36532 .51505 .34822 .52546 Metetra
.922 .975 .718 r
.34822 .52546 .36532 .51505 .39257 .46575 .37567 .48365 Metetra
.865 .954 .605 r
.37567 .48365 .39257 .46575 .41943 .41629 .40301 .43759 Metetra
.784 .911 .521 r
.40301 .43759 .41943 .41629 .44575 .37256 .43 .39189 Metetra
.742 .903 .521 r
.43 .39189 .44575 .37256 .47158 .33928 .45654 .35085 Metetra
.784 .966 .662 r
.45654 .35085 .47158 .33928 .49714 .31961 .4827 .318 Metetra
.829 .973 .889 r
.4827 .318 .49714 .31961 .52274 .31495 .50865 .29583 Metetra
.674 .714 .878 r
.50865 .29583 .52274 .31495 .54876 .32486 .53467 .2857 Metetra
.522 .49 .762 r
.53467 .2857 .54876 .32486 .57555 .34713 .56106 .28777 Metetra
.447 .379 .687 r
.56106 .28777 .57555 .34713 .60333 .37779 .58813 .30101 Metetra
.414 .327 .648 r
.58813 .30101 .60333 .37779 .63216 .41144 .61611 .32321 Metetra
.402 .306 .632 r
.61611 .32321 .63216 .41144 .66187 .44178 .64513 .35107 Metetra
.4 .304 .631 r
.64513 .35107 .66187 .44178 .69209 .46252 .67517 .3804 Metetra
.405 .32 .646 r
.67517 .3804 .69209 .46252 .72226 .46856 .70603 .40649 Metetra
.42 .366 .692 r
.70603 .40649 .72226 .46856 .75182 .45716 .73734 .42472 Metetra
.452 .507 .825 r
.73734 .42472 .75182 .45716 .78031 .42859 .76862 .43125 Metetra
.177 .705 .697 r
.76862 .43125 .78031 .42859 .80752 .38611 .79934 .42372 Metetra
.244 0 .171 r
.79934 .42372 .80752 .38611 .83359 .33516 .82907 .40173 Metetra
.682 .169 0 r
.16417 .49455 .1809 .50916 .20111 .53835 .1847 .51973 Metetra
0 0 .52 r
.1847 .51973 .20111 .53835 .22237 .5639 .20614 .54242 Metetra
0 .257 .766 r
.20614 .54242 .22237 .5639 .24499 .58145 .22874 .55949 Metetra
.266 .49 .887 r
.22874 .55949 .24499 .58145 .26907 .58748 .25261 .5682 Metetra
.531 .66 .919 r
.25261 .5682 .26907 .58748 .29451 .57994 .27772 .56665 Metetra
.715 .798 .917 r
.27772 .56665 .29451 .57994 .32103 .55868 .30389 .55401 Metetra
.84 .916 .886 r
.30389 .55401 .32103 .55868 .34822 .52546 .33086 .53072 Metetra
.889 .986 .802 r
.33086 .53072 .34822 .52546 .37567 .48365 .35831 .49838 Metetra
.836 .971 .658 r
.35831 .49838 .37567 .48365 .40301 .43759 .38592 .45952 Metetra
.718 .889 .5 r
.38592 .45952 .40301 .43759 .43 .39189 .41343 .41724 Metetra
.609 .808 .394 r
.41343 .41724 .43 .39189 .45654 .35085 .44065 .37484 Metetra
.44065 .37484 .45654 .35085 .4827 .318 .46752 .3354 Metetra
.62 .859 .497 r
.46752 .3354 .4827 .318 .50865 .29583 .49409 .30161 Metetra
.776 .993 .776 r
.49409 .30161 .50865 .29583 .53467 .2857 .52049 .27554 Metetra
.774 .867 .917 r
.52049 .27554 .53467 .2857 .56106 .28777 .54692 .25854 Metetra
.622 .605 .813 r
.54692 .25854 .56106 .28777 .58813 .30101 .57363 .25127 Metetra
.524 .454 .719 r
.57363 .25127 .58813 .30101 .61611 .32321 .60088 .25359 Metetra
.475 .379 .666 r
.60088 .25359 .61611 .32321 .64513 .35107 .6289 .26465 Metetra
.451 .341 .638 r
.6289 .26465 .64513 .35107 .67517 .3804 .65787 .28284 Metetra
.439 .323 .625 r
.65787 .28284 .67517 .3804 .70603 .40649 .6879 .30587 Metetra
.434 .319 .623 r
.6879 .30587 .70603 .40649 .73734 .42472 .71896 .33088 Metetra
.434 .327 .634 r
.71896 .33088 .73734 .42472 .76862 .43125 .7509 .35458 Metetra
.439 .353 .662 r
.7509 .35458 .76862 .43125 .79934 .42372 .78344 .37361 Metetra
.449 .422 .737 r
.78344 .37361 .79934 .42372 .82907 .40173 .81616 .38486 Metetra
.565 .042 0 r
.14715 .4797 .16417 .49455 .1847 .51973 .16804 .50078 Metetra
0 .111 .633 r
.16804 .50078 .1847 .51973 .20614 .54242 .18973 .52027 Metetra
0 .298 .795 r
.18973 .52027 .20614 .54242 .22874 .55949 .21239 .536 Metetra
.236 .458 .871 r
.21239 .536 .22874 .55949 .25261 .5682 .23612 .54602 Metetra
.442 .587 .902 r
.23612 .54602 .25261 .5682 .27772 .56665 .26094 .54875 Metetra
.601 .711 .921 r
.26094 .54875 .27772 .56665 .30389 .55401 .28676 .54319 Metetra
.734 .841 .931 r
.28676 .54319 .30389 .55401 .33086 .53072 .31341 .52905 Metetra
.823 .96 .9 r
.31341 .52905 .33086 .53072 .35831 .49838 .34069 .50675 Metetra
.811 .997 .774 r
.34069 .50675 .35831 .49838 .38592 .45952 .36835 .47743 Metetra
.678 .904 .562 r
.36835 .47743 .38592 .45952 .41343 .41724 .39614 .44277 Metetra
.39614 .44277 .41343 .41724 .44065 .37484 .42389 .40482 Metetra
.42389 .40482 .44065 .37484 .46752 .3354 .45145 .3658 Metetra
.45145 .3658 .46752 .3354 .49409 .30161 .47876 .32788 Metetra
.47876 .32788 .49409 .30161 .52049 .27554 .50582 .29305 Metetra
.50582 .29305 .52049 .27554 .54692 .25854 .53272 .263 Metetra
.743 .99 .796 r
.53272 .263 .54692 .25854 .57363 .25127 .5596 .23904 Metetra
.767 .846 .911 r
.5596 .23904 .57363 .25127 .60088 .25359 .58663 .22206 Metetra
.638 .603 .798 r
.58663 .22206 .60088 .25359 .6289 .26465 .61402 .21253 Metetra
.556 .47 .712 r
.61402 .21253 .6289 .26465 .65787 .28284 .64197 .21046 Metetra
.512 .4 .663 r
.64197 .21046 .65787 .28284 .6879 .30587 .6707 .21544 Metetra
.487 .362 .635 r
.6707 .21544 .6879 .30587 .71896 .33088 .70034 .2266 Metetra
.474 .342 .621 r
.70034 .2266 .71896 .33088 .7509 .35458 .73103 .24266 Metetra
.466 .332 .615 r
.73103 .24266 .7509 .35458 .78344 .37361 .76279 .26194 Metetra
.462 .331 .617 r
.76279 .26194 .78344 .37361 .81616 .38486 .79556 .28245 Metetra
0 .118 .596 r
.12983 .46459 .14715 .4797 .16804 .50078 .15114 .4815 Metetra
0 .24 .745 r
.15114 .4815 .16804 .50078 .18973 .52027 .17313 .49747 Metetra
.059 .358 .83 r
.17313 .49747 .18973 .52027 .21239 .536 .19593 .5111 Metetra
.25 .452 .863 r
.19593 .5111 .21239 .536 .23612 .54602 .21963 .5211 Metetra
.394 .535 .879 r
.21963 .5211 .23612 .54602 .26094 .54875 .24424 .52631 Metetra
.511 .623 .899 r
.24424 .52631 .26094 .54875 .28676 .54319 .26974 .52585 Metetra
.616 .729 .927 r
.26974 .52585 .28676 .54319 .31341 .52905 .29605 .51916 Metetra
.713 .858 .951 r
.29605 .51916 .31341 .52905 .34069 .50675 .32304 .50607 Metetra
.765 .975 .92 r
.32304 .50607 .34069 .50675 .36835 .47743 .35055 .48683 Metetra
.685 .965 .742 r
.35055 .48683 .36835 .47743 .39614 .44277 .37841 .46207 Metetra
.37841 .46207 .39614 .44277 .42389 .40482 .40645 .43273 Metetra
.40645 .43273 .42389 .40482 .45145 .3658 .43452 .40003 Metetra
.43452 .40003 .45145 .3658 .47876 .32788 .4625 .36531 Metetra
.4625 .36531 .47876 .32788 .50582 .29305 .49034 .33 Metetra
.49034 .33 .50582 .29305 .53272 .263 .518 .29548 Metetra
.518 .29548 .53272 .263 .5596 .23904 .54551 .26302 Metetra
.54551 .26302 .5596 .23904 .58663 .22206 .57294 .23374 Metetra
.51 .841 .553 r
.57294 .23374 .58663 .22206 .61402 .21253 .60039 .20857 Metetra
.788 .971 .915 r
.60039 .20857 .61402 .21253 .64197 .21046 .62801 .1882 Metetra
.714 .719 .853 r
.62801 .1882 .64197 .21046 .6707 .21544 .65596 .1731 Metetra
.618 .543 .747 r
.65596 .1731 .6707 .21544 .70034 .2266 .68439 .16352 Metetra
.563 .45 .684 r
.68439 .16352 .70034 .2266 .73103 .24266 .71348 .15943 Metetra
.531 .399 .646 r
.71348 .15943 .73103 .24266 .76279 .26194 .74338 .16061 Metetra
.511 .37 .624 r
.74338 .16061 .76279 .26194 .79556 .28245 .77422 .16657 Metetra
0 .297 .761 r
.11221 .44921 .12983 .46459 .15114 .4815 .13399 .46189 Metetra
.009 .371 .838 r
.13399 .46189 .15114 .4815 .17313 .49747 .15634 .47407 Metetra
.174 .426 .861 r
.15634 .47407 .17313 .49747 .19593 .5111 .17937 .48492 Metetra
.297 .469 .861 r
.17937 .48492 .19593 .5111 .21963 .5211 .20313 .49367 Metetra
.389 .51 .86 r
.20313 .49367 .21963 .5211 .24424 .52631 .22765 .49958 Metetra
.464 .559 .867 r
.22765 .49958 .24424 .52631 .26974 .52585 .25293 .502 Metetra
.532 .623 .888 r
.25293 .502 .26974 .52585 .29605 .51916 .27894 .50043 Metetra
.6 .712 .923 r
.27894 .50043 .29605 .51916 .32304 .50607 .30561 .49451 Metetra
.665 .831 .963 r
.30561 .49451 .32304 .50607 .35055 .48683 .33286 .48409 Metetra
.691 .951 .955 r
.33286 .48409 .35055 .48683 .37841 .46207 .36059 .4692 Metetra
.578 .933 .77 r
.36059 .4692 .37841 .46207 .40645 .43273 .38867 .45008 Metetra
.38867 .45008 .40645 .43273 .43452 .40003 .41699 .42713 Metetra
.41699 .42713 .43452 .40003 .4625 .36531 .44545 .40094 Metetra
.44545 .40094 .4625 .36531 .49034 .33 .47395 .37219 Metetra
.056 0 .066 r
.47395 .37219 .49034 .33 .518 .29548 .50241 .34167 Metetra
.097 0 .114 r
.50241 .34167 .518 .29548 .54551 .26302 .53079 .31019 Metetra
.114 0 .132 r
.53079 .31019 .54551 .26302 .57294 .23374 .55907 .27858 Metetra
.108 0 .122 r
.55907 .27858 .57294 .23374 .60039 .20857 .58726 .24764 Metetra
.073 0 .077 r
.58726 .24764 .60039 .20857 .62801 .1882 .61539 .21811 Metetra
.61539 .21811 .62801 .1882 .65596 .1731 .64354 .19065 Metetra
.64354 .19065 .65596 .1731 .68439 .16352 .67179 .16584 Metetra
.673 .973 .806 r
.67179 .16584 .68439 .16352 .71348 .15943 .70023 .14413 Metetra
.765 .832 .903 r
.70023 .14413 .71348 .15943 .74338 .16061 .72901 .12587 Metetra
.67 .614 .783 r
.72901 .12587 .74338 .16061 .77422 .16657 .75823 .11132 Metetra
.06 .466 .885 r
.09428 .43356 .11221 .44921 .13399 .46189 .11657 .44195 Metetra
.194 .486 .899 r
.11657 .44195 .13399 .46189 .15634 .47407 .13937 .4501 Metetra
.294 .493 .882 r
.13937 .4501 .15634 .47407 .17937 .48492 .16271 .4576 Metetra
.366 .499 .86 r
.16271 .4576 .17937 .48492 .20313 .49367 .18665 .46403 Metetra
.419 .509 .844 r
.18665 .46403 .20313 .49367 .22765 .49958 .21121 .46898 Metetra
.461 .526 .838 r
.21121 .46898 .22765 .49958 .25293 .502 .2364 .47208 Metetra
.499 .553 .843 r
.2364 .47208 .25293 .502 .27894 .50043 .2622 .47298 Metetra
.535 .595 .86 r
.2622 .47298 .27894 .50043 .30561 .49451 .28861 .47139 Metetra
.573 .656 .893 r
.28861 .47139 .30561 .49451 .33286 .48409 .31559 .46709 Metetra
.612 .746 .941 r
.31559 .46709 .33286 .48409 .36059 .4692 .34307 .45992 Metetra
.637 .864 .984 r
.34307 .45992 .36059 .4692 .38867 .45008 .37102 .44979 Metetra
.577 .936 .925 r
.37102 .44979 .38867 .45008 .41699 .42713 .39936 .43672 Metetra
.352 .792 .627 r
.39936 .43672 .41699 .42713 .44545 .40094 .42801 .42079 Metetra
.42801 .42079 .44545 .40094 .47395 .37219 .4569 .40216 Metetra
.051 0 0 r
.4569 .40216 .47395 .37219 .50241 .34167 .48597 .38108 Metetra
.141 0 .074 r
.48597 .38108 .50241 .34167 .53079 .31019 .51515 .35785 Metetra
.196 0 .151 r
.51515 .35785 .53079 .31019 .55907 .27858 .54438 .33281 Metetra
.229 0 .198 r
.54438 .33281 .55907 .27858 .58726 .24764 .57362 .30637 Metetra
.249 0 .226 r
.57362 .30637 .58726 .24764 .61539 .21811 .60284 .27893 Metetra
.259 0 .24 r
.60284 .27893 .61539 .21811 .64354 .19065 .63203 .25094 Metetra
.259 0 .242 r
.63203 .25094 .64354 .19065 .67179 .16584 .66119 .22281 Metetra
.25 0 .23 r
.66119 .22281 .67179 .16584 .70023 .14413 .69034 .19496 Metetra
.227 0 .202 r
.69034 .19496 .70023 .14413 .72901 .12587 .71952 .1678 Metetra
.18 0 .144 r
.71952 .1678 .72901 .12587 .75823 .11132 .74876 .14167 Metetra
.278 .596 .949 r
.07603 .41763 .09428 .43356 .11657 .44195 .0989 .42167 Metetra
.355 .575 .924 r
.0989 .42167 .11657 .44195 .13937 .4501 .12219 .42562 Metetra
.407 .552 .888 r
.12219 .42562 .13937 .4501 .16271 .4576 .14594 .42929 Metetra
.443 .534 .855 r
.14594 .42929 .16271 .4576 .18665 .46403 .17018 .43251 Metetra
.468 .522 .83 r
.17018 .43251 .18665 .46403 .21121 .46898 .19491 .43509 Metetra
.489 .518 .814 r
.19491 .43509 .21121 .46898 .2364 .47208 .22015 .43686 Metetra
.506 .521 .806 r
.22015 .43686 .2364 .47208 .2622 .47298 .24591 .43765 Metetra
.522 .531 .805 r
.24591 .43765 .2622 .47298 .28861 .47139 .27218 .43731 Metetra
.539 .549 .814 r
.27218 .43731 .28861 .47139 .31559 .46709 .29895 .43569 Metetra
.556 .579 .832 r
.29895 .43569 .31559 .46709 .34307 .45992 .32622 .43266 Metetra
.575 .624 .863 r
.32622 .43266 .34307 .45992 .37102 .44979 .35397 .4281 Metetra
.595 .691 .909 r
.35397 .4281 .37102 .44979 .39936 .43672 .38216 .42193 Metetra
.609 .785 .966 r
.38216 .42193 .39936 .43672 .42801 .42079 .41077 .41407 Metetra
.577 .887 .99 r
.41077 .41407 .42801 .42079 .4569 .40216 .43976 .4045 Metetra
.405 .858 .827 r
.43976 .4045 .4569 .40216 .48597 .38108 .46909 .39318 Metetra
.46909 .39318 .48597 .38108 .51515 .35785 .49873 .38014 Metetra
.072 0 0 r
.49873 .38014 .51515 .35785 .54438 .33281 .52864 .3654 Metetra
.186 0 .029 r
.52864 .3654 .54438 .33281 .57362 .30637 .55877 .34905 Metetra
.251 0 .136 r
.55877 .34905 .57362 .30637 .60284 .27893 .58908 .33116 Metetra
.291 0 .203 r
.58908 .33116 .60284 .27893 .63203 .25094 .61954 .31184 Metetra
.317 0 .247 r
.61954 .31184 .63203 .25094 .66119 .22281 .65011 .29123 Metetra
.335 .021 .276 r
.65011 .29123 .66119 .22281 .69034 .19496 .68077 .26947 Metetra
.347 .041 .297 r
.68077 .26947 .69034 .19496 .71952 .1678 .7115 .24672 Metetra
.354 .054 .31 r
.7115 .24672 .71952 .1678 .74876 .14167 .74228 .22317 Metetra
.448 .679 .963 r
.05745 .40141 .07603 .41763 .0989 .42167 .08095 .40107 Metetra
.483 .637 .922 r
.08095 .40107 .0989 .42167 .12219 .42562 .10481 .40067 Metetra
.504 .599 .881 r
.10481 .40067 .12219 .42562 .14594 .42929 .12905 .40016 Metetra
.517 .568 .846 r
.12905 .40016 .14594 .42929 .17018 .43251 .15369 .39949 Metetra
.525 .544 .817 r
.15369 .39949 .17018 .43251 .19491 .43509 .17873 .3986 Metetra
.531 .526 .795 r
.17873 .3986 .19491 .43509 .22015 .43686 .20418 .39744 Metetra
.536 .514 .778 r
.20418 .39744 .22015 .43686 .24591 .43765 .23005 .39595 Metetra
.541 .507 .767 r
.23005 .39595 .24591 .43765 .27218 .43731 .25634 .39408 Metetra
.545 .503 .76 r
.25634 .39408 .27218 .43731 .29895 .43569 .28307 .39177 Metetra
.55 .505 .758 r
.28307 .39177 .29895 .43569 .32622 .43266 .31022 .38898 Metetra
.555 .51 .76 r
.31022 .38898 .32622 .43266 .35397 .4281 .33781 .38566 Metetra
.561 .521 .768 r
.33781 .38566 .35397 .4281 .38216 .42193 .36584 .38174 Metetra
.568 .537 .781 r
.36584 .38174 .38216 .42193 .41077 .41407 .39429 .3772 Metetra
.576 .562 .801 r
.39429 .3772 .41077 .41407 .43976 .4045 .42316 .37198 Metetra
.586 .597 .83 r
.42316 .37198 .43976 .4045 .46909 .39318 .45245 .36605 Metetra
.597 .647 .871 r
.45245 .36605 .46909 .39318 .49873 .38014 .48214 .35937 Metetra
.604 .719 .926 r
.48214 .35937 .49873 .38014 .52864 .3654 .51223 .35192 Metetra
.592 .813 .984 r
.51223 .35192 .52864 .3654 .55877 .34905 .54271 .34365 Metetra
.503 .88 .973 r
.54271 .34365 .55877 .34905 .58908 .33116 .57355 .33456 Metetra
.267 .768 .735 r
.57355 .33456 .58908 .33116 .61954 .31184 .60476 .32462 Metetra
.60476 .32462 .61954 .31184 .65011 .29123 .63629 .31382 Metetra
.164 0 0 r
.63629 .31382 .65011 .29123 .68077 .26947 .66816 .30216 Metetra
.256 0 .055 r
.66816 .30216 .68077 .26947 .7115 .24672 .70032 .28963 Metetra
.31 0 .153 r
.70032 .28963 .7115 .24672 .74228 .22317 .73278 .27625 Metetra
.57 .727 .948 r
.03853 .3849 .05745 .40141 .08095 .40107 .06272 .38012 Metetra
.58 .676 .906 r
.06272 .38012 .08095 .40107 .10481 .40067 .08722 .37528 Metetra
.583 .633 .867 r
.08722 .37528 .10481 .40067 .12905 .40016 .11203 .37037 Metetra
.582 .596 .832 r
.11203 .37037 .12905 .40016 .15369 .39949 .13716 .36537 Metetra
.58 .566 .803 r
.13716 .36537 .15369 .39949 .17873 .3986 .16262 .36028 Metetra
.577 .542 .779 r
.16262 .36028 .17873 .3986 .20418 .39744 .18841 .3551 Metetra
.574 .522 .759 r
.18841 .3551 .20418 .39744 .23005 .39595 .21454 .3498 Metetra
.572 .506 .742 r
.21454 .3498 .23005 .39595 .25634 .39408 .24102 .34439 Metetra
.57 .493 .729 r
.24102 .34439 .25634 .39408 .28307 .39177 .26785 .33886 Metetra
.568 .482 .718 r
.26785 .33886 .28307 .39177 .31022 .38898 .29504 .3332 Metetra
.567 .474 .709 r
.29504 .3332 .31022 .38898 .33781 .38566 .3226 .32739 Metetra
.566 .468 .702 r
.3226 .32739 .33781 .38566 .36584 .38174 .35052 .32144 Metetra
.565 .463 .697 r
.35052 .32144 .36584 .38174 .39429 .3772 .37882 .31533 Metetra
.565 .46 .693 r
.37882 .31533 .39429 .3772 .42316 .37198 .4075 .30905 Metetra
.565 .459 .692 r
.4075 .30905 .42316 .37198 .45245 .36605 .43657 .3026 Metetra
.566 .459 .691 r
.43657 .3026 .45245 .36605 .48214 .35937 .46603 .29596 Metetra
.567 .46 .692 r
.46603 .29596 .48214 .35937 .51223 .35192 .49589 .28913 Metetra
.568 .464 .695 r
.49589 .28913 .51223 .35192 .54271 .34365 .52616 .2821 Metetra
.57 .469 .7 r
.52616 .2821 .54271 .34365 .57355 .33456 .55683 .27486 Metetra
.573 .476 .707 r
.55683 .27486 .57355 .33456 .60476 .32462 .58791 .2674 Metetra
.576 .486 .716 r
.58791 .2674 .60476 .32462 .63629 .31382 .61941 .25971 Metetra
.58 .499 .728 r
.61941 .25971 .63629 .31382 .66816 .30216 .65133 .25178 Metetra
.585 .516 .744 r
.65133 .25178 .66816 .30216 .70032 .28963 .68367 .24361 Metetra
.591 .538 .764 r
.68367 .24361 .70032 .28963 .73278 .27625 .71645 .23519 Metetra
.656 .751 .92 r
.01926 .36808 .03853 .3849 .06272 .38012 .0442 .35884 Metetra
.651 .701 .883 r
.0442 .35884 .06272 .38012 .08722 .37528 .0694 .34951 Metetra
.644 .657 .848 r
.0694 .34951 .08722 .37528 .11203 .37037 .09484 .34009 Metetra
.636 .62 .817 r
.09484 .34009 .11203 .37037 .13716 .36537 .12055 .33057 Metetra
.628 .588 .79 r
.12055 .33057 .13716 .36537 .16262 .36028 .14652 .32095 Metetra
.62 .561 .766 r
.14652 .32095 .16262 .36028 .18841 .3551 .17275 .31124 Metetra
.613 .538 .746 r
.17275 .31124 .18841 .3551 .21454 .3498 .19925 .30142 Metetra
.606 .518 .728 r
.19925 .30142 .21454 .3498 .24102 .34439 .22603 .2915 Metetra
.6 .501 .713 r
.22603 .2915 .24102 .34439 .26785 .33886 .25309 .28148 Metetra
.595 .486 .699 r
.25309 .28148 .26785 .33886 .29504 .3332 .28042 .27136 Metetra
.59 .472 .687 r
.28042 .27136 .29504 .3332 .3226 .32739 .30805 .26113 Metetra
.586 .461 .676 r
.30805 .26113 .3226 .32739 .35052 .32144 .33597 .25079 Metetra
.582 .45 .667 r
.33597 .25079 .35052 .32144 .37882 .31533 .36418 .24034 Metetra
.578 .441 .658 r
.36418 .24034 .37882 .31533 .4075 .30905 .3927 .22978 Metetra
.575 .433 .651 r
.3927 .22978 .4075 .30905 .43657 .3026 .42152 .2191 Metetra
.572 .426 .644 r
.42152 .2191 .43657 .3026 .46603 .29596 .45066 .20831 Metetra
.569 .419 .638 r
.45066 .20831 .46603 .29596 .49589 .28913 .48011 .1974 Metetra
.567 .413 .632 r
.48011 .1974 .49589 .28913 .52616 .2821 .50988 .18638 Metetra
.565 .408 .627 r
.50988 .18638 .52616 .2821 .55683 .27486 .53998 .17523 Metetra
.563 .403 .622 r
.53998 .17523 .55683 .27486 .58791 .2674 .57041 .16396 Metetra
.561 .399 .618 r
.57041 .16396 .58791 .2674 .61941 .25971 .60118 .15257 Metetra
.559 .394 .614 r
.60118 .15257 .61941 .25971 .65133 .25178 .63229 .14104 Metetra
.558 .391 .611 r
.63229 .14104 .65133 .25178 .68367 .24361 .66375 .12939 Metetra
.556 .388 .608 r
.66375 .12939 .68367 .24361 .71645 .23519 .69556 .11761 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AmbientLight"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, \(3  Pi\)\/2}, {y, 0, \(3  Pi\)\/2}, \ 
      AmbientLight\  -> \ Hue[1]]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AmbientLight"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.49366e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.15339 .19666 -5.94672 -9 ]
[.15339 .19666 .05328 0 ]
[.2857 .14461 -5.68126 -9 ]
[.2857 .14461 .31874 0 ]
[.42503 .08982 -5.4158 -9 ]
[.42503 .08982 .5842 0 ]
[.57193 .03208 -5.15034 -9 ]
[.57193 .03208 .84966 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.77131 .10294 0 -6.15612 ]
[.77131 .10294 6 2.84388 ]
[.83516 .20071 0 -6.0622 ]
[.83516 .20071 6 2.9378 ]
[.89336 .28984 0 -5.97836 ]
[.89336 .28984 6 3.02164 ]
[.94663 .37142 0 -5.90306 ]
[.94663 .37142 6 3.09694 ]
[.02411 .2651 -12 -2.74231 ]
[.02411 .2651 0 6.25769 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48796 -6 -2.93176 ]
[-0.01144 .48796 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.759 .10747 m
.75284 .10974 L
s
[(1)] .77131 .10294 -1 .36803 Mshowa
.82276 .20501 m
.81656 .20717 L
s
[(2)] .83516 .20071 -1 .34716 Mshowa
.88089 .29393 m
.87466 .29598 L
s
[(3)] .89336 .28984 -1 .32852 Mshowa
.93411 .37533 m
.92784 .37728 L
s
[(4)] .94663 .37142 -1 .31179 Mshowa
.125 Mabswid
.70336 .02236 m
.69968 .02378 L
s
.71768 .04428 m
.714 .04568 L
s
.73173 .06576 m
.72804 .06715 L
s
.7455 .08682 m
.74181 .0882 L
s
.77224 .12773 m
.76854 .12908 L
s
.78523 .1476 m
.78153 .14893 L
s
.79798 .1671 m
.79427 .16842 L
s
.81049 .18623 m
.80677 .18754 L
s
.83481 .22345 m
.83109 .22473 L
s
.84665 .24155 m
.84292 .24282 L
s
.85827 .25933 m
.85454 .26058 L
s
.86968 .27678 m
.86595 .27803 L
s
.89191 .31078 m
.88817 .312 L
s
.90273 .32734 m
.89899 .32855 L
s
.91337 .34361 m
.90962 .34481 L
s
.92383 .35961 m
.92007 .36079 L
s
.94421 .39079 m
.94045 .39195 L
s
.95415 .40599 m
.95039 .40714 L
s
.96393 .42094 m
.96016 .42208 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25794 L
s
[(-1)] .02411 .2651 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48364 m
.00714 .48148 L
s
[(1)] -0.01144 .48796 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .28129 m
.03669 .27987 L
s
.03134 .29188 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40055 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43643 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .47171 m
.00655 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
1 .58 .321 r
.38853 .69037 .40169 .70185 .4213 .77838 .40801 .76464 Metetra
1 .265 .755 r
.40801 .76464 .4213 .77838 .44359 .78967 .43022 .78043 Metetra
1 .761 .683 r
.43022 .78043 .44359 .78967 .4676 .71984 .45443 .71926 Metetra
1 .775 .624 r
.45443 .71926 .4676 .71984 .49125 .62349 .47858 .62499 Metetra
1 .829 .667 r
.47858 .62499 .49125 .62349 .51378 .57147 .50155 .56248 Metetra
1 .541 .915 r
.50155 .56248 .51378 .57147 .53615 .59682 .52395 .56943 Metetra
1 .466 0 r
.52395 .56943 .53615 .59682 .55967 .67724 .5471 .63738 Metetra
1 0 .213 r
.5471 .63738 .55967 .67724 .58435 .74586 .57159 .71503 Metetra
1 .33 .763 r
.57159 .71503 .58435 .74586 .60848 .73841 .59634 .73764 Metetra
1 .851 .682 r
.59634 .73764 .60848 .73841 .6305 .65527 .61955 .6808 Metetra
1 .855 .45 r
.61955 .6808 .6305 .65527 .65127 .56135 .64095 .58487 Metetra
1 .853 .396 r
.64095 .58487 .65127 .56135 .67351 .52377 .66241 .51623 Metetra
1 .737 .992 r
.66241 .51623 .67351 .52377 .69957 .56463 .68653 .51656 Metetra
1 0 .547 r
.68653 .51656 .69957 .56463 .72914 .65005 .71456 .58147 Metetra
1 .048 .561 r
.71456 .58147 .72914 .65005 .75841 .70735 .74486 .66201 Metetra
1 .328 .713 r
.74486 .66201 .75841 .70735 .78268 .68051 .77309 .69145 Metetra
1 .924 .541 r
.77309 .69145 .78268 .68051 .80145 .58681 .79573 .63943 Metetra
1 0 .101 r
.79573 .63943 .80145 .58681 .81963 .49861 .81404 .5423 Metetra
1 0 .128 r
.81404 .5423 .81963 .49861 .8432 .4769 .8333 .46765 Metetra
1 .812 .972 r
.8333 .46765 .8432 .4769 .8748 .53214 .85865 .4611 Metetra
1 .223 .637 r
.85865 .4611 .8748 .53214 .91119 .61927 .89169 .52242 Metetra
1 .209 .613 r
.89169 .52242 .91119 .61927 .94401 .66208 .92863 .60533 Metetra
1 .329 .691 r
.92863 .60533 .94401 .66208 .96648 .61601 .96141 .64155 Metetra
1 0 .053 r
.96141 .64155 .96648 .61601 .98107 .51498 .98404 .59481 Metetra
1 .574 .312 r
.37517 .67871 .38853 .69037 .40801 .76464 .39453 .75059 Metetra
1 .102 .611 r
.39453 .75059 .40801 .76464 .43022 .78043 .41664 .77041 Metetra
1 .765 .704 r
.41664 .77041 .43022 .78043 .45443 .71926 .44099 .718 Metetra
1 .776 .63 r
.44099 .718 .45443 .71926 .47858 .62499 .46559 .62748 Metetra
1 .821 .65 r
.46559 .62748 .47858 .62499 .50155 .56248 .48907 .55682 Metetra
1 .878 .956 r
.48907 .55682 .50155 .56248 .52395 .56943 .51165 .54614 Metetra
1 .369 0 r
.51165 .54614 .52395 .56943 .5471 .63738 .53455 .59809 Metetra
1 .403 0 r
.53455 .59809 .5471 .63738 .57159 .71503 .5587 .67672 Metetra
1 .013 .578 r
.5587 .67672 .57159 .71503 .59634 .73764 .5837 .72375 Metetra
1 .77 .804 r
.5837 .72375 .59634 .73764 .61955 .6808 .60798 .69879 Metetra
1 .876 .523 r
.60798 .69879 .61955 .6808 .64095 .58487 .63042 .6153 Metetra
1 .826 .354 r
.63042 .6153 .64095 .58487 .66241 .51623 .65184 .52822 Metetra
1 .932 .558 r
.65184 .52822 .66241 .51623 .68653 .51656 .6745 .48954 Metetra
1 .227 .73 r
.6745 .48954 .68653 .51656 .71456 .58147 .70046 .51834 Metetra
1 .039 .561 r
.70046 .51834 .71456 .58147 .74486 .66201 .72994 .59342 Metetra
1 .136 .605 r
.72994 .59342 .74486 .66201 .77309 .69145 .76039 .66122 Metetra
1 .514 .799 r
.76039 .66122 .77309 .69145 .79573 .63943 .78758 .66721 Metetra
1 0 0 r
.78758 .66721 .79573 .63943 .81404 .5423 .8092 .60086 Metetra
1 0 .184 r
.8092 .60086 .81404 .5423 .8333 .46765 .82755 .50588 Metetra
1 0 .113 r
.82755 .50588 .8333 .46765 .85865 .4611 .84777 .44158 Metetra
1 .611 .876 r
.84777 .44158 .85865 .4611 .89169 .52242 .87433 .44279 Metetra
1 .242 .634 r
.87433 .44279 .89169 .52242 .92863 .60533 .90825 .50461 Metetra
1 .227 .617 r
.90825 .50461 .92863 .60533 .96141 .64155 .94573 .58394 Metetra
1 .33 .69 r
.94573 .58394 .96141 .64155 .98404 .59481 .97924 .62007 Metetra
1 .568 .301 r
.36161 .66687 .37517 .67871 .39453 .75059 .38087 .73621 Metetra
1 .029 0 r
.38087 .73621 .39453 .75059 .41664 .77041 .40285 .75957 Metetra
1 .769 .729 r
.40285 .75957 .41664 .77041 .44099 .718 .42727 .71591 Metetra
1 .779 .639 r
.42727 .71591 .44099 .718 .46559 .62748 .45227 .63063 Metetra
1 .816 .64 r
.45227 .63063 .46559 .62748 .48907 .55682 .4763 .5543 Metetra
1 .901 .827 r
.4763 .5543 .48907 .55682 .51165 .54614 .49921 .52748 Metetra
1 0 .402 r
.49921 .52748 .51165 .54614 .53455 .59809 .52199 .56127 Metetra
1 .386 0 r
.52199 .56127 .53455 .59809 .5587 .67672 .54575 .63357 Metetra
1 0 .435 r
.54575 .63357 .5587 .67672 .5837 .72375 .5707 .69681 Metetra
1 .51 .821 r
.5707 .69681 .5837 .72375 .60798 .69879 .59574 .70414 Metetra
1 .894 .654 r
.59574 .70414 .60798 .69879 .63042 .6153 .61939 .6452 Metetra
1 .839 .381 r
.61939 .6452 .63042 .6153 .65184 .52822 .64145 .55539 Metetra
1 .807 .32 r
.64145 .55539 .65184 .52822 .6745 .48954 .6634 .48667 Metetra
1 .947 .957 r
.6634 .48667 .6745 .48954 .70046 .51834 .68742 .47405 Metetra
1 .142 .642 r
.68742 .47405 .70046 .51834 .72994 .59342 .71495 .52066 Metetra
1 .095 .581 r
.71495 .52066 .72994 .59342 .76039 .66122 .74541 .59666 Metetra
1 .208 .64 r
.74541 .59666 .76039 .66122 .78758 .66721 .7758 .65063 Metetra
1 .728 .882 r
.7758 .65063 .78758 .66721 .8092 .60086 .80227 .64058 Metetra
1 0 .046 r
.80227 .64058 .8092 .60086 .82755 .50588 .82345 .56802 Metetra
1 0 .236 r
.82345 .56802 .82755 .50588 .84777 .44158 .84203 .47677 Metetra
1 0 .102 r
.84203 .47677 .84777 .44158 .87433 .44279 .86289 .41805 Metetra
1 .565 .831 r
.86289 .41805 .87433 .44279 .90825 .50461 .89002 .42024 Metetra
1 .264 .636 r
.89002 .42024 .90825 .50461 .94573 .58394 .92431 .47827 Metetra
1 .242 .618 r
.92431 .47827 .94573 .58394 .97924 .62007 .96238 .55494 Metetra
1 .561 .289 r
.34784 .65485 .36161 .66687 .38087 .73621 .36702 .72151 Metetra
1 .125 0 r
.36702 .72151 .38087 .73621 .40285 .75957 .38886 .74791 Metetra
1 .772 .76 r
.38886 .74791 .40285 .75957 .42727 .71591 .41328 .71283 Metetra
1 .782 .65 r
.41328 .71283 .42727 .71591 .45227 .63063 .43861 .6341 Metetra
1 .814 .636 r
.43861 .6341 .45227 .63063 .4763 .5543 .4632 .55464 Metetra
1 .885 .744 r
.4632 .55464 .4763 .5543 .49921 .52748 .48656 .51375 Metetra
1 .32 .8 r
.48656 .51375 .49921 .52748 .52199 .56127 .50939 .52856 Metetra
1 0 .266 r
.50939 .52856 .52199 .56127 .54575 .63357 .53282 .5886 Metetra
1 0 .369 r
.53282 .5886 .54575 .63357 .5707 .69681 .5575 .65867 Metetra
1 .188 .683 r
.5575 .65867 .5707 .69681 .59574 .70414 .5829 .69363 Metetra
1 .82 .816 r
.5829 .69363 .59574 .70414 .61939 .6452 .60767 .66661 Metetra
1 .883 .478 r
.60767 .66661 .61939 .6452 .64145 .55539 .63083 .59009 Metetra
1 .775 .269 r
.63083 .59009 .64145 .55539 .6634 .48667 .65291 .50598 Metetra
1 .841 .391 r
.65291 .50598 .6634 .48667 .68742 .47405 .67565 .45642 Metetra
1 .568 .902 r
.67565 .45642 .68742 .47405 .71495 .52066 .70095 .46264 Metetra
1 .149 .623 r
.70095 .46264 .71495 .52066 .74541 .59666 .72972 .51824 Metetra
1 .143 .598 r
.72972 .51824 .74541 .59666 .7758 .65063 .76087 .59068 Metetra
1 .262 .666 r
.76087 .59068 .7758 .65063 .80227 .64058 .79126 .63383 Metetra
1 .915 .919 r
.79126 .63383 .80227 .64058 .82345 .56802 .81749 .61548 Metetra
1 0 .156 r
.81749 .61548 .82345 .56802 .84203 .47677 .83868 .54224 Metetra
1 0 .274 r
.83868 .54224 .84203 .47677 .86289 .41805 .85756 .45429 Metetra
1 0 .127 r
.85756 .45429 .86289 .41805 .89002 .42024 .87864 .39621 Metetra
1 .606 .833 r
.87864 .39621 .89002 .42024 .92431 .47827 .90567 .39338 Metetra
1 .29 .642 r
.90567 .39338 .92431 .47827 .96238 .55494 .93976 .44352 Metetra
1 .553 .275 r
.33385 .64264 .34784 .65485 .36702 .72151 .35297 .70649 Metetra
1 .192 0 r
.35297 .70649 .36702 .72151 .38886 .74791 .37468 .7354 Metetra
1 .772 .796 r
.37468 .7354 .38886 .74791 .41328 .71283 .39904 .70861 Metetra
1 .786 .665 r
.39904 .70861 .41328 .71283 .43861 .6341 .42462 .63752 Metetra
1 .814 .637 r
.42462 .63752 .43861 .6341 .4632 .55464 .44974 .55744 Metetra
1 .871 .696 r
.44974 .55744 .4632 .55464 .48656 .51375 .47364 .50506 Metetra
1 .79 .985 r
.47364 .50506 .48656 .51375 .50939 .52856 .4967 .50127 Metetra
1 0 .417 r
.4967 .50127 .50939 .52856 .53282 .5886 .51993 .54485 Metetra
1 0 .365 r
.51993 .54485 .53282 .5886 .5575 .65867 .54422 .61264 Metetra
1 0 .553 r
.54422 .61264 .5575 .65867 .5829 .69363 .56963 .66666 Metetra
1 .524 .826 r
.56963 .66666 .5829 .69363 .60767 .66661 .59518 .67259 Metetra
1 .932 .677 r
.59518 .67259 .60767 .66661 .63083 .59009 .61962 .62242 Metetra
1 .804 .313 r
.61962 .62242 .63083 .59009 .65291 .50598 .64254 .5406 Metetra
1 0 0 r
.64254 .5406 .65291 .50598 .67565 .45642 .6649 .46663 Metetra
1 .94 .591 r
.6649 .46663 .67565 .45642 .70095 .46264 .68847 .43244 Metetra
1 .396 .785 r
.68847 .43244 .70095 .46264 .72972 .51824 .71486 .45002 Metetra
1 .176 .62 r
.71486 .45002 .72972 .51824 .76087 .59068 .74457 .50842 Metetra
1 .18 .609 r
.74457 .50842 .76087 .59068 .79126 .63383 .77627 .57629 Metetra
1 .293 .68 r
.77627 .57629 .79126 .63383 .81749 .61548 .80692 .61346 Metetra
1 .985 .902 r
.80692 .61346 .81749 .61548 .83868 .54224 .83344 .59379 Metetra
1 0 .216 r
.83344 .59379 .83868 .54224 .85756 .45429 .85509 .52395 Metetra
1 0 .307 r
.85509 .52395 .85756 .45429 .87864 .39621 .87429 .43855 Metetra
1 0 .192 r
.87429 .43855 .87864 .39621 .90567 .39338 .89518 .37696 Metetra
1 .751 .875 r
.89518 .37696 .90567 .39338 .93976 .44352 .92143 .36379 Metetra
1 .544 .259 r
.31963 .63024 .33385 .64264 .35297 .70649 .33873 .69114 Metetra
1 .237 0 r
.33873 .69114 .35297 .70649 .37468 .7354 .36029 .72203 Metetra
1 .767 .837 r
.36029 .72203 .37468 .7354 .39904 .70861 .38454 .7031 Metetra
1 .79 .684 r
.38454 .7031 .39904 .70861 .42462 .63752 .41028 .64048 Metetra
1 .816 .643 r
.41028 .64048 .42462 .63752 .44974 .55744 .43588 .5622 Metetra
1 .863 .669 r
.43588 .5622 .44974 .55744 .47364 .50506 .46038 .50124 Metetra
1 .91 .878 r
.46038 .50124 .47364 .50506 .4967 .50127 .48383 .48033 Metetra
1 .134 .681 r
.48383 .48033 .4967 .50127 .51993 .54485 .50704 .50512 Metetra
1 0 .42 r
.50704 .50512 .51993 .54485 .54422 .61264 .53098 .5629 Metetra
1 0 .493 r
.53098 .5629 .54422 .61264 .56963 .66666 .55611 .62544 Metetra
1 .22 .691 r
.55611 .62544 .56963 .66666 .59518 .67259 .58202 .65902 Metetra
1 .786 .867 r
.58202 .65902 .59518 .67259 .61962 .62242 .60756 .64209 Metetra
1 .897 .481 r
.60756 .64209 .61962 .62242 .64254 .5406 .63177 .57946 Metetra
1 0 0 r
.63177 .57946 .64254 .5406 .6649 .46663 .65467 .49906 Metetra
1 0 0 r
.65467 .49906 .6649 .46663 .68847 .43244 .67744 .43477 Metetra
1 1 .813 r
.67744 .43477 .68847 .43244 .71486 .45002 .70175 .41049 Metetra
1 .354 .736 r
.70175 .41049 .71486 .45002 .74457 .50842 .72895 .43291 Metetra
1 .206 .623 r
.72895 .43291 .74457 .50842 .77627 .57629 .75934 .49015 Metetra
1 .207 .616 r
.75934 .49015 .77627 .57629 .80692 .61346 .79158 .55419 Metetra
1 .3 .68 r
.79158 .55419 .80692 .61346 .83344 .59379 .82284 .59042 Metetra
1 .959 .947 r
.82284 .59042 .83344 .59379 .85509 .52395 .85023 .57555 Metetra
1 0 .244 r
.85023 .57555 .85509 .52395 .87429 .43855 .8728 .51298 Metetra
1 0 .335 r
.8728 .51298 .87429 .43855 .89518 .37696 .89245 .43048 Metetra
1 0 .271 r
.89245 .43048 .89518 .37696 .92143 .36379 .91288 .36281 Metetra
1 .533 .24 r
.3052 .61764 .31963 .63024 .33873 .69114 .32428 .67547 Metetra
1 .267 0 r
.32428 .67547 .33873 .69114 .36029 .72203 .34571 .70781 Metetra
1 .75 .88 r
.34571 .70781 .36029 .72203 .38454 .7031 .3698 .6962 Metetra
1 .795 .708 r
.3698 .6962 .38454 .7031 .41028 .64048 .39561 .64261 Metetra
1 .819 .653 r
.39561 .64261 .41028 .64048 .43588 .5622 .42162 .56834 Metetra
1 .859 .655 r
.42162 .56834 .43588 .5622 .46038 .50124 .44672 .50192 Metetra
1 .916 .775 r
.44672 .50192 .46038 .50124 .48383 .48033 .4707 .46626 Metetra
1 .591 .94 r
.4707 .46626 .48383 .48033 .50704 .50512 .49409 .47169 Metetra
1 0 .544 r
.49409 .47169 .50704 .50512 .53098 .5629 .5178 .51387 Metetra
1 0 .495 r
.5178 .51387 .53098 .5629 .55611 .62544 .54254 .57448 Metetra
1 .067 .594 r
.54254 .57448 .55611 .62544 .58202 .65902 .56839 .6257 Metetra
1 .413 .783 r
.56839 .6257 .58202 .65902 .60756 .64209 .59463 .64102 Metetra
1 .948 .813 r
.59463 .64102 .60756 .64209 .63177 .57946 .62015 .60932 Metetra
1 .779 .288 r
.62015 .60932 .63177 .57946 .65467 .49906 .64428 .54186 Metetra
1 0 0 r
.64428 .54186 .65467 .49906 .67744 .43477 .66734 .46535 Metetra
1 0 0 r
.66734 .46535 .67744 .43477 .70175 .41049 .69052 .40786 Metetra
1 .971 .9 r
.69052 .40786 .70175 .41049 .72895 .43291 .71536 .38787 Metetra
1 .361 .72 r
.71536 .38787 .72895 .43291 .75934 .49015 .74308 .40976 Metetra
1 .235 .628 r
.74308 .40976 .75934 .49015 .79158 .55419 .77391 .46304 Metetra
1 .228 .618 r
.77391 .46304 .79158 .55419 .82284 .59042 .80669 .5242 Metetra
1 .292 .666 r
.80669 .5242 .82284 .59042 .85023 .57555 .8389 .56363 Metetra
1 .775 .976 r
.8389 .56363 .85023 .57555 .8728 .51298 .86774 .55897 Metetra
1 0 .237 r
.86774 .55897 .8728 .51298 .89245 .43048 .89185 .50824 Metetra
1 0 .356 r
.89185 .50824 .89245 .43048 .91288 .36281 .91237 .43117 Metetra
1 .519 .218 r
.29053 .60484 .3052 .61764 .32428 .67547 .30964 .65947 Metetra
1 .284 0 r
.30964 .65947 .32428 .67547 .34571 .70781 .33094 .69273 Metetra
1 .716 .917 r
.33094 .69273 .34571 .70781 .3698 .6962 .35484 .68777 Metetra
1 .799 .738 r
.35484 .68777 .3698 .6962 .39561 .64261 .38062 .6435 Metetra
1 .824 .668 r
.38062 .6435 .39561 .64261 .42162 .56834 .40693 .57518 Metetra
1 .859 .651 r
.40693 .57518 .42162 .56834 .44672 .50192 .43262 .50649 Metetra
1 .908 .712 r
.43262 .50649 .44672 .50192 .4707 .46626 .45721 .45915 Metetra
1 .871 .939 r
.45721 .45915 .4707 .46626 .49409 .47169 .48098 .44625 Metetra
1 .229 .741 r
.48098 .44625 .49409 .47169 .5178 .51387 .50465 .46963 Metetra
1 0 .552 r
.50465 .46963 .5178 .51387 .54254 .57448 .52902 .51959 Metetra
1 .024 .562 r
.52902 .51959 .54254 .57448 .56839 .6257 .55454 .57647 Metetra
1 .189 .659 r
.55454 .57647 .56839 .6257 .59463 .64102 .58098 .61582 Metetra
1 .569 .848 r
.58098 .61582 .59463 .64102 .62015 .60932 .60749 .61817 Metetra
1 .975 .67 r
.60749 .61817 .62015 .60932 .64428 .54186 .63309 .57898 Metetra
1 0 0 r
.63309 .57898 .64428 .54186 .66734 .46535 .65732 .51131 Metetra
1 0 .012 r
.65732 .51131 .66734 .46535 .69052 .40786 .68061 .43872 Metetra
1 0 0 r
.68061 .43872 .69052 .40786 .71536 .38787 .70412 .38444 Metetra
1 .964 .897 r
.70412 .38444 .71536 .38787 .74308 .40976 .72927 .36367 Metetra
1 .394 .723 r
.72927 .36367 .74308 .40976 .77391 .46304 .75718 .38047 Metetra
1 .266 .634 r
.75718 .38047 .77391 .46304 .80669 .5242 .78818 .42713 Metetra
1 .246 .618 r
.78818 .42713 .80669 .5242 .8389 .56363 .82142 .48528 Metetra
1 .28 .647 r
.82142 .48528 .8389 .56363 .86774 .55897 .85479 .53018 Metetra
1 .498 .829 r
.85479 .53018 .86774 .55897 .89185 .50824 .88562 .53997 Metetra
1 0 .145 r
.88562 .53997 .89185 .50824 .91237 .43117 .91205 .50658 Metetra
1 .503 .191 r
.27563 .59183 .29053 .60484 .30964 .65947 .29478 .64315 Metetra
1 .29 0 r
.29478 .64315 .30964 .65947 .33094 .69273 .31598 .67679 Metetra
1 .655 .937 r
.31598 .67679 .33094 .69273 .35484 .68777 .33966 .67775 Metetra
1 .801 .774 r
.33966 .67775 .35484 .68777 .38062 .6435 .36533 .64276 Metetra
1 .83 .689 r
.36533 .64276 .38062 .6435 .40693 .57518 .39184 .58199 Metetra
1 .862 .655 r
.39184 .58199 .40693 .57518 .43262 .50649 .41804 .51414 Metetra
1 .903 .676 r
.41804 .51414 .43262 .50649 .45721 .45915 .44328 .45867 Metetra
1 .938 .824 r
.44328 .45867 .45721 .45915 .48098 .44625 .46758 .42979 Metetra
1 .607 .926 r
.46758 .42979 .48098 .44625 .50465 .46963 .49144 .43353 Metetra
1 .144 .665 r
.49144 .43353 .50465 .46963 .52902 .51959 .51561 .46688 Metetra
1 .055 .583 r
.51561 .46688 .52902 .51959 .55454 .57647 .5407 .51817 Metetra
1 .113 .606 r
.5407 .51817 .55454 .57647 .58098 .61582 .56692 .56899 Metetra
1 .274 .699 r
.56692 .56899 .58098 .61582 .60749 .61817 .59387 .59916 Metetra
1 .68 .895 r
.59387 .59916 .60749 .61817 .63309 .57898 .62069 .59448 Metetra
1 .892 .5 r
.62069 .59448 .63309 .57898 .65732 .51131 .64652 .55351 Metetra
1 0 0 r
.64652 .55351 .65732 .51131 .68061 .43872 .67101 .48837 Metetra
1 0 .086 r
.67101 .48837 .68061 .43872 .70412 .38444 .69459 .41889 Metetra
1 0 0 r
.69459 .41889 .70412 .38444 .72927 .36367 .71834 .36455 Metetra
1 .999 .819 r
.71834 .36455 .72927 .36367 .75718 .38047 .74353 .33876 Metetra
1 .457 .744 r
.74353 .33876 .75718 .38047 .78818 .42713 .77128 .34639 Metetra
1 .303 .644 r
.77128 .34639 .78818 .42713 .82142 .48528 .80209 .38319 Metetra
1 .267 .619 r
.80209 .38319 .82142 .48528 .85479 .53018 .83551 .43619 Metetra
1 .275 .63 r
.83551 .43619 .85479 .53018 .88562 .53997 .86998 .48596 Metetra
1 .354 .708 r
.86998 .48596 .88562 .53997 .91205 .50658 .90311 .51207 Metetra
1 .484 .159 r
.26048 .57861 .27563 .59183 .29478 .64315 .27972 .6265 Metetra
1 .287 0 r
.27972 .6265 .29478 .64315 .31598 .67679 .30083 .66 Metetra
1 .568 .927 r
.30083 .66 .31598 .67679 .33966 .67775 .32429 .66604 Metetra
1 .797 .816 r
.32429 .66604 .33966 .67775 .36533 .64276 .34977 .64004 Metetra
1 .836 .718 r
.34977 .64004 .36533 .64276 .39184 .58199 .37634 .58799 Metetra
1 .868 .668 r
.37634 .58799 .39184 .58199 .41804 .51414 .40295 .52383 Metetra
1 .903 .66 r
.40295 .52383 .41804 .51414 .44328 .45867 .42883 .46403 Metetra
1 .943 .734 r
.42883 .46403 .44328 .45867 .46758 .42979 .45377 .42257 Metetra
1 .878 .928 r
.45377 .42257 .46758 .42979 .49144 .43353 .47804 .40788 Metetra
1 .412 .823 r
.47804 .40788 .49144 .43353 .51561 .46688 .50223 .4217 Metetra
1 .159 .652 r
.50223 .4217 .51561 .46688 .5407 .51817 .52698 .45894 Metetra
1 .122 .608 r
.52698 .45894 .5407 .51817 .56692 .56899 .55276 .50813 Metetra
1 .177 .632 r
.55276 .50813 .56692 .56899 .59387 .59916 .57961 .55333 Metetra
1 .321 .718 r
.57961 .55333 .59387 .59916 .62069 .59448 .60707 .57824 Metetra
1 .728 .923 r
.60707 .57824 .62069 .59448 .64652 .55351 .6343 .57197 Metetra
1 0 0 r
.6343 .57197 .64652 .55351 .67101 .48837 .66055 .53372 Metetra
1 0 .066 r
.66055 .53372 .67101 .48837 .69459 .41889 .68548 .47317 Metetra
1 0 .153 r
.68548 .47317 .69459 .41889 .71834 .36455 .70944 .40637 Metetra
1 0 .083 r
.70944 .40637 .71834 .36455 .74353 .33876 .73334 .34978 Metetra
1 .882 .514 r
.73334 .34978 .74353 .33876 .77128 .34639 .75836 .31585 Metetra
1 .579 .796 r
.75836 .31585 .77128 .34639 .80209 .38319 .7856 .31073 Metetra
1 .353 .662 r
.7856 .31073 .80209 .38319 .83551 .43619 .81576 .3337 Metetra
1 .294 .623 r
.81576 .3337 .83551 .43619 .86998 .48596 .84884 .37715 Metetra
1 .282 .619 r
.84884 .37715 .86998 .48596 .90311 .51207 .88392 .42743 Metetra
1 .459 .121 r
.24509 .56518 .26048 .57861 .27972 .6265 .26444 .60953 Metetra
1 .273 0 r
.26444 .60953 .27972 .6265 .30083 .66 .2855 .64237 Metetra
1 .466 .89 r
.2855 .64237 .30083 .66 .32429 .66604 .30873 .6526 Metetra
1 .782 .86 r
.30873 .6526 .32429 .66604 .34977 .64004 .33396 .63503 Metetra
1 .84 .754 r
.33396 .63503 .34977 .64004 .37634 .58799 .36048 .59241 Metetra
1 .876 .691 r
.36048 .59241 .37634 .58799 .40295 .52383 .38736 .53438 Metetra
1 .907 .658 r
.38736 .53438 .40295 .52383 .42883 .46403 .41381 .47407 Metetra
1 .94 .679 r
.41381 .47407 .42883 .46403 .45377 .42257 .43944 .42411 Metetra
1 .962 .813 r
.43944 .42411 .45377 .42257 .47804 .40788 .46429 .39389 Metetra
1 .742 .934 r
.46429 .39389 .47804 .40788 .50223 .4217 .48875 .38815 Metetra
1 .351 .766 r
.48875 .38815 .50223 .4217 .52698 .45894 .51338 .40652 Metetra
1 .198 .653 r
.51338 .40652 .52698 .45894 .55276 .50813 .53874 .44355 Metetra
1 .176 .624 r
.53874 .44355 .55276 .50813 .57961 .55333 .56515 .48922 Metetra
1 .218 .643 r
.56515 .48922 .57961 .55333 .60707 .57824 .59257 .53039 Metetra
1 .334 .716 r
.59257 .53039 .60707 .57824 .6343 .57197 .62056 .5539 Metetra
1 .688 .921 r
.62056 .5539 .6343 .57197 .66055 .53372 .64836 .55065 Metetra
1 0 0 r
.64836 .55065 .66055 .53372 .68548 .47317 .67525 .51899 Metetra
1 0 .114 r
.67525 .51899 .68548 .47317 .70944 .40637 .70085 .46543 Metetra
1 0 .21 r
.70085 .46543 .70944 .40637 .73334 .34978 .72534 .40218 Metetra
1 0 .187 r
.72534 .40218 .73334 .34978 .75836 .31585 .74945 .34296 Metetra
1 0 0 r
.74945 .34296 .75836 .31585 .7856 .31073 .77419 .29942 Metetra
1 .864 .887 r
.77419 .29942 .7856 .31073 .81576 .3337 .80063 .279 Metetra
1 .441 .703 r
.80063 .279 .81576 .3337 .84884 .37715 .82964 .28411 Metetra
1 .335 .636 r
.82964 .28411 .84884 .37715 .88392 .42743 .86164 .31196 Metetra
1 .428 .073 r
.22944 .55152 .24509 .56518 .26444 .60953 .24895 .59223 Metetra
1 .25 0 r
.24895 .59223 .26444 .60953 .2855 .64237 .26999 .62393 Metetra
1 .37 .838 r
.26999 .62393 .2855 .64237 .30873 .6526 .29301 .63742 Metetra
1 .749 .9 r
.29301 .63742 .30873 .6526 .33396 .63503 .31795 .62744 Metetra
1 .839 .798 r
.31795 .62744 .33396 .63503 .36048 .59241 .34431 .59446 Metetra
1 .884 .724 r
.34431 .59446 .36048 .59241 .38736 .53438 .37131 .54449 Metetra
1 .916 .672 r
.37131 .54449 .38736 .53438 .41381 .47407 .3982 .48721 Metetra
1 .94 .651 r
.3982 .48721 .41381 .47407 .43944 .42411 .42449 .4332 Metetra
1 .968 .707 r
.42449 .4332 .43944 .42411 .46429 .39389 .45002 .3916 Metetra
1 .948 .878 r
.45002 .3916 .46429 .39389 .48875 .38815 .47498 .36864 Metetra
1 .644 .894 r
.47498 .36864 .48875 .38815 .51338 .40652 .49976 .367 Metetra
1 .351 .741 r
.49976 .367 .51338 .40652 .53874 .44355 .52489 .38562 Metetra
1 .241 .658 r
.52489 .38562 .53874 .44355 .56515 .48922 .5508 .41976 Metetra
1 .219 .633 r
.5508 .41976 .56515 .48922 .59257 .53039 .57776 .46135 Metetra
1 .245 .644 r
.57776 .46135 .59257 .53039 .62056 .5539 .60573 .50002 Metetra
1 .324 .698 r
.60573 .50002 .62056 .5539 .64836 .55065 .63431 .52511 Metetra
1 .566 .864 r
.63431 .52511 .64836 .55065 .67525 .51899 .66283 .52846 Metetra
1 .815 .565 r
.66283 .52846 .67525 .51899 .70085 .46543 .69061 .50696 Metetra
1 0 .119 r
.69061 .50696 .70085 .46543 .72534 .40218 .71718 .46367 Metetra
1 0 .247 r
.71718 .46367 .72534 .40218 .74945 .34296 .74251 .40679 Metetra
1 0 .263 r
.74251 .40679 .74945 .34296 .77419 .29942 .76705 .34706 Metetra
1 0 .185 r
.76705 .34706 .77419 .29942 .80063 .279 .79162 .29502 Metetra
1 0 0 r
.79162 .29502 .80063 .279 .82964 .28411 .81718 .25886 Metetra
1 .678 .816 r
.81718 .25886 .82964 .28411 .86164 .31196 .84468 .24343 Metetra
1 .388 .014 r
.21353 .53763 .22944 .55152 .24895 .59223 .23323 .5746 Metetra
1 .214 0 r
.23323 .5746 .24895 .59223 .26999 .62393 .2543 .60468 Metetra
1 .296 .791 r
.2543 .60468 .26999 .62393 .29301 .63742 .27714 .62048 Metetra
1 .695 .924 r
.27714 .62048 .29301 .63742 .31795 .62744 .30178 .61707 Metetra
1 .826 .847 r
.30178 .61707 .31795 .62744 .34431 .59446 .32788 .59345 Metetra
1 .89 .77 r
.32788 .59345 .34431 .59446 .37131 .54449 .35484 .55279 Metetra
1 .928 .701 r
.35484 .55279 .37131 .54449 .3982 .48721 .38202 .50157 Metetra
1 .946 .646 r
.38202 .50157 .3982 .48721 .42449 .4332 .40886 .44793 Metetra
1 .958 .636 r
.40886 .44793 .42449 .4332 .45002 .3916 .4351 .39984 Metetra
1 .985 .73 r
.4351 .39984 .45002 .3916 .47498 .36864 .46071 .36383 Metetra
1 .926 .906 r
.46071 .36383 .47498 .36864 .49976 .367 .48591 .34418 Metetra
1 .613 .865 r
.48591 .34418 .49976 .367 .52489 .38562 .5111 .34262 Metetra
1 .379 .734 r
.5111 .34262 .52489 .38562 .5508 .41976 .5367 .35821 Metetra
1 .283 .664 r
.5367 .35821 .5508 .41976 .57776 .46135 .56309 .38741 Metetra
1 .255 .637 r
.56309 .38741 .57776 .46135 .60573 .50002 .59052 .42424 Metetra
1 .264 .639 r
.59052 .42424 .60573 .50002 .63431 .52511 .61898 .46093 Metetra
1 .308 .672 r
.61898 .46093 .63431 .52511 .66283 .52846 .64816 .48902 Metetra
1 .434 .771 r
.64816 .48902 .66283 .52846 .69061 .50696 .67752 .50112 Metetra
1 .881 .989 r
.67752 .50112 .69061 .50696 .71718 .46367 .70643 .49277 Metetra
1 0 .017 r
.70643 .49277 .71718 .46367 .74251 .40679 .73434 .46373 Metetra
1 0 .25 r
.73434 .46373 .74251 .40679 .76705 .34706 .76097 .41807 Metetra
1 0 .304 r
.76097 .41807 .76705 .34706 .79162 .29502 .78646 .36304 Metetra
1 0 .298 r
.78646 .36304 .79162 .29502 .81718 .25886 .81132 .30716 Metetra
1 0 .211 r
.81132 .30716 .81718 .25886 .84468 .24343 .83632 .25847 Metetra
1 .335 0 r
.19735 .52351 .21353 .53763 .23323 .5746 .21728 .55664 Metetra
1 .163 0 r
.21728 .55664 .23323 .5746 .2543 .60468 .23842 .58467 Metetra
1 .253 .761 r
.23842 .58467 .2543 .60468 .27714 .62048 .26113 .60181 Metetra
1 .623 .926 r
.26113 .60181 .27714 .62048 .30178 .61707 .28547 .60378 Metetra
1 .793 .891 r
.28547 .60378 .30178 .61707 .32788 .59345 .31126 .58877 Metetra
1 .885 .824 r
.31126 .58877 .32788 .59345 .35484 .55279 .33805 .55793 Metetra
1 .94 .749 r
.33805 .55793 .35484 .55279 .38202 .50157 .36532 .51505 Metetra
1 .958 .667 r
.36532 .51505 .38202 .50157 .40886 .44793 .39257 .46575 Metetra
1 .951 .601 r
.39257 .46575 .40886 .44793 .4351 .39984 .41943 .41629 Metetra
1 .952 .6 r
.41943 .41629 .4351 .39984 .46071 .36383 .44575 .37256 Metetra
1 .99 .725 r
.44575 .37256 .46071 .36383 .48591 .34418 .47158 .33928 Metetra
1 .93 .909 r
.47158 .33928 .48591 .34418 .5111 .34262 .49714 .31961 Metetra
1 .637 .859 r
.49714 .31961 .5111 .34262 .5367 .35821 .52274 .31495 Metetra
1 .423 .74 r
.52274 .31495 .5367 .35821 .56309 .38741 .54876 .32486 Metetra
1 .327 .672 r
.54876 .32486 .56309 .38741 .59052 .42424 .57555 .34713 Metetra
1 .289 .641 r
.57555 .34713 .59052 .42424 .61898 .46093 .60333 .37779 Metetra
1 .282 .634 r
.60333 .37779 .61898 .46093 .64816 .48902 .63216 .41144 Metetra
1 .3 .647 r
.63216 .41144 .64816 .48902 .67752 .50112 .66187 .44178 Metetra
1 .353 .694 r
.66187 .44178 .67752 .50112 .70643 .49277 .69209 .46252 Metetra
1 .519 .836 r
.69209 .46252 .70643 .49277 .73434 .46373 .72226 .46856 Metetra
1 0 0 r
.72226 .46856 .73434 .46373 .76097 .41807 .75182 .45716 Metetra
1 0 .163 r
.75182 .45716 .76097 .41807 .78646 .36304 .78031 .42859 Metetra
1 0 .302 r
.78031 .42859 .78646 .36304 .81132 .30716 .80752 .38611 Metetra
1 .007 .34 r
.80752 .38611 .81132 .30716 .83632 .25847 .83359 .33516 Metetra
1 .264 0 r
.1809 .50916 .19735 .52351 .21728 .55664 .20111 .53835 Metetra
1 .093 0 r
.20111 .53835 .21728 .55664 .23842 .58467 .22237 .5639 Metetra
1 .241 .754 r
.22237 .5639 .23842 .58467 .26113 .60181 .24499 .58145 Metetra
1 .549 .909 r
.24499 .58145 .26113 .60181 .28547 .60378 .26907 .58748 Metetra
1 .735 .917 r
.26907 .58748 .28547 .60378 .31126 .58877 .29451 .57994 Metetra
1 .858 .88 r
.29451 .57994 .31126 .58877 .33805 .55793 .32103 .55868 Metetra
1 .942 .815 r
.32103 .55868 .33805 .55793 .36532 .51505 .34822 .52546 Metetra
1 .975 .718 r
.34822 .52546 .36532 .51505 .39257 .46575 .37567 .48365 Metetra
1 .954 .605 r
.37567 .48365 .39257 .46575 .41943 .41629 .40301 .43759 Metetra
1 .911 .521 r
.40301 .43759 .41943 .41629 .44575 .37256 .43 .39189 Metetra
1 .903 .521 r
.43 .39189 .44575 .37256 .47158 .33928 .45654 .35085 Metetra
1 .966 .662 r
.45654 .35085 .47158 .33928 .49714 .31961 .4827 .318 Metetra
1 .973 .889 r
.4827 .318 .49714 .31961 .52274 .31495 .50865 .29583 Metetra
1 .714 .878 r
.50865 .29583 .52274 .31495 .54876 .32486 .53467 .2857 Metetra
1 .49 .762 r
.53467 .2857 .54876 .32486 .57555 .34713 .56106 .28777 Metetra
1 .379 .687 r
.56106 .28777 .57555 .34713 .60333 .37779 .58813 .30101 Metetra
1 .327 .648 r
.58813 .30101 .60333 .37779 .63216 .41144 .61611 .32321 Metetra
1 .306 .632 r
.61611 .32321 .63216 .41144 .66187 .44178 .64513 .35107 Metetra
1 .304 .631 r
.64513 .35107 .66187 .44178 .69209 .46252 .67517 .3804 Metetra
1 .32 .646 r
.67517 .3804 .69209 .46252 .72226 .46856 .70603 .40649 Metetra
1 .366 .692 r
.70603 .40649 .72226 .46856 .75182 .45716 .73734 .42472 Metetra
1 .507 .825 r
.73734 .42472 .75182 .45716 .78031 .42859 .76862 .43125 Metetra
1 .705 .697 r
.76862 .43125 .78031 .42859 .80752 .38611 .79934 .42372 Metetra
1 0 .171 r
.79934 .42372 .80752 .38611 .83359 .33516 .82907 .40173 Metetra
1 .169 0 r
.16417 .49455 .1809 .50916 .20111 .53835 .1847 .51973 Metetra
1 0 .52 r
.1847 .51973 .20111 .53835 .22237 .5639 .20614 .54242 Metetra
1 .257 .766 r
.20614 .54242 .22237 .5639 .24499 .58145 .22874 .55949 Metetra
1 .49 .887 r
.22874 .55949 .24499 .58145 .26907 .58748 .25261 .5682 Metetra
1 .66 .919 r
.25261 .5682 .26907 .58748 .29451 .57994 .27772 .56665 Metetra
1 .798 .917 r
.27772 .56665 .29451 .57994 .32103 .55868 .30389 .55401 Metetra
1 .916 .886 r
.30389 .55401 .32103 .55868 .34822 .52546 .33086 .53072 Metetra
1 .986 .802 r
.33086 .53072 .34822 .52546 .37567 .48365 .35831 .49838 Metetra
1 .971 .658 r
.35831 .49838 .37567 .48365 .40301 .43759 .38592 .45952 Metetra
1 .889 .5 r
.38592 .45952 .40301 .43759 .43 .39189 .41343 .41724 Metetra
1 .808 .394 r
.41343 .41724 .43 .39189 .45654 .35085 .44065 .37484 Metetra
1 0 0 r
.44065 .37484 .45654 .35085 .4827 .318 .46752 .3354 Metetra
1 .859 .497 r
.46752 .3354 .4827 .318 .50865 .29583 .49409 .30161 Metetra
1 .993 .776 r
.49409 .30161 .50865 .29583 .53467 .2857 .52049 .27554 Metetra
1 .867 .917 r
.52049 .27554 .53467 .2857 .56106 .28777 .54692 .25854 Metetra
1 .605 .813 r
.54692 .25854 .56106 .28777 .58813 .30101 .57363 .25127 Metetra
1 .454 .719 r
.57363 .25127 .58813 .30101 .61611 .32321 .60088 .25359 Metetra
1 .379 .666 r
.60088 .25359 .61611 .32321 .64513 .35107 .6289 .26465 Metetra
1 .341 .638 r
.6289 .26465 .64513 .35107 .67517 .3804 .65787 .28284 Metetra
1 .323 .625 r
.65787 .28284 .67517 .3804 .70603 .40649 .6879 .30587 Metetra
1 .319 .623 r
.6879 .30587 .70603 .40649 .73734 .42472 .71896 .33088 Metetra
1 .327 .634 r
.71896 .33088 .73734 .42472 .76862 .43125 .7509 .35458 Metetra
1 .353 .662 r
.7509 .35458 .76862 .43125 .79934 .42372 .78344 .37361 Metetra
1 .422 .737 r
.78344 .37361 .79934 .42372 .82907 .40173 .81616 .38486 Metetra
1 .042 0 r
.14715 .4797 .16417 .49455 .1847 .51973 .16804 .50078 Metetra
1 .111 .633 r
.16804 .50078 .1847 .51973 .20614 .54242 .18973 .52027 Metetra
1 .298 .795 r
.18973 .52027 .20614 .54242 .22874 .55949 .21239 .536 Metetra
1 .458 .871 r
.21239 .536 .22874 .55949 .25261 .5682 .23612 .54602 Metetra
1 .587 .902 r
.23612 .54602 .25261 .5682 .27772 .56665 .26094 .54875 Metetra
1 .711 .921 r
.26094 .54875 .27772 .56665 .30389 .55401 .28676 .54319 Metetra
1 .841 .931 r
.28676 .54319 .30389 .55401 .33086 .53072 .31341 .52905 Metetra
1 .96 .9 r
.31341 .52905 .33086 .53072 .35831 .49838 .34069 .50675 Metetra
1 .997 .774 r
.34069 .50675 .35831 .49838 .38592 .45952 .36835 .47743 Metetra
1 .904 .562 r
.36835 .47743 .38592 .45952 .41343 .41724 .39614 .44277 Metetra
1 0 0 r
.39614 .44277 .41343 .41724 .44065 .37484 .42389 .40482 Metetra
1 0 0 r
.42389 .40482 .44065 .37484 .46752 .3354 .45145 .3658 Metetra
1 0 0 r
.45145 .3658 .46752 .3354 .49409 .30161 .47876 .32788 Metetra
1 0 0 r
.47876 .32788 .49409 .30161 .52049 .27554 .50582 .29305 Metetra
1 0 0 r
.50582 .29305 .52049 .27554 .54692 .25854 .53272 .263 Metetra
1 .99 .796 r
.53272 .263 .54692 .25854 .57363 .25127 .5596 .23904 Metetra
1 .846 .911 r
.5596 .23904 .57363 .25127 .60088 .25359 .58663 .22206 Metetra
1 .603 .798 r
.58663 .22206 .60088 .25359 .6289 .26465 .61402 .21253 Metetra
1 .47 .712 r
.61402 .21253 .6289 .26465 .65787 .28284 .64197 .21046 Metetra
1 .4 .663 r
.64197 .21046 .65787 .28284 .6879 .30587 .6707 .21544 Metetra
1 .362 .635 r
.6707 .21544 .6879 .30587 .71896 .33088 .70034 .2266 Metetra
1 .342 .621 r
.70034 .2266 .71896 .33088 .7509 .35458 .73103 .24266 Metetra
1 .332 .615 r
.73103 .24266 .7509 .35458 .78344 .37361 .76279 .26194 Metetra
1 .331 .617 r
.76279 .26194 .78344 .37361 .81616 .38486 .79556 .28245 Metetra
1 .118 .596 r
.12983 .46459 .14715 .4797 .16804 .50078 .15114 .4815 Metetra
1 .24 .745 r
.15114 .4815 .16804 .50078 .18973 .52027 .17313 .49747 Metetra
1 .358 .83 r
.17313 .49747 .18973 .52027 .21239 .536 .19593 .5111 Metetra
1 .452 .863 r
.19593 .5111 .21239 .536 .23612 .54602 .21963 .5211 Metetra
1 .535 .879 r
.21963 .5211 .23612 .54602 .26094 .54875 .24424 .52631 Metetra
1 .623 .899 r
.24424 .52631 .26094 .54875 .28676 .54319 .26974 .52585 Metetra
1 .729 .927 r
.26974 .52585 .28676 .54319 .31341 .52905 .29605 .51916 Metetra
1 .858 .951 r
.29605 .51916 .31341 .52905 .34069 .50675 .32304 .50607 Metetra
1 .975 .92 r
.32304 .50607 .34069 .50675 .36835 .47743 .35055 .48683 Metetra
1 .965 .742 r
.35055 .48683 .36835 .47743 .39614 .44277 .37841 .46207 Metetra
1 0 0 r
.37841 .46207 .39614 .44277 .42389 .40482 .40645 .43273 Metetra
1 0 0 r
.40645 .43273 .42389 .40482 .45145 .3658 .43452 .40003 Metetra
1 0 0 r
.43452 .40003 .45145 .3658 .47876 .32788 .4625 .36531 Metetra
1 0 0 r
.4625 .36531 .47876 .32788 .50582 .29305 .49034 .33 Metetra
1 0 0 r
.49034 .33 .50582 .29305 .53272 .263 .518 .29548 Metetra
1 0 0 r
.518 .29548 .53272 .263 .5596 .23904 .54551 .26302 Metetra
1 0 0 r
.54551 .26302 .5596 .23904 .58663 .22206 .57294 .23374 Metetra
1 .841 .553 r
.57294 .23374 .58663 .22206 .61402 .21253 .60039 .20857 Metetra
1 .971 .915 r
.60039 .20857 .61402 .21253 .64197 .21046 .62801 .1882 Metetra
1 .719 .853 r
.62801 .1882 .64197 .21046 .6707 .21544 .65596 .1731 Metetra
1 .543 .747 r
.65596 .1731 .6707 .21544 .70034 .2266 .68439 .16352 Metetra
1 .45 .684 r
.68439 .16352 .70034 .2266 .73103 .24266 .71348 .15943 Metetra
1 .399 .646 r
.71348 .15943 .73103 .24266 .76279 .26194 .74338 .16061 Metetra
1 .37 .624 r
.74338 .16061 .76279 .26194 .79556 .28245 .77422 .16657 Metetra
1 .297 .761 r
.11221 .44921 .12983 .46459 .15114 .4815 .13399 .46189 Metetra
1 .371 .838 r
.13399 .46189 .15114 .4815 .17313 .49747 .15634 .47407 Metetra
1 .426 .861 r
.15634 .47407 .17313 .49747 .19593 .5111 .17937 .48492 Metetra
1 .469 .861 r
.17937 .48492 .19593 .5111 .21963 .5211 .20313 .49367 Metetra
1 .51 .86 r
.20313 .49367 .21963 .5211 .24424 .52631 .22765 .49958 Metetra
1 .559 .867 r
.22765 .49958 .24424 .52631 .26974 .52585 .25293 .502 Metetra
1 .623 .888 r
.25293 .502 .26974 .52585 .29605 .51916 .27894 .50043 Metetra
1 .712 .923 r
.27894 .50043 .29605 .51916 .32304 .50607 .30561 .49451 Metetra
1 .831 .963 r
.30561 .49451 .32304 .50607 .35055 .48683 .33286 .48409 Metetra
1 .951 .955 r
.33286 .48409 .35055 .48683 .37841 .46207 .36059 .4692 Metetra
1 .933 .77 r
.36059 .4692 .37841 .46207 .40645 .43273 .38867 .45008 Metetra
1 0 0 r
.38867 .45008 .40645 .43273 .43452 .40003 .41699 .42713 Metetra
1 0 0 r
.41699 .42713 .43452 .40003 .4625 .36531 .44545 .40094 Metetra
1 0 0 r
.44545 .40094 .4625 .36531 .49034 .33 .47395 .37219 Metetra
1 0 .066 r
.47395 .37219 .49034 .33 .518 .29548 .50241 .34167 Metetra
1 0 .114 r
.50241 .34167 .518 .29548 .54551 .26302 .53079 .31019 Metetra
1 0 .132 r
.53079 .31019 .54551 .26302 .57294 .23374 .55907 .27858 Metetra
1 0 .122 r
.55907 .27858 .57294 .23374 .60039 .20857 .58726 .24764 Metetra
1 0 .077 r
.58726 .24764 .60039 .20857 .62801 .1882 .61539 .21811 Metetra
1 0 0 r
.61539 .21811 .62801 .1882 .65596 .1731 .64354 .19065 Metetra
1 0 0 r
.64354 .19065 .65596 .1731 .68439 .16352 .67179 .16584 Metetra
1 .973 .806 r
.67179 .16584 .68439 .16352 .71348 .15943 .70023 .14413 Metetra
1 .832 .903 r
.70023 .14413 .71348 .15943 .74338 .16061 .72901 .12587 Metetra
1 .614 .783 r
.72901 .12587 .74338 .16061 .77422 .16657 .75823 .11132 Metetra
1 .466 .885 r
.09428 .43356 .11221 .44921 .13399 .46189 .11657 .44195 Metetra
1 .486 .899 r
.11657 .44195 .13399 .46189 .15634 .47407 .13937 .4501 Metetra
1 .493 .882 r
.13937 .4501 .15634 .47407 .17937 .48492 .16271 .4576 Metetra
1 .499 .86 r
.16271 .4576 .17937 .48492 .20313 .49367 .18665 .46403 Metetra
1 .509 .844 r
.18665 .46403 .20313 .49367 .22765 .49958 .21121 .46898 Metetra
1 .526 .838 r
.21121 .46898 .22765 .49958 .25293 .502 .2364 .47208 Metetra
1 .553 .843 r
.2364 .47208 .25293 .502 .27894 .50043 .2622 .47298 Metetra
1 .595 .86 r
.2622 .47298 .27894 .50043 .30561 .49451 .28861 .47139 Metetra
1 .656 .893 r
.28861 .47139 .30561 .49451 .33286 .48409 .31559 .46709 Metetra
1 .746 .941 r
.31559 .46709 .33286 .48409 .36059 .4692 .34307 .45992 Metetra
1 .864 .984 r
.34307 .45992 .36059 .4692 .38867 .45008 .37102 .44979 Metetra
1 .936 .925 r
.37102 .44979 .38867 .45008 .41699 .42713 .39936 .43672 Metetra
1 .792 .627 r
.39936 .43672 .41699 .42713 .44545 .40094 .42801 .42079 Metetra
1 0 0 r
.42801 .42079 .44545 .40094 .47395 .37219 .4569 .40216 Metetra
1 0 0 r
.4569 .40216 .47395 .37219 .50241 .34167 .48597 .38108 Metetra
1 0 .074 r
.48597 .38108 .50241 .34167 .53079 .31019 .51515 .35785 Metetra
1 0 .151 r
.51515 .35785 .53079 .31019 .55907 .27858 .54438 .33281 Metetra
1 0 .198 r
.54438 .33281 .55907 .27858 .58726 .24764 .57362 .30637 Metetra
1 0 .226 r
.57362 .30637 .58726 .24764 .61539 .21811 .60284 .27893 Metetra
1 0 .24 r
.60284 .27893 .61539 .21811 .64354 .19065 .63203 .25094 Metetra
1 0 .242 r
.63203 .25094 .64354 .19065 .67179 .16584 .66119 .22281 Metetra
1 0 .23 r
.66119 .22281 .67179 .16584 .70023 .14413 .69034 .19496 Metetra
1 0 .202 r
.69034 .19496 .70023 .14413 .72901 .12587 .71952 .1678 Metetra
1 0 .144 r
.71952 .1678 .72901 .12587 .75823 .11132 .74876 .14167 Metetra
1 .596 .949 r
.07603 .41763 .09428 .43356 .11657 .44195 .0989 .42167 Metetra
1 .575 .924 r
.0989 .42167 .11657 .44195 .13937 .4501 .12219 .42562 Metetra
1 .552 .888 r
.12219 .42562 .13937 .4501 .16271 .4576 .14594 .42929 Metetra
1 .534 .855 r
.14594 .42929 .16271 .4576 .18665 .46403 .17018 .43251 Metetra
1 .522 .83 r
.17018 .43251 .18665 .46403 .21121 .46898 .19491 .43509 Metetra
1 .518 .814 r
.19491 .43509 .21121 .46898 .2364 .47208 .22015 .43686 Metetra
1 .521 .806 r
.22015 .43686 .2364 .47208 .2622 .47298 .24591 .43765 Metetra
1 .531 .805 r
.24591 .43765 .2622 .47298 .28861 .47139 .27218 .43731 Metetra
1 .549 .814 r
.27218 .43731 .28861 .47139 .31559 .46709 .29895 .43569 Metetra
1 .579 .832 r
.29895 .43569 .31559 .46709 .34307 .45992 .32622 .43266 Metetra
1 .624 .863 r
.32622 .43266 .34307 .45992 .37102 .44979 .35397 .4281 Metetra
1 .691 .909 r
.35397 .4281 .37102 .44979 .39936 .43672 .38216 .42193 Metetra
1 .785 .966 r
.38216 .42193 .39936 .43672 .42801 .42079 .41077 .41407 Metetra
1 .887 .99 r
.41077 .41407 .42801 .42079 .4569 .40216 .43976 .4045 Metetra
1 .858 .827 r
.43976 .4045 .4569 .40216 .48597 .38108 .46909 .39318 Metetra
1 0 0 r
.46909 .39318 .48597 .38108 .51515 .35785 .49873 .38014 Metetra
1 0 0 r
.49873 .38014 .51515 .35785 .54438 .33281 .52864 .3654 Metetra
1 0 .029 r
.52864 .3654 .54438 .33281 .57362 .30637 .55877 .34905 Metetra
1 0 .136 r
.55877 .34905 .57362 .30637 .60284 .27893 .58908 .33116 Metetra
1 0 .203 r
.58908 .33116 .60284 .27893 .63203 .25094 .61954 .31184 Metetra
1 0 .247 r
.61954 .31184 .63203 .25094 .66119 .22281 .65011 .29123 Metetra
1 .021 .276 r
.65011 .29123 .66119 .22281 .69034 .19496 .68077 .26947 Metetra
1 .041 .297 r
.68077 .26947 .69034 .19496 .71952 .1678 .7115 .24672 Metetra
1 .054 .31 r
.7115 .24672 .71952 .1678 .74876 .14167 .74228 .22317 Metetra
1 .679 .963 r
.05745 .40141 .07603 .41763 .0989 .42167 .08095 .40107 Metetra
1 .637 .922 r
.08095 .40107 .0989 .42167 .12219 .42562 .10481 .40067 Metetra
1 .599 .881 r
.10481 .40067 .12219 .42562 .14594 .42929 .12905 .40016 Metetra
1 .568 .846 r
.12905 .40016 .14594 .42929 .17018 .43251 .15369 .39949 Metetra
1 .544 .817 r
.15369 .39949 .17018 .43251 .19491 .43509 .17873 .3986 Metetra
1 .526 .795 r
.17873 .3986 .19491 .43509 .22015 .43686 .20418 .39744 Metetra
1 .514 .778 r
.20418 .39744 .22015 .43686 .24591 .43765 .23005 .39595 Metetra
1 .507 .767 r
.23005 .39595 .24591 .43765 .27218 .43731 .25634 .39408 Metetra
1 .503 .76 r
.25634 .39408 .27218 .43731 .29895 .43569 .28307 .39177 Metetra
1 .505 .758 r
.28307 .39177 .29895 .43569 .32622 .43266 .31022 .38898 Metetra
1 .51 .76 r
.31022 .38898 .32622 .43266 .35397 .4281 .33781 .38566 Metetra
1 .521 .768 r
.33781 .38566 .35397 .4281 .38216 .42193 .36584 .38174 Metetra
1 .537 .781 r
.36584 .38174 .38216 .42193 .41077 .41407 .39429 .3772 Metetra
1 .562 .801 r
.39429 .3772 .41077 .41407 .43976 .4045 .42316 .37198 Metetra
1 .597 .83 r
.42316 .37198 .43976 .4045 .46909 .39318 .45245 .36605 Metetra
1 .647 .871 r
.45245 .36605 .46909 .39318 .49873 .38014 .48214 .35937 Metetra
1 .719 .926 r
.48214 .35937 .49873 .38014 .52864 .3654 .51223 .35192 Metetra
1 .813 .984 r
.51223 .35192 .52864 .3654 .55877 .34905 .54271 .34365 Metetra
1 .88 .973 r
.54271 .34365 .55877 .34905 .58908 .33116 .57355 .33456 Metetra
1 .768 .735 r
.57355 .33456 .58908 .33116 .61954 .31184 .60476 .32462 Metetra
1 0 0 r
.60476 .32462 .61954 .31184 .65011 .29123 .63629 .31382 Metetra
1 0 0 r
.63629 .31382 .65011 .29123 .68077 .26947 .66816 .30216 Metetra
1 0 .055 r
.66816 .30216 .68077 .26947 .7115 .24672 .70032 .28963 Metetra
1 0 .153 r
.70032 .28963 .7115 .24672 .74228 .22317 .73278 .27625 Metetra
1 .727 .948 r
.03853 .3849 .05745 .40141 .08095 .40107 .06272 .38012 Metetra
1 .676 .906 r
.06272 .38012 .08095 .40107 .10481 .40067 .08722 .37528 Metetra
1 .633 .867 r
.08722 .37528 .10481 .40067 .12905 .40016 .11203 .37037 Metetra
1 .596 .832 r
.11203 .37037 .12905 .40016 .15369 .39949 .13716 .36537 Metetra
1 .566 .803 r
.13716 .36537 .15369 .39949 .17873 .3986 .16262 .36028 Metetra
1 .542 .779 r
.16262 .36028 .17873 .3986 .20418 .39744 .18841 .3551 Metetra
1 .522 .759 r
.18841 .3551 .20418 .39744 .23005 .39595 .21454 .3498 Metetra
1 .506 .742 r
.21454 .3498 .23005 .39595 .25634 .39408 .24102 .34439 Metetra
1 .493 .729 r
.24102 .34439 .25634 .39408 .28307 .39177 .26785 .33886 Metetra
1 .482 .718 r
.26785 .33886 .28307 .39177 .31022 .38898 .29504 .3332 Metetra
1 .474 .709 r
.29504 .3332 .31022 .38898 .33781 .38566 .3226 .32739 Metetra
1 .468 .702 r
.3226 .32739 .33781 .38566 .36584 .38174 .35052 .32144 Metetra
1 .463 .697 r
.35052 .32144 .36584 .38174 .39429 .3772 .37882 .31533 Metetra
1 .46 .693 r
.37882 .31533 .39429 .3772 .42316 .37198 .4075 .30905 Metetra
1 .459 .692 r
.4075 .30905 .42316 .37198 .45245 .36605 .43657 .3026 Metetra
1 .459 .691 r
.43657 .3026 .45245 .36605 .48214 .35937 .46603 .29596 Metetra
1 .46 .692 r
.46603 .29596 .48214 .35937 .51223 .35192 .49589 .28913 Metetra
1 .464 .695 r
.49589 .28913 .51223 .35192 .54271 .34365 .52616 .2821 Metetra
1 .469 .7 r
.52616 .2821 .54271 .34365 .57355 .33456 .55683 .27486 Metetra
1 .476 .707 r
.55683 .27486 .57355 .33456 .60476 .32462 .58791 .2674 Metetra
1 .486 .716 r
.58791 .2674 .60476 .32462 .63629 .31382 .61941 .25971 Metetra
1 .499 .728 r
.61941 .25971 .63629 .31382 .66816 .30216 .65133 .25178 Metetra
1 .516 .744 r
.65133 .25178 .66816 .30216 .70032 .28963 .68367 .24361 Metetra
1 .538 .764 r
.68367 .24361 .70032 .28963 .73278 .27625 .71645 .23519 Metetra
1 .751 .92 r
.01926 .36808 .03853 .3849 .06272 .38012 .0442 .35884 Metetra
1 .701 .883 r
.0442 .35884 .06272 .38012 .08722 .37528 .0694 .34951 Metetra
1 .657 .848 r
.0694 .34951 .08722 .37528 .11203 .37037 .09484 .34009 Metetra
1 .62 .817 r
.09484 .34009 .11203 .37037 .13716 .36537 .12055 .33057 Metetra
1 .588 .79 r
.12055 .33057 .13716 .36537 .16262 .36028 .14652 .32095 Metetra
1 .561 .766 r
.14652 .32095 .16262 .36028 .18841 .3551 .17275 .31124 Metetra
1 .538 .746 r
.17275 .31124 .18841 .3551 .21454 .3498 .19925 .30142 Metetra
1 .518 .728 r
.19925 .30142 .21454 .3498 .24102 .34439 .22603 .2915 Metetra
1 .501 .713 r
.22603 .2915 .24102 .34439 .26785 .33886 .25309 .28148 Metetra
1 .486 .699 r
.25309 .28148 .26785 .33886 .29504 .3332 .28042 .27136 Metetra
1 .472 .687 r
.28042 .27136 .29504 .3332 .3226 .32739 .30805 .26113 Metetra
1 .461 .676 r
.30805 .26113 .3226 .32739 .35052 .32144 .33597 .25079 Metetra
1 .45 .667 r
.33597 .25079 .35052 .32144 .37882 .31533 .36418 .24034 Metetra
1 .441 .658 r
.36418 .24034 .37882 .31533 .4075 .30905 .3927 .22978 Metetra
1 .433 .651 r
.3927 .22978 .4075 .30905 .43657 .3026 .42152 .2191 Metetra
1 .426 .644 r
.42152 .2191 .43657 .3026 .46603 .29596 .45066 .20831 Metetra
1 .419 .638 r
.45066 .20831 .46603 .29596 .49589 .28913 .48011 .1974 Metetra
1 .413 .632 r
.48011 .1974 .49589 .28913 .52616 .2821 .50988 .18638 Metetra
1 .408 .627 r
.50988 .18638 .52616 .2821 .55683 .27486 .53998 .17523 Metetra
1 .403 .622 r
.53998 .17523 .55683 .27486 .58791 .2674 .57041 .16396 Metetra
1 .399 .618 r
.57041 .16396 .58791 .2674 .61941 .25971 .60118 .15257 Metetra
1 .394 .614 r
.60118 .15257 .61941 .25971 .65133 .25178 .63229 .14104 Metetra
1 .391 .611 r
.63229 .14104 .65133 .25178 .68367 .24361 .66375 .12939 Metetra
1 .388 .608 r
.66375 .12939 .68367 .24361 .71645 .23519 .69556 .11761 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AmbientLight"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AnchoredSearch", "ObjectName",
  CellTags->{"S0.1024", "AnchoredSearch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnchoredSearch", "MR"],
  " is an option for ",
  ButtonBox["Find",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FindList",
    ButtonStyle->"RefGuideLink"],
  " which specifies whether the text searched for must be at the beginning of \
a record. "
}], "Usage",
  CellTags->{"S0.1024", "AnchoredSearch"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["RecordSeparators", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{\"\[Backslash]n\"}", "MR"],
  ", ",
  StyleBox["AnchoredSearch", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " specifies that the text must appear at the beginning of a line. "
}], "Notes",
  CellTags->{"S0.1024", "AnchoredSearch"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.12.9",
    ButtonData:>{"2.12.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1024", "AnchoredSearch"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1024", "AnchoredSearch"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["And", "ObjectName",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  " is the logical AND function. It evaluates its arguments in order, giving \
",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  " immediately if any of them are ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ", and ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " if they are all ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Usage",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["And[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " can be input in ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  " as ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  " ",
  "\[Ellipsis]",
  " ",
  ". The character ",
  Cell[BoxData[
      \(TraditionalForm\` \[And] \)], "InlineFormula"],
  " can be entered as \[AliasIndicator]",
  StyleBox["&&\[AliasIndicator]", "MR"],
  ", \[AliasIndicator]",
  StyleBox["and\[AliasIndicator]", "MR"],
  " or \[Backslash]",
  StyleBox["[And]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["And", "MR"],
  " evaluates its arguments in a non\[Hyphen]standard way (see Section\
\[NonBreakingSpace]",
  ButtonBox["A.4.2",
    ButtonData:>{"A.4.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["And", "MR"],
  " gives symbolic results when necessary, removing initial arguments that \
are ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.5.6",
    ButtonData:>{"1.5.6", "6.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1025", "And"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LogicalExpand",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitAnd",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Nand",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1025", "And"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1025", "And"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"And"],

Cell[TextData[{
  "This uses the shorthand notation for ",
  StyleBox["And", "MR"],
  ". "
}], "ExampleText",
  CellTags->"And"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x == x && y == y\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"And"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"And"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AnimationDirection", "ObjectName",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDirection", "MR"],
  " is an option for ",
  StyleBox["Cell", "MR"],
  " which specifies the direction to run an animation which starts with the \
cell. "
}], "Usage",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDirection->Forward", "MR"],
  " specifies that the animation should run through successive selected \
graphics cells in the order that they appear in the notebook, and should then \
start again at the first cell. "
}], "Notes",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDirection->Backward", "MR"],
  " specifies that the reverse order should be used. "
}], "Notes",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDirection->ForwardBackward", "MR"],
  " specifies that the animation should run from the first cell to the last, \
and should then reverse back to the first cell again. "
}], "Notes",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1026", "AnimationDirection"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1026", "AnimationDirection"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AnimationDisplayTime", "ObjectName",
  CellTags->{"S0.1027", "AnimationDisplayTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDisplayTime", "MR"],
  " is an option for ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " which specifies the minimum time in seconds for which a cell should be \
displayed in the course of an animation that runs through a sequence of \
selected cells. "
}], "Usage",
  CellTags->{"S0.1027", "AnimationDisplayTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting of ",
  StyleBox["AnimationDisplayTime->0", "MR"],
  " specifies that the animation should be run as fast as your computer can. \
"
}], "Notes",
  CellTags->{"S0.1027", "AnimationDisplayTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1027", "AnimationDisplayTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AnimationDirection",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1027", "AnimationDisplayTime"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1027", "AnimationDisplayTime"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apart", "ObjectName",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " rewrites a rational expression as a sum of terms with minimal \
denominators. \n\[FilledSmallSquare] ",
  StyleBox["Apart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["var", "TI"],
  StyleBox["]", "MR"],
  " treats all variables other than ",
  StyleBox["var", "TI"],
  " as constants. "
}], "Usage",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] Example: ",
  StyleBox["Apart[(x^2+1)/(x-1)]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      InterpretationBox[
        StyleBox[\(1\  + \ 2/\((\(-1\)\  + \ x)\)\  + \ x\),
          ShowStringCharacters->True,
          NumberMarks->True],
        InputForm[ 
          Plus[ 1, 
            Times[ 2, 
              Power[ 
                Plus[ -1, x], -1]], x]],
        Editable->True,
        AutoDelete->True]], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart", "MR"],
  " gives the partial fraction decomposition of a rational expression. "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["var", "TI"],
  StyleBox["]", "MR"],
  " writes ",
  StyleBox["expr", "TI"],
  " as a polynomial in ",
  StyleBox["var", "TI"],
  " together with a sum of ratios of polynomials, where the degree in ",
  StyleBox["var", "TI"],
  " of each numerator polynomial is less than that of the corresponding \
denominator polynomial. "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart[(x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y)/(x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["y),", "MR"],
  " ",
  StyleBox["x]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      InterpretationBox[
        StyleBox[\(1\  + \ \((2*y)\)/\((x\  - \ y)\)\),
          ShowStringCharacters->True,
          NumberMarks->True],
        InputForm[ 
          Plus[ 1, 
            Times[ 2, 
              Power[ 
                Plus[ x, 
                  Times[ -1, y]], -1], y]]],
        Editable->True,
        AutoDelete->True]], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart[(x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y)/(x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["y),", "MR"],
  " ",
  StyleBox["y]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      InterpretationBox[
        StyleBox[\(\(-1\)\  - \ \((2*x)\)/\((\(-x\)\  + \ y)\)\),
          ShowStringCharacters->True,
          NumberMarks->True],
        InputForm[ 
          Plus[ -1, 
            Times[ -2, x, 
              Power[ 
                Plus[ 
                  Times[ -1, x], y], -1]]]],
        Editable->True,
        AutoDelete->True]], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Trig", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True]", "MR"],
  " treats trigonometric functions as rational functions of exponentials, and \
manipulates them accordingly. "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.4.5",
    ButtonData:>{"1.4.5", "5.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.3.3",
    ButtonData:>{"3.3.3", "3.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Together",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Cancel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PolynomialQuotient",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1028", "Apart"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Apart"],

Cell[TextData[{
  StyleBox["Apart", "MR"],
  " splits up expressions into partial fractions. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[1\/\(\((3 + x)\) \((1 + x)\)\^3\)]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(1\/\(2\ \((1 + x)\)\^3\) - 1\/\(4\ \((1 + x)\)\^2\) + 
      1\/\(8\ \((1 + x)\)\) - 1\/\(8\ \((3 + x)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[TextData[{
  "Here neither ",
  StyleBox["x", "MR"],
  " nor ",
  StyleBox["y", "MR"],
  " are treated as constants. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[\(x + y\)\/\(\((1 + x)\) \((2 + x)\) \((3 + x)\)\)]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(x\/\(6 + 11\ x + 6\ x\^2 + x\^3\) + 
      y\/\(6 + 11\ x + 6\ x\^2 + x\^3\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["y", "MR"],
  " is treated as a constant. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[\(x + y\)\/\(\((1 + x)\) \((2 + x)\) \((3 + x)\)\), x]\)], "Input",\

  CellLabel->"In[3]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(\(2 - y\)\/\(2 + x\) + \(\(-3\) + y\)\/\(2\ \((3 + x)\)\) + \(\(-1\) + \
y\)\/\(2\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["x", "MR"],
  " is treated as a constant. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[\(x + y\)\/\(\((1 + x)\) \((2 + x)\) \((3 + x)\)\), y]\)], "Input",\

  CellLabel->"In[4]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(x\/\(6 + 11\ x + 6\ x\^2 + x\^3\) + 
      y\/\(6 + 11\ x + 6\ x\^2 + x\^3\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[TextData[{
  "By default, ",
  Cell[BoxData[
      \(Trig \[Rule] False\)], "InlineFormula"],
  " and ",
  StyleBox["Sin[2", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " is not treated as a rational function of exponentials. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[1\/Sin[2\ x]]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(Csc[2\ x]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[1\/Sin[2\ x], Trig \[Rule] False]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(Csc[2\ x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"Apart"]
}, Open  ]],

Cell[TextData[{
  "With ",
  Cell[BoxData[
      \(Trig \[Rule] True\)], "InlineFormula"],
  " ",
  StyleBox["Sin[2", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " is treated as a rational function of exponentials. "
}], "ExampleText",
  CellTags->"Apart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[1\/Sin[2\ x], Trig \[Rule] True]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Apart"],

Cell[BoxData[
    \(Cot[x]\/2 + Tan[x]\/2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"Apart"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AppellF1", "ObjectName",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppellF1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " is the Appell hypergeometric function of two variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " has series expansion ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["m",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], 
            RowBox[{
              StyleBox["m",
                "TI"], "+", 
              StyleBox["n",
                "TI"]}]], 
          SubscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ")"}], 
            StyleBox["m",
              "TI"]], 
          SubscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ")"}], 
            StyleBox["n",
              "TI"]], "/", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["m",
                "TI"], "!", 
              StyleBox["n",
                "TI"], "!", 
              SubscriptBox[
                RowBox[{"(", 
                  StyleBox["c",
                    "TI"], ")"}], 
                RowBox[{
                  StyleBox["m",
                    "TI"], "+", 
                  StyleBox["n",
                    "TI"]}]]}], ")"}], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["m",
              "TI"]], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], 
            StyleBox["n",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ";", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "1"], ",", 
              SubscriptBox[
                StyleBox["b",
                  "TI"], "2"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " reduces to ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Null]\_2\), 
          SubscriptBox[
            StyleBox["F",
              "TI"], "1"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"], ";", 
              StyleBox["c",
                "TI"], ";", 
              StyleBox["z",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppellF1[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " has singular lines in two\[Hyphen]variable complex ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["x",
              "TI"], ",", 
            StyleBox["y",
              "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
  " space at ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Re", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"Re", 
          RowBox[{"(", 
            StyleBox["y",
              "TI"], ")"}], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", and has branch cut discontinuities along the rays from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  " in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " include transformation rules for ",
  StyleBox["AppellF1", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.90"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Hypergeometric2F1",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1029", "AppellF1"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AppellF1"],

Cell[TextData[{
  "Here is the derivative with respect to ",
  StyleBox["x", "MR"],
  ". "
}], "ExampleText",
  CellTags->"AppellF1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[AppellF1[a, b\_1, b\_2, c, x, y], x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(a\ AppellF1[1 + a, 1 + b\_1, b\_2, 1 + c, x, y]\ b\_1\)\/c\)], \
"Output",
  CellLabel->"Out[1]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[TextData[{
  "Here is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  " in both ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "ExampleText",
  CellTags->"AppellF1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[
      AppellF1[a, b\_1, b\_2, c, x, y], {x, 0, 2}, {y, 0, 2}]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{"(", 
          InterpretationBox[
            RowBox[{
            "1", "+", \(\(a\ b\_2\ y\)\/c\), 
              "+", \(\(a\ \((1 + a)\)\ b\_2\ \((1 + 
                        b\_2)\)\ y\^2\)\/\(2\ c\ \((1 + c)\)\)\), "+", 
              InterpretationBox[\(O[y]\^3\),
                SeriesData[ y, 0, {}, 0, 3, 1],
                Editable->False]}],
            SeriesData[ y, 0, {1, 
              Times[ a, 
                Power[ c, -1], 
                Subscript[ b, 2]], 
              Times[ 
                Rational[ 1, 2], a, 
                Plus[ 1, a], 
                Power[ c, -1], 
                Power[ 
                  Plus[ 1, c], -1], 
                Subscript[ b, 2], 
                Plus[ 1, 
                  Subscript[ b, 2]]]}, 0, 3, 1],
            Editable->False], ")"}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              
              RowBox[{\(\(a\ b\_1\)\/c\), 
                "+", \(\(a\ \((1 + a)\)\ b\_1\ b\_2\ y\)\/\(c\ \((1 + 
                          c)\)\)\), 
                "+", \(\(a\ \((1 + a)\)\ \((2 + a)\)\ b\_1\ b\_2\ \((1 + 
                          b\_2)\)\ y\^2\)\/\(2\ c\ \((1 + c)\)\ \((2 + 
                          c)\)\)\), "+", 
                InterpretationBox[\(O[y]\^3\),
                  SeriesData[ y, 0, {}, 0, 3, 1],
                  Editable->False]}],
              SeriesData[ y, 0, {
                Times[ a, 
                  Power[ c, -1], 
                  Subscript[ b, 1]], 
                Times[ a, 
                  Plus[ 1, a], 
                  Power[ c, -1], 
                  Power[ 
                    Plus[ 1, c], -1], 
                  Subscript[ b, 1], 
                  Subscript[ b, 2]], 
                Times[ 
                  Rational[ 1, 2], a, 
                  Plus[ 1, a], 
                  Plus[ 2, a], 
                  Power[ c, -1], 
                  Power[ 
                    Plus[ 1, c], -1], 
                  Power[ 
                    Plus[ 2, c], -1], 
                  Subscript[ b, 1], 
                  Subscript[ b, 2], 
                  Plus[ 1, 
                    Subscript[ b, 2]]]}, 0, 3, 1],
              Editable->False], ")"}], " ", "x"}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              
              RowBox[{\(\(a\ \((1 + a)\)\ b\_1\ \((1 + 
                          b\_1)\)\)\/\(2\ c\ \((1 + c)\)\)\), 
                "+", \(\(a\ \((1 + a)\)\ \((2 + a)\)\ b\_1\ \((1 + 
                          b\_1)\)\ b\_2\ y\)\/\(2\ c\ \((1 + c)\)\ \((2 + 
                          c)\)\)\), 
                "+", \(\(a\ \((1 + a)\)\ \((2 + a)\)\ \((3 + 
                          a)\)\ b\_1\ \((1 + b\_1)\)\ b\_2\ \((1 + 
                          b\_2)\)\ y\^2\)\/\(4\ c\ \((1 + c)\)\ \((2 + 
                          c)\)\ \((3 + c)\)\)\), "+", 
                InterpretationBox[\(O[y]\^3\),
                  SeriesData[ y, 0, {}, 0, 3, 1],
                  Editable->False]}],
              SeriesData[ y, 0, {
                Times[ 
                  Rational[ 1, 2], a, 
                  Plus[ 1, a], 
                  Power[ c, -1], 
                  Power[ 
                    Plus[ 1, c], -1], 
                  Subscript[ b, 1], 
                  Plus[ 1, 
                    Subscript[ b, 1]]], 
                Times[ 
                  Rational[ 1, 2], a, 
                  Plus[ 1, a], 
                  Plus[ 2, a], 
                  Power[ c, -1], 
                  Power[ 
                    Plus[ 1, c], -1], 
                  Power[ 
                    Plus[ 2, c], -1], 
                  Subscript[ b, 1], 
                  Plus[ 1, 
                    Subscript[ b, 1]], 
                  Subscript[ b, 2]], 
                Times[ 
                  Rational[ 1, 4], a, 
                  Plus[ 1, a], 
                  Plus[ 2, a], 
                  Plus[ 3, a], 
                  Power[ c, -1], 
                  Power[ 
                    Plus[ 1, c], -1], 
                  Power[ 
                    Plus[ 2, c], -1], 
                  Power[ 
                    Plus[ 3, c], -1], 
                  Subscript[ b, 1], 
                  Plus[ 1, 
                    Subscript[ b, 1]], 
                  Subscript[ b, 2], 
                  Plus[ 1, 
                    Subscript[ b, 2]]]}, 0, 3, 1],
              Editable->False], ")"}], " ", \(x\^2\)}], "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        SeriesData[ y, 0, {1, 
          Times[ a, 
            Power[ c, -1], 
            Subscript[ b, 2]], 
          Times[ 
            Rational[ 1, 2], a, 
            Plus[ 1, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Subscript[ b, 2], 
            Plus[ 1, 
              Subscript[ b, 2]]]}, 0, 3, 1], 
        SeriesData[ y, 0, {
          Times[ a, 
            Power[ c, -1], 
            Subscript[ b, 1]], 
          Times[ a, 
            Plus[ 1, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Subscript[ b, 1], 
            Subscript[ b, 2]], 
          Times[ 
            Rational[ 1, 2], a, 
            Plus[ 1, a], 
            Plus[ 2, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Power[ 
              Plus[ 2, c], -1], 
            Subscript[ b, 1], 
            Subscript[ b, 2], 
            Plus[ 1, 
              Subscript[ b, 2]]]}, 0, 3, 1], 
        SeriesData[ y, 0, {
          Times[ 
            Rational[ 1, 2], a, 
            Plus[ 1, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Subscript[ b, 1], 
            Plus[ 1, 
              Subscript[ b, 1]]], 
          Times[ 
            Rational[ 1, 2], a, 
            Plus[ 1, a], 
            Plus[ 2, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Power[ 
              Plus[ 2, c], -1], 
            Subscript[ b, 1], 
            Plus[ 1, 
              Subscript[ b, 1]], 
            Subscript[ b, 2]], 
          Times[ 
            Rational[ 1, 4], a, 
            Plus[ 1, a], 
            Plus[ 2, a], 
            Plus[ 3, a], 
            Power[ c, -1], 
            Power[ 
              Plus[ 1, c], -1], 
            Power[ 
              Plus[ 2, c], -1], 
            Power[ 
              Plus[ 3, c], -1], 
            Subscript[ b, 1], 
            Plus[ 1, 
              Subscript[ b, 1]], 
            Subscript[ b, 2], 
            Plus[ 1, 
              Subscript[ b, 2]]]}, 0, 3, 1]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[TextData[{
  "Special cases of ",
  StyleBox["AppellF1", "MR"],
  " can reduce to less general functions. "
}], "ExampleText",
  CellTags->"AppellF1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppellF1[\(-1\), a, b, c, 1\/2, z]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(-\(\(a - 2\ c + 2\ b\ z\)\/\(2\ c\)\)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppellF1[\(-1\), a, b, c, x, y]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(-\(\(\((1 - x)\)\^\(-a\)\ \((1 - y)\)\^a\ \((\(\(-1\) + y\)\/\(\(-1\) \
+ x\))\)\^\(-a\)\ \((\(-c\) + a\ x + b\ y)\)\)\/c\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppellF1[a, b, c, b + c, x, y]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\((1 - y)\)\^\(-a\)\ Hypergeometric2F1[a, b, 
        b + c, \(x - y\)\/\(1 - y\)]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppellF1[a, b, b, c, x, \(-x\)]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(HypergeometricPFQ[{1\/2 + a\/2, a\/2, b}, {1\/2 + c\/2, c\/2}, 
      x\^2]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppellF1[a, b, \(-2\), 2, 1\/2, z]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\((2\^\(\(-3\) + a\)\ \((20\ \((6\ Gamma[a] + 
                    z\ \((\(-6\) + z + a\ z)\)\ Gamma[1 + a])\)\ Gamma[
                  b]\ HypergeometricPFQ[{a, 
                    4 - b}, {4}, \(-1\)] + \((\(-1\) + z)\)\ Gamma[
                  1 + a]\ Gamma[
                  1 + b]\ \((10\ \((\(-3\) + z + 
                          a\ z)\)\ HypergeometricPFQ[{1 + a, 
                          4 - b}, {5}, \(-1\)] + \((1 + a)\)\ \((1 + 
                          b)\)\ \((\(-1\) + z)\)\ HypergeometricPFQ[{2 + a, 
                          4 - b}, {6}, \(-1\)])\))\))\)/\((15\ Gamma[
            a]\ Gamma[b])\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[TextData[{
  "Here are some integrals that evaluate to expressions involving ",
  StyleBox["AppellF1", "MR"],
  ". "
}], "ExampleText",
  CellTags->"AppellF1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(x\^m\ \((a\ x\^r + b)\)\^n\ \((c\ x\^r + d)\)\^k\)\ \
\[DifferentialD]x\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(1\/\(1 + 
            m\)\) \((x\^\(1 + m\)\ \((b + a\ x\^r)\)\^n\ \((1 + \(a\ \
x\^r\)\/b)\)\^\(-n\)\ \((d + c\ x\^r)\)\^k\ \((1 + \(c\ x\^r\)\/d)\)\^\(-k\)\ \
AppellF1[\(1 + m\)\/r, \(-n\), \(-k\), 
            1 + \(1 + m\)\/r, \(-\(\(a\ x\^r\)\/b\)\), \(-\(\(c\ \
x\^r\)\/d\)\)])\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(x\^m\ \((a + b\ x + c\ x\^2)\)\^n\) \[DifferentialD]x\)], \
"Input",
  CellLabel->"In[9]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(1\/\(1 + 
            m\)\) \((x\^\(1 + m\)\ \((1 - \(2\ c\ x\)\/\(\(-b\) + \@\(b\^2 - \
4\ a\ c\)\))\)\^\(-n\)\ \((1 + \(2\ c\ x\)\/\(b + \@\(b\^2 - 4\ a\ c\)\))\)\^\
\(-n\)\ \((a + b\ x + c\ x\^2)\)\^n\ AppellF1[1 + m, \(-n\), \(-n\), 
            2 + m, \(-\(\(2\ c\ x\)\/\(b + \@\(b\^2 - 4\ a\ c\)\)\)\), \(2\ c\
\ x\)\/\(\(-b\) + \@\(b\^2 - 4\ a\ c\)\)])\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(Sin[x]\^m\ Cos[x]\^n\ \((1 - k\^2\ Sin[x]\^2)\)\^\(r/2\)\)\
\ \[DifferentialD]x\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(1\/\(1 + 
            m\)\) \((AppellF1[\(1 + m\)\/2, \(1 - n\)\/2, \(-\(r\/2\)\), \(3 \
+ m\)\/2, Sin[x]\^2, 
            k\^2\ Sin[x]\^2]\ Cos[x]\^\(\(-1\) + n\)\ \((Cos[x]\^2)\)\^\(1\/2 \
- n\/2\)\ Sin[x]\^\(1 + m\))\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\ \(\(Tan[x]\^n\)\(\ \)\)\/\@\(1 - k\^2\ Sin[x]\^2\)\ \
\[DifferentialD]x\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(1\/\(1 + n\)\) \((AppellF1[\(1 + n\)\/2, \(1 + n\)\/2, 
            1\/2, \(3 + n\)\/2, Sin[x]\^2, 
            k\^2\ Sin[x]\^2]\ \((Cos[x]\^2)\)\^\(\(1 + n\)\/2\)\ Tan[x]\^\(1 \
+ n\))\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"AppellF1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(\[ExponentialE]\^\(a\ x\)\ Sin[x]\^p\ Cos[x]\^q\)\ \
\[DifferentialD]x\)], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"AppellF1"],

Cell[BoxData[
    \(\(1\/\(a - \[ImaginaryI]\ \((p + 
                  q)\)\)\) \((\[ExponentialE]\^\(a\ x\)\ \((1 - \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ x\))\)\^\(-p\)\ \((1 + \[ExponentialE]\^\
\(2\ \[ImaginaryI]\ x\))\)\^\(-q\)\ AppellF1[\(-\(1\/2\)\)\ \[ImaginaryI]\ \
\((a - \[ImaginaryI]\ \((p + q)\))\), \(-q\), \(-p\), 
            1\/2\ \((2 - \[ImaginaryI]\ a - p - 
                  q)\), \(-\[ExponentialE]\^\(2\ \[ImaginaryI]\ x\)\), \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ x\)]\ Cos[x]\^q\ Sin[x]\^p)\)\)], \
"Output",
  CellLabel->"Out[12]= ",
  CellTags->"AppellF1"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Append", "ObjectName",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Append[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  " gives ",
  StyleBox["expr", "TI"],
  " with ",
  StyleBox["elem", "TI"],
  " appended. "
}], "Usage",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] Examples: ",
  StyleBox["Append[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,b", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({a, b, c}\)], "InlineOutput"],
  "; ",
  StyleBox["Append[f[a],", "MR"],
  " ",
  StyleBox["b+c]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(f[a, b + c]\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] In iteratively building a list, it is usually more \
efficient to use ",
  ButtonBox["Sow",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Reap",
    ButtonStyle->"RefGuideLink"],
  " than to use ",
  StyleBox["Append[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["new", "TI"],
  StyleBox["]", "MR"],
  " at each step. "
}], "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Append", "MR"],
  " works on ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " objects, returning ordinary lists if necessary. "
}], "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.8.6",
    ButtonData:>{"1.8.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.4.2",
    ButtonData:>{"2.4.2", "2.31"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Prepend",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Insert",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AppendTo",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PadRight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Sow",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1030", "Append"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Append"],

Cell["Here is a matrix and a vector. ", "ExampleText",
  CellTags->"Append"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((mat = {{\[ScriptA], \[ScriptB]}, {\[ScriptC], \[ScriptD]}})\) // 
      MatrixForm\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Append"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\[ScriptA]", "\[ScriptB]"},
            {"\[ScriptC]", "\[ScriptD]"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[1]//MatrixForm= ",
  CellTags->"Append"]
}, Open  ]],

Cell[BoxData[
    \(vec = {\[ScriptX], \[ScriptY]}; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Append"],

Cell[TextData[{
  "This adds ",
  StyleBox["vec", "MR"],
  " as a row to ",
  StyleBox["mat", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Append"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Append[mat, vec] // MatrixForm\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Append"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\[ScriptA]", "\[ScriptB]"},
            {"\[ScriptC]", "\[ScriptD]"},
            {"\[ScriptX]", "\[ScriptY]"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm= ",
  CellTags->"Append"]
}, Open  ]],

Cell[TextData[{
  "This adds ",
  StyleBox["vec", "MR"],
  " as a column. "
}], "ExampleText",
  CellTags->"Append"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapThread[Append, {mat, vec}] // MatrixForm\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Append"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\[ScriptA]", "\[ScriptB]", "\[ScriptX]"},
            {"\[ScriptC]", "\[ScriptD]", "\[ScriptY]"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm= ",
  CellTags->"Append"]
}, Open  ]],

Cell["\<\
This definition allows several elements to be appended to a list \
simultaneously. \
\>", "ExampleText",
  CellTags->"Append"],

Cell[BoxData[
    \(myAppend1[p_, a___] := Join[p, List[a]]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Append"],

Cell[CellGroupData[{

Cell[BoxData[
    \(myAppend1[{1, 2, 3}, 4, 5]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Append"],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"Append"]
}, Open  ]],

Cell[TextData[{
  "Here is a variation that allows more general heads than ",
  StyleBox["List", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Append"],

Cell[BoxData[
    \(myAppend2[h_[l___], a___] := h[l, a]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Append"],

Cell[TextData[{
  "Here ",
  StyleBox["t", "MR"],
  ", ",
  StyleBox["u", "MR"],
  " and ",
  StyleBox["v", "MR"],
  " are appended to expressions with heads ",
  StyleBox["Plus", "MR"],
  ", ",
  StyleBox["Times", "MR"],
  ", and ",
  StyleBox["Power", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Append"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(myAppend2[#, t, u, v] &\) /@ {r + s, r*s, r\^s}\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"Append"],

Cell[BoxData[
    \({r + s + t + u + v, r\ s\ t\ u\ v, 
      r\^\(s\^\(t\^\(u\^v\)\)\)}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"Append"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head /@ {r + s, r*s, r\^s}\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"Append"],

Cell[BoxData[
    \({Plus, Times, Power}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"Append"]
}, Open  ]],

Cell[BoxData[
    \(Clear[mat, vec]\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"Append"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AppendTo", "ObjectName",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppendTo[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  " appends ",
  StyleBox["elem", "TI"],
  " to the value of ",
  StyleBox["s", "TI"],
  ", and resets ",
  StyleBox["s", "TI"],
  " to the result. "
}], "Usage",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppendTo[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["s", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["Append[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppendTo[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  " does not evaluate ",
  StyleBox["s", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["AppendTo", "MR"],
  " repeatedly to build up a list, though ",
  ButtonBox["Sow",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Reap",
    ButtonStyle->"RefGuideLink"],
  " will usually be more efficient. "
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AppendTo", "MR"],
  " works on ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " objects, returning ordinary lists if necessary. "
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.5.4",
    ButtonData:>{"2.5.4", "4.14"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["PrependTo",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Sow",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1031", "AppendTo"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AppendTo"],

Cell["This defines a list. ", "ExampleText",
  CellTags->"AppendTo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = {1, 2, 3}\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AppendTo"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AppendTo"]
}, Open  ]],

Cell[TextData[{
  "This appends the number ",
  Cell[BoxData[
      \(TraditionalForm\`44\)], "InlineFormula"],
  " to the end of the list. "
}], "ExampleText",
  CellTags->"AppendTo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[b, 44]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AppendTo"],

Cell[BoxData[
    \({1, 2, 3, 44}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"AppendTo"]
}, Open  ]],

Cell["The original list is changed as a side effect. ", "ExampleText",
  CellTags->"AppendTo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"AppendTo"],

Cell[BoxData[
    \({1, 2, 3, 44}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"AppendTo"]
}, Open  ]],

Cell[TextData[{
  "On the other hand, ",
  StyleBox["Append", "MR"],
  " does not change the new version of the list. "
}], "ExampleText",
  CellTags->"AppendTo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Append[b, 55]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"AppendTo"],

Cell[BoxData[
    \({1, 2, 3, 44, 55}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"AppendTo"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"AppendTo"],

Cell[BoxData[
    \({1, 2, 3, 44}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"AppendTo"]
}, Open  ]],

Cell["b =.", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"AppendTo"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apply", "ObjectName",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apply[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["f", "TI"],
  " ",
  StyleBox["@@", "MR"],
  " ",
  StyleBox["expr", "TI"],
  " replaces the head of ",
  StyleBox["expr", "TI"],
  " by ",
  StyleBox["f", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Apply[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["levelspec", "TI"],
  StyleBox["]", "MR"],
  " replaces heads in parts of ",
  StyleBox["expr", "TI"],
  " specified by ",
  StyleBox["levelspec", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] Examples: ",
  StyleBox["Apply[f,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(f[a, b, c]\)], "InlineOutput"],
  "; ",
  StyleBox["Apply[Plus,", "MR"],
  " ",
  StyleBox["g[a,", "MR"],
  " ",
  StyleBox["b]]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(a + b\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] Level specifications are described in Section\
\[NonBreakingSpace]",
  ButtonBox["A.3.6",
    ButtonData:>{"A.3.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default value for ",
  StyleBox["levelspec", "TI"],
  " in ",
  StyleBox["Apply", "MR"],
  " is ",
  StyleBox["{0}", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["f", "TI"],
  " ",
  StyleBox["@@@", "MR"],
  " ",
  StyleBox["expr", "TI"],
  " is equivalent to ",
  StyleBox["Apply[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{1}]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] Examples: ",
  StyleBox["Apply[f,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,b", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["c,d", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(f[{a, b}, {c, d}]\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apply[f,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,b", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["c,d", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["1", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({f[a, b], f[c, d]}\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apply[f,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["-2]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({f[f[f[a]]]}\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Apply", "MR"],
  " operates on ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " objects just as it would on the corresponding ordinary lists. "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.2.3",
    ButtonData:>{"2.2.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Map",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Scan",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Level",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Operate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["MapThread",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Total",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 4.\
\>", "Notes",
  CellTags->{"S0.1032", "Apply"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Apply"],

Cell[TextData[{
  "This substitutes ",
  StyleBox["New", "MR"],
  " for ",
  StyleBox["Old", "MR"],
  " at the head of the expression using the shorthand notation for Apply. \
(Neither ",
  StyleBox["New", "MR"],
  " nor ",
  StyleBox["Old", "MR"],
  " has a built\[Hyphen]in meaning in ",
  StyleBox["Mathematica", "TI"],
  ".) "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(New @@ Old[a, b, c]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(New[a, b, c]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["This is the same thing. ", "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[New, Old[a, b, c]]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(New[a, b, c]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[TextData[{
  "The head of a product is ",
  StyleBox["Times", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[a  b  c]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(Times\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[TextData[{
  "The head of a list is ",
  StyleBox["List", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[{a, b, c}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(List\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[TextData[{
  "You can see heads explicitly using ",
  StyleBox["FullForm", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[a  b  c]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[5]//FullForm= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{a, b, c}]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[TextData[{
  "This substitutes ",
  StyleBox["Times", "MR"],
  " for ",
  StyleBox["List", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Times @@ {a, b, c}\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(a\ b\ c\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["This changes a line into a polygon. ", "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Polygon @@ Line[{{0, 0}, {1, 0}, {0, 1}}]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(Polygon[{{0, 0}, {1, 0}, {0, 1}}]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["\<\
This constructs a list of circles from a list of pairs of centers \
and radii. \
\>", "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Circle, {{{0, 0}, r}, {{1, 0}, s}, {{0, 1}, t}}, {1}]\)], "Input",\

  CellLabel->"In[9]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({Circle[{0, 0}, r], Circle[{1, 0}, s], Circle[{0, 1}, t]}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["Here is another way to write the previous expression. ", "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Circle @@@ {{{0, 0}, r}, {{1, 0}, s}, {{0, 1}, t}}\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({Circle[{0, 0}, r], Circle[{1, 0}, s], Circle[{0, 1}, t]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[TextData[{
  "Here, ",
  StyleBox["Apply", "MR"],
  " replaces heads in subexpressions at level ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[f, {{g[5]}, 6, h[k[7]]}, {2}]\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({{f[5]}, 6, h[f[7]]}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["Here is a list. ", "ExampleText",
  CellTags->"Apply"],

Cell[BoxData[
    \(mm = {v, w, x, y, z}; \)], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"Apply"],

Cell[TextData[{
  "This defines a function ",
  StyleBox["ff", "MR"],
  " that permutes ",
  StyleBox["mm", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[BoxData[
    \(Evaluate[ff /@ {v, w, x, y, z}] = {z, y, w, x, v}; \)], "Input",
  CellLabel->"In[13]:= ",
  CellTags->"Apply"],

Cell["The permutation can be written as a list of ordered pairs. ", \
"ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pairs = Transpose[{mm, ff /@ mm}]\)], "Input",
  CellLabel->"In[14]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({{v, z}, {w, y}, {x, w}, {y, x}, {z, v}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["Another way to write the permutation is as a list of rules. ", \
"ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rules = Rule @@@ pairs\)], "Input",
  CellLabel->"In[15]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({v \[Rule] z, w \[Rule] y, x \[Rule] w, y \[Rule] x, 
      z \[Rule] v}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell["\<\
These rules can be represented more compactly as a list of cycles. \
\
\>", "ExampleText",
  CellTags->"Apply"],

Cell[BoxData[
    \({{v, z}, {w, y, x}}; \)], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"Apply"],

Cell[TextData[{
  "This defines the function ",
  StyleBox["CyclesfromRules", "MR"],
  " that finds all cycles from a list of rules. "
}], "ExampleText",
  CellTags->"Apply"],

Cell[BoxData[
    \(CyclesfromRules[rules_] := 
      Cases[Apply[CyclesfromRulesAux, rules, {1}], _List]\)], "Input",
  CellLabel->"In[17]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(CyclesfromRulesAux /: {e1___, CyclesfromRulesAux[s__, a_], e2___, 
        CyclesfromRulesAux[t___, a_, b__], e3___} := {e1, 
        CyclesfromRulesAux[s, a, b], e2, e3}\)], "Input",
  CellLabel->"In[18]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \(CyclesfromRulesAux[t___, a_, e___, a_] := {a, e}\)], "Input",
  CellLabel->"In[19]:= ",
  CellTags->"Apply"],

Cell[TextData[{
  "Here are the cycles of ",
  StyleBox["ff", "MR"],
  " using ",
  StyleBox["CyclesfromRules", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Apply"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclesfromRules[rules]\)], "Input",
  CellLabel->"In[20]:= ",
  CellTags->"Apply"],

Cell[BoxData[
    \({{v, z}, {w, y, x}}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"Apply"]
}, Open  ]],

Cell[BoxData[
    \(Clear[ff, mm, pairs, rules]\)], "Input",
  CellLabel->"In[21]:= ",
  CellTags->"Apply"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCos", "ObjectName",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCos[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc cosine ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(cos\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  " between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCos[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.1.3",
    ButtonData:>{"1.1.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1033", "ArcCos"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCos"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcCos[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCos"],

Cell[BoxData[
    \(\(-\(1\/\@\(1 - z\^2\)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCos"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcCos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCos[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCos"],

Cell[BoxData[
    \(\(-\@\(1 - z\^2\)\) + z\ ArcCos[z]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcCos"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`11\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCos[z], {z, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCos"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(\[Pi]\/2\), "-", "z", "-", \(z\^3\/6\), 
        "-", \(\(3\ z\^5\)\/40\), "-", \(\(5\ z\^7\)\/112\), 
        "-", \(\(35\ z\^9\)\/1152\), "-", \(\(63\ z\^11\)\/2816\), "+", 
        InterpretationBox[\(O[z]\^12\),
          SeriesData[ z, 0, {}, 0, 12, 1],
          Editable->False]}],
      SeriesData[ z, 0, {
        Times[ 
          Rational[ 1, 2], Pi], -1, 0, 
        Rational[ -1, 6], 0, 
        Rational[ -3, 40], 0, 
        Rational[ -5, 112], 0, 
        Rational[ -35, 1152], 0, 
        Rational[ -63, 2816]}, 0, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCos"]
}, Open  ]],

Cell[TextData[{
  "Here are two integrals that involve ",
  StyleBox["ArcCos", "MR"],
  ". "
}], "ExampleText",
  CellTags->"ArcCos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1 
        x \@\( 1 - x\^2\)\ ArcCos[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArcCos"],

Cell[BoxData[
    \(\(-\(2\/9\)\) + \[Pi]\/6\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"ArcCos"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\ \(x\^s\) ArcCos[x], {x, 0, 1}, 
      Assumptions -> Re[s] > \(-1\)]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"ArcCos"],

Cell[BoxData[
    \(\(\@\[Pi]\ Gamma[1 + s\/2]\)\/\(\((1 + s)\)\^2\ Gamma[\(1 + \
s\)\/2]\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"ArcCos"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCosh", "ObjectName",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCosh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the inverse hyperbolic cosine ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(cosh\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCosh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ArcSech",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1034", "ArcCosh"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCosh"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCosh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcCosh[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCosh"],

Cell[BoxData[
    \(1\/\(\@\(\(-1\) + x\)\ \@\(1 + x\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCosh"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcCosh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCosh[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCosh"],

Cell[BoxData[
    \(\((\(-1\) - x)\)\ \@\(\(\(-1\) + x\)\/\(1 + x\)\) + 
      x\ ArcCosh[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcCosh"]
}, Open  ]],

Cell[TextData[{
  "This gives a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCosh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCosh[x], {x, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCosh"],

Cell[BoxData[
    RowBox[{\(\((\(-1\))\)\^Floor[Arg[x]\/\(2\ \[Pi]\)]\), " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(\(\[ImaginaryI]\ \[Pi]\)\/2\), "-", \(\[ImaginaryI]\ x\), 
            "-", \(\(\[ImaginaryI]\ x\^3\)\/6\), 
            "-", \(\(3\ \[ImaginaryI]\ x\^5\)\/40\), 
            "-", \(\(5\ \[ImaginaryI]\ x\^7\)\/112\), 
            "-", \(\(35\ \[ImaginaryI]\ x\^9\)\/1152\), 
            "-", \(\(63\ \[ImaginaryI]\ x\^11\)\/2816\), "+", 
            InterpretationBox[\(O[x]\^12\),
              SeriesData[ x, 0, {}, 0, 12, 1],
              Editable->False]}],
          SeriesData[ x, 0, {
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], Pi], 
            Complex[ 0, -1], 0, 
            Complex[ 0, 
              Rational[ -1, 6]], 0, 
            Complex[ 0, 
              Rational[ -3, 40]], 0, 
            Complex[ 0, 
              Rational[ -5, 112]], 0, 
            Complex[ 0, 
              Rational[ -35, 1152]], 0, 
            Complex[ 0, 
              Rational[ -63, 2816]]}, 0, 12, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCosh"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCot", "ObjectName",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCot[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc cotangent ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(cot\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ", excluding ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCot[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1035", "ArcCot"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCot"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcCot[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCot"],

Cell[BoxData[
    \(\(-\(1\/\(1 + z\^2\)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCot"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcCot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCot[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCot"],

Cell[BoxData[
    \(z\ ArcCot[z] + 1\/2\ Log[1 + z\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcCot"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`9\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCot[z], {z, 0, 9}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCot"],

Cell[BoxData[
    RowBox[{\(1\/2\ \((\(-1\))\)\^Floor[\(\[Pi] + 2\ Arg[z]\)\/\(2\ \[Pi]\)]\ \
\[Pi]\), "+", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(-z\), "+", \(z\^3\/3\), "-", \(z\^5\/5\), 
            "+", \(z\^7\/7\), "-", \(z\^9\/9\), "+", 
            InterpretationBox[\(O[z]\^10\),
              SeriesData[ z, 0, {}, 1, 10, 1],
              Editable->False]}],
          SeriesData[ z, 0, {-1, 0, 
            Rational[ 1, 3], 0, 
            Rational[ -1, 5], 0, 
            Rational[ 1, 7], 0, 
            Rational[ -1, 9]}, 1, 10, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCot"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCoth", "ObjectName",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCoth[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the inverse hyperbolic cotangent ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(coth\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCoth[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1036", "ArcCoth"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCoth"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCoth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcCoth[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCoth"],

Cell[BoxData[
    \(1\/\(1 - x\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCoth"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcCoth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCoth[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCoth"],

Cell[BoxData[
    \(x\ ArcCoth[x] + 1\/2\ Log[\(-1\) + x\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcCoth"]
}, Open  ]],

Cell[TextData[{
  "This is a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCoth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCoth[x], {x, 0, 9}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCoth"],

Cell[BoxData[
    RowBox[{\(-\[ImaginaryI]\), " ", 
      RowBox[{"(", 
        RowBox[{\(1\/2\ \((\(-1\))\)\^Floor[Arg[x]\/\[Pi]]\ \[Pi]\), "+", 
          RowBox[{"(", 
            InterpretationBox[
              
              RowBox[{\(\[ImaginaryI]\ x\), 
                "+", \(\(\[ImaginaryI]\ x\^3\)\/3\), 
                "+", \(\(\[ImaginaryI]\ x\^5\)\/5\), 
                "+", \(\(\[ImaginaryI]\ x\^7\)\/7\), 
                "+", \(\(\[ImaginaryI]\ x\^9\)\/9\), "+", 
                InterpretationBox[\(O[x]\^10\),
                  SeriesData[ x, 0, {}, 1, 10, 1],
                  Editable->False]}],
              SeriesData[ x, 0, {
                Complex[ 0, 1], 0, 
                Complex[ 0, 
                  Rational[ 1, 3]], 0, 
                Complex[ 0, 
                  Rational[ 1, 5]], 0, 
                Complex[ 0, 
                  Rational[ 1, 7]], 0, 
                Complex[ 0, 
                  Rational[ 1, 9]]}, 1, 10, 1],
              Editable->False], ")"}]}], ")"}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCoth"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCsc", "ObjectName",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCsc[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc cosecant ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(csc\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  " outside the interval ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ", excluding ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCsc[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1037", "ArcCsc"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCsc"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCsc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcCsc[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCsc"],

Cell[BoxData[
    \(\(-\(1\/\(\@\(1 - 1\/z\^2\)\ z\^2\)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCsc"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcCsc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCsc[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCsc"],

Cell[BoxData[
    \(z\ ArcCsc[z] + 
      Log[z\ \((1 + \@\(\(\(-1\) + z\^2\)\/z\^2\))\)]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcCsc"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion of ",
  Cell[BoxData[
      \(ArcCsc[1 + z\^2]\)], "InlineFormula"],
  " around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCsc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCsc[1 + z\^2], {z, 0, 5}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCsc"],

Cell[BoxData[
    RowBox[{\(\[Pi]\/2\), "+", 
      RowBox[{\(\((\(-1\))\)\^Floor[\(\[Pi] - 2\ Arg[z] - Arg[1\/\(1 + \
z\^2\)]\)\/\(2\ \[Pi]\)]\), " ", 
        RowBox[{"(", 
          InterpretationBox[
            
            RowBox[{\(-\(\@2\ z\)\), "+", \(\(5\ z\^3\)\/\(6\ \@2\)\), 
              "-", \(\(43\ z\^5\)\/\(80\ \@2\)\), "+", 
              InterpretationBox[\(O[z]\^6\),
                SeriesData[ z, 0, {}, 1, 6, 1],
                Editable->False]}],
            SeriesData[ z, 0, {
              Times[ -1, 
                Power[ 2, 
                  Rational[ 1, 2]]], 0, 
              Times[ 
                Rational[ 5, 6], 
                Power[ 2, 
                  Rational[ -1, 2]]], 0, 
              Times[ 
                Rational[ -43, 80], 
                Power[ 2, 
                  Rational[ -1, 2]]]}, 1, 6, 1],
            Editable->False], ")"}]}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCsc"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcCsch", "ObjectName",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCsch[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the inverse hyperbolic cosecant ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(csch\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcCsch[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1038", "ArcCsch"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcCsch"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcCsch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcCsch[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcCsch"],

Cell[BoxData[
    \(\(-\(1\/\(\@\(1 + 1\/x\^2\)\ x\^2\)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcCsch"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcCsch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcCsch[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcCsch"],

Cell[BoxData[
    \(x\ ArcCsch[x] + Log[x\ \((1 + \@\(\(1 + x\^2\)\/x\^2\))\)]\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"ArcCsch"]
}, Open  ]],

Cell[TextData[{
  "This is a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcCsch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcCsch[x], {x, 2, 3}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcCsch"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(ArcSinh[1\/2]\), "-", \(\(x - 2\)\/\(2\ \@5\)\), 
        "+", \(\(9\ \((x - 2)\)\^2\)\/\(40\ \@5\)\), 
        "-", \(\(59\ \((x - 2)\)\^3\)\/\(600\ \@5\)\), "+", 
        InterpretationBox[\(O[x - 2]\^4\),
          SeriesData[ x, 2, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 2, {
        ArcSinh[ 
          Rational[ 1, 2]], 
        Times[ 
          Rational[ -1, 2], 
          Power[ 5, 
            Rational[ -1, 2]]], 
        Times[ 
          Rational[ 9, 40], 
          Power[ 5, 
            Rational[ -1, 2]]], 
        Times[ 
          Rational[ -59, 600], 
          Power[ 5, 
            Rational[ -1, 2]]]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcCsch"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcSec", "ObjectName",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSec[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc secant ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sec\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  " outside the interval ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ", excluding ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSec[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1039", "ArcSec"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcSec"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcSec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcSec[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcSec"],

Cell[BoxData[
    \(1\/\(\@\(1 - 1\/z\^2\)\ z\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcSec"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcSec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcSec[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcSec"],

Cell[BoxData[
    \(z\ ArcSec[z] - 
      Log[z\ \((1 + \@\(\(\(-1\) + z\^2\)\/z\^2\))\)]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcSec"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion of ",
  Cell[BoxData[
      \(ArcSec[1 + z\^2]\)], "InlineFormula"],
  " around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcSec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcSec[1 + z\^2], {z, 0, 5}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcSec"],

Cell[BoxData[
    RowBox[{\(\((\(-1\))\)\^Floor[\(\[Pi] - 2\ Arg[z] - Arg[1\/\(1 + \
z\^2\)]\)\/\(2\ \[Pi]\)]\), " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(\@2\ z\), "-", \(\(5\ z\^3\)\/\(6\ \@2\)\), 
            "+", \(\(43\ z\^5\)\/\(80\ \@2\)\), "+", 
            InterpretationBox[\(O[z]\^6\),
              SeriesData[ z, 0, {}, 1, 6, 1],
              Editable->False]}],
          SeriesData[ z, 0, {
            Power[ 2, 
              Rational[ 1, 2]], 0, 
            Times[ 
              Rational[ -5, 6], 
              Power[ 2, 
                Rational[ -1, 2]]], 0, 
            Times[ 
              Rational[ 43, 80], 
              Power[ 2, 
                Rational[ -1, 2]]]}, 1, 6, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcSec"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcSech", "ObjectName",
  CellTags->{"S0.1040", "ArcSech"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSech[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the inverse hyperbolic secant ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sech\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1040", "ArcSech"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1040", "ArcSech"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSech[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to 0 and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1040", "ArcSech"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1040", "ArcSech"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1040", "ArcSech"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcSech"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcSech"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcSech[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcSech"],

Cell[BoxData[
    \(\(-\(1\/\(x\ \@\(\(1 - x\)\/\(1 + x\)\)\ \((1 + x)\)\)\)\)\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"ArcSech"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcSech"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcSech[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcSech"],

Cell[BoxData[
    \(x\ ArcSech[x] - 
      ArcTan[\(x\ \@\(\(1 - x\)\/\(1 + x\)\)\)\/\(\(-1\) + x\)]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcSech"]
}, Open  ]],

Cell[TextData[{
  "This is a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcSech"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcSech[x], {x, 2, 3}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcSech"],

Cell[BoxData[
    RowBox[{\(\((\(-1\))\)\^Floor[Arg[\(-\(1\/2\)\) + 1\/x]\/\(2\ \[Pi]\)]\), 
      " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(\(\[ImaginaryI]\ \[Pi]\)\/3\), 
            "+", \(\(\[ImaginaryI]\ \((x - 2)\)\)\/\(2\ \@3\)\), 
            "+", \(-\(\(7\ \[ImaginaryI]\ \((x - 2)\)\^2\)\/\(24\ \@3\)\)\), 
            "+", \(\(13\ \[ImaginaryI]\ \((x - 2)\)\^3\)\/\(72\ \@3\)\), "+", 
            
            InterpretationBox[\(O[x - 2]\^4\),
              SeriesData[ x, 2, {}, 0, 4, 1],
              Editable->False]}],
          SeriesData[ x, 2, {
            Times[ 
              Complex[ 0, 
                Rational[ 1, 3]], Pi], 
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], 
              Power[ 3, 
                Rational[ -1, 2]]], 
            Times[ 
              Complex[ 0, 
                Rational[ -7, 24]], 
              Power[ 3, 
                Rational[ -1, 2]]], 
            Times[ 
              Complex[ 0, 
                Rational[ 13, 72]], 
              Power[ 3, 
                Rational[ -1, 2]]]}, 0, 4, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcSech"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcSin", "ObjectName",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSin[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc sine ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sin\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  " between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSin[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.1.3",
    ButtonData:>{"1.1.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1041", "ArcSin"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcSin"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcSin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcSin[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(1\/\@\(1 - z\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcSin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcSin[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(\@\(1 - z\^2\) + z\ ArcSin[z]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`11\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcSin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcSin[z], {z, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "z", "+", \(z\^3\/6\), "+", \(\(3\ z\^5\)\/40\), 
        "+", \(\(5\ z\^7\)\/112\), "+", \(\(35\ z\^9\)\/1152\), 
        "+", \(\(63\ z\^11\)\/2816\), "+", 
        InterpretationBox[\(O[z]\^12\),
          SeriesData[ z, 0, {}, 1, 12, 1],
          Editable->False]}],
      SeriesData[ z, 0, {1, 0, 
        Rational[ 1, 6], 0, 
        Rational[ 3, 40], 0, 
        Rational[ 5, 112], 0, 
        Rational[ 35, 1152], 0, 
        Rational[ 63, 2816]}, 1, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell[TextData[{
  "Here are some integrals that involve ",
  StyleBox["ArcSin", "MR"],
  ". "
}], "ExampleText",
  CellTags->"ArcSin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1\( ArcSin[x]\^2\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(1\/4\ \((\(-8\) + \[Pi]\^2)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1 ArcSin[x]\^2\/\(\(x\^2\) \@\(1 - x\^2\)\)\ \
\[DifferentialD]x\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(\[Pi]\ Log[2]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1\(\( 
              x\ ArcSin[
                x]\)\/\@\(1 - k\^2\ x\^2\)\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(If[Re[k\^2] \[LessEqual] 1 || 
        Im[k\^2] \[NotEqual] 
          0, \(-\(\(\@\(1 - k\^2\)\ \[Pi] - 
              2\ EllipticE[k\^2]\)\/\(2\ k\^2\)\)\), 
      Integrate[\(x\ ArcSin[x]\)\/\@\(1 - k\^2\ x\^2\), {x, 0, 1}, 
        Assumptions \[Rule] 
          Im[k] \[Equal] 0 && \((Re[k] < \(-1\) || Re[k] > 1)\)]]\)], "Output",\

  CellLabel->"Out[6]= ",
  CellTags->"ArcSin"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1\(\( x\ ArcSin[x]\)\/\(1 + 
              s\ x\^2\)\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"ArcSin"],

Cell[BoxData[
    \(If[Im[s] \[NotEqual] 0 || 
        1 + Re[s] \[GreaterEqual] 
          0, \(\[Pi]\ \((Log[4] + Log[1 + s] - 2\ Log[1 + \@\(1 + s\)])\)\)\/\
\(4\ s\), 
      Integrate[\(x\ ArcSin[x]\)\/\(1 + s\ x\^2\), {x, 0, 1}, 
        Assumptions \[Rule] s < \(-1\)]]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"ArcSin"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcSinh", "ObjectName",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSinh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the inverse hyperbolic sine ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(sinh\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcSinh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"], "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"], "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ArcCsch",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1042", "ArcSinh"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcSinh"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcSinh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcSinh[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcSinh"],

Cell[BoxData[
    \(1\/\@\(1 + x\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcSinh"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcSinh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcSinh[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcSinh"],

Cell[BoxData[
    \(\(-\@\(1 + x\^2\)\) + x\ ArcSinh[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcSinh"]
}, Open  ]],

Cell[TextData[{
  "This is a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcSinh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcSinh[x], {x, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcSinh"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "-", \(x\^3\/6\), "+", \(\(3\ x\^5\)\/40\), 
        "-", \(\(5\ x\^7\)\/112\), "+", \(\(35\ x\^9\)\/1152\), 
        "-", \(\(63\ x\^11\)\/2816\), "+", 
        InterpretationBox[\(O[x]\^12\),
          SeriesData[ x, 0, {}, 1, 12, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 6], 0, 
        Rational[ 3, 40], 0, 
        Rational[ -5, 112], 0, 
        Rational[ 35, 1152], 0, 
        Rational[ -63, 2816]}, 1, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcSinh"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcTan", "ObjectName",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcTan[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the arc tangent ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(tan\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ArcTan[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " gives the arc tangent of ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox["y",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", taking into account which quadrant the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["x",
              "TI"], ",", 
            StyleBox["y",
              "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
  " is in. "
}], "Usage",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell["\<\
\[FilledSmallSquare] All results are given in radians. \
\>", \
"Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] For real ",
  StyleBox["z", "TI"],
  ", the results are always in the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcTan[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"], "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        RowBox[{"+", 
          StyleBox["i",
            "TI"], "\[Infinity]"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["x", "TI"],
  " or ",
  StyleBox["y", "TI"],
  " is complex, then ",
  StyleBox["ArcTan[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " gives ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          StyleBox["i",
            "TI"], " ", "log", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  StyleBox["x",
                    "TI"], "+", 
                  StyleBox["i",
                    "TI"], 
                  StyleBox["y",
                    "TI"]}], ")"}], "/", 
              SqrtBox[
                RowBox[{
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], "2"], "+", 
                  SuperscriptBox[
                    StyleBox["y",
                      "TI"], "2"]}]]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". When ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "2"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["ArcTan[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " gives the number ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "cos", "\[Phi]"}], TraditionalForm]], 
    "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], "=", "sin", "\[Phi]"}], TraditionalForm]], 
    "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.1.3",
    ButtonData:>{"1.1.3", "3.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Arg",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1043", "ArcTan"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcTan"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcTan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z ArcTan[z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcTan"],

Cell[BoxData[
    \(1\/\(1 + z\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcTan"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"ArcTan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcTan[z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcTan"],

Cell[BoxData[
    \(z\ ArcTan[z] - 1\/2\ Log[1 + z\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcTan"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`11\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcTan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcTan[z], {z, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcTan"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "z", "-", \(z\^3\/3\), "+", \(z\^5\/5\), "-", \(z\^7\/7\), 
        "+", \(z\^9\/9\), "-", \(z\^11\/11\), "+", 
        InterpretationBox[\(O[z]\^12\),
          SeriesData[ z, 0, {}, 1, 12, 1],
          Editable->False]}],
      SeriesData[ z, 0, {1, 0, 
        Rational[ -1, 3], 0, 
        Rational[ 1, 5], 0, 
        Rational[ -1, 7], 0, 
        Rational[ 1, 9], 0, 
        Rational[ -1, 11]}, 1, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcTan"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArcTanh", "ObjectName",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcTanh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the hyperbolic arc tangent ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(tanh\^\(-1\)\), 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.7",
    ButtonData:>{"3.2.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArcTanh[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has branch cut discontinuities in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+1\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ArcCoth",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1044", "ArcTanh"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArcTanh"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArcTanh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x ArcTanh[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArcTanh"],

Cell[BoxData[
    \(1\/\(1 - x\^2\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArcTanh"]
}, Open  ]],

Cell["This is an indefinite integral. ", "ExampleText",
  CellTags->"ArcTanh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]ArcTanh[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArcTanh"],

Cell[BoxData[
    \(x\ ArcTanh[x] + 1\/2\ Log[\(-1\) + x\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArcTanh"]
}, Open  ]],

Cell[TextData[{
  "This is a power series expansion about ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArcTanh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[ArcTanh[x], {x, 0, 11}]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArcTanh"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "+", \(x\^3\/3\), "+", \(x\^5\/5\), "+", \(x\^7\/7\), 
        "+", \(x\^9\/9\), "+", \(x\^11\/11\), "+", 
        InterpretationBox[\(O[x]\^12\),
          SeriesData[ x, 0, {}, 1, 12, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ 1, 3], 0, 
        Rational[ 1, 5], 0, 
        Rational[ 1, 7], 0, 
        Rational[ 1, 9], 0, 
        Rational[ 1, 11]}, 1, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArcTanh"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arg", "ObjectName",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the argument of the complex number ",
  StyleBox["z", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is left unevaluated if ",
  StyleBox["z", "TI"],
  " is not a numeric quantity. "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the phase angle of ",
  StyleBox["z", "TI"],
  " in radians. "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] The result from ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " is always between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Pi]\)\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Arg[", "MR"],
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.1.5",
    ButtonData:>{"1.1.5", "5.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.2.2",
    ButtonData:>{"3.2.2", "2.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ArcTan",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Sign",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1045", "Arg"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Arg"],

Cell[TextData[{
  "The argument of a complex number ",
  StyleBox["z", "MR"],
  " gives the angle that the line from ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to ",
  StyleBox["z", "MR"],
  " makes with the positive real axis. "
}], "ExampleText",
  CellTags->"Arg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Arg[1\/2 + \(\(\@3\) \[ImaginaryI]\)\/2]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Arg"],

Cell[BoxData[
    \(\[Pi]\/3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Arg"]
}, Open  ]],

Cell["This gives the arguments of the units in the complex plane. ", \
"ExampleText",
  CellTags->"Arg"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Arg[1], Arg[\[ImaginaryI]], Arg[\(-1\)], 
      Arg[\(-\[ImaginaryI]\)]}\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Arg"],

Cell[BoxData[
    \({0, \[Pi]\/2, \[Pi], \(-\(\[Pi]\/2\)\)}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Arg"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArithmeticGeometricMean", "ObjectName",
  CellTags->{"S0.1046", "ArithmeticGeometricMean"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArithmeticGeometricMean[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the arithmetic\[Hyphen]geometric mean of ",
  StyleBox["a", "TI"],
  " and ",
  StyleBox["b", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1046", "ArithmeticGeometricMean"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.12",
    ButtonData:>{"3.2.12", "12.45"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1046", "ArithmeticGeometricMean"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1046", "ArithmeticGeometricMean"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArithmeticGeometricMean"],

Cell[TextData[{
  StyleBox["ArithmeticGeometricMean", "MR"],
  " always lies between the arithmetic and geometric means. "
}], "ExampleText",
  CellTags->"ArithmeticGeometricMean"],

Cell[BoxData[
    \({x, y} = {Random[], 10 + Random[]}; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArithmeticGeometricMean"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Min[x, y], \@\(x\ y\), ArithmeticGeometricMean[x, y], \(x + y\)\/2, 
      Max[x, y]}\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArithmeticGeometricMean"],

Cell[BoxData[
    \({0.056070794834861534`, 0.7720423297217679`, 2.5181084727404217`, 
      5.34318529530711`, 10.63029979577936`}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArithmeticGeometricMean"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ArithmeticGeometricMean", "MR"],
  " is symmetric in its arguments. "
}], "ExampleText",
  CellTags->"ArithmeticGeometricMean"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      ArithmeticGeometricMean[a, b] == 
        ArithmeticGeometricMean[b, a]]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArithmeticGeometricMean"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArithmeticGeometricMean"]
}, Open  ]],

Cell["\<\
The arithmetic\[Hyphen]geometric mean of two positive real numbers \
can be expressed in terms of an elliptic function. \
\>", "ExampleText",
  CellTags->"ArithmeticGeometricMean"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArithmeticGeometricMean[1, x] == \[Pi]\/\(2\ EllipticK[1 - x\^2]\) /. 
      x -> Random\ [Real, {1, 10}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArithmeticGeometricMean"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"ArithmeticGeometricMean"]
}, Open  ]],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"ArithmeticGeometricMean"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_a ArithmeticGeometricMean[a, b]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"ArithmeticGeometricMean"],

Cell[BoxData[
    \(\(1\/\(a\ \((a - b)\)\ \[Pi]\)\) \((ArithmeticGeometricMean[a, 
            b]\ \((a\ \[Pi] - 
              2\ ArithmeticGeometricMean[a, 
                  b]\ EllipticE[\((a - b)\)\^2\/\((a + b)\)\^2])\))\)\)], \
"Output",
  CellLabel->"Out[5]= ",
  CellTags->"ArithmeticGeometricMean"]
}, Open  ]],

Cell[BoxData[
    \(Clear[x, y]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"ArithmeticGeometricMean"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Array", "ObjectName",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Array[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " generates a list of length ",
  StyleBox["n", "TI"],
  ", with elements ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Array[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " generates an ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["n",
              "TI"], "1"], "\[Cross]", 
          SubscriptBox[
            StyleBox["n",
              "TI"], "2"], "\[Cross]", "..."}], TraditionalForm]], 
    "InlineFormula"],
  " array of nested lists, with elements ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Array[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " generates a list using the index origins ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " (default ",
  StyleBox["1", "MR"],
  "). \n\[FilledSmallSquare] ",
  StyleBox["Array[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["origin", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " uses head ",
  StyleBox["h", "TI"],
  ", rather than ",
  ButtonBox["List",
    ButtonStyle->"RefGuideLink"],
  ", for each level of the array. "
}], "Usage",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] Examples: ",
  StyleBox["Array[f,", "MR"],
  " ",
  StyleBox["3]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({f[1], f[2], f[3]}\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Array[f,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["2,", "MR"],
  " ",
  StyleBox["3", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({{f[1, 1], f[1, 2], f[1, 3]}, {f[2, 1], f[2, 2], f[2, 3]}}\)], 
    "InlineOutput"],
  " generates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Array[#1^#2", "MR"],
  " ",
  StyleBox["&,", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["2,", "MR"],
  " ",
  StyleBox["2", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({{1, 1}, {2, 4}}\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Array[f,", "MR"],
  " ",
  StyleBox["3,", "MR"],
  " ",
  StyleBox["0]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \({f[0], f[1], f[2]}\)], "InlineOutput"],
  " generates an array with index origin ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Array[f,", "MR"],
  " ",
  StyleBox["3,", "MR"],
  " ",
  StyleBox["1,", "MR"],
  " ",
  StyleBox["Plus]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(f[1] + f[2] + f[3]\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] Note that the dimensions given to ",
  StyleBox["Array", "MR"],
  " are ",
  StyleBox["not", "TI"],
  " in standard ",
  StyleBox["Mathematica", "TI"],
  " iterator notation. "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.8.3",
    ButtonData:>{"1.8.3", "3.14"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.2.6",
    ButtonData:>{"2.2.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Table",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 4.\
\>", "Notes",
  CellTags->{"S0.1047", "Array"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Array"],

Cell[TextData[{
  "This creates an array of ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  " elements. "
}], "ExampleText",
  CellTags->"Array"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[a, 3]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Array"],

Cell[BoxData[
    \({a[1], a[2], a[3]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Array"]
}, Open  ]],

Cell[TextData[{
  "This creates an array of ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  " elements with ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  " elements each. "
}], "ExampleText",
  CellTags->"Array"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[a, {2, 3}]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Array"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2], a[1, 3]}, {a[2, 1], a[2, 2], a[2, 3]}}\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"Array"]
}, Open  ]],

Cell[TextData[{
  "This array starts its index at ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"Array"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[a, {2, 3}, 0]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Array"],

Cell[BoxData[
    \({{a[0, 0], a[0, 1], a[0, 2]}, {a[1, 0], a[1, 1], a[1, 2]}}\)], "Output",\

  CellLabel->"Out[3]= ",
  CellTags->"Array"]
}, Open  ]],

Cell[TextData[{
  "Since the function ",
  StyleBox["Plus", "MR"],
  " is specified here, the head of the array changes to ",
  StyleBox["Plus", "MR"],
  " from its default value ",
  StyleBox["List", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Array"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[a, {2, 3}, 1, Plus]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Array"],

Cell[BoxData[
    \(a[1, 1] + a[1, 2] + a[1, 3] + a[2, 1] + a[2, 2] + a[2, 3]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Array"]
}, Open  ]],

Cell[TextData[{
  "This array uses the index origins ",
  Cell[BoxData[
      \(TraditionalForm\`10\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`20\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"Array"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[a, {2, 3}, {10, 20}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Array"],

Cell[BoxData[
    \({{a[10, 20], a[10, 21], a[10, 22]}, {a[11, 20], a[11, 21], 
        a[11, 22]}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"Array"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArrayDepth", "ObjectName",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayDepth[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives the depth to which ",
  StyleBox["expr", "TI"],
  " is a full array, with all the parts at a particular level being lists of \
the same length, or is a ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " object. "
}], "Usage",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayDepth[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["Length[Dimensions[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[TextData[{
  "\[FilledSmallSquare] Examples: ",
  StyleBox["ArrayDepth[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,b", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(1\)], "InlineOutput"],
  "; ",
  StyleBox["ArrayDepth[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["a,", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["b", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  StyleBox["]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      \(1\)], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.4.3",
    ButtonData:>{"2.4.3", "3.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.7.11",
    ButtonData:>{"3.7.11", "11.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Dimensions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Depth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ArrayQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["VectorQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["MatrixQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PadLeft",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1048", "ArrayDepth"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArrayDepth"],

Cell[TextData[{
  "The array depth of a matrix is ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArrayDepth"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ArrayDepth", "[", 
      TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
              {"a", "b"},
              {"c", "d"},
              {"e", "f"}
              }], "\[NoBreak]", ")"}],
        Function[ BoxForm`e$, 
          MatrixForm[ BoxForm`e$]]], "]"}]], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArrayDepth"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"ArrayDepth"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]4\[Cross]3\[Cross]1\)], "InlineFormula"],
  " tensor. "
}], "ExampleText",
  CellTags->"ArrayDepth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\[ScriptT] = Array[\((#1 + #2 + #3 + #4)\) &, {2, 4, 3, 1}])\) // 
      MatrixForm\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArrayDepth"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"4"},
                    {"5"},
                    {"6"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"5"},
                    {"6"},
                    {"7"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"6"},
                    {"7"},
                    {"8"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"7"},
                    {"8"},
                    {"9"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"5"},
                    {"6"},
                    {"7"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"6"},
                    {"7"},
                    {"8"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"7"},
                    {"8"},
                    {"9"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"8"},
                    {"9"},
                    {"10"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm= ",
  CellTags->"ArrayDepth"]
}, Open  ]],

Cell[TextData[{
  "The array depth of ",
  Cell[BoxData[
      \(\[ScriptT]\)], "InlineFormula"],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`4\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArrayDepth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayDepth[\[ScriptT]]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArrayDepth"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArrayDepth"]
}, Open  ]],

Cell["This is the same thing. ", "ExampleText",
  CellTags->"ArrayDepth"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Dimensions[\[ScriptT]]]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArrayDepth"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"ArrayDepth"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArrayPlot", "ObjectName",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayPlot[", "MR"],
  StyleBox["array", "TI"],
  StyleBox["]", "MR"],
  " generates a plot in which the values in an array are shown in a discrete \
array of squares. "
}], "Usage",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayPlot[", "MR"],
  StyleBox["array", "TI"],
  StyleBox["]", "MR"],
  " arranges successive rows of ",
  StyleBox["array", "TI"],
  " down the page, and successive columns across, just as a table or grid \
would normally be formatted. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["array", "TI"],
  " contains ",
  StyleBox["0", "MR"],
  "'s and ",
  StyleBox["1", "MR"],
  "'s, the ",
  StyleBox["1", "MR"],
  "'s will appear as black squares and the ",
  StyleBox["0", "MR"],
  "'s as white squares. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayPlot", "MR"],
  " by default generates grayscale output, in which zero values are shown \
white, and the maximum positive or negative value is shown black. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayPlot", "MR"],
  " has the same options as ",
  ButtonBox["Graphics",
    ButtonStyle->"RefGuideLink"],
  ", with the following additions and changes: "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              ButtonBox["AspectRatio",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Automatic",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["ratio of height to width "]},
          {Cell[TextData[{
              ButtonBox["ColorFunction",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Automatic",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["how each cell should be colored "]},
          {Cell[TextData[{
              ButtonBox["ColorFunctionScaling",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["False",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "whether to scale the argument to ",
              ButtonBox["ColorFunction",
                ButtonStyle->"RefGuideLink"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ColorRules", "MR"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Automatic",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["rules for determining colors from values "]},
          {Cell[TextData[{
              ButtonBox["DataRange",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["All",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the range of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " values to assume "
            }]]},
          {Cell[TextData[{
              ButtonBox["Frame",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Automatic",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["whether to draw a frame around the plot "]},
          {Cell[TextData[{
              ButtonBox["FrameTicks",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["None",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["what ticks to include on the frame "]},
          {Cell[TextData[{
              ButtonBox["MaxPlotPoints",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Infinity",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["the maximum number of points to include "]},
          {Cell[TextData[{
              ButtonBox["Mesh",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["False",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["whether to draw a mesh "]},
          {Cell[TextData[{
              ButtonBox["MeshStyle",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["GrayLevel[GoldenRatio-1]", "MR"],
              " "
            }]], Cell["the style to use for a mesh "]},
          {Cell[TextData[{
              StyleBox["PixelConstrained", "MR"],
              " "
            }]], Cell[TextData[{
              ButtonBox["False",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["whether to constrain cells to align with pixels "]},
          {Cell[TextData[{
              ButtonBox["PlotRange",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["All",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["the range of values to plot "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "3ColumnTable",
  CellTags->{"ArrayPlot", "S0.1049"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColorRules", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{0->Red,", "MR"],
  " ",
  StyleBox["1->Blue,", "MR"],
  " ",
  StyleBox["_->Black}", "MR"],
  " specifies that cells with value ",
  StyleBox["0", "MR"],
  " should be red, those with value ",
  StyleBox["1", "MR"],
  " should be blue, and all others should be black. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] The rules given by ",
  StyleBox["ColorRules", "MR"],
  " are applied to the value ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["ij",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " of each cell. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] If none of the rules in ",
  StyleBox["ColorRules", "MR"],
  " applies, then ",
  ButtonBox["ColorFunction",
    ButtonStyle->"RefGuideLink"],
  " is used to determine the color. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColorRules", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", an explicit setting ",
  StyleBox["ColorFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["f", "TI"],
  " is used instead of ",
  StyleBox["ColorRules", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColorFunctionScaling", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  ", each value ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["ij",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is supplied as the argument to any function given for ",
  ButtonBox["ColorFunction",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["ColorFunctionScaling", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", the values are scaled to lie between ",
  StyleBox["0", "MR"],
  " and ",
  StyleBox["1", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["FrameTicks", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", ticks are placed at round integers, typically multiples of 5 or 10. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["FrameTicks", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", ticks are also placed at the minimum and maximum ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " specifies that only those ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["ij",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " between ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " should be shown. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}}", "MR"],
  " shows only elements with ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in the specified ranges. The top\[Hyphen]left element has ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["j",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " increases down the page; ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  " increases to the right. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["ispec", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["jspec", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["aspec", "TI"],
  StyleBox["}", "MR"],
  " shows only elements in the specified ranges of ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and value. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting for ",
  ButtonBox["ColorFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox["PlotRange->{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " specifies that values from ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " should be shown with grayscales varying from white to black. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColorFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["(GrayLevel[If[#==0,", "MR"],
  " ",
  StyleBox["1,", "MR"],
  " ",
  StyleBox["0]]&)", "MR"],
  " generates a plot in which all nonzero values are shown as black. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mesh", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " draws mesh lines between each cell in the array. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["Frame", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", a frame is drawn only when ",
  StyleBox["Mesh", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["DataRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", the array element ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], 
          StyleBox["ij",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " will be taken to cover a unit square centered at coordinate position ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", 
          StyleBox["j",
            "TI"], "-", "1", "/", "2"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], "=", 
          SubscriptBox[
            StyleBox["i",
              "TI"], 
            StyleBox["max",
              "TI"]], "-", 
          StyleBox["i",
            "TI"], "+", "1", "/", "2"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayPlot", "MR"],
  " returns ",
  StyleBox["Graphics[Raster[", "MR"],
  StyleBox["data", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["PixelConstrained", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["ArrayPlot", "MR"],
  " generates a ",
  ButtonBox["Raster",
    ButtonStyle->"RefGuideLink"],
  " with an absolute size that aligns cells with pixels, so that each cell is \
an integer number of pixels across, or each pixel is an integer number of \
cells across. The cells are each taken to be as large as possible given the \
",
  ButtonBox["ImageSize",
    ButtonStyle->"RefGuideLink"],
  " setting specified. "
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ListDensityPlot",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Raster",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ListPlot3D",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellularAutomaton",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1049", "ArrayPlot"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArrayPlot"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "ExampleText",
  CellTags->"ArrayPlot"],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[ScriptM]1", "=", 
        RowBox[{"(", GridBox[{
              {\(\(1\)\(\[NoBreak]\)\), "0", "1"},
              {"0", "1", "0"}
              }], ")"}]}], ";"}]], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArrayPlot"],

Cell[TextData[{
  "This plots ",
  Cell[BoxData[
      \(\[ScriptM]1\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArrayPlot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayPlot[\[ScriptM]1]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArrayPlot"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.015873 0.31746 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .66667 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .66667 L
s
0 .66667 m
1 .66667 L
s
1 0 m
1 .66667 L
s
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01587 translate
.95238 .63492 scale
3 string
3 2 8 [3 0 0 2 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FF
00FF00
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"ArrayPlot"]
}, Open  ]],

Cell[TextData[{
  "This plots ",
  Cell[BoxData[
      \(\[ScriptM]1\)], "InlineFormula"],
  " with frame ticks added. Notice that the row indices run from top to \
bottom, and column indices from left to right. "
}], "ExampleText",
  CellTags->"ArrayPlot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayPlot[\[ScriptM]1, FrameTicks \[Rule] True]; \)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArrayPlot"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.015873 0.31746 [
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .49206 -6 -4.5 ]
[-0.0125 .49206 0 4.5 ]
[-0.0125 .1746 -6 -4.5 ]
[-0.0125 .1746 0 4.5 ]
[ 0 0 -0.125 0 ]
[.18254 .67917 -3 0 ]
[.18254 .67917 3 9 ]
[.5 .67917 -3 0 ]
[.5 .67917 3 9 ]
[.81746 .67917 -3 0 ]
[.81746 .67917 3 9 ]
[ 0 .66667 .125 0 ]
[1.0125 .49206 0 -4.5 ]
[1.0125 .49206 6 4.5 ]
[1.0125 .1746 0 -4.5 ]
[1.0125 .1746 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .66667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(1)] .18254 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(3)] .81746 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .49206 m
.00625 .49206 L
s
[(1)] -0.0125 .49206 1 0 Mshowa
0 .1746 m
.00625 .1746 L
s
[(2)] -0.0125 .1746 1 0 Mshowa
0 0 m
0 .66667 L
s
.18254 .66042 m
.18254 .66667 L
s
[(1)] .18254 .67917 0 -1 Mshowa
.5 .66042 m
.5 .66667 L
s
[(2)] .5 .67917 0 -1 Mshowa
.81746 .66042 m
.81746 .66667 L
s
[(3)] .81746 .67917 0 -1 Mshowa
0 .66667 m
1 .66667 L
s
.99375 .49206 m
1 .49206 L
s
[(1)] 1.0125 .49206 -1 0 Mshowa
.99375 .1746 m
1 .1746 L
s
[(2)] 1.0125 .1746 -1 0 Mshowa
1 0 m
1 .66667 L
s
0 0 m
1 0 L
1 .66667 L
0 .66667 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01587 translate
.95238 .63492 scale
3 string
3 2 8 [3 0 0 2 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FF
00FF00
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"ArrayPlot"]
}, Open  ]],

Cell[TextData[{
  "By default, entries are plotted using ",
  StyleBox["GrayLevel", "MR"],
  ". The entry with largest absolute value is black and the smallest is \
white. This plots a ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Cross]5\)], "InlineFormula"],
  " matrix, with entry values varying from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-19\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArrayPlot"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"ArrayPlot", "[", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-19\), \(-18\), \(-17\), \(-16\), \(-15\)},
                {\(-14\), \(-13\), \(-12\), \(-11\), \(-10\)},
                {\(-9\), \(-8\), \(-7\), \(-6\), \(-5\)},
                {\(-4\), \(-3\), \(-2\), \(-1\), "0"}
                },
              RowSpacings->1,
              ColumnSpacings->1,
              ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]], "]"}], ";"}]], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArrayPlot"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0190476 0.190476 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .8 L
s
0 .8 m
1 .8 L
s
1 0 m
1 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01905 translate
.95238 .7619 scale
5 string
5 4 8 [5 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
CAD7E5F2FF
8694A1AFBC
43505E6B79
000D1A2835
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"ArrayPlot"]
}, Open  ]],

Cell["This plots a cellular automaton. ", "ExampleText",
  CellTags->"ArrayPlot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayPlot[CellularAutomaton[30, {{1}, 0}, 20]]; \)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"ArrayPlot"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5122 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0232288 0.0121951 0.0232288 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .5122 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5122 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .5122 L
s
0 .5122 m
1 .5122 L
s
1 0 m
1 .5122 L
s
0 0 m
1 0 L
1 .5122 L
0 .5122 L
closepath
clip
newpath
% Start of gray image
p
.02381 .0122 translate
.95238 .4878 scale
41 string
41 21 8 [41 0 0 21 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFF00FFFFFF000000FFFF00000000FFFFFFFFFF00000000FF000000FF0000FFFFFF
00FFFFFF00
FF0000FF00000000FFFF0000FF00FFFF000000000000FFFF00FFFFFF00FFFFFF000000FF
00000000FF
FFFF0000FFFF00FFFFFFFF00FF000000FFFF00FFFF0000FF000000FF00000000FFFF0000
FFFF00FFFF
FFFFFF0000FF00000000FF0000FFFF000000FFFFFFFF0000FFFF0000FFFF00FFFFFFFF00
0000FFFFFF
FFFFFFFF0000FFFF00FFFFFF000000FFFF00000000FF00FFFFFFFF000000FFFFFFFFFFFF
00FFFFFFFF
FFFFFFFFFF0000FF00000000FFFF0000FF00FFFF00FF0000000000FFFF00000000000000
FFFFFFFFFF
FFFFFFFFFFFF0000FFFF00FFFFFFFF00FF000000FFFFFF00FFFF000000FFFF00FFFF00FF
FFFFFFFFFF
FFFFFFFFFFFFFF0000FF00000000FF0000FFFF000000FF000000FFFF0000FF000000FFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFF0000FFFF0000FF00FFFFFF00FFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FF00000000FFFF0000FF00FFFFFFFF00FF00000000FFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FF00000000FF0000FFFF00FFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF0000FFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF000000FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFF000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"ArrayPlot"]
}, Open  ]],

Cell["This plots a sparse matrix in black and white. ", "ExampleText",
  CellTags->"ArrayPlot"],

Cell[BoxData[
    \(\[ScriptM]2 = 
      Import[ToFileName[{"\<LinearAlgebraExamples\>", "\<Data\>"}, \
"\<west0381.mtx\>"]]; \)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"ArrayPlot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayPlot[\[ScriptM]2, 
      ColorRules \[Rule] {0 \[Rule] White, _ \[Rule] Black}]; \)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"ArrayPlot"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00249969 0.0238095 0.00249969 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
0 g
.9112 .02381 m
.9112 .02631 L
.9137 .02631 L
.9137 .02381 L
F
.9137 .02381 m
.9137 .02631 L
.9162 .02631 L
.9162 .02381 L
F
.9162 .02381 m
.9162 .02631 L
.9187 .02631 L
.9187 .02381 L
F
.9187 .02381 m
.9187 .02631 L
.9212 .02631 L
.9212 .02381 L
F
.9212 .02381 m
.9212 .02631 L
.9237 .02631 L
.9237 .02381 L
F
.9237 .02381 m
.9237 .02631 L
.9262 .02631 L
.9262 .02381 L
F
.9262 .02381 m
.9262 .02631 L
.9287 .02631 L
.9287 .02381 L
F
.9287 .02381 m
.9287 .02631 L
.9312 .02631 L
.9312 .02381 L
F
.9312 .02381 m
.9312 .02631 L
.9337 .02631 L
.9337 .02381 L
F
.9337 .02381 m
.9337 .02631 L
.9362 .02631 L
.9362 .02381 L
F
.9362 .02381 m
.9362 .02631 L
.9387 .02631 L
.9387 .02381 L
F
.9387 .02381 m
.9387 .02631 L
.94119 .02631 L
.94119 .02381 L
F
.94119 .02381 m
.94119 .02631 L
.94369 .02631 L
.94369 .02381 L
F
.94369 .02381 m
.94369 .02631 L
.94619 .02631 L
.94619 .02381 L
F
.94619 .02381 m
.94619 .02631 L
.94869 .02631 L
.94869 .02381 L
F
.94869 .02381 m
.94869 .02631 L
.95119 .02631 L
.95119 .02381 L
F
.95119 .02381 m
.95119 .02631 L
.95369 .02631 L
.95369 .02381 L
F
.95369 .02381 m
.95369 .02631 L
.95619 .02631 L
.95619 .02381 L
F
.95619 .02381 m
.95619 .02631 L
.95869 .02631 L
.95869 .02381 L
F
.95869 .02381 m
.95869 .02631 L
.96119 .02631 L
.96119 .02381 L
F
.96119 .02381 m
.96119 .02631 L
.96369 .02631 L
.96369 .02381 L
F
.96369 .02381 m
.96369 .02631 L
.96619 .02631 L
.96619 .02381 L
F
.96619 .02381 m
.96619 .02631 L
.96869 .02631 L
.96869 .02381 L
F
.96869 .02381 m
.96869 .02631 L
.97119 .02631 L
.97119 .02381 L
F
.28128 .02631 m
.28128 .02881 L
.28378 .02881 L
.28378 .02631 L
F
.28378 .02631 m
.28378 .02881 L
.28628 .02881 L
.28628 .02631 L
F
.28628 .02631 m
.28628 .02881 L
.28878 .02881 L
.28878 .02631 L
F
.28878 .02631 m
.28878 .02881 L
.29128 .02881 L
.29128 .02631 L
F
.29128 .02631 m
.29128 .02881 L
.29378 .02881 L
.29378 .02631 L
F
.29378 .02631 m
.29378 .02881 L
.29628 .02881 L
.29628 .02631 L
F
.29628 .02631 m
.29628 .02881 L
.29878 .02881 L
.29878 .02631 L
F
.29878 .02631 m
.29878 .02881 L
.30127 .02881 L
.30127 .02631 L
F
.30127 .02631 m
.30127 .02881 L
.30377 .02881 L
.30377 .02631 L
F
.30377 .02631 m
.30377 .02881 L
.30627 .02881 L
.30627 .02631 L
F
.30627 .02631 m
.30627 .02881 L
.30877 .02881 L
.30877 .02631 L
F
.30877 .02631 m
.30877 .02881 L
.31127 .02881 L
.31127 .02631 L
F
.31127 .02631 m
.31127 .02881 L
.31377 .02881 L
.31377 .02631 L
F
.31377 .02631 m
.31377 .02881 L
.31627 .02881 L
.31627 .02631 L
F
.31627 .02631 m
.31627 .02881 L
.31877 .02881 L
.31877 .02631 L
F
.31877 .02631 m
.31877 .02881 L
.32127 .02881 L
.32127 .02631 L
F
.32127 .02631 m
.32127 .02881 L
.32377 .02881 L
.32377 .02631 L
F
.32377 .02631 m
.32377 .02881 L
.32627 .02881 L
.32627 .02631 L
F
.32627 .02631 m
.32627 .02881 L
.32877 .02881 L
.32877 .02631 L
F
.32877 .02631 m
.32877 .02881 L
.33127 .02881 L
.33127 .02631 L
F
.33127 .02631 m
.33127 .02881 L
.33377 .02881 L
.33377 .02631 L
F
.33377 .02631 m
.33377 .02881 L
.33627 .02881 L
.33627 .02631 L
F
.33627 .02631 m
.33627 .02881 L
.33877 .02881 L
.33877 .02631 L
F
.33877 .02631 m
.33877 .02881 L
.34127 .02881 L
.34127 .02631 L
F
.34377 .02881 m
.34377 .03131 L
.34627 .03131 L
.34627 .02881 L
F
.34627 .02881 m
.34627 .03131 L
.34877 .03131 L
.34877 .02881 L
F
.34877 .02881 m
.34877 .03131 L
.35127 .03131 L
.35127 .02881 L
F
.35127 .02881 m
.35127 .03131 L
.35377 .03131 L
.35377 .02881 L
F
.35377 .02881 m
.35377 .03131 L
.35627 .03131 L
.35627 .02881 L
F
.35627 .02881 m
.35627 .03131 L
.35877 .03131 L
.35877 .02881 L
F
.35877 .02881 m
.35877 .03131 L
.36127 .03131 L
.36127 .02881 L
F
.36127 .02881 m
.36127 .03131 L
.36377 .03131 L
.36377 .02881 L
F
.36377 .02881 m
.36377 .03131 L
.36627 .03131 L
.36627 .02881 L
F
.36627 .02881 m
.36627 .03131 L
.36877 .03131 L
.36877 .02881 L
F
.36877 .02881 m
.36877 .03131 L
.37127 .03131 L
.37127 .02881 L
F
.37127 .02881 m
.37127 .03131 L
.37377 .03131 L
.37377 .02881 L
F
.37377 .02881 m
.37377 .03131 L
.37627 .03131 L
.37627 .02881 L
F
.37627 .02881 m
.37627 .03131 L
.37877 .03131 L
.37877 .02881 L
F
.37877 .02881 m
.37877 .03131 L
.38126 .03131 L
.38126 .02881 L
F
.38126 .02881 m
.38126 .03131 L
.38376 .03131 L
.38376 .02881 L
F
.38376 .02881 m
.38376 .03131 L
.38626 .03131 L
.38626 .02881 L
F
.38626 .02881 m
.38626 .03131 L
.38876 .03131 L
.38876 .02881 L
F
.38876 .02881 m
.38876 .03131 L
.39126 .03131 L
.39126 .02881 L
F
.39126 .02881 m
.39126 .03131 L
.39376 .03131 L
.39376 .02881 L
F
.39376 .02881 m
.39376 .03131 L
.39626 .03131 L
.39626 .02881 L
F
.39626 .02881 m
.39626 .03131 L
.39876 .03131 L
.39876 .02881 L
F
.39876 .02881 m
.39876 .03131 L
.40126 .03131 L
.40126 .02881 L
F
.40126 .02881 m
.40126 .03131 L
.40376 .03131 L
.40376 .02881 L
F
.84871 .03131 m
.84871 .03381 L
.85121 .03381 L
.85121 .03131 L
F
.85121 .03131 m
.85121 .03381 L
.85371 .03381 L
.85371 .03131 L
F
.85371 .03131 m
.85371 .03381 L
.85621 .03381 L
.85621 .03131 L
F
.85621 .03131 m
.85621 .03381 L
.85871 .03381 L
.85871 .03131 L
F
.85871 .03131 m
.85871 .03381 L
.8612 .03381 L
.8612 .03131 L
F
.8612 .03131 m
.8612 .03381 L
.8637 .03381 L
.8637 .03131 L
F
.8637 .03131 m
.8637 .03381 L
.8662 .03381 L
.8662 .03131 L
F
.8662 .03131 m
.8662 .03381 L
.8687 .03381 L
.8687 .03131 L
F
.8687 .03131 m
.8687 .03381 L
.8712 .03381 L
.8712 .03131 L
F
.8712 .03131 m
.8712 .03381 L
.8737 .03381 L
.8737 .03131 L
F
.8737 .03131 m
.8737 .03381 L
.8762 .03381 L
.8762 .03131 L
F
.8762 .03131 m
.8762 .03381 L
.8787 .03381 L
.8787 .03131 L
F
.8787 .03131 m
.8787 .03381 L
.8812 .03381 L
.8812 .03131 L
F
.8812 .03131 m
.8812 .03381 L
.8837 .03381 L
.8837 .03131 L
F
.8837 .03131 m
.8837 .03381 L
.8862 .03381 L
.8862 .03131 L
F
.8862 .03131 m
.8862 .03381 L
.8887 .03381 L
.8887 .03131 L
F
.8887 .03131 m
.8887 .03381 L
.8912 .03381 L
.8912 .03131 L
F
.8912 .03131 m
.8912 .03381 L
.8937 .03381 L
.8937 .03131 L
F
.8937 .03131 m
.8937 .03381 L
.8962 .03381 L
.8962 .03131 L
F
.8962 .03131 m
.8962 .03381 L
.8987 .03381 L
.8987 .03131 L
F
.8987 .03131 m
.8987 .03381 L
.9012 .03381 L
.9012 .03131 L
F
.9012 .03131 m
.9012 .03381 L
.9037 .03381 L
.9037 .03131 L
F
.9037 .03131 m
.9037 .03381 L
.9062 .03381 L
.9062 .03131 L
F
.9062 .03131 m
.9062 .03381 L
.9087 .03381 L
.9087 .03131 L
F
.15629 .03381 m
.15629 .03631 L
.15879 .03631 L
.15879 .03381 L
F
.15879 .03381 m
.15879 .03631 L
.16129 .03631 L
.16129 .03381 L
F
.16129 .03381 m
.16129 .03631 L
.16379 .03631 L
.16379 .03381 L
F
.16379 .03381 m
.16379 .03631 L
.16629 .03631 L
.16629 .03381 L
F
.16629 .03381 m
.16629 .03631 L
.16879 .03631 L
.16879 .03381 L
F
.16879 .03381 m
.16879 .03631 L
.17129 .03631 L
.17129 .03381 L
F
.17129 .03381 m
.17129 .03631 L
.17379 .03631 L
.17379 .03381 L
F
.17379 .03381 m
.17379 .03631 L
.17629 .03631 L
.17629 .03381 L
F
.17629 .03381 m
.17629 .03631 L
.17879 .03631 L
.17879 .03381 L
F
.17879 .03381 m
.17879 .03631 L
.18129 .03631 L
.18129 .03381 L
F
.18129 .03381 m
.18129 .03631 L
.18379 .03631 L
.18379 .03381 L
F
.18379 .03381 m
.18379 .03631 L
.18629 .03631 L
.18629 .03381 L
F
.18629 .03381 m
.18629 .03631 L
.18879 .03631 L
.18879 .03381 L
F
.18879 .03381 m
.18879 .03631 L
.19129 .03631 L
.19129 .03381 L
F
.19129 .03381 m
.19129 .03631 L
.19379 .03631 L
.19379 .03381 L
F
.19379 .03381 m
.19379 .03631 L
.19629 .03631 L
.19629 .03381 L
F
.19629 .03381 m
.19629 .03631 L
.19879 .03631 L
.19879 .03381 L
F
.19879 .03381 m
.19879 .03631 L
.20129 .03631 L
.20129 .03381 L
F
.20129 .03381 m
.20129 .03631 L
.20379 .03631 L
.20379 .03381 L
F
.20379 .03381 m
.20379 .03631 L
.20629 .03631 L
.20629 .03381 L
F
.20629 .03381 m
.20629 .03631 L
.20879 .03631 L
.20879 .03381 L
F
.20879 .03381 m
.20879 .03631 L
.21129 .03631 L
.21129 .03381 L
F
.21129 .03381 m
.21129 .03631 L
.21379 .03631 L
.21379 .03381 L
F
.21379 .03381 m
.21379 .03631 L
.21629 .03631 L
.21629 .03381 L
F
.78371 .03631 m
.78371 .03881 L
.78621 .03881 L
.78621 .03631 L
F
.78621 .03631 m
.78621 .03881 L
.78871 .03881 L
.78871 .03631 L
F
.78871 .03631 m
.78871 .03881 L
.79121 .03881 L
.79121 .03631 L
F
.79121 .03631 m
.79121 .03881 L
.79371 .03881 L
.79371 .03631 L
F
.79371 .03631 m
.79371 .03881 L
.79621 .03881 L
.79621 .03631 L
F
.79621 .03631 m
.79621 .03881 L
.79871 .03881 L
.79871 .03631 L
F
.79871 .03631 m
.79871 .03881 L
.80121 .03881 L
.80121 .03631 L
F
.80121 .03631 m
.80121 .03881 L
.80371 .03881 L
.80371 .03631 L
F
.80371 .03631 m
.80371 .03881 L
.80621 .03881 L
.80621 .03631 L
F
.80621 .03631 m
.80621 .03881 L
.80871 .03881 L
.80871 .03631 L
F
.80871 .03631 m
.80871 .03881 L
.81121 .03881 L
.81121 .03631 L
F
.81121 .03631 m
.81121 .03881 L
.81371 .03881 L
.81371 .03631 L
F
.81371 .03631 m
.81371 .03881 L
.81621 .03881 L
.81621 .03631 L
F
.81621 .03631 m
.81621 .03881 L
.81871 .03881 L
.81871 .03631 L
F
.81871 .03631 m
.81871 .03881 L
.82121 .03881 L
.82121 .03631 L
F
.82121 .03631 m
.82121 .03881 L
.82371 .03881 L
.82371 .03631 L
F
.82371 .03631 m
.82371 .03881 L
.82621 .03881 L
.82621 .03631 L
F
.82621 .03631 m
.82621 .03881 L
.82871 .03881 L
.82871 .03631 L
F
.82871 .03631 m
.82871 .03881 L
.83121 .03881 L
.83121 .03631 L
F
.83121 .03631 m
.83121 .03881 L
.83371 .03881 L
.83371 .03631 L
F
.83371 .03631 m
.83371 .03881 L
.83621 .03881 L
.83621 .03631 L
F
.83621 .03631 m
.83621 .03881 L
.83871 .03881 L
.83871 .03631 L
F
.83871 .03631 m
.83871 .03881 L
.84121 .03881 L
.84121 .03631 L
F
.84121 .03631 m
.84121 .03881 L
.84371 .03881 L
.84371 .03631 L
F
.72372 .03881 m
.72372 .04131 L
.72622 .04131 L
.72622 .03881 L
F
.72622 .03881 m
.72622 .04131 L
.72872 .04131 L
.72872 .03881 L
F
.72872 .03881 m
.72872 .04131 L
.73122 .04131 L
.73122 .03881 L
F
.73122 .03881 m
.73122 .04131 L
.73372 .04131 L
.73372 .03881 L
F
.73372 .03881 m
.73372 .04131 L
.73622 .04131 L
.73622 .03881 L
F
.73622 .03881 m
.73622 .04131 L
.73872 .04131 L
.73872 .03881 L
F
.73872 .03881 m
.73872 .04131 L
.74122 .04131 L
.74122 .03881 L
F
.74122 .03881 m
.74122 .04131 L
.74372 .04131 L
.74372 .03881 L
F
.74372 .03881 m
.74372 .04131 L
.74622 .04131 L
.74622 .03881 L
F
.74622 .03881 m
.74622 .04131 L
.74872 .04131 L
.74872 .03881 L
F
.74872 .03881 m
.74872 .04131 L
.75122 .04131 L
.75122 .03881 L
F
.75122 .03881 m
.75122 .04131 L
.75372 .04131 L
.75372 .03881 L
F
.75372 .03881 m
.75372 .04131 L
.75622 .04131 L
.75622 .03881 L
F
.75622 .03881 m
.75622 .04131 L
.75872 .04131 L
.75872 .03881 L
F
.75872 .03881 m
.75872 .04131 L
.76122 .04131 L
.76122 .03881 L
F
.76122 .03881 m
.76122 .04131 L
.76372 .04131 L
.76372 .03881 L
F
.76372 .03881 m
.76372 .04131 L
.76622 .04131 L
.76622 .03881 L
F
.76622 .03881 m
.76622 .04131 L
.76872 .04131 L
.76872 .03881 L
F
.76872 .03881 m
.76872 .04131 L
.77122 .04131 L
.77122 .03881 L
F
.77122 .03881 m
.77122 .04131 L
.77372 .04131 L
.77372 .03881 L
F
.77372 .03881 m
.77372 .04131 L
.77622 .04131 L
.77622 .03881 L
F
.77622 .03881 m
.77622 .04131 L
.77872 .04131 L
.77872 .03881 L
F
.77872 .03881 m
.77872 .04131 L
.78121 .04131 L
.78121 .03881 L
F
.78121 .03881 m
.78121 .04131 L
.78371 .04131 L
.78371 .03881 L
F
.65873 .04131 m
.65873 .04381 L
.66123 .04381 L
.66123 .04131 L
F
.66123 .04131 m
.66123 .04381 L
.66373 .04381 L
.66373 .04131 L
F
.66373 .04131 m
.66373 .04381 L
.66623 .04381 L
.66623 .04131 L
F
.66623 .04131 m
.66623 .04381 L
.66873 .04381 L
.66873 .04131 L
F
.66873 .04131 m
.66873 .04381 L
.67123 .04381 L
.67123 .04131 L
F
.67123 .04131 m
.67123 .04381 L
.67373 .04381 L
.67373 .04131 L
F
.67373 .04131 m
.67373 .04381 L
.67623 .04381 L
.67623 .04131 L
F
.67623 .04131 m
.67623 .04381 L
.67873 .04381 L
.67873 .04131 L
F
.67873 .04131 m
.67873 .04381 L
.68123 .04381 L
.68123 .04131 L
F
.68123 .04131 m
.68123 .04381 L
.68373 .04381 L
.68373 .04131 L
F
.68373 .04131 m
.68373 .04381 L
.68623 .04381 L
.68623 .04131 L
F
.68623 .04131 m
.68623 .04381 L
.68873 .04381 L
.68873 .04131 L
F
.68873 .04131 m
.68873 .04381 L
.69123 .04381 L
.69123 .04131 L
F
.69123 .04131 m
.69123 .04381 L
.69373 .04381 L
.69373 .04131 L
F
.69373 .04131 m
.69373 .04381 L
.69623 .04381 L
.69623 .04131 L
F
.69623 .04131 m
.69623 .04381 L
.69873 .04381 L
.69873 .04131 L
F
.69873 .04131 m
.69873 .04381 L
.70122 .04381 L
.70122 .04131 L
F
.70122 .04131 m
.70122 .04381 L
.70372 .04381 L
.70372 .04131 L
F
.70372 .04131 m
.70372 .04381 L
.70622 .04381 L
.70622 .04131 L
F
.70622 .04131 m
.70622 .04381 L
.70872 .04381 L
.70872 .04131 L
F
.70872 .04131 m
.70872 .04381 L
.71122 .04381 L
.71122 .04131 L
F
.71122 .04131 m
.71122 .04381 L
.71372 .04381 L
.71372 .04131 L
F
.71372 .04131 m
.71372 .04381 L
.71622 .04381 L
.71622 .04131 L
F
.71622 .04131 m
.71622 .04381 L
.71872 .04381 L
.71872 .04131 L
F
.59624 .04381 m
.59624 .04631 L
.59874 .04631 L
.59874 .04381 L
F
.59874 .04381 m
.59874 .04631 L
.60124 .04631 L
.60124 .04381 L
F
.60124 .04381 m
.60124 .04631 L
.60374 .04631 L
.60374 .04381 L
F
.60374 .04381 m
.60374 .04631 L
.60624 .04631 L
.60624 .04381 L
F
.60624 .04381 m
.60624 .04631 L
.60874 .04631 L
.60874 .04381 L
F
.60874 .04381 m
.60874 .04631 L
.61124 .04631 L
.61124 .04381 L
F
.61124 .04381 m
.61124 .04631 L
.61374 .04631 L
.61374 .04381 L
F
.61374 .04381 m
.61374 .04631 L
.61624 .04631 L
.61624 .04381 L
F
.61624 .04381 m
.61624 .04631 L
.61874 .04631 L
.61874 .04381 L
F
.61874 .04381 m
.61874 .04631 L
.62123 .04631 L
.62123 .04381 L
F
.62123 .04381 m
.62123 .04631 L
.62373 .04631 L
.62373 .04381 L
F
.62373 .04381 m
.62373 .04631 L
.62623 .04631 L
.62623 .04381 L
F
.62623 .04381 m
.62623 .04631 L
.62873 .04631 L
.62873 .04381 L
F
.62873 .04381 m
.62873 .04631 L
.63123 .04631 L
.63123 .04381 L
F
.63123 .04381 m
.63123 .04631 L
.63373 .04631 L
.63373 .04381 L
F
.63373 .04381 m
.63373 .04631 L
.63623 .04631 L
.63623 .04381 L
F
.63623 .04381 m
.63623 .04631 L
.63873 .04631 L
.63873 .04381 L
F
.63873 .04381 m
.63873 .04631 L
.64123 .04631 L
.64123 .04381 L
F
.64123 .04381 m
.64123 .04631 L
.64373 .04631 L
.64373 .04381 L
F
.64373 .04381 m
.64373 .04631 L
.64623 .04631 L
.64623 .04381 L
F
.64623 .04381 m
.64623 .04631 L
.64873 .04631 L
.64873 .04381 L
F
.64873 .04381 m
.64873 .04631 L
.65123 .04631 L
.65123 .04381 L
F
.65123 .04381 m
.65123 .04631 L
.65373 .04631 L
.65373 .04381 L
F
.65373 .04381 m
.65373 .04631 L
.65623 .04631 L
.65623 .04381 L
F
.53375 .04631 m
.53375 .04881 L
.53625 .04881 L
.53625 .04631 L
F
.53625 .04631 m
.53625 .04881 L
.53875 .04881 L
.53875 .04631 L
F
.53875 .04631 m
.53875 .04881 L
.54124 .04881 L
.54124 .04631 L
F
.54124 .04631 m
.54124 .04881 L
.54374 .04881 L
.54374 .04631 L
F
.54374 .04631 m
.54374 .04881 L
.54624 .04881 L
.54624 .04631 L
F
.54624 .04631 m
.54624 .04881 L
.54874 .04881 L
.54874 .04631 L
F
.54874 .04631 m
.54874 .04881 L
.55124 .04881 L
.55124 .04631 L
F
.55124 .04631 m
.55124 .04881 L
.55374 .04881 L
.55374 .04631 L
F
.55374 .04631 m
.55374 .04881 L
.55624 .04881 L
.55624 .04631 L
F
.55624 .04631 m
.55624 .04881 L
.55874 .04881 L
.55874 .04631 L
F
.55874 .04631 m
.55874 .04881 L
.56124 .04881 L
.56124 .04631 L
F
.56124 .04631 m
.56124 .04881 L
.56374 .04881 L
.56374 .04631 L
F
.56374 .04631 m
.56374 .04881 L
.56624 .04881 L
.56624 .04631 L
F
.56624 .04631 m
.56624 .04881 L
.56874 .04881 L
.56874 .04631 L
F
.56874 .04631 m
.56874 .04881 L
.57124 .04881 L
.57124 .04631 L
F
.57124 .04631 m
.57124 .04881 L
.57374 .04881 L
.57374 .04631 L
F
.57374 .04631 m
.57374 .04881 L
.57624 .04881 L
.57624 .04631 L
F
.57624 .04631 m
.57624 .04881 L
.57874 .04881 L
.57874 .04631 L
F
.57874 .04631 m
.57874 .04881 L
.58124 .04881 L
.58124 .04631 L
F
.58124 .04631 m
.58124 .04881 L
.58374 .04881 L
.58374 .04631 L
F
.58374 .04631 m
.58374 .04881 L
.58624 .04881 L
.58624 .04631 L
F
.58624 .04631 m
.58624 .04881 L
.58874 .04881 L
.58874 .04631 L
F
.58874 .04631 m
.58874 .04881 L
.59124 .04881 L
.59124 .04631 L
F
.59124 .04631 m
.59124 .04881 L
.59374 .04881 L
.59374 .04631 L
F
.0963 .04881 m
.0963 .05131 L
.0988 .05131 L
.0988 .04881 L
F
.0988 .04881 m
.0988 .05131 L
.1013 .05131 L
.1013 .04881 L
F
.1013 .04881 m
.1013 .05131 L
.1038 .05131 L
.1038 .04881 L
F
.1038 .04881 m
.1038 .05131 L
.1063 .05131 L
.1063 .04881 L
F
.1063 .04881 m
.1063 .05131 L
.1088 .05131 L
.1088 .04881 L
F
.1088 .04881 m
.1088 .05131 L
.1113 .05131 L
.1113 .04881 L
F
.1113 .04881 m
.1113 .05131 L
.1138 .05131 L
.1138 .04881 L
F
.1138 .04881 m
.1138 .05131 L
.1163 .05131 L
.1163 .04881 L
F
.1163 .04881 m
.1163 .05131 L
.1188 .05131 L
.1188 .04881 L
F
.1188 .04881 m
.1188 .05131 L
.1213 .05131 L
.1213 .04881 L
F
.1213 .04881 m
.1213 .05131 L
.1238 .05131 L
.1238 .04881 L
F
.1238 .04881 m
.1238 .05131 L
.1263 .05131 L
.1263 .04881 L
F
.1263 .04881 m
.1263 .05131 L
.1288 .05131 L
.1288 .04881 L
F
.1288 .04881 m
.1288 .05131 L
.1313 .05131 L
.1313 .04881 L
F
.1313 .04881 m
.1313 .05131 L
.1338 .05131 L
.1338 .04881 L
F
.1338 .04881 m
.1338 .05131 L
.1363 .05131 L
.1363 .04881 L
F
.1363 .04881 m
.1363 .05131 L
.1388 .05131 L
.1388 .04881 L
F
.1388 .04881 m
.1388 .05131 L
.14129 .05131 L
.14129 .04881 L
F
.14129 .04881 m
.14129 .05131 L
.14379 .05131 L
.14379 .04881 L
F
.14379 .04881 m
.14379 .05131 L
.14629 .05131 L
.14629 .04881 L
F
.14629 .04881 m
.14629 .05131 L
.14879 .05131 L
.14879 .04881 L
F
.14879 .04881 m
.14879 .05131 L
.15129 .05131 L
.15129 .04881 L
F
.15129 .04881 m
.15129 .05131 L
.15379 .05131 L
.15379 .04881 L
F
.15379 .04881 m
.15379 .05131 L
.15629 .05131 L
.15629 .04881 L
F
.47125 .05131 m
.47125 .05381 L
.47375 .05381 L
.47375 .05131 L
F
.47375 .05131 m
.47375 .05381 L
.47625 .05381 L
.47625 .05131 L
F
.47625 .05131 m
.47625 .05381 L
.47875 .05381 L
.47875 .05131 L
F
.47875 .05131 m
.47875 .05381 L
.48125 .05381 L
.48125 .05131 L
F
.48125 .05131 m
.48125 .05381 L
.48375 .05381 L
.48375 .05131 L
F
.48375 .05131 m
.48375 .05381 L
.48625 .05381 L
.48625 .05131 L
F
.48625 .05131 m
.48625 .05381 L
.48875 .05381 L
.48875 .05131 L
F
.48875 .05131 m
.48875 .05381 L
.49125 .05381 L
.49125 .05131 L
F
.49125 .05131 m
.49125 .05381 L
.49375 .05381 L
.49375 .05131 L
F
.49375 .05131 m
.49375 .05381 L
.49625 .05381 L
.49625 .05131 L
F
.49625 .05131 m
.49625 .05381 L
.49875 .05381 L
.49875 .05131 L
F
.49875 .05131 m
.49875 .05381 L
.50125 .05381 L
.50125 .05131 L
F
.50125 .05131 m
.50125 .05381 L
.50375 .05381 L
.50375 .05131 L
F
.50375 .05131 m
.50375 .05381 L
.50625 .05381 L
.50625 .05131 L
F
.50625 .05131 m
.50625 .05381 L
.50875 .05381 L
.50875 .05131 L
F
.50875 .05131 m
.50875 .05381 L
.51125 .05381 L
.51125 .05131 L
F
.51125 .05131 m
.51125 .05381 L
.51375 .05381 L
.51375 .05131 L
F
.51375 .05131 m
.51375 .05381 L
.51625 .05381 L
.51625 .05131 L
F
.51625 .05131 m
.51625 .05381 L
.51875 .05381 L
.51875 .05131 L
F
.51875 .05131 m
.51875 .05381 L
.52125 .05381 L
.52125 .05131 L
F
.52125 .05131 m
.52125 .05381 L
.52375 .05381 L
.52375 .05131 L
F
.52375 .05131 m
.52375 .05381 L
.52625 .05381 L
.52625 .05131 L
F
.52625 .05131 m
.52625 .05381 L
.52875 .05381 L
.52875 .05131 L
F
.52875 .05131 m
.52875 .05381 L
.53125 .05381 L
.53125 .05131 L
F
.40626 .05381 m
.40626 .05631 L
.40876 .05631 L
.40876 .05381 L
F
.40876 .05381 m
.40876 .05631 L
.41126 .05631 L
.41126 .05381 L
F
.41126 .05381 m
.41126 .05631 L
.41376 .05631 L
.41376 .05381 L
F
.41376 .05381 m
.41376 .05631 L
.41626 .05631 L
.41626 .05381 L
F
.41626 .05381 m
.41626 .05631 L
.41876 .05631 L
.41876 .05381 L
F
.41876 .05381 m
.41876 .05631 L
.42126 .05631 L
.42126 .05381 L
F
.42126 .05381 m
.42126 .05631 L
.42376 .05631 L
.42376 .05381 L
F
.42376 .05381 m
.42376 .05631 L
.42626 .05631 L
.42626 .05381 L
F
.42626 .05381 m
.42626 .05631 L
.42876 .05631 L
.42876 .05381 L
F
.42876 .05381 m
.42876 .05631 L
.43126 .05631 L
.43126 .05381 L
F
.43126 .05381 m
.43126 .05631 L
.43376 .05631 L
.43376 .05381 L
F
.43376 .05381 m
.43376 .05631 L
.43626 .05631 L
.43626 .05381 L
F
.43626 .05381 m
.43626 .05631 L
.43876 .05631 L
.43876 .05381 L
F
.43876 .05381 m
.43876 .05631 L
.44126 .05631 L
.44126 .05381 L
F
.44126 .05381 m
.44126 .05631 L
.44376 .05631 L
.44376 .05381 L
F
.44376 .05381 m
.44376 .05631 L
.44626 .05631 L
.44626 .05381 L
F
.44626 .05381 m
.44626 .05631 L
.44876 .05631 L
.44876 .05381 L
F
.44876 .05381 m
.44876 .05631 L
.45126 .05631 L
.45126 .05381 L
F
.45126 .05381 m
.45126 .05631 L
.45376 .05631 L
.45376 .05381 L
F
.45376 .05381 m
.45376 .05631 L
.45626 .05631 L
.45626 .05381 L
F
.45626 .05381 m
.45626 .05631 L
.45876 .05631 L
.45876 .05381 L
F
.45876 .05381 m
.45876 .05631 L
.46125 .05631 L
.46125 .05381 L
F
.46125 .05381 m
.46125 .05631 L
.46375 .05631 L
.46375 .05381 L
F
.46375 .05381 m
.46375 .05631 L
.46625 .05631 L
.46625 .05381 L
F
.03381 .05631 m
.03381 .05881 L
.03631 .05881 L
.03631 .05631 L
F
.03631 .05631 m
.03631 .05881 L
.03881 .05881 L
.03881 .05631 L
F
.03881 .05631 m
.03881 .05881 L
.04131 .05881 L
.04131 .05631 L
F
.04131 .05631 m
.04131 .05881 L
.04381 .05881 L
.04381 .05631 L
F
.04381 .05631 m
.04381 .05881 L
.04631 .05881 L
.04631 .05631 L
F
.04631 .05631 m
.04631 .05881 L
.04881 .05881 L
.04881 .05631 L
F
.04881 .05631 m
.04881 .05881 L
.05131 .05881 L
.05131 .05631 L
F
.05131 .05631 m
.05131 .05881 L
.05381 .05881 L
.05381 .05631 L
F
.05381 .05631 m
.05381 .05881 L
.05631 .05881 L
.05631 .05631 L
F
.05631 .05631 m
.05631 .05881 L
.05881 .05881 L
.05881 .05631 L
F
.05881 .05631 m
.05881 .05881 L
.0613 .05881 L
.0613 .05631 L
F
.0613 .05631 m
.0613 .05881 L
.0638 .05881 L
.0638 .05631 L
F
.0638 .05631 m
.0638 .05881 L
.0663 .05881 L
.0663 .05631 L
F
.0663 .05631 m
.0663 .05881 L
.0688 .05881 L
.0688 .05631 L
F
.0688 .05631 m
.0688 .05881 L
.0713 .05881 L
.0713 .05631 L
F
.0713 .05631 m
.0713 .05881 L
.0738 .05881 L
.0738 .05631 L
F
.0738 .05631 m
.0738 .05881 L
.0763 .05881 L
.0763 .05631 L
F
.0763 .05631 m
.0763 .05881 L
.0788 .05881 L
.0788 .05631 L
F
.0788 .05631 m
.0788 .05881 L
.0813 .05881 L
.0813 .05631 L
F
.0813 .05631 m
.0813 .05881 L
.0838 .05881 L
.0838 .05631 L
F
.0838 .05631 m
.0838 .05881 L
.0863 .05881 L
.0863 .05631 L
F
.0863 .05631 m
.0863 .05881 L
.0888 .05881 L
.0888 .05631 L
F
.0888 .05631 m
.0888 .05881 L
.0913 .05881 L
.0913 .05631 L
F
.0913 .05631 m
.0913 .05881 L
.0938 .05881 L
.0938 .05631 L
F
.03131 .05881 m
.03131 .0613 L
.03381 .0613 L
.03381 .05881 L
F
.9087 .05881 m
.9087 .0613 L
.9112 .0613 L
.9112 .05881 L
F
.28128 .0613 m
.28128 .0638 L
.28378 .0638 L
.28378 .0613 L
F
.28378 .0613 m
.28378 .0638 L
.28628 .0638 L
.28628 .0613 L
F
.28628 .0613 m
.28628 .0638 L
.28878 .0638 L
.28878 .0613 L
F
.28878 .0613 m
.28878 .0638 L
.29128 .0638 L
.29128 .0613 L
F
.29128 .0613 m
.29128 .0638 L
.29378 .0638 L
.29378 .0613 L
F
.29378 .0613 m
.29378 .0638 L
.29628 .0638 L
.29628 .0613 L
F
.29628 .0613 m
.29628 .0638 L
.29878 .0638 L
.29878 .0613 L
F
.29878 .0613 m
.29878 .0638 L
.30127 .0638 L
.30127 .0613 L
F
.30127 .0613 m
.30127 .0638 L
.30377 .0638 L
.30377 .0613 L
F
.30377 .0613 m
.30377 .0638 L
.30627 .0638 L
.30627 .0613 L
F
.30627 .0613 m
.30627 .0638 L
.30877 .0638 L
.30877 .0613 L
F
.30877 .0613 m
.30877 .0638 L
.31127 .0638 L
.31127 .0613 L
F
.31127 .0613 m
.31127 .0638 L
.31377 .0638 L
.31377 .0613 L
F
.31377 .0613 m
.31377 .0638 L
.31627 .0638 L
.31627 .0613 L
F
.31627 .0613 m
.31627 .0638 L
.31877 .0638 L
.31877 .0613 L
F
.31877 .0613 m
.31877 .0638 L
.32127 .0638 L
.32127 .0613 L
F
.32127 .0613 m
.32127 .0638 L
.32377 .0638 L
.32377 .0613 L
F
.32377 .0613 m
.32377 .0638 L
.32627 .0638 L
.32627 .0613 L
F
.32627 .0613 m
.32627 .0638 L
.32877 .0638 L
.32877 .0613 L
F
.32877 .0613 m
.32877 .0638 L
.33127 .0638 L
.33127 .0613 L
F
.33127 .0613 m
.33127 .0638 L
.33377 .0638 L
.33377 .0613 L
F
.33377 .0613 m
.33377 .0638 L
.33627 .0638 L
.33627 .0613 L
F
.33627 .0613 m
.33627 .0638 L
.33877 .0638 L
.33877 .0613 L
F
.33877 .0613 m
.33877 .0638 L
.34127 .0638 L
.34127 .0613 L
F
.97369 .0613 m
.97369 .0638 L
.97619 .0638 L
.97619 .0613 L
F
.03131 .0638 m
.03131 .0663 L
.03381 .0663 L
.03381 .0638 L
F
.0913 .0638 m
.0913 .0663 L
.0938 .0663 L
.0938 .0638 L
F
.27878 .0638 m
.27878 .0663 L
.28128 .0663 L
.28128 .0638 L
F
.33877 .0638 m
.33877 .0663 L
.34127 .0663 L
.34127 .0638 L
F
.84621 .0638 m
.84621 .0663 L
.84871 .0663 L
.84871 .0638 L
F
.9062 .0638 m
.9062 .0663 L
.9087 .0663 L
.9087 .0638 L
F
.9087 .0638 m
.9087 .0663 L
.9112 .0663 L
.9112 .0638 L
F
.96869 .0638 m
.96869 .0663 L
.97119 .0663 L
.97119 .0638 L
F
.03131 .0663 m
.03131 .0688 L
.03381 .0688 L
.03381 .0663 L
F
.0888 .0663 m
.0888 .0688 L
.0913 .0688 L
.0913 .0663 L
F
.27878 .0663 m
.27878 .0688 L
.28128 .0688 L
.28128 .0663 L
F
.33627 .0663 m
.33627 .0688 L
.33877 .0688 L
.33877 .0663 L
F
.84621 .0663 m
.84621 .0688 L
.84871 .0688 L
.84871 .0663 L
F
.9037 .0663 m
.9037 .0688 L
.9062 .0688 L
.9062 .0663 L
F
.9087 .0663 m
.9087 .0688 L
.9112 .0688 L
.9112 .0663 L
F
.96619 .0663 m
.96619 .0688 L
.96869 .0688 L
.96869 .0663 L
F
.03131 .0688 m
.03131 .0713 L
.03381 .0713 L
.03381 .0688 L
F
.0863 .0688 m
.0863 .0713 L
.0888 .0713 L
.0888 .0688 L
F
.27878 .0688 m
.27878 .0713 L
.28128 .0713 L
.28128 .0688 L
F
.33377 .0688 m
.33377 .0713 L
.33627 .0713 L
.33627 .0688 L
F
.84621 .0688 m
.84621 .0713 L
.84871 .0713 L
.84871 .0688 L
F
.9012 .0688 m
.9012 .0713 L
.9037 .0713 L
.9037 .0688 L
F
.9087 .0688 m
.9087 .0713 L
.9112 .0713 L
.9112 .0688 L
F
.96369 .0688 m
.96369 .0713 L
.96619 .0713 L
.96619 .0688 L
F
.03131 .0713 m
.03131 .0738 L
.03381 .0738 L
.03381 .0713 L
F
.0838 .0713 m
.0838 .0738 L
.0863 .0738 L
.0863 .0713 L
F
.27878 .0713 m
.27878 .0738 L
.28128 .0738 L
.28128 .0713 L
F
.33127 .0713 m
.33127 .0738 L
.33377 .0738 L
.33377 .0713 L
F
.84621 .0713 m
.84621 .0738 L
.84871 .0738 L
.84871 .0713 L
F
.8987 .0713 m
.8987 .0738 L
.9012 .0738 L
.9012 .0713 L
F
.9087 .0713 m
.9087 .0738 L
.9112 .0738 L
.9112 .0713 L
F
.96119 .0713 m
.96119 .0738 L
.96369 .0738 L
.96369 .0713 L
F
.03131 .0738 m
.03131 .0763 L
.03381 .0763 L
.03381 .0738 L
F
.0813 .0738 m
.0813 .0763 L
.0838 .0763 L
.0838 .0738 L
F
.27878 .0738 m
.27878 .0763 L
.28128 .0763 L
.28128 .0738 L
F
.32877 .0738 m
.32877 .0763 L
.33127 .0763 L
.33127 .0738 L
F
.84621 .0738 m
.84621 .0763 L
.84871 .0763 L
.84871 .0738 L
F
.8962 .0738 m
.8962 .0763 L
.8987 .0763 L
.8987 .0738 L
F
.9087 .0738 m
.9087 .0763 L
.9112 .0763 L
.9112 .0738 L
F
.95869 .0738 m
.95869 .0763 L
.96119 .0763 L
.96119 .0738 L
F
.03131 .0763 m
.03131 .0788 L
.03381 .0788 L
.03381 .0763 L
F
.0788 .0763 m
.0788 .0788 L
.0813 .0788 L
.0813 .0763 L
F
.27878 .0763 m
.27878 .0788 L
.28128 .0788 L
.28128 .0763 L
F
.32627 .0763 m
.32627 .0788 L
.32877 .0788 L
.32877 .0763 L
F
.84621 .0763 m
.84621 .0788 L
.84871 .0788 L
.84871 .0763 L
F
.8937 .0763 m
.8937 .0788 L
.8962 .0788 L
.8962 .0763 L
F
.9087 .0763 m
.9087 .0788 L
.9112 .0788 L
.9112 .0763 L
F
.95619 .0763 m
.95619 .0788 L
.95869 .0788 L
.95869 .0763 L
F
.03131 .0788 m
.03131 .0813 L
.03381 .0813 L
.03381 .0788 L
F
.0763 .0788 m
.0763 .0813 L
.0788 .0813 L
.0788 .0788 L
F
.27878 .0788 m
.27878 .0813 L
.28128 .0813 L
.28128 .0788 L
F
.32377 .0788 m
.32377 .0813 L
.32627 .0813 L
.32627 .0788 L
F
.84621 .0788 m
.84621 .0813 L
.84871 .0813 L
.84871 .0788 L
F
.8912 .0788 m
.8912 .0813 L
.8937 .0813 L
.8937 .0788 L
F
.9087 .0788 m
.9087 .0813 L
.9112 .0813 L
.9112 .0788 L
F
.95369 .0788 m
.95369 .0813 L
.95619 .0813 L
.95619 .0788 L
F
.03131 .0813 m
.03131 .0838 L
.03381 .0838 L
.03381 .0813 L
F
.0738 .0813 m
.0738 .0838 L
.0763 .0838 L
.0763 .0813 L
F
.27878 .0813 m
.27878 .0838 L
.28128 .0838 L
.28128 .0813 L
F
.32127 .0813 m
.32127 .0838 L
.32377 .0838 L
.32377 .0813 L
F
.84621 .0813 m
.84621 .0838 L
.84871 .0838 L
.84871 .0813 L
F
.8887 .0813 m
.8887 .0838 L
.8912 .0838 L
.8912 .0813 L
F
.9087 .0813 m
.9087 .0838 L
.9112 .0838 L
.9112 .0813 L
F
.95119 .0813 m
.95119 .0838 L
.95369 .0838 L
.95369 .0813 L
F
.03131 .0838 m
.03131 .0863 L
.03381 .0863 L
.03381 .0838 L
F
.0713 .0838 m
.0713 .0863 L
.0738 .0863 L
.0738 .0838 L
F
.27878 .0838 m
.27878 .0863 L
.28128 .0863 L
.28128 .0838 L
F
.31877 .0838 m
.31877 .0863 L
.32127 .0863 L
.32127 .0838 L
F
.84621 .0838 m
.84621 .0863 L
.84871 .0863 L
.84871 .0838 L
F
.8862 .0838 m
.8862 .0863 L
.8887 .0863 L
.8887 .0838 L
F
.9087 .0838 m
.9087 .0863 L
.9112 .0863 L
.9112 .0838 L
F
.03131 .0863 m
.03131 .0888 L
.03381 .0888 L
.03381 .0863 L
F
.0688 .0863 m
.0688 .0888 L
.0713 .0888 L
.0713 .0863 L
F
.27878 .0863 m
.27878 .0888 L
.28128 .0888 L
.28128 .0863 L
F
.31627 .0863 m
.31627 .0888 L
.31877 .0888 L
.31877 .0863 L
F
.84621 .0863 m
.84621 .0888 L
.84871 .0888 L
.84871 .0863 L
F
.8837 .0863 m
.8837 .0888 L
.8862 .0888 L
.8862 .0863 L
F
.9087 .0863 m
.9087 .0888 L
.9112 .0888 L
.9112 .0863 L
F
.94619 .0863 m
.94619 .0888 L
.94869 .0888 L
.94869 .0863 L
F
.03131 .0888 m
.03131 .0913 L
.03381 .0913 L
.03381 .0888 L
F
.0663 .0888 m
.0663 .0913 L
.0688 .0913 L
.0688 .0888 L
F
.27878 .0888 m
.27878 .0913 L
.28128 .0913 L
.28128 .0888 L
F
.31377 .0888 m
.31377 .0913 L
.31627 .0913 L
.31627 .0888 L
F
.84621 .0888 m
.84621 .0913 L
.84871 .0913 L
.84871 .0888 L
F
.8812 .0888 m
.8812 .0913 L
.8837 .0913 L
.8837 .0888 L
F
.9087 .0888 m
.9087 .0913 L
.9112 .0913 L
.9112 .0888 L
F
.94369 .0888 m
.94369 .0913 L
.94619 .0913 L
.94619 .0888 L
F
.03131 .0913 m
.03131 .0938 L
.03381 .0938 L
.03381 .0913 L
F
.0638 .0913 m
.0638 .0938 L
.0663 .0938 L
.0663 .0913 L
F
.27878 .0913 m
.27878 .0938 L
.28128 .0938 L
.28128 .0913 L
F
.31127 .0913 m
.31127 .0938 L
.31377 .0938 L
.31377 .0913 L
F
.84621 .0913 m
.84621 .0938 L
.84871 .0938 L
.84871 .0913 L
F
.8787 .0913 m
.8787 .0938 L
.8812 .0938 L
.8812 .0913 L
F
.9087 .0913 m
.9087 .0938 L
.9112 .0938 L
.9112 .0913 L
F
.94119 .0913 m
.94119 .0938 L
.94369 .0938 L
.94369 .0913 L
F
.03131 .0938 m
.03131 .0963 L
.03381 .0963 L
.03381 .0938 L
F
.0613 .0938 m
.0613 .0963 L
.0638 .0963 L
.0638 .0938 L
F
.27878 .0938 m
.27878 .0963 L
.28128 .0963 L
.28128 .0938 L
F
.30877 .0938 m
.30877 .0963 L
.31127 .0963 L
.31127 .0938 L
F
.84621 .0938 m
.84621 .0963 L
.84871 .0963 L
.84871 .0938 L
F
.8762 .0938 m
.8762 .0963 L
.8787 .0963 L
.8787 .0938 L
F
.9087 .0938 m
.9087 .0963 L
.9112 .0963 L
.9112 .0938 L
F
.9387 .0938 m
.9387 .0963 L
.94119 .0963 L
.94119 .0938 L
F
.03131 .0963 m
.03131 .0988 L
.03381 .0988 L
.03381 .0963 L
F
.05881 .0963 m
.05881 .0988 L
.0613 .0988 L
.0613 .0963 L
F
.27878 .0963 m
.27878 .0988 L
.28128 .0988 L
.28128 .0963 L
F
.30627 .0963 m
.30627 .0988 L
.30877 .0988 L
.30877 .0963 L
F
.84621 .0963 m
.84621 .0988 L
.84871 .0988 L
.84871 .0963 L
F
.8737 .0963 m
.8737 .0988 L
.8762 .0988 L
.8762 .0963 L
F
.9087 .0963 m
.9087 .0988 L
.9112 .0988 L
.9112 .0963 L
F
.9362 .0963 m
.9362 .0988 L
.9387 .0988 L
.9387 .0963 L
F
.03131 .0988 m
.03131 .1013 L
.03381 .1013 L
.03381 .0988 L
F
.05631 .0988 m
.05631 .1013 L
.05881 .1013 L
.05881 .0988 L
F
.27878 .0988 m
.27878 .1013 L
.28128 .1013 L
.28128 .0988 L
F
.30377 .0988 m
.30377 .1013 L
.30627 .1013 L
.30627 .0988 L
F
.84621 .0988 m
.84621 .1013 L
.84871 .1013 L
.84871 .0988 L
F
.8712 .0988 m
.8712 .1013 L
.8737 .1013 L
.8737 .0988 L
F
.9087 .0988 m
.9087 .1013 L
.9112 .1013 L
.9112 .0988 L
F
.9337 .0988 m
.9337 .1013 L
.9362 .1013 L
.9362 .0988 L
F
.03131 .1013 m
.03131 .1038 L
.03381 .1038 L
.03381 .1013 L
F
.05381 .1013 m
.05381 .1038 L
.05631 .1038 L
.05631 .1013 L
F
.27878 .1013 m
.27878 .1038 L
.28128 .1038 L
.28128 .1013 L
F
.30127 .1013 m
.30127 .1038 L
.30377 .1038 L
.30377 .1013 L
F
.84621 .1013 m
.84621 .1038 L
.84871 .1038 L
.84871 .1013 L
F
.8687 .1013 m
.8687 .1038 L
.8712 .1038 L
.8712 .1013 L
F
.9087 .1013 m
.9087 .1038 L
.9112 .1038 L
.9112 .1013 L
F
.9312 .1013 m
.9312 .1038 L
.9337 .1038 L
.9337 .1013 L
F
.03131 .1038 m
.03131 .1063 L
.03381 .1063 L
.03381 .1038 L
F
.05131 .1038 m
.05131 .1063 L
.05381 .1063 L
.05381 .1038 L
F
.27878 .1038 m
.27878 .1063 L
.28128 .1063 L
.28128 .1038 L
F
.29878 .1038 m
.29878 .1063 L
.30127 .1063 L
.30127 .1038 L
F
.84621 .1038 m
.84621 .1063 L
.84871 .1063 L
.84871 .1038 L
F
.8662 .1038 m
.8662 .1063 L
.8687 .1063 L
.8687 .1038 L
F
.9087 .1038 m
.9087 .1063 L
.9112 .1063 L
.9112 .1038 L
F
.9287 .1038 m
.9287 .1063 L
.9312 .1063 L
.9312 .1038 L
F
.03131 .1063 m
.03131 .1088 L
.03381 .1088 L
.03381 .1063 L
F
.04881 .1063 m
.04881 .1088 L
.05131 .1088 L
.05131 .1063 L
F
.27878 .1063 m
.27878 .1088 L
.28128 .1088 L
.28128 .1063 L
F
.29628 .1063 m
.29628 .1088 L
.29878 .1088 L
.29878 .1063 L
F
.84621 .1063 m
.84621 .1088 L
.84871 .1088 L
.84871 .1063 L
F
.8637 .1063 m
.8637 .1088 L
.8662 .1088 L
.8662 .1063 L
F
.9087 .1063 m
.9087 .1088 L
.9112 .1088 L
.9112 .1063 L
F
.9262 .1063 m
.9262 .1088 L
.9287 .1088 L
.9287 .1063 L
F
.03131 .1088 m
.03131 .1113 L
.03381 .1113 L
.03381 .1088 L
F
.04631 .1088 m
.04631 .1113 L
.04881 .1113 L
.04881 .1088 L
F
.27878 .1088 m
.27878 .1113 L
.28128 .1113 L
.28128 .1088 L
F
.29378 .1088 m
.29378 .1113 L
.29628 .1113 L
.29628 .1088 L
F
.84621 .1088 m
.84621 .1113 L
.84871 .1113 L
.84871 .1088 L
F
.8612 .1088 m
.8612 .1113 L
.8637 .1113 L
.8637 .1088 L
F
.9087 .1088 m
.9087 .1113 L
.9112 .1113 L
.9112 .1088 L
F
.9237 .1088 m
.9237 .1113 L
.9262 .1113 L
.9262 .1088 L
F
.03131 .1113 m
.03131 .1138 L
.03381 .1138 L
.03381 .1113 L
F
.04381 .1113 m
.04381 .1138 L
.04631 .1138 L
.04631 .1113 L
F
.27878 .1113 m
.27878 .1138 L
.28128 .1138 L
.28128 .1113 L
F
.29128 .1113 m
.29128 .1138 L
.29378 .1138 L
.29378 .1113 L
F
.84621 .1113 m
.84621 .1138 L
.84871 .1138 L
.84871 .1113 L
F
.85871 .1113 m
.85871 .1138 L
.8612 .1138 L
.8612 .1113 L
F
.9087 .1113 m
.9087 .1138 L
.9112 .1138 L
.9112 .1113 L
F
.9212 .1113 m
.9212 .1138 L
.9237 .1138 L
.9237 .1113 L
F
.03131 .1138 m
.03131 .1163 L
.03381 .1163 L
.03381 .1138 L
F
.04131 .1138 m
.04131 .1163 L
.04381 .1163 L
.04381 .1138 L
F
.27878 .1138 m
.27878 .1163 L
.28128 .1163 L
.28128 .1138 L
F
.28878 .1138 m
.28878 .1163 L
.29128 .1163 L
.29128 .1138 L
F
.84621 .1138 m
.84621 .1163 L
.84871 .1163 L
.84871 .1138 L
F
.85621 .1138 m
.85621 .1163 L
.85871 .1163 L
.85871 .1138 L
F
.9087 .1138 m
.9087 .1163 L
.9112 .1163 L
.9112 .1138 L
F
.9187 .1138 m
.9187 .1163 L
.9212 .1163 L
.9212 .1138 L
F
.03131 .1163 m
.03131 .1188 L
.03381 .1188 L
.03381 .1163 L
F
.03881 .1163 m
.03881 .1188 L
.04131 .1188 L
.04131 .1163 L
F
.27878 .1163 m
.27878 .1188 L
.28128 .1188 L
.28128 .1163 L
F
.28628 .1163 m
.28628 .1188 L
.28878 .1188 L
.28878 .1163 L
F
.84621 .1163 m
.84621 .1188 L
.84871 .1188 L
.84871 .1163 L
F
.85371 .1163 m
.85371 .1188 L
.85621 .1188 L
.85621 .1163 L
F
.9087 .1163 m
.9087 .1188 L
.9112 .1188 L
.9112 .1163 L
F
.9162 .1163 m
.9162 .1188 L
.9187 .1188 L
.9187 .1163 L
F
.03131 .1188 m
.03131 .1213 L
.03381 .1213 L
.03381 .1188 L
F
.03631 .1188 m
.03631 .1213 L
.03881 .1213 L
.03881 .1188 L
F
.27878 .1188 m
.27878 .1213 L
.28128 .1213 L
.28128 .1188 L
F
.28378 .1188 m
.28378 .1213 L
.28628 .1213 L
.28628 .1188 L
F
.84621 .1188 m
.84621 .1213 L
.84871 .1213 L
.84871 .1188 L
F
.85121 .1188 m
.85121 .1213 L
.85371 .1213 L
.85371 .1188 L
F
.9087 .1188 m
.9087 .1213 L
.9112 .1213 L
.9112 .1188 L
F
.9137 .1188 m
.9137 .1213 L
.9162 .1213 L
.9162 .1188 L
F
.03131 .1213 m
.03131 .1238 L
.03381 .1238 L
.03381 .1213 L
F
.03381 .1213 m
.03381 .1238 L
.03631 .1238 L
.03631 .1213 L
F
.27878 .1213 m
.27878 .1238 L
.28128 .1238 L
.28128 .1213 L
F
.28128 .1213 m
.28128 .1238 L
.28378 .1238 L
.28378 .1213 L
F
.84621 .1213 m
.84621 .1238 L
.84871 .1238 L
.84871 .1213 L
F
.84871 .1213 m
.84871 .1238 L
.85121 .1238 L
.85121 .1213 L
F
.9087 .1213 m
.9087 .1238 L
.9112 .1238 L
.9112 .1213 L
F
.9112 .1213 m
.9112 .1238 L
.9137 .1238 L
.9137 .1213 L
F
.0888 .1238 m
.0888 .1263 L
.0913 .1263 L
.0913 .1238 L
F
.33627 .1238 m
.33627 .1263 L
.33877 .1263 L
.33877 .1238 L
F
.96619 .1238 m
.96619 .1263 L
.96869 .1263 L
.96869 .1238 L
F
.97369 .1238 m
.97369 .1263 L
.97619 .1263 L
.97619 .1238 L
F
.0863 .1263 m
.0863 .1288 L
.0888 .1288 L
.0888 .1263 L
F
.33377 .1263 m
.33377 .1288 L
.33627 .1288 L
.33627 .1263 L
F
.96369 .1263 m
.96369 .1288 L
.96619 .1288 L
.96619 .1263 L
F
.97369 .1263 m
.97369 .1288 L
.97619 .1288 L
.97619 .1263 L
F
.0838 .1288 m
.0838 .1313 L
.0863 .1313 L
.0863 .1288 L
F
.33127 .1288 m
.33127 .1313 L
.33377 .1313 L
.33377 .1288 L
F
.96119 .1288 m
.96119 .1313 L
.96369 .1313 L
.96369 .1288 L
F
.97369 .1288 m
.97369 .1313 L
.97619 .1313 L
.97619 .1288 L
F
.0813 .1313 m
.0813 .1338 L
.0838 .1338 L
.0838 .1313 L
F
.32877 .1313 m
.32877 .1338 L
.33127 .1338 L
.33127 .1313 L
F
.95869 .1313 m
.95869 .1338 L
.96119 .1338 L
.96119 .1313 L
F
.97369 .1313 m
.97369 .1338 L
.97619 .1338 L
.97619 .1313 L
F
.0788 .1338 m
.0788 .1363 L
.0813 .1363 L
.0813 .1338 L
F
.32627 .1338 m
.32627 .1363 L
.32877 .1363 L
.32877 .1338 L
F
.95619 .1338 m
.95619 .1363 L
.95869 .1363 L
.95869 .1338 L
F
.97369 .1338 m
.97369 .1363 L
.97619 .1363 L
.97619 .1338 L
F
.0763 .1363 m
.0763 .1388 L
.0788 .1388 L
.0788 .1363 L
F
.32377 .1363 m
.32377 .1388 L
.32627 .1388 L
.32627 .1363 L
F
.95369 .1363 m
.95369 .1388 L
.95619 .1388 L
.95619 .1363 L
F
.97369 .1363 m
.97369 .1388 L
.97619 .1388 L
.97619 .1363 L
F
.0738 .1388 m
.0738 .14129 L
.0763 .14129 L
.0763 .1388 L
F
.32127 .1388 m
.32127 .14129 L
.32377 .14129 L
.32377 .1388 L
F
.95119 .1388 m
.95119 .14129 L
.95369 .14129 L
.95369 .1388 L
F
.97369 .1388 m
.97369 .14129 L
.97619 .14129 L
.97619 .1388 L
F
.0713 .14129 m
.0713 .14379 L
.0738 .14379 L
.0738 .14129 L
F
.31877 .14129 m
.31877 .14379 L
.32127 .14379 L
.32127 .14129 L
F
.94869 .14129 m
.94869 .14379 L
.95119 .14379 L
.95119 .14129 L
F
.97369 .14129 m
.97369 .14379 L
.97619 .14379 L
.97619 .14129 L
F
.0688 .14379 m
.0688 .14629 L
.0713 .14629 L
.0713 .14379 L
F
.31627 .14379 m
.31627 .14629 L
.31877 .14629 L
.31877 .14379 L
F
.94619 .14379 m
.94619 .14629 L
.94869 .14629 L
.94869 .14379 L
F
.97369 .14379 m
.97369 .14629 L
.97619 .14629 L
.97619 .14379 L
F
.0663 .14629 m
.0663 .14879 L
.0688 .14879 L
.0688 .14629 L
F
.31377 .14629 m
.31377 .14879 L
.31627 .14879 L
.31627 .14629 L
F
.94369 .14629 m
.94369 .14879 L
.94619 .14879 L
.94619 .14629 L
F
.97369 .14629 m
.97369 .14879 L
.97619 .14879 L
.97619 .14629 L
F
.0638 .14879 m
.0638 .15129 L
.0663 .15129 L
.0663 .14879 L
F
.31127 .14879 m
.31127 .15129 L
.31377 .15129 L
.31377 .14879 L
F
.94119 .14879 m
.94119 .15129 L
.94369 .15129 L
.94369 .14879 L
F
.97369 .14879 m
.97369 .15129 L
.97619 .15129 L
.97619 .14879 L
F
.0613 .15129 m
.0613 .15379 L
.0638 .15379 L
.0638 .15129 L
F
.30877 .15129 m
.30877 .15379 L
.31127 .15379 L
.31127 .15129 L
F
.9387 .15129 m
.9387 .15379 L
.94119 .15379 L
.94119 .15129 L
F
.97369 .15129 m
.97369 .15379 L
.97619 .15379 L
.97619 .15129 L
F
.05881 .15379 m
.05881 .15629 L
.0613 .15629 L
.0613 .15379 L
F
.30627 .15379 m
.30627 .15629 L
.30877 .15629 L
.30877 .15379 L
F
.9362 .15379 m
.9362 .15629 L
.9387 .15629 L
.9387 .15379 L
F
.97369 .15379 m
.97369 .15629 L
.97619 .15629 L
.97619 .15379 L
F
.05631 .15629 m
.05631 .15879 L
.05881 .15879 L
.05881 .15629 L
F
.30377 .15629 m
.30377 .15879 L
.30627 .15879 L
.30627 .15629 L
F
.9337 .15629 m
.9337 .15879 L
.9362 .15879 L
.9362 .15629 L
F
.97369 .15629 m
.97369 .15879 L
.97619 .15879 L
.97619 .15629 L
F
.05381 .15879 m
.05381 .16129 L
.05631 .16129 L
.05631 .15879 L
F
.30127 .15879 m
.30127 .16129 L
.30377 .16129 L
.30377 .15879 L
F
.9312 .15879 m
.9312 .16129 L
.9337 .16129 L
.9337 .15879 L
F
.97369 .15879 m
.97369 .16129 L
.97619 .16129 L
.97619 .15879 L
F
.05131 .16129 m
.05131 .16379 L
.05381 .16379 L
.05381 .16129 L
F
.29878 .16129 m
.29878 .16379 L
.30127 .16379 L
.30127 .16129 L
F
.9287 .16129 m
.9287 .16379 L
.9312 .16379 L
.9312 .16129 L
F
.97369 .16129 m
.97369 .16379 L
.97619 .16379 L
.97619 .16129 L
F
.04881 .16379 m
.04881 .16629 L
.05131 .16629 L
.05131 .16379 L
F
.29628 .16379 m
.29628 .16629 L
.29878 .16629 L
.29878 .16379 L
F
.9262 .16379 m
.9262 .16629 L
.9287 .16629 L
.9287 .16379 L
F
.97369 .16379 m
.97369 .16629 L
.97619 .16629 L
.97619 .16379 L
F
.04631 .16629 m
.04631 .16879 L
.04881 .16879 L
.04881 .16629 L
F
.29378 .16629 m
.29378 .16879 L
.29628 .16879 L
.29628 .16629 L
F
.9237 .16629 m
.9237 .16879 L
.9262 .16879 L
.9262 .16629 L
F
.97369 .16629 m
.97369 .16879 L
.97619 .16879 L
.97619 .16629 L
F
.04381 .16879 m
.04381 .17129 L
.04631 .17129 L
.04631 .16879 L
F
.29128 .16879 m
.29128 .17129 L
.29378 .17129 L
.29378 .16879 L
F
.9212 .16879 m
.9212 .17129 L
.9237 .17129 L
.9237 .16879 L
F
.97369 .16879 m
.97369 .17129 L
.97619 .17129 L
.97619 .16879 L
F
.04131 .17129 m
.04131 .17379 L
.04381 .17379 L
.04381 .17129 L
F
.28878 .17129 m
.28878 .17379 L
.29128 .17379 L
.29128 .17129 L
F
.9187 .17129 m
.9187 .17379 L
.9212 .17379 L
.9212 .17129 L
F
.97369 .17129 m
.97369 .17379 L
.97619 .17379 L
.97619 .17129 L
F
.03881 .17379 m
.03881 .17629 L
.04131 .17629 L
.04131 .17379 L
F
.28628 .17379 m
.28628 .17629 L
.28878 .17629 L
.28878 .17379 L
F
.9162 .17379 m
.9162 .17629 L
.9187 .17629 L
.9187 .17379 L
F
.97369 .17379 m
.97369 .17629 L
.97619 .17629 L
.97619 .17379 L
F
.03631 .17629 m
.03631 .17879 L
.03881 .17879 L
.03881 .17629 L
F
.28378 .17629 m
.28378 .17879 L
.28628 .17879 L
.28628 .17629 L
F
.9137 .17629 m
.9137 .17879 L
.9162 .17879 L
.9162 .17629 L
F
.97369 .17629 m
.97369 .17879 L
.97619 .17879 L
.97619 .17629 L
F
.03381 .17879 m
.03381 .18129 L
.03631 .18129 L
.03631 .17879 L
F
.28128 .17879 m
.28128 .18129 L
.28378 .18129 L
.28378 .17879 L
F
.9112 .17879 m
.9112 .18129 L
.9137 .18129 L
.9137 .17879 L
F
.97369 .17879 m
.97369 .18129 L
.97619 .18129 L
.97619 .17879 L
F
.34127 .18129 m
.34127 .18379 L
.34377 .18379 L
.34377 .18129 L
F
.9087 .18129 m
.9087 .18379 L
.9112 .18379 L
.9112 .18129 L
F
.84871 .18379 m
.84871 .18629 L
.85121 .18629 L
.85121 .18379 L
F
.85121 .18379 m
.85121 .18629 L
.85371 .18629 L
.85371 .18379 L
F
.85371 .18379 m
.85371 .18629 L
.85621 .18629 L
.85621 .18379 L
F
.85621 .18379 m
.85621 .18629 L
.85871 .18629 L
.85871 .18379 L
F
.85871 .18379 m
.85871 .18629 L
.8612 .18629 L
.8612 .18379 L
F
.8612 .18379 m
.8612 .18629 L
.8637 .18629 L
.8637 .18379 L
F
.8637 .18379 m
.8637 .18629 L
.8662 .18629 L
.8662 .18379 L
F
.8662 .18379 m
.8662 .18629 L
.8687 .18629 L
.8687 .18379 L
F
.8687 .18379 m
.8687 .18629 L
.8712 .18629 L
.8712 .18379 L
F
.8712 .18379 m
.8712 .18629 L
.8737 .18629 L
.8737 .18379 L
F
.8737 .18379 m
.8737 .18629 L
.8762 .18629 L
.8762 .18379 L
F
.8762 .18379 m
.8762 .18629 L
.8787 .18629 L
.8787 .18379 L
F
.8787 .18379 m
.8787 .18629 L
.8812 .18629 L
.8812 .18379 L
F
.8812 .18379 m
.8812 .18629 L
.8837 .18629 L
.8837 .18379 L
F
.8837 .18379 m
.8837 .18629 L
.8862 .18629 L
.8862 .18379 L
F
.8862 .18379 m
.8862 .18629 L
.8887 .18629 L
.8887 .18379 L
F
.8887 .18379 m
.8887 .18629 L
.8912 .18629 L
.8912 .18379 L
F
.8912 .18379 m
.8912 .18629 L
.8937 .18629 L
.8937 .18379 L
F
.8937 .18379 m
.8937 .18629 L
.8962 .18629 L
.8962 .18379 L
F
.8962 .18379 m
.8962 .18629 L
.8987 .18629 L
.8987 .18379 L
F
.8987 .18379 m
.8987 .18629 L
.9012 .18629 L
.9012 .18379 L
F
.9012 .18379 m
.9012 .18629 L
.9037 .18629 L
.9037 .18379 L
F
.9037 .18379 m
.9037 .18629 L
.9062 .18629 L
.9062 .18379 L
F
.9062 .18379 m
.9062 .18629 L
.9087 .18629 L
.9087 .18379 L
F
.97119 .18379 m
.97119 .18629 L
.97369 .18629 L
.97369 .18379 L
F
.21629 .18629 m
.21629 .18879 L
.21879 .18879 L
.21879 .18629 L
F
.27628 .18629 m
.27628 .18879 L
.27878 .18879 L
.27878 .18629 L
F
.34127 .18629 m
.34127 .18879 L
.34377 .18879 L
.34377 .18629 L
F
.40126 .18629 m
.40126 .18879 L
.40376 .18879 L
.40376 .18629 L
F
.84621 .18629 m
.84621 .18879 L
.84871 .18879 L
.84871 .18629 L
F
.9062 .18629 m
.9062 .18879 L
.9087 .18879 L
.9087 .18629 L
F
.9087 .18629 m
.9087 .18879 L
.9112 .18879 L
.9112 .18629 L
F
.96869 .18629 m
.96869 .18879 L
.97119 .18879 L
.97119 .18629 L
F
.21629 .18879 m
.21629 .19129 L
.21879 .19129 L
.21879 .18879 L
F
.27378 .18879 m
.27378 .19129 L
.27628 .19129 L
.27628 .18879 L
F
.34127 .18879 m
.34127 .19129 L
.34377 .19129 L
.34377 .18879 L
F
.39876 .18879 m
.39876 .19129 L
.40126 .19129 L
.40126 .18879 L
F
.84621 .18879 m
.84621 .19129 L
.84871 .19129 L
.84871 .18879 L
F
.9037 .18879 m
.9037 .19129 L
.9062 .19129 L
.9062 .18879 L
F
.9087 .18879 m
.9087 .19129 L
.9112 .19129 L
.9112 .18879 L
F
.96619 .18879 m
.96619 .19129 L
.96869 .19129 L
.96869 .18879 L
F
.21629 .19129 m
.21629 .19379 L
.21879 .19379 L
.21879 .19129 L
F
.27128 .19129 m
.27128 .19379 L
.27378 .19379 L
.27378 .19129 L
F
.34127 .19129 m
.34127 .19379 L
.34377 .19379 L
.34377 .19129 L
F
.39626 .19129 m
.39626 .19379 L
.39876 .19379 L
.39876 .19129 L
F
.84621 .19129 m
.84621 .19379 L
.84871 .19379 L
.84871 .19129 L
F
.9012 .19129 m
.9012 .19379 L
.9037 .19379 L
.9037 .19129 L
F
.9087 .19129 m
.9087 .19379 L
.9112 .19379 L
.9112 .19129 L
F
.96369 .19129 m
.96369 .19379 L
.96619 .19379 L
.96619 .19129 L
F
.21629 .19379 m
.21629 .19629 L
.21879 .19629 L
.21879 .19379 L
F
.26878 .19379 m
.26878 .19629 L
.27128 .19629 L
.27128 .19379 L
F
.34127 .19379 m
.34127 .19629 L
.34377 .19629 L
.34377 .19379 L
F
.39376 .19379 m
.39376 .19629 L
.39626 .19629 L
.39626 .19379 L
F
.84621 .19379 m
.84621 .19629 L
.84871 .19629 L
.84871 .19379 L
F
.8987 .19379 m
.8987 .19629 L
.9012 .19629 L
.9012 .19379 L
F
.9087 .19379 m
.9087 .19629 L
.9112 .19629 L
.9112 .19379 L
F
.96119 .19379 m
.96119 .19629 L
.96369 .19629 L
.96369 .19379 L
F
.21629 .19629 m
.21629 .19879 L
.21879 .19879 L
.21879 .19629 L
F
.26628 .19629 m
.26628 .19879 L
.26878 .19879 L
.26878 .19629 L
F
.34127 .19629 m
.34127 .19879 L
.34377 .19879 L
.34377 .19629 L
F
.39126 .19629 m
.39126 .19879 L
.39376 .19879 L
.39376 .19629 L
F
.84621 .19629 m
.84621 .19879 L
.84871 .19879 L
.84871 .19629 L
F
.8962 .19629 m
.8962 .19879 L
.8987 .19879 L
.8987 .19629 L
F
.9087 .19629 m
.9087 .19879 L
.9112 .19879 L
.9112 .19629 L
F
.95869 .19629 m
.95869 .19879 L
.96119 .19879 L
.96119 .19629 L
F
.21629 .19879 m
.21629 .20129 L
.21879 .20129 L
.21879 .19879 L
F
.26378 .19879 m
.26378 .20129 L
.26628 .20129 L
.26628 .19879 L
F
.34127 .19879 m
.34127 .20129 L
.34377 .20129 L
.34377 .19879 L
F
.38876 .19879 m
.38876 .20129 L
.39126 .20129 L
.39126 .19879 L
F
.84621 .19879 m
.84621 .20129 L
.84871 .20129 L
.84871 .19879 L
F
.8937 .19879 m
.8937 .20129 L
.8962 .20129 L
.8962 .19879 L
F
.9087 .19879 m
.9087 .20129 L
.9112 .20129 L
.9112 .19879 L
F
.95619 .19879 m
.95619 .20129 L
.95869 .20129 L
.95869 .19879 L
F
.21629 .20129 m
.21629 .20379 L
.21879 .20379 L
.21879 .20129 L
F
.26128 .20129 m
.26128 .20379 L
.26378 .20379 L
.26378 .20129 L
F
.34127 .20129 m
.34127 .20379 L
.34377 .20379 L
.34377 .20129 L
F
.38626 .20129 m
.38626 .20379 L
.38876 .20379 L
.38876 .20129 L
F
.84621 .20129 m
.84621 .20379 L
.84871 .20379 L
.84871 .20129 L
F
.8912 .20129 m
.8912 .20379 L
.8937 .20379 L
.8937 .20129 L
F
.9087 .20129 m
.9087 .20379 L
.9112 .20379 L
.9112 .20129 L
F
.95369 .20129 m
.95369 .20379 L
.95619 .20379 L
.95619 .20129 L
F
.21629 .20379 m
.21629 .20629 L
.21879 .20629 L
.21879 .20379 L
F
.25878 .20379 m
.25878 .20629 L
.26128 .20629 L
.26128 .20379 L
F
.34127 .20379 m
.34127 .20629 L
.34377 .20629 L
.34377 .20379 L
F
.38376 .20379 m
.38376 .20629 L
.38626 .20629 L
.38626 .20379 L
F
.84621 .20379 m
.84621 .20629 L
.84871 .20629 L
.84871 .20379 L
F
.8887 .20379 m
.8887 .20629 L
.8912 .20629 L
.8912 .20379 L
F
.9087 .20379 m
.9087 .20629 L
.9112 .20629 L
.9112 .20379 L
F
.95119 .20379 m
.95119 .20629 L
.95369 .20629 L
.95369 .20379 L
F
.21629 .20629 m
.21629 .20879 L
.21879 .20879 L
.21879 .20629 L
F
.25628 .20629 m
.25628 .20879 L
.25878 .20879 L
.25878 .20629 L
F
.34127 .20629 m
.34127 .20879 L
.34377 .20879 L
.34377 .20629 L
F
.38126 .20629 m
.38126 .20879 L
.38376 .20879 L
.38376 .20629 L
F
.84621 .20629 m
.84621 .20879 L
.84871 .20879 L
.84871 .20629 L
F
.8862 .20629 m
.8862 .20879 L
.8887 .20879 L
.8887 .20629 L
F
.9087 .20629 m
.9087 .20879 L
.9112 .20879 L
.9112 .20629 L
F
.94869 .20629 m
.94869 .20879 L
.95119 .20879 L
.95119 .20629 L
F
.21629 .20879 m
.21629 .21129 L
.21879 .21129 L
.21879 .20879 L
F
.25378 .20879 m
.25378 .21129 L
.25628 .21129 L
.25628 .20879 L
F
.34127 .20879 m
.34127 .21129 L
.34377 .21129 L
.34377 .20879 L
F
.37877 .20879 m
.37877 .21129 L
.38126 .21129 L
.38126 .20879 L
F
.84621 .20879 m
.84621 .21129 L
.84871 .21129 L
.84871 .20879 L
F
.8837 .20879 m
.8837 .21129 L
.8862 .21129 L
.8862 .20879 L
F
.9087 .20879 m
.9087 .21129 L
.9112 .21129 L
.9112 .20879 L
F
.94619 .20879 m
.94619 .21129 L
.94869 .21129 L
.94869 .20879 L
F
.21629 .21129 m
.21629 .21379 L
.21879 .21379 L
.21879 .21129 L
F
.25128 .21129 m
.25128 .21379 L
.25378 .21379 L
.25378 .21129 L
F
.34127 .21129 m
.34127 .21379 L
.34377 .21379 L
.34377 .21129 L
F
.37627 .21129 m
.37627 .21379 L
.37877 .21379 L
.37877 .21129 L
F
.84621 .21129 m
.84621 .21379 L
.84871 .21379 L
.84871 .21129 L
F
.8812 .21129 m
.8812 .21379 L
.8837 .21379 L
.8837 .21129 L
F
.9087 .21129 m
.9087 .21379 L
.9112 .21379 L
.9112 .21129 L
F
.94369 .21129 m
.94369 .21379 L
.94619 .21379 L
.94619 .21129 L
F
.21629 .21379 m
.21629 .21629 L
.21879 .21629 L
.21879 .21379 L
F
.24878 .21379 m
.24878 .21629 L
.25128 .21629 L
.25128 .21379 L
F
.34127 .21379 m
.34127 .21629 L
.34377 .21629 L
.34377 .21379 L
F
.37377 .21379 m
.37377 .21629 L
.37627 .21629 L
.37627 .21379 L
F
.84621 .21379 m
.84621 .21629 L
.84871 .21629 L
.84871 .21379 L
F
.8787 .21379 m
.8787 .21629 L
.8812 .21629 L
.8812 .21379 L
F
.9087 .21379 m
.9087 .21629 L
.9112 .21629 L
.9112 .21379 L
F
.94119 .21379 m
.94119 .21629 L
.94369 .21629 L
.94369 .21379 L
F
.21629 .21629 m
.21629 .21879 L
.21879 .21879 L
.21879 .21629 L
F
.24628 .21629 m
.24628 .21879 L
.24878 .21879 L
.24878 .21629 L
F
.34127 .21629 m
.34127 .21879 L
.34377 .21879 L
.34377 .21629 L
F
.37127 .21629 m
.37127 .21879 L
.37377 .21879 L
.37377 .21629 L
F
.84621 .21629 m
.84621 .21879 L
.84871 .21879 L
.84871 .21629 L
F
.8762 .21629 m
.8762 .21879 L
.8787 .21879 L
.8787 .21629 L
F
.9087 .21629 m
.9087 .21879 L
.9112 .21879 L
.9112 .21629 L
F
.9387 .21629 m
.9387 .21879 L
.94119 .21879 L
.94119 .21629 L
F
.21629 .21879 m
.21629 .22128 L
.21879 .22128 L
.21879 .21879 L
F
.24378 .21879 m
.24378 .22128 L
.24628 .22128 L
.24628 .21879 L
F
.34127 .21879 m
.34127 .22128 L
.34377 .22128 L
.34377 .21879 L
F
.36877 .21879 m
.36877 .22128 L
.37127 .22128 L
.37127 .21879 L
F
.84621 .21879 m
.84621 .22128 L
.84871 .22128 L
.84871 .21879 L
F
.8737 .21879 m
.8737 .22128 L
.8762 .22128 L
.8762 .21879 L
F
.9087 .21879 m
.9087 .22128 L
.9112 .22128 L
.9112 .21879 L
F
.9362 .21879 m
.9362 .22128 L
.9387 .22128 L
.9387 .21879 L
F
.21629 .22128 m
.21629 .22378 L
.21879 .22378 L
.21879 .22128 L
F
.24128 .22128 m
.24128 .22378 L
.24378 .22378 L
.24378 .22128 L
F
.34127 .22128 m
.34127 .22378 L
.34377 .22378 L
.34377 .22128 L
F
.36627 .22128 m
.36627 .22378 L
.36877 .22378 L
.36877 .22128 L
F
.84621 .22128 m
.84621 .22378 L
.84871 .22378 L
.84871 .22128 L
F
.8712 .22128 m
.8712 .22378 L
.8737 .22378 L
.8737 .22128 L
F
.9087 .22128 m
.9087 .22378 L
.9112 .22378 L
.9112 .22128 L
F
.9337 .22128 m
.9337 .22378 L
.9362 .22378 L
.9362 .22128 L
F
.21629 .22378 m
.21629 .22628 L
.21879 .22628 L
.21879 .22378 L
F
.23878 .22378 m
.23878 .22628 L
.24128 .22628 L
.24128 .22378 L
F
.34127 .22378 m
.34127 .22628 L
.34377 .22628 L
.34377 .22378 L
F
.36377 .22378 m
.36377 .22628 L
.36627 .22628 L
.36627 .22378 L
F
.84621 .22378 m
.84621 .22628 L
.84871 .22628 L
.84871 .22378 L
F
.8687 .22378 m
.8687 .22628 L
.8712 .22628 L
.8712 .22378 L
F
.9087 .22378 m
.9087 .22628 L
.9112 .22628 L
.9112 .22378 L
F
.9312 .22378 m
.9312 .22628 L
.9337 .22628 L
.9337 .22378 L
F
.21629 .22628 m
.21629 .22878 L
.21879 .22878 L
.21879 .22628 L
F
.23628 .22628 m
.23628 .22878 L
.23878 .22878 L
.23878 .22628 L
F
.34127 .22628 m
.34127 .22878 L
.34377 .22878 L
.34377 .22628 L
F
.36127 .22628 m
.36127 .22878 L
.36377 .22878 L
.36377 .22628 L
F
.84621 .22628 m
.84621 .22878 L
.84871 .22878 L
.84871 .22628 L
F
.8662 .22628 m
.8662 .22878 L
.8687 .22878 L
.8687 .22628 L
F
.9087 .22628 m
.9087 .22878 L
.9112 .22878 L
.9112 .22628 L
F
.9287 .22628 m
.9287 .22878 L
.9312 .22878 L
.9312 .22628 L
F
.21629 .22878 m
.21629 .23128 L
.21879 .23128 L
.21879 .22878 L
F
.23378 .22878 m
.23378 .23128 L
.23628 .23128 L
.23628 .22878 L
F
.34127 .22878 m
.34127 .23128 L
.34377 .23128 L
.34377 .22878 L
F
.35877 .22878 m
.35877 .23128 L
.36127 .23128 L
.36127 .22878 L
F
.84621 .22878 m
.84621 .23128 L
.84871 .23128 L
.84871 .22878 L
F
.8637 .22878 m
.8637 .23128 L
.8662 .23128 L
.8662 .22878 L
F
.9087 .22878 m
.9087 .23128 L
.9112 .23128 L
.9112 .22878 L
F
.9262 .22878 m
.9262 .23128 L
.9287 .23128 L
.9287 .22878 L
F
.21629 .23128 m
.21629 .23378 L
.21879 .23378 L
.21879 .23128 L
F
.23128 .23128 m
.23128 .23378 L
.23378 .23378 L
.23378 .23128 L
F
.34127 .23128 m
.34127 .23378 L
.34377 .23378 L
.34377 .23128 L
F
.35627 .23128 m
.35627 .23378 L
.35877 .23378 L
.35877 .23128 L
F
.84621 .23128 m
.84621 .23378 L
.84871 .23378 L
.84871 .23128 L
F
.8612 .23128 m
.8612 .23378 L
.8637 .23378 L
.8637 .23128 L
F
.9087 .23128 m
.9087 .23378 L
.9112 .23378 L
.9112 .23128 L
F
.9237 .23128 m
.9237 .23378 L
.9262 .23378 L
.9262 .23128 L
F
.21629 .23378 m
.21629 .23628 L
.21879 .23628 L
.21879 .23378 L
F
.22878 .23378 m
.22878 .23628 L
.23128 .23628 L
.23128 .23378 L
F
.34127 .23378 m
.34127 .23628 L
.34377 .23628 L
.34377 .23378 L
F
.35377 .23378 m
.35377 .23628 L
.35627 .23628 L
.35627 .23378 L
F
.84621 .23378 m
.84621 .23628 L
.84871 .23628 L
.84871 .23378 L
F
.85871 .23378 m
.85871 .23628 L
.8612 .23628 L
.8612 .23378 L
F
.9087 .23378 m
.9087 .23628 L
.9112 .23628 L
.9112 .23378 L
F
.9212 .23378 m
.9212 .23628 L
.9237 .23628 L
.9237 .23378 L
F
.21629 .23628 m
.21629 .23878 L
.21879 .23878 L
.21879 .23628 L
F
.22628 .23628 m
.22628 .23878 L
.22878 .23878 L
.22878 .23628 L
F
.34127 .23628 m
.34127 .23878 L
.34377 .23878 L
.34377 .23628 L
F
.35127 .23628 m
.35127 .23878 L
.35377 .23878 L
.35377 .23628 L
F
.84621 .23628 m
.84621 .23878 L
.84871 .23878 L
.84871 .23628 L
F
.85621 .23628 m
.85621 .23878 L
.85871 .23878 L
.85871 .23628 L
F
.9087 .23628 m
.9087 .23878 L
.9112 .23878 L
.9112 .23628 L
F
.9187 .23628 m
.9187 .23878 L
.9212 .23878 L
.9212 .23628 L
F
.21629 .23878 m
.21629 .24128 L
.21879 .24128 L
.21879 .23878 L
F
.22378 .23878 m
.22378 .24128 L
.22628 .24128 L
.22628 .23878 L
F
.34127 .23878 m
.34127 .24128 L
.34377 .24128 L
.34377 .23878 L
F
.34877 .23878 m
.34877 .24128 L
.35127 .24128 L
.35127 .23878 L
F
.84621 .23878 m
.84621 .24128 L
.84871 .24128 L
.84871 .23878 L
F
.85371 .23878 m
.85371 .24128 L
.85621 .24128 L
.85621 .23878 L
F
.9087 .23878 m
.9087 .24128 L
.9112 .24128 L
.9112 .23878 L
F
.9162 .23878 m
.9162 .24128 L
.9187 .24128 L
.9187 .23878 L
F
.21629 .24128 m
.21629 .24378 L
.21879 .24378 L
.21879 .24128 L
F
.22128 .24128 m
.22128 .24378 L
.22378 .24378 L
.22378 .24128 L
F
.34127 .24128 m
.34127 .24378 L
.34377 .24378 L
.34377 .24128 L
F
.34627 .24128 m
.34627 .24378 L
.34877 .24378 L
.34877 .24128 L
F
.84621 .24128 m
.84621 .24378 L
.84871 .24378 L
.84871 .24128 L
F
.85121 .24128 m
.85121 .24378 L
.85371 .24378 L
.85371 .24128 L
F
.9087 .24128 m
.9087 .24378 L
.9112 .24378 L
.9112 .24128 L
F
.9137 .24128 m
.9137 .24378 L
.9162 .24378 L
.9162 .24128 L
F
.21629 .24378 m
.21629 .24628 L
.21879 .24628 L
.21879 .24378 L
F
.21879 .24378 m
.21879 .24628 L
.22128 .24628 L
.22128 .24378 L
F
.34127 .24378 m
.34127 .24628 L
.34377 .24628 L
.34377 .24378 L
F
.34377 .24378 m
.34377 .24628 L
.34627 .24628 L
.34627 .24378 L
F
.84621 .24378 m
.84621 .24628 L
.84871 .24628 L
.84871 .24378 L
F
.84871 .24378 m
.84871 .24628 L
.85121 .24628 L
.85121 .24378 L
F
.9087 .24378 m
.9087 .24628 L
.9112 .24628 L
.9112 .24378 L
F
.9112 .24378 m
.9112 .24628 L
.9137 .24628 L
.9137 .24378 L
F
.39876 .24628 m
.39876 .24878 L
.40126 .24878 L
.40126 .24628 L
F
.9037 .24628 m
.9037 .24878 L
.9062 .24878 L
.9062 .24628 L
F
.96619 .24628 m
.96619 .24878 L
.96869 .24878 L
.96869 .24628 L
F
.97119 .24628 m
.97119 .24878 L
.97369 .24878 L
.97369 .24628 L
F
.39626 .24878 m
.39626 .25128 L
.39876 .25128 L
.39876 .24878 L
F
.9012 .24878 m
.9012 .25128 L
.9037 .25128 L
.9037 .24878 L
F
.96369 .24878 m
.96369 .25128 L
.96619 .25128 L
.96619 .24878 L
F
.97119 .24878 m
.97119 .25128 L
.97369 .25128 L
.97369 .24878 L
F
.39376 .25128 m
.39376 .25378 L
.39626 .25378 L
.39626 .25128 L
F
.8987 .25128 m
.8987 .25378 L
.9012 .25378 L
.9012 .25128 L
F
.96119 .25128 m
.96119 .25378 L
.96369 .25378 L
.96369 .25128 L
F
.97119 .25128 m
.97119 .25378 L
.97369 .25378 L
.97369 .25128 L
F
.39126 .25378 m
.39126 .25628 L
.39376 .25628 L
.39376 .25378 L
F
.8962 .25378 m
.8962 .25628 L
.8987 .25628 L
.8987 .25378 L
F
.95869 .25378 m
.95869 .25628 L
.96119 .25628 L
.96119 .25378 L
F
.97119 .25378 m
.97119 .25628 L
.97369 .25628 L
.97369 .25378 L
F
.38876 .25628 m
.38876 .25878 L
.39126 .25878 L
.39126 .25628 L
F
.8937 .25628 m
.8937 .25878 L
.8962 .25878 L
.8962 .25628 L
F
.95619 .25628 m
.95619 .25878 L
.95869 .25878 L
.95869 .25628 L
F
.97119 .25628 m
.97119 .25878 L
.97369 .25878 L
.97369 .25628 L
F
.38626 .25878 m
.38626 .26128 L
.38876 .26128 L
.38876 .25878 L
F
.8912 .25878 m
.8912 .26128 L
.8937 .26128 L
.8937 .25878 L
F
.95369 .25878 m
.95369 .26128 L
.95619 .26128 L
.95619 .25878 L
F
.97119 .25878 m
.97119 .26128 L
.97369 .26128 L
.97369 .25878 L
F
.38376 .26128 m
.38376 .26378 L
.38626 .26378 L
.38626 .26128 L
F
.8887 .26128 m
.8887 .26378 L
.8912 .26378 L
.8912 .26128 L
F
.95119 .26128 m
.95119 .26378 L
.95369 .26378 L
.95369 .26128 L
F
.97119 .26128 m
.97119 .26378 L
.97369 .26378 L
.97369 .26128 L
F
.38126 .26378 m
.38126 .26628 L
.38376 .26628 L
.38376 .26378 L
F
.8862 .26378 m
.8862 .26628 L
.8887 .26628 L
.8887 .26378 L
F
.94869 .26378 m
.94869 .26628 L
.95119 .26628 L
.95119 .26378 L
F
.97119 .26378 m
.97119 .26628 L
.97369 .26628 L
.97369 .26378 L
F
.37877 .26628 m
.37877 .26878 L
.38126 .26878 L
.38126 .26628 L
F
.8837 .26628 m
.8837 .26878 L
.8862 .26878 L
.8862 .26628 L
F
.94619 .26628 m
.94619 .26878 L
.94869 .26878 L
.94869 .26628 L
F
.97119 .26628 m
.97119 .26878 L
.97369 .26878 L
.97369 .26628 L
F
.37627 .26878 m
.37627 .27128 L
.37877 .27128 L
.37877 .26878 L
F
.8812 .26878 m
.8812 .27128 L
.8837 .27128 L
.8837 .26878 L
F
.94369 .26878 m
.94369 .27128 L
.94619 .27128 L
.94619 .26878 L
F
.97119 .26878 m
.97119 .27128 L
.97369 .27128 L
.97369 .26878 L
F
.37377 .27128 m
.37377 .27378 L
.37627 .27378 L
.37627 .27128 L
F
.8787 .27128 m
.8787 .27378 L
.8812 .27378 L
.8812 .27128 L
F
.94119 .27128 m
.94119 .27378 L
.94369 .27378 L
.94369 .27128 L
F
.97119 .27128 m
.97119 .27378 L
.97369 .27378 L
.97369 .27128 L
F
.37127 .27378 m
.37127 .27628 L
.37377 .27628 L
.37377 .27378 L
F
.8762 .27378 m
.8762 .27628 L
.8787 .27628 L
.8787 .27378 L
F
.9387 .27378 m
.9387 .27628 L
.94119 .27628 L
.94119 .27378 L
F
.97119 .27378 m
.97119 .27628 L
.97369 .27628 L
.97369 .27378 L
F
.36877 .27628 m
.36877 .27878 L
.37127 .27878 L
.37127 .27628 L
F
.8737 .27628 m
.8737 .27878 L
.8762 .27878 L
.8762 .27628 L
F
.9362 .27628 m
.9362 .27878 L
.9387 .27878 L
.9387 .27628 L
F
.97119 .27628 m
.97119 .27878 L
.97369 .27878 L
.97369 .27628 L
F
.36627 .27878 m
.36627 .28128 L
.36877 .28128 L
.36877 .27878 L
F
.8712 .27878 m
.8712 .28128 L
.8737 .28128 L
.8737 .27878 L
F
.9337 .27878 m
.9337 .28128 L
.9362 .28128 L
.9362 .27878 L
F
.97119 .27878 m
.97119 .28128 L
.97369 .28128 L
.97369 .27878 L
F
.36377 .28128 m
.36377 .28378 L
.36627 .28378 L
.36627 .28128 L
F
.8687 .28128 m
.8687 .28378 L
.8712 .28378 L
.8712 .28128 L
F
.9312 .28128 m
.9312 .28378 L
.9337 .28378 L
.9337 .28128 L
F
.97119 .28128 m
.97119 .28378 L
.97369 .28378 L
.97369 .28128 L
F
.36127 .28378 m
.36127 .28628 L
.36377 .28628 L
.36377 .28378 L
F
.8662 .28378 m
.8662 .28628 L
.8687 .28628 L
.8687 .28378 L
F
.9287 .28378 m
.9287 .28628 L
.9312 .28628 L
.9312 .28378 L
F
.97119 .28378 m
.97119 .28628 L
.97369 .28628 L
.97369 .28378 L
F
.35877 .28628 m
.35877 .28878 L
.36127 .28878 L
.36127 .28628 L
F
.8637 .28628 m
.8637 .28878 L
.8662 .28878 L
.8662 .28628 L
F
.9262 .28628 m
.9262 .28878 L
.9287 .28878 L
.9287 .28628 L
F
.97119 .28628 m
.97119 .28878 L
.97369 .28878 L
.97369 .28628 L
F
.35627 .28878 m
.35627 .29128 L
.35877 .29128 L
.35877 .28878 L
F
.8612 .28878 m
.8612 .29128 L
.8637 .29128 L
.8637 .28878 L
F
.9237 .28878 m
.9237 .29128 L
.9262 .29128 L
.9262 .28878 L
F
.97119 .28878 m
.97119 .29128 L
.97369 .29128 L
.97369 .28878 L
F
.35377 .29128 m
.35377 .29378 L
.35627 .29378 L
.35627 .29128 L
F
.85871 .29128 m
.85871 .29378 L
.8612 .29378 L
.8612 .29128 L
F
.9212 .29128 m
.9212 .29378 L
.9237 .29378 L
.9237 .29128 L
F
.97119 .29128 m
.97119 .29378 L
.97369 .29378 L
.97369 .29128 L
F
.35127 .29378 m
.35127 .29628 L
.35377 .29628 L
.35377 .29378 L
F
.85621 .29378 m
.85621 .29628 L
.85871 .29628 L
.85871 .29378 L
F
.9187 .29378 m
.9187 .29628 L
.9212 .29628 L
.9212 .29378 L
F
.97119 .29378 m
.97119 .29628 L
.97369 .29628 L
.97369 .29378 L
F
.34877 .29628 m
.34877 .29878 L
.35127 .29878 L
.35127 .29628 L
F
.85371 .29628 m
.85371 .29878 L
.85621 .29878 L
.85621 .29628 L
F
.9162 .29628 m
.9162 .29878 L
.9187 .29878 L
.9187 .29628 L
F
.97119 .29628 m
.97119 .29878 L
.97369 .29878 L
.97369 .29628 L
F
.34627 .29878 m
.34627 .30127 L
.34877 .30127 L
.34877 .29878 L
F
.85121 .29878 m
.85121 .30127 L
.85371 .30127 L
.85371 .29878 L
F
.9137 .29878 m
.9137 .30127 L
.9162 .30127 L
.9162 .29878 L
F
.97119 .29878 m
.97119 .30127 L
.97369 .30127 L
.97369 .29878 L
F
.34377 .30127 m
.34377 .30377 L
.34627 .30377 L
.34627 .30127 L
F
.84871 .30127 m
.84871 .30377 L
.85121 .30377 L
.85121 .30127 L
F
.9112 .30127 m
.9112 .30377 L
.9137 .30377 L
.9137 .30127 L
F
.97119 .30127 m
.97119 .30377 L
.97369 .30377 L
.97369 .30127 L
F
.21879 .30377 m
.21879 .30627 L
.22128 .30627 L
.22128 .30377 L
F
.22128 .30377 m
.22128 .30627 L
.22378 .30627 L
.22378 .30377 L
F
.22378 .30377 m
.22378 .30627 L
.22628 .30627 L
.22628 .30377 L
F
.22628 .30377 m
.22628 .30627 L
.22878 .30627 L
.22878 .30377 L
F
.22878 .30377 m
.22878 .30627 L
.23128 .30627 L
.23128 .30377 L
F
.23128 .30377 m
.23128 .30627 L
.23378 .30627 L
.23378 .30377 L
F
.23378 .30377 m
.23378 .30627 L
.23628 .30627 L
.23628 .30377 L
F
.23628 .30377 m
.23628 .30627 L
.23878 .30627 L
.23878 .30377 L
F
.23878 .30377 m
.23878 .30627 L
.24128 .30627 L
.24128 .30377 L
F
.24128 .30377 m
.24128 .30627 L
.24378 .30627 L
.24378 .30377 L
F
.24378 .30377 m
.24378 .30627 L
.24628 .30627 L
.24628 .30377 L
F
.24628 .30377 m
.24628 .30627 L
.24878 .30627 L
.24878 .30377 L
F
.24878 .30377 m
.24878 .30627 L
.25128 .30627 L
.25128 .30377 L
F
.25128 .30377 m
.25128 .30627 L
.25378 .30627 L
.25378 .30377 L
F
.25378 .30377 m
.25378 .30627 L
.25628 .30627 L
.25628 .30377 L
F
.25628 .30377 m
.25628 .30627 L
.25878 .30627 L
.25878 .30377 L
F
.25878 .30377 m
.25878 .30627 L
.26128 .30627 L
.26128 .30377 L
F
.26128 .30377 m
.26128 .30627 L
.26378 .30627 L
.26378 .30377 L
F
.26378 .30377 m
.26378 .30627 L
.26628 .30627 L
.26628 .30377 L
F
.26628 .30377 m
.26628 .30627 L
.26878 .30627 L
.26878 .30377 L
F
.26878 .30377 m
.26878 .30627 L
.27128 .30627 L
.27128 .30377 L
F
.27128 .30377 m
.27128 .30627 L
.27378 .30627 L
.27378 .30377 L
F
.27378 .30377 m
.27378 .30627 L
.27628 .30627 L
.27628 .30377 L
F
.27628 .30377 m
.27628 .30627 L
.27878 .30627 L
.27878 .30377 L
F
.02881 .30627 m
.02881 .30877 L
.03131 .30877 L
.03131 .30627 L
F
.02631 .30877 m
.02631 .31127 L
.02881 .31127 L
.02881 .30877 L
F
.02381 .31127 m
.02381 .31377 L
.02631 .31377 L
.02631 .31127 L
F
.72122 .31377 m
.72122 .31627 L
.72372 .31627 L
.72372 .31377 L
F
.84371 .31377 m
.84371 .31627 L
.84621 .31627 L
.84621 .31377 L
F
.72122 .31627 m
.72122 .31877 L
.72372 .31877 L
.72372 .31627 L
F
.84371 .31627 m
.84371 .31877 L
.84621 .31877 L
.84621 .31627 L
F
.77872 .31877 m
.77872 .32127 L
.78121 .32127 L
.78121 .31877 L
F
.83871 .31877 m
.83871 .32127 L
.84121 .32127 L
.84121 .31877 L
F
.77622 .32127 m
.77622 .32377 L
.77872 .32377 L
.77872 .32127 L
F
.83621 .32127 m
.83621 .32377 L
.83871 .32377 L
.83871 .32127 L
F
.77372 .32377 m
.77372 .32627 L
.77622 .32627 L
.77622 .32377 L
F
.83371 .32377 m
.83371 .32627 L
.83621 .32627 L
.83621 .32377 L
F
.77122 .32627 m
.77122 .32877 L
.77372 .32877 L
.77372 .32627 L
F
.83121 .32627 m
.83121 .32877 L
.83371 .32877 L
.83371 .32627 L
F
.76872 .32877 m
.76872 .33127 L
.77122 .33127 L
.77122 .32877 L
F
.82871 .32877 m
.82871 .33127 L
.83121 .33127 L
.83121 .32877 L
F
.76622 .33127 m
.76622 .33377 L
.76872 .33377 L
.76872 .33127 L
F
.82621 .33127 m
.82621 .33377 L
.82871 .33377 L
.82871 .33127 L
F
.76372 .33377 m
.76372 .33627 L
.76622 .33627 L
.76622 .33377 L
F
.82371 .33377 m
.82371 .33627 L
.82621 .33627 L
.82621 .33377 L
F
.76122 .33627 m
.76122 .33877 L
.76372 .33877 L
.76372 .33627 L
F
.82121 .33627 m
.82121 .33877 L
.82371 .33877 L
.82371 .33627 L
F
.75872 .33877 m
.75872 .34127 L
.76122 .34127 L
.76122 .33877 L
F
.81871 .33877 m
.81871 .34127 L
.82121 .34127 L
.82121 .33877 L
F
.75622 .34127 m
.75622 .34377 L
.75872 .34377 L
.75872 .34127 L
F
.81621 .34127 m
.81621 .34377 L
.81871 .34377 L
.81871 .34127 L
F
.75372 .34377 m
.75372 .34627 L
.75622 .34627 L
.75622 .34377 L
F
.81371 .34377 m
.81371 .34627 L
.81621 .34627 L
.81621 .34377 L
F
.75122 .34627 m
.75122 .34877 L
.75372 .34877 L
.75372 .34627 L
F
.81121 .34627 m
.81121 .34877 L
.81371 .34877 L
.81371 .34627 L
F
.74872 .34877 m
.74872 .35127 L
.75122 .35127 L
.75122 .34877 L
F
.80871 .34877 m
.80871 .35127 L
.81121 .35127 L
.81121 .34877 L
F
.74622 .35127 m
.74622 .35377 L
.74872 .35377 L
.74872 .35127 L
F
.80621 .35127 m
.80621 .35377 L
.80871 .35377 L
.80871 .35127 L
F
.74372 .35377 m
.74372 .35627 L
.74622 .35627 L
.74622 .35377 L
F
.80371 .35377 m
.80371 .35627 L
.80621 .35627 L
.80621 .35377 L
F
.74122 .35627 m
.74122 .35877 L
.74372 .35877 L
.74372 .35627 L
F
.80121 .35627 m
.80121 .35877 L
.80371 .35877 L
.80371 .35627 L
F
.73872 .35877 m
.73872 .36127 L
.74122 .36127 L
.74122 .35877 L
F
.79871 .35877 m
.79871 .36127 L
.80121 .36127 L
.80121 .35877 L
F
.73622 .36127 m
.73622 .36377 L
.73872 .36377 L
.73872 .36127 L
F
.79621 .36127 m
.79621 .36377 L
.79871 .36377 L
.79871 .36127 L
F
.73372 .36377 m
.73372 .36627 L
.73622 .36627 L
.73622 .36377 L
F
.79371 .36377 m
.79371 .36627 L
.79621 .36627 L
.79621 .36377 L
F
.73122 .36627 m
.73122 .36877 L
.73372 .36877 L
.73372 .36627 L
F
.79121 .36627 m
.79121 .36877 L
.79371 .36877 L
.79371 .36627 L
F
.72872 .36877 m
.72872 .37127 L
.73122 .37127 L
.73122 .36877 L
F
.78871 .36877 m
.78871 .37127 L
.79121 .37127 L
.79121 .36877 L
F
.72622 .37127 m
.72622 .37377 L
.72872 .37377 L
.72872 .37127 L
F
.78621 .37127 m
.78621 .37377 L
.78871 .37377 L
.78871 .37127 L
F
.72372 .37377 m
.72372 .37627 L
.72622 .37627 L
.72622 .37377 L
F
.78371 .37377 m
.78371 .37627 L
.78621 .37627 L
.78621 .37377 L
F
.21129 .37627 m
.21129 .37877 L
.21379 .37877 L
.21379 .37627 L
F
.72122 .37627 m
.72122 .37877 L
.72372 .37877 L
.72372 .37627 L
F
.77872 .37627 m
.77872 .37877 L
.78121 .37877 L
.78121 .37627 L
F
.83871 .37627 m
.83871 .37877 L
.84121 .37877 L
.84121 .37627 L
F
.20879 .37877 m
.20879 .38126 L
.21129 .38126 L
.21129 .37877 L
F
.72122 .37877 m
.72122 .38126 L
.72372 .38126 L
.72372 .37877 L
F
.77622 .37877 m
.77622 .38126 L
.77872 .38126 L
.77872 .37877 L
F
.83621 .37877 m
.83621 .38126 L
.83871 .38126 L
.83871 .37877 L
F
.20629 .38126 m
.20629 .38376 L
.20879 .38376 L
.20879 .38126 L
F
.72122 .38126 m
.72122 .38376 L
.72372 .38376 L
.72372 .38126 L
F
.77372 .38126 m
.77372 .38376 L
.77622 .38376 L
.77622 .38126 L
F
.83371 .38126 m
.83371 .38376 L
.83621 .38376 L
.83621 .38126 L
F
.20379 .38376 m
.20379 .38626 L
.20629 .38626 L
.20629 .38376 L
F
.72122 .38376 m
.72122 .38626 L
.72372 .38626 L
.72372 .38376 L
F
.77122 .38376 m
.77122 .38626 L
.77372 .38626 L
.77372 .38376 L
F
.83121 .38376 m
.83121 .38626 L
.83371 .38626 L
.83371 .38376 L
F
.20129 .38626 m
.20129 .38876 L
.20379 .38876 L
.20379 .38626 L
F
.72122 .38626 m
.72122 .38876 L
.72372 .38876 L
.72372 .38626 L
F
.76872 .38626 m
.76872 .38876 L
.77122 .38876 L
.77122 .38626 L
F
.82871 .38626 m
.82871 .38876 L
.83121 .38876 L
.83121 .38626 L
F
.19879 .38876 m
.19879 .39126 L
.20129 .39126 L
.20129 .38876 L
F
.72122 .38876 m
.72122 .39126 L
.72372 .39126 L
.72372 .38876 L
F
.76622 .38876 m
.76622 .39126 L
.76872 .39126 L
.76872 .38876 L
F
.82621 .38876 m
.82621 .39126 L
.82871 .39126 L
.82871 .38876 L
F
.19629 .39126 m
.19629 .39376 L
.19879 .39376 L
.19879 .39126 L
F
.72122 .39126 m
.72122 .39376 L
.72372 .39376 L
.72372 .39126 L
F
.76372 .39126 m
.76372 .39376 L
.76622 .39376 L
.76622 .39126 L
F
.82371 .39126 m
.82371 .39376 L
.82621 .39376 L
.82621 .39126 L
F
.19379 .39376 m
.19379 .39626 L
.19629 .39626 L
.19629 .39376 L
F
.72122 .39376 m
.72122 .39626 L
.72372 .39626 L
.72372 .39376 L
F
.76122 .39376 m
.76122 .39626 L
.76372 .39626 L
.76372 .39376 L
F
.82121 .39376 m
.82121 .39626 L
.82371 .39626 L
.82371 .39376 L
F
.19129 .39626 m
.19129 .39876 L
.19379 .39876 L
.19379 .39626 L
F
.72122 .39626 m
.72122 .39876 L
.72372 .39876 L
.72372 .39626 L
F
.75872 .39626 m
.75872 .39876 L
.76122 .39876 L
.76122 .39626 L
F
.81871 .39626 m
.81871 .39876 L
.82121 .39876 L
.82121 .39626 L
F
.18879 .39876 m
.18879 .40126 L
.19129 .40126 L
.19129 .39876 L
F
.72122 .39876 m
.72122 .40126 L
.72372 .40126 L
.72372 .39876 L
F
.75622 .39876 m
.75622 .40126 L
.75872 .40126 L
.75872 .39876 L
F
.81621 .39876 m
.81621 .40126 L
.81871 .40126 L
.81871 .39876 L
F
.18629 .40126 m
.18629 .40376 L
.18879 .40376 L
.18879 .40126 L
F
.72122 .40126 m
.72122 .40376 L
.72372 .40376 L
.72372 .40126 L
F
.75372 .40126 m
.75372 .40376 L
.75622 .40376 L
.75622 .40126 L
F
.81371 .40126 m
.81371 .40376 L
.81621 .40376 L
.81621 .40126 L
F
.18379 .40376 m
.18379 .40626 L
.18629 .40626 L
.18629 .40376 L
F
.72122 .40376 m
.72122 .40626 L
.72372 .40626 L
.72372 .40376 L
F
.75122 .40376 m
.75122 .40626 L
.75372 .40626 L
.75372 .40376 L
F
.81121 .40376 m
.81121 .40626 L
.81371 .40626 L
.81371 .40376 L
F
.18129 .40626 m
.18129 .40876 L
.18379 .40876 L
.18379 .40626 L
F
.72122 .40626 m
.72122 .40876 L
.72372 .40876 L
.72372 .40626 L
F
.74872 .40626 m
.74872 .40876 L
.75122 .40876 L
.75122 .40626 L
F
.80871 .40626 m
.80871 .40876 L
.81121 .40876 L
.81121 .40626 L
F
.17879 .40876 m
.17879 .41126 L
.18129 .41126 L
.18129 .40876 L
F
.72122 .40876 m
.72122 .41126 L
.72372 .41126 L
.72372 .40876 L
F
.74622 .40876 m
.74622 .41126 L
.74872 .41126 L
.74872 .40876 L
F
.80621 .40876 m
.80621 .41126 L
.80871 .41126 L
.80871 .40876 L
F
.17629 .41126 m
.17629 .41376 L
.17879 .41376 L
.17879 .41126 L
F
.72122 .41126 m
.72122 .41376 L
.72372 .41376 L
.72372 .41126 L
F
.74372 .41126 m
.74372 .41376 L
.74622 .41376 L
.74622 .41126 L
F
.80371 .41126 m
.80371 .41376 L
.80621 .41376 L
.80621 .41126 L
F
.17379 .41376 m
.17379 .41626 L
.17629 .41626 L
.17629 .41376 L
F
.72122 .41376 m
.72122 .41626 L
.72372 .41626 L
.72372 .41376 L
F
.74122 .41376 m
.74122 .41626 L
.74372 .41626 L
.74372 .41376 L
F
.80121 .41376 m
.80121 .41626 L
.80371 .41626 L
.80371 .41376 L
F
.17129 .41626 m
.17129 .41876 L
.17379 .41876 L
.17379 .41626 L
F
.72122 .41626 m
.72122 .41876 L
.72372 .41876 L
.72372 .41626 L
F
.73872 .41626 m
.73872 .41876 L
.74122 .41876 L
.74122 .41626 L
F
.79871 .41626 m
.79871 .41876 L
.80121 .41876 L
.80121 .41626 L
F
.16879 .41876 m
.16879 .42126 L
.17129 .42126 L
.17129 .41876 L
F
.72122 .41876 m
.72122 .42126 L
.72372 .42126 L
.72372 .41876 L
F
.73622 .41876 m
.73622 .42126 L
.73872 .42126 L
.73872 .41876 L
F
.79621 .41876 m
.79621 .42126 L
.79871 .42126 L
.79871 .41876 L
F
.16629 .42126 m
.16629 .42376 L
.16879 .42376 L
.16879 .42126 L
F
.72122 .42126 m
.72122 .42376 L
.72372 .42376 L
.72372 .42126 L
F
.73372 .42126 m
.73372 .42376 L
.73622 .42376 L
.73622 .42126 L
F
.79371 .42126 m
.79371 .42376 L
.79621 .42376 L
.79621 .42126 L
F
.16379 .42376 m
.16379 .42626 L
.16629 .42626 L
.16629 .42376 L
F
.72122 .42376 m
.72122 .42626 L
.72372 .42626 L
.72372 .42376 L
F
.73122 .42376 m
.73122 .42626 L
.73372 .42626 L
.73372 .42376 L
F
.79121 .42376 m
.79121 .42626 L
.79371 .42626 L
.79371 .42376 L
F
.16129 .42626 m
.16129 .42876 L
.16379 .42876 L
.16379 .42626 L
F
.72122 .42626 m
.72122 .42876 L
.72372 .42876 L
.72372 .42626 L
F
.72872 .42626 m
.72872 .42876 L
.73122 .42876 L
.73122 .42626 L
F
.78871 .42626 m
.78871 .42876 L
.79121 .42876 L
.79121 .42626 L
F
.15879 .42876 m
.15879 .43126 L
.16129 .43126 L
.16129 .42876 L
F
.72122 .42876 m
.72122 .43126 L
.72372 .43126 L
.72372 .42876 L
F
.72622 .42876 m
.72622 .43126 L
.72872 .43126 L
.72872 .42876 L
F
.78621 .42876 m
.78621 .43126 L
.78871 .43126 L
.78871 .42876 L
F
.15629 .43126 m
.15629 .43376 L
.15879 .43376 L
.15879 .43126 L
F
.72122 .43126 m
.72122 .43376 L
.72372 .43376 L
.72372 .43126 L
F
.72372 .43126 m
.72372 .43376 L
.72622 .43376 L
.72622 .43126 L
F
.78371 .43126 m
.78371 .43376 L
.78621 .43376 L
.78621 .43126 L
F
.02881 .43376 m
.02881 .43626 L
.03131 .43626 L
.03131 .43376 L
F
.65623 .43376 m
.65623 .43626 L
.65873 .43626 L
.65873 .43376 L
F
.71622 .43376 m
.71622 .43626 L
.71872 .43626 L
.71872 .43376 L
F
.72122 .43376 m
.72122 .43626 L
.72372 .43626 L
.72372 .43376 L
F
.78121 .43376 m
.78121 .43626 L
.78371 .43626 L
.78371 .43376 L
F
.65623 .43626 m
.65623 .43876 L
.65873 .43876 L
.65873 .43626 L
F
.71372 .43626 m
.71372 .43876 L
.71622 .43876 L
.71622 .43626 L
F
.72122 .43626 m
.72122 .43876 L
.72372 .43876 L
.72372 .43626 L
F
.77872 .43626 m
.77872 .43876 L
.78121 .43876 L
.78121 .43626 L
F
.65623 .43876 m
.65623 .44126 L
.65873 .44126 L
.65873 .43876 L
F
.71122 .43876 m
.71122 .44126 L
.71372 .44126 L
.71372 .43876 L
F
.72122 .43876 m
.72122 .44126 L
.72372 .44126 L
.72372 .43876 L
F
.77622 .43876 m
.77622 .44126 L
.77872 .44126 L
.77872 .43876 L
F
.65623 .44126 m
.65623 .44376 L
.65873 .44376 L
.65873 .44126 L
F
.70872 .44126 m
.70872 .44376 L
.71122 .44376 L
.71122 .44126 L
F
.72122 .44126 m
.72122 .44376 L
.72372 .44376 L
.72372 .44126 L
F
.77372 .44126 m
.77372 .44376 L
.77622 .44376 L
.77622 .44126 L
F
.65623 .44376 m
.65623 .44626 L
.65873 .44626 L
.65873 .44376 L
F
.70622 .44376 m
.70622 .44626 L
.70872 .44626 L
.70872 .44376 L
F
.72122 .44376 m
.72122 .44626 L
.72372 .44626 L
.72372 .44376 L
F
.77122 .44376 m
.77122 .44626 L
.77372 .44626 L
.77372 .44376 L
F
.65623 .44626 m
.65623 .44876 L
.65873 .44876 L
.65873 .44626 L
F
.70372 .44626 m
.70372 .44876 L
.70622 .44876 L
.70622 .44626 L
F
.72122 .44626 m
.72122 .44876 L
.72372 .44876 L
.72372 .44626 L
F
.76872 .44626 m
.76872 .44876 L
.77122 .44876 L
.77122 .44626 L
F
.65623 .44876 m
.65623 .45126 L
.65873 .45126 L
.65873 .44876 L
F
.70122 .44876 m
.70122 .45126 L
.70372 .45126 L
.70372 .44876 L
F
.72122 .44876 m
.72122 .45126 L
.72372 .45126 L
.72372 .44876 L
F
.76622 .44876 m
.76622 .45126 L
.76872 .45126 L
.76872 .44876 L
F
.65623 .45126 m
.65623 .45376 L
.65873 .45376 L
.65873 .45126 L
F
.69873 .45126 m
.69873 .45376 L
.70122 .45376 L
.70122 .45126 L
F
.72122 .45126 m
.72122 .45376 L
.72372 .45376 L
.72372 .45126 L
F
.76372 .45126 m
.76372 .45376 L
.76622 .45376 L
.76622 .45126 L
F
.65623 .45376 m
.65623 .45626 L
.65873 .45626 L
.65873 .45376 L
F
.69623 .45376 m
.69623 .45626 L
.69873 .45626 L
.69873 .45376 L
F
.72122 .45376 m
.72122 .45626 L
.72372 .45626 L
.72372 .45376 L
F
.76122 .45376 m
.76122 .45626 L
.76372 .45626 L
.76372 .45376 L
F
.65623 .45626 m
.65623 .45876 L
.65873 .45876 L
.65873 .45626 L
F
.69373 .45626 m
.69373 .45876 L
.69623 .45876 L
.69623 .45626 L
F
.72122 .45626 m
.72122 .45876 L
.72372 .45876 L
.72372 .45626 L
F
.75872 .45626 m
.75872 .45876 L
.76122 .45876 L
.76122 .45626 L
F
.65623 .45876 m
.65623 .46125 L
.65873 .46125 L
.65873 .45876 L
F
.69123 .45876 m
.69123 .46125 L
.69373 .46125 L
.69373 .45876 L
F
.72122 .45876 m
.72122 .46125 L
.72372 .46125 L
.72372 .45876 L
F
.75622 .45876 m
.75622 .46125 L
.75872 .46125 L
.75872 .45876 L
F
.65623 .46125 m
.65623 .46375 L
.65873 .46375 L
.65873 .46125 L
F
.68873 .46125 m
.68873 .46375 L
.69123 .46375 L
.69123 .46125 L
F
.72122 .46125 m
.72122 .46375 L
.72372 .46375 L
.72372 .46125 L
F
.75372 .46125 m
.75372 .46375 L
.75622 .46375 L
.75622 .46125 L
F
.65623 .46375 m
.65623 .46625 L
.65873 .46625 L
.65873 .46375 L
F
.68623 .46375 m
.68623 .46625 L
.68873 .46625 L
.68873 .46375 L
F
.72122 .46375 m
.72122 .46625 L
.72372 .46625 L
.72372 .46375 L
F
.75122 .46375 m
.75122 .46625 L
.75372 .46625 L
.75372 .46375 L
F
.65623 .46625 m
.65623 .46875 L
.65873 .46875 L
.65873 .46625 L
F
.68373 .46625 m
.68373 .46875 L
.68623 .46875 L
.68623 .46625 L
F
.72122 .46625 m
.72122 .46875 L
.72372 .46875 L
.72372 .46625 L
F
.74872 .46625 m
.74872 .46875 L
.75122 .46875 L
.75122 .46625 L
F
.65623 .46875 m
.65623 .47125 L
.65873 .47125 L
.65873 .46875 L
F
.68123 .46875 m
.68123 .47125 L
.68373 .47125 L
.68373 .46875 L
F
.72122 .46875 m
.72122 .47125 L
.72372 .47125 L
.72372 .46875 L
F
.74622 .46875 m
.74622 .47125 L
.74872 .47125 L
.74872 .46875 L
F
.65623 .47125 m
.65623 .47375 L
.65873 .47375 L
.65873 .47125 L
F
.67873 .47125 m
.67873 .47375 L
.68123 .47375 L
.68123 .47125 L
F
.72122 .47125 m
.72122 .47375 L
.72372 .47375 L
.72372 .47125 L
F
.74372 .47125 m
.74372 .47375 L
.74622 .47375 L
.74622 .47125 L
F
.65623 .47375 m
.65623 .47625 L
.65873 .47625 L
.65873 .47375 L
F
.67623 .47375 m
.67623 .47625 L
.67873 .47625 L
.67873 .47375 L
F
.72122 .47375 m
.72122 .47625 L
.72372 .47625 L
.72372 .47375 L
F
.74122 .47375 m
.74122 .47625 L
.74372 .47625 L
.74372 .47375 L
F
.65623 .47625 m
.65623 .47875 L
.65873 .47875 L
.65873 .47625 L
F
.67373 .47625 m
.67373 .47875 L
.67623 .47875 L
.67623 .47625 L
F
.72122 .47625 m
.72122 .47875 L
.72372 .47875 L
.72372 .47625 L
F
.73872 .47625 m
.73872 .47875 L
.74122 .47875 L
.74122 .47625 L
F
.65623 .47875 m
.65623 .48125 L
.65873 .48125 L
.65873 .47875 L
F
.67123 .47875 m
.67123 .48125 L
.67373 .48125 L
.67373 .47875 L
F
.72122 .47875 m
.72122 .48125 L
.72372 .48125 L
.72372 .47875 L
F
.73622 .47875 m
.73622 .48125 L
.73872 .48125 L
.73872 .47875 L
F
.65623 .48125 m
.65623 .48375 L
.65873 .48375 L
.65873 .48125 L
F
.66873 .48125 m
.66873 .48375 L
.67123 .48375 L
.67123 .48125 L
F
.72122 .48125 m
.72122 .48375 L
.72372 .48375 L
.72372 .48125 L
F
.73372 .48125 m
.73372 .48375 L
.73622 .48375 L
.73622 .48125 L
F
.65623 .48375 m
.65623 .48625 L
.65873 .48625 L
.65873 .48375 L
F
.66623 .48375 m
.66623 .48625 L
.66873 .48625 L
.66873 .48375 L
F
.72122 .48375 m
.72122 .48625 L
.72372 .48625 L
.72372 .48375 L
F
.73122 .48375 m
.73122 .48625 L
.73372 .48625 L
.73372 .48375 L
F
.65623 .48625 m
.65623 .48875 L
.65873 .48875 L
.65873 .48625 L
F
.66373 .48625 m
.66373 .48875 L
.66623 .48875 L
.66623 .48625 L
F
.72122 .48625 m
.72122 .48875 L
.72372 .48875 L
.72372 .48625 L
F
.72872 .48625 m
.72872 .48875 L
.73122 .48875 L
.73122 .48625 L
F
.65623 .48875 m
.65623 .49125 L
.65873 .49125 L
.65873 .48875 L
F
.66123 .48875 m
.66123 .49125 L
.66373 .49125 L
.66373 .48875 L
F
.72122 .48875 m
.72122 .49125 L
.72372 .49125 L
.72372 .48875 L
F
.72622 .48875 m
.72622 .49125 L
.72872 .49125 L
.72872 .48875 L
F
.65623 .49125 m
.65623 .49375 L
.65873 .49375 L
.65873 .49125 L
F
.65873 .49125 m
.65873 .49375 L
.66123 .49375 L
.66123 .49125 L
F
.72122 .49125 m
.72122 .49375 L
.72372 .49375 L
.72372 .49125 L
F
.72372 .49125 m
.72372 .49375 L
.72622 .49375 L
.72622 .49125 L
F
.65873 .49375 m
.65873 .49625 L
.66123 .49625 L
.66123 .49375 L
F
.66123 .49375 m
.66123 .49625 L
.66373 .49625 L
.66373 .49375 L
F
.66373 .49375 m
.66373 .49625 L
.66623 .49625 L
.66623 .49375 L
F
.66623 .49375 m
.66623 .49625 L
.66873 .49625 L
.66873 .49375 L
F
.66873 .49375 m
.66873 .49625 L
.67123 .49625 L
.67123 .49375 L
F
.67123 .49375 m
.67123 .49625 L
.67373 .49625 L
.67373 .49375 L
F
.67373 .49375 m
.67373 .49625 L
.67623 .49625 L
.67623 .49375 L
F
.67623 .49375 m
.67623 .49625 L
.67873 .49625 L
.67873 .49375 L
F
.67873 .49375 m
.67873 .49625 L
.68123 .49625 L
.68123 .49375 L
F
.68123 .49375 m
.68123 .49625 L
.68373 .49625 L
.68373 .49375 L
F
.68373 .49375 m
.68373 .49625 L
.68623 .49625 L
.68623 .49375 L
F
.68623 .49375 m
.68623 .49625 L
.68873 .49625 L
.68873 .49375 L
F
.68873 .49375 m
.68873 .49625 L
.69123 .49625 L
.69123 .49375 L
F
.69123 .49375 m
.69123 .49625 L
.69373 .49625 L
.69373 .49375 L
F
.69373 .49375 m
.69373 .49625 L
.69623 .49625 L
.69623 .49375 L
F
.69623 .49375 m
.69623 .49625 L
.69873 .49625 L
.69873 .49375 L
F
.69873 .49375 m
.69873 .49625 L
.70122 .49625 L
.70122 .49375 L
F
.70122 .49375 m
.70122 .49625 L
.70372 .49625 L
.70372 .49375 L
F
.70372 .49375 m
.70372 .49625 L
.70622 .49625 L
.70622 .49375 L
F
.70622 .49375 m
.70622 .49625 L
.70872 .49625 L
.70872 .49375 L
F
.70872 .49375 m
.70872 .49625 L
.71122 .49625 L
.71122 .49375 L
F
.71122 .49375 m
.71122 .49625 L
.71372 .49625 L
.71372 .49375 L
F
.71372 .49375 m
.71372 .49625 L
.71622 .49625 L
.71622 .49375 L
F
.71622 .49375 m
.71622 .49625 L
.71872 .49625 L
.71872 .49375 L
F
.71872 .49375 m
.71872 .49625 L
.72122 .49625 L
.72122 .49375 L
F
.53125 .49625 m
.53125 .49875 L
.53375 .49875 L
.53375 .49625 L
F
.59124 .49625 m
.59124 .49875 L
.59374 .49875 L
.59374 .49625 L
F
.65373 .49625 m
.65373 .49875 L
.65623 .49875 L
.65623 .49625 L
F
.65623 .49625 m
.65623 .49875 L
.65873 .49875 L
.65873 .49625 L
F
.71622 .49625 m
.71622 .49875 L
.71872 .49875 L
.71872 .49625 L
F
.53125 .49875 m
.53125 .50125 L
.53375 .50125 L
.53375 .49875 L
F
.58874 .49875 m
.58874 .50125 L
.59124 .50125 L
.59124 .49875 L
F
.65123 .49875 m
.65123 .50125 L
.65373 .50125 L
.65373 .49875 L
F
.65623 .49875 m
.65623 .50125 L
.65873 .50125 L
.65873 .49875 L
F
.71372 .49875 m
.71372 .50125 L
.71622 .50125 L
.71622 .49875 L
F
.53125 .50125 m
.53125 .50375 L
.53375 .50375 L
.53375 .50125 L
F
.58624 .50125 m
.58624 .50375 L
.58874 .50375 L
.58874 .50125 L
F
.64873 .50125 m
.64873 .50375 L
.65123 .50375 L
.65123 .50125 L
F
.65623 .50125 m
.65623 .50375 L
.65873 .50375 L
.65873 .50125 L
F
.71122 .50125 m
.71122 .50375 L
.71372 .50375 L
.71372 .50125 L
F
.53125 .50375 m
.53125 .50625 L
.53375 .50625 L
.53375 .50375 L
F
.58374 .50375 m
.58374 .50625 L
.58624 .50625 L
.58624 .50375 L
F
.64623 .50375 m
.64623 .50625 L
.64873 .50625 L
.64873 .50375 L
F
.65623 .50375 m
.65623 .50625 L
.65873 .50625 L
.65873 .50375 L
F
.70872 .50375 m
.70872 .50625 L
.71122 .50625 L
.71122 .50375 L
F
.53125 .50625 m
.53125 .50875 L
.53375 .50875 L
.53375 .50625 L
F
.58124 .50625 m
.58124 .50875 L
.58374 .50875 L
.58374 .50625 L
F
.64373 .50625 m
.64373 .50875 L
.64623 .50875 L
.64623 .50625 L
F
.65623 .50625 m
.65623 .50875 L
.65873 .50875 L
.65873 .50625 L
F
.70622 .50625 m
.70622 .50875 L
.70872 .50875 L
.70872 .50625 L
F
.53125 .50875 m
.53125 .51125 L
.53375 .51125 L
.53375 .50875 L
F
.57874 .50875 m
.57874 .51125 L
.58124 .51125 L
.58124 .50875 L
F
.64123 .50875 m
.64123 .51125 L
.64373 .51125 L
.64373 .50875 L
F
.65623 .50875 m
.65623 .51125 L
.65873 .51125 L
.65873 .50875 L
F
.70372 .50875 m
.70372 .51125 L
.70622 .51125 L
.70622 .50875 L
F
.53125 .51125 m
.53125 .51375 L
.53375 .51375 L
.53375 .51125 L
F
.57624 .51125 m
.57624 .51375 L
.57874 .51375 L
.57874 .51125 L
F
.63873 .51125 m
.63873 .51375 L
.64123 .51375 L
.64123 .51125 L
F
.65623 .51125 m
.65623 .51375 L
.65873 .51375 L
.65873 .51125 L
F
.70122 .51125 m
.70122 .51375 L
.70372 .51375 L
.70372 .51125 L
F
.53125 .51375 m
.53125 .51625 L
.53375 .51625 L
.53375 .51375 L
F
.57374 .51375 m
.57374 .51625 L
.57624 .51625 L
.57624 .51375 L
F
.63623 .51375 m
.63623 .51625 L
.63873 .51625 L
.63873 .51375 L
F
.65623 .51375 m
.65623 .51625 L
.65873 .51625 L
.65873 .51375 L
F
.69873 .51375 m
.69873 .51625 L
.70122 .51625 L
.70122 .51375 L
F
.53125 .51625 m
.53125 .51875 L
.53375 .51875 L
.53375 .51625 L
F
.57124 .51625 m
.57124 .51875 L
.57374 .51875 L
.57374 .51625 L
F
.63373 .51625 m
.63373 .51875 L
.63623 .51875 L
.63623 .51625 L
F
.65623 .51625 m
.65623 .51875 L
.65873 .51875 L
.65873 .51625 L
F
.69623 .51625 m
.69623 .51875 L
.69873 .51875 L
.69873 .51625 L
F
.53125 .51875 m
.53125 .52125 L
.53375 .52125 L
.53375 .51875 L
F
.63123 .51875 m
.63123 .52125 L
.63373 .52125 L
.63373 .51875 L
F
.65623 .51875 m
.65623 .52125 L
.65873 .52125 L
.65873 .51875 L
F
.69373 .51875 m
.69373 .52125 L
.69623 .52125 L
.69623 .51875 L
F
.56624 .52125 m
.56624 .52375 L
.56874 .52375 L
.56874 .52125 L
F
.62873 .52125 m
.62873 .52375 L
.63123 .52375 L
.63123 .52125 L
F
.65623 .52125 m
.65623 .52375 L
.65873 .52375 L
.65873 .52125 L
F
.69123 .52125 m
.69123 .52375 L
.69373 .52375 L
.69373 .52125 L
F
.53125 .52375 m
.53125 .52625 L
.53375 .52625 L
.53375 .52375 L
F
.56374 .52375 m
.56374 .52625 L
.56624 .52625 L
.56624 .52375 L
F
.62623 .52375 m
.62623 .52625 L
.62873 .52625 L
.62873 .52375 L
F
.65623 .52375 m
.65623 .52625 L
.65873 .52625 L
.65873 .52375 L
F
.68873 .52375 m
.68873 .52625 L
.69123 .52625 L
.69123 .52375 L
F
.53125 .52625 m
.53125 .52875 L
.53375 .52875 L
.53375 .52625 L
F
.56124 .52625 m
.56124 .52875 L
.56374 .52875 L
.56374 .52625 L
F
.62373 .52625 m
.62373 .52875 L
.62623 .52875 L
.62623 .52625 L
F
.65623 .52625 m
.65623 .52875 L
.65873 .52875 L
.65873 .52625 L
F
.68623 .52625 m
.68623 .52875 L
.68873 .52875 L
.68873 .52625 L
F
.53125 .52875 m
.53125 .53125 L
.53375 .53125 L
.53375 .52875 L
F
.55874 .52875 m
.55874 .53125 L
.56124 .53125 L
.56124 .52875 L
F
.62123 .52875 m
.62123 .53125 L
.62373 .53125 L
.62373 .52875 L
F
.65623 .52875 m
.65623 .53125 L
.65873 .53125 L
.65873 .52875 L
F
.68373 .52875 m
.68373 .53125 L
.68623 .53125 L
.68623 .52875 L
F
.53125 .53125 m
.53125 .53375 L
.53375 .53375 L
.53375 .53125 L
F
.55624 .53125 m
.55624 .53375 L
.55874 .53375 L
.55874 .53125 L
F
.61874 .53125 m
.61874 .53375 L
.62123 .53375 L
.62123 .53125 L
F
.65623 .53125 m
.65623 .53375 L
.65873 .53375 L
.65873 .53125 L
F
.68123 .53125 m
.68123 .53375 L
.68373 .53375 L
.68373 .53125 L
F
.53125 .53375 m
.53125 .53625 L
.53375 .53625 L
.53375 .53375 L
F
.55374 .53375 m
.55374 .53625 L
.55624 .53625 L
.55624 .53375 L
F
.61624 .53375 m
.61624 .53625 L
.61874 .53625 L
.61874 .53375 L
F
.65623 .53375 m
.65623 .53625 L
.65873 .53625 L
.65873 .53375 L
F
.67873 .53375 m
.67873 .53625 L
.68123 .53625 L
.68123 .53375 L
F
.53125 .53625 m
.53125 .53875 L
.53375 .53875 L
.53375 .53625 L
F
.55124 .53625 m
.55124 .53875 L
.55374 .53875 L
.55374 .53625 L
F
.61374 .53625 m
.61374 .53875 L
.61624 .53875 L
.61624 .53625 L
F
.65623 .53625 m
.65623 .53875 L
.65873 .53875 L
.65873 .53625 L
F
.67623 .53625 m
.67623 .53875 L
.67873 .53875 L
.67873 .53625 L
F
.53125 .53875 m
.53125 .54124 L
.53375 .54124 L
.53375 .53875 L
F
.54874 .53875 m
.54874 .54124 L
.55124 .54124 L
.55124 .53875 L
F
.61124 .53875 m
.61124 .54124 L
.61374 .54124 L
.61374 .53875 L
F
.65623 .53875 m
.65623 .54124 L
.65873 .54124 L
.65873 .53875 L
F
.67373 .53875 m
.67373 .54124 L
.67623 .54124 L
.67623 .53875 L
F
.53125 .54124 m
.53125 .54374 L
.53375 .54374 L
.53375 .54124 L
F
.54624 .54124 m
.54624 .54374 L
.54874 .54374 L
.54874 .54124 L
F
.60874 .54124 m
.60874 .54374 L
.61124 .54374 L
.61124 .54124 L
F
.65623 .54124 m
.65623 .54374 L
.65873 .54374 L
.65873 .54124 L
F
.67123 .54124 m
.67123 .54374 L
.67373 .54374 L
.67373 .54124 L
F
.53125 .54374 m
.53125 .54624 L
.53375 .54624 L
.53375 .54374 L
F
.54374 .54374 m
.54374 .54624 L
.54624 .54624 L
.54624 .54374 L
F
.60624 .54374 m
.60624 .54624 L
.60874 .54624 L
.60874 .54374 L
F
.65623 .54374 m
.65623 .54624 L
.65873 .54624 L
.65873 .54374 L
F
.66873 .54374 m
.66873 .54624 L
.67123 .54624 L
.67123 .54374 L
F
.53125 .54624 m
.53125 .54874 L
.53375 .54874 L
.53375 .54624 L
F
.54124 .54624 m
.54124 .54874 L
.54374 .54874 L
.54374 .54624 L
F
.60374 .54624 m
.60374 .54874 L
.60624 .54874 L
.60624 .54624 L
F
.65623 .54624 m
.65623 .54874 L
.65873 .54874 L
.65873 .54624 L
F
.66623 .54624 m
.66623 .54874 L
.66873 .54874 L
.66873 .54624 L
F
.53125 .54874 m
.53125 .55124 L
.53375 .55124 L
.53375 .54874 L
F
.53875 .54874 m
.53875 .55124 L
.54124 .55124 L
.54124 .54874 L
F
.60124 .54874 m
.60124 .55124 L
.60374 .55124 L
.60374 .54874 L
F
.65623 .54874 m
.65623 .55124 L
.65873 .55124 L
.65873 .54874 L
F
.66373 .54874 m
.66373 .55124 L
.66623 .55124 L
.66623 .54874 L
F
.53125 .55124 m
.53125 .55374 L
.53375 .55374 L
.53375 .55124 L
F
.53625 .55124 m
.53625 .55374 L
.53875 .55374 L
.53875 .55124 L
F
.59874 .55124 m
.59874 .55374 L
.60124 .55374 L
.60124 .55124 L
F
.65623 .55124 m
.65623 .55374 L
.65873 .55374 L
.65873 .55124 L
F
.66123 .55124 m
.66123 .55374 L
.66373 .55374 L
.66373 .55124 L
F
.53125 .55374 m
.53125 .55624 L
.53375 .55624 L
.53375 .55374 L
F
.53375 .55374 m
.53375 .55624 L
.53625 .55624 L
.53625 .55374 L
F
.59624 .55374 m
.59624 .55624 L
.59874 .55624 L
.59874 .55374 L
F
.65623 .55374 m
.65623 .55624 L
.65873 .55624 L
.65873 .55374 L
F
.65873 .55374 m
.65873 .55624 L
.66123 .55624 L
.66123 .55374 L
F
.65123 .55624 m
.65123 .55874 L
.65373 .55874 L
.65373 .55624 L
F
.71372 .55624 m
.71372 .55874 L
.71622 .55874 L
.71622 .55624 L
F
.71872 .55624 m
.71872 .55874 L
.72122 .55874 L
.72122 .55624 L
F
.64873 .55874 m
.64873 .56124 L
.65123 .56124 L
.65123 .55874 L
F
.71122 .55874 m
.71122 .56124 L
.71372 .56124 L
.71372 .55874 L
F
.71872 .55874 m
.71872 .56124 L
.72122 .56124 L
.72122 .55874 L
F
.64623 .56124 m
.64623 .56374 L
.64873 .56374 L
.64873 .56124 L
F
.70872 .56124 m
.70872 .56374 L
.71122 .56374 L
.71122 .56124 L
F
.71872 .56124 m
.71872 .56374 L
.72122 .56374 L
.72122 .56124 L
F
.64373 .56374 m
.64373 .56624 L
.64623 .56624 L
.64623 .56374 L
F
.70622 .56374 m
.70622 .56624 L
.70872 .56624 L
.70872 .56374 L
F
.71872 .56374 m
.71872 .56624 L
.72122 .56624 L
.72122 .56374 L
F
.64123 .56624 m
.64123 .56874 L
.64373 .56874 L
.64373 .56624 L
F
.70372 .56624 m
.70372 .56874 L
.70622 .56874 L
.70622 .56624 L
F
.71872 .56624 m
.71872 .56874 L
.72122 .56874 L
.72122 .56624 L
F
.63873 .56874 m
.63873 .57124 L
.64123 .57124 L
.64123 .56874 L
F
.70122 .56874 m
.70122 .57124 L
.70372 .57124 L
.70372 .56874 L
F
.71872 .56874 m
.71872 .57124 L
.72122 .57124 L
.72122 .56874 L
F
.63623 .57124 m
.63623 .57374 L
.63873 .57374 L
.63873 .57124 L
F
.69873 .57124 m
.69873 .57374 L
.70122 .57374 L
.70122 .57124 L
F
.71872 .57124 m
.71872 .57374 L
.72122 .57374 L
.72122 .57124 L
F
.63373 .57374 m
.63373 .57624 L
.63623 .57624 L
.63623 .57374 L
F
.69623 .57374 m
.69623 .57624 L
.69873 .57624 L
.69873 .57374 L
F
.71872 .57374 m
.71872 .57624 L
.72122 .57624 L
.72122 .57374 L
F
.63123 .57624 m
.63123 .57874 L
.63373 .57874 L
.63373 .57624 L
F
.69373 .57624 m
.69373 .57874 L
.69623 .57874 L
.69623 .57624 L
F
.71872 .57624 m
.71872 .57874 L
.72122 .57874 L
.72122 .57624 L
F
.62873 .57874 m
.62873 .58124 L
.63123 .58124 L
.63123 .57874 L
F
.69123 .57874 m
.69123 .58124 L
.69373 .58124 L
.69373 .57874 L
F
.71872 .57874 m
.71872 .58124 L
.72122 .58124 L
.72122 .57874 L
F
.62623 .58124 m
.62623 .58374 L
.62873 .58374 L
.62873 .58124 L
F
.68873 .58124 m
.68873 .58374 L
.69123 .58374 L
.69123 .58124 L
F
.71872 .58124 m
.71872 .58374 L
.72122 .58374 L
.72122 .58124 L
F
.62373 .58374 m
.62373 .58624 L
.62623 .58624 L
.62623 .58374 L
F
.68623 .58374 m
.68623 .58624 L
.68873 .58624 L
.68873 .58374 L
F
.71872 .58374 m
.71872 .58624 L
.72122 .58624 L
.72122 .58374 L
F
.62123 .58624 m
.62123 .58874 L
.62373 .58874 L
.62373 .58624 L
F
.68373 .58624 m
.68373 .58874 L
.68623 .58874 L
.68623 .58624 L
F
.71872 .58624 m
.71872 .58874 L
.72122 .58874 L
.72122 .58624 L
F
.61874 .58874 m
.61874 .59124 L
.62123 .59124 L
.62123 .58874 L
F
.68123 .58874 m
.68123 .59124 L
.68373 .59124 L
.68373 .58874 L
F
.71872 .58874 m
.71872 .59124 L
.72122 .59124 L
.72122 .58874 L
F
.61624 .59124 m
.61624 .59374 L
.61874 .59374 L
.61874 .59124 L
F
.67873 .59124 m
.67873 .59374 L
.68123 .59374 L
.68123 .59124 L
F
.71872 .59124 m
.71872 .59374 L
.72122 .59374 L
.72122 .59124 L
F
.61374 .59374 m
.61374 .59624 L
.61624 .59624 L
.61624 .59374 L
F
.67623 .59374 m
.67623 .59624 L
.67873 .59624 L
.67873 .59374 L
F
.71872 .59374 m
.71872 .59624 L
.72122 .59624 L
.72122 .59374 L
F
.61124 .59624 m
.61124 .59874 L
.61374 .59874 L
.61374 .59624 L
F
.67373 .59624 m
.67373 .59874 L
.67623 .59874 L
.67623 .59624 L
F
.71872 .59624 m
.71872 .59874 L
.72122 .59874 L
.72122 .59624 L
F
.60874 .59874 m
.60874 .60124 L
.61124 .60124 L
.61124 .59874 L
F
.67123 .59874 m
.67123 .60124 L
.67373 .60124 L
.67373 .59874 L
F
.71872 .59874 m
.71872 .60124 L
.72122 .60124 L
.72122 .59874 L
F
.60624 .60124 m
.60624 .60374 L
.60874 .60374 L
.60874 .60124 L
F
.66873 .60124 m
.66873 .60374 L
.67123 .60374 L
.67123 .60124 L
F
.71872 .60124 m
.71872 .60374 L
.72122 .60374 L
.72122 .60124 L
F
.60374 .60374 m
.60374 .60624 L
.60624 .60624 L
.60624 .60374 L
F
.66623 .60374 m
.66623 .60624 L
.66873 .60624 L
.66873 .60374 L
F
.71872 .60374 m
.71872 .60624 L
.72122 .60624 L
.72122 .60374 L
F
.60124 .60624 m
.60124 .60874 L
.60374 .60874 L
.60374 .60624 L
F
.66373 .60624 m
.66373 .60874 L
.66623 .60874 L
.66623 .60624 L
F
.71872 .60624 m
.71872 .60874 L
.72122 .60874 L
.72122 .60624 L
F
.59874 .60874 m
.59874 .61124 L
.60124 .61124 L
.60124 .60874 L
F
.66123 .60874 m
.66123 .61124 L
.66373 .61124 L
.66373 .60874 L
F
.71872 .60874 m
.71872 .61124 L
.72122 .61124 L
.72122 .60874 L
F
.59624 .61124 m
.59624 .61374 L
.59874 .61374 L
.59874 .61124 L
F
.65873 .61124 m
.65873 .61374 L
.66123 .61374 L
.66123 .61124 L
F
.71872 .61124 m
.71872 .61374 L
.72122 .61374 L
.72122 .61124 L
F
.46875 .61374 m
.46875 .61624 L
.47125 .61624 L
.47125 .61374 L
F
.53125 .61374 m
.53125 .61624 L
.53375 .61624 L
.53375 .61374 L
F
.0963 .61624 m
.0963 .61874 L
.0988 .61874 L
.0988 .61624 L
F
.0988 .61624 m
.0988 .61874 L
.1013 .61874 L
.1013 .61624 L
F
.1013 .61624 m
.1013 .61874 L
.1038 .61874 L
.1038 .61624 L
F
.1038 .61624 m
.1038 .61874 L
.1063 .61874 L
.1063 .61624 L
F
.1063 .61624 m
.1063 .61874 L
.1088 .61874 L
.1088 .61624 L
F
.1088 .61624 m
.1088 .61874 L
.1113 .61874 L
.1113 .61624 L
F
.1113 .61624 m
.1113 .61874 L
.1138 .61874 L
.1138 .61624 L
F
.1138 .61624 m
.1138 .61874 L
.1163 .61874 L
.1163 .61624 L
F
.1163 .61624 m
.1163 .61874 L
.1188 .61874 L
.1188 .61624 L
F
.1188 .61624 m
.1188 .61874 L
.1213 .61874 L
.1213 .61624 L
F
.1213 .61624 m
.1213 .61874 L
.1238 .61874 L
.1238 .61624 L
F
.1238 .61624 m
.1238 .61874 L
.1263 .61874 L
.1263 .61624 L
F
.1263 .61624 m
.1263 .61874 L
.1288 .61874 L
.1288 .61624 L
F
.1288 .61624 m
.1288 .61874 L
.1313 .61874 L
.1313 .61624 L
F
.1313 .61624 m
.1313 .61874 L
.1338 .61874 L
.1338 .61624 L
F
.1338 .61624 m
.1338 .61874 L
.1363 .61874 L
.1363 .61624 L
F
.1363 .61624 m
.1363 .61874 L
.1388 .61874 L
.1388 .61624 L
F
.1388 .61624 m
.1388 .61874 L
.14129 .61874 L
.14129 .61624 L
F
.14129 .61624 m
.14129 .61874 L
.14379 .61874 L
.14379 .61624 L
F
.14379 .61624 m
.14379 .61874 L
.14629 .61874 L
.14629 .61624 L
F
.14629 .61624 m
.14629 .61874 L
.14879 .61874 L
.14879 .61624 L
F
.14879 .61624 m
.14879 .61874 L
.15129 .61874 L
.15129 .61624 L
F
.15129 .61624 m
.15129 .61874 L
.15379 .61874 L
.15379 .61624 L
F
.15379 .61624 m
.15379 .61874 L
.15629 .61874 L
.15629 .61624 L
F
.59374 .61624 m
.59374 .61874 L
.59624 .61874 L
.59624 .61624 L
F
.0938 .61874 m
.0938 .62123 L
.0963 .62123 L
.0963 .61874 L
F
.15379 .61874 m
.15379 .62123 L
.15629 .62123 L
.15629 .61874 L
F
.21379 .61874 m
.21379 .62123 L
.21629 .62123 L
.21629 .61874 L
F
.46875 .61874 m
.46875 .62123 L
.47125 .62123 L
.47125 .61874 L
F
.52875 .61874 m
.52875 .62123 L
.53125 .62123 L
.53125 .61874 L
F
.53125 .61874 m
.53125 .62123 L
.53375 .62123 L
.53375 .61874 L
F
.59124 .61874 m
.59124 .62123 L
.59374 .62123 L
.59374 .61874 L
F
.0938 .62123 m
.0938 .62373 L
.0963 .62373 L
.0963 .62123 L
F
.15129 .62123 m
.15129 .62373 L
.15379 .62373 L
.15379 .62123 L
F
.21129 .62123 m
.21129 .62373 L
.21379 .62373 L
.21379 .62123 L
F
.46875 .62123 m
.46875 .62373 L
.47125 .62373 L
.47125 .62123 L
F
.52625 .62123 m
.52625 .62373 L
.52875 .62373 L
.52875 .62123 L
F
.53125 .62123 m
.53125 .62373 L
.53375 .62373 L
.53375 .62123 L
F
.58874 .62123 m
.58874 .62373 L
.59124 .62373 L
.59124 .62123 L
F
.0938 .62373 m
.0938 .62623 L
.0963 .62623 L
.0963 .62373 L
F
.14879 .62373 m
.14879 .62623 L
.15129 .62623 L
.15129 .62373 L
F
.20879 .62373 m
.20879 .62623 L
.21129 .62623 L
.21129 .62373 L
F
.46875 .62373 m
.46875 .62623 L
.47125 .62623 L
.47125 .62373 L
F
.52375 .62373 m
.52375 .62623 L
.52625 .62623 L
.52625 .62373 L
F
.53125 .62373 m
.53125 .62623 L
.53375 .62623 L
.53375 .62373 L
F
.58624 .62373 m
.58624 .62623 L
.58874 .62623 L
.58874 .62373 L
F
.0938 .62623 m
.0938 .62873 L
.0963 .62873 L
.0963 .62623 L
F
.14629 .62623 m
.14629 .62873 L
.14879 .62873 L
.14879 .62623 L
F
.20629 .62623 m
.20629 .62873 L
.20879 .62873 L
.20879 .62623 L
F
.46875 .62623 m
.46875 .62873 L
.47125 .62873 L
.47125 .62623 L
F
.52125 .62623 m
.52125 .62873 L
.52375 .62873 L
.52375 .62623 L
F
.53125 .62623 m
.53125 .62873 L
.53375 .62873 L
.53375 .62623 L
F
.58374 .62623 m
.58374 .62873 L
.58624 .62873 L
.58624 .62623 L
F
.0938 .62873 m
.0938 .63123 L
.0963 .63123 L
.0963 .62873 L
F
.14379 .62873 m
.14379 .63123 L
.14629 .63123 L
.14629 .62873 L
F
.20379 .62873 m
.20379 .63123 L
.20629 .63123 L
.20629 .62873 L
F
.46875 .62873 m
.46875 .63123 L
.47125 .63123 L
.47125 .62873 L
F
.51875 .62873 m
.51875 .63123 L
.52125 .63123 L
.52125 .62873 L
F
.53125 .62873 m
.53125 .63123 L
.53375 .63123 L
.53375 .62873 L
F
.58124 .62873 m
.58124 .63123 L
.58374 .63123 L
.58374 .62873 L
F
.0938 .63123 m
.0938 .63373 L
.0963 .63373 L
.0963 .63123 L
F
.14129 .63123 m
.14129 .63373 L
.14379 .63373 L
.14379 .63123 L
F
.20129 .63123 m
.20129 .63373 L
.20379 .63373 L
.20379 .63123 L
F
.46875 .63123 m
.46875 .63373 L
.47125 .63373 L
.47125 .63123 L
F
.51625 .63123 m
.51625 .63373 L
.51875 .63373 L
.51875 .63123 L
F
.53125 .63123 m
.53125 .63373 L
.53375 .63373 L
.53375 .63123 L
F
.57874 .63123 m
.57874 .63373 L
.58124 .63373 L
.58124 .63123 L
F
.0938 .63373 m
.0938 .63623 L
.0963 .63623 L
.0963 .63373 L
F
.1388 .63373 m
.1388 .63623 L
.14129 .63623 L
.14129 .63373 L
F
.19879 .63373 m
.19879 .63623 L
.20129 .63623 L
.20129 .63373 L
F
.46875 .63373 m
.46875 .63623 L
.47125 .63623 L
.47125 .63373 L
F
.51375 .63373 m
.51375 .63623 L
.51625 .63623 L
.51625 .63373 L
F
.53125 .63373 m
.53125 .63623 L
.53375 .63623 L
.53375 .63373 L
F
.57624 .63373 m
.57624 .63623 L
.57874 .63623 L
.57874 .63373 L
F
.0938 .63623 m
.0938 .63873 L
.0963 .63873 L
.0963 .63623 L
F
.1363 .63623 m
.1363 .63873 L
.1388 .63873 L
.1388 .63623 L
F
.19629 .63623 m
.19629 .63873 L
.19879 .63873 L
.19879 .63623 L
F
.46875 .63623 m
.46875 .63873 L
.47125 .63873 L
.47125 .63623 L
F
.51125 .63623 m
.51125 .63873 L
.51375 .63873 L
.51375 .63623 L
F
.53125 .63623 m
.53125 .63873 L
.53375 .63873 L
.53375 .63623 L
F
.57374 .63623 m
.57374 .63873 L
.57624 .63873 L
.57624 .63623 L
F
.0938 .63873 m
.0938 .64123 L
.0963 .64123 L
.0963 .63873 L
F
.1338 .63873 m
.1338 .64123 L
.1363 .64123 L
.1363 .63873 L
F
.19379 .63873 m
.19379 .64123 L
.19629 .64123 L
.19629 .63873 L
F
.46875 .63873 m
.46875 .64123 L
.47125 .64123 L
.47125 .63873 L
F
.50875 .63873 m
.50875 .64123 L
.51125 .64123 L
.51125 .63873 L
F
.53125 .63873 m
.53125 .64123 L
.53375 .64123 L
.53375 .63873 L
F
.57124 .63873 m
.57124 .64123 L
.57374 .64123 L
.57374 .63873 L
F
.0938 .64123 m
.0938 .64373 L
.0963 .64373 L
.0963 .64123 L
F
.1313 .64123 m
.1313 .64373 L
.1338 .64373 L
.1338 .64123 L
F
.19129 .64123 m
.19129 .64373 L
.19379 .64373 L
.19379 .64123 L
F
.46875 .64123 m
.46875 .64373 L
.47125 .64373 L
.47125 .64123 L
F
.50625 .64123 m
.50625 .64373 L
.50875 .64373 L
.50875 .64123 L
F
.53125 .64123 m
.53125 .64373 L
.53375 .64373 L
.53375 .64123 L
F
.56874 .64123 m
.56874 .64373 L
.57124 .64373 L
.57124 .64123 L
F
.0938 .64373 m
.0938 .64623 L
.0963 .64623 L
.0963 .64373 L
F
.1288 .64373 m
.1288 .64623 L
.1313 .64623 L
.1313 .64373 L
F
.18879 .64373 m
.18879 .64623 L
.19129 .64623 L
.19129 .64373 L
F
.46875 .64373 m
.46875 .64623 L
.47125 .64623 L
.47125 .64373 L
F
.50375 .64373 m
.50375 .64623 L
.50625 .64623 L
.50625 .64373 L
F
.53125 .64373 m
.53125 .64623 L
.53375 .64623 L
.53375 .64373 L
F
.56624 .64373 m
.56624 .64623 L
.56874 .64623 L
.56874 .64373 L
F
.0938 .64623 m
.0938 .64873 L
.0963 .64873 L
.0963 .64623 L
F
.1263 .64623 m
.1263 .64873 L
.1288 .64873 L
.1288 .64623 L
F
.18629 .64623 m
.18629 .64873 L
.18879 .64873 L
.18879 .64623 L
F
.46875 .64623 m
.46875 .64873 L
.47125 .64873 L
.47125 .64623 L
F
.50125 .64623 m
.50125 .64873 L
.50375 .64873 L
.50375 .64623 L
F
.53125 .64623 m
.53125 .64873 L
.53375 .64873 L
.53375 .64623 L
F
.56374 .64623 m
.56374 .64873 L
.56624 .64873 L
.56624 .64623 L
F
.0938 .64873 m
.0938 .65123 L
.0963 .65123 L
.0963 .64873 L
F
.1238 .64873 m
.1238 .65123 L
.1263 .65123 L
.1263 .64873 L
F
.18379 .64873 m
.18379 .65123 L
.18629 .65123 L
.18629 .64873 L
F
.46875 .64873 m
.46875 .65123 L
.47125 .65123 L
.47125 .64873 L
F
.49875 .64873 m
.49875 .65123 L
.50125 .65123 L
.50125 .64873 L
F
.53125 .64873 m
.53125 .65123 L
.53375 .65123 L
.53375 .64873 L
F
.56124 .64873 m
.56124 .65123 L
.56374 .65123 L
.56374 .64873 L
F
.0938 .65123 m
.0938 .65373 L
.0963 .65373 L
.0963 .65123 L
F
.1213 .65123 m
.1213 .65373 L
.1238 .65373 L
.1238 .65123 L
F
.18129 .65123 m
.18129 .65373 L
.18379 .65373 L
.18379 .65123 L
F
.46875 .65123 m
.46875 .65373 L
.47125 .65373 L
.47125 .65123 L
F
.49625 .65123 m
.49625 .65373 L
.49875 .65373 L
.49875 .65123 L
F
.53125 .65123 m
.53125 .65373 L
.53375 .65373 L
.53375 .65123 L
F
.55874 .65123 m
.55874 .65373 L
.56124 .65373 L
.56124 .65123 L
F
.0938 .65373 m
.0938 .65623 L
.0963 .65623 L
.0963 .65373 L
F
.1188 .65373 m
.1188 .65623 L
.1213 .65623 L
.1213 .65373 L
F
.17879 .65373 m
.17879 .65623 L
.18129 .65623 L
.18129 .65373 L
F
.46875 .65373 m
.46875 .65623 L
.47125 .65623 L
.47125 .65373 L
F
.49375 .65373 m
.49375 .65623 L
.49625 .65623 L
.49625 .65373 L
F
.53125 .65373 m
.53125 .65623 L
.53375 .65623 L
.53375 .65373 L
F
.55624 .65373 m
.55624 .65623 L
.55874 .65623 L
.55874 .65373 L
F
.0938 .65623 m
.0938 .65873 L
.0963 .65873 L
.0963 .65623 L
F
.1163 .65623 m
.1163 .65873 L
.1188 .65873 L
.1188 .65623 L
F
.17629 .65623 m
.17629 .65873 L
.17879 .65873 L
.17879 .65623 L
F
.46875 .65623 m
.46875 .65873 L
.47125 .65873 L
.47125 .65623 L
F
.49125 .65623 m
.49125 .65873 L
.49375 .65873 L
.49375 .65623 L
F
.53125 .65623 m
.53125 .65873 L
.53375 .65873 L
.53375 .65623 L
F
.55374 .65623 m
.55374 .65873 L
.55624 .65873 L
.55624 .65623 L
F
.0938 .65873 m
.0938 .66123 L
.0963 .66123 L
.0963 .65873 L
F
.1138 .65873 m
.1138 .66123 L
.1163 .66123 L
.1163 .65873 L
F
.17379 .65873 m
.17379 .66123 L
.17629 .66123 L
.17629 .65873 L
F
.46875 .65873 m
.46875 .66123 L
.47125 .66123 L
.47125 .65873 L
F
.48875 .65873 m
.48875 .66123 L
.49125 .66123 L
.49125 .65873 L
F
.53125 .65873 m
.53125 .66123 L
.53375 .66123 L
.53375 .65873 L
F
.55124 .65873 m
.55124 .66123 L
.55374 .66123 L
.55374 .65873 L
F
.0938 .66123 m
.0938 .66373 L
.0963 .66373 L
.0963 .66123 L
F
.1113 .66123 m
.1113 .66373 L
.1138 .66373 L
.1138 .66123 L
F
.17129 .66123 m
.17129 .66373 L
.17379 .66373 L
.17379 .66123 L
F
.46875 .66123 m
.46875 .66373 L
.47125 .66373 L
.47125 .66123 L
F
.48625 .66123 m
.48625 .66373 L
.48875 .66373 L
.48875 .66123 L
F
.53125 .66123 m
.53125 .66373 L
.53375 .66373 L
.53375 .66123 L
F
.54874 .66123 m
.54874 .66373 L
.55124 .66373 L
.55124 .66123 L
F
.0938 .66373 m
.0938 .66623 L
.0963 .66623 L
.0963 .66373 L
F
.1088 .66373 m
.1088 .66623 L
.1113 .66623 L
.1113 .66373 L
F
.16879 .66373 m
.16879 .66623 L
.17129 .66623 L
.17129 .66373 L
F
.46875 .66373 m
.46875 .66623 L
.47125 .66623 L
.47125 .66373 L
F
.48375 .66373 m
.48375 .66623 L
.48625 .66623 L
.48625 .66373 L
F
.53125 .66373 m
.53125 .66623 L
.53375 .66623 L
.53375 .66373 L
F
.54624 .66373 m
.54624 .66623 L
.54874 .66623 L
.54874 .66373 L
F
.0938 .66623 m
.0938 .66873 L
.0963 .66873 L
.0963 .66623 L
F
.1063 .66623 m
.1063 .66873 L
.1088 .66873 L
.1088 .66623 L
F
.16629 .66623 m
.16629 .66873 L
.16879 .66873 L
.16879 .66623 L
F
.46875 .66623 m
.46875 .66873 L
.47125 .66873 L
.47125 .66623 L
F
.48125 .66623 m
.48125 .66873 L
.48375 .66873 L
.48375 .66623 L
F
.53125 .66623 m
.53125 .66873 L
.53375 .66873 L
.53375 .66623 L
F
.54374 .66623 m
.54374 .66873 L
.54624 .66873 L
.54624 .66623 L
F
.0938 .66873 m
.0938 .67123 L
.0963 .67123 L
.0963 .66873 L
F
.1038 .66873 m
.1038 .67123 L
.1063 .67123 L
.1063 .66873 L
F
.16379 .66873 m
.16379 .67123 L
.16629 .67123 L
.16629 .66873 L
F
.46875 .66873 m
.46875 .67123 L
.47125 .67123 L
.47125 .66873 L
F
.47875 .66873 m
.47875 .67123 L
.48125 .67123 L
.48125 .66873 L
F
.53125 .66873 m
.53125 .67123 L
.53375 .67123 L
.53375 .66873 L
F
.54124 .66873 m
.54124 .67123 L
.54374 .67123 L
.54374 .66873 L
F
.0938 .67123 m
.0938 .67373 L
.0963 .67373 L
.0963 .67123 L
F
.1013 .67123 m
.1013 .67373 L
.1038 .67373 L
.1038 .67123 L
F
.16129 .67123 m
.16129 .67373 L
.16379 .67373 L
.16379 .67123 L
F
.46875 .67123 m
.46875 .67373 L
.47125 .67373 L
.47125 .67123 L
F
.47625 .67123 m
.47625 .67373 L
.47875 .67373 L
.47875 .67123 L
F
.53125 .67123 m
.53125 .67373 L
.53375 .67373 L
.53375 .67123 L
F
.53875 .67123 m
.53875 .67373 L
.54124 .67373 L
.54124 .67123 L
F
.0938 .67373 m
.0938 .67623 L
.0963 .67623 L
.0963 .67373 L
F
.0988 .67373 m
.0988 .67623 L
.1013 .67623 L
.1013 .67373 L
F
.15879 .67373 m
.15879 .67623 L
.16129 .67623 L
.16129 .67373 L
F
.46875 .67373 m
.46875 .67623 L
.47125 .67623 L
.47125 .67373 L
F
.47375 .67373 m
.47375 .67623 L
.47625 .67623 L
.47625 .67373 L
F
.53125 .67373 m
.53125 .67623 L
.53375 .67623 L
.53375 .67373 L
F
.53625 .67373 m
.53625 .67623 L
.53875 .67623 L
.53875 .67373 L
F
.0938 .67623 m
.0938 .67873 L
.0963 .67873 L
.0963 .67623 L
F
.0963 .67623 m
.0963 .67873 L
.0988 .67873 L
.0988 .67623 L
F
.15629 .67623 m
.15629 .67873 L
.15879 .67873 L
.15879 .67623 L
F
.46875 .67623 m
.46875 .67873 L
.47125 .67873 L
.47125 .67623 L
F
.47125 .67623 m
.47125 .67873 L
.47375 .67873 L
.47375 .67623 L
F
.53125 .67623 m
.53125 .67873 L
.53375 .67873 L
.53375 .67623 L
F
.53375 .67623 m
.53375 .67873 L
.53625 .67873 L
.53625 .67623 L
F
.15129 .67873 m
.15129 .68123 L
.15379 .68123 L
.15379 .67873 L
F
.58874 .67873 m
.58874 .68123 L
.59124 .68123 L
.59124 .67873 L
F
.59374 .67873 m
.59374 .68123 L
.59624 .68123 L
.59624 .67873 L
F
.14879 .68123 m
.14879 .68373 L
.15129 .68373 L
.15129 .68123 L
F
.58624 .68123 m
.58624 .68373 L
.58874 .68373 L
.58874 .68123 L
F
.59374 .68123 m
.59374 .68373 L
.59624 .68373 L
.59624 .68123 L
F
.14629 .68373 m
.14629 .68623 L
.14879 .68623 L
.14879 .68373 L
F
.58374 .68373 m
.58374 .68623 L
.58624 .68623 L
.58624 .68373 L
F
.59374 .68373 m
.59374 .68623 L
.59624 .68623 L
.59624 .68373 L
F
.14379 .68623 m
.14379 .68873 L
.14629 .68873 L
.14629 .68623 L
F
.58124 .68623 m
.58124 .68873 L
.58374 .68873 L
.58374 .68623 L
F
.59374 .68623 m
.59374 .68873 L
.59624 .68873 L
.59624 .68623 L
F
.14129 .68873 m
.14129 .69123 L
.14379 .69123 L
.14379 .68873 L
F
.57874 .68873 m
.57874 .69123 L
.58124 .69123 L
.58124 .68873 L
F
.59374 .68873 m
.59374 .69123 L
.59624 .69123 L
.59624 .68873 L
F
.1388 .69123 m
.1388 .69373 L
.14129 .69373 L
.14129 .69123 L
F
.57624 .69123 m
.57624 .69373 L
.57874 .69373 L
.57874 .69123 L
F
.59374 .69123 m
.59374 .69373 L
.59624 .69373 L
.59624 .69123 L
F
.1363 .69373 m
.1363 .69623 L
.1388 .69623 L
.1388 .69373 L
F
.57374 .69373 m
.57374 .69623 L
.57624 .69623 L
.57624 .69373 L
F
.59374 .69373 m
.59374 .69623 L
.59624 .69623 L
.59624 .69373 L
F
.1338 .69623 m
.1338 .69873 L
.1363 .69873 L
.1363 .69623 L
F
.57124 .69623 m
.57124 .69873 L
.57374 .69873 L
.57374 .69623 L
F
.59374 .69623 m
.59374 .69873 L
.59624 .69873 L
.59624 .69623 L
F
.1313 .69873 m
.1313 .70122 L
.1338 .70122 L
.1338 .69873 L
F
.56874 .69873 m
.56874 .70122 L
.57124 .70122 L
.57124 .69873 L
F
.59374 .69873 m
.59374 .70122 L
.59624 .70122 L
.59624 .69873 L
F
.1288 .70122 m
.1288 .70372 L
.1313 .70372 L
.1313 .70122 L
F
.56624 .70122 m
.56624 .70372 L
.56874 .70372 L
.56874 .70122 L
F
.59374 .70122 m
.59374 .70372 L
.59624 .70372 L
.59624 .70122 L
F
.1263 .70372 m
.1263 .70622 L
.1288 .70622 L
.1288 .70372 L
F
.56374 .70372 m
.56374 .70622 L
.56624 .70622 L
.56624 .70372 L
F
.59374 .70372 m
.59374 .70622 L
.59624 .70622 L
.59624 .70372 L
F
.1238 .70622 m
.1238 .70872 L
.1263 .70872 L
.1263 .70622 L
F
.56124 .70622 m
.56124 .70872 L
.56374 .70872 L
.56374 .70622 L
F
.59374 .70622 m
.59374 .70872 L
.59624 .70872 L
.59624 .70622 L
F
.1213 .70872 m
.1213 .71122 L
.1238 .71122 L
.1238 .70872 L
F
.55874 .70872 m
.55874 .71122 L
.56124 .71122 L
.56124 .70872 L
F
.59374 .70872 m
.59374 .71122 L
.59624 .71122 L
.59624 .70872 L
F
.1188 .71122 m
.1188 .71372 L
.1213 .71372 L
.1213 .71122 L
F
.55624 .71122 m
.55624 .71372 L
.55874 .71372 L
.55874 .71122 L
F
.59374 .71122 m
.59374 .71372 L
.59624 .71372 L
.59624 .71122 L
F
.1163 .71372 m
.1163 .71622 L
.1188 .71622 L
.1188 .71372 L
F
.55374 .71372 m
.55374 .71622 L
.55624 .71622 L
.55624 .71372 L
F
.59374 .71372 m
.59374 .71622 L
.59624 .71622 L
.59624 .71372 L
F
.1138 .71622 m
.1138 .71872 L
.1163 .71872 L
.1163 .71622 L
F
.55124 .71622 m
.55124 .71872 L
.55374 .71872 L
.55374 .71622 L
F
.59374 .71622 m
.59374 .71872 L
.59624 .71872 L
.59624 .71622 L
F
.1113 .71872 m
.1113 .72122 L
.1138 .72122 L
.1138 .71872 L
F
.54874 .71872 m
.54874 .72122 L
.55124 .72122 L
.55124 .71872 L
F
.59374 .71872 m
.59374 .72122 L
.59624 .72122 L
.59624 .71872 L
F
.1088 .72122 m
.1088 .72372 L
.1113 .72372 L
.1113 .72122 L
F
.54624 .72122 m
.54624 .72372 L
.54874 .72372 L
.54874 .72122 L
F
.59374 .72122 m
.59374 .72372 L
.59624 .72372 L
.59624 .72122 L
F
.1063 .72372 m
.1063 .72622 L
.1088 .72622 L
.1088 .72372 L
F
.54374 .72372 m
.54374 .72622 L
.54624 .72622 L
.54624 .72372 L
F
.59374 .72372 m
.59374 .72622 L
.59624 .72622 L
.59624 .72372 L
F
.1038 .72622 m
.1038 .72872 L
.1063 .72872 L
.1063 .72622 L
F
.54124 .72622 m
.54124 .72872 L
.54374 .72872 L
.54374 .72622 L
F
.59374 .72622 m
.59374 .72872 L
.59624 .72872 L
.59624 .72622 L
F
.1013 .72872 m
.1013 .73122 L
.1038 .73122 L
.1038 .72872 L
F
.53875 .72872 m
.53875 .73122 L
.54124 .73122 L
.54124 .72872 L
F
.59374 .72872 m
.59374 .73122 L
.59624 .73122 L
.59624 .72872 L
F
.0988 .73122 m
.0988 .73372 L
.1013 .73372 L
.1013 .73122 L
F
.53625 .73122 m
.53625 .73372 L
.53875 .73372 L
.53875 .73122 L
F
.59374 .73122 m
.59374 .73372 L
.59624 .73372 L
.59624 .73122 L
F
.0963 .73372 m
.0963 .73622 L
.0988 .73622 L
.0988 .73372 L
F
.53375 .73372 m
.53375 .73622 L
.53625 .73622 L
.53625 .73372 L
F
.59374 .73372 m
.59374 .73622 L
.59624 .73622 L
.59624 .73372 L
F
.02381 .73622 m
.02381 .73872 L
.02631 .73872 L
.02631 .73622 L
F
.34127 .73622 m
.34127 .73872 L
.34377 .73872 L
.34377 .73622 L
F
.40126 .73622 m
.40126 .73872 L
.40376 .73872 L
.40376 .73622 L
F
.46875 .73622 m
.46875 .73872 L
.47125 .73872 L
.47125 .73622 L
F
.52875 .73622 m
.52875 .73872 L
.53125 .73872 L
.53125 .73622 L
F
.34127 .73872 m
.34127 .74122 L
.34377 .74122 L
.34377 .73872 L
F
.39876 .73872 m
.39876 .74122 L
.40126 .74122 L
.40126 .73872 L
F
.46875 .73872 m
.46875 .74122 L
.47125 .74122 L
.47125 .73872 L
F
.52625 .73872 m
.52625 .74122 L
.52875 .74122 L
.52875 .73872 L
F
.34127 .74122 m
.34127 .74372 L
.34377 .74372 L
.34377 .74122 L
F
.39626 .74122 m
.39626 .74372 L
.39876 .74372 L
.39876 .74122 L
F
.46875 .74122 m
.46875 .74372 L
.47125 .74372 L
.47125 .74122 L
F
.52375 .74122 m
.52375 .74372 L
.52625 .74372 L
.52625 .74122 L
F
.34127 .74372 m
.34127 .74622 L
.34377 .74622 L
.34377 .74372 L
F
.39376 .74372 m
.39376 .74622 L
.39626 .74622 L
.39626 .74372 L
F
.46875 .74372 m
.46875 .74622 L
.47125 .74622 L
.47125 .74372 L
F
.52125 .74372 m
.52125 .74622 L
.52375 .74622 L
.52375 .74372 L
F
.34127 .74622 m
.34127 .74872 L
.34377 .74872 L
.34377 .74622 L
F
.39126 .74622 m
.39126 .74872 L
.39376 .74872 L
.39376 .74622 L
F
.46875 .74622 m
.46875 .74872 L
.47125 .74872 L
.47125 .74622 L
F
.51875 .74622 m
.51875 .74872 L
.52125 .74872 L
.52125 .74622 L
F
.34127 .74872 m
.34127 .75122 L
.34377 .75122 L
.34377 .74872 L
F
.38876 .74872 m
.38876 .75122 L
.39126 .75122 L
.39126 .74872 L
F
.46875 .74872 m
.46875 .75122 L
.47125 .75122 L
.47125 .74872 L
F
.51625 .74872 m
.51625 .75122 L
.51875 .75122 L
.51875 .74872 L
F
.34127 .75122 m
.34127 .75372 L
.34377 .75372 L
.34377 .75122 L
F
.38626 .75122 m
.38626 .75372 L
.38876 .75372 L
.38876 .75122 L
F
.46875 .75122 m
.46875 .75372 L
.47125 .75372 L
.47125 .75122 L
F
.51375 .75122 m
.51375 .75372 L
.51625 .75372 L
.51625 .75122 L
F
.34127 .75372 m
.34127 .75622 L
.34377 .75622 L
.34377 .75372 L
F
.38376 .75372 m
.38376 .75622 L
.38626 .75622 L
.38626 .75372 L
F
.46875 .75372 m
.46875 .75622 L
.47125 .75622 L
.47125 .75372 L
F
.51125 .75372 m
.51125 .75622 L
.51375 .75622 L
.51375 .75372 L
F
.34127 .75622 m
.34127 .75872 L
.34377 .75872 L
.34377 .75622 L
F
.38126 .75622 m
.38126 .75872 L
.38376 .75872 L
.38376 .75622 L
F
.46875 .75622 m
.46875 .75872 L
.47125 .75872 L
.47125 .75622 L
F
.50875 .75622 m
.50875 .75872 L
.51125 .75872 L
.51125 .75622 L
F
.34127 .75872 m
.34127 .76122 L
.34377 .76122 L
.34377 .75872 L
F
.37877 .75872 m
.37877 .76122 L
.38126 .76122 L
.38126 .75872 L
F
.46875 .75872 m
.46875 .76122 L
.47125 .76122 L
.47125 .75872 L
F
.50625 .75872 m
.50625 .76122 L
.50875 .76122 L
.50875 .75872 L
F
.34127 .76122 m
.34127 .76372 L
.34377 .76372 L
.34377 .76122 L
F
.37627 .76122 m
.37627 .76372 L
.37877 .76372 L
.37877 .76122 L
F
.46875 .76122 m
.46875 .76372 L
.47125 .76372 L
.47125 .76122 L
F
.50375 .76122 m
.50375 .76372 L
.50625 .76372 L
.50625 .76122 L
F
.34127 .76372 m
.34127 .76622 L
.34377 .76622 L
.34377 .76372 L
F
.37377 .76372 m
.37377 .76622 L
.37627 .76622 L
.37627 .76372 L
F
.46875 .76372 m
.46875 .76622 L
.47125 .76622 L
.47125 .76372 L
F
.50125 .76372 m
.50125 .76622 L
.50375 .76622 L
.50375 .76372 L
F
.34127 .76622 m
.34127 .76872 L
.34377 .76872 L
.34377 .76622 L
F
.37127 .76622 m
.37127 .76872 L
.37377 .76872 L
.37377 .76622 L
F
.46875 .76622 m
.46875 .76872 L
.47125 .76872 L
.47125 .76622 L
F
.49875 .76622 m
.49875 .76872 L
.50125 .76872 L
.50125 .76622 L
F
.34127 .76872 m
.34127 .77122 L
.34377 .77122 L
.34377 .76872 L
F
.36877 .76872 m
.36877 .77122 L
.37127 .77122 L
.37127 .76872 L
F
.46875 .76872 m
.46875 .77122 L
.47125 .77122 L
.47125 .76872 L
F
.49625 .76872 m
.49625 .77122 L
.49875 .77122 L
.49875 .76872 L
F
.34127 .77122 m
.34127 .77372 L
.34377 .77372 L
.34377 .77122 L
F
.36627 .77122 m
.36627 .77372 L
.36877 .77372 L
.36877 .77122 L
F
.46875 .77122 m
.46875 .77372 L
.47125 .77372 L
.47125 .77122 L
F
.49375 .77122 m
.49375 .77372 L
.49625 .77372 L
.49625 .77122 L
F
.34127 .77372 m
.34127 .77622 L
.34377 .77622 L
.34377 .77372 L
F
.36377 .77372 m
.36377 .77622 L
.36627 .77622 L
.36627 .77372 L
F
.46875 .77372 m
.46875 .77622 L
.47125 .77622 L
.47125 .77372 L
F
.49125 .77372 m
.49125 .77622 L
.49375 .77622 L
.49375 .77372 L
F
.34127 .77622 m
.34127 .77872 L
.34377 .77872 L
.34377 .77622 L
F
.36127 .77622 m
.36127 .77872 L
.36377 .77872 L
.36377 .77622 L
F
.46875 .77622 m
.46875 .77872 L
.47125 .77872 L
.47125 .77622 L
F
.48875 .77622 m
.48875 .77872 L
.49125 .77872 L
.49125 .77622 L
F
.34127 .77872 m
.34127 .78121 L
.34377 .78121 L
.34377 .77872 L
F
.35877 .77872 m
.35877 .78121 L
.36127 .78121 L
.36127 .77872 L
F
.46875 .77872 m
.46875 .78121 L
.47125 .78121 L
.47125 .77872 L
F
.48625 .77872 m
.48625 .78121 L
.48875 .78121 L
.48875 .77872 L
F
.34127 .78121 m
.34127 .78371 L
.34377 .78371 L
.34377 .78121 L
F
.35627 .78121 m
.35627 .78371 L
.35877 .78371 L
.35877 .78121 L
F
.46875 .78121 m
.46875 .78371 L
.47125 .78371 L
.47125 .78121 L
F
.48375 .78121 m
.48375 .78371 L
.48625 .78371 L
.48625 .78121 L
F
.34127 .78371 m
.34127 .78621 L
.34377 .78621 L
.34377 .78371 L
F
.35377 .78371 m
.35377 .78621 L
.35627 .78621 L
.35627 .78371 L
F
.46875 .78371 m
.46875 .78621 L
.47125 .78621 L
.47125 .78371 L
F
.48125 .78371 m
.48125 .78621 L
.48375 .78621 L
.48375 .78371 L
F
.34127 .78621 m
.34127 .78871 L
.34377 .78871 L
.34377 .78621 L
F
.35127 .78621 m
.35127 .78871 L
.35377 .78871 L
.35377 .78621 L
F
.46875 .78621 m
.46875 .78871 L
.47125 .78871 L
.47125 .78621 L
F
.47875 .78621 m
.47875 .78871 L
.48125 .78871 L
.48125 .78621 L
F
.34127 .78871 m
.34127 .79121 L
.34377 .79121 L
.34377 .78871 L
F
.34877 .78871 m
.34877 .79121 L
.35127 .79121 L
.35127 .78871 L
F
.46875 .78871 m
.46875 .79121 L
.47125 .79121 L
.47125 .78871 L
F
.47625 .78871 m
.47625 .79121 L
.47875 .79121 L
.47875 .78871 L
F
.34127 .79121 m
.34127 .79371 L
.34377 .79371 L
.34377 .79121 L
F
.34627 .79121 m
.34627 .79371 L
.34877 .79371 L
.34877 .79121 L
F
.46875 .79121 m
.46875 .79371 L
.47125 .79371 L
.47125 .79121 L
F
.47375 .79121 m
.47375 .79371 L
.47625 .79371 L
.47625 .79121 L
F
.34127 .79371 m
.34127 .79621 L
.34377 .79621 L
.34377 .79371 L
F
.34377 .79371 m
.34377 .79621 L
.34627 .79621 L
.34627 .79371 L
F
.46875 .79371 m
.46875 .79621 L
.47125 .79621 L
.47125 .79371 L
F
.47125 .79371 m
.47125 .79621 L
.47375 .79621 L
.47375 .79371 L
F
.40626 .79621 m
.40626 .79871 L
.40876 .79871 L
.40876 .79621 L
F
.40876 .79621 m
.40876 .79871 L
.41126 .79871 L
.41126 .79621 L
F
.41126 .79621 m
.41126 .79871 L
.41376 .79871 L
.41376 .79621 L
F
.41376 .79621 m
.41376 .79871 L
.41626 .79871 L
.41626 .79621 L
F
.41626 .79621 m
.41626 .79871 L
.41876 .79871 L
.41876 .79621 L
F
.41876 .79621 m
.41876 .79871 L
.42126 .79871 L
.42126 .79621 L
F
.42126 .79621 m
.42126 .79871 L
.42376 .79871 L
.42376 .79621 L
F
.42376 .79621 m
.42376 .79871 L
.42626 .79871 L
.42626 .79621 L
F
.42626 .79621 m
.42626 .79871 L
.42876 .79871 L
.42876 .79621 L
F
.42876 .79621 m
.42876 .79871 L
.43126 .79871 L
.43126 .79621 L
F
.43126 .79621 m
.43126 .79871 L
.43376 .79871 L
.43376 .79621 L
F
.43376 .79621 m
.43376 .79871 L
.43626 .79871 L
.43626 .79621 L
F
.43626 .79621 m
.43626 .79871 L
.43876 .79871 L
.43876 .79621 L
F
.43876 .79621 m
.43876 .79871 L
.44126 .79871 L
.44126 .79621 L
F
.44126 .79621 m
.44126 .79871 L
.44376 .79871 L
.44376 .79621 L
F
.44376 .79621 m
.44376 .79871 L
.44626 .79871 L
.44626 .79621 L
F
.44626 .79621 m
.44626 .79871 L
.44876 .79871 L
.44876 .79621 L
F
.44876 .79621 m
.44876 .79871 L
.45126 .79871 L
.45126 .79621 L
F
.45126 .79621 m
.45126 .79871 L
.45376 .79871 L
.45376 .79621 L
F
.45376 .79621 m
.45376 .79871 L
.45626 .79871 L
.45626 .79621 L
F
.45626 .79621 m
.45626 .79871 L
.45876 .79871 L
.45876 .79621 L
F
.45876 .79621 m
.45876 .79871 L
.46125 .79871 L
.46125 .79621 L
F
.46125 .79621 m
.46125 .79871 L
.46375 .79871 L
.46375 .79621 L
F
.46375 .79621 m
.46375 .79871 L
.46625 .79871 L
.46625 .79621 L
F
.46625 .79621 m
.46625 .79871 L
.46875 .79871 L
.46875 .79621 L
F
.03131 .79871 m
.03131 .80121 L
.03381 .80121 L
.03381 .79871 L
F
.0913 .79871 m
.0913 .80121 L
.0938 .80121 L
.0938 .79871 L
F
.27878 .79871 m
.27878 .80121 L
.28128 .80121 L
.28128 .79871 L
F
.33877 .79871 m
.33877 .80121 L
.34127 .80121 L
.34127 .79871 L
F
.40376 .79871 m
.40376 .80121 L
.40626 .80121 L
.40626 .79871 L
F
.46375 .79871 m
.46375 .80121 L
.46625 .80121 L
.46625 .79871 L
F
.03131 .80121 m
.03131 .80371 L
.03381 .80371 L
.03381 .80121 L
F
.0888 .80121 m
.0888 .80371 L
.0913 .80371 L
.0913 .80121 L
F
.27878 .80121 m
.27878 .80371 L
.28128 .80371 L
.28128 .80121 L
F
.33627 .80121 m
.33627 .80371 L
.33877 .80371 L
.33877 .80121 L
F
.40376 .80121 m
.40376 .80371 L
.40626 .80371 L
.40626 .80121 L
F
.46125 .80121 m
.46125 .80371 L
.46375 .80371 L
.46375 .80121 L
F
.03131 .80371 m
.03131 .80621 L
.03381 .80621 L
.03381 .80371 L
F
.0863 .80371 m
.0863 .80621 L
.0888 .80621 L
.0888 .80371 L
F
.27878 .80371 m
.27878 .80621 L
.28128 .80621 L
.28128 .80371 L
F
.33377 .80371 m
.33377 .80621 L
.33627 .80621 L
.33627 .80371 L
F
.40376 .80371 m
.40376 .80621 L
.40626 .80621 L
.40626 .80371 L
F
.45876 .80371 m
.45876 .80621 L
.46125 .80621 L
.46125 .80371 L
F
.03131 .80621 m
.03131 .80871 L
.03381 .80871 L
.03381 .80621 L
F
.0838 .80621 m
.0838 .80871 L
.0863 .80871 L
.0863 .80621 L
F
.27878 .80621 m
.27878 .80871 L
.28128 .80871 L
.28128 .80621 L
F
.33127 .80621 m
.33127 .80871 L
.33377 .80871 L
.33377 .80621 L
F
.40376 .80621 m
.40376 .80871 L
.40626 .80871 L
.40626 .80621 L
F
.45626 .80621 m
.45626 .80871 L
.45876 .80871 L
.45876 .80621 L
F
.03131 .80871 m
.03131 .81121 L
.03381 .81121 L
.03381 .80871 L
F
.0813 .80871 m
.0813 .81121 L
.0838 .81121 L
.0838 .80871 L
F
.27878 .80871 m
.27878 .81121 L
.28128 .81121 L
.28128 .80871 L
F
.32877 .80871 m
.32877 .81121 L
.33127 .81121 L
.33127 .80871 L
F
.40376 .80871 m
.40376 .81121 L
.40626 .81121 L
.40626 .80871 L
F
.45376 .80871 m
.45376 .81121 L
.45626 .81121 L
.45626 .80871 L
F
.03131 .81121 m
.03131 .81371 L
.03381 .81371 L
.03381 .81121 L
F
.0788 .81121 m
.0788 .81371 L
.0813 .81371 L
.0813 .81121 L
F
.27878 .81121 m
.27878 .81371 L
.28128 .81371 L
.28128 .81121 L
F
.32627 .81121 m
.32627 .81371 L
.32877 .81371 L
.32877 .81121 L
F
.40376 .81121 m
.40376 .81371 L
.40626 .81371 L
.40626 .81121 L
F
.45126 .81121 m
.45126 .81371 L
.45376 .81371 L
.45376 .81121 L
F
.03131 .81371 m
.03131 .81621 L
.03381 .81621 L
.03381 .81371 L
F
.0763 .81371 m
.0763 .81621 L
.0788 .81621 L
.0788 .81371 L
F
.27878 .81371 m
.27878 .81621 L
.28128 .81621 L
.28128 .81371 L
F
.32377 .81371 m
.32377 .81621 L
.32627 .81621 L
.32627 .81371 L
F
.40376 .81371 m
.40376 .81621 L
.40626 .81621 L
.40626 .81371 L
F
.44876 .81371 m
.44876 .81621 L
.45126 .81621 L
.45126 .81371 L
F
.03131 .81621 m
.03131 .81871 L
.03381 .81871 L
.03381 .81621 L
F
.0738 .81621 m
.0738 .81871 L
.0763 .81871 L
.0763 .81621 L
F
.27878 .81621 m
.27878 .81871 L
.28128 .81871 L
.28128 .81621 L
F
.32127 .81621 m
.32127 .81871 L
.32377 .81871 L
.32377 .81621 L
F
.40376 .81621 m
.40376 .81871 L
.40626 .81871 L
.40626 .81621 L
F
.44626 .81621 m
.44626 .81871 L
.44876 .81871 L
.44876 .81621 L
F
.03131 .81871 m
.03131 .82121 L
.03381 .82121 L
.03381 .81871 L
F
.0713 .81871 m
.0713 .82121 L
.0738 .82121 L
.0738 .81871 L
F
.27878 .81871 m
.27878 .82121 L
.28128 .82121 L
.28128 .81871 L
F
.31877 .81871 m
.31877 .82121 L
.32127 .82121 L
.32127 .81871 L
F
.40376 .81871 m
.40376 .82121 L
.40626 .82121 L
.40626 .81871 L
F
.44376 .81871 m
.44376 .82121 L
.44626 .82121 L
.44626 .81871 L
F
.03131 .82121 m
.03131 .82371 L
.03381 .82371 L
.03381 .82121 L
F
.0688 .82121 m
.0688 .82371 L
.0713 .82371 L
.0713 .82121 L
F
.27878 .82121 m
.27878 .82371 L
.28128 .82371 L
.28128 .82121 L
F
.31627 .82121 m
.31627 .82371 L
.31877 .82371 L
.31877 .82121 L
F
.40376 .82121 m
.40376 .82371 L
.40626 .82371 L
.40626 .82121 L
F
.44126 .82121 m
.44126 .82371 L
.44376 .82371 L
.44376 .82121 L
F
.03131 .82371 m
.03131 .82621 L
.03381 .82621 L
.03381 .82371 L
F
.0663 .82371 m
.0663 .82621 L
.0688 .82621 L
.0688 .82371 L
F
.27878 .82371 m
.27878 .82621 L
.28128 .82621 L
.28128 .82371 L
F
.31377 .82371 m
.31377 .82621 L
.31627 .82621 L
.31627 .82371 L
F
.40376 .82371 m
.40376 .82621 L
.40626 .82621 L
.40626 .82371 L
F
.43876 .82371 m
.43876 .82621 L
.44126 .82621 L
.44126 .82371 L
F
.03131 .82621 m
.03131 .82871 L
.03381 .82871 L
.03381 .82621 L
F
.0638 .82621 m
.0638 .82871 L
.0663 .82871 L
.0663 .82621 L
F
.27878 .82621 m
.27878 .82871 L
.28128 .82871 L
.28128 .82621 L
F
.31127 .82621 m
.31127 .82871 L
.31377 .82871 L
.31377 .82621 L
F
.40376 .82621 m
.40376 .82871 L
.40626 .82871 L
.40626 .82621 L
F
.43626 .82621 m
.43626 .82871 L
.43876 .82871 L
.43876 .82621 L
F
.03131 .82871 m
.03131 .83121 L
.03381 .83121 L
.03381 .82871 L
F
.0613 .82871 m
.0613 .83121 L
.0638 .83121 L
.0638 .82871 L
F
.27878 .82871 m
.27878 .83121 L
.28128 .83121 L
.28128 .82871 L
F
.30877 .82871 m
.30877 .83121 L
.31127 .83121 L
.31127 .82871 L
F
.40376 .82871 m
.40376 .83121 L
.40626 .83121 L
.40626 .82871 L
F
.43376 .82871 m
.43376 .83121 L
.43626 .83121 L
.43626 .82871 L
F
.03131 .83121 m
.03131 .83371 L
.03381 .83371 L
.03381 .83121 L
F
.05881 .83121 m
.05881 .83371 L
.0613 .83371 L
.0613 .83121 L
F
.27878 .83121 m
.27878 .83371 L
.28128 .83371 L
.28128 .83121 L
F
.30627 .83121 m
.30627 .83371 L
.30877 .83371 L
.30877 .83121 L
F
.40376 .83121 m
.40376 .83371 L
.40626 .83371 L
.40626 .83121 L
F
.43126 .83121 m
.43126 .83371 L
.43376 .83371 L
.43376 .83121 L
F
.03131 .83371 m
.03131 .83621 L
.03381 .83621 L
.03381 .83371 L
F
.05631 .83371 m
.05631 .83621 L
.05881 .83621 L
.05881 .83371 L
F
.27878 .83371 m
.27878 .83621 L
.28128 .83621 L
.28128 .83371 L
F
.30377 .83371 m
.30377 .83621 L
.30627 .83621 L
.30627 .83371 L
F
.40376 .83371 m
.40376 .83621 L
.40626 .83621 L
.40626 .83371 L
F
.42876 .83371 m
.42876 .83621 L
.43126 .83621 L
.43126 .83371 L
F
.03131 .83621 m
.03131 .83871 L
.03381 .83871 L
.03381 .83621 L
F
.05381 .83621 m
.05381 .83871 L
.05631 .83871 L
.05631 .83621 L
F
.27878 .83621 m
.27878 .83871 L
.28128 .83871 L
.28128 .83621 L
F
.30127 .83621 m
.30127 .83871 L
.30377 .83871 L
.30377 .83621 L
F
.40376 .83621 m
.40376 .83871 L
.40626 .83871 L
.40626 .83621 L
F
.42626 .83621 m
.42626 .83871 L
.42876 .83871 L
.42876 .83621 L
F
.03131 .83871 m
.03131 .84121 L
.03381 .84121 L
.03381 .83871 L
F
.05131 .83871 m
.05131 .84121 L
.05381 .84121 L
.05381 .83871 L
F
.27878 .83871 m
.27878 .84121 L
.28128 .84121 L
.28128 .83871 L
F
.29878 .83871 m
.29878 .84121 L
.30127 .84121 L
.30127 .83871 L
F
.40376 .83871 m
.40376 .84121 L
.40626 .84121 L
.40626 .83871 L
F
.42376 .83871 m
.42376 .84121 L
.42626 .84121 L
.42626 .83871 L
F
.03131 .84121 m
.03131 .84371 L
.03381 .84371 L
.03381 .84121 L
F
.04881 .84121 m
.04881 .84371 L
.05131 .84371 L
.05131 .84121 L
F
.27878 .84121 m
.27878 .84371 L
.28128 .84371 L
.28128 .84121 L
F
.29628 .84121 m
.29628 .84371 L
.29878 .84371 L
.29878 .84121 L
F
.40376 .84121 m
.40376 .84371 L
.40626 .84371 L
.40626 .84121 L
F
.42126 .84121 m
.42126 .84371 L
.42376 .84371 L
.42376 .84121 L
F
.03131 .84371 m
.03131 .84621 L
.03381 .84621 L
.03381 .84371 L
F
.04631 .84371 m
.04631 .84621 L
.04881 .84621 L
.04881 .84371 L
F
.27878 .84371 m
.27878 .84621 L
.28128 .84621 L
.28128 .84371 L
F
.29378 .84371 m
.29378 .84621 L
.29628 .84621 L
.29628 .84371 L
F
.40376 .84371 m
.40376 .84621 L
.40626 .84621 L
.40626 .84371 L
F
.41876 .84371 m
.41876 .84621 L
.42126 .84621 L
.42126 .84371 L
F
.03131 .84621 m
.03131 .84871 L
.03381 .84871 L
.03381 .84621 L
F
.04381 .84621 m
.04381 .84871 L
.04631 .84871 L
.04631 .84621 L
F
.27878 .84621 m
.27878 .84871 L
.28128 .84871 L
.28128 .84621 L
F
.29128 .84621 m
.29128 .84871 L
.29378 .84871 L
.29378 .84621 L
F
.40376 .84621 m
.40376 .84871 L
.40626 .84871 L
.40626 .84621 L
F
.41626 .84621 m
.41626 .84871 L
.41876 .84871 L
.41876 .84621 L
F
.03131 .84871 m
.03131 .85121 L
.03381 .85121 L
.03381 .84871 L
F
.04131 .84871 m
.04131 .85121 L
.04381 .85121 L
.04381 .84871 L
F
.27878 .84871 m
.27878 .85121 L
.28128 .85121 L
.28128 .84871 L
F
.28878 .84871 m
.28878 .85121 L
.29128 .85121 L
.29128 .84871 L
F
.40376 .84871 m
.40376 .85121 L
.40626 .85121 L
.40626 .84871 L
F
.41376 .84871 m
.41376 .85121 L
.41626 .85121 L
.41626 .84871 L
F
.03131 .85121 m
.03131 .85371 L
.03381 .85371 L
.03381 .85121 L
F
.03881 .85121 m
.03881 .85371 L
.04131 .85371 L
.04131 .85121 L
F
.27878 .85121 m
.27878 .85371 L
.28128 .85371 L
.28128 .85121 L
F
.28628 .85121 m
.28628 .85371 L
.28878 .85371 L
.28878 .85121 L
F
.40376 .85121 m
.40376 .85371 L
.40626 .85371 L
.40626 .85121 L
F
.41126 .85121 m
.41126 .85371 L
.41376 .85371 L
.41376 .85121 L
F
.03131 .85371 m
.03131 .85621 L
.03381 .85621 L
.03381 .85371 L
F
.03631 .85371 m
.03631 .85621 L
.03881 .85621 L
.03881 .85371 L
F
.27878 .85371 m
.27878 .85621 L
.28128 .85621 L
.28128 .85371 L
F
.28378 .85371 m
.28378 .85621 L
.28628 .85621 L
.28628 .85371 L
F
.40376 .85371 m
.40376 .85621 L
.40626 .85621 L
.40626 .85371 L
F
.40876 .85371 m
.40876 .85621 L
.41126 .85621 L
.41126 .85371 L
F
.03131 .85621 m
.03131 .85871 L
.03381 .85871 L
.03381 .85621 L
F
.03381 .85621 m
.03381 .85871 L
.03631 .85871 L
.03631 .85621 L
F
.27878 .85621 m
.27878 .85871 L
.28128 .85871 L
.28128 .85621 L
F
.28128 .85621 m
.28128 .85871 L
.28378 .85871 L
.28378 .85621 L
F
.40376 .85621 m
.40376 .85871 L
.40626 .85871 L
.40626 .85621 L
F
.40626 .85621 m
.40626 .85871 L
.40876 .85871 L
.40876 .85621 L
F
.0888 .85871 m
.0888 .8612 L
.0913 .8612 L
.0913 .85871 L
F
.46125 .85871 m
.46125 .8612 L
.46375 .8612 L
.46375 .85871 L
F
.46625 .85871 m
.46625 .8612 L
.46875 .8612 L
.46875 .85871 L
F
.0863 .8612 m
.0863 .8637 L
.0888 .8637 L
.0888 .8612 L
F
.45876 .8612 m
.45876 .8637 L
.46125 .8637 L
.46125 .8612 L
F
.46625 .8612 m
.46625 .8637 L
.46875 .8637 L
.46875 .8612 L
F
.0838 .8637 m
.0838 .8662 L
.0863 .8662 L
.0863 .8637 L
F
.45626 .8637 m
.45626 .8662 L
.45876 .8662 L
.45876 .8637 L
F
.46625 .8637 m
.46625 .8662 L
.46875 .8662 L
.46875 .8637 L
F
.0813 .8662 m
.0813 .8687 L
.0838 .8687 L
.0838 .8662 L
F
.45376 .8662 m
.45376 .8687 L
.45626 .8687 L
.45626 .8662 L
F
.46625 .8662 m
.46625 .8687 L
.46875 .8687 L
.46875 .8662 L
F
.0788 .8687 m
.0788 .8712 L
.0813 .8712 L
.0813 .8687 L
F
.45126 .8687 m
.45126 .8712 L
.45376 .8712 L
.45376 .8687 L
F
.46625 .8687 m
.46625 .8712 L
.46875 .8712 L
.46875 .8687 L
F
.0763 .8712 m
.0763 .8737 L
.0788 .8737 L
.0788 .8712 L
F
.44876 .8712 m
.44876 .8737 L
.45126 .8737 L
.45126 .8712 L
F
.46625 .8712 m
.46625 .8737 L
.46875 .8737 L
.46875 .8712 L
F
.0738 .8737 m
.0738 .8762 L
.0763 .8762 L
.0763 .8737 L
F
.44626 .8737 m
.44626 .8762 L
.44876 .8762 L
.44876 .8737 L
F
.46625 .8737 m
.46625 .8762 L
.46875 .8762 L
.46875 .8737 L
F
.0713 .8762 m
.0713 .8787 L
.0738 .8787 L
.0738 .8762 L
F
.44376 .8762 m
.44376 .8787 L
.44626 .8787 L
.44626 .8762 L
F
.46625 .8762 m
.46625 .8787 L
.46875 .8787 L
.46875 .8762 L
F
.0688 .8787 m
.0688 .8812 L
.0713 .8812 L
.0713 .8787 L
F
.44126 .8787 m
.44126 .8812 L
.44376 .8812 L
.44376 .8787 L
F
.46625 .8787 m
.46625 .8812 L
.46875 .8812 L
.46875 .8787 L
F
.0663 .8812 m
.0663 .8837 L
.0688 .8837 L
.0688 .8812 L
F
.43876 .8812 m
.43876 .8837 L
.44126 .8837 L
.44126 .8812 L
F
.46625 .8812 m
.46625 .8837 L
.46875 .8837 L
.46875 .8812 L
F
.0638 .8837 m
.0638 .8862 L
.0663 .8862 L
.0663 .8837 L
F
.43626 .8837 m
.43626 .8862 L
.43876 .8862 L
.43876 .8837 L
F
.46625 .8837 m
.46625 .8862 L
.46875 .8862 L
.46875 .8837 L
F
.0613 .8862 m
.0613 .8887 L
.0638 .8887 L
.0638 .8862 L
F
.43376 .8862 m
.43376 .8887 L
.43626 .8887 L
.43626 .8862 L
F
.46625 .8862 m
.46625 .8887 L
.46875 .8887 L
.46875 .8862 L
F
.05881 .8887 m
.05881 .8912 L
.0613 .8912 L
.0613 .8887 L
F
.1138 .8887 m
.1138 .8912 L
.1163 .8912 L
.1163 .8887 L
F
.43126 .8887 m
.43126 .8912 L
.43376 .8912 L
.43376 .8887 L
F
.46625 .8887 m
.46625 .8912 L
.46875 .8912 L
.46875 .8887 L
F
.05631 .8912 m
.05631 .8937 L
.05881 .8937 L
.05881 .8912 L
F
.42876 .8912 m
.42876 .8937 L
.43126 .8937 L
.43126 .8912 L
F
.46625 .8912 m
.46625 .8937 L
.46875 .8937 L
.46875 .8912 L
F
.05381 .8937 m
.05381 .8962 L
.05631 .8962 L
.05631 .8937 L
F
.42626 .8937 m
.42626 .8962 L
.42876 .8962 L
.42876 .8937 L
F
.46625 .8937 m
.46625 .8962 L
.46875 .8962 L
.46875 .8937 L
F
.05131 .8962 m
.05131 .8987 L
.05381 .8987 L
.05381 .8962 L
F
.42376 .8962 m
.42376 .8987 L
.42626 .8987 L
.42626 .8962 L
F
.46625 .8962 m
.46625 .8987 L
.46875 .8987 L
.46875 .8962 L
F
.04881 .8987 m
.04881 .9012 L
.05131 .9012 L
.05131 .8987 L
F
.42126 .8987 m
.42126 .9012 L
.42376 .9012 L
.42376 .8987 L
F
.46625 .8987 m
.46625 .9012 L
.46875 .9012 L
.46875 .8987 L
F
.04631 .9012 m
.04631 .9037 L
.04881 .9037 L
.04881 .9012 L
F
.41876 .9012 m
.41876 .9037 L
.42126 .9037 L
.42126 .9012 L
F
.46625 .9012 m
.46625 .9037 L
.46875 .9037 L
.46875 .9012 L
F
.04381 .9037 m
.04381 .9062 L
.04631 .9062 L
.04631 .9037 L
F
.41626 .9037 m
.41626 .9062 L
.41876 .9062 L
.41876 .9037 L
F
.46625 .9037 m
.46625 .9062 L
.46875 .9062 L
.46875 .9037 L
F
.04131 .9062 m
.04131 .9087 L
.04381 .9087 L
.04381 .9062 L
F
.41376 .9062 m
.41376 .9087 L
.41626 .9087 L
.41626 .9062 L
F
.46625 .9062 m
.46625 .9087 L
.46875 .9087 L
.46875 .9062 L
F
.03881 .9087 m
.03881 .9112 L
.04131 .9112 L
.04131 .9087 L
F
.41126 .9087 m
.41126 .9112 L
.41376 .9112 L
.41376 .9087 L
F
.46625 .9087 m
.46625 .9112 L
.46875 .9112 L
.46875 .9087 L
F
.03631 .9112 m
.03631 .9137 L
.03881 .9137 L
.03881 .9112 L
F
.40876 .9112 m
.40876 .9137 L
.41126 .9137 L
.41126 .9112 L
F
.46625 .9112 m
.46625 .9137 L
.46875 .9137 L
.46875 .9112 L
F
.03381 .9137 m
.03381 .9162 L
.03631 .9162 L
.03631 .9137 L
F
.40626 .9137 m
.40626 .9162 L
.40876 .9162 L
.40876 .9137 L
F
.46625 .9137 m
.46625 .9162 L
.46875 .9162 L
.46875 .9137 L
F
.02631 .9162 m
.02631 .9187 L
.02881 .9187 L
.02881 .9162 L
F
.0938 .9162 m
.0938 .9187 L
.0963 .9187 L
.0963 .9162 L
F
.15379 .9162 m
.15379 .9187 L
.15629 .9187 L
.15629 .9162 L
F
.21629 .9162 m
.21629 .9187 L
.21879 .9187 L
.21879 .9162 L
F
.27628 .9162 m
.27628 .9187 L
.27878 .9187 L
.27878 .9162 L
F
.0938 .9187 m
.0938 .9212 L
.0963 .9212 L
.0963 .9187 L
F
.15129 .9187 m
.15129 .9212 L
.15379 .9212 L
.15379 .9187 L
F
.21629 .9187 m
.21629 .9212 L
.21879 .9212 L
.21879 .9187 L
F
.27378 .9187 m
.27378 .9212 L
.27628 .9212 L
.27628 .9187 L
F
.0938 .9212 m
.0938 .9237 L
.0963 .9237 L
.0963 .9212 L
F
.14879 .9212 m
.14879 .9237 L
.15129 .9237 L
.15129 .9212 L
F
.21629 .9212 m
.21629 .9237 L
.21879 .9237 L
.21879 .9212 L
F
.27128 .9212 m
.27128 .9237 L
.27378 .9237 L
.27378 .9212 L
F
.0938 .9237 m
.0938 .9262 L
.0963 .9262 L
.0963 .9237 L
F
.14629 .9237 m
.14629 .9262 L
.14879 .9262 L
.14879 .9237 L
F
.21629 .9237 m
.21629 .9262 L
.21879 .9262 L
.21879 .9237 L
F
.26878 .9237 m
.26878 .9262 L
.27128 .9262 L
.27128 .9237 L
F
.0938 .9262 m
.0938 .9287 L
.0963 .9287 L
.0963 .9262 L
F
.14379 .9262 m
.14379 .9287 L
.14629 .9287 L
.14629 .9262 L
F
.21629 .9262 m
.21629 .9287 L
.21879 .9287 L
.21879 .9262 L
F
.26628 .9262 m
.26628 .9287 L
.26878 .9287 L
.26878 .9262 L
F
.0938 .9287 m
.0938 .9312 L
.0963 .9312 L
.0963 .9287 L
F
.14129 .9287 m
.14129 .9312 L
.14379 .9312 L
.14379 .9287 L
F
.21629 .9287 m
.21629 .9312 L
.21879 .9312 L
.21879 .9287 L
F
.26378 .9287 m
.26378 .9312 L
.26628 .9312 L
.26628 .9287 L
F
.0713 .9312 m
.0713 .9337 L
.0738 .9337 L
.0738 .9312 L
F
.0738 .9312 m
.0738 .9337 L
.0763 .9337 L
.0763 .9312 L
F
.0938 .9312 m
.0938 .9337 L
.0963 .9337 L
.0963 .9312 L
F
.1388 .9312 m
.1388 .9337 L
.14129 .9337 L
.14129 .9312 L
F
.21629 .9312 m
.21629 .9337 L
.21879 .9337 L
.21879 .9312 L
F
.26128 .9312 m
.26128 .9337 L
.26378 .9337 L
.26378 .9312 L
F
.0938 .9337 m
.0938 .9362 L
.0963 .9362 L
.0963 .9337 L
F
.1363 .9337 m
.1363 .9362 L
.1388 .9362 L
.1388 .9337 L
F
.21629 .9337 m
.21629 .9362 L
.21879 .9362 L
.21879 .9337 L
F
.25878 .9337 m
.25878 .9362 L
.26128 .9362 L
.26128 .9337 L
F
.0938 .9362 m
.0938 .9387 L
.0963 .9387 L
.0963 .9362 L
F
.1338 .9362 m
.1338 .9387 L
.1363 .9387 L
.1363 .9362 L
F
.21629 .9362 m
.21629 .9387 L
.21879 .9387 L
.21879 .9362 L
F
.25628 .9362 m
.25628 .9387 L
.25878 .9387 L
.25878 .9362 L
F
.0938 .9387 m
.0938 .94119 L
.0963 .94119 L
.0963 .9387 L
F
.1313 .9387 m
.1313 .94119 L
.1338 .94119 L
.1338 .9387 L
F
.21629 .9387 m
.21629 .94119 L
.21879 .94119 L
.21879 .9387 L
F
.25378 .9387 m
.25378 .94119 L
.25628 .94119 L
.25628 .9387 L
F
.0938 .94119 m
.0938 .94369 L
.0963 .94369 L
.0963 .94119 L
F
.1288 .94119 m
.1288 .94369 L
.1313 .94369 L
.1313 .94119 L
F
.21629 .94119 m
.21629 .94369 L
.21879 .94369 L
.21879 .94119 L
F
.25128 .94119 m
.25128 .94369 L
.25378 .94369 L
.25378 .94119 L
F
.0938 .94369 m
.0938 .94619 L
.0963 .94619 L
.0963 .94369 L
F
.1263 .94369 m
.1263 .94619 L
.1288 .94619 L
.1288 .94369 L
F
.21629 .94369 m
.21629 .94619 L
.21879 .94619 L
.21879 .94369 L
F
.24878 .94369 m
.24878 .94619 L
.25128 .94619 L
.25128 .94369 L
F
.0938 .94619 m
.0938 .94869 L
.0963 .94869 L
.0963 .94619 L
F
.1238 .94619 m
.1238 .94869 L
.1263 .94869 L
.1263 .94619 L
F
.21629 .94619 m
.21629 .94869 L
.21879 .94869 L
.21879 .94619 L
F
.24628 .94619 m
.24628 .94869 L
.24878 .94869 L
.24878 .94619 L
F
.0938 .94869 m
.0938 .95119 L
.0963 .95119 L
.0963 .94869 L
F
.1213 .94869 m
.1213 .95119 L
.1238 .95119 L
.1238 .94869 L
F
.21629 .94869 m
.21629 .95119 L
.21879 .95119 L
.21879 .94869 L
F
.24378 .94869 m
.24378 .95119 L
.24628 .95119 L
.24628 .94869 L
F
.0938 .95119 m
.0938 .95369 L
.0963 .95369 L
.0963 .95119 L
F
.1188 .95119 m
.1188 .95369 L
.1213 .95369 L
.1213 .95119 L
F
.21629 .95119 m
.21629 .95369 L
.21879 .95369 L
.21879 .95119 L
F
.24128 .95119 m
.24128 .95369 L
.24378 .95369 L
.24378 .95119 L
F
.0938 .95369 m
.0938 .95619 L
.0963 .95619 L
.0963 .95369 L
F
.1163 .95369 m
.1163 .95619 L
.1188 .95619 L
.1188 .95369 L
F
.21629 .95369 m
.21629 .95619 L
.21879 .95619 L
.21879 .95369 L
F
.23878 .95369 m
.23878 .95619 L
.24128 .95619 L
.24128 .95369 L
F
.0938 .95619 m
.0938 .95869 L
.0963 .95869 L
.0963 .95619 L
F
.1138 .95619 m
.1138 .95869 L
.1163 .95869 L
.1163 .95619 L
F
.21629 .95619 m
.21629 .95869 L
.21879 .95869 L
.21879 .95619 L
F
.23628 .95619 m
.23628 .95869 L
.23878 .95869 L
.23878 .95619 L
F
.0938 .95869 m
.0938 .96119 L
.0963 .96119 L
.0963 .95869 L
F
.1113 .95869 m
.1113 .96119 L
.1138 .96119 L
.1138 .95869 L
F
.21629 .95869 m
.21629 .96119 L
.21879 .96119 L
.21879 .95869 L
F
.23378 .95869 m
.23378 .96119 L
.23628 .96119 L
.23628 .95869 L
F
.0938 .96119 m
.0938 .96369 L
.0963 .96369 L
.0963 .96119 L
F
.1088 .96119 m
.1088 .96369 L
.1113 .96369 L
.1113 .96119 L
F
.21629 .96119 m
.21629 .96369 L
.21879 .96369 L
.21879 .96119 L
F
.23128 .96119 m
.23128 .96369 L
.23378 .96369 L
.23378 .96119 L
F
.0938 .96369 m
.0938 .96619 L
.0963 .96619 L
.0963 .96369 L
F
.1063 .96369 m
.1063 .96619 L
.1088 .96619 L
.1088 .96369 L
F
.21629 .96369 m
.21629 .96619 L
.21879 .96619 L
.21879 .96369 L
F
.22878 .96369 m
.22878 .96619 L
.23128 .96619 L
.23128 .96369 L
F
.0938 .96619 m
.0938 .96869 L
.0963 .96869 L
.0963 .96619 L
F
.1038 .96619 m
.1038 .96869 L
.1063 .96869 L
.1063 .96619 L
F
.21629 .96619 m
.21629 .96869 L
.21879 .96869 L
.21879 .96619 L
F
.22628 .96619 m
.22628 .96869 L
.22878 .96869 L
.22878 .96619 L
F
.0938 .96869 m
.0938 .97119 L
.0963 .97119 L
.0963 .96869 L
F
.1013 .96869 m
.1013 .97119 L
.1038 .97119 L
.1038 .96869 L
F
.21629 .96869 m
.21629 .97119 L
.21879 .97119 L
.21879 .96869 L
F
.22378 .96869 m
.22378 .97119 L
.22628 .97119 L
.22628 .96869 L
F
.0938 .97119 m
.0938 .97369 L
.0963 .97369 L
.0963 .97119 L
F
.0988 .97119 m
.0988 .97369 L
.1013 .97369 L
.1013 .97119 L
F
.21629 .97119 m
.21629 .97369 L
.21879 .97369 L
.21879 .97119 L
F
.22128 .97119 m
.22128 .97369 L
.22378 .97369 L
.22378 .97119 L
F
.0938 .97369 m
.0938 .97619 L
.0963 .97619 L
.0963 .97369 L
F
.0963 .97369 m
.0963 .97619 L
.0988 .97619 L
.0988 .97369 L
F
.21629 .97369 m
.21629 .97619 L
.21879 .97619 L
.21879 .97369 L
F
.21879 .97369 m
.21879 .97619 L
.22128 .97619 L
.22128 .97369 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"ArrayPlot"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArrayQ", "ObjectName",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " if ",
  StyleBox["expr", "TI"],
  " is a full array or a ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  " object, and gives ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  " otherwise. \n\[FilledSmallSquare] ",
  StyleBox["ArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["patt", "TI"],
  StyleBox["]", "MR"],
  " requires ",
  StyleBox["expr", "TI"],
  " to be a full array with a depth that matches the pattern ",
  StyleBox["patt", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["patt", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["test", "TI"],
  StyleBox["]", "MR"],
  " requires also that ",
  StyleBox["test", "TI"],
  " yield ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " when applied to each of the array elements in ",
  StyleBox["expr", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell["\<\
\[FilledSmallSquare] In a full array all parts at a particular \
level must be lists of the same length. \
\>", "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["1|2]", "MR"],
  " tests whether ",
  StyleBox["expr", "TI"],
  " is either a vector or a matrix. "
}], "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["_,", "MR"],
  " ",
  StyleBox["NumberQ]", "MR"],
  " tests whether ",
  StyleBox["expr", "TI"],
  " is a numerical array at all levels. "
}], "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.5",
    ButtonData:>{"2.3.5", "5.20"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.4.3",
    ButtonData:>{"2.4.3", "3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ArrayDepth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["MatrixQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["VectorQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Dimensions",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Advanced Documentation",
    ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2], 
        FrontEnd`HelpBrowserLookup[ 
        "RefGuide", "Advanced Documentation: Linear Algebra"]}]&),
    ButtonData:>{
      FrontEnd`FileName[ {$InstallationDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "t:13"},
    Active->True,
    ButtonStyle->"RefGuideLinkText",
    ButtonNote->"Advanced Documentation"],
  ". "
}], "Notes",
  CellTags->{"S0.1050", "ArrayQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArrayQ"],

Cell["Here is a matrix; any matrix is a full array. ", "ExampleText",
  CellTags->"ArrayQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\[ScriptT]1 = {{1, 2}, {3, 4}})\) // MatrixForm\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2"},
            {"3", "4"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[1]//MatrixForm= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[\[ScriptT]1]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\[ScriptT]1]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell["Here is a full array that is not a matrix. ", "ExampleText",
  CellTags->"ArrayQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\[ScriptT]2 = {{{1, 2}, {3, 4}}, {{4, 5}, {5, 6}}})\) // 
      MatrixForm\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"1"},
                      {"2"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"3"},
                      {"4"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"4"},
                      {"5"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", 
                TagBox[GridBox[{
                      {"5"},
                      {"6"}
                      },
                    RowSpacings->1,
                    ColumnAlignments->{Left}],
                  Column], "\[NoBreak]", ")"}]}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[\[ScriptT]2]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\[ScriptT]2]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[TextData[{
  "The array depth of ",
  Cell[BoxData[
      \(\[ScriptT]2\)], "InlineFormula"],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"ArrayQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\[ScriptT]2, 3]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayDepth[\[ScriptT]2]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(\[ScriptT]2\)], "InlineFormula"],
  " is an integer array at all levels. "
}], "ExampleText",
  CellTags->"ArrayQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\[ScriptT]2, _, IntegerQ]\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"ArrayQ"]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(\[ScriptT]2\)], "InlineFormula"],
  " is a full array with depth ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  " with integer entries. "
}], "ExampleText",
  CellTags->"ArrayQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\[ScriptT]2, 3, IntegerQ]\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"ArrayQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"ArrayQ"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArrayRules", "ObjectName",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayRules[SparseArray[", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  " gives the rules ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["pos",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["->", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["pos",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["->", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " specifying elements in a sparse array. \n\[FilledSmallSquare] ",
  StyleBox["ArrayRules[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " gives rules for ",
  StyleBox["SparseArray[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Usage",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] The last element of ",
  StyleBox["ArrayRules[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " is always ",
  StyleBox["{_,", "MR"],
  " ",
  StyleBox["_,", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["def", "TI"],
  ", where ",
  StyleBox["def", "TI"],
  " is the default value for unspecified elements in the sparse array. "
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayRules[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["val", "TI"],
  StyleBox["]", "MR"],
  " takes the default value to be ",
  StyleBox["val", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ArrayRules[", "MR"],
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " assumes a default value of ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.7.2",
    ButtonData:>{"3.7.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.7.12",
    ButtonData:>{"3.7.12", "12.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Position",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Normal",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Advanced Documentation",
    ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2], 
        FrontEnd`HelpBrowserLookup[ 
        "RefGuide", "Advanced Documentation: Linear Algebra"]}]&),
    ButtonData:>{
      FrontEnd`FileName[ {$InstallationDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "t:124"},
    Active->True,
    ButtonStyle->"RefGuideLinkText",
    ButtonNote->"Advanced Documentation"],
  ". "
}], "Notes",
  CellTags->{"S0.1051", "ArrayRules"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"ArrayRules"],

Cell[TextData[{
  "See the Further Examples for ",
  ButtonBox["SparseArray",
    ButtonStyle->"RefGuideLink"],
  "."
}], "ExampleText",
  CellTags->"ArrayRules"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AspectRatio", "ObjectName",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AspectRatio", "MR"],
  " is an option for ",
  ButtonBox["Graphics",
    ButtonStyle->"RefGuideLink"],
  " and related functions which specifies the ratio of height to width for a \
plot. "
}], "Usage",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AspectRatio", "MR"],
  " determines the scaling for the final image shape. "
}], "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " determines the ratio of height to width from the actual coordinate values \
in the plot. "
}], "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default value ",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["1/GoldenRatio", "MR"],
  " is used for two\[Hyphen]dimensional plots. ",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " is used for three\[Hyphen]dimensional plots. "
}], "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.9.6",
    ButtonData:>{"1.9.6", "6.4"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.10.2",
    ButtonData:>{"2.10.2", "2.14"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.4",
    ButtonData:>{"2.10.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BoxRatios",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PlotRegion",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Options",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AbsoluteOptions",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1052", "AspectRatio"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AspectRatio"],

Cell[TextData[{
  "The default setting of ",
  StyleBox["AspectRatio", "MR"],
  " is ",
  StyleBox["GoldenRatio", "MR"],
  ". Setting the option to ",
  StyleBox["Automatic", "MR"],
  " makes the height\[Hyphen]to\[Hyphen]width ratio ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AspectRatio"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Circle[{0, 0}, 1]]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AspectRatio"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.47619 0.294302 scale
1.05 1.05001 1 0 365.73 arc
setmatrix s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AspectRatio"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[Circle[{0, 0}, 1], 
        AspectRatio \[Rule] Automatic]]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AspectRatio"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .47619 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AspectRatio"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AspectRatioFixed", "ObjectName",
  CellTags->{"S0.1053", "AspectRatioFixed"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AspectRatioFixed", "MR"],
  " is an option for ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " which specifies whether graphics in the cell should be constrained to \
stay the same shape when they are interactively resized using the front end. \
"
}], "Usage",
  CellTags->{"S0.1053", "AspectRatioFixed"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["AspectRatioFixed->False", "MR"],
  ", the shape of an image is determined by the setting for ",
  ButtonBox["ImageSize",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1053", "AspectRatioFixed"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1053", "AspectRatioFixed"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ImageSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AspectRatio",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1053", "AspectRatioFixed"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1053", "AspectRatioFixed"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assuming", "ObjectName",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Assuming[", "MR"],
  StyleBox["assum", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " evaluates ",
  StyleBox["expr", "TI"],
  " with ",
  StyleBox["assum", "TI"],
  " appended to ",
  ButtonBox["$Assumptions",
    ButtonStyle->"RefGuideLink"],
  ", so that ",
  StyleBox["assum", "TI"],
  " is included in the default assumptions used by functions such as ",
  ButtonBox["Refine",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Integrate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Usage",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Assuming", "MR"],
  " affects the default assumptions for all functions that have an ",
  ButtonBox["Assumptions",
    ButtonStyle->"RefGuideLink"],
  " option. "
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell["\<\
\[FilledSmallSquare] The assumptions can be equations, inequalities \
or domain specifications, or lists or logical combinations of these. \
\>", \
"Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] Assumptions from nested invocations of ",
  StyleBox["Assuming", "MR"],
  " are combined. "
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Assuming[", "MR"],
  StyleBox["assum", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " is effectively equivalent to ",
  StyleBox["Block[{$Assumptions", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["$Assumptions", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["assum", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Assuming", "MR"],
  " converts lists of assumptions ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". "
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.3.11",
    ButtonData:>{"3.3.11", "11.33"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Block",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Module",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Refine",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Reduce",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1054", "Assuming"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Assuming"],

Cell[TextData[{
  "If ",
  StyleBox["$Assumptions", "MR"],
  " has no effect on ",
  StyleBox["ff", "MR"],
  ", which would be the case by default, then ",
  StyleBox["ff", "MR"],
  " pulls out positive numeric factors. "
}], "ExampleText",
  CellTags->"Assuming"],

Cell[BoxData[
    \(ff[a_?\((Refine[# > 0] &)\) x_] := a  ff[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Assuming"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ff[3\ \[Pi]\ a\ \[ExponentialE]\^b\ x\ y]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Assuming"],

Cell[BoxData[
    \(3\ \[Pi]\ ff[a\ \[ExponentialE]\^b\ x\ y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Assuming"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["ff", "MR"],
  " is used inside ",
  StyleBox["Assuming", "MR"],
  " it also pulls out symbolic factors which are assumed to be positive. "
}], "ExampleText",
  CellTags->"Assuming"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Assuming[a > 0 && b \[Element] Reals, 
      ff[3\ \[Pi]\ a\ \[ExponentialE]\^b\ x\ y]]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Assuming"],

Cell[BoxData[
    \(3\ a\ \[ExponentialE]\^b\ \[Pi]\ ff[x\ y]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Assuming"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Refine[\[ExponentialE]\^b > 0, b \[Element] Reals]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Assuming"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Assuming"]
}, Open  ]],

Cell[BoxData[
    \(Clear[ff]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Assuming"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assumptions", "ObjectName",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Assumptions", "MR"],
  " is an option for functions such as ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Refine",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Integrate",
    ButtonStyle->"RefGuideLink"],
  " which specifies default assumptions to be made about symbolic quantities. \
"
}], "Usage",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Assumptions:>$Assumptions", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell["\<\
\[FilledSmallSquare] The assumptions can be equations, inequalities \
or domain specifications, or lists or logical combinations of these. \
\>", \
"Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Assuming",
    ButtonStyle->"RefGuideLink"],
  " modifies ",
  ButtonBox["$Assumptions",
    ButtonStyle->"RefGuideLink"],
  " and so modifies the value of default settings for ",
  StyleBox["Assumptions", "MR"],
  " options. "
}], "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Reals", "MR"],
  " can be used to specify that ",
  StyleBox["x", "TI"],
  " should be treated as a real variable. "
}], "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.5.8",
    ButtonData:>{"3.5.8", "8.26"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Assuming",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$Assumptions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GenerateConditions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Integrate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Refine",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Limit",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell["\<\
\[FilledSmallSquare] New in Version 3; modified in 5.\
\>", "Notes",
  CellTags->{"S0.1055", "Assumptions"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Assumptions"],

Cell[TextData[{
  " See the Further Examples for ",
  ButtonBox["Integrate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "ExampleText",
  CellTags->"Assumptions"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AtomQ", "ObjectName",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AtomQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " yields ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " if ",
  StyleBox["expr", "TI"],
  " is an expression which cannot be divided into subexpressions, and yields \
",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  " otherwise. "
}], "Usage",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["AtomQ", "MR"],
  " in a recursive procedure to tell when you have reached the bottom of the \
tree corresponding to an expression. "
}], "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AtomQ", "MR"],
  " gives ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " for symbols, numbers, strings and other raw objects, such as sparse \
arrays. "
}], "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AtomQ", "MR"],
  " gives ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " for any object whose subparts cannot be accessed using functions like ",
  ButtonBox["Map",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.5",
    ButtonData:>{"2.3.5", "5.27"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["NumberQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Head",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LeafCount",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Length",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 5.\
\>", "Notes",
  CellTags->{"S0.1056", "AtomQ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AtomQ"],

Cell["\<\
Integers, complex numbers, strings, and symbols are all atoms; a \
list is not an atom. \
\>", "ExampleText",
  CellTags->"AtomQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AtomQ /@ {3, 
        2.1 + 0.2  \[ImaginaryI], "\<{1,2}\>", \[Pi], {1, 2}}\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AtomQ"],

Cell[BoxData[
    \({True, True, True, True, False}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"AtomQ"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Attributes", "ObjectName",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Attributes[", "MR"],
  StyleBox["symbol", "TI"],
  StyleBox["]", "MR"],
  " gives the list of attributes for a symbol. "
}], "Usage",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] The attributes of a symbol can be set by assigning a \
value to ",
  StyleBox["Attributes[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  ". If a single attribute is assigned, it need not be in a list. "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Attributes[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["{}", "MR"],
  " clears all attributes of a symbol. "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Attributes[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " gives a list of the attributes for each of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Attributes[\"", "MR"],
  StyleBox["str", "TI"],
  StyleBox["\"]", "MR"],
  " gives a list of the attributes for all symbols which match the string \
pattern ",
  StyleBox["str", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Attributes[HoldPattern[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]]", "MR"],
  " is treated as equivalent to ",
  StyleBox["Attributes[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell["\<\
\[FilledSmallSquare] Attributes for functions must be set before \
any definitions that involve the functions are given. \
\>", "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] The complete list of possible attributes for a symbol \
",
  StyleBox["f", "TI"],
  " is: "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              ButtonBox["Constant",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "all derivatives of ",
              StyleBox["f", "TI"],
              " are zero "
            }]]},
          {Cell[TextData[{
              ButtonBox["Flat",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " is associative "
            }]]},
          {Cell[TextData[{
              ButtonBox["HoldAll",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "all the arguments of ",
              StyleBox["f", "TI"],
              " are not evaluated"
            }]]},
          {Cell[TextData[{
              ButtonBox["HoldAllComplete",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the arguments of ",
              StyleBox["f", "TI"],
              " are completely shielded from evaluation "
            }]]},
          {Cell[TextData[{
              ButtonBox["HoldFirst",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the first argument of ",
              StyleBox["f", "TI"],
              " is not evaluated "
            }]]},
          {Cell[TextData[{
              ButtonBox["HoldRest",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "all but the first argument of ",
              StyleBox["f", "TI"],
              " are not evaluated "
            }]]},
          {Cell[TextData[{
              ButtonBox["Listable",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              
              " is automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over lists "
            }]]},
          {Cell[TextData[{
              ButtonBox["Locked",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "attributes of ",
              StyleBox["f", "TI"],
              " cannot be changed "
            }]]},
          {Cell[TextData[{
              ButtonBox["NHoldAll",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the arguments of ",
              StyleBox["f", "TI"],
              " are not affected by ",
              ButtonBox["N",
                ButtonStyle->"RefGuideLink"],
              " "
            }]]},
          {Cell[TextData[{
              ButtonBox["NHoldFirst",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the first argument of ",
              StyleBox["f", "TI"],
              " is not affected by ",
              ButtonBox["N",
                ButtonStyle->"RefGuideLink"],
              " "
            }]]},
          {Cell[TextData[{
              ButtonBox["NHoldRest",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "all but the first argument of ",
              StyleBox["f", "TI"],
              " are not affected by ",
              ButtonBox["N",
                ButtonStyle->"RefGuideLink"],
              " "
            }]]},
          {Cell[TextData[{
              ButtonBox["NumericFunction",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "the value of ",
              StyleBox["f", "TI"],
              " is assumed to be a number when its arguments are numbers "
            }]]},
          {Cell[TextData[{
              ButtonBox["OneIdentity",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              ", ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]]", "MR"],
              ", etc. are equivalent to ",
              StyleBox["a", "TI"],
              " in pattern matching "
            }]]},
          {Cell[TextData[{
              ButtonBox["Orderless",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " is commutative "
            }]]},
          {Cell[TextData[{
              ButtonBox["Protected",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "values of ",
              StyleBox["f", "TI"],
              " cannot be changed "
            }]]},
          {Cell[TextData[{
              ButtonBox["ReadProtected",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              "values of ",
              StyleBox["f", "TI"],
              " cannot be read "
            }]]},
          {Cell[TextData[{
              ButtonBox["SequenceHold",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Sequence",
                ButtonStyle->"RefGuideLink"],
              " objects in the arguments of ",
              StyleBox["f", "TI"],
              " are not flattened out "
            }]]},
          {Cell[TextData[{
              ButtonBox["Stub",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["Needs",
                ButtonStyle->"RefGuideLink"],
              " is automatically called if the symbol is ever input "
            }]]},
          {Cell[TextData[{
              ButtonBox["Temporary",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " is a local variable, removed when no longer used "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"Attributes", "S0.1057"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.7",
    ButtonData:>{"2.3.7", "7.9"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.6.3",
    ButtonData:>{"2.6.3", "3.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["SetAttributes",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ClearAttributes",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell["\<\
\[FilledSmallSquare] New in Version 1; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1057", "Attributes"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Attributes"],

Cell[TextData[{
  "This gives the attributes of ",
  StyleBox["Plus", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Attributes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[Plus]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Attributes"],

Cell[BoxData[
    \({Flat, Listable, NumericFunction, OneIdentity, Orderless, 
      Protected}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Attributes"]
}, Open  ]],

Cell[TextData[{
  "Here are the attributes of ",
  StyleBox["Log", "MR"],
  " and of ",
  StyleBox["Integrate", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Attributes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[{Log, Integrate}]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Attributes"],

Cell[BoxData[
    \({{Listable, NumericFunction, Protected}, {Protected, 
        ReadProtected}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Attributes"]
}, Open  ]],

Cell[TextData[{
  "Here is the list of all attributes of built\[Hyphen]in functions that \
appear in the ",
  StyleBox["System`", "MR"],
  " context. "
}], "ExampleText",
  CellTags->"Attributes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[Flatten[Attributes /@ Names["\<*\>"]]]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Attributes"],

Cell[BoxData[
    \({Constant, Flat, HoldAll, HoldAllComplete, HoldFirst, HoldRest, 
      Listable, Locked, NHoldAll, NHoldFirst, NHoldRest, NumericFunction, 
      OneIdentity, Orderless, Protected, ReadProtected, SequenceHold, 
      Temporary}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Attributes"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AutoIndent", "ObjectName",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoIndent", "MR"],
  " is an option for ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " which specifies what automatic indentation should be done at the \
beginning of a new line after an explicit return character has been entered. \
"
}], "Usage",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings for ",
  StyleBox["AutoIndent", "MR"],
  " are: "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              ButtonBox["False",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["do no indentation "]},
          {Cell[TextData[{
              ButtonBox["True",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["indent the same as the previous line "]},
          {Cell[TextData[{
              ButtonBox["Automatic",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], 
            Cell["\<\
indent according to the structure of the expression \
(default) \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"AutoIndent", "S0.1058"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["AutoIndent->True", "MR"],
  ", tabs or spaces used for indentation on the previous line are explicitly \
inserted at the beginning of the new line. "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["AutoIndent->Automatic", "MR"],
  ", line breaks are always indicated by an \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"],
  " character even if they were originally entered using ",
  Cell[BoxData[
      \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
  " or \[Backslash]",
  StyleBox["[NewLine]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] Indentation after an \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"],
  " is automatically redone every time an expression is displayed. "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] The amount of indentation after an \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"],
  " is determined by the settings for the ",
  ButtonBox["LineIndent",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["LineIndentMaxFraction",
    ButtonStyle->"RefGuideLink"],
  " options. "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LineIndent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ParagraphIndent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowAutoStyles",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1058", "AutoIndent"}],

Cell["\<\
\[FilledSmallSquare] New in Version 3; modified in 4.\
\>", "Notes",
  CellTags->{"S0.1058", "AutoIndent"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["AutoItalicWords", "ObjectName",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoItalicWords", "MR"],
  " is an option for ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " which gives a list of words which should automatically be put in italics \
when they are entered. "
}], "Usage",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical settings for ",
  StyleBox["AutoItalicWords", "MR"],
  " include ",
  StyleBox["\"Mathematica\"", "MR"],
  " and ",
  StyleBox["\"MathLink\"", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoItalicWords", "MR"],
  " affects only ordinary text strings, not elements of more general \
expressions. "
}], "Notes",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["FontSlant",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SingleLetterItalics",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1059", "AutoItalicWords"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1059", "AutoItalicWords"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic", "ObjectName",
  CellTags->{"S0.1060", "Automatic"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Automatic", "MR"],
  " represents an option value that is to be chosen automatically by a built\
\[Hyphen]in function. "
}], "Usage",
  CellTags->{"S0.1060", "Automatic"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1060", "Automatic"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["All",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1060", "Automatic"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1060", "Automatic"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Automatic"],

Cell[TextData[{
  "This draws a circle first with the default settings for all options and \
then with two options set to ",
  StyleBox["Automatic", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Automatic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Circle[{0, 0}, 1]]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Automatic"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.47619 0.294302 scale
1.05 1.05001 1 0 365.73 arc
setmatrix s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Automatic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[Circle[{0, 0}, 1], Axes \[Rule] Automatic, 
        AspectRatio \[Rule] Automatic]]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Automatic"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -12 -9 ]
[.2619 .4875 12 0 ]
[.7381 .4875 -9 -9 ]
[.7381 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -24 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -18 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-1)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-0.5)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(0.5)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(1)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-1)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-0.5)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(0.5)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(1)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
newpath
.5 .5 .47619 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Automatic"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AutoSpacing", "ObjectName",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing", "MR"],
  " is an option for ",
  ButtonBox["StyleBox",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " which specifies whether spaces between successive characters should be \
adjusted automatically. "
}], "Usage",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing->False", "MR"],
  " leaves equal spaces between all characters. "
}], "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing->True", "MR"],
  " inserts additional space around lower\[Hyphen]precedence operators. "
}], "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing->False", "MR"],
  " is in effect automatically used inside ordinary strings and comments. "
}], "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1061", "AutoSpacing"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Axes", "ObjectName",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Axes", "MR"],
  " is an option for graphics functions that specifies whether axes should be \
drawn. "
}], "Usage",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Axes", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " draws all axes. "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Axes", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  " draws no axes. "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Axes", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{False,", "MR"],
  " ",
  StyleBox["True}", "MR"],
  " draws a ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis but no ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis in two dimensions. "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] In two dimensions, axes are drawn to cross at the \
position specified by the option ",
  ButtonBox["AxesOrigin",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] In three dimensions, axes are drawn on the edges of \
the bounding box specified by the option ",
  ButtonBox["AxesEdge",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.9.6",
    ButtonData:>{"1.9.6", "6.4"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.10.5",
    ButtonData:>{"2.10.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.13",
    ButtonData:>{"2.10.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["AxesLabel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Frame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GridLines",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Boxed",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1062", "Axes"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Axes"],

Cell[TextData[{
  "This draws a circle of radius ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", centered at the origin, first without axes and then with axes. "
}], "ExampleText",
  CellTags->"Axes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[Circle[{0, 0}, 1], 
        AspectRatio \[Rule] Automatic]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Axes"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .47619 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Axes"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[Circle[{0, 0}, 1], AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic]]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Axes"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -12 -9 ]
[.2619 .4875 12 0 ]
[.7381 .4875 -9 -9 ]
[.7381 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -24 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -18 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-1)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-0.5)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(0.5)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(1)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-1)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-0.5)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(0.5)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(1)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
newpath
.5 .5 .47619 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Axes"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AxesEdge", "ObjectName",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesEdge", "MR"],
  " is an option for three\[Hyphen]dimensional graphics functions that \
specifies on which edges of the bounding box axes should be drawn. "
}], "Usage",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesEdge->{{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["y",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["y",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}}", "MR"],
  " specifies on which three edges of the bounding box axes are drawn. The ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " must be either ",
  StyleBox["+1", "MR"],
  " or ",
  StyleBox["-1", "MR"],
  ", and specify whether axes are drawn on the edge of the box with a larger \
or smaller value of coordinate ",
  StyleBox["i", "TI"],
  ", respectively. "
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting ",
  StyleBox["AxesEdge->Automatic", "MR"],
  " chooses automatically on which exposed box edges axes should be drawn. "
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any pair ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["j",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " in the setting for ",
  StyleBox["AxesEdge", "MR"],
  " can be replaced by ",
  ButtonBox["Automatic",
    ButtonStyle->"RefGuideLink"],
  " to specify that the position of the corresponding axis is to be chosen \
automatically. "
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any pair ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["j",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " can be replaced by ",
  ButtonBox["None",
    ButtonStyle->"RefGuideLink"],
  ", in which case the corresponding axis will not be drawn. "
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell["\<\
\[FilledSmallSquare] If you explicitly specify on which edge to \
draw an axis, the axis will be drawn on that edge, whether or not the edge is \
exposed with the view point you have chosen. \
\>", "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.13",
    ButtonData:>{"2.10.13", "13.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Axes",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AxesOrigin",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1063", "AxesEdge"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AxesEdge"],

Cell["Compare the placement of the axes in these two plots. ", "ExampleText",
  CellTags->"AxesEdge"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, \[Pi]}, {y, 0, \[Pi]}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AxesEdge"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.2902e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.2187 .17096 -5.81399 -9 ]
[.2187 .17096 .18601 0 ]
[.42503 .08982 -5.4158 -9 ]
[.42503 .08982 .5842 0 ]
[.64842 .00203 -5.01761 -9 ]
[.64842 .00203 .98239 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80399 .15298 0 -6.10779 ]
[.80399 .15298 6 2.89221 ]
[.89336 .28984 0 -5.97836 ]
[.89336 .28984 6 3.02164 ]
[.97161 .40968 0 -5.86822 ]
[.97161 .40968 6 3.13178 ]
[.02412 .26509 -12 -2.7423 ]
[.02412 .26509 0 6.2577 ]
[.01568 .31794 -24 -2.78699 ]
[.01568 .31794 0 6.21301 ]
[.00696 .37263 -6 -2.83339 ]
[.00696 .37263 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.22768 .18054 m
.23217 .18532 L
s
[(1)] .2187 .17096 .938 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(2)] .42503 .08982 .80527 1 Mshowa
.65575 .01292 m
.65941 .01836 L
s
[(3)] .64842 .00203 .67254 1 Mshowa
.125 Mabswid
.07414 .24066 m
.07698 .24338 L
s
.11167 .22596 m
.11448 .22872 L
s
.14976 .21105 m
.15253 .21384 L
s
.18843 .19591 m
.19116 .19874 L
s
.26753 .16493 m
.27019 .16784 L
s
.30801 .14908 m
.31061 .15203 L
s
.34911 .13299 m
.35167 .13598 L
s
.39085 .11664 m
.39337 .11967 L
s
.47634 .08317 m
.47875 .08628 L
s
.52011 .06603 m
.52247 .06918 L
s
.56459 .04861 m
.5669 .0518 L
s
.60979 .03091 m
.61205 .03414 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79163 .1574 m
.78546 .15961 L
s
[(1)] .80399 .15298 -1 .35729 Mshowa
.88089 .29393 m
.87466 .29598 L
s
[(2)] .89336 .28984 -1 .32852 Mshowa
.95906 .4135 m
.95278 .41541 L
s
[(3)] .97161 .40968 -1 .30405 Mshowa
.125 Mabswid
.71056 .03337 m
.70688 .03479 L
s
.73173 .06576 m
.72804 .06715 L
s
.75228 .0972 m
.74859 .09856 L
s
.77224 .12773 m
.76854 .12908 L
s
.81049 .18623 m
.80677 .18754 L
s
.82882 .21427 m
.8251 .21556 L
s
.84665 .24155 m
.84292 .24282 L
s
.864 .26809 m
.86027 .26934 L
s
.89734 .3191 m
.8936 .32031 L
s
.91337 .34361 m
.90962 .34481 L
s
.92899 .3675 m
.92523 .36868 L
s
.94421 .39079 m
.94045 .39195 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26032 m
.04245 .25793 L
s
[(-1)] .02412 .26509 1 -0.3906 Mshowa
.02795 .31327 m
.03408 .31094 L
s
[(-0.5)] .01568 .31794 1 -0.38067 Mshowa
.01926 .36807 m
.02542 .36579 L
s
[(0)] .00696 .37263 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27077 m
.03835 .26934 L
s
.03302 .28128 m
.03669 .27986 L
s
.03134 .29187 m
.03501 .29046 L
s
.02965 .30254 m
.03333 .30113 L
s
.02623 .32408 m
.02992 .32269 L
s
.02451 .33496 m
.02819 .33358 L
s
.02277 .34592 m
.02646 .34454 L
s
.02102 .35696 m
.02471 .35559 L
s
.01749 .37926 m
.02118 .3779 L
s
.0157 .39053 m
.0194 .38918 L
s
.0139 .40188 m
.0176 .40054 L
s
.01209 .41331 m
.0158 .41197 L
s
.00843 .43642 m
.01214 .43509 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.821 .348 0 r
.38853 .69036 .40169 .70185 .4225 .73657 .40935 .72353 Metetra
.695 .197 0 r
.40935 .72353 .4225 .73657 .44414 .76533 .43098 .75147 Metetra
0 .231 .729 r
.43098 .75147 .44414 .76533 .4666 .78174 .45345 .76844 Metetra
.464 .662 .947 r
.45345 .76844 .4666 .78174 .48971 .7814 .47662 .7703 Metetra
.763 .788 .874 r
.47662 .7703 .48971 .7814 .51315 .76307 .50022 .75549 Metetra
.875 .826 .796 r
.50022 .75549 .51315 .76307 .53658 .72898 .5239 .72542 Metetra
.928 .85 .746 r
.5239 .72542 .53658 .72898 .55974 .68424 .5474 .68412 Metetra
.954 .871 .717 r
.5474 .68412 .55974 .68424 .58252 .63566 .57057 .63736 Metetra
.962 .894 .713 r
.57057 .63736 .58252 .63566 .605 .5903 .5934 .59145 Metetra
.951 .916 .742 r
.5934 .59145 .605 .5903 .62744 .55427 .61608 .55218 Metetra
.905 .924 .819 r
.61608 .55218 .62744 .55427 .65017 .53194 .63888 .52412 Metetra
.768 .855 .915 r
.63888 .52412 .65017 .53194 .67359 .5256 .66216 .5101 Metetra
.518 .645 .913 r
.66216 .5101 .67359 .5256 .69805 .53525 .68627 .51111 Metetra
.31 .429 .821 r
.68627 .51111 .69805 .53525 .72376 .55863 .71148 .52619 Metetra
.22 .312 .746 r
.71148 .52619 .72376 .55863 .75074 .5913 .73795 .55248 Metetra
.208 .275 .713 r
.73795 .55248 .75074 .5913 .77874 .62707 .76559 .58539 Metetra
.24 .287 .71 r
.76559 .58539 .77874 .62707 .80729 .65874 .79413 .61902 Metetra
.301 .337 .732 r
.79413 .61902 .80729 .65874 .83567 .67932 .82303 .6469 Metetra
.396 .434 .783 r
.82303 .6469 .83567 .67932 .86313 .68347 .85162 .66309 Metetra
.552 .62 .873 r
.85162 .66309 .86313 .68347 .88906 .66891 .87921 .66337 Metetra
.779 .936 .932 r
.87921 .66337 .88906 .66891 .91317 .63697 .90527 .64627 Metetra
.626 .852 .475 r
.90527 .64627 .91317 .63697 .93561 .59228 .92958 .61346 Metetra
.92958 .61346 .93561 .59228 .95693 .5416 .95231 .56932 Metetra
0 0 .09 r
.95231 .56932 .95693 .5416 .97797 .49234 .97398 .51991 Metetra
.802 .321 0 r
.37517 .6787 .38853 .69036 .40935 .72353 .396 .71029 Metetra
.672 .173 0 r
.396 .71029 .40935 .72353 .43098 .75147 .41763 .73733 Metetra
0 .216 .717 r
.41763 .73733 .43098 .75147 .45345 .76844 .44012 .75468 Metetra
.402 .628 .945 r
.44012 .75468 .45345 .76844 .47662 .7703 .46333 .75851 Metetra
.724 .776 .894 r
.46333 .75851 .47662 .7703 .50022 .75549 .48705 .74703 Metetra
.854 .824 .819 r
.48705 .74703 .50022 .75549 .5239 .72542 .51096 .72099 Metetra
.916 .852 .765 r
.51096 .72099 .5239 .72542 .5474 .68412 .53479 .68343 Metetra
.948 .875 .731 r
.53479 .68343 .5474 .68412 .57057 .63736 .55833 .63912 Metetra
.961 .897 .717 r
.55833 .63912 .57057 .63736 .5934 .59145 .58154 .59358 Metetra
.957 .919 .73 r
.58154 .59358 .5934 .59145 .61608 .55218 .60452 .55217 Metetra
.93 .935 .784 r
.60452 .55217 .61608 .55218 .63888 .52412 .62747 .51941 Metetra
.848 .91 .877 r
.62747 .51941 .63888 .52412 .66216 .5101 .65072 .49853 Metetra
.662 .77 .93 r
.65072 .49853 .66216 .5101 .68627 .51111 .67458 .49122 Metetra
.438 .55 .872 r
.67458 .49122 .68627 .51111 .71148 .52619 .69936 .49758 Metetra
.301 .39 .787 r
.69936 .49758 .71148 .52619 .73795 .55248 .72529 .51606 Metetra
.251 .314 .734 r
.72529 .51606 .73795 .55248 .76559 .58539 .75244 .54356 Metetra
.253 .295 .712 r
.75244 .54356 .76559 .58539 .79413 .61902 .78068 .57562 Metetra
.285 .313 .714 r
.78068 .57562 .79413 .61902 .82303 .6469 .8097 .60681 Metetra
.341 .364 .739 r
.8097 .60681 .82303 .6469 .85162 .66309 .83897 .63145 Metetra
.429 .461 .792 r
.83897 .63145 .85162 .66309 .87921 .66337 .86784 .64448 Metetra
.577 .654 .888 r
.86784 .64448 .87921 .66337 .90527 .64627 .8957 .6425 Metetra
.771 .968 .925 r
.8957 .6425 .90527 .64627 .92958 .61346 .92206 .62451 Metetra
.92206 .62451 .92958 .61346 .95231 .56932 .94674 .59213 Metetra
0 0 .001 r
.94674 .59213 .95231 .56932 .97398 .51991 .96989 .54929 Metetra
.78 .29 0 r
.36161 .66686 .37517 .6787 .396 .71029 .38246 .69684 Metetra
.646 .144 0 r
.38246 .69684 .396 .71029 .41763 .73733 .4041 .72289 Metetra
0 .209 .711 r
.4041 .72289 .41763 .73733 .44012 .75468 .42659 .74047 Metetra
.342 .594 .939 r
.42659 .74047 .44012 .75468 .46333 .75851 .44984 .74601 Metetra
.679 .759 .912 r
.44984 .74601 .46333 .75851 .48705 .74703 .47366 .73766 Metetra
.827 .819 .842 r
.47366 .73766 .48705 .74703 .51096 .72099 .49777 .71557 Metetra
.9 .853 .786 r
.49777 .71557 .51096 .72099 .53479 .68343 .52188 .68198 Metetra
.94 .878 .748 r
.52188 .68198 .53479 .68343 .55833 .63912 .54579 .64068 Metetra
.958 .901 .725 r
.54579 .64068 .55833 .63912 .58154 .59358 .5694 .59637 Metetra
.959 .923 .725 r
.5694 .59637 .58154 .59358 .60452 .55217 .59272 .5539 Metetra
.943 .941 .757 r
.59272 .5539 .60452 .55217 .62747 .51941 .61591 .5176 Metetra
.896 .941 .833 r
.61591 .5176 .62747 .51941 .65072 .49853 .63923 .49087 Metetra
.776 .866 .915 r
.63923 .49087 .65072 .49853 .67458 .49122 .66295 .47591 Metetra
.578 .683 .912 r
.66295 .47591 .67458 .49122 .69936 .49758 .6874 .47359 Metetra
.405 .493 .836 r
.6874 .47359 .69936 .49758 .72529 .51606 .71283 .48344 Metetra
.315 .376 .766 r
.71283 .48344 .72529 .51606 .75244 .54356 .73941 .50366 Metetra
.286 .324 .726 r
.73941 .50366 .75244 .54356 .78068 .57562 .76717 .53115 Metetra
.293 .314 .712 r
.76717 .53115 .78068 .57562 .8097 .60681 .79596 .56176 Metetra
.322 .333 .717 r
.79596 .56176 .8097 .60681 .83897 .63145 .82544 .59064 Metetra
.371 .382 .742 r
.82544 .59064 .83897 .63145 .86784 .64448 .85511 .61282 Metetra
.449 .477 .796 r
.85511 .61282 .86784 .64448 .8957 .6425 .88437 .62398 Metetra
.584 .666 .895 r
.88437 .62398 .8957 .6425 .92206 .62451 .91265 .62125 Metetra
.745 .974 .925 r
.91265 .62125 .92206 .62451 .94674 .59213 .9395 .6038 Metetra
.9395 .6038 .94674 .59213 .96989 .54929 .96472 .573 Metetra
.753 .255 0 r
.34784 .65484 .36161 .66686 .38246 .69684 .36872 .68319 Metetra
.614 .111 0 r
.36872 .68319 .38246 .69684 .4041 .72289 .39038 .70817 Metetra
0 .207 .711 r
.39038 .70817 .4041 .72289 .42659 .74047 .41287 .72578 Metetra
.288 .56 .93 r
.41287 .72578 .42659 .74047 .44984 .74601 .43615 .73281 Metetra
.629 .738 .926 r
.43615 .73281 .44984 .74601 .47366 .73766 .46005 .72733 Metetra
.795 .811 .865 r
.46005 .72733 .47366 .73766 .49777 .71557 .48432 .70909 Metetra
.88 .851 .81 r
.48432 .70909 .49777 .71557 .52188 .68198 .50869 .67958 Metetra
.928 .881 .768 r
.50869 .67958 .52188 .68198 .54579 .64068 .53295 .64175 Metetra
.952 .906 .739 r
.53295 .64175 .54579 .64068 .5694 .59637 .55694 .59948 Metetra
.958 .927 .726 r
.55694 .59948 .5694 .59637 .59272 .5539 .58065 .55701 Metetra
.948 .946 .74 r
.58065 .55701 .59272 .5539 .61591 .5176 .60415 .51838 Metetra
.921 .957 .793 r
.60415 .51838 .61591 .5176 .63923 .49087 .62763 .48697 Metetra
.853 .93 .877 r
.62763 .48697 .63923 .49087 .66295 .47591 .65134 .46528 Metetra
.709 .807 .927 r
.65134 .46528 .66295 .47591 .6874 .47359 .67557 .45477 Metetra
.528 .617 .884 r
.67557 .45477 .6874 .47359 .71283 .48344 .70059 .45578 Metetra
.4 .463 .809 r
.70059 .45578 .71283 .48344 .73941 .50366 .72661 .46755 Metetra
.339 .375 .753 r
.72661 .46755 .73941 .50366 .76717 .53115 .75378 .48821 Metetra
.32 .337 .721 r
.75378 .48821 .76717 .53115 .79596 .56176 .78209 .51486 Metetra
.328 .331 .71 r
.78209 .51486 .79596 .56176 .82544 .59064 .81138 .54376 Metetra
.352 .349 .716 r
.81138 .54376 .82544 .59064 .85511 .61282 .84133 .57066 Metetra
.393 .394 .741 r
.84133 .57066 .85511 .61282 .88437 .62398 .87147 .59123 Metetra
.459 .479 .792 r
.87147 .59123 .88437 .62398 .91265 .62125 .90123 .60172 Metetra
.574 .654 .891 r
.90123 .60172 .91265 .62125 .9395 .6038 .93008 .5996 Metetra
.715 .959 .946 r
.93008 .5996 .9395 .6038 .96472 .573 .9576 .58397 Metetra
.721 .215 0 r
.33385 .64263 .34784 .65484 .36872 .68319 .35478 .66932 Metetra
.578 .074 0 r
.35478 .66932 .36872 .68319 .39038 .70817 .37646 .69315 Metetra
0 .213 .716 r
.37646 .69315 .39038 .70817 .41287 .72578 .39896 .71064 Metetra
.241 .53 .919 r
.39896 .71064 .41287 .72578 .43615 .73281 .42226 .71889 Metetra
.577 .712 .935 r
.42226 .71889 .43615 .73281 .46005 .72733 .44621 .71601 Metetra
.756 .798 .886 r
.44621 .71601 .46005 .72733 .48432 .70909 .47061 .70144 Metetra
.855 .847 .835 r
.47061 .70144 .48432 .70909 .50869 .67958 .49521 .67606 Metetra
.912 .882 .791 r
.49521 .67606 .50869 .67958 .53295 .64175 .51979 .64205 Metetra
.943 .91 .757 r
.51979 .64205 .53295 .64175 .55694 .59948 .54417 .60252 Metetra
.954 .932 .734 r
.54417 .60252 .55694 .59948 .58065 .55701 .56828 .56107 Metetra
.949 .95 .731 r
.56828 .56107 .58065 .55701 .60415 .51838 .59214 .52131 Metetra
.931 .965 .76 r
.59214 .52131 .60415 .51838 .62763 .48697 .61588 .4865 Metetra
.894 .964 .829 r
.61588 .4865 .62763 .48697 .65134 .46528 .63969 .45926 Metetra
.809 .905 .908 r
.63969 .45926 .65134 .46528 .67557 .45477 .66383 .4414 Metetra
.659 .753 .919 r
.66383 .4414 .67557 .45477 .70059 .45578 .68855 .43389 Metetra
.508 .576 .859 r
.68855 .43389 .70059 .45578 .72661 .46755 .71409 .43675 Metetra
.411 .451 .791 r
.71409 .43675 .72661 .46755 .75378 .48821 .74066 .44911 Metetra
.365 .381 .744 r
.74066 .44911 .75378 .48821 .78209 .51486 .76835 .46921 Metetra
.352 .35 .718 r
.76835 .46921 .78209 .51486 .81138 .54376 .79716 .49446 Metetra
.357 .345 .708 r
.79716 .49446 .81138 .54376 .84133 .57066 .82692 .52158 Metetra
.377 .36 .714 r
.82692 .52158 .84133 .57066 .87147 .59123 .85735 .54687 Metetra
.409 .398 .735 r
.85735 .54687 .87147 .59123 .90123 .60172 .88801 .56661 Metetra
.462 .471 .782 r
.88801 .56661 .90123 .60172 .93008 .5996 .91838 .57748 Metetra
.553 .619 .873 r
.91838 .57748 .93008 .5996 .9576 .58397 .94798 .57711 Metetra
.682 .169 0 r
.31964 .63023 .33385 .64263 .35478 .66932 .34063 .65523 Metetra
.535 .032 0 r
.34063 .65523 .35478 .66932 .37646 .69315 .36234 .67784 Metetra
0 .224 .726 r
.36234 .67784 .37646 .69315 .39896 .71064 .38486 .69504 Metetra
.203 .504 .908 r
.38486 .69504 .39896 .71064 .42226 .71889 .40817 .70425 Metetra
.523 .684 .939 r
.40817 .70425 .42226 .71889 .44621 .71601 .43216 .70368 Metetra
.712 .78 .905 r
.43216 .70368 .44621 .71601 .47061 .70144 .45667 .69255 Metetra
.823 .838 .859 r
.45667 .69255 .47061 .70144 .49521 .67606 .48146 .67125 Metetra
.891 .88 .817 r
.48146 .67125 .49521 .67606 .51979 .64205 .50631 .64131 Metetra
.93 .913 .78 r
.50631 .64131 .51979 .64205 .54417 .60252 .53105 .6051 Metetra
.947 .938 .749 r
.53105 .6051 .54417 .60252 .56828 .56107 .55557 .56559 Metetra
.946 .956 .732 r
.55557 .56559 .56828 .56107 .59214 .52131 .57983 .5259 Metetra
.932 .969 .738 r
.57983 .5259 .59214 .52131 .61588 .4865 .60391 .48902 Metetra
.909 .979 .782 r
.60391 .48902 .61588 .4865 .63969 .45926 .62794 .45756 Metetra
.867 .964 .861 r
.62794 .45756 .63969 .45926 .66383 .4414 .65211 .43351 Metetra
.773 .876 .922 r
.65211 .43351 .66383 .4414 .68855 .43389 .67667 .41824 Metetra
.631 .713 .906 r
.67667 .41824 .68855 .43389 .71409 .43675 .70185 .41238 Metetra
.506 .556 .841 r
.70185 .41238 .71409 .43675 .74066 .44911 .72788 .4158 Metetra
.43 .45 .779 r
.72788 .4158 .74066 .44911 .76835 .46921 .75492 .42767 Metetra
.393 .391 .738 r
.75492 .42767 .76835 .46921 .79716 .49446 .78307 .44642 Metetra
.38 .363 .714 r
.78307 .44642 .79716 .49446 .82692 .52158 .81231 .46983 Metetra
.383 .356 .705 r
.81231 .46983 .82692 .52158 .85735 .54687 .84252 .4951 Metetra
.397 .367 .709 r
.84252 .4951 .85735 .54687 .88801 .56661 .87343 .51909 Metetra
.421 .397 .727 r
.87343 .51909 .88801 .56661 .91838 .57748 .90467 .53858 Metetra
.461 .455 .765 r
.90467 .53858 .91838 .57748 .94798 .57711 .93576 .55062 Metetra
.636 .117 0 r
.3052 .61763 .31964 .63023 .34063 .65523 .32626 .64093 Metetra
0 .015 .515 r
.32626 .64093 .34063 .65523 .36234 .67784 .34802 .66223 Metetra
0 .241 .741 r
.34802 .66223 .36234 .67784 .38486 .69504 .37056 .67897 Metetra
.176 .484 .899 r
.37056 .67897 .38486 .69504 .40817 .70425 .39388 .6889 Metetra
.472 .654 .94 r
.39388 .6889 .40817 .70425 .43216 .70368 .4179 .69032 Metetra
.664 .757 .919 r
.4179 .69032 .43216 .70368 .45667 .69255 .44248 .68235 Metetra
.785 .824 .883 r
.44248 .68235 .45667 .69255 .48146 .67125 .46742 .66501 Metetra
.863 .874 .844 r
.46742 .66501 .48146 .67125 .50631 .64131 .49252 .63925 Metetra
.912 .913 .806 r
.49252 .63925 .50631 .64131 .53105 .6051 .5176 .60682 Metetra
.936 .942 .771 r
.5176 .60682 .53105 .6051 .55557 .56559 .54251 .57005 Metetra
.939 .961 .741 r
.54251 .57005 .55557 .56559 .57983 .5259 .5672 .53155 Metetra
.927 .973 .727 r
.5672 .53155 .57983 .5259 .60391 .48902 .59167 .49395 Metetra
.908 .983 .743 r
.59167 .49395 .60391 .48902 .62794 .45756 .616 .4597 Metetra
.886 .988 .801 r
.616 .4597 .62794 .45756 .65211 .43351 .64035 .43085 Metetra
.844 .961 .883 r
.64035 .43085 .65211 .43351 .67667 .41824 .66489 .40898 Metetra
.75 .855 .927 r
.66489 .40898 .67667 .41824 .70185 .41238 .68986 .3951 Metetra
.622 .693 .894 r
.68986 .3951 .70185 .41238 .72788 .4158 .71547 .38968 Metetra
.518 .551 .829 r
.71547 .38968 .72788 .4158 .75492 .42767 .74192 .39256 Metetra
.453 .457 .773 r
.74192 .39256 .75492 .42767 .78307 .44642 .76936 .40302 Metetra
.42 .403 .734 r
.76936 .40302 .78307 .44642 .81231 .46983 .7979 .41975 Metetra
.407 .375 .712 r
.7979 .41975 .81231 .46983 .84252 .4951 .82752 .44091 Metetra
.406 .367 .702 r
.82752 .44091 .84252 .4951 .87343 .51909 .85813 .4642 Metetra
.415 .373 .703 r
.85813 .4642 .87343 .51909 .90467 .53858 .88951 .48699 Metetra
.432 .394 .716 r
.88951 .48699 .90467 .53858 .93576 .55062 .92134 .50652 Metetra
.581 .058 0 r
.29053 .60483 .3052 .61763 .32626 .64093 .31168 .62639 Metetra
0 .067 .569 r
.31168 .62639 .32626 .64093 .34802 .66223 .3335 .64632 Metetra
0 .264 .759 r
.3335 .64632 .34802 .66223 .37056 .67897 .35606 .66245 Metetra
.159 .47 .892 r
.35606 .66245 .37056 .67897 .39388 .6889 .3794 .67283 Metetra
.426 .626 .936 r
.3794 .67283 .39388 .6889 .4179 .69032 .40344 .67593 Metetra
.614 .73 .928 r
.40344 .67593 .4179 .69032 .44248 .68235 .42807 .67079 Metetra
.741 .804 .902 r
.42807 .67079 .44248 .68235 .46742 .66501 .45313 .65718 Metetra
.829 .862 .871 r
.45313 .65718 .46742 .66501 .49252 .63925 .47843 .63562 Metetra
.887 .909 .836 r
.47843 .63562 .49252 .63925 .5176 .60682 .5038 .60728 Metetra
.92 .944 .799 r
.5038 .60728 .5176 .60682 .54251 .57005 .52909 .57391 Metetra
.929 .967 .761 r
.52909 .57391 .54251 .57005 .5672 .53155 .5542 .5376 Metetra
.918 .978 .729 r
.5542 .5376 .5672 .53155 .59167 .49395 .5791 .50057 Metetra
.897 .984 .718 r
.5791 .50057 .59167 .49395 .616 .4597 .60382 .46501 Metetra
.877 .991 .743 r
.60382 .46501 .616 .4597 .64035 .43085 .62845 .43289 Metetra
.862 .995 .811 r
.62845 .43289 .64035 .43085 .66489 .40898 .65313 .40585 Metetra
.828 .961 .896 r
.65313 .40585 .66489 .40898 .68986 .3951 .67805 .38515 Metetra
.742 .847 .929 r
.67805 .38515 .68986 .3951 .71547 .38968 .7034 .37161 Metetra
.629 .69 .888 r
.7034 .37161 .71547 .38968 .74192 .39256 .72939 .36559 Metetra
.537 .558 .824 r
.72939 .36559 .74192 .39256 .76936 .40302 .7562 .36698 Metetra
.479 .47 .77 r
.7562 .36698 .76936 .40302 .7979 .41975 .78397 .37522 Metetra
.447 .418 .733 r
.78397 .37522 .7979 .41975 .82752 .44091 .81281 .3893 Metetra
.432 .389 .71 r
.81281 .3893 .82752 .44091 .85813 .4642 .84274 .40775 Metetra
.428 .376 .699 r
.84274 .40775 .85813 .4642 .88951 .48699 .87369 .42875 Metetra
.432 .377 .696 r
.87369 .42875 .88951 .48699 .92134 .50652 .90549 .45015 Metetra
.515 0 0 r
.27563 .59182 .29053 .60483 .31168 .62639 .29688 .61163 Metetra
0 .123 .625 r
.29688 .61163 .31168 .62639 .3335 .64632 .31876 .63011 Metetra
0 .291 .781 r
.31876 .63011 .3335 .64632 .35606 .66245 .34137 .64547 Metetra
.153 .463 .889 r
.34137 .64547 .35606 .66245 .3794 .67283 .36472 .65606 Metetra
.388 .6 .931 r
.36472 .65606 .3794 .67283 .40344 .67593 .38877 .66049 Metetra
.564 .7 .932 r
.38877 .66049 .40344 .67593 .42807 .67079 .41343 .65783 Metetra
.692 .778 .917 r
.41343 .65783 .42807 .67079 .45313 .65718 .43858 .64767 Metetra
.787 .843 .894 r
.43858 .64767 .45313 .65718 .47843 .63562 .46405 .63017 Metetra
.854 .898 .866 r
.46405 .63017 .47843 .63562 .5038 .60728 .48967 .60608 Metetra
.897 .942 .831 r
.48967 .60608 .5038 .60728 .52909 .57391 .5153 .57661 Metetra
.914 .971 .789 r
.5153 .57661 .52909 .57391 .5542 .5376 .54082 .54334 Metetra
.906 .984 .745 r
.54082 .54334 .5542 .5376 .5791 .50057 .56616 .50807 Metetra
.881 .985 .709 r
.56616 .50807 .5791 .50057 .60382 .46501 .59132 .47264 Metetra
.854 .984 .699 r
.59132 .47264 .60382 .46501 .62845 .43289 .61633 .43884 Metetra
.838 .991 .731 r
.61633 .43884 .62845 .43289 .65313 .40585 .64129 .40827 Metetra
.835 .999 .809 r
.64129 .40827 .65313 .40585 .67805 .38515 .66633 .38227 Metetra
.816 .969 .9 r
.66633 .38227 .67805 .38515 .7034 .37161 .69161 .36186 Metetra
.747 .858 .931 r
.69161 .36186 .7034 .37161 .72939 .36559 .71732 .34774 Metetra
.647 .706 .89 r
.71732 .34774 .72939 .36559 .7562 .36698 .74363 .34024 Metetra
.563 .578 .827 r
.74363 .34024 .7562 .36698 .78397 .37522 .77073 .33933 Metetra
.507 .49 .773 r
.77073 .33933 .78397 .37522 .81281 .3893 .79876 .34464 Metetra
.474 .436 .735 r
.79876 .34464 .81281 .3893 .84274 .40775 .82781 .35543 Metetra
.457 .404 .71 r
.82781 .35543 .84274 .40775 .87369 .42875 .85795 .37061 Metetra
.449 .387 .696 r
.85795 .37061 .87369 .42875 .90549 .45015 .88913 .38879 Metetra
0 .08 .558 r
.26048 .5786 .27563 .59182 .29688 .61163 .28184 .59663 Metetra
0 .184 .681 r
.28184 .59663 .29688 .61163 .31876 .63011 .30382 .6136 Metetra
0 .323 .805 r
.30382 .6136 .31876 .63011 .34137 .64547 .32647 .62805 Metetra
.157 .463 .888 r
.32647 .62805 .34137 .64547 .36472 .65606 .34984 .63858 Metetra
.36 .578 .925 r
.34984 .63858 .36472 .65606 .38877 .66049 .3739 .64401 Metetra
.519 .67 .932 r
.3739 .64401 .38877 .66049 .41343 .65783 .39859 .64344 Metetra
.642 .747 .925 r
.39859 .64344 .41343 .65783 .43858 .64767 .4238 .63636 Metetra
.738 .816 .913 r
.4238 .63636 .43858 .64767 .46405 .63017 .44939 .62272 Metetra
.813 .879 .894 r
.44939 .62272 .46405 .63017 .48967 .60608 .47522 .60287 Metetra
.866 .932 .866 r
.47522 .60287 .48967 .60608 .5153 .57661 .50114 .5776 Metetra
.892 .971 .825 r
.50114 .5776 .5153 .57661 .54082 .54334 .52704 .54803 Metetra
.89 .99 .774 r
.52704 .54803 .54082 .54334 .56616 .50807 .55283 .51553 Metetra
.864 .988 .719 r
.55283 .51553 .56616 .50807 .59132 .47264 .57845 .48157 Metetra
.826 .976 .677 r
.57845 .48157 .59132 .47264 .61633 .43884 .60391 .44768 Metetra
.794 .969 .665 r
.60391 .44768 .61633 .43884 .64129 .40827 .62925 .41531 Metetra
.785 .978 .7 r
.62925 .41531 .64129 .40827 .66633 .38227 .65457 .38576 Metetra
.798 .997 .787 r
.65457 .38576 .66633 .38227 .69161 .36186 .67997 .36013 Metetra
.805 .985 .891 r
.67997 .36013 .69161 .36186 .71732 .34774 .7056 .33929 Metetra
.761 .889 .935 r
.7056 .33929 .71732 .34774 .74363 .34024 .73164 .32384 Metetra
.676 .742 .901 r
.73164 .32384 .74363 .34024 .77073 .33933 .75824 .31414 Metetra
.595 .612 .838 r
.75824 .31414 .77073 .33933 .79876 .34464 .78556 .31025 Metetra
.539 .52 .782 r
.78556 .31025 .79876 .34464 .82781 .35543 .81376 .31197 Metetra
.503 .46 .742 r
.81376 .31197 .82781 .35543 .85795 .37061 .84293 .31883 Metetra
.482 .423 .714 r
.84293 .31883 .85795 .37061 .88913 .38879 .87316 .33007 Metetra
0 .157 .635 r
.24509 .56517 .26048 .5786 .28184 .59663 .26658 .58139 Metetra
0 .247 .736 r
.26658 .58139 .28184 .59663 .30382 .6136 .28865 .59679 Metetra
0 .359 .829 r
.28865 .59679 .30382 .6136 .32647 .62805 .31137 .61018 Metetra
.172 .468 .89 r
.31137 .61018 .32647 .62805 .34984 .63858 .33477 .62042 Metetra
.341 .562 .919 r
.33477 .62042 .34984 .63858 .3739 .64401 .35884 .6265 Metetra
.48 .643 .928 r
.35884 .6265 .3739 .64401 .39859 .64344 .38354 .62761 Metetra
.593 .714 .928 r
.38354 .62761 .39859 .64344 .4238 .63636 .40879 .62321 Metetra
.687 .783 .924 r
.40879 .62321 .4238 .63636 .44939 .62272 .43447 .61308 Metetra
.764 .849 .915 r
.43447 .61308 .44939 .62272 .47522 .60287 .46046 .59731 Metetra
.825 .912 .898 r
.46046 .59731 .47522 .60287 .50114 .5776 .48663 .57636 Metetra
.862 .962 .866 r
.48663 .57636 .50114 .5776 .52704 .54803 .51287 .55093 Metetra
.87 .992 .816 r
.51287 .55093 .52704 .54803 .55283 .51553 .53907 .52199 Metetra
.846 .994 .749 r
.53907 .52199 .55283 .51553 .57845 .48157 .56516 .49066 Metetra
.799 .974 .68 r
.56516 .49066 .57845 .48157 .60391 .44768 .59112 .45816 Metetra
.748 .947 .627 r
.59112 .45816 .60391 .44768 .62925 .41531 .61693 .4257 Metetra
.713 .932 .609 r
.61693 .4257 .62925 .41531 .65457 .38576 .64265 .39446 Metetra
.707 .942 .641 r
.64265 .39446 .65457 .38576 .67997 .36013 .66834 .3655 Metetra
.736 .976 .731 r
.66834 .3655 .67997 .36013 .7056 .33929 .69412 .33973 Metetra
.777 .997 .855 r
.69412 .33973 .7056 .33929 .73164 .32384 .72011 .31792 Metetra
.775 .939 .934 r
.72011 .31792 .73164 .32384 .75824 .31414 .74645 .30061 Metetra
.713 .804 .921 r
.74645 .30061 .75824 .31414 .78556 .31025 .77329 .28818 Metetra
.637 .666 .861 r
.77329 .28818 .78556 .31025 .81376 .31197 .80079 .28077 Metetra
.577 .563 .801 r
.80079 .28077 .81376 .31197 .84293 .31883 .82907 .27835 Metetra
.536 .493 .755 r
.82907 .27835 .84293 .31883 .87316 .33007 .85827 .28066 Metetra
0 .237 .709 r
.22944 .55151 .24509 .56517 .26658 .58139 .25108 .5659 Metetra
0 .311 .787 r
.25108 .5659 .26658 .58139 .28865 .59679 .27326 .57967 Metetra
.036 .397 .853 r
.27326 .57967 .28865 .59679 .31137 .61018 .29606 .59186 Metetra
.194 .479 .894 r
.29606 .59186 .31137 .61018 .33477 .62042 .31951 .60158 Metetra
.334 .553 .914 r
.31951 .60158 .33477 .62042 .35884 .6265 .3436 .60797 Metetra
.451 .619 .922 r
.3436 .60797 .35884 .6265 .38354 .62761 .36831 .61034 Metetra
.55 .682 .925 r
.36831 .61034 .38354 .62761 .40879 .62321 .39357 .60816 Metetra
.636 .745 .927 r
.39357 .60816 .40879 .62321 .43447 .61308 .41931 .60112 Metetra
.711 .811 .928 r
.41931 .60112 .43447 .61308 .46046 .59731 .44542 .58914 Metetra
.774 .878 .922 r
.44542 .58914 .46046 .59731 .48663 .57636 .47179 .5724 Metetra
.822 .94 .904 r
.47179 .5724 .48663 .57636 .51287 .55093 .49831 .55131 Metetra
.843 .985 .865 r
.49831 .55131 .51287 .55093 .53907 .52199 .52489 .52649 Metetra
.828 1 .799 r
.52489 .52649 .53907 .52199 .56516 .49066 .55143 .4987 Metetra
.78 .98 .712 r
.55143 .4987 .56516 .49066 .59112 .45816 .57788 .46884 Metetra
.712 .938 .625 r
.57788 .46884 .59112 .45816 .61693 .4257 .60422 .43788 Metetra
.647 .894 .558 r
.60422 .43788 .61693 .4257 .64265 .39446 .63044 .40678 Metetra
.605 .868 .528 r
.63044 .40678 .64265 .39446 .66834 .3655 .65657 .37648 Metetra
.597 .873 .549 r
.65657 .37648 .66834 .3655 .69412 .33973 .68269 .34785 Metetra
.632 .915 .629 r
.68269 .34785 .69412 .33973 .72011 .31792 .70887 .32167 Metetra
.702 .975 .765 r
.70887 .32167 .72011 .31792 .74645 .30061 .73522 .29858 Metetra
.762 .986 .9 r
.73522 .29858 .74645 .30061 .77329 .28818 .76186 .2791 Metetra
.751 .894 .943 r
.76186 .2791 .77329 .28818 .80079 .28077 .78893 .26362 Metetra
.689 .752 .9 r
.78893 .26362 .80079 .28077 .82907 .27835 .81656 .25235 Metetra
.625 .63 .835 r
.81656 .25235 .82907 .27835 .85827 .28066 .84489 .24539 Metetra
0 .317 .778 r
.21353 .53762 .22944 .55151 .25108 .5659 .23533 .55016 Metetra
0 .374 .833 r
.23533 .55016 .25108 .5659 .27326 .57967 .25765 .56224 Metetra
.098 .436 .875 r
.25765 .56224 .27326 .57967 .29606 .59186 .28054 .57312 Metetra
.225 .495 .899 r
.28054 .57312 .29606 .59186 .31951 .60158 .30405 .58208 Metetra
.337 .549 .91 r
.30405 .58208 .31951 .60158 .3436 .60797 .32817 .58846 Metetra
.433 .6 .915 r
.32817 .58846 .3436 .60797 .36831 .61034 .35289 .59166 Metetra
.516 .652 .919 r
.35289 .59166 .36831 .61034 .39357 .60816 .37816 .59121 Metetra
.59 .707 .924 r
.37816 .59121 .39357 .60816 .41931 .60112 .40394 .58676 Metetra
.657 .767 .93 r
.40394 .58676 .41931 .60112 .44542 .58914 .43013 .57813 Metetra
.719 .833 .935 r
.43013 .57813 .44542 .58914 .47179 .5724 .45665 .56534 Metetra
.771 .9 .933 r
.45665 .56534 .47179 .5724 .49831 .55131 .4834 .54854 Metetra
.805 .96 .912 r
.4834 .54854 .49831 .55131 .52489 .52649 .51029 .52808 Metetra
.807 .996 .861 r
.51029 .52808 .52489 .52649 .55143 .4987 .53724 .50443 Metetra
.767 .991 .775 r
.53724 .50443 .55143 .4987 .57788 .46884 .56417 .4782 Metetra
.693 .946 .665 r
.56417 .4782 .57788 .46884 .60422 .43788 .59105 .45007 Metetra
.605 .879 .557 r
.59105 .45007 .60422 .43788 .63044 .40678 .61782 .42077 Metetra
.528 .817 .474 r
.61782 .42077 .63044 .40678 .65657 .37648 .64451 .39107 Metetra
.64451 .39107 .65657 .37648 .68269 .34785 .67112 .36171 Metetra
.67112 .36171 .68269 .34785 .70887 .32167 .69771 .33338 Metetra
.69771 .33338 .70887 .32167 .73522 .29858 .72433 .30673 Metetra
.549 .873 .595 r
.72433 .30673 .73522 .29858 .76186 .2791 .75108 .28233 Metetra
.658 .961 .766 r
.75108 .28233 .76186 .2791 .78893 .26362 .77805 .26064 Metetra
.743 .981 .913 r
.77805 .26064 .78893 .26362 .81656 .25235 .80536 .24206 Metetra
.742 .882 .944 r
.80536 .24206 .81656 .25235 .84489 .24539 .83313 .22685 Metetra
0 .395 .837 r
.19735 .52351 .21353 .53762 .23533 .55016 .21933 .53417 Metetra
.055 .434 .872 r
.21933 .53417 .23533 .55016 .25765 .56224 .2418 .5445 Metetra
.161 .474 .895 r
.2418 .5445 .25765 .56224 .28054 .57312 .26481 .55394 Metetra
.261 .513 .905 r
.26481 .55394 .28054 .57312 .30405 .58208 .28839 .56195 Metetra
.349 .55 .908 r
.28839 .56195 .30405 .58208 .32817 .58846 .31256 .56799 Metetra
.425 .587 .909 r
.31256 .56799 .32817 .58846 .35289 .59166 .33729 .5716 Metetra
.492 .627 .911 r
.33729 .5716 .35289 .59166 .37816 .59121 .36258 .57236 Metetra
.553 .671 .916 r
.36258 .57236 .37816 .59121 .40394 .58676 .38837 .56995 Metetra
.61 .722 .925 r
.38837 .56995 .40394 .58676 .43013 .57813 .41462 .56415 Metetra
.664 .78 .935 r
.41462 .56415 .43013 .57813 .45665 .56534 .44124 .55484 Metetra
.714 .846 .945 r
.44124 .55484 .45665 .56534 .4834 .54854 .46816 .54206 Metetra
.755 .913 .944 r
.46816 .54206 .4834 .54854 .51029 .52808 .49531 .52592 Metetra
.775 .97 .921 r
.49531 .52592 .51029 .52808 .53724 .50443 .52261 .50667 Metetra
.757 .995 .857 r
.52261 .50667 .53724 .50443 .56417 .4782 .54998 .48468 Metetra
.692 .969 .749 r
.54998 .48468 .56417 .4782 .59105 .45007 .57736 .46036 Metetra
.595 .897 .616 r
.57736 .46036 .59105 .45007 .61782 .42077 .60471 .43422 Metetra
.60471 .43422 .61782 .42077 .64451 .39107 .632 .40681 Metetra
.632 .40681 .64451 .39107 .67112 .36171 .65923 .3787 Metetra
.65923 .3787 .67112 .36171 .69771 .33338 .68639 .35046 Metetra
.68639 .35046 .69771 .33338 .72433 .30673 .71351 .32264 Metetra
.71351 .32264 .72433 .30673 .75108 .28233 .74065 .29576 Metetra
.74065 .29576 .75108 .28233 .77805 .26064 .76787 .27031 Metetra
.76787 .27031 .77805 .26064 .80536 .24206 .79524 .24671 Metetra
.562 .908 .691 r
.79524 .24671 .80536 .24206 .83313 .22685 .82286 .22532 Metetra
.06 .466 .885 r
.1809 .50915 .19735 .52351 .21933 .53417 .20308 .51791 Metetra
.143 .489 .903 r
.20308 .51791 .21933 .53417 .2418 .5445 .22572 .52644 Metetra
.226 .512 .91 r
.22572 .52644 .2418 .5445 .26481 .55394 .24886 .53434 Metetra
.302 .534 .91 r
.24886 .53434 .26481 .55394 .28839 .56195 .27254 .54119 Metetra
.369 .557 .906 r
.27254 .54119 .28839 .56195 .31256 .56799 .29677 .5466 Metetra
.427 .581 .903 r
.29677 .5466 .31256 .56799 .33729 .5716 .32154 .55021 Metetra
.479 .608 .902 r
.32154 .55021 .33729 .5716 .36258 .57236 .34684 .55167 Metetra
.527 .641 .905 r
.34684 .55167 .36258 .57236 .38837 .56995 .37265 .55071 Metetra
.572 .68 .913 r
.37265 .55071 .38837 .56995 .41462 .56415 .39892 .54711 Metetra
.616 .727 .925 r
.39892 .54711 .41462 .56415 .44124 .55484 .42561 .54071 Metetra
.659 .782 .94 r
.42561 .54071 .44124 .55484 .46816 .54206 .45265 .53144 Metetra
.699 .847 .953 r
.45265 .53144 .46816 .54206 .49531 .52592 .48 .51929 Metetra
.73 .914 .957 r
.48 .51929 .49531 .52592 .52261 .50667 .50757 .50436 Metetra
.737 .968 .933 r
.50757 .50436 .52261 .50667 .54998 .48468 .5353 .4868 Metetra
.703 .984 .862 r
.5353 .4868 .54998 .48468 .57736 .46036 .56315 .46685 Metetra
.618 .941 .736 r
.56315 .46685 .57736 .46036 .60471 .43422 .59104 .44479 Metetra
.502 .848 .581 r
.59104 .44479 .60471 .43422 .632 .40681 .61894 .42097 Metetra
.61894 .42097 .632 .40681 .65923 .3787 .64682 .39577 Metetra
.64682 .39577 .65923 .3787 .68639 .35046 .67467 .3696 Metetra
.67467 .3696 .68639 .35046 .71351 .32264 .70246 .34288 Metetra
.70246 .34288 .71351 .32264 .74065 .29576 .73023 .31603 Metetra
.73023 .31603 .74065 .29576 .76787 .27031 .758 .28945 Metetra
.758 .28945 .76787 .27031 .79524 .24671 .7858 .26354 Metetra
.7858 .26354 .79524 .24671 .82286 .22532 .81369 .23866 Metetra
.162 .53 .921 r
.16417 .49455 .1809 .50915 .20308 .51791 .18656 .50139 Metetra
.227 .539 .925 r
.18656 .50139 .20308 .51791 .22572 .52644 .20939 .50808 Metetra
.29 .547 .921 r
.20939 .50808 .22572 .52644 .24886 .53434 .2327 .51432 Metetra
.346 .556 .913 r
.2327 .51432 .24886 .53434 .27254 .54119 .2565 .51983 Metetra
.395 .566 .904 r
.2565 .51983 .27254 .54119 .29677 .5466 .2808 .52433 Metetra
.438 .579 .897 r
.2808 .52433 .29677 .5466 .32154 .55021 .30562 .52754 Metetra
.477 .596 .893 r
.30562 .52754 .32154 .55021 .34684 .55167 .33095 .5292 Metetra
.513 .617 .893 r
.33095 .5292 .34684 .55167 .37265 .55071 .35677 .5291 Metetra
.547 .644 .898 r
.35677 .5291 .37265 .55071 .39892 .54711 .38306 .52703 Metetra
.58 .678 .907 r
.38306 .52703 .39892 .54711 .42561 .54071 .40979 .52284 Metetra
.613 .721 .922 r
.40979 .52284 .42561 .54071 .45265 .53144 .43692 .51641 Metetra
.646 .772 .94 r
.43692 .51641 .45265 .53144 .48 .51929 .46439 .50769 Metetra
.677 .833 .958 r
.46439 .50769 .48 .51929 .50757 .50436 .49217 .49664 Metetra
.7 .898 .968 r
.49217 .49664 .50757 .50436 .5353 .4868 .5202 .48331 Metetra
.7 .954 .952 r
.5202 .48331 .5353 .4868 .56315 .46685 .54842 .46779 Metetra
.659 .971 .885 r
.54842 .46779 .56315 .46685 .59104 .44479 .57678 .4502 Metetra
.565 .925 .754 r
.57678 .4502 .59104 .44479 .61894 .42097 .60525 .43072 Metetra
.437 .82 .584 r
.60525 .43072 .61894 .42097 .64682 .39577 .63378 .40957 Metetra
.63378 .40957 .64682 .39577 .67467 .3696 .66233 .38698 Metetra
.66233 .38698 .67467 .3696 .70246 .34288 .69089 .36323 Metetra
.69089 .36323 .70246 .34288 .73023 .31603 .71944 .33861 Metetra
.71944 .33861 .73023 .31603 .758 .28945 .74797 .31341 Metetra
.74797 .31341 .758 .28945 .7858 .26354 .7765 .28792 Metetra
.7765 .28792 .7858 .26354 .81369 .23866 .80505 .26245 Metetra
.256 .584 .945 r
.14715 .47969 .16417 .49455 .18656 .50139 .16978 .48459 Metetra
.305 .582 .939 r
.16978 .48459 .18656 .50139 .20939 .50808 .19282 .48939 Metetra
.351 .579 .928 r
.19282 .48939 .20939 .50808 .2327 .51432 .21631 .4939 Metetra
.391 .578 .914 r
.21631 .4939 .2327 .51432 .2565 .51983 .24025 .4979 Metetra
.426 .579 .902 r
.24025 .4979 .2565 .51983 .2808 .52433 .26466 .50123 Metetra
.456 .582 .891 r
.26466 .50123 .2808 .52433 .30562 .52754 .28955 .50367 Metetra
.484 .59 .884 r
.28955 .50367 .30562 .52754 .33095 .5292 .31493 .50506 Metetra
.509 .601 .881 r
.31493 .50506 .33095 .5292 .35677 .5291 .34078 .50522 Metetra
.534 .617 .882 r
.34078 .50522 .35677 .5291 .38306 .52703 .36709 .504 Metetra
.557 .639 .887 r
.36709 .504 .38306 .52703 .40979 .52284 .39384 .50126 Metetra
.581 .667 .898 r
.39384 .50126 .40979 .52284 .43692 .51641 .42101 .49689 Metetra
.605 .703 .913 r
.42101 .49689 .43692 .51641 .46439 .50769 .44857 .49081 Metetra
.63 .747 .932 r
.44857 .49081 .46439 .50769 .49217 .49664 .47649 .48294 Metetra
.653 .802 .954 r
.47649 .48294 .49217 .49664 .5202 .48331 .50472 .47326 Metetra
.671 .863 .973 r
.50472 .47326 .5202 .48331 .54842 .46779 .53323 .46177 Metetra
.672 .922 .974 r
.53323 .46177 .54842 .46779 .57678 .4502 .56198 .44849 Metetra
.639 .956 .933 r
.56198 .44849 .57678 .4502 .60525 .43072 .59092 .43348 Metetra
.553 .931 .824 r
.59092 .43348 .60525 .43072 .63378 .40957 .62002 .41684 Metetra
.423 .836 .654 r
.62002 .41684 .63378 .40957 .66233 .38698 .64924 .39866 Metetra
.64924 .39866 .66233 .38698 .69089 .36323 .67855 .37909 Metetra
.67855 .37909 .69089 .36323 .71944 .33861 .70792 .35829 Metetra
.70792 .35829 .71944 .33861 .74797 .31341 .73734 .33642 Metetra
.004 0 0 r
.73734 .33642 .74797 .31341 .7765 .28792 .76678 .31368 Metetra
.055 0 0 r
.76678 .31368 .7765 .28792 .80505 .26245 .79624 .29026 Metetra
.34 .628 .959 r
.12983 .46458 .14715 .47969 .16978 .48459 .15272 .46752 Metetra
.376 .618 .946 r
.15272 .46752 .16978 .48459 .19282 .48939 .176 .47039 Metetra
.408 .608 .93 r
.176 .47039 .19282 .48939 .21631 .4939 .19968 .47307 Metetra
.435 .599 .913 r
.19968 .47307 .21631 .4939 .24025 .4979 .22379 .47543 Metetra
.459 .592 .898 r
.22379 .47543 .24025 .4979 .26466 .50123 .24834 .47734 Metetra
.48 .589 .885 r
.24834 .47734 .26466 .50123 .28955 .50367 .27334 .4787 Metetra
.499 .589 .876 r
.27334 .4787 .28955 .50367 .31493 .50506 .29878 .47936 Metetra
.516 .592 .869 r
.29878 .47936 .31493 .50506 .34078 .50522 .32467 .47923 Metetra
.532 .599 .866 r
.32467 .47923 .34078 .50522 .36709 .504 .35101 .47818 Metetra
.548 .61 .867 r
.35101 .47818 .36709 .504 .39384 .50126 .37778 .47612 Metetra
.563 .626 .872 r
.37778 .47612 .39384 .50126 .42101 .49689 .40498 .47296 Metetra
.579 .647 .881 r
.40498 .47296 .42101 .49689 .44857 .49081 .43259 .46861 Metetra
.596 .674 .895 r
.43259 .46861 .44857 .49081 .47649 .48294 .46059 .46301 Metetra
.613 .709 .913 r
.46059 .46301 .47649 .48294 .50472 .47326 .48896 .45609 Metetra
.63 .752 .935 r
.48896 .45609 .50472 .47326 .53323 .46177 .51766 .44783 Metetra
.645 .805 .96 r
.51766 .44783 .53323 .46177 .56198 .44849 .54668 .4382 Metetra
.652 .863 .979 r
.54668 .4382 .56198 .44849 .59092 .43348 .57598 .42718 Metetra
.639 .916 .979 r
.57598 .42718 .59092 .43348 .62002 .41684 .60553 .4148 Metetra
.589 .939 .932 r
.60553 .4148 .62002 .41684 .64924 .39866 .63531 .40108 Metetra
.486 .899 .812 r
.63531 .40108 .64924 .39866 .67855 .37909 .66527 .38605 Metetra
.344 .789 .631 r
.66527 .38605 .67855 .37909 .70792 .35829 .69541 .36978 Metetra
.69541 .36978 .70792 .35829 .73734 .33642 .72568 .35233 Metetra
.72568 .35233 .73734 .33642 .76678 .31368 .75607 .3338 Metetra
.012 0 0 r
.75607 .3338 .76678 .31368 .79624 .29026 .78655 .31428 Metetra
.414 .664 .963 r
.11221 .4492 .12983 .46458 .15272 .46752 .13538 .45016 Metetra
.44 .648 .947 r
.13538 .45016 .15272 .46752 .176 .47039 .15892 .45106 Metetra
.461 .632 .928 r
.15892 .45106 .176 .47039 .19968 .47307 .18283 .45184 Metetra
.479 .618 .91 r
.18283 .45184 .19968 .47307 .22379 .47543 .20714 .45242 Metetra
.494 .607 .894 r
.20714 .45242 .22379 .47543 .24834 .47734 .23185 .45273 Metetra
.507 .598 .879 r
.23185 .45273 .24834 .47734 .27334 .4787 .25697 .4527 Metetra
.518 .591 .867 r
.25697 .4527 .27334 .4787 .29878 .47936 .28251 .45225 Metetra
.529 .588 .858 r
.28251 .45225 .29878 .47936 .32467 .47923 .30847 .45131 Metetra
.539 .588 .852 r
.30847 .45131 .32467 .47923 .35101 .47818 .33485 .44981 Metetra
.548 .591 .848 r
.33485 .44981 .35101 .47818 .37778 .47612 .36166 .44769 Metetra
.558 .597 .848 r
.36166 .44769 .37778 .47612 .40498 .47296 .38888 .44488 Metetra
.568 .606 .851 r
.38888 .44488 .40498 .47296 .43259 .46861 .41652 .44132 Metetra
.578 .619 .857 r
.41652 .44132 .43259 .46861 .46059 .46301 .44456 .43695 Metetra
.588 .637 .867 r
.44456 .43695 .46059 .46301 .48896 .45609 .473 .43174 Metetra
.599 .661 .881 r
.473 .43174 .48896 .45609 .51766 .44783 .50181 .42562 Metetra
.611 .69 .899 r
.50181 .42562 .51766 .44783 .54668 .4382 .531 .41858 Metetra
.622 .727 .922 r
.531 .41858 .54668 .4382 .57598 .42718 .56053 .41057 Metetra
.632 .772 .947 r
.56053 .41057 .57598 .42718 .60553 .4148 .59039 .40157 Metetra
.637 .824 .972 r
.59039 .40157 .60553 .4148 .63531 .40108 .62056 .39158 Metetra
.629 .878 .988 r
.62056 .39158 .63531 .40108 .66527 .38605 .65102 .38057 Metetra
.593 .917 .973 r
.65102 .38057 .66527 .38605 .69541 .36978 .68175 .36857 Metetra
.512 .912 .899 r
.68175 .36857 .69541 .36978 .72568 .35233 .71273 .35556 Metetra
.383 .837 .75 r
.71273 .35556 .72568 .35233 .75607 .3338 .74394 .34157 Metetra
.74394 .34157 .75607 .3338 .78655 .31428 .77536 .32664 Metetra
.479 .692 .961 r
.09428 .43355 .11221 .4492 .13538 .45016 .11775 .43251 Metetra
.495 .672 .943 r
.11775 .43251 .13538 .45016 .15892 .45106 .14157 .43141 Metetra
.509 .653 .924 r
.14157 .43141 .15892 .45106 .18283 .45184 .16574 .43023 Metetra
.519 .636 .905 r
.16574 .43023 .18283 .45184 .20714 .45242 .19027 .42893 Metetra
.528 .621 .888 r
.19027 .42893 .20714 .45242 .23185 .45273 .21517 .42746 Metetra
.535 .608 .872 r
.21517 .42746 .23185 .45273 .25697 .4527 .24045 .42579 Metetra
.542 .597 .859 r
.24045 .42579 .25697 .4527 .28251 .45225 .26612 .42388 Metetra
.547 .589 .848 r
.26612 .42388 .28251 .45225 .30847 .45131 .29218 .42169 Metetra
.552 .583 .839 r
.29218 .42169 .30847 .45131 .33485 .44981 .31863 .41918 Metetra
.557 .58 .832 r
.31863 .41918 .33485 .44981 .36166 .44769 .34549 .41632 Metetra
.562 .578 .828 r
.34549 .41632 .36166 .44769 .38888 .44488 .37275 .41306 Metetra
.567 .579 .825 r
.37275 .41306 .38888 .44488 .41652 .44132 .40041 .40938 Metetra
.573 .583 .825 r
.40041 .40938 .41652 .44132 .44456 .43695 .42847 .40524 Metetra
.578 .589 .828 r
.42847 .40524 .44456 .43695 .473 .43174 .45694 .40059 Metetra
.584 .598 .832 r
.45694 .40059 .473 .43174 .50181 .42562 .4858 .39543 Metetra
.59 .61 .84 r
.4858 .39543 .50181 .42562 .531 .41858 .51505 .3897 Metetra
.597 .626 .851 r
.51505 .3897 .531 .41858 .56053 .41057 .54469 .38339 Metetra
.604 .645 .864 r
.54469 .38339 .56053 .41057 .59039 .40157 .57471 .37646 Metetra
.612 .67 .882 r
.57471 .37646 .59039 .40157 .62056 .39158 .6051 .36891 Metetra
.619 .701 .903 r
.6051 .36891 .62056 .39158 .65102 .38057 .63586 .3607 Metetra
.626 .739 .928 r
.63586 .3607 .65102 .38057 .68175 .36857 .66697 .35182 Metetra
.629 .784 .956 r
.66697 .35182 .68175 .36857 .71273 .35556 .69842 .34226 Metetra
.625 .834 .98 r
.69842 .34226 .71273 .35556 .74394 .34157 .7302 .332 Metetra
.604 .881 .991 r
.7302 .332 .74394 .34157 .77536 .32664 .7623 .32104 Metetra
.534 .714 .955 r
.07603 .41762 .09428 .43355 .11775 .43251 .09983 .41455 Metetra
.544 .692 .936 r
.09983 .41455 .11775 .43251 .14157 .43141 .12395 .41144 Metetra
.551 .671 .917 r
.12395 .41144 .14157 .43141 .16574 .43023 .1484 .40824 Metetra
.557 .651 .898 r
.1484 .40824 .16574 .43023 .19027 .42893 .17318 .40496 Metetra
.561 .634 .881 r
.17318 .40496 .19027 .42893 .21517 .42746 .1983 .40158 Metetra
.564 .618 .865 r
.1983 .40158 .21517 .42746 .24045 .42579 .22378 .39807 Metetra
.566 .605 .851 r
.22378 .39807 .24045 .42579 .26612 .42388 .24961 .39442 Metetra
.568 .593 .838 r
.24961 .39442 .26612 .42388 .29218 .42169 .2758 .39062 Metetra
.57 .583 .827 r
.2758 .39062 .29218 .42169 .31863 .41918 .30236 .38664 Metetra
.572 .575 .818 r
.30236 .38664 .31863 .41918 .34549 .41632 .32929 .38247 Metetra
.573 .569 .81 r
.32929 .38247 .34549 .41632 .37275 .41306 .3566 .37808 Metetra
.575 .564 .804 r
.3566 .37808 .37275 .41306 .40041 .40938 .38429 .37347 Metetra
.577 .561 .8 r
.38429 .37347 .40041 .40938 .42847 .40524 .41237 .36862 Metetra
.579 .56 .797 r
.41237 .36862 .42847 .40524 .45694 .40059 .44084 .36351 Metetra
.581 .56 .795 r
.44084 .36351 .45694 .40059 .4858 .39543 .4697 .35811 Metetra
.583 .561 .795 r
.4697 .35811 .4858 .39543 .51505 .3897 .49896 .35242 Metetra
.586 .564 .797 r
.49896 .35242 .51505 .3897 .54469 .38339 .52862 .34643 Metetra
.589 .569 .8 r
.52862 .34643 .54469 .38339 .57471 .37646 .55867 .3401 Metetra
.592 .576 .804 r
.55867 .3401 .57471 .37646 .6051 .36891 .58912 .33343 Metetra
.596 .585 .811 r
.58912 .33343 .6051 .36891 .63586 .3607 .61998 .3264 Metetra
.6 .597 .82 r
.61998 .3264 .63586 .3607 .66697 .35182 .65123 .319 Metetra
.604 .611 .831 r
.65123 .319 .66697 .35182 .69842 .34226 .68288 .31122 Metetra
.609 .629 .845 r
.68288 .31122 .69842 .34226 .7302 .332 .71493 .30303 Metetra
.615 .65 .862 r
.71493 .30303 .7302 .332 .7623 .32104 .74737 .29444 Metetra
.581 .73 .945 r
.05745 .4014 .07603 .41762 .09983 .41455 .0816 .3963 Metetra
.586 .707 .926 r
.0816 .3963 .09983 .41455 .12395 .41144 .10605 .39113 Metetra
.589 .685 .908 r
.10605 .39113 .12395 .41144 .1484 .40824 .13081 .38588 Metetra
.591 .665 .89 r
.13081 .38588 .1484 .40824 .17318 .40496 .15587 .38056 Metetra
.592 .646 .873 r
.15587 .38056 .17318 .40496 .1983 .40158 .18125 .37516 Metetra
.592 .629 .857 r
.18125 .37516 .1983 .40158 .22378 .39807 .20694 .36966 Metetra
.592 .613 .842 r
.20694 .36966 .22378 .39807 .24961 .39442 .23297 .36407 Metetra
.591 .599 .829 r
.23297 .36407 .24961 .39442 .2758 .39062 .25932 .35837 Metetra
.59 .587 .817 r
.25932 .35837 .2758 .39062 .30236 .38664 .28602 .35257 Metetra
.589 .576 .806 r
.28602 .35257 .30236 .38664 .32929 .38247 .31305 .34665 Metetra
.589 .567 .797 r
.31305 .34665 .32929 .38247 .3566 .37808 .34044 .3406 Metetra
.588 .558 .788 r
.34044 .3406 .3566 .37808 .38429 .37347 .36819 .33443 Metetra
.587 .551 .781 r
.36819 .33443 .38429 .37347 .41237 .36862 .39629 .32813 Metetra
.587 .544 .774 r
.39629 .32813 .41237 .36862 .44084 .36351 .42476 .32168 Metetra
.587 .539 .769 r
.42476 .32168 .44084 .36351 .4697 .35811 .45361 .31508 Metetra
.586 .535 .764 r
.45361 .31508 .4697 .35811 .49896 .35242 .48283 .30833 Metetra
.586 .531 .76 r
.48283 .30833 .49896 .35242 .52862 .34643 .51244 .30142 Metetra
.586 .529 .757 r
.51244 .30142 .52862 .34643 .55867 .3401 .54243 .29434 Metetra
.587 .527 .755 r
.54243 .29434 .55867 .3401 .58912 .33343 .57282 .28708 Metetra
.587 .526 .754 r
.57282 .28708 .58912 .33343 .61998 .3264 .60361 .27964 Metetra
.588 .526 .753 r
.60361 .27964 .61998 .3264 .65123 .319 .63481 .27202 Metetra
.589 .527 .754 r
.63481 .27202 .65123 .319 .68288 .31122 .66642 .2642 Metetra
.59 .529 .755 r
.66642 .2642 .68288 .31122 .71493 .30303 .69844 .25617 Metetra
.591 .532 .757 r
.69844 .25617 .71493 .30303 .74737 .29444 .73088 .24794 Metetra
.622 .742 .933 r
.03853 .38489 .05745 .4014 .0816 .3963 .06306 .37773 Metetra
.623 .719 .915 r
.06306 .37773 .0816 .3963 .10605 .39113 .08787 .37048 Metetra
.623 .697 .898 r
.08787 .37048 .10605 .39113 .13081 .38588 .11296 .36316 Metetra
.622 .676 .88 r
.11296 .36316 .13081 .38588 .15587 .38056 .13833 .35575 Metetra
.62 .657 .864 r
.13833 .35575 .15587 .38056 .18125 .37516 .16399 .34826 Metetra
.618 .639 .849 r
.16399 .34826 .18125 .37516 .20694 .36966 .18994 .34067 Metetra
.616 .622 .834 r
.18994 .34067 .20694 .36966 .23297 .36407 .21619 .333 Metetra
.613 .607 .821 r
.21619 .333 .23297 .36407 .25932 .35837 .24274 .32523 Metetra
.611 .593 .809 r
.24274 .32523 .25932 .35837 .28602 .35257 .2696 .31737 Metetra
.609 .581 .797 r
.2696 .31737 .28602 .35257 .31305 .34665 .29677 .30941 Metetra
.606 .569 .786 r
.29677 .30941 .31305 .34665 .34044 .3406 .32427 .30136 Metetra
.604 .558 .777 r
.32427 .30136 .34044 .3406 .36819 .33443 .35209 .2932 Metetra
.602 .549 .768 r
.35209 .2932 .36819 .33443 .39629 .32813 .38024 .28494 Metetra
.599 .54 .759 r
.38024 .28494 .39629 .32813 .42476 .32168 .40872 .27657 Metetra
.597 .532 .751 r
.40872 .27657 .42476 .32168 .45361 .31508 .43755 .26809 Metetra
.595 .524 .744 r
.43755 .26809 .45361 .31508 .48283 .30833 .46672 .2595 Metetra
.594 .517 .738 r
.46672 .2595 .48283 .30833 .51244 .30142 .49625 .2508 Metetra
.592 .511 .732 r
.49625 .2508 .51244 .30142 .54243 .29434 .52614 .24199 Metetra
.591 .505 .727 r
.52614 .24199 .54243 .29434 .57282 .28708 .55639 .23305 Metetra
.589 .5 .722 r
.55639 .23305 .57282 .28708 .60361 .27964 .58702 .22399 Metetra
.588 .495 .717 r
.58702 .22399 .60361 .27964 .63481 .27202 .61803 .21481 Metetra
.587 .491 .713 r
.61803 .21481 .63481 .27202 .66642 .2642 .64942 .2055 Metetra
.586 .487 .709 r
.64942 .2055 .66642 .2642 .69844 .25617 .68121 .19606 Metetra
.585 .484 .706 r
.68121 .19606 .69844 .25617 .73088 .24794 .7134 .18649 Metetra
.656 .751 .92 r
.01926 .36807 .03853 .38489 .06306 .37773 .04421 .35884 Metetra
.654 .728 .903 r
.04421 .35884 .06306 .37773 .08787 .37048 .0694 .34951 Metetra
.652 .706 .887 r
.0694 .34951 .08787 .37048 .11296 .36316 .09484 .34008 Metetra
.649 .685 .871 r
.09484 .34008 .11296 .36316 .13833 .35575 .12055 .33056 Metetra
.646 .666 .855 r
.12055 .33056 .13833 .35575 .16399 .34826 .14652 .32094 Metetra
.642 .648 .841 r
.14652 .32094 .16399 .34826 .18994 .34067 .17275 .31123 Metetra
.639 .631 .827 r
.17275 .31123 .18994 .34067 .21619 .333 .19925 .30141 Metetra
.635 .616 .814 r
.19925 .30141 .21619 .333 .24274 .32523 .22603 .2915 Metetra
.631 .601 .801 r
.22603 .2915 .24274 .32523 .2696 .31737 .25309 .28147 Metetra
.628 .588 .79 r
.25309 .28147 .2696 .31737 .29677 .30941 .28042 .27135 Metetra
.624 .575 .779 r
.28042 .27135 .29677 .30941 .32427 .30136 .30805 .26112 Metetra
.621 .564 .769 r
.30805 .26112 .32427 .30136 .35209 .2932 .33597 .25078 Metetra
.617 .553 .759 r
.33597 .25078 .35209 .2932 .38024 .28494 .36418 .24033 Metetra
.614 .543 .75 r
.36418 .24033 .38024 .28494 .40872 .27657 .3927 .22977 Metetra
.611 .533 .742 r
.3927 .22977 .40872 .27657 .43755 .26809 .42152 .21909 Metetra
.608 .524 .734 r
.42152 .21909 .43755 .26809 .46672 .2595 .45066 .2083 Metetra
.605 .516 .727 r
.45066 .2083 .46672 .2595 .49625 .2508 .48011 .1974 Metetra
.603 .508 .719 r
.48011 .1974 .49625 .2508 .52614 .24199 .50988 .18637 Metetra
.6 .501 .713 r
.50988 .18637 .52614 .24199 .55639 .23305 .53998 .17522 Metetra
.598 .494 .707 r
.53998 .17522 .55639 .23305 .58702 .22399 .57041 .16395 Metetra
.595 .487 .701 r
.57041 .16395 .58702 .22399 .61803 .21481 .60118 .15256 Metetra
.593 .481 .695 r
.60118 .15256 .61803 .21481 .64942 .2055 .63229 .14103 Metetra
.591 .475 .69 r
.63229 .14103 .64942 .2055 .68121 .19606 .66375 .12938 Metetra
.589 .47 .685 r
.66375 .12938 .68121 .19606 .7134 .18649 .69556 .1176 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.22768 .18054 m
.23217 .18532 L
s
[(1)] .2187 .17096 .938 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(2)] .42503 .08982 .80527 1 Mshowa
.65575 .01292 m
.65941 .01836 L
s
[(3)] .64842 .00203 .67254 1 Mshowa
.125 Mabswid
.07414 .24066 m
.07698 .24338 L
s
.11167 .22596 m
.11448 .22872 L
s
.14976 .21105 m
.15253 .21384 L
s
.18843 .19591 m
.19116 .19874 L
s
.26753 .16493 m
.27019 .16784 L
s
.30801 .14908 m
.31061 .15203 L
s
.34911 .13299 m
.35167 .13598 L
s
.39085 .11664 m
.39337 .11967 L
s
.47634 .08317 m
.47875 .08628 L
s
.52011 .06603 m
.52247 .06918 L
s
.56459 .04861 m
.5669 .0518 L
s
.60979 .03091 m
.61205 .03414 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesEdge"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, \[Pi]}, {y, 0, \[Pi]}, 
      AxesEdge \[Rule] {{1, 1}, {\(-1\), 1}, {1, 1}}]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AxesEdge"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.2902e-17 1.04977 -0.0679587 1.04977 [
[.39741 .82425 -3.10486 0 ]
[.39741 .82425 2.89514 9 ]
[.57612 .77764 -2.95731 0 ]
[.57612 .77764 3.04269 9 ]
[.76709 .7278 -2.79534 0 ]
[.76709 .7278 3.20466 9 ]
[.97164 .67438 -2.61674 0 ]
[.97164 .67438 3.38326 9 ]
[-0.00205 .50259 -3.47541 0 ]
[-0.00205 .50259 2.52459 9 ]
[.1436 .61987 -3.33228 0 ]
[.1436 .61987 2.66772 9 ]
[.27072 .72224 -3.2151 0 ]
[.27072 .72224 2.7849 9 ]
[.38264 .81235 -3.1174 0 ]
[.38264 .81235 2.8826 9 ]
[.9826 .43046 0 -5.85 ]
[.9826 .43046 12 3.15 ]
[.98958 .48145 0 -5.80995 ]
[.98958 .48145 24 3.19005 ]
[.99679 .53406 0 -5.76872 ]
[.99679 .53406 6 3.23128 ]
[1.00423 .58838 0 -5.72627 ]
[1.00423 .58838 18 3.27373 ]
[1.01191 .64447 0 -5.68253 ]
[1.01191 .64447 6 3.31747 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.39787 .81114 m
1 .6535 L
s
.39787 .81114 m
.3981 .80458 L
s
[(0)] .39741 .82425 .03495 -1 Mshowa
.57593 .76452 m
.57584 .75796 L
s
[(1)] .57612 .77764 -0.01423 -1 Mshowa
.7662 .71471 m
.76575 .70816 L
s
[(2)] .76709 .7278 -0.06822 -1 Mshowa
.96997 .66136 m
.96914 .65485 L
s
[(3)] .97164 .67438 -0.12775 -1 Mshowa
.125 Mabswid
.43256 .80205 m
.43266 .79812 L
s
.46771 .79285 m
.46777 .78892 L
s
.50331 .78353 m
.50333 .7796 L
s
.53938 .77409 m
.53937 .77015 L
s
.61297 .75482 m
.61287 .75089 L
s
.6505 .745 m
.65037 .74106 L
s
.68855 .73504 m
.68837 .73111 L
s
.72711 .72494 m
.72688 .72101 L
s
.80583 .70433 m
.80552 .70041 L
s
.84601 .69381 m
.84565 .68989 L
s
.88675 .68315 m
.88635 .67923 L
s
.92807 .67233 m
.92762 .66842 L
s
.25 Mabswid
0 .48963 m
.39787 .81114 L
s
0 .48963 m
.00103 .48315 L
s
[(0)] -0.00205 .50259 .15847 -1 Mshowa
.14504 .60683 m
.14576 .60031 L
s
[(1)] .1436 .61987 .11076 -1 Mshowa
.27166 .70915 m
.27213 .7026 L
s
[(2)] .27072 .72224 .0717 -1 Mshowa
.38315 .79924 m
.38341 .79269 L
s
[(3)] .38264 .81235 .03913 -1 Mshowa
.125 Mabswid
.03067 .51441 m
.03125 .51052 L
s
.06048 .5385 m
.06102 .5346 L
s
.08945 .56191 m
.08995 .55801 L
s
.11763 .58468 m
.1181 .58077 L
s
.17172 .62839 m
.17212 .62447 L
s
.19769 .64938 m
.19806 .64546 L
s
.22299 .66982 m
.22333 .6659 L
s
.24764 .68974 m
.24795 .68581 L
s
.29508 .72807 m
.29533 .72414 L
s
.31791 .74652 m
.31814 .74259 L
s
.34019 .76453 m
.34039 .7606 L
s
.36193 .78209 m
.36211 .77816 L
s
.25 Mabswid
.96935 .42924 m
1 .6535 L
s
.97003 .43423 m
.96375 .43611 L
s
[(-1)] .9826 .43046 -1 .3 Mshowa
.97699 .48512 m
.97069 .48695 L
s
[(-0.5)] .98958 .48145 -1 .2911 Mshowa
.98416 .53762 m
.97785 .53941 L
s
[(0)] .99679 .53406 -1 .28194 Mshowa
.99157 .59183 m
.98524 .59355 L
s
[(0.5)] 1.00423 .58838 -1 .2725 Mshowa
.99922 .6478 m
.99288 .64947 L
s
[(1)] 1.01191 .64447 -1 .26278 Mshowa
.125 Mabswid
.9714 .44428 m
.96763 .4454 L
s
.97279 .45439 m
.96901 .45551 L
s
.97418 .46457 m
.9704 .46568 L
s
.97558 .47481 m
.9718 .47592 L
s
.9784 .49549 m
.97462 .49658 L
s
.97983 .50592 m
.97605 .50701 L
s
.98126 .51642 m
.97748 .5175 L
s
.98271 .52699 m
.97892 .52807 L
s
.98562 .54833 m
.98183 .54939 L
s
.9871 .5591 m
.9833 .56015 L
s
.98858 .56994 m
.98478 .57099 L
s
.99007 .58085 m
.98627 .58189 L
s
.99308 .60288 m
.98928 .6039 L
s
.9946 .614 m
.9908 .61502 L
s
.99613 .62519 m
.99233 .62621 L
s
.99767 .63646 m
.99387 .63747 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.821 .348 0 r
.38853 .69036 .40169 .70185 .4225 .73657 .40935 .72353 Metetra
.695 .197 0 r
.40935 .72353 .4225 .73657 .44414 .76533 .43098 .75147 Metetra
0 .231 .729 r
.43098 .75147 .44414 .76533 .4666 .78174 .45345 .76844 Metetra
.464 .662 .947 r
.45345 .76844 .4666 .78174 .48971 .7814 .47662 .7703 Metetra
.763 .788 .874 r
.47662 .7703 .48971 .7814 .51315 .76307 .50022 .75549 Metetra
.875 .826 .796 r
.50022 .75549 .51315 .76307 .53658 .72898 .5239 .72542 Metetra
.928 .85 .746 r
.5239 .72542 .53658 .72898 .55974 .68424 .5474 .68412 Metetra
.954 .871 .717 r
.5474 .68412 .55974 .68424 .58252 .63566 .57057 .63736 Metetra
.962 .894 .713 r
.57057 .63736 .58252 .63566 .605 .5903 .5934 .59145 Metetra
.951 .916 .742 r
.5934 .59145 .605 .5903 .62744 .55427 .61608 .55218 Metetra
.905 .924 .819 r
.61608 .55218 .62744 .55427 .65017 .53194 .63888 .52412 Metetra
.768 .855 .915 r
.63888 .52412 .65017 .53194 .67359 .5256 .66216 .5101 Metetra
.518 .645 .913 r
.66216 .5101 .67359 .5256 .69805 .53525 .68627 .51111 Metetra
.31 .429 .821 r
.68627 .51111 .69805 .53525 .72376 .55863 .71148 .52619 Metetra
.22 .312 .746 r
.71148 .52619 .72376 .55863 .75074 .5913 .73795 .55248 Metetra
.208 .275 .713 r
.73795 .55248 .75074 .5913 .77874 .62707 .76559 .58539 Metetra
.24 .287 .71 r
.76559 .58539 .77874 .62707 .80729 .65874 .79413 .61902 Metetra
.301 .337 .732 r
.79413 .61902 .80729 .65874 .83567 .67932 .82303 .6469 Metetra
.396 .434 .783 r
.82303 .6469 .83567 .67932 .86313 .68347 .85162 .66309 Metetra
.552 .62 .873 r
.85162 .66309 .86313 .68347 .88906 .66891 .87921 .66337 Metetra
.779 .936 .932 r
.87921 .66337 .88906 .66891 .91317 .63697 .90527 .64627 Metetra
.626 .852 .475 r
.90527 .64627 .91317 .63697 .93561 .59228 .92958 .61346 Metetra
.92958 .61346 .93561 .59228 .95693 .5416 .95231 .56932 Metetra
0 0 .09 r
.95231 .56932 .95693 .5416 .97797 .49234 .97398 .51991 Metetra
.802 .321 0 r
.37517 .6787 .38853 .69036 .40935 .72353 .396 .71029 Metetra
.672 .173 0 r
.396 .71029 .40935 .72353 .43098 .75147 .41763 .73733 Metetra
0 .216 .717 r
.41763 .73733 .43098 .75147 .45345 .76844 .44012 .75468 Metetra
.402 .628 .945 r
.44012 .75468 .45345 .76844 .47662 .7703 .46333 .75851 Metetra
.724 .776 .894 r
.46333 .75851 .47662 .7703 .50022 .75549 .48705 .74703 Metetra
.854 .824 .819 r
.48705 .74703 .50022 .75549 .5239 .72542 .51096 .72099 Metetra
.916 .852 .765 r
.51096 .72099 .5239 .72542 .5474 .68412 .53479 .68343 Metetra
.948 .875 .731 r
.53479 .68343 .5474 .68412 .57057 .63736 .55833 .63912 Metetra
.961 .897 .717 r
.55833 .63912 .57057 .63736 .5934 .59145 .58154 .59358 Metetra
.957 .919 .73 r
.58154 .59358 .5934 .59145 .61608 .55218 .60452 .55217 Metetra
.93 .935 .784 r
.60452 .55217 .61608 .55218 .63888 .52412 .62747 .51941 Metetra
.848 .91 .877 r
.62747 .51941 .63888 .52412 .66216 .5101 .65072 .49853 Metetra
.662 .77 .93 r
.65072 .49853 .66216 .5101 .68627 .51111 .67458 .49122 Metetra
.438 .55 .872 r
.67458 .49122 .68627 .51111 .71148 .52619 .69936 .49758 Metetra
.301 .39 .787 r
.69936 .49758 .71148 .52619 .73795 .55248 .72529 .51606 Metetra
.251 .314 .734 r
.72529 .51606 .73795 .55248 .76559 .58539 .75244 .54356 Metetra
.253 .295 .712 r
.75244 .54356 .76559 .58539 .79413 .61902 .78068 .57562 Metetra
.285 .313 .714 r
.78068 .57562 .79413 .61902 .82303 .6469 .8097 .60681 Metetra
.341 .364 .739 r
.8097 .60681 .82303 .6469 .85162 .66309 .83897 .63145 Metetra
.429 .461 .792 r
.83897 .63145 .85162 .66309 .87921 .66337 .86784 .64448 Metetra
.577 .654 .888 r
.86784 .64448 .87921 .66337 .90527 .64627 .8957 .6425 Metetra
.771 .968 .925 r
.8957 .6425 .90527 .64627 .92958 .61346 .92206 .62451 Metetra
.92206 .62451 .92958 .61346 .95231 .56932 .94674 .59213 Metetra
0 0 .001 r
.94674 .59213 .95231 .56932 .97398 .51991 .96989 .54929 Metetra
.78 .29 0 r
.36161 .66686 .37517 .6787 .396 .71029 .38246 .69684 Metetra
.646 .144 0 r
.38246 .69684 .396 .71029 .41763 .73733 .4041 .72289 Metetra
0 .209 .711 r
.4041 .72289 .41763 .73733 .44012 .75468 .42659 .74047 Metetra
.342 .594 .939 r
.42659 .74047 .44012 .75468 .46333 .75851 .44984 .74601 Metetra
.679 .759 .912 r
.44984 .74601 .46333 .75851 .48705 .74703 .47366 .73766 Metetra
.827 .819 .842 r
.47366 .73766 .48705 .74703 .51096 .72099 .49777 .71557 Metetra
.9 .853 .786 r
.49777 .71557 .51096 .72099 .53479 .68343 .52188 .68198 Metetra
.94 .878 .748 r
.52188 .68198 .53479 .68343 .55833 .63912 .54579 .64068 Metetra
.958 .901 .725 r
.54579 .64068 .55833 .63912 .58154 .59358 .5694 .59637 Metetra
.959 .923 .725 r
.5694 .59637 .58154 .59358 .60452 .55217 .59272 .5539 Metetra
.943 .941 .757 r
.59272 .5539 .60452 .55217 .62747 .51941 .61591 .5176 Metetra
.896 .941 .833 r
.61591 .5176 .62747 .51941 .65072 .49853 .63923 .49087 Metetra
.776 .866 .915 r
.63923 .49087 .65072 .49853 .67458 .49122 .66295 .47591 Metetra
.578 .683 .912 r
.66295 .47591 .67458 .49122 .69936 .49758 .6874 .47359 Metetra
.405 .493 .836 r
.6874 .47359 .69936 .49758 .72529 .51606 .71283 .48344 Metetra
.315 .376 .766 r
.71283 .48344 .72529 .51606 .75244 .54356 .73941 .50366 Metetra
.286 .324 .726 r
.73941 .50366 .75244 .54356 .78068 .57562 .76717 .53115 Metetra
.293 .314 .712 r
.76717 .53115 .78068 .57562 .8097 .60681 .79596 .56176 Metetra
.322 .333 .717 r
.79596 .56176 .8097 .60681 .83897 .63145 .82544 .59064 Metetra
.371 .382 .742 r
.82544 .59064 .83897 .63145 .86784 .64448 .85511 .61282 Metetra
.449 .477 .796 r
.85511 .61282 .86784 .64448 .8957 .6425 .88437 .62398 Metetra
.584 .666 .895 r
.88437 .62398 .8957 .6425 .92206 .62451 .91265 .62125 Metetra
.745 .974 .925 r
.91265 .62125 .92206 .62451 .94674 .59213 .9395 .6038 Metetra
.9395 .6038 .94674 .59213 .96989 .54929 .96472 .573 Metetra
.753 .255 0 r
.34784 .65484 .36161 .66686 .38246 .69684 .36872 .68319 Metetra
.614 .111 0 r
.36872 .68319 .38246 .69684 .4041 .72289 .39038 .70817 Metetra
0 .207 .711 r
.39038 .70817 .4041 .72289 .42659 .74047 .41287 .72578 Metetra
.288 .56 .93 r
.41287 .72578 .42659 .74047 .44984 .74601 .43615 .73281 Metetra
.629 .738 .926 r
.43615 .73281 .44984 .74601 .47366 .73766 .46005 .72733 Metetra
.795 .811 .865 r
.46005 .72733 .47366 .73766 .49777 .71557 .48432 .70909 Metetra
.88 .851 .81 r
.48432 .70909 .49777 .71557 .52188 .68198 .50869 .67958 Metetra
.928 .881 .768 r
.50869 .67958 .52188 .68198 .54579 .64068 .53295 .64175 Metetra
.952 .906 .739 r
.53295 .64175 .54579 .64068 .5694 .59637 .55694 .59948 Metetra
.958 .927 .726 r
.55694 .59948 .5694 .59637 .59272 .5539 .58065 .55701 Metetra
.948 .946 .74 r
.58065 .55701 .59272 .5539 .61591 .5176 .60415 .51838 Metetra
.921 .957 .793 r
.60415 .51838 .61591 .5176 .63923 .49087 .62763 .48697 Metetra
.853 .93 .877 r
.62763 .48697 .63923 .49087 .66295 .47591 .65134 .46528 Metetra
.709 .807 .927 r
.65134 .46528 .66295 .47591 .6874 .47359 .67557 .45477 Metetra
.528 .617 .884 r
.67557 .45477 .6874 .47359 .71283 .48344 .70059 .45578 Metetra
.4 .463 .809 r
.70059 .45578 .71283 .48344 .73941 .50366 .72661 .46755 Metetra
.339 .375 .753 r
.72661 .46755 .73941 .50366 .76717 .53115 .75378 .48821 Metetra
.32 .337 .721 r
.75378 .48821 .76717 .53115 .79596 .56176 .78209 .51486 Metetra
.328 .331 .71 r
.78209 .51486 .79596 .56176 .82544 .59064 .81138 .54376 Metetra
.352 .349 .716 r
.81138 .54376 .82544 .59064 .85511 .61282 .84133 .57066 Metetra
.393 .394 .741 r
.84133 .57066 .85511 .61282 .88437 .62398 .87147 .59123 Metetra
.459 .479 .792 r
.87147 .59123 .88437 .62398 .91265 .62125 .90123 .60172 Metetra
.574 .654 .891 r
.90123 .60172 .91265 .62125 .9395 .6038 .93008 .5996 Metetra
.715 .959 .946 r
.93008 .5996 .9395 .6038 .96472 .573 .9576 .58397 Metetra
.721 .215 0 r
.33385 .64263 .34784 .65484 .36872 .68319 .35478 .66932 Metetra
.578 .074 0 r
.35478 .66932 .36872 .68319 .39038 .70817 .37646 .69315 Metetra
0 .213 .716 r
.37646 .69315 .39038 .70817 .41287 .72578 .39896 .71064 Metetra
.241 .53 .919 r
.39896 .71064 .41287 .72578 .43615 .73281 .42226 .71889 Metetra
.577 .712 .935 r
.42226 .71889 .43615 .73281 .46005 .72733 .44621 .71601 Metetra
.756 .798 .886 r
.44621 .71601 .46005 .72733 .48432 .70909 .47061 .70144 Metetra
.855 .847 .835 r
.47061 .70144 .48432 .70909 .50869 .67958 .49521 .67606 Metetra
.912 .882 .791 r
.49521 .67606 .50869 .67958 .53295 .64175 .51979 .64205 Metetra
.943 .91 .757 r
.51979 .64205 .53295 .64175 .55694 .59948 .54417 .60252 Metetra
.954 .932 .734 r
.54417 .60252 .55694 .59948 .58065 .55701 .56828 .56107 Metetra
.949 .95 .731 r
.56828 .56107 .58065 .55701 .60415 .51838 .59214 .52131 Metetra
.931 .965 .76 r
.59214 .52131 .60415 .51838 .62763 .48697 .61588 .4865 Metetra
.894 .964 .829 r
.61588 .4865 .62763 .48697 .65134 .46528 .63969 .45926 Metetra
.809 .905 .908 r
.63969 .45926 .65134 .46528 .67557 .45477 .66383 .4414 Metetra
.659 .753 .919 r
.66383 .4414 .67557 .45477 .70059 .45578 .68855 .43389 Metetra
.508 .576 .859 r
.68855 .43389 .70059 .45578 .72661 .46755 .71409 .43675 Metetra
.411 .451 .791 r
.71409 .43675 .72661 .46755 .75378 .48821 .74066 .44911 Metetra
.365 .381 .744 r
.74066 .44911 .75378 .48821 .78209 .51486 .76835 .46921 Metetra
.352 .35 .718 r
.76835 .46921 .78209 .51486 .81138 .54376 .79716 .49446 Metetra
.357 .345 .708 r
.79716 .49446 .81138 .54376 .84133 .57066 .82692 .52158 Metetra
.377 .36 .714 r
.82692 .52158 .84133 .57066 .87147 .59123 .85735 .54687 Metetra
.409 .398 .735 r
.85735 .54687 .87147 .59123 .90123 .60172 .88801 .56661 Metetra
.462 .471 .782 r
.88801 .56661 .90123 .60172 .93008 .5996 .91838 .57748 Metetra
.553 .619 .873 r
.91838 .57748 .93008 .5996 .9576 .58397 .94798 .57711 Metetra
.682 .169 0 r
.31964 .63023 .33385 .64263 .35478 .66932 .34063 .65523 Metetra
.535 .032 0 r
.34063 .65523 .35478 .66932 .37646 .69315 .36234 .67784 Metetra
0 .224 .726 r
.36234 .67784 .37646 .69315 .39896 .71064 .38486 .69504 Metetra
.203 .504 .908 r
.38486 .69504 .39896 .71064 .42226 .71889 .40817 .70425 Metetra
.523 .684 .939 r
.40817 .70425 .42226 .71889 .44621 .71601 .43216 .70368 Metetra
.712 .78 .905 r
.43216 .70368 .44621 .71601 .47061 .70144 .45667 .69255 Metetra
.823 .838 .859 r
.45667 .69255 .47061 .70144 .49521 .67606 .48146 .67125 Metetra
.891 .88 .817 r
.48146 .67125 .49521 .67606 .51979 .64205 .50631 .64131 Metetra
.93 .913 .78 r
.50631 .64131 .51979 .64205 .54417 .60252 .53105 .6051 Metetra
.947 .938 .749 r
.53105 .6051 .54417 .60252 .56828 .56107 .55557 .56559 Metetra
.946 .956 .732 r
.55557 .56559 .56828 .56107 .59214 .52131 .57983 .5259 Metetra
.932 .969 .738 r
.57983 .5259 .59214 .52131 .61588 .4865 .60391 .48902 Metetra
.909 .979 .782 r
.60391 .48902 .61588 .4865 .63969 .45926 .62794 .45756 Metetra
.867 .964 .861 r
.62794 .45756 .63969 .45926 .66383 .4414 .65211 .43351 Metetra
.773 .876 .922 r
.65211 .43351 .66383 .4414 .68855 .43389 .67667 .41824 Metetra
.631 .713 .906 r
.67667 .41824 .68855 .43389 .71409 .43675 .70185 .41238 Metetra
.506 .556 .841 r
.70185 .41238 .71409 .43675 .74066 .44911 .72788 .4158 Metetra
.43 .45 .779 r
.72788 .4158 .74066 .44911 .76835 .46921 .75492 .42767 Metetra
.393 .391 .738 r
.75492 .42767 .76835 .46921 .79716 .49446 .78307 .44642 Metetra
.38 .363 .714 r
.78307 .44642 .79716 .49446 .82692 .52158 .81231 .46983 Metetra
.383 .356 .705 r
.81231 .46983 .82692 .52158 .85735 .54687 .84252 .4951 Metetra
.397 .367 .709 r
.84252 .4951 .85735 .54687 .88801 .56661 .87343 .51909 Metetra
.421 .397 .727 r
.87343 .51909 .88801 .56661 .91838 .57748 .90467 .53858 Metetra
.461 .455 .765 r
.90467 .53858 .91838 .57748 .94798 .57711 .93576 .55062 Metetra
.636 .117 0 r
.3052 .61763 .31964 .63023 .34063 .65523 .32626 .64093 Metetra
0 .015 .515 r
.32626 .64093 .34063 .65523 .36234 .67784 .34802 .66223 Metetra
0 .241 .741 r
.34802 .66223 .36234 .67784 .38486 .69504 .37056 .67897 Metetra
.176 .484 .899 r
.37056 .67897 .38486 .69504 .40817 .70425 .39388 .6889 Metetra
.472 .654 .94 r
.39388 .6889 .40817 .70425 .43216 .70368 .4179 .69032 Metetra
.664 .757 .919 r
.4179 .69032 .43216 .70368 .45667 .69255 .44248 .68235 Metetra
.785 .824 .883 r
.44248 .68235 .45667 .69255 .48146 .67125 .46742 .66501 Metetra
.863 .874 .844 r
.46742 .66501 .48146 .67125 .50631 .64131 .49252 .63925 Metetra
.912 .913 .806 r
.49252 .63925 .50631 .64131 .53105 .6051 .5176 .60682 Metetra
.936 .942 .771 r
.5176 .60682 .53105 .6051 .55557 .56559 .54251 .57005 Metetra
.939 .961 .741 r
.54251 .57005 .55557 .56559 .57983 .5259 .5672 .53155 Metetra
.927 .973 .727 r
.5672 .53155 .57983 .5259 .60391 .48902 .59167 .49395 Metetra
.908 .983 .743 r
.59167 .49395 .60391 .48902 .62794 .45756 .616 .4597 Metetra
.886 .988 .801 r
.616 .4597 .62794 .45756 .65211 .43351 .64035 .43085 Metetra
.844 .961 .883 r
.64035 .43085 .65211 .43351 .67667 .41824 .66489 .40898 Metetra
.75 .855 .927 r
.66489 .40898 .67667 .41824 .70185 .41238 .68986 .3951 Metetra
.622 .693 .894 r
.68986 .3951 .70185 .41238 .72788 .4158 .71547 .38968 Metetra
.518 .551 .829 r
.71547 .38968 .72788 .4158 .75492 .42767 .74192 .39256 Metetra
.453 .457 .773 r
.74192 .39256 .75492 .42767 .78307 .44642 .76936 .40302 Metetra
.42 .403 .734 r
.76936 .40302 .78307 .44642 .81231 .46983 .7979 .41975 Metetra
.407 .375 .712 r
.7979 .41975 .81231 .46983 .84252 .4951 .82752 .44091 Metetra
.406 .367 .702 r
.82752 .44091 .84252 .4951 .87343 .51909 .85813 .4642 Metetra
.415 .373 .703 r
.85813 .4642 .87343 .51909 .90467 .53858 .88951 .48699 Metetra
.432 .394 .716 r
.88951 .48699 .90467 .53858 .93576 .55062 .92134 .50652 Metetra
.581 .058 0 r
.29053 .60483 .3052 .61763 .32626 .64093 .31168 .62639 Metetra
0 .067 .569 r
.31168 .62639 .32626 .64093 .34802 .66223 .3335 .64632 Metetra
0 .264 .759 r
.3335 .64632 .34802 .66223 .37056 .67897 .35606 .66245 Metetra
.159 .47 .892 r
.35606 .66245 .37056 .67897 .39388 .6889 .3794 .67283 Metetra
.426 .626 .936 r
.3794 .67283 .39388 .6889 .4179 .69032 .40344 .67593 Metetra
.614 .73 .928 r
.40344 .67593 .4179 .69032 .44248 .68235 .42807 .67079 Metetra
.741 .804 .902 r
.42807 .67079 .44248 .68235 .46742 .66501 .45313 .65718 Metetra
.829 .862 .871 r
.45313 .65718 .46742 .66501 .49252 .63925 .47843 .63562 Metetra
.887 .909 .836 r
.47843 .63562 .49252 .63925 .5176 .60682 .5038 .60728 Metetra
.92 .944 .799 r
.5038 .60728 .5176 .60682 .54251 .57005 .52909 .57391 Metetra
.929 .967 .761 r
.52909 .57391 .54251 .57005 .5672 .53155 .5542 .5376 Metetra
.918 .978 .729 r
.5542 .5376 .5672 .53155 .59167 .49395 .5791 .50057 Metetra
.897 .984 .718 r
.5791 .50057 .59167 .49395 .616 .4597 .60382 .46501 Metetra
.877 .991 .743 r
.60382 .46501 .616 .4597 .64035 .43085 .62845 .43289 Metetra
.862 .995 .811 r
.62845 .43289 .64035 .43085 .66489 .40898 .65313 .40585 Metetra
.828 .961 .896 r
.65313 .40585 .66489 .40898 .68986 .3951 .67805 .38515 Metetra
.742 .847 .929 r
.67805 .38515 .68986 .3951 .71547 .38968 .7034 .37161 Metetra
.629 .69 .888 r
.7034 .37161 .71547 .38968 .74192 .39256 .72939 .36559 Metetra
.537 .558 .824 r
.72939 .36559 .74192 .39256 .76936 .40302 .7562 .36698 Metetra
.479 .47 .77 r
.7562 .36698 .76936 .40302 .7979 .41975 .78397 .37522 Metetra
.447 .418 .733 r
.78397 .37522 .7979 .41975 .82752 .44091 .81281 .3893 Metetra
.432 .389 .71 r
.81281 .3893 .82752 .44091 .85813 .4642 .84274 .40775 Metetra
.428 .376 .699 r
.84274 .40775 .85813 .4642 .88951 .48699 .87369 .42875 Metetra
.432 .377 .696 r
.87369 .42875 .88951 .48699 .92134 .50652 .90549 .45015 Metetra
.515 0 0 r
.27563 .59182 .29053 .60483 .31168 .62639 .29688 .61163 Metetra
0 .123 .625 r
.29688 .61163 .31168 .62639 .3335 .64632 .31876 .63011 Metetra
0 .291 .781 r
.31876 .63011 .3335 .64632 .35606 .66245 .34137 .64547 Metetra
.153 .463 .889 r
.34137 .64547 .35606 .66245 .3794 .67283 .36472 .65606 Metetra
.388 .6 .931 r
.36472 .65606 .3794 .67283 .40344 .67593 .38877 .66049 Metetra
.564 .7 .932 r
.38877 .66049 .40344 .67593 .42807 .67079 .41343 .65783 Metetra
.692 .778 .917 r
.41343 .65783 .42807 .67079 .45313 .65718 .43858 .64767 Metetra
.787 .843 .894 r
.43858 .64767 .45313 .65718 .47843 .63562 .46405 .63017 Metetra
.854 .898 .866 r
.46405 .63017 .47843 .63562 .5038 .60728 .48967 .60608 Metetra
.897 .942 .831 r
.48967 .60608 .5038 .60728 .52909 .57391 .5153 .57661 Metetra
.914 .971 .789 r
.5153 .57661 .52909 .57391 .5542 .5376 .54082 .54334 Metetra
.906 .984 .745 r
.54082 .54334 .5542 .5376 .5791 .50057 .56616 .50807 Metetra
.881 .985 .709 r
.56616 .50807 .5791 .50057 .60382 .46501 .59132 .47264 Metetra
.854 .984 .699 r
.59132 .47264 .60382 .46501 .62845 .43289 .61633 .43884 Metetra
.838 .991 .731 r
.61633 .43884 .62845 .43289 .65313 .40585 .64129 .40827 Metetra
.835 .999 .809 r
.64129 .40827 .65313 .40585 .67805 .38515 .66633 .38227 Metetra
.816 .969 .9 r
.66633 .38227 .67805 .38515 .7034 .37161 .69161 .36186 Metetra
.747 .858 .931 r
.69161 .36186 .7034 .37161 .72939 .36559 .71732 .34774 Metetra
.647 .706 .89 r
.71732 .34774 .72939 .36559 .7562 .36698 .74363 .34024 Metetra
.563 .578 .827 r
.74363 .34024 .7562 .36698 .78397 .37522 .77073 .33933 Metetra
.507 .49 .773 r
.77073 .33933 .78397 .37522 .81281 .3893 .79876 .34464 Metetra
.474 .436 .735 r
.79876 .34464 .81281 .3893 .84274 .40775 .82781 .35543 Metetra
.457 .404 .71 r
.82781 .35543 .84274 .40775 .87369 .42875 .85795 .37061 Metetra
.449 .387 .696 r
.85795 .37061 .87369 .42875 .90549 .45015 .88913 .38879 Metetra
0 .08 .558 r
.26048 .5786 .27563 .59182 .29688 .61163 .28184 .59663 Metetra
0 .184 .681 r
.28184 .59663 .29688 .61163 .31876 .63011 .30382 .6136 Metetra
0 .323 .805 r
.30382 .6136 .31876 .63011 .34137 .64547 .32647 .62805 Metetra
.157 .463 .888 r
.32647 .62805 .34137 .64547 .36472 .65606 .34984 .63858 Metetra
.36 .578 .925 r
.34984 .63858 .36472 .65606 .38877 .66049 .3739 .64401 Metetra
.519 .67 .932 r
.3739 .64401 .38877 .66049 .41343 .65783 .39859 .64344 Metetra
.642 .747 .925 r
.39859 .64344 .41343 .65783 .43858 .64767 .4238 .63636 Metetra
.738 .816 .913 r
.4238 .63636 .43858 .64767 .46405 .63017 .44939 .62272 Metetra
.813 .879 .894 r
.44939 .62272 .46405 .63017 .48967 .60608 .47522 .60287 Metetra
.866 .932 .866 r
.47522 .60287 .48967 .60608 .5153 .57661 .50114 .5776 Metetra
.892 .971 .825 r
.50114 .5776 .5153 .57661 .54082 .54334 .52704 .54803 Metetra
.89 .99 .774 r
.52704 .54803 .54082 .54334 .56616 .50807 .55283 .51553 Metetra
.864 .988 .719 r
.55283 .51553 .56616 .50807 .59132 .47264 .57845 .48157 Metetra
.826 .976 .677 r
.57845 .48157 .59132 .47264 .61633 .43884 .60391 .44768 Metetra
.794 .969 .665 r
.60391 .44768 .61633 .43884 .64129 .40827 .62925 .41531 Metetra
.785 .978 .7 r
.62925 .41531 .64129 .40827 .66633 .38227 .65457 .38576 Metetra
.798 .997 .787 r
.65457 .38576 .66633 .38227 .69161 .36186 .67997 .36013 Metetra
.805 .985 .891 r
.67997 .36013 .69161 .36186 .71732 .34774 .7056 .33929 Metetra
.761 .889 .935 r
.7056 .33929 .71732 .34774 .74363 .34024 .73164 .32384 Metetra
.676 .742 .901 r
.73164 .32384 .74363 .34024 .77073 .33933 .75824 .31414 Metetra
.595 .612 .838 r
.75824 .31414 .77073 .33933 .79876 .34464 .78556 .31025 Metetra
.539 .52 .782 r
.78556 .31025 .79876 .34464 .82781 .35543 .81376 .31197 Metetra
.503 .46 .742 r
.81376 .31197 .82781 .35543 .85795 .37061 .84293 .31883 Metetra
.482 .423 .714 r
.84293 .31883 .85795 .37061 .88913 .38879 .87316 .33007 Metetra
0 .157 .635 r
.24509 .56517 .26048 .5786 .28184 .59663 .26658 .58139 Metetra
0 .247 .736 r
.26658 .58139 .28184 .59663 .30382 .6136 .28865 .59679 Metetra
0 .359 .829 r
.28865 .59679 .30382 .6136 .32647 .62805 .31137 .61018 Metetra
.172 .468 .89 r
.31137 .61018 .32647 .62805 .34984 .63858 .33477 .62042 Metetra
.341 .562 .919 r
.33477 .62042 .34984 .63858 .3739 .64401 .35884 .6265 Metetra
.48 .643 .928 r
.35884 .6265 .3739 .64401 .39859 .64344 .38354 .62761 Metetra
.593 .714 .928 r
.38354 .62761 .39859 .64344 .4238 .63636 .40879 .62321 Metetra
.687 .783 .924 r
.40879 .62321 .4238 .63636 .44939 .62272 .43447 .61308 Metetra
.764 .849 .915 r
.43447 .61308 .44939 .62272 .47522 .60287 .46046 .59731 Metetra
.825 .912 .898 r
.46046 .59731 .47522 .60287 .50114 .5776 .48663 .57636 Metetra
.862 .962 .866 r
.48663 .57636 .50114 .5776 .52704 .54803 .51287 .55093 Metetra
.87 .992 .816 r
.51287 .55093 .52704 .54803 .55283 .51553 .53907 .52199 Metetra
.846 .994 .749 r
.53907 .52199 .55283 .51553 .57845 .48157 .56516 .49066 Metetra
.799 .974 .68 r
.56516 .49066 .57845 .48157 .60391 .44768 .59112 .45816 Metetra
.748 .947 .627 r
.59112 .45816 .60391 .44768 .62925 .41531 .61693 .4257 Metetra
.713 .932 .609 r
.61693 .4257 .62925 .41531 .65457 .38576 .64265 .39446 Metetra
.707 .942 .641 r
.64265 .39446 .65457 .38576 .67997 .36013 .66834 .3655 Metetra
.736 .976 .731 r
.66834 .3655 .67997 .36013 .7056 .33929 .69412 .33973 Metetra
.777 .997 .855 r
.69412 .33973 .7056 .33929 .73164 .32384 .72011 .31792 Metetra
.775 .939 .934 r
.72011 .31792 .73164 .32384 .75824 .31414 .74645 .30061 Metetra
.713 .804 .921 r
.74645 .30061 .75824 .31414 .78556 .31025 .77329 .28818 Metetra
.637 .666 .861 r
.77329 .28818 .78556 .31025 .81376 .31197 .80079 .28077 Metetra
.577 .563 .801 r
.80079 .28077 .81376 .31197 .84293 .31883 .82907 .27835 Metetra
.536 .493 .755 r
.82907 .27835 .84293 .31883 .87316 .33007 .85827 .28066 Metetra
0 .237 .709 r
.22944 .55151 .24509 .56517 .26658 .58139 .25108 .5659 Metetra
0 .311 .787 r
.25108 .5659 .26658 .58139 .28865 .59679 .27326 .57967 Metetra
.036 .397 .853 r
.27326 .57967 .28865 .59679 .31137 .61018 .29606 .59186 Metetra
.194 .479 .894 r
.29606 .59186 .31137 .61018 .33477 .62042 .31951 .60158 Metetra
.334 .553 .914 r
.31951 .60158 .33477 .62042 .35884 .6265 .3436 .60797 Metetra
.451 .619 .922 r
.3436 .60797 .35884 .6265 .38354 .62761 .36831 .61034 Metetra
.55 .682 .925 r
.36831 .61034 .38354 .62761 .40879 .62321 .39357 .60816 Metetra
.636 .745 .927 r
.39357 .60816 .40879 .62321 .43447 .61308 .41931 .60112 Metetra
.711 .811 .928 r
.41931 .60112 .43447 .61308 .46046 .59731 .44542 .58914 Metetra
.774 .878 .922 r
.44542 .58914 .46046 .59731 .48663 .57636 .47179 .5724 Metetra
.822 .94 .904 r
.47179 .5724 .48663 .57636 .51287 .55093 .49831 .55131 Metetra
.843 .985 .865 r
.49831 .55131 .51287 .55093 .53907 .52199 .52489 .52649 Metetra
.828 1 .799 r
.52489 .52649 .53907 .52199 .56516 .49066 .55143 .4987 Metetra
.78 .98 .712 r
.55143 .4987 .56516 .49066 .59112 .45816 .57788 .46884 Metetra
.712 .938 .625 r
.57788 .46884 .59112 .45816 .61693 .4257 .60422 .43788 Metetra
.647 .894 .558 r
.60422 .43788 .61693 .4257 .64265 .39446 .63044 .40678 Metetra
.605 .868 .528 r
.63044 .40678 .64265 .39446 .66834 .3655 .65657 .37648 Metetra
.597 .873 .549 r
.65657 .37648 .66834 .3655 .69412 .33973 .68269 .34785 Metetra
.632 .915 .629 r
.68269 .34785 .69412 .33973 .72011 .31792 .70887 .32167 Metetra
.702 .975 .765 r
.70887 .32167 .72011 .31792 .74645 .30061 .73522 .29858 Metetra
.762 .986 .9 r
.73522 .29858 .74645 .30061 .77329 .28818 .76186 .2791 Metetra
.751 .894 .943 r
.76186 .2791 .77329 .28818 .80079 .28077 .78893 .26362 Metetra
.689 .752 .9 r
.78893 .26362 .80079 .28077 .82907 .27835 .81656 .25235 Metetra
.625 .63 .835 r
.81656 .25235 .82907 .27835 .85827 .28066 .84489 .24539 Metetra
0 .317 .778 r
.21353 .53762 .22944 .55151 .25108 .5659 .23533 .55016 Metetra
0 .374 .833 r
.23533 .55016 .25108 .5659 .27326 .57967 .25765 .56224 Metetra
.098 .436 .875 r
.25765 .56224 .27326 .57967 .29606 .59186 .28054 .57312 Metetra
.225 .495 .899 r
.28054 .57312 .29606 .59186 .31951 .60158 .30405 .58208 Metetra
.337 .549 .91 r
.30405 .58208 .31951 .60158 .3436 .60797 .32817 .58846 Metetra
.433 .6 .915 r
.32817 .58846 .3436 .60797 .36831 .61034 .35289 .59166 Metetra
.516 .652 .919 r
.35289 .59166 .36831 .61034 .39357 .60816 .37816 .59121 Metetra
.59 .707 .924 r
.37816 .59121 .39357 .60816 .41931 .60112 .40394 .58676 Metetra
.657 .767 .93 r
.40394 .58676 .41931 .60112 .44542 .58914 .43013 .57813 Metetra
.719 .833 .935 r
.43013 .57813 .44542 .58914 .47179 .5724 .45665 .56534 Metetra
.771 .9 .933 r
.45665 .56534 .47179 .5724 .49831 .55131 .4834 .54854 Metetra
.805 .96 .912 r
.4834 .54854 .49831 .55131 .52489 .52649 .51029 .52808 Metetra
.807 .996 .861 r
.51029 .52808 .52489 .52649 .55143 .4987 .53724 .50443 Metetra
.767 .991 .775 r
.53724 .50443 .55143 .4987 .57788 .46884 .56417 .4782 Metetra
.693 .946 .665 r
.56417 .4782 .57788 .46884 .60422 .43788 .59105 .45007 Metetra
.605 .879 .557 r
.59105 .45007 .60422 .43788 .63044 .40678 .61782 .42077 Metetra
.528 .817 .474 r
.61782 .42077 .63044 .40678 .65657 .37648 .64451 .39107 Metetra
.64451 .39107 .65657 .37648 .68269 .34785 .67112 .36171 Metetra
.67112 .36171 .68269 .34785 .70887 .32167 .69771 .33338 Metetra
.69771 .33338 .70887 .32167 .73522 .29858 .72433 .30673 Metetra
.549 .873 .595 r
.72433 .30673 .73522 .29858 .76186 .2791 .75108 .28233 Metetra
.658 .961 .766 r
.75108 .28233 .76186 .2791 .78893 .26362 .77805 .26064 Metetra
.743 .981 .913 r
.77805 .26064 .78893 .26362 .81656 .25235 .80536 .24206 Metetra
.742 .882 .944 r
.80536 .24206 .81656 .25235 .84489 .24539 .83313 .22685 Metetra
0 .395 .837 r
.19735 .52351 .21353 .53762 .23533 .55016 .21933 .53417 Metetra
.055 .434 .872 r
.21933 .53417 .23533 .55016 .25765 .56224 .2418 .5445 Metetra
.161 .474 .895 r
.2418 .5445 .25765 .56224 .28054 .57312 .26481 .55394 Metetra
.261 .513 .905 r
.26481 .55394 .28054 .57312 .30405 .58208 .28839 .56195 Metetra
.349 .55 .908 r
.28839 .56195 .30405 .58208 .32817 .58846 .31256 .56799 Metetra
.425 .587 .909 r
.31256 .56799 .32817 .58846 .35289 .59166 .33729 .5716 Metetra
.492 .627 .911 r
.33729 .5716 .35289 .59166 .37816 .59121 .36258 .57236 Metetra
.553 .671 .916 r
.36258 .57236 .37816 .59121 .40394 .58676 .38837 .56995 Metetra
.61 .722 .925 r
.38837 .56995 .40394 .58676 .43013 .57813 .41462 .56415 Metetra
.664 .78 .935 r
.41462 .56415 .43013 .57813 .45665 .56534 .44124 .55484 Metetra
.714 .846 .945 r
.44124 .55484 .45665 .56534 .4834 .54854 .46816 .54206 Metetra
.755 .913 .944 r
.46816 .54206 .4834 .54854 .51029 .52808 .49531 .52592 Metetra
.775 .97 .921 r
.49531 .52592 .51029 .52808 .53724 .50443 .52261 .50667 Metetra
.757 .995 .857 r
.52261 .50667 .53724 .50443 .56417 .4782 .54998 .48468 Metetra
.692 .969 .749 r
.54998 .48468 .56417 .4782 .59105 .45007 .57736 .46036 Metetra
.595 .897 .616 r
.57736 .46036 .59105 .45007 .61782 .42077 .60471 .43422 Metetra
.60471 .43422 .61782 .42077 .64451 .39107 .632 .40681 Metetra
.632 .40681 .64451 .39107 .67112 .36171 .65923 .3787 Metetra
.65923 .3787 .67112 .36171 .69771 .33338 .68639 .35046 Metetra
.68639 .35046 .69771 .33338 .72433 .30673 .71351 .32264 Metetra
.71351 .32264 .72433 .30673 .75108 .28233 .74065 .29576 Metetra
.74065 .29576 .75108 .28233 .77805 .26064 .76787 .27031 Metetra
.76787 .27031 .77805 .26064 .80536 .24206 .79524 .24671 Metetra
.562 .908 .691 r
.79524 .24671 .80536 .24206 .83313 .22685 .82286 .22532 Metetra
.06 .466 .885 r
.1809 .50915 .19735 .52351 .21933 .53417 .20308 .51791 Metetra
.143 .489 .903 r
.20308 .51791 .21933 .53417 .2418 .5445 .22572 .52644 Metetra
.226 .512 .91 r
.22572 .52644 .2418 .5445 .26481 .55394 .24886 .53434 Metetra
.302 .534 .91 r
.24886 .53434 .26481 .55394 .28839 .56195 .27254 .54119 Metetra
.369 .557 .906 r
.27254 .54119 .28839 .56195 .31256 .56799 .29677 .5466 Metetra
.427 .581 .903 r
.29677 .5466 .31256 .56799 .33729 .5716 .32154 .55021 Metetra
.479 .608 .902 r
.32154 .55021 .33729 .5716 .36258 .57236 .34684 .55167 Metetra
.527 .641 .905 r
.34684 .55167 .36258 .57236 .38837 .56995 .37265 .55071 Metetra
.572 .68 .913 r
.37265 .55071 .38837 .56995 .41462 .56415 .39892 .54711 Metetra
.616 .727 .925 r
.39892 .54711 .41462 .56415 .44124 .55484 .42561 .54071 Metetra
.659 .782 .94 r
.42561 .54071 .44124 .55484 .46816 .54206 .45265 .53144 Metetra
.699 .847 .953 r
.45265 .53144 .46816 .54206 .49531 .52592 .48 .51929 Metetra
.73 .914 .957 r
.48 .51929 .49531 .52592 .52261 .50667 .50757 .50436 Metetra
.737 .968 .933 r
.50757 .50436 .52261 .50667 .54998 .48468 .5353 .4868 Metetra
.703 .984 .862 r
.5353 .4868 .54998 .48468 .57736 .46036 .56315 .46685 Metetra
.618 .941 .736 r
.56315 .46685 .57736 .46036 .60471 .43422 .59104 .44479 Metetra
.502 .848 .581 r
.59104 .44479 .60471 .43422 .632 .40681 .61894 .42097 Metetra
.61894 .42097 .632 .40681 .65923 .3787 .64682 .39577 Metetra
.64682 .39577 .65923 .3787 .68639 .35046 .67467 .3696 Metetra
.67467 .3696 .68639 .35046 .71351 .32264 .70246 .34288 Metetra
.70246 .34288 .71351 .32264 .74065 .29576 .73023 .31603 Metetra
.73023 .31603 .74065 .29576 .76787 .27031 .758 .28945 Metetra
.758 .28945 .76787 .27031 .79524 .24671 .7858 .26354 Metetra
.7858 .26354 .79524 .24671 .82286 .22532 .81369 .23866 Metetra
.162 .53 .921 r
.16417 .49455 .1809 .50915 .20308 .51791 .18656 .50139 Metetra
.227 .539 .925 r
.18656 .50139 .20308 .51791 .22572 .52644 .20939 .50808 Metetra
.29 .547 .921 r
.20939 .50808 .22572 .52644 .24886 .53434 .2327 .51432 Metetra
.346 .556 .913 r
.2327 .51432 .24886 .53434 .27254 .54119 .2565 .51983 Metetra
.395 .566 .904 r
.2565 .51983 .27254 .54119 .29677 .5466 .2808 .52433 Metetra
.438 .579 .897 r
.2808 .52433 .29677 .5466 .32154 .55021 .30562 .52754 Metetra
.477 .596 .893 r
.30562 .52754 .32154 .55021 .34684 .55167 .33095 .5292 Metetra
.513 .617 .893 r
.33095 .5292 .34684 .55167 .37265 .55071 .35677 .5291 Metetra
.547 .644 .898 r
.35677 .5291 .37265 .55071 .39892 .54711 .38306 .52703 Metetra
.58 .678 .907 r
.38306 .52703 .39892 .54711 .42561 .54071 .40979 .52284 Metetra
.613 .721 .922 r
.40979 .52284 .42561 .54071 .45265 .53144 .43692 .51641 Metetra
.646 .772 .94 r
.43692 .51641 .45265 .53144 .48 .51929 .46439 .50769 Metetra
.677 .833 .958 r
.46439 .50769 .48 .51929 .50757 .50436 .49217 .49664 Metetra
.7 .898 .968 r
.49217 .49664 .50757 .50436 .5353 .4868 .5202 .48331 Metetra
.7 .954 .952 r
.5202 .48331 .5353 .4868 .56315 .46685 .54842 .46779 Metetra
.659 .971 .885 r
.54842 .46779 .56315 .46685 .59104 .44479 .57678 .4502 Metetra
.565 .925 .754 r
.57678 .4502 .59104 .44479 .61894 .42097 .60525 .43072 Metetra
.437 .82 .584 r
.60525 .43072 .61894 .42097 .64682 .39577 .63378 .40957 Metetra
.63378 .40957 .64682 .39577 .67467 .3696 .66233 .38698 Metetra
.66233 .38698 .67467 .3696 .70246 .34288 .69089 .36323 Metetra
.69089 .36323 .70246 .34288 .73023 .31603 .71944 .33861 Metetra
.71944 .33861 .73023 .31603 .758 .28945 .74797 .31341 Metetra
.74797 .31341 .758 .28945 .7858 .26354 .7765 .28792 Metetra
.7765 .28792 .7858 .26354 .81369 .23866 .80505 .26245 Metetra
.256 .584 .945 r
.14715 .47969 .16417 .49455 .18656 .50139 .16978 .48459 Metetra
.305 .582 .939 r
.16978 .48459 .18656 .50139 .20939 .50808 .19282 .48939 Metetra
.351 .579 .928 r
.19282 .48939 .20939 .50808 .2327 .51432 .21631 .4939 Metetra
.391 .578 .914 r
.21631 .4939 .2327 .51432 .2565 .51983 .24025 .4979 Metetra
.426 .579 .902 r
.24025 .4979 .2565 .51983 .2808 .52433 .26466 .50123 Metetra
.456 .582 .891 r
.26466 .50123 .2808 .52433 .30562 .52754 .28955 .50367 Metetra
.484 .59 .884 r
.28955 .50367 .30562 .52754 .33095 .5292 .31493 .50506 Metetra
.509 .601 .881 r
.31493 .50506 .33095 .5292 .35677 .5291 .34078 .50522 Metetra
.534 .617 .882 r
.34078 .50522 .35677 .5291 .38306 .52703 .36709 .504 Metetra
.557 .639 .887 r
.36709 .504 .38306 .52703 .40979 .52284 .39384 .50126 Metetra
.581 .667 .898 r
.39384 .50126 .40979 .52284 .43692 .51641 .42101 .49689 Metetra
.605 .703 .913 r
.42101 .49689 .43692 .51641 .46439 .50769 .44857 .49081 Metetra
.63 .747 .932 r
.44857 .49081 .46439 .50769 .49217 .49664 .47649 .48294 Metetra
.653 .802 .954 r
.47649 .48294 .49217 .49664 .5202 .48331 .50472 .47326 Metetra
.671 .863 .973 r
.50472 .47326 .5202 .48331 .54842 .46779 .53323 .46177 Metetra
.672 .922 .974 r
.53323 .46177 .54842 .46779 .57678 .4502 .56198 .44849 Metetra
.639 .956 .933 r
.56198 .44849 .57678 .4502 .60525 .43072 .59092 .43348 Metetra
.553 .931 .824 r
.59092 .43348 .60525 .43072 .63378 .40957 .62002 .41684 Metetra
.423 .836 .654 r
.62002 .41684 .63378 .40957 .66233 .38698 .64924 .39866 Metetra
.64924 .39866 .66233 .38698 .69089 .36323 .67855 .37909 Metetra
.67855 .37909 .69089 .36323 .71944 .33861 .70792 .35829 Metetra
.70792 .35829 .71944 .33861 .74797 .31341 .73734 .33642 Metetra
.004 0 0 r
.73734 .33642 .74797 .31341 .7765 .28792 .76678 .31368 Metetra
.055 0 0 r
.76678 .31368 .7765 .28792 .80505 .26245 .79624 .29026 Metetra
.34 .628 .959 r
.12983 .46458 .14715 .47969 .16978 .48459 .15272 .46752 Metetra
.376 .618 .946 r
.15272 .46752 .16978 .48459 .19282 .48939 .176 .47039 Metetra
.408 .608 .93 r
.176 .47039 .19282 .48939 .21631 .4939 .19968 .47307 Metetra
.435 .599 .913 r
.19968 .47307 .21631 .4939 .24025 .4979 .22379 .47543 Metetra
.459 .592 .898 r
.22379 .47543 .24025 .4979 .26466 .50123 .24834 .47734 Metetra
.48 .589 .885 r
.24834 .47734 .26466 .50123 .28955 .50367 .27334 .4787 Metetra
.499 .589 .876 r
.27334 .4787 .28955 .50367 .31493 .50506 .29878 .47936 Metetra
.516 .592 .869 r
.29878 .47936 .31493 .50506 .34078 .50522 .32467 .47923 Metetra
.532 .599 .866 r
.32467 .47923 .34078 .50522 .36709 .504 .35101 .47818 Metetra
.548 .61 .867 r
.35101 .47818 .36709 .504 .39384 .50126 .37778 .47612 Metetra
.563 .626 .872 r
.37778 .47612 .39384 .50126 .42101 .49689 .40498 .47296 Metetra
.579 .647 .881 r
.40498 .47296 .42101 .49689 .44857 .49081 .43259 .46861 Metetra
.596 .674 .895 r
.43259 .46861 .44857 .49081 .47649 .48294 .46059 .46301 Metetra
.613 .709 .913 r
.46059 .46301 .47649 .48294 .50472 .47326 .48896 .45609 Metetra
.63 .752 .935 r
.48896 .45609 .50472 .47326 .53323 .46177 .51766 .44783 Metetra
.645 .805 .96 r
.51766 .44783 .53323 .46177 .56198 .44849 .54668 .4382 Metetra
.652 .863 .979 r
.54668 .4382 .56198 .44849 .59092 .43348 .57598 .42718 Metetra
.639 .916 .979 r
.57598 .42718 .59092 .43348 .62002 .41684 .60553 .4148 Metetra
.589 .939 .932 r
.60553 .4148 .62002 .41684 .64924 .39866 .63531 .40108 Metetra
.486 .899 .812 r
.63531 .40108 .64924 .39866 .67855 .37909 .66527 .38605 Metetra
.344 .789 .631 r
.66527 .38605 .67855 .37909 .70792 .35829 .69541 .36978 Metetra
.69541 .36978 .70792 .35829 .73734 .33642 .72568 .35233 Metetra
.72568 .35233 .73734 .33642 .76678 .31368 .75607 .3338 Metetra
.012 0 0 r
.75607 .3338 .76678 .31368 .79624 .29026 .78655 .31428 Metetra
.414 .664 .963 r
.11221 .4492 .12983 .46458 .15272 .46752 .13538 .45016 Metetra
.44 .648 .947 r
.13538 .45016 .15272 .46752 .176 .47039 .15892 .45106 Metetra
.461 .632 .928 r
.15892 .45106 .176 .47039 .19968 .47307 .18283 .45184 Metetra
.479 .618 .91 r
.18283 .45184 .19968 .47307 .22379 .47543 .20714 .45242 Metetra
.494 .607 .894 r
.20714 .45242 .22379 .47543 .24834 .47734 .23185 .45273 Metetra
.507 .598 .879 r
.23185 .45273 .24834 .47734 .27334 .4787 .25697 .4527 Metetra
.518 .591 .867 r
.25697 .4527 .27334 .4787 .29878 .47936 .28251 .45225 Metetra
.529 .588 .858 r
.28251 .45225 .29878 .47936 .32467 .47923 .30847 .45131 Metetra
.539 .588 .852 r
.30847 .45131 .32467 .47923 .35101 .47818 .33485 .44981 Metetra
.548 .591 .848 r
.33485 .44981 .35101 .47818 .37778 .47612 .36166 .44769 Metetra
.558 .597 .848 r
.36166 .44769 .37778 .47612 .40498 .47296 .38888 .44488 Metetra
.568 .606 .851 r
.38888 .44488 .40498 .47296 .43259 .46861 .41652 .44132 Metetra
.578 .619 .857 r
.41652 .44132 .43259 .46861 .46059 .46301 .44456 .43695 Metetra
.588 .637 .867 r
.44456 .43695 .46059 .46301 .48896 .45609 .473 .43174 Metetra
.599 .661 .881 r
.473 .43174 .48896 .45609 .51766 .44783 .50181 .42562 Metetra
.611 .69 .899 r
.50181 .42562 .51766 .44783 .54668 .4382 .531 .41858 Metetra
.622 .727 .922 r
.531 .41858 .54668 .4382 .57598 .42718 .56053 .41057 Metetra
.632 .772 .947 r
.56053 .41057 .57598 .42718 .60553 .4148 .59039 .40157 Metetra
.637 .824 .972 r
.59039 .40157 .60553 .4148 .63531 .40108 .62056 .39158 Metetra
.629 .878 .988 r
.62056 .39158 .63531 .40108 .66527 .38605 .65102 .38057 Metetra
.593 .917 .973 r
.65102 .38057 .66527 .38605 .69541 .36978 .68175 .36857 Metetra
.512 .912 .899 r
.68175 .36857 .69541 .36978 .72568 .35233 .71273 .35556 Metetra
.383 .837 .75 r
.71273 .35556 .72568 .35233 .75607 .3338 .74394 .34157 Metetra
.74394 .34157 .75607 .3338 .78655 .31428 .77536 .32664 Metetra
.479 .692 .961 r
.09428 .43355 .11221 .4492 .13538 .45016 .11775 .43251 Metetra
.495 .672 .943 r
.11775 .43251 .13538 .45016 .15892 .45106 .14157 .43141 Metetra
.509 .653 .924 r
.14157 .43141 .15892 .45106 .18283 .45184 .16574 .43023 Metetra
.519 .636 .905 r
.16574 .43023 .18283 .45184 .20714 .45242 .19027 .42893 Metetra
.528 .621 .888 r
.19027 .42893 .20714 .45242 .23185 .45273 .21517 .42746 Metetra
.535 .608 .872 r
.21517 .42746 .23185 .45273 .25697 .4527 .24045 .42579 Metetra
.542 .597 .859 r
.24045 .42579 .25697 .4527 .28251 .45225 .26612 .42388 Metetra
.547 .589 .848 r
.26612 .42388 .28251 .45225 .30847 .45131 .29218 .42169 Metetra
.552 .583 .839 r
.29218 .42169 .30847 .45131 .33485 .44981 .31863 .41918 Metetra
.557 .58 .832 r
.31863 .41918 .33485 .44981 .36166 .44769 .34549 .41632 Metetra
.562 .578 .828 r
.34549 .41632 .36166 .44769 .38888 .44488 .37275 .41306 Metetra
.567 .579 .825 r
.37275 .41306 .38888 .44488 .41652 .44132 .40041 .40938 Metetra
.573 .583 .825 r
.40041 .40938 .41652 .44132 .44456 .43695 .42847 .40524 Metetra
.578 .589 .828 r
.42847 .40524 .44456 .43695 .473 .43174 .45694 .40059 Metetra
.584 .598 .832 r
.45694 .40059 .473 .43174 .50181 .42562 .4858 .39543 Metetra
.59 .61 .84 r
.4858 .39543 .50181 .42562 .531 .41858 .51505 .3897 Metetra
.597 .626 .851 r
.51505 .3897 .531 .41858 .56053 .41057 .54469 .38339 Metetra
.604 .645 .864 r
.54469 .38339 .56053 .41057 .59039 .40157 .57471 .37646 Metetra
.612 .67 .882 r
.57471 .37646 .59039 .40157 .62056 .39158 .6051 .36891 Metetra
.619 .701 .903 r
.6051 .36891 .62056 .39158 .65102 .38057 .63586 .3607 Metetra
.626 .739 .928 r
.63586 .3607 .65102 .38057 .68175 .36857 .66697 .35182 Metetra
.629 .784 .956 r
.66697 .35182 .68175 .36857 .71273 .35556 .69842 .34226 Metetra
.625 .834 .98 r
.69842 .34226 .71273 .35556 .74394 .34157 .7302 .332 Metetra
.604 .881 .991 r
.7302 .332 .74394 .34157 .77536 .32664 .7623 .32104 Metetra
.534 .714 .955 r
.07603 .41762 .09428 .43355 .11775 .43251 .09983 .41455 Metetra
.544 .692 .936 r
.09983 .41455 .11775 .43251 .14157 .43141 .12395 .41144 Metetra
.551 .671 .917 r
.12395 .41144 .14157 .43141 .16574 .43023 .1484 .40824 Metetra
.557 .651 .898 r
.1484 .40824 .16574 .43023 .19027 .42893 .17318 .40496 Metetra
.561 .634 .881 r
.17318 .40496 .19027 .42893 .21517 .42746 .1983 .40158 Metetra
.564 .618 .865 r
.1983 .40158 .21517 .42746 .24045 .42579 .22378 .39807 Metetra
.566 .605 .851 r
.22378 .39807 .24045 .42579 .26612 .42388 .24961 .39442 Metetra
.568 .593 .838 r
.24961 .39442 .26612 .42388 .29218 .42169 .2758 .39062 Metetra
.57 .583 .827 r
.2758 .39062 .29218 .42169 .31863 .41918 .30236 .38664 Metetra
.572 .575 .818 r
.30236 .38664 .31863 .41918 .34549 .41632 .32929 .38247 Metetra
.573 .569 .81 r
.32929 .38247 .34549 .41632 .37275 .41306 .3566 .37808 Metetra
.575 .564 .804 r
.3566 .37808 .37275 .41306 .40041 .40938 .38429 .37347 Metetra
.577 .561 .8 r
.38429 .37347 .40041 .40938 .42847 .40524 .41237 .36862 Metetra
.579 .56 .797 r
.41237 .36862 .42847 .40524 .45694 .40059 .44084 .36351 Metetra
.581 .56 .795 r
.44084 .36351 .45694 .40059 .4858 .39543 .4697 .35811 Metetra
.583 .561 .795 r
.4697 .35811 .4858 .39543 .51505 .3897 .49896 .35242 Metetra
.586 .564 .797 r
.49896 .35242 .51505 .3897 .54469 .38339 .52862 .34643 Metetra
.589 .569 .8 r
.52862 .34643 .54469 .38339 .57471 .37646 .55867 .3401 Metetra
.592 .576 .804 r
.55867 .3401 .57471 .37646 .6051 .36891 .58912 .33343 Metetra
.596 .585 .811 r
.58912 .33343 .6051 .36891 .63586 .3607 .61998 .3264 Metetra
.6 .597 .82 r
.61998 .3264 .63586 .3607 .66697 .35182 .65123 .319 Metetra
.604 .611 .831 r
.65123 .319 .66697 .35182 .69842 .34226 .68288 .31122 Metetra
.609 .629 .845 r
.68288 .31122 .69842 .34226 .7302 .332 .71493 .30303 Metetra
.615 .65 .862 r
.71493 .30303 .7302 .332 .7623 .32104 .74737 .29444 Metetra
.581 .73 .945 r
.05745 .4014 .07603 .41762 .09983 .41455 .0816 .3963 Metetra
.586 .707 .926 r
.0816 .3963 .09983 .41455 .12395 .41144 .10605 .39113 Metetra
.589 .685 .908 r
.10605 .39113 .12395 .41144 .1484 .40824 .13081 .38588 Metetra
.591 .665 .89 r
.13081 .38588 .1484 .40824 .17318 .40496 .15587 .38056 Metetra
.592 .646 .873 r
.15587 .38056 .17318 .40496 .1983 .40158 .18125 .37516 Metetra
.592 .629 .857 r
.18125 .37516 .1983 .40158 .22378 .39807 .20694 .36966 Metetra
.592 .613 .842 r
.20694 .36966 .22378 .39807 .24961 .39442 .23297 .36407 Metetra
.591 .599 .829 r
.23297 .36407 .24961 .39442 .2758 .39062 .25932 .35837 Metetra
.59 .587 .817 r
.25932 .35837 .2758 .39062 .30236 .38664 .28602 .35257 Metetra
.589 .576 .806 r
.28602 .35257 .30236 .38664 .32929 .38247 .31305 .34665 Metetra
.589 .567 .797 r
.31305 .34665 .32929 .38247 .3566 .37808 .34044 .3406 Metetra
.588 .558 .788 r
.34044 .3406 .3566 .37808 .38429 .37347 .36819 .33443 Metetra
.587 .551 .781 r
.36819 .33443 .38429 .37347 .41237 .36862 .39629 .32813 Metetra
.587 .544 .774 r
.39629 .32813 .41237 .36862 .44084 .36351 .42476 .32168 Metetra
.587 .539 .769 r
.42476 .32168 .44084 .36351 .4697 .35811 .45361 .31508 Metetra
.586 .535 .764 r
.45361 .31508 .4697 .35811 .49896 .35242 .48283 .30833 Metetra
.586 .531 .76 r
.48283 .30833 .49896 .35242 .52862 .34643 .51244 .30142 Metetra
.586 .529 .757 r
.51244 .30142 .52862 .34643 .55867 .3401 .54243 .29434 Metetra
.587 .527 .755 r
.54243 .29434 .55867 .3401 .58912 .33343 .57282 .28708 Metetra
.587 .526 .754 r
.57282 .28708 .58912 .33343 .61998 .3264 .60361 .27964 Metetra
.588 .526 .753 r
.60361 .27964 .61998 .3264 .65123 .319 .63481 .27202 Metetra
.589 .527 .754 r
.63481 .27202 .65123 .319 .68288 .31122 .66642 .2642 Metetra
.59 .529 .755 r
.66642 .2642 .68288 .31122 .71493 .30303 .69844 .25617 Metetra
.591 .532 .757 r
.69844 .25617 .71493 .30303 .74737 .29444 .73088 .24794 Metetra
.622 .742 .933 r
.03853 .38489 .05745 .4014 .0816 .3963 .06306 .37773 Metetra
.623 .719 .915 r
.06306 .37773 .0816 .3963 .10605 .39113 .08787 .37048 Metetra
.623 .697 .898 r
.08787 .37048 .10605 .39113 .13081 .38588 .11296 .36316 Metetra
.622 .676 .88 r
.11296 .36316 .13081 .38588 .15587 .38056 .13833 .35575 Metetra
.62 .657 .864 r
.13833 .35575 .15587 .38056 .18125 .37516 .16399 .34826 Metetra
.618 .639 .849 r
.16399 .34826 .18125 .37516 .20694 .36966 .18994 .34067 Metetra
.616 .622 .834 r
.18994 .34067 .20694 .36966 .23297 .36407 .21619 .333 Metetra
.613 .607 .821 r
.21619 .333 .23297 .36407 .25932 .35837 .24274 .32523 Metetra
.611 .593 .809 r
.24274 .32523 .25932 .35837 .28602 .35257 .2696 .31737 Metetra
.609 .581 .797 r
.2696 .31737 .28602 .35257 .31305 .34665 .29677 .30941 Metetra
.606 .569 .786 r
.29677 .30941 .31305 .34665 .34044 .3406 .32427 .30136 Metetra
.604 .558 .777 r
.32427 .30136 .34044 .3406 .36819 .33443 .35209 .2932 Metetra
.602 .549 .768 r
.35209 .2932 .36819 .33443 .39629 .32813 .38024 .28494 Metetra
.599 .54 .759 r
.38024 .28494 .39629 .32813 .42476 .32168 .40872 .27657 Metetra
.597 .532 .751 r
.40872 .27657 .42476 .32168 .45361 .31508 .43755 .26809 Metetra
.595 .524 .744 r
.43755 .26809 .45361 .31508 .48283 .30833 .46672 .2595 Metetra
.594 .517 .738 r
.46672 .2595 .48283 .30833 .51244 .30142 .49625 .2508 Metetra
.592 .511 .732 r
.49625 .2508 .51244 .30142 .54243 .29434 .52614 .24199 Metetra
.591 .505 .727 r
.52614 .24199 .54243 .29434 .57282 .28708 .55639 .23305 Metetra
.589 .5 .722 r
.55639 .23305 .57282 .28708 .60361 .27964 .58702 .22399 Metetra
.588 .495 .717 r
.58702 .22399 .60361 .27964 .63481 .27202 .61803 .21481 Metetra
.587 .491 .713 r
.61803 .21481 .63481 .27202 .66642 .2642 .64942 .2055 Metetra
.586 .487 .709 r
.64942 .2055 .66642 .2642 .69844 .25617 .68121 .19606 Metetra
.585 .484 .706 r
.68121 .19606 .69844 .25617 .73088 .24794 .7134 .18649 Metetra
.656 .751 .92 r
.01926 .36807 .03853 .38489 .06306 .37773 .04421 .35884 Metetra
.654 .728 .903 r
.04421 .35884 .06306 .37773 .08787 .37048 .0694 .34951 Metetra
.652 .706 .887 r
.0694 .34951 .08787 .37048 .11296 .36316 .09484 .34008 Metetra
.649 .685 .871 r
.09484 .34008 .11296 .36316 .13833 .35575 .12055 .33056 Metetra
.646 .666 .855 r
.12055 .33056 .13833 .35575 .16399 .34826 .14652 .32094 Metetra
.642 .648 .841 r
.14652 .32094 .16399 .34826 .18994 .34067 .17275 .31123 Metetra
.639 .631 .827 r
.17275 .31123 .18994 .34067 .21619 .333 .19925 .30141 Metetra
.635 .616 .814 r
.19925 .30141 .21619 .333 .24274 .32523 .22603 .2915 Metetra
.631 .601 .801 r
.22603 .2915 .24274 .32523 .2696 .31737 .25309 .28147 Metetra
.628 .588 .79 r
.25309 .28147 .2696 .31737 .29677 .30941 .28042 .27135 Metetra
.624 .575 .779 r
.28042 .27135 .29677 .30941 .32427 .30136 .30805 .26112 Metetra
.621 .564 .769 r
.30805 .26112 .32427 .30136 .35209 .2932 .33597 .25078 Metetra
.617 .553 .759 r
.33597 .25078 .35209 .2932 .38024 .28494 .36418 .24033 Metetra
.614 .543 .75 r
.36418 .24033 .38024 .28494 .40872 .27657 .3927 .22977 Metetra
.611 .533 .742 r
.3927 .22977 .40872 .27657 .43755 .26809 .42152 .21909 Metetra
.608 .524 .734 r
.42152 .21909 .43755 .26809 .46672 .2595 .45066 .2083 Metetra
.605 .516 .727 r
.45066 .2083 .46672 .2595 .49625 .2508 .48011 .1974 Metetra
.603 .508 .719 r
.48011 .1974 .49625 .2508 .52614 .24199 .50988 .18637 Metetra
.6 .501 .713 r
.50988 .18637 .52614 .24199 .55639 .23305 .53998 .17522 Metetra
.598 .494 .707 r
.53998 .17522 .55639 .23305 .58702 .22399 .57041 .16395 Metetra
.595 .487 .701 r
.57041 .16395 .58702 .22399 .61803 .21481 .60118 .15256 Metetra
.593 .481 .695 r
.60118 .15256 .61803 .21481 .64942 .2055 .63229 .14103 Metetra
.591 .475 .69 r
.63229 .14103 .64942 .2055 .68121 .19606 .66375 .12938 Metetra
.589 .47 .685 r
.66375 .12938 .68121 .19606 .7134 .18649 .69556 .1176 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
0 .48963 m
.39787 .81114 L
s
0 .48963 m
.00103 .48315 L
s
[(0)] -0.00205 .50259 .15847 -1 Mshowa
.14504 .60683 m
.14576 .60031 L
s
[(1)] .1436 .61987 .11076 -1 Mshowa
.27166 .70915 m
.27213 .7026 L
s
[(2)] .27072 .72224 .0717 -1 Mshowa
.38315 .79924 m
.38341 .79269 L
s
[(3)] .38264 .81235 .03913 -1 Mshowa
.125 Mabswid
.03067 .51441 m
.03125 .51052 L
s
.06048 .5385 m
.06102 .5346 L
s
.08945 .56191 m
.08995 .55801 L
s
.11763 .58468 m
.1181 .58077 L
s
.17172 .62839 m
.17212 .62447 L
s
.19769 .64938 m
.19806 .64546 L
s
.22299 .66982 m
.22333 .6659 L
s
.24764 .68974 m
.24795 .68581 L
s
.29508 .72807 m
.29533 .72414 L
s
.31791 .74652 m
.31814 .74259 L
s
.34019 .76453 m
.34039 .7606 L
s
.36193 .78209 m
.36211 .77816 L
s
.25 Mabswid
.96935 .42924 m
1 .6535 L
s
.97003 .43423 m
.96375 .43611 L
s
[(-1)] .9826 .43046 -1 .3 Mshowa
.97699 .48512 m
.97069 .48695 L
s
[(-0.5)] .98958 .48145 -1 .2911 Mshowa
.98416 .53762 m
.97785 .53941 L
s
[(0)] .99679 .53406 -1 .28194 Mshowa
.99157 .59183 m
.98524 .59355 L
s
[(0.5)] 1.00423 .58838 -1 .2725 Mshowa
.99922 .6478 m
.99288 .64947 L
s
[(1)] 1.01191 .64447 -1 .26278 Mshowa
.125 Mabswid
.9714 .44428 m
.96763 .4454 L
s
.97279 .45439 m
.96901 .45551 L
s
.97418 .46457 m
.9704 .46568 L
s
.97558 .47481 m
.9718 .47592 L
s
.9784 .49549 m
.97462 .49658 L
s
.97983 .50592 m
.97605 .50701 L
s
.98126 .51642 m
.97748 .5175 L
s
.98271 .52699 m
.97892 .52807 L
s
.98562 .54833 m
.98183 .54939 L
s
.9871 .5591 m
.9833 .56015 L
s
.98858 .56994 m
.98478 .57099 L
s
.99007 .58085 m
.98627 .58189 L
s
.99308 .60288 m
.98928 .6039 L
s
.9946 .614 m
.9908 .61502 L
s
.99613 .62519 m
.99233 .62621 L
s
.99767 .63646 m
.99387 .63747 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesEdge"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AxesLabel", "ObjectName",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesLabel", "MR"],
  " is an option for graphics functions that specifies labels for axes. "
}], "Usage",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesLabel", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["None", "MR"],
  " specifies that no labels should be given. "
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesLabel", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["label", "TI"],
  " specifies a label for the ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis of a two\[Hyphen]dimensional plot, and the ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis of a three\[Hyphen]dimensional plot. "
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesLabel", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["xlabel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ylabel", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " specifies labels for different axes. "
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell["\<\
\[FilledSmallSquare] By default, axes labels in \
two\[Hyphen]dimensional graphics are placed at the ends of the axes. In three\
\[Hyphen]dimensional graphics, they are aligned with the middles of the axes. \
\
\>", "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any expression can be specified as a label. It will \
be given in ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". Arbitrary strings of text can be given as ",
  StyleBox["\"", "MR"],
  StyleBox["text", "TI"],
  StyleBox["\"", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.5"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 1.9.6",
    ButtonData:>{"1.9.6", "6.4"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.10.5",
    ButtonData:>{"2.10.5", "5.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.13",
    ButtonData:>{"2.10.13", "13.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["PlotLabel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FrameLabel",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1064", "AxesLabel"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AxesLabel"],

Cell["Here is a plot without and with labels. ", "ExampleText",
  CellTags->"AxesLabel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AxesLabel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesLabel"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}, 
      AxesLabel \[Rule] "\<This is a sine plot\>"]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AxesLabel"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -59 0 ]
[.02381 .64303 59 10.125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(This) show
93.000 11.562 moveto
(is) show
111.000 11.562 moveto
(a) show
123.000 11.562 moveto
(sine) show
153.000 11.562 moveto
(plot) show
177.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesLabel"]
}, Open  ]],

Cell[TextData[{
  "See also the Further Examples for ",
  ButtonBox["ListPlot",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Plot",
    ButtonStyle->"RefGuideLink"],
  "."
}], "ExampleText",
  CellTags->"AxesLabel"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AxesOrigin", "ObjectName",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesOrigin", "MR"],
  " is an option for two\[Hyphen]dimensional graphics functions which \
specifies where any axes drawn should cross. "
}], "Usage",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesOrigin", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "MR"],
  " specifies that the axes should cross at the point ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesOrigin", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " uses an internal algorithm to determine where the axes should cross. If \
the point ",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  " is within, or close to, the plotting region, then it is usually chosen as \
the axis origin. "
}], "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] In contour and density plots, ",
  StyleBox["AxesOrigin", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " puts axes outside the plotting area. "
}], "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.2",
    ButtonData:>{"1.9.2", "2.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.5",
    ButtonData:>{"2.10.5", "5.4"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Axes",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AxesEdge",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1065", "AxesOrigin"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AxesOrigin"],

Cell[TextData[{
  "Here is a plot with the axes centered with the default setting and then \
centered at the point ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Pi], 0)\)\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"AxesOrigin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AxesOrigin"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesOrigin"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}, 
      AxesOrigin \[Rule] {\[Pi], 0}]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AxesOrigin"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.02381 .29652 -3 -9 ]
[.02381 .29652 3 0 ]
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(0)] .02381 .29652 0 1 Mshowa
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07357 m
.50375 .07357 L
s
.5 .103 m
.50375 .103 L
s
.5 .13243 m
.50375 .13243 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesOrigin"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AxesStyle", "ObjectName",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesStyle", "MR"],
  " is an option for graphics functions which specifies how axes should be \
rendered. "
}], "Usage",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesStyle", "MR"],
  " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. \
"
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesStyle", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["style", "TI"],
  " specifies that all axes are to be generated with the specified graphics \
directive, or list of graphics directives. "
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AxesStyle", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{{", "MR"],
  StyleBox["xstyle", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["ystyle", "TI"],
  StyleBox["},", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  " specifies that axes should use graphics directives ",
  StyleBox["xstyle", "TI"],
  ", \[Ellipsis]",
  " ",
  ". The styles must be enclosed in lists, perhaps of length one. "
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] Styles can be specified using graphics directives \
such as ",
  ButtonBox["Dashing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Hue",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Thickness",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default color of axes is specified by the option \
",
  ButtonBox["DefaultColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.5",
    ButtonData:>{"2.10.5", "5.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.13",
    ButtonData:>{"2.10.13", "13.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Prolog",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Epilog",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PlotStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FrameStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1066", "AxesStyle"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"AxesStyle"],

Cell["\<\
Here is one plot using default settings and another with the axes \
colored red and made a bit thicker than the default. \
\>", "ExampleText",
  CellTags->"AxesStyle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"AxesStyle"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesStyle"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}, 
      AxesStyle \[Rule] {RGBColor[1, 0, 0], Thickness[0.01]}]; \)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"AxesStyle"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
1 0 0 r
.01 w
0 .30902 m
1 .30902 L
s
0 g
.25 Mabswid
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
1 0 0 r
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"AxesStyle"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Background", "ObjectName",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " is an option which specifies the background color to use. "
}], "Usage",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " is an option for graphics functions, ",
  ButtonBox["Text",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Cell",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["ButtonBox",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting for ",
  StyleBox["Background", "MR"],
  " in graphics functions must be a ",
  ButtonBox["CMYKColor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GrayLevel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Hue",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["RGBColor",
    ButtonStyle->"RefGuideLink"],
  " directive. "
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting in graphics functions is ",
  StyleBox["Background->Automatic", "MR"],
  ", which produces a white background on most output devices. "
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  ButtonBox["Text",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox["Background->None", "MR"],
  " draws no background rectangle around the text and ",
  StyleBox["Background->Automatic", "MR"],
  " draws a background rectangle in the same color as the background for the \
whole plot. "
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell["\<\
\[FilledSmallSquare] In a cell, the background is used only for the \
region inside any cell frame. \
\>", "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.4"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.20"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.10.3",
    ButtonData:>{"2.10.3", "3.23"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Prolog",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DefaultColor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PlotRegion",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell["\<\
\[FilledSmallSquare] New in Version 2; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1067", "Background"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Background"],

Cell["This gives a gray background to the plot. ", "ExampleText",
  CellTags->"Background"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  \[Pi]}, 
      Background \[Rule] GrayLevel[0.5]]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Background"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.5 g
MFill
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Background"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BaseForm", "ObjectName",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BaseForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " prints with the numbers in ",
  StyleBox["expr", "TI"],
  " given in base ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The maximum allowed base is 36. For bases larger than \
10, additional digits are chosen from the letters ",
  StyleBox["a", "MR"],
  "\[Dash]",
  StyleBox["z", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can enter a number in an arbitrary base using ",
  StyleBox["base", "TI"],
  StyleBox["^^", "MR"],
  StyleBox["digits", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell["\<\
\[FilledSmallSquare] When a number in an arbitrary base is given in \
scientific notation, the exponent is still given in base 10. \
\>", "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can mix ",
  StyleBox["BaseForm", "MR"],
  " with ",
  ButtonBox["NumberForm",
    ButtonStyle->"RefGuideLink"],
  " and related functions. "
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BaseForm", "MR"],
  " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.9.7",
    ButtonData:>{"2.9.7", "7.30"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.1.3",
    ButtonData:>{"3.1.3", "3.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["IntegerDigits",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RealDigits",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1068", "BaseForm"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BaseForm"],

Cell["The input here is the number 1024 in base 2. ", "ExampleText",
  CellTags->"BaseForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^^10000000000\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    \(1024\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BaseForm"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[1024, 2]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("10000000000"\_"2"\),
        1024,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[2]//BaseForm= ",
  CellTags->"BaseForm"]
}, Open  ]],

Cell["This input is the base 16 representation of a large number. ", \
"ExampleText",
  CellTags->"BaseForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(16^^16c91a3\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    \(23892387\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BaseForm"]
}, Open  ]],

Cell["\<\
Numbers other than integers can be represented in various bases. \
\
\>", "ExampleText",
  CellTags->"BaseForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^^111.00011001100110011001100110100110011/2^^1010^2^^110\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    \(7.1000000029744114726782`11.387308197140358*^-6\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BaseForm"]
}, Open  ]],

Cell[TextData[{
  "The defined function ",
  StyleBox["HexDigits", "MR"],
  " is a fast way to get a string of hexadecimal digits for a number, without \
any extra formatting characters generated by ",
  StyleBox["BaseForm", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BaseForm"],

Cell[BoxData[
    \(HexDigits[b_] := 
      Module[{s = ToString[BaseForm[b, 16]]}, 
        StringDrop[
          s, {Part[StringPosition[s, "\<\n\>"], 1, 1], \(-1\)}]]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    \(aa = 6492653846287; \)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BaseForm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HexDigits[aa]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BaseForm"],

Cell[BoxData[
    \("5e7b0537f0f"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BaseForm"]
}, Open  ]],

Cell[BoxData[
    \(Clear[aa]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"BaseForm"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin", "ObjectName",
  CellTags->{"S0.1069", "Begin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Begin[\"", "MR"],
  StyleBox["context", "TI"],
  StyleBox["`\"]", "MR"],
  " resets the current context. "
}], "Usage",
  CellTags->{"S0.1069", "Begin"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Begin", "MR"],
  " resets the value of ",
  ButtonBox["$Context",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1069", "Begin"}],

Cell[TextData[{
  "\[FilledSmallSquare] The interpretation of symbol names depends on \
context. ",
  StyleBox["Begin", "MR"],
  " thus affects the parsing of input expressions. "
}], "Notes",
  CellTags->{"S0.1069", "Begin"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.7.10",
    ButtonData:>{"2.7.10", "10.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1069", "Begin"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BeginPackage",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["End",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$ContextPath",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1069", "Begin"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1069", "Begin"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Begin"],

Cell[TextData[{
  "This is the current context when you start ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Begin"]
}, Open  ]],

Cell[TextData[{
  "This is the current context path. A symbol whose context name is not \
specified is looked up first in the current context, then in the contexts in \
",
  StyleBox["$ContextPath", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ContextPath\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \({"Global`", "System`"}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Begin"]
}, Open  ]],

Cell["\<\
This command changes the current context, but not the context path. \
\
\>", "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Begin["\<Temporary`\>"]; \), "\n", 
    \({$Context, $ContextPath}\)}], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \({"Temporary`", {"Global`", "System`"}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Begin"]
}, Open  ]],

Cell[TextData[{
  "The following symbol does not exist either in the current context ",
  StyleBox["Temporary`", "MR"],
  ", or in the contexts in ",
  StyleBox["$ContextPath", "MR"],
  ". As a result, it is created in the current context. "
}], "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newsymbol\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \(newsymbol\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Begin"]
}, Open  ]],

Cell["This is its full name. ", "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?newsymbol\)\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \("Temporary`newsymbol"\)], "Print",
  CellTags->"Begin"]
}, Open  ]],

Cell["Following this command, the earlier context is restored. ", \
"ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(End[]; \), "\n", 
    \({$Context, $ContextPath}\)}], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \({"Global`", {"Global`", "System`"}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"Begin"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["newsymbol", "MR"],
  " is not recognized, since the context it belongs to is not in the search \
path. "
}], "ExampleText",
  CellTags->"Begin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?newsymbol\)\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Begin"],

Cell[BoxData[
    \(Information::"notfound" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"newsymbol\"\) not found."\)], "Message",
  CellTags->"Begin"]
}, Open  ]],

Cell[TextData[{
  "A very common use of ",
  StyleBox["Begin", "MR"],
  " is to hide symbols defined in packages. This technique is illustrated in \
the Further Examples for ",
  ButtonBox["BeginPackage",
    ButtonStyle->"RefGuideLink"],
  "."
}], "ExampleText",
  CellTags->"Begin"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BeginPackage", "ObjectName",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BeginPackage[\"", "MR"],
  StyleBox["context", "TI"],
  StyleBox["`\"]", "MR"],
  " makes ",
  StyleBox["context", "TI"],
  StyleBox["`", "MR"],
  " and ",
  StyleBox["System`", "MR"],
  " the only active contexts. \n\[FilledSmallSquare] ",
  StyleBox["BeginPackage[\"", "MR"],
  StyleBox["context", "TI"],
  StyleBox["`\",", "MR"],
  " ",
  StyleBox["{\"", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["need",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["`\",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["need",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["`\",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " calls ",
  ButtonBox["Needs",
    ButtonStyle->"RefGuideLink"],
  " on the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["need",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BeginPackage", "MR"],
  " is typically used at the beginning of a ",
  StyleBox["Mathematica", "TI"],
  " package. "
}], "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BeginPackage", "MR"],
  " resets the values of both ",
  ButtonBox["$Context",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["$ContextPath",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] The interpretation of symbol names depends on \
context. ",
  StyleBox["BeginPackage", "MR"],
  " thus affects the parsing of input expressions. "
}], "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.7.10",
    ButtonData:>{"2.7.10", "10.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["EndPackage",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1070", "BeginPackage"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BeginPackage"],

Cell[TextData[{
  StyleBox["BeginPackage", "MR"],
  " sets things up so that only ",
  StyleBox["System`", "MR"],
  " and the named context are in the context search path. As a result, any \
reference to something other than a predefined symbol creates a new symbol in \
the named context. "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(BeginPackage["\<Temporary`\>"]; \), "\n", 
    \({$Context, $ContextPath}\)}], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \({"Temporary`", {"Temporary`", "System`"}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell[TextData[{
  "The corresponding ",
  StyleBox["EndPackage", "MR"],
  " restores the earlier environment, and also adds to the ",
  StyleBox["$ContextPath", "MR"],
  " the context that's being concluded. As a result, symbols created between \
the invocations of ",
  StyleBox["BeginPackage", "MR"],
  " and ",
  StyleBox["EndPackage", "MR"],
  " are now accessible under their short names. "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(EndPackage[]; \), "\n", 
    \({$Context, $ContextPath}\)}], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \({"Global`", {"Temporary`", "Global`", "System`"}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell[TextData[{
  "A package often needs to use variables and functions that should not be \
accessible by their short names (\[OpenCurlyDoubleQuote]private\
\[CloseCurlyDoubleQuote] symbols). Such symbols are traditionally created \
inside a subcontext of the context created by ",
  StyleBox["BeginPackage", "MR"],
  ". Here is a full example illustrating the standard sequence of context \
control commands."
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[TextData[{
  "This makes ",
  StyleBox["Collatz`", "MR"],
  " the current context, and puts only ",
  StyleBox["System`", "MR"],
  " on the context search path. "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BeginPackage["\<Collatz`\>"]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \("Collatz`"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell["\<\
This introduces the objects intended to be \
\[OpenCurlyDoubleQuote]exported\[CloseCurlyDoubleQuote], that is, made \
visible after the package is loaded. \
\>", "ExampleText",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \(Collatz::"\<usage\>" = "\<Collatz[n] gives a list of the iterates in \
the 3n + 1 problem, starting from n. The conjecture is that this sequence \
always terminates.\>"; \)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BeginPackage"],

Cell[TextData[{
  "This passes to a subcontext. The backquote at the beginning of ",
  StyleBox["`Private`", "MR"],
  " stands for the current context. "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Begin["\<`Private`\>"]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \("Collatz`Private`"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell["Here is the definition of the function. ", "ExampleText",
  CellTags->"BeginPackage"],

Cell[BoxData[{
    \(Collatz[1] := {1}; \), "\n", 
    \(Collatz[n_Integer] := 
      Prepend[Collatz[3\ n + 1], n] /; OddQ[n] && n > 0; \), "\n", 
    \(Collatz[n_Integer] := 
      Prepend[Collatz[n\/2], n] /; EvenQ[n] && n > 0; \)}], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BeginPackage"],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to revert to the previous context (here, ",
  StyleBox["Collatz`", "MR"],
  "). "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \(End[]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \("Collatz`Private`"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell[TextData[{
  "This ends the package, prepending ",
  StyleBox["Collatz`", "MR"],
  " to the context search path. "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \(EndPackage[]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"BeginPackage"],

Cell["Here is the context search path. ", "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ContextPath\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \({"Collatz`", "Temporary`", "Global`", "System`"}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Collatz", "MR"],
  " function was created in the context ",
  StyleBox["Collatz`", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[Collatz]\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \("Collatz`"\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"BeginPackage"]
}, Open  ]],

Cell[TextData[{
  "The symbol ",
  StyleBox["n", "MR"],
  " was put in the private context ",
  StyleBox["Collatz`Private`", "MR"],
  ". It is not accessible by its short name, so it won't interfere with other \
uses for ",
  StyleBox["n", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BeginPackage"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?n\)\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"BeginPackage"],

Cell[BoxData[
    \(Information::"notfound" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"n\"\) not found."\)], "Message",
  CellTags->"BeginPackage"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BernoulliB", "ObjectName",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the Bernoulli number ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["B",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["BernoulliB[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives the Bernoulli polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Bernoulli polynomials satisfy the generating \
function relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["t",
              "TI"], 
            SuperscriptBox[
              StyleBox["e",
                "TI"], 
              StyleBox[\(x  t\),
                "TI"]]}], "/", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["e",
                  "TI"], 
                StyleBox["t",
                  "TI"]], "-", "1"}], ")"}], "=", 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["n",
                "TI"], "=", "0"}], "\[Infinity]",
            LimitsPositioning->True], 
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["t",
                  "TI"], 
                StyleBox["n",
                  "TI"]], "/", 
              StyleBox["n",
                "TI"], "!"}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Bernoulli numbers are given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], "=", 
          SubscriptBox[
            StyleBox["B",
              "TI"], 
            StyleBox["n",
              "TI"]], \((0)\)}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.6",
    ButtonData:>{"3.2.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["EulerE",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1071", "BernoulliB"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BernoulliB"],

Cell[TextData[{
  "This computes the ",
  Cell[BoxData[
      \(TraditionalForm\`24\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " Bernoulli number. "
}], "ExampleText",
  CellTags->"BernoulliB"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BernoulliB[24]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BernoulliB"],

Cell[BoxData[
    \(\(-\(236364091\/2730\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BernoulliB"]
}, Open  ]],

Cell[TextData[{
  "Here is the ",
  Cell[BoxData[
      \(TraditionalForm\`10\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " Bernoulli polynomial. "
}], "ExampleText",
  CellTags->"BernoulliB"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BernoulliB[10, x]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BernoulliB"],

Cell[BoxData[
    \(5\/66 - \(3\ x\^2\)\/2 + 5\ x\^4 - 7\ x\^6 + \(15\ x\^8\)\/2 - 
      5\ x\^9 + x\^10\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BernoulliB"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BesselI", "ObjectName",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselI[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the modified Bessel function of the first kind ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["I",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["I",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " satisfies the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselI[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " include transformation rules for ",
  StyleBox["BesselI", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BesselK",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryBi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BesselJ",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1072", "BesselI"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BesselI"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z BesselI[n, z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    \(1\/2\ \((BesselI[\(-1\) + n, z] + BesselI[1 + n, z])\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]BesselI[n, z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    \(2\^\(\(-1\) - n\)\ z\^\(1 + n\)\ Gamma[\(1 + n\)\/2]\ \
HypergeometricPFQRegularized[{\(1 + n\)\/2}, {1 + n, \(3 + n\)\/2}, 
        z\^2\/4]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell[TextData[{
  "This verifies the defining differential equation for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselI"],

Cell[BoxData[
    \(y = BesselI[n, z]; \)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(z\^2\) \[PartialD]\_{z, 2}y + 
          z \[PartialD]\_z y - \((z\^2 + n\^2)\)\ y /. n -> 3 // 
      FullSimplify\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[BesselI[n, z], {z, 0, 5}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    RowBox[{\(z\^n\), " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(2\^\(-n\)\/Gamma[1 + n]\), 
            "+", \(\(2\^\(\(-2\) - n\)\ z\^2\)\/\(\((1 + n)\)\ Gamma[
                    1 + n]\)\), 
            "+", \(\(2\^\(\(-5\) - n\)\ z\^4\)\/\(\((1 + n)\)\ \((2 + 
                      n)\)\ Gamma[1 + n]\)\), "+", 
            InterpretationBox[\(O[z]\^6\),
              SeriesData[ z, 0, {}, 0, 6, 1],
              Editable->False]}],
          SeriesData[ z, 0, {
            Times[ 
              Power[ 2, 
                Times[ -1, n]], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]], 0, 
            Times[ 
              Power[ 2, 
                Plus[ -2, 
                  Times[ -1, n]]], 
              Power[ 
                Plus[ 1, n], -1], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]], 0, 
            Times[ 
              Power[ 2, 
                Plus[ -5, 
                  Times[ -1, n]]], 
              Power[ 
                Plus[ 1, n], -1], 
              Power[ 
                Plus[ 2, n], -1], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]]}, 0, 6, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BesselI", "MR"],
  " simplifies when the order is half an odd integer. "
}], "ExampleText",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BesselI[11\/2, z]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    \(\(\((2 + 1890\/z\^4 + 210\/z\^2)\)\ Cosh[z] + \((\(-\(1890\/z\^5\)\) - \
840\/z\^3 - 30\/z)\)\ Sinh[z]\)\/\(\@\(2\ \[Pi]\)\ \@z\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell[TextData[{
  "Here is an integral involving ",
  StyleBox["BesselI", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BesselI"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%1\( x\^\(a + 1\)\ BesselI[a, 
            b\ x]\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BesselI"],

Cell[BoxData[
    \(If[Re[a] > \(-1\), BesselI[1 + a, b]\/b, 
      Integrate[x\^\(1 + a\)\ BesselI[a, b\ x], {x, 0, 1}, 
        Assumptions \[Rule] Re[a] \[LessEqual] \(-1\)]]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BesselI"]
}, Open  ]],

Cell[BoxData[
    \(Clear[y]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"BesselI"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BesselJ", "ObjectName",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselJ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the Bessel function of the first kind ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " satisfies the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "-", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselJ[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " include transformation rules for ",
  StyleBox["BesselJ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BesselY",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["StruveH",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BesselK",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1073", "BesselJ"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BesselJ"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"BesselJ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z BesselJ[n, z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BesselJ"],

Cell[BoxData[
    \(1\/2\ \((BesselJ[\(-1\) + n, z] - BesselJ[1 + n, z])\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BesselJ"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"BesselJ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]BesselJ[n, z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BesselJ"],

Cell[BoxData[
    \(2\^\(\(-1\) - n\)\ z\^\(1 + n\)\ Gamma[\(1 + n\)\/2]\ \
HypergeometricPFQRegularized[{\(1 + n\)\/2}, {1 + 
            n, \(3 + n\)\/2}, \(-\(z\^2\/4\)\)]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BesselJ"]
}, Open  ]],

Cell[TextData[{
  "This verifies the defining differential equation for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselJ"],

Cell[BoxData[
    \(y = BesselJ[n, z]; \)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BesselJ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(z\^2\ \[PartialD]\_{z, 2}y + 
          z\ \[PartialD]\_z y + \((z\^2 - n\^2)\)\ y /. n -> 3 // 
      FullSimplify\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BesselJ"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BesselJ"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion around ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to order ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselJ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[BesselJ[n, z], {z, 0, 5}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BesselJ"],

Cell[BoxData[
    RowBox[{\(z\^n\), " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(2\^\(-n\)\/Gamma[1 + n]\), 
            "-", \(\(2\^\(\(-2\) - n\)\ z\^2\)\/\(\((1 + n)\)\ Gamma[
                    1 + n]\)\), 
            "+", \(\(2\^\(\(-5\) - n\)\ z\^4\)\/\(\((1 + n)\)\ \((2 + 
                      n)\)\ Gamma[1 + n]\)\), "+", 
            InterpretationBox[\(O[z]\^6\),
              SeriesData[ z, 0, {}, 0, 6, 1],
              Editable->False]}],
          SeriesData[ z, 0, {
            Times[ 
              Power[ 2, 
                Times[ -1, n]], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]], 0, 
            Times[ -1, 
              Power[ 2, 
                Plus[ -2, 
                  Times[ -1, n]]], 
              Power[ 
                Plus[ 1, n], -1], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]], 0, 
            Times[ 
              Power[ 2, 
                Plus[ -5, 
                  Times[ -1, n]]], 
              Power[ 
                Plus[ 1, n], -1], 
              Power[ 
                Plus[ 2, n], -1], 
              Power[ 
                Gamma[ 
                  Plus[ 1, n]], -1]]}, 0, 6, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BesselJ"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BesselJ", "MR"],
  " simplifies when the order is half an odd integer. "
}], "ExampleText",
  CellTags->"BesselJ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BesselJ[9\/2, x]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BesselJ"],

Cell[BoxData[
    \(\(\@\(2\/\[Pi]\)\ \((\(-\(\(105\ Cos[x]\)\/x\^3\)\) + \(10\ Cos[x]\)\/x \
+ Sin[x] + \(105\ Sin[x]\)\/x\^4 - \(45\ Sin[x]\)\/x\^2)\)\)\/\@x\)], "Output",\

  CellLabel->"Out[6]= ",
  CellTags->"BesselJ"]
}, Open  ]],

Cell[BoxData[
    \(Clear[y]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BesselJ"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BesselK", "ObjectName",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselK[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the modified Bessel function of the second kind ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["K",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " satisfies the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "-", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselK[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " include transformation rules for ",
  StyleBox["BesselK", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BesselI",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AiryAi",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BesselJ",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1074", "BesselK"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BesselK"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"BesselK"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z BesselK[n, z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BesselK"],

Cell[BoxData[
    \(1\/2\ \((\(-BesselK[\(-1\) + n, z]\) - BesselK[1 + n, z])\)\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"BesselK"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"BesselK"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]BesselK[n, z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BesselK"],

Cell[BoxData[
    \(2\^\(\(-2\) - n\)\ \[Pi]\ z\^\(1 - n\)\ Csc[
        n\ \[Pi]]\ \((4\^n\ Gamma[
              1\/2 - n\/2]\ HypergeometricPFQRegularized[{1\/2 - n\/2}, {1 - 
                  n, 3\/2 - n\/2}, z\^2\/4] - 
          z\^\(2\ n\)\ Gamma[\(1 + n\)\/2]\ HypergeometricPFQRegularized[{\(1 \
+ n\)\/2}, {1 + n, \(3 + n\)\/2}, z\^2\/4])\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BesselK"]
}, Open  ]],

Cell[TextData[{
  "This verifies the defining differential equation for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselK"],

Cell[BoxData[
    \(y = BesselK[n, z]; \)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BesselK"],

Cell[CellGroupData[{

Cell[BoxData[
    \(z\^2\ \[PartialD]\_{z, 2}y + 
          z\ \[PartialD]\_z y - \((z\^2 + n\^2)\)\ y /. n -> 3 // 
      FullSimplify\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BesselK"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BesselK"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion of order ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  " about ",
  StyleBox["Infinity", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BesselK"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[BesselK[n, z], {z, \[Infinity], 2}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BesselK"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\
\\/\\(1\\/z\\)\\)\\)\\)\\) + \
\\*InterpretationBox[\\(\\(O[\\(\\(1\\/z\\)\\)]\\)\\^5\\), SeriesData[z, \
DirectedInfinity[1], List[], -1, 5, 1], Rule[Editable, False]]\\), \
SeriesData[z, DirectedInfinity[1], List[-1], -1, 5, 1], Rule[Editable, \
False]]\\).\"\>"}]], "Message",
  CellTags->"BesselK"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\
\\/z\\)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[z]\\)\\^5\\), SeriesData[z, \
0, List[], -1, 5, 1], Rule[Editable, False]]\\), SeriesData[z, 0, List[-1], \
-1, 5, 1], Rule[Editable, False]]\\).\"\>"}]], "Message",
  CellTags->"BesselK"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\
\\/\\(1\\/z\\)\\)\\)\\)\\) + \
\\*InterpretationBox[\\(\\(O[\\(\\(1\\/z\\)\\)]\\)\\^6\\), SeriesData[z, \
DirectedInfinity[1], List[], -1, 6, 1], Rule[Editable, False]]\\), \
SeriesData[z, DirectedInfinity[1], List[-1], -1, 6, 1], Rule[Editable, \
False]]\\).\"\>"}]], "Message",
  CellTags->"BesselK"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Series :: \"esss\"\) will be suppressed during \
this calculation."\)], "Message",
  CellTags->"BesselK"],

Cell[BoxData[
    RowBox[{\(\[ExponentialE]\^\(-z\)\), " ", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(\@\(\[Pi]\/2\)\ \@\(1\/z\)\), 
            "+", \(1\/128\ \((\(-16\) + 
                  64\ n\^2)\)\ \@\(\[Pi]\/2\)\ \((1\/z)\)\^\(3/2\)\), 
            "+", \(1\/128\ \((9 - 40\ n\^2 + 
                  16\ n\^4)\)\ \@\(\[Pi]\/2\)\ \((1\/z)\)\^\(5/2\)\), "+", 
            InterpretationBox[\(O[1\/z]\^3\),
              SeriesData[ z, 
                DirectedInfinity[ 1], {}, 1, 6, 2],
              Editable->False]}],
          SeriesData[ z, 
            DirectedInfinity[ 1], {
            Power[ 
              Times[ 
                Rational[ 1, 2], Pi], 
              Rational[ 1, 2]], 0, 
            Times[ 
              Rational[ 1, 128], 
              Plus[ -16, 
                Times[ 64, 
                  Power[ n, 2]]], 
              Power[ 
                Times[ 
                  Rational[ 1, 2], Pi], 
                Rational[ 1, 2]]], 0, 
            Times[ 
              Rational[ 1, 128], 
              Plus[ 9, 
                Times[ -40, 
                  Power[ n, 2]], 
                Times[ 16, 
                  Power[ n, 4]]], 
              Power[ 
                Times[ 
                  Rational[ 1, 2], Pi], 
                Rational[ 1, 2]]]}, 1, 6, 2],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BesselK"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BesselK", "MR"],
  " simplifies when the order is half an odd integer. "
}], "ExampleText",
  CellTags->"BesselK"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BesselK[13\/2, z]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BesselK"],

Cell[BoxData[
    \(\(\[ExponentialE]\^\(-z\)\ \@\(\[Pi]\/2\)\ \((1 + 10395\/z\^6 + \
10395\/z\^5 + 4725\/z\^4 + 1260\/z\^3 + 210\/z\^2 + 21\/z)\)\)\/\@z\)], \
"Output",
  CellLabel->"Out[6]= ",
  CellTags->"BesselK"]
}, Open  ]],

Cell[BoxData[
    \(Clear[y]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BesselK"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BesselY", "ObjectName",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselY[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " gives the Bessel function of the second kind ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Y",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["z",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " satisfies the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["z",
              "TI"], "2"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], "+", 
          StyleBox["z",
            "TI"], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], "+", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["z",
                  "TI"], "2"], "-", 
              SuperscriptBox[
                StyleBox["n",
                  "TI"], "2"]}], ")"}], 
          StyleBox["y",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BesselY[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " include transformation rules for ",
  StyleBox["BesselY", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.51"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BesselJ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["StruveH",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BesselI",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1075", "BesselY"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BesselY"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"BesselY"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z BesselY[n, z]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BesselY"],

Cell[BoxData[
    \(1\/2\ \((BesselY[\(-1\) + n, z] - BesselY[1 + n, z])\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BesselY"]
}, Open  ]],

Cell["This is the indefinite integral. ", "ExampleText",
  CellTags->"BesselY"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]BesselY[n, z] \[DifferentialD]z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BesselY"],

Cell[BoxData[
    \(2\^\(\(-1\) - n\)\ z\^\(1 - n\)\ Csc[
        n\ \[Pi]]\ \((\(-4\^n\)\ Gamma[
              1\/2 - n\/2]\ HypergeometricPFQRegularized[{1\/2 - n\/2}, {1 - 
                  n, 3\/2 - n\/2}, \(-\(z\^2\/4\)\)] + 
          z\^\(2\ n\)\ Cos[
              n\ \[Pi]]\ Gamma[\(1 + n\)\/2]\ \
HypergeometricPFQRegularized[{\(1 + n\)\/2}, {1 + 
                  n, \(3 + n\)\/2}, \(-\(z\^2\/4\)\)])\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BesselY"]
}, Open  ]],

Cell[TextData[{
  "This verifies the defining differential equation for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            "TI"], "=", "3"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "ExampleText",
  CellTags->"BesselY"],

Cell[BoxData[
    \(y = BesselY[n, z]; \)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BesselY"],

Cell[CellGroupData[{

Cell[BoxData[
    \(z\^2\ \[PartialD]\_{z, 2}y + 
          z\ \[PartialD]\_z y + \((z\^2 - n\^2)\)\ y /. n -> 3 // 
      FullSimplify\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BesselY"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BesselY"]
}, Open  ]],

Cell[TextData[{
  "This is the series expansion of order 2 about ",
  StyleBox["Infinity", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BesselY"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[BesselY[n, z], {z, \[Infinity], 2}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BesselY"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(Cos[\\(\\(\\*InterpretationBox[\\(1\\/\\(1\\/z\\) + \
\\(\\((\\(\\(-\\(\\(\[Pi]\\/4\\)\\)\\)\\) + \\(n\\\\ \[Pi]\\)\\/2)\\)\\) + \
\\*InterpretationBox[\\(\\(O[\\(\\(1\\/z\\)\\)]\\)\\^5\\), SeriesData[z, \
DirectedInfinity[1], List[], -1, 5, 1], Rule[Editable, False]]\\), \
SeriesData[z, DirectedInfinity[1], List[1, Plus[Times[Rational[-1, 4], Pi], \
Times[Rational[1, 2], n, Pi]]], -1, 5, 1], Rule[Editable, \
False]]\\)\\)]\\).\"\>"}]], "Message",
  CellTags->"BesselY"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(Cos[\\(\\(\\*InterpretationBox[\\(1\\/z + \\(\\((\\(\\(-\
\\(\\(\[Pi]\\/4\\)\\)\\)\\) + \\(n\\\\ \[Pi]\\)\\/2)\\)\\) + \
\\*InterpretationBox[\\(\\(O[z]\\)\\^5\\), SeriesData[z, 0, List[], -1, 5, \
1], Rule[Editable, False]]\\), SeriesData[z, 0, List[1, \
Plus[Times[Rational[-1, 4], Pi], Times[Rational[1, 2], n, Pi]]], -1, 5, 1], \
Rule[Editable, False]]\\)\\)]\\).\"\>"}]], "Message",
  CellTags->"BesselY"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \
\\!\\(Cos[\\(\\(\\*InterpretationBox[\\(\\(\\(-\\(\\(1\\/\\(1\\/z\\)\\)\\)\\)\
\\) + \\(\\((\[Pi]\\/4 + \\(n\\\\ \[Pi]\\)\\/2)\\)\\) + \\*InterpretationBox[\
\\(\\(O[\\(\\(1\\/z\\)\\)]\\)\\^5\\), SeriesData[z, DirectedInfinity[1], \
List[], -1, 5, 1], Rule[Editable, False]]\\), SeriesData[z, \
DirectedInfinity[1], List[-1, Plus[Times[Rational[1, 4], Pi], \
Times[Rational[1, 2], n, Pi]]], -1, 5, 1], Rule[Editable, \
False]]\\)\\)]\\).\"\>"}]], "Message",
  CellTags->"BesselY"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Series :: \"esss\"\) will be suppressed during \
this calculation."\)], "Message",
  CellTags->"BesselY"],

Cell[BoxData[
    RowBox[{\(1\/\@\(2\ \[Pi]\)\), 
      RowBox[{"(", 
        RowBox[{\(Csc[n\ \[Pi]]\), " ", 
          RowBox[{"(", 
            RowBox[{
              
              RowBox[{\((Cos[\[Pi]\/4 - \(n\ \[Pi]\)\/2 - z] - 
                    Cos[n\ \[Pi]]\ Cos[\[Pi]\/4 + \(n\ \[Pi]\)\/2 - z])\), 
                " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    
                    RowBox[{\(-\(2\ \@\(1\/z\)\)\), 
                      "+", \(1\/64\ \((9 - 40\ n\^2 + 
                            16\ n\^4)\)\ \((1\/z)\)\^\(5/2\)\), "+", 
                      InterpretationBox[\(O[1\/z]\^3\),
                        SeriesData[ z, 
                          DirectedInfinity[ 1], {}, 1, 6, 2],
                        Editable->False]}],
                    SeriesData[ z, 
                      DirectedInfinity[ 1], {-2, 0, 0, 0, 
                      Times[ 
                        Rational[ 1, 64], 
                        Plus[ 9, 
                          Times[ -40, 
                            Power[ n, 2]], 
                          Times[ 16, 
                            Power[ n, 4]]]]}, 1, 6, 2],
                    Editable->False], ")"}]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  InterpretationBox[
                    
                    RowBox[{\(1\/4\ \((\(-1\) + 
                            4\ n\^2)\)\ \((1\/z)\)\^\(3/2\)\), "+", 
                      InterpretationBox[\(O[1\/z]\^3\),
                        SeriesData[ z, 
                          DirectedInfinity[ 1], {}, 3, 6, 2],
                        Editable->False]}],
                    SeriesData[ z, 
                      DirectedInfinity[ 1], {
                      Times[ 
                        Rational[ 1, 4], 
                        Plus[ -1, 
                          Times[ 4, 
                            Power[ n, 2]]]]}, 3, 6, 2],
                    Editable->False], ")"}], 
                " ", \((\(-Sin[\[Pi]\/4 - \(n\ \[Pi]\)\/2 - z]\) + 
                    Cos[n\ \[Pi]]\ Sin[\[Pi]\/4 + \(n\ \[Pi]\)\/2 - z])\)}]}],
             ")"}]}], ")"}]}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BesselY"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BesselY", "MR"],
  " simplifies when the order is half an odd integer. "
}], "ExampleText",
  CellTags->"BesselY"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BesselY[11\/2, z]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BesselY"],

Cell[BoxData[
    \(\(1\/\@z\) \((\@\(2\/\[Pi]\)\ \((\(-\(\(945\ Cos[
                        z]\)\/z\^5\)\) + \(420\ Cos[z]\)\/z\^3 - \(15\ Cos[z]\
\)\/z - Sin[
                z] - \(945\ Sin[z]\)\/z\^4 + \(105\ Sin[z]\)\/z\^2)\))\)\)], \
"Output",
  CellLabel->"Out[6]= ",
  CellTags->"BesselY"]
}, Open  ]],

Cell[BoxData[
    \(Clear[y]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BesselY"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beta", "ObjectName",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Beta[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the Euler beta function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalBeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Beta[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the incomplete beta function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[CapitalBeta]", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalBeta]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["a",
                "TI"], ")"}], "\[CapitalGamma]", 
            RowBox[{"(", 
              StyleBox["b",
                "TI"], ")"}]}], "/", 
          RowBox[{"\[CapitalGamma]", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["a",
                  "TI"], "+", 
                StyleBox["b",
                  "TI"]}], ")"}]}], "=", \(\[Integral]\_0\%1\), 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[CapitalBeta]", 
            StyleBox["z",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["z",
              "TI"]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Beta[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " has a branch cut discontinuity in the complex ",
  StyleBox["z", "TI"],
  " plane running from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\)\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Beta[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the generalized incomplete beta function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            SubscriptBox[
              StyleBox["z",
                "TI"], "0"], 
            SubscriptBox[
              StyleBox["z",
                "TI"], "1"]], 
          SuperscriptBox[
            StyleBox["t",
              "TI"], 
            RowBox[{
              StyleBox["a",
                "TI"], "-", "1"}]], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "-", 
                StyleBox["t",
                  "TI"]}], ")"}], 
            RowBox[{
              StyleBox["b",
                "TI"], "-", "1"}]], 
          StyleBox["d",
            "TI"], 
          StyleBox["t",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] Note that the arguments in the incomplete form of ",
  StyleBox["Beta", "MR"],
  " are arranged differently from those in the incomplete form of ",
  ButtonBox["Gamma",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox["Beta", "MR"],
  " is output using \[Backslash]",
  StyleBox["[CapitalBeta]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BetaRegularized",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InverseBetaRegularized",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1076", "Beta"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Beta"],

Cell["Here is a symbolic result. ", "ExampleText",
  CellTags->"Beta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Beta[z\_0, z\_1, 5, 1]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Beta"],

Cell[BoxData[
    \(1\/5\ \((\(-z\_0\%5\) + z\_1\%5)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Beta"]
}, Open  ]],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"Beta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x Beta[x, a, b]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Beta"],

Cell[BoxData[
    \(\((1 - x)\)\^\(\(-1\) + b\)\ x\^\(\(-1\) + a\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Beta"]
}, Open  ]],

Cell["This is the second derivative. ", "ExampleText",
  CellTags->"Beta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_{x, 2}Beta[x, a, b]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Beta"],

Cell[BoxData[
    \(\((\(-1\) + 
            a)\)\ \((1 - x)\)\^\(\(-1\) + b\)\ x\^\(\(-2\) + a\) - \((\(-1\) \
+ b)\)\ \((1 - x)\)\^\(\(-2\) + b\)\ x\^\(\(-1\) + a\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Beta"]
}, Open  ]],

Cell[TextData[{
  "For a and b positive real, this just gives an alternate definition of the \
",
  StyleBox["Beta", "MR"],
  " function. "
}], "ExampleText",
  CellTags->"Beta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\(t\^\(a - 1\)\) \((1 - t)\)\^\(b - 1\), {t, 0, 1}, 
      Assumptions \[Rule] {a > 0, b > 0}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Beta"],

Cell[BoxData[
    \(\(Gamma[a]\ Gamma[b]\)\/Gamma[a + b]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Beta"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Beta[a, b] == \(Gamma[a] Gamma[b]\)\/Gamma[a + b] // 
      FullSimplify\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Beta"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"Beta"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BetaRegularized", "ObjectName",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BetaRegularized[", "MR"],
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the regularized incomplete beta function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["I",
              "TI"], 
            StyleBox["z",
              "TI"]], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] Mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] For non\[Hyphen]singular cases, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["I",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "=", 
          StyleBox["B",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["z",
                "TI"], ",", 
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}], "/", 
          StyleBox["B",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["a",
                "TI"], ",", 
              StyleBox["b",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BetaRegularized[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " gives the generalized regularized incomplete beta function defined in non\
\[Hyphen]singular cases as ",
  StyleBox["Beta[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["z",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]/Beta[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] Note that the arguments in ",
  StyleBox["BetaRegularized", "MR"],
  " are arranged differently from those in ",
  ButtonBox["GammaRegularized",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.11",
    ButtonData:>{"3.2.11", "11.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Beta",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InverseBetaRegularized",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1077", "BetaRegularized"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BetaRegularized"],

Cell["This is the derivative. ", "ExampleText",
  CellTags->"BetaRegularized"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x BetaRegularized[x, a, b]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BetaRegularized"],

Cell[BoxData[
    \(\(\((1 - x)\)\^\(\(-1\) + b\)\ x\^\(\(-1\) + a\)\)\/Beta[a, b]\)], \
"Output",
  CellLabel->"Out[1]= ",
  CellTags->"BetaRegularized"]
}, Open  ]],

Cell["This is the second derivative. ", "ExampleText",
  CellTags->"BetaRegularized"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_{x, 2}BetaRegularized[x, a, b]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BetaRegularized"],

Cell[BoxData[
    \(\(\((\(-1\) + a)\)\ \((1 - x)\)\^\(\(-1\) + b\)\ x\^\(\(-2\) + \
a\)\)\/Beta[a, b] - \(\((\(-1\) + b)\)\ \((1 - x)\)\^\(\(-2\) + b\)\ \
x\^\(\(-1\) + a\)\)\/Beta[a, b]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BetaRegularized"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BinaryRead", "ObjectName",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryRead[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox["]", "MR"],
  " reads one byte of raw binary data from an input stream, and returns an \
integer from 0 to 255. \n\[FilledSmallSquare] ",
  StyleBox["BinaryRead[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " reads an object of the specified type. \n\[FilledSmallSquare] ",
  StyleBox["BinaryRead[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " reads a sequence of objects of the specified types. "
}], "Usage",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell["\[FilledSmallSquare] Possible types to read are: ", "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"Byte\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"Character8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit character "]},
          {Cell[TextData[{
              StyleBox["\"Character16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit character "]},
          {Cell[TextData[{
              StyleBox["\"Complex64\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE single\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Complex128\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE double\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Complex256\"", "MR"],
              " "
            }]], 
            Cell["\<\
IEEE quad\[Hyphen]precision complex number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Integer8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer32\"", "MR"],
              " "
            }]], Cell["32\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer64\"", "MR"],
              " "
            }]], Cell["64\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Integer128\"", "MR"],
              " "
            }]], Cell["128\[Hyphen]bit signed integer "]},
          {Cell[TextData[{
              StyleBox["\"Real32\"", "MR"],
              " "
            }]], Cell["\<\
IEEE single\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Real64\"", "MR"],
              " "
            }]], Cell["\<\
IEEE double\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"Real128\"", "MR"],
              " "
            }]], Cell["\<\
IEEE quad\[Hyphen]precision real number \
\>"]},
          {Cell[TextData[{
              StyleBox["\"TerminatedString\"", "MR"],
              " "
            }]], 
            Cell["\<\
null\[Hyphen]terminated string of 8\[Hyphen]bit \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger8\"", "MR"],
              " "
            }]], Cell["8\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger16\"", "MR"],
              " "
            }]], Cell["16\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger32\"", "MR"],
              " "
            }]], Cell["32\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger64\"", "MR"],
              " "
            }]], Cell["64\[Hyphen]bit unsigned integer "]},
          {Cell[TextData[{
              StyleBox["\"UnsignedInteger128\"", "MR"],
              " "
            }]], Cell["128\[Hyphen]bit unsigned integer "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"BinaryRead", "S0.1078"}],

Cell[TextData[{
  "\[FilledSmallSquare] The first argument to ",
  StyleBox["BinaryRead", "MR"],
  " can be ",
  StyleBox["InputStream[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", or simply ",
  StyleBox["\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"", "MR"],
  " if there is only one open input stream with the specified name. "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can open a file or pipe to get an ",
  ButtonBox["InputStream",
    ButtonStyle->"RefGuideLink"],
  " object using ",
  ButtonBox["OpenRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] Streams for use with ",
  StyleBox["BinaryRead", "MR"],
  " should be opened with ",
  StyleBox["BinaryFormat->True", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] There is always a \[OpenCurlyDoubleQuote]current \
point\[CloseCurlyDoubleQuote] maintained for any stream. When you read an \
object from a stream, the current point is left after the input you read. \
Successive calls to ",
  StyleBox["BinaryRead", "MR"],
  " can therefore be used to read successive objects in a stream such as a \
file. "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryRead", "MR"],
  " returns ",
  ButtonBox["EndOfFile",
    ButtonStyle->"RefGuideLink"],
  " if you are at the end of the file. "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryRead", "MR"],
  " returns ",
  ButtonBox["Infinity",
    ButtonStyle->"RefGuideLink"],
  " for IEEE \[OpenCurlyDoubleQuote]infinity\[CloseCurlyDoubleQuote], and ",
  ButtonBox["Indeterminate",
    ButtonStyle->"RefGuideLink"],
  " for IEEE \[OpenCurlyDoubleQuote]not\[Hyphen]a\[Hyphen]number\
\[CloseCurlyDoubleQuote]. "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell["\<\
\[FilledSmallSquare] The following options can be given: \
\>", \
"Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ByteOrdering", "MR"],
              " "
            }]], Cell[TextData[{
              ButtonBox["$ByteOrdering",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["what byte ordering to use "]},
          {Cell[TextData[{
              ButtonBox["Path",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell[TextData[{
              ButtonBox["$Path",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["the path to search for files to be opened "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "3ColumnTable",
  CellTags->{"BinaryRead", "S0.1078"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.12.11",
    ButtonData:>{"2.12.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BinaryReadList",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BinaryWrite",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Read",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Import",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImportString",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1078", "BinaryRead"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1078", "BinaryRead"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["BinaryReadList", "ObjectName",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\"]", "MR"],
  " reads all remaining bytes from a file, and returns them as a list of \
integers from 0 to 255. \n\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " reads objects of the specified type from a file, until the end of the \
file is reached. The list of objects read is returned. \n\[FilledSmallSquare] \
",
  StyleBox["BinaryReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " reads objects with a sequence of types, until the end of the file is \
reached. \n\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["types", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " reads only the first ",
  StyleBox["n", "TI"],
  " objects of the specified types. "
}], "Usage",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryReadList", "MR"],
  " supports the same types and options as ",
  ButtonBox["BinaryRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["file", "TI"],
  " is not already open for reading, ",
  StyleBox["BinaryReadList", "MR"],
  " opens it, then closes it when it is finished. If the file is already \
open, ",
  StyleBox["BinaryReadList", "MR"],
  " does not close it at the end. "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " reads the sequence of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in order. If the end of file is reached while part way through this \
sequence, ",
  ButtonBox["EndOfFile",
    ButtonStyle->"RefGuideLink"],
  " is returned in place of elements in the sequence that have not yet been \
read. "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[\"!", "MR"],
  StyleBox["command", "TI"],
  StyleBox["\",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " reads from a pipe. "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryReadList[", "MR"],
  StyleBox["stream", "TI"],
  StyleBox["]", "MR"],
  " reads from an open input stream, as returned by ",
  ButtonBox["OpenRead",
    ButtonStyle->"RefGuideLink"],
  " with ",
  StyleBox["BinaryFormat->True", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  ButtonBox["BinaryRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.12.11",
    ButtonData:>{"2.12.11", "11.12"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Import",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BinaryRead",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Export",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1079", "BinaryReadList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["BinaryWrite", "ObjectName",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " writes a byte of data, specified as an integer from 0 to 255. \n\
\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " writes a sequence of bytes. \n\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["string", "TI"],
  StyleBox["\"]", "MR"],
  " writes the raw sequence of characters in a string. \n\[FilledSmallSquare] \
",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " writes an object of the specified type. \n\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["type", "TI"],
  StyleBox["]", "MR"],
  " writes a sequence of objects of the specified type. \n\
\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["type",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}]", "MR"],
  " writes a sequence of objects with a sequence of types. "
}], "Usage",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryWrite", "MR"],
  " supports the same types as ",
  ButtonBox["BinaryRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] The output channel used by ",
  StyleBox["BinaryWrite", "MR"],
  " can be a single file or pipe, or list of them, each specified by a string \
giving their name, or by an ",
  ButtonBox["OutputStream",
    ButtonStyle->"RefGuideLink"],
  " object that has been opened with ",
  StyleBox["BinaryFormat->True", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] If any of the specified files or pipes are not \
already open, ",
  StyleBox["BinaryWrite", "MR"],
  " calls ",
  ButtonBox["OpenWrite",
    ButtonStyle->"RefGuideLink"],
  " to open them. "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryWrite", "MR"],
  " does not close files and pipes after it finishes writing to them. "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell["\<\
\[FilledSmallSquare] When a list of types is given, the list is \
effectively repeated as many times as necessary. \
\>", "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell["\<\
\[FilledSmallSquare] The following option can be given: \
\>", \
"Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ByteOrdering", "MR"],
              " "
            }]], Cell[TextData[{
              ButtonBox["$ByteOrdering",
                ButtonStyle->"RefGuideLink"],
              " "
            }]], Cell["what byte ordering to use "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "3ColumnTable",
  CellTags->{"BinaryWrite", "S0.1080"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryWrite[", "MR"],
  StyleBox["channel", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["string", "TI"],
  StyleBox["\"]", "MR"],
  " uses type ",
  StyleBox["\"Character8\"", "MR"],
  ", so all characters in ",
  StyleBox["\"", "MR"],
  StyleBox["string", "TI"],
  StyleBox["\"", "MR"],
  " should have character code in the range 0\[Dash]255. "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BinaryWrite", "MR"],
  " returns ",
  ButtonBox["$Failed",
    ButtonStyle->"RefGuideLink"],
  " if it encounters a data element that cannot match the type specified. "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.12.11",
    ButtonData:>{"2.12.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BinaryRead",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WriteString",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Export",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1080", "BinaryWrite"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Binomial", "ObjectName",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Binomial[", "MR"],
  StyleBox["n", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["m", "TI"],
  StyleBox["]", "MR"],
  " gives the binomial coefficient ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          FractionBox[
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"],
            FractionLine->None], ")"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integer mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Binomial", "MR"],
  " is evaluated symbolically when possible. "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] Example: ",
  StyleBox["Binomial[x+2,", "MR"],
  " ",
  StyleBox["x]", "MR"],
  "\[LongRightArrow]",
  Cell[BoxData[
      InterpretationBox[
        StyleBox[\(\((\((1\  + \ x)\)*\((2\  + \ x)\))\)/2\),
          ShowStringCharacters->True,
          NumberMarks->True],
        InputForm[ 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 1, x], 
            Plus[ 2, x]]],
        Editable->True,
        AutoDelete->True]], "InlineOutput"],
  ". "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] In general, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          FractionBox[
            StyleBox["n",
              "TI"], 
            StyleBox["m",
              "TI"],
            FractionLine->None], ")"}], TraditionalForm]], "InlineFormula"],
  " is defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "+", "1"}], ")"}], "/", 
          RowBox[{"(", 
            RowBox[{"\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["m",
                    "TI"], "+", "1"}], ")"}], "\[CapitalGamma]", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["n",
                    "TI"], "-", 
                  StyleBox["m",
                    "TI"], "+", "1"}], ")"}]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " or suitable limits of this. "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.6",
    ButtonData:>{"3.2.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] Implementation notes: see ",
  ButtonBox["Section A.9.4",
    ButtonData:>{"A.9.4", "4.32"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Multinomial",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Pochhammer",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1081", "Binomial"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Binomial"],

Cell[TextData[{
  "In how many ways can you choose ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  " objects from ",
  Cell[BoxData[
      \(TraditionalForm\`5\)], "InlineFormula"],
  "? "
}], "ExampleText",
  CellTags->"Binomial"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Binomial[5, 2]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Binomial"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Binomial"]
}, Open  ]],

Cell["\<\
Here is a table of the first nine rows of Pascal's triangle. \
\>", \
"ExampleText",
  CellTags->"Binomial"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Table[Binomial[n, k], {n, 0, 8}, {k, 0, n}]]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Binomial"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
          {"1", "2", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
          {"1", "3", "3", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "4", "6", "4", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "5", "10", "10", "5", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "6", "15", "20", "15", "6", "1", "\<\"\"\>", "\<\"\"\>"},
          {"1", "7", "21", "35", "35", "21", "7", "1", "\<\"\"\>"},
          {"1", "8", "28", "56", "70", "56", "28", "8", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 
        5, 10, 10, 5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 
        1}, {1, 8, 28, 56, 70, 56, 28, 8, 1}}]]], "Output",
  CellLabel->"Out[2]//TableForm= ",
  CellTags->"Binomial"]
}, Open  ]],

Cell["Here are two identities. ", "ExampleText",
  CellTags->"Binomial"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Binomial[Binomial[n, 2], 2] == 3  Binomial[n + 1, 4], 
      n \[Element] Integers && n > 2]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Binomial"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Binomial"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[\[Sum]\+\(k = 0\)\%n Binomial[a, k]\ Binomial[b, n - k] == 
        Binomial[a + b, n]]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Binomial"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Binomial"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BitAnd", "ObjectName",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitAnd[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives the bitwise AND of the integers ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integer mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitAnd[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of all of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. "
}], "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] For negative integers ",
  StyleBox["BitAnd", "MR"],
  " assumes a two's complement representation. "
}], "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.5",
    ButtonData:>{"3.2.5", "5.62"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BitOr",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitXor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitNot",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["And",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["IntegerDigits",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DigitCount",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellularAutomaton",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1082", "BitAnd"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BitAnd"],

Cell["Here are two numbers in binary. ", "ExampleText",
  CellTags->"BitAnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[10, 2]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1010"\_"2"\),
        10,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[1]//BaseForm= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[12, 2]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1100"\_"2"\),
        12,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[2]//BaseForm= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell["Here are the digits as lists. ", "ExampleText",
  CellTags->"BitAnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[10, 2]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    \({1, 0, 1, 0}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[12, 2]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    \({1, 1, 0, 0}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[TextData[{
  "The product of the two lists represents the ",
  StyleBox["BitAnd", "MR"],
  " of the two numbers. "
}], "ExampleText",
  CellTags->"BitAnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 0, 1, 0} {1, 1, 0, 0}\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    \({1, 0, 0, 0}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BitAnd[10, 12]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[%, 2]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BitAnd"],

Cell[BoxData[
    \({1, 0, 0, 0}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BitAnd"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["BitAnd", "MR"],
  " is used to construct a fractal. "
}], "ExampleText",
  CellTags->"BitAnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Table[Sign[BitAnd[x, y]], {x, 127}, {y, 127}], 
      Mesh \[Rule] False, Frame \[Rule] False]; \)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"BitAnd"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00757117 0.0192308 0.00757117 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
127 string
127 127 8 [127 0 0 127 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF00
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF00
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF00
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FF
FFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FF
FFFFFF00000000FFFFFFFF00000000FFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFF
FFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFF
FFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFF
FFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF00
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFF
FFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFF0000000000000000FF
FFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFF
FFFFFF0000000000000000FFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00
FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFF
FFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF
FFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFF
FFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FF00
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FF00FF00FF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF0000FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000000000000000000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FF00
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF
FFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF
FFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FF00
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF00
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FF
FFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFF
FFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFF
FFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00
FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000000000000000000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FF00FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFF0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"BitAnd"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BitNot", "ObjectName",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitNot[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " gives the bitwise NOT of the integer ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integer mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitNot[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " turns ones into zeros and vice versa in the binary bit representation of \
",
  StyleBox["n", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integers are assumed to be represented in two's \
complement form, with an unlimited number of digits, so that ",
  StyleBox["BitNot[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " is simply equivalent to ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-1\), "-", 
          StyleBox["n",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.5",
    ButtonData:>{"3.2.5", "5.62"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BitAnd",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitOr",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitXor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Not",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1083", "BitNot"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BitNot"],

Cell["These two commands give the same result. ", "ExampleText",
  CellTags->"BitNot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[\(-5\), 
        5] /. \[InvisibleSpace]n_?IntegerQ -> \(-\((n + 1)\)\)\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BitNot"],

Cell[BoxData[
    \({4, 3, 2, 1, 
      0, \(-1\), \(-2\), \(-3\), \(-4\), \(-5\), \(-6\)}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"BitNot"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BitNot[Range[\(-5\), 5]]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BitNot"],

Cell[BoxData[
    \({4, 3, 2, 1, 
      0, \(-1\), \(-2\), \(-3\), \(-4\), \(-5\), \(-6\)}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BitNot"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BitOr", "ObjectName",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitOr[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives the bitwise OR of the integers ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integer mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitOr[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of any of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. "
}], "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] For negative integers ",
  StyleBox["BitOr", "MR"],
  " assumes a two's complement representation. "
}], "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.5",
    ButtonData:>{"3.2.5", "5.62"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BitAnd",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitXor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitNot",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Or",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["IntegerDigits",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellularAutomaton",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1084", "BitOr"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BitOr"],

Cell["Here are two numbers in binary. ", "ExampleText",
  CellTags->"BitOr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[10, 2]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1010"\_"2"\),
        10,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[1]//BaseForm= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[12, 2]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1100"\_"2"\),
        12,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[2]//BaseForm= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell["Here are the digits as lists. ", "ExampleText",
  CellTags->"BitOr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[10, 2]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    \({1, 0, 1, 0}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[12, 2]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    \({1, 1, 0, 0}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell[TextData[{
  "The pairwise maximum of the lists represents the ",
  StyleBox["BitOr", "MR"],
  " of the two numbers. "
}], "ExampleText",
  CellTags->"BitOr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Max /@ Transpose[{{1, 0, 1, 0}, {1, 1, 0, 0}}]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    \({1, 1, 1, 0}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BitOr[10, 12]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    \(14\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"BitOr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[%, 2]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BitOr"],

Cell[BoxData[
    \({1, 1, 1, 0}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BitOr"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BitXor", "ObjectName",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitXor[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " gives the bitwise XOR of the integers ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "Usage",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integer mathematical function (see Section ",
  ButtonBox["A.3.10",
    ButtonData:>{"A.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  "). "
}], "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BitXor[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " yields the integer whose binary bit representation has ones at positions \
where an odd number of the binary bit representations of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " have ones. "
}], "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] For negative integers ",
  StyleBox["BitXor", "MR"],
  " assumes a two's complement representation. "
}], "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.5",
    ButtonData:>{"3.2.5", "5.62"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["BitAnd",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitOr",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["BitNot",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Xor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["IntegerDigits",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellularAutomaton",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1085", "BitXor"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BitXor"],

Cell["Here are three numbers in binary. ", "ExampleText",
  CellTags->"BitXor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[9, 2]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1001"\_"2"\),
        9,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[1]//BaseForm= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[10, 2]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1010"\_"2"\),
        10,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[2]//BaseForm= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[13, 2]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1101"\_"2"\),
        13,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[3]//BaseForm= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell["Here are the digits as lists. ", "ExampleText",
  CellTags->"BitXor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = IntegerDigits[9, 2]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    \({1, 0, 0, 1}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = IntegerDigits[10, 2]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    \({1, 0, 1, 0}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(c = IntegerDigits[13, 2]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    \({1, 1, 0, 1}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[TextData[{
  "Add the lists together and reduce modulo ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". The result represents the ",
  StyleBox["BitXor", "MR"],
  " of the three numbers. "
}], "ExampleText",
  CellTags->"BitXor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Mod[a + b + c, 2]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    \({1, 1, 1, 0}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BitXor[9, 10, 13]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    \(14\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[14, 2]\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"BitXor"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1110"\_"2"\),
        14,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[9]//BaseForm= ",
  CellTags->"BitXor"]
}, Open  ]],

Cell[BoxData[
    \(Clear[a, b, c]\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"BitXor"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Black", "ObjectName",
  CellTags->{"S0.1086", "Black"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Black", "MR"],
  " represents the color black in graphics or style specifications. "
}], "Usage",
  CellTags->{"S0.1086", "Black"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Black", "MR"],
  " is equivalent to ",
  StyleBox["GrayLevel[0]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1086", "Black"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["GrayLevel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RGBColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1086", "Black"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1086", "Black"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1086", "Black"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Blank", "ObjectName",
  CellTags->{"S0.1087", "Blank"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["_", "MR"],
  " or ",
  StyleBox["Blank[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is a pattern object that can stand for any ",
  StyleBox["Mathematica", "TI"],
  " expression. \n\[FilledSmallSquare] ",
  StyleBox["_", "MR"],
  StyleBox["h", "TI"],
  " or ",
  StyleBox["Blank[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " can stand for any expression with head ",
  StyleBox["h", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1087", "Blank"}],

Cell[TextData[{
  "\[FilledSmallSquare] The head ",
  StyleBox["h", "TI"],
  " in ",
  StyleBox["_", "MR"],
  StyleBox["h", "TI"],
  " cannot itself contain pattern objects. "
}], "Notes",
  CellTags->{"S0.1087", "Blank"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.1",
    ButtonData:>{"2.3.1", "1.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1087", "Blank"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Pattern",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Optional",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ForAll",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1087", "Blank"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1087", "Blank"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell["Patterns, Rules, and Replacement", "ExampleSubsection",
  CellTags->"Blank"],

Cell["\<\
This rule can be used to replace the logarithm of a power in the \
usual way. \
\>", "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(logpowerrule = Log[x_\^a_] \[Rule] a\ Log[x]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \(Log[x_\^a_] \[Rule] a\ Log[x]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell["\<\
Rules are applied using the slash\[Hyphen]dot operator. \
\>", \
"ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[\@2] - Log[1\/\[Pi]] + Log[\((x + y)\)\^3] /. 
      logpowerrule\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \(Log[2]\/2 + Log[\[Pi]] + 3\ Log[x + y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[TextData[{
  "As an aside, this rule is not built into ",
  StyleBox["Mathematica", "TI"],
  " because it is not correct in general. "
}], "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Log[\((\(-1\))\)\^2], 2\ Log[\(-1\)]}\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \({0, 2\ \[ImaginaryI]\ \[Pi]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[TextData[{
  "However, the built\[Hyphen]in function ",
  StyleBox["PowerExpand", "MR"],
  " does such transformations. "
}], "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerExpand[{Log[x\^a], Log[x\ y]}]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \({a\ Log[x], Log[x] + Log[y]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[BoxData[
    \(Clear[logpowerrule]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Blank"]
}, Closed]],

Cell[CellGroupData[{

Cell["Patterns in Function Definitions", "ExampleSubsection",
  CellTags->"Blank"],

Cell[TextData[{
  "You can often simplify the definition of a function by putting the \
arguments in a suitable form and naming the important parts. In this case we \
are avoiding the use of ",
  StyleBox["[[]]", "MR"],
  " (",
  StyleBox["Part", "MR"],
  "). "
}], "ExampleText",
  CellTags->"Blank"],

Cell[BoxData[
    \(relnorm[{x_, y_, z_, t_}] := \@\(x\^2 + y\^2 + z\^2 - t\^2\)\)], "Input",\

  CellLabel->"In[6]:= ",
  CellTags->"Blank"],

Cell["\<\
To make this definition without pattern matching, you would need to \
use a module, local variables, conditionals, and some complicated \
constructions to get at the right pieces. \
\>", "ExampleText",
  CellTags->"Blank"],

Cell[BoxData[
    \(modtrans[\(_\ z_ + _\)\/\(c_\ z_ + d_\)] := 
      1\/\((c\ z + d)\)\^\(2\ m\)\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(modtrans[\(3 + 5\ x\)\/\(1 + 2\ x\)]\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \(\((1 + 2\ x)\)\^\(\(-2\)\ m\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell["We clear the definitions. ", "ExampleText",
  CellTags->"Blank"],

Cell[BoxData[
    \(Clear[relnorm, modtrans]\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"Blank"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Using ",
  StyleBox["FullForm", "MR"]
}], "ExampleSubsection",
  CellTags->"Blank"],

Cell[TextData[{
  "The output you see from ",
  StyleBox["Mathematica", "TI"],
  " is designed for human eyes. Expressions that look the same may be \
structurally different. ",
  StyleBox["FullForm", "MR"],
  " reveals the internal representation of expressions. "
}], "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[2\/3]\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Rational[2, 3]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[10]//FullForm= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[2\/3.0]\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    TagBox[
      StyleBox["0.6666666666666666`",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[11]//FullForm= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[2\/x]\)], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[2, Power[x, \(-1\)]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[12]//FullForm= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[TextData[{
  "In this example, notice that the second square root is not transformed to \
become ",
  StyleBox["1/s", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@x + 1\/\@x /. \@a_ \[Rule] s\)], "Input",
  CellLabel->"In[13]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \(s + 1\/\@x\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullForm", "MR"],
  " shows that the representation of the square root depends on whether it is \
in the numerator or the denominator. "
}], "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[\@x]\)], "Input",
  CellLabel->"In[14]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[x, Rational[1, 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[14]//FullForm= ",
  CellTags->"Blank"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[1\/\@x]\)], "Input",
  CellLabel->"In[15]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[x, Rational[\(-1\), 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[15]//FullForm= ",
  CellTags->"Blank"]
}, Open  ]],

Cell["\<\
One rule is needed for each case, and these can be put together in \
a list. \
\>", "ExampleText",
  CellTags->"Blank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@x + 1\/\@x /. {\@a_ \[Rule] s, 1\/\@a_ \[Rule] 1\/s}\)], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"Blank"],

Cell[BoxData[
    \(1\/s + s\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"Blank"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BlankNullSequence", "ObjectName",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["___", "MR"],
  " (three ",
  StyleBox["_", "MR"],
  " characters) or ",
  StyleBox["BlankNullSequence[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is a pattern object that can stand for any sequence of zero or more ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] ",
  StyleBox["___", "MR"],
  StyleBox["h", "TI"],
  " or ",
  StyleBox["BlankNullSequence[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " can stand for any sequence of expressions, all of which have head ",
  StyleBox["h", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] Blank sequences work slightly differently depending \
on whether or not the head of the expression in which they appear is a symbol \
with the attribute ",
  ButtonBox["Flat",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] Consider matching the pattern ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  StyleBox["___,", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " against the expression ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". If ",
  StyleBox["f", "TI"],
  " is a symbol with attribute ",
  ButtonBox["Flat",
    ButtonStyle->"RefGuideLink"],
  ", then the ",
  StyleBox["___", "MR"],
  " will be taken to stand for the expression ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". If ",
  StyleBox["f", "TI"],
  " is not a symbol with attribute ",
  ButtonBox["Flat",
    ButtonStyle->"RefGuideLink"],
  ", then ",
  StyleBox["___", "MR"],
  " will be taken to stand for the sequence of expressions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  ". With a named pattern, such as ",
  StyleBox["x", "TI"],
  StyleBox["___", "MR"],
  ", ",
  StyleBox["x", "TI"],
  " can be used only as an element in an expression. The sequence of \
expressions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["b",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  " is \[OpenCurlyDoubleQuote]spliced in\[CloseCurlyDoubleQuote] to replace \
",
  StyleBox["x", "TI"],
  ", thereby usually increasing the length of the expression. "
}], "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["___", "MR"],
  " matches a sequence of length more than one, then the sequence will be \
represented by a ",
  ButtonBox["Sequence",
    ButtonStyle->"RefGuideLink"],
  " object. In most uses of ",
  StyleBox["___", "MR"],
  ", however, the ",
  ButtonBox["Sequence",
    ButtonStyle->"RefGuideLink"],
  " object will automatically be spliced into another expression, and will \
never appear explicitly. "
}], "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.8",
    ButtonData:>{"2.3.8", "8.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Pattern",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SlotSequence",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1088", "BlankNullSequence"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BlankNullSequence"],

Cell[TextData[{
  "The triple blank indicates that the second argument to the function ",
  StyleBox["f", "MR"],
  " can have any number of arguments (0, 1, 2, ...). "
}], "ExampleText",
  CellTags->"BlankNullSequence"],

Cell[BoxData[
    \(f[x_, y___] := x + y\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BlankNullSequence"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[a, b, c, d]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BlankNullSequence"],

Cell[BoxData[
    \(a + b + c + d\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BlankNullSequence"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[a]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BlankNullSequence"],

Cell[BoxData[
    \(a\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BlankNullSequence"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BlankSequence", "ObjectName",
  CellTags->{"S0.1089", "BlankSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["__", "MR"],
  " (two ",
  StyleBox["_", "MR"],
  " characters) or ",
  StyleBox["BlankSequence[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is a pattern object that can stand for any sequence of one or more ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] ",
  StyleBox["__", "MR"],
  StyleBox["h", "TI"],
  " or ",
  StyleBox["BlankSequence[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " can stand for any sequence of one or more expressions, all of which have \
head ",
  StyleBox["h", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1089", "BlankSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  ButtonBox["BlankNullSequence",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1089", "BlankSequence"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.3.8",
    ButtonData:>{"2.3.8", "8.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1089", "BlankSequence"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1089", "BlankSequence"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BlankSequence"],

Cell[TextData[{
  StyleBox["BlankSequence", "MR"],
  " differs from ",
  StyleBox["BlankNullSequence", "MR"],
  " in that it must have at least one expression to match. ",
  StyleBox["g[a,b,c]", "MR"],
  " matches the definition for g but there is no match for ",
  StyleBox["g[a]", "MR"],
  ". "
}], "ExampleText",
  CellTags->"BlankSequence"],

Cell[BoxData[
    \(g[x_, y__] := x + y\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BlankSequence"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[a, b, c]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"BlankSequence"],

Cell[BoxData[
    \(a + b + c\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"BlankSequence"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[a]\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"BlankSequence"],

Cell[BoxData[
    \(g[a]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"BlankSequence"]
}, Open  ]],

Cell[BoxData[
    \(Clear[g]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"BlankSequence"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Block", "ObjectName",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block[{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " specifies that ",
  StyleBox["expr", "TI"],
  " is to be evaluated with local values for the symbols ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", \[Ellipsis]",
  " ",
  ". \n\[FilledSmallSquare] ",
  StyleBox["Block[{", "MR"],
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " defines initial local values for ",
  StyleBox["x", "TI"],
  ", \[Ellipsis]",
  " ",
  ". "
}], "Usage",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block", "MR"],
  " allows you to set up an environment in which the values of variables can \
temporarily be changed. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] When you execute a block, values assigned to ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", \[Ellipsis]",
  " ",
  "are cleared. When the execution of the block is finished, the original \
values of these symbols are restored. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block", "MR"],
  " affects only the ",
  StyleBox["values", "TI"],
  " of symbols, not their names. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] Initial values specified for ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", \[Ellipsis]",
  " ",
  "are evaluated before ",
  StyleBox["x", "TI"],
  ", ",
  StyleBox["y", "TI"],
  ", \[Ellipsis]",
  " ",
  "are cleared. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["Block[{", "MR"],
  StyleBox["vars", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["cond", "TI"],
  StyleBox["]", "MR"],
  " as the right\[Hyphen]hand side of a transformation rule with a condition \
attached. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block", "MR"],
  " has attribute ",
  ButtonBox["HoldAll",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block", "MR"],
  " implements dynamic scoping of variables. "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Block", "MR"],
  " is automatically used to localize values of iterators in iteration \
constructs such as ",
  ButtonBox["Do",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Sum",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Table",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.7.6",
    ButtonData:>{"2.7.6", "6.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Module",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["With",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CompoundExpression",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1090", "Block"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Block"],

Cell[TextData[{
  "Here is an expression involving ",
  StyleBox["s", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Block"],

Cell[BoxData[
    \(s\^2 + 3; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Block"],

Cell[TextData[{
  "This evaluates the previous expression, using a local value for ",
  StyleBox["s", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Block"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{s = a + 1}, %]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Block"],

Cell[BoxData[
    \(3 + \((1 + a)\)\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Block"]
}, Open  ]],

Cell[TextData[{
  "There is no global value for ",
  StyleBox["s", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Block"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Block"],

Cell[BoxData[
    \(s\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Block"]
}, Open  ]],

Cell["Attempting to evaluate this sum directly does not work. ", "ExampleText",
  CellTags->"Block"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sum]\+\(n = 0\)\%\[Infinity] 1\/\(n!!\)\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Block"],

Cell[BoxData[
    \(\[Sum]\+\(n = 0\)\%\[Infinity] 1\/\(n!!\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Block"]
}, Open  ]],

Cell["This works. ", "ExampleText",
  CellTags->"Block"],

Cell[BoxData[
    \(gg[expr_] := 
      Block[{Sum}, ee = MapAt[FunctionExpand, expr, 1]; ee]\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"Block"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gg[\[Sum]\+\(n = 0\)\%\[Infinity] 1\/\(n!!\)]\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"Block"],

Cell[BoxData[
    \(1\/2\ \((\[Pi]\/2)\)\^\(1/4\)\ \((2\ \@\[ExponentialE]\ \
\((2\/\[Pi])\)\^\(1/4\) + 
          2\^\(3/4\)\ \@\[ExponentialE]\ \[Pi]\^\(1/4\)\ Erf[
              1\/\@2])\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"Block"]
}, Open  ]],

Cell[BoxData[
    \(Clear[gg, ee]\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"Block"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Blue", "ObjectName",
  CellTags->{"S0.1091", "Blue"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Blue", "MR"],
  " represents the color blue in graphics or style specifications. "
}], "Usage",
  CellTags->{"S0.1091", "Blue"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Blue", "MR"],
  " is equivalent to ",
  StyleBox["RGBColor[0,", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["1]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1091", "Blue"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Hue",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RGBColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1091", "Blue"}],

Cell[TextData[{
  "\[FilledSmallSquare] Related package: ",
  StyleBox[ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`"},
    ButtonStyle->"AddOnsLink"], "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1091", "Blue"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1091", "Blue"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boole", "ObjectName",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Boole[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " yields ",
  StyleBox["1", "MR"],
  " if ",
  StyleBox["expr", "TI"],
  " is ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " and ",
  StyleBox["0", "MR"],
  " if it is ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Usage",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Boole[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " remains unchanged if ",
  StyleBox["expr", "TI"],
  " is neither ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " nor ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Boole[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " is effectively equivalent to ",
  StyleBox["If[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["1,", "MR"],
  " ",
  StyleBox["0]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Integrate[", "MR"],
  StyleBox["f", "TI"],
  " ",
  StyleBox["Boole[", "MR"],
  StyleBox["pred", "TI"],
  StyleBox["],", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " can be used to integrate ",
  StyleBox["f", "TI"],
  " over the region in which ",
  StyleBox["pred", "TI"],
  " is ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.2.3",
    ButtonData:>{"3.2.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1092", "Boole"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["If",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Piecewise",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DiscreteDelta",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["UnitStep",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1092", "Boole"}],

Cell["\[FilledSmallSquare] New in Version 5.1.", "Notes",
  CellTags->{"S0.1092", "Boole"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Booleans", "ObjectName",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Booleans", "MR"],
  " represents the domain of booleans, as in ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Booleans", "MR"],
  ". "
}], "Usage",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] The domain of booleans is taken to consist of the \
symbols ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["x", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Booleans", "MR"],
  " evaluates immediately if ",
  StyleBox["x", "TI"],
  " is explicitly ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Simplify[", "MR"],
  StyleBox["expr", "TI"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Booleans]", "MR"],
  " can be used to try to determine whether an expression is boolean, with no \
undetermined variables. "
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Booleans", "MR"],
  " is output in ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalB]\)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 3.3.11",
    ButtonData:>{"3.3.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Element",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Integers",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell["\[FilledSmallSquare] New in Version 4.", "Notes",
  CellTags->{"S0.1093", "Booleans"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Booleans"],

Cell[TextData[{
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " are boolean. "
}], "ExampleText",
  CellTags->"Booleans"],

Cell[CellGroupData[{

Cell[BoxData[
    \(True \[Element] Booleans\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Booleans"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"Booleans"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(False \[Element] Booleans\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"Booleans"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"Booleans"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not use ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to stand for ",
  StyleBox["False", "MR"],
  " and ",
  StyleBox["True", "MR"],
  ". "
}], "ExampleText",
  CellTags->"Booleans"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0 \[Element] Booleans\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"Booleans"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"Booleans"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 \[Element] Booleans\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"Booleans"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"Booleans"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boxed", "ObjectName",
  CellTags->{"S0.1094", "Boxed"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Boxed", "MR"],
  " is an option for ",
  ButtonBox["Graphics3D",
    ButtonStyle->"RefGuideLink"],
  " which specifies whether to draw the edges of the bounding box in a three\
\[Hyphen]dimensional picture. "
}], "Usage",
  CellTags->{"S0.1094", "Boxed"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Boxed", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " draws the box; ",
  StyleBox["Boxed", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  " does not. "
}], "Notes",
  CellTags->{"S0.1094", "Boxed"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.9.6",
    ButtonData:>{"1.9.6", "6.4"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.10.13",
    ButtonData:>{"2.10.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1094", "Boxed"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1094", "Boxed"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"Boxed"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, \(3\ \[Pi]\)\/2}, {y, 0, \(3\ \[Pi]\)\/2}, 
      Boxed \[Rule] False]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"Boxed"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.49366e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.15339 .19666 -5.94672 -9 ]
[.15339 .19666 .05328 0 ]
[.2857 .14461 -5.68126 -9 ]
[.2857 .14461 .31874 0 ]
[.42503 .08982 -5.4158 -9 ]
[.42503 .08982 .5842 0 ]
[.57193 .03208 -5.15034 -9 ]
[.57193 .03208 .84966 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.77131 .10294 0 -6.15612 ]
[.77131 .10294 6 2.84388 ]
[.83516 .20071 0 -6.0622 ]
[.83516 .20071 6 2.9378 ]
[.89336 .28984 0 -5.97836 ]
[.89336 .28984 6 3.02164 ]
[.94663 .37142 0 -5.90306 ]
[.94663 .37142 6 3.09694 ]
[.02411 .2651 -12 -2.74231 ]
[.02411 .2651 0 6.25769 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48796 -6 -2.93176 ]
[-0.01144 .48796 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.759 .10747 m
.75284 .10974 L
s
[(1)] .77131 .10294 -1 .36803 Mshowa
.82276 .20501 m
.81656 .20717 L
s
[(2)] .83516 .20071 -1 .34716 Mshowa
.88089 .29393 m
.87466 .29598 L
s
[(3)] .89336 .28984 -1 .32852 Mshowa
.93411 .37533 m
.92784 .37728 L
s
[(4)] .94663 .37142 -1 .31179 Mshowa
.125 Mabswid
.70336 .02236 m
.69968 .02378 L
s
.71768 .04428 m
.714 .04568 L
s
.73173 .06576 m
.72804 .06715 L
s
.7455 .08682 m
.74181 .0882 L
s
.77224 .12773 m
.76854 .12908 L
s
.78523 .1476 m
.78153 .14893 L
s
.79798 .1671 m
.79427 .16842 L
s
.81049 .18623 m
.80677 .18754 L
s
.83481 .22345 m
.83109 .22473 L
s
.84665 .24155 m
.84292 .24282 L
s
.85827 .25933 m
.85454 .26058 L
s
.86968 .27678 m
.86595 .27803 L
s
.89191 .31078 m
.88817 .312 L
s
.90273 .32734 m
.89899 .32855 L
s
.91337 .34361 m
.90962 .34481 L
s
.92383 .35961 m
.92007 .36079 L
s
.94421 .39079 m
.94045 .39195 L
s
.95415 .40599 m
.95039 .40714 L
s
.96393 .42094 m
.96016 .42208 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25794 L
s
[(-1)] .02411 .2651 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48364 m
.00714 .48148 L
s
[(1)] -0.01144 .48796 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .28129 m
.03669 .27987 L
s
.03134 .29188 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40055 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43643 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .47171 m
.00655 .4704 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.935 .58 .321 r
.38853 .69037 .40169 .70185 .4213 .77838 .40801 .76464 Metetra
0 .265 .755 r
.40801 .76464 .4213 .77838 .44359 .78967 .43022 .78043 Metetra
.91 .761 .683 r
.43022 .78043 .44359 .78967 .4676 .71984 .45443 .71926 Metetra
.953 .775 .624 r
.45443 .71926 .4676 .71984 .49125 .62349 .47858 .62499 Metetra
.961 .829 .667 r
.47858 .62499 .49125 .62349 .51378 .57147 .50155 .56248 Metetra
.111 .541 .915 r
.50155 .56248 .51378 .57147 .53615 .59682 .52395 .56943 Metetra
.832 .466 0 r
.52395 .56943 .53615 .59682 .55967 .67724 .5471 .63738 Metetra
0 0 .213 r
.5471 .63738 .55967 .67724 .58435 .74586 .57159 .71503 Metetra
.222 .33 .763 r
.57159 .71503 .58435 .74586 .60848 .73841 .59634 .73764 Metetra
.964 .851 .682 r
.59634 .73764 .60848 .73841 .6305 .65527 .61955 .6808 Metetra
.968 .855 .45 r
.61955 .6808 .6305 .65527 .65127 .56135 .64095 .58487 Metetra
.871 .853 .396 r
.64095 .58487 .65127 .56135 .67351 .52377 .66241 .51623 Metetra
.395 .737 .992 r
.66241 .51623 .67351 .52377 .69957 .56463 .68653 .51656 Metetra
0 0 .547 r
.68653 .51656 .69957 .56463 .72914 .65005 .71456 .58147 Metetra
0 .048 .561 r
.71456 .58147 .72914 .65005 .75841 .70735 .74486 .66201 Metetra
.319 .328 .713 r
.74486 .66201 .75841 .70735 .78268 .68051 .77309 .69145 Metetra
.909 .924 .541 r
.77309 .69145 .78268 .68051 .80145 .58681 .79573 .63943 Metetra
0 0 .101 r
.79573 .63943 .80145 .58681 .81963 .49861 .81404 .5423 Metetra
0 0 .128 r
.81404 .5423 .81963 .49861 .8432 .4769 .8333 .46765 Metetra
.626 .812 .972 r
.8333 .46765 .8432 .4769 .8748 .53214 .85865 .4611 Metetra
.242 .223 .637 r
.85865 .4611 .8748 .53214 .91119 .61927 .89169 .52242 Metetra
.253 .209 .613 r
.89169 .52242 .91119 .61927 .94401 .66208 .92863 .60533 Metetra
.356 .329 .691 r
.92863 .60533 .94401 .66208 .96648 .61601 .96141 .64155 Metetra
0 0 .053 r
.96141 .64155 .96648 .61601 .98107 .51498 .98404 .59481 Metetra
.934 .574 .312 r
.37517 .67871 .38853 .69037 .40801 .76464 .39453 .75059 Metetra
0 .102 .611 r
.39453 .75059 .40801 .76464 .43022 .78043 .41664 .77041 Metetra
.9 .765 .704 r
.41664 .77041 .43022 .78043 .45443 .71926 .44099 .718 Metetra
.951 .776 .63 r
.44099 .718 .45443 .71926 .47858 .62499 .46559 .62748 Metetra
.966 .821 .65 r
.46559 .62748 .47858 .62499 .50155 .56248 .48907 .55682 Metetra
.718 .878 .956 r
.48907 .55682 .50155 .56248 .52395 .56943 .51165 .54614 Metetra
.762 .369 0 r
.51165 .54614 .52395 .56943 .5471 .63738 .53455 .59809 Metetra
.708 .403 0 r
.53455 .59809 .5471 .63738 .57159 .71503 .5587 .67672 Metetra
0 .013 .578 r
.5587 .67672 .57159 .71503 .59634 .73764 .5837 .72375 Metetra
.822 .77 .804 r
.5837 .72375 .59634 .73764 .61955 .6808 .60798 .69879 Metetra
.986 .876 .523 r
.60798 .69879 .61955 .6808 .64095 .58487 .63042 .6153 Metetra
.882 .826 .354 r
.63042 .6153 .64095 .58487 .66241 .51623 .65184 .52822 Metetra
.82 .932 .558 r
.65184 .52822 .66241 .51623 .68653 .51656 .6745 .48954 Metetra
.034 .227 .73 r
.6745 .48954 .68653 .51656 .71456 .58147 .70046 .51834 Metetra
0 .039 .561 r
.70046 .51834 .71456 .58147 .74486 .66201 .72994 .59342 Metetra
.114 .136 .605 r
.72994 .59342 .74486 .66201 .77309 .69145 .76039 .66122 Metetra
.507 .514 .799 r
.76039 .66122 .77309 .69145 .79573 .63943 .78758 .66721 Metetra
.78758 .66721 .79573 .63943 .81404 .5423 .8092 .60086 Metetra
0 0 .184 r
.8092 .60086 .81404 .5423 .8333 .46765 .82755 .50588 Metetra
0 0 .113 r
.82755 .50588 .8333 .46765 .85865 .4611 .84777 .44158 Metetra
.535 .611 .876 r
.84777 .44158 .85865 .4611 .89169 .52242 .87433 .44279 Metetra
.282 .242 .634 r
.87433 .44279 .89169 .52242 .92863 .60533 .90825 .50461 Metetra
.283 .227 .617 r
.90825 .50461 .92863 .60533 .96141 .64155 .94573 .58394 Metetra
.358 .33 .69 r
.94573 .58394 .96141 .64155 .98404 .59481 .97924 .62007 Metetra
.932 .568 .301 r
.36161 .66687 .37517 .67871 .39453 .75059 .38087 .73621 Metetra
.521 .029 0 r
.38087 .73621 .39453 .75059 .41664 .77041 .40285 .75957 Metetra
.884 .769 .729 r
.40285 .75957 .41664 .77041 .44099 .718 .42727 .71591 Metetra
.948 .779 .639 r
.42727 .71591 .44099 .718 .46559 .62748 .45227 .63063 Metetra
.968 .816 .64 r
.45227 .63063 .46559 .62748 .48907 .55682 .4763 .5543 Metetra
.892 .901 .827 r
.4763 .5543 .48907 .55682 .51165 .54614 .49921 .52748 Metetra
0 0 .402 r
.49921 .52748 .51165 .54614 .53455 .59809 .52199 .56127 Metetra
.701 .386 0 r
.52199 .56127 .53455 .59809 .5587 .67672 .54575 .63357 Metetra
0 0 .435 r
.54575 .63357 .5587 .67672 .5837 .72375 .5707 .69681 Metetra
.463 .51 .821 r
.5707 .69681 .5837 .72375 .60798 .69879 .59574 .70414 Metetra
.982 .894 .654 r
.59574 .70414 .60798 .69879 .63042 .6153 .61939 .6452 Metetra
.906 .839 .381 r
.61939 .6452 .63042 .6153 .65184 .52822 .64145 .55539 Metetra
.791 .807 .32 r
.64145 .55539 .65184 .52822 .6745 .48954 .6634 .48667 Metetra
.704 .947 .957 r
.6634 .48667 .6745 .48954 .70046 .51834 .68742 .47405 Metetra
.046 .142 .642 r
.68742 .47405 .70046 .51834 .72994 .59342 .71495 .52066 Metetra
.066 .095 .581 r
.71495 .52066 .72994 .59342 .76039 .66122 .74541 .59666 Metetra
.206 .208 .64 r
.74541 .59666 .76039 .66122 .78758 .66721 .7758 .65063 Metetra
.686 .728 .882 r
.7758 .65063 .78758 .66721 .8092 .60086 .80227 .64058 Metetra
0 0 .046 r
.80227 .64058 .8092 .60086 .82755 .50588 .82345 .56802 Metetra
0 0 .236 r
.82345 .56802 .82755 .50588 .84777 .44158 .84203 .47677 Metetra
0 0 .102 r
.84203 .47677 .84777 .44158 .87433 .44279 .86289 .41805 Metetra
.537 .565 .831 r
.86289 .41805 .87433 .44279 .90825 .50461 .89002 .42024 Metetra
.321 .264 .636 r
.89002 .42024 .90825 .50461 .94573 .58394 .92431 .47827 Metetra
.309 .242 .618 r
.92431 .47827 .94573 .58394 .97924 .62007 .96238 .55494 Metetra
.93 .561 .289 r
.34784 .65485 .36161 .66687 .38087 .73621 .36702 .72151 Metetra
.618 .125 0 r
.36702 .72151 .38087 .73621 .40285 .75957 .38886 .74791 Metetra
.863 .772 .76 r
.38886 .74791 .40285 .75957 .42727 .71591 .41328 .71283 Metetra
.944 .782 .65 r
.41328 .71283 .42727 .71591 .45227 .63063 .43861 .6341 Metetra
.968 .814 .636 r
.43861 .6341 .45227 .63063 .4763 .5543 .4632 .55464 Metetra
.944 .885 .744 r
.4632 .55464 .4763 .5543 .49921 .52748 .48656 .51375 Metetra
0 .32 .8 r
.48656 .51375 .49921 .52748 .52199 .56127 .50939 .52856 Metetra
0 0 .266 r
.50939 .52856 .52199 .56127 .54575 .63357 .53282 .5886 Metetra
0 0 .369 r
.53282 .5886 .54575 .63357 .5707 .69681 .5575 .65867 Metetra
.065 .188 .683 r
.5575 .65867 .5707 .69681 .59574 .70414 .5829 .69363 Metetra
.852 .82 .816 r
.5829 .69363 .59574 .70414 .61939 .6452 .60767 .66661 Metetra
.946 .883 .478 r
.60767 .66661 .61939 .6452 .64145 .55539 .63083 .59009 Metetra
.786 .775 .269 r
.63083 .59009 .64145 .55539 .6634 .48667 .65291 .50598 Metetra
.749 .841 .391 r
.65291 .50598 .6634 .48667 .68742 .47405 .67565 .45642 Metetra
.404 .568 .902 r
.67565 .45642 .68742 .47405 .71495 .52066 .70095 .46264 Metetra
.109 .149 .623 r
.70095 .46264 .71495 .52066 .74541 .59666 .72972 .51824 Metetra
.143 .143 .598 r
.72972 .51824 .74541 .59666 .7758 .65063 .76087 .59068 Metetra
.27 .262 .666 r
.76087 .59068 .7758 .65063 .80227 .64058 .79126 .63383 Metetra
.797 .915 .919 r
.79126 .63383 .80227 .64058 .82345 .56802 .81749 .61548 Metetra
0 0 .156 r
.81749 .61548 .82345 .56802 .84203 .47677 .83868 .54224 Metetra
0 0 .274 r
.83868 .54224 .84203 .47677 .86289 .41805 .85756 .45429 Metetra
0 0 .127 r
.85756 .45429 .86289 .41805 .89002 .42024 .87864 .39621 Metetra
.595 .606 .833 r
.87864 .39621 .89002 .42024 .92431 .47827 .90567 .39338 Metetra
.361 .29 .642 r
.90567 .39338 .92431 .47827 .96238 .55494 .93976 .44352 Metetra
.928 .553 .275 r
.33385 .64264 .34784 .65485 .36702 .72151 .35297 .70649 Metetra
.68 .192 0 r
.35297 .70649 .36702 .72151 .38886 .74791 .37468 .7354 Metetra
.831 .772 .796 r
.37468 .7354 .38886 .74791 .41328 .71283 .39904 .70861 Metetra
.939 .786 .665 r
.39904 .70861 .41328 .71283 .43861 .6341 .42462 .63752 Metetra
.968 .814 .637 r
.42462 .63752 .43861 .6341 .4632 .55464 .44974 .55744 Metetra
.964 .871 .696 r
.44974 .55744 .4632 .55464 .48656 .51375 .47364 .50506 Metetra
.561 .79 .985 r
.47364 .50506 .48656 .51375 .50939 .52856 .4967 .50127 Metetra
0 0 .417 r
.4967 .50127 .50939 .52856 .53282 .5886 .51993 .54485 Metetra
0 0 .365 r
.51993 .54485 .53282 .5886 .5575 .65867 .54422 .61264 Metetra
0 0 .553 r
.54422 .61264 .5575 .65867 .5829 .69363 .56963 .66666 Metetra
.478 .524 .826 r
.56963 .66666 .5829 .69363 .60767 .66661 .59518 .67259 Metetra
.969 .932 .677 r
.59518 .67259 .60767 .66661 .63083 .59009 .61962 .62242 Metetra
.817 .804 .313 r
.61962 .62242 .63083 .59009 .65291 .50598 .64254 .5406 Metetra
.64254 .5406 .65291 .50598 .67565 .45642 .6649 .46663 Metetra
.781 .94 .591 r
.6649 .46663 .67565 .45642 .70095 .46264 .68847 .43244 Metetra
.318 .396 .785 r
.68847 .43244 .70095 .46264 .72972 .51824 .71486 .45002 Metetra
.173 .176 .62 r
.71486 .45002 .72972 .51824 .76087 .59068 .74457 .50842 Metetra
.201 .18 .609 r
.74457 .50842 .76087 .59068 .79126 .63383 .77627 .57629 Metetra
.306 .293 .68 r
.77627 .57629 .79126 .63383 .81749 .61548 .80692 .61346 Metetra
.775 .985 .902 r
.80692 .61346 .81749 .61548 .83868 .54224 .83344 .59379 Metetra
0 0 .216 r
.83344 .59379 .83868 .54224 .85756 .45429 .85509 .52395 Metetra
.011 0 .307 r
.85509 .52395 .85756 .45429 .87864 .39621 .87429 .43855 Metetra
0 0 .192 r
.87429 .43855 .87864 .39621 .90567 .39338 .89518 .37696 Metetra
.722 .751 .875 r
.89518 .37696 .90567 .39338 .93976 .44352 .92143 .36379 Metetra
.924 .544 .259 r
.31963 .63024 .33385 .64264 .35297 .70649 .33873 .69114 Metetra
.721 .237 0 r
.33873 .69114 .35297 .70649 .37468 .7354 .36029 .72203 Metetra
.785 .767 .837 r
.36029 .72203 .37468 .7354 .39904 .70861 .38454 .7031 Metetra
.93 .79 .684 r
.38454 .7031 .39904 .70861 .42462 .63752 .41028 .64048 Metetra
.966 .816 .643 r
.41028 .64048 .42462 .63752 .44974 .55744 .43588 .5622 Metetra
.973 .863 .669 r
.43588 .5622 .44974 .55744 .47364 .50506 .46038 .50124 Metetra
.846 .91 .878 r
.46038 .50124 .47364 .50506 .4967 .50127 .48383 .48033 Metetra
0 .134 .681 r
.48383 .48033 .4967 .50127 .51993 .54485 .50704 .50512 Metetra
0 0 .42 r
.50704 .50512 .51993 .54485 .54422 .61264 .53098 .5629 Metetra
0 0 .493 r
.53098 .5629 .54422 .61264 .56963 .66666 .55611 .62544 Metetra
.129 .22 .691 r
.55611 .62544 .56963 .66666 .59518 .67259 .58202 .65902 Metetra
.768 .786 .867 r
.58202 .65902 .59518 .67259 .61962 .62242 .60756 .64209 Metetra
.895 .897 .481 r
.60756 .64209 .61962 .62242 .64254 .5406 .63177 .57946 Metetra
.63177 .57946 .64254 .5406 .6649 .46663 .65467 .49906 Metetra
.65467 .49906 .6649 .46663 .68847 .43244 .67744 .43477 Metetra
.819 1 .813 r
.67744 .43477 .68847 .43244 .71486 .45002 .70175 .41049 Metetra
.328 .354 .736 r
.70175 .41049 .71486 .45002 .74457 .50842 .72895 .43291 Metetra
.23 .206 .623 r
.72895 .43291 .74457 .50842 .77627 .57629 .75934 .49015 Metetra
.245 .207 .616 r
.75934 .49015 .77627 .57629 .80692 .61346 .79158 .55419 Metetra
.321 .3 .68 r
.79158 .55419 .80692 .61346 .83344 .59379 .82284 .59042 Metetra
.693 .959 .947 r
.82284 .59042 .83344 .59379 .85509 .52395 .85023 .57555 Metetra
.007 0 .244 r
.85023 .57555 .85509 .52395 .87429 .43855 .8728 .51298 Metetra
.079 0 .335 r
.8728 .51298 .87429 .43855 .89518 .37696 .89245 .43048 Metetra
.01 0 .271 r
.89245 .43048 .89518 .37696 .92143 .36379 .91288 .36281 Metetra
.921 .533 .24 r
.3052 .61764 .31963 .63024 .33873 .69114 .32428 .67547 Metetra
.745 .267 0 r
.32428 .67547 .33873 .69114 .36029 .72203 .34571 .70781 Metetra
.716 .75 .88 r
.34571 .70781 .36029 .72203 .38454 .7031 .3698 .6962 Metetra
.919 .795 .708 r
.3698 .6962 .38454 .7031 .41028 .64048 .39561 .64261 Metetra
.963 .819 .653 r
.39561 .64261 .41028 .64048 .43588 .5622 .42162 .56834 Metetra
.977 .859 .655 r
.42162 .56834 .43588 .5622 .46038 .50124 .44672 .50192 Metetra
.934 .916 .775 r
.44672 .50192 .46038 .50124 .48383 .48033 .4707 .46626 Metetra
.327 .591 .94 r
.4707 .46626 .48383 .48033 .50704 .50512 .49409 .47169 Metetra
0 0 .544 r
.49409 .47169 .50704 .50512 .53098 .5629 .5178 .51387 Metetra
0 0 .495 r
.5178 .51387 .53098 .5629 .55611 .62544 .54254 .57448 Metetra
0 .067 .594 r
.54254 .57448 .55611 .62544 .58202 .65902 .56839 .6257 Metetra
.356 .413 .783 r
.56839 .6257 .58202 .65902 .60756 .64209 .59463 .64102 Metetra
.91 .948 .813 r
.59463 .64102 .60756 .64209 .63177 .57946 .62015 .60932 Metetra
.723 .779 .288 r
.62015 .60932 .63177 .57946 .65467 .49906 .64428 .54186 Metetra
.64428 .54186 .65467 .49906 .67744 .43477 .66734 .46535 Metetra
.66734 .46535 .67744 .43477 .70175 .41049 .69052 .40786 Metetra
.815 .971 .9 r
.69052 .40786 .70175 .41049 .72895 .43291 .71536 .38787 Metetra
.368 .361 .72 r
.71536 .38787 .72895 .43291 .75934 .49015 .74308 .40976 Metetra
.28 .235 .628 r
.74308 .40976 .75934 .49015 .79158 .55419 .77391 .46304 Metetra
.281 .228 .618 r
.77391 .46304 .79158 .55419 .82284 .59042 .80669 .5242 Metetra
.326 .292 .666 r
.80669 .5242 .82284 .59042 .85023 .57555 .8389 .56363 Metetra
.567 .775 .976 r
.8389 .56363 .85023 .57555 .8728 .51298 .86774 .55897 Metetra
.068 0 .237 r
.86774 .55897 .8728 .51298 .89245 .43048 .89185 .50824 Metetra
.141 0 .356 r
.89185 .50824 .89245 .43048 .91288 .36281 .91237 .43117 Metetra
.915 .519 .218 r
.29053 .60484 .3052 .61764 .32428 .67547 .30964 .65947 Metetra
.759 .284 0 r
.30964 .65947 .32428 .67547 .34571 .70781 .33094 .69273 Metetra
.616 .716 .917 r
.33094 .69273 .34571 .70781 .3698 .6962 .35484 .68777 Metetra
.901 .799 .738 r
.35484 .68777 .3698 .6962 .39561 .64261 .38062 .6435 Metetra
.959 .824 .668 r
.38062 .6435 .39561 .64261 .42162 .56834 .40693 .57518 Metetra
.979 .859 .651 r
.40693 .57518 .42162 .56834 .44672 .50192 .43262 .50649 Metetra
.964 .908 .712 r
.43262 .50649 .44672 .50192 .4707 .46626 .45721 .45915 Metetra
.744 .871 .939 r
.45721 .45915 .4707 .46626 .49409 .47169 .48098 .44625 Metetra
0 .229 .741 r
.48098 .44625 .49409 .47169 .5178 .51387 .50465 .46963 Metetra
0 0 .552 r
.50465 .46963 .5178 .51387 .54254 .57448 .52902 .51959 Metetra
0 .024 .562 r
.52902 .51959 .54254 .57448 .56839 .6257 .55454 .57647 Metetra
.126 .189 .659 r
.55454 .57647 .56839 .6257 .59463 .64102 .58098 .61582 Metetra
.515 .569 .848 r
.58098 .61582 .59463 .64102 .62015 .60932 .60749 .61817 Metetra
.881 .975 .67 r
.60749 .61817 .62015 .60932 .64428 .54186 .63309 .57898 Metetra
.63309 .57898 .64428 .54186 .66734 .46535 .65732 .51131 Metetra
0 0 .012 r
.65732 .51131 .66734 .46535 .69052 .40786 .68061 .43872 Metetra
.68061 .43872 .69052 .40786 .71536 .38787 .70412 .38444 Metetra
.825 .964 .897 r
.70412 .38444 .71536 .38787 .74308 .40976 .72927 .36367 Metetra
.422 .394 .723 r
.72927 .36367 .74308 .40976 .77391 .46304 .75718 .38047 Metetra
.329 .266 .634 r
.75718 .38047 .77391 .46304 .80669 .5242 .78818 .42713 Metetra
.315 .246 .618 r
.78818 .42713 .80669 .5242 .8389 .56363 .82142 .48528 Metetra
.334 .28 .647 r
.82142 .48528 .8389 .56363 .86774 .55897 .85479 .53018 Metetra
.427 .498 .829 r
.85479 .53018 .86774 .55897 .89185 .50824 .88562 .53997 Metetra
.09 0 .145 r
.88562 .53997 .89185 .50824 .91237 .43117 .91205 .50658 Metetra
.909 .503 .191 r
.27563 .59183 .29053 .60484 .30964 .65947 .29478 .64315 Metetra
.764 .29 0 r
.29478 .64315 .30964 .65947 .33094 .69273 .31598 .67679 Metetra
.481 .655 .937 r
.31598 .67679 .33094 .69273 .35484 .68777 .33966 .67775 Metetra
.874 .801 .774 r
.33966 .67775 .35484 .68777 .38062 .6435 .36533 .64276 Metetra
.951 .83 .689 r
.36533 .64276 .38062 .6435 .40693 .57518 .39184 .58199 Metetra
.978 .862 .655 r
.39184 .58199 .40693 .57518 .43262 .50649 .41804 .51414 Metetra
.976 .903 .676 r
.41804 .51414 .43262 .50649 .45721 .45915 .44328 .45867 Metetra
.903 .938 .824 r
.44328 .45867 .45721 .45915 .48098 .44625 .46758 .42979 Metetra
.416 .607 .926 r
.46758 .42979 .48098 .44625 .50465 .46963 .49144 .43353 Metetra
0 .144 .665 r
.49144 .43353 .50465 .46963 .52902 .51959 .51561 .46688 Metetra
0 .055 .583 r
.51561 .46688 .52902 .51959 .55454 .57647 .5407 .51817 Metetra
.056 .113 .606 r
.5407 .51817 .55454 .57647 .58098 .61582 .56692 .56899 Metetra
.234 .274 .699 r
.56692 .56899 .58098 .61582 .60749 .61817 .59387 .59916 Metetra
.604 .68 .895 r
.59387 .59916 .60749 .61817 .63309 .57898 .62069 .59448 Metetra
.731 .892 .5 r
.62069 .59448 .63309 .57898 .65732 .51131 .64652 .55351 Metetra
.64652 .55351 .65732 .51131 .68061 .43872 .67101 .48837 Metetra
0 0 .086 r
.67101 .48837 .68061 .43872 .70412 .38444 .69459 .41889 Metetra
.69459 .41889 .70412 .38444 .72927 .36367 .71834 .36455 Metetra
.838 .999 .819 r
.71834 .36455 .72927 .36367 .75718 .38047 .74353 .33876 Metetra
.495 .457 .744 r
.74353 .33876 .75718 .38047 .78818 .42713 .77128 .34639 Metetra
.379 .303 .644 r
.77128 .34639 .78818 .42713 .82142 .48528 .80209 .38319 Metetra
.351 .267 .619 r
.80209 .38319 .82142 .48528 .85479 .53018 .83551 .43619 Metetra
.351 .275 .63 r
.83551 .43619 .85479 .53018 .88562 .53997 .86998 .48596 Metetra
.375 .354 .708 r
.86998 .48596 .88562 .53997 .91205 .50658 .90311 .51207 Metetra
.9 .484 .159 r
.26048 .57861 .27563 .59183 .29478 .64315 .27972 .6265 Metetra
.76 .287 0 r
.27972 .6265 .29478 .64315 .31598 .67679 .30083 .66 Metetra
.321 .568 .927 r
.30083 .66 .31598 .67679 .33966 .67775 .32429 .66604 Metetra
.834 .797 .816 r
.32429 .66604 .33966 .67775 .36533 .64276 .34977 .64004 Metetra
.938 .836 .718 r
.34977 .64004 .36533 .64276 .39184 .58199 .37634 .58799 Metetra
.975 .868 .668 r
.37634 .58799 .39184 .58199 .41804 .51414 .40295 .52383 Metetra
.98 .903 .66 r
.40295 .52383 .41804 .51414 .44328 .45867 .42883 .46403 Metetra
.951 .943 .734 r
.42883 .46403 .44328 .45867 .46758 .42979 .45377 .42257 Metetra
.766 .878 .928 r
.45377 .42257 .46758 .42979 .49144 .43353 .47804 .40788 Metetra
.265 .412 .823 r
.47804 .40788 .49144 .43353 .51561 .46688 .50223 .4217 Metetra
.067 .159 .652 r
.50223 .4217 .51561 .46688 .5407 .51817 .52698 .45894 Metetra
.074 .122 .608 r
.52698 .45894 .5407 .51817 .56692 .56899 .55276 .50813 Metetra
.153 .177 .632 r
.55276 .50813 .56692 .56899 .59387 .59916 .57961 .55333 Metetra
.295 .321 .718 r
.57961 .55333 .59387 .59916 .62069 .59448 .60707 .57824 Metetra
.621 .728 .923 r
.60707 .57824 .62069 .59448 .64652 .55351 .6343 .57197 Metetra
.6343 .57197 .64652 .55351 .67101 .48837 .66055 .53372 Metetra
0 0 .066 r
.66055 .53372 .67101 .48837 .69459 .41889 .68548 .47317 Metetra
0 0 .153 r
.68548 .47317 .69459 .41889 .71834 .36455 .70944 .40637 Metetra
0 0 .083 r
.70944 .40637 .71834 .36455 .74353 .33876 .73334 .34978 Metetra
.67 .882 .514 r
.73334 .34978 .74353 .33876 .77128 .34639 .75836 .31585 Metetra
.608 .579 .796 r
.75836 .31585 .77128 .34639 .80209 .38319 .7856 .31073 Metetra
.439 .353 .662 r
.7856 .31073 .80209 .38319 .83551 .43619 .81576 .3337 Metetra
.392 .294 .623 r
.81576 .3337 .83551 .43619 .86998 .48596 .84884 .37715 Metetra
.377 .282 .619 r
.84884 .37715 .86998 .48596 .90311 .51207 .88392 .42743 Metetra
.888 .459 .121 r
.24509 .56518 .26048 .57861 .27972 .6265 .26444 .60953 Metetra
.749 .273 0 r
.26444 .60953 .27972 .6265 .30083 .66 .2855 .64237 Metetra
.158 .466 .89 r
.2855 .64237 .30083 .66 .32429 .66604 .30873 .6526 Metetra
.773 .782 .86 r
.30873 .6526 .32429 .66604 .34977 .64004 .33396 .63503 Metetra
.917 .84 .754 r
.33396 .63503 .34977 .64004 .37634 .58799 .36048 .59241 Metetra
.968 .876 .691 r
.36048 .59241 .37634 .58799 .40295 .52383 .38736 .53438 Metetra
.98 .907 .658 r
.38736 .53438 .40295 .52383 .42883 .46403 .41381 .47407 Metetra
.964 .94 .679 r
.41381 .47407 .42883 .46403 .45377 .42257 .43944 .42411 Metetra
.906 .962 .813 r
.43944 .42411 .45377 .42257 .47804 .40788 .46429 .39389 Metetra
.619 .742 .934 r
.46429 .39389 .47804 .40788 .50223 .4217 .48875 .38815 Metetra
.264 .351 .766 r
.48875 .38815 .50223 .4217 .52698 .45894 .51338 .40652 Metetra
.159 .198 .653 r
.51338 .40652 .52698 .45894 .55276 .50813 .53874 .44355 Metetra
.167 .176 .624 r
.53874 .44355 .55276 .50813 .57961 .55333 .56515 .48922 Metetra
.222 .218 .643 r
.56515 .48922 .57961 .55333 .60707 .57824 .59257 .53039 Metetra
.323 .334 .716 r
.59257 .53039 .60707 .57824 .6343 .57197 .62056 .5539 Metetra
.569 .688 .921 r
.62056 .5539 .6343 .57197 .66055 .53372 .64836 .55065 Metetra
.64836 .55065 .66055 .53372 .68548 .47317 .67525 .51899 Metetra
0 0 .114 r
.67525 .51899 .68548 .47317 .70944 .40637 .70085 .46543 Metetra
0 0 .21 r
.70085 .46543 .70944 .40637 .73334 .34978 .72534 .40218 Metetra
0 0 .187 r
.72534 .40218 .73334 .34978 .75836 .31585 .74945 .34296 Metetra
.74945 .34296 .75836 .31585 .7856 .31073 .77419 .29942 Metetra
.811 .864 .887 r
.77419 .29942 .7856 .31073 .81576 .3337 .80063 .279 Metetra
.525 .441 .703 r
.80063 .279 .81576 .3337 .84884 .37715 .82964 .28411 Metetra
.443 .335 .636 r
.82964 .28411 .84884 .37715 .88392 .42743 .86164 .31196 Metetra
.871 .428 .073 r
.22944 .55152 .24509 .56518 .26444 .60953 .24895 .59223 Metetra
.728 .25 0 r
.24895 .59223 .26444 .60953 .2855 .64237 .26999 .62393 Metetra
.02 .37 .838 r
.26999 .62393 .2855 .64237 .30873 .6526 .29301 .63742 Metetra
.686 .749 .9 r
.29301 .63742 .30873 .6526 .33396 .63503 .31795 .62744 Metetra
.882 .839 .798 r
.31795 .62744 .33396 .63503 .36048 .59241 .34431 .59446 Metetra
.954 .884 .724 r
.34431 .59446 .36048 .59241 .38736 .53438 .37131 .54449 Metetra
.975 .916 .672 r
.37131 .54449 .38736 .53438 .41381 .47407 .3982 .48721 Metetra
.963 .94 .651 r
.3982 .48721 .41381 .47407 .43944 .42411 .42449 .4332 Metetra
.935 .968 .707 r
.42449 .4332 .43944 .42411 .46429 .39389 .45002 .3916 Metetra
.854 .948 .878 r
.45002 .3916 .46429 .39389 .48875 .38815 .47498 .36864 Metetra
.553 .644 .894 r
.47498 .36864 .48875 .38815 .51338 .40652 .49976 .367 Metetra
.313 .351 .741 r
.49976 .367 .51338 .40652 .53874 .44355 .52489 .38562 Metetra
.241 .241 .658 r
.52489 .38562 .53874 .44355 .56515 .48922 .5508 .41976 Metetra
.241 .219 .633 r
.5508 .41976 .56515 .48922 .59257 .53039 .57776 .46135 Metetra
.273 .245 .644 r
.57776 .46135 .59257 .53039 .62056 .5539 .60573 .50002 Metetra
.335 .324 .698 r
.60573 .50002 .62056 .5539 .64836 .55065 .63431 .52511 Metetra
.482 .566 .864 r
.63431 .52511 .64836 .55065 .67525 .51899 .66283 .52846 Metetra
.439 .815 .565 r
.66283 .52846 .67525 .51899 .70085 .46543 .69061 .50696 Metetra
0 0 .119 r
.69061 .50696 .70085 .46543 .72534 .40218 .71718 .46367 Metetra
.073 0 .247 r
.71718 .46367 .72534 .40218 .74945 .34296 .74251 .40679 Metetra
.079 0 .263 r
.74251 .40679 .74945 .34296 .77419 .29942 .76705 .34706 Metetra
0 0 .185 r
.76705 .34706 .77419 .29942 .80063 .279 .79162 .29502 Metetra
.79162 .29502 .80063 .279 .82964 .28411 .81718 .25886 Metetra
.71 .678 .816 r
.81718 .25886 .82964 .28411 .86164 .31196 .84468 .24343 Metetra
.847 .388 .014 r
.21353 .53763 .22944 .55152 .24895 .59223 .23323 .5746 Metetra
.695 .214 0 r
.23323 .5746 .24895 .59223 .26999 .62393 .2543 .60468 Metetra
0 .296 .791 r
.2543 .60468 .26999 .62393 .29301 .63742 .27714 .62048 Metetra
.574 .695 .924 r
.27714 .62048 .29301 .63742 .31795 .62744 .30178 .61707 Metetra
.828 .826 .847 r
.30178 .61707 .31795 .62744 .34431 .59446 .32788 .59345 Metetra
.93 .89 .77 r
.32788 .59345 .34431 .59446 .37131 .54449 .35484 .55279 Metetra
.966 .928 .701 r
.35484 .55279 .37131 .54449 .3982 .48721 .38202 .50157 Metetra
.955 .946 .646 r
.38202 .50157 .3982 .48721 .42449 .4332 .40886 .44793 Metetra
.923 .958 .636 r
.40886 .44793 .42449 .4332 .45002 .3916 .4351 .39984 Metetra
.9 .985 .73 r
.4351 .39984 .45002 .3916 .47498 .36864 .46071 .36383 Metetra
.818 .926 .906 r
.46071 .36383 .47498 .36864 .49976 .367 .48591 .34418 Metetra
.556 .613 .865 r
.48591 .34418 .49976 .367 .52489 .38562 .5111 .34262 Metetra
.377 .379 .734 r
.5111 .34262 .52489 .38562 .5508 .41976 .5367 .35821 Metetra
.314 .283 .664 r
.5367 .35821 .5508 .41976 .57776 .46135 .56309 .38741 Metetra
.303 .255 .637 r
.56309 .38741 .57776 .46135 .60573 .50002 .59052 .42424 Metetra
.316 .264 .639 r
.59052 .42424 .60573 .50002 .63431 .52511 .61898 .46093 Metetra
.347 .308 .672 r
.61898 .46093 .63431 .52511 .66283 .52846 .64816 .48902 Metetra
.415 .434 .771 r
.64816 .48902 .66283 .52846 .69061 .50696 .67752 .50112 Metetra
.547 .881 .989 r
.67752 .50112 .69061 .50696 .71718 .46367 .70643 .49277 Metetra
.012 0 .017 r
.70643 .49277 .71718 .46367 .74251 .40679 .73434 .46373 Metetra
.144 0 .25 r
.73434 .46373 .74251 .40679 .76705 .34706 .76097 .41807 Metetra
.172 0 .304 r
.76097 .41807 .76705 .34706 .79162 .29502 .78646 .36304 Metetra
.154 0 .298 r
.78646 .36304 .79162 .29502 .81718 .25886 .81132 .30716 Metetra
.06 0 .211 r
.81132 .30716 .81718 .25886 .84468 .24343 .83632 .25847 Metetra
.812 .335 0 r
.19735 .52351 .21353 .53763 .23323 .5746 .21728 .55664 Metetra
.646 .163 0 r
.21728 .55664 .23323 .5746 .2543 .60468 .23842 .58467 Metetra
0 .253 .761 r
.23842 .58467 .2543 .60468 .27714 .62048 .26113 .60181 Metetra
.451 .623 .926 r
.26113 .60181 .27714 .62048 .30178 .61707 .28547 .60378 Metetra
.746 .793 .891 r
.28547 .60378 .30178 .61707 .32788 .59345 .31126 .58877 Metetra
.887 .885 .824 r
.31126 .58877 .32788 .59345 .35484 .55279 .33805 .55793 Metetra
.947 .94 .749 r
.33805 .55793 .35484 .55279 .38202 .50157 .36532 .51505 Metetra
.942 .958 .667 r
.36532 .51505 .38202 .50157 .40886 .44793 .39257 .46575 Metetra
.896 .951 .601 r
.39257 .46575 .40886 .44793 .4351 .39984 .41943 .41629 Metetra
.854 .952 .6 r
.41943 .41629 .4351 .39984 .46071 .36383 .44575 .37256 Metetra
.858 .99 .725 r
.44575 .37256 .46071 .36383 .48591 .34418 .47158 .33928 Metetra
.815 .93 .909 r
.47158 .33928 .48591 .34418 .5111 .34262 .49714 .31961 Metetra
.6 .637 .859 r
.49714 .31961 .5111 .34262 .5367 .35821 .52274 .31495 Metetra
.445 .423 .74 r
.52274 .31495 .5367 .35821 .56309 .38741 .54876 .32486 Metetra
.381 .327 .672 r
.54876 .32486 .56309 .38741 .59052 .42424 .57555 .34713 Metetra
.359 .289 .641 r
.57555 .34713 .59052 .42424 .61898 .46093 .60333 .37779 Metetra
.358 .282 .634 r
.60333 .37779 .61898 .46093 .64816 .48902 .63216 .41144 Metetra
.369 .3 .647 r
.63216 .41144 .64816 .48902 .67752 .50112 .66187 .44178 Metetra
.394 .353 .694 r
.66187 .44178 .67752 .50112 .70643 .49277 .69209 .46252 Metetra
.453 .519 .836 r
.69209 .46252 .70643 .49277 .73434 .46373 .72226 .46856 Metetra
.72226 .46856 .73434 .46373 .76097 .41807 .75182 .45716 Metetra
.172 0 .163 r
.75182 .45716 .76097 .41807 .78646 .36304 .78031 .42859 Metetra
.235 0 .302 r
.78031 .42859 .78646 .36304 .81132 .30716 .80752 .38611 Metetra
.247 .007 .34 r
.80752 .38611 .81132 .30716 .83632 .25847 .83359 .33516 Metetra
.76 .264 0 r
.1809 .50916 .19735 .52351 .21728 .55664 .20111 .53835 Metetra
.575 .093 0 r
.20111 .53835 .21728 .55664 .23842 .58467 .22237 .5639 Metetra
0 .241 .754 r
.22237 .5639 .23842 .58467 .26113 .60181 .24499 .58145 Metetra
.341 .549 .909 r
.24499 .58145 .26113 .60181 .28547 .60378 .26907 .58748 Metetra
.641 .735 .917 r
.26907 .58748 .28547 .60378 .31126 .58877 .29451 .57994 Metetra
.816 .858 .88 r
.29451 .57994 .31126 .58877 .33805 .55793 .32103 .55868 Metetra
.909 .942 .815 r
.32103 .55868 .33805 .55793 .36532 .51505 .34822 .52546 Metetra
.922 .975 .718 r
.34822 .52546 .36532 .51505 .39257 .46575 .37567 .48365 Metetra
.865 .954 .605 r
.37567 .48365 .39257 .46575 .41943 .41629 .40301 .43759 Metetra
.784 .911 .521 r
.40301 .43759 .41943 .41629 .44575 .37256 .43 .39189 Metetra
.742 .903 .521 r
.43 .39189 .44575 .37256 .47158 .33928 .45654 .35085 Metetra
.784 .966 .662 r
.45654 .35085 .47158 .33928 .49714 .31961 .4827 .318 Metetra
.829 .973 .889 r
.4827 .318 .49714 .31961 .52274 .31495 .50865 .29583 Metetra
.674 .714 .878 r
.50865 .29583 .52274 .31495 .54876 .32486 .53467 .2857 Metetra
.522 .49 .762 r
.53467 .2857 .54876 .32486 .57555 .34713 .56106 .28777 Metetra
.447 .379 .687 r
.56106 .28777 .57555 .34713 .60333 .37779 .58813 .30101 Metetra
.414 .327 .648 r
.58813 .30101 .60333 .37779 .63216 .41144 .61611 .32321 Metetra
.402 .306 .632 r
.61611 .32321 .63216 .41144 .66187 .44178 .64513 .35107 Metetra
.4 .304 .631 r
.64513 .35107 .66187 .44178 .69209 .46252 .67517 .3804 Metetra
.405 .32 .646 r
.67517 .3804 .69209 .46252 .72226 .46856 .70603 .40649 Metetra
.42 .366 .692 r
.70603 .40649 .72226 .46856 .75182 .45716 .73734 .42472 Metetra
.452 .507 .825 r
.73734 .42472 .75182 .45716 .78031 .42859 .76862 .43125 Metetra
.177 .705 .697 r
.76862 .43125 .78031 .42859 .80752 .38611 .79934 .42372 Metetra
.244 0 .171 r
.79934 .42372 .80752 .38611 .83359 .33516 .82907 .40173 Metetra
.682 .169 0 r
.16417 .49455 .1809 .50916 .20111 .53835 .1847 .51973 Metetra
0 0 .52 r
.1847 .51973 .20111 .53835 .22237 .5639 .20614 .54242 Metetra
0 .257 .766 r
.20614 .54242 .22237 .5639 .24499 .58145 .22874 .55949 Metetra
.266 .49 .887 r
.22874 .55949 .24499 .58145 .26907 .58748 .25261 .5682 Metetra
.531 .66 .919 r
.25261 .5682 .26907 .58748 .29451 .57994 .27772 .56665 Metetra
.715 .798 .917 r
.27772 .56665 .29451 .57994 .32103 .55868 .30389 .55401 Metetra
.84 .916 .886 r
.30389 .55401 .32103 .55868 .34822 .52546 .33086 .53072 Metetra
.889 .986 .802 r
.33086 .53072 .34822 .52546 .37567 .48365 .35831 .49838 Metetra
.836 .971 .658 r
.35831 .49838 .37567 .48365 .40301 .43759 .38592 .45952 Metetra
.718 .889 .5 r
.38592 .45952 .40301 .43759 .43 .39189 .41343 .41724 Metetra
.609 .808 .394 r
.41343 .41724 .43 .39189 .45654 .35085 .44065 .37484 Metetra
.44065 .37484 .45654 .35085 .4827 .318 .46752 .3354 Metetra
.62 .859 .497 r
.46752 .3354 .4827 .318 .50865 .29583 .49409 .30161 Metetra
.776 .993 .776 r
.49409 .30161 .50865 .29583 .53467 .2857 .52049 .27554 Metetra
.774 .867 .917 r
.52049 .27554 .53467 .2857 .56106 .28777 .54692 .25854 Metetra
.622 .605 .813 r
.54692 .25854 .56106 .28777 .58813 .30101 .57363 .25127 Metetra
.524 .454 .719 r
.57363 .25127 .58813 .30101 .61611 .32321 .60088 .25359 Metetra
.475 .379 .666 r
.60088 .25359 .61611 .32321 .64513 .35107 .6289 .26465 Metetra
.451 .341 .638 r
.6289 .26465 .64513 .35107 .67517 .3804 .65787 .28284 Metetra
.439 .323 .625 r
.65787 .28284 .67517 .3804 .70603 .40649 .6879 .30587 Metetra
.434 .319 .623 r
.6879 .30587 .70603 .40649 .73734 .42472 .71896 .33088 Metetra
.434 .327 .634 r
.71896 .33088 .73734 .42472 .76862 .43125 .7509 .35458 Metetra
.439 .353 .662 r
.7509 .35458 .76862 .43125 .79934 .42372 .78344 .37361 Metetra
.449 .422 .737 r
.78344 .37361 .79934 .42372 .82907 .40173 .81616 .38486 Metetra
.565 .042 0 r
.14715 .4797 .16417 .49455 .1847 .51973 .16804 .50078 Metetra
0 .111 .633 r
.16804 .50078 .1847 .51973 .20614 .54242 .18973 .52027 Metetra
0 .298 .795 r
.18973 .52027 .20614 .54242 .22874 .55949 .21239 .536 Metetra
.236 .458 .871 r
.21239 .536 .22874 .55949 .25261 .5682 .23612 .54602 Metetra
.442 .587 .902 r
.23612 .54602 .25261 .5682 .27772 .56665 .26094 .54875 Metetra
.601 .711 .921 r
.26094 .54875 .27772 .56665 .30389 .55401 .28676 .54319 Metetra
.734 .841 .931 r
.28676 .54319 .30389 .55401 .33086 .53072 .31341 .52905 Metetra
.823 .96 .9 r
.31341 .52905 .33086 .53072 .35831 .49838 .34069 .50675 Metetra
.811 .997 .774 r
.34069 .50675 .35831 .49838 .38592 .45952 .36835 .47743 Metetra
.678 .904 .562 r
.36835 .47743 .38592 .45952 .41343 .41724 .39614 .44277 Metetra
.39614 .44277 .41343 .41724 .44065 .37484 .42389 .40482 Metetra
.42389 .40482 .44065 .37484 .46752 .3354 .45145 .3658 Metetra
.45145 .3658 .46752 .3354 .49409 .30161 .47876 .32788 Metetra
.47876 .32788 .49409 .30161 .52049 .27554 .50582 .29305 Metetra
.50582 .29305 .52049 .27554 .54692 .25854 .53272 .263 Metetra
.743 .99 .796 r
.53272 .263 .54692 .25854 .57363 .25127 .5596 .23904 Metetra
.767 .846 .911 r
.5596 .23904 .57363 .25127 .60088 .25359 .58663 .22206 Metetra
.638 .603 .798 r
.58663 .22206 .60088 .25359 .6289 .26465 .61402 .21253 Metetra
.556 .47 .712 r
.61402 .21253 .6289 .26465 .65787 .28284 .64197 .21046 Metetra
.512 .4 .663 r
.64197 .21046 .65787 .28284 .6879 .30587 .6707 .21544 Metetra
.487 .362 .635 r
.6707 .21544 .6879 .30587 .71896 .33088 .70034 .2266 Metetra
.474 .342 .621 r
.70034 .2266 .71896 .33088 .7509 .35458 .73103 .24266 Metetra
.466 .332 .615 r
.73103 .24266 .7509 .35458 .78344 .37361 .76279 .26194 Metetra
.462 .331 .617 r
.76279 .26194 .78344 .37361 .81616 .38486 .79556 .28245 Metetra
0 .118 .596 r
.12983 .46459 .14715 .4797 .16804 .50078 .15114 .4815 Metetra
0 .24 .745 r
.15114 .4815 .16804 .50078 .18973 .52027 .17313 .49747 Metetra
.059 .358 .83 r
.17313 .49747 .18973 .52027 .21239 .536 .19593 .5111 Metetra
.25 .452 .863 r
.19593 .5111 .21239 .536 .23612 .54602 .21963 .5211 Metetra
.394 .535 .879 r
.21963 .5211 .23612 .54602 .26094 .54875 .24424 .52631 Metetra
.511 .623 .899 r
.24424 .52631 .26094 .54875 .28676 .54319 .26974 .52585 Metetra
.616 .729 .927 r
.26974 .52585 .28676 .54319 .31341 .52905 .29605 .51916 Metetra
.713 .858 .951 r
.29605 .51916 .31341 .52905 .34069 .50675 .32304 .50607 Metetra
.765 .975 .92 r
.32304 .50607 .34069 .50675 .36835 .47743 .35055 .48683 Metetra
.685 .965 .742 r
.35055 .48683 .36835 .47743 .39614 .44277 .37841 .46207 Metetra
.37841 .46207 .39614 .44277 .42389 .40482 .40645 .43273 Metetra
.40645 .43273 .42389 .40482 .45145 .3658 .43452 .40003 Metetra
.43452 .40003 .45145 .3658 .47876 .32788 .4625 .36531 Metetra
.4625 .36531 .47876 .32788 .50582 .29305 .49034 .33 Metetra
.49034 .33 .50582 .29305 .53272 .263 .518 .29548 Metetra
.518 .29548 .53272 .263 .5596 .23904 .54551 .26302 Metetra
.54551 .26302 .5596 .23904 .58663 .22206 .57294 .23374 Metetra
.51 .841 .553 r
.57294 .23374 .58663 .22206 .61402 .21253 .60039 .20857 Metetra
.788 .971 .915 r
.60039 .20857 .61402 .21253 .64197 .21046 .62801 .1882 Metetra
.714 .719 .853 r
.62801 .1882 .64197 .21046 .6707 .21544 .65596 .1731 Metetra
.618 .543 .747 r
.65596 .1731 .6707 .21544 .70034 .2266 .68439 .16352 Metetra
.563 .45 .684 r
.68439 .16352 .70034 .2266 .73103 .24266 .71348 .15943 Metetra
.531 .399 .646 r
.71348 .15943 .73103 .24266 .76279 .26194 .74338 .16061 Metetra
.511 .37 .624 r
.74338 .16061 .76279 .26194 .79556 .28245 .77422 .16657 Metetra
0 .297 .761 r
.11221 .44921 .12983 .46459 .15114 .4815 .13399 .46189 Metetra
.009 .371 .838 r
.13399 .46189 .15114 .4815 .17313 .49747 .15634 .47407 Metetra
.174 .426 .861 r
.15634 .47407 .17313 .49747 .19593 .5111 .17937 .48492 Metetra
.297 .469 .861 r
.17937 .48492 .19593 .5111 .21963 .5211 .20313 .49367 Metetra
.389 .51 .86 r
.20313 .49367 .21963 .5211 .24424 .52631 .22765 .49958 Metetra
.464 .559 .867 r
.22765 .49958 .24424 .52631 .26974 .52585 .25293 .502 Metetra
.532 .623 .888 r
.25293 .502 .26974 .52585 .29605 .51916 .27894 .50043 Metetra
.6 .712 .923 r
.27894 .50043 .29605 .51916 .32304 .50607 .30561 .49451 Metetra
.665 .831 .963 r
.30561 .49451 .32304 .50607 .35055 .48683 .33286 .48409 Metetra
.691 .951 .955 r
.33286 .48409 .35055 .48683 .37841 .46207 .36059 .4692 Metetra
.578 .933 .77 r
.36059 .4692 .37841 .46207 .40645 .43273 .38867 .45008 Metetra
.38867 .45008 .40645 .43273 .43452 .40003 .41699 .42713 Metetra
.41699 .42713 .43452 .40003 .4625 .36531 .44545 .40094 Metetra
.44545 .40094 .4625 .36531 .49034 .33 .47395 .37219 Metetra
.056 0 .066 r
.47395 .37219 .49034 .33 .518 .29548 .50241 .34167 Metetra
.097 0 .114 r
.50241 .34167 .518 .29548 .54551 .26302 .53079 .31019 Metetra
.114 0 .132 r
.53079 .31019 .54551 .26302 .57294 .23374 .55907 .27858 Metetra
.108 0 .122 r
.55907 .27858 .57294 .23374 .60039 .20857 .58726 .24764 Metetra
.073 0 .077 r
.58726 .24764 .60039 .20857 .62801 .1882 .61539 .21811 Metetra
.61539 .21811 .62801 .1882 .65596 .1731 .64354 .19065 Metetra
.64354 .19065 .65596 .1731 .68439 .16352 .67179 .16584 Metetra
.673 .973 .806 r
.67179 .16584 .68439 .16352 .71348 .15943 .70023 .14413 Metetra
.765 .832 .903 r
.70023 .14413 .71348 .15943 .74338 .16061 .72901 .12587 Metetra
.67 .614 .783 r
.72901 .12587 .74338 .16061 .77422 .16657 .75823 .11132 Metetra
.06 .466 .885 r
.09428 .43356 .11221 .44921 .13399 .46189 .11657 .44195 Metetra
.194 .486 .899 r
.11657 .44195 .13399 .46189 .15634 .47407 .13937 .4501 Metetra
.294 .493 .882 r
.13937 .4501 .15634 .47407 .17937 .48492 .16271 .4576 Metetra
.366 .499 .86 r
.16271 .4576 .17937 .48492 .20313 .49367 .18665 .46403 Metetra
.419 .509 .844 r
.18665 .46403 .20313 .49367 .22765 .49958 .21121 .46898 Metetra
.461 .526 .838 r
.21121 .46898 .22765 .49958 .25293 .502 .2364 .47208 Metetra
.499 .553 .843 r
.2364 .47208 .25293 .502 .27894 .50043 .2622 .47298 Metetra
.535 .595 .86 r
.2622 .47298 .27894 .50043 .30561 .49451 .28861 .47139 Metetra
.573 .656 .893 r
.28861 .47139 .30561 .49451 .33286 .48409 .31559 .46709 Metetra
.612 .746 .941 r
.31559 .46709 .33286 .48409 .36059 .4692 .34307 .45992 Metetra
.637 .864 .984 r
.34307 .45992 .36059 .4692 .38867 .45008 .37102 .44979 Metetra
.577 .936 .925 r
.37102 .44979 .38867 .45008 .41699 .42713 .39936 .43672 Metetra
.352 .792 .627 r
.39936 .43672 .41699 .42713 .44545 .40094 .42801 .42079 Metetra
.42801 .42079 .44545 .40094 .47395 .37219 .4569 .40216 Metetra
.051 0 0 r
.4569 .40216 .47395 .37219 .50241 .34167 .48597 .38108 Metetra
.141 0 .074 r
.48597 .38108 .50241 .34167 .53079 .31019 .51515 .35785 Metetra
.196 0 .151 r
.51515 .35785 .53079 .31019 .55907 .27858 .54438 .33281 Metetra
.229 0 .198 r
.54438 .33281 .55907 .27858 .58726 .24764 .57362 .30637 Metetra
.249 0 .226 r
.57362 .30637 .58726 .24764 .61539 .21811 .60284 .27893 Metetra
.259 0 .24 r
.60284 .27893 .61539 .21811 .64354 .19065 .63203 .25094 Metetra
.259 0 .242 r
.63203 .25094 .64354 .19065 .67179 .16584 .66119 .22281 Metetra
.25 0 .23 r
.66119 .22281 .67179 .16584 .70023 .14413 .69034 .19496 Metetra
.227 0 .202 r
.69034 .19496 .70023 .14413 .72901 .12587 .71952 .1678 Metetra
.18 0 .144 r
.71952 .1678 .72901 .12587 .75823 .11132 .74876 .14167 Metetra
.278 .596 .949 r
.07603 .41763 .09428 .43356 .11657 .44195 .0989 .42167 Metetra
.355 .575 .924 r
.0989 .42167 .11657 .44195 .13937 .4501 .12219 .42562 Metetra
.407 .552 .888 r
.12219 .42562 .13937 .4501 .16271 .4576 .14594 .42929 Metetra
.443 .534 .855 r
.14594 .42929 .16271 .4576 .18665 .46403 .17018 .43251 Metetra
.468 .522 .83 r
.17018 .43251 .18665 .46403 .21121 .46898 .19491 .43509 Metetra
.489 .518 .814 r
.19491 .43509 .21121 .46898 .2364 .47208 .22015 .43686 Metetra
.506 .521 .806 r
.22015 .43686 .2364 .47208 .2622 .47298 .24591 .43765 Metetra
.522 .531 .805 r
.24591 .43765 .2622 .47298 .28861 .47139 .27218 .43731 Metetra
.539 .549 .814 r
.27218 .43731 .28861 .47139 .31559 .46709 .29895 .43569 Metetra
.556 .579 .832 r
.29895 .43569 .31559 .46709 .34307 .45992 .32622 .43266 Metetra
.575 .624 .863 r
.32622 .43266 .34307 .45992 .37102 .44979 .35397 .4281 Metetra
.595 .691 .909 r
.35397 .4281 .37102 .44979 .39936 .43672 .38216 .42193 Metetra
.609 .785 .966 r
.38216 .42193 .39936 .43672 .42801 .42079 .41077 .41407 Metetra
.577 .887 .99 r
.41077 .41407 .42801 .42079 .4569 .40216 .43976 .4045 Metetra
.405 .858 .827 r
.43976 .4045 .4569 .40216 .48597 .38108 .46909 .39318 Metetra
.46909 .39318 .48597 .38108 .51515 .35785 .49873 .38014 Metetra
.072 0 0 r
.49873 .38014 .51515 .35785 .54438 .33281 .52864 .3654 Metetra
.186 0 .029 r
.52864 .3654 .54438 .33281 .57362 .30637 .55877 .34905 Metetra
.251 0 .136 r
.55877 .34905 .57362 .30637 .60284 .27893 .58908 .33116 Metetra
.291 0 .203 r
.58908 .33116 .60284 .27893 .63203 .25094 .61954 .31184 Metetra
.317 0 .247 r
.61954 .31184 .63203 .25094 .66119 .22281 .65011 .29123 Metetra
.335 .021 .276 r
.65011 .29123 .66119 .22281 .69034 .19496 .68077 .26947 Metetra
.347 .041 .297 r
.68077 .26947 .69034 .19496 .71952 .1678 .7115 .24672 Metetra
.354 .054 .31 r
.7115 .24672 .71952 .1678 .74876 .14167 .74228 .22317 Metetra
.448 .679 .963 r
.05745 .40141 .07603 .41763 .0989 .42167 .08095 .40107 Metetra
.483 .637 .922 r
.08095 .40107 .0989 .42167 .12219 .42562 .10481 .40067 Metetra
.504 .599 .881 r
.10481 .40067 .12219 .42562 .14594 .42929 .12905 .40016 Metetra
.517 .568 .846 r
.12905 .40016 .14594 .42929 .17018 .43251 .15369 .39949 Metetra
.525 .544 .817 r
.15369 .39949 .17018 .43251 .19491 .43509 .17873 .3986 Metetra
.531 .526 .795 r
.17873 .3986 .19491 .43509 .22015 .43686 .20418 .39744 Metetra
.536 .514 .778 r
.20418 .39744 .22015 .43686 .24591 .43765 .23005 .39595 Metetra
.541 .507 .767 r
.23005 .39595 .24591 .43765 .27218 .43731 .25634 .39408 Metetra
.545 .503 .76 r
.25634 .39408 .27218 .43731 .29895 .43569 .28307 .39177 Metetra
.55 .505 .758 r
.28307 .39177 .29895 .43569 .32622 .43266 .31022 .38898 Metetra
.555 .51 .76 r
.31022 .38898 .32622 .43266 .35397 .4281 .33781 .38566 Metetra
.561 .521 .768 r
.33781 .38566 .35397 .4281 .38216 .42193 .36584 .38174 Metetra
.568 .537 .781 r
.36584 .38174 .38216 .42193 .41077 .41407 .39429 .3772 Metetra
.576 .562 .801 r
.39429 .3772 .41077 .41407 .43976 .4045 .42316 .37198 Metetra
.586 .597 .83 r
.42316 .37198 .43976 .4045 .46909 .39318 .45245 .36605 Metetra
.597 .647 .871 r
.45245 .36605 .46909 .39318 .49873 .38014 .48214 .35937 Metetra
.604 .719 .926 r
.48214 .35937 .49873 .38014 .52864 .3654 .51223 .35192 Metetra
.592 .813 .984 r
.51223 .35192 .52864 .3654 .55877 .34905 .54271 .34365 Metetra
.503 .88 .973 r
.54271 .34365 .55877 .34905 .58908 .33116 .57355 .33456 Metetra
.267 .768 .735 r
.57355 .33456 .58908 .33116 .61954 .31184 .60476 .32462 Metetra
.60476 .32462 .61954 .31184 .65011 .29123 .63629 .31382 Metetra
.164 0 0 r
.63629 .31382 .65011 .29123 .68077 .26947 .66816 .30216 Metetra
.256 0 .055 r
.66816 .30216 .68077 .26947 .7115 .24672 .70032 .28963 Metetra
.31 0 .153 r
.70032 .28963 .7115 .24672 .74228 .22317 .73278 .27625 Metetra
.57 .727 .948 r
.03853 .3849 .05745 .40141 .08095 .40107 .06272 .38012 Metetra
.58 .676 .906 r
.06272 .38012 .08095 .40107 .10481 .40067 .08722 .37528 Metetra
.583 .633 .867 r
.08722 .37528 .10481 .40067 .12905 .40016 .11203 .37037 Metetra
.582 .596 .832 r
.11203 .37037 .12905 .40016 .15369 .39949 .13716 .36537 Metetra
.58 .566 .803 r
.13716 .36537 .15369 .39949 .17873 .3986 .16262 .36028 Metetra
.577 .542 .779 r
.16262 .36028 .17873 .3986 .20418 .39744 .18841 .3551 Metetra
.574 .522 .759 r
.18841 .3551 .20418 .39744 .23005 .39595 .21454 .3498 Metetra
.572 .506 .742 r
.21454 .3498 .23005 .39595 .25634 .39408 .24102 .34439 Metetra
.57 .493 .729 r
.24102 .34439 .25634 .39408 .28307 .39177 .26785 .33886 Metetra
.568 .482 .718 r
.26785 .33886 .28307 .39177 .31022 .38898 .29504 .3332 Metetra
.567 .474 .709 r
.29504 .3332 .31022 .38898 .33781 .38566 .3226 .32739 Metetra
.566 .468 .702 r
.3226 .32739 .33781 .38566 .36584 .38174 .35052 .32144 Metetra
.565 .463 .697 r
.35052 .32144 .36584 .38174 .39429 .3772 .37882 .31533 Metetra
.565 .46 .693 r
.37882 .31533 .39429 .3772 .42316 .37198 .4075 .30905 Metetra
.565 .459 .692 r
.4075 .30905 .42316 .37198 .45245 .36605 .43657 .3026 Metetra
.566 .459 .691 r
.43657 .3026 .45245 .36605 .48214 .35937 .46603 .29596 Metetra
.567 .46 .692 r
.46603 .29596 .48214 .35937 .51223 .35192 .49589 .28913 Metetra
.568 .464 .695 r
.49589 .28913 .51223 .35192 .54271 .34365 .52616 .2821 Metetra
.57 .469 .7 r
.52616 .2821 .54271 .34365 .57355 .33456 .55683 .27486 Metetra
.573 .476 .707 r
.55683 .27486 .57355 .33456 .60476 .32462 .58791 .2674 Metetra
.576 .486 .716 r
.58791 .2674 .60476 .32462 .63629 .31382 .61941 .25971 Metetra
.58 .499 .728 r
.61941 .25971 .63629 .31382 .66816 .30216 .65133 .25178 Metetra
.585 .516 .744 r
.65133 .25178 .66816 .30216 .70032 .28963 .68367 .24361 Metetra
.591 .538 .764 r
.68367 .24361 .70032 .28963 .73278 .27625 .71645 .23519 Metetra
.656 .751 .92 r
.01926 .36808 .03853 .3849 .06272 .38012 .0442 .35884 Metetra
.651 .701 .883 r
.0442 .35884 .06272 .38012 .08722 .37528 .0694 .34951 Metetra
.644 .657 .848 r
.0694 .34951 .08722 .37528 .11203 .37037 .09484 .34009 Metetra
.636 .62 .817 r
.09484 .34009 .11203 .37037 .13716 .36537 .12055 .33057 Metetra
.628 .588 .79 r
.12055 .33057 .13716 .36537 .16262 .36028 .14652 .32095 Metetra
.62 .561 .766 r
.14652 .32095 .16262 .36028 .18841 .3551 .17275 .31124 Metetra
.613 .538 .746 r
.17275 .31124 .18841 .3551 .21454 .3498 .19925 .30142 Metetra
.606 .518 .728 r
.19925 .30142 .21454 .3498 .24102 .34439 .22603 .2915 Metetra
.6 .501 .713 r
.22603 .2915 .24102 .34439 .26785 .33886 .25309 .28148 Metetra
.595 .486 .699 r
.25309 .28148 .26785 .33886 .29504 .3332 .28042 .27136 Metetra
.59 .472 .687 r
.28042 .27136 .29504 .3332 .3226 .32739 .30805 .26113 Metetra
.586 .461 .676 r
.30805 .26113 .3226 .32739 .35052 .32144 .33597 .25079 Metetra
.582 .45 .667 r
.33597 .25079 .35052 .32144 .37882 .31533 .36418 .24034 Metetra
.578 .441 .658 r
.36418 .24034 .37882 .31533 .4075 .30905 .3927 .22978 Metetra
.575 .433 .651 r
.3927 .22978 .4075 .30905 .43657 .3026 .42152 .2191 Metetra
.572 .426 .644 r
.42152 .2191 .43657 .3026 .46603 .29596 .45066 .20831 Metetra
.569 .419 .638 r
.45066 .20831 .46603 .29596 .49589 .28913 .48011 .1974 Metetra
.567 .413 .632 r
.48011 .1974 .49589 .28913 .52616 .2821 .50988 .18638 Metetra
.565 .408 .627 r
.50988 .18638 .52616 .2821 .55683 .27486 .53998 .17523 Metetra
.563 .403 .622 r
.53998 .17523 .55683 .27486 .58791 .2674 .57041 .16396 Metetra
.561 .399 .618 r
.57041 .16396 .58791 .2674 .61941 .25971 .60118 .15257 Metetra
.559 .394 .614 r
.60118 .15257 .61941 .25971 .65133 .25178 .63229 .14104 Metetra
.558 .391 .611 r
.63229 .14104 .65133 .25178 .68367 .24361 .66375 .12939 Metetra
.556 .388 .608 r
.66375 .12939 .68367 .24361 .71645 .23519 .69556 .11761 Metetra
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.16258 .20603 m
.16718 .21071 L
s
[(1)] .15339 .19666 .98224 1 Mshowa
.29445 .15439 m
.29882 .15928 L
s
[(2)] .2857 .14461 .89375 1 Mshowa
.43326 .10004 m
.43737 .10515 L
s
[(3)] .42503 .08982 .80527 1 Mshowa
.57958 .04274 m
.5834 .04808 L
s
[(4)] .57193 .03208 .71678 1 Mshowa
.125 Mabswid
.06175 .24551 m
.06461 .24822 L
s
.08659 .23578 m
.08942 .23852 L
s
.11167 .22596 m
.11448 .22872 L
s
.137 .21604 m
.13978 .21883 L
s
.18843 .19591 m
.19116 .19874 L
s
.21453 .18569 m
.21724 .18854 L
s
.2409 .17536 m
.24358 .17824 L
s
.26753 .16493 m
.27019 .16784 L
s
.32163 .14375 m
.32423 .14671 L
s
.34911 .13299 m
.35167 .13598 L
s
.37686 .12212 m
.3794 .12513 L
s
.40491 .11114 m
.40741 .11418 L
s
.4619 .08882 m
.46434 .09192 L
s
.49085 .07749 m
.49325 .08061 L
s
.52011 .06603 m
.52247 .06918 L
s
.54968 .05445 m
.55201 .05762 L
s
.60979 .03091 m
.61205 .03414 L
s
.64034 .01895 m
.64256 .0222 L
s
.67123 .00685 m
.67341 .01013 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"Boxed"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BoxRatios", "ObjectName",
  CellTags->{"S0.1095", "BoxRatios"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxRatios", "MR"],
  " is an option for ",
  ButtonBox["Graphics3D",
    ButtonStyle->"RefGuideLink"],
  " which gives the ratios of side lengths for the bounding box of the three\
\[Hyphen]dimensional picture. "
}], "Usage",
  CellTags->{"S0.1095", "BoxRatios"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxRatios", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], 
          StyleBox["x",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], 
          StyleBox["y",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            "TI"], 
          StyleBox["z",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " gives the side\[Hyphen]length ratios. "
}], "Notes",
  CellTags->{"S0.1095", "BoxRatios"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.10.10",
    ButtonData:>{"2.10.10", "10.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1095", "BoxRatios"}],

Cell["\[FilledSmallSquare] New in Version 1.", "Notes",
  CellTags->{"S0.1095", "BoxRatios"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->"BoxRatios"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, \(3\ \[Pi]\)\/2}, {y, 0, \(3\ \[Pi]\)\/2}, 
      BoxRatios \[Rule] {1, 2, 3}]; \)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"BoxRatios"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.85794 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.402411 1.86064 1.12052e-16 1.86064 [
[.54613 1.8812 -2.99302 0 ]
[.54613 1.8812 3.00698 9 ]
[.63985 1.85883 -2.957 0 ]
[.63985 1.85883 3.043 9 ]
[.73509 1.83609 -2.92018 0 ]
[.73509 1.83609 3.07982 9 ]
[.8319 1.81298 -2.88253 0 ]
[.8319 1.81298 3.11747 9 ]
[.93031 1.78947 -2.84403 0 ]
[.93031 1.78947 3.15597 9 ]
[-0.02233 1.4158 -6 -3.18597 ]
[-0.02233 1.4158 0 5.81403 ]
[.10779 1.5225 -6 -3.24453 ]
[.10779 1.5225 0 5.75547 ]
[.22953 1.62233 -6 -3.29809 ]
[.22953 1.62233 0 5.70191 ]
[.34368 1.71593 -6 -3.34727 ]
[.34368 1.71593 0 5.65273 ]
[.45093 1.80388 -6 -3.39258 ]
[.45093 1.80388 0 5.60742 ]
[.06561 .20214 -12 -2.70336 ]
[.06561 .20214 0 6.29664 ]
[.04694 .45966 -24 -2.80512 ]
[.04694 .45966 0 6.19488 ]
[.02664 .73973 -6 -2.91618 ]
[.02664 .73973 0 6.08382 ]
[.00449 1.04547 -18 -3.03789 ]
[.00449 1.04547 0 5.96211 ]
[-0.01977 1.38055 -6 -3.17185 ]
[-0.01977 1.38055 0 5.82815 ]
[ 0 0 0 0 ]
[ 1 1.85794 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.54608 1.85794 m
1 1.74928 L
s
.54608 1.85794 m
.54605 1.84631 L
s
[(0)] .54613 1.8812 -0.00233 -1 Mshowa
.63951 1.83557 m
.63935 1.82394 L
s
[(1)] .63985 1.85883 -0.01433 -1 Mshowa
.73447 1.81284 m
.73416 1.80122 L
s
[(2)] .73509 1.83609 -0.02661 -1 Mshowa
.83099 1.78974 m
.83053 1.77812 L
s
[(3)] .8319 1.81298 -0.03916 -1 Mshowa
.92911 1.76625 m
.9285 1.75463 L
s
[(4)] .93031 1.78947 -0.05199 -1 Mshowa
.125 Mabswid
.56465 1.8535 m
.56461 1.84652 L
s
.58327 1.84904 m
.58322 1.84206 L
s
.60196 1.84456 m
.60189 1.83759 L
s
.62071 1.84008 m
.62062 1.8331 L
s
.65838 1.83106 m
.65827 1.82408 L
s
.67731 1.82652 m
.67718 1.81955 L
s
.6963 1.82198 m
.69615 1.815 L
s
.71536 1.81742 m
.71519 1.81044 L
s
.75365 1.80825 m
.75345 1.80128 L
s
.77289 1.80364 m
.77267 1.79667 L
s
.79219 1.79902 m
.79195 1.79205 L
s
.81156 1.79439 m
.8113 1.78741 L
s
.85048 1.78507 m
.85019 1.7781 L
s
.87004 1.78039 m
.86973 1.77342 L
s
.88966 1.77569 m
.88934 1.76872 L
s
.90935 1.77098 m
.90901 1.76401 L
s
.94892 1.7615 m
.94854 1.75454 L
s
.96881 1.75674 m
.96841 1.74978 L
s
.98876 1.75197 m
.98834 1.745 L
s
.25 Mabswid
0 1.40928 m
.54608 1.85794 L
s
0 1.40928 m
.01116 1.40602 L
s
[(0)] -0.02233 1.4158 1 -0.29201 Mshowa
.13019 1.51625 m
.14139 1.51312 L
s
[(1)] .10779 1.5225 1 -0.27899 Mshowa
.252 1.61633 m
.26324 1.61332 L
s
[(2)] .22953 1.62233 1 -0.26709 Mshowa
.36621 1.71016 m
.37748 1.70728 L
s
[(3)] .34368 1.71593 1 -0.25616 Mshowa
.47352 1.79832 m
.48481 1.79554 L
s
[(4)] .45093 1.80388 1 -0.24609 Mshowa
.125 Mabswid
.02675 1.43126 m
.03345 1.42932 L
s
.05314 1.45294 m
.05985 1.45101 L
s
.07917 1.47432 m
.08588 1.47242 L
s
.10485 1.49543 m
.11157 1.49353 L
s
.1552 1.53679 m
.16192 1.53493 L
s
.17988 1.55707 m
.18661 1.55522 L
s
.20423 1.57708 m
.21097 1.57525 L
s
.22827 1.59683 m
.23501 1.59501 L
s
.27543 1.63557 m
.28218 1.63379 L
s
.29856 1.65458 m
.30531 1.6528 L
s
.3214 1.67334 m
.32815 1.67158 L
s
.34395 1.69187 m
.3507 1.69012 L
s
.38821 1.72823 m
.39497 1.72651 L
s
.40993 1.74608 m
.41669 1.74437 L
s
.43138 1.7637 m
.43815 1.76201 L
s
.45258 1.78112 m
.45935 1.77944 L
s
.4942 1.81532 m
.50098 1.81366 L
s
.51464 1.83211 m
.52142 1.83047 L
s
.53484 1.8487 m
.54162 1.84707 L
s
.25 Mabswid
.08897 .16888 m
0 1.40928 L
s
.08721 .19352 m
.09801 .18921 L
s
[(-1)] .06561 .20214 1 -0.39925 Mshowa
.0687 .45146 m
.07959 .44736 L
s
[(-0.5)] .04694 .45966 1 -0.37664 Mshowa
.04858 .73201 m
.05955 .72815 L
s
[(0)] .02664 .73973 1 -0.35196 Mshowa
.02661 1.03828 m
.03767 1.03469 L
s
[(0.5)] .00449 1.04547 1 -0.32491 Mshowa
.00253 1.37397 m
.01369 1.37068 L
s
[(1)] -0.01977 1.38055 1 -0.29515 Mshowa
.125 Mabswid
.08363 .24343 m
.09012 .24087 L
s
.07999 .29416 m
.08649 .29162 L
s
.07629 .34573 m
.0828 .34322 L
s
.07253 .39815 m
.07905 .39567 L
s
.06482 .50567 m
.07136 .50324 L
s
.06086 .56081 m
.06741 .5584 L
s
.05684 .61689 m
.0634 .61452 L
s
.05274 .67395 m
.05932 .67161 L
s
.04434 .7911 m
.05093 .78881 L
s
.04003 .85124 m
.04663 .84899 L
s
.03564 .91247 m
.04225 .91024 L
s
.03116 .9748 m
.03779 .97261 L
s
.02197 1.10293 m
.02862 1.10081 L
s
.01725 1.1688 m
.02391 1.16671 L
s
.01244 1.2359 m
.01911 1.23385 L
s
.00753 1.30428 m
.01421 1.30226 L
s
.25 Mabswid
.08897 .16888 m
0 1.40928 L
s
0 1.40928 m
.54608 1.85794 L
s
.54608 1.85794 m
.54338 .69828 L
s
.54338 .69828 m
.08897 .16888 L
s
.50969 0 m
.92756 .56774 L
s
.92756 .56774 m
1 1.74928 L
s
1 1.74928 m
.50582 1.26157 L
s
.50582 1.26157 m
.50969 0 L
s
.08897 .16888 m
0 1.40928 L
s
0 1.40928 m
.50582 1.26157 L
s
.50582 1.26157 m
.50969 0 L
s
.50969 0 m
.08897 .16888 L
s
.54338 .69828 m
.92756 .56774 L
s
.92756 .56774 m
1 1.74928 L
s
1 1.74928 m
.54608 1.85794 L
s
.54608 1.85794 m
.54338 .69828 L
s
0 0 m
1 0 L
1 1.85794 L
0 1.85794 L
closepath
clip
newpath
.5 Mabswid
.958 .675 .456 r
.52651 1.21337 .54462 1.23161 .56356 1.69386 .54431 1.66221 Metetra
.964 .641 .341 r
.54431 1.66221 .56356 1.69386 .58219 1.7919 .56285 1.78726 Metetra
.962 .71 .509 r
.56285 1.78726 .58219 1.7919 .59695 1.41905 .57896 1.46323 Metetra
.974 .716 .48 r
.57896 1.46323 .59695 1.41905 .60867 .93116 .59215 .9822 Metetra
.986 .738 .471 r
.59215 .9822 .60867 .93116 .62172 .69718 .60537 .6941 Metetra
.926 .566 .322 r
.60537 .6941 .62172 .69718 .64015 .85168 .6222 .75671 Metetra
.982 .694 .381 r
.6222 .75671 .64015 .85168 .66502 1.30466 .64463 1.13641 Metetra
.983 .703 .337 r
.64463 1.13641 .66502 1.30466 .69146 1.72561 .67053 1.59829 Metetra
.857 .594 .058 r
.67053 1.59829 .69146 1.72561 .70977 1.71486 .69242 1.76364 Metetra
.988 .739 .461 r
.69242 1.76364 .70977 1.71486 .71696 1.27766 .70427 1.46894 Metetra
.99 .743 .371 r
.70427 1.46894 .71696 1.27766 .72143 .81729 .70973 .98289 Metetra
.969 .748 .314 r
.70973 .98289 .72143 .81729 .73315 .66058 .71778 .66758 Metetra
.848 .429 .238 r
.71778 .66758 .73315 .66058 .75723 .89353 .73514 .69887 Metetra
.941 .674 .207 r
.73514 .69887 .75723 .89353 .79155 1.3773 .7638 1.05902 Metetra
.88 .643 .119 r
.7638 1.05902 .79155 1.3773 .82357 1.7367 .79838 1.5309 Metetra
0 0 .148 r
.79838 1.5309 .82357 1.7367 .8378 1.61597 .82507 1.73567 Metetra
.974 .753 .329 r
.82507 1.73567 .8378 1.61597 .83581 1.13391 .83362 1.47296 Metetra
.874 .68 .155 r
.83362 1.47296 .83581 1.13391 .83443 .71632 .83107 .98461 Metetra
.801 .641 .086 r
.83107 .98461 .83443 .71632 .84763 .64112 .83291 .6431 Metetra
.05 0 0 r
.83291 .6431 .84763 .64112 .88 .94734 .84973 .64267 Metetra
0 0 .095 r
.84973 .64267 .88 .94734 .92427 1.44512 .88406 .98142 Metetra
0 0 .139 r
.88406 .98142 .92427 1.44512 .95889 1.72432 .92776 1.46023 Metetra
0 0 .242 r
.92776 1.46023 .95889 1.72432 .96536 1.49832 .96069 1.70319 Metetra
0 0 .02 r
.96069 1.70319 .96536 1.49832 .95357 .99194 .9671 1.47498 Metetra
.958 .675 .455 r
.5082 1.19493 .52651 1.21337 .54431 1.66221 .52492 1.6296 Metetra
.966 .651 .366 r
.52492 1.6296 .54431 1.66221 .56285 1.78726 .5432 1.77877 Metetra
.961 .712 .516 r
.5432 1.77877 .56285 1.78726 .57896 1.46323 .56044 1.50492 Metetra
.974 .717 .481 r
.56044 1.50492 .57896 1.46323 .59215 .9822 .57514 1.03981 Metetra
.985 .734 .469 r
.57514 1.03981 .59215 .9822 .60537 .6941 .58892 .70817 Metetra
.862 .969 .649 r
.58892 .70817 .60537 .6941 .6222 .75671 .60472 .68389 Metetra
.98 .687 .375 r
.60472 .68389 .6222 .75671 .64463 1.13641 .62491 .97613 Metetra
.984 .703 .344 r
.62491 .97613 .64463 1.13641 .67053 1.59829 .64928 1.43193 Metetra
.955 .681 .235 r
.64928 1.43193 .67053 1.59829 .69242 1.76364 .67309 1.73608 Metetra
.943 .721 .572 r
.67309 1.73608 .69242 1.76364 .70427 1.46894 .68961 1.62446 Metetra
.992 .746 .389 r
.68961 1.62446 .70427 1.46894 .70973 .98289 .69801 1.19192 Metetra
.976 .744 .324 r
.69801 1.19192 .70973 .98289 .71778 .66758 .70469 .77215 Metetra
.922 .754 .269 r
.70469 .77215 .71778 .66758 .73514 .69887 .71683 .61202 Metetra
.947 .649 .201 r
.71683 .61202 .73514 .69887 .7638 1.05902 .73864 .78436 Metetra
.895 .651 .138 r
.73864 .78436 .7638 1.05902 .79838 1.5309 .76982 1.2058 Metetra
.808 .595 .036 r
.76982 1.2058 .79838 1.5309 .82507 1.73567 .80285 1.61764 Metetra
0 0 .497 r
.80285 1.61764 .82507 1.73567 .83362 1.47296 .8248 1.68851 Metetra
.909 .712 .211 r
.8248 1.68851 .83362 1.47296 .83107 .98461 .83021 1.34918 Metetra
.813 .643 .09 r
.83021 1.34918 .83107 .98461 .83291 .6431 .82834 .88184 Metetra
.757 .619 .052 r
.82834 .88184 .83291 .6431 .84973 .64267 .83262 .59635 Metetra
0 0 .482 r
.83262 .59635 .84973 .64267 .88406 .98142 .85139 .63424 Metetra
0 0 .167 r
.85139 .63424 .88406 .98142 .92776 1.46023 .88617 .97649 Metetra
0 0 .188 r
.88617 .97649 .92776 1.46023 .96069 1.70319 .92922 1.43658 Metetra
0 0 .247 r
.92922 1.43658 .96069 1.70319 .9671 1.47498 .96239 1.67943 Metetra
.958 .674 .454 r
.48969 1.17629 .5082 1.19493 .52492 1.6296 .50538 1.59606 Metetra
.967 .658 .381 r
.50538 1.59606 .52492 1.6296 .5432 1.77877 .52329 1.76632 Metetra
.959 .715 .527 r
.52329 1.76632 .5432 1.77877 .56044 1.50492 .54139 1.54314 Metetra
.974 .718 .483 r
.54139 1.54314 .56044 1.50492 .57514 1.03981 .55759 1.10258 Metetra
.984 .732 .468 r
.55759 1.10258 .57514 1.03981 .58892 .70817 .57224 .73876 Metetra
.999 .803 .499 r
.57224 .73876 .58892 .70817 .60472 .68389 .58755 .63512 Metetra
.975 .672 .362 r
.58755 .63512 .60472 .68389 .62491 .97613 .6059 .83297 Metetra
.983 .701 .345 r
.6059 .83297 .62491 .97613 .64928 1.43193 .62826 1.24403 Metetra
.97 .696 .279 r
.62826 1.24403 .64928 1.43193 .67309 1.73608 .65236 1.6332 Metetra
0 0 .348 r
.65236 1.6332 .67309 1.73608 .68961 1.62446 .67258 1.71089 Metetra
.995 .752 .426 r
.67258 1.71089 .68961 1.62446 .69801 1.19192 .68513 1.40757 Metetra
.98 .745 .335 r
.68513 1.40757 .69801 1.19192 .70469 .77215 .69276 .95782 Metetra
.95 .74 .279 r
.69276 .95782 .70469 .77215 .71683 .61202 .70179 .64376 Metetra
.70179 .64376 .71683 .61202 .73864 .78436 .71751 .61302 Metetra
.898 .641 .131 r
.71751 .61302 .73864 .78436 .76982 1.2058 .74238 .87636 Metetra
.834 .615 .066 r
.74238 .87636 .76982 1.2058 .80285 1.61764 .7745 1.3113 Metetra
.725 .536 0 r
.7745 1.3113 .80285 1.61764 .8248 1.68851 .80545 1.65138 Metetra
.788 .688 .754 r
.80545 1.65138 .8248 1.68851 .83021 1.34918 .82412 1.63052 Metetra
.83 .663 .118 r
.82412 1.63052 .83021 1.34918 .82834 .88184 .82826 1.26115 Metetra
.747 .602 .032 r
.82826 1.26115 .82834 .88184 .83262 .59635 .82738 .81951 Metetra
.722 .6 .028 r
.82738 .81951 .83262 .59635 .85139 .63424 .83302 .56421 Metetra
0 .001 .551 r
.83302 .56421 .85139 .63424 .88617 .97649 .85218 .60759 Metetra
0 0 .236 r
.85218 .60759 .88617 .97649 .92922 1.43658 .88618 .93026 Metetra
0 0 .234 r
.88618 .93026 .92922 1.43658 .96239 1.67943 .92857 1.37367 Metetra
.959 .674 .452 r
.47098 1.15744 .48969 1.17629 .50538 1.59606 .4857 1.5616 Metetra
.967 .662 .391 r
.4857 1.5616 .50538 1.59606 .52329 1.76632 .50313 1.74983 Metetra
.955 .72 .543 r
.50313 1.74983 .52329 1.76632 .54139 1.54314 .52184 1.57692 Metetra
.974 .719 .486 r
.52184 1.57692 .54139 1.54314 .55759 1.10258 .53942 1.16884 Metetra
.984 .731 .467 r
.53942 1.16884 .55759 1.10258 .57224 .73876 .55518 .78481 Metetra
.996 .769 .471 r
.55518 .78481 .57224 .73876 .58755 .63512 .57052 .61143 Metetra
.96 .628 .322 r
.57052 .61143 .58755 .63512 .6059 .83297 .58754 .71403 Metetra
.982 .697 .342 r
.58754 .71403 .6059 .83297 .62826 1.24403 .60784 1.05259 Metetra
.975 .7 .295 r
.60784 1.05259 .62826 1.24403 .65236 1.6332 .63097 1.46887 Metetra
.905 .644 .14 r
.63097 1.46887 .65236 1.6332 .67258 1.71089 .65331 1.70582 Metetra
.972 .752 .546 r
.65331 1.70582 .67258 1.71089 .68513 1.40757 .67014 1.58401 Metetra
.985 .75 .355 r
.67014 1.58401 .68513 1.40757 .69276 .95782 .68067 1.19192 Metetra
.957 .738 .284 r
.68067 1.19192 .69276 .95782 .70179 .64376 .689 .78704 Metetra
.915 .736 .243 r
.689 .78704 .70179 .64376 .71751 .61302 .70045 .57437 Metetra
.869 .508 .013 r
.70045 .57437 .71751 .61302 .74238 .87636 .71884 .6361 Metetra
.832 .606 .056 r
.71884 .6361 .74238 .87636 .7745 1.3113 .74552 .94794 Metetra
.763 .568 0 r
.74552 .94794 .7745 1.3113 .80545 1.65138 .77764 1.37023 Metetra
0 0 .118 r
.77764 1.37023 .80545 1.65138 .82412 1.63052 .80687 1.65212 Metetra
.991 .865 .518 r
.80687 1.65212 .82412 1.63052 .82826 1.26115 .82392 1.58446 Metetra
.74 .605 .035 r
.82392 1.58446 .82826 1.26115 .82738 .81951 .82805 1.21469 Metetra
0 0 .025 r
.82805 1.21469 .82738 .81951 .83302 .56421 .82804 .79322 Metetra
.82804 .79322 .83302 .56421 .85218 .60759 .83395 .54264 Metetra
.291 .298 .695 r
.83395 .54264 .85218 .60759 .88618 .93026 .85208 .5626 Metetra
0 0 .308 r
.85208 .5626 .88618 .93026 .92857 1.37367 .88412 .84425 Metetra
.959 .673 .451 r
.45207 1.13839 .47098 1.15744 .4857 1.5616 .46589 1.52626 Metetra
.967 .664 .397 r
.46589 1.52626 .4857 1.5616 .50313 1.74983 .48275 1.72923 Metetra
.947 .725 .569 r
.48275 1.72923 .50313 1.74983 .52184 1.57692 .50181 1.60529 Metetra
.974 .721 .49 r
.50181 1.60529 .52184 1.57692 .53942 1.16884 .52059 1.23669 Metetra
.984 .731 .468 r
.52059 1.23669 .53942 1.16884 .55518 .78481 .53762 .84479 Metetra
.993 .756 .461 r
.53762 .84479 .55518 .78481 .57052 .61143 .55342 .61308 Metetra
.649 .106 0 r
.55342 .61308 .57052 .61143 .58754 .71403 .5697 .62446 Metetra
.98 .687 .33 r
.5697 .62446 .58754 .71403 .60784 1.05259 .58822 .87379 Metetra
.976 .7 .298 r
.58822 .87379 .60784 1.05259 .63097 1.46887 .60966 1.26589 Metetra
.944 .68 .216 r
.60966 1.26589 .63097 1.46887 .65331 1.70582 .63242 1.60554 Metetra
0 0 .387 r
.63242 1.60554 .65331 1.70582 .67014 1.58401 .65258 1.67645 Metetra
.994 .765 .406 r
.65258 1.67645 .67014 1.58401 .68067 1.19192 .66709 1.42448 Metetra
.961 .741 .294 r
.66709 1.42448 .68067 1.19192 .689 .78704 .67704 1.01515 Metetra
.923 .725 .235 r
.67704 1.01515 .689 .78704 .70045 .57437 .68658 .6723 Metetra
.882 .745 .236 r
.68658 .6723 .70045 .57437 .71884 .6361 .69998 .53787 Metetra
.788 .528 0 r
.69998 .53787 .71884 .6361 .74552 .94794 .7201 .65561 Metetra
.749 .555 0 r
.7201 .65561 .74552 .94794 .77764 1.37023 .74759 .98454 Metetra
0 0 .072 r
.74759 .98454 .77764 1.37023 .80687 1.65212 .77934 1.38566 Metetra
0 0 .166 r
.77934 1.38566 .80687 1.65212 .82392 1.58446 .80767 1.63501 Metetra
.867 .807 .32 r
.80767 1.63501 .82392 1.58446 .82805 1.21469 .82463 1.56092 Metetra
0 0 .045 r
.82463 1.56092 .82805 1.21469 .82804 .79322 .82967 1.21137 Metetra
0 0 .084 r
.82967 1.21137 .82804 .79322 .83395 .54264 .83034 .8033 Metetra
0 0 .045 r
.83034 .8033 .83395 .54264 .85208 .5626 .8356 .53587 Metetra
.869 .741 .718 r
.8356 .53587 .85208 .5626 .88412 .84425 .85149 .50729 Metetra
.959 .672 .449 r
.43294 1.11913 .45207 1.13839 .46589 1.52626 .44595 1.49005 Metetra
.967 .666 .402 r
.44595 1.49005 .46589 1.52626 .48275 1.72923 .46218 1.70452 Metetra
.929 .733 .616 r
.46218 1.70452 .48275 1.72923 .50181 1.60529 .48133 1.62736 Metetra
.973 .723 .496 r
.48133 1.62736 .50181 1.60529 .52059 1.23669 .50109 1.30405 Metetra
.984 .732 .469 r
.50109 1.30405 .52059 1.23669 .53762 .84479 .51943 .91668 Metetra
.993 .751 .455 r
.51943 .91668 .53762 .84479 .55342 .61308 .53607 .63955 Metetra
.998 .845 .521 r
.53607 .63955 .55342 .61308 .5697 .62446 .55217 .56759 Metetra
.973 .663 .302 r
.55217 .56759 .5697 .62446 .58822 .87379 .56939 .72066 Metetra
.974 .696 .293 r
.56939 .72066 .58822 .87379 .60966 1.26589 .58898 1.05024 Metetra
.953 .689 .237 r
.58898 1.05024 .60966 1.26589 .63242 1.60554 .61085 1.42661 Metetra
.866 .62 .088 r
.61085 1.42661 .63242 1.60554 .65258 1.67645 .63267 1.65612 Metetra
.938 .761 .636 r
.63267 1.65612 .65258 1.67645 .66709 1.42448 .651 1.59475 Metetra
.97 .754 .322 r
.651 1.59475 .66709 1.42448 .67704 1.01515 .66429 1.27796 Metetra
.923 .724 .235 r
.66429 1.27796 .67704 1.01515 .68658 .6723 .67443 .88619 Metetra
.881 .708 .19 r
.67443 .88619 .68658 .6723 .69998 .53787 .68513 .59817 Metetra
.884 .787 .295 r
.68513 .59817 .69998 .53787 .7201 .65561 .69983 .51346 Metetra
0 0 .129 r
.69983 .51346 .7201 .65561 .74759 .98454 .72079 .65553 Metetra
0 0 .101 r
.72079 .65553 .74759 .98454 .77934 1.38566 .74837 .97989 Metetra
0 0 .134 r
.74837 .97989 .77934 1.38566 .80767 1.63501 .77969 1.3611 Metetra
0 0 .195 r
.77969 1.3611 .80767 1.63501 .82463 1.56092 .80804 1.60541 Metetra
.80804 1.60541 .82463 1.56092 .82967 1.21137 .82626 1.56021 Metetra
0 0 .125 r
.82626 1.56021 .82967 1.21137 .83034 .8033 .83314 1.25063 Metetra
0 0 .147 r
.83314 1.25063 .83034 .8033 .8356 .53587 .83457 .85492 Metetra
0 0 .109 r
.83457 .85492 .8356 .53587 .85149 .50729 .83859 .55618 Metetra
.959 .671 .448 r
.41361 1.09965 .43294 1.11913 .44595 1.49005 .42588 1.45301 Metetra
.967 .668 .404 r
.42588 1.45301 .44595 1.49005 .46218 1.70452 .44144 1.67572 Metetra
.864 .735 .719 r
.44144 1.67572 .46218 1.70452 .48133 1.62736 .46045 1.64232 Metetra
.972 .726 .504 r
.46045 1.64232 .48133 1.62736 .50109 1.30405 .48092 1.36869 Metetra
.984 .734 .471 r
.48092 1.36869 .50109 1.30405 .51943 .91668 .50051 .99791 Metetra
.992 .748 .452 r
.50051 .99791 .51943 .91668 .53607 .63955 .51824 .68947 Metetra
.999 .788 .462 r
.51824 .68947 .53607 .63955 .55217 .56759 .53468 .54514 Metetra
.931 .552 .184 r
.53468 .54514 .55217 .56759 .56939 .72066 .55119 .6027 Metetra
.97 .686 .277 r
.55119 .6027 .56939 .72066 .58898 1.05024 .5692 .84612 Metetra
.954 .689 .238 r
.5692 .84612 .58898 1.05024 .61085 1.42661 .58947 1.19996 Metetra
.908 .66 .157 r
.58947 1.19996 .61085 1.42661 .63267 1.65612 .61126 1.52243 Metetra
0 0 .134 r
.61126 1.52243 .63267 1.65612 .651 1.59475 .63211 1.64905 Metetra
.996 .797 .439 r
.63211 1.64905 .651 1.59475 .66429 1.27796 .64927 1.50371 Metetra
.927 .732 .247 r
.64927 1.50371 .66429 1.27796 .67443 .88619 .66214 1.16606 Metetra
.872 .697 .173 r
.66214 1.16606 .67443 .88619 .68513 .59817 .67277 .80159 Metetra
.837 .686 .148 r
.67277 .80159 .68513 .59817 .69983 .51346 .68433 .55102 Metetra
.929 .847 .404 r
.68433 .55102 .69983 .51346 .72079 .65553 .69968 .48828 Metetra
0 0 .236 r
.69968 .48828 .72079 .65553 .74837 .97989 .72071 .62827 Metetra
0 0 .181 r
.72071 .62827 .74837 .97989 .77969 1.3611 .7478 .93211 Metetra
0 0 .195 r
.7478 .93211 .77969 1.3611 .80804 1.60541 .77866 1.29602 Metetra
0 0 .221 r
.77866 1.29602 .80804 1.60541 .82626 1.56021 .80774 1.55751 Metetra
.601 .03 0 r
.80774 1.55751 .82626 1.56021 .83314 1.25063 .82844 1.57213 Metetra
0 0 .207 r
.82844 1.57213 .83314 1.25063 .83457 .85492 .83827 1.32759 Metetra
0 0 .215 r
.83827 1.32759 .83457 .85492 .83859 .55618 .84108 .95524 Metetra
.959 .67 .446 r
.39406 1.07996 .41361 1.09965 .42588 1.45301 .40569 1.41517 Metetra
.967 .668 .406 r
.40569 1.41517 .42588 1.45301 .44144 1.67572 .42056 1.64287 Metetra
.344 .507 .876 r
.42056 1.64287 .44144 1.67572 .46045 1.64232 .43923 1.64944 Metetra
.971 .731 .516 r
.43923 1.64944 .46045 1.64232 .48092 1.36869 .4601 1.42825 Metetra
.985 .736 .474 r
.4601 1.42825 .48092 1.36869 .50051 .99791 .48078 1.08537 Metetra
.992 .748 .451 r
.48078 1.08537 .50051 .99791 .51824 .68947 .49975 .76059 Metetra
.997 .772 .443 r
.49975 .76059 .51824 .68947 .53468 .54514 .51696 .55737 Metetra
.951 .952 .665 r
.51696 .55737 .53468 .54514 .55119 .6027 .53337 .52617 Metetra
.959 .657 .234 r
.53337 .52617 .55119 .6027 .5692 .84612 .5503 .67302 Metetra
.948 .682 .224 r
.5503 .67302 .5692 .84612 .58947 1.19996 .5689 .96141 Metetra
.913 .667 .168 r
.5689 .96141 .58947 1.19996 .61126 1.52243 .5895 1.30334 Metetra
.837 .609 .062 r
.5895 1.30334 .61126 1.52243 .63211 1.64905 .61105 1.56396 Metetra
0 0 .483 r
.61105 1.56396 .63211 1.64905 .64927 1.50371 .63119 1.61652 Metetra
.952 .773 .317 r
.63119 1.61652 .64927 1.50371 .66214 1.16606 .64782 1.43028 Metetra
.862 .697 .169 r
.64782 1.43028 .66214 1.16606 .67277 .80159 .66078 1.09615 Metetra
.806 .659 .109 r
.66078 1.09615 .67277 .80159 .68433 .55102 .67195 .75599 Metetra
.786 .658 .104 r
.67195 .75599 .68433 .55102 .69968 .48828 .684 .52331 Metetra
.952 .851 .427 r
.684 .52331 .69968 .48828 .72071 .62827 .69939 .45798 Metetra
0 0 .358 r
.69939 .45798 .72071 .62827 .7478 .93211 .71983 .57362 Metetra
0 0 .264 r
.71983 .57362 .7478 .93211 .77866 1.29602 .74588 .84224 Metetra
0 0 .256 r
.74588 .84224 .77866 1.29602 .80774 1.55751 .77607 1.18592 Metetra
0 0 .258 r
.77607 1.18592 .80774 1.55751 .82844 1.57213 .80616 1.47521 Metetra
0 0 .21 r
.80616 1.47521 .82844 1.57213 .83827 1.32759 .83024 1.57352 Metetra
0 0 .293 r
.83024 1.57352 .83827 1.32759 .84108 .95524 .84442 1.4263 Metetra
.959 .669 .443 r
.37428 1.06005 .39406 1.07996 .40569 1.41517 .38537 1.37654 Metetra
.968 .669 .406 r
.38537 1.37654 .40569 1.41517 .42056 1.64287 .39958 1.60606 Metetra
.792 .389 0 r
.39958 1.60606 .42056 1.64287 .43923 1.64944 .41773 1.64813 Metetra
.968 .737 .535 r
.41773 1.64813 .43923 1.64944 .4601 1.42825 .43869 1.48037 Metetra
.985 .739 .479 r
.43869 1.48037 .4601 1.42825 .48078 1.08537 .46021 1.17536 Metetra
.993 .749 .451 r
.46021 1.17536 .48078 1.08537 .49975 .76059 .48042 .84966 Metetra
.996 .766 .434 r
.48042 .84966 .49975 .76059 .51696 .55737 .49872 .60308 Metetra
.997 .814 .462 r
.49872 .60308 .51696 .55737 .53337 .52617 .51558 .49442 Metetra
.885 .5 .04 r
.51558 .49442 .53337 .52617 .5503 .67302 .53206 .54477 Metetra
.935 .661 .188 r
.53206 .54477 .5503 .67302 .5689 .96141 .54936 .74332 Metetra
.905 .66 .154 r
.54936 .74332 .5689 .96141 .5895 1.30334 .56834 1.04391 Metetra
.852 .628 .088 r
.56834 1.04391 .5895 1.30334 .61105 1.56396 .58909 1.35839 Metetra
.749 .544 0 r
.58909 1.35839 .61105 1.56396 .63119 1.61652 .61041 1.56938 Metetra
.282 .386 .792 r
.61041 1.56938 .63119 1.61652 .64782 1.43028 .63024 1.58216 Metetra
.87 .728 .211 r
.63024 1.58216 .64782 1.43028 .66078 1.09615 .64687 1.38777 Metetra
.774 .645 .086 r
.64687 1.38777 .66078 1.09615 .67195 .75599 .66024 1.06996 Metetra
.722 .608 .038 r
.66024 1.06996 .67195 .75599 .684 .52331 .67192 .74732 Metetra
.719 .615 .048 r
.67192 .74732 .684 .52331 .69939 .45798 .68415 .51521 Metetra
.913 .799 .323 r
.68415 .51521 .69939 .45798 .71983 .57362 .69909 .42686 Metetra
0 0 .5 r
.69909 .42686 .71983 .57362 .74588 .84224 .71836 .49881 Metetra
0 0 .35 r
.71836 .49881 .74588 .84224 .77607 1.18592 .74279 .71594 Metetra
0 0 .322 r
.74279 .71594 .77607 1.18592 .80616 1.47521 .77175 1.02671 Metetra
0 0 .31 r
.77175 1.02671 .80616 1.47521 .83024 1.57352 .80248 1.33698 Metetra
0 0 .272 r
.80248 1.33698 .83024 1.57352 .84442 1.4263 .83015 1.52723 Metetra
.959 .668 .441 r
.35429 1.03991 .37428 1.06005 .38537 1.37654 .36493 1.33717 Metetra
.968 .669 .406 r
.36493 1.33717 .38537 1.37654 .39958 1.60606 .37851 1.56543 Metetra
.933 .573 .162 r
.37851 1.56543 .39958 1.60606 .41773 1.64813 .39602 1.63797 Metetra
.96 .746 .569 r
.39602 1.63797 .41773 1.64813 .43869 1.48037 .41677 1.52275 Metetra
.985 .744 .488 r
.41677 1.52275 .43869 1.48037 .46021 1.17536 .43881 1.26372 Metetra
.993 .752 .452 r
.43881 1.26372 .46021 1.17536 .48042 .84966 .46013 .95231 Metetra
.996 .764 .428 r
.46013 .95231 .48042 .84966 .49872 .60308 .47968 .67953 Metetra
.995 .788 .422 r
.47968 .67953 .49872 .60308 .51558 .49442 .49744 .50824 Metetra
.974 .925 .631 r
.49744 .50824 .51558 .49442 .53206 .54477 .51411 .46994 Metetra
.89 .59 .082 r
.51411 .46994 .53206 .54477 .54936 .74332 .53072 .5703 Metetra
.881 .636 .114 r
.53072 .5703 .54936 .74332 .56834 1.04391 .5483 .79085 Metetra
.836 .619 .071 r
.5483 .79085 .56834 1.04391 .58909 1.35839 .56751 1.08422 Metetra
.77 .574 .003 r
.56751 1.08422 .58909 1.35839 .61041 1.56938 .58829 1.37078 Metetra
0 0 .112 r
.58829 1.37078 .61041 1.56938 .63024 1.58216 .60953 1.55314 Metetra
.372 .563 .91 r
.60953 1.55314 .63024 1.58216 .64687 1.38777 .62942 1.55786 Metetra
.748 .659 .103 r
.62942 1.55786 .64687 1.38777 .66024 1.06996 .64649 1.38032 Metetra
0 0 .004 r
.64649 1.38032 .66024 1.06996 .67192 .74732 .66054 1.08798 Metetra
0 0 .041 r
.66054 1.08798 .67192 .74732 .68415 .51521 .67275 .77835 Metetra
0 0 .028 r
.67275 .77835 .68415 .51521 .69909 .42686 .68497 .53462 Metetra
.794 .697 .156 r
.68497 .53462 .69909 .42686 .71836 .49881 .69912 .40796 Metetra
.45 .362 .665 r
.69912 .40796 .71836 .49881 .74279 .71594 .71677 .41989 Metetra
0 0 .443 r
.71677 .41989 .74279 .71594 .77175 1.02671 .73897 .56764 Metetra
0 0 .39 r
.73897 .56764 .77175 1.02671 .80248 1.33698 .76585 .8232 Metetra
0 0 .369 r
.76585 .8232 .80248 1.33698 .83015 1.52723 .79607 1.12734 Metetra
.959 .666 .437 r
.33406 1.01954 .35429 1.03991 .36493 1.33717 .34438 1.29708 Metetra
.968 .669 .404 r
.34438 1.29708 .36493 1.33717 .37851 1.56543 .35739 1.52111 Metetra
.958 .62 .251 r
.35739 1.52111 .37851 1.56543 .39602 1.63797 .37417 1.61868 Metetra
.936 .758 .636 r
.37417 1.61868 .39602 1.63797 .41677 1.52275 .39444 1.55327 Metetra
.985 .752 .502 r
.39444 1.55327 .41677 1.52275 .43881 1.26372 .41663 1.34594 Metetra
.994 .757 .456 r
.41663 1.34594 .43881 1.26372 .46013 .95231 .43881 1.06297 Metetra
.996 .766 .424 r
.43881 1.06297 .46013 .95231 .47968 .67953 .45961 .78219 Metetra
.993 .779 .403 r
.45961 .78219 .47968 .67953 .49744 .50824 .47857 .56599 Metetra
.988 .816 .429 r
.47857 .56599 .49744 .50824 .51411 .46994 .49597 .45255 Metetra
.129 .51 .911 r
.49597 .45255 .51411 .46994 .53072 .5703 .51259 .45837 Metetra
.816 .565 .009 r
.51259 .45837 .53072 .5703 .5483 .79085 .52933 .58195 Metetra
.793 .583 .018 r
.52933 .58195 .5483 .79085 .56751 1.08422 .54709 .80333 Metetra
.738 .556 0 r
.54709 .80333 .56751 1.08422 .58829 1.37078 .56639 1.08001 Metetra
0 0 .081 r
.56639 1.08001 .58829 1.37078 .60953 1.55314 .58716 1.34536 Metetra
0 0 .166 r
.58716 1.34536 .60953 1.55314 .62942 1.55786 .60845 1.52038 Metetra
0 .093 .65 r
.60845 1.52038 .62942 1.55786 .64649 1.38032 .62873 1.54373 Metetra
0 0 .009 r
.62873 1.54373 .64649 1.38032 .66054 1.08798 .64661 1.40465 Metetra
0 0 .101 r
.64661 1.40465 .66054 1.08798 .67275 .77835 .66166 1.14948 Metetra
0 0 .129 r
.66166 1.14948 .67275 .77835 .68497 .53462 .67457 .85536 Metetra
0 0 .119 r
.67457 .85536 .68497 .53462 .69912 .40796 .68682 .59593 Metetra
0 0 .018 r
.68682 .59593 .69912 .40796 .71677 .41989 .70007 .42266 Metetra
.993 .832 .58 r
.70007 .42266 .71677 .41989 .73897 .56764 .71583 .36303 Metetra
.249 .159 .553 r
.71583 .36303 .73897 .56764 .76585 .8232 .73531 .42487 Metetra
.054 0 .463 r
.73531 .42487 .76585 .8232 .79607 1.12734 .75916 .59854 Metetra
.959 .665 .434 r
.31361 .99894 .33406 1.01954 .34438 1.29708 .32371 1.2563 Metetra
.968 .668 .401 r
.32371 1.2563 .34438 1.29708 .35739 1.52111 .33623 1.47329 Metetra
.966 .639 .29 r
.33623 1.47329 .35739 1.52111 .37417 1.61868 .35227 1.59017 Metetra
.808 .742 .79 r
.35227 1.59017 .37417 1.61868 .39444 1.55327 .37183 1.57011 Metetra
.983 .762 .526 r
.37183 1.57011 .39444 1.55327 .41663 1.34594 .3938 1.41732 Metetra
.995 .764 .463 r
.3938 1.41732 .41663 1.34594 .43881 1.06297 .41647 1.17496 Metetra
.996 .77 .422 r
.41647 1.17496 .43881 1.06297 .45961 .78219 .43836 .90451 Metetra
.99 .777 .39 r
.43836 .90451 .45961 .78219 .47857 .56599 .45862 .66332 Metetra
.98 .79 .378 r
.45862 .66332 .47857 .56599 .49597 .45255 .47716 .4926 Metetra
.982 .85 .466 r
.47716 .4926 .49597 .45255 .51259 .45837 .4944 .41599 Metetra
0 0 .557 r
.4944 .41599 .51259 .45837 .52933 .58195 .51105 .44243 Metetra
0 0 .108 r
.51105 .44243 .52933 .58195 .54709 .80333 .52791 .56812 Metetra
0 0 .093 r
.52791 .56812 .54709 .80333 .56639 1.08001 .54574 .77563 Metetra
0 0 .123 r
.54574 .77563 .56639 1.08001 .58716 1.34536 .56501 1.0308 Metetra
0 0 .164 r
.56501 1.0308 .58716 1.34536 .60845 1.52038 .58571 1.28163 Metetra
0 0 .214 r
.58571 1.28163 .60845 1.52038 .62873 1.54373 .60712 1.46537 Metetra
0 0 .333 r
.60712 1.46537 .62873 1.54373 .64661 1.40465 .62801 1.52794 Metetra
0 0 .117 r
.62801 1.52794 .64661 1.40465 .66166 1.14948 .64704 1.44797 Metetra
0 0 .198 r
.64704 1.44797 .66166 1.14948 .67457 .85536 .66347 1.24808 Metetra
0 0 .218 r
.66347 1.24808 .67457 .85536 .68682 .59593 .6775 .98312 Metetra
0 0 .214 r
.6775 .98312 .68682 .59593 .70007 .42266 .69011 .71596 Metetra
0 0 .168 r
.69011 .71596 .70007 .42266 .71583 .36303 .70269 .49834 Metetra
.70269 .49834 .71583 .36303 .73531 .42487 .71663 .36392 Metetra
.797 .62 .662 r
.71663 .36392 .73531 .42487 .75916 .59854 .73318 .3297 Metetra
.959 .662 .429 r
.29292 .9781 .31361 .99894 .32371 1.2563 .30293 1.21488 Metetra
.969 .668 .397 r
.30293 1.21488 .32371 1.2563 .33623 1.47329 .31507 1.42217 Metetra
.969 .649 .308 r
.31507 1.42217 .33623 1.47329 .35227 1.59017 .33038 1.55254 Metetra
0 .151 .694 r
.33038 1.55254 .35227 1.59017 .37183 1.57011 .34908 1.57186 Metetra
.976 .778 .574 r
.34908 1.57186 .37183 1.57011 .3938 1.41732 .37048 1.47334 Metetra
.996 .775 .478 r
.37048 1.47334 .3938 1.41732 .41647 1.17496 .39321 1.28068 Metetra
.996 .777 .424 r
.39321 1.28068 .41647 1.17496 .43836 .90451 .41584 1.03779 Metetra
.986 .778 .38 r
.41584 1.03779 .43836 .90451 .45862 .66332 .43733 .79283 Metetra
.969 .78 .348 r
.43733 .79283 .45862 .66332 .47716 .4926 .45721 .58608 Metetra
.956 .795 .349 r
.45721 .58608 .47716 .4926 .4944 .41599 .47555 .44524 Metetra
.98 .879 .513 r
.47555 .44524 .4944 .41599 .51105 .44243 .49277 .38587 Metetra
0 .064 .608 r
.49277 .38587 .51105 .44243 .52791 .56812 .50951 .41355 Metetra
0 0 .251 r
.50951 .41355 .52791 .56812 .54574 .77563 .52647 .525 Metetra
0 0 .215 r
.52647 .525 .54574 .77563 .56501 1.0308 .54428 .70735 Metetra
0 0 .226 r
.54428 .70735 .56501 1.0308 .58571 1.28163 .56339 .93609 Metetra
0 0 .247 r
.56339 .93609 .58571 1.28163 .60712 1.46537 .5839 1.1737 Metetra
0 0 .271 r
.5839 1.1737 .60712 1.46537 .62801 1.52794 .60539 1.37269 Metetra
0 0 .293 r
.60539 1.37269 .62801 1.52794 .64704 1.44797 .62693 1.48595 Metetra
.393 0 .13 r
.62693 1.48595 .64704 1.44797 .66347 1.24808 .64731 1.4829 Metetra
0 0 .287 r
.64731 1.4829 .66347 1.24808 .6775 .98312 .66558 1.36253 Metetra
0 0 .302 r
.66558 1.36253 .6775 .98312 .69011 .71596 .68137 1.15399 Metetra
0 0 .301 r
.68137 1.15399 .69011 .71596 .70269 .49834 .69509 .90403 Metetra
0 0 .284 r
.69509 .90403 .70269 .49834 .71663 .36392 .70769 .66073 Metetra
0 0 .226 r
.70769 .66073 .71663 .36392 .73318 .3297 .72037 .46246 Metetra
.959 .66 .423 r
.27199 .95702 .29292 .9781 .30293 1.21488 .28204 1.17283 Metetra
.969 .666 .391 r
.28204 1.17283 .30293 1.21488 .31507 1.42217 .29392 1.368 Metetra
.971 .654 .314 r
.29392 1.368 .31507 1.42217 .33038 1.55254 .30857 1.50607 Metetra
.821 .448 0 r
.30857 1.50607 .33038 1.55254 .34908 1.57186 .32635 1.55757 Metetra
.936 .797 .682 r
.32635 1.55757 .34908 1.57186 .37048 1.47334 .34689 1.5099 Metetra
.997 .793 .508 r
.34689 1.5099 .37048 1.47334 .39321 1.28068 .36923 1.37204 Metetra
.996 .789 .431 r
.36923 1.37204 .39321 1.28068 .41584 1.03779 .39215 1.1712 Metetra
.981 .783 .372 r
.39215 1.1712 .41584 1.03779 .43733 .79283 .41455 .94355 Metetra
.955 .775 .323 r
.41455 .94355 .43733 .79283 .45721 .58608 .43573 .7244 Metetra
.926 .769 .29 r
.43573 .7244 .45721 .58608 .47555 .44524 .45542 .54212 Metetra
.915 .785 .305 r
.45542 .54212 .47555 .44524 .49277 .38587 .47376 .41617 Metetra
.973 .881 .506 r
.47376 .41617 .49277 .38587 .50951 .41355 .49111 .35785 Metetra
.287 .327 .729 r
.49111 .35785 .50951 .41355 .52647 .525 .508 .37163 Metetra
0 0 .402 r
.508 .37163 .52647 .525 .54428 .70735 .52502 .45597 Metetra
0 0 .336 r
.52502 .45597 .54428 .70735 .56339 .93609 .54273 .60302 Metetra
0 0 .325 r
.54273 .60302 .56339 .93609 .5839 1.1737 .56155 .79739 Metetra
0 0 .33 r
.56155 .79739 .5839 1.1737 .60539 1.37269 .58172 1.01484 Metetra
0 0 .337 r
.58172 1.01484 .60539 1.37269 .62693 1.48595 .60306 1.22264 Metetra
0 0 .341 r
.60306 1.22264 .62693 1.48595 .64731 1.4829 .62504 1.3835 Metetra
0 0 .289 r
.62504 1.3835 .64731 1.4829 .66558 1.36253 .64672 1.46407 Metetra
.354 .067 .331 r
.64672 1.46407 .66558 1.36253 .68137 1.15399 .66709 1.44543 Metetra
.112 0 .369 r
.66709 1.44543 .68137 1.15399 .69509 .90403 .68537 1.33018 Metetra
.054 0 .371 r
.68537 1.33018 .69509 .90403 .70769 .66073 .7013 1.14148 Metetra
.018 0 .366 r
.7013 1.14148 .70769 .66073 .72037 .46246 .71524 .91467 Metetra
.958 .656 .416 r
.25082 .9357 .27199 .95702 .28204 1.17283 .26103 1.13019 Metetra
.969 .664 .382 r
.26103 1.13019 .28204 1.17283 .29392 1.368 .2728 1.31102 Metetra
.972 .657 .313 r
.2728 1.31102 .29392 1.368 .30857 1.50607 .28692 1.45119 Metetra
.912 .566 .103 r
.28692 1.45119 .30857 1.50607 .32635 1.55757 .30378 1.5269 Metetra
.589 .667 .893 r
.30378 1.5269 .32635 1.55757 .34689 1.5099 .32329 1.52375 Metetra
.991 .822 .578 r
.32329 1.52375 .34689 1.5099 .36923 1.37204 .34485 1.44112 Metetra
.997 .809 .453 r
.34485 1.44112 .36923 1.37204 .39215 1.1712 .36753 1.29236 Metetra
.973 .792 .369 r
.36753 1.29236 .39215 1.1712 .41455 .94355 .39036 1.10079 Metetra
.934 .771 .299 r
.39036 1.10079 .41455 .94355 .43573 .7244 .41253 .8935 Metetra
.887 .747 .242 r
.41253 .8935 .43573 .7244 .45542 .54212 .43356 .6959 Metetra
.846 .731 .208 r
.43356 .6959 .45542 .54212 .47376 .41617 .45327 .5284 Metetra
.84 .746 .227 r
.45327 .5284 .47376 .41617 .49111 .35785 .47178 .40553 Metetra
.931 .849 .408 r
.47178 .40553 .49111 .35785 .508 .37163 .48938 .33632 Metetra
.718 .66 .791 r
.48938 .33632 .508 .37163 .52502 .45597 .50649 .32516 Metetra
.112 .087 .547 r
.50649 .32516 .52502 .45597 .54273 .60302 .52358 .37245 Metetra
0 0 .447 r
.52358 .37245 .54273 .60302 .56155 .79739 .54114 .47465 Metetra
0 0 .416 r
.54114 .47465 .56155 .79739 .58172 1.01484 .55957 .62375 Metetra
0 0 .406 r
.55957 .62375 .58172 1.01484 .60306 1.22264 .57917 .80639 Metetra
0 0 .404 r
.57917 .80639 .60306 1.22264 .62504 1.3835 .60003 1.00322 Metetra
0 0 .403 r
.60003 1.00322 .62504 1.3835 .64672 1.46407 .62195 1.18942 Metetra
0 0 .394 r
.62195 1.18942 .64672 1.46407 .66709 1.44543 .6444 1.33747 Metetra
0 0 .304 r
.6444 1.33747 .66709 1.44543 .68537 1.33018 .6666 1.42233 Metetra
.546 .221 .369 r
.6666 1.42233 .68537 1.33018 .7013 1.14148 .68768 1.42787 Metetra
.281 .078 .417 r
.68768 1.42787 .7013 1.14148 .71524 .91467 .70689 1.35181 Metetra
.958 .652 .407 r
.2294 .91413 .25082 .9357 .26103 1.13019 .23992 1.087 Metetra
.97 .661 .371 r
.23992 1.087 .26103 1.13019 .2728 1.31102 .25173 1.2515 Metetra
.971 .657 .305 r
.25173 1.2515 .2728 1.31102 .28692 1.45119 .26547 1.38852 Metetra
.933 .603 .156 r
.26547 1.38852 .28692 1.45119 .30378 1.5269 .28152 1.48005 Metetra
0 0 .433 r
.28152 1.48005 .30378 1.5269 .32329 1.52375 .29994 1.51275 Metetra
.919 .851 .76 r
.29994 1.51275 .32329 1.52375 .34485 1.44112 .32042 1.48098 Metetra
.997 .847 .514 r
.32042 1.48098 .34485 1.44112 .36753 1.29236 .34238 1.38834 Metetra
.963 .811 .379 r
.34238 1.38834 .36753 1.29236 .39036 1.10079 .36505 1.24669 Metetra
.902 .769 .276 r
.36505 1.24669 .39036 1.10079 .41253 .8935 .3877 1.07339 Metetra
.829 .721 .192 r
.3877 1.07339 .41253 .8935 .43356 .6959 .40972 .88768 Metetra
.758 .676 .127 r
.40972 .88768 .43356 .6959 .45327 .5284 .43076 .70768 Metetra
.705 .647 .091 r
.43076 .70768 .45327 .5284 .47178 .40553 .45067 .54847 Metetra
.45067 .54847 .47178 .40553 .48938 .33632 .46951 .42141 Metetra
.786 .743 .221 r
.46951 .42141 .48938 .33632 .50649 .32516 .48749 .33425 Metetra
.985 .9 .635 r
.48749 .33425 .50649 .32516 .52358 .37245 .50491 .29161 Metetra
.508 .413 .683 r
.50491 .29161 .52358 .37245 .54114 .47465 .52214 .29545 Metetra
.235 .149 .55 r
.52214 .29545 .54114 .47465 .55957 .62375 .53957 .34531 Metetra
.148 .064 .496 r
.53957 .34531 .55957 .62375 .57917 .80639 .55756 .43823 Metetra
.115 .03 .473 r
.55756 .43823 .57917 .80639 .60003 1.00322 .57644 .56844 Metetra
.099 .014 .462 r
.57644 .56844 .60003 1.00322 .62195 1.18942 .59644 .72682 Metetra
.084 .003 .457 r
.59644 .72682 .62195 1.18942 .6444 1.33747 .61763 .90046 Metetra
.06 0 .453 r
.61763 .90046 .6444 1.33747 .6666 1.42233 .63988 1.07279 Metetra
.005 0 .446 r
.63988 1.07279 .6666 1.42233 .68768 1.42787 .66284 1.22469 Metetra
0 0 .416 r
.66284 1.22469 .68768 1.42787 .70689 1.35181 .68591 1.3369 Metetra
.958 .646 .395 r
.20773 .8923 .2294 .91413 .23992 1.087 .21869 1.04329 Metetra
.969 .656 .355 r
.21869 1.04329 .23992 1.087 .25173 1.2515 .23071 1.18973 Metetra
.969 .654 .288 r
.23071 1.18973 .25173 1.2515 .26547 1.38852 .24426 1.3188 Metetra
.935 .614 .163 r
.24426 1.3188 .26547 1.38852 .28152 1.48005 .25968 1.41783 Metetra
.77 .441 0 r
.25968 1.41783 .28152 1.48005 .29994 1.51275 .27708 1.47609 Metetra
.177 .404 .844 r
.27708 1.47609 .29994 1.51275 .32042 1.48098 .29638 1.48656 Metetra
.966 .915 .707 r
.29638 1.48656 .32042 1.48098 .34238 1.38834 .31725 1.44732 Metetra
.953 .857 .438 r
.31725 1.44732 .34238 1.38834 .36505 1.24669 .3392 1.36196 Metetra
.855 .772 .266 r
.3392 1.36196 .36505 1.24669 .3877 1.07339 .36166 1.23882 Metetra
.743 .685 .14 r
.36166 1.23882 .3877 1.07339 .40972 .88768 .38409 1.08951 Metetra
.38409 1.08951 .40972 .88768 .43076 .70768 .40605 .92699 Metetra
0 0 .019 r
.40605 .92699 .43076 .70768 .45067 .54847 .42723 .76392 Metetra
0 0 .056 r
.42723 .76392 .45067 .54847 .46951 .42141 .44747 .61145 Metetra
0 0 .062 r
.44747 .61145 .46951 .42141 .48749 .33425 .46679 .47864 Metetra
0 0 .014 r
.46679 .47864 .48749 .33425 .50491 .29161 .48529 .37233 Metetra
.705 .707 .177 r
.48529 .37233 .50491 .29161 .52214 .29545 .50316 .29727 Metetra
.979 .882 .662 r
.50316 .29727 .52214 .29545 .53957 .34531 .52066 .25643 Metetra
.59 .457 .668 r
.52066 .25643 .53957 .34531 .55756 .43823 .53808 .25121 Metetra
.383 .252 .577 r
.53808 .25121 .55756 .43823 .57644 .56844 .55572 .28161 Metetra
.301 .173 .534 r
.55572 .28161 .57644 .56844 .59644 .72682 .57388 .34621 Metetra
.263 .136 .512 r
.57388 .34621 .59644 .72682 .61763 .90046 .59281 .44204 Metetra
.241 .115 .501 r
.59281 .44204 .61763 .90046 .63988 1.07279 .61272 .56432 Metetra
.224 .101 .494 r
.61272 .56432 .63988 1.07279 .66284 1.22469 .63376 .70617 Metetra
.205 .088 .49 r
.63376 .70617 .66284 1.22469 .68591 1.3369 .6559 .85846 Metetra
.957 .638 .379 r
.1858 .87021 .20773 .8923 .21869 1.04329 .19736 .99909 Metetra
.968 .649 .332 r
.19736 .99909 .21869 1.04329 .23071 1.18973 .20976 1.12598 Metetra
.964 .646 .258 r
.20976 1.12598 .23071 1.18973 .24426 1.3188 .22335 1.24288 Metetra
.923 .61 .139 r
.22335 1.24288 .24426 1.3188 .25968 1.41783 .23836 1.34156 Metetra
.803 .5 0 r
.23836 1.34156 .25968 1.41783 .27708 1.47609 .25495 1.41443 Metetra
0 0 .393 r
.25495 1.41443 .27708 1.47609 .29638 1.48656 .27313 1.45535 Metetra
.327 .542 .908 r
.27313 1.45535 .29638 1.48656 .31725 1.44732 .29275 1.46046 Metetra
.921 .976 .716 r
.29275 1.46046 .31725 1.44732 .3392 1.36196 .31358 1.42879 Metetra
.797 .811 .326 r
.31358 1.42879 .3392 1.36196 .36166 1.23882 .33525 1.36235 Metetra
.33525 1.36235 .36166 1.23882 .38409 1.08951 .35737 1.26589 Metetra
0 0 .029 r
.35737 1.26589 .38409 1.08951 .40605 .92699 .37955 1.14619 Metetra
0 0 .114 r
.37955 1.14619 .40605 .92699 .42723 .76392 .40145 1.01121 Metetra
0 0 .169 r
.40145 1.01121 .42723 .76392 .44747 .61145 .42282 .86925 Metetra
0 0 .202 r
.42282 .86925 .44747 .61145 .46679 .47864 .44349 .72819 Metetra
0 0 .217 r
.44349 .72819 .46679 .47864 .48529 .37233 .46339 .595 Metetra
0 0 .212 r
.46339 .595 .48529 .37233 .50316 .29727 .48255 .4755 Metetra
0 0 .172 r
.48255 .4755 .50316 .29727 .52066 .25643 .50105 .37431 Metetra
0 0 .047 r
.50105 .37431 .52066 .25643 .53808 .25121 .51905 .29486 Metetra
.855 .842 .376 r
.51905 .29486 .53808 .25121 .55572 .28161 .53672 .23955 Metetra
.829 .682 .7 r
.53672 .23955 .55572 .28161 .57388 .34621 .55427 .20988 Metetra
.561 .4 .62 r
.55427 .20988 .57388 .34621 .59281 .44204 .57194 .20653 Metetra
.449 .288 .57 r
.57194 .20653 .59281 .44204 .61272 .56432 .58995 .22946 Metetra
.396 .236 .544 r
.58995 .22946 .61272 .56432 .63376 .70617 .60851 .27783 Metetra
.366 .207 .529 r
.60851 .27783 .63376 .70617 .6559 .85846 .62782 .35002 Metetra
.954 .625 .354 r
.16361 .84787 .1858 .87021 .19736 .99909 .17591 .95444 Metetra
.965 .637 .297 r
.17591 .95444 .19736 .99909 .20976 1.12598 .18888 1.06058 Metetra
.951 .63 .208 r
.18888 1.06058 .20976 1.12598 .22335 1.24288 .20273 1.1617 Metetra
.89 .586 .079 r
.20273 1.1617 .22335 1.24288 .23836 1.34156 .21763 1.25302 Metetra
.759 .485 0 r
.21763 1.25302 .23836 1.34156 .25495 1.41443 .2337 1.32982 Metetra
0 0 .288 r
.2337 1.32982 .25495 1.41443 .27313 1.45535 .25099 1.38782 Metetra
0 0 .52 r
.25099 1.38782 .27313 1.45535 .29275 1.46046 .26947 1.42349 Metetra
.148 .39 .84 r
.26947 1.42349 .29275 1.46046 .31358 1.42879 .28905 1.43446 Metetra
.69 .981 .849 r
.28905 1.43446 .31358 1.42879 .33525 1.36235 .30955 1.41969 Metetra
.30955 1.41969 .33525 1.36235 .35737 1.26589 .33075 1.37961 Metetra
0 0 .056 r
.33075 1.37961 .35737 1.26589 .37955 1.14619 .3524 1.31612 Metetra
0 0 .177 r
.3524 1.31612 .37955 1.14619 .40145 1.01121 .37424 1.23231 Metetra
0 0 .245 r
.37424 1.23231 .40145 1.01121 .42282 .86925 .39602 1.13225 Metetra
0 0 .286 r
.39602 1.13225 .42282 .86925 .44349 .72819 .41753 1.02056 Metetra
.02 0 .312 r
.41753 1.02056 .44349 .72819 .46339 .595 .43861 .90208 Metetra
.047 0 .328 r
.43861 .90208 .46339 .595 .48255 .4755 .45914 .78155 Metetra
.062 0 .335 r
.45914 .78155 .48255 .4755 .50105 .37431 .47908 .66337 Metetra
.064 0 .334 r
.47908 .66337 .50105 .37431 .51905 .29486 .49841 .55145 Metetra
.047 0 .322 r
.49841 .55145 .51905 .29486 .53672 .23955 .51718 .44911 Metetra
0 0 .29 r
.51718 .44911 .53672 .23955 .55427 .20988 .53548 .35908 Metetra
0 0 .208 r
.53548 .35908 .55427 .20988 .57194 .20653 .55342 .28351 Metetra
.55342 .28351 .57194 .20653 .58995 .22946 .57113 .22403 Metetra
.973 .855 .664 r
.57113 .22403 .58995 .22946 .60851 .27783 .58875 .18179 Metetra
.697 .52 .644 r
.58875 .18179 .60851 .27783 .62782 .35002 .60646 .15754 Metetra
.95 .604 .315 r
.14116 .82525 .16361 .84787 .17591 .95444 .15435 .90936 Metetra
.954 .613 .235 r
.15435 .90936 .17591 .95444 .18888 1.06058 .16807 .99381 Metetra
.915 .591 .117 r
.16807 .99381 .18888 1.06058 .20273 1.1617 .18243 1.07627 Metetra
.805 .521 0 r
.18243 1.07627 .20273 1.1617 .21763 1.25302 .19752 1.15433 Metetra
0 0 .2 r
.19752 1.15433 .21763 1.25302 .2337 1.32982 .21343 1.2255 Metetra
0 0 .341 r
.21343 1.2255 .2337 1.32982 .25099 1.38782 .2302 1.28736 Metetra
0 0 .455 r
.2302 1.28736 .25099 1.38782 .26947 1.42349 .24785 1.33766 Metetra
0 .018 .56 r
.24785 1.33766 .26947 1.42349 .28905 1.43446 .26636 1.37444 Metetra
.041 .191 .694 r
.26636 1.37444 .28905 1.43446 .30955 1.41969 .28567 1.39612 Metetra
.196 .545 .929 r
.28567 1.39612 .30955 1.41969 .33075 1.37961 .30569 1.40167 Metetra
.30569 1.40167 .33075 1.37961 .3524 1.31612 .3263 1.39062 Metetra
.041 0 .106 r
.3263 1.39062 .3524 1.31612 .37424 1.23231 .34736 1.36311 Metetra
.114 0 .25 r
.34736 1.36311 .37424 1.23231 .39602 1.13225 .36873 1.31988 Metetra
.159 0 .316 r
.36873 1.31988 .39602 1.13225 .41753 1.02056 .39023 1.26224 Metetra
.19 0 .352 r
.39023 1.26224 .41753 1.02056 .43861 .90208 .41171 1.19197 Metetra
.214 .012 .375 r
.41171 1.19197 .43861 .90208 .45914 .78155 .43305 1.1112 Metetra
.231 .032 .39 r
.43305 1.1112 .45914 .78155 .47908 .66337 .45412 1.02231 Metetra
.243 .045 .4 r
.45412 1.02231 .47908 .66337 .49841 .55145 .47483 .92779 Metetra
.251 .054 .407 r
.47483 .92779 .49841 .55145 .51718 .44911 .49512 .83013 Metetra
.255 .059 .41 r
.49512 .83013 .51718 .44911 .53548 .35908 .51495 .73174 Metetra
.255 .058 .41 r
.51495 .73174 .53548 .35908 .55342 .28351 .53431 .63488 Metetra
.248 .052 .407 r
.53431 .63488 .55342 .28351 .57113 .22403 .55323 .54159 Metetra
.234 .039 .398 r
.55323 .54159 .57113 .22403 .58875 .18179 .57173 .45366 Metetra
.205 .011 .382 r
.57173 .45366 .58875 .18179 .60646 .15754 .58989 .37265 Metetra
.936 .563 .242 r
.11843 .80236 .14116 .82525 .15435 .90936 .13269 .86391 Metetra
.917 .556 .114 r
.13269 .86391 .15435 .90936 .16807 .99381 .14733 .92597 Metetra
.803 .489 0 r
.14733 .92597 .16807 .99381 .18243 1.07627 .16242 .98761 Metetra
0 0 .244 r
.16242 .98761 .18243 1.07627 .19752 1.15433 .17801 1.04783 Metetra
0 0 .376 r
.17801 1.04783 .19752 1.15433 .21343 1.2255 .19414 1.10558 Metetra
0 0 .457 r
.19414 1.10558 .21343 1.2255 .2302 1.28736 .21083 1.15982 Metetra
0 0 .507 r
.21083 1.15982 .2302 1.28736 .24785 1.33766 .22811 1.2095 Metetra
.055 .059 .543 r
.22811 1.2095 .24785 1.33766 .26636 1.37444 .24598 1.25361 Metetra
.121 .114 .575 r
.24598 1.25361 .26636 1.37444 .28567 1.39612 .26444 1.29119 Metetra
.166 .167 .614 r
.26444 1.29119 .28567 1.39612 .30569 1.40167 .28345 1.32138 Metetra
.191 .23 .674 r
.28345 1.32138 .30569 1.40167 .3263 1.39062 .30299 1.34344 Metetra
.171 .343 .794 r
.30299 1.34344 .3263 1.39062 .34736 1.36311 .323 1.35677 Metetra
0 .473 .732 r
.323 1.35677 .34736 1.36311 .36873 1.31988 .34342 1.36095 Metetra
.317 0 .064 r
.34342 1.36095 .36873 1.31988 .39023 1.26224 .36419 1.35575 Metetra
.337 .022 .274 r
.36419 1.35575 .39023 1.26224 .41171 1.19197 .38522 1.3411 Metetra
.347 .074 .349 r
.38522 1.3411 .41171 1.19197 .43305 1.1112 .40644 1.31717 Metetra
.356 .103 .387 r
.40644 1.31717 .43305 1.1112 .45412 1.02231 .42775 1.28431 Metetra
.363 .122 .409 r
.42775 1.28431 .45412 1.02