(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12901,        348]*)
(*NotebookOutlinePosition[     18506,        531]*)
(*  CellTagsIndexPosition[     17656,        493]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New in Version 3", "Section",
  CellTags->{"S0.0.1", "1.1"}],

Cell[TextData[{
  "Released at the end of 1996, ",
  StyleBox["Mathematica", "TI"],
  " Version 3 was the first new version of ",
  StyleBox["Mathematica", "TI"],
  " in several years. It substantially strengthened the core computational \
capabilities of ",
  StyleBox["Mathematica", "TI"],
  ", and introduced some revolutionary new features.  Except as noted in \
Section ",
  ButtonBox["A.13.1",
    ButtonData:>{"A.13.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", Version 3 was fully compatible with earlier versions.   "
}], "Text",
  CellTags->{"S0.0.1", "1.2"}],

Cell[CellGroupData[{

Cell["Numerical Computation", "Subsection",
  CellTags->{"S0.0.2", "1.3"}],

Cell["\<\
\[FilledSmallSquare] Adaptive precision control to generate results \
with guaranteed precision.  
\[FilledSmallSquare] High\[Hyphen]performance compilation of \
list\[Hyphen]oriented, procedural and functional numerical operations.  
\[FilledSmallSquare] Optimized algorithms for one\[Hyphen] and \
higher\[Hyphen]dimensional interpolation.  
\[FilledSmallSquare] Optimized algorithms for solution of differential \
equations.  
\[FilledSmallSquare] Solution of boundary value ordinary differential \
equations, and initial value partial differential equations.  
\[FilledSmallSquare] High\[Hyphen]dimensional numerical integration.  
\[FilledSmallSquare] Optimized minimization algorithms.  
\[FilledSmallSquare] LU and Jordan decomposition of matrices.  
\[FilledSmallSquare] Numerical differentiation.  
\[FilledSmallSquare] Automatic comparison and manipulation of exact numeric \
quantities.  
\[FilledSmallSquare] Support for exact implicitly\[Hyphen]defined algebraic \
numbers.  
\[FilledSmallSquare] Support for interval arithmetic.  
\[FilledSmallSquare] Fully adjustable global numerical precision control \
model.  
\[FilledSmallSquare] New capabilities for extracting segments of digits in \
exact and inexact numbers.  
\[FilledSmallSquare] Machine\[Hyphen]independent mechanisms for input and \
output of numbers without loss of precision.  \
\>", "Notes",
  CellTags->{"S0.0.2", "1.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic Computation", "Subsection",
  CellTags->{"S0.0.3", "1.5"}],

Cell["\<\
\[FilledSmallSquare] Enhanced and optimized simplification of \
algebraic expressions.  
\[FilledSmallSquare] Simplification of expressions involving special \
functions.  
\[FilledSmallSquare] Built\[Hyphen]in functions for transformations on \
trigonometric expressions.  
\[FilledSmallSquare] Greatly extended indefinite and definite symbolic \
integration.  \
\>", "Notes",
  CellTags->{"S0.0.3", "1.6"}],

Cell["\<\
\[FilledSmallSquare] Support for principal values and assumptions \
on parameters in integrals.  
\[FilledSmallSquare] Greatly extended symbolic sums and products.  
\[FilledSmallSquare] Greatly extended symbolic solution of ordinary and \
partial differential equations.  
\[FilledSmallSquare] Optimized symbolic linear algebra.  
\[FilledSmallSquare] Enhanced handling of exact numerical quantities.  
\[FilledSmallSquare] Generation and system\[Hyphen]wide support for algebraic \
numbers.  
\[FilledSmallSquare] Highly optimized Gr\[ODoubleDot]bner basis reduction.  \
\
\>", "Notes",
  CellTags->{"S0.0.3", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Functions", "Subsection",
  CellTags->{"S0.0.4", "1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] Faster evaluation of many special functions.  \n\
\[FilledSmallSquare] Fresnel integrals and hyperbolic sine and cosine \
integrals.  \n\[FilledSmallSquare] Inverse error function, gamma function and \
beta function.  \n\[FilledSmallSquare] Product log function.  \n\
\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Null]", 
            StyleBox["p",
              "TI"]], 
          SubscriptBox[
            StyleBox["F",
              "TI"], 
            StyleBox["q",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  " generalized hypergeometric functions and Meijer G functions.  \n\
\[FilledSmallSquare] Additional Weierstrass, elliptic and related functions.  \
\n\[FilledSmallSquare] Mathieu functions.  \n\[FilledSmallSquare] Stieltjes \
constants.  \n\[FilledSmallSquare] Built\[Hyphen]in Fibonacci numbers and \
polynomials.  "
}], "Notes",
  CellTags->{"S0.0.4", "1.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Subsection",
  CellTags->{"S0.0.5", "1.10"}],

Cell["\<\
\[FilledSmallSquare] Full typesetting capabilities for labels and \
text in plots.  
\[FilledSmallSquare] Automatic conversions to EPS, TIFF, GIF and other \
formats.  
\[FilledSmallSquare] Kernel control of animation in notebooks.  
\[FilledSmallSquare] Absolute offset specifications in graphics primitives.  
\[FilledSmallSquare] Direct control of final graphics size, resolution, etc.  \

\[FilledSmallSquare] Direct generation of text strings for graphics in \
various formats.  \
\>", "Notes",
  CellTags->{"S0.0.5", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programming and Core System", "Subsection",
  CellTags->{"S0.0.6", "1.12"}],

Cell["\<\
\[FilledSmallSquare] Faster execution speed and lower memory usage \
for typical kernel operations.  
\[FilledSmallSquare] Dumping of function definitions for optimized loading.  \
\
\>", "Notes",
  CellTags->{"S0.0.6", "1.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] Powerful new general symbolic programming functions, \
including ",
  ButtonBox["ReplaceList",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Split",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] Pattern\[Hyphen]based non\[Hyphen]local control \
flow with ",
  ButtonBox["Throw",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Catch",
    ButtonStyle->"RefGuideLink"],
  ".  \n\[FilledSmallSquare] Separate support for verbatim and held patterns. \
 \n\[FilledSmallSquare] Enhanced control of basic evaluation.  \n\
\[FilledSmallSquare] New functions and enhancements for string manipulation.  \
\n\[FilledSmallSquare] Extensive support for manipulation of \
non\[Hyphen]ASCII characters.  "
}], "Notes",
  CellTags->{"S0.0.6", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input and Output", "Subsection",
  CellTags->{"S0.0.7", "1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for WYSIWYG fully editable \
two\[Hyphen]dimensional typeset input and output.  \n\[FilledSmallSquare] \
Extended ",
  StyleBox["Mathematica", "TI"],
  " language incorporating special characters and two\[Hyphen]dimensional \
notation.  \n\[FilledSmallSquare] Over 700 special characters for \
mathematical and other notation.  \n\[FilledSmallSquare] Support for \
traditional math textbook notation for output and heuristic input.  \n\
\[FilledSmallSquare] Top\[Hyphen]quality typeset output with advanced \
adjustable layout rules.  \n\[FilledSmallSquare] Complete symbolic language \
for specifying two\[Hyphen]dimensional typeset structures.  \n\
\[FilledSmallSquare] Two\[Hyphen]dimensional input and manipulation of arrays \
and matrices.  \n\[FilledSmallSquare] Complete support for international \
character sets and Unicode.  \n\[FilledSmallSquare] TeX conversion with line\
\[Hyphen]breaking information.  \n\[FilledSmallSquare] Optimized textual \
import and export of typeset structures.  "
}], "Notes",
  CellTags->{"S0.0.7", "1.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Interface", "Subsection",
  CellTags->{"S0.0.8", "1.17"}],

Cell["\<\
\[FilledSmallSquare] Programmable documents based on underlying \
symbolic representation.  
\[FilledSmallSquare] Symbolic language for specifying user interface \
operations.  
\[FilledSmallSquare] Customizable palettes that can execute any kernel or \
front end operation.  
\[FilledSmallSquare] Integrated active elements and hyperlinks in notebooks.  \

\[FilledSmallSquare] Separate style environments for screen and printing.  
\[FilledSmallSquare] New style sheets for varied document types.  
\[FilledSmallSquare] Language\[Hyphen]based control of all features of text, \
graphics, cells and notebooks.  
\[FilledSmallSquare] Inline typesetting and graphics embedded in text.  
\[FilledSmallSquare] Enhanced text formatting capabilities including full \
text justification.  \
\>", "Notes",
  CellTags->{"S0.0.8", "1.18"}],

Cell["\<\
\[FilledSmallSquare] Integrated customizable notebook\[Hyphen]based \
online help with hyperlinks and the full text of this book.  
\[FilledSmallSquare] Fully platform\[Hyphen]independent notebook file format. \
 
\[FilledSmallSquare] Notebook conversion to TeX, HTML and other external \
formats.  
\[FilledSmallSquare] Option inspector for interactive control of all \
notebooks and front end properties.  
\[FilledSmallSquare] Keyboard commands for editing and notebook navigation; \
drag and drop.  \
\>", "Notes",
  CellTags->{"S0.0.8", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Interface", "Subsection",
  CellTags->{"S0.0.9", "1.20"}],

Cell[TextData[{
  "\[FilledSmallSquare] Additional kernel directory and file manipulation \
functions.  \n\[FilledSmallSquare] Support for multi\[Hyphen]platform \
external program clusters.  \n\[FilledSmallSquare] Optimized ",
  StyleBox["MathLink", "TI"],
  " external program interface.  \n\[FilledSmallSquare] Loopback links for \
storing expressions in external programs.  \n\[FilledSmallSquare] Direct \
support for arrays in external programs.  \n\[FilledSmallSquare] Shared \
libraries for ",
  StyleBox["MathLink", "TI"],
  ".  \n\[FilledSmallSquare] Uniform layout of system files across all \
platforms.  \n\[FilledSmallSquare] Automatic initialization of kernel and \
front end functionality as well as documentation for add\[Hyphen]ons.  \n\
\[FilledSmallSquare] Support for multi\[Hyphen]lingual versions and all \
standard keyboard character encodings.  \n\[FilledSmallSquare] \
TCP\[Hyphen]based network license server.  \n\[FilledSmallSquare] OLE support \
under Microsoft Windows.  "
}], "Notes",
  CellTags->{"S0.0.9", "1.21"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Add\[Hyphen]on Packages", "Subsection",
  CellTags->{"S0.0.10", "1.22"}],

Cell["\<\
\[FilledSmallSquare] Manipulating and solving algebraic \
inequalities.  
\[FilledSmallSquare] Symmetric polynomials.  
\[FilledSmallSquare] Manipulating quaternions and elements of Galois fields.  \

\[FilledSmallSquare] Complete integrals and differential invariants of \
nonlinear PDEs.  
\[FilledSmallSquare] Primitive roots for arbitrary algebraic extensions.  
\[FilledSmallSquare] Numerical residue and series computations.  
\[FilledSmallSquare] Data smoothing and filtering.  
\[FilledSmallSquare] Classical and robust multivariate descriptive \
statistics.  
\[FilledSmallSquare] Linear and nonlinear regression with diagnostics.  
\[FilledSmallSquare] Simplified arithmetic and algebra without complex \
numbers.  
\[FilledSmallSquare] Full online documentation of all packages.  \
\>", \
"Notes",
  CellTags->{"S0.0.10", "1.23"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.0.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}],
    Cell[1845, 56, 574, 15, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}]},
  "1.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}]},
  "1.2"->{
    Cell[1845, 56, 574, 15, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}]},
  "S0.0.2"->{
    Cell[2444, 75, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.3"}],
    Cell[2521, 78, 1413, 27, 70, "Notes",
      CellTags->{"S0.0.2", "1.4"}]},
  "1.3"->{
    Cell[2444, 75, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.3"}]},
  "1.4"->{
    Cell[2521, 78, 1413, 27, 70, "Notes",
      CellTags->{"S0.0.2", "1.4"}]},
  "S0.0.3"->{
    Cell[3971, 110, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.5"}],
    Cell[4048, 113, 418, 10, 70, "Notes",
      CellTags->{"S0.0.3", "1.6"}],
    Cell[4469, 125, 629, 13, 70, "Notes",
      CellTags->{"S0.0.3", "1.7"}]},
  "1.5"->{
    Cell[3971, 110, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.5"}]},
  "1.6"->{
    Cell[4048, 113, 418, 10, 70, "Notes",
      CellTags->{"S0.0.3", "1.6"}]},
  "1.7"->{
    Cell[4469, 125, 629, 13, 70, "Notes",
      CellTags->{"S0.0.3", "1.7"}]},
  "S0.0.4"->{
    Cell[5135, 143, 75, 1, 70, "Subsection",
      CellTags->{"S0.0.4", "1.8"}],
    Cell[5213, 146, 986, 23, 70, "Notes",
      CellTags->{"S0.0.4", "1.9"}]},
  "1.8"->{
    Cell[5135, 143, 75, 1, 70, "Subsection",
      CellTags->{"S0.0.4", "1.8"}]},
  "1.9"->{
    Cell[5213, 146, 986, 23, 70, "Notes",
      CellTags->{"S0.0.4", "1.9"}]},
  "S0.0.5"->{
    Cell[6236, 174, 62, 1, 70, "Subsection",
      CellTags->{"S0.0.5", "1.10"}],
    Cell[6301, 177, 541, 12, 70, "Notes",
      CellTags->{"S0.0.5", "1.11"}]},
  "1.10"->{
    Cell[6236, 174, 62, 1, 70, "Subsection",
      CellTags->{"S0.0.5", "1.10"}]},
  "1.11"->{
    Cell[6301, 177, 541, 12, 70, "Notes",
      CellTags->{"S0.0.5", "1.11"}]},
  "S0.0.6"->{
    Cell[6879, 194, 81, 1, 70, "Subsection",
      CellTags->{"S0.0.6", "1.12"}],
    Cell[6963, 197, 238, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.13"}],
    Cell[7204, 205, 815, 21, 70, "Notes",
      CellTags->{"S0.0.6", "1.14"}]},
  "1.12"->{
    Cell[6879, 194, 81, 1, 70, "Subsection",
      CellTags->{"S0.0.6", "1.12"}]},
  "1.13"->{
    Cell[6963, 197, 238, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.13"}]},
  "1.14"->{
    Cell[7204, 205, 815, 21, 70, "Notes",
      CellTags->{"S0.0.6", "1.14"}]},
  "S0.0.7"->{
    Cell[8056, 231, 70, 1, 70, "Subsection",
      CellTags->{"S0.0.7", "1.15"}],
    Cell[8129, 234, 1095, 18, 238, "Notes",
      CellTags->{"S0.0.7", "1.16"}]},
  "1.15"->{
    Cell[8056, 231, 70, 1, 70, "Subsection",
      CellTags->{"S0.0.7", "1.15"}]},
  "1.16"->{
    Cell[8129, 234, 1095, 18, 238, "Notes",
      CellTags->{"S0.0.7", "1.16"}]},
  "S0.0.8"->{
    Cell[9261, 257, 72, 1, 70, "Subsection",
      CellTags->{"S0.0.8", "1.17"}],
    Cell[9336, 260, 840, 17, 200, "Notes",
      CellTags->{"S0.0.8", "1.18"}],
    Cell[10179, 279, 560, 12, 128, "Notes",
      CellTags->{"S0.0.8", "1.19"}]},
  "1.17"->{
    Cell[9261, 257, 72, 1, 70, "Subsection",
      CellTags->{"S0.0.8", "1.17"}]},
  "1.18"->{
    Cell[9336, 260, 840, 17, 200, "Notes",
      CellTags->{"S0.0.8", "1.18"}]},
  "1.19"->{
    Cell[10179, 279, 560, 12, 128, "Notes",
      CellTags->{"S0.0.8", "1.19"}]},
  "S0.0.9"->{
    Cell[10776, 296, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.9", "1.20"}],
    Cell[10849, 299, 1046, 18, 260, "Notes",
      CellTags->{"S0.0.9", "1.21"}]},
  "1.20"->{
    Cell[10776, 296, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.9", "1.20"}]},
  "1.21"->{
    Cell[10849, 299, 1046, 18, 260, "Notes",
      CellTags->{"S0.0.9", "1.21"}]},
  "S0.0.10"->{
    Cell[11932, 322, 87, 1, 38, "Subsection",
      CellTags->{"S0.0.10", "1.22"}],
    Cell[12022, 325, 851, 19, 244, "Notes",
      CellTags->{"S0.0.10", "1.23"}]},
  "1.22"->{
    Cell[11932, 322, 87, 1, 38, "Subsection",
      CellTags->{"S0.0.10", "1.22"}]},
  "1.23"->{
    Cell[12022, 325, 851, 19, 244, "Notes",
      CellTags->{"S0.0.10", "1.23"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.0.1", 13516, 364},
  {"1.1", 13681, 369},
  {"1.2", 13770, 372},
  {"S0.0.2", 13861, 375},
  {"1.3", 14031, 380},
  {"1.4", 14123, 383},
  {"S0.0.3", 14216, 386},
  {"1.5", 14465, 393},
  {"1.6", 14558, 396},
  {"1.7", 14648, 399},
  {"S0.0.4", 14741, 402},
  {"1.8", 14912, 407},
  {"1.9", 15005, 410},
  {"S0.0.5", 15098, 413},
  {"1.10", 15272, 418},
  {"1.11", 15367, 421},
  {"S0.0.6", 15461, 424},
  {"1.12", 15713, 431},
  {"1.13", 15808, 434},
  {"1.14", 15899, 437},
  {"S0.0.7", 15993, 440},
  {"1.15", 16169, 445},
  {"1.16", 16264, 448},
  {"S0.0.8", 16360, 451},
  {"1.17", 16616, 458},
  {"1.18", 16711, 461},
  {"1.19", 16804, 464},
  {"S0.0.9", 16900, 467},
  {"1.20", 17078, 472},
  {"1.21", 17174, 475},
  {"S0.0.10", 17272, 478},
  {"1.22", 17451, 483},
  {"1.23", 17548, 486}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 66, 1, 65, "Section",
  CellTags->{"S0.0.1", "1.1"}],
Cell[1845, 56, 574, 15, 70, "Text",
  CellTags->{"S0.0.1", "1.2"}],

Cell[CellGroupData[{
Cell[2444, 75, 74, 1, 70, "Subsection",
  CellTags->{"S0.0.2", "1.3"}],
Cell[2521, 78, 1413, 27, 70, "Notes",
  CellTags->{"S0.0.2", "1.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3971, 110, 74, 1, 70, "Subsection",
  CellTags->{"S0.0.3", "1.5"}],
Cell[4048, 113, 418, 10, 70, "Notes",
  CellTags->{"S0.0.3", "1.6"}],
Cell[4469, 125, 629, 13, 70, "Notes",
  CellTags->{"S0.0.3", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5135, 143, 75, 1, 70, "Subsection",
  CellTags->{"S0.0.4", "1.8"}],
Cell[5213, 146, 986, 23, 70, "Notes",
  CellTags->{"S0.0.4", "1.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6236, 174, 62, 1, 70, "Subsection",
  CellTags->{"S0.0.5", "1.10"}],
Cell[6301, 177, 541, 12, 70, "Notes",
  CellTags->{"S0.0.5", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6879, 194, 81, 1, 70, "Subsection",
  CellTags->{"S0.0.6", "1.12"}],
Cell[6963, 197, 238, 6, 70, "Notes",
  CellTags->{"S0.0.6", "1.13"}],
Cell[7204, 205, 815, 21, 70, "Notes",
  CellTags->{"S0.0.6", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8056, 231, 70, 1, 70, "Subsection",
  CellTags->{"S0.0.7", "1.15"}],
Cell[8129, 234, 1095, 18, 238, "Notes",
  CellTags->{"S0.0.7", "1.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9261, 257, 72, 1, 70, "Subsection",
  CellTags->{"S0.0.8", "1.17"}],
Cell[9336, 260, 840, 17, 200, "Notes",
  CellTags->{"S0.0.8", "1.18"}],
Cell[10179, 279, 560, 12, 128, "Notes",
  CellTags->{"S0.0.8", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10776, 296, 70, 1, 38, "Subsection",
  CellTags->{"S0.0.9", "1.20"}],
Cell[10849, 299, 1046, 18, 260, "Notes",
  CellTags->{"S0.0.9", "1.21"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11932, 322, 87, 1, 38, "Subsection",
  CellTags->{"S0.0.10", "1.22"}],
Cell[12022, 325, 851, 19, 244, "Notes",
  CellTags->{"S0.0.10", "1.23"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

