(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14812,        597]*)
(*NotebookOutlinePosition[     31630,       1128]*)
(*  CellTagsIndexPosition[     29381,       1032]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New in Version 4", "Section",
  CellTags->{"S0.0.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " Version 4 introduces important extensions to the ",
  StyleBox["Mathematica", "TI"],
  " system, especially major efficiency enhancements in handling large \
volumes of numerical data. It also includes a range of new algorithmic, \
language and interface features.  Except as noted in Section ",
  ButtonBox["A.13.1",
    ButtonData:>{"A.13.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", Version 4 is fully compatible with all earlier versions.         "
}], "Text",
  CellTags->{"S0.0.1", "1.2"}],

Cell[TextData[{
  ButtonBox["New in V4 Demo Palette.",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "GettingStarted", "Demos", "Palettes"}, "NewIn4.nb", 
        CharacterEncoding -> "ISO8859-1"], None},
    ButtonStyle->"Hyperlink"],
  "  "
}], "Text",
  CellTags->{"S0.0.1", "1.3"}],

Cell[CellGroupData[{

Cell["Numerical Computation", "Subsection",
  CellTags->{"S0.0.2", "1.4"}],

Cell["\<\
\[FilledSmallSquare] Internal packed array technology to make \
repetitive operations on large numerical datasets radically more efficient in \
speed and memory. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.5"}],

Cell["\<\
\[FilledSmallSquare] Highly optimized algorithms for doing \
computations on numbers with up to millions of digits. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.6"}],

Cell["\<\
\[FilledSmallSquare] Faster input and output of very large \
integers. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.7"}],

Cell["\<\
\[FilledSmallSquare] Complete preservation of precision on input \
and output of approximate real numbers. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.8"}],

Cell["\<\
\[FilledSmallSquare] Convolution and correlation of arrays of any \
dimension. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.9"}],

Cell["\<\
\[FilledSmallSquare] New optimized algorithms for Fourier \
transforms. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.10"}],

Cell["\<\
\[FilledSmallSquare] Faster solution of numerical polynomial \
equations. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] New algorithms for ",
  ButtonBox["FindMinimum",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.2", "1.12"}],

Cell["\<\
\[FilledSmallSquare] Direct support for matrix traces. \
\>", \
"Notes",
  CellTags->{"S0.0.2", "1.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic Computation", "Subsection",
  CellTags->{"S0.0.3", "1.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for assumptions in ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  " and related functions. "
}], "Notes",
  CellTags->{"S0.0.3", "1.15"}],

Cell["\<\
\[FilledSmallSquare] Specification of domains for variables. \
\>", \
"Notes",
  CellTags->{"S0.0.3", "1.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] Many additional transformations in ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FunctionExpand",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.3", "1.17"}],

Cell["\<\
\[FilledSmallSquare] Simplification of polynomial and other \
inequalities. \
\>", "Notes",
  CellTags->{"S0.0.3", "1.18"}],

Cell["\<\
\[FilledSmallSquare] Full support of symbolic Laplace, Fourier and \
Z transforms. \
\>", "Notes",
  CellTags->{"S0.0.3", "1.19"}],

Cell["\<\
\[FilledSmallSquare] Extensions to integration and summation. \
\
\>", "Notes",
  CellTags->{"S0.0.3", "1.20"}],

Cell["\<\
\[FilledSmallSquare] Extensions to transcendental equation solving. \
\
\>", "Notes",
  CellTags->{"S0.0.3", "1.21"}],

Cell["\<\
\[FilledSmallSquare] Faster multiple differentiation. \
\>", "Notes",
  CellTags->{"S0.0.3", "1.22"}],

Cell["\[FilledSmallSquare] Support for subresultants. ", "Notes",
  CellTags->{"S0.0.3", "1.23"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Functions", "Subsection",
  CellTags->{"S0.0.4", "1.24"}],

Cell["\<\
\[FilledSmallSquare] Dirac delta and other generalized functions. \
\
\>", "Notes",
  CellTags->{"S0.0.4", "1.25"}],

Cell["\[FilledSmallSquare] Struve functions. ", "Notes",
  CellTags->{"S0.0.4", "1.26"}],

Cell["\<\
\[FilledSmallSquare] Nielsen generalized polylogarithms. \
\>", \
"Notes",
  CellTags->{"S0.0.4", "1.27"}],

Cell["\<\
\[FilledSmallSquare] Appell F1 bivariate hypergeometric function. \
\
\>", "Notes",
  CellTags->{"S0.0.4", "1.28"}],

Cell["\[FilledSmallSquare] Harmonic numbers. ", "Notes",
  CellTags->{"S0.0.4", "1.29"}],

Cell["\<\
\[FilledSmallSquare] Khinchin and Glaisher constants. \
\>", "Notes",
  CellTags->{"S0.0.4", "1.30"}],

Cell["\<\
\[FilledSmallSquare] Multiplicative order and Carmichael lambda \
functions. \
\>", "Notes",
  CellTags->{"S0.0.4", "1.31"}],

Cell[TextData[{
  "\[FilledSmallSquare] New optimized methods for evaluating ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " and other constants to very high precision. "
}], "Notes",
  CellTags->{"S0.0.4", "1.32"}],

Cell["\<\
\[FilledSmallSquare] Full support for continued fractions. \
\>", \
"Notes",
  CellTags->{"S0.0.4", "1.33"}],

Cell["\<\
\[FilledSmallSquare] Support for periodic digit sequences. \
\>", \
"Notes",
  CellTags->{"S0.0.4", "1.34"}],

Cell["\<\
\[FilledSmallSquare] Direct support for bitwise operations. \
\>", \
"Notes",
  CellTags->{"S0.0.4", "1.35"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics and Sound", "Subsection",
  CellTags->{"S0.0.5", "1.36"}],

Cell["\<\
\[FilledSmallSquare] Faster generation and display of large \
graphics. \
\>", "Notes",
  CellTags->{"S0.0.5", "1.37"}],

Cell["\<\
\[FilledSmallSquare] Export of graphics and sound in many formats. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.38"}],

Cell["\<\
\[FilledSmallSquare] Import of graphics and sound in many formats. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.39"}],

Cell["\<\
\[FilledSmallSquare] Support for discrete scaling of color levels. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.40"}],

Cell["\<\
\[FilledSmallSquare] Fully consistent support for absolute options. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.41"}],

Cell["\<\
\[FilledSmallSquare] Experimental support for real\[Hyphen]time 3D \
graphics (Windows only). \
\>", "Notes",
  CellTags->{"S0.0.5", "1.42"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programming and Core System", "Subsection",
  CellTags->{"S0.0.6", "1.43"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["NestWhile",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["NestWhileList",
    ButtonStyle->"RefGuideLink"],
  ", allowing generalizations of ",
  ButtonBox["FixedPoint",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.6", "1.44"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["PadLeft",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["PadRight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.6", "1.45"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for padding and overhangs in ",
  ButtonBox["Partition",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.6", "1.46"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["ListConvolve",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["ListCorrelate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.6", "1.47"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generalization of ",
  ButtonBox["Take",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Drop",
    ButtonStyle->"RefGuideLink"],
  " and related functions to any number of dimensions and any stride. "
}], "Notes",
  CellTags->{"S0.0.6", "1.48"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for ",
  ButtonBox["All",
    ButtonStyle->"RefGuideLink"],
  " as a specification of parts at specific levels in expressions. "
}], "Notes",
  CellTags->{"S0.0.6", "1.49"}],

Cell[TextData[{
  "\[FilledSmallSquare] Extension to ",
  ButtonBox["Mod",
    ButtonStyle->"RefGuideLink"],
  " to support cyclic lists. "
}], "Notes",
  CellTags->{"S0.0.6", "1.50"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Developer`", "MR"],
  " context containing advanced and algorithmic specific built\[Hyphen]in \
functions. "
}], "Notes",
  CellTags->{"S0.0.6", "1.51"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Experimental`", "MR"],
  " context providing a preview of features under development. "
}], "Notes",
  CellTags->{"S0.0.6", "1.52"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input and Output", "Subsection",
  CellTags->{"S0.0.7", "1.53"}],

Cell["\<\
\[FilledSmallSquare] Optimized minimal\[Hyphen]change line breaking \
for smooth input of expressions and programs. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.54"}],

Cell["\<\
\[FilledSmallSquare] Event\[Hyphen]oriented cursor tracker for \
visual continuity during input. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.55"}],

Cell["\<\
\[FilledSmallSquare] Dynamic color cues for delimiter matching \
during input. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.56"}],

Cell["\<\
\[FilledSmallSquare] Automatic replacement of input key sequences \
by special characters or other objects. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.57"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " used by default in standard output. "
}], "Notes",
  CellTags->{"S0.0.7", "1.58"}],

Cell["\<\
\[FilledSmallSquare] New optional syntax for part extraction and \
function application. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.59"}],

Cell[TextData[{
  "\[FilledSmallSquare] Inline cells within typeset ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Notes",
  CellTags->{"S0.0.7", "1.60"}],

Cell[TextData[{
  "\[FilledSmallSquare] Much faster string\[Hyphen]oriented output of ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Notes",
  CellTags->{"S0.0.7", "1.61"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Interface", "Subsection",
  CellTags->{"S0.0.8", "1.62"}],

Cell["\<\
\[FilledSmallSquare] Full\[Hyphen]function spell checking including \
special technical dictionaries. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.63"}],

Cell["\<\
\[FilledSmallSquare] Dictionary\[Hyphen]validated algorithmic \
hyphenation. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.64"}],

Cell["\<\
\[FilledSmallSquare] Additional keyboard navigation features. \
\
\>", "Notes",
  CellTags->{"S0.0.8", "1.65"}],

Cell["\[FilledSmallSquare] Enhanced undo capabilities. ", "Notes",
  CellTags->{"S0.0.8", "1.66"}],

Cell["\<\
\[FilledSmallSquare] Platform\[Hyphen]independent double buffering \
to eliminate flicker. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.67"}],

Cell["\<\
\[FilledSmallSquare] Optimized controller for smooth autoscrolling. \
\
\>", "Notes",
  CellTags->{"S0.0.8", "1.68"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Interface", "Subsection",
  CellTags->{"S0.0.9", "1.69"}],

Cell["\<\
\[FilledSmallSquare] Streamlined import and export of tabular data. \
\
\>", "Notes",
  CellTags->{"S0.0.9", "1.70"}],

Cell["\<\
\[FilledSmallSquare] Extended support for conversion to HTML. \
\
\>", "Notes",
  CellTags->{"S0.0.9", "1.71"}],

Cell["\<\
\[FilledSmallSquare] Additional support for TeX output. \
\>", \
"Notes",
  CellTags->{"S0.0.9", "1.72"}],

Cell[TextData[{
  "\[FilledSmallSquare] Faster ",
  StyleBox["MathLink", "TI"],
  " external program communication. "
}], "Notes",
  CellTags->{"S0.0.9", "1.73"}],

Cell["\<\
\[FilledSmallSquare] Support for additional character sets, \
including Chinese and Korean. \
\>", "Notes",
  CellTags->{"S0.0.9", "1.74"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Add\[Hyphen]ons and Experimental Features\
\>", "Subsection",
  CellTags->{"S0.0.10", "1.75"}],

Cell["\<\
\[FilledSmallSquare] Direct support for sparse linear algebra. \
\
\>", "Notes",
  CellTags->{"S0.0.10", "1.76"}],

Cell["\<\
\[FilledSmallSquare] Experimental support of quantifier elimination \
using cylindrical algebraic decomposition. \
\>", "Notes",
  CellTags->{"S0.0.10", "1.77"}],

Cell["\<\
\[FilledSmallSquare] Experimental support for symbolic \
optimization. \
\>", "Notes",
  CellTags->{"S0.0.10", "1.78"}],

Cell["\<\
\[FilledSmallSquare] Experimental support for real\[Hyphen]time \
value displays. \
\>", "Notes",
  CellTags->{"S0.0.10", "1.79"}],

Cell[TextData[{
  "\[FilledSmallSquare] Experimental support for ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]based remote file systems. "
}], "Notes",
  CellTags->{"S0.0.10", "1.80"}],

Cell["\<\
\[FilledSmallSquare] Experimental support for pop\[Hyphen]up \
palettes. \
\>", "Notes",
  CellTags->{"S0.0.10", "1.81"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.0.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}],
    Cell[1845, 56, 554, 12, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}],
    Cell[2402, 70, 335, 9, 70, "Text",
      CellTags->{"S0.0.1", "1.3"}]},
  "1.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}]},
  "1.2"->{
    Cell[1845, 56, 554, 12, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}]},
  "1.3"->{
    Cell[2402, 70, 335, 9, 70, "Text",
      CellTags->{"S0.0.1", "1.3"}]},
  "S0.0.2"->{
    Cell[2762, 83, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.4"}],
    Cell[2839, 86, 218, 5, 70, "Notes",
      CellTags->{"S0.0.2", "1.5"}],
    Cell[3060, 93, 172, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.6"}],
    Cell[3235, 99, 127, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.7"}],
    Cell[3365, 105, 163, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.8"}],
    Cell[3531, 111, 135, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.9"}],
    Cell[3669, 117, 129, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.10"}],
    Cell[3801, 123, 131, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.11"}],
    Cell[3935, 129, 174, 6, 70, "Notes",
      CellTags->{"S0.0.2", "1.12"}],
    Cell[4112, 137, 114, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.13"}]},
  "1.4"->{
    Cell[2762, 83, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.4"}]},
  "1.5"->{
    Cell[2839, 86, 218, 5, 70, "Notes",
      CellTags->{"S0.0.2", "1.5"}]},
  "1.6"->{
    Cell[3060, 93, 172, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.6"}]},
  "1.7"->{
    Cell[3235, 99, 127, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.7"}]},
  "1.8"->{
    Cell[3365, 105, 163, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.8"}]},
  "1.9"->{
    Cell[3531, 111, 135, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.9"}]},
  "1.10"->{
    Cell[3669, 117, 129, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.10"}]},
  "1.11"->{
    Cell[3801, 123, 131, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.11"}]},
  "1.12"->{
    Cell[3935, 129, 174, 6, 70, "Notes",
      CellTags->{"S0.0.2", "1.12"}]},
  "1.13"->{
    Cell[4112, 137, 114, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.13"}]},
  "S0.0.3"->{
    Cell[4263, 146, 75, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.14"}],
    Cell[4341, 149, 273, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.15"}],
    Cell[4617, 160, 120, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.16"}],
    Cell[4740, 166, 266, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.17"}],
    Cell[5009, 177, 133, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.18"}],
    Cell[5145, 183, 140, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.19"}],
    Cell[5288, 189, 121, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.20"}],
    Cell[5412, 195, 127, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.21"}],
    Cell[5542, 201, 111, 3, 70, "Notes",
      CellTags->{"S0.0.3", "1.22"}],
    Cell[5656, 206, 97, 1, 70, "Notes",
      CellTags->{"S0.0.3", "1.23"}]},
  "1.14"->{
    Cell[4263, 146, 75, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.14"}]},
  "1.15"->{
    Cell[4341, 149, 273, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.15"}]},
  "1.16"->{
    Cell[4617, 160, 120, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.16"}]},
  "1.17"->{
    Cell[4740, 166, 266, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.17"}]},
  "1.18"->{
    Cell[5009, 177, 133, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.18"}]},
  "1.19"->{
    Cell[5145, 183, 140, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.19"}]},
  "1.20"->{
    Cell[5288, 189, 121, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.20"}]},
  "1.21"->{
    Cell[5412, 195, 127, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.21"}]},
  "1.22"->{
    Cell[5542, 201, 111, 3, 70, "Notes",
      CellTags->{"S0.0.3", "1.22"}]},
  "1.23"->{
    Cell[5656, 206, 97, 1, 70, "Notes",
      CellTags->{"S0.0.3", "1.23"}]},
  "S0.0.4"->{
    Cell[5790, 212, 76, 1, 70, "Subsection",
      CellTags->{"S0.0.4", "1.24"}],
    Cell[5869, 215, 125, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.25"}],
    Cell[5997, 221, 88, 1, 70, "Notes",
      CellTags->{"S0.0.4", "1.26"}],
    Cell[6088, 224, 116, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.27"}],
    Cell[6207, 230, 125, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.28"}],
    Cell[6335, 236, 88, 1, 70, "Notes",
      CellTags->{"S0.0.4", "1.29"}],
    Cell[6426, 239, 111, 3, 70, "Notes",
      CellTags->{"S0.0.4", "1.30"}],
    Cell[6540, 244, 134, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.31"}],
    Cell[6677, 250, 330, 9, 70, "Notes",
      CellTags->{"S0.0.4", "1.32"}],
    Cell[7010, 261, 118, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.33"}],
    Cell[7131, 267, 118, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.34"}],
    Cell[7252, 273, 119, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.35"}]},
  "1.24"->{
    Cell[5790, 212, 76, 1, 70, "Subsection",
      CellTags->{"S0.0.4", "1.24"}]},
  "1.25"->{
    Cell[5869, 215, 125, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.25"}]},
  "1.26"->{
    Cell[5997, 221, 88, 1, 70, "Notes",
      CellTags->{"S0.0.4", "1.26"}]},
  "1.27"->{
    Cell[6088, 224, 116, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.27"}]},
  "1.28"->{
    Cell[6207, 230, 125, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.28"}]},
  "1.29"->{
    Cell[6335, 236, 88, 1, 70, "Notes",
      CellTags->{"S0.0.4", "1.29"}]},
  "1.30"->{
    Cell[6426, 239, 111, 3, 70, "Notes",
      CellTags->{"S0.0.4", "1.30"}]},
  "1.31"->{
    Cell[6540, 244, 134, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.31"}]},
  "1.32"->{
    Cell[6677, 250, 330, 9, 70, "Notes",
      CellTags->{"S0.0.4", "1.32"}]},
  "1.33"->{
    Cell[7010, 261, 118, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.33"}]},
  "1.34"->{
    Cell[7131, 267, 118, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.34"}]},
  "1.35"->{
    Cell[7252, 273, 119, 4, 70, "Notes",
      CellTags->{"S0.0.4", "1.35"}]},
  "S0.0.5"->{
    Cell[7408, 282, 72, 1, 70, "Subsection",
      CellTags->{"S0.0.5", "1.36"}],
    Cell[7483, 285, 129, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.37"}],
    Cell[7615, 291, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.38"}],
    Cell[7744, 297, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.39"}],
    Cell[7873, 303, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.40"}],
    Cell[8002, 309, 127, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.41"}],
    Cell[8132, 315, 151, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.42"}]},
  "1.36"->{
    Cell[7408, 282, 72, 1, 70, "Subsection",
      CellTags->{"S0.0.5", "1.36"}]},
  "1.37"->{
    Cell[7483, 285, 129, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.37"}]},
  "1.38"->{
    Cell[7615, 291, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.38"}]},
  "1.39"->{
    Cell[7744, 297, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.39"}]},
  "1.40"->{
    Cell[7873, 303, 126, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.40"}]},
  "1.41"->{
    Cell[8002, 309, 127, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.41"}]},
  "1.42"->{
    Cell[8132, 315, 151, 4, 70, "Notes",
      CellTags->{"S0.0.5", "1.42"}]},
  "S0.0.6"->{
    Cell[8320, 324, 81, 1, 70, "Subsection",
      CellTags->{"S0.0.6", "1.43"}],
    Cell[8404, 327, 323, 12, 70, "Notes",
      CellTags->{"S0.0.6", "1.44"}],
    Cell[8730, 341, 220, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.45"}],
    Cell[8953, 352, 190, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.46"}],
    Cell[9146, 360, 230, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.47"}],
    Cell[9379, 371, 293, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.48"}],
    Cell[9675, 382, 221, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.49"}],
    Cell[9899, 390, 184, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.50"}],
    Cell[10086, 398, 208, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.51"}],
    Cell[10297, 406, 187, 5, 70, "Notes",
      CellTags->{"S0.0.6", "1.52"}]},
  "1.43"->{
    Cell[8320, 324, 81, 1, 70, "Subsection",
      CellTags->{"S0.0.6", "1.43"}]},
  "1.44"->{
    Cell[8404, 327, 323, 12, 70, "Notes",
      CellTags->{"S0.0.6", "1.44"}]},
  "1.45"->{
    Cell[8730, 341, 220, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.45"}]},
  "1.46"->{
    Cell[8953, 352, 190, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.46"}]},
  "1.47"->{
    Cell[9146, 360, 230, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.47"}]},
  "1.48"->{
    Cell[9379, 371, 293, 9, 70, "Notes",
      CellTags->{"S0.0.6", "1.48"}]},
  "1.49"->{
    Cell[9675, 382, 221, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.49"}]},
  "1.50"->{
    Cell[9899, 390, 184, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.50"}]},
  "1.51"->{
    Cell[10086, 398, 208, 6, 70, "Notes",
      CellTags->{"S0.0.6", "1.51"}]},
  "1.52"->{
    Cell[10297, 406, 187, 5, 70, "Notes",
      CellTags->{"S0.0.6", "1.52"}]},
  "S0.0.7"->{
    Cell[10521, 416, 70, 1, 70, "Subsection",
      CellTags->{"S0.0.7", "1.53"}],
    Cell[10594, 419, 173, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.54"}],
    Cell[10770, 425, 154, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.55"}],
    Cell[10927, 431, 136, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.56"}],
    Cell[11066, 437, 165, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.57"}],
    Cell[11234, 443, 296, 9, 70, "Notes",
      CellTags->{"S0.0.7", "1.58"}],
    Cell[11533, 454, 146, 4, 24, "Notes",
      CellTags->{"S0.0.7", "1.59"}],
    Cell[11682, 460, 167, 5, 70, "Notes",
      CellTags->{"S0.0.7", "1.60"}],
    Cell[11852, 467, 185, 5, 24, "Notes",
      CellTags->{"S0.0.7", "1.61"}]},
  "1.53"->{
    Cell[10521, 416, 70, 1, 70, "Subsection",
      CellTags->{"S0.0.7", "1.53"}]},
  "1.54"->{
    Cell[10594, 419, 173, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.54"}]},
  "1.55"->{
    Cell[10770, 425, 154, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.55"}]},
  "1.56"->{
    Cell[10927, 431, 136, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.56"}]},
  "1.57"->{
    Cell[11066, 437, 165, 4, 70, "Notes",
      CellTags->{"S0.0.7", "1.57"}]},
  "1.58"->{
    Cell[11234, 443, 296, 9, 70, "Notes",
      CellTags->{"S0.0.7", "1.58"}]},
  "1.59"->{
    Cell[11533, 454, 146, 4, 24, "Notes",
      CellTags->{"S0.0.7", "1.59"}]},
  "1.60"->{
    Cell[11682, 460, 167, 5, 70, "Notes",
      CellTags->{"S0.0.7", "1.60"}]},
  "1.61"->{
    Cell[11852, 467, 185, 5, 24, "Notes",
      CellTags->{"S0.0.7", "1.61"}]},
  "S0.0.8"->{
    Cell[12074, 477, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.8", "1.62"}],
    Cell[12149, 480, 159, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.63"}],
    Cell[12311, 486, 134, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.64"}],
    Cell[12448, 492, 121, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.65"}],
    Cell[12572, 498, 98, 1, 24, "Notes",
      CellTags->{"S0.0.8", "1.66"}],
    Cell[12673, 501, 148, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.67"}],
    Cell[12824, 507, 127, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.68"}]},
  "1.62"->{
    Cell[12074, 477, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.8", "1.62"}]},
  "1.63"->{
    Cell[12149, 480, 159, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.63"}]},
  "1.64"->{
    Cell[12311, 486, 134, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.64"}]},
  "1.65"->{
    Cell[12448, 492, 121, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.65"}]},
  "1.66"->{
    Cell[12572, 498, 98, 1, 24, "Notes",
      CellTags->{"S0.0.8", "1.66"}]},
  "1.67"->{
    Cell[12673, 501, 148, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.67"}]},
  "1.68"->{
    Cell[12824, 507, 127, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.68"}]},
  "S0.0.9"->{
    Cell[12988, 516, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.9", "1.69"}],
    Cell[13061, 519, 127, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.70"}],
    Cell[13191, 525, 121, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.71"}],
    Cell[13315, 531, 115, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.72"}],
    Cell[13433, 537, 162, 5, 24, "Notes",
      CellTags->{"S0.0.9", "1.73"}],
    Cell[13598, 544, 149, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.74"}]},
  "1.69"->{
    Cell[12988, 516, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.9", "1.69"}]},
  "1.70"->{
    Cell[13061, 519, 127, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.70"}]},
  "1.71"->{
    Cell[13191, 525, 121, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.71"}]},
  "1.72"->{
    Cell[13315, 531, 115, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.72"}]},
  "1.73"->{
    Cell[13433, 537, 162, 5, 24, "Notes",
      CellTags->{"S0.0.9", "1.73"}]},
  "1.74"->{
    Cell[13598, 544, 149, 4, 24, "Notes",
      CellTags->{"S0.0.9", "1.74"}]},
  "S0.0.10"->{
    Cell[13784, 553, 104, 3, 38, "Subsection",
      CellTags->{"S0.0.10", "1.75"}],
    Cell[13891, 558, 123, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.76"}],
    Cell[14017, 564, 171, 4, 40, "Notes",
      CellTags->{"S0.0.10", "1.77"}],
    Cell[14191, 570, 129, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.78"}],
    Cell[14323, 576, 140, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.79"}],
    Cell[14466, 582, 184, 5, 24, "Notes",
      CellTags->{"S0.0.10", "1.80"}],
    Cell[14653, 589, 131, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.81"}]},
  "1.75"->{
    Cell[13784, 553, 104, 3, 38, "Subsection",
      CellTags->{"S0.0.10", "1.75"}]},
  "1.76"->{
    Cell[13891, 558, 123, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.76"}]},
  "1.77"->{
    Cell[14017, 564, 171, 4, 40, "Notes",
      CellTags->{"S0.0.10", "1.77"}]},
  "1.78"->{
    Cell[14191, 570, 129, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.78"}]},
  "1.79"->{
    Cell[14323, 576, 140, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.79"}]},
  "1.80"->{
    Cell[14466, 582, 184, 5, 24, "Notes",
      CellTags->{"S0.0.10", "1.80"}]},
  "1.81"->{
    Cell[14653, 589, 131, 4, 24, "Notes",
      CellTags->{"S0.0.10", "1.81"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.0.1", 15427, 613},
  {"1.1", 15667, 620},
  {"1.2", 15756, 623},
  {"1.3", 15844, 626},
  {"S0.0.2", 15934, 629},
  {"1.4", 16720, 650},
  {"1.5", 16812, 653},
  {"1.6", 16900, 656},
  {"1.7", 16988, 659},
  {"1.8", 17076, 662},
  {"1.9", 17165, 665},
  {"1.10", 17255, 668},
  {"1.11", 17346, 671},
  {"1.12", 17437, 674},
  {"1.13", 17528, 677},
  {"S0.0.3", 17621, 680},
  {"1.14", 18417, 701},
  {"1.15", 18512, 704},
  {"1.16", 18603, 707},
  {"1.17", 18694, 710},
  {"1.18", 18785, 713},
  {"1.19", 18876, 716},
  {"1.20", 18967, 719},
  {"1.21", 19058, 722},
  {"1.22", 19149, 725},
  {"1.23", 19240, 728},
  {"S0.0.4", 19332, 731},
  {"1.24", 20283, 756},
  {"1.25", 20378, 759},
  {"1.26", 20469, 762},
  {"1.27", 20559, 765},
  {"1.28", 20650, 768},
  {"1.29", 20741, 771},
  {"1.30", 20831, 774},
  {"1.31", 20922, 777},
  {"1.32", 21013, 780},
  {"1.33", 21104, 783},
  {"1.34", 21195, 786},
  {"1.35", 21286, 789},
  {"S0.0.5", 21379, 792},
  {"1.36", 21942, 807},
  {"1.37", 22037, 810},
  {"1.38", 22128, 813},
  {"1.39", 22219, 816},
  {"1.40", 22310, 819},
  {"1.41", 22401, 822},
  {"1.42", 22492, 825},
  {"S0.0.6", 22585, 828},
  {"1.43", 23385, 849},
  {"1.44", 23480, 852},
  {"1.45", 23572, 855},
  {"1.46", 23663, 858},
  {"1.47", 23754, 861},
  {"1.48", 23845, 864},
  {"1.49", 23936, 867},
  {"1.50", 24027, 870},
  {"1.51", 24118, 873},
  {"1.52", 24210, 876},
  {"S0.0.7", 24304, 879},
  {"1.53", 25032, 898},
  {"1.54", 25128, 901},
  {"1.55", 25220, 904},
  {"1.56", 25312, 907},
  {"1.57", 25404, 910},
  {"1.58", 25496, 913},
  {"1.59", 25588, 916},
  {"1.60", 25680, 919},
  {"1.61", 25772, 922},
  {"S0.0.8", 25866, 925},
  {"1.62", 26435, 940},
  {"1.63", 26531, 943},
  {"1.64", 26623, 946},
  {"1.65", 26715, 949},
  {"1.66", 26807, 952},
  {"1.67", 26898, 955},
  {"1.68", 26990, 958},
  {"S0.0.9", 27084, 961},
  {"1.69", 27575, 974},
  {"1.70", 27671, 977},
  {"1.71", 27763, 980},
  {"1.72", 27855, 983},
  {"1.73", 27947, 986},
  {"1.74", 28039, 989},
  {"S0.0.10", 28134, 992},
  {"1.75", 28712, 1007},
  {"1.76", 28810, 1010},
  {"1.77", 28903, 1013},
  {"1.78", 28996, 1016},
  {"1.79", 29089, 1019},
  {"1.80", 29182, 1022},
  {"1.81", 29275, 1025}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 66, 1, 65, "Section",
  CellTags->{"S0.0.1", "1.1"}],
Cell[1845, 56, 554, 12, 70, "Text",
  CellTags->{"S0.0.1", "1.2"}],
Cell[2402, 70, 335, 9, 70, "Text",
  CellTags->{"S0.0.1", "1.3"}],

Cell[CellGroupData[{
Cell[2762, 83, 74, 1, 70, "Subsection",
  CellTags->{"S0.0.2", "1.4"}],
Cell[2839, 86, 218, 5, 70, "Notes",
  CellTags->{"S0.0.2", "1.5"}],
Cell[3060, 93, 172, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.6"}],
Cell[3235, 99, 127, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.7"}],
Cell[3365, 105, 163, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.8"}],
Cell[3531, 111, 135, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.9"}],
Cell[3669, 117, 129, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.10"}],
Cell[3801, 123, 131, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.11"}],
Cell[3935, 129, 174, 6, 70, "Notes",
  CellTags->{"S0.0.2", "1.12"}],
Cell[4112, 137, 114, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4263, 146, 75, 1, 70, "Subsection",
  CellTags->{"S0.0.3", "1.14"}],
Cell[4341, 149, 273, 9, 70, "Notes",
  CellTags->{"S0.0.3", "1.15"}],
Cell[4617, 160, 120, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.16"}],
Cell[4740, 166, 266, 9, 70, "Notes",
  CellTags->{"S0.0.3", "1.17"}],
Cell[5009, 177, 133, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.18"}],
Cell[5145, 183, 140, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.19"}],
Cell[5288, 189, 121, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.20"}],
Cell[5412, 195, 127, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.21"}],
Cell[5542, 201, 111, 3, 70, "Notes",
  CellTags->{"S0.0.3", "1.22"}],
Cell[5656, 206, 97, 1, 70, "Notes",
  CellTags->{"S0.0.3", "1.23"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5790, 212, 76, 1, 70, "Subsection",
  CellTags->{"S0.0.4", "1.24"}],
Cell[5869, 215, 125, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.25"}],
Cell[5997, 221, 88, 1, 70, "Notes",
  CellTags->{"S0.0.4", "1.26"}],
Cell[6088, 224, 116, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.27"}],
Cell[6207, 230, 125, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.28"}],
Cell[6335, 236, 88, 1, 70, "Notes",
  CellTags->{"S0.0.4", "1.29"}],
Cell[6426, 239, 111, 3, 70, "Notes",
  CellTags->{"S0.0.4", "1.30"}],
Cell[6540, 244, 134, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.31"}],
Cell[6677, 250, 330, 9, 70, "Notes",
  CellTags->{"S0.0.4", "1.32"}],
Cell[7010, 261, 118, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.33"}],
Cell[7131, 267, 118, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.34"}],
Cell[7252, 273, 119, 4, 70, "Notes",
  CellTags->{"S0.0.4", "1.35"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7408, 282, 72, 1, 70, "Subsection",
  CellTags->{"S0.0.5", "1.36"}],
Cell[7483, 285, 129, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.37"}],
Cell[7615, 291, 126, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.38"}],
Cell[7744, 297, 126, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.39"}],
Cell[7873, 303, 126, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.40"}],
Cell[8002, 309, 127, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.41"}],
Cell[8132, 315, 151, 4, 70, "Notes",
  CellTags->{"S0.0.5", "1.42"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8320, 324, 81, 1, 70, "Subsection",
  CellTags->{"S0.0.6", "1.43"}],
Cell[8404, 327, 323, 12, 70, "Notes",
  CellTags->{"S0.0.6", "1.44"}],
Cell[8730, 341, 220, 9, 70, "Notes",
  CellTags->{"S0.0.6", "1.45"}],
Cell[8953, 352, 190, 6, 70, "Notes",
  CellTags->{"S0.0.6", "1.46"}],
Cell[9146, 360, 230, 9, 70, "Notes",
  CellTags->{"S0.0.6", "1.47"}],
Cell[9379, 371, 293, 9, 70, "Notes",
  CellTags->{"S0.0.6", "1.48"}],
Cell[9675, 382, 221, 6, 70, "Notes",
  CellTags->{"S0.0.6", "1.49"}],
Cell[9899, 390, 184, 6, 70, "Notes",
  CellTags->{"S0.0.6", "1.50"}],
Cell[10086, 398, 208, 6, 70, "Notes",
  CellTags->{"S0.0.6", "1.51"}],
Cell[10297, 406, 187, 5, 70, "Notes",
  CellTags->{"S0.0.6", "1.52"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10521, 416, 70, 1, 70, "Subsection",
  CellTags->{"S0.0.7", "1.53"}],
Cell[10594, 419, 173, 4, 70, "Notes",
  CellTags->{"S0.0.7", "1.54"}],
Cell[10770, 425, 154, 4, 70, "Notes",
  CellTags->{"S0.0.7", "1.55"}],
Cell[10927, 431, 136, 4, 70, "Notes",
  CellTags->{"S0.0.7", "1.56"}],
Cell[11066, 437, 165, 4, 70, "Notes",
  CellTags->{"S0.0.7", "1.57"}],
Cell[11234, 443, 296, 9, 70, "Notes",
  CellTags->{"S0.0.7", "1.58"}],
Cell[11533, 454, 146, 4, 24, "Notes",
  CellTags->{"S0.0.7", "1.59"}],
Cell[11682, 460, 167, 5, 70, "Notes",
  CellTags->{"S0.0.7", "1.60"}],
Cell[11852, 467, 185, 5, 24, "Notes",
  CellTags->{"S0.0.7", "1.61"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12074, 477, 72, 1, 38, "Subsection",
  CellTags->{"S0.0.8", "1.62"}],
Cell[12149, 480, 159, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.63"}],
Cell[12311, 486, 134, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.64"}],
Cell[12448, 492, 121, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.65"}],
Cell[12572, 498, 98, 1, 24, "Notes",
  CellTags->{"S0.0.8", "1.66"}],
Cell[12673, 501, 148, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.67"}],
Cell[12824, 507, 127, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.68"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12988, 516, 70, 1, 38, "Subsection",
  CellTags->{"S0.0.9", "1.69"}],
Cell[13061, 519, 127, 4, 24, "Notes",
  CellTags->{"S0.0.9", "1.70"}],
Cell[13191, 525, 121, 4, 24, "Notes",
  CellTags->{"S0.0.9", "1.71"}],
Cell[13315, 531, 115, 4, 24, "Notes",
  CellTags->{"S0.0.9", "1.72"}],
Cell[13433, 537, 162, 5, 24, "Notes",
  CellTags->{"S0.0.9", "1.73"}],
Cell[13598, 544, 149, 4, 24, "Notes",
  CellTags->{"S0.0.9", "1.74"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13784, 553, 104, 3, 38, "Subsection",
  CellTags->{"S0.0.10", "1.75"}],
Cell[13891, 558, 123, 4, 24, "Notes",
  CellTags->{"S0.0.10", "1.76"}],
Cell[14017, 564, 171, 4, 40, "Notes",
  CellTags->{"S0.0.10", "1.77"}],
Cell[14191, 570, 129, 4, 24, "Notes",
  CellTags->{"S0.0.10", "1.78"}],
Cell[14323, 576, 140, 4, 24, "Notes",
  CellTags->{"S0.0.10", "1.79"}],
Cell[14466, 582, 184, 5, 24, "Notes",
  CellTags->{"S0.0.10", "1.80"}],
Cell[14653, 589, 131, 4, 24, "Notes",
  CellTags->{"S0.0.10", "1.81"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

