(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6788,        270]*)
(*NotebookOutlinePosition[     13951,        503]*)
(*  CellTagsIndexPosition[     12957,        458]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New in Version 4.1", "Section",
  CellTags->{"S0.0.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " Version 4.1 extends capabilities and increases speed of several important \
numeric and symbolic functions. It also includes some system, language and \
interface enhancements. "
}], "Text",
  CellTags->{"S0.0.1", "1.2"}],

Cell[CellGroupData[{

Cell["Numerical Computation", "Subsection",
  CellTags->{"S0.0.2", "1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Automatic common subexpression elimination and \
register allocation optimization in ",
  StyleBox["Mathematica", "TI"],
  " expression compilation. "
}], "Notes",
  CellTags->{"S0.0.2", "1.4"}],

Cell["\<\
\[FilledSmallSquare] Optimized handling of sparse linear equations. \
\
\>", "Notes",
  CellTags->{"S0.0.2", "1.5"}],

Cell["\<\
\[FilledSmallSquare] Faster high\[Hyphen]precision evaluation of \
polynomial roots. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.6"}],

Cell["\<\
\[FilledSmallSquare] Faster evaluation of long continued fraction \
sequences. \
\>", "Notes",
  CellTags->{"S0.0.2", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic Computation", "Subsection",
  CellTags->{"S0.0.3", "1.8"}],

Cell["\<\
\[FilledSmallSquare] Greatly enhanced symbolic differential \
equation solving. \
\>", "Notes",
  CellTags->{"S0.0.3", "1.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] Faster multivariate ",
  ButtonBox["PolynomialGCD",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Together",
    ButtonStyle->"RefGuideLink"],
  " and related algebraic functions. "
}], "Notes",
  CellTags->{"S0.0.3", "1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] 85 new rules added for ",
  ButtonBox["Simplify",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FullSimplify",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.0.3", "1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] Optimized ",
  ButtonBox["Expand",
    ButtonStyle->"RefGuideLink"],
  " in cases where many terms cancel. "
}], "Notes",
  CellTags->{"S0.0.3", "1.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics and Sound", "Subsection",
  CellTags->{"S0.0.4", "1.13"}],

Cell["\<\
\[FilledSmallSquare] Enhanced support for extended character sets \
in graphics output. \
\>", "Notes",
  CellTags->{"S0.0.4", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programming and Core System", "Subsection",
  CellTags->{"S0.0.5", "1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Ordering",
    ButtonStyle->"RefGuideLink"],
  " for finding rankings of elements in lists. "
}], "Notes",
  CellTags->{"S0.0.5", "1.16"}],

Cell["\<\
\[FilledSmallSquare] Built\[Hyphen]in support for Nand and Nor. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.17"}],

Cell["\<\
\[FilledSmallSquare] Optimized pattern matching in packed arrays. \
\
\>", "Notes",
  CellTags->{"S0.0.5", "1.18"}],

Cell["\<\
\[FilledSmallSquare] Faster handling of multiple repeated patterns \
in pattern matching. \
\>", "Notes",
  CellTags->{"S0.0.5", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input and Output", "Subsection",
  CellTags->{"S0.0.6", "1.20"}],

Cell["\<\
\[FilledSmallSquare] Support for UTF\[Hyphen]8 character encoding. \
\
\>", "Notes",
  CellTags->{"S0.0.6", "1.21"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Interface", "Subsection",
  CellTags->{"S0.0.7", "1.22"}],

Cell["\<\
\[FilledSmallSquare] Automatic palette presentation of help on \
objects. \
\>", "Notes",
  CellTags->{"S0.0.7", "1.23"}],

Cell[TextData[{
  "\[FilledSmallSquare] New logical operators ",
  Cell[BoxData[
      \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
  ". "
}], "Notes",
  CellTags->{"S0.0.7", "1.24"}],

Cell[TextData[{
  "\[FilledSmallSquare] More ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  " formats for functions. "
}], "Notes",
  CellTags->{"S0.0.7", "1.25"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Interface", "Subsection",
  CellTags->{"S0.0.8", "1.26"}],

Cell["\<\
\[FilledSmallSquare] Support for generating and reading MathML for \
web applications. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.27"}],

Cell["\<\
\[FilledSmallSquare] Import and export of CSV spreadsheet files. \
\
\>", "Notes",
  CellTags->{"S0.0.8", "1.28"}],

Cell["\<\
\[FilledSmallSquare] Import and export of DXF and STL 3D data. \
\
\>", "Notes",
  CellTags->{"S0.0.8", "1.29"}],

Cell["\<\
\[FilledSmallSquare] Faster import of tabular data. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.30"}],

Cell["\<\
\[FilledSmallSquare] Import and export of BMP supports \
run\[Hyphen]length encoding compression. \
\>", "Notes",
  CellTags->{"S0.0.8", "1.31"}],

Cell["\<\
\[FilledSmallSquare] Shift\[Hyphen]close shortcut for window \
closing (Windows). \
\>", "Notes",
  CellTags->{"S0.0.8", "1.32"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{200, Automatic}, {Automatic, 59}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.0.1"->{
    Cell[1776, 53, 68, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}],
    Cell[1847, 56, 274, 6, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}]},
  "1.1"->{
    Cell[1776, 53, 68, 1, 65, "Section",
      CellTags->{"S0.0.1", "1.1"}]},
  "1.2"->{
    Cell[1847, 56, 274, 6, 70, "Text",
      CellTags->{"S0.0.1", "1.2"}]},
  "S0.0.2"->{
    Cell[2146, 66, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.3"}],
    Cell[2223, 69, 234, 6, 70, "Notes",
      CellTags->{"S0.0.2", "1.4"}],
    Cell[2460, 77, 126, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.5"}],
    Cell[2589, 83, 141, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.6"}],
    Cell[2733, 89, 135, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.7"}]},
  "1.3"->{
    Cell[2146, 66, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.2", "1.3"}]},
  "1.4"->{
    Cell[2223, 69, 234, 6, 70, "Notes",
      CellTags->{"S0.0.2", "1.4"}]},
  "1.5"->{
    Cell[2460, 77, 126, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.5"}]},
  "1.6"->{
    Cell[2589, 83, 141, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.6"}]},
  "1.7"->{
    Cell[2733, 89, 135, 4, 70, "Notes",
      CellTags->{"S0.0.2", "1.7"}]},
  "S0.0.3"->{
    Cell[2905, 98, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.8"}],
    Cell[2982, 101, 136, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.9"}],
    Cell[3121, 107, 275, 9, 24, "Notes",
      CellTags->{"S0.0.3", "1.10"}],
    Cell[3399, 118, 248, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.11"}],
    Cell[3650, 129, 193, 6, 24, "Notes",
      CellTags->{"S0.0.3", "1.12"}]},
  "1.8"->{
    Cell[2905, 98, 74, 1, 70, "Subsection",
      CellTags->{"S0.0.3", "1.8"}]},
  "1.9"->{
    Cell[2982, 101, 136, 4, 70, "Notes",
      CellTags->{"S0.0.3", "1.9"}]},
  "1.10"->{
    Cell[3121, 107, 275, 9, 24, "Notes",
      CellTags->{"S0.0.3", "1.10"}]},
  "1.11"->{
    Cell[3399, 118, 248, 9, 70, "Notes",
      CellTags->{"S0.0.3", "1.11"}]},
  "1.12"->{
    Cell[3650, 129, 193, 6, 24, "Notes",
      CellTags->{"S0.0.3", "1.12"}]},
  "S0.0.4"->{
    Cell[3880, 140, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.4", "1.13"}],
    Cell[3955, 143, 145, 4, 24, "Notes",
      CellTags->{"S0.0.4", "1.14"}]},
  "1.13"->{
    Cell[3880, 140, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.4", "1.13"}]},
  "1.14"->{
    Cell[3955, 143, 145, 4, 24, "Notes",
      CellTags->{"S0.0.4", "1.14"}]},
  "S0.0.5"->{
    Cell[4137, 152, 81, 1, 38, "Subsection",
      CellTags->{"S0.0.5", "1.15"}],
    Cell[4221, 155, 194, 6, 24, "Notes",
      CellTags->{"S0.0.5", "1.16"}],
    Cell[4418, 163, 123, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.17"}],
    Cell[4544, 169, 125, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.18"}],
    Cell[4672, 175, 147, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.19"}]},
  "1.15"->{
    Cell[4137, 152, 81, 1, 38, "Subsection",
      CellTags->{"S0.0.5", "1.15"}]},
  "1.16"->{
    Cell[4221, 155, 194, 6, 24, "Notes",
      CellTags->{"S0.0.5", "1.16"}]},
  "1.17"->{
    Cell[4418, 163, 123, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.17"}]},
  "1.18"->{
    Cell[4544, 169, 125, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.18"}]},
  "1.19"->{
    Cell[4672, 175, 147, 4, 24, "Notes",
      CellTags->{"S0.0.5", "1.19"}]},
  "S0.0.6"->{
    Cell[4856, 184, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.6", "1.20"}],
    Cell[4929, 187, 126, 4, 24, "Notes",
      CellTags->{"S0.0.6", "1.21"}]},
  "1.20"->{
    Cell[4856, 184, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.6", "1.20"}]},
  "1.21"->{
    Cell[4929, 187, 126, 4, 24, "Notes",
      CellTags->{"S0.0.6", "1.21"}]},
  "S0.0.7"->{
    Cell[5092, 196, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.7", "1.22"}],
    Cell[5167, 199, 131, 4, 24, "Notes",
      CellTags->{"S0.0.7", "1.23"}],
    Cell[5301, 205, 352, 12, 24, "Notes",
      CellTags->{"S0.0.7", "1.24"}],
    Cell[5656, 219, 186, 6, 24, "Notes",
      CellTags->{"S0.0.7", "1.25"}]},
  "1.22"->{
    Cell[5092, 196, 72, 1, 38, "Subsection",
      CellTags->{"S0.0.7", "1.22"}]},
  "1.23"->{
    Cell[5167, 199, 131, 4, 24, "Notes",
      CellTags->{"S0.0.7", "1.23"}]},
  "1.24"->{
    Cell[5301, 205, 352, 12, 24, "Notes",
      CellTags->{"S0.0.7", "1.24"}]},
  "1.25"->{
    Cell[5656, 219, 186, 6, 24, "Notes",
      CellTags->{"S0.0.7", "1.25"}]},
  "S0.0.8"->{
    Cell[5879, 230, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.8", "1.26"}],
    Cell[5952, 233, 144, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.27"}],
    Cell[6099, 239, 124, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.28"}],
    Cell[6226, 245, 122, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.29"}],
    Cell[6351, 251, 109, 3, 24, "Notes",
      CellTags->{"S0.0.8", "1.30"}],
    Cell[6463, 256, 155, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.31"}],
    Cell[6621, 262, 139, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.32"}]},
  "1.26"->{
    Cell[5879, 230, 70, 1, 38, "Subsection",
      CellTags->{"S0.0.8", "1.26"}]},
  "1.27"->{
    Cell[5952, 233, 144, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.27"}]},
  "1.28"->{
    Cell[6099, 239, 124, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.28"}]},
  "1.29"->{
    Cell[6226, 245, 122, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.29"}]},
  "1.30"->{
    Cell[6351, 251, 109, 3, 24, "Notes",
      CellTags->{"S0.0.8", "1.30"}]},
  "1.31"->{
    Cell[6463, 256, 155, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.31"}]},
  "1.32"->{
    Cell[6621, 262, 139, 4, 24, "Notes",
      CellTags->{"S0.0.8", "1.32"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.0.1", 7403, 286},
  {"1.1", 7567, 291},
  {"1.2", 7656, 294},
  {"S0.0.2", 7746, 297},
  {"1.3", 8142, 308},
  {"1.4", 8234, 311},
  {"1.5", 8322, 314},
  {"1.6", 8410, 317},
  {"1.7", 8498, 320},
  {"S0.0.3", 8589, 323},
  {"1.8", 8992, 334},
  {"1.9", 9084, 337},
  {"1.10", 9174, 340},
  {"1.11", 9265, 343},
  {"1.12", 9356, 346},
  {"S0.0.4", 9449, 349},
  {"1.13", 9622, 354},
  {"1.14", 9717, 357},
  {"S0.0.5", 9810, 360},
  {"1.15", 10217, 371},
  {"1.16", 10312, 374},
  {"1.17", 10403, 377},
  {"1.18", 10494, 380},
  {"1.19", 10585, 383},
  {"S0.0.6", 10678, 386},
  {"1.20", 10851, 391},
  {"1.21", 10946, 394},
  {"S0.0.7", 11039, 397},
  {"1.22", 11369, 406},
  {"1.23", 11464, 409},
  {"1.24", 11555, 412},
  {"1.25", 11647, 415},
  {"S0.0.8", 11740, 418},
  {"1.26", 12303, 433},
  {"1.27", 12398, 436},
  {"1.28", 12489, 439},
  {"1.29", 12580, 442},
  {"1.30", 12671, 445},
  {"1.31", 12762, 448},
  {"1.32", 12853, 451}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 68, 1, 65, "Section",
  CellTags->{"S0.0.1", "1.1"}],
Cell[1847, 56, 274, 6, 70, "Text",
  CellTags->{"S0.0.1", "1.2"}],

Cell[CellGroupData[{
Cell[2146, 66, 74, 1, 70, "Subsection",
  CellTags->{"S0.0.2", "1.3"}],
Cell[2223, 69, 234, 6, 70, "Notes",
  CellTags->{"S0.0.2", "1.4"}],
Cell[2460, 77, 126, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.5"}],
Cell[2589, 83, 141, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.6"}],
Cell[2733, 89, 135, 4, 70, "Notes",
  CellTags->{"S0.0.2", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2905, 98, 74, 1, 70, "Subsection",
  CellTags->{"S0.0.3", "1.8"}],
Cell[2982, 101, 136, 4, 70, "Notes",
  CellTags->{"S0.0.3", "1.9"}],
Cell[3121, 107, 275, 9, 24, "Notes",
  CellTags->{"S0.0.3", "1.10"}],
Cell[3399, 118, 248, 9, 70, "Notes",
  CellTags->{"S0.0.3", "1.11"}],
Cell[3650, 129, 193, 6, 24, "Notes",
  CellTags->{"S0.0.3", "1.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3880, 140, 72, 1, 38, "Subsection",
  CellTags->{"S0.0.4", "1.13"}],
Cell[3955, 143, 145, 4, 24, "Notes",
  CellTags->{"S0.0.4", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4137, 152, 81, 1, 38, "Subsection",
  CellTags->{"S0.0.5", "1.15"}],
Cell[4221, 155, 194, 6, 24, "Notes",
  CellTags->{"S0.0.5", "1.16"}],
Cell[4418, 163, 123, 4, 24, "Notes",
  CellTags->{"S0.0.5", "1.17"}],
Cell[4544, 169, 125, 4, 24, "Notes",
  CellTags->{"S0.0.5", "1.18"}],
Cell[4672, 175, 147, 4, 24, "Notes",
  CellTags->{"S0.0.5", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4856, 184, 70, 1, 38, "Subsection",
  CellTags->{"S0.0.6", "1.20"}],
Cell[4929, 187, 126, 4, 24, "Notes",
  CellTags->{"S0.0.6", "1.21"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5092, 196, 72, 1, 38, "Subsection",
  CellTags->{"S0.0.7", "1.22"}],
Cell[5167, 199, 131, 4, 24, "Notes",
  CellTags->{"S0.0.7", "1.23"}],
Cell[5301, 205, 352, 12, 24, "Notes",
  CellTags->{"S0.0.7", "1.24"}],
Cell[5656, 219, 186, 6, 24, "Notes",
  CellTags->{"S0.0.7", "1.25"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5879, 230, 70, 1, 38, "Subsection",
  CellTags->{"S0.0.8", "1.26"}],
Cell[5952, 233, 144, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.27"}],
Cell[6099, 239, 124, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.28"}],
Cell[6226, 245, 122, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.29"}],
Cell[6351, 251, 109, 3, 24, "Notes",
  CellTags->{"S0.0.8", "1.30"}],
Cell[6463, 256, 155, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.31"}],
Cell[6621, 262, 139, 4, 24, "Notes",
  CellTags->{"S0.0.8", "1.32"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

