(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3334708,      53077]*)
(*NotebookOutlinePosition[   3522528,      58093]*)
(*  CellTagsIndexPosition[   3507353,      57584]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["DatabaseLink",
  FontSlant->"Italic"]], "Title"],

Cell["\<\
Version 1.0
January 2005\
\>", "Subtitle"],

Cell[TextData[{
  "Copyright \[Copyright] 1999-2005 Wolfram Research, Inc. All rights \
reserved.\n",
  StyleBox["Mathematica", "TI"],
  " is a registered trademark of Wolfram Research, Inc.\nJava is a trademark \
of Sun Microsystems, Inc.\nAll other trademarks used herein are the property \
of their respective owners."
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"xref:1", "c:1"}],

Cell[CellGroupData[{

Cell["Background", "Subsection",
  CellTags->{"xref:2", "c:2", "i:42", "b:0.0"}],

Cell["\<\
Data storage, indexing, and retrieval have long been crucial tasks of many \
large organizations such as governments, banks, hospitals, and libraries. As \
human societies have grown increasingly complex, data management requirements \
have also increased. Some of the new challenges include the complexity of \
what the data represents, how the data is used, as well as the sheer volume \
of data. Since the development of modern electronic computers in the latter \
half of the twentieth century, tools such as relational database management \
systems (RDBMS) and the Structured Query Language (SQL) have become standards \
that are widely used for data handling in many different types of \
organization.\
\>", "Text",
  CellTags->"b:0.0"],

Cell["\<\
In a typical organization, many different users need to access the data \
management system, and hence many database applications are server-based. \
They can be combined with other server-based technologies, often called \
enterprise technologies, such as web servers, web services, as well as remote \
computing heterogeneous architectures.\
\>", "Text",
  CellTags->"b:0.0"],

Cell["\<\
At the current time, there are many different database systems. These range \
from large-scale, expensive commercial applications that are suitable for \
high-end uses, to freely available open-source tools running on personal \
computers with operating systems such as Microsoft Windows or Linux.\
\>", "Text",
  CellTags->"b:0.0"],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \[RegisteredTrademark]",
  " application that provides a set of tools allowing convenient integration \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with database management systems."
}], "Text",
  CellTags->"b:0.0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Database ",
  "Applications"
}], "Subsection",
  CellTags->{"xref:2", "c:3", "b:0.1"}],

Cell[TextData[{
  "There are a number of important benefits that can be gained from \
integrating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " into a database system."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a large collection of functions for numerical and symbolic \
computation that can be applied to data taken from a database. After the \
computations have been completed, their results can be stored in a database \
application, allowing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to work on the results at a later time. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " might be used for statistical processing, modelling, or computing some \
optimal configuration. All of these computations typically require and \
produce data that can conveniently be stored in a database application."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "Database applications can be integrated with many other application types, \
providing an important form of interoperability. Data derived from one \
application can be stored in the database. Then, elements of this data can be \
retrieved by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", used for computation, and the results stored in the database. Finally, \
another application can extract these results and use them for some further \
purpose. The central database application is the hub of this computational \
network; its interaction with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " made possible by ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:0.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Features of ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{"xref:3", "c:4", "b:0.2"}],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " provides the following features."
}], "Text",
  CellTags->"b:0.2"],

Cell["\<\
Connectivity\[ThinSpace]\[Dash]\[ThinSpace]works with most standard SQL \
database applications and with databases that are local and network based \
(including different types of computers).\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
Supplied drivers\[ThinSpace]\[Dash]\[ThinSpace]built-in support for many \
important databases, including MySQL, Open Database Connectivity (ODBC), and \
HSQL Database Engine (HSQLDB).\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
The HSQL Database Engine (HSQLDB)\[ThinSpace]\[Dash]\[ThinSpace]a lightweight \
database useful for database applications if you don't have an existing \
database.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
SQL command interface\[ThinSpace]\[Dash]\[ThinSpace]you can exploit your \
knowledge of SQL without learning a new system.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command interface\[ThinSpace]\[Dash]\[ThinSpace]useful if you are \
familiar with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming."
}], "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
GUI interfaces\[ThinSpace]\[Dash]\[ThinSpace]the Database Explorer and the \
Connection Tool provide convenient tools for opening connections and querying \
the database.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
Access to data and metadata\[ThinSpace]\[Dash]\[ThinSpace]you can inspect the \
names of tables and columns, as well as the data in each entry.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell[TextData[{
  "Configurable\[ThinSpace]\[Dash]\[ThinSpace]common tasks can be simplified \
and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications can add their own database information."
}], "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
Batch support\[ThinSpace]\[Dash]\[ThinSpace]provides efficiency when making \
repeated changes to a database.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell[TextData[{
  "Data type support\[ThinSpace]\[Dash]\[ThinSpace]works with standard SQL \
data types, including numbers, strings, binary data, date and time, as well \
as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions."
}], "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
Support for advanced features\[ThinSpace]\[Dash]\[ThinSpace]such as multiple \
connections and transactions (including rollbacks and savepoints).\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"],

Cell["\<\
Secure Socket Layer (SSL) support\[ThinSpace]\[Dash]\[ThinSpace]security for \
communications with the database.\
\>", "BulletedList",
  CellDingbat->None,
  CellTags->"b:0.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " Technology"
}], "Subsection",
  CellTags->{"xref:4", "c:5", "b:0.3"}],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " is based on the commonly used Java database connectivity (JDBC) \
technology, ",
  StyleBox[ButtonBox["http://java.sun.com/products/jdbc/",
    ButtonData:>{
      URL[ "http://java.sun.com/products/jdbc/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ". The package makes extensive use of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Java toolkit ",
  StyleBox["J/Link", "TI"],
  " ",
  StyleBox[ButtonBox["http://www.wolfram.com/solutions/mathlink/jlink/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink/jlink/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ", though no Java programming is required. The Database Explorer uses the \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphical user interface toolkit ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  ", ",
  StyleBox[ButtonBox["http://www.wolfram.com/solutions/guikit",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/guikit"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " comes with a selection of drivers for a number of databases. If it does \
not include a driver for your database, you can install your own driver, as \
described in the ",
  ButtonBox["JDBC Connections",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:0.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Started", "Section",
  CellTags->{"xref:6", "c:7"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"xref:8", "c:8", "b:1.0"}],

Cell[TextData[{
  "This section contains simple examples of ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " that give an overview of its functionality and ideas of how to get \
started. It will use a lightweight database, HSQLDB, that is installed as \
part of ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  ". This allows you to try examples in the documentation without having to \
install your own database. The other sections of the documentation gives \
detailed reference information."
}], "Text",
  CellTags->"b:1.0"],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " provides two styles of interface for working with a database. A command \
line interface, which is more flexible and is useful for using database \
commands inside programs, and a graphical interface, which is simpler to use. \
Both interfaces are discussed in this section."
}], "Text",
  CellTags->"b:1.0"],

Cell[TextData[{
  "When you have finished trying these examples, you may wish to restore the \
example database, by using the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:1.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Command Line Interface", "Subsection",
  CellTags->{"xref:133", "c:9"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"xref:144", "b:1.1.0"}],

Cell[TextData[{
  "The command line interface is a powerful and flexible interface that is \
particularly appropriate if you want to write programs that use database \
functionality. This section discusses a number of different operations that \
use a demonstration database. If you find that these examples do not work as \
shown here, you may need to restore the database to its original state with \
the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:1.1.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Loading the Package", "Subsubsection",
  CellTags->{"xref:7", "c:10", "b:1.1.1"}],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " add-on application. Before any functions from the package can be used, it \
must be loaded as follows."
}], "Text",
  CellTags->"b:1.1.1"],

Cell[BoxData[
    \(Needs["\<DatabaseLink`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Connecting to the Database", "Subsubsection",
  CellTags->{"xref:9", "c:11", "b:1.1.2"}],

Cell[TextData[{
  "The details of connecting to a database are described in the ",
  ButtonBox["Database Connections ",
    ButtonData:>{"DatabaseLink2.0", "xref:134"},
    ButtonStyle->"AddOnsLinkText"],
  "section. The command line method uses the function ",
  StyleBox["OpenSQLConnection", "MR"],
  ", which returns a handle that can be used to work with a database. The \
following opens a connection to an included sample database. If you find that \
this does not work as shown, you may need to install or restore the example \
database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conn = OpenSQLConnection["\<demo\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \(SQLConnection["demo", 1, "Open", "<>"]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.1.2"]
}, Closed]],

Cell[TextData[{
  "There is also a GUI method to connect to the database that is invoked by \
executing ",
  StyleBox["OpenSQLConnection[]", "MR"],
  ". When this is done, the Connection Tool appears; at this point a \
connection must be opened or the tool cancelled before operations can \
continue."
}], "Text",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \(conn1\  = \ OpenSQLConnection[]; \)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "You can use the selection tool to connect to the ",
  StyleBox["example", "MR"],
  " database. More information on how to open a connection to a database is \
provided in the ",
  ButtonBox["Database Connections",
    ButtonData:>{"DatabaseLink2.0", "xref:134"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:1.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Fetching Data", "Subsubsection",
  CellTags->{"xref:10", "c:12", "b:1.1.3"}],

Cell["\<\
A relational database consists of a set of tables; each table contains data \
in various categories (typically called columns). Each row of a table \
contains data values for the different categories. The database application \
provides functions for managing this data by supporting features such as \
querying, inserting, updating, or dropping data.\
\>", "Text",
  CellTags->"b:1.1.3"],

Cell[TextData[{
  "Tables are fundamental to relational databases, and it is important to \
have a convenient way to list them. You can do this with the ",
  StyleBox["SQLTables", "MR"],
  " command as follows."
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.1.3"],

Cell[BoxData[
    \({SQLTable["SAMPLETABLE1", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  "You can see information on the specific columns in a table with the ",
  StyleBox["SQLColumns", "MR"],
  " command. An example that provides information on the columns in the ",
  StyleBox["SAMPLETABLE1", "TI"],
  " table follows."
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumns[conn, \ "\<SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:1.1.3"],

Cell[BoxData[
    \({SQLColumn[{"SAMPLETABLE1", "ENTRY"}, "DataTypeName" \[Rule] "INTEGER", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "VALUE"}, "DataTypeName" \[Rule] "DOUBLE", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "NAME"}, "DataTypeName" \[Rule] "VARCHAR", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 2147483647]}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  "You can retrieve the data in the ",
  StyleBox["SAMPLETABLE1", "TI"],
  " table by executing an ",
  StyleBox["SQLSelect", "MR"],
  " command as follows. "
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = SQLSelect[\ \ conn, "\<SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:1.1.3"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}, {3, 7.2`, "Day3"}, {4, 6.2`, 
        "Day4"}, {5, 6.`, "Day5"}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  "The result of the database query is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list, which can be used in any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command. In the following example the last element of each row is \
plotted."
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[data[\([\)\(All, 2\)\(]\)], 
      PlotJoined \[Rule] True]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:1.1.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.214286 0.238095 -2.0454 0.367877 [
[.2619 .14937 -3 -9 ]
[.2619 .14937 3 0 ]
[.5 .14937 -3 -9 ]
[.5 .14937 3 0 ]
[.7381 .14937 -3 -9 ]
[.7381 .14937 3 0 ]
[.97619 .14937 -3 -9 ]
[.97619 .14937 3 0 ]
[.01131 .0699 -24 -4.5 ]
[.01131 .0699 0 4.5 ]
[.01131 .25384 -24 -4.5 ]
[.01131 .25384 0 4.5 ]
[.01131 .3458 -18 -4.5 ]
[.01131 .3458 0 4.5 ]
[.01131 .43777 -24 -4.5 ]
[.01131 .43777 0 4.5 ]
[.01131 .52974 -6 -4.5 ]
[.01131 .52974 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .16187 m
.2619 .16812 L
s
[(2)] .2619 .14937 0 1 Mshowa
.5 .16187 m
.5 .16812 L
s
[(3)] .5 .14937 0 1 Mshowa
.7381 .16187 m
.7381 .16812 L
s
[(4)] .7381 .14937 0 1 Mshowa
.97619 .16187 m
.97619 .16812 L
s
[(5)] .97619 .14937 0 1 Mshowa
.125 Mabswid
.07143 .16187 m
.07143 .16562 L
s
.11905 .16187 m
.11905 .16562 L
s
.16667 .16187 m
.16667 .16562 L
s
.21429 .16187 m
.21429 .16562 L
s
.30952 .16187 m
.30952 .16562 L
s
.35714 .16187 m
.35714 .16562 L
s
.40476 .16187 m
.40476 .16562 L
s
.45238 .16187 m
.45238 .16562 L
s
.54762 .16187 m
.54762 .16562 L
s
.59524 .16187 m
.59524 .16562 L
s
.64286 .16187 m
.64286 .16562 L
s
.69048 .16187 m
.69048 .16562 L
s
.78571 .16187 m
.78571 .16562 L
s
.83333 .16187 m
.83333 .16562 L
s
.88095 .16187 m
.88095 .16562 L
s
.92857 .16187 m
.92857 .16562 L
s
.25 Mabswid
0 .16187 m
1 .16187 L
s
.02381 .0699 m
.03006 .0699 L
s
[(5.75)] .01131 .0699 1 0 Mshowa
.02381 .25384 m
.03006 .25384 L
s
[(6.25)] .01131 .25384 1 0 Mshowa
.02381 .3458 m
.03006 .3458 L
s
[(6.5)] .01131 .3458 1 0 Mshowa
.02381 .43777 m
.03006 .43777 L
s
[(6.75)] .01131 .43777 1 0 Mshowa
.02381 .52974 m
.03006 .52974 L
s
[(7)] .01131 .52974 1 0 Mshowa
.125 Mabswid
.02381 .08829 m
.02756 .08829 L
s
.02381 .10668 m
.02756 .10668 L
s
.02381 .12508 m
.02756 .12508 L
s
.02381 .14347 m
.02756 .14347 L
s
.02381 .18026 m
.02756 .18026 L
s
.02381 .19865 m
.02756 .19865 L
s
.02381 .21705 m
.02756 .21705 L
s
.02381 .23544 m
.02756 .23544 L
s
.02381 .27223 m
.02756 .27223 L
s
.02381 .29062 m
.02756 .29062 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .32741 m
.02756 .32741 L
s
.02381 .3642 m
.02756 .3642 L
s
.02381 .38259 m
.02756 .38259 L
s
.02381 .40099 m
.02756 .40099 L
s
.02381 .41938 m
.02756 .41938 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .47456 m
.02756 .47456 L
s
.02381 .49296 m
.02756 .49296 L
s
.02381 .51135 m
.02756 .51135 L
s
.02381 .54814 m
.02756 .54814 L
s
.02381 .56653 m
.02756 .56653 L
s
.02381 .58493 m
.02756 .58493 L
s
.02381 .60332 m
.02756 .60332 L
s
.02381 .0515 m
.02756 .0515 L
s
.02381 .03311 m
.02756 .03311 L
s
.02381 .01472 m
.02756 .01472 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.2619 .12508 L
.5 .60332 L
.7381 .23544 L
.97619 .16187 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00:03oool00`000000oooo0?oo
o`3o0?ooohH0oooo000X0?ooo`030000003oool0oooo0?l0ooooQP3oool002P0oooo00<000000?oo
o`3oool0o`3ooon60?ooo`00:03oool00`000000oooo0?ooo`3o0?ooohH0oooo000X0?ooo`030000
003oool0oooo0?l0ooooQP3oool002P0oooo00<000000?ooo`3oool0o`3ooon60?ooo`00:03oool3
00000?l0ooooQP3oool002P0oooo00@000000?ooo`0000000000o`3ooon50?ooo`00:03oool01000
0000oooo0?ooo`3oool200000?l0ooooP`3oool002P0oooo00<000000?ooo`3oool00`3oool20000
0?l0ooooP@3oool002P0oooo00<000000?ooo`3oool01@3oool200000?l0ooooO`3oool002P0oooo
00<000000?ooo`3oool01`3oool200000?l0ooooO@3oool002P0oooo00<000000?ooo`3oool02@3o
ool300000?l0ooooNP3oool002P0oooo0`00000<0?ooo`800000o`3ooomh0?ooo`00:03oool00`00
0000oooo0?ooo`0>0?ooo`800000o`3ooomf0?ooo`00:03oool00`000000oooo0?ooo`0@0?ooo`80
0000o`3ooomd0?ooo`00:03oool00`000000oooo0?ooo`0B0?ooo`800000o`3ooomb0?ooo`00:03o
ool00`000000oooo0?ooo`0D0?ooo`<00000o`3ooom_0?ooo`00:03oool00`000000oooo0?ooo`0G
0?ooo`800000o`3ooom]0?ooo`00:03oool00`000000oooo0?ooo`0I0?ooo`800000o`3ooom[0?oo
o`00:03oool00`000000oooo0?ooo`0K0?ooo`800000o`3ooomY0?ooo`00:03oool3000001d0oooo
0P00003o0?ooofL0oooo000X0?ooo`030000003oool0oooo01l0oooo0P00003o0?ooofD0oooo000X
0?ooo`030000003oool0oooo0240oooo0`00003o0?ooof80oooo000X0?ooo`030000003oool0oooo
02@0oooo0P00003o0?ooof00oooo00020?ooo`050;md0000000000000000001d_ol01@3oool00`2o
M0000000001d_`060?ooo`030?oOW018B9`0oooo00D0oooo00D0_g@0000000000000000007Boo`06
0?ooo`030000003oool0oooo02H0oooo0P00003o0?oooeh0oooo00000`3oool0_g@0001d_`020?oo
o`030?oOW0180000M;oo00@0oooo00<0_g@000000000M;l01`3oool00`2LB4P0W=oo0?ooo`030?oo
o`070;md0000M;l0oooo0?ooo`3ogi`0B00007Boo`050?ooo`030000003oool0oooo02P0oooo0P00
003o0?oooe`0oooo00060?ooo`030?noM000M;l0oooo00d0oooo00<0gia804RLg`3oool0203oool0
0`3o_g@007Bo0?ooo`040?ooo`030000003oool0oooo02X0oooo0P00003o0?oooeX0oooo00060?oo
o`030?noM000M;l0oooo00d0oooo00<0omnL04Q8W03oool0203oool00`3o_g@007Bo0?ooo`040?oo
o`@00000:`3oool300000?l0ooooE`3oool000H0oooo00<0W4P007Boo`3oool03P3oool00`2LB4P0
W=oo0?ooo`070?ooo`0309a8001d_ol0oooo00@0oooo00<000000?ooo`3oool0;`3oool200000?l0
ooooE@3oool000030?ooo`3ookl0M00000<0000000<0B9cO0?ooo`3oool03P3oool00`3OW4P0B9cO
0?ooo`020?ooo`030?oo_`1d000000000080000000<0B9cO0?ooo`3oool0103oool00`000000oooo
0?ooo`0a0?ooo`800000o`3ooomC0?ooo`0000@0oooo0?oo_`1d07@0_ooo4`3oool00`3ogi`0B4RL
0?ooo`020?ooo`030?oo_`1d07@0_ooo00T0oooo00<000000?ooo`3oool0<`3oool200000?l0oooo
D@3oool000040?ooo`3ookl0M01d0;ooo`l0oooo00<0_gA809cOo`3oool00P3oool01`2oM4P0W=oo
0?ooo`3oool0oono07@0M02oool02@3oool00`000000oooo0?ooo`0e0?ooo`800000o`3ooom?0?oo
o`0000<0oooo0?oo_`1d00000`0000000`0007@0_ooo0?ooo`0:0?ooo`030;md00000000000000<0
000000D0M;oo0?ooo`3oool0oono07@00003000000030000M02oool0oooo00@0oooo00<000000?oo
o`3oool0=`3oool200000?l0ooooC@3oool002P0oooo00<000000?ooo`3oool0>@3oool300000?l0
ooooBP3oool002P0oooo0`00000l0?ooo`800000o`3ooom80?ooo`00:03oool00`000000oooo0?oo
o`0n0?ooo`800000o`3ooom60?ooo`00:03oool00`000000oooo0?ooo`100?ooo`800000o`3ooom4
0?ooo`00:03oool00`000000oooo0?ooo`120?ooo`800000o`3ooom20?ooo`00:03oool00`000000
oooo0?ooo`140?ooo`<00000o`3ooolo0?ooo`00:03oool00`000000oooo0?ooo`170?ooo`800000
o`3ooolm0?ooo`00:03oool00`000000oooo0?ooo`190?ooo`800000o`3ooolk0?ooo`00:03oool0
0`000000oooo0?ooo`1;0?ooo`800000o`3oooli0?ooo`00:03oool3000004d0oooo0P00003o0?oo
ocL0oooo000X0?ooo`030000003oool0oooo04l0oooo0P00003o0?ooocD0oooo000X0?ooo`030000
003oool0oooo0540oooo0`00003o0?oooc80oooo000X0?ooo`030000003oool0oooo05@0oooo0P00
003o0?oooc00oooo000X0?ooo`030000003oool0oooo05H0oooo0P00003o0?ooobh0oooo000X0?oo
o`030000003oool0oooo05P0oooo1`0000000`1d_ol0oooo0?ooo`1G0?ooo`050;md000000000000
00000018W=l0F`3oool01@3ogi`0B000000000000000M;oo05T0oooo00D0_g@00000000000000000
07Boo`090?ooo`00:03oool00`000000oooo0?ooo`1I0?ooo`030;md0000000000000080oooo00<0
giad09cOo`3oool0E`3oool01`2oM00007Bo0?ooo`3oool0oono07@00018W=l0G03oool00`2oM000
M;oo0?ooo`1H0?ooo`070;md0000M;l0oooo0?ooo`3ogi`0B00007Boo`080?ooo`00:03oool30000
05X0oooo00@0okmd0000B00000000000G`3oool00`3o_g@007Bo0?ooo`1K0?ooo`030;md001d_ol0
oooo05d0oooo00<0okmd001d_`3oool01`3oool002P0oooo00<000000?ooo`3oool0F`3oool00`3o
gi`0B0000000001N0?ooo`030?oOW01804P0W=oo05P0oooo00<0gia80000000000000`0000000`1d
_ol0oooo0?ooo`1K0?ooo`030?noM000M;l0oooo00L0oooo000X0?ooo`030000003oool0oooo05d0
oooo00<0W4P00000003oool0FP3oool0103OW4P000000000B02LgomI0?ooo`060?noM00007@0_ooo
0?ooo`2oM000M;ooGP3oool00`2LB000M;oo0?ooo`070?ooo`00:03oool00`000000oooo0?ooo`1N
0?ooo`030000002oool0oooo05/0oooo00<0omnL04P0B02Lgol0F@3oool01@3OW4P007Bo0?ooo`2o
M000M;oo05T0oooo00<0oono07@0000000000P0000000`18W=l0oooo0?ooo`070?ooo`00:03oool0
0`000000oooo0?ooo`1I0?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@00000003oool0G03oool0
0`2oM000M;oo0?ooo`1I0?ooo`0409a80018W=l0_g@007BooeT0oooo00<0oono07@0M02oool0303o
ool002P0oooo00<000000?ooo`3oool0F@3oool01`3o_g@0001d0;ooo`3oool0okmd0000B0000000
F03oool01`3o_g@0001809cOo`3oool0omnL04P0B02Lgol0FP3oool0103ogi`0B01804Q8001d_omI
0?ooo`030?oo_`1d07@0_ooo00`0oooo000X0?ooo`030000003oool0oooo05X0oooo00L0okmd0000
00000000001809cOo`3oool0000005P0oooo00D0omnL04P000000000000007Boo`1L0?ooo`030?no
M0000000M;oo05T0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`070?ooo`00:03o
ool300000600oooo00<000000?ooo`3oool0o`3ooolS0?ooo`00:03oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool0oooo0?l0oooo8P3oool002P0oooo00<000000?ooo`3oool0H@3oool00`00
0000oooo0?ooo`3o0?ooob80oooo000X0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3o
ool0o`3ooolQ0?ooo`00:03oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo0?l0oooo
8@3oool002P0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`3o0?ooob00oooo000X
0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0o`3ooolP0?ooo`00:03oool00`00
0000oooo0?ooo`1T0?ooo`030000003oool0oooo0?l0oooo7`3oool001l0ooooo`00002A00000040
oooo000X0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0<0?ooo`<0000000<0oooo0000003oool02@3oool002P0oooo00<000000?ooo`3oool0G@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0G03o
ool00`000000oooo0?ooo`1D0?ooo`@00000103oool00`000000oooo0?ooo`080?ooo`00:03oool0
0`000000oooo0?ooo`1V0?ooo`030000003oool0oooo0?l0oooo1`3oool3000001<0oooo000X0?oo
o`030000003oool0oooo06H0oooo00<000000?ooo`3oool0o`3oool40?ooo`<000005P3oool002P0
oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`3n0?ooo`@000006@3oool002P0oooo
00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`3k0?ooo`<000007@3oool002P0oooo0`00
001X0?ooo`030000003oool0oooo0?L0oooo0`00000P0?ooo`00:03oool00`000000oooo0?ooo`1X
0?ooo`030000003oool0oooo0?@0oooo0`00000S0?ooo`00:03oool00`000000oooo0?ooo`1Y0?oo
o`030000003oool0oooo0>l0oooo1000000V0?ooo`00:03oool00`000000oooo0?ooo`1Y0?ooo`03
0000003oool0oooo0>`0oooo0`00000Z0?ooo`00:03oool00`000000oooo0?ooo`1Z0?ooo`030000
003oool0oooo0>P0oooo0`00000]0?ooo`00:03oool00`000000oooo0?ooo`1Z0?ooo`030000003o
ool0oooo0>D0oooo0`00000`0?ooo`00:03oool00`000000oooo0?ooo`1[0?ooo`030000003oool0
oooo0>00oooo1000000c0?ooo`00:03oool3000006/0oooo00<000000?ooo`3oool0g@3oool30000
03L0oooo000X0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0f@3oool3000003X0
oooo000X0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0e@3oool4000003d0oooo
000X0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0d@3oool300000440oooo000X
0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0cP3oool3000004@0oooo000X0?oo
o`030000003oool0oooo06h0oooo00<000000?ooo`3oool0bP3oool3000004L0oooo000X0?ooo`03
0000003oool0oooo06h0oooo00<000000?ooo`3oool0aP3oool4000004X0oooo000X0?ooo`030000
003oool0oooo06l0oooo00<000000?ooo`3oool0`P3oool3000004h0oooo000X0?ooo`<00000K`3o
ool00`000000oooo0?ooo`2o0?ooo`<00000D@3oool002P0oooo00<000000?ooo`3oool0L03oool0
0`000000oooo0?ooo`2k0?ooo`<00000E03oool002P0oooo00<000000?ooo`3oool0L03oool00`00
0000oooo0?ooo`2g0?ooo`@00000E`3oool002P0oooo00<000000?ooo`3oool0L@3oool00`000000
oooo0?ooo`2c0?ooo`<00000F`3oool002P0oooo00<000000?ooo`3oool0L@3oool00`000000oooo
0?ooo`2`0?ooo`<00000GP3oool002P0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?oo
o`2[0?ooo`@00000H@3oool002P0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`2X
0?ooo`<00000I@3oool002P0oooo0`00001c0?ooo`030000003oool0oooo0:D0oooo0P00001X0?oo
o`00:03oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3o
ool0J03oool002P0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`2S0?ooo`030000
003oool0oooo06P0oooo000X0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0XP3o
ool00`000000oooo0?ooo`1Y0?ooo`000`3oool01@2oM00000000000000007@0_ooo00@0oooo00<0
_g@000000000M;l00`3oool00`3ookl0M000000000040000000507Boo`3oool0oooo0?ooo`2oM000
0`0000000`1d_ol0oooo0?ooo`040?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0
X03oool00`000000oooo0?ooo`1Z0?ooo`000P3oool01P3OW4P007Bo0?ooo`3oool0okmd001d_`@0
oooo00<0_g@000000000M;l0103oool00`2oM000001d0;ooo`020?ooo`060=nLM02Lgol0oooo0?oo
o`2oM00007Bo0P3oool00`3ogi`0B00007Boo`050?ooo`030000003oool0oooo07D0oooo00<00000
0?ooo`3oool0X03oool00`000000oooo0?ooo`1Z0?ooo`0000@0oooo0?oo_`1d0000M;oo0P3oool0
0`3ookl0M4RL0?ooo`0;0?ooo`030?noM00004P0W=oo00X0oooo00<0okmd001d_`3oool0103oool0
0`000000oooo0?ooo`1f0?ooo`030000003oool0oooo09h0oooo00<000000?ooo`3oool0J`3oool0
00080?ooo`3o_g@004Q807@0M02oool0oooo0=nLB000M;l=0?ooo`030?oOW0180000B9cO00T0oooo
00<0okmd001d_`3oool0103oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo09d0oooo
00<000000?ooo`3oool0K03oool000040?ooo`3ogi`0B4RL0?noM080000000<004RL0?ooo`3oool0
3P3oool00`2LB000B9cO0?ooo`070?ooo`0309a8001d_ol0oooo00@0oooo1000001f0?ooo`030000
003oool0oooo09`0oooo00<000000?ooo`3oool0K03oool000040?ooo`3ookl0M01d0;oooa@0oooo
00H0W4Qd0;ooo`3oool0oooo0?oo_`1d00030000000304RLg`3oool0oooo00@0oooo00<000000?oo
o`3oool0M`3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo06d0oooo00020?ooo`03
0;md0018W=l0oooo00h0oooo00<0gia807Boo`3oool00P3oool01`2oM000M;oo0?ooo`3oool0oono
07@0M02oool02@3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo09X0oooo00<00000
0?ooo`3oool0K@3oool00080oooo00<0oono07@00000M;l03P3oool01`3o_g@0001d0;ooo`3oool0
okmd0000B02Lgol00P3oool00`3ookl0M01d0;ooo`090?ooo`030000003oool0oooo07P0oooo00<0
00000?ooo`3oool0V@3oool00`000000oooo0?ooo`1^0?ooo`00103oool0102oM000000000000000
B9`<0?ooo`050?noM000000000000000B02Lgol00`3oool00`3ookl0M00000000002000000030000
M02oool0oooo00@0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`2G0?ooo`030000
003oool0oooo06l0oooo000X0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0U`3o
ool00`000000oooo0?ooo`1_0?ooo`00:03oool00`000000oooo0?ooo`1j0?ooo`030000003oool0
oooo09D0oooo00<000000?ooo`3oool0L03oool002P0oooo0`00001j0?ooo`030000003oool0oooo
09@0oooo00<000000?ooo`3oool0L@3oool002P0oooo00<000000?ooo`3oool0N`3oool00`000000
oooo0?ooo`2C0?ooo`030000003oool0oooo0740oooo000X0?ooo`030000003oool0oooo07/0oooo
00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`1b0?ooo`00:03oool00`000000oooo0?oo
o`1l0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0L`3oool002P0oooo00<00000
0?ooo`3oool0O03oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo07<0oooo000X0?oo
o`030000003oool0oooo07d0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`1d0?oo
o`00:03oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3o
ool0M@3oool002P0oooo0`00001n0?ooo`030000003oool0oooo08`0oooo00<000000?ooo`3oool0
M@3oool002P0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`2;0?ooo`030000003o
ool0oooo07H0oooo000X0?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0R@3oool0
0`000000oooo0?ooo`1g0?ooo`00:03oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo
08T0oooo00<000000?ooo`3oool0M`3oool002P0oooo00<000000?ooo`3oool0P03oool00`000000
oooo0?ooo`270?ooo`030000003oool0oooo07P0oooo000X0?ooo`030000003oool0oooo0800oooo
00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`1h0?ooo`00:03oool00`000000oooo0?oo
o`210?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0N@3oool002P0oooo00<00000
0?ooo`3oool0P@3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo07X0oooo000X0?oo
o`<00000PP3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo07X0oooo000X0?ooo`03
0000003oool0oooo0880oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`1k0?ooo`00
:03oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0
O03oool002P0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`200?ooo`030000003o
ool0oooo07`0oooo000X0?ooo`030000003oool0oooo08@0oooo00<000000?ooo`3oool0OP3oool0
0`000000oooo0?ooo`1m0?ooo`00:03oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo
07d0oooo00<000000?ooo`3oool0OP3oool002P0oooo00<000000?ooo`3oool0Q@3oool00`000000
oooo0?ooo`1l0?ooo`030000003oool0oooo07h0oooo000X0?ooo`<00000Q@3oool00`000000oooo
0?ooo`1k0?ooo`030000003oool0oooo07l0oooo000X0?ooo`030000003oool0oooo08H0oooo00<0
00000?ooo`3oool0N@3oool00`000000oooo0?ooo`200?ooo`00:03oool00`000000oooo0?ooo`26
0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0P03oool002P0oooo00<000000?oo
o`3oool0Q`3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo0840oooo000<0?ooo`05
0;md0000000000000000M02oool0103oool00`2oM0000000001d_`050?ooo`050;md000000000000
0000001d_ol01P3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo07L0oooo00<00000
0?ooo`3oool0P@3oool000/0oooo00H0gia8001d_`3oool0oooo0?noM000M;l40?ooo`030;md0000
000007Bo00@0oooo00L0_g@0001d_`3oool0oooo0?oOW0180000M;oo00D0oooo00<000000?ooo`3o
ool0R03oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo0880oooo000:0?ooo`030?oo
_`1d0000M;oo0080oooo00<0oono07A8W03oool03`3oool00`3o_g@007Bo0?ooo`040?ooo`030000
003oool0oooo08P0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`230?ooo`002P3o
ool01`3o_g@004Q807@0M02oool0oooo0=nLB000M;l0403oool00`3o_g@007Bo0?ooo`040?ooo`@0
0000R03oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo08<0oooo000:0?ooo`030?oO
W018B9`0okmd0080000000<004RL0?ooo`3oool03`3oool00`2LB000M;oo0?ooo`040?ooo`030000
003oool0oooo08T0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`240?ooo`002P3o
ool00`3ookl0M01d0;ooo`0?0?ooo`030?oo_`1d000000000080000000<0B9cO0?ooo`3oool0103o
ool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0Q@3o
ool000/0oooo00<0_g@004RLg`3oool03P3oool00`3ookl0M01d0;ooo`090?ooo`030000003oool0
oooo08X0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`250?ooo`002`3oool00`3o
okl0M000001d_`0>0?ooo`030?oo_`1d07@0_ooo00T0oooo00<000000?ooo`3oool0R`3oool00`00
0000oooo0?ooo`1^0?ooo`030000003oool0oooo08H0oooo000=0?ooo`040;md0000000000000018
W0/0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`040?ooo`030000003oool0oooo
08/0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`270?ooo`00:03oool00`000000
oooo0?ooo`2<0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0Q`3oool002P0oooo
00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo08P0oooo
000X0?ooo`<00000S@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo08T0oooo000X
0?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`29
0?ooo`00:03oool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo06L0oooo00<000000?oo
o`3oool0RP3oool002P0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`1V0?ooo`03
0000003oool0oooo08/0oooo000X0?ooo`030000003oool0oooo08l0oooo00<000000?ooo`3oool0
I@3oool00`000000oooo0?ooo`2;0?ooo`00:03oool00`000000oooo0?ooo`2?0?ooo`030000003o
ool0oooo06@0oooo00<000000?ooo`3oool0S03oool002P0oooo00<000000?ooo`3oool0T03oool0
0`000000oooo0?ooo`1S0?ooo`030000003oool0oooo08`0oooo000X0?ooo`<00000T03oool00`00
0000oooo0?ooo`1R0?ooo`030000003oool0oooo08d0oooo000X0?ooo`030000003oool0oooo0940
oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`2>0?ooo`00:03oool00`000000oooo
0?ooo`2A0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0SP3oool002P0oooo00<0
00000?ooo`3oool0TP3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo08l0oooo000X
0?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`2@
0?ooo`00:03oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo05`0oooo00<000000?oo
o`3oool0T03oool002P0oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo0940oooo000X0?ooo`<00000U03oool00`000000oooo0?ooo`1I0?ooo`030000
003oool0oooo0980oooo000X0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`2B0?ooo`00:03oool00`000000oooo0?ooo`2E0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool0T`3oool002P0oooo00<000000?ooo`3oool0U@3oool00`00
0000oooo0?ooo`1F0?ooo`030000003oool0oooo09@0oooo000X0?ooo`030000003oool0oooo09H0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`2D0?ooo`00:03oool00`000000oooo
0?ooo`2F0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0U@3oool002P0oooo00<0
00000?ooo`3oool0U`3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo09H0oooo000X
0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`2F
0?ooo`00:03oool3000009P0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`2G0?oo
o`00:03oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3o
ool0U`3oool002P0oooo00<000000?ooo`3oool0V@3oool00`000000oooo0?ooo`1>0?ooo`030000
003oool0oooo09P0oooo000X0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0C@3o
ool00`000000oooo0?ooo`2I0?ooo`000`3oool01@2oM00000000000000007@0_ooo00@0oooo00<0
_g@000000000M;l01P3oool00`3ogi`0B4RL0?ooo`050?ooo`050;md0000000000000000001d_ol0
1P3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0
V@3oool00080oooo00H0gia8001d_`3oool0oooo0?noM000M;l40?ooo`030;md0000000007Bo00L0
oooo00<0W4Q809cOo`3oool00`3oool01`2oM00007Bo0?ooo`3oool0omnL04P0001d_ol01@3oool0
0`000000oooo0?ooo`2J0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0VP3oool0
00040?ooo`3ookl0M00007Boo`80oooo00<0oono07A8W03oool03@3oool00`3OW4P0B9cO0?ooo`08
0?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`19
0?ooo`030000003oool0oooo09/0oooo0000203oool0okmd0018B01d07@0_ooo0?ooo`3OW4P007Bo
3P3oool00`3ogi`0B4RL0?ooo`080?ooo`030?noM000M;l0oooo00@0oooo1000002J0?ooo`030000
003oool0oooo04T0oooo00<000000?ooo`3oool0V`3oool000040?ooo`3ogi`0B4RL0?noM0800000
00<004RL0?ooo`3oool03P3oool00`2LB4P0W=oo0?ooo`070?ooo`0309a8001d_ol0oooo00@0oooo
00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo09`0oooo
0000103oool0oono07@0M02ooolC0?ooo`030=nLB018W=l0oooo0080oooo00<0oono07@000000000
0P0000000`18W=l0oooo0?ooo`040?ooo`030000003oool0oooo09`0oooo00<000000?ooo`3oool0
AP3oool00`000000oooo0?ooo`2M0?ooo`000P3oool00`2oM000B9cO0?ooo`0B0?ooo`030?oOW018
B9`0oooo0080oooo00<0oono07@0M02oool02@3oool00`000000oooo0?ooo`2M0?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool0W@3oool00080oooo00<0oono07@00000M;l03P3oool0
0`2oM4P0W=oo0?ooo`020?ooo`070;mdB02Lgol0oooo0?ooo`3ookl0M01d0;ooo`090?ooo`030000
003oool0oooo09d0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2N0?ooo`00103o
ool0102oM000000000000000B9`;0?ooo`030;md00000000000000<0000000D0M;oo0?ooo`3oool0
oono07@00003000000030000M02oool0oooo00@0oooo00<000000?ooo`3oool0WP3oool00`000000
oooo0?ooo`120?ooo`030000003oool0oooo09l0oooo000X0?ooo`030000003oool0oooo09h0oooo
00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`2O0?ooo`00:03oool3000009l0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`2P0?ooo`00:03oool00`000000oooo0?ooo`2O
0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0X@3oool002P0oooo00<000000?oo
o`3oool0X03oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0:40oooo000X0?ooo`03
0000003oool0oooo0:00oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`2R0?ooo`00
:03oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
XP3oool002P0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`0k0?ooo`030000003o
ool0oooo0:<0oooo000X0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`2T0?ooo`00:03oool00`000000oooo0?ooo`2R0?ooo`030000003oool0oooo
03T0oooo00<000000?ooo`3oool0Y03oool002P0oooo0`00002S0?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool0Y@3oool002P0oooo00<000000?ooo`3oool0X`3oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo0:H0oooo000X0?ooo`030000003oool0oooo0:@0oooo00<0
00000?ooo`3oool0=@3oool00`000000oooo0?ooo`2V0?ooo`00:03oool00`000000oooo0?ooo`2T
0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0Y`3oool002P0oooo00<000000?oo
o`3oool0Y@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0:P0oooo000X0?ooo`03
0000003oool0oooo0:D0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`2X0?ooo`00
:03oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
Z@3oool002P0oooo0`00002V0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0ZP3o
ool002P0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo0:X0oooo000X0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`2[0?ooo`00:03oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0[03oool002P0oooo00<000000?ooo`3oool0Z03oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo0:`0oooo000X0?ooo`030000003oool0oooo0:T0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`2]0?ooo`00:03oool00`000000oooo0?ooo`2Y
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0[@3oool002P0oooo0`00002Z0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool0[P3oool002P0oooo00<000000?ooo`3o
ool0ZP3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0:l0oooo000X0?ooo`030000
003oool0oooo0:/0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`2_0?ooo`00:03o
ool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0/03o
ool001h0oooo00<0omnL04Q8W03oool01`3oool00`000000oooo0?ooo`2/0?ooo`030000003oool0
oooo0280oooo00<000000?ooo`3oool0/@3oool001l0oooo00<0W4Q809cOo`3oool01P3oool00`00
0000oooo0?ooo`2/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0/@3oool001l0
oooo00<0gia804RLg`3oool01P3oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0/P3oool001l0oooo00<0omnL04Q8W03oool01P3oool00`000000oooo
0?ooo`2]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0/`3oool00200oooo00<0
W4Q809cOo`3oool01@3oool400000:d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`2c0?ooo`00803oool00`3OW4P0B9cO0?ooo`050?ooo`030000003oool0oooo0:h0oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`2d0?ooo`00803oool00`3ogi`0B4RL0?ooo`050?oo
o`030000003oool0oooo0:l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`2e0?oo
o`00703oool00`2oM4P0W=oo0?ooo`020?ooo`030;mdB02Lgol0oooo00@0oooo00<000000?ooo`3o
ool0[`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0;D0oooo000L0?ooo`030;md
00000000000000<0000000<0M;oo0?ooo`3oool00`3oool00`000000oooo0?ooo`2`0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0]P3oool002P0oooo00<000000?ooo`3oool0/03o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0;H0oooo000X0?ooo`030000003oool0
oooo0;40oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2g0?ooo`00:03oool30000
0;40oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`2h0?ooo`00:03oool00`000000
oooo0?ooo`2b0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0^03oool002P0oooo
00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0;T0oooo
000X0?ooo`030000003oool0oooo0;<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`2j0?ooo`00:03oool00`000000oooo0?ooo`2c0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0^P3oool002P0oooo00<000000?ooo`3oool0]03oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0;/0oooo000X0?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`2l0?ooo`00:03oool300000;D0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`2l0?ooo`00:03oool00`000000oooo0?ooo`2e0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0_@3oool002P0oooo00<000000?ooo`3oool0]P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0;h0oooo000X0?ooo`030000003oool0oooo
0;H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2n0?ooo`00:03oool00`000000
oooo0?ooo`2g0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0_`3oool002P0oooo
00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0<00oooo
000X0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`300?ooo`00:03oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0`@3oool002P0oooo0`00002i0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0`@3oool002P0oooo00<000000?ooo`3oool0^@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0<80oooo000X0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`330?ooo`00:03oool00`000000oooo0?ooo`2j0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0``3oool002P0oooo00<000000?ooo`3oool0^`3oool0
10000000oooo0?ooo`0000360?ooo`00:03oool00`000000oooo0?ooo`2k0?ooo`030000003oool0
00000<L0oooo000X0?ooo`030000003oool0oooo0;`0oooo0P0000370?ooo`00:03oool300000;`0
oooo00<000000?ooo`3oool0aP3oool002P0oooo00<000000?ooo`3oool0o`3ooon60?ooo`00:03o
ool00`000000oooo0?ooo`3o0?ooohH0oooo000X0?ooo`030000003oool0oooo0?l0ooooQP3oool0
02P0oooo00<000000?ooo`3oool0o`3ooon60?ooo`00:03oool00`000000oooo0?ooo`3o0?ooohH0
oooo000X0?ooo`030000003oool0oooo0?l0ooooQP3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {265.875, 0}} -> {0, 5, 0, 0}, {{0, 287.313}, \
{177.25, 0}} -> {0, 5, 0, 0}},
  CellTags->"b:1.1.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  "The following example retrieves data from the ",
  StyleBox["SALES", "TI"],
  " table, but adds column headings and outputs the result in a tabular \
form."
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[\ \ conn, "\<SAMPLETABLE1\>", \ 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:1.1.3"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
          {"1", "5.6`", "\<\"Day1\"\>"},
          {"2", "5.9`", "\<\"Day2\"\>"},
          {"3", "7.2`", "\<\"Day3\"\>"},
          {"4", "6.2`", "\<\"Day4\"\>"},
          {"5", "6.`", "\<\"Day5\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[7]//TableForm=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " also allows you to enter raw SQL commands; this might be useful if you \
are already familiar with SQL and do not want to learn a new language. Here \
is an example that shows how to obtain all the data in the ",
  StyleBox["SALES", "TI"],
  " table."
}], "Text",
  CellTags->"b:1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ conn, \ "\<SELECT * FROM SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:1.1.3"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}, {3, 7.2`, "Day3"}, {4, 6.2`, 
        "Day4"}, {5, 6.`, "Day5"}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[TextData[{
  "More information on fetching data is available in sections for ",
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"DatabaseLink4.1.1", "xref:31"},
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  ButtonBox[" commands",
    ButtonData:>{"DatabaseLink4.1.1", "xref:31"},
    ButtonStyle->"AddOnsLinkText"],
  " and ",
  ButtonBox["SQL commands",
    ButtonData:>{"DatabaseLink4.2.2", "xref:38"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:1.1.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inserting Data", "Subsubsection",
  CellTags->{"xref:11", "c:13", "b:1.1.4"}],

Cell[TextData[{
  "You can use the ",
  StyleBox["SQLInsert", "MR"],
  " command to insert data in the table. For example, this adds a new row to \
the ",
  StyleBox["SAMPLETABLE1", "TI"],
  " table."
}], "Text",
  CellTags->"b:1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLInsert[\ 
      conn, "\<SAMPLETABLE1\>", \ {"\<ENTRY\>", "\<VALUE\>", "\<NAME\>"}, {6, 
        8.2, "\<Day6\>"}]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:1.1.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell["You can see the extra row that has been added.", "Text",
  CellTags->"b:1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[\ \ conn, \ "\<SAMPLETABLE1\>", \ 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:1.1.4"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
          {"1", "5.6`", "\<\"Day1\"\>"},
          {"2", "5.9`", "\<\"Day2\"\>"},
          {"3", "7.2`", "\<\"Day3\"\>"},
          {"4", "6.2`", "\<\"Day4\"\>"},
          {"5", "6.`", "\<\"Day5\"\>"},
          {"6", "8.2`", "\<\"Day6\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[11]//TableForm=",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell[TextData[{
  "It is also possible to use a raw SQL command to insert more data. Note how \
the string being inserted, ",
  StyleBox["Day7", "MR"],
  ", uses single-quote characters ('). It is also possible to use \
double-quote characters (\"), though these need to be preceded with a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " string escape backslash character (\\)."
}], "Text",
  CellTags->"b:1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ 
      conn, \ "\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (7, 6.9, \
'Day7')\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:1.1.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell[TextData[{
  "Another version of raw SQL commands involves using placeholders to \
represent where the arguments will go and then giving ",
  StyleBox["SQLExecute", "MR"],
  " a list argument that contains the actual arguments. This is particularly \
useful since it avoids the need to concatenate strings to form the raw \
command."
}], "Text",
  CellTags->"b:1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ 
      conn, \ "\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (`1`, \
`2`, `3`)\>", \ {8, 10.5, "\<Day8\>"}]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:1.1.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell["This shows the data that is currently in the table.", "Text",
  CellTags->"b:1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ conn, \ "\<SELECT * FROM SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:1.1.4"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}, {3, 7.2`, "Day3"}, {4, 6.2`, 
        "Day4"}, {5, 6.`, "Day5"}, {6, 8.2`, "Day6"}, {7, 6.9`, "Day7"}, {8, 
        10.5`, "Day8"}}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell[TextData[{
  "More information on inserting data is available in sections for ",
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"DatabaseLink4.1.3", "xref:33"},
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  ButtonBox[" commands",
    ButtonData:>{"DatabaseLink4.1.3", "xref:33"},
    ButtonStyle->"AddOnsLinkText"],
  " and ",
  ButtonBox["SQL commands",
    ButtonData:>{"DatabaseLink4.2.4", "xref:40"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:1.1.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Updating Data", "Subsubsection",
  CellTags->{"xref:12", "c:14", "b:1.1.5"}],

Cell[TextData[{
  "You can use the ",
  StyleBox["SQLUpdate", "MR"],
  " command to update data in the table. Often this is combined with a \
condition, so that only some of the data is modified. For example, this sets \
all entries of the ",
  StyleBox["VALUE", "TI"],
  " column that are greater than 8 to 7."
}], "Text",
  CellTags->"b:1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLUpdate[\ \ conn, "\<SAMPLETABLE1\>", \ {"\<VALUE\>"}, \ {7}, 
      SQLColumn["\<VALUE\>"] > 8]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"b:1.1.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"b:1.1.5"]
}, Closed]],

Cell["You can see the changes that have been made.", "Text",
  CellTags->"b:1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[\ \ conn, "\<SAMPLETABLE1\>", \ 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"b:1.1.5"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
          {"1", "5.6`", "\<\"Day1\"\>"},
          {"2", "5.9`", "\<\"Day2\"\>"},
          {"3", "7.2`", "\<\"Day3\"\>"},
          {"4", "6.2`", "\<\"Day4\"\>"},
          {"5", "6.`", "\<\"Day5\"\>"},
          {"7", "6.9`", "\<\"Day7\"\>"},
          {"6", "7.`", "\<\"Day6\"\>"},
          {"8", "7.`", "\<\"Day8\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[16]//TableForm=",
  CellTags->"b:1.1.5"]
}, Closed]],

Cell[TextData[{
  "It is also possible to use a raw SQL command to update data. This sets all \
rows for which the ",
  StyleBox["VALUE", "TI"],
  " entry is greater than or equal to 6 to 7."
}], "Text",
  CellTags->"b:1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ 
      conn, \ "\<UPDATE SAMPLETABLE1 SET VALUE = `1` WHERE VALUE >= `2`\>", \
{7, 6}]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"b:1.1.5"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"b:1.1.5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ conn, \ "\<SELECT * FROM SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"b:1.1.5"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}, {3, 7.`, "Day3"}, {4, 7.`, 
        "Day4"}, {5, 7.`, "Day5"}, {7, 7.`, "Day7"}, {6, 7.`, "Day6"}, {8, 
        7.`, "Day8"}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"b:1.1.5"]
}, Closed]],

Cell[TextData[{
  "More information on updating data is available in sections for ",
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"DatabaseLink4.1.4", "xref:34"},
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  ButtonBox[" commands",
    ButtonData:>{"DatabaseLink4.1.4", "xref:34"},
    ButtonStyle->"AddOnsLinkText"],
  " and ",
  ButtonBox["SQL commands",
    ButtonData:>{"DatabaseLink4.2.5", "xref:41"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:1.1.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deleting Data", "Subsubsection",
  CellTags->{"xref:13", "c:15", "b:1.1.6"}],

Cell[TextData[{
  "You can use the ",
  StyleBox["SQLDelete", "MR"],
  " command to delete data in the table. Often this is combined with a \
condition, so that only some of the data is modified. For example, this \
deletes all rows for which the ",
  StyleBox["ENTRY", "TI"],
  " entry is 7 or greater."
}], "Text",
  CellTags->"b:1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDelete[\ \ conn, "\<SAMPLETABLE1\>", 
      SQLColumn["\<VALUE\>"] \[GreaterEqual] 7]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:1.1.6"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"b:1.1.6"]
}, Closed]],

Cell["You can see the changes that have been made.", "Text",
  CellTags->"b:1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[\ \ conn, "\<SAMPLETABLE1\>", \ 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"b:1.1.6"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
          {"1", "5.6`", "\<\"Day1\"\>"},
          {"2", "5.9`", "\<\"Day2\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[20]//TableForm=",
  CellTags->"b:1.1.6"]
}, Closed]],

Cell[TextData[{
  "It is also possible to use a raw SQL command to delete data. This deletes \
all entries for which the ",
  StyleBox["VALUE", "TI"],
  " entry is greater than 5.7."
}], "Text",
  CellTags->"b:1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ 
      conn, \ "\<DELETE FROM SAMPLETABLE1 WHERE VALUE > 5.7\>"]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"b:1.1.6"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"b:1.1.6"]
}, Closed]],

Cell["There is only one row left in the database now.", "Text",
  CellTags->"b:1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ conn, \ "\<SELECT * FROM SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"b:1.1.6"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"b:1.1.6"]
}, Closed]],

Cell[TextData[{
  "More information on deleting data is available in sections for ",
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"DatabaseLink4.1.5", "xref:35"},
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  ButtonBox[" commands",
    ButtonData:>{"DatabaseLink4.1.5", "xref:35"},
    ButtonStyle->"AddOnsLinkText"],
  " and ",
  ButtonBox["SQL commands",
    ButtonData:>{"DatabaseLink4.2.6", "xref:42"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:1.1.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Batch Commands", "Subsubsection",
  CellTags->{"xref:72", "c:16", "b:1.1.7"}],

Cell["\<\
If you want to repeat the same command many times, you can do this by \
providing repeated arguments in a list. Carrying out the same command like \
this is much faster than doing each command separately.\
\>", "Text",
  CellTags->"b:1.1.7"],

Cell["The following command repeats the insertion of two rows.", "Text",
  CellTags->"b:1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLInsert[\ 
      conn, "\<SAMPLETABLE1\>", \ {"\<ENTRY\>", "\<VALUE\>", "\<NAME\>"}, \
{{2, 5.9, "\<Day2\>"}, {3, 7.2, "\<Day3\>"}}]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"b:1.1.7"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"b:1.1.7"]
}, Closed]],

Cell["This uses a raw SQL command to insert two more rows.", "Text",
  CellTags->"b:1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ 
      conn, "\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (`1`, `2`, \
`3`)\>", \[IndentingNewLine]{{4, 6.2, "\<Day4\>"}, {5, 
          6. , "\<Day5\>"}}]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"b:1.1.7"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"b:1.1.7"]
}, Closed]],

Cell["The result of the insert commands can be seen as follows.", "Text",
  CellTags->"b:1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[\ conn, \ "\<SELECT * FROM SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"b:1.1.7"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}, {3, 7.2`, "Day3"}, {4, 6.2`, 
        "Day4"}, {5, 6.`, "Day5"}}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"b:1.1.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Closing the Connection", "Subsubsection",
  CellTags->{"xref:14", "c:17", "b:1.1.8"}],

Cell["\<\
When you have finished with the connection, you can close it.\
\>", "Text",
  CellTags->"b:1.1.8"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"b:1.1.8"],

Cell[TextData[{
  "More information on working with connections is provided in the ",
  ButtonBox["Database Connections",
    ButtonData:>{"DatabaseLink2.0", "xref:134"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you have modified the database and want to restore it, you \
can use ",
  "the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package.",
  " "
}], "Text",
  CellTags->"b:1.1.8"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Database Explorer", "Subsection",
  CellTags->{"xref:15", "c:18", "b:1.2"}],

Cell[TextData[{
  "The Database Explorer is a graphical interface to database functionality. \
It can be launched by loading ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and executing the command ",
  StyleBox["DatabaseExplorer[]", "MR"],
  "."
}], "Text",
  CellTags->"b:1.2"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(DatabaseExplorer[]\)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.2"],

Cell["\<\
When the Database Explorer opens, you can connect to the different databases \
that are configured for your system. You can also create new connections. \
After you connect to a database, you can view the tables and columns; as seen \
in the following example.
\
\>", "Text",
  CellTags->"b:1.2"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007X0001^b000`400?l00000o`00003oo`1VIWkY
06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?gU0?_lo@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^n@0
Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0o`1VIWkS06IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`3ooooQ0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWko09bLW^00W9bN00@0oooo06IVOP2XZK/0nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2L
W9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk
06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh00006
06IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3k
o?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3o
ool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo203Pgn<3000000@0
h=oS00<000000>3Oh`3Pgn<0103Pgn<010000000h=oS0000000000020>3Oh`<000000P3Pgn<01000
0000h=oS0>3Oh`0000020>3Oh`030000003Pgn<0h=oS00<000000`3Pgn<00`000000h=oS0>3Oh`3o
0>3OhjX0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bL
WP3oool70>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`040>3Oh`03
0000003Pgn<000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<000000080h=oS00H00000
0>3Oh`3Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0h=oS0?l0h=oS[@3Pgn<01@2LW9h0oooo
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`/0h=oS00D000000>3O
h`3Pgn<0h=oS000000060>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`3Pgn<00`3Pgn<0
10000000h=oS0>3Oh`0000020>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0o`3P
gn>^0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0
oooo2`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000H0h=oS00<000000>3Oh`0000000P3Pgn<50000
00050>3Oh`000000h=oS0>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`0200000?l0h=oS/@3Pgn<0
1@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`L0h=oS
100000040>3Oh`030000003Pgn<0h=oS00@0h=oS00<000000>3Oh`0000000P3Pgn<01P000000h=oS
0>3Oh`3Pgn<000000>3Oh`80000000L0h=oS000000000000h=oS0000003Pgn<0000000<0h=oS00<0
00000>3Oh`3Pgn<0o`3Pgn>]0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP2LW9h0oooo1`3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0000000H0
h=oS100000020>3Oh`<000000P3Pgn<00`000000h=oS000000020>3Oh`040000003Pgn<0h=oS0>3O
h`<00000o`3Pgn>`0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk
06IVOP2LW9h0oooo203Pgn<00`000000h=oS0>3Oh`030>3Oh`800000203Pgn<00`000000h=oS0>3O
h`3o0>3Ohl80h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn
09bLWP3oool80>3Oh`@000000`3Pgn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<000000?l0
h=oSa03Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN
0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1V
IWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001P1V
IWh0nocm0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2X
ZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2LW9h0oooo
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooool0h=oSg@3Pgn<01@2L
W9h0oooo06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0W9bN0?l0oooogP3oool0
1@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko09bLW^00W9bN00@0
oooo06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWko0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@0S@3akn830>3Oh`03075_I03akn80lNoR0?l0lNoRC@3akn800`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1a
Kf@0o`3Pgn=>0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0060>3Oh`030=g2S@3TUc`0iX//02D0iX//00<0jiL^
0>76SP3Pgn<0o`3Pgn<M0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`030>76SP3^Wc40nkhi02H0olPl
00<0nKTh0>jO<@3QaXh0o`3Pgn<M0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`030=fQD`3i^3P0olLl
02L0olLl00D0nKPh0=fQD`3Pgn<0b=7=0:6c^`0R096W]0030:Vi_`3@e]00h=oS0?@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3O
h`3Pgn<0LFmT00D0h=oS00<0TI^L0?cloP3lo?h07@3lo?h00`000000o?cn0?cloP080?cloP04096K
W03@e]00]/C=0>galb80oooo00<0i>W/0;K4c@3@e]00m03Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<0
0`2AVi`0o?cn0?cloP0N0?cloP030000003lo?h0o?cn00L0o?cn00@0TI^L0:Vi_`3SjN/0o_km8P3o
ool00`3no_h0hnW/0:Vi_`3d0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`03096KW03lo?h0o?cn00H0
o?cn0`000000103lo?h000000?cloP3lo?h2000000040?cloP000000o?cn0?cloP<000000P3lo?h0
0`000000o?cn0?cloP030?cloP030000003lo?h0o?cn00L0o?cn00<0TI^L096W]03fm?80903oool0
0`3moO`0TJNd0>3Oh`3c0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`03096KW03lo?h0o?cn00D0o?cn
00D000000?cloP3lo?h0o?cn000000020?cloP030000003lo?h0o?cn0080000000<0o?cn0000003l
o?h00P3lo?h00`000000o?cn000000050?cloP030000003lo?h0o?cn00L0o?cn00<0TI^L096W]03o
ool09@3oool00`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`03096KW03lo?h0
o?cn00@0o?cn00<000000?cloP3lo?h00P000000103lo?h000000?cloP0000030?cloP030000003l
o?h0000000D0o?cn00<000000?cloP3lo?h00P3lo?h00`000000o?cn000000080?cloP03096KW02A
Yk@0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`03000000<0oooo0`00
00030?ooo`80000000D0oooo0000003oool000000?ooo`02000000D0oooo00<0TJNd0>3Oh`3Pgn<0
lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`2AVi`0o?cn0?cloP040?cloP030000003lo?h0o?cn
00<0o?cn00<000000?cloP0000000`3lo?h00`000000o?cn00000004000000030?cloP000000o?cn
00<0o?cn00<000000?cloP000000203lo?h00`2AVi`0TJNd0?[ioP030?[ioP050000003jnOh0n_Wn
0?[ioP0000000P3jnOh01`000000n_Wn0?[ioP3jnOh000000?[ioP0000000`3jnOh00`000000n_Wn
000000020?[ioP80000000@0n_Wn0000003jnOh000001P3jnOh00`2AYk@0h=oS0>3Oh`3b0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oSPP1oWKT01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0TI^L0?cloP3lo?h0103lo?h00`000000o?cn0?cloP03
0?cloP030000003lo?h0000000<0o?cn00<000000?cloP0000000`3lo?h010000000o?cn00000000
00020?cloP050000003lo?h0o?cn0?cloP0000001`3lo?h00`2AVi`0TJNd0?Gdo@030?Gdo@050000
003em?d0mOCm0?Gdo@0000000P3em?d00`000000mOCm0?Gdo@060?Gdo@040000003em?d0mOCm0000
00<0mOCm00D000000?Gdo@000000mOCm000000040?Gdo@030?Kdo@3em?d0TJNd0?@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`2AVi`0o?cn0?cl
oP040?cloP030000003lo?h0o?cn00<0o?cn00<000000?cloP0000000`3lo?h00`000000o?cn0?cl
oP0300000080o?cn00D000000?cloP000000o?cn000000030?cloP030000003lo?h0o?cn00D0o?cn
00<0TI^L096W]03alOd00`3alOd010000000lO7m0?7ao@0000030?7ao@D000000P3alOd2000000<0
lO7m00T000000?7ao@3alOd0lO7m0000003alOd000000?7ao@0000001P3alOd00`2AYk@0h=oS0>3O
h`3b0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00<0TI^L0?cloP3lo?h01@3lo?h01@000000o?cn0?cloP3lo?h0000001h0o?cn00<0TI^L096W]03Z
j_T00`3Zj_T500000080j^[i00L000000>[Zn@3Zj_T0j^[i0000003Zj_T0000000<0j^[i00<00000
0>[Zn@0000000`3Zj_T01@000000j^[i0000003Zj_T0000000H0j^[i00<0TJNd0>3Oh`3Pgn<0lP3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03096K
W03lo?h0o?cn00H0o?cn0`00000O0?cloP03096KW02AYk@0j^[h00<0j^[h00<000000>[Zn03Zj_P0
0P3Zj_P00`000000j^[h0>[Zn003000000<0j^[h0`0000020>[Zn0060000003Zj_P0j^[h0>[Zn000
0000j^[h100000050>[Zn003096W]03Pgn<0h=oS0?80h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`2AVi`0o?cn0?cloP0X0?cloP03096KW02AYk@0
iNKd00<0iNKd00<000000>GVm03Ui_@00P3Ui_@00`000000iNKd0>GVm00A0>GVm0030000003Ui_@0
000000H0iNKd00<0TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`03096KW03lo?h0o?cn02P0o?cn00<0TI^L096W]03Ogo400`3O
go45000001@0gmoa00<000000=oOl@0000001P3Ogo400`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0TI^L0?cloP3lo?h0
:03lo?h00`2AVi`0TJNd0=_Lk@0=0=_Mk@D0fmc]4`3KgNd00`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0TI^L0?cloP3l
o?h0:03lo?h00`2AVi`0TJNd0=GGj@0U0=GGj@03096W]03Pgn<0h=oS0?80h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`2AVi`0o?cn0?cloP0X0?cl
oP03096KW02AYk@0c<gR02D0c<gR00<0TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03096KW03lo?h0o?cn02P0o?cn00<0TI^L
096W]036b=d09@36b=d00`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0TI^L0?cloP3lo?h0:03lo?h00`2AVi`0TJNd0;jn
f00Q0;jnf080_[oH0P2n_]P00`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oSo`1aKfA4075_I0D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0WIfQ09fMX@3o09fMXD00
WIfQ00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo
0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00L0oooo0>3Oh`3Q
h>@0i^GX0>c[kP3`l?80l_;d04T0lo?dA@3hmoP20??cm0050??cm@3dm?D0mOGf0?Ccm@3Ui>P04`3P
gn<01@3Qh>@0i^GX0>c[kP3`l?80l_;d0280lo?d7`3hmoP20??cm0050??cm@3dm?D0mOGf0?Ccm@3U
i>P0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Ng=l0i>;P07^G[@0UEhFB000lM00401M=OP1[
RjH0l_7^0?;ala<0h=oS00@0g]cO0>CRh01kUjd09EN5A@00?7@0100GCGh0Jh^V0?;akP3blO=50>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0=[Hf@1VQJ40BW6C0;:m`i80a/GG00@0`<K504Q^T01ZRZ@0
knoa4`3Pgn<0103Jf=T0IXFQ04YaT`2b_L=50<K5e`040<36a@18KY00JXZT0>o_lDD0h=oS00<0WIfQ
075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`050?ooo`3Pgn<0f=GF01M=OP2oalX0U036aML00`2f_Kd05den0>_Zk@0C0>3Oh`030=SE
eP0GCGh0_lO:04L0a/GG00<0][fm01M=OP3[j^d0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3I
eMD003ad0?ooo`2D0<g<g`030?ooo`00?7@0j>OZ01<0h=oS00<0fMGE000lM03oool0A`3=c=l00`3o
ool003ad0>SWjP150>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0oooo06T0d]7T00<0
00000=;Ai03BdN@0:03BdN@00`3oool003ad0>OVj@0C0>3Oh`030=WEe@00?7@0oooo04L0d]7T00<0
oooo000lM03Wi^T0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`1Y0=KGi`03
0000003FenL0e]OW02P0e]OW00<0oooo000lM03Wi^T04`3Pgn<00`3IeMD003ad0?ooo`170=KGi`03
0?ooo`00?7@0inKY04D0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0fMGE000lM03oool03P3If^L4
00000080fM[W00D000000=WJi`3If^L0fM[W000000020=WJi`<00000103If^L01@000000fM[W0=WJ
i`3If^L0000000H0fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJi`02000000030=WJ
i`000000fM[W0080fM[W00<000000=WJi`3If^L00P3If^L2000000040=WJi`000000fM[W000000<0
fM[W00<000000=WJi`3If^L00`0000030=WJi`8000000`3If^L2000000030=WJi`000000fM[W00D0
fM[W0`0000030=WJi`040000003If^L0000000000080fM[W0P000000103If^L000000=WJi`3If^L3
00000080fM[W00D000000=WJi`3If^L0fM[W000000020=WJi`<00000403If^L00`3oool003ad0>OV
j@0C0>3Oh`030=WEe@00?7@0oooo00h0fM[W100000030=WJi`<000000P3If^L00`000000fM[W0=WJ
i`03000000<0fM[W0`0000020=WJi`800000103If^L00`000000fM[W0=WJi`030=WJi`050000003I
f^L000000=WJi`0000003P3If^L00`3oool003ad0>OVj@150>3Oh`0309fMX@1aKf@0h=oS00@0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0
h=oS0=WEe@00?7@0oooo00d0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W000000030=WJ
i`030000003If^L0000000<0fM[W00D000000=WJi`3If^L0fM[W000000030=WJi`030000003If^L0
fM[W00@0fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W000000020=WJi`8000000`3If^L0
1@000000fM[W0=WJi`3If^L000000080fM[W0P0000000`3If^L000000=WJi`020=WJi`030000003I
f^L0000000<0fM[W00<000000=WJi`0000000P3If^L00`000000fM[W000000020=WJi`8000001@3I
f^L01@000000fM[W0=WJi`3If^L000000080fM[W0P0000020=WJi`030000003If^L000000080fM[W
00<000000=WJi`0000000`3If^L00`000000fM[W000000030=WJi`030000003If^L0000000<0fM[W
00<000000=WJi`3If^L03@3If^L00`3oool003ad0>OVj@0C0>3Oh`030=WEe@00?7@0oooo00d0fM[W
00<000000=WJi`3If^L00P3If^L00`000000fM[W000000030=WJi`050000003If^L000000=WJi`00
00000`3If^L00`000000fM[W000000030=WJi`030000003If^L0000000D0fM[W00<000000=WJi`3I
f^L00`3If^L01@000000fM[W0000003If^L0000000h0fM[W00<0oooo000lM03Wi^T0A@3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0B0=kOk0030000003Ngn`0000000<0g]o/00<0
00000=kOk00000000`3Ngn`02P000000g]o/0=kOk0000000g]o/0000003Ngn`000000=kOk0000006
0=kOk0D000000P3Ngn`01@000000g]o/0=kOk03Ngn`000000080g]o/00<000000=kOk00000000P3N
gn`01`000000g]o/0=kOk03Ngn`000000=kOk00000000`3Ngn`00`000000g]o/000000050=kOk003
0000003Ngn`0g]o/0080g]o/00D000000=kOk03Ngn`0g]o/000000040=kOk0030000003Ngn`0g]o/
00<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/000000020=kOk0030000003Ngn`00000
00<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`0g]o/
00h0g]o/00<0oooo000lM03Wi^T04`3Pgn<00`3IeMD003ad0?ooo`0B0=kOk0030000003Ngn`00000
00D0g]o/00<000000=kOk00000001@3Ngn`00`000000g]o/0=kOk0030=kOk0030000003Ngn`0g]o/
00@0g]o/1@0000020=kOk0030000003Ngn`0000000h0g]o/00<0oooo000lM03Wi^T0A@3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0@0>?Ul08000000P3SiO001`000000hnG`0>?U
l03SiO0000000>?Ul00000000`3SiO002P000000hnG`0>?Ul0000000hnG`0000003SiO0000000>?U
l00000060>?Ul0050000003SiO00hnG`0>?Ul00000000P3SiO001@000000hnG`0>?Ul03SiO000000
0080hnG`00<000000>?Ul00000000`3SiO04000000030>?Ul0000000hnG`0080hnG`00<000000>?U
l00000001@3SiO04000000030>?Ul0000000hnG`0080hnG`00<000000>?Ul03SiO000P3SiO000`00
0000hnG`0>?Ul0030>?Ul0030000003SiO00000000<0hnG`00<000000>?Ul00000000P3SiO000`00
0000hnG`000000030>?Ul0030000003SiO00000000<0hnG`00<000000>?Ul03SiO000P00000A0>?U
l0030?ooo`00?7@0inKY01<0h=oS00<0fMGE000lM03oool0403SiO0200000080hnG`1@0000000`3S
iO0000000>?Ul005000000030>?Ul0000000hnG`00@0hnG`00<000000>?Ul03SiO00103SiO001@00
0000hnG`0>?Ul03SiO0000000080hnG`00<000000>?Ul00000003P3SiO000`3oool003ad0>OVj@15
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0oooo00h0jN_e0P0000040>W[m@800000
0P3YjoD00`000000jN_e000000030>W[m@030000003YjoD000000080jN_e00<000000>W[m@000000
0P3YjoD00`000000jN_e0>W[m@040>W[m@030000003YjoD0000000<0jN_e00<000000>W[m@3YjoD0
0P0000000`3YjoD000000>W[m@020>W[m@030000003YjoD0000000<0jN_e00@000000>W[m@000000
00000P3YjoD00`000000jN_e000000030>W[m@030000003YjoD000000080jN_e00<000000>W[m@00
00000P3YjoD2000000@0jN_e00<000000>W[m@3YjoD00`3YjoD010000000jN_e0000000000020>W[
m@030000003YjoD000000080jN_e00<000000>W[m@0000000`3YjoD010000000jN_e000000000002
0>W[m@030000003YjoD0000000<0jN_e00<000000>W[m@3YjoD03@3YjoD00`3oool003ad0>OVj@0C
0>3Oh`030=WEe@00?7@0oooo00h0jN_e0P0000040>W[m@090000003YjoD0jN_e0>W[m@000000jN_e
0000003YjoD0000000<0jN_e00<000000>W[m@0000000`3YjoD00`000000jN_e000000070>W[m@03
0000003YjoD0000000<0jN_e00<000000>W[m@0000003P3YjoD00`3oool003ad0>OVj@150>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`0103`lO`0
10000000l?7l0000000000030?3ao0<000000P3`lO`01@000000l?7l0?3ao03`lO`0000000<0l?7l
00<000000?3ao03`lO`0103`lO`00`000000l?7l000000040?3ao080000000@0l?7l0000003`lO`0
00000`3`lO`00`000000l?7l0?3ao00300000080l?7l00@000000?3ao000000000000`3`lO`30000
00<0l?7l0P0000030?3ao080000000<0l?7l0000003`lO`00`3`lO`00`000000l?7l0?3ao0030?3a
o0040000003`lO`000000?3ao080000000H0l?7l00000000000000000?3ao00000020?3ao0<00000
0P3`lO`010000000l?7l0000000000030?3ao0<00000403`lO`00`3oool003ad0>OVj@0C0>3Oh`03
0=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`01@3`lO`300000080l?7l00<000000?3ao03`
lO`00`0000030?3ao0<0000000@0l?7l00000000000000001P3`lO`00`000000l?7l000000030?3a
o0030000003`lO`0000000h0l?7l00<0oooo000lM03Wi^T0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo
0>3Oh`3IeMD003ad0?ooo`0=0?Ceo@030000003dmOd0m?Gm0080m?Gm00<000000?Ceo@0000006P3d
mOd00`000000m?Gm000000070?Ceo@030000003dmOd0m?Gm0200m?Gm00<000000?Ceo@3dmOd00`3d
mOd01@000000m?Gm0?Ceo@3dmOd0000000P0m?Gm00<000000?Ceo@3dmOd08P3dmOd00`3oool003ad
0>OVj@0C0>3Oh`030=WEe@00?7@0oooo00d0m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000m?Gm
0?Ceo@050?Ceo@030000003dmOd0m?Gm00/0m?Gm00<000000?Ceo@3dmOd01@3dmOd00`000000m?Gm
000000030?Ceo@030000003dmOd0000000h0m?Gm00<0oooo000lM03Wi^T0A@3Pgn<00`2MWJ40LFmT
0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0>0?Kgo@@000000P3fmod00`000000m_Om0?Kgo@0I0?Kg
o@030000003fmod0m_Om00H0m_Om00<000000?Kgo@3fmod0803fmod00`000000m_Om0?Kgo@040?Kg
o@<000002@3fmod010000000m_Om0?Kgo@00000Q0?Kgo@030?ooo`00?7@0inKY01<0h=oS00<0fMGE
000lM03oool03P3fmod4000000P0m_Om00<000000?Kgo@3fmod02`3fmod00`000000m_Om0?Kgo@06
0?Kgo@030000003fmod0m_Om0080m_Om00<000000?Kgo@0000003P3fmod00`3oool003ad0>OVj@15
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0oooo09@0n?cm00<0oooo000lM03Wi^T0
4`3Pgn<00`3IeMD003ad0?ooo`170?Slo@030?ooo`00?7@0inKY04D0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`05
0?ooo`3Pgn<0fMGE000lM03oool0U03moOd00`3oool003ad0>OVj@0C0>3Oh`030=WEe@00?7@0oooo
04L0oOgm00<0oooo000lM03Wi^T0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?oo
o`2D0?gmo@030?ooo`00?7@0i^KY01<0h=oS00<0fMGE000lM03oool0A`3moOd00`3oool003ad0>KV
j@150>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=SDe000?7@0oooo09@0oOgm00<0oooo000lM03U
iNP04`3Pgn<00`3He=@003ad0?ooo`170?gmo@030?ooo`00?7@0iNGX04D0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`050?ooo`3Pgn<0fMGE02EGQ@2oc]`0U03oool00`2oc]/09EN50>7Qi00C0>3Oh`030=WEe@0UEhD0
_lkL04L0oooo00<0_lkK02EGQ@3QhN@0A@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3IeMD0NIBY
05EmXP30cmfB0?ooo`040=GOj01EOJ80NIF[0=oMh1<0h=oS00@0fMGE07VDZ@1EOJ80`<oMA@3oool0
103EgnP0EGfR07VEZ`3OgN150>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0=[Gf@3Og=P0NIBY02EG
QI8003ad00@05den06J6X@3Pg]X0g=_M4`3Pgn<0103JemT0gmcH07VDZ@0UEhE5000lM00401M=OP1V
QZ40h=kJ0=cKgDD0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0gmgP0=[Gf@3He=@0B`3GdmA50=?>
c0<0em?D00@0f=CD0=WEe@3JemT0gmgP4`3Pgn<00`3OgN00f]OI0=SDe00T0=OCe1l0dlk<0`3Gdm@0
103He=@0fMGE0=[Gf@3OgN150>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3O
h`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ
075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`3Pgn<0
h=oSYP3oool70>3Ohhd0oooo0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`3Pgn<0h=oSY@2LW9h0
0`3oool0h=oS0>3Oh`050>3Ohh`0W9bN00H0oooo0>3Oh`3Pgn<0h=oS09fMX@1aKf@50>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3ooonR0>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0R03Pgn<0
0`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oooj80
h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo0>3Oh`280>3Oh`0309bLWP3oool0h=oS0080
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn>N07nM^@80h=oS00<0
W9bN0?ooo`3Pgn<01P3Pgn<0102LW9h0oooo0>3Oh`3Pgn>507nM^@80h=oS00<0W9bN0?ooo`3Pgn<0
0P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0
VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3O
h`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0
Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0
oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS
0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0
VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3O
h`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0
Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0
oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS
0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0
VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3O
h`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0
Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0
oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS
0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0
VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<01@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`D0000000<0oooo0000000000000`0000020?ooo`@00000O03oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0507nM^@3oool0
oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
N@3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0507nM^@3oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo07T0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<01@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool2000007`0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<01@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`800000OP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0507nM
^@3oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
1@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo07T0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo00000004000000030?ooo`000000oooo00D0
000000<0oooo0000003oool0103oool500000080oooo1000001l0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00D0Oifi0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool5
000000030?ooo`000000000000<0000000<0oooo0000000000000P0000030?ooo`050000003oool0
oooo0?ooo`0000001@3oool3000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`04000005h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0
h=oS0>3Oh`2LW9h0oooo0P3Pgn<01@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1K0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1a
Kf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00D0Oifi0?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000001@3oool00`000000oooo000000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0F`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`04
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0
oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0507nM^@3oool0oooo0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`800000GP3o
ool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`05
07nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bL
WP3oool20>3Oh`0507nM^@3oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool00`3oool5000000030?ooo`000000oooo00<0oooo00<000000?oo
o`0000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`00000010000003
0?ooo`800000H03oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3O
h`3Pgn<0h=oS09bLWP3oool20>3Oh`0507nM^@3oool0oooo0?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`000000103oool00`000000oooo0000001R0?ooo`0507nM^@3Pgn<0h=oS
09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00D0Oifi
0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000040?ooo`030000003oool0oooo05/0oooo00D0Oifi
0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS
0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3P
gn<00`1oWKT0oooo00000004000000030?ooo`000000oooo00D0000000<0oooo0000003oool0103o
ool5000000030?ooo`0000000000008000000`3oool00`000000oooo00000004000000<0oooo0`00
00030?ooo`D000000`3oool4000005h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<01@1oWKT0oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`D0000000<0oooo00000000
00000`0000000`3oool000000?ooo`040?ooo`030000003oool0oooo00@00000103oool01@000000
oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01000001A0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00D0Oifi0?ooo`3oool0oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo04h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<01@1oWKT0oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool5
00000080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00D0Oifi0?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool00`000000oooo000000020?ooo`030000003oool0oooo00@0oooo0P00
001A0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00D0Oifi0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`030?ooo`D000000`3oool00`000000oooo000000030?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`H0000000<0oooo
0000003oool0103oool00`000000oooo00000004000000<0oooo0P00001C0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00D0
Oifi0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000`3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0000000D0oooo00<000000?ooo`000000103oool00`000000oooo0000001E0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00D0Oifi0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo000000040?ooo`030000003oool0oooo04h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0000
0004000000030?ooo`000000oooo00D0000000<0oooo0000003oool0103oool5000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000@0000000<0
oooo0000003oool00`3oool010000000oooo0?ooo`3oool3000000<0oooo1@0000030?ooo`@00000
D@3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3O
h`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0
h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0
Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0
h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo00@000000P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0000000@0000000<0oooo0000000000000`0000020?ooo`@00000
0P3oool4000000<0oooo1@0000030?ooo`050000003oool0oooo0?ooo`0000001@3oool010000000
oooo0000003oool500000080oooo1000001A0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`000000103oool0
0`000000oooo000000050?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000001`3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`000000oooo000000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0CP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo
00@0oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0203oool00`000000oooo000000040?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool00P3oool500000080oooo00<000000?ooo`0000002P3oool00`000000oooo0?ooo`1>0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool00P3oool2000000<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool200000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000070?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0000000P0oooo0P00001A0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool00P0000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool00`3oool500000080oooo0P0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
0000100000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000060?ooo`800000D`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0000000P0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool0D`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0000000@0oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000070?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0CP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo
00@000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo1@0000020?oo
o`@000000P3oool4000000<0oooo1@0000000`3oool0000000000003000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000060?ooo`@00000D@3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0
P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0
VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3O
h`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?oo
o`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0
W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0
Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0
oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3O
h`0307nM^@3oool0oooo00@000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00@0000000<0oooo0000000000000`0000020?ooo`@00000N`3oool01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0
000000@0oooo00<000000?ooo`0000001@3oool00`000000oooo000000050?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1h0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0
Oifi0?ooo`3oool0103oool00`000000oooo0?ooo`0500000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07P0oooo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
0?ooo`020?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`060?ooo`800000N`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo
008000001P3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo1@0000020?oo
o`800000O@3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0000000P0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0O@3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0000000D000000`3oool3000000<0oooo00<000000?ooo`3oool00`3o
ool5000000030?ooo`000000000000@00000NP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`3oool01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1a
Kf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230?ooo`0507nM^@3P
gn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0
lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool2
0>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0P`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3P
gn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0oooo00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS
00<0Oifi0;:d_`2b];l0VP2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3P
gn<0h=oS07nM^@230;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`04
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0
oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0/[Bo09X0/[Bo00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2L
W9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1o
WKT0/[Bo0;:d_`2J0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0Oifi03/0/[Bo00<000000;:d_`2b];l0A@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0/[Bo0;:d_`2J
0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi03/0/[Bo
00<000000;:d_`2b];l0A@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0/[Bo000000040;:d_`040000002b
];l0/[Bo0;:d_`<000001P2b];l00`000000/[Bo0;:d_`030;:d_`@00000102b];l300000080/[Bo
00<000000;:d_`2b];l00P2b];l00`000000/[Bo00000004000000030;:d_`000000000000800000
I@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l0
000000@0/[Bo00@000000;:d_`2b];l0/[Bo0`0000060;:d_`030000002b];l0/[Bo00<0/[Bo1000
00040;:d_`<000000P2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000@0000000<0
/[Bo0000000000000P0000040;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l00P2b
];l010000000/[Bo0;:d_`2b];l3000000H0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo
0;:d_`030;:d_`030000002b];l0000000@000000`2b];l00`000000/[Bo0;:d_`040;:d_`030000
002b];l0/[Bo0180/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0;:d_`0000000`2b];l01@000000/[Bo0;:d
_`2b];l0000000<0/[Bo00<000000;:d_`2b];l00`2b];l00`000000/[Bo0;:d_`020;:d_`030000
002b];l0/[Bo0080/[Bo00@000000;:d_`2b];l000000`2b];l00`000000/[Bo000000040;:d_`03
0000002b];l0000000D0/[Bo00D000000;:d_`2b];l0/[Bo0000001T0;:d_`0507nM^@3Pgn<0h=oS
09bLWP3oool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`0000000`2b];l01@000000/[Bo
0;:d_`2b];l0000000<0/[Bo00<000000;:d_`2b];l00`2b];l00`000000/[Bo0;:d_`020;:d_`03
0000002b];l0/[Bo0080/[Bo00@000000;:d_`2b];l000000`2b];l00`000000/[Bo000000040;:d
_`030000002b];l0000000D0/[Bo00D000000;:d_`2b];l0/[Bo000000080;:d_`050000002b];l0
/[Bo0;:d_`0000000`2b];l01@000000/[Bo0;:d_`2b];l0000000D0/[Bo00<000000;:d_`2b];l0
0P2b];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0000000L0/[Bo00<000000;:d_`2b];l0
102b];l00`000000/[Bo0;:d_`0B0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0000000<0/[Bo00@0
00000;:d_`2b];l000001@2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00L0/[Bo
00<000000;:d_`0000001P2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000D0/[Bo
00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`1Q0;:d_`0507nM^@3Pgn<0h=oS09bLWP3o
ool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`0000000`2b];l010000000/[Bo0;:d_`00
00050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01`2b];l00`000000/[Bo0000
00060;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`0000001@2b];l00`000000/[Bo0;:d
_`020;:d_`030000002b];l0/[Bo00D0/[Bo00D000000;:d_`2b];l0/[Bo000000020;:d_`030000
002b];l0/[Bo00<0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`030;:d_`D00000
0P2b];l00`000000/[Bo0;:d_`050;:d_`030000002b];l0/[Bo00@0/[Bo00<000000;:d_`2b];l0
4P2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0/[Bo000000020;:d_`050000002b];l0/[Bo0;:d_`000000
1@2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00D0/[Bo0P0000020;:d_`030000
002b];l0/[Bo00@0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo000000050;:d_`030000
002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l0H@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l000000080/[Bo00D000000;:d_`2b];l0/[Bo0000
00050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l200000080/[Bo00<0
00000;:d_`2b];l0102b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000D0/[Bo00<0
00000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`050;:d_`040000002b];l0/[Bo000000<0/[Bo
00<000000;:d_`2b];l00`2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00<0/[Bo
00D000000;:d_`2b];l0/[Bo000000020;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b
];l0102b];l00`000000/[Bo0;:d_`0B0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0000000@00000
0P2b];l00`000000/[Bo0;:d_`030;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo000000040;:d
_`800000102b];l00`000000/[Bo0;:d_`040;:d_`H0000000<0/[Bo0000000000000`0000000`2b
];l000000;:d_`030;:d_`030000002b];l0/[Bo0640/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`07
0>3Oh`0609bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo1@0000020;:d_`030000002b];l0/[Bo00<0/[Bo
00L000000;:d_`2b];l0/[Bo0000002b];l0000000@0/[Bo0P0000040;:d_`030000002b];l0/[Bo
00@0/[Bo1P0000000`2b];l0000000000003000000030;:d_`000000/[Bo00<0/[Bo00<000000;:d
_`2b];l01@2b];l500000080/[Bo00<000000;:d_`2b];l00`2b];l01`000000/[Bo0;:d_`2b];l0
00000;:d_`0000001@2b];l00`000000/[Bo000000030;:d_`030000002b];l0/[Bo00D0/[Bo00<0
00000;:d_`2b];l00`2b];l00`000000/[Bo0000000C0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool0
0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0
000000@0/[Bo00<000000;:d_`0000001@2b];l010000000/[Bo0;:d_`0000030;:d_`040000002b
];l0/[Bo000000H0/[Bo00<000000;:d_`2b];l0102b];l00`000000/[Bo0;:d_`020;:d_`030000
002b];l0000000D0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`1Q0;:d_`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`000000102b];l0
0`000000/[Bo000000050;:d_`040000002b];l0/[Bo000000<0/[Bo00@000000;:d_`2b];l00000
1P2b];l00`000000/[Bo0;:d_`040;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`000000
1@2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b];l0
0P2b];l00`000000/[Bo000000050;:d_`040000002b];l0/[Bo000000<0/[Bo00<000000;:d_`2b
];l00P2b];l00`000000/[Bo000000030;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b
];l00P2b];l01@000000/[Bo0;:d_`2b];l000000180/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`03
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0;:d_`00
0000102b];l010000000/[Bo0;:d_`0000030;:d_`050000002b];l0/[Bo0;:d_`0000000`2b];l0
10000000/[Bo0;:d_`0000040;:d_`040000002b];l0/[Bo000000<0/[Bo00<000000;:d_`000000
102b];l00`000000/[Bo000000050;:d_`050000002b];l0/[Bo0;:d_`000000I02b];l01@1oWKT0
h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l0000000@0/[Bo00@0
00000;:d_`2b];l000000`2b];l01@000000/[Bo0;:d_`2b];l0000000<0/[Bo00@000000;:d_`2b
];l00000102b];l010000000/[Bo0;:d_`0000030;:d_`030000002b];l0000000@0/[Bo00<00000
0;:d_`0000001@2b];l01@000000/[Bo0;:d_`2b];l0000000P0/[Bo00<000000;:d_`2b];l00P2b
];l010000000/[Bo0;:d_`0000030;:d_`050000002b];l0/[Bo0;:d_`0000000`2b];l00`000000
/[Bo0;:d_`020;:d_`030000002b];l0000000<0/[Bo00<000000;:d_`2b];l01@2b];l00`000000
/[Bo0;:d_`020;:d_`050000002b];l0/[Bo0;:d_`0000004P2b];l01@1oWKT0h=oS0>3Oh`2LW9h0
oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0
/[Bo00000004000000@0/[Bo0`0000030;:d_`030000002b];l0/[Bo00<0/[Bo00<000000;:d_`2b
];l0100000040;:d_`<000000P2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000@0
000000<0/[Bo0000000000000P00001U0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01P2L
W9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`D00000102b];l3000000<0/[Bo00<000000;:d_`2b];l00`2b
];l00`000000/[Bo0;:d_`04000000@0/[Bo0`0000020;:d_`030000002b];l0/[Bo0080/[Bo00<0
00000;:d_`000000100000000`2b];l0000000000002000000T0/[Bo1@0000040;:d_`<000000`2b
];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l00P2b
];l00`000000/[Bo0;:d_`030;:d_`D0000000<0/[Bo0000002b];l0102b];l00`000000/[Bo0;:d
_`0?0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0/[Bo09X0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0/[Bo0;:d
_`2J0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0
/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0;:d_`2b];l0VP2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@2b];l0/[Bo09X0
/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0/[Bo0;:d_`2J0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230;:d_`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi03/0/[Bo00<000000;:d
_`2b];l0A@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi03/0/[Bo00<000000;:d_`2b];l0A@2b];l0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo000000060?ooo`@000000P3oool500000080oooo1@000000103o
ool000000?ooo`3oool400000080oooo00<000000?ooo`3oool00P3oool00`000000oooo00000004
000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool01000001O0?ooo`0507nM^@3Pgn<0
h=oS09bLWP3oool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`000000102b];l010000000
/[Bo0;:d_`2b];l3000000H0/[Bo00<000000;:d_`2b];l00`2b];l4000000@0/[Bo0`0000020;:d
_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`000000100000000`2b];l00000000000020000
00@0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`020;:d_`050000002b];l00000
0;:d_`000000102b];l00`000000/[Bo000000050;:d_`030000002b];l0000000@0/[Bo00@00000
0;:d_`2b];l0/[Bo0`0000030;:d_`D000005`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo00000005
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000oooo00000005
0?ooo`030000003oool0000000@0oooo00<000000?ooo`000000103oool00`000000oooo00000005
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo05`0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0709bLWP3oool0h=oS0>3Oh`1o
WKT0/[Bo000000030;:d_`050000002b];l0/[Bo0;:d_`0000000`2b];l00`000000/[Bo0;:d_`03
0;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l00P2b];l010000000/[Bo0;:d_`00
00030;:d_`030000002b];l0000000@0/[Bo00<000000;:d_`0000001@2b];l01@000000/[Bo0;:d
_`2b];l0000000P0/[Bo00<000000;:d_`2b];l00P2b];l01@000000/[Bo0000002b];l0000000<0
/[Bo00@000000;:d_`2b];l000001@2b];l00`000000/[Bo000000030;:d_`8000000P2b];l01@00
0000/[Bo0;:d_`2b];l000000080/[Bo00<000000;:d_`2b];l06@2b];l01@1oWKT0h=oS0>3Oh`2L
W9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1o
WKT0oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`00
0000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000103oool00`00
0000oooo000000050?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`1L
0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`00
00000`2b];l010000000/[Bo0;:d_`0000050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d
_`2b];l01`2b];l00`000000/[Bo000000060;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d
_`0000001@2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d
_`2b];l00P2b];l01@000000/[Bo0000002b];l0000000<0/[Bo00@000000;:d_`2b];l0/[Bo1@00
00020;:d_`080000002b];l0/[Bo0000002b];l000000;:d_`0000050;:d_`030000002b];l00000
01/0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3O
h`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`0000000`0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0oooo0080
oooo0P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool010000000
oooo0?ooo`0000060?ooo`800000G`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS07nM^@2b];l000000080/[Bo00D000000;:d_`2b];l0/[Bo000000050;:d_`03
0000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l200000080/[Bo00<000000;:d_`2b
];l0102b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000D0/[Bo00<000000;:d_`2b
];l00P2b];l00`000000/[Bo0;:d_`050;:d_`030000002b];l0/[Bo0080/[Bo00D000000;:d_`00
0000/[Bo000000020;:d_`030000002b];l0/[Bo0080/[Bo00D000000;:d_`2b];l0/[Bo00000002
0;:d_`080000002b];l0/[Bo0000002b];l000000;:d_`0000030;:d_`<0000000<0/[Bo0000002b
];l06P2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0
h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo000000030?ooo`030000003oool0000000@0oooo
00<000000?ooo`000000100000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P0000040?ooo`H0000000<0oooo0000000000000`0000000`3oool0000000000003000000<0oooo
0P00001Q0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01P2LW9h0oooo0>3Oh`3Pgn<0Oifi
0;:d_`D000000P2b];l00`000000/[Bo0;:d_`030;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo
000000040;:d_`800000102b];l00`000000/[Bo0;:d_`040;:d_`H0000000<0/[Bo000000000000
0`0000000`2b];l000000;:d_`030;:d_`030000002b];l0/[Bo00D0/[Bo1P0000000`2b];l00000
0;:d_`05000000@0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo000000020;:d_`030000
002b];l0000000L0/[Bo1@00000G0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo000000040?ooo`030000003oool0000000D0oooo00<0
00000?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0000001S0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool0
1`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`000000102b];l00`000000/[Bo000000050;:d
_`040000002b];l0/[Bo000000<0/[Bo00@000000;:d_`2b];l000001P2b];l00`000000/[Bo0;:d
_`040;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`0000001@2b];l00`000000/[Bo0;:d
_`020;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b];l00P2b];l01@000000/[Bo0000
002b];l0000000@0/[Bo00L000000;:d_`2b];l0/[Bo0000002b];l0000000<0/[Bo00<000000;:d
_`0000000P2b];l00`000000/[Bo000000070;:d_`030000002b];l0/[Bo01T0/[Bo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`0000000`3oool00`000000oooo000000040?ooo`030000003oool0000000@0
oooo00<000000?ooo`0000001@3oool00`000000oooo000000040?ooo`030000003oool0000000@0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000@0
oooo00<000000?ooo`3oool0G03oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN0?oo
o`3Pgn<0h=oS07nM^@2b];l0000000@0/[Bo00@000000;:d_`2b];l000000`2b];l01@000000/[Bo
0;:d_`2b];l0000000<0/[Bo00@000000;:d_`2b];l00000102b];l010000000/[Bo0;:d_`000003
0;:d_`030000002b];l0000000@0/[Bo00<000000;:d_`0000001@2b];l01@000000/[Bo0;:d_`2b
];l0000000P0/[Bo00<000000;:d_`2b];l00P2b];l01@000000/[Bo0000002b];l0000000@0/[Bo
00L000000;:d_`2b];l0/[Bo0000002b];l0000000<0/[Bo0P0000030;:d_`040000002b];l0/[Bo
000000<0/[Bo00@000000;:d_`2b];l000006`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo00000003
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0000000400000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo00000004000000030?ooo`000000000000<000000`3oool4000005l0oooo00D0Oifi
0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0609bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo1@0000040;:d_`<0
00000`2b];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0/[Bo00@00000102b];l300000080
/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo00000004000000030;:d_`00000000000080
00002@2b];l00`000000/[Bo0;:d_`020;:d_`040000002b];l000000;:d_`D000001@2b];l00`00
0000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo0080/[Bo00@000000;:d_`2b];l0/[Bo0`000003
0;:d_`D000005`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?oo
o`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS
09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi
0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS
07nM^@230;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3O
h`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi
08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3O
h`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo
09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b
];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3O
h`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3P
gn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3o
ool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@0k0;:d_`03
0000002b];l0/[Bo04D0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS
00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
1P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS
0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@0k0;:d_`030000002b];l0/[Bo
04D0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3O
h`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`000000100000000`3oool0000000000002000000<0
oooo00D000000?ooo`3oool0oooo000000050?ooo`<000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@00000LP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS07nM^@2b];l0000000@0/[Bo00@000000;:d_`2b];l0/[Bo0`0000060;:d_`03
0000002b];l0/[Bo00<0/[Bo100000040;:d_`<000000P2b];l00`000000/[Bo0;:d_`020;:d_`03
0000002b];l0000000@0000000<0/[Bo0000000000000P0000040;:d_`030000002b];l0/[Bo0080
/[Bo1@0000030;:d_`<000000`2b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000D0
/[Bo00<000000;:d_`000000102b];l010000000/[Bo0;:d_`2b];l3000000<0/[Bo1@00000B0;:d
_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3oool20>3Oh`0307nM^@3oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
K`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l0
000000<0/[Bo00D000000;:d_`2b];l0/[Bo000000030;:d_`030000002b];l0/[Bo00<0/[Bo00<0
00000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`020;:d_`040000002b];l0/[Bo000000<0/[Bo
00<000000;:d_`000000102b];l00`000000/[Bo000000050;:d_`050000002b];l0/[Bo0;:d_`00
0000202b];l00`000000/[Bo0;:d_`040;:d_`050000002b];l0/[Bo0;:d_`0000000P2b];l01@00
0000/[Bo0;:d_`2b];l000000080/[Bo00<000000;:d_`2b];l00`2b];l00`000000/[Bo00000003
0;:d_`8000000P2b];l01@000000/[Bo0;:d_`2b];l000000080/[Bo00<000000;:d_`2b];l0502b
];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3O
h`2LW9h0oooo0P3Pgn<00`1oWKT0oooo000000050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`070>3Oh`0709bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo000000030;:d_`040000002b];l0/[Bo
000000D0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`070;:d_`030000002b];l0
000000H0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo000000050;:d_`030000002b];l0
/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0
/[Bo00<0/[Bo00<000000;:d_`0000000`2b];l010000000/[Bo0;:d_`2b];l500000080/[Bo00P0
00000;:d_`2b];l000000;:d_`000000/[Bo000000D0/[Bo00<000000;:d_`0000005P2b];l01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<00`1oWKT0oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`0000000P3oool00`00
0000oooo0?ooo`040?ooo`800000LP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS07nM^@2b];l000000080/[Bo00D000000;:d_`2b];l0/[Bo000000050;:d_`03
0000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l200000080/[Bo00<000000;:d_`2b
];l0102b];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0000000D0/[Bo00<000000;:d_`2b
];l00P2b];l00`000000/[Bo0;:d_`050;:d_`030000002b];l0/[Bo00<0/[Bo00<000000;:d_`2b
];l00`2b];l00`000000/[Bo000000020;:d_`030000002b];l0/[Bo0080/[Bo00D000000;:d_`2b
];l0/[Bo000000020;:d_`080000002b];l0/[Bo0000002b];l000000;:d_`0000030;:d_`<00000
00<0/[Bo0000002b];l05@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo00000004000000030?ooo`00
0000oooo00<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`000000100000030?ooo`800000M03oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00H0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l500000080/[Bo00<000000;:d_`2b];l00`2b];l0
1`000000/[Bo0;:d_`2b];l000000;:d_`000000102b];l2000000@0/[Bo00<000000;:d_`2b];l0
102b];l6000000030;:d_`000000000000<0000000<0/[Bo0000002b];l00`2b];l00`000000/[Bo
0;:d_`050;:d_`030000002b];l0/[Bo00<0/[Bo00<000000;:d_`2b];l00`2b];l00`000000/[Bo
00000004000000@0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo000000020;:d_`030000
002b];l0000000L0/[Bo1@00000B0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0000000D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo000000040?ooo`030000003oool0000007H0oooo00D0Oifi0>3Oh`3Pgn<0
W9bN0?ooo`070>3Oh`0709bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo000000040;:d_`030000002b];l0
000000D0/[Bo00@000000;:d_`2b];l000000`2b];l010000000/[Bo0;:d_`0000060;:d_`030000
002b];l0/[Bo00@0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo000000050;:d_`030000
002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l00`000000/[Bo0;:d_`030;:d_`030000
002b];l0/[Bo00<0/[Bo00<000000;:d_`000000102b];l01`000000/[Bo0;:d_`2b];l000000;:d
_`0000000`2b];l00`000000/[Bo000000020;:d_`030000002b];l0000000L0/[Bo00<000000;:d
_`2b];l0502b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo000000050?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000oooo0?oo
o`1_0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d
_`000000102b];l010000000/[Bo0;:d_`0000030;:d_`050000002b];l0/[Bo0;:d_`0000000`2b
];l010000000/[Bo0;:d_`0000040;:d_`040000002b];l0/[Bo000000<0/[Bo00<000000;:d_`00
0000102b];l00`000000/[Bo000000050;:d_`050000002b];l0/[Bo0;:d_`000000202b];l00`00
0000/[Bo0;:d_`040;:d_`050000002b];l0/[Bo0;:d_`0000000P2b];l00`000000/[Bo0;:d_`02
0;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo000000030;:d_`8000000`2b];l010000000/[Bo
0;:d_`0000030;:d_`040000002b];l0/[Bo000001H0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`03
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`00
0000100000000`3oool0000000000002000000<0oooo00<000000?ooo`000000100000030?ooo`<0
00000`3oool5000000<0oooo1000001b0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01P2L
W9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`D00000102b];l3000000<0/[Bo00<000000;:d_`2b];l00`2b
];l00`000000/[Bo0;:d_`04000000@0/[Bo0`0000020;:d_`030000002b];l0/[Bo0080/[Bo00<0
00000;:d_`000000100000000`2b];l0000000000002000000T0/[Bo00<000000;:d_`2b];l01@2b
];l3000000<0/[Bo1@0000050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l00P2b
];l010000000/[Bo0;:d_`2b];l3000000<0/[Bo1@00000B0;:d_`0507nM^@3Pgn<0h=oS09bLWP3o
ool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3o
ool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1o
WKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0
h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3o
ool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`03
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3o
ool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@23
0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0
h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`07
0>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J
0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0
W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS
00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi03/0/[Bo00<000000;:d_`2b];l0702b];l6000002<0/[Bo00D0Oifi
0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oo
o`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN
0?ooo`3Pgn<0h=oS07nM^@0k0;:d_`030000002b];l0/[Bo04D0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN
0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi
0?ooo`0000001@3oool00`000000oooo0?ooo`04000000@0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`040000003oool0oooo0?ooo`<000000`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00@00000J`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0W9bN0?ooo`3P
gn<0h=oS07nM^@2b];l0000000@0/[Bo00@000000;:d_`2b];l0/[Bo0`0000060;:d_`030000002b
];l0/[Bo00<0/[Bo100000040;:d_`<000000P2b];l00`000000/[Bo0;:d_`020;:d_`030000002b
];l0000000@0000000<0/[Bo0000000000000P0000040;:d_`030000002b];l0/[Bo00@0/[Bo00D0
00000;:d_`2b];l0/[Bo000000030;:d_`040000002b];l0/[Bo0;:d_`D0000000<0/[Bo00000000
00000`0000070;:d_`030000002b];l0000000<000007@2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo
00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
000000050?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`000003
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0J03oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00L0W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l0000000<0/[Bo00D000000;:d
_`2b];l0/[Bo000000030;:d_`030000002b];l0/[Bo00<0/[Bo00<000000;:d_`2b];l00P2b];l0
0`000000/[Bo0;:d_`020;:d_`040000002b];l0/[Bo000000<0/[Bo00<000000;:d_`000000102b
];l00`000000/[Bo000000050;:d_`050000002b];l0/[Bo0;:d_`0000002P2b];l01@000000/[Bo
0;:d_`2b];l0000000<0/[Bo00D000000;:d_`2b];l0/[Bo000000050;:d_`030000002b];l0/[Bo
00T0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo0;:d_`0J0;:d_`0507nM^@3Pgn<0h=oS
09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`03
07nM^@3oool0oooo00D000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06P0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0709bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo000000030;:d_`040000
002b];l0/[Bo000000D0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d_`070;:d_`03
0000002b];l0000000H0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo000000050;:d_`03
0000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l01`2b];l01@000000/[Bo0;:d_`2b];l00000
00<0/[Bo00D000000;:d_`2b];l0/[Bo000000050;:d_`030000002b];l0/[Bo00T0/[Bo00<00000
0;:d_`000000102b];l00`000000/[Bo0;:d_`0I0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0407nM^@3oool0oooo
000000<0oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool000000080oooo
00<000000?ooo`3oool0103oool2000006/0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`07
09bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo000000020;:d_`050000002b];l0/[Bo0;:d_`0000001@2b
];l00`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00D0/[Bo0P0000020;:d_`030000002b
];l0/[Bo00@0/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo000000050;:d_`030000002b
];l0/[Bo0080/[Bo00<000000;:d_`2b];l01`2b];l01@000000/[Bo0;:d_`2b];l0000000<0/[Bo
00D000000;:d_`2b];l0/[Bo000000050;:d_`030000002b];l0/[Bo00T0/[Bo00<000000;:d_`00
0000102b];l00`000000/[Bo0;:d_`0I0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0707nM^@3oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`H0000000<0oooo0000003oool0103oool00`000000oooo00000004000000<0oooo0P00001]
0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01P2LW9h0oooo0>3Oh`3Pgn<0Oifi0;:d_`D0
00000P2b];l00`000000/[Bo0;:d_`030;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo00000004
0;:d_`800000102b];l00`000000/[Bo0;:d_`040;:d_`H0000000<0/[Bo0000000000000`000000
0`2b];l000000;:d_`030;:d_`030000002b];l0/[Bo00L0/[Bo00D000000;:d_`2b];l0/[Bo0000
00030;:d_`050000002b];l0/[Bo0;:d_`0000001@2b];l5000000L0/[Bo00<000000;:d_`000000
102b];l00`000000/[Bo0;:d_`0I0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0707nM^@3oool0oooo0?ooo`000000
oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo000000040?oo
o`030000003oool0000006l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0709bLWP3oool0
h=oS0>3Oh`1oWKT0/[Bo000000040;:d_`030000002b];l0000000D0/[Bo00@000000;:d_`2b];l0
00000`2b];l010000000/[Bo0;:d_`0000060;:d_`030000002b];l0/[Bo00@0/[Bo00<000000;:d
_`2b];l00P2b];l00`000000/[Bo000000050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d
_`2b];l01`2b];l01@000000/[Bo0;:d_`2b];l0000000<0/[Bo00D000000;:d_`2b];l0/[Bo0000
00050;:d_`030000002b];l0/[Bo00T0/[Bo00<000000;:d_`000000102b];l00`000000/[Bo0;:d
_`0I0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0707nM^@3oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
000000@0oooo00<000000?ooo`3oool0J03oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00L0
W9bN0?ooo`3Pgn<0h=oS07nM^@2b];l0000000@0/[Bo00@000000;:d_`2b];l000000`2b];l01@00
0000/[Bo0;:d_`2b];l0000000<0/[Bo00@000000;:d_`2b];l00000102b];l010000000/[Bo0;:d
_`0000030;:d_`030000002b];l0000000@0/[Bo00<000000;:d_`0000001@2b];l01@000000/[Bo
0;:d_`2b];l0000000X0/[Bo00D000000;:d_`2b];l0/[Bo000000030;:d_`050000002b];l0/[Bo
0;:d_`0000001@2b];l00`000000/[Bo0;:d_`090;:d_`030000002b];l0000000<0/[Bo00<00000
0;:d_`2b];l06P2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?oo
o`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo00000004000000030?ooo`000000oooo
00<0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`D000000`3oool4000006/0oooo00D0Oifi
0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0609bLWP3oool0h=oS0>3Oh`1oWKT0/[Bo1@0000040;:d_`<0
00000`2b];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0/[Bo00@00000102b];l300000080
/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo00000004000000030;:d_`00000000000080
00002@2b];l5000000030;:d_`000000/[Bo00D0000000<0/[Bo0000002b];l0102b];l5000000L0
/[Bo00<000000;:d_`0000000`00000M0;:d_`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo09X0oooo
00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0P`2b];l01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1a
Kf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0VP3oool01@1o
WKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@230;:d_`0507nM^@3P
gn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0
lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool2
0>3Oh`0307nM^@3oool0oooo09X0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3o
ool0h=oS0>3Oh`1oWKT0P`2b];l01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2J0?ooo`0507nM^@3P
gn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08<0/[Bo00D0Oifi0>3Oh`3P
gn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS
WP1oWKT20>3Oh`0309bLWP3oool0h=oS00H0h=oS00@0W9bN0?ooo`3Pgn<0h=oSQ@1oWKT20>3Oh`03
09bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooXP3P
gn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS08P0h=oS00<0W9bN0?ooo`3Pgn<00P3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooonR0>3Oh`0309bLWP3oool0h=oS
00H0h=oS00<0W9bN0?ooo`3Pgn<0R03Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS
00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
1P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oooj80h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo
0>3Oh`280>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3O
h`2LW9h0ooooXP3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS08P0h=oS00<0W9bN
0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooonR0>3Oh`03
09bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0R03Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oooj80h=oS00<0W9bN0?ooo`3Pgn<01P3P
gn<00`2LW9h0oooo0>3Oh`280>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?oo
o`3Pgn<0h=oS0>3Oh`2LW9h0ooooXP3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS
08P0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bL
WP3ooonR0>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0R03Pgn<00`2LW9h0oooo
0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`L0h=oS00<00000
0>3Oh`3Pgn<00P3Pgn<2000000050>3Oh`000000h=oS0000003Pgn<00P0000020>3Oh`030000003P
gn<0h=oS00<000000`3Pgn<3000007l0h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo0>3O
h`060>3Oh`<000000`3Pgn<300000080h=oS00<000000>3Oh`3Pgn<00P000000103Pgn<000000>3O
h`0000020>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3Oh`030000
05d0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bL
WP3oool70>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<2000000030>3Oh`00000000000080
h=oS00D000000>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<0O03Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS00D0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS000000020>3Oh`800000
00D0h=oS0000003Pgn<0h=oS000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS0>3Oh`1J0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo1`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000P0h=oS00<000000>3Oh`3P
gn<0O@3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS00@0h=oS00<000000>3Oh`3P
gn<0103Pgn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS000000030>3Oh`030000003P
gn<000000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0h=oS0080
h=oS00<000000>3Oh`3Pgn<0F`3Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3o
ool0h=oS0>3Oh`3Pgn<0W9bN00D0oooo0`3Pgn<00`000000h=oS0>3Oh`020>3Oh`@0000000<0h=oS
0000003Pgn<00P3Pgn<010000000h=oS0000003Pgn<500000080h=oS0P0000040>3Ohg`0oooo00<0
W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`030>3Oh`000000h=oS00D0h=oS00T0
00000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3O
h`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3Oh`02000000@0h=oSFP3o
ool00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS0>3Oh`3Pgn<609bLWP<0
h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`040000003Pgn<0000000000080h=oS00D00000
0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0O@2L
W9h00`3oool0h=oS0>3Oh`050>3Oh`H0W9bN00<0h=oS0000003Pgn<01@3Pgn<02@000000h=oS0>3O
h`3Pgn<000000>3Oh`000000h=oS000000030>3Oh`050000003Pgn<000000000003Pgn<00P000000
0`3Pgn<000000>3Oh`0200000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`1K
09bLWP060?ooo`3Pgn<0h=oS0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS00X0h=oS00<000000>3Oh`3P
gn<00P3Pgn<300000080h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS0>3Oh`030000
00<0h=oS0`00002?0>3Oh`030000003Pgn<0h=oS00D0h=oS0`0000020>3Oh`030000003Pgn<00000
00<0h=oS00D000000>3Oh`000000h=oS000000020>3Oh`050000003Pgn<0h=oS0000003Pgn<00P00
00030>3Oh`<00000HP3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<02P3Pgn<00`000000h=oS
0>3Oh`070>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0V@3Pgn<01@000000h=oS
0>3Oh`3Pgn<0000000L0h=oS00<000000>3Oh`3Pgn<0N@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3O
h`3Pgn<0203Pgn<5000000L0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`2J0>3O
h`<00000203Pgn<00`000000h=oS0>3Oh`1i0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o
0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo
0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3P
gn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`040?ooo`3Pgn<0h=oS0>3Ohol0oooo>`3oool30>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS
0>3Oh`3Pgn?o09bLWSX0W9bN00H0oooo0>3Oh`3Pgn<0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3O
h`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Ohol0Oifi<`1oWKT20>3Oh`0309bLWP3oool0h=oS
0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
0?ooo`3o0?oooah0oooo00<0k>gd08^<V@2MWZ/0302MWZ/00`2:RiT0];Nn07nM^@020>3Oh`0309bL
WP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0U9FR0=gNh@3If^@0303If^@00`3Mg^40U9FR07nM^@02
0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<00`1oWKT0oooo0000003o0?oooah0oooo00<0U9FR0?ooo`3;c=X0303;c=X00`3oool0
U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo
07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0000003o0?oooah0oooo00<0U9FR0?ooo`3;c=X0303;
c=X00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@2b];l0/[Bo00@000000P2b];l01P000000/[Bo0;:d_`2b];l000000;:d_`80000000<0/[Bo0000
002b];l00P000000102b];l000000;:d_`2b];l3000000<0/[Bo0P0000000`2b];l000000;:d_`06
0;:d_`030000002b];l0/[Bo05<0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0101oWKT0oooo0000003oool2000000<0
oooo0P0000001@3oool000000?ooo`000000oooo008000000P3oool00`000000oooo000000020?oo
o`<000000P3oool01@000000oooo0?ooo`3oool000000080oooo0`0000020?ooo`030000003oool0
oooo0?<0oooo00<0U9FR0?ooo`3;c=X0303;c=X00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0
h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0000000@0/[Bo00<000000;:d_`0000000`2b
];l00`000000/[Bo000000020;:d_`030000002b];l000000080/[Bo00<000000;:d_`0000000`2b
];l00`000000/[Bo000000020;:d_`8000001`2b];l00`000000/[Bo0;:d_`1C0;:d_`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00@0Oifi0?ooo`00000000000P3oool00`000000oooo000000020?ooo`80000000<0oooo0000
000000000P3oool01`000000oooo0000003oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000m@3oool00`2DUJ80oooo0<_<
fP050<_<fP0303lm?@3;c=X0blcJ00@0blcJ00<0oooo09BEXP1oWKT00P3Pgn<00`2LW9h0oooo0>3O
h`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0/[Bo000000040;:d_`030000002b];l0000000<0/[Bo
00<000000;:d_`0000000P2b];l00`000000/[Bo000000020;:d_`030000002b];l0000000D0/[Bo
00H000000;:d_`2b];l0/[Bo0000002b];l3000000<0/[Bo00<000000;:d_`2b];l0D`2b];l00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`050000003oool000000?ooo`000000103oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool0l`3oool00`2DUJ80oooo0<c=f`040<c=f`<0
?cdm1@3<cM/00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@2b];l0000000@0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo000000020;:d
_`030000002b];l000000080/[Bo00<000000;:d_`000000100000000`2b];l000000;:d_`020;:d
_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b];l0D`2b];l00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003o
ool000000?ooo`0000000P3oool2000000<0oooo00H000000?ooo`3oool0oooo0000003oool50000
00030?ooo`000000oooo0?@0oooo00<0U9FR0?ooo`3Ad^000`3Ad^0503lm?@@0dM;P00<0oooo09BE
XP1oWKT00P3Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0/[Bo00000004
0;:d_`040000002b];l0000000000080/[Bo00<000000;:d_`0000000P2b];l00`000000/[Bo0000
00020;:d_`030000002b];l0000000<0/[Bo00<000000;:d_`0000000P2b];l2000000L0/[Bo00L0
00000;:d_`2b];l0/[Bo0000002b];l0000004l0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0101oWKT0oooo00000000
00020?ooo`030000003oool0000000<0oooo00@000000?ooo`00000000000P3oool01`000000oooo
0000003oool000000?ooo`0000000`3oool010000000oooo0000000000020?ooo`030000003oool0
000000<0oooo00@000000?ooo`0000000000m03oool00`2DUJ80oooo0=WJi0020=WJi0<0?cdm00@0
fM[T03lm?@0o?Cd0?cdm0`3If^@00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@2b];l0000000@0/[Bo00@000000;:d_`000000/[Bo0P0000001@2b
];l00000000000000000/[Bo00@0000000@0/[Bo0000002b];l0/[Bo0`0000030;:d_`80000000<0
/[Bo0000002b];l0102b];l00`000000/[Bo000000040;:d_`030000002b];l0/[Bo04h0/[Bo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0
oooo0P3Pgn<0101oWKT0oooo0000003oool200000080oooo00P000000?ooo`3oool0oooo0000003o
ool000000?ooo`8000000P3oool00`000000oooo000000020?ooo`<000000P3oool010000000oooo
0000000000030?ooo`<000000P3oool00`000000oooo0000003c0?ooo`0409BEXP3oool0fM[T0=WJ
i0<0?cdm0`3If^@303lm?@80fM[T00<0oooo09BEXP1oWKT00P3Pgn<00`2LW9h0oooo0>3Oh`020>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0/[Bo000000040;:d_`030000002b];l0/[Bo00D0/[Bo00<00000
0;:d_`2b];l00P2b];l010000000/[Bo0;:d_`00000;0;:d_`030000002b];l0/[Bo00@0/[Bo0P00
00030;:d_`<00000C`2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0
oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo00/0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0oooo00<0U9FR0?ooo`3S
hn/00P3Shn/00`0o?Cd0hn?[0>?Sj`030>?Sj`0703lm?@3Shn/0hn?[0>?Sj`3oool0U9FR07nM^@02
0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0000000@0/[Bo00<0
00000;:d_`2b];l01@2b];l01P000000/[Bo0;:d_`000000/[Bo00000080/[Bo00<000000;:d_`2b
];l02@2b];l00`000000/[Bo0;:d_`050;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b
];l0CP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo00/0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo000000070?ooo`030000003oool0oooo0?l0oooo00<0U9FR0?ooo`3/k?40303/k?40
0`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b
];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0U9FR0?ooo`3d
m?L0303dm?L00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0
U9FR0?ooo`3ko?`0303ko?`00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oo
oah0oooo00<0U9FR0?ooo`3oool03@3oool01P2DUJ80Oifi0>3Oh`3Pgn<0W9bN0?ooo`<0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oo
oah0oooo00<0U9FR0=KFf`3oool0303oool00`3Fe]/0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS
0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
0?ooo`3o0?oooal0oooo00<0Si2N0;Fe_P2d];h01@2d];d02@2c];d0];Bm0;Bd_@2c];d0];Bm0;>c
_@2<SI`0];Nn07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Ohh80Oifi00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn?o07nM
^C<0Oifi0P3Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3P
gn<0LFmT00D0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3P
gn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`060?ooo`3Pgn<0
h=oS0>3Oh`2LW9h0ooooo`3Pgn<g0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooool0h=oS=`3P
gn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0
h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0ooooo`3Pgn<g0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooool0h=oS=`3Pgn<00`2LW9h0
oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@03`3Pgn<3000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS
0000003Pgn<0h=oS0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<3000000<0h=oS
0`0000020>3Oh`030000003Pgn<0h=oS05H0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooo`3Pgn<g0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ
075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I00>0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`02000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0F03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0
h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00d0h=oS00<000000>3Oh`3Pgn<00P000000103Pgn<000000>3Oh`0000030>3Oh`030000
003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000P0h=oS00<000000>3O
h`3Pgn<0F@3Pgn<01@3akn8000000>3Oh`3Pgn<0LFmT00D0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bL
WP3oool70>3Oh`<000000`3Pgn<300000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`3Pgn<00`0000030>3Oh`<000000P3Pgn<2000000040>3Oh`000000h=oS
0>3Oh`<000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000?`0h=oS00<0W9bN0?ooo`3Pgn<00P3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00d0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000000@0000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS0000000400000080h=oS
0P00001L0>3Oh`050?7_hP00000000000>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`H0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS0>3Oh`3j0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00=0>3Oh`03
0000003Pgn<0h=oS00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`04
0000003Pgn<0000000000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS05P0h=oS00D0lNoR0000000000000000075_I0050>3Oh`060?ooo`3Pgn<0
h=oS0>3Oh`2LW9h0oooo1@3Pgn<00`000000h=oS0>3Oh`040>3Oh`070000003Pgn<0h=oS0>3Oh`00
0000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000001@3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0h=oS0?X0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00d0h=oS
00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS00<00000
0P3Pgn<01@000000h=oS0000003Pgn<000000080h=oS0`0000030>3Oh`<000000P3Pgn<00`000000
h=oS0>3Oh`1F0>3Oh`050?7_hP00000000000>3Oh`1aKf@01@3Pgn<01@3oool0h=oS0>3Oh`3Pgn<0
W9bN00D0oooo00<0h=oS0000003Pgn<01@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003Pgn<0
103Pgn<01P000000h=oS0>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`3j0?ooo`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00>0>3Oh`050000003Pgn<0
h=oS0>3Oh`000000N@3Pgn<01@3akn8000000>3Oh`3Pgn<0LFmT00D0h=oS00@0oooo0>3Oh`3Pgn<0
h=oS1P2LW9h00`3Pgn<000000>3Oh`050>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P000002
0>3Oh`040000003Pgn<0000000000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<0h=oS0?/0W9bN00H0oooo0>3Oh`3Pgn<0h=oS09fMX@1aKf@50>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00l0h=oS0`00000C
0>3Oh`030000003Pgn<0h=oS06@0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`030?ooo`3P
gn<0h=oS00P0h=oS00<000000>3Oh`3Pgn<01@3Pgn<300000080h=oS00@000000>3Oh`0000000000
0P3Pgn<010000000h=oS0000000000030>3Oh`<000000`3Pgn<3000000060>3Oh`00000000000000
003Pgn<000000P3Pgn<300000080h=oS00@000000>3Oh`0000000000o`3Pgn<30>3Oh`0309fMX@1a
Kf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<02@3Pgn<01@000000
h=oS0>3Oh`3Pgn<0000001l0h=oS00<000000>3Oh`3Pgn<0o`3Pgn<?0>3Oh`0309fMX@1aKf@0h=oS
00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<0
1@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<02P3Pgn<300000200h=oS00@0
00000>3Oh`3Pgn<00000o`3Pgn<>0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT
00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3P
gn<0LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS
0>3Oh`3Pgn<0LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3a
kn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0
h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03P
gn<01@3akn80h=oS0>3Oh`000000LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0S03Pgn<01@3akn80h=oS000000000000LFmT00D0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@0S03Pgn<01@3akn800000000000000000LFmT00D0h=oSo`3ooom30?ooo`03075_I03P
gn<0h=oS00<0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
S03Pgn<01@3akn80h=oS000000000000LFmT0?l0h=oSCP3Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0000001aKf@0o`3Pgn=>
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0h=oS00D0
lNoR0>3Oh`3Pgn<0h=oS075_I03o0>3Ohdh0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT0?l0h=oSCP3Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@0o`3Pgn=>0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWj>075_I0<0h=oSo`1aKfA?075_I0040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWko0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0
h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`2c/:<0
SHQj0?ooo`3o0>3Ohm/0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0
h=oS00<0e/o60;>`Z`3_jnL0o`3Pgn?K0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWko0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0
h=oS00<0inOW0?ooo`3onol04@3Pgn<01@3oool000000?ooo`3Pgn<0oooo01@0h=oS00<0oooo0>3O
h`3Pgn<0D`3Pgn<00`3bl_80h=oS0>3Oh`3o0>3OheP0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0/k2S08f8NP3oool02P3Pgn<02`3oool0l_;b0?ooo`3bl_80
oooo0>3Oh`0=3@d0h=oS00d=3@3Pgn<03@d=00`0h=oS1P3oool20>3Oh`030000003oool0h=oS00`0
h=oS2@3oool?0>3Oh`0:0?;blP3oool0l_;b0?ooo`3bl_80oooo0?;blP3oool0l_;b0?ooo``0h=oS
2@3oool@0>3Oh`030?;blP0=3@d0l_;b01@0h=oS00<06a/K0?ooo`3Pgn<0o`3Pgn=20>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030=K?aP2c/:/0kn_W00T0h=oS
00D03@d=0000000=3@d0000000d=3@020>3Oh`060?;blP0=3@d0l_;b00d=3@3Pgn<0oooo2P3Pgn<6
00000080h=oS00<0oooo0000003oool00P3oool:0>3Oh`X0000000<0oooo0>3Oh`3Pgn<0303Pgn<0
2P0=3@d0000000d=3@0000003@d=0000000=3@d0000000d=3@3bl_8;0>3Oh`T0<c<c00<0oooo0>3O
h`3Pgn<03@3Pgn<01@3bl_803@d=0000003oool0l_;b00l0h=oS00X0oooo0?;blP3oool0l_;b02PX
:00K6a/0oooo0?;blP3oool0l_;bo`3Pgn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh?0>3Oh`0=0000003oool0c/c`0=WGn`34`nT0h=oS0000000=3@d0l_;b00d=3@3b
l_803@d=0000000:0>3Oh`070000003oool0i^Ko0;Bdc03Vi_l0Z:O10>3Oh`05000000X0h=oS00<0
00000?ooo`1VIVH01P3oool0101VIVH0c<c<0000003oool:0>3Oh`0=0?ooo`3bl_80oooo0000003o
ool0_kno0?ooo`3bl_80oooo0?;blP3oool000000?ooo`0;0>3Oh`0403<c<`3oool0c<c<0<c<c0<0
VIVI00<0IVIV03<c<`3oool03P3Pgn<0203bl_803@d=0<;2lP3?col0000000d=3@3bl_80oooo303P
gn<02`0=3@d0000000d=3@0000003@d=01/K6`3Bde<06a/K08n?S`3bl_80oooo0?l0h=oS?`3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`3WinL0oooo0?oko`09
0>3Oh`0500d=3@3bl_80emGj0<k<l03Jeo`00`3Pgn<01@0=3@d0l_;b00d=3@3Pgn<0oooo00X0h=oS
00H000000?ooo`2d]<`0i^Ko0;Bdc03Vi_l30>3Oh`030000003oool0h=oS00X0h=oS00@000000?oo
o`1VIVH0oooo103<c<`01@3oool0IVIV0<c<c0000000oooo00T0h=oS00h0oooo0000000=3@d00000
00d=3@3bl_803@d=0;no_`3<c<`0_kno0<c<c03bl_803@d=0?;blP/0h=oS00X0<c<c0?ooo`2IVIT0
c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo3P3Pgn<02@0=3@d0TI7209jNc`2ATL80cloo0<;2lP0=
3@d000000?ooo`0;0>3Oh`0;0000003oool0c/c`0=WGn`34`nT0:2PX0<G6AP2nCV406a/K0?ooo`3b
l_80o`3Pgn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`03
0;>`X`2=R7X0oooo00T0h=oS00`000000?ooo`33`^L0e]Ci0<g;k`3KfOd0h=oS00d=3@3Pgn<03@d=
0?;blP0=3@d;0>3Oh`0:0000003oool0i^Ko0;Bdc03Vi_l0];C<0>KVo`2XYl40h=oS000000`0h=oS
00@000000?ooo`1VIVH0oooo103<c<`01@3oool0IVIV0<c<c0000000oooo00T0h=oS00h000000?oo
o`1QHF40oooo0000003oool000000<c<c02o_kl0c<c<0;no_`3oool000000?ooo`/0h=oS00X0<c<c
0?ooo`2IVIT0c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo3P3Pgn<02P000000WYk?096A`P2NW/l0
TI7209jNc`32`_80cloo0000003oool:0>3Oh`0;00d=3@3bl_80emGj0<k<l03Jeo`0alGZ02PX:035
aTH0_TiQ01/K6`3oool0o`3Pgn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh30>3Oh`030=K?aP2c/:/0kn_W00T0h=oS00H03@d=0?;blP37a^d0`L3V0=CCn03<b^h30>3O
h`030000003Pgn<0h=oS00/0h=oS00P000000?ooo`2VY/00i^Ko0;Bdc03Vi_l0];C<0>KVo`h0h=oS
00<000000?ooo`1VIVH01P3oool0101VIVH0c<c<0000003oool90>3Oh`0>00d=3@3bl_80KVi^0?;b
lP0=3@d0l_;b0<c<c03bl_80oooo0?;blP3oool0l_;b00d=3@3bl_8;0>3Oh`0:03<c<`3oool0VIVI
0<c<c01VIVH0VIVI03<c<`1VIVH0<c<c0?ooo`/0h=oS00d0l_;b0?ooo`3bl_80oooo0000002NW/l0
TI7200d=3@2ATL80WYk?0<;2lP0=3@d0l_;b00X0h=oS00/000000?ooo`33`^L0e]Ci0<g;k`3KfOd0
6a/K0=;CD`2a@E@0:2PX0?;blP3o0>3Ohcl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOPl0h=oS00P000000?ooo`2b/]T0aLC/0;nni03BdOH0blW^0=[Io@l0h=oS00/00000
0?ooo`3<c>D0YZK00>KVo`2d]<`0i^Ko0;Bdc03Vi_l000000?ooo`0;0>3Oh`030000003oool0IVIV
00L0IVIV00<0c<c<0000003oool02@3Pgn<03P000000oooo065QH@3oool0000003dmKP0`<640?Ce^
030`H@0m?Fh0<31Q03dmKP000000oooo2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0
IVIV03<c<`3oool;0>3Oh`0>00d=3@0000003@d=0000003oool0000000d=3@3Pgn<03@d=096A`P2N
W/l0`/;b00d=3@3bl_890>3Oh`0<00d=3@3bl_80alK]0<70iP3DdoP0c<[^0=_Io@0K6a/0d]=C0;51
E00X:2P0l_;bo`3Pgn<n0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh3
0>3Oh`030>OWi`3oool0oo_o00T0h=oS00/03@d=0?;blP2h^N40/K7H0<?3jP2n_N<0d=3f0<[8k03K
f?`000000?ooo`0<0>3Oh`0;0000003oool0Rh^T0<c<i@2VY/00i^Ko0;Bdc03Vi_l0];C<0000003o
ool02`3Pgn<00`000000oooo0<c<c0070?ooo`030<c<c0000000oooo00T0h=oS00h03@d=0?;blP1^
KVh0l_;b00d=3@0000003@d=0000000=3@d0000000d=3@0000003@d=0?;blP/0h=oS00X0<c<c0?oo
o`2IVIT0c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo2`3Pgn<03P000000cloo096A`P0=3@d0l_;b
0>3Oh`000000oooo0>3Oh`0=3@d0TI720<o?o`000000oooo2@3Pgn<030000000oooo0;:bf@35a>`0
_kkT0=;AmP3;bNh0:2PX0<G6AP2nCV406a/K0?ooool0h=oS?P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`2c/:<0SHQj0?ooo`090>3Oh`0;0000003oool0XZC=
0;Ffh02_/=L0`L7X0;^jh@3?c_@0000000d=3@3bl_80303Pgn<020000000oooo0;Bdc02;Rj@0c<cU
0:JV`03Vi_l0];C<0P0000000`3oool0h=oS0>3Oh`090>3Oh`030000003oool0IVIV00<0c<c<0`00
0000103oool0c<c<0000003oool90>3Oh`0<0000003oool0HF5Q06i^KP1QHF40KVi^065QH@1^KVh0
HF5Q0<o?c`000000oooo3@3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3o
ool;0>3Oh`0>00d=3@32`_80WYk?096A`P0=3@d0l_;b00d=3@000000oooo0000000=3@d0000000d=
3@3bl_890>3Oh`0=00d=3@3bl_80^;WQ0;6af033`nX0_[gS0=3@mP3:b>`0:2PX0<G6AP2nCV406a/K
0?ooo`3o0>3Ohcd0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS
00<0e/o60;>`Z`3_jnL02@3Pgn<02P0=3@d0l_;b0:VZe02QX/`0];GN0:j^eP2o_nL0000000d=3@3b
l_8=0>3Oh`070000003oool0P82I0;Bdc02;Rj@0c<cU0:JV`002000000030?ooo`3Pgn<0h=oS00X0
h=oS00<000000?ooo`1VIVH00`3<c<`01`000000c<c<0000003oool0c<c<0000003oool02@3Pgn<0
300=3@d0l_;b0<o?c`3bl_80oooo0?;blP3oool0l_;b0?ooo`32`/803@d=0?;blPd0h=oS00@0<c<c
0?ooo`3<c<`0c<c<0`2IVIT0101VIVH0<c<c0?ooo`3oool;0>3Oh`0900d=3@32`_80WYk?096A`P0=
3@d0TI7209jNc`000000oooo00d0h=oS00d000000?ooo`2RY<d0]KKP0:n`e`31`NP0^k[Q0<o>m00K
6a/0d]=C01/K6`0X:2P0l_;b0?l0h=oS?@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn3`3Pgn<02P000000oooo09NI``2XZ]<0Wj3:0;:cg0000000cloo0000003oool=0>3O
h`0:0000003oool0];C<0820V@2d]<`0Rh^T0000003<c?l000000?ooo``0h=oS00<000000?ooo`1V
IVH00`3<c<`01`000000c<c<0000003oool0c<c<0000003oool02@3Pgn<030000000oooo065QH@3?
cll0`/;200d=3@0000003@d=0?;blP3?cll000000?ooo``0h=oS2`0c<c<00`3oool0h=oS0>3Oh`09
0>3Oh`0:0000003?col0`/;b09jNc`2ATL80WYk?096A`P2NW/l000000?ooo``0h=oS00h03@d=0?;b
lP2YZ]@0XJ;<0;BegP2^[]H0_koW0000000=3@d06a/K0;V=C@2a@E@0:2PX0?;bl_l0h=oS?03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`3WinL0oooo0?oko`09
0>3Oh`0:00d=3@3bl_80oooo0?;blP3oool0l_;b0?ooo`000000oooo0;Jf]Pd0h=oS00<000000?oo
o`3oool0103oool00`000000oooo0>3Oh`0<0>3Oh`030000003oool0IVIV00<0oooo0`0000020?oo
o`030000003Pgn<0h=oS00P0h=oS00`03@d=0?;blP1^KVh0`/;20<o?c`000000clo?0000003oool0
`/;200d=3@3bl_8<0>3Oh`0303<c<`3<c<`0c<c<0080c<c<102IVIT00`1VIVH0<c<c0?ooo`0<0>3O
h`090000000=3@d0`/;b0<o?o`2ATL80WYk?096A`P0=3@d0l_;b00`0h=oS00h000000?ooo`2GVL<0
Z:[C09nPbP2b/m`000000<o?o`000000:2PX0=V_[@3V_;X06a/K0?ooool0h=oS?03Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`2c/:<0SHQj0?ooo`090>3Oh`0:
0000000=3@d0000000d=3@0000003@d=0000000=3@d0][Jf0<?3``d0h=oS2000000?0>3Oh`X00000
2`3Pgn<030000000oooo065QH@3oool0l_;b00d=3@0000003@d=0?;blP3oool000000?ooo``0h=oS
2`0c<c<?0>3Oh`0500d=3@000000cloo0<;2lP0=3@d03P3Pgn<03P0=3@d0l_;b0?ooo`3bl_80oooo
0?;blP3oool000000?ooo`2f][H0:2PX0=V_[@0X:2P0l_;bo`3Pgn<l0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030=K?aP2c/:/0kn_W04d0h=oS00X0000000d=
3@0000003@d=0000000=3@d0000000d=3@000000oooo4@3Pgn<303<c<aD0h=oS00<0000000d=3@3P
gn<03P3Pgn<03P0000003@d=0000000=3@d0000000d=3@0000003@d=0;Jf]P33`l<06a/K02PX:02;
Rh/0ooooo`3Pgn<l0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj60>3O
h`0300d=3@3Pgn<0h=oS0?l0h=oSF03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIno`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3O
hn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0WIfQ0?l0oooogP3oool01@2MWJ40oooo06IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko09fMXN00WIfQ00@0oooo06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO_l0h>;[h@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIno`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWko0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h>;[h@3P
h^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInE@3Ph^/00`000000h>;[0>3R
j`3o0>3RjhT0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUD0h>;[00<0
00000>3Rj`3Ph^/0o`3Ph^^90>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh60>3Rj`030000003Ph^/0h>;[00<0h>;[00<000000>3Rj`0000000P3Ph^/300000140h>;[00D0
00000>3Rj`3Ph^/0h>;[000000020>3Rj`<000000`3Ph^/01@000000h>;[0>3Rj`3Ph^/0000000l0
h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[0>3Rj`0300000080h>;[00<000000>3Rj`00
00000`00003o0>3RjhP0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0
h>;[00<000000>3Rj`3Ph^/00`3Ph^/01@000000h>;[0000003Ph^/0000000<0h>;[00<000000>3R
j`3Ph^/03P3Ph^/01`000000h>;[0>3Rj`3Ph^/000000>3Rj`0000000`3Ph^/010000000h>;[0>3R
j`0000030>3Rj`030000003Ph^/0h>;[00d0h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[
000000030>3Rj`050000003Ph^/000000>3Rj`0000000`3Ph^/00`000000h>;[0>3Rj`3o0>3RjhD0
h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0h>;[00<000000>3Rj`3P
h^/00`3Ph^/01@000000h>;[0000003Ph^/0000001<0h>;[00<000000>3Rj`0000000P3Ph^/00`00
0000h>;[000000050>3Rj`070000003Ph^/000000>3Rj`000000h>;[0000000>0>3Rj`030000003P
h^/0h>;[0080h>;[00<000000>3Rj`0000001@3Ph^/00`000000h>;[000000030>3Rj`030000003P
h^/0h>;[0?l0h>;[Q@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P3P
h^/00`000000h>;[0>3Rj`030>3Rj`040000003Ph^/000000>3Rj`D000003`3Ph^/00`000000h>;[
000000020>3Rj`030000003Ph^/0000000@0000000P0h>;[0000003Ph^/000000>3Rj`000000h>;[
000000h0h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[00000004000000040>3Rj`000000
h>;[000000<0h>;[00<000000>3Rj`3Ph^/0o`3Ph^^50>3Rj`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh60>3Rj`D0000000H0h>;[0000003Ph^/000000>3Rj`0000030>3Rj`03
0000003Ph^/0h>;[00d0h>;[00<000000>3Rj`0000000P3Ph^/00`000000h>;[000000030>3Rj`03
0000003Ph^/000000080h>;[00@000000>3Rj`3Ph^/000003P3Ph^/6000000030>3Rj`000000h>;[
0080h>;[00D000000>3Rj`000000h>;[000000030>3Rj`030000003Ph^/0h>;[0?l0h>;[Q@3Ph^/0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P3Ph^/00`000000h>;[0>3Rj`03
0>3Rj`030000003Ph^/000000080h>;[0`00000?0>3Rj`070000003Ph^/0h>;[0>3Rj`000000h>;[
000000020>3Rj`<000000P3Ph^/010000000h>;[0>3Rj`0000020>3Rj`030000003Ph^/0h>;[00`0
h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[0>3Rj`0300000080h>;[00<000000>3Rj`00
00000`00003o0>3RjhP0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0
h>;[00<000000>3Rj`3Ph^/01@3Ph^/00`000000h>;[0>3Rj`0B0>3Rj`050000003Ph^/0h>;[0>3R
j`0000007P3Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00D0h>;[00<000000>3R
j`3Ph^/0o`3Ph^^;0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60>3R
j`D0000000@0h>;[0000003Ph^/00000503Ph^/01`000000h>;[0>3Rj`3Ph^/000000>3Rj`000000
703Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00D0h>;[00<000000>3Rj`3Ph^/0
o`3Ph^^;0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3Rj`030000
003Ph^/0h>;[0480h>;[00<000000>3Rj`3Ph^/0o`3Ph^^;0>3Rj`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWko0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO_l0h>;[h@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
o`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Rjn40h>;[
00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW0?l0MgNBh`1gMi8109RHY`40moOi0@1V
IWh0000306IVOP3gmoT0_;g=0?l0_;g=i02l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`030>CS
h`l0FU9Bo`3Thn?B0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo00<0oooo00<0FU9B0>OWi`3W
inL00P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knm40?ooo`030<O2d@3oool0oooo0?l0
ooooF@3oool00`3Thn<0W:Bi06]eS`0206]eS`80K7J@1@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S
09bT^@<0JgF?0P1/MY0506]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi0`2V>D@20:LjA0D0YSU4
00<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00002`1VIWh0h^7R0?_lo03kno`0nocm0?cko@1J
DU80S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL0103_knL0kno_0>o_k`3k
o?`20?clo0040?clo@3lo?`0no_m0?cloC`0o?_l00<03Q0@0<O2d@3lno`0C`3lnob=0?_lo7d0nocm
00<0W:Bi06]eS`25RK002@25RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eS`X0QHV`00H0JgF?09bT
^@3kno`0nocm09bT^@2V>D@:0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP00
00@0IVIn0>3Ph@3fmoT0moOi0P3fmoT01@1JDU80inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD
403WinL0imk60>n<40030>o_k`030?Kgn@3gmoT0m_Oi0080m_Oi00<0m_Oh0<O2d@37`]400P37`]44
0?Ogn@@0al;A0`3gmoT20<O2d@80moOi1037`]400`3gmoT0al;A0<O2d@020<O2d@<0moOi1037`]40
103gmoT0al;A0<O2d@37`]430?Ogn@<0al;A1@3gmoT50<O2d@030?Ogn@37`]40moOi0080moOi00<0
al;A00h@4037`]400`37`]420?Ogn@030<O2d@3gmoT0moOi00<0al;A0`3gmoT00`37`]40moOi0?Og
n@020?Ogn@<0al;A0`3gmoT00`37`]40moOi0?Ogn@0d0?OgnHd0m_OiO@3gmoT00`1[MHl0QHV`09bN
_P0909bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`2P2LW[h02025RK00JgF?0?Ogn03gmoT0YSU4
0:XlE@32DU/0aUAJ1P36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IV
OP0000P0IVIn0=kMh@3alO@0lO7d0?3am03`l_@0FU9B08b<S080inOW00D0ikF40=IJ003FQ000olh0
0<iS00020=i[00090>neS03_knl0kno_0>o_k`3al_@0lO7d0?3bm@3alO@0lO;d00@03Q0@00@0l?7e
0<O2d@3`lOD0l?7e100>41000`37`]40l?7e0?3am@0200h@4080l?7e100>41000`37`]403Q0@00h@
400200h@40030?3am@37`]40l?7e00@03Q0@00L0al;A00h@400>41003Q0@0?3am@37`]40l?7e00<0
3Q0@00<0l?7e0<O2d@3`lOD00P3`lOD500h@40070?3am@0>4100l?7e0<O2d@3`lOD03Q0@0?3am@04
00h@40050?3am@37`]403Q0@0<O2d@3`lOD00`0>41001@3`lOD0al;A0?3am@0>4100al;A00<0l?7e
0`0>41001@3`lOD0al;A0?3am@0>4100al;A0<<0l?7eO@3`lO@00`1[MHl0/[G@0:NX`P090:NX`P06
0;:ed01[MHl0l?7d0?3am01[MHl0/[G@1`3oool30:NX`P050;:ed01[MHl0l?7d0?3am02V>D@00P32
DU/00`3;E5T0cEUN0<eIGP040<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN40
0@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__05YBDP030>OWi`0<0>ONcP36BP00mlh00>n]
003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh0j^c_0P3Zjo00103Zjnl0j^_`00h@4037`]420>[[
l00500h@403Zjo00al;A00h@4037`]400P3Zjo001@0>4100al;A0>[[l00>4100al;A0080j^_`00P0
3Q0@0<O2d@3Zjo00j^_`00h@4037`]403Q0@0<O2d@80j^_`00@03Q0@0<O2d@0>4100al;A0P3Zjo00
0`0>4100al;A0>[[l0020>[[l00400h@403Zjo003Q0@0<O2d@80j^_`00<03Q0@0>[[l03Zjo000P3Z
jo000`0>4100al;A0>[[l0040>[[l00300h@403Zjo003Q0@0080j^_`00X03Q0@0<O2d@3Zjo00j^_`
00h@4037`]403Q0@0<O2d@0>4100al;A0P3Zjo001@0>4100al;A0>[[l00>4100al;A0080j^_`00D0
3Q0@0<O2d@3Zjo00j^_`00h@40020>[[l00300h@4037`]40j^_`03D0j^_`S@3Zk?1m0>[[k`0306]e
S`2f^M40[Jk600H0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[k`0306]eS`2f^M40oooo00H0KVf?
00D09BDf0:f^aP2/[/H0][WA06]eS`020>[[l0030:HiA03=FEh0beAI0080oooo0`3@FUl20?ooo`06
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0P3Zjnl10=cKh040IVIn00000`1VIWh0emSN0=cNiP030=cN
iP0A05YBDP3WaZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0
kno_0=cMiP3Lg^H00P3Lg^D00`3Lg^H03Q0@0<O2d@030=cNi@0400h@4037`]403Q0@0=cNi@80al;A
00D03Q0@0<O2d@3Lg^D03Q0@0<O2d@020=cNi@0800h@403Lg^D0al;A0<O2d@0>4100al;A00h@4037
`]420=cNi@0400h@4037`]403Q0@0=cNi@80al;A00D03Q0@0<O2d@3Lg^D0g=kU00h@40020=cNi@03
00h@4037`]40al;A00<0al;A0`3Lg^D00`0>4100al;A0=cNi@050=cNi@0600h@4037`]40g=kU0=cN
i@0>4100al;A0P3Lg^D01P0>4100al;A00h@4037`]403Q0@0<O2d@80g=kU00D03Q0@0<O2d@3Lg^D0
3Q0@0<O2d@020=cNi@0300h@4037`]40al;A00<0al;A00<0g=kU00h@4037`]40o`3Lg^E10=cNi@04
06]eS`2o`MH0^;W>0?ooo`@0KVf?00H09BDf0;RicP2h^Lh0^;W>0;o1eP1[MHl20=cNi@0406]eS`2o
`MH0oooo06i]S`@0^;W>00H0oooo02DU=P2h^Lh0^;W>0;o1eP1[MHl20=cNi@030:HiA03=FEh0dEYN
00<0oooo00P0eUmS0?ooo`3oool0oooo0=AMH@3AFUh0cEUN0:HiA080g=kU00<0g=kV0=cNi@3Gf=h0
0@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00H0FU9B0<K6aP3Wg]H0cW/00>N]003_]@020>NU
00030=JD003>L`00eY@00080mlH00P3gmoL01`3Ef>00eMSQ0=GHh@3Een00e]SP00h@4037`]400`3F
en000`0>4100al;A0=KGh00400h@40040<O2d@3Fen003Q0@0<O2d@<0e]OP100>41000`37`]403Q0@
0<O2d@020=KGh00300h@4037`]40e]OP00@03Q0@00<0al;A0=KGh00>41000`3Fen0500h@40050<O2
d@3Fen00e]OP0=KGh00>41001037`]430=KGh00600h@403Fen00al;A0=KGh00>4100al;A0P3Fen00
1P0>4100al;A00h@4037`]403Q0@0<O2d@80e]OP00@03Q0@0<O2d@3Fen003Q0@0P37`]400`3Fen00
3Q0@00h@400300h@40030<O2d@3Fen003Q0@0080al;A=@3Fen2=0=KHh7d0eMSQ00<0JgF?0<_<gP38
b]T01P0U9CH01@38b]T0b<WI0<S:f@3;c=h0JgF?0080eMSQ00@0JgF?0<_<gP3oool0KVf?0`38b]T0
3@38bMT0oooo02DU=P38bMT0b<[I0<_<gP1[MHl0e]SQ0=KHh02V>D@0eemO0=]TI0167QX01@3oool0
2P167QX0h6MU0=]TI03GGel0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?
d]`0d=;L0=3Bg@3@d]`0FU9B00<0inOW00/0eX@00>ne003WY@00ijD00=J4003>J`00ijd00?Ne003g
_@00kno_0?Ogm`040=3Bg0030<oBg00>4100al;A00<0d=;L00@03Q0@0<O2d@3@d]`0d=;L0P37`]40
100>4100d=;L0=3Bg00>41030<O2d@80d=;L0P37`]400`0>4100d=;L00h@40030<O2d@0400h@403@
d]`0d=;L0=3Bg080al;A00@03Q0@0=3Bg00>4100d=;L0`37`]401@0>4100d=;L0<O2d@37`]403Q0@
00@0d=;L100>41030=3Bg00600h@403@d]`03Q0@0=3Bg037`]403Q0@0`37`]401P0>4100d=;L00h@
4037`]403Q0@0=3Bg080al;A00<03Q0@0=3Bg03@d]`00P0>4100103@d]`0al;A00h@403@d]`20<O2
d@0300h@403@d]`0d=;L00803Q0@00<0d=;L0<O2d@3@d]`0<`3@d]b=0<oBgGd0d=;L00<0JgF?0=?C
hP3?d=d02@3?d=d0203Cdn80JgF?0=3Bg03@d]`0JgF?0=?ChP3oool0KVf?103?d=d03@3oool09BDf
0<o@g@3?d=d0dm?R06]eS`3@d]`0cm;L0:HiA03KI6@0hFUU0>1/J@167QX00`3oool01`167QX0h6aY
0>1/J@3QJFD0ffAT0:HiA03@d]d00P3@d]`10<oBg040d]CM0@1VIWh0000;06IVOP3@d]/0blgH0<[=
f@3;c]P0b/gH05YBDP2LW9`0inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2003_Y@020?N]0009
0?Ne003ocTX0b/kI0<_=f03;cMT0b/gI0<_>f00>4100al;A00<0blgI00<03Q0@0<_=f@3;cMT00`0>
41020<_=f@@03Q0@0P3;cMT300h@4080blgI100>41030<_=f@<03Q0@0`3;cMT300h@4080blgI0`0>
41050<_=f@0300h@4037`]40blgI00<0blgI00H03Q0@0<_=f@3;cMT0blgI00h@403;cMT400h@4080
blgI00<03Q0@0<O2d@3;cMT00`0>41030<_=f@0300h@403;cMT03Q0@0080blgI0`0>41030<_=f@03
00h@403;cMT03Q0@03D0blgIS@3;c]Um0<_=f00406]eS`3Fe^@0f=SU0=SHiP80f=SU0P3Hf>H01P3H
f>D0f=SV0=SHi@3Hf>D0e]KT06]eS`80blgH00@0JgF?0=KFi03oool0KVf?1@3oool02`0U9CH0f=SU
0=SHi@3Fe^@0JgF?0<_=f@3:c]P0YSU40>A^K@3TM6l0ig5_00D0oooo00L0i7A_0>MaK`3TM6l0i6i]
0:HiA03:c]P0b/kI0080blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@04@1JDU80kno_
0>o_k`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`35am@0aLSD
0080aLOD00<0aLOE00h@4037`]400P37`]400`0>4100a<OE0<C7e@070<C7e@0300h@4037`]40a<OE
00L0a<OE00<03Q0@0<O2d@34amD05`34amD00`0>4100al;A0<O2d@030<O2d@`0a<OE00<03Q0@0<O2
d@34amD0B@34amF=0<C8e7d0a<OD00<0JgF?0=GDh`3PgnX02@3PgnX01`3Ee><0JgF?0<C7e034am@0
JgF?0=GDh`3oool01P1^KHl02P0U9CH0h=oZ0>3OjP3Ee><0JgF?0<G8e034b=@0YSU40>YiL`3YO7P3
0?ooo`0904HN6P3oool0oooo0?ooo`3_PGX0jGah0>YiL`2V>D@0a<SE0080a<SD0@35amD10<o?fP40
IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP0305YBDP24Q8@0inON0080kno_00L0aV/00?O6003_
]@00ki`00=j<003>J`00ii`000<0moOg00D0`/CB0<74dP31a=80`LCB0<;4d@0400h@40X0`LCA00<0
3Q0@0<74d@31a=401`31a=400`0>4100`LCA0<74d@0G0<74d@D03Q0@3@31a=400`0>4100`LCA0<74
d@190<74dHd0`LCBO@32a=800`1[MHl0kN_c0>WXl@090>WXl@070>g[l`1[MHl0`/CB0<;4dP1[MHl0
kN_c0>WXl@0702DU=P80jNSa00L0kN_c06]eS`32a=40`LCA0:HiA03aP7D0l8Al0080oooo00<0AQhJ
0?6bV`167QX00P3oool02@3eS8@0l8Al0?60M@2V>D@0`LCB0<;4d@31a=40`LCB0<c>fP0106IVOP00
00@0IVIn0<[<f02n`<l0_L3?0P2n`<h00`1JDU80kno_0>o_k`020>o_k`0@0>N]003gaPP0ijD00>ND
003WS000knOF0=jD>@3_e[D0ooOg0?ooo`2n`<l0_/3>0;k0c`2n`<h0_/3?0;g0cXl0_/3>S@2m`<im
0;k0cP0306]eS`3BdN<0l_7g00T0l_7g00H0d]7S06]eS`2n`<h0_/3>06]eS`3BdN<:0?;am`070=;A
h`1[MHl0_L3>0;k0cP2V>D@0m8Ym0?F@Q@0204HN6P<0l[RN0P167QX20?F@Q@030?B:O@2V>D@0_L3?
0080_/3?0@2n`<h10<[<f040IVIn0000201VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc01JDU80S8b<0P3_
knl01P3WcW/0kno_0?Ogm`3gmoL0ii@00?OWcP80moOg00<0knOF0?Ogm`3oool00P2i_<`01@2j^l`0
^Kc;0;Zlb`2i_<`0^Kc;08h0^Kc<S@2j_<am0;Zlb`0408B<XP1[MHl0c<_M0?_ko0H0oooo00@0no_l
0<c;g@1[MHl0Q8bR0P2j_</01024S:80JgF?0<c;g@3kno`60?ooo`0;0?_ko03<bmd0JgF?08B<XP2j
_<`0^Kc<096HZP2V>D@0oin=0?joY03jg;L00P3jjKH20?WY]P0:0?[L]`3n_j@0oin=0:HiA02AV:X0
^[c<0;Zkc02i_</0][S80<W:f040IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`0605YBDP3_knl0kno_
0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`2_[/L0[jk70?l0[jk7W`2_
[/L00`24S:80JgF?06]eS`0806]eS`0308B<XP2_[/L0[jk70080[jk700<0Q8bR06]eS`1[MHl0201[
MHl00`24S:80[jk70:n^a`020:n^a`0308B<XP2V>D@0YSU400P0YSU400<0Q8bR0:n^a`2_[/L00P2_
[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD00<0[:_400D0FU9B0:f][@3gmnl0moOg0>o_
k`060?Ogm`80ooOg0P3ooooo0:b[a=40[:_40@37am@10<31d@40IVIn00001P3oool0Z:No0>KVk@3B
d^00_;c?0;6`a?l0Z:Nog@2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040oooo00001`3oool0QhNK
0=OHhP3lo?`0i>?X0=3@h03:b]X0o`2l_<oK0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@3o
ool00080oooo00H0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^_o0=OHh]T0emSR00H0hN;[0>c[kP3blO<0
o?cl0=OHhP2EU:/20?ooo`000`3oool206IVOP0308R7W@2EU:/0Z:No0?l0Z:NofP2XYkl0102EU:/0
R8NM06IVOP1VIWh30?ooo`001@3ooooo06IVO]l0IVIn1@3oool00001\
\>"], "PictureGroup",
  Evaluatable->False,
  ImageSize->{488.75, 443.688},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"b:1.2"],

Cell[TextData[{
  "\nYou can then see the data in the database by clicking the ",
  StyleBox["Result", "SR"],
  " tab. Here is an example view.\n"
}], "Text",
  CellTags->"b:1.2"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007Y0001_2000`400?l00000o`00003o00<0oooo
06IVOP1VIWh0o`1VIWkW06IVOP0000<0oooo06IVOP3ko?d0o`3ko?gV0?_lo@40IVIn00000`3oool0
IVIn0?_lo@3o0:RY^nD0Z:Vk0@3ko?d106IVOP0000@0oooo06IVOP3ko?d0Z:Vko`1VIWkS06IVOP40
Z:Vk0@3ko?d106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IVOP3o0?ooon40oooo00<0IVIn0:RY^`3k
o?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0o`2LW9kP09bLWP040?ooo`1VIWh0Z:Vk0?_l
o@40IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3oool0o`3Pgn?M0>3Oh`0509bLWP3oool0
IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`3o0>3Ohmd0h=oS
00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000L0oooo06IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo
0?l0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0
IVIn09bLWP3oool0o`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1V
IWh0nocm0:RY^`1VIWh0W9bN0?ooo`3o0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IV
OP0000L0oooo06IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo0?l0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2X
ZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3oool0o`3Pgn?M0>3Oh`0509bL
WP3oool0IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`080>3O
h`<00000103Pgn<00`000000h=oS0>3Oh`040>3Oh`040000003Pgn<0000000000080h=oS0`000002
0>3Oh`040000003Pgn<0h=oS00000080h=oS00<000000>3Oh`3Pgn<00`0000030>3Oh`030000003P
gn<0h=oS0?l0h=oSZP3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_l
o@2XZK/0IVIn09bLWP3oool01`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<0103Pgn<00`000000h=oS000000020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00020>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3Oh`3o0>3Ohjd0
h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000L0oooo06IVOP3ko?d0Z:Vk06IVOP2LW9h0
oooo00/0h=oS00D000000>3Oh`3Pgn<0h=oS000000060>3Oh`030000003Pgn<000000080h=oS00<0
00000>3Oh`3Pgn<00`3Pgn<010000000h=oS0>3Oh`0000020>3Oh`030000003Pgn<0h=oS0080h=oS
00<000000>3Oh`3Pgn<0o`3Pgn>^0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000070?oo
o`1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`0;0>3Oh`050000003Pgn<0h=oS0>3Oh`0000001P3Pgn<0
0`000000h=oS000000020>3Oh`D0000000D0h=oS0000003Pgn<0h=oS000000020>3Oh`030000003P
gn<0h=oS00800000o`3Pgn>a0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1V
IWh0nocm0:RY^`1VIWh0W9bN0?ooo`070>3Oh`@00000103Pgn<00`000000h=oS0>3Oh`040>3Oh`03
0000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<2000000070>3Oh`000000
00000>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0?l0h=oS[@3Pgn<01@2LW9h0oooo
06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3oool01`3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`030000003Pgn<0000000H0h=oS100000020>3Oh`<000000P3Pgn<00`00
0000h=oS000000020>3Oh`040000003Pgn<0h=oS0>3Oh`<00000o`3Pgn>`0>3Oh`0509bLWP3oool0
IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`080>3Oh`030000
003Pgn<0h=oS00<0h=oS0P0000080>3Oh`030000003Pgn<0h=oS0?l0h=oS`P3Pgn<01@2LW9h0oooo
06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3oool0203Pgn<40000
00<0h=oS00<000000>3Oh`3Pgn<0103Pgn<00`000000h=oS0000003o0>3Ohl@0h=oS00D0W9bN0?oo
o`1VIWh0Z:Vk0?_lo@0106IVOP0000L0oooo06IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo0?l0h=oSg@3P
gn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3o
ool0o`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000070?ooo`1VIWh0nocm0:RY
^`1VIWh0W9bN0?ooo`3o0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000L0oooo
06IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo0?l0h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040
IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn09bLWP3oool0o`3Pgn?M0>3Oh`0509bLWP3oool0IVIn
0:RY^`3ko?d00@1VIWh000070?ooo`1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`3o0>3Ohmd0h=oS00D0
W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000L0oooo06IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo0?l0
h=oSg@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn00001`3oool0IVIn0?_lo@2XZK/0IVIn
09bLWP3oool0o`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0W9bNo`3ooooN0?ooo`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh000050?oo
o`1VIWh0nocm0:RY^`1VIWh0o`2LW9kP09bLWP040?ooo`1VIWh0Z:Vk0?_lo@40IVIn00001@3oool0
IVIn0?_lo@2XZK/0IVIn0?l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3k
o?d0Z:Vk06IVOP3o0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY
^`1VIWh0o`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I8d0lNoR0`3Pgn<00`1aKf@0lNoR0?7_hP3o0?7_hTd0lNoR00<0IVIn0:RY^`3ko?d00@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT0?l0h=oS
CP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3O
h`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0;`3Pgn<00`3M`Xd0i9Ll0>J;;00U0>J;;0030>^G;P3QaXh0
h=oS0?<0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT02h0h=oS00<0hLJ>0>jO<@3k_ST09P3ob3`00`3i^CP0
kYla0>76SP3c0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0090>3Oh`030<SAc@2Q/k/0TJNd0240TJNd00<0
ZKVo0=fQD`3i^3P0:03oac`00`3i^3P0gJ5C0>3Oh`3b0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0080>3O
h`030=3Fd02fa<d0kO7c0280oooo00<0i>W/096KW03lo?h0:@3lo?h00`2AVi`0h=oS0>3Oh`3a0>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I8`0h=oS00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0080>3Oh`030:Vi_`3SjN/0o_km0280oooo00<0o_kn096KW03lo?h0
:@3lo?h00`2AVi`0h=oS0>3Oh`3a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn
0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0080>3Oh`03096W]03fm?80
oooo01/0oooo00<000000?ooo`3oool01@3oool00`2AVi`0o?cn0?cloP040?cloP030000003lo?h0
o?cn0080o?cn00<000000?cloP3lo?h00`0000030?cloP<000000`3lo?h2000000050?cloP000000
o?cn0000003lo?h00P0000070?cloP03096KW03Pgn<0h=oS0?40h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT
00P0h=oS00<0TJNd0?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`03096KW03lo?h0o?cn
00@0o?cn00D000000?cloP3lo?h0o?cn000000020?cloP070000003lo?h0o?cn0?cloP000000o?cn
000000030?cloP030000003lo?h000000080o?cn0P000000103lo?h000000?cloP0000080?cloP03
096KW03Pgn<0h=oS0?40h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00P0h=oS00<0TJNd0?ooo`3oool0103o
ool3000000040?ooo`000000oooo0?ooo`80000000@0oooo0000003oool0oooo0`0000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`2AVi`0o?cn0?cloP040?cloP05
0000003lo?h0o?cn0?cloP0000000P3lo?h00`000000o?cn0?cloP060?cloP040000003lo?h0o?cn
000000<0o?cn00D000000?cloP000000o?cn000000080?cloP03096KW03Pgn<0h=oS0?40h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmTS03Pgn<01@3akn80
h=oS0>3Oh`3Pgn<0LFmT00P0h=oS00<0TJNd0?[ioP3jnOh00`3jnOh01@000000n_Wn0?[ioP3jnOh0
00000080n_Wn00<000000?[ioP3jnOh00P0000000`3jnOh000000?[ioP020?[ioP030000003jnOh0
000000D0n_Wn00<000000?[ioP3jnOh0103jnOh00`2AVi`0o?cn0?cloP040?cloP040000003lo?h0
o?cn000000<0o?cn1@0000020?cloP8000000`3lo?h02@000000o?cn0?cloP3lo?h000000?cloP00
0000o?cn000000080?cloP03096KW03Pgn<0h=oS0?40h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn>207nM^@050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
203Pgn<00`2AYk@0mOCm0?Gdo@020?Gdo@030000003em?d0mOCm0080000000@0mOCm0000003em?d0
00000`3em?d00`000000mOCm000000050?Gdo@030000003em?d0mOCm0080mOCm00<000000?Gdo@00
0000103em?d00`3fm?d0TI^L0?cloP050?cloPD000000P3lo?h01`000000o?cn0?cloP3lo?h00000
0?cloP0000000`3lo?h00`000000o?cn000000030?cloP050000003lo?h000000?cloP000000203l
o?h00`2AVi`0h=oS0>3Oh`3a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00H0h=oS00<0TJNd0?7ao@3alOd00P3alOd00`000000lO7m0?7ao@030?7ao@03
0000003alOd0000000<0lO7m00<000000?7ao@000000100000000`3alOd000000?7ao@030?7ao@03
0000003alOd0000000D0lO7m00<0TI^L0?cloP3lo?h0103lo?h00`000000o?cn0?cloP020?cloP03
0000003lo?h0o?cn00<000000`3lo?h300000080o?cn00H000000?cloP3lo?h0o?cn0000003lo?h4
000000L0o?cn00<0TI^L0>3Oh`3Pgn<0l@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo
06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`060>3Oh`03096W]03Zj_T0j^[i0080j^[i00<000000>[Zn@3Zj_T0
0`3Zj_T00`000000j^[i000000030>[Zn@030000003Zj_T0000000<0j^[i00@000000>[Zn@000000
00000P3Zj_T01@000000j^[i0>[Zn@3Zj_T0000000@0j^[i00<0TI^L0?cloP3lo?h0103lo?h00`00
0000o?cn0?cloP020?cloP030000003lo?h0o?cn0140o?cn00<000000?cloP000000203lo?h00`2A
Vi`0h=oS0>3Oh`3a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00H0h=oS00<0TJNd0>[Zn03Zj_P00P3Zj_P00`000000j^[h0>[Zn0030>[Zn0030000003Z
j_P0000000<0j^[h00<000000>[Zn03Zj_P00`0000020>[Zn0050000003Zj_P000000>[Zn0000000
0`3Zj_P00`000000j^[h0>[Zn0020>[Zn003096KW03lo?h0o?cn00@0o?cn1@00000D0?cloP030000
003lo?h0000000P0o?cn00<0TI^L0>3Oh`3Pgn<0l@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`060>3Oh`03096W]03Ui_@0iNKd00<0iNKd00D000000>GV
m03Ui_@0iNKd0000000K0>GVm003096KW03lo?h0o?cn02P0o?cn00<0TI^L0>3Oh`3Pgn<0l@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`060>3Oh`03096W
]03Ogo40gmoa00@0gmoa0`00000L0=oOl@03096KW03lo?h0o?cn02P0o?cn00<0TI^L0>3Oh`3Pgn<0
l@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`060>3O
h`03096W]03Kg>d0fmg]00`0fmg]1@3Kg>dB0=_Mk@03096KW03lo?h0o?cn02P0o?cn00<0TI^L0>3O
h`3Pgn<0l@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
Kf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`060>3Oh`03096W]03EenT0eMOY02<0eMOY00<0TI^L0?cloP3lo?h0:03lo?h00`2AVi`0h=oS0>3O
h`3a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00H0
h=oS00<0TJNd0<c=hP3<cN808`3<cN800`2AVi`0o?cn0?cloP0X0?cloP03096KW03Pgn<0h=oS0?40
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<01P3Pgn<0
0`2AYk@0a/SM0<K8g@0S0<K8g@03096KW03lo?h0o?cn02P0o?cn00<0TI^L0>3Oh`3Pgn<0l@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`060>3Oh`03096W
]02n_]P0_[kH0200_[kH0P2n_mP00`2n_]P0TI^L0?cloP0Y0?cloP03096KW03Pgn<0h=oS0?40h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn?o075_
I4@0LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
Kf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`030?ooo`2MWJ40WIfQ0?l0WIfQ@02MWJ400`1aKf@0h=oS0>3Oh`030>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3P
gn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00006
0?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@3o07nM^Ch0Oifi00<0h=oS
09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo
0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P8200=C@b03/kO@0RhbI302MWZ/01P2:RiT0
hnK]07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo
00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`040820P03Dd<P0U9FR0=gNh@`0
fM[T00H0gMkQ09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT00P3oool400000080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`03000000<0oooo0`0000030?ooo`<00000
1@3oool00`000000oooo0?ooo`0S0?ooo`030820P03oool0oooo0300oooo00<000000?ooo`3oool0
0P3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo00<0P8200?ooo`3oool0
;`3oool500000080oooo0`0000030?ooo`<000000`3oool3000000<0oooo00<0P8200?ooo`3oool0
<`3oool3000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`D000000P3oool01020P800
e=3809BEXP3oool<0<_<fP060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?oo
o`000000103oool00`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool08`3oool00`20P800oooo0?ooo`0`0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo
0?ooo`0`0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0
oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00@0
P8200=C@b02DUJ80oooo303;c=X01P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM
^@3oool0000000@0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000004000002@0oooo
00<0P8200?ooo`3oool0<03oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0<@3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01020P800e=3809BEXP3oool<0<_<fP06
0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo
06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`000000103oool01P000000
oooo000000000000oooo000000L0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool08`3oool00`20P800oooo0?ooo`0`
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0b0?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820
P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo00P00000
0?ooo`3oool0oooo0820P03Dd<P0U9FR0?ooo`D0blcJ00<0?cdm0<_<fP3;c=X0103;c=X01P3oool0
U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00@000000?ooo`00
0000oooo0P0000050?ooo`8000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool01P000000oooo0?ooo`000000oooo000002D0oooo00<0P8200?ooo`3oool0<03oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<0P8200?ooo`3oool0<`3oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003o
ool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`050?ooo`070000003oool0oooo0820P03D
d<P0U9FR0?ooo`040<_<fP<0?cdm1@3;c=X01P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0
h=oS07nM^@3oool0000000@0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01P000000oooo0?ooo`000000
oooo000002D0oooo00<0P8200?ooo`3oool0;P3oool00`000000oooo000000030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`050000003oool000000?ooo`000000103oool00`20
P800oooo0?ooo`0c0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0000000L0oooo00L000000?ooo`3oool0P8200=C@b02DUJ80oooo00<0
c<gK1@0o?Cd40<c=f`060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`00
0000103oool00`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0?ooo`8000009@3oool0
0`20P800oooo0?ooo`0_0?ooo`8000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
0`3oool00`000000oooo0?ooo`02000000@0oooo00<0P8200?ooo`3oool0;`3oool01`000000oooo
0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000D0oooo0P00
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool01020P800e=3809BEXP3oool20=7Bh0<0
?cdm00@0dM;P03lm?@0o?Cd0?cdm0`3Ad^001P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0
h=oS07nM^@3oool0000000@0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030000
00<0oooo0`0000030?ooo`<000001@3oool00`000000oooo0?ooo`0S0?ooo`030820P03oool0oooo
0300oooo00<000000?ooo`3oool00P3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo
0080oooo00<0P8200?ooo`3oool0<03oool3000000<0oooo0`0000030?ooo`<000000`3oool30000
00<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo00<000000?ooo`3oool00P3oool30000
00<0oooo00D0P8200=C@b02DUJ80oooo0=WJi00303lm?@<0fM[T0`0o?Cd20=WJi0060?ooo`2DUJ80
Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0
Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20
P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P8200=C@b02DUJ80oooo0P3Shn/0
0`0o?Cd0hn?[0>?Sj`030>?Sj`0:03lm?@3Shn/0hn?[0>?Sj`3oool0U9FR07nM^@3Pgn<0WIfQ075_
I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03o
ool00`20P800oooo0?ooo`180?ooo`040820P03Dd<P0U9FR0?ooo``0k>ca00H0oooo09BEXP1oWKT0
h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03o
ool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01020P800e=3809BEXP3oool<0?Cdm`060?oo
o`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3o
ool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P8200=C@b02DUJ80oooo
303ko?`01P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@3o0820P2`0P82000<0
e=3809BEXP3oool03@3oool01@2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?oo
o`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?oo
o`040820P03Dd<P0U9FR0=KFf``0oooo00H0e]KK09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3O
h`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?oo
o`3oool0B03oool01P20P800e=380=KKf@2?T9h0]KFn0;Bd_PD0];Bm00/0/kBm0;Bd_@2c];d0];Bm
0;>c_@2<SI`0e]_I07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo
0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=38
0>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0080oooo100000020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`0000030?ooo`<000000`3oool3000000D0oooo00<0
00000?ooo`3oool08`3oool00`20P800oooo0?ooo`110?ooo`<000000`3oool00`20P800oooo0?oo
o`0a0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<000000`3oool3000000<0oooo00<0
P8200?ooo`3oool0>@3oool3000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`0;0820
P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_k
oP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3o
ool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0S0?ooo`03
0820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo
0340oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`000000
1P3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0
m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0
oooo0>3Oh`1oWKT0oooo000000040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
1000000T0?ooo`030820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0820P03oool0oooo0340oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0
oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0
ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0
WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`060000003oool000000000003oool0
00001`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`0S0?ooo`030820P03oool0oooo0400oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030820P03oool0oooo0340oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`0;0820
P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_k
oP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3o
ool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`040000
003oool000000?ooo`8000001@3oool200000080oooo00L000000?ooo`3oool0oooo0000003oool0
000000<0oooo00H000000?ooo`3oool000000?ooo`00000U0?ooo`030820P03oool0oooo0400oooo
00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo0340oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo0000
00040?ooo`030000003oool000000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00H000000?ooo`3oool000000?ooo`00000U0?ooo`03
0820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo
02l0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0000000@0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40
LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`0000000`3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`3oool2000002D0oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3o
ool000000080oooo00<0P8200?ooo`3oool0<03oool2000000<0oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?oo
o`050000003oool0oooo0?ooo`0000001@3oool2000000@0oooo00/0P8200=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3O
h`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`000000103oool0
0`000000oooo0?ooo`03000000<0oooo0`0000030?ooo`<000001@3oool00`000000oooo0?ooo`0S
0?ooo`030820P03oool0oooo0440oooo0`0000030?ooo`030820P03oool0oooo0340oooo00<00000
0?ooo`3oool00P3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20P800oooo0?ooo`0i
0?ooo`<000001`3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e
0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ
075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_
I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo
04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03
0?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`03
0820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi
0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS
07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo
0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3o
ool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03o
ool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m
0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020P800
2P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n
0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo
04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc
0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=38
07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`03
0820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od
0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS
09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo
0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f
0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01@3oool0h=oS07nM^@3oool0000000P0oooo00<000000?ooo`3oool00P3oool500000080oooo
0`0000030?ooo`<000000`3oool3000002D0oooo00<0P8200?ooo`3oool0;`3oool3000000<0oooo
0`0000030?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`030820P03oool0oooo02X0oooo
0`0000030?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20P800oooo
0?ooo`0c0?ooo`<000000`3oool01@000000oooo0?ooo`3oool0000000H0oooo00l000000?ooo`3o
ool0oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo00000008
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo0280oooo
00<0P8200?ooo`3oool0;P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0Y
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo00l000000?oo
o`3oool0oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo0000
00080?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030820
P03oool0oooo0380oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`050000
003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0]0?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0oooo00@00000
0?ooo`3oool0oooo1@0000020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo
0>3Oh`1oWKT0oooo100000050?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
8P3oool00`20P800oooo0?ooo`0b0?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0;@3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo00000006
0?ooo`050000003oool0oooo0?ooo`0000000P3oool03`000000oooo0?ooo`3oool0P8200=C@b03/
k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3D
d<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000L0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`040000003oool0oooo0?ooo`8000009@3oool00`20P800oooo0?ooo`0^0?ooo`@000000P3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<0P8200?ooo`3oool0:@3oool400000080oooo00L000000?ooo`3oool0oooo0000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003o
ool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080
oooo00<000000?ooo`0000000`3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?oo
o`3Pgn<0Oifi0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool08P3oool00`20P800oooo0?ooo`0^0?ooo`030000003oool0oooo
00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`000000oooo
000000040?ooo`030820P03oool0oooo02T0oooo00<000000?ooo`3oool00`3oool01`000000oooo
0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`000000103oool00`000000oooo000000030?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0
ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0
WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`040000003oool0oooo000000<0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0R0?ooo`030820P03oool0oooo02l0
oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`02000000@0oooo00<0P8200?ooo`3oool0:P3oool00`000000oooo0?ooo`02
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?oo
o`0000001@3oool2000000D0oooo0P0000030?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_
I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00@0oooo0>3Oh`1oWKT0oooo100000020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00`0000030?ooo`<000000`3oool3000000<0oooo0`00000U0?ooo`030820P03oool0oooo
02l0oooo100000020?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`20
P800oooo0?ooo`0Z0?ooo`@000000P3oool3000000<0oooo0`0000030?ooo`<000000`3oool30000
00<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo00<000000?ooo`3oool0103oool03`00
0000oooo0?ooo`3oool0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`02
0?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:
0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`18
0?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20
P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20
P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3k
noh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0
oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3o
ool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/
k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3D
d<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo
00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^
ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3P
gn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0o`20P80/0820P00:0=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3d
mOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3o
ool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20
P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3h
n?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1o
WKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3o
ool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`00
0000203oool00`000000oooo0?ooo`020?ooo`D000000P3oool3000000<0oooo0`0000030?ooo`<0
00009@3oool00`20P800oooo0?ooo`0^0?ooo`D000000P3oool3000000<0oooo0`0000040?ooo`03
0000003oool0oooo0080oooo00<0P8200?ooo`3oool0<03oool3000000<0oooo0`0000030?ooo`<0
00000`3oool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`D000000P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`05
0?ooo`3Pgn<0Oifi0?ooo`000000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`0R0?ooo`030820P03oool0oooo02l0oooo00<000000?ooo`3oool00P3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<0P8200?ooo`3oool0;`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820
=03oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/0
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0
oooo000000080?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?oo
o`030820P03oool0oooo0300oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03oool0oooo03<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3c
loL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I005
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00@0oooo0>3Oh`1oWKT0oooo100000050?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool08P3oool00`20P800oooo0?ooo`0a0?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0<`3o
ool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000
oooo0?ooo`040?ooo`0?0000003oool0oooo0?ooo`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0
lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@0
1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`050?ooo`3Pgn<0Oifi0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0
oooo0P00000U0?ooo`030820P03oool0oooo0380oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0_0?oo
o`@000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0oooo00D0oooo00h000000?ooo`3oool0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f
0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@0
1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`050?ooo`3Pgn<0Oifi0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool08P3oool00`20P800oooo0?ooo`0b0?ooo`030000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0000003oool0000000@0oooo
00<0P8200?ooo`3oool0;`3oool00`000000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`0000001`3oool03P000000oooo0?oo
o`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0R
0?ooo`030820P03oool0oooo02h0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000@0oooo00<0P8200?ooo`3oool0
<03oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3o
ool0000000D0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool02`20P800e=38
0>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`@000000P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<000000`3oool3000000<0oooo0`0000030?ooo`<00000
9@3oool00`20P800oooo0?ooo`0_0?ooo`<000000`3oool3000000<0oooo0`0000040?ooo`030000
003oool0oooo0080oooo00<0P8200?ooo`3oool0<03oool400000080oooo0`0000030?ooo`<00000
0`3oool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo00<000000?ooo`3oool0
0P3oool3000000<0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Sh
n`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM
^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?oo
o`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool0
0`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool0
2`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_k
oP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?oo
o`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_k
oP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0
oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM
^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2X
ZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0o`20P80/0820P00:0=C@b03/k_<0k>od0>k_m03_
l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fM
X@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
Kf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?oo
o`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??c
m`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
0`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool0
0`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Og
n@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3O
h`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?oo
o`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080
nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?oo
o`000000203oool00`000000oooo0?ooo`020?ooo`D000000P3oool3000000<0oooo0`0000030?oo
o`<000009@3oool00`20P800oooo0?ooo`110?ooo`<000000`3oool00`20P800oooo0?ooo`0_0?oo
o`D000000P3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20P800oooo0?ooo`0i0?oo
o`<000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00/0P8200=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3O
h`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool08P3oool00`20P800oooo0?ooo`100?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0`0?ooo`030000003oool0oooo0080
oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
10000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo
0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo
000000080?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`03
0820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo
0340oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`000000
1P3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0
m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0
oooo0>3Oh`1oWKT0oooo100000050?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool08P3oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20
P800oooo0?ooo`0b0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0oooo
000000060?ooo`030000003oool0oooo0080oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f
0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01@3oool0h=oS07nM^@3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool00000
00L0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo
0?ooo`8000009@3oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`20P800oooo0?ooo`0c0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo0080oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40
LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01@3oool0h=oS07nM^@3oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0280oooo00<0P8200?ooo`3oool0@03oool01@00
0000oooo0?ooo`3oool000000080oooo00<0P8200?ooo`3oool0<`3oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80j0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo000000040?ooo`0;0820
P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_k
oP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3o
ool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0R0?oo
o`030820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0
oooo02l0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3o
ool0oooo000000050?ooo`800000103oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`04
0?ooo`3Pgn<0Oifi0?ooo`@000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<000000`3oool3000000<0oooo0`0000030?ooo`<000009@3oool00`20P800oooo0?ooo`110?oo
o`<000000`3oool00`20P800oooo0?ooo`0`0?ooo`<000000`3oool3000000<0oooo0`0000030?oo
o`<000000`3oool00`20P800oooo0?ooo`0i0?ooo`<000001`3oool00`000000oooo0?ooo`020?oo
o`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0
no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0
lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800
oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800
e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0
no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo
06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0
A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0
k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0
Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm
0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0
P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0
ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0
WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0
oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0
lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@0
1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`030?ooo`3Pgn<0Oifi0?l0P820;020P8002P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0
h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800
oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/0
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0
BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0
B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0
n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0
P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0
P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0
no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00006
0?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000P0oooo00<0
00000?ooo`3oool00P3oool500000080oooo0`0000030?ooo`<000000P3oool5000002@0oooo00<0
P8200?ooo`3oool0;`3oool3000000<0oooo0`0000030?ooo`<00000103oool00`000000oooo0?oo
o`020?ooo`030820P03oool0oooo02X0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`00
00030?ooo`<000000`3oool00`20P800oooo0?ooo`0c0?ooo`<000000`3oool01@000000oooo0?oo
o`3oool0000000H0oooo00l000000?ooo`3oool0oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_
I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00D0oooo0>3Oh`1oWKT0oooo000000080?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?oo
o`00000W0?ooo`030820P03oool0oooo02h0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P820
0?ooo`3oool0:@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo
0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`040?oo
o`0?0000003oool0oooo0?ooo`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0
n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0
Oifi0?ooo`000000203oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20P800
oooo0?ooo`0b0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0;@3oool00`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?oo
o`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`040000003o
ool0oooo0?ooo`D000000P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3g
moT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3P
gn<0Oifi0?ooo`@000001@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0
oooo00<0P8200?ooo`3oool0<P3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03oool0oooo02d0oooo00<000000?oo
o`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00l000000?ooo`3oool0oooo0820P03Dd<P0k>kc
0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=38
07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`070000003oool0oooo
0?ooo`000000oooo000000070?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0280oooo00<0P8200?ooo`3oool0;P3o
ool400000080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030820P03oool0oooo02T0oooo100000020?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000<0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40
LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01@3oool0h=oS07nM^@3oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0280oooo00<0P8200?ooo`3oool0;P3oool00`00
0000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`050000003o
ool000000?ooo`000000103oool00`20P800oooo0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000`3oool02`20P800e=380>c^
l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@
b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3k
o?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool08P3oool00`20P800
oooo0?ooo`0_0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0
000000<0oooo00<000000?ooo`3oool00P0000040?ooo`030820P03oool0oooo02X0oooo00<00000
0?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000
oooo0?ooo`3oool0000000D0oooo0P0000050?ooo`8000000`3oool02`20P800e=380>c^l`3/ko@0
k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0
h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk
06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`@000000P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<000000`3oool3000000<0oooo0`0000030?ooo`<000009@3oool00`20
P800oooo0?ooo`0_0?ooo`@000000P3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo
0080oooo00<0P8200?ooo`3oool0:P3oool400000080oooo0`0000030?ooo`<000000`3oool30000
00<0oooo0`0000030?ooo`030820P03oool0oooo03<0oooo0`0000070?ooo`030000003oool0oooo
00@0oooo00l000000?ooo`3oool0oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo
0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P820
0?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi
04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo
04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`09
0?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`03
0820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;
0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo
0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=38
0>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020P8002P3Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P820
0?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e
0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ
075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_
I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo
04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03
0?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`03
0820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi
0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS
07nM^@3oool0000000P0oooo00<000000?ooo`3oool00P3oool500000080oooo0`0000030?ooo`<0
00000P3oool5000002@0oooo00<0P8200?ooo`3oool0<03oool00`000000oooo0?ooo`020?ooo`<0
00000`3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`20P800oooo0?ooo`0`0?ooo`<0
00000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20P800oooo0?ooo`0c0?ooo`<0
00000`3oool01@000000oooo0?ooo`3oool0000000<0oooo1@0000020?ooo`0;0820P03Dd<P0k>kc
0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=38
07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000080?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool010000000oooo0?ooo`00000W0?ooo`030820P03oool0oooo0300oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030820P03oool0oooo02l0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo
00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00`3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`00
0000203oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20P800oooo0?ooo`0`
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0c0?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080
nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?oo
o`@000001@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00<0P820
0?ooo`3oool0<03oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0<`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo
0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`040?oo
o`0?0000003oool0oooo0?ooo`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0
n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0
Oifi0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000001`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0R0?ooo`030820P03oool0oooo0300oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03oool0
oooo02l0oooo100000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool00000
00H0oooo00<000000?ooo`3oool01@3oool03P000000oooo0?ooo`20P800e=380>c^l`3/ko@0k^od
0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0
WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030820P03oool0oooo02h0oooo
00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@00
0000oooo0000003oool0000000@0oooo00<0P8200?ooo`3oool0;`3oool00`000000oooo0?ooo`03
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`0000001`3oool03P000000oooo0?ooo`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo
0>3Oh`1oWKT0oooo000000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`0R0?ooo`030820P03oool0oooo02l0oooo0P0000030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo00800000103oool0
0`20P800oooo0?ooo`0`0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`05
0000003oool0oooo0?ooo`0000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`1oWKT0oooo10000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`0000030?ooo`<000000`3oool3
000000<0oooo0`00000U0?ooo`030820P03oool0oooo0300oooo00<000000?ooo`3oool00P3oool3
000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo00<0P8200?ooo`3oool0<03oool4
00000080oooo0`0000030?ooo`<000000`3oool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3
000000L0oooo00<000000?ooo`3oool00P3oool3000000<0oooo00/0P8200=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3O
h`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?oo
o`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_
I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0
oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?oo
o`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820
P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Sh
n`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM
^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?oo
o`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0o`20P80/
0820P00:0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_k
oP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?oo
o`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_k
oP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0
oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM
^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2X
ZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820
P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`
m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fM
X@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
Kf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`D00000
0P3oool3000000<0oooo0`0000020?ooo`D00000903oool00`20P800oooo0?ooo`110?ooo`<00000
0`3oool00`20P800oooo0?ooo`0a0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<00000
0`3oool3000000<0oooo00<0P8200?ooo`3oool0>@3oool3000000<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/0
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0
oooo000000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?ooo`00000W0?ooo`030820P03o
ool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo0340oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool0
0`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Og
n@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3O
h`1oWKT0oooo000000080?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030820
P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo0340
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3o
ool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo
0>3Oh`1oWKT0oooo100000050?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
8`3oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800
oooo0?ooo`0a0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?oo
o`030000003oool0000000<0oooo00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`3oool00P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`
lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`050?ooo`3Pgn<0Oifi0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`00
00001`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0R0?ooo`030820P03oool0oooo0400oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030820P03oool0oooo0340oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`0;0820
P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_k
oP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3o
ool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`03
0820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo
02l0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0000000@0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40
LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<01@3oool0h=oS07nM^@3oool0000000<0oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`030000003oool0oooo0280oooo00<0P8200?ooo`3oool0@03oool0
1@000000oooo0?ooo`3oool000000080oooo00<0P8200?ooo`3oool0<03oool2000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000
oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000@0oooo00/0P820
0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n
0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS07nM^@3oool400000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`03000000<0oooo0`0000030?ooo`<000000`3oool3
000002D0oooo00<0P8200?ooo`3oool0@@3oool3000000<0oooo00<0P8200?ooo`3oool0<@3oool0
0`000000oooo0?ooo`020?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`030820P03oool0
oooo03T0oooo0`0000070?ooo`030000003oool0oooo0080oooo00/0P8200=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3O
h`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?oo
o`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_
I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0
oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?oo
o`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820
P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Sh
n`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM
^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?oo
o`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0o`20P80/
0820P00:0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_k
oP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?oo
o`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_k
oP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0
oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM
^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2X
ZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820
P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`
m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fM
X@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
Kf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3O
h`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`0000001P3oool4000000<0oooo0`0000030?ooo`<00000
0`3oool3000000<0oooo0`00000V0?ooo`030820P03oool0oooo0440oooo0`0000030?ooo`030820
P03oool0oooo02X0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<00000
0`3oool00`20P800oooo0?ooo`0i0?ooo`<000000`3oool01@000000oooo0?ooo`3oool0000000@0
oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[j
o@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo02<0
oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool000000080oooo00<0P8200?oo
o`3oool0:@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?oo
o`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`0;
0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo0000000:0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool08`3oool00`20P800oooo0?ooo`100?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0]0?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<0
00000?ooo`3oool00P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0
n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0
Oifi0?ooo`@000001@3oool2000000<0oooo100000020?ooo`@000000P3oool400000080oooo1000
000U0?ooo`030820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820
P03oool0oooo02d0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`05
0000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc
0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=38
07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000030?ooo`030000003oool0oooo
00800000103oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool08`3oool00`20P800oooo0?oo
o`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0Y0?ooo`@00000
0P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo000000030?oo
o`030000003oool0000000<0oooo00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`3oool00P3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`
lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`050?ooo`3Pgn<0Oifi0?ooo`0000000`3oool00`000000oooo000000060?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`0S0?ooo`030820P03oool0oooo0400oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030820P03oool0oooo02T0oooo00<000000?ooo`3oool00`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`000000103oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?oo
o`3Pgn<0Oifi0?ooo`0000000`3oool00`000000oooo000000040?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool08`3oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`20P800oooo0?ooo`0Z0?ooo`030000003oool0oooo0080oooo00L000000?oo
o`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0oooo000000050?ooo`80
0000103oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`@0
00000`3oool4000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`00000V0?ooo`03
0820P03oool0oooo0440oooo0`0000030?ooo`030820P03oool0oooo02X0oooo100000020?ooo`<0
00000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20P800oooo0?ooo`0i0?ooo`<0
00001`3oool00`000000oooo0?ooo`020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3c
loL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I005
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo
00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3g
moT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3P
gn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03o
ool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`02
0?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:
0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`18
0?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20
P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20
P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3k
noh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0
oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020P8002P3Dd<P0
k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3D
d<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo
00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^
ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3P
gn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03o
ool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`
lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3d
mOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103o
ool0h=oS07nM^@3oool5000000<0oooo100000040?ooo`030000003oool0oooo0080oooo0`000003
0?ooo`<00000103oool00`000000oooo0?ooo`0T0?ooo`030820P03oool0oooo02l0oooo00<00000
0?ooo`3oool00`3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo00<0P820
0?ooo`3oool0:P3oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`000003
0?ooo`030820P03oool0oooo03<0oooo0`0000030?ooo`050000003oool0oooo0?ooo`000000103o
ool3000000<0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`02
0?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3o
ool0000000@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000V
0?ooo`030820P03oool0oooo02l0oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3o
ool0:@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00h000000?ooo`3oool0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Sh
n`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi
0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
02H0oooo00<0P8200?ooo`3oool0;`3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo
0?ooo`0]0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000
oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000030?ooo`0>0000003oool0
oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3k
noh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo
00<000000?ooo`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030820P03oool0oooo
0300oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030820P03oool0oooo02d0oooo00<000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00h000000?ooo`3oool0P8200=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D000000`3oool2000000H0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`03
0820P03oool0oooo0300oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool00000
00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03oool0oooo02T0oooo10000002
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?oo
o`0000001P3oool00`000000oooo0?ooo`020?ooo`<000000`3oool02`20P800e=380>c^l`3/ko@0
k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0
h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk
06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo000000060?oo
o`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D0
00000?ooo`000000oooo0000000V0?ooo`030820P03oool0oooo0340oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo000000030?ooo`050000003oool000000?ooo`000000103oool00`20
P800oooo0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003o
ool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_
I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`030000003oool0000000@0oooo00<000000?oo
o`3oool00P0000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003o
ool0oooo008000009P3oool00`20P800oooo0?ooo`0a0?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000@0oooo00<0P8200?ooo`3oool0
:P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d
0?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`1oWKT0oooo
1@0000030?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`<000000`3oool3000000@0oooo
00<000000?ooo`3oool0903oool00`20P800oooo0?ooo`0^0?ooo`D000000P3oool3000000<0oooo
0`0000040?ooo`030000003oool0oooo0080oooo00<0P8200?ooo`3oool0:P3oool400000080oooo
0`0000030?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`030820P03oool0oooo03<0oooo
0`0000070?ooo`030000003oool0oooo0080oooo0`0000030?ooo`0;0820P03Dd<P0k>kc0>c_m03^
ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3P
gn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03o
ool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`
lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3d
mOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3o
ool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20
P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3h
n?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1o
WKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3o
ool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820
;020P8002P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3k
noh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03o
ool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03D
d<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3k
noh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0
IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`17
0?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/
ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01o
WKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0
Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D000000`3oool4000000@0oooo00<00000
0?ooo`3oool00P3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo02@0oooo00<0P820
0?ooo`3oool0;`3oool3000000<0oooo0`0000030?ooo`<00000103oool00`000000oooo0?ooo`02
0?ooo`030820P03oool0oooo0300oooo00<000000?ooo`3oool00`3oool3000000<0oooo0`000003
0?ooo`<000000`3oool00`20P800oooo0?ooo`0c0?ooo`<000000`3oool01@000000oooo0?ooo`3o
ool0000000@0oooo0`0000030?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo
0>3Oh`1oWKT0oooo000000040?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo
000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo
0?ooo`0000009P3oool00`20P800oooo0?ooo`0^0?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0820P03oool0oooo0300oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000000`3oool03P000000
oooo0?ooo`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo00000004
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20
P800oooo0?ooo`0b0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0<03oool00`000000oooo0?ooo`02
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?oo
o`3oool0oooo000000030?ooo`0>0000003oool0oooo0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`3oool00P3oool2000000@0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo0000000V0?ooo`030820P03oool0oooo0380oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0a
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0
oooo00D000000?ooo`3oool0oooo000000030?ooo`0>0000003oool0oooo0820P03Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS07nM^@3oool5000000<0oooo0P0000060?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`00
00009P3oool00`20P800oooo0?ooo`0^0?ooo`@000000P3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?ooo`3oool0<@3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?oo
o`040000003oool0oooo0?ooo`@000000`3oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0
lo?g0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@0
1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`050?ooo`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo000000060?ooo`030000003oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`000000
oooo0000000V0?ooo`030820P03oool0oooo02h0oooo00<000000?ooo`3oool00`3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0000003oool0000000@0oooo00<0
P8200?ooo`3oool0<P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo00/0P8200=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_k
oP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?oo
o`000000103oool00`000000oooo0?ooo`02000000<0oooo00L000000?ooo`3oool0oooo0000003o
ool0000000<0oooo00<000000?ooo`3oool00P00000V0?ooo`030820P03oool0oooo02l0oooo00<0
00000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`02000000@0oooo00<0P8200?ooo`3oool0<P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d
0?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`1oWKT0oooo
1@0000030?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`<000000`3oool3000000@0oooo
00<000000?ooo`3oool0903oool00`20P800oooo0?ooo`0_0?ooo`@000000P3oool3000000<0oooo
0`0000040?ooo`030000003oool0oooo0080oooo00<0P8200?ooo`3oool0;`3oool500000080oooo
0`0000030?ooo`<000000`3oool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo
00<000000?ooo`3oool00P3oool3000000<0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f
0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03o
ool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo
0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P820
0?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi
04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo
04P0oooo00/0P8200=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`09
0?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`03
0820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;
0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0o`20P80/0820P00:0=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3o
ool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00/0P8200=C@b03/k_<0k>od
0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P820
0?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e
0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ
075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_
I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo
04P0oooo00<0P8200?ooo`3oool0B03oool02`20P800e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`04
0?ooo`3Pgn<0Oifi0?ooo`D000000`3oool4000000@0oooo00<000000?ooo`3oool00P3oool30000
00<0oooo0`0000040?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`3oool0<03oool00`00
0000oooo0?ooo`020?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`20
P800oooo0?ooo`0`0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool00`20
P800oooo0?ooo`0c0?ooo`<000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo1@000002
0?ooo`0;0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo00000004
0?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20
P800oooo0?ooo`0`0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0_0?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00/0P8200=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`020?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi0>3O
h`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030820P03oool0oooo0300oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030820P03oool0oooo03<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo
0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`0;
0820P03Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20P800oooo0?ooo`0`
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0c0?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo00P000000?oo
o`3oool0oooo0820P03Dd<P0kO3b08^<VPD0WIj/00<0WIj[09fN[02MWZ`00`2MWZ`01`2MWj`0SHnK
0=C@b01oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D000000`3oool2000000H0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo0000000V0?ooo`030820P03oool0oooo0300oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03o
ool0oooo02l0oooo100000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0
000000H0oooo00<000000?ooo`3oool01@3oool01`000000oooo0?ooo`20P800e=3809BEXP3Mg^40
303@dMl01P3Mg^40U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo
00<000000?ooo`0000001P3oool00`000000oooo000000030?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`050000003oool000000?ooo`0000009P3oool00`20P800oooo0?ooo`0^
0?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00D000000?ooo`000000oooo000000040?ooo`030820P03oool0oooo02l0oooo00<000000?ooo`3o
ool00`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0000000L0oooo00P000000?ooo`3oool0P8200=C@b02DUJ80oooo0?Ogn@80k>ca0P3Xj>h0
3@3Rhn/0fmcU0=_Li@3DeN40c/oM0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?oo
o`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo000000040?ooo`030000003oool0oooo0080
00000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`02
000002H0oooo00<0P8200?ooo`3oool0;`3oool2000000<0oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00<000000?ooo`3oool00P0000040?ooo`030820P03oool0oooo0300oooo
00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo0000
00050?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D0P8200=C@b02DUJ80
oooo0?Ogn@020>c/l@80j>S^00d0h^;[0=_KiP3KfnH0e=GQ0<k?g@3<cM/0cLkL0?ooo`2DUJ80Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS07nM^@3oool5000000<0oooo100000040?ooo`030000003o
ool0oooo0080oooo0`0000030?ooo`<00000103oool00`000000oooo0?ooo`0T0?ooo`030820P03o
ool0oooo0300oooo00<000000?ooo`3oool00P3oool3000000<0oooo0`0000040?ooo`030000003o
ool0oooo0080oooo00<0P8200?ooo`3oool0<03oool400000080oooo0`0000030?ooo`<000000`3o
ool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo00<000000?ooo`3oool00P3o
ool3000000<0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>W_00d0hn?Z0=_KiP3KfnH0
e=GQ0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?oo
o`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?oo
o`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>;SjP3Kg>D0fmcU0=GEh@3?cm`0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo
0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=38
09BEXP3oool0moOi0080k>ca0P3XjNh03@3RhnX0fmcU0=_Li@3EeN40cloL0<c=f`3=c]`0oooo09BE
XP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3k
o?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool0
0`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Og
n@020>c/l@80j>W^00d0h^?Z0=_Li@3Kg>D0eMGQ0<o?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2M
WJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0
LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3o
ool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SY
kP0=0>;SjP3Kg>D0fmcU0=GEh@3?cm`0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0
oooo0>3Oh`1oWKT0o`20P80/0820P0040=C@b02DUJ80oooo0?Ogn@80k>ca0P3XjNh03@3RhnX0fmcU
0=_Li@3EeN40cloL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi
04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo
04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>W^00d0h^?Z0=_Li@3Kg>D0eMGQ0<o?
g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820
P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`050820
P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>;RjP3Kg>D0fmcU0=CEh@3?cmd0c<gK0<g>g03o
ool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0
IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`17
0?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3o
ool0moOi0080k>ca0P3XjNh03@3Rh^X0fmcU0=_Li@3DeN40cloM0<c=f`3=c]`0oooo09BEXP1oWKT0
h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk
06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D000000`3oool4000000@0oooo00<000000?oo
o`3oool00P3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo02@0oooo00<0P8200?oo
o`3oool0@@3oool3000000<0oooo00<0P8200?ooo`3oool0<@3oool00`000000oooo0?ooo`020?oo
o`<000000`3oool3000000<0oooo0`0000030?ooo`030820P03oool0oooo03T0oooo0`0000030?oo
o`050000003oool0oooo0?ooo`000000103oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3X
jNh03@3Rh^X0fmcU0=_Li@3DeN40cloM0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`05
0?ooo`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo000000040?ooo`050000003oool0oooo
0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000002H0oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool00000
0080oooo00<0P8200?ooo`3oool0<@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080oooo00D0P8200=C@b02DUJ80
oooo0?Ogn@020>c/l@80j>W^00d0h^;Z0=_Li@3Kg>D0e=GQ0<o?g@3<cM/0cLkL0?ooo`2DUJ80Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030820P03oool0oooo0400oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo0340oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo
0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?oo
o`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>;RjP3Kg>D0fmcU0=CEh@3?cmd0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009P3oool00`20P800oooo0?ooo`10
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0a0?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`3oool00P3oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3XjNh03@3Rh^X0fmcU0=_Li@3D
eN40cloM0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D0
00000`3oool2000000H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool00000
00<0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030820P03oool0oooo0400oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo0340oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo
0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?oo
o`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>;RjP3Kg>D0fmcU0=CEh@3?cmd0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`03
0000003oool0000000H0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool01@000000oooo0000003oool0000002H0oooo00<0P8200?ooo`3oool0@03o
ool01@000000oooo0?ooo`3oool000000080oooo00<0P8200?ooo`3oool0;`3oool00`000000oooo
000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`000000103oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3Yj>h03@3Sh^X0fmcU
0=_Li@3DeN40c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi
0?ooo`000000103oool00`000000oooo000000040?ooo`030000003oool0oooo008000000`3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`02000002H0oooo
00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool000000080oooo00<0P8200?ooo`3o
ool0<03oool2000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?ooo`000000
1@3oool2000000@0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80jNS^00d0hn;Z0=_Li@3K
g>D0e=GQ0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS07nM^@3o
ool5000000<0oooo100000040?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<00000103o
ool00`000000oooo0?ooo`0T0?ooo`030820P03oool0oooo0440oooo0`0000030?ooo`030820P03o
ool0oooo0340oooo00<000000?ooo`3oool00P3oool3000000<0oooo0`0000030?ooo`<000000`3o
ool00`20P800oooo0?ooo`0i0?ooo`<000001`3oool00`000000oooo0?ooo`020?ooo`050820P03D
d<P0U9FR0?ooo`3gmoT00P3/k?420>WXkP0=0>?RjP3Kg>D0fmcU0=CEh@3>cm`0c<gK0<g>g03oool0
U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn
0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?oo
o`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3oool0
moOi0080k>ca0P3Yj>h03@3Sh^X0fmcU0=_Li@3DeN40c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS
09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo
0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80
jNS^00d0hn;Z0=_Li@3Kg>D0e=GQ0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
0`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool0
0`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>WXkP0=0>?RjP3K
g>D0fmcU0=CEh@3>cm`0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1o
WKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3o
ool0B03oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3YjNh03@3ShnX0fmcU0=_Li@3DeN00
c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020
P800103Dd<P0U9FR0?ooo`3gmoT20>c/l@80jNW^00d0hn?Z0=_Li@3Kg>D0e=GP0<k?g03<cM/0cLkL
0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo
04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR
0?ooo`3gmoT00P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>cm`0c<gK0<g>g03oool0U9FR07nM
^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2X
ZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820
P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3oool0moOi0080
k>ca0P3YjNh03@3ShnX0fmcU0=_Li@3DeN00c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80jNW^00d0
hn?Z0=_Li@3Kg>D0e=GP0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0
h=oS07nM^@030?ooo`<000000P3oool00`000000oooo0?ooo`040?ooo`<000000`3oool3000000@0
oooo00<000000?ooo`3oool00P3oool3000002H0oooo00<0P8200?ooo`3oool0<@3oool010000000
oooo0?ooo`3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo00<0P8200?oo
o`3oool0:P3oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`0000030?oo
o`030820P03oool0oooo03<0oooo0`0000030?ooo`050000003oool0oooo0?ooo`000000103oool3
000000<0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80jNW^00d0hn?Z0=_Li@3Kg>D0e=GP
0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@020?ooo`07
0000003oool0oooo0?ooo`000000oooo000000050?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
02D0oooo00<0P8200?ooo`3oool0<@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030820P03oool0oooo02T0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@00
0000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000030?ooo`080000003o
ool0oooo0820P03Dd<P0U9FR0?ooo`3gmoT20>c/l@80jNW^00d0hn?Z0=_Li@3Kg>D0e=GP0<k?g03<
cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000H0oooo
00<000000?ooo`3oool01`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000002D0oooo00<0P8200?ooo`3oool0;P3oool50000
00030?ooo`000000oooo0080oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<0P8200?ooo`3oool0;@3oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`00
00000`3oool020000000oooo0?ooo`20P800e=3809BEXP3oool0moOi0P3/k?420>SXk`0=0>;RjP3K
fnD0fm_U0=CEh03>d=d0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1o
WKT0oooo000000060?ooo`@000001P3oool00`000000oooo000000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000002D0oooo00<0P8200?ooo`3oool0;P3o
ool010000000oooo0?ooo`0000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0]0?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0oooo
00D000000?ooo`3oool0oooo000000030?ooo`080000003oool0oooo0820P03Dd<P0U9FR0?ooo`3g
moT20>c/l@80j>S_00d0h^;Z0=_Ki@3KfnD0e=GP0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2M
WJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0
LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000H0oooo00H000000?ooo`3oool0oooo0000003o
ool400000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo
0`00000V0?ooo`030820P03oool0oooo02l0oooo00<000000?ooo`0000000P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P820
0?ooo`3oool0:@3oool400000080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0
oooo00D000000?ooo`3oool0oooo000000060?ooo`040000003oool0oooo0?ooo`@000000`3oool0
1@20P800e=3809BEXP3oool0moOi0080k>ca0P3Xj>l03@3Rh^X0fm_U0=_Ki@3DeN00c]3M0<c=f`3=
c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0
oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`0000001P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000001@3oool02@000000oooo0?ooo`3oool000000?ooo`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009@3oool00`20P800oooo0?ooo`0_
0?ooo`030000003oool000000080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00D000000?ooo`000000oooo000000040?ooo`030820P03oool0oooo02T0oooo00<000000?ooo`3o
ool00`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`050820
P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SXk`0=0>;RjP3KfnD0fm_U0=CEh03>d=d0c<gK0<g>g03o
ool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0
IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT00P3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool2000000<0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`030820P03oool0
oooo0300oooo0P0000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0oooo00800000103oool00`20P800oooo0?ooo`0Z0?ooo`030000003oool0oooo0080oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo0000
00050?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D0P8200=C@b02DUJ80
oooo0?Ogn@020>c/l@80j>S_00d0h^;Z0=_Ki@3KfnD0e=GP0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi
0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@030?ooo`<000000P3oool4000000<0oooo10000002
0?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`<000009P3oool00`20P800oooo0?ooo`0a
0?ooo`040000003oool0oooo0?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool00P3o
ool00`20P800oooo0?ooo`0Z0?ooo`@000000P3oool3000000<0oooo0`0000030?ooo`<000000`3o
ool3000000<0oooo00<0P8200?ooo`3oool0<`3oool3000000L0oooo00<000000?ooo`3oool00P3o
ool3000000<0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>S_00d0h^;Z0=_Ki@3KfnD0
e=GP0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?oo
o`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?oo
o`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>?Rj`3KfnH0fm_V0=CEh03>cm`0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo
0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=38
09BEXP3oool0moOi0080k>ca0P3XjNh03@3Sh^/0fm_V0=_KiP3DeN00c/oL0<c=f`3=c]`0oooo09BE
XP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3k
o?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool0
0`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Og
n@020>c/l@80j>W^00d0hn;[0=_KiP3KfnH0e=GP0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2M
WJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0
LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3o
ool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?4608jE
XP090<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@3o0820
P2`0P82000D0e=3809BEXP3oool0moOi0>c/l@060?ooo`0:0=CEh03>cm`0c<gK0<g>g03oool0U9FR
07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm
0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0
P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT0
0P3/k?4608jEXP090<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS
07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo
0?ooo`180?ooo`060820P03Dd<P0U9FR0?ooo`3gmoT0k>ca1P3oool02P3DeN00c/oL0<c=f`3=c]`0
oooo09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0
IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`17
0?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3o
ool0moOi0080k>ca1P2>UJ802@3>cmd0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0
oooo0>3Oh`1oWKT00`3oool300000080oooo00<000000?ooo`3oool0103oool3000000<0oooo0`00
00040?ooo`030000003oool0oooo0080oooo0`00000V0?ooo`030820P03oool0oooo02h0oooo1@00
00020?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`20P800oooo0?oo
o`0b0?ooo`040000003oool0oooo0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`030820
P03oool0oooo03<0oooo0`0000030?ooo`050000003oool0oooo0?ooo`0000000`3oool500000080
oooo00H0P8200=C@b02DUJ80oooo0?Ogn@3/k?460?ooo`0:0=CEh03>cmd0c<gK0<g>g03oool0U9FR
07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm
0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@020?ooo`070000003oool0oooo0?ooo`000000
oooo000000050?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000002D0oooo00<0P8200?ooo`3oool0
;`3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0b0?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003o
ool0oooo0820P3@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool01@20P800e=3809BEXP3oool0moOi0080k>ca1P2>UJ802@3>
cmd0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo00000006
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`030820P03oool0oooo0300oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030820P03oool0oooo02l0oooo1@0000000`3oool000000?ooo`020?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d
0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00H0P8200=C@b02DUJ80oooo0?Ogn@3/k?460?ooo`0:0=CEh03>cmd0c<gK0<g>
g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000H0oooo10000006
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000009@3oool00`20P800oooo0?ooo`0a0?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P8200?oo
o`3oool0;`3oool010000000oooo0?ooo`0000020?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0103oool02@000000oooo0?ooo`3oool0
P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80jNW^00d0hn?Z0=_KiP3KfnH0e=GP0<k?g@3<cM/0cLkL
0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000H0oooo00H00000
0?ooo`3oool0oooo0000003oool400000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0080oooo0`00000V0?ooo`030820P03oool0oooo0380oooo00<000000?ooo`00
00000`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20
P800oooo0?ooo`0`0?ooo`030000003oool000000080oooo00L000000?ooo`3oool0oooo0000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80d0?ooo`050000
003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`050?ooo`080000003oool0oooo0820
P03Dd<P0U9FR0?ooo`3gmoT20>c/l@80jNW^00d0hn?Z0=_KiP3KfnH0e=GP0<k?g@3<cM/0cLkL0?oo
o`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000H0oooo00L000000?oo
o`3oool0oooo0000003oool0000000D0oooo00T000000?ooo`3oool0oooo0000003oool000000?oo
o`0000000`3oool01@000000oooo0?ooo`3oool0000002D0oooo00<0P8200?ooo`3oool0<P3oool0
0`000000oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`000000oooo0000
00040?ooo`030820P03oool0oooo0300oooo00<000000?ooo`0000000P3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820
P3@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0000000L0oooo00P00000
0?ooo`3oool0P8200=C@b02DUJ80oooo0?Ogn@80k>ca0P3XjNl03@3ShnX0fm_V0=_KiP3DeN40c]3M
0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0080oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3oool00000103oool01@000000
oooo0?ooo`3oool000000080oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000009@3oool0
0`20P800oooo0?ooo`0^0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool00P0000040?ooo`030820P03oool0oooo0340oooo
0P0000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000D0oooo0P00
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@20P800e=3809BEXP3oool0moOi0080
k>ca0P3XjNl03@3ShnX0fm_V0=_KiP3DeN40c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi00<0oooo0`0000020?ooo`@000000`3oool400000080oooo0`000004
0?ooo`030000003oool0oooo0080oooo0`00000V0?ooo`030820P03oool0oooo02l0oooo0`000003
0?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool00P3oool00`20P800oooo0?ooo`0b
0?ooo`040000003oool0oooo0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`030820P03o
ool0oooo03<0oooo0`0000070?ooo`030000003oool0oooo0080oooo0`0000030?ooo`050820P03D
d<P0U9FR0?ooo`3gmoT00P3/k?420>SYk`0=0>?SjP3KfnH0fm_V0=CEh@3>d=d0c<gK0<g>g03oool0
U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn
0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?oo
o`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3oool0
moOi0080k>ca0P3XjNl03@3ShnX0fm_V0=_KiP3DeN40c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS
09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo
0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80
j>W_00d0hn?Z0=_KiP3KfnH0e=GQ0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
0`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool0
0`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYk`0=0>?SjP3K
fnH0fm_V0=CEh@3>d=d0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1o
WKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3o
ool0B03oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3XjNl03@3ShnX0fm_V0=_KiP3DeN40
c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020
P800103Dd<P0U9FR0?ooo`3gmoT20>c/l@80j>W^00d0h^?Z0=_Li@3Kg>D0eMGQ0<o?g03<cM/0cLkL
0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?oo
o`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo
04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR
0?ooo`3gmoT00P3/k?420>SYkP0=0>;SjP3Kg>D0fmcU0=GEh@3?cm`0c<gK0<g>g03oool0U9FR07nM
^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2X
ZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820
P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3oool0moOi0080
k>ca0P3XjNh03@3RhnX0fmcU0=_Li@3EeN40cloL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1a
Kf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>W^00d0
h^?Z0=_Li@3Kg>D0eMGQ0<o?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0
h=oS07nM^@030?ooo`<000000P3oool00`000000oooo0?ooo`040?ooo`<000000`3oool3000000@0
oooo00<000000?ooo`3oool00P3oool3000002H0oooo00<0P8200?ooo`3oool0@@3oool3000000<0
oooo00<0P8200?ooo`3oool0;`3oool500000080oooo0`0000030?ooo`<000000`3oool3000000<0
oooo00<0P8200?ooo`3oool0>@3oool3000000<0oooo00D000000?ooo`3oool0oooo000000040?oo
o`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SYkP0=0>;SjP3Kg>D0fmcU0=GEh@3?cm`0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT00P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000001@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`03
0820P03oool0oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo
0300oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo0080oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/
l@80j>W^00d0h^?Z0=_Li@3Kg>D0eMGQ0<o?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01@3oool0h=oS07nM^@3oool0000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
02D0oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool000000080oooo00<0P820
0?ooo`3oool0<@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo0080oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/
l@80j>W^00d0h^;Z0=_Li@3Kg>D0e=GQ0<o?g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01@3oool0h=oS07nM^@3oool0000000H0oooo100000060?ooo`030000003oool0000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000009@3oool00`20
P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0b
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0oooo0080oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>W^00d0h^;Z0=_L
i@3Kg>D0e=GQ0<o?g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM
^@3oool0000000H0oooo00H000000?ooo`3oool0oooo0000003oool400000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo0`00000V0?ooo`030820P03oool0
oooo0400oooo00D000000?ooo`3oool0oooo000000020?ooo`030820P03oool0oooo03<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool0P820>P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3o
ool00P3oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3XjNh03@3Rh^X0fmcU0=_Li@3DeN40
cloM0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`000000
1P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool02@000000oooo0?ooo`3oool0
00000?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000009@3oool00`20P800
oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0c0?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?oo
o`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0000000@0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80j>W^00d0h^;Z0=_Li@3Kg>D0
e=GQ0<o?g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@020?oo
o`070000003oool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0oooo000000@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`8000000`3oool01@000000oooo0?ooo`3oool00000
02D0oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool000000080oooo00<0P820
0?ooo`3oool0;`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820>P3oool01@000000
oooo0?ooo`3oool0000000D0oooo0P0000040?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?42
0>SYkP0=0>;RjP3Kg>D0fmcU0=CEh@3?cmd0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I005
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00<0oooo0>3Oh`1oWKT00`3oool300000080oooo100000030?ooo`@000000P3oool3000000@0oooo
00<000000?ooo`3oool00P3oool3000002H0oooo00<0P8200?ooo`3oool0@@3oool3000000<0oooo
00<0P8200?ooo`3oool0<03oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo
00<0P8200?ooo`3oool0>@3oool3000000L0oooo00<000000?ooo`3oool00P3oool01@20P800e=38
09BEXP3oool0moOi0080k>ca0P3XjNh03@3Rh^X0fmcU0=_Li@3DeN40cloM0<c=f`3=c]`0oooo09BE
XP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3k
o?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool0
0`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Og
n@020>c/l@80j>W^00d0h^;Z0=_Li@3Kg>D0e=GQ0<o?g@3<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2M
WJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0
LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3o
ool0B03oool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>WX
kP0=0>?RjP3Kg>D0fmcU0=CEh@3>cm`0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0
oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0
P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3Yj>h03@3Sh^X0fmcU
0=_Li@3DeN40c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi
04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo
04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/l@80jNS^00d0hn;Z0=_Li@3Kg>D0e=GQ0<k?
g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@3o0820P2`0P820
00@0e=3809BEXP3oool0moOi0P3/k?420>WXkP0=0>?RjP3Kg>D0fmcU0=CEh@3>cm`0c<gK0<g>g03o
ool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0
IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`17
0?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01@20P800e=3809BEXP3o
ool0moOi0080k>ca0P3Yj>h03@3Sh^X0fmcU0=_Li@3DeN40c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0
h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk
06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800
oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@b02DUJ80oooo0?Ogn@020>c/
l@80jNS^00d0hn;Z0=_Li@3Kg>D0e=GQ0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT
00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3P
gn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03o
ool00`20P800oooo0?ooo`180?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>WYkP0=0>?S
jP3Kg>D0fmcU0=CEh03>cm`0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3O
h`1oWKT0oooo1@0000030?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`<00000103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`3oool0;`3oool3
000000<0oooo0`0000030?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`030820P03oool0
oooo02X0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool0
0`20P800oooo0?ooo`0c0?ooo`<000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo1@00
00020?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>
cm`0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo00000004
0?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo
00<0P8200?ooo`3oool0;P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0Y
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00`3oool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3YjNh03@3ShnX0fmcU0=_Li@3D
eN00c/oL0<c=f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0Oifi0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0T
0?ooo`030820P03oool0oooo0380oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`000000103oool00`20P800oooo0?ooo`0]0?ooo`030000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo0?ooo`3oool0000000H0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`050820P03Dd<P0U9FR0?oo
o`3gmoT00P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>cm`0c<gK0<g>g03oool0U9FR07nM^@3P
gn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0
IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`030000003oool0oooo0080oooo
0P0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool0903oool00`20P800oooo0?ooo`0b0?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0P820
0?ooo`3oool0;@3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0820P3@0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo00T000000?ooo`3oool0
oooo0820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>cm`0c<gK
0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`1oWKT0oooo1@0000030?ooo`80
00001P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo00000005
0?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`3oool0;P3oool400000080oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0820P03oool0oooo02T0oooo100000020?ooo`070000003oool0oooo0?ooo`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80d0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`050?ooo`080000
003oool0oooo0820P03Dd<P0U9FR0?ooo`3gmoT20>c/l@80jNW^00d0hn?Z0=_Li@3Kg>D0e=GP0<k?
g03<cM/0cLkL0?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM
^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0
oooo00<000000?ooo`0000001P3oool00`000000oooo000000030?ooo`090000003oool0oooo0?oo
o`000000oooo0000003oool0000000<0oooo00<000000?ooo`0000009P3oool00`20P800oooo0?oo
o`0^0?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00D000000?ooo`000000oooo000000040?ooo`030820P03oool0oooo02T0oooo00<000000?oo
o`3oool00`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0P820=03oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`0000001`3oool020000000oooo0?ooo`20P800e=38
09BEXP3oool0moOi0P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>cm`0c<gK0<g>g03oool0U9FR
07nM^@3Pgn<0WIfQ075_I0050>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03
075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`1oWKT0oooo000000040?ooo`030000003oool00000
00@0oooo00<000000?ooo`3oool00P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool2
000000@0oooo0P00000V0?ooo`030820P03oool0oooo02l0oooo00<000000?ooo`3oool00P3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000@0oooo
00<0P8200?ooo`3oool0:P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`20P80d0?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050820P03Dd<P0U9FR0?ooo`3gmoT00P3/k?420>SXk`0=
0>;RjP3KfnD0fm_U0=CEh03>d=d0c<gK0<g>g03oool0U9FR07nM^@3Pgn<0WIfQ075_I0050>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo
0>3Oh`1oWKT0oooo1@0000030?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`<00000103o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`3oool0;`3o
ool400000080oooo0`0000030?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`030820P03o
ool0oooo02X0oooo100000020?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<000000`3o
ool00`20P800oooo0?ooo`0c0?ooo`<000001`3oool00`000000oooo0?ooo`020?ooo`<000000`3o
ool01@20P800e=3809BEXP3oool0moOi0080k>ca0P3XjNh03@3Sh^/0fm_V0=_KiP3DeN00c/oL0<c=
f`3=c]`0oooo09BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?oo
o`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00D0P8200=C@
b02DUJ80oooo0?Ogn@020>c/l@80jNW^00d0hn?Z0=_KiP3KfnH0e=GP0<k?g@3<cM/0cLkL0?ooo`2D
UJ80Oifi0>3Oh`2MWJ40LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0
nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo04L0oooo
00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`040820P03Dd<P0U9FR0=KFf``0
oooo00H0e]KK09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo
0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01020P800e=38
0?gmnP2@TIl50;Ng_`030;Bd_@2g]kl0]kNo00@0]kNo00H0T96O0=C@b01oWKT0h=oS09fMX@1aKf@5
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS
00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00<0oooo0>3Oh`1oWKT0BP3oool00`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo
00<0P8200?ooo`3oool0B03oool01020P800e=380>c]m02;S9T<09fNZ`0608Z;V@3Si^d0Oifi0>3O
h`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKf@:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi0?l0P820;020P8000`3Dd<P0U9FR0=gNh@0<0=WJi0060=gN
h@2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3P
gn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3o
ool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P8200=C@b02DUJ80oooo
303;c=X01P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0/[Bo0;:d_`0400000080/[Bo00H0
00000;:d_`2b];l0/[Bo0000002b];l2000000030;:d_`000000/[Bo0080000000@0/[Bo0000002b
];l0/[Bo0`0000030;:d_`80000000<0/[Bo0000002b];l01P2b];l00`000000/[Bo0;:d_`1C0;:d
_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?oo
o`030820P03oool0oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?oo
o`040820P03Dd<P0U9FR0?ooo``0blcJ00H0oooo09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0;:d
_`000000102b];l00`000000/[Bo000000030;:d_`030000002b];l000000080/[Bo00<000000;:d
_`0000000P2b];l00`000000/[Bo000000030;:d_`030000002b];l000000080/[Bo0P0000070;:d
_`030000002b];l0/[Bo05<0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`030?ooo`3Pgn<0Oifi04X0oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?oo
o`030820P03oool0oooo04P0oooo00@0P8200=C@b02DUJ80oooo303;c=X01P3oool0U9FR07nM^@3P
gn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmT2P3Pgn<00`1oWKT0/[Bo000000040;:d_`030000002b];l0000000<0/[Bo00<000000;:d
_`0000000P2b];l00`000000/[Bo000000020;:d_`030000002b];l0000000D0/[Bo00H000000;:d
_`2b];l0/[Bo0000002b];l3000000<0/[Bo00<000000;:d_`2b];l0D`2b];l00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00@0oooo0>3Oh`1oWKT0oooo1@0000030?ooo`@00000
103oool00`000000oooo0?ooo`020?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo02@0oooo00<0P8200?ooo`3oool0@@3oool3000000<0oooo00<0P8200?ooo`3oool0
<03oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo00<0P8200?ooo`3oool0
>@3oool3000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`040820P03Dd<P0U9FR0?oo
o``0blcJ00H0oooo09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0;:d_`000000102b];l00`000000
/[Bo000000030;:d_`030000002b];l000000080/[Bo00<000000;:d_`0000000P2b];l00`000000
/[Bo00000004000000030;:d_`000000/[Bo0080/[Bo00<000000;:d_`2b];l01@2b];l00`000000
/[Bo0;:d_`1C0;:d_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0
h=oS07nM^@3oool0000000@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool0
000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0903oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`20P800oooo0?ooo`0_0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j
0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`040820P03D
d<P0U9FR0?ooo`80blcJ00<0?cdm0<_<fP3;c=X00`3;c=X02P0o?Cd0blcJ0<_<fP3;c=X0oooo09BE
XP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_l
o@2XZK/0IVIn075_I0X0h=oS00<0Oifi0;:d_`000000102b];l010000000/[Bo0000000000020;:d
_`030000002b];l000000080/[Bo00<000000;:d_`0000000P2b];l00`000000/[Bo000000030;:d
_`030000002b];l000000080/[Bo0P0000070;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo0000
001?0;:d_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS07nM
^@3oool0000000@0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0903oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`20P800oooo0?ooo`0c0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`040000003oool0oooo0820P3X0oooo00D000000?ooo`3oool0oooo
000000060?ooo`030000003oool0oooo0080oooo00D0P8200=C@b02DUJ80oooo0<c=f`0303lm?@<0
c<gK0`0o?Cd20<c=f`060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@2b];l0000000@0/[Bo
00@000000;:d_`000000/[Bo0P0000001@2b];l00000000000000000/[Bo00@0000000@0/[Bo0000
002b];l0/[Bo0`0000030;:d_`80000000<0/[Bo0000002b];l0102b];l00`000000/[Bo00000004
0;:d_`030000002b];l0/[Bo04h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`050?ooo`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`800000103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`03
0000003oool0oooo02@0oooo00<0P8200?ooo`3oool0@03oool01@000000oooo0?ooo`3oool00000
0080oooo00<0P8200?ooo`3oool0<`3oool00`000000oooo000000030?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0
oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`040820P03Dd<P0U9FR0?ooo`80dM;P
0`0o?Cd0103Ad^00?cdm03lm?@0o?Cd30=7Bh0060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@2b];l0000000@0/[Bo00<000000;:d_`2b];l01@2b];l00`000000/[Bo0;:d_`020;:d_`040000
002b];l0/[Bo000000/0/[Bo00<000000;:d_`2b];l0102b];l2000000<0/[Bo0`00001?0;:d_`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS07nM^@3oool50000
00<0oooo0P0000060?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`3oool0903oool00`20P800oooo0?ooo`100?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0_0?ooo`@000000P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo
0820P3X0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080oooo00@0
P8200=C@b02DUJ80oooo0`3If^@503lm?@@0fM[T00H0oooo09BEXP1oWKT0h=oS09fMX@1aKf@50>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0
Oifi0;:d_`000000102b];l00`000000/[Bo0;:d_`050;:d_`060000002b];l0/[Bo0000002b];l0
00000P2b];l00`000000/[Bo0;:d_`090;:d_`030000002b];l0/[Bo00D0/[Bo00<000000;:d_`2b
];l00P2b];l00`000000/[Bo0;:d_`1>0;:d_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01@3oool0h=oS07nM^@3oool0000000@0oooo00<000000?ooo`0000001P3oool00`00
0000oooo000000030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo
00<000000?ooo`0000009P3oool00`20P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`20P800oooo0?ooo`0_0?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`20
P80j0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo000000040?ooo`040820
P03Dd<P0U9FR0?ooo`@0hn?[0`0o?Cd50>?Sj`060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM
^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?oo
o`3Pgn<0Oifi0?ooo`000000103oool00`000000oooo000000040?ooo`030000003oool0oooo0080
00000`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000040?ooo`8000009P3oool00`20
P800oooo0?ooo`100?ooo`050000003oool0oooo0?ooo`0000000P3oool00`20P800oooo0?ooo`0`
0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`20P80j0?ooo`050000003oool0oooo0?oo
o`0000001@3oool2000000@0oooo00@0P8200=C@b02DUJ80oooo1@3/k?400`0o?Cd0k>ca0>c/l@04
0>c/l@060?ooo`2DUJ80Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0Oifi0?ooo`D000000`3oool4
000000@0oooo00<000000?ooo`3oool00P3oool3000000@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0T0?ooo`030820P03oool0oooo0440oooo0`0000030?ooo`030820P03oool0
oooo0300oooo100000020?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`030820P03oool0
oooo03T0oooo0`0000070?ooo`030000003oool0oooo0080oooo00@0P8200=C@b02DUJ80oooo303d
m?L01P3oool0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00006
0?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn<00`1oWKT0/[Bo0;:d_`1n0;:d_`0307nM^@3akn80
h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0
oooo04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`040820P03Dd<P0
U9FR0?ooo``0nocl00H0oooo09BEXP1oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`1oWKT0BP3oool0
0`20P800oooo0?ooo`170?ooo`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool0
0`20P800e=3809BEXP0>0?ooo`0509BEXP1oWKT0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@:0>3Oh`0307nM^@2b];l0/[Bo07h0
/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0Oifi04X0
oooo00<0P8200?ooo`3oool0A`3oool00`20P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0
oooo00@0P8200=C@b02DUJ80e]KK303oool01P3Fe]/0U9FR07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT2P3Pgn>207nM^@05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS07nM^@1:0?ooo`030820P03oool0oooo
04L0oooo00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`060820P03Dd<P0e]_I
08n@WP2e]Kh0];Bn1@2d];d02`2c];d0];Bm0;>d_@2d];d0/k>m08b=W03FfmT0Oifi0>3Oh`2MWJ40
LFmT00D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT
S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0oooo0>3Oh`1oWKT0BP1aKf@00`3Pgn<0
LFmT075_I017075_I0030>3Oh`1aKf@0LFmT04P0LFmT00<0h=oS075_I01aKf@0B01aKf@B0>3Oh`04
07nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm
0:RY^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00@0oooo0>3Oh`1oWKT0
ooooB02MWJ400`1aKf@0h=oS0?ooo`1709fMX@03075_I03Pgn<0oooo04P0WIfQ00<0LFmT0>3Oh`3o
ool0B02MWJ400`1aKf@0h=oS0>3Oh`0@0>3Oh`0407nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3O
h`3Pgn<0LFmT00D0h=oS00D0oooo0>3Oh`1oWKT0oooo0?7_hP160>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80A@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR04H0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP160>3Oh`0309fMX@1aKf@0h=oS0140h=oS00@0Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@01@3Pgn<01@3oool0h=oS07nM^@3oool0lNoR04H0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP150>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80AP3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
04H0h=oS00<0WIfQ075_I03Pgn<04@3Pgn<0101oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0
h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn808`3Pgn<6000001d0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP150>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80AP3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR04H0h=oS00<0WIfQ075_I03Pgn<04@3Pgn<0101oWKT0h=oS09fMX@1aKf@50>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR
0>3Oh`3Pgn<0h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn80AP3Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR04D0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP160>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn80AP3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM^@3Pgn<0WIfQ075_I0D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT3`3Pgn<300000004
0>3Oh`000000h=oS0>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`050000003Pgn<0
h=oS0>3Oh`0000000P3Pgn<3000000<0h=oS0`0000020>3Oh`030000003Pgn<0h=oS05H0h=oS00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn802`3Pgn<01@000000
h=oS0>3Oh`3Pgn<0000000<0h=oS00@000000>3Oh`3Pgn<0h=oS1@0000000`3Pgn<0000000000003
000000L0h=oS00<000000>3Oh`0000000`00000G0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103P
gn<500000080h=oS0`0000030>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000001@3P
gn<00`000000h=oS000000040>3Oh`040000003Pgn<0h=oS0>3Oh`<000000`3Pgn<500000140h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0h=oS0080h=oS00D000000>3Oh`00
0000h=oS000000040>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`000000103Pgn<01000
0000h=oS0>3Oh`3Pgn<3000000<0h=oS1@00000C0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103P
gn<00`000000h=oS0>3Oh`020>3Oh`040000003Pgn<0h=oS0>3Oh`<000001P3Pgn<00`000000h=oS
0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`000000100000030>3Oh`030000
003Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<04@3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM
^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY
^`1VIWh0LFmT3P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<00P00
00000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3P
gn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS05P0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS
075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn802`3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
00<0h=oS00D000000>3Oh`3Pgn<0h=oS000000050>3Oh`030000003Pgn<0h=oS00T0h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0D0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103P
gn<00`000000h=oS0>3Oh`030>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<01@000000h=oS
0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`80
00000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<04`3Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01@000000h=oS0000003P
gn<0000000<0h=oS00@000000>3Oh`3Pgn<000001@3Pgn<00`000000h=oS000000030>3Oh`800000
0P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<05@3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR00@0h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`050000003Pgn<0
h=oS0>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00<0
00000>3Oh`0000001`3Pgn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<0h=oS0140h=oS00<0
WIfQ075_I03Pgn<04@3Pgn<0101oWKT0h=oS09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0d0h=oS00<000000>3Oh`3Pgn<00P000000103P
gn<000000>3Oh`0000030>3Oh`030000003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<0000000P0h=oS00<000000>3Oh`3Pgn<0F@3Pgn<01@3akn8000000>3Oh`3Pgn<0LFmT00D0
h=oS00D0oooo0>3Oh`1oWKT0oooo0?7_hP0;0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<02@3Pgn<00`000000h=oS0000
00040>3Oh`030000003Pgn<0h=oS01<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`040000
003Pgn<0h=oS0>3Oh`D000000P3Pgn<020000000h=oS0>3Oh`000000h=oS0000003Pgn<000001@3P
gn<00`000000h=oS0000000E0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<00`000000h=oS
0>3Oh`020>3Oh`050000003Pgn<000000>3Oh`0000000`3Pgn<010000000h=oS0>3Oh`3Pgn<50000
0080h=oS00P000000>3Oh`3Pgn<000000>3Oh`000000h=oS000000D0h=oS00<000000>3Oh`000000
5`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
h`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`030>3O
h`D000000P3Pgn<00`000000h=oS0>3Oh`050>3Oh`030000003Pgn<0h=oS00@0h=oS00<000000>3O
h`3Pgn<04@3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT3@3Pgn<00`000000h=oS
0>3Oh`030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000100000000`3Pgn<00000
0>3Oh`020>3Oh`030000003Pgn<0000000@000000P3Pgn<2000005`0h=oS00D0lNoR000000000000
h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn802`3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000000<0h=oS00D000000>3Oh`3Pgn<0h=oS000000050>3Oh`030000003Pgn<0h=oS00T0h=oS00<0
00000>3Oh`000000103Pgn<00`000000h=oS0>3Oh`0C0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
103Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`000000
0P3Pgn<00`000000h=oS0>3Oh`020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<020000000
h=oS0>3Oh`000000h=oS0000003Pgn<000000`3Pgn<3000000030>3Oh`000000h=oS01@0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0h=oS0080h=oS00D000000>3Oh`000000
h=oS000000020>3Oh`030000003Pgn<0h=oS0080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
h`080000003Pgn<0h=oS0000003Pgn<000000>3Oh`0000030>3Oh`<0000000<0h=oS0000003Pgn<0
5P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS00@000000>3Oh`3Pgn<000000`3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@00
0000h=oS0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3Oh`04
0>3Oh`030000003Pgn<0h=oS0140h=oS00<0WIfQ075_I03Pgn<04@3Pgn<0101oWKT0h=oS09fMX@1a
Kf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I0d0
h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`3Pgn<0F03Pgn<01@3akn800000000000000000LFmT00D0h=oS00D0oooo
0>3Oh`1oWKT0oooo0?7_hP0;0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<01@000000h=oS
0>3Oh`3Pgn<0000000D0h=oS1@0000070>3Oh`030000003Pgn<0000000@0h=oS00<000000>3Oh`3P
gn<04`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`030000003Pgn<0000000@00000103Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<000000080h=oS00<000000>3Oh`0000001`3Pgn<500000140h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP070>3Oh`H0000000<0h=oS0000003Pgn<01@0000040>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS000000070>3Oh`D000004`3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS1@0000020>3Oh`030000003Pgn<0h=oS00<0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000D0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS0>3Oh`050>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`0000004P3Pgn<00`2MWJ40
LFmT0>3Oh`0A0>3Oh`0407nM^@3Pgn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
00060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT3@3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`3Pgn<00`0000020>3Oh`050000003Pgn<000000>3Oh`000000
0P3Pgn<3000000<0h=oS0`0000020>3Oh`030000003Pgn<0h=oS05H0h=oS00D0lNoR000000000000
h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn802`3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000000<0h=oS00D000000>3Oh`3Pgn<0h=oS000000050>3Oh`030000003Pgn<0h=oS00T0h=oS00<0
00000>3Oh`000000103Pgn<00`000000h=oS0>3Oh`0C0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
103Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`000000
103Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3O
h`030000003Pgn<0000000L0h=oS00<000000>3Oh`3Pgn<04`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0
lNoR00L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01@000000h=oS0000003Pgn<0000000@0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<00`000000
h=oS000000070>3Oh`030000003Pgn<0h=oS01D0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3O
h`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000001@3Pgn<010000000h=oS0>3Oh`000003
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`05
0>3Oh`030000003Pgn<0h=oS0080h=oS00D000000>3Oh`3Pgn<0h=oS0000000A0>3Oh`0309fMX@1a
Kf@0h=oS0140h=oS00@0Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKf@>0>3Oh`050000003Pgn<0h=oS0>3Oh`000000N@3Pgn<0
1@3akn8000000>3Oh`3Pgn<0LFmT00D0h=oS00D0oooo0>3Oh`1oWKT0oooo0?7_hP0;0>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000D0h=oS00<000000>3O
h`3Pgn<02@3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP040>3Oh`030000003Pgn<0h=oS00<0h=oS00D000000>3Oh`3Pgn<0h=oS0000
00020>3Oh`030000003Pgn<0h=oS0080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0
h=oS0P0000030>3Oh`040000003Pgn<0h=oS000000<0h=oS00@000000>3Oh`3Pgn<000005@3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01@000000h=oS0000
003Pgn<0000000@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS0P0000030>3O
h`040000003Pgn<0h=oS000000<0h=oS00@000000>3Oh`3Pgn<000005`3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR00@0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000030>3Oh`05
0000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3Oh`020>3Oh`050000003Pgn<0h=oS
0>3Oh`0000004@3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM^@3Pgn<0WIfQ075_I0D0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0LFmT3`3Pgn<3000001<0
h=oS00<000000>3Oh`3Pgn<0I03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00D0oooo0>3O
h`1oWKT0oooo0?7_hP090>3Oh`D0000000<0h=oS0000003Pgn<01@0000000`3Pgn<000000>3Oh`04
0>3Oh`D000001`3Pgn<00`000000h=oS00000003000001L0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP040>3Oh`030000003Pgn<0h=oS00@0h=oS0`0000030>3Oh`D000001@3Pgn<00`000000h=oS0>3O
h`020>3Oh`030000003Pgn<0h=oS0080h=oS00@000000>3Oh`3Pgn<0h=oS0`0000030>3Oh`D00000
4@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000
h=oS0000003Pgn<5000000D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`020>3O
h`040000003Pgn<0h=oS0>3Oh`<000000`3Pgn<5000001<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP040>3Oh`D00000103Pgn<3000000<0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3O
h`020>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<5000000030>3Oh`00
0000h=oS00@0h=oS00<000000>3Oh`3Pgn<03P3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM^@3P
gn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1V
IWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00D0oooo0>3Oh`1oWKT0oooo0?7_
hP160>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80A@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR04H0
h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP160>3Oh`0309fMX@1aKf@0h=oS0140h=oS00@0Oifi0>3O
h`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IV
OP1aKfB<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<01@3oool0h=oS07nM^@3oool0lNoR
04H0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP150>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80AP3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR04H0h=oS00<0WIfQ075_I03Pgn<04@3Pgn<0101oWKT0h=oS
09fMX@1aKf@50>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn
075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`050?ooo`3Pgn<0Oifi0?ooo`3akn80
AP3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR04D0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP160>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80AP3Pgn<00`2MWJ40LFmT0>3Oh`0A0>3Oh`0407nM^@3Pgn<0
WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1VIWh0nocm0:RY^`1VIWh0
LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00D0oooo0>3Oh`1oWKT0oooo0?7_hP16
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80A@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR04H0h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP160>3Oh`0309fMX@1aKf@0h=oS0140h=oS00@0Oifi0>3Oh`2M
WJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1a
KfB<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<0103oool0h=oS07nM^@3ooom70?7_hP04
09fMX@1aKf@0h=oS0?ooodH0lNoR00@0WIfQ075_I03Pgn<0ooooA`3akn80102MWJ40LFmT0>3Oh`3o
oom70?7_hP0309fMX@1aKf@0h=oS0140h=oS00@0Oifi0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP3Pgn<0h=oS
0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS07nM^@190?ooo`03075_I03Pgn<0oooo04L0oooo00<0LFmT
0>3Oh`3oool0B03oool00`1aKf@0h=oS0?ooo`180?ooo`03075_I03Pgn<0h=oS0100h=oS00@0Oifi
0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk
06IVOP1aKfB<0>3Oh`050?7_hP3Pgn<0h=oS0000001aKf@01@3Pgn<00`3oool0h=oS07nM^@3o07nM
^Ch0Oifi00<0h=oS09fMX@1aKf@01@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IV
OP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP3Pgn<000000000001aKf@01@3Pgn<00`3oool0h=oS
0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP00000000000000001aKf@01@3Pgn?o
0?oood<0oooo00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000H0oooo
06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP3Pgn<000000000001aKf@0o`3Pgn=>0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR
0>3Oh`3Pgn<00000075_I03o0>3Ohdh0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh000060?ooo`1V
IWh0nocm0:RY^`1VIWh0LFmTS03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT0?l0h=oSCP3Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000H0oooo06IVOP3ko?d0Z:Vk06IVOP1aKfB<0>3Oh`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@0o`3Pgn=>0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001P3oool0IVIn
0?_lo@2XZK/0IVIn075_I8`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I03o0>3Ohdh0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0SP1aKf@30>3Ohol0LFmTC`1a
Kf@0103akn80IVIn0:RY^`3ko?d106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IVOP3o0>3Ohn40h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0o`3Pgn?Q0>3Oh`0306IV
OP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0/k2S08f8NP3oool0
o`3Pgn?K0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS
00<0e/o60;>`Z`3_jnL0o`3Pgn?K0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_l
o@2XZK/0IVIn0?l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3ko?d0Z:Vk
06IVOP030>3Oh`030>OWi`3oool0oo_o0140h=oS00D0oooo0000003oool0h=oS0?ooo`0D0>3Oh`03
0?ooo`3Pgn<0h=oS05<0h=oS00<0l_;b0>3Oh`3Pgn<0o`3Pgn=H0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0/k2S08f8NP3oool02P3Pgn<02`3oool0
l_;b0?ooo`3bl_80oooo0>3Oh`0=3@d0h=oS00d=3@3Pgn<03@d=00`0h=oS1P3oool20>3Oh`030000
003oool0h=oS00`0h=oS2@3oool?0>3Oh`0:0?;blP3oool0l_;b0?ooo`3bl_80oooo0?;blP3oool0
l_;b0?ooo``0h=oS2@3oool@0>3Oh`030?;blP0=3@d0l_;b01@0h=oS00<06a/K0?ooo`3Pgn<0o`3P
gn=20>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0
e/o60;>`Z`3_jnL02@3Pgn<01@0=3@d0000000d=3@0000003@d=0080h=oS00H0l_;b00d=3@3bl_80
3@d=0>3Oh`3oool:0>3Oh`H000000P3Pgn<00`3oool000000?ooo`020?ooo`X0h=oS2P0000000`3o
ool0h=oS0>3Oh`0<0>3Oh`0:00d=3@0000003@d=0000000=3@d0000000d=3@0000003@d=0?;blP/0
h=oS2@0c<c<00`3oool0h=oS0>3Oh`0=0>3Oh`050?;blP0=3@d000000?ooo`3bl_803`3Pgn<02P3o
ool0l_;b0?ooo`3bl_80:2PX01/K6`3oool0l_;b0?ooo`3bl_;o0>3Ohcl0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh03`3Pgn<03@000000oooo0<k<l03Ieo/0a<?Y
0>3Oh`0000003@d=0?;blP0=3@d0l_;b00d=3@0000002P3Pgn<01`000000oooo0>KVo`2d]<`0i^Ko
0:RW`@3Pgn<01@00000:0>3Oh`030000003oool0IVIV00H0oooo00@0IVIV0<c<c0000000oooo2P3P
gn<03@3oool0l_;b0?ooo`000000oooo0;no_`3oool0l_;b0?ooo`3bl_80oooo0000003oool02`3P
gn<0100c<c<0oooo0<c<c03<c<`309VIV@0306IVIP0c<c<0oooo00h0h=oS00P0l_;b00d=3@32`_80
cloo0000000=3@d0l_;b0?ooo``0h=oS00/03@d=0000000=3@d0000000d=3@0K6a/0d]=C01/K6`2?
Shl0l_;b0?ooo`3o0>3Ohcl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY
^`1VIWh00`3Pgn<00`3WinL0oooo0?oko`090>3Oh`0500d=3@3bl_80emGj0<k<l03Jeo`00`3Pgn<0
1@0=3@d0l_;b00d=3@3Pgn<0oooo00X0h=oS00H000000?ooo`2d]<`0i^Ko0;Bdc03Vi_l30>3Oh`03
0000003oool0h=oS00X0h=oS00@000000?ooo`1VIVH0oooo103<c<`01@3oool0IVIV0<c<c0000000
oooo00T0h=oS00h0oooo0000000=3@d0000000d=3@3bl_803@d=0;no_`3<c<`0_kno0<c<c03bl_80
3@d=0?;blP/0h=oS00X0<c<c0?ooo`2IVIT0c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo3P3Pgn<0
2@0=3@d0TI7209jNc`2ATL80cloo0<;2lP0=3@d000000?ooo`0;0>3Oh`0;0000003oool0c/c`0=WG
n`34`nT0:2PX0<G6AP2nCV406a/K0?ooo`3bl_80o`3Pgn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0/k2S08f8NP3oool02@3Pgn<030000000oooo
0<?2i`3Fe?T0cL__0=_Io@3Pgn<03@d=0>3Oh`0=3@d0l_;b00d=3@/0h=oS00X000000?ooo`3Vi_l0
];C<0>KVo`2d]<`0i^Ko0:RW`@3Pgn<00000303Pgn<010000000oooo06IVIP3oool40<c<c0050?oo
o`1VIVH0c<c<0000003oool02@3Pgn<03P000000oooo065QH@3oool000000?ooo`000000c<c<0;no
_`3<c<`0_kno0?ooo`000000oooo2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV
03<c<`3oool>0>3Oh`0:0000002NW/l0TI7209jNc`2ATL80WYk?0<;2lP3?col000000?ooo`X0h=oS
00/03@d=0?;blP3GeOX0c/c`0=[Go037aNX0:2PX0<G6AP2nCV406a/K0?ooo`3o0>3Ohcl0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh00`3Pgn<00`3FclH0/k2[0>o[
i`090>3Oh`0600d=3@3bl_80alK]0<70iP3DdoP0c<[^0`3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`08
0000003oool0YZK00>KVo`2d]<`0i^Ko0;Bdc03Vi_l>0>3Oh`030000003oool0IVIV00H0oooo00@0
IVIV0<c<c0000000oooo2@3Pgn<03P0=3@d0l_;b06i^KP3bl_803@d=0?;blP3<c<`0l_;b0?ooo`3b
l_80oooo0?;blP0=3@d0l_;b2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c
<`3oool;0>3Oh`0=0?;blP3oool0l_;b0?ooo`000000WYk?096A`P0=3@d0TI7209jNc`32`_803@d=
0?;blP0:0>3Oh`0;0000003oool0`l;W0=KDn@3=bnl0fmWm01/K6`3Bde<0/D5D02PX:03bl_80o`3P
gn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00l0h=oS00P0
00000?ooo`2b/]T0aLC/0;nni03BdOH0blW^0=[Io@l0h=oS00/000000?ooo`3<c>D0YZK00>KVo`2d
]<`0i^Ko0;Bdc03Vi_l000000?ooo`0;0>3Oh`030000003oool0IVIV00L0IVIV00<0c<c<0000003o
ool02@3Pgn<03P000000oooo065QH@3oool0000003dmKP0`<640?Ce^030`H@0m?Fh0<31Q03dmKP00
0000oooo2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool;0>3Oh`0>
00d=3@0000003@d=0000003oool0000000d=3@3Pgn<03@d=096A`P2NW/l0`/;b00d=3@3bl_890>3O
h`0<00d=3@3bl_80alK]0<70iP3DdoP0c<[^0=_Io@0K6a/0d]=C0;51E00X:2P0l_;bo`3Pgn<n0>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0inOW0?oo
o`3onol02@3Pgn<02`0=3@d0l_;b0;Rih@2a/MP0`l?Z0;jmh`3@d?H0b/S/0=_Ho0000000oooo00`0
h=oS00/000000?ooo`2;Rj@0c<cU0:JV`03Vi_l0];C<0>KVo`2d]<`000000?ooo`0;0>3Oh`030000
003oool0c<c<00L0oooo00<0c<c<0000003oool02@3Pgn<03P0=3@d0l_;b06i^KP3bl_803@d=0000
000=3@d0000000d=3@0000003@d=0000000=3@d0l_;b2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV
09VIV@0c<c<0IVIV03<c<`3oool;0>3Oh`0>0000003?col0TI7200d=3@3bl_80h=oS0000003oool0
h=oS00d=3@2ATL80cloo0000003oool90>3Oh`0<0000003oool0/[;I0<G4k02o_^@0d]7f0<_9kP0X
:2P0aLI60;i>H@0K6a/0ooooo`3Pgn<n0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn
0?_lo@2XZK/0IVIn00<0h=oS00<0/k2S08f8NP3oool02@3Pgn<02`000000oooo0::Tc@2e]^00[k3G
0<71j02k^^40clkd0000000=3@d0l_;b00`0h=oS00P000000?ooo`2d]<`0Rh^T0<c<i@2VY/00i^Ko
0;Bdc080000000<0oooo0>3Oh`3Pgn<02@3Pgn<00`000000oooo06IVIP030<c<c0<0000000@0oooo
0<c<c0000000oooo2@3Pgn<030000000oooo065QH@1^KVh0HF5Q06i^KP1QHF40KVi^065QH@3?cll0
00000?ooo`d0h=oS00X0<c<c0?ooo`2IVIT0c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo2`3Pgn<0
3P0=3@d0`/;b09jNc`2ATL803@d=0?;blP0=3@d000000?ooo`0000003@d=0000000=3@d0l_;b2@3P
gn<03@0=3@d0l_;b0;Rih@2a/MP0`l?Z0;jmh`3@d?H0b/S/02PX:035aTH0_TiQ01/K6`3oool0o`3P
gn<m0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0
e/o60;>`Z`3_jnL02@3Pgn<02P0=3@d0l_;b0:VZe02QX/`0];GN0:j^eP2o_nL0000000d=3@3bl_8=
0>3Oh`070000003oool0P82I0;Bdc02;Rj@0c<cU0:JV`002000000030?ooo`3Pgn<0h=oS00X0h=oS
00<000000?ooo`1VIVH00`3<c<`01`000000c<c<0000003oool0c<c<0000003oool02@3Pgn<0300=
3@d0l_;b0<o?c`3bl_80oooo0?;blP3oool0l_;b0?ooo`32`/803@d=0?;blPd0h=oS00@0<c<c0?oo
o`3<c<`0c<c<0`2IVIT0101VIVH0<c<c0?ooo`3oool;0>3Oh`0900d=3@32`_80WYk?096A`P0=3@d0
TI7209jNc`000000oooo00d0h=oS00d000000?ooo`2RY<d0]KKP0:n`e`31`NP0^k[Q0<o>m00K6a/0
d]=C01/K6`0X:2P0l_;b0?l0h=oS?@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3k
o?d0Z:Vk06IVOP0?0>3Oh`0:0000003oool0UiW30:RZd`2OX<X0/[?L0000003?col000000?ooo`d0
h=oS00X000000?ooo`2d]<`0P82I0;Bdc02;Rj@000000<c<o`000000oooo303Pgn<00`000000oooo
06IVIP030<c<c0070000003<c<`000000?ooo`3<c<`000000?ooo`090>3Oh`0<0000003oool0HF5Q
0<o?c`32`/803@d=0000000=3@d0l_;b0<o?c`000000oooo303Pgn<;03<c<`030?ooo`3Pgn<0h=oS
00T0h=oS00X000000<o?o`32`_80WYk?096A`P2NW/l0TI7209jNc`000000oooo303Pgn<03P0=3@d0
l_;b0:VZe02QX/`0];GN0:j^eP2o_nL0000000d=3@0K6a/0^He=0;51E00X:2P0l_;bo`3Pgn<l0>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0inOW0?oo
o`3onol02@3Pgn<02P0=3@d0l_;b0?ooo`3bl_80oooo0?;blP3oool000000?ooo`2f][H=0>3Oh`03
0000003oool0oooo00@0oooo00<000000?ooo`3Pgn<0303Pgn<00`000000oooo06IVIP030?ooo`<0
00000P3oool00`000000h=oS0>3Oh`080>3Oh`0<00d=3@3bl_80KVi^0<;2`P3?cll000000<o?c`00
0000oooo0<;2`P0=3@d0l_;b303Pgn<00`0c<c<0c<c<0<c<c0020<c<c0@0VIVI00<0IVIV03<c<`3o
ool0303Pgn<02@0000003@d=0<;2lP3?col0TI7209jNc`2ATL803@d=0?;blP0<0>3Oh`0>0000003o
ool0UiW30:RZd`2OX<X0/[?L0000003?col0000002PX:03I[jd0i[bj01/K6`3ooooo0>3Ohc`0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh00`3Pgn<00`2c/:<0SHQj
0?ooo`090>3Oh`0:0000000=3@d0000000d=3@0000003@d=0000000=3@d0][Jf0<?3``d0h=oS2000
000?0>3Oh`X000002`3Pgn<030000000oooo065QH@3oool0l_;b00d=3@0000003@d=0?;blP3oool0
00000?ooo``0h=oS2`0c<c<?0>3Oh`0500d=3@000000cloo0<;2lP0=3@d03P3Pgn<03P0=3@d0l_;b
0?ooo`3bl_80oooo0?;blP3oool000000?ooo`2f][H0:2PX0=V_[@0X:2P0l_;bo`3Pgn<l0>3Oh`03
06IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00<0h=oS00<0e/o60;>`Z`3_
jnL0C@3Pgn<02P0000003@d=0000000=3@d0000000d=3@0000003@d=0000003ooolA0>3Oh`<0<c<c
5@3Pgn<00`0000003@d=0>3Oh`0>0>3Oh`0>0000000=3@d0000000d=3@0000003@d=0000000=3@d0
][Jf0<?3``0K6a/0:2PX08^;R`3ooooo0>3Ohc`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh000050?oo
o`1VIWh0nocm0:RY^`1VIWh0QP3Pgn<00`0=3@d0h=oS0>3Oh`3o0>3OheP0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0o`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn0?l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00D0oooo06IVOP3ko?d0Z:Vk06IVOP3o0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh000050?oo
o`1VIWh0nocm0:RY^`1VIWh0o`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001P3oool0IVIn
0?_lo@2XZK/0IVIn09fMXOl0oooogP3oool01@2MWJ40oooo06IVOP2XZK/0nocm0040IVIn00001@3o
ool0IVIn0?_lo@2XZK/0IVIn0?l0WIfQh02MWJ40103oool0IVIn0:RY^`3ko?d106IVOP0000D0oooo
06IVOP3ko?d0Z:Vk06IVOP3o0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0
nocm0:RY^`1VIWh0o`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2X
ZK/0IVIn0?l0h>;[h@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IV
OP3o0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0E@3P
h^/00`000000h>;[0>3Rj`3o0>3RjhT0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1VIWh0
nocm0:RY^`1VIWh0E@3Ph^/00`000000h>;[0>3Rj`3o0>3RjhT0h>;[00<0IVIn0:RY^`3ko?d00@1V
IWh000050?ooo`1VIWh0nocm0:RY^`1VIWh01P3Ph^/00`000000h>;[0>3Rj`030>3Rj`030000003P
h^/000000080h>;[0`00000A0>3Rj`050000003Ph^/0h>;[0>3Rj`0000000P3Ph^/3000000<0h>;[
00D000000>3Rj`3Ph^/0h>;[0000000?0>3Rj`030000003Ph^/0h>;[0080h>;[00<000000>3Rj`3P
h^/00`0000020>3Rj`030000003Ph^/0000000<00000o`3Ph^^80>3Rj`0306IVOP2XZK/0nocm0040
IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00H0h>;[00<000000>3Rj`3Ph^/00`3Ph^/01@000000
h>;[0000003Ph^/0000000<0h>;[00<000000>3Rj`3Ph^/03P3Ph^/01`000000h>;[0>3Rj`3Ph^/0
00000>3Rj`0000000`3Ph^/010000000h>;[0>3Rj`0000030>3Rj`030000003Ph^/0h>;[00d0h>;[
00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[000000030>3Rj`050000003Ph^/000000>3Rj`00
00000`3Ph^/00`000000h>;[0>3Rj`3o0>3RjhD0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh000050?oo
o`1VIWh0nocm0:RY^`1VIWh01P3Ph^/00`000000h>;[0>3Rj`030>3Rj`050000003Ph^/000000>3R
j`0000004`3Ph^/00`000000h>;[000000020>3Rj`030000003Ph^/0000000D0h>;[00L000000>3R
j`000000h>;[0000003Ph^/0000000h0h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[0000
00050>3Rj`030000003Ph^/0000000<0h>;[00<000000>3Rj`3Ph^/0o`3Ph^^50>3Rj`0306IVOP2X
ZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00H0h>;[00<000000>3Rj`3Ph^/00`3P
h^/010000000h>;[0000003Ph^/5000000l0h>;[00<000000>3Rj`0000000P3Ph^/00`000000h>;[
00000004000000080>3Rj`000000h>;[0000003Ph^/000000>3Rj`00000>0>3Rj`030000003Ph^/0
h>;[0080h>;[00<000000>3Rj`00000010000000103Ph^/000000>3Rj`0000030>3Rj`030000003P
h^/0h>;[0?l0h>;[Q@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IV
OP060>3Rj`D0000000H0h>;[0000003Ph^/000000>3Rj`0000030>3Rj`030000003Ph^/0h>;[00d0
h>;[00<000000>3Rj`0000000P3Ph^/00`000000h>;[000000030>3Rj`030000003Ph^/000000080
h>;[00@000000>3Rj`3Ph^/000003P3Ph^/6000000030>3Rj`000000h>;[0080h>;[00D000000>3R
j`000000h>;[000000030>3Rj`030000003Ph^/0h>;[0?l0h>;[Q@3Ph^/00`1VIWh0Z:Vk0?_lo@01
06IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IVOP060>3Rj`030000003Ph^/0h>;[00<0h>;[00<00000
0>3Rj`0000000P3Ph^/3000000l0h>;[00L000000>3Rj`3Ph^/0h>;[0000003Ph^/000000080h>;[
0`0000020>3Rj`040000003Ph^/0h>;[00000080h>;[00<000000>3Rj`3Ph^/0303Ph^/00`000000
h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00<000000P3Ph^/00`000000h>;[0000000300000?l0
h>;[R03Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IVOP060>3Rj`03
0000003Ph^/0h>;[00D0h>;[00<000000>3Rj`3Ph^/04P3Ph^/01@000000h>;[0>3Rj`3Ph^/00000
01h0h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[0>3Rj`050>3Rj`030000003Ph^/0h>;[
0?l0h>;[R`3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0oooo06IVOP3ko?d0Z:Vk06IVOP060>3R
j`D0000000@0h>;[0000003Ph^/00000503Ph^/01`000000h>;[0>3Rj`3Ph^/000000>3Rj`000000
703Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00D0h>;[00<000000>3Rj`3Ph^/0
o`3Ph^^;0>3Rj`0306IVOP2XZK/0nocm0040IVIn00001@3oool0IVIn0?_lo@2XZK/0IVIn00h0h>;[
00<000000>3Rj`3Ph^/0@P3Ph^/00`000000h>;[0>3Rj`3o0>3Rjh/0h>;[00<0IVIn0:RY^`3ko?d0
0@1VIWh000050?ooo`1VIWh0nocm0:RY^`1VIWh0o`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn
00001@3oool0IVIn0?_lo@2XZK/0IVIn0?l0h>;[h@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0
oooo06IVOP3ko?d0Z:Vk06IVOP3o0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh000050?ooo`1V
IWh0nocm0:RY^`1VIWh0o`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000103oool0IVIn0?Og
n@2HV:Oo07MgT^<0MgNB0@2HV:L10?Ogn@40IVIn00000`3oool0IVIn0?Ogn@3o0;bmcND0_;g=0@3g
moT106IVOP0000<0oooo06IVOP3gmoT0103Thn<?05YBD_l0i>?SdP3Thn<10?Ogn@40IVIn00000`3o
ool0IVIn0?3am0040?ooo`0305YBDP3WinL0inOW0080g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OW
i`80kno_A03oool00`37`]40oooo0?ooo`3o0?oooeT0oooo00<0i>?S09bT^@1[MHl00P1[MHl206af
T0D0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T306]eS`80K7J@1@1[MHl01P2LY;T0i>?S0?oo
o`3oool0k>[Z09bT^@<0YSU40P2W>T@50:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP00
00`0oooo06IVOP3RhN80nocl0?_ko03ko?d0o?_m05YBDP2<S8`0g]kN0>OWi`3Ng]h20>OWi`030<IS
003WinL0inOW0080inOW00@0knoW0>o_k`3_knl0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dl0?ck
o00300h@4037`]40o?_l04l0o?_lS@3ko?am0?_lo@0309bT^@1[MHl0QHV`00T0QHV`00H0JgF?09bT
^@3ko?d0nocm09bT^@1[MHl:08F9/00606]eS`2LY;T0no_l0?_lo@2LY;T0YSU42P2Z?5D01`2V>D@0
W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN800@1VIWh000050?ooo`1VIWh0h>3Q0?Kgn@3gmoT00P3fmoT0
1@1JDU80inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`030?Kg
n@3gmoT0m_Oi0080m_Oi00<0m_Oh0<O2d@37`]400P37`]440?Ogn@@0al;A0`3gmoT20<O2d@80moOi
1037`]400`3gmoT0al;A0<O2d@020<O2d@<0moOi1037`]40103gmoT0al;A0<O2d@37`]430?Ogn@<0
al;A1@3gmoT50<O2d@030?Ogn@37`]40moOi0080moOi00<0al;A00h@4037`]400`37`]420?Ogn@03
0<O2d@3gmoT0moOi00<0al;A0`3gmoT00`37`]40moOi0?Ogn@020?Ogn@<0al;A0`3gmoT00`37`]40
moOi0?Ogn@0d0?OgnHd0m_OiO@3gmoT00`1[MHl0QHV`09bN_P0909bN_P0608F9/01[MHl0moOi0?Og
n@1[MHl0QHV`2P2LW[h02025RK00JgF?0?Ogn03gmoT0YSU40:XlE@32DU/0aUAJ1P36EE`02@36E5X0
`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000<0oooo06IVOP3NgN400P3alO@0
103`lO@0l?;d05YBDP2<S8`20>OWi`050>NeQ03FFP00eX@00?o>003>H`000P3NJ`002@3_]H`0kno_
0>o_k`3_knl0lO;d0?7am03`l_D0lO7d0?7bm00400h@40040?3am@37`]40l?7e0?3am@@03Q0@00<0
al;A0?3am@3`lOD00P0>41020?3am@@03Q0@00<0al;A00h@400>41000P0>41000`3`lOD0al;A0?3a
m@0400h@40070<O2d@0>41003Q0@00h@403`lOD0al;A0?3am@0300h@40030?3am@37`]40l?7e0080
l?7e1@0>41001`3`lOD03Q0@0?3am@37`]40l?7e00h@403`lOD0100>41001@3`lOD0al;A00h@4037
`]40l?7e00<03Q0@00D0l?7e0<O2d@3`lOD03Q0@0<O2d@030?3am@<03Q0@00D0l?7e0<O2d@3`lOD0
3Q0@0<O2d@330?3amGd0l?7d00<0JgF?0;:ed02WZ<802@2WZ<801P2b]M00JgF?0?3am03`lO@0JgF?
0;:ed0L0oooo0`2WZ<801@2b]M00JgF?0?3am03`lO@0YSU40080`U9K00<0beAI0<eIGP3=FEh0103=
FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00000`3oool0IVIn0=cK
h0020>[[l0030>[/l03Yjnl0FU9B00<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[
003NS4X0ijD00>oWcP3Zk>l20>[[l0040>[[k`3Zjo003Q0@0<O2d@80j^_`00D03Q0@0>[[l037`]40
3Q0@0<O2d@020>[[l00500h@4037`]40j^_`00h@4037`]400P3Zjo00200>4100al;A0>[[l03Zjo00
3Q0@0<O2d@0>4100al;A0P3Zjo00100>4100al;A00h@4037`]420>[[l00300h@4037`]40j^_`0080
j^_`00@03Q0@0>[[l00>4100al;A0P3Zjo000`0>4100j^_`0>[[l0020>[[l00300h@4037`]40j^_`
00@0j^_`00<03Q0@0>[[l00>41000P3Zjo002P0>4100al;A0>[[l03Zjo003Q0@0<O2d@0>4100al;A
00h@4037`]420>[[l00500h@4037`]40j^_`00h@4037`]400P3Zjo001@0>4100al;A0>[[l03Zjo00
3Q0@0080j^_`00<03Q0@0<O2d@3Zjo00=@3Zjo2=0>[/l7d0j^__00<0JgF?0;Jid@2][/H01P3oool2
0:f^aP030:b^aP2f^M40JgF?0080j^__00<0JgF?0;Jid@3oool01P1^KHl01@0U9CH0[Jk60:b^aP2f
^M40JgF?0080j^_`00<0YSU40<eIGP3;E5T00P3oool30=1JG`80oooo00H0cEIK0<]DF@3=FEh0YSU4
0>[[k`3Zjo020>[[k`40g=_P0@1VIWh000030?ooo`1VIWh0emSN00@0g=kV0140FU9B0>O6[@3WaX`0
mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0g=gV0=cNiP020=cN
i@030=cNiP0>4100al;A00<0g=kU00@03Q0@0<O2d@0>4100g=kU0P37`]401@0>4100al;A0=cNi@0>
4100al;A0080g=kU00P03Q0@0=cNi@37`]40al;A00h@4037`]403Q0@0<O2d@80g=kU00@03Q0@0<O2
d@0>4100g=kU0P37`]401@0>4100al;A0=cNi@3Lg^D03Q0@0080g=kU00<03Q0@0<O2d@37`]400`37
`]430=cNi@0300h@4037`]40g=kU00D0g=kU00H03Q0@0<O2d@3Lg^D0g=kU00h@4037`]420=cNi@06
00h@4037`]403Q0@0<O2d@0>4100al;A0P3Lg^D01@0>4100al;A0=cNi@0>4100al;A0080g=kU00<0
3Q0@0<O2d@37`]400`37`]400`3Lg^D03Q0@0<O2d@3o0=cNiD40g=kU00@0JgF?0;o1eP2h^Lh0oooo
101^KHl01P0U9CH0^;W>0;RicP2h^Lh0_l7F06]eS`80g=kU00@0JgF?0;o1eP3oool0KVf?102h^Lh0
1P3oool09BDf0;RicP2h^Lh0_l7F06]eS`80g=kU00<0YSU40<eIGP3AFUh00`3oool0203FGf<0oooo
0?ooo`3oool0e5eQ0=5JGP3=FEh0YSU40P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000D0oooo06IV
OP3Ee]d0eMSP0=KHh@020=GHh00605YBDP36a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<0
0=JD00020?O60080moOg00L0eMSP0=GHh@3Ef>40eMOP0=KHh00>4100al;A00<0e]OP00<03Q0@0<O2
d@3Fen00100>41001037`]40e]OP00h@4037`]430=KGh0@03Q0@00<0al;A00h@4037`]400P3Fen00
0`0>4100al;A0=KGh00400h@40030<O2d@3Fen003Q0@00<0e]OP1@0>41001@37`]40e]OP0=KGh03F
en003Q0@00@0al;A0`3Fen001P0>4100e]OP0<O2d@3Fen003Q0@0<O2d@80e]OP00H03Q0@0<O2d@0>
4100al;A00h@4037`]420=KGh00400h@4037`]40e]OP00h@4080al;A00<0e]OP00h@400>41000`0>
41000`37`]40e]OP00h@40020<O2dCD0e]OPS@3Ff>1m0=GHh@0306]eS`3;c=h0b<[I00H09BDf00D0
b<[I0<S9f@38b]T0blcN06]eS`020=GHh@0406]eS`3;c=h0oooo06i]S`<0b<[I00d0b<WI0?ooo`0U
9CH0b<WI0<S:f@3;c=h0JgF?0=KHh@3Ff>00YSU40=MOG`3KI6@0AQhJ00D0oooo00X0AQhJ0>1WI@3K
I6@0eemO0:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh000080?ooo`1VIWh0d]CM0<oBg03@d]`0
d=;M0=3Bg01JDU830>OWi`0;0=J4003_]@00ijD00>NU003FQ000cV/00>N]003g]@00mkd00>o_k`3g
moL0103@d]`00`3?d]`03Q0@0<O2d@030=3Bg00400h@4037`]40d=;L0=3Bg080al;A00@03Q0@0=3B
g03@d]`03Q0@0`37`]420=3Bg080al;A00<03Q0@0=3Bg00>41000`37`]40100>4100d=;L0=3Bg03@
d]`20<O2d@0400h@403@d]`03Q0@0=3Bg0<0al;A00D03Q0@0=3Bg037`]40al;A00h@40040=3Bg0@0
3Q0@0`3@d]`01P0>4100d=;L00h@403@d]`0al;A00h@40<0al;A00H03Q0@0=3Bg00>4100al;A00h@
403@d]`20<O2d@0300h@403@d]`0d=;L00803Q0@00@0d=;L0<O2d@0>4100d=;L0P37`]400`0>4100
d=;L0=3Bg00200h@40030=3Bg037`]40d=;L03<0d=;LS@3?d]em0=3Bg00306]eS`3Cdn80cm3M00T0
cm3M00P0dm?R06]eS`3@d]`0d=;L06]eS`3Cdn80oooo06i]S`@0cm3M00d0oooo02DU=P3?d=d0cm3M
0=?ChP1[MHl0d=;L0<oBg02V>D@0ffAT0>5YI@3PK6T0AQhJ00<0oooo00L0AQhJ0>1/J@3PK6T0hFUU
0=]TI02V>D@0d=;M0080d=;L0@3?d]`10=;Dg@40IVIn0000303oool0IVIn0=3Bf`3;cMP0b/gI0<_>
f03:cMP0FU9B09bLW03WinL0imkF0=J<0080gY@000@0eW/00<IS002m@P00kjD00P3g[@002@3g]@00
oli:0<[>f@3;cMP0blgI0<[=f@3;c]P03Q0@0<O2d@030<_=f@0300h@403;cMT0blgI00<03Q0@0P3;
cMT400h@4080blgI0`0>41020<_=f@@03Q0@0`3;cMT300h@40<0blgI0`0>41020<_=f@<03Q0@1@3;
cMT00`0>4100al;A0<_=f@030<_=f@0600h@403;cMT0blgI0<_=f@0>4100blgI100>41020<_=f@03
00h@4037`]40blgI00<03Q0@0`3;cMT00`0>4100blgI00h@40020<_=f@<03Q0@0`3;cMT00`0>4100
blgI00h@400e0<_=fHd0blkIO@3;cMP0101[MHl0e]KT0=SHi@3Hf>H20=SHi@80f=SV00H0f=SU0=SH
iP3Hf>D0f=SU0=KFi01[MHl20<_=f00406]eS`3Fe^@0oooo06i]S`D0oooo00/09BDf0=SHi@3Hf>D0
e]KT06]eS`3;cMT0b/kH0:HiA03TKVd0i7A_0>MaK`050?ooo`070>AdK`3WLFl0i7A_0>A^K@2V>D@0
b/kH0<[>f@020<_=f@40d=;K0@1VIWh000030?ooo`1VIWh0cloJ00@0aLSD0140FU9B0>o_k`3_knl0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool0aLOD0<G8e0020<G7
e0030<G7e@0>4100al;A0080al;A00<03Q0@0<C7e@34amD01`34amD00`0>4100al;A0<C7e@070<C7
e@0300h@4037`]40a<OE01L0a<OE00<03Q0@0<O2d@37`]400`37`]4<0<C7e@0300h@4037`]40a<OE
04T0a<OES@34b=Am0<C7e00306]eS`3Ee><0h=oZ00T0h=oZ00L0eMCS06]eS`34am@0a<OD06]eS`3E
e><0oooo00H0KVf?00X09BDf0>3OjP3PgnX0eMCS06]eS`35b=@0a<SD0:HiA03ZNG<0jGah0`3oool0
2@167QX0oooo0?ooo`3oool0kh5j0>UlN03ZNG<0YSU40<C8e@020<C8e040aLOE0@3?cmX106IVOP00
00D0oooo06IVOP3<c]X0`/CB0<74d@020<74dP0305YBDP24Q8@0inON0080kno_00L0aV/00?O6003_
]@00ki`00=j<003>J`00ii`000<0moOg00D0`/CB0<74dP31a=80`LCB0<;4d@0400h@40X0`LCA00<0
3Q0@0<74d@31a=401`31a=400`0>4100`LCA0<74d@0G0<74d@D03Q0@3@31a=400`0>4100`LCA0<74
d@190<74dHd0`LCBO@32a=800`1[MHl0kN_c0>WXl@090>WXl@070>g[l`1[MHl0`/CB0<;4dP1[MHl0
kN_c0>WXl@0702DU=P80jNSa00L0kN_c06]eS`32a=40`LCA0:HiA03aP7D0l8Al0080oooo00<0AQhJ
0?6bV`167QX00P3oool02@3eS8@0l8Al0?60M@2V>D@0`LCB0<;4d@31a=40`LCB0<c>fP0106IVOP00
00D0oooo06IVOP3:c=P0_/3?0;g0c`020;k0cP0305YBDP3_knl0kno_0080kno_0100ijd00?O6203W
Y@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0;k0c`2n`<h0_/3?0;k0cP2n`<l0_L3>S`2n`<j=
0;g0cWd0_/3>00<0JgF?0=;Ah`3blOL02@3blOL01P3BdN<0JgF?0;k0cP2n`<h0JgF?0=;Ah`X0l_7g
00L0d]7S06]eS`2m`<h0_/3>0:HiA03dRWd0mI250080AQhJ0`3b^9h204HN6P80mI2500<0m8Ym0:Hi
A02m`<l00P2n`<l10;k0cP40b/cH0@1VIWh000090?ooo`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc01J
DU80S8b<0080kno_00H0ilik0>o_k`3gmoL0moOg0>ND003gilh20?Ogm`030>oWeP3gmoL0oooo0080
^Kc<00D0^[_<0;Vlb`2j_</0^Kc<0;Vlb`2>0;Vlc8d0^[c<O@2j_</01024S:80JgF?0<c;g@3kno`6
0?ooo`040?_ko03<bmd0JgF?08B<XP80^[c;00@0Q8bR06]eS`3<bmd0no_l1P3oool02`3kno`0c<_M
06]eS`24S:80^[c<0;Vlc02AV:X0YSU40?nOS@3n_j@0n]bg0080n^Vf0P3ijKH02P3jg;L0o[nT0?nO
S@2V>D@0TIRZ0;Zlc02j^l`0^Kc;0;Jhb039b]P106IVOP0000@0oooo06IVOP36b=L0^;O?0`2_[/L0
1P1JDU80kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool0[jk7
0:n^a`3o0:n^ail0[jk700<0Q8bR06]eS`1[MHl0201[MHl00`24S:80[jk70:n^a`020:n^a`0308B<
XP1[MHl0JgF?00P0JgF?00<0Q8bR0:n^a`2_[/L00P2_[/L00`24S:80YSU40:HiA0080:HiA00308B<
XP2_[/L0[jk70080[jk70@2h]ll10<K8e`40IVIn0000103oool0IVIn0<31d@37am@30:b[a00505YB
DP2][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80ooooo`2/ZlCA0:b[a040alOD0@30`M4106IVOP00
0P3oool01@2XYkl0i^K]0=;Bh02l_<l0/K340?l0Z:Nog@2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No
0040oooo00020?ooo`0608N7V`3Gf>80o?cl0>CSj03@d>00b/[Jo`2l_<oK0;blc`060<[:fP3@d>00
i>?X0?clo03Gf>80QhNK0@3oool000<0oooo00H0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^_o0=OHh]T0
emSR00H0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/20?ooo`00103oool206IVOP0308R7W@2EU:/0Z:No
0?l0Z:NofP2XYkl0102EU:/0R8NM06IVOP1VIWh30?ooo`001P3ooooo06IVO]l0IVIn1@3oool00?l0
oooojP3oool00001\
\>"], "PictureGroup",
  Evaluatable->False,
  ImageSize->{489.5, 444.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"b:1.2"],

Cell[TextData[{
  "\nThe Database Explorer supports many more features, such as forming more \
complicated queries, saving queries, and creating reports with the result of \
a query (saved as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook). These are described in the ",
  ButtonBox["Database Explorer",
    ButtonData:>{"DatabaseLink5.0", "xref:139"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:1.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Database Connections", "Section",
  CellTags->{"xref:134", "c:19"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"xref:134", "c:20", "i:47", "b:2.0"}],

Cell["\<\
The first step in using a database is making a connection. This section \
discusses how to do this.\
\>", "Text",
  CellTags->"b:2.0"],

Cell[TextData[{
  "If you are just starting to use ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  ", you might want to look at some of the basic examples in the ",
  ButtonBox["Establishing a Connection",
    ButtonData:>{"DatabaseLink2.2.0", "xref:19"},
    ButtonStyle->"AddOnsLinkText"],
  " section. Then, to learn if ",
  StyleBox["DatabaseLink ",
    FontSlant->"Italic"],
  "comes with a driver for your database, you might want to study the ",
  ButtonBox["JDBC Connection",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  " section, which contains further information about adding new drivers. \
Finally, if you want to give your connection a name, you might want to study \
the ",
  ButtonBox["Named Connections",
    ButtonData:>{"DatabaseLink2.2.2", "xref:162"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting up a Database", "Subsection",
  CellTags->{"xref:18", "c:21", "b:2.1"}],

Cell[TextData[{
  "Many users of ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " will have an existing database they wish to connect to and use. If you \
have one, you should be able to read this documentation and modify it to \
connect to your own database. If you do not already have a database, you can \
use HSQLDB (included in ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  ")",
  ". If you want to set up a different type of database, you will need to \
refer to the specific information for that database."
}], "Text",
  CellTags->"b:2.1"],

Cell["\<\
Once you have set up your database, you can continue to use this document to \
learn how to connect to it.\
\>", "Text",
  CellTags->"b:2.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Establishing a Connection", "Subsection",
  CellTags->{"c:22", "xref:145"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"xref:19", "c:23", "b:2.2.0"}],

Cell[TextData[{
  "In this section you will see how to make a connection. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"OpenSQLConnection[\"\>",
                      "MR"], 
                    StyleBox["\<\"name\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"connect to a named SQL \
data\:f39fsource"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"OpenSQLConnection[JDBC[\"\>",
                      "MR"], 
                    StyleBox["\<\"driver\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"url\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"connect to the data source URL, using \
JDBC"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"OpenSQLConnection[\"\>",
                      "MR"], 
                    StyleBox["\<\"args\"\>",
                      "TI"], 
                    StyleBox["\<\", \"\>",
                      "MR"], 
                    StyleBox["\<\"opts\[Ellipsis]\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"set options for the connection"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"OpenConnection[\"\>",
                      "MR"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"use the Connection Tool to open a \
connection"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"CloseSQLConnection[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"close a connection"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLConnections[\"\>",
                      "MR"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"list SQL connections"\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:2.2.0"}],

Cell["Functions for working with database connections.", "Caption",
  CellTags->"b:2.2.0"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(Needs["\<DatabaseLink`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:2.2.0"],

Cell[TextData[{
  "Now you can connect to a named database, called ",
  StyleBox["demo", "MR"],
  ", that is provided by ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " for documentation. The ",
  ButtonBox["Connection Configuration",
    ButtonData:>{"DatabaseLink2.3.2", "xref:66"},
    ButtonStyle->"AddOnsLinkText"],
  " section shows how to set up new named connections. You can learn about \
existing named connection in the ",
  ButtonBox["Named Connections",
    ButtonData:>{"DatabaseLink2.2.2", "xref:162"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(SQLConnection["demo", 1, "Open", "<>"]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLConnections", "MR"],
  " returns a list of all the open connections."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLConnections[]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \({SQLConnection["demo", 1, "Open", "<>"]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[TextData[{
  StyleBox["OpenSQLConnection", "MR"],
  " returns a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression that refers to the connection. It can be used to make queries \
on the database. In the following example, the tables that are found in the \
database are returned. The functions for retrieving data from a database are \
discussed in the ",
  ButtonBox["Data Commands",
    ButtonData:>{"DatabaseLink4.0", "xref:30"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \({SQLTable["SAMPLETABLE1", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[TextData[{
  "When you have finished with a connection, you can close it with ",
  StyleBox["CloseSQLConnection", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:2.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conn\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(SQLConnection["demo", 1, "Closed", "<>"]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[TextData[{
  "There are a number of options that can be given to ",
  StyleBox["OpenSQLConnection", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Description\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a textual description of the \
connection"\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Name\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the name of the connection"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Username\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the username to use for connecting \
"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Password\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the password to use for connecting "\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"S5.27.1", "b:2.2.0"}],

Cell[TextData[{
  StyleBox["OpenSQLConnection", "MR"],
  " options."
}], "Caption",
  CellTags->"b:2.2.0"],

Cell["\<\
These options can be used when opening a connection. For instance, the \
following allows you to use a different username and password for the \
connection.\
\>", "Text",
  CellTags->"b:2.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conn = 
      OpenSQLConnection[\ "\<demo\>", \ Username -> "\<sa\>", \ 
        Password -> "\<\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(SQLConnection["demo", 2, "Open", "<>"]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[BoxData[
    \(CloseSQLConnection[\ conn]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:2.2.0"],

Cell[TextData[{
  "If you enter ",
  StyleBox["$Prompt", "MR"],
  " as a password, a dialog box opens that will prompt you for the password. \
This helps keep the password more secure."
}], "Text",
  CellTags->"b:2.2.0"],

Cell[BoxData[
    \(conn = 
      OpenSQLConnection[\ "\<demo\>", \ Username -> "\<sa\>", \ 
        Password -> "\<$Prompt\>"]\)], "Input",
  CellTags->"b:2.2.0"],

Cell[TextData[{
  "Another simple way to connect to a database is to use the ",
  ButtonBox["Connection Tool",
    ButtonData:>{"DatabaseLink2.4", "xref:23"},
    ButtonStyle->"AddOnsLinkText"],
  ", described in a later section."
}], "Text",
  CellTags->"b:2.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["JDBC Connections", "Subsubsection",
  CellTags->{"xref:20", "c:25", "b:2.2.1"}],

Cell[TextData[{
  "If you do not have a named database connection, you can still connect to \
the database by using a JDBC setting. If you find that the examples in this \
section do not work as shown, you may need to install or restore the example \
database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"JDBC[\"\>",
                      "MR"], 
                    StyleBox["\<\"name\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"url\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a JDBC setting"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"JDBC[\"\>",
                      "MR"], 
                    StyleBox["\<\"classname\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"url\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a JDBC setting that gives the explicit \
classname for the driver"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"JDBCDriverNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a list of the names of possible JDBC \
drivers"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"JDBCDrivers[\"\>",
                      "MR"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the details of all JDBC drivers"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"JDBCDrivers[\\\"\"\>",
                      "MR"], 
                    StyleBox["\<\"name\"\>",
                      "TI"], 
                    StyleBox["\<\"\\\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            TextData[{
              "the details of the JDBC driver labeled ",
              StyleBox["name", "TI"]
            }], "Text"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"b:2.2.1"],

Cell["This loads the package.", "Text",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \(Needs["\<DatabaseLink`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:2.2.1"],

Cell[TextData[{
  "The following opens a connection to HSQLDB using the file ",
  StyleBox["D$UserBaseDirectory/DatabaseResources/Examples/test", "MR"],
  ". This works because the package knows what JDBC driver to use for \
connecting to HSQLDB. "
}], "Text",
  CellTags->"b:2.2.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conn = 
      OpenSQLConnection[\ 
        JDBC["\<hsqldb\>", 
          ToFileName[{$UserBaseDirectory, "\<DatabaseResources\>", \
"\<Examples\>"}, "\<demo\>"]\ ], \ \[IndentingNewLine]\t
        Name -> "\<manualA\>", Username -> "\<sa\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \(SQLConnection["manualA", 2, "Open", "<>"]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:2.2.1"]
}, Closed]],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:2.2.1"],

Cell[TextData[{
  "The ",
  StyleBox["JDBCDriverNames", "MR"],
  " command returns the list of built-in drivers. ",
  StyleBox["hsqldb", "MR"],
  " appears in this list and therefore you can use the setting ",
  StyleBox["hsqldb", "MR"],
  " as an argument to ",
  StyleBox["JDBC", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JDBCDriverNames[]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \({"hsqldb", "jtds_sqlserver", "jtds_sybase", "mysql", 
      "odbc"}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:2.2.1"]
}, Closed]],

Cell[TextData[{
  "You can get more complete information on all of the built-in drivers by \
using ",
  StyleBox["JDBCDrivers", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JDBCDrivers[]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \({JDBCDriver["Name" \[Rule] "hsqldb", 
        "Driver" \[Rule] "org.hsqldb.jdbcDriver", 
        "Protocol" \[Rule] "jdbc:hsqldb:", "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\hsqldb.m"], 
      JDBCDriver["Name" \[Rule] "jtds_sqlserver", 
        "Driver" \[Rule] "net.sourceforge.jtds.jdbc.Driver", 
        "Protocol" \[Rule] "jdbc:jtds:sqlserver//", "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\jtds_\
sqlserver.m"], 
      JDBCDriver["Name" \[Rule] "jtds_sybase", 
        "Driver" \[Rule] "net.sourceforge.jtds.jdbc.Driver", 
        "Protocol" \[Rule] "jdbc:jtds:sybase//", "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\jtds_sybase.\
m"], JDBCDriver["Name" \[Rule] "mysql", 
        "Driver" \[Rule] "com.mysql.jdbc.Driver", 
        "Protocol" \[Rule] "jdbc:mysql://", "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\mysql.m"], 
      JDBCDriver["Name" \[Rule] "odbc", 
        "Driver" \[Rule] "sun.jdbc.odbc.JdbcOdbcDriver", 
        "Protocol" \[Rule] "jdbc:odbc:", "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\odbc.m"]}\)]\
, "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:2.2.1"]
}, Closed]],

Cell[TextData[{
  "If you want to get information on just one driver, you can do this by \
giving its name to ",
  StyleBox["JDBCDrivers", "MR"],
  ". Finding the protocol set for a driver can help to use ",
  StyleBox["OpenSQLConnection", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JDBCDrivers["\<odbc\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \(JDBCDriver["Name" \[Rule] "odbc", 
      "Driver" \[Rule] "sun.jdbc.odbc.JdbcOdbcDriver", 
      "Protocol" \[Rule] "jdbc:odbc:", "Version" \[Rule] 1.`, 
      "Location" \[Rule] 
        "C:\\Documents and Settings\\All Users\\Application Data\\Mathematica\
\\Applications\\DatabaseLink\\DatabaseResources\\odbc.m"]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:2.2.1"]
}, Closed]],

Cell[TextData[{
  "The details of how the built-in drivers are configured is described in the \
",
  ButtonBox["Database Resources",
    ButtonData:>{"DatabaseLink2.3.0", "xref:22"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[TextData[{
  "If ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " does not already contain a driver for your database, you can add your \
own. The driver is a collection of Java classes, and they must be added to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using the standard that ",
  StyleBox["J/Link", "TI"],
  " provides for adding Java classes. Typically, this is done by adding the \
classfile or a jar file to a Java subdirectory in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application. One possible location is inside ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " itself. A disadvantage is that if you update ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you may have to copy the new material. Another location would be in an \
application inside ",
  StyleBox["$UserBaseDirectory", "MR"],
  " or ",
  StyleBox["$BaseDirectory", "MR"],
  ", this would not need to be changed if you updated your software."
}], "Text",
  CellTags->"b:2.2.1"],

Cell[TextData[{
  "As an example, you could create an application for connecting to the \
Oracle database. This could be done by creating an application called ",
  StyleBox["Oracle", "MR"],
  " inside  ",
  StyleBox["$UserBaseDirectory/Applications", "MR"],
  " or ",
  StyleBox["$BaseDirectory/Applications", "MR"],
  ". You might have to create some of the directories manually, but you would \
not need to change anything if you update your software. Another advantage is \
that you can use the same location to hold a ",
  StyleBox["DatabaseResources", "MR"],
  " directory, this could hold other configuration information as discussed \
in the ",
  ButtonBox["Database Resources",
    ButtonData:>{"DatabaseLink2.3.0", "xref:22"},
    ButtonStyle->"AddOnsLinkText"],
  " section. "
}], "Text",
  CellTags->"b:2.2.1"],

Cell["\<\
The following table shows some possible locations that you could use to \
install drivers for connecting to Oracle.\
\>", "Text",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/Java\
\"\>",
                      
                      "MR"], "\<\"   location for database driver \
classfiles\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$BaseDirectory/Applications/Oracle/Java\"\>\
",
                      
                      "MR"], "\<\"   location for database driver \
classfiles\"\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "Box",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"b:2.2.1"],

Cell["Possible location for database driver classfiles.", "Caption",
  CellTags->"b:2.2.1"],

Cell["\<\
When you have installed the driver classes, you can make a connection. It \
should be noted that the URL argument you use depends on the server you are \
using. In the following example, which is not actually configured, a \
connection is made to an Oracle database using a driver installed in one of \
the locations previously suggested. The documentation for the JDBC driver \
will tell you what class and URL to use. \
\>", "Text",
  CellTags->"b:2.2.1"],

Cell[BoxData[
    \(OpenSQLConnection[
      JDBC["\<oracle.jdbc.driver.OracleDriver\>", \
"\<jdbc:oracle:thin:@server.business.com:1999\>"], 
      Name \[Rule] "\<manualOracle\>", 
      Username \[Rule] "\<server1\>"]\)], "Input",
  Evaluatable->False,
  CellTags->"b:2.2.1"],

Cell[TextData[{
  "This is the most verbose form of ",
  StyleBox["OpenSQLConnection", "MR"],
  ". Typically, you would want to use information that had been stored \
previously. This is discussed in the ",
  ButtonBox["Database Resources",
    ButtonData:>{"DatabaseLink2.3.0", "xref:22"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.2.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Named Connections", "Subsubsection",
  CellTags->{"xref:162", "b:2.2.2"}],

Cell[TextData[{
  "If your work requires that you frequently connect to the same database, it \
might be beneficial to give this connection a name and use the name in ",
  StyleBox["OpenSQLConnection", "MR"],
  ". The details of how to set up a named connection are given in the ",
  ButtonBox["Database Resources",
    ButtonData:>{"DatabaseLink2.3.0", "xref:22"},
    ButtonStyle->"AddOnsLinkText"],
  " section. This section describes how to learn what named connections are \
available."
}], "Text",
  CellTags->"b:2.2.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(DataSourceNames[]\),
              "MR"], Cell[BoxData[
                \(TraditionalForm\`"a list of the names of all \
connections"\)]]},
          {
            StyleBox[\(DataSource[]\),
              "MR"], Cell[BoxData[
                \(TraditionalForm\`"the details of all named \
connections"\)]]},
          {Cell[TextData[{
              StyleBox["DataSource[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"]
            }]], Cell[TextData[{
              "the details of the connection called ",
              StyleBox["name", "TI"]
            }], "Text"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"b:2.2.2"],

Cell["This loads the package.", "Text",
  CellTags->"b:2.2.2"],

Cell[BoxData[
    \(Needs["\<DatabaseLink`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:2.2.2"],

Cell["\<\
The following lists all the named connections. If you have installed more \
connections, you may see a larger list.\
\>", "Text",
  CellTags->"b:2.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DataSourceNames[]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:2.2.2"],

Cell[BoxData[
    \({"demo", "graphs", "publisher"}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:2.2.2"]
}, Closed]],

Cell[TextData[{
  "You can get more complete information on all of connections by using ",
  StyleBox["DataSources", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DataSources[]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:2.2.2"],

Cell[BoxData[
    \({SQLConnection[
        JDBC["hsqldb", 
          "C:\\Documents and Settings\\twj.WRI\\Application Data\\Mathematica\
\\DatabaseResources\\Examples\\demo"], "Name" \[Rule] "demo", 
        "Description" \[Rule] "Connection to hsql db for documention.", 
        "Username" \[Rule] "sa", "Password" \[Rule] \*"\<\"\"\>", 
        "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\demo.m"], 
      SQLConnection[
        JDBC["hsqldb", 
          "C:\\Documents and Settings\\twj.WRI\\Application Data\\Mathematica\
\\DatabaseResources\\Examples\\graphs"], "Name" \[Rule] "graphs", 
        "Description" \[Rule] "Connection to the graph database.", 
        "Username" \[Rule] "sa", "Password" \[Rule] \*"\<\"\"\>", 
        "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\graphs.m"], 
      SQLConnection[
        JDBC["hsqldb", 
          "C:\\Documents and Settings\\twj.WRI\\Application Data\\Mathematica\
\\DatabaseResources\\Examples\\publisher"], "Name" \[Rule] "publisher", 
        "Description" \[Rule] "Connection to hsql db for demos.", 
        "Username" \[Rule] "sa", "Password" \[Rule] \*"\<\"\"\>", 
        "Version" \[Rule] 1.`, 
        "Location" \[Rule] 
          "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\publisher.\
m"]}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:2.2.2"]
}, Closed]],

Cell[TextData[{
  "You can get information on just one named connection by giving a ",
  StyleBox["name", "TI"],
  " argument to ",
  StyleBox["DataSources", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DataSources["\<demo\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:2.2.2"],

Cell[BoxData[
    \(SQLConnection[
      JDBC["hsqldb", 
        "C:\\Documents and Settings\\twj.WRI\\Application \
Data\\Mathematica\\DatabaseResources\\Examples\\demo"], 
      "Name" \[Rule] "demo", 
      "Description" \[Rule] "Connection to hsql db for documention.", 
      "Username" \[Rule] "sa", "Password" \[Rule] \*"\<\"\"\>", 
      "Version" \[Rule] 1.`, 
      "Location" \[Rule] 
        "C:\\Documents and Settings\\All Users\\Application Data\\Mathematica\
\\Applications\\DatabaseLink\\DatabaseResources\\demo.m"]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:2.2.2"]
}, Closed]],

Cell[TextData[{
  "This is the most verbose form of ",
  StyleBox["OpenSQLConnection", "MR"],
  ". Typically, you would want to use information that had been stored \
previously. This is discussed in the ",
  ButtonBox["Database Resources",
    ButtonData:>{"DatabaseLink2.3.0", "xref:22"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Database Timeouts", "Subsubsection",
  CellTags->{"xref:138", "c:24", "b:2.2.3"}],

Cell[TextData[{
  "Database operations typically involve connecting to a server and the \
possibility of problems accessing the server must be taken into account. \
Consequently, there is a timeout for database operations such as connecting \
or executing queries. This timeout is controlled by the global variable ",
  StyleBox["$SQLTimeout", "MR"],
  "."
}], "Text",
  CellTags->"b:2.2.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"global name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"$SQLTimeout\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"timeout while making a connection and \
executing queries"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"S5.27.1", "b:2.2.3"}],

Cell["Specification of the timeout for working with the database.", "Caption",
  CellTags->"b:2.2.3"],

Cell[TextData[{
  "The default value, ",
  StyleBox["Automatic", "MR"],
  ", means that the default value given by the driver will be used."
}], "Text",
  CellTags->"b:2.2.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Database Resources", "Subsection",
  CellTags->{"c:26", "xref:146"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"xref:22", "c:27", "b:2.3.0"}],

Cell[TextData[{
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " allows other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications to hold resource information for database connections in ",
  StyleBox["DatabaseResources", "MR"],
  " directories. There are a number of possible locations of ",
  StyleBox["DatabaseResources", "MR"],
  " directories inside ",
  StyleBox["$InstallationDirectory", "MR"],
  ", ",
  StyleBox["$BaseDirectory", "MR"],
  ", and ",
  StyleBox["$UserBaseDirectory", "MR"],
  "."
}], "Text",
  CellTags->"b:2.3.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"DatabaseResourcesPath[\"\>",
                      "MR"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox["\<\"\!\(\*
StyleBox[\\\"DatabaseResources\\\",\\n\\\"MR\\\"]\) directories to search for \
resources\"\>", TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$InstallationDirectory/AddOns/ExtraPackages/\
*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                
                FormBox["\<\" possible locations for \\!\\(\\* \
StyleBox[\\\"DatabaseResources\\\",\\n\\\"MR\\\"]\\) directories\"\>", 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$InstallationDirectory/AddOns/\
StandardPackages/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$InstallationDirectory/AddOns/\
StandardPackages/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$InstallationDirectory/AddOns/Autoload/*\"\>\
",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$InstallationDirectory/AddOns/Applications/*\
\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"$BaseDirectory/Autoload/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"$BaseDirectory/Applications/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"$UserBaseDirectory/Autoload/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"$UserBaseDirectory/Applications/*\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\*"\<\"\"\>"\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  ColumnWidths->{0.6, 0.4},
  RowLines->{0.25, False}},
  CellTags->"b:2.3.0"],

Cell[TextData[{
  "The command ",
  StyleBox["DatabaseResourcesPath", "MR"],
  " shows the current locations of ",
  StyleBox["DatabaseResources", "MR"],
  " directories."
}], "Text",
  CellTags->"b:2.3.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DatabaseResourcesPath[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:2.3.0"],

Cell[BoxData[
    \({"C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\DatabaseResources\\", 
      "C:\\Documents and Settings\\WRI\\Application \
Data\\Mathematica\\DatabaseResources\\", 
      "C:\\Documents and Settings\\WRI\\Application \
Data\\Mathematica\\Applications\\DatabaseLink\\DatabaseResources\\"}\)], \
"Output",
  CellLabel->"Out[1]=",
  CellTags->"b:2.3.0"]
}, Closed]],

Cell[TextData[{
  StyleBox["DatabaseResources", "MR"],
  " directories can hold two sorts of files: those that contain JDBC settings \
and those that contain connection settings."
}], "Text",
  CellTags->"b:2.3.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["JDBC Configuration", "Subsubsection",
  CellTags->{"xref:65", "c:28", "b:2.3.1"}],

Cell[TextData[{
  "Any file that is in a ",
  StyleBox["DatabaseResources", "MR"],
  " directory with an extension of .m will be inspected to see if it contains \
possible JDBC configuration information. Here is the format of a JDBC \
configuration file."
}], "Text",
  CellTags->"b:2.3.1"],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"name\",
\t\"Driver\" -> \"driverclass\",
\t\"Protocol\" -> \"protocol\",
\t\"Version\" -> 1
]\
\>", "Program",
  CellTags->"b:2.3.1"],

Cell[TextData[{
  "In this format ",
  StyleBox["name", "MR"],
  " is the name of the connection (as might be used in ",
  StyleBox["OpenSQLConnection", "MR"],
  "), ",
  StyleBox["driverclass", "MR"],
  " is the class file of the JDBC driver, and ",
  StyleBox["protocol", "MR"],
  " is the JDBC protocol. The version of the configuration file is specified \
by the ",
  StyleBox["Version", "MR"],
  " setting. "
}], "Text",
  CellTags->"b:2.3.1"],

Cell["Here is an example file (configured for HSQLDB).", "Text",
  CellTags->"b:2.3.1"],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"hsqldb\",
\t\"Driver\" -> \"org.hsqldb.jdbcDriver\",
\t\"Protocol\" -> \"jdbc:hsqldb:\",
\t\"Version\" -> 1
]\
\>", "Program",
  CellTags->"b:2.3.1"],

Cell[TextData[{
  "This file specifies the driver and protocol to use when ",
  StyleBox["OpenSQLConnection", "MR"],
  " is invoked for an ",
  StyleBox["hsqldb", "MR"],
  " connection, such as the following command."
}], "Text",
  CellTags->"b:2.3.1"],

Cell["\<\
OpenSQLConnection[JDBC[\"hsqldb\",ToFileName[{\"DatabaseLink\",\"Examples\"},\
\"example\"]]\
\>", "Program",
  CellTags->"b:2.3.1"],

Cell["Here is another example file (configured for Oracle).", "Text",
  CellTags->"b:2.3.1"],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"oracle\",
\t\"Driver\" -> \"oracle.jdbc.driver.OracleDriver\",
\t\"Protocol\" -> \"jdbc:oracle:thin:@\",
\t\"Version\" -> 1
]\
\>", "Program",
  CellTags->"b:2.3.1"],

Cell[TextData[{
  "This specifies the driver and protocol to use when ",
  StyleBox["OpenSQLConnection", "MR"],
  " is invoked for an ",
  StyleBox["oracle", "MR"],
  " connection, such as the following command."
}], "Text",
  CellTags->"b:2.3.1"],

Cell["\<\
OpenSQLConnection[JDBC[\"oracle\",\"server.business.com:1999\"],
\tUsername -> \"server1\"]\
\>", "Program",
  CellTags->"b:2.3.1"],

Cell[TextData[{
  "Note that if you added an application to hold JDBC driver classes, as \
shown in the ",
  ButtonBox["previous section",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  ", you could create a ",
  StyleBox["DatabaseResources", "MR"],
  " directory in the same application to hold JDBC configuration information. \
The following table shows the layout of an application, named ",
  StyleBox["Oracle", "MR"],
  ", that could be used for connecting to the Oracle database."
}], "Text",
  CellTags->"b:2.3.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/Java\
\"\>",
                      
                      "MR"], "\<\"    location for database driver classfiles\
\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/\
DatabaseResources\"\>",
                      
                      "MR"], "\<\"    location for JDBC configuration files\"\
\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "Box",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"b:2.3.1"],

Cell[TextData[{
  "When you have installed a new JDBC driver, you might want to go to the ",
  ButtonBox["JDBC Connection",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  " section to confirm that your new driver is accessible to the system."
}], "Text",
  CellTags->"b:2.3.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Connection Configuration", "Subsubsection",
  CellTags->{"xref:66", "c:29", "b:2.3.2"}],

Cell[TextData[{
  "Any file that is in a ",
  StyleBox["DatabaseResources", "MR"],
  " directory with an extension of .m will be inspected to see if it contains \
possible connection configuration information. Here is the format of a \
connection configuration file."
}], "Text",
  CellTags->"b:2.3.2"],

Cell["\<\
SQLConnection[
  connectdata,
  \"Name\" -> \"name\", 
  \"Description\" -> \"text\", 
  \"Username\" -> \"user\", 
  \"Password\" -> \"pass\",
  \"RelativePath\" -> True|False
]\
\>", "Program",
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "Here ",
  StyleBox["connectdata", "MR"],
  " holds connection data (typically a JDBC setting), ",
  StyleBox["name", "MR"],
  " is the name of the connection (as might be used in ",
  StyleBox["OpenSQLConnection", "MR"],
  "), ",
  StyleBox["text", "MR"],
  " is a textual description of the connection, and ",
  StyleBox["user", "MR"],
  " and ",
  StyleBox["pass", "MR"],
  " are the username and password to use when connecting to the database. A \
password of ",
  StyleBox["$Prompt", "MR"],
  " causes a GUI to appear to enter the password. If the connection data \
involves a relative path, this is specified with the ",
  StyleBox["RelativePath", "MR"],
  " setting. The version of the configuration file is specified by the ",
  StyleBox["Version", "MR"],
  " setting."
}], "Text",
  CellTags->"b:2.3.2"],

Cell["Here is an example file (configured for HSQLDB).", "Text",
  CellTags->"b:2.3.2"],

Cell["\<\
SQLConnection[
\tJDBC[\"hsqldb\", \"../Examples/example\"], 
 \t\"Name\" -> \"example\", 
 \t\"Description\" -> \"Connection to hsql db for documention.\", 
 \t\"Username\" -> \"sa\", 
 \t\"Password\" -> \"\", 
    \"RelativePath\" -> True,
 \t\"Version\" -> 1]\
\>", "Program",
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "This file specifies that HSQLDB should be used to connect to the file ",
  StyleBox["Examples/example", "MR"],
  ", which is found relative to the location of the configuration file. The \
username ",
  StyleBox["sa", "MR"],
  " and a blank password are also given. This connection information is given \
the name ",
  StyleBox["example", "MR"],
  ". This configuration file supports the following ",
  StyleBox["OpenSQLConnection", "MR"],
  " command."
}], "Text",
  CellTags->"b:2.3.2"],

Cell["OpenSQLConnection[\"example\"]", "Program",
  CellTags->"b:2.3.2"],

Cell["Here is another example file (configured for Oracle).", "Text",
  CellTags->"b:2.3.2"],

Cell["\<\
SQLConnection[
\tJDBC[\"oracle\", \"server.business.com:1999\"], 
 \t\"Name\" -> \"businessDB\", 
 \t\"Description\" -> \"Connection to Oracle db.\", 
 \t\"Username\" -> \"server1\", 
 \t\"Version\" -> 1]\
\>", "Program",
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "This specifies connection information to use when ",
  StyleBox["OpenSQLConnection", "MR"],
  " is invoked with ",
  StyleBox["businessDB", "MR"],
  ", such as the following command."
}], "Text",
  CellTags->"b:2.3.2"],

Cell["OpenSQLConnection[\"businessDB\"]", "Program",
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "Note that if you added an application to hold JDBC driver classes, as \
shown in a ",
  ButtonBox["previous section",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  ", and JDBC configuration information as shown ",
  ButtonBox["previously",
    ButtonData:>{"DatabaseLink2.3.1", "xref:65"},
    ButtonStyle->"AddOnsLinkText"],
  ", you could use the same location for holding the Oracle connection \
information. The following table shows the layout of an application that \
could be used for connecting to Oracle."
}], "Text",
  CellTags->"b:2.3.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/Java\
\"\>",
                      
                      "MR"], "\<\"    location for database driver classfiles\
\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/\
DatabaseResources\"\>",
                      
                      "MR"], "\<\"    location for JDBC configuration files\"\
\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    
                    StyleBox["\<\"$UserBaseDirectory/Applications/Oracle/\
DatabaseResources\"\>",
                      
                      "MR"], "\<\"    location for connection configuration \
files\"\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "Box",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "If you did not wish to write the connection configuration file yourself, \
you could use the ",
  ButtonBox["New Connection Wizard",
    ButtonData:>{"DatabaseLink5.5", "xref:70"},
    ButtonStyle->"AddOnsLinkText"],
  ", described in a later section."
}], "Text",
  CellTags->"b:2.3.2"],

Cell[TextData[{
  "When you have made a new named connection, you might want to go to the ",
  ButtonBox["Named Connections",
    ButtonData:>{"DatabaseLink2.2.2", "xref:162"},
    ButtonStyle->"AddOnsLinkText"],
  " section to confirm that the new connection is accessible to the system."
}], "Text",
  CellTags->"b:2.3.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Connection Tool", "Subsection",
  CellTags->{"xref:23", "c:30", "b:2.4"}],

Cell[TextData[{
  "The Connection Tool is a graphical interface tool that simplifies opening \
a connection to a database. It is launched by executing the command ",
  StyleBox["OpenSQLConnection[]", "MR"],
  ". It can also be accessed from the ",
  ButtonBox["Database Explorer",
    ButtonData:>{"DatabaseLink5.0", "xref:139"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:2.4"],

Cell[TextData[{
  "The details of the operation of the Connection Tool are described in more \
detail in a ",
  ButtonBox["later section",
    ButtonData:>{"DatabaseLink5.1", "xref:68"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:2.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Security and Authentication", "Subsection",
  CellTags->{"xref:67", "c:31", "b:2.5"}],

Cell["\<\
Many SQL databases can be configured to require a username and password when \
a connection is made. This is useful for preventing unwanted access and \
restricting the range of operations that certain users can execute. This \
attention to security is important since databases are typically \
server-based.\
\>", "Text",
  CellTags->"b:2.5"],

Cell[TextData[{
  "There are a number of issues for ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " that need to be considered when working with passwords. These depend on \
the level of security you want and how this should be balanced with \
convenience. Another issue is whether you are running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in a stand-alone mode or inside a server (as in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"web", 
          StyleBox[
            AdjustmentBox["Mathematica",
              BoxMargins->{{-0.175, 0}, {0, 0}}],
            FontSlant->"Italic"]}], TextForm]]],
  ")."
}], "Text",
  CellTags->"b:2.5"],

Cell[TextData[{
  "The most convenient way to work with a password is to place it in a ",
  ButtonBox["connection configuration file",
    ButtonData:>{"DatabaseLink2.3.2", "xref:66"},
    ButtonStyle->"AddOnsLinkText"],
  ". However, the password will be stored in plain text and an intruder could \
inspect the configuration file and learn the password. Since this is a \
security risk, the ",
  ButtonBox["New Connection Wizard",
    ButtonData:>{"DatabaseLink5.5", "xref:70"},
    ButtonStyle->"AddOnsLinkText"],
  " does not save a password. However, you can edit the configuration file \
and add a password. You could provide further protection by ensuring that the \
permission on the configuration file is restricted to those who are intended \
to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:2.5"],

Cell[TextData[{
  "A higher level of security is obtained if you use a GUI to enter the \
password, which has the advantage that the password is never stored. The GUI \
for the password is opened whenever you use a password setting of ",
  StyleBox["$Prompt", "MR"],
  "."
}], "Text",
  CellTags->"b:2.5"],

Cell[BoxData[
    \(conn = 
      OpenSQLConnection["\<demo\>", Username \[Rule] "\<sa\>", 
        Password \[Rule] "\<$Prompt\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:2.5"],

Cell["Here is the dialog box for the password.", "Text",
  CellTags->"b:2.5"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000IB000`400?l00000o`00003od01VIWh0
000306IVOP3ko?d0nocm0<`0nocm0@1VIWh0000306IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX
00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00@0
g]cO0>CRh01kUjd09EN59`00?7@0100GCGh0Jh^V0?;akP3blO<30>3Oh`040=kLg`3Th^00NiN]02EG
QCT003ad00@05den06^;YP3blNh0l_7c;03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn:@3Pgn<0103Jf=T0IXFQ04YaT`2b_L<W0<K5e`040<36a@18KY00JXZT0>o_l@<0h=oS
00@0f]SI06J5X@1:LI<0/[g3>@36aML01030a/D0B6j@06Z:Y03_ko4/0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=SEeP0GCGh0_lO:02T0a/GG00<0][fm01M=
OP3[j^d00`3Pgn<00`3HeMH05den0;o7bP0k0<K5e`030;Jm_@0GCGh0jn[]02`0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0fMGE000lM03oool0:@3=c=l00`3o
ool003ad0>SWjP030>3Oh`030=WEe@00?7@0oooo03/0cLcO00<0oooo000lM03XinX0;03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`3IeMD003ad0?ooo`0Y0=;A
i0030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03oool0>`3BdN@00`3oool003ad0>OVj@0/0>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@00?7@0oooo
02T0e]OW00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0k0=KGi`030?ooo`00?7@0inKY
02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0fMGE000l
M03oool03`3If^L3000000<0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W0=WJi`0<0=WJ
i`030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03oool03`3If^L3000000<0fM[W0P000000103I
f^L000000=WJi`0000030=WJi`030000003If^L0fM[W00<000000`3If^L300000080fM[W00<00000
0=WJi`3If^L0303If^L00`3oool003ad0>OVj@0/0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@00?7@0oooo00h0fM[W00D000000=WJi`3If^L0fM[W0000
00020=WJi`050000003If^L0fM[W0=WJi`0000003`3If^L00`3oool003ad0>OVj@030>3Oh`030=WE
e@00?7@0oooo00h0fM[W00L000000=WJi`3If^L0fM[W0000003If^L000000080fM[W0P0000000`3I
f^L000000=WJi`020=WJi`030000003If^L0000000<0fM[W00<000000=WJi`0000000`3If^L00`00
0000fM[W0000000>0=WJi`030?ooo`00?7@0inKY02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVORT0h=oS00<0fMGE000lM03oool03@3Ngn`00`000000g]o/0=kOk0030=kO
k0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`03@3Ngn`00`3oool003ad0>OVj@030>3O
h`030=WEe@00?7@0oooo00d0g]o/00<000000=kOk03Ngn`0103Ngn`01`000000g]o/0=kOk03Ngn`0
00000=kOk00000000`3Ngn`00`000000g]o/000000050=kOk0030000003Ngn`0g]o/00<0g]o/00<0
00000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@0/0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@00?7@0oooo00d0hnG`00<000000>?Ul03SiO000`3S
iO001P000000hnG`000000000000hnG`00000100hnG`00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD0
03ad0?ooo`0=0>?Ul0030000003SiO00hnG`00D0hnG`100000000`3SiO0000000>?Ul0020>?Ul003
0000003SiO00000000D0hnG`1@0000000`3SiO0000000>?Ul00=0>?Ul0030?ooo`00?7@0inKY02`0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0fMGE000lM03o
ool03@3YjoD00`000000jN_e0>W[m@030>W[m@040000003YjoD000000>W[m@800000403YjoD00`3o
ool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3YjoD0103YjoD01P00
0000jN_e0>W[m@3YjoD000000>W[m@8000000P3YjoD00`000000jN_e000000030>W[m@030000003Y
joD0000000<0jN_e00<000000>W[m@0000003P3YjoD00`3oool003ad0>OVj@0/0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@00?7@0oooo00d0l?7l00<0
00000?3ao03`lO`00`3`lO`00`000000l?7l000000020?3ao0030000003`lO`0l?7l00h0l?7l00<0
oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`lO`0l?7l00D0l?7l0`00
00020?3ao0040000003`lO`00000000000<0l?7l0`0000030?3ao0<000000P3`lO`00`000000l?7l
0?3ao00<0?3ao0030?ooo`00?7@0inKY02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVORT0h=oS00<0fMGE000lM03oool03P3dmOd01@000000m?Gm0?Ceo@3dmOd000000080
m?Gm00D000000?Ceo@3dmOd0m?Gm0000000?0?Ceo@030?ooo`00?7@0inKY00<0h=oS00<0fMGE000l
M03oool03P3dmOd01@000000m?Gm0?Ceo@3dmOd0000001T0m?Gm00<000000?Ceo@3dmOd0303dmOd0
0`3oool003ad0>OVj@0/0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY
0>3Oh`030=WEe@00?7@0oooo00l0m_Om0`0000030?Kgo@030000003fmod0m_Om0080m_Om00<00000
0?Kgo@3fmod0303fmod00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo00l0m_Om0`00000J
0?Kgo@030000003fmod0m_Om00`0m_Om00<0oooo000lM03Wi^T0;03Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`3IeMD003ad0?ooo`0Y0?Slo@030?ooo`00?7@0
inKY00<0h=oS00<0fMGE000lM03oool0>`3ho?d00`3oool003ad0>OVj@0/0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@00?7@0oooo02T0oOgm00<0oooo
000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0k0?gmo@030?ooo`00?7@0inKY02`0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0fMGE000lM03oool0:@3moOd0
0`3oool003ad0>KVj@030>3Oh`030=WEe@00?7@0oooo03/0oOgm00<0oooo000lM03Vi^T0;03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`3He=@003ad0?ooo`0Y
0?gmo@030?ooo`00?7@0iNGX00<0h=oS00<0f=CD000lM03oool0>`3moOd00`3oool003ad0>GUj00/
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=WEe@0UEhD0
_lkL02T0oooo00<0_lkK02EGQ@3QhN@00`3Pgn<00`3IeMD09EN50;o>g00k0?ooo`030;o>f`0UEhD0
hN7T02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00@0fMGE
07VDZ@1EOJ80`<oM9`3oool0103EgnP0EGfR07VEZ`3OgN030>3Oh`040=WEe@1iU:T0EGfR0<3?gCT0
oooo00@0eMoX05EmXP1iUJ/0gmgP;03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn:@3Pgn<0103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1VQZ40h=kJ0=cKg@<0h=oS00@0
f]OI0=oLf01iU:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3Lfmd/0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030=oMh03JemT0f=CD01D0em?D403Cc/`30=OCe004
0=SDe03IeMD0f]OI0=oMh0<0h=oS00<0gmgP0=[Gf@3He=@07P3Gdm@I0=?>c0<0em?D00@0f=CD0=WE
e@3JemT0gmgP;03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn?40?ooo`80h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS``2LW9h01P3oool0h=oS0>3Oh`1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0h=oS
00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3O
h`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0409bLWP3oool0h=oS0>3Ohk`0YJbb0P3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN0?oo
o`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0YJbb0;X0oooo
00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U[;80h=oS0>3Oh`2LW9h0
oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN
0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0YJbb0;X0
oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U[;80h=oS0>3Oh`2L
W9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00D0
W9bN0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0YJbb
0;X0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
00D0W9bN0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0
YJbb0;X0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U[;80h=oS
0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80
h=oS00D0W9bN0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3Oh`3P
gn<0YJbb0;X0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U[;80
h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0YJbb0;X0oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`2U[;80^P3oool01@2U
[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS0:F//P2j0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool0
0P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0102LW9h0oooo
0>3Oh`3Pgn>l0:F//P80h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0h=oS
00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3O
h`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh2
0>3Oh`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0;l0h=oS00L0W9bN0?ooo`3Pgn<0
h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS
0;l0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh20>3Oh`0309bLWP3oool0h=oS00@0h=oS00<000000>3Oh`3Pgn<0103Pgn<2000000040>3Oh`00
0000h=oS0>3Oh`<000000`3Pgn<3000000@0h=oS00D000000>3Oh`3Pgn<0h=oS000000040>3Oh`<0
00000P3Pgn<00`000000h=oS0>3Oh`020>3Oh`80000000<0h=oS0000003Pgn<0R@3Pgn<01`2LW9h0
oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN
0?ooo`3Pgn<0103Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0080000000<0h=oS
0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3P
gn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
0>3Oh`02000008X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS00@0h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@00
0000h=oS0>3Oh`3Pgn<0000000@0h=oS00<000000>3Oh`3Pgn<00`3Pgn<02`000000h=oS0>3Oh`3P
gn<000000>3Oh`000000h=oS0000003Pgn<000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<0000000<0h=oS00D000000>3Oh`3Pgn<0h=oS0000002:0>3Oh`0709bLWP3oool0h=oS0>3Oh`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0?ooo`030?oo
o`030>3Oh`0000000000008000000`3Pgn<400000080h=oS0P0000040>3Oh`800000103Pgn<01`00
0000h=oS0000003Pgn<000000>3Oh`0000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`00
00000`3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oSR03oool01`2LW9h0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS1P2LW9h00`3Pgn<000000>3O
h`020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS0000
00030>3Oh`040000003Pgn<0000000000080h=oS00<000000>3Oh`3Pgn<00P0000020>3OhhT0W9bN
00H0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<01@00
0000h=oS0>3Oh`3Pgn<000000080h=oS0`0000030>3Oh`<000000`3Pgn<300000080h=oS00D00000
0>3Oh`3Pgn<0h=oS000000030>3Oh`030000003Pgn<0h=oS00<000000P3Pgn<00`000000h=oS0000
00020>3Oh`80000000<0h=oS0000003Pgn<0S@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn2@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000002/0h=oS00<000000>3Oh`3Pgn<0
S03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<4000002`0h=oS
00<000000>3Oh`3Pgn<0S03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
b03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVInb03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
b03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0bP1gMi8109RHY`40moOi0@1V
IWh0000306IVOP3gmoT0_;g=0</0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<00`3Thn<?05YB
D[T0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool00`3oool00`1JDU80inOW0>OWi`020=kNgP80
inOW00<0ikf40>OWi`3WinL00`3WinL20>o_khL0oooo00<0i>?S09bT^@1[MHl00P1[MHl206afT0D0
JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T306]eS`80K7J@1@1[MHl01P2LY;T0i>?S0?ooo`3o
ool0k>[Z09bT^@<0YSU40P2W>T@50:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0000/0
IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0FU9B08b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0
inOW0080inOW00@0knoW0>o_k`3_knl0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?d`0?cko340nocl
7`3ko?d00`2LY;T0JgF?08F9/00908F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?2P25RK001P1[
MHl0W:Bi0?_ko03ko?d0W:Bi0:HiA0X0ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040
IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0505YBDP3WinL0inOW0>OWi`3We/h00P3WinL01@3>
N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00<0m_Oi0?Ogn@3fmoT00P3fmoT00`3fmoP0al;A0<O2d@03
0<O2d@030?Ogn@37`]40moOi0080moOi00@0al;A0?Ogn@3gmoT0moOi0P37`]420?Ogn@<0al;A0`3g
moT00`37`]40moOi0?Ogn@040?Ogn@030<O2d@3gmoT0moOi00@0moOi1037`]40103gmoT0al;A0<O2
d@37`]420?Ogn@<0al;A0`3fmoT01@37`]40m_Oi0?Kgn@3fmoT0al;A00<0m_Oi0`37`]430?Kgn@03
0<O2d@3fmoT0m_Oi0080m_Oi1037`]4E0?KgnAl0moOi00<0JgF?08F9/02LW[h02@2LW[h01P25RK00
JgF?0?Ogn@3gmoT0JgF?08F9/0X0W9jn00P0QHV`06]eS`3gmoP0moOi0:HiA02Z?5D0`U9K0<IDFPH0
aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000806IVOP3NgN40
lO7d0?7am03`lO@0l?;d05YBDP2<S8`20>OWi`050>NeQ03FFP00eX@00?o>003>H`000P3NJ`002@3_
]H`0kno_0>o_k`3_knl0lO;d0?7am03`l_D0lO7d0?7bm00500h@40030?3am@0>4100al;A0080l?7e
00@03Q0@0<O2d@3`lOD0l?7e0P0>41020?3am@<03Q0@00D0l?7e0<O2d@3`lOD03Q0@0<O2d@050?3a
m@0300h@4037`]40l?7e00@0l?7e100>41001P37`]403Q0@00h@400>4100l?7e0<O2d@<03Q0@00/0
l?7e0<O2d@3`lOD03Q0@0?3am@37`]40l?7e00h@403`lOD0al;A0?3am@0300h@40050?3am@37`]40
l?7e00h@4037`]400`3`lOD400h@40030<O2d@3`lOD0l?7e01<0l?7e7`3`lO@00`1[MHl0/[G@0:NX
`P090:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@1`3oool30:NX`P050;:ed01[MHl0l?7d0?3a
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP040<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d
0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__05YBDP030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh0j^c_0P3Zjo00103Zjnl0j^_`00h@
4037`]440>[[l00900h@4037`]40j^_`0>[[l00>4100al;A0>[[l00>4100al;A0080j^_`00D03Q0@
0<O2d@3Zjo00j^_`00h@40020>[[l00300h@4037`]40j^_`00@0j^_`00<03Q0@0<O2d@3Zjo000`3Z
jo001P0>4100al;A0>[[l03Zjo003Q0@0<O2d@<0j^_`01403Q0@0>[[l03Zjo00j^_`0>[/l00>4100
j^c`00h@4037`]403Q0@0<O2d@0>4100al;A00h@4037`]403Q0@0<O2d@020>[/l00500h@4037`]40
j^c`00h@4037`]400P3Zk?001P0>4100al;A0>[/l03Zk?003Q0@0<O2dAD0j^c`7`3Zjnl00`1[MHl0
][WA0:f^aP060?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjnl00`1[MHl0][WA0?ooo`0606i]S`05
02DU=P2][/H0[:k60;Jid@1[MHl00P3Zjo000`2V>D@0cEUN0<]DF@020?ooo`<0d5YO0P3oool01P3=
EU/0beAI0<eIGP2V>D@0j^__0>[[l080j^__0@3Lfn0106IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H0
4@1JDU80ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_
k`3LgNH0g=kV0080g=kU00<0g=kV00h@4037`]40103Lg^D02@0>4100al;A0=cNi@3Lg^D03Q0@0<O2
d@3Lg^D03Q0@0<O2d@020=cNi@0300h@4037`]40al;A00<0al;A00<0g=kU00h@4037`]401@3Lg^D0
0`0>4100al;A0<O2d@020<O2d@030=cNi@0>4100g=kU0080al;A00D03Q0@0<O2d@3Lg^D0g=kU00h@
40040=cNi@0=00h@403Lg^D0g=kU00h@4037`]403Q0@0<O2d@0>4100al;A00h@4037`]403Q0@0<O2
d@020=cNi@0500h@4037`]40g=kU00h@4037`]400P3Lg^D01P0>4100al;A0=cNi@3Lg^D03Q0@0<O2
dC@0g=kU00@0JgF?0;o1eP2h^Lh0oooo101^KHl01P0U9CH0^;W>0;RicP2h^Lh0_l7F06]eS`80g=kU
00@0JgF?0;o1eP3oool0KVf?102h^Lh01P3oool09BDf0;RicP2h^Lh0_l7F06]eS`80g=kU00<0YSU4
0<eIGP3AFUh00`3oool0203FGf<0oooo0?ooo`3oool0e5eQ0=5JGP3=FEh0YSU40P3Lg^D00`3Lg^H0
g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>001P1JDU80a/K60>ONeP3>N`00ijd0
0>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`060=GHh03Ef>40eMSQ0=GGh03Ff>003Q0@
1037`]400`3Fen003Q0@0<O2d@020=KGh00500h@4037`]40e]OP00h@4037`]400P3Fen0500h@4003
0<O2d@3Fen003Q0@0080al;A103Fen0400h@40030=KGh037`]40e]OP00@03Q0@00<0al;A0=KGh00>
4100103Fen003P0>4100e]SP0=KHh03Ff>003Q0@0<O2d@0>4100e]SP00h@403Ff>003Q0@0<O2d@0>
4100al;A0P3Ff>00100>4100al;A0=KHh00>41020<O2d@030=KHh00>4100al;A0080e]SP00<03Q0@
0<O2d@3Ff>00503Ff>0O0=GHh@0306]eS`3;c=h0b<[I00H09BDf00D0b<[I0<S9f@38b]T0blcN06]e
S`020=GHh@0406]eS`3;c=h0oooo06i]S`<0b<[I00d0b<WI0?ooo`0U9CH0b<WI0<S:f@3;c=h0JgF?
0=KHh@3Ff>00YSU40=MOG`3KI6@0AQhJ00D0oooo00X0AQhJ0>1WI@3KI6@0eemO0:HiA03Ff>00eMSQ
0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L05YBDP030>OWi`0;0=J4
003_]@00ijD00>NU003FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL0103@d]`00`3?d]`03Q0@00h@
400200h@4080d=;L00D03Q0@0<O2d@37`]40al;A00h@40020=3Bg00600h@4037`]40al;A0<O2d@0>
4100d=;L0P37`]400`0>4100d=;L0=3Bg00200h@40030=3Bg037`]40d=;L0080d=;L00H03Q0@0<O2
d@3@d]`0d=;L00h@4037`]420=3Bg080al;A00@03Q0@0=3Bg00>4100d=;L0`37`]400`0>4100d=;L
0<O2d@020<O2d@0:00h@4037`]40cm;M00h@4037`]40cm;M00h@4037`]403Q0@0<oBg@80al;A00<0
3Q0@0<oBg@3?d]d00P0>4100103?d]d0al;A00h@403?d]d20<O2d@0300h@4037`]40cm;M01@0cm;M
7`3@d]`00`1[MHl0dm?R0<o@g@090<o@g@080=?ChP1[MHl0d=;L0=3Bg01[MHl0dm?R0?ooo`1^KHl4
0<o@g@0=0?ooo`0U9CH0cm3M0<o@g@3Cdn80JgF?0=3Bg03?d]`0YSU40=]TI03QJFD0h6aY04HN6P03
0?ooo`0704HN6P3PK6T0h6aY0>5YI@3KI6@0YSU40=3Bg@020=3Bg040cm;L0@3Be=d106IVOP0000/0
IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP0FU9B09bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00
_D800>nU0080mjd000T0mkD00?o>BP3:c]T0blgH0<_=f@3:cMT0blkH00h@4037`]40103;cMT400h@
4080blgI100>41020<_=f@<03Q0@0`3;cMT00`0>4100blgI00h@40040<_=f@0700h@4037`]40blgI
0<_=f@0>4100al;A0<_=f@0300h@40<0blgI0`0>41020<_=f@<03Q0@00D0blkI00h@403;c]T0blkI
00h@40020<_>f@0300h@403;c]T0blkI00<03Q0@0`3;c]T00`0>4100blkI00h@40020<_>f@@03Q0@
00<0al;A0<_>f@3;c]T04`3;c]TO0<_=f00406]eS`3Fe^@0f=SU0=SHiP80f=SU0P3Hf>H01P3Hf>D0
f=SV0=SHi@3Hf>D0e]KT06]eS`80blgH00@0JgF?0=KFi03oool0KVf?1@3oool02`0U9CH0f=SU0=SH
i@3Fe^@0JgF?0<_=f@3:c]P0YSU40>A^K@3TM6l0ig5_00D0oooo00L0i7A_0>MaK`3TM6l0i6i]0:Hi
A03:c]P0b/kI0080blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@04@1JDU80kno_0>o_
k`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`35am@0aLSD0080
aLOD00<0aLOE00h@4037`]401037`]470<C7e@0300h@4037`]40a<OE00l0a<OE00D03Q0@0<O2d@37
`]40al;A00h@400>0<C7eAX0a<SD00<03Q0@0<O2d@34b=@05034b=@O0<C7e00306]eS`3Ee><0h=oZ
00T0h=oZ00L0eMCS06]eS`34am@0a<OD06]eS`3Ee><0oooo00H0KVf?00X09BDf0>3OjP3PgnX0eMCS
06]eS`35b=@0a<SD0:HiA03ZNG<0jGah0`3oool02@167QX0oooo0?ooo`3oool0kh5j0>UlN03ZNG<0
YSU40<C8e@020<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=800`1JDU80
Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050<;4dP31a=80
`LCB0<74dP32a=401@0>41080<74d@0300h@4031a=40`LCA00l0`LCA100>410?0<74dAX0`LCB00<0
3Q0@0<74dP31a=805031a=8O0<;4dP0306]eS`3]jo<0jNSa00T0jNSa00L0kN_c06]eS`32a=80`/CB
06]eS`3]jo<0jNSa00L09BDf0P3Yj?401`3]jo<0JgF?0<;4d@31a=40YSU40?60M@3`Q7`00P3oool0
0`167QX0lK:K04HN6P020?ooo`090?F<Q03`Q7`0lH1e0:HiA031a=80`/CA0<74d@31a=80c<kJ0040
IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0cP0305YBDP3_knl0kno_0080kno_0100ijd00?O6203W
Y@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0;k0c`2n`<h0_/3?0;k0cP2n`<l0_L3><@2n`<ha
0;g0cQl0_/3>00<0JgF?0=;Ah`3blOL02@3blOL01P3BdN<0JgF?0;k0cP2n`<h0JgF?0=;Ah`X0l_7g
00L0d]7S06]eS`2m`<h0_/3>0:HiA03dRWd0mI250080AQhJ0`3b^9h204HN6P80mI2500<0m8Ym0:Hi
A02m`<l00P2n`<l10;k0cP40b/cH0@1VIWh0000806IVOP39b]P0][S80;Vlb`2j_</0^[c<05YBDP2<
S8`20>o_k`060>O>N`3_knl0moOg0?Ogm`3WU000mnO>0P3gmoL00`3_imH0moOg0?ooo`020;Vlc005
0;Zkc02i_</0^[c;0;Vlc02i_</0<02i_<`a0;Zlc1l0^[c;00@0Q8bR06]eS`3<bmd0no_l1P3oool0
103kno`0c<_M06]eS`24S:820;Zlb`0408B<XP1[MHl0c<_M0?_ko0H0oooo00/0no_l0<c;g@1[MHl0
Q8bR0;Zlc02i_<`0TIRZ0:HiA03oWhd0o[nT0?[L]`020?[Y]P80nNVf00X0n]bg0?joY03oWhd0YSU4
096HZP2j_<`0^[_<0;Vlb`2f^<P0bL[H0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700H0FU9B0>o_
k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0:n^a`2_[/L0QP2_
[/L00`24S:80JgF?06]eS`0806]eS`0308B<XP2_[/L0[jk70080[jk700<0Q8bR06]eS`1[MHl0201[
MHl00`24S:80[jk70:n^a`020:n^a`0308B<XP2V>D@0YSU400P0YSU400<0Q8bR0:n^a`2_[/L00P2_
[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD00<0[:_400D0FU9B0:f][@3gmnl0moOg0>o_
k`060?Ogm`80ooOg0P3ooonh0:b[a040alOD0@30`M4106IVOP0000H0oooo0:RW_`3Vi^d0d];P0;bl
c`2a/<C40:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@3oool000070?ooo`27Qi/0emSR0?clo03T
hnP0d=3P0<[:fP320;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@3oool00080oooo00H0UIB[
0=OHhP3lo?`0l_7c0>c[kP3Qh^_00=OHhP060>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[0P3oool000<0
oooo0P1VIWh00`28Qid0UIB[0:RW_`310:RW_`0409FDZ`28Qid0IVIn06IVOP<0oooo00050?ooolH0
IVIn1@3oool00001\
\>"], "PictureGroup",
  Evaluatable->False,
  ImageSize->{208, 101.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"b:2.5"],

Cell[TextData[{
  "You could also enter the password in the ",
  StyleBox["OpenSQLConnection", "MR"],
  " command, and then make sure that you deleted your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input as soon as you made the connection."
}], "Text",
  CellTags->"b:2.5"],

Cell[TextData[{
  "Using a GUI is useful for an interactive session of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", but is not very useful if you run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " inside a web server (as in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"web", 
          StyleBox[
            AdjustmentBox["Mathematica",
              BoxMargins->{{-0.175, 0}, {0, 0}}],
            FontSlant->"Italic"]}], TextForm]]],
  "). In this case, you have a number of options. You could place the \
password in a configuration file and use file permissions to restrict access \
to those who are running the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " process in the web server. An alternative would be to store the password \
in an authenticated mechanism provided by the web server. For example, the \
Tomcat server provides a mechanism based on JDBC Realms. The database \
password could be retrieved from the web server and passed to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", which could use it in an ",
  StyleBox["OpenSQLConnection", "MR"],
  " command. Any hostile inspection of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code would not find the database password without breaking the web server \
authentication mechanism."
}], "Text",
  CellTags->"b:2.5"],

Cell[TextData[{
  "For greater security, use SSL to protect the transactions between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and the database. This is described in the ",
  ButtonBox["Secure Socket Layer",
    ButtonData:>{"DatabaseLink6.5", "xref:159"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example Connections", "Subsection",
  CellTags->{"xref:21", "c:32", "b:2.6"}],

Cell["\<\
This section shows some sample connection commands and explains how they \
work.\
\>", "Text",
  CellTags->"b:2.6"],

Cell[TextData[{
  "In this example, you connect to a MySQL database called ",
  StyleBox["conn_test", "MR"],
  " running on the computer named ",
  StyleBox["databases", "MR"],
  " on port 1234 using the built-in driver with the username ",
  StyleBox["test", "MR"],
  "."
}], "Text",
  CellTags->"b:2.6"],

Cell["\<\
OpenSQLConnection[ JDBC[ \"mysql\",
\"databases:1234/conn_test\"], Username -> \"test\"]\
\>", "Program",
  CellTags->"b:2.6"],

Cell[TextData[{
  "In this example, you connect to the same MySQL database as in the previous \
example, but this time using the driver ",
  StyleBox["com.mysql.jdbc.Driver", "MR"],
  ". "
}], "Text",
  CellTags->"b:2.6"],

Cell["\<\
OpenSQLConnection[ JDBC[ \"com.mysql.jdbc.Driver\",
\"databases:1234/conn_test\"], Username -> \"test\"]\
\>", "Program",
  CellTags->"b:2.6"],

Cell[TextData[{
  "The first example requires that a JDBC connection ",
  StyleBox["mysql", "MR"],
  " has been configured. The second does not require any ",
  StyleBox["DatabaseResources", "MR"],
  " configuration. It does require that the JDBC driver, ",
  StyleBox["com.mysql.jdbc.Driver", "MR"],
  ", is made available. More information on drivers is found in the ",
  ButtonBox["JDBC Connections",
    ButtonData:>{"DatabaseLink2.2.1", "xref:20"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:2.6"],

Cell["", "Text",
  CellTags->"b:2.6"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Descriptive Commands", "Section",
  CellTags->{"xref:24", "c:33"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"xref:25", "c:34", "b:3.0"}],

Cell["\<\
It is often useful to programmatically browse information that describes the \
database.  This section describes functions that allow you to retrieve data \
such as table names, column names, column types, and more relating to the \
database structure.\
\>", "Text",
  CellTags->"b:3.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQL Tables", "Subsection",
  CellTags->{"xref:25", "c:35", "b:3.1"}],

Cell[TextData[{
  "This section discusses commands that get information about database \
tables. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:3.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTableNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"list all table names within a \
data\:f39fsource"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTableNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                
                FormBox["\<\"list all table names that match \\!\\(\\* \
StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\\) within a data source\"\
\>", TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTables[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all tables within a \
data\:f39fsource\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTables[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all tables that match \
\\!\\(\\* StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\\) within a \
data source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTableInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"list all table information within a data\
\:f39fsource"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTableInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all table information for \
tables that match \\!\\(\\* \
StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\\) within a data source\"\
\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTableTypeNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], \(list\ the\ types\ of\ table\ \
supported\ in\ this\ data\ source\)}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.1"}],

Cell["Functions for retrieving information about tables.", "Caption",
  CellTags->"b:3.1"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["publisher", "TI"],
  " database."
}], "Text",
  CellTags->"b:3.1"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<publisher\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:3.1"],

Cell[TextData[{
  StyleBox["SQLTableNames", "MR"],
  " returns a list of the names of the tables within the connection."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({"AUTHORS", "EDITORS", "PUBLISHERS", "ROYSCHED", "SALES", 
      "SALESDETAILS", "TITLEAUTHORS", "TITLEDITORS", "TITLES"}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLTables", "MR"],
  " returns a list of ",
  ButtonBox["SQLTable",
    ButtonData:>{"DatabaseLink3.2", "xref:77"},
    ButtonStyle->"AddOnsLink"],
  " expressions. These hold information about the tables in a database."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({SQLTable["AUTHORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["EDITORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["PUBLISHERS", "TableType" \[Rule] "TABLE"], 
      SQLTable["ROYSCHED", "TableType" \[Rule] "TABLE"], 
      SQLTable["SALES", "TableType" \[Rule] "TABLE"], 
      SQLTable["SALESDETAILS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLEAUTHORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLEDITORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLES", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  "In addition, ",
  StyleBox["SQLTableInformation", "MR"],
  " returns more complete information about tables.  "
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableInformation[conn] // TableForm\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {"Null", "Null", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", "Null",
             "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", "Null",
             "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", "Null", 
            "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", "Null", 
            "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//TableForm=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  "With each function, you can filter the names of the tables by providing a \
string to match as the second parameter. An important point is that this \
filtering is done on the database server, which leads to significant speed \
enhancements. The following example searches for a table named ",
  StyleBox["AUTHORS", "TI"],
  ". If no such table existed, the result would be an empty list."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn, \ "\<AUTHORS\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({SQLTable["AUTHORS", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  "It is also possible to give metacharacters to match more than one table. \
The metacharacters are '%' which matches zero or more characters, and '_' \
which matches a single character. The following command returns the names of \
all tables that start with ",
  StyleBox["TITLE", "TI"],
  "."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, \ "\<TITLE%\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({"TITLEAUTHORS", "TITLEDITORS", "TITLES"}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLTables", "MR"],
  ", ",
  StyleBox["SQLTableNames", "MR"],
  ", and ",
  StyleBox["SQLTableInformation", "MR"],
  " take a number of options."
}], "Text",
  CellTags->"b:3.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"TableType\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"TABLE\\\"\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"the type of table to be returned\"\
\>"},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Catalog\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"the database catalog to use\"\>"},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Schema\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"the database schema to use\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ShowColumnHeadings\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            TextData[{
              "return headings with the results (",
              StyleBox["SQLTableInformation", "MR"],
              " only)"
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"S5.27.1", "b:3.1"}],

Cell[TextData[{
  "The option ",
  StyleBox["TableType", "MR"],
  " selects which type of table is returned. Typically, it is the tables of \
type ",
  StyleBox["TABLE", "TI"],
  " that are of interest and by default ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " table functions only return information on these. You can use ",
  StyleBox["SQLTableTypeNames", "MR"],
  " to find all the different types of tables in your data source."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableTypeNames[conn]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  "If you want to see all the tables in the data source, you can use the \
result of ",
  StyleBox["SQLTableTypeNames", "MR"],
  " with the option ",
  StyleBox["TableType", "MR"],
  ". This is demonstrated in the following."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn, TableType \[Rule] SQLTableTypeNames[conn]]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    \({SQLTable["SYSTEM_ALIASES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_ALLTYPEINFO", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_BESTROWIDENTIFIER", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CACHEINFO", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CATALOGS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_COLUMN_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_CONSTRAINTS", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_ROUTINE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_TABLE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CLASSPRIVILEGES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_COLUMNPRIVILEGES", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_COLUMNS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CROSSREFERENCE", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_INDEXINFO", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_PRIMARYKEYS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_PROCEDURECOLUMNS", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_PROCEDURES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_PROPERTIES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SCHEMAS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SEQUENCES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SESSIONINFO", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SESSIONS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SUPERTABLES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_SUPERTYPES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TABLEPRIVILEGES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TABLES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TABLETYPES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TABLE_CONSTRAINTS", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TEXTTABLES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TRIGGERCOLUMNS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TRIGGERS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_TYPEINFO", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_UDTATTRIBUTES", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_UDTS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_USAGE_PRIVILEGES", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_USERS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VERSIONCOLUMNS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEWS", "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_COLUMN_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_ROUTINE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_TABLE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["AUTHORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["EDITORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["PUBLISHERS", "TableType" \[Rule] "TABLE"], 
      SQLTable["ROYSCHED", "TableType" \[Rule] "TABLE"], 
      SQLTable["SALES", "TableType" \[Rule] "TABLE"], 
      SQLTable["SALESDETAILS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLEAUTHORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLEDITORS", "TableType" \[Rule] "TABLE"], 
      SQLTable["TITLES", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:3.1"]
}, Closed]],

Cell[TextData[{
  "The option ",
  StyleBox["ShowColumnHeadings", "MR"],
  " can be used with ",
  StyleBox["SQLTableInformation", "MR"],
  " to return the column headings."
}], "Text",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableInformation[conn, ShowColumnHeadings \[Rule] True] // 
      TableForm\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:3.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"TABLE_TYPE\"\>", "\<\"REMARKS\"\>", "\<\"TYPE_CAT\"\>", \
"\<\"TYPE_SCHEM\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"SELF_REFERENCING_COL_NAME\"\>", "\<\"REF_GENERATION\"\>", \
"\<\"HSQLDB_TYPE\"\>", "\<\"READ_ONLY\"\>"},
          {"Null", "Null", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", "Null",
             "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", "Null",
             "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", "Null", 
            "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
          {"Null", "Null", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null", 
            "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
            "False"},
          {"Null", "Null", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", "Null", 
            "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[10]//TableForm=",
  CellTags->"b:3.1"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:3.1"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:3.1"],

Cell[TextData[{
  "If the database was designed with particular schema and catalogs, you can \
also select tables by using the ",
  StyleBox["Catalog", "MR"],
  " and ",
  StyleBox["Schema", "MR"],
  " options."
}], "Text",
  CellTags->"b:3.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQLTable", "Subsection",
  CellTags->{"xref:77", "c:36", "b:3.2"}],

Cell[TextData[{
  StyleBox["SQLTable", "MR"],
  " expressions hold information about the tables in a database. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:3.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLTable[\"\>",
                      "MR"], 
                    StyleBox["\<\"table\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"opts\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            "expression that represents an SQL table"]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"TableType\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"option that holds the type of the \
table\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.2"}],

Cell[TextData[{
  "The ",
  StyleBox["TableType", "MR"],
  " option is used to select the type of the table in the database."
}], "Text",
  CellTags->"b:3.2"],

Cell[TextData[{
  "An example demonstrating ",
  StyleBox["SQLTable", "MR"],
  " expressions follows. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:3.2"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:3.2"],

Cell[TextData[{
  "Now ",
  StyleBox["SQLTables", "MR"],
  " is used to return a list of the tables in the database; they are returned \
as ",
  StyleBox["SQLTable", "MR"],
  " expressions. In this example, a pattern is given to match the names of \
the tables, and the ",
  StyleBox["TableType", "MR"],
  " option is set to return tables of all types."
}], "Text",
  CellTags->"b:3.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTables[conn, "\<%SA%\>", \ 
      TableType \[Rule] SQLTableTypeNames[conn]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:3.2"],

Cell[BoxData[
    \({SQLTable["SYSTEM_CHECK_COLUMN_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_ROUTINE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_CHECK_TABLE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_USAGE_PRIVILEGES", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_COLUMN_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_ROUTINE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SYSTEM_VIEW_TABLE_USAGE", 
        "TableType" \[Rule] "SYSTEM TABLE"], 
      SQLTable["SAMPLETABLE1", "TableType" \[Rule] "TABLE"]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:3.2"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:3.2"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:3.2"],

Cell[TextData[{
  StyleBox["SQLTable", "MR"],
  " expressions can also be used in commands as shown in the ",
  ButtonBox["Data Command",
    ButtonData:>{"DatabaseLink4.0", "xref:30"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:3.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQL Columns", "Subsection",
  CellTags->{"xref:26", "c:37", "b:3.3"}],

Cell[TextData[{
  "This section discusses commands that get information about database \
columns. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:3.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumnNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all column names within a \
data source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumnNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox["\<\"list all column names that match \!\(\*
StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\) within a data \
source\"\>", TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumns[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all columns within a data \
source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumns[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all columns that match \!\(\*
StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\) within a data \
source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumnInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all column information for \
tables within a data source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumnInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, name, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all column information for \
columns that match \!\(\*
StyleBox[\\\"name\\\",\\nFontSlant->\\\"Italic\\\"]\) within a data \
source\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.3"}],

Cell["Functions for retrieving information about columns.", "Caption",
  CellTags->"b:3.3"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:3.3"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:3.3"],

Cell[TextData[{
  StyleBox["SQLColumnNames", "MR"],
  " returns a list of the column names within a database as a list of pairs \
of table and column names. For HSQLDB it returns information from many of the \
",
  StyleBox["SYSTEM", "TI"],
  " tables."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SAMPLETABLE1", "ENTRY"}, {"SAMPLETABLE1", "VALUE"}, {"SAMPLETABLE1", 
        "NAME"}, {"SYSTEM_ALIASES", "OBJECT_TYPE"}, {"SYSTEM_ALIASES", 
        "OBJECT_CAT"}, {"SYSTEM_ALIASES", "OBJECT_SCHEM"}, {"SYSTEM_ALIASES", 
        "OBJECT_NAME"}, {"SYSTEM_ALIASES", "ALIAS_CAT"}, {"SYSTEM_ALIASES", 
        "ALIAS_SCHEM"}, {"SYSTEM_ALIASES", "ALIAS"}, {"SYSTEM_ALLTYPEINFO", 
        "TYPE_NAME"}, {"SYSTEM_ALLTYPEINFO", 
        "DATA_TYPE"}, {"SYSTEM_ALLTYPEINFO", 
        "PRECISION"}, {"SYSTEM_ALLTYPEINFO", 
        "LITERAL_PREFIX"}, {"SYSTEM_ALLTYPEINFO", 
        "LITERAL_SUFFIX"}, {"SYSTEM_ALLTYPEINFO", 
        "CREATE_PARAMS"}, {"SYSTEM_ALLTYPEINFO", 
        "NULLABLE"}, {"SYSTEM_ALLTYPEINFO", 
        "CASE_SENSITIVE"}, {"SYSTEM_ALLTYPEINFO", 
        "SEARCHABLE"}, {"SYSTEM_ALLTYPEINFO", 
        "UNSIGNED_ATTRIBUTE"}, {"SYSTEM_ALLTYPEINFO", 
        "FIXED_PREC_SCALE"}, {"SYSTEM_ALLTYPEINFO", 
        "AUTO_INCREMENT"}, {"SYSTEM_ALLTYPEINFO", 
        "LOCAL_TYPE_NAME"}, {"SYSTEM_ALLTYPEINFO", 
        "MINIMUM_SCALE"}, {"SYSTEM_ALLTYPEINFO", 
        "MAXIMUM_SCALE"}, {"SYSTEM_ALLTYPEINFO", 
        "SQL_DATA_TYPE"}, {"SYSTEM_ALLTYPEINFO", 
        "SQL_DATETIME_SUB"}, {"SYSTEM_ALLTYPEINFO", 
        "NUM_PREC_RADIX"}, {"SYSTEM_ALLTYPEINFO", 
        "INTERVAL_PRECISION"}, {"SYSTEM_ALLTYPEINFO", 
        "AS_TAB_COL"}, {"SYSTEM_ALLTYPEINFO", 
        "AS_PROC_COL"}, {"SYSTEM_ALLTYPEINFO", 
        "MAX_PREC_ACT"}, {"SYSTEM_ALLTYPEINFO", 
        "MIN_SCALE_ACT"}, {"SYSTEM_ALLTYPEINFO", 
        "MAX_SCALE_ACT"}, {"SYSTEM_ALLTYPEINFO", 
        "COL_ST_CLS_NAME"}, {"SYSTEM_ALLTYPEINFO", 
        "COL_ST_IS_SUP"}, {"SYSTEM_ALLTYPEINFO", 
        "STD_MAP_CLS_NAME"}, {"SYSTEM_ALLTYPEINFO", 
        "STD_MAP_IS_SUP"}, {"SYSTEM_ALLTYPEINFO", 
        "CST_MAP_CLS_NAME"}, {"SYSTEM_ALLTYPEINFO", 
        "CST_MAP_IS_SUP"}, {"SYSTEM_ALLTYPEINFO", 
        "MCOL_JDBC"}, {"SYSTEM_ALLTYPEINFO", 
        "MCOL_ACT"}, {"SYSTEM_ALLTYPEINFO", 
        "DEF_OR_FIXED_SCALE"}, {"SYSTEM_ALLTYPEINFO", 
        "REMARKS"}, {"SYSTEM_ALLTYPEINFO", 
        "TYPE_SUB"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "SCOPE"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "COLUMN_NAME"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "DATA_TYPE"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "TYPE_NAME"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "COLUMN_SIZE"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "BUFFER_LENGTH"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "DECIMAL_DIGITS"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "PSEUDO_COLUMN"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "TABLE_CAT"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "TABLE_SCHEM"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "TABLE_NAME"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "NULLABLE"}, {"SYSTEM_BESTROWIDENTIFIER", 
        "IN_KEY"}, {"SYSTEM_CACHEINFO", "CACHE_CLASS"}, {"SYSTEM_CACHEINFO", 
        "CACHE_HASH"}, {"SYSTEM_CACHEINFO", 
        "CACHE_FILE"}, {"SYSTEM_CACHEINFO", 
        "CACHE_LENGTH"}, {"SYSTEM_CACHEINFO", 
        "CACHE_SIZE"}, {"SYSTEM_CACHEINFO", 
        "FREE_BYTES"}, {"SYSTEM_CACHEINFO", 
        "SMALLEST_FREE_ITEM"}, {"SYSTEM_CACHEINFO", 
        "LARGEST_FREE_ITEM"}, {"SYSTEM_CACHEINFO", 
        "FREE_COUNT"}, {"SYSTEM_CACHEINFO", "FREE_POS"}, {"SYSTEM_CACHEINFO", 
        "MAX_CACHE_SIZE"}, {"SYSTEM_CACHEINFO", 
        "MAX_CACHE_BYTE_SIZE"}, {"SYSTEM_CACHEINFO", 
        "WRITER_LENGTH"}, {"SYSTEM_CATALOGS", 
        "TABLE_CAT"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "CONSTRAINT_CATALOG"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "CONSTRAINT_SCHEMA"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "CONSTRAINT_NAME"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "TABLE_CATALOG"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "TABLE_SCHEMA"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "TABLE_NAME"}, {"SYSTEM_CHECK_COLUMN_USAGE", 
        "COLUMN_NAME"}, {"SYSTEM_CHECK_CONSTRAINTS", 
        "CONSTRAINT_CATALOG"}, {"SYSTEM_CHECK_CONSTRAINTS", 
        "CONSTRAINT_SCHEMA"}, {"SYSTEM_CHECK_CONSTRAINTS", 
        "CONSTRAINT_NAME"}, {"SYSTEM_CHECK_CONSTRAINTS", 
        "CHECK_CLAUSE"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "CONSTRAINT_CATALOG"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "CONSTRAINT_SCHEMA"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "CONSTRAINT_NAME"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "SPECIFIC_CATALOG"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "SPECIFIC_SCHEMA"}, {"SYSTEM_CHECK_ROUTINE_USAGE", 
        "SPECIFIC_NAME"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "CONSTRAINT_CATALOG"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "CONSTRAINT_SCHEMA"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "CONSTRAINT_NAME"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "TABLE_CATALOG"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "TABLE_SCHEMA"}, {"SYSTEM_CHECK_TABLE_USAGE", 
        "TABLE_NAME"}, {"SYSTEM_CLASSPRIVILEGES", 
        "CLASS_CAT"}, {"SYSTEM_CLASSPRIVILEGES", 
        "CLASS_SCHEM"}, {"SYSTEM_CLASSPRIVILEGES", 
        "CLASS_NAME"}, {"SYSTEM_CLASSPRIVILEGES", 
        "GRANTOR"}, {"SYSTEM_CLASSPRIVILEGES", 
        "GRANTEE"}, {"SYSTEM_CLASSPRIVILEGES", 
        "PRIVILEGE"}, {"SYSTEM_CLASSPRIVILEGES", 
        "IS_GRANTABLE"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "TABLE_CAT"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "TABLE_SCHEM"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "TABLE_NAME"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "COLUMN_NAME"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "GRANTOR"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "GRANTEE"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "PRIVILEGE"}, {"SYSTEM_COLUMNPRIVILEGES", 
        "IS_GRANTABLE"}, {"SYSTEM_COLUMNS", "TABLE_CAT"}, {"SYSTEM_COLUMNS", 
        "TABLE_SCHEM"}, {"SYSTEM_COLUMNS", "TABLE_NAME"}, {"SYSTEM_COLUMNS", 
        "COLUMN_NAME"}, {"SYSTEM_COLUMNS", "DATA_TYPE"}, {"SYSTEM_COLUMNS", 
        "TYPE_NAME"}, {"SYSTEM_COLUMNS", "COLUMN_SIZE"}, {"SYSTEM_COLUMNS", 
        "BUFFER_LENGTH"}, {"SYSTEM_COLUMNS", 
        "DECIMAL_DIGITS"}, {"SYSTEM_COLUMNS", 
        "NUM_PREC_RADIX"}, {"SYSTEM_COLUMNS", "NULLABLE"}, {"SYSTEM_COLUMNS", 
        "REMARKS"}, {"SYSTEM_COLUMNS", "COLUMN_DEF"}, {"SYSTEM_COLUMNS", 
        "SQL_DATA_TYPE"}, {"SYSTEM_COLUMNS", 
        "SQL_DATETIME_SUB"}, {"SYSTEM_COLUMNS", 
        "CHAR_OCTET_LENGTH"}, {"SYSTEM_COLUMNS", 
        "ORDINAL_POSITION"}, {"SYSTEM_COLUMNS", 
        "IS_NULLABLE"}, {"SYSTEM_COLUMNS", 
        "SCOPE_CATLOG"}, {"SYSTEM_COLUMNS", 
        "SCOPE_SCHEMA"}, {"SYSTEM_COLUMNS", 
        "SCOPE_TABLE"}, {"SYSTEM_COLUMNS", 
        "SOURCE_DATA_TYPE"}, {"SYSTEM_COLUMNS", 
        "TYPE_SUB"}, {"SYSTEM_CROSSREFERENCE", 
        "PKTABLE_CAT"}, {"SYSTEM_CROSSREFERENCE", 
        "PKTABLE_SCHEM"}, {"SYSTEM_CROSSREFERENCE", 
        "PKTABLE_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "PKCOLUMN_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "FKTABLE_CAT"}, {"SYSTEM_CROSSREFERENCE", 
        "FKTABLE_SCHEM"}, {"SYSTEM_CROSSREFERENCE", 
        "FKTABLE_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "FKCOLUMN_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "KEY_SEQ"}, {"SYSTEM_CROSSREFERENCE", 
        "UPDATE_RULE"}, {"SYSTEM_CROSSREFERENCE", 
        "DELETE_RULE"}, {"SYSTEM_CROSSREFERENCE", 
        "FK_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "PK_NAME"}, {"SYSTEM_CROSSREFERENCE", 
        "DEFERRABILITY"}, {"SYSTEM_INDEXINFO", 
        "TABLE_CAT"}, {"SYSTEM_INDEXINFO", 
        "TABLE_SCHEM"}, {"SYSTEM_INDEXINFO", 
        "TABLE_NAME"}, {"SYSTEM_INDEXINFO", 
        "NON_UNIQUE"}, {"SYSTEM_INDEXINFO", 
        "INDEX_QUALIFIER"}, {"SYSTEM_INDEXINFO", 
        "INDEX_NAME"}, {"SYSTEM_INDEXINFO", "TYPE"}, {"SYSTEM_INDEXINFO", 
        "ORDINAL_POSITION"}, {"SYSTEM_INDEXINFO", 
        "COLUMN_NAME"}, {"SYSTEM_INDEXINFO", 
        "ASC_OR_DESC"}, {"SYSTEM_INDEXINFO", 
        "CARDINALITY"}, {"SYSTEM_INDEXINFO", "PAGES"}, {"SYSTEM_INDEXINFO", 
        "FILTER_CONDITION"}, {"SYSTEM_PRIMARYKEYS", 
        "TABLE_CAT"}, {"SYSTEM_PRIMARYKEYS", 
        "TABLE_SCHEM"}, {"SYSTEM_PRIMARYKEYS", 
        "TABLE_NAME"}, {"SYSTEM_PRIMARYKEYS", 
        "COLUMN_NAME"}, {"SYSTEM_PRIMARYKEYS", 
        "KEY_SEQ"}, {"SYSTEM_PRIMARYKEYS", 
        "PK_NAME"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "PROCEDURE_CAT"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "PROCEDURE_SCHEM"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "PROCEDURE_NAME"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "COLUMN_NAME"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "COLUMN_TYPE"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "DATA_TYPE"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "TYPE_NAME"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "PRECISION"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "LENGTH"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "SCALE"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "RADIX"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "NULLABLE"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "REMARKS"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "SPECIFIC_NAME"}, {"SYSTEM_PROCEDURECOLUMNS", 
        "SEQ"}, {"SYSTEM_PROCEDURES", "PROCEDURE_CAT"}, {"SYSTEM_PROCEDURES", 
        "PROCEDURE_SCHEM"}, {"SYSTEM_PROCEDURES", 
        "PROCEDURE_NAME"}, {"SYSTEM_PROCEDURES", 
        "NUM_INPUT_PARAMS"}, {"SYSTEM_PROCEDURES", 
        "NUM_OUTPUT_PARAMS"}, {"SYSTEM_PROCEDURES", 
        "NUM_RESULT_SETS"}, {"SYSTEM_PROCEDURES", 
        "REMARKS"}, {"SYSTEM_PROCEDURES", 
        "PROCEDURE_TYPE"}, {"SYSTEM_PROCEDURES", 
        "ORIGIN"}, {"SYSTEM_PROCEDURES", 
        "SPECIFIC_NAME"}, {"SYSTEM_PROPERTIES", 
        "PROPERTY_SCOPE"}, {"SYSTEM_PROPERTIES", 
        "PROPERTY_NAMESPACE"}, {"SYSTEM_PROPERTIES", 
        "PROPERTY_NAME"}, {"SYSTEM_PROPERTIES", 
        "PROPERTY_VALUE"}, {"SYSTEM_PROPERTIES", 
        "PROPERTY_CLASS"}, {"SYSTEM_SCHEMAS", 
        "TABLE_SCHEM"}, {"SYSTEM_SCHEMAS", 
        "TABLE_CATALOG"}, {"SYSTEM_SEQUENCES", 
        "SEQUENCE_CATALOG"}, {"SYSTEM_SEQUENCES", 
        "SEQUENCE_SCHEMA"}, {"SYSTEM_SEQUENCES", 
        "SEQUENCE_NAME"}, {"SYSTEM_SEQUENCES", 
        "DTD_IDENTIFIER"}, {"SYSTEM_SEQUENCES", 
        "MAXIMUM_VALUE"}, {"SYSTEM_SEQUENCES", 
        "MINIMUM_VALUE"}, {"SYSTEM_SEQUENCES", 
        "INCREMENT"}, {"SYSTEM_SEQUENCES", 
        "CYCLE_OPTION"}, {"SYSTEM_SEQUENCES", 
        "START_WITH"}, {"SYSTEM_SESSIONINFO", "KEY"}, {"SYSTEM_SESSIONINFO", 
        "VALUE"}, {"SYSTEM_SESSIONS", "SESSION_ID"}, {"SYSTEM_SESSIONS", 
        "CONNECTED"}, {"SYSTEM_SESSIONS", "USER_NAME"}, {"SYSTEM_SESSIONS", 
        "IS_ADMIN"}, {"SYSTEM_SESSIONS", "AUTOCOMMIT"}, {"SYSTEM_SESSIONS", 
        "READONLY"}, {"SYSTEM_SESSIONS", "MAXROWS"}, {"SYSTEM_SESSIONS", 
        "LAST_IDENTITY"}, {"SYSTEM_SESSIONS", 
        "TRANSACTION_SIZE"}, {"SYSTEM_SUPERTABLES", 
        "TABLE_CAT"}, {"SYSTEM_SUPERTABLES", 
        "TABLE_SCHEM"}, {"SYSTEM_SUPERTABLES", 
        "TABLE_NAME"}, {"SYSTEM_SUPERTABLES", 
        "SUPERTABLE_NAME"}, {"SYSTEM_SUPERTYPES", 
        "TYPE_CAT"}, {"SYSTEM_SUPERTYPES", 
        "TYPE_SCHEM"}, {"SYSTEM_SUPERTYPES", 
        "TYPE_NAME"}, {"SYSTEM_SUPERTYPES", 
        "SUPERTYPE_CAT"}, {"SYSTEM_SUPERTYPES", 
        "SUPERTYPE_SCHEM"}, {"SYSTEM_SUPERTYPES", 
        "SUPERTYPE_NAME"}, {"SYSTEM_TABLEPRIVILEGES", 
        "TABLE_CAT"}, {"SYSTEM_TABLEPRIVILEGES", 
        "TABLE_SCHEM"}, {"SYSTEM_TABLEPRIVILEGES", 
        "TABLE_NAME"}, {"SYSTEM_TABLEPRIVILEGES", 
        "GRANTOR"}, {"SYSTEM_TABLEPRIVILEGES", 
        "GRANTEE"}, {"SYSTEM_TABLEPRIVILEGES", 
        "PRIVILEGE"}, {"SYSTEM_TABLEPRIVILEGES", 
        "IS_GRANTABLE"}, {"SYSTEM_TABLES", "TABLE_CAT"}, {"SYSTEM_TABLES", 
        "TABLE_SCHEM"}, {"SYSTEM_TABLES", "TABLE_NAME"}, {"SYSTEM_TABLES", 
        "TABLE_TYPE"}, {"SYSTEM_TABLES", "REMARKS"}, {"SYSTEM_TABLES", 
        "TYPE_CAT"}, {"SYSTEM_TABLES", "TYPE_SCHEM"}, {"SYSTEM_TABLES", 
        "TYPE_NAME"}, {"SYSTEM_TABLES", 
        "SELF_REFERENCING_COL_NAME"}, {"SYSTEM_TABLES", 
        "REF_GENERATION"}, {"SYSTEM_TABLES", 
        "HSQLDB_TYPE"}, {"SYSTEM_TABLES", "READ_ONLY"}, {"SYSTEM_TABLETYPES", 
        "TABLE_TYPE"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "CONSTRAINT_CATALOG"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "CONSTRAINT_SCHEMA"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "CONSTRAINT_NAME"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "CONSTRAINT_TYPE"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "TABLE_CATALOG"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "TABLE_SCHEMA"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "TABLE_NAME"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "IS_DEFERRABLE"}, {"SYSTEM_TABLE_CONSTRAINTS", 
        "INITIALLY_DEFERRED"}, {"SYSTEM_TEXTTABLES", 
        "TABLE_CAT"}, {"SYSTEM_TEXTTABLES", 
        "TABLE_SCHEM"}, {"SYSTEM_TEXTTABLES", 
        "TABLE_NAME"}, {"SYSTEM_TEXTTABLES", 
        "DATA_SOURCE_DEFINTION"}, {"SYSTEM_TEXTTABLES", 
        "FILE_PATH"}, {"SYSTEM_TEXTTABLES", 
        "FILE_ENCODING"}, {"SYSTEM_TEXTTABLES", 
        "FIELD_SEPARATOR"}, {"SYSTEM_TEXTTABLES", 
        "VARCHAR_SEPARATOR"}, {"SYSTEM_TEXTTABLES", 
        "LONGVARCHAR_SEPARATOR"}, {"SYSTEM_TEXTTABLES", 
        "IS_IGNORE_FIRST"}, {"SYSTEM_TEXTTABLES", 
        "IS_ALL_QUOTED"}, {"SYSTEM_TEXTTABLES", 
        "IS_QUOTED"}, {"SYSTEM_TEXTTABLES", 
        "IS_DESC"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TRIGGER_CAT"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TRIGGER_SCHEM"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TRIGGER_NAME"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TABLE_CAT"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TABLE_SCHEM"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "TABLE_NAME"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "COLUMN_NAME"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "COLUMN_LIST"}, {"SYSTEM_TRIGGERCOLUMNS", 
        "COLUMN_USAGE"}, {"SYSTEM_TRIGGERS", 
        "TRIGGER_CAT"}, {"SYSTEM_TRIGGERS", 
        "TRIGGER_SCHEM"}, {"SYSTEM_TRIGGERS", 
        "TRIGGER_NAME"}, {"SYSTEM_TRIGGERS", 
        "TRIGGER_TYPE"}, {"SYSTEM_TRIGGERS", 
        "TRIGGERING_EVENT"}, {"SYSTEM_TRIGGERS", 
        "TABLE_CAT"}, {"SYSTEM_TRIGGERS", "TABLE_SCHEM"}, {"SYSTEM_TRIGGERS", 
        "BASE_OBJECT_TYPE"}, {"SYSTEM_TRIGGERS", 
        "TABLE_NAME"}, {"SYSTEM_TRIGGERS", 
        "COLUMN_NAME"}, {"SYSTEM_TRIGGERS", 
        "REFERENCING_NAMES"}, {"SYSTEM_TRIGGERS", 
        "WHEN_CLAUSE"}, {"SYSTEM_TRIGGERS", "STATUS"}, {"SYSTEM_TRIGGERS", 
        "DESCRIPTION"}, {"SYSTEM_TRIGGERS", 
        "ACTION_TYPE"}, {"SYSTEM_TRIGGERS", 
        "TRIGGER_BODY"}, {"SYSTEM_TYPEINFO", 
        "TYPE_NAME"}, {"SYSTEM_TYPEINFO", "DATA_TYPE"}, {"SYSTEM_TYPEINFO", 
        "PRECISION"}, {"SYSTEM_TYPEINFO", 
        "LITERAL_PREFIX"}, {"SYSTEM_TYPEINFO", 
        "LITERAL_SUFFIX"}, {"SYSTEM_TYPEINFO", 
        "CREATE_PARAMS"}, {"SYSTEM_TYPEINFO", 
        "NULLABLE"}, {"SYSTEM_TYPEINFO", 
        "CASE_SENSITIVE"}, {"SYSTEM_TYPEINFO", 
        "SEARCHABLE"}, {"SYSTEM_TYPEINFO", 
        "UNSIGNED_ATTRIBUTE"}, {"SYSTEM_TYPEINFO", 
        "FIXED_PREC_SCALE"}, {"SYSTEM_TYPEINFO", 
        "AUTO_INCREMENT"}, {"SYSTEM_TYPEINFO", 
        "LOCAL_TYPE_NAME"}, {"SYSTEM_TYPEINFO", 
        "MINIMUM_SCALE"}, {"SYSTEM_TYPEINFO", 
        "MAXIMUM_SCALE"}, {"SYSTEM_TYPEINFO", 
        "SQL_DATA_TYPE"}, {"SYSTEM_TYPEINFO", 
        "SQL_DATETIME_SUB"}, {"SYSTEM_TYPEINFO", 
        "NUM_PREC_RADIX"}, {"SYSTEM_TYPEINFO", 
        "TYPE_SUB"}, {"SYSTEM_UDTATTRIBUTES", 
        "TYPE_CAT"}, {"SYSTEM_UDTATTRIBUTES", 
        "TYPE_SCHEM"}, {"SYSTEM_UDTATTRIBUTES", 
        "TYPE_NAME"}, {"SYSTEM_UDTATTRIBUTES", 
        "ATTR_NAME"}, {"SYSTEM_UDTATTRIBUTES", 
        "DATA_TYPE"}, {"SYSTEM_UDTATTRIBUTES", 
        "ATTR_TYPE_NAME"}, {"SYSTEM_UDTATTRIBUTES", 
        "ATTR_SIZE"}, {"SYSTEM_UDTATTRIBUTES", 
        "DECIMAL_DIGITS"}, {"SYSTEM_UDTATTRIBUTES", 
        "NUM_PREC_RADIX"}, {"SYSTEM_UDTATTRIBUTES", 
        "NULLABLE"}, {"SYSTEM_UDTATTRIBUTES", 
        "REMARKS"}, {"SYSTEM_UDTATTRIBUTES", 
        "ATTR_DEF"}, {"SYSTEM_UDTATTRIBUTES", 
        "SQL_DATA_TYPE"}, {"SYSTEM_UDTATTRIBUTES", 
        "SQL_DATETIME_SUB"}, {"SYSTEM_UDTATTRIBUTES", 
        "CHAR_OCTET_LENGTH"}, {"SYSTEM_UDTATTRIBUTES", 
        "ORDINAL_POSITION"}, {"SYSTEM_UDTATTRIBUTES", 
        "IS_NULLABLE"}, {"SYSTEM_UDTATTRIBUTES", 
        "SCOPE_CATALOG"}, {"SYSTEM_UDTATTRIBUTES", 
        "SCOPE_SCHEMA"}, {"SYSTEM_UDTATTRIBUTES", 
        "SCOPE_TABLE"}, {"SYSTEM_UDTATTRIBUTES", 
        "SOURCE_DATA_TYPE"}, {"SYSTEM_UDTS", "TYPE_CAT"}, {"SYSTEM_UDTS", 
        "TYPE_SCHEM"}, {"SYSTEM_UDTS", "TYPE_NAME"}, {"SYSTEM_UDTS", 
        "CLASS_NAME"}, {"SYSTEM_UDTS", "DATA_TYPE"}, {"SYSTEM_UDTS", 
        "REMARKS"}, {"SYSTEM_UDTS", "BASE_TYPE"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "GRANTOR"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "GRANTEE"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "OBJECT_CATALOG"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "OBJECT_SCHEMA"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "OBJECT_NAME"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "OBJECT_TYPE"}, {"SYSTEM_USAGE_PRIVILEGES", 
        "IS_GRANTABLE"}, {"SYSTEM_USERS", "USER"}, {"SYSTEM_USERS", 
        "ADMIN"}, {"SYSTEM_VERSIONCOLUMNS", 
        "SCOPE"}, {"SYSTEM_VERSIONCOLUMNS", 
        "COLUMN_NAME"}, {"SYSTEM_VERSIONCOLUMNS", 
        "DATA_TYPE"}, {"SYSTEM_VERSIONCOLUMNS", 
        "TYPE_NAME"}, {"SYSTEM_VERSIONCOLUMNS", 
        "COLUMN_SIZE"}, {"SYSTEM_VERSIONCOLUMNS", 
        "BUFFER_LENGTH"}, {"SYSTEM_VERSIONCOLUMNS", 
        "DECIMAL_DIGITS"}, {"SYSTEM_VERSIONCOLUMNS", 
        "PSEUDO_COLUMN"}, {"SYSTEM_VERSIONCOLUMNS", 
        "TABLE_CAT"}, {"SYSTEM_VERSIONCOLUMNS", 
        "TABLE_SCHEM"}, {"SYSTEM_VERSIONCOLUMNS", 
        "TABLE_NAME"}, {"SYSTEM_VIEWS", "TABLE_CATALOG"}, {"SYSTEM_VIEWS", 
        "TABLE_SCHEMA"}, {"SYSTEM_VIEWS", "TABLE_NAME"}, {"SYSTEM_VIEWS", 
        "VIEW_DEFINITION"}, {"SYSTEM_VIEWS", 
        "CHECK_OPTION"}, {"SYSTEM_VIEWS", "IS_UPDATABLE"}, {"SYSTEM_VIEWS", 
        "VALID"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_SCHEMA"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "TABLE_CATALOG"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "TABLE_SCHEMA"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "TABLE_NAME"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "COLUMN_NAME"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "TABLE_CATALOG"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "TABLE_SCHEMA"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "TABLE_NAME"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "SPECIFIC_CATALOG"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "SPECIFIC_SCHEMA"}, {"SYSTEM_VIEW_ROUTINE_USAGE", 
        "SPECIFIC_NAME"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_SCHEMA"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "TABLE_CATALOG"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "TABLE_SCHEMA"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "TABLE_NAME"}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  "It is possible to use metacharacters that will match names. As mentioned \
in the ",
  ButtonBox["SQL Tables ",
    ButtonData:>{"DatabaseLink3.1", "xref:25"},
    ButtonStyle->"AddOnsLinkText"],
  "section, the metacharacters are '%' for zero or more characters and '_' \
for a single character. The following command matches columns in tables that \
have names starting with SA."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ "\<SA%\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SAMPLETABLE1", "ENTRY"}, {"SAMPLETABLE1", "VALUE"}, {"SAMPLETABLE1", 
        "NAME"}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumns", "MR"],
  " returns a list of ",
  StyleBox["SQLColumn", "MR"],
  " expressions. An ",
  StyleBox["SQLColumn", "MR"],
  " expression is sometimes useful for ",
  ButtonBox["structural arguments",
    ButtonData:>{"DatabaseLink6.0", "xref:46"},
    ButtonStyle->"AddOnsLinkText"],
  " in database commands. This is because they contain information on the \
table name, column name, data type, whether an entry can be set to ",
  StyleBox["Null", "MR"],
  ", and the data length."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumns[conn, \ "\<SA%\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({SQLColumn[{"SAMPLETABLE1", "ENTRY"}, "DataTypeName" \[Rule] "INTEGER", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "VALUE"}, "DataTypeName" \[Rule] "DOUBLE", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "NAME"}, "DataTypeName" \[Rule] "VARCHAR", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 2147483647]}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumnInformation", "MR"],
  " returns more information about the columns.  "
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnInformation[conn, \ "\<SA%\>"] // TableForm\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    TagBox[GridBox[{
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
            "4", "\<\"INTEGER\"\>", "0", "4", "0", "10", "1", "Null", "Null", 
            "4", "0", "0", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null",
             "1"},
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
            "8", "\<\"DOUBLE\"\>", "0", "8", "0", "10", "1", "Null", "Null", 
            "8", "0", "0", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null",
             "1"},
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
            "12", "\<\"VARCHAR\"\>", "2147483647", "0", "0", "0", "1", "Null",
             "Null", "12", "0", "0", "3", "\<\"YES\"\>", "Null", "Null", 
            "Null", "Null", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//TableForm=",
  CellTags->"b:3.3"]
}, Closed]],

Cell["\<\
You can filter the names of the columns by providing a list of metacharacters \
to match the table and column names. The following command searches in all \
tables to return all columns that start with V.\
\>", "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ {"\<%\>", "\<V%\>"}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SYSTEM_VIEWS", "VALID"}, {"SAMPLETABLE1", 
        "VALUE"}, {"SYSTEM_SESSIONINFO", "VALUE"}, {"SYSTEM_TEXTTABLES", 
        "VARCHAR_SEPARATOR"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEWS", 
        "VIEW_DEFINITION"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_SCHEMA"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_SCHEMA"}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell["\<\
You can find all the columns in a single table by specifying the table \
name.\
\>", "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ {"\<SAMPLETABLE1\>", "\<%\>"}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SAMPLETABLE1", "ENTRY"}, {"SAMPLETABLE1", "VALUE"}, {"SAMPLETABLE1", 
        "NAME"}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  "You can also give a ",
  StyleBox["SQLTable", "MR"],
  " argument."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, SQLTable["\<SAMPLETABLE1\>"]]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SAMPLETABLE1", "ENTRY"}, {"SAMPLETABLE1", "VALUE"}, {"SAMPLETABLE1", 
        "NAME"}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumnNames", "MR"],
  " returns a list where each entry is a list of the table name and the \
column names. If you want a list of just the column names, you can use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " part notation, entered with ",
  StyleBox["[[All, 2]]", "MR"],
  ", to extract just the second elements."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SQLColumnNames[conn, SQLTable["\<SAMPLETABLE1\>"]]\)[\([\)\(All, 
      2\)\(]\)]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({"ENTRY", "VALUE", "NAME"}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  "In addition, you can give an ",
  StyleBox["SQLColumn", "MR"],
  " argument."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, SQLColumn["\<V%\>"]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    \({{"SYSTEM_VIEWS", "VALID"}, {"SAMPLETABLE1", 
        "VALUE"}, {"SYSTEM_SESSIONINFO", "VALUE"}, {"SYSTEM_TEXTTABLES", 
        "VARCHAR_SEPARATOR"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_CATALOG"}, {"SYSTEM_VIEWS", 
        "VIEW_DEFINITION"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_NAME"}, {"SYSTEM_VIEW_COLUMN_USAGE", 
        "VIEW_SCHEMA"}, {"SYSTEM_VIEW_TABLE_USAGE", 
        "VIEW_SCHEMA"}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:3.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumns", "MR"],
  ", ",
  StyleBox["SQLColumnNames", "MR"],
  ", and ",
  StyleBox["SQLColumnInformation", "MR"],
  " take a number of options."
}], "Text",
  CellTags->"b:3.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Catalog\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"the database catalog to use\"\>"},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Schema\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"the database schema to use\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ShowColumnHeadings\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            TextData[{
              "return headings with the results (",
              StyleBox["SQLColumnInformation", "MR"],
              " only)"
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"S5.27.1", "b:3.3"}],

Cell[TextData[{
  "The option ",
  StyleBox["ShowColumnHeadings", "MR"],
  " can be used with ",
  StyleBox["SQLColumnInformation", "MR"],
  " to return the column headings."
}], "Text",
  CellTags->"b:3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnInformation[conn, \ "\<SA%\>", 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:3.3"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"COLUMN_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"COLUMN_SIZE\"\>", "\<\"BUFFER_LENGTH\"\>", "\<\"DECIMAL_DIGITS\"\>", "\<\
\"NUM_PREC_RADIX\"\>", "\<\"NULLABLE\"\>", "\<\"REMARKS\"\>", "\<\"COLUMN_DEF\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"CHAR_OCTET_LENGTH\"\>", "\<\"ORDINAL_POSITION\"\>", \
"\<\"IS_NULLABLE\"\>", "\<\"SCOPE_CATLOG\"\>", "\<\"SCOPE_SCHEMA\"\>", \
"\<\"SCOPE_TABLE\"\>", "\<\"SOURCE_DATA_TYPE\"\>", "\<\"TYPE_SUB\"\>"},
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
            "4", "\<\"INTEGER\"\>", "0", "4", "0", "10", "1", "Null", "Null", 
            "4", "0", "0", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null",
             "1"},
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
            "8", "\<\"DOUBLE\"\>", "0", "8", "0", "10", "1", "Null", "Null", 
            "8", "0", "0", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null",
             "1"},
          {"Null", "Null", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
            "12", "\<\"VARCHAR\"\>", "2147483647", "0", "0", "0", "1", "Null",
             "Null", "12", "0", "0", "3", "\<\"YES\"\>", "Null", "Null", 
            "Null", "Null", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[12]//TableForm=",
  CellTags->"b:3.3"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:3.3"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:3.3"],

Cell[TextData[{
  "If the database was designed with particular schema and catalogs, you can \
also select columns by using the ",
  StyleBox["Catalog", "MR"],
  " and ",
  StyleBox["Schema", "MR"],
  " options."
}], "Text",
  CellTags->"b:3.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQLColumn", "Subsection",
  CellTags->{"xref:78", "c:38", "b:3.4"}],

Cell[TextData[{
  StyleBox["SQLColumn", "MR"],
  " expressions hold information about the columns in a database. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:3.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLColumn[{\"\>",
                      "MR"], 
                    StyleBox["\<\"table\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"col\"\>",
                      "TI"], 
                    StyleBox["\<\"},\"\>",
                      "MR"], 
                    StyleBox["\<\"opts\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            "expression that represents a column in an SQL table"]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"DataTypeName\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"option that holds the type of the \
entry\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Nullable\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"option that states whether the \
entry can be null\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"DataLength\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"option that gives the maximum \
length for variable length data\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.4"}],

Cell[TextData[{
  "Here is an example demonstrating ",
  StyleBox["SQLColumn", "MR"],
  " expressions. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:3.4"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:3.4"],

Cell[TextData[{
  StyleBox["SQLColumns", "MR"],
  " returns a list of the columns in the database as ",
  StyleBox["SQLColumn", "MR"],
  " expressions. In this example a pattern is given to pick out just the ",
  StyleBox["SAMPLETABLE1", "TI"],
  " table."
}], "Text",
  CellTags->"b:3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumns[conn, "\<SAMPLETABLE1\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:3.4"],

Cell[BoxData[
    \({SQLColumn[{"SAMPLETABLE1", "ENTRY"}, "DataTypeName" \[Rule] "INTEGER", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "VALUE"}, "DataTypeName" \[Rule] "DOUBLE", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 0], 
      SQLColumn[{"SAMPLETABLE1", "NAME"}, "DataTypeName" \[Rule] "VARCHAR", 
        "Nullable" \[Rule] 1, "DataLength" \[Rule] 2147483647]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:3.4"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:3.4"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:3.4"],

Cell[TextData[{
  StyleBox["SQLColumn", "MR"],
  " expressions can also be used in commands as discussed in the ",
  ButtonBox["Data Command",
    ButtonData:>{"DatabaseLink4.0", "xref:30"},
    ButtonStyle->"AddOnsLinkText"],
  " section. The ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.1.2", "xref:32"},
    ButtonStyle->"AddOnsLinkText"],
  " section discusses one important use."
}], "Text",
  CellTags->"b:3.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQL Data Types", "Subsection",
  CellTags->{"xref:27", "c:39", "b:3.5"}],

Cell[TextData[{
  "This section discusses how to retrieve information about data types. When \
you create a table, you will need to refer to these data types. ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:3.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLDataTypeNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all data type names within a \
data source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLDataTypeInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"list all data type information within a\
\:f39fdata source"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLDataTypeInformation[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, opts\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all data type information \
within a data source and set the \\!\\(\\* \
StyleBox[\\\"ShowColumnHeadings\\\",\\n\\\"MR\\\"]\\) option\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.5"}],

Cell["Functions for retrieving information about tables.", "Caption",
  CellTags->"b:3.5"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:3.5"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:3.5"],

Cell[TextData[{
  StyleBox["SQLDataTypeNames", "MR"],
  " returns a list of the data type names within a database."
}], "Text",
  CellTags->"b:3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDataTypeNames[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:3.5"],

Cell[BoxData[
    \({"TINYINT", "BIGINT", "LONGVARBINARY", "VARBINARY", "BINARY", 
      "LONGVARCHAR", "CHAR", "NUMERIC", "DECIMAL", "INTEGER", "SMALLINT", 
      "FLOAT", "REAL", "DOUBLE", "VARCHAR", "VARCHAR_IGNORECASE", "BOOLEAN", 
      "DATE", "TIME", "TIMESTAMP", "OTHER"}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:3.5"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLDataTypeInformation", "MR"],
  " returns more complete information about the data types.  "
}], "Text",
  CellTags->"b:3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDataTypeInformation[conn] // TableForm\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:3.5"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TINYINT\"\>", \(-6\), "3", "Null", "Null", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"TINYINT\"\>", "0", 
            "0", \(-6\), "0", "10", "1"},
          {"\<\"BIGINT\"\>", \(-5\), "19", "Null", "Null", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"BIGINT\"\>", "0", 
            "0", "25", "0", "10", "1"},
          {"\<\"LONGVARBINARY\"\>", \(-4\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "False", "3",
             "False", "False", "False", "\<\"LONGVARBINARY\"\>", "0", "0", 
            "30", "0", "0", "1"},
          {"\<\"VARBINARY\"\>", \(-3\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "False", "3",
             "False", "False", "False", "\<\"VARBINARY\"\>", "0", "0", "30", 
            "0", "0", "1"},
          {"\<\"BINARY\"\>", \(-2\), "2147483647", "\<\"'\"\>", "\<\"'\"\>", 
            "Null", "1", "False", "3", "False", "False", 
            "False", "\<\"BINARY\"\>", "0", "0", "30", "0", "0", "1"},
          {"\<\"LONGVARCHAR\"\>", \(-1\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "True", "3", 
            "False", "False", "False", "\<\"LONGVARCHAR\"\>", "0", "0", "40", 
            "0", "0", "1"},
          {"\<\"CHAR\"\>", "1", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "True", "3", "False", "False", "False", "\<\"CHAR\"\>", "0", "0", 
            "1", "0", "0", "1"},
          {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
            "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", 
            "False", "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "0", "10",
             "1"},
          {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
            "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", 
            "False", "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "0", "10",
             "1"},
          {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"INTEGER\"\>", "0", "0", "4",
             "0", "10", "1"},
          {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", 
            "5", "0", "10", "1"},
          {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"FLOAT\"\>", \(-324\), "306", 
            "6", "0", "10", "1"},
          {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"REAL\"\>", \(-324\), "306", 
            "7", "0", "10", "1"},
          {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"DOUBLE\"\>", \(-324\), "306",
             "8", "0", "10", "1"},
          {"\<\"VARCHAR\"\>", "12", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "False", "3", "False", "False", "False", "\<\"VARCHAR\"\>", "0", 
            "0", "12", "0", "0", "1"},
          {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "True", "3", "False", "False", 
            "False", "\<\"VARCHAR_IGNORECASE\"\>", "0", "0", "12", "0", "0", 
            "4"},
          {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"BOOLEAN\"\>", "0", "0", 
            "16", "0", "0", "1"},
          {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"DATE\"\>", "0", "0",
             "9", "1", "0", "1"},
          {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"TIME\"\>", "0", "0",
             "9", "2", "0", "1"},
          {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", 
            "1", "False", "3", "False", "False", "False", "\<\"TIMESTAMP\"\>",
             "0", "0", "9", "3", "0", "1"},
          {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", 
            "Null", "1", "True", "0", "False", "False", 
            "False", "\<\"OTHER\"\>", "0", "0", "1111", "0", "0", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//TableForm=",
  CellTags->"b:3.5"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLDataTypeInformation", "MR"],
  " takes a single option: ",
  StyleBox["ShowColumnHeadings", "MR"],
  ". This returns the column headings."
}], "Text",
  CellTags->"b:3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDataTypeInformation[conn, \ ShowColumnHeadings \[Rule] True] // 
      TableForm\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:3.5"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TYPE_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"PRECISION\"\>", "\<\
\"LITERAL_PREFIX\"\>", "\<\"LITERAL_SUFFIX\"\>", "\<\"CREATE_PARAMS\"\>", "\<\
\"NULLABLE\"\>", "\<\"CASE_SENSITIVE\"\>", "\<\"SEARCHABLE\"\>", \
"\<\"UNSIGNED_ATTRIBUTE\"\>", "\<\"FIXED_PREC_SCALE\"\>", "\<\"AUTO_INCREMENT\
\"\>", "\<\"LOCAL_TYPE_NAME\"\>", "\<\"MINIMUM_SCALE\"\>", "\<\"MAXIMUM_SCALE\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"NUM_PREC_RADIX\"\>", "\<\"TYPE_SUB\"\>"},
          {"\<\"TINYINT\"\>", \(-6\), "3", "Null", "Null", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"TINYINT\"\>", "0", 
            "0", \(-6\), "0", "10", "1"},
          {"\<\"BIGINT\"\>", \(-5\), "19", "Null", "Null", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"BIGINT\"\>", "0", 
            "0", "25", "0", "10", "1"},
          {"\<\"LONGVARBINARY\"\>", \(-4\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "False", "3",
             "False", "False", "False", "\<\"LONGVARBINARY\"\>", "0", "0", 
            "30", "0", "0", "1"},
          {"\<\"VARBINARY\"\>", \(-3\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "False", "3",
             "False", "False", "False", "\<\"VARBINARY\"\>", "0", "0", "30", 
            "0", "0", "1"},
          {"\<\"BINARY\"\>", \(-2\), "2147483647", "\<\"'\"\>", "\<\"'\"\>", 
            "Null", "1", "False", "3", "False", "False", 
            "False", "\<\"BINARY\"\>", "0", "0", "30", "0", "0", "1"},
          {"\<\"LONGVARCHAR\"\>", \(-1\), 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", "True", "3", 
            "False", "False", "False", "\<\"LONGVARCHAR\"\>", "0", "0", "40", 
            "0", "0", "1"},
          {"\<\"CHAR\"\>", "1", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "True", "3", "False", "False", "False", "\<\"CHAR\"\>", "0", "0", 
            "1", "0", "0", "1"},
          {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
            "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", 
            "False", "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "0", "10",
             "1"},
          {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
            "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", 
            "False", "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "0", "10",
             "1"},
          {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"INTEGER\"\>", "0", "0", "4",
             "0", "10", "1"},
          {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", 
            "5", "0", "10", "1"},
          {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"FLOAT\"\>", \(-324\), "306", 
            "6", "0", "10", "1"},
          {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"REAL\"\>", \(-324\), "306", 
            "7", "0", "10", "1"},
          {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", 
            "3", "False", "False", "False", "\<\"DOUBLE\"\>", \(-324\), "306",
             "8", "0", "10", "1"},
          {"\<\"VARCHAR\"\>", "12", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "False", "3", "False", "False", "False", "\<\"VARCHAR\"\>", "0", 
            "0", "12", "0", "0", "1"},
          {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
            "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", 
            "True", "3", "False", "False", 
            "False", "\<\"VARCHAR_IGNORECASE\"\>", "0", "0", "12", "0", "0", 
            "4"},
          {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False",
             "3", "False", "False", "False", "\<\"BOOLEAN\"\>", "0", "0", 
            "16", "0", "0", "1"},
          {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"DATE\"\>", "0", "0",
             "9", "1", "0", "1"},
          {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
            "False", "3", "False", "False", "False", "\<\"TIME\"\>", "0", "0",
             "9", "2", "0", "1"},
          {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", 
            "1", "False", "3", "False", "False", "False", "\<\"TIMESTAMP\"\>",
             "0", "0", "9", "3", "0", "1"},
          {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", 
            "Null", "1", "True", "0", "False", "False", 
            "False", "\<\"OTHER\"\>", "0", "0", "1111", "0", "0", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//TableForm=",
  CellTags->"b:3.5"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:3.5"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:3.5"],

Cell[TextData[{
  "More information on working with data types is provided in the ",
  ButtonBox["Data Type Mapping",
    ButtonData:>{"DatabaseLink6.1.0", "xref:141"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:3.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Schema and Catalogs", "Subsection",
  CellTags->{"xref:150", "b:3.6"}],

Cell[TextData[{
  "Database schema and catalogs can be used to hold collections of database \
components and objects suitable for particular users. They can be \
particularly useful when working with large databases. The functions ",
  StyleBox["SQLSchemaNames", "MR"],
  " and ",
  StyleBox["SQLCatalogNames", "MR"],
  " can be used to learn the names of the schema and catalogs in the \
database. These can be used with the ",
  StyleBox["Schema", "MR"],
  " and ",
  StyleBox["Catalog", "MR"],
  " options to focus attention on particular parts of the database."
}], "Text",
  CellTags->"b:3.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLCatalogNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all the catalogs used in a \
data source\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLSchemaNames[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"list all the schema used in a data \
source\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:3.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Commands", "Section",
  CellTags->{"xref:28", "c:40"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"xref:30", "c:41", "b:4.0"}],

Cell[TextData[{
  "This section will describe the commands that can be used to interact with \
data in the database. It will show how to create tables, insert data, update \
data, remove data, drop tables, and select data. ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " provides two styles of commands for working with data: one for those who \
are familiar with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and one for those who are familiar with SQL."
}], "Text",
  CellTags->"b:4.0"],

Cell[TextData[{
  "In addition, ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " provides a GUI, the ",
  ButtonBox["Database Explorer",
    ButtonData:>{"DatabaseLink5.0", "xref:139"},
    ButtonStyle->"AddOnsLinkText"],
  ", that avoids the need to work with a command interface."
}], "Text",
  CellTags->"b:4.0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica-",
    FontSlant->"Italic"],
  "Based Queries"
}], "Subsection",
  CellTags->{"c:42", "xref:147"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"xref:140", "c:43", "b:4.1.0"}],

Cell[TextData[{
  "This section describes how to carry out database queries using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions. The advantage of this approach is that it requires less \
knowledge of SQL. However, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands do not give complete coverage, thus, for more advanced queries, \
SQL style commands may be preferred. The latter may also be desirable if you \
already have a knowledge of SQL."
}], "Text",
  CellTags->"b:4.1.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting Data", "Subsubsection",
  CellTags->{"xref:31", "c:44", "b:4.1.1"}],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " selects and returns data from a database. An alternative, using raw SQL, \
is described in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.2", "xref:38"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLSelect[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn,\:f39ftable, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], \(select\ all\ data\ from\ the\ \
table\)},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLSelect[\"\>",
                        "MR"], 
                      
                      StyleBox["\<\"conn,\:f39f{ tables.. }, { columns.. \
}\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], \(select\ data\ in\ certain\ columns\ \
from\ the\ table\)},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLSelect[\"\>",
                        "MR"], 
                      StyleBox["conn",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({tables .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({columns .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["condition",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], \(select\ data\ in\ certain\ columns\ \
from\ the\ table\ meeting\ the\ condition\)}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.1"}],

Cell["Retrieving data from a database.", "Caption",
  CellTags->"b:4.1.1"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["publisher", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<publisher\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.1"],

Cell[TextData[{
  "This retrieves all data within the table, ",
  StyleBox["ROYSCHED", "TI"],
  "."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0, 5000, 0.1`}, {"BS1011", 5001, 50000, 0.12`}, {"CP5018", 
        0, 2000, 0.1`}, {"CP5018", 2001, 4000, 0.12`}, {"CP5018", 4001, 
        50000, 0.16`}, {"BS1001", 0, 1000, 0.1`}, {"BS1001", 1001, 5000, 
        0.12`}, {"BS1001", 5001, 7000, 0.16`}, {"BS1001", 7001, 50000, 
        0.18`}, {"PS9999", 0, 50000, 0.1`}, {"PY2002", 0, 1000, 
        0.1`}, {"PY2002", 1001, 5000, 0.12`}, {"PY2002", 5001, 50000, 
        0.14`}, {"PY2003", 0, 2000, 0.1`}, {"PY2003", 2001, 5000, 
        0.12`}, {"PY2003", 5001, 50000, 0.14`}, {"UK3004", 0, 1000, 
        0.1`}, {"UK3004", 1001, 2000, 0.12`}, {"UK3004", 2001, 6000, 
        0.14`}, {"UK3004", 6001, 8000, 0.18`}, {"UK3004", 8001, 50000, 
        0.2`}, {"CK4005", 0, 2000, 0.1`}, {"CK4005", 2001, 6000, 
        0.12`}, {"CK4005", 6001, 8000, 0.16`}, {"CK4005", 8001, 50000, 
        0.16`}, {"CP5010", 0, 5000, 0.1`}, {"CP5010", 5001, 50000, 
        0.12`}, {"PY2012", 0, 5000, 0.1`}, {"PY2012", 5001, 50000, 
        0.12`}, {"PY2013", 0, 5000, 0.1`}, {"PY2013", 5001, 50000, 
        0.12`}, {"UK3006", 0, 1000, 0.1`}, {"UK3006", 1001, 2000, 
        0.12`}, {"UK3006", 2001, 6000, 0.14`}, {"UK3006", 6001, 8000, 
        0.18`}, {"UK3006", 8001, 50000, 0.2`}, {"BS1014", 0, 4000, 
        0.1`}, {"BS1014", 4001, 8000, 0.12`}, {"BS1014", 8001, 50000, 
        0.14`}, {"UK3015", 0, 2000, 0.1`}, {"UK3015", 2001, 4000, 
        0.12`}, {"UK3015", 4001, 8000, 0.14`}, {"UK3015", 8001, 12000, 
        0.16`}, {"CK4016", 0, 5000, 0.1`}, {"CK4016", 5001, 15000, 
        0.12`}, {"CK4017", 0, 2000, 0.1`}, {"CK4017", 2001, 8000, 
        0.12`}, {"CK4017", 8001, 16000, 0.14`}, {"BS1007", 0, 5000, 
        0.1`}, {"BS1007", 5001, 50000, 0.12`}, {"PY2008", 0, 50000, 
        0.1`}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "The third parameter of ",
  StyleBox["SQLSelect", "MR"],
  " can be used to select only certain columns. In this example, only the ",
  StyleBox["TITLE_ID", "TI"],
  " and ",
  StyleBox["ROYALTY", "TI"],
  " columns are selected."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(data\  = \ 
      SQLSelect[
        conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}]\)], \
"Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"BS1011", 0.12`}, {"CP5018", 0.1`}, {"CP5018", 
        0.12`}, {"CP5018", 0.16`}, {"BS1001", 0.1`}, {"BS1001", 
        0.12`}, {"BS1001", 0.16`}, {"BS1001", 0.18`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2002", 0.12`}, {"PY2002", 
        0.14`}, {"PY2003", 0.1`}, {"PY2003", 0.12`}, {"PY2003", 
        0.14`}, {"UK3004", 0.1`}, {"UK3004", 0.12`}, {"UK3004", 
        0.14`}, {"UK3004", 0.18`}, {"UK3004", 0.2`}, {"CK4005", 
        0.1`}, {"CK4005", 0.12`}, {"CK4005", 0.16`}, {"CK4005", 
        0.16`}, {"CP5010", 0.1`}, {"CP5010", 0.12`}, {"PY2012", 
        0.1`}, {"PY2012", 0.12`}, {"PY2013", 0.1`}, {"PY2013", 
        0.12`}, {"UK3006", 0.1`}, {"UK3006", 0.12`}, {"UK3006", 
        0.14`}, {"UK3006", 0.18`}, {"UK3006", 0.2`}, {"BS1014", 
        0.1`}, {"BS1014", 0.12`}, {"BS1014", 0.14`}, {"UK3015", 
        0.1`}, {"UK3015", 0.12`}, {"UK3015", 0.14`}, {"UK3015", 
        0.16`}, {"CK4016", 0.1`}, {"CK4016", 0.12`}, {"CK4017", 
        0.1`}, {"CK4017", 0.12`}, {"CK4017", 0.14`}, {"BS1007", 
        0.1`}, {"BS1007", 0.12`}, {"PY2008", 0.1`}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "The results of the database operation can immediately be used in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  "
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Last\  /@ \ data, \ PlotJoined \[Rule] True]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.1.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0186741 -0.573889 5.88604 [
[.21055 .00222 -6 -9 ]
[.21055 .00222 6 0 ]
[.39729 .00222 -6 -9 ]
[.39729 .00222 6 0 ]
[.58403 .00222 -6 -9 ]
[.58403 .00222 6 0 ]
[.77077 .00222 -6 -9 ]
[.77077 .00222 6 0 ]
[.95752 .00222 -6 -9 ]
[.95752 .00222 6 0 ]
[.01131 .13244 -24 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -24 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -24 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -24 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .01472 m
.21055 .02097 L
s
[(10)] .21055 .00222 0 1 Mshowa
.39729 .01472 m
.39729 .02097 L
s
[(20)] .39729 .00222 0 1 Mshowa
.58403 .01472 m
.58403 .02097 L
s
[(30)] .58403 .00222 0 1 Mshowa
.77077 .01472 m
.77077 .02097 L
s
[(40)] .77077 .00222 0 1 Mshowa
.95752 .01472 m
.95752 .02097 L
s
[(50)] .95752 .00222 0 1 Mshowa
.125 Mabswid
.06116 .01472 m
.06116 .01847 L
s
.09851 .01472 m
.09851 .01847 L
s
.13585 .01472 m
.13585 .01847 L
s
.1732 .01472 m
.1732 .01847 L
s
.2479 .01472 m
.2479 .01847 L
s
.28525 .01472 m
.28525 .01847 L
s
.3226 .01472 m
.3226 .01847 L
s
.35994 .01472 m
.35994 .01847 L
s
.43464 .01472 m
.43464 .01847 L
s
.47199 .01472 m
.47199 .01847 L
s
.50934 .01472 m
.50934 .01847 L
s
.54669 .01472 m
.54669 .01847 L
s
.62138 .01472 m
.62138 .01847 L
s
.65873 .01472 m
.65873 .01847 L
s
.69608 .01472 m
.69608 .01847 L
s
.73343 .01472 m
.73343 .01847 L
s
.80812 .01472 m
.80812 .01847 L
s
.84547 .01472 m
.84547 .01847 L
s
.88282 .01472 m
.88282 .01847 L
s
.92017 .01472 m
.92017 .01847 L
s
.99486 .01472 m
.99486 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.12)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.14)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.16)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.18)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.2)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04248 .01472 m
.06116 .13244 L
.07983 .01472 L
.09851 .13244 L
.11718 .36788 L
.13585 .01472 L
.15453 .13244 L
.1732 .36788 L
.19188 .4856 L
.21055 .01472 L
.22923 .01472 L
.2479 .13244 L
.26657 .25016 L
.28525 .01472 L
.30392 .13244 L
.3226 .25016 L
.34127 .01472 L
.35994 .13244 L
.37862 .25016 L
.39729 .4856 L
.41597 .60332 L
.43464 .01472 L
.45331 .13244 L
.47199 .36788 L
.49066 .36788 L
.50934 .01472 L
.52801 .13244 L
.54669 .01472 L
.56536 .13244 L
.58403 .01472 L
.60271 .13244 L
.62138 .01472 L
.64006 .13244 L
.65873 .25016 L
.6774 .4856 L
.69608 .60332 L
.71475 .01472 L
.73343 .13244 L
.7521 .25016 L
.77077 .01472 L
.78945 .13244 L
.80812 .25016 L
.8268 .36788 L
.84547 .01472 L
.86415 .13244 L
.88282 .01472 L
.90149 .13244 L
.92017 .25016 L
.93884 .01472 L
.95752 .13244 L
Mistroke
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00J`3oool00`3o_g@000000000
000300000005001d_`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0oooo0?ooo`0i0?ooo`030?oo
_`1d0000000000@0000000D0M;oo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo03X0
oooo00D0_g@0000000000000000004RLg`040?ooo`050?noM000000000000000001d_ol0?P3oool0
1@3ogi`0B000000000000000M;oo00<0oooo00D0okmd000000000000000007Boo`0m0?ooo`050;md
0000000000000000001d_ol0103oool01@3o_g@00000000000000000M;oo00/0oooo001^0?ooo`03
09a8B02Lgol0oooo00@0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolk0?ooo`030;md000007@0
_ooo0080oooo00<0giad09cOo`3oool00P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooocX0oooo
00L0_g@0001d_`3oool0oooo0?oo_`1d0000B9cO00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02o
oolo0?ooo`030;md001d_ol0oooo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolk0?ooo`07
0;md0000M;l0oooo0?ooo`3ogi`0B00007Boo`030?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo
2P3oool006h0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018
W=l0oooo03/0oooo00<0okmd0000B02Lgol01@3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018
W=l0oooo03h0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo03h0
oooo00<0_g@007Boo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo03l0
oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo00T0oooo001^0?oo
o`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0l0?oo
o`030?oOW0180000B9cO00@0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0m0?oo
o`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0j0?oo
o`030=nLB0000000000000<0000000D0M;oo0?ooo`3oool0gia804RLg`030?ooo`030?noM000M;l0
oooo03l0oooo00H0okmd001d_`3oool0oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo00T0oooo
001^0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?oo
o`0n0?ooo`0309a80018W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?oo
o`0k0?ooo`040=nLB0000000001809cOo`<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo
0?ooo`0j0?ooo`060?noM00007@0_ooo0?ooo`2oM000M;oo0`3oool00`3OW4P0B9cO0?ooo`020?oo
o`030?noM000M;l0oooo03l0oooo00H0W4P007Boo`3oool0oooo0=nLB018W=l30?ooo`030?noM000
M;l0oooo00T0oooo001^0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool0
0`3o_g@007Bo0?ooo`0o0?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo
0?ooo`0m0?ooo`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo
0?ooo`0k0?ooo`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0B9cO0?ooo`020?ooo`03
0?noM000M;l0oooo03X0oooo00<0oono07@0000000000P0000001P18W=l0oooo0?ooo`3oool0gia8
04RLg`<0oooo00<0okmd001d_`3oool02@3oool006h0oooo00<0W4Q809cOo`3oool00`3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo00<0gia807Boo`3oool00P3oool01P2o
M000M;oo0?ooo`3oool0okmd04RLg`<0oooo00<0gia804RLg`3oool0?P3oool01P2oM000M;oo0?oo
o`3oool0okmd04RLg`<0oooo00<0gia804RLg`3oool0?03oool0102LB000B9cO0;md001d_ol30?oo
o`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool0>P3oool00`3ookl0M01d0;ooo`060?oo
o`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool02@3oool006/0oooo00D0gia800000000
B9`0W4Q809cOo`050?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo>`3oool01`3o_g@0001d0;oo
o`3oool0okmd0000B02Lgol00`3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooocX0oooo00L0okmd
0000B02Lgol0oooo0?oOW01804P0W=oo00<0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolm0?oo
o`040?oOW01804P0B4P007Boo`@0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolk0?ooo`030?oo
_`1d07@0_ooo00L0oooo00H0W4P007Boo`3oool0omnL04P0M02oool:0?ooo`00K@3oool00`3OW4P0
001809cOo`050?ooo`050?oo_`1d000000000000B02Lgol0?@3oool01@3o_g@000000000000004P0
W=oo00@0oooo00D0oono07@000000000001809cOo`0l0?ooo`050?oOW018000000000000001d_ol0
103oool01@3ookl0M0000000000004P0W=oo03l0oooo00<0okmd0000001d_ol0103oool01@3ookl0
M0000000000004P0W=oo03`0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`020?oo
o`050?oo_`1d000000000000B02Lgol02`3oool00?l0oooo/@3oool00?l0oooo/@3oool002P0oooo
00<000000?ooo`3oool0o`3ooon60?ooo`00:03oool00`000000oooo0?ooo`3o0?ooohH0oooo000X
0?ooo`030000003oool0oooo0?l0ooooQP3oool002P0oooo00<000000?ooo`3oool0o`3ooon60?oo
o`00:03oool00`000000oooo0?ooo`3o0?ooohH0oooo000X0?ooo`030000003oool0oooo0?l0oooo
QP3oool001l0ooooo`00002A00000040oooo000X0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0040oooo000X0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?oo
o`00:03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo0P00000E0?ooo`80
0000703oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool04`3oool2000002@0oooo00<000000?ooo`3oool06P3oool2000000d0oooo0P00000=0?ooo`80
00003@3oool2000002@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo00/0oooo0P00000E0?ooo`8000003@3oool00`000000oooo0?ooo`080?ooo`00
:03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000
503oool2000001`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`800000
503oool2000002@0oooo0P00000K0?ooo`800000303oool00`000000oooo0000000<0?ooo`030000
003oool0000000`0oooo00<000000?ooo`000000903oool2000001@0oooo0P00000L0?ooo`800000
303oool00`000000oooo0000000D0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`00:03o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000503o
ool2000001`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`800000503o
ool2000002@0oooo0P00000K0?ooo`800000303oool00`000000oooo0000000<0?ooo`030000003o
ool0000000`0oooo00<000000?ooo`000000903oool2000001@0oooo0P00000L0?ooo`800000303o
ool00`000000oooo0000000D0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`00:03oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000503oool2
000001`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
000001@0oooo0P00000T0?ooo`8000006`3oool2000000`0oooo00<000000?ooo`000000303oool0
0`000000oooo0000000<0?ooo`030000003oool0000002@0oooo0P00000C0?ooo`030000003oool0
000001`0oooo0P00000<0?ooo`030000003oool0000001@0oooo0P00000<0?ooo`030000003oool0
oooo00T0oooo000X0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0000000D0?ooo`800000703oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0140oooo00<000000?ooo`0000004`3oool00`000000oooo0000000T0?ooo`8000006`3oool20000
00`0oooo00<000000?ooo`000000303oool00`000000oooo0000000<0?ooo`030000003oool00000
02@0oooo0P00000C0?ooo`030000003oool0000001`0oooo0P00000<0?ooo`030000003oool00000
01<0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`090?ooo`00:03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000503oool2000001`0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0000001<0
oooo00<000000?ooo`000000903oool2000001/0oooo0P00000<0?ooo`030000003oool0000000`0
oooo00<000000?ooo`000000303oool00`000000oooo0000000T0?ooo`8000004`3oool00`000000
oooo0000000L0?ooo`800000303oool00`000000oooo0000000C0?ooo`030000003oool0000000`0
oooo00<000000?ooo`3oool02@3oool002P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000001@0oooo00<000000?ooo`0000006`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0140oooo00<000000?ooo`0000004`3oool010000000
oooo0?ooo`00000S0?ooo`8000006`3oool00`000000oooo0000000;0?ooo`040000003oool0oooo
000000/0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`00000S0?ooo`800000
4`3oool00`000000oooo0000000K0?ooo`030000003oool0000000/0oooo00@000000?ooo`3oool0
00004`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00T0oooo000X0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`00000D0?oo
o`030000003oool0000001/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0000001<0oooo00@000000?ooo`3oool000008`3oool2000001/0oooo00<00000
0?ooo`0000002`3oool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo000000/0oooo
00@000000?ooo`3oool000008`3oool2000001<0oooo00<000000?ooo`0000006`3oool00`000000
oooo0000000;0?ooo`040000003oool0oooo000001<0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`090?ooo`00:03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`040000003oool0oooo000001/0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`040000003oool0oooo00000180oooo
00@000000?ooo`3oool000008`3oool00`000000oooo0000000I0?ooo`040000003oool0oooo0000
00X0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000002P3o
ool01@000000oooo0?ooo`3oool0000002<0oooo00<000000?ooo`0000004P3oool010000000oooo
0?ooo`00000J0?ooo`040000003oool0oooo000000X0oooo00D000000?ooo`3oool0oooo0000000B
0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool02P3oool002P0oooo0`000007
0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`040000003o
ool0oooo000001/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`040000
003oool0oooo00000180oooo00@000000?ooo`3oool000008`3oool00`000000oooo0000000I0?oo
o`040000003oool0oooo000000X0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003o
ool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000002<0oooo00<000000?ooo`00
00004P3oool010000000oooo0?ooo`00000J0?ooo`040000003oool0oooo000000X0oooo00D00000
0?ooo`3oool0oooo0000000B0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
2P3oool002P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`050000003o
ool0oooo0?ooo`0000004P3oool010000000oooo0?ooo`00000K0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0403oool010000000oooo0?ooo`00000B0?ooo`040000003oool0oooo
000002<0oooo00<000000?ooo`0000006@3oool010000000oooo0?ooo`00000:0?ooo`050000003o
ool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D000000?ooo`3o
ool0oooo0000000S0?ooo`030000003oool000000180oooo00@000000?ooo`3oool000006P3oool0
10000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000004P3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00X0oooo000X0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool000000180oooo00@000000?ooo`3o
ool000006P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0100oooo00@000000?oo
o`3oool000004P3oool010000000oooo0?ooo`00000S0?ooo`030000003oool0000001T0oooo00@0
00000?ooo`3oool000002P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D000000?ooo`3o
ool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000008`3oool00`000000oooo0000000B
0?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool000002P3oool01@000000oooo
0?ooo`3oool000000180oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0:0?oo
o`00:03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?ooo`0000006@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0100oooo00@000000?ooo`3oool000004P3oool0
1@000000oooo0?ooo`3oool000000240oooo00@000000?ooo`3oool000006@3oool01@000000oooo
0?ooo`3oool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01l0oooo00@000000?ooo`3oool000004P3oool010000000oooo0?ooo`00000J
0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0@0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`0:0?ooo`00:03o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?ooo`0000006@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0100oooo00@000000?ooo`3oool000004P3oool01@000000
oooo0?ooo`3oool000000240oooo00@000000?ooo`3oool000006@3oool01@000000oooo0?ooo`3o
ool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01l0oooo00@000000?ooo`3oool000004P3oool010000000oooo0?ooo`00000J0?ooo`04
0000003oool0oooo000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?oo
o`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`0:0?ooo`00:03oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000006@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo0000000A0?ooo`050000003o
ool0oooo0?ooo`0000008@3oool01@000000oooo0?ooo`3oool0000001P0oooo00D000000?ooo`3o
ool0oooo000000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0O0?ooo`050000003oool0oooo0?ooo`0000004@3oool01@000000oooo0?ooo`3o
ool0000001T0oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3o
ool02`3oool002P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool0000001T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool000000240oooo00D000000?oo
o`3oool0oooo0000000H0?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07`3oool01@000000oooo0?oo
o`3oool000000100oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0G0?ooo`050000
003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00l0
oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00/0oooo000X0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo0000000I0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00l0oooo00D000000?ooo`3oool0oooo0000000Q0?ooo`050000003oool0oooo0?ooo`000000603o
ool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo01l0oooo00D000000?ooo`3oool0oooo0000000@0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool05`3oool01@000000oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`050000003oool0oooo
0?ooo`000000203oool00`000000oooo0?ooo`0;0?ooo`00:03oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?oo
o`050000003oool0oooo0?ooo`0000006@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`050000003oool0
oooo0?ooo`0000008@3oool01@000000oooo0?ooo`3oool0000001P0oooo00D000000?ooo`3oool0
oooo000000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0O0?ooo`050000003oool0oooo0?ooo`000000403oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo01L0oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool0000000P0oooo00<0
00000?ooo`3oool02`3oool002P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01h0oooo00D000000?ooo`3oool0oooo0000000H0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool07P3oool01@000000oooo0?ooo`3oool000000100oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0G0?ooo`050000003oool0oooo0?ooo`00
00001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo000X0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0N0?ooo`050000
003oool0oooo0?ooo`000000603oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01h0
oooo00D000000?ooo`3oool0oooo0000000@0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool05`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0;0?ooo`00:03oool3000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0N0?ooo`050000003oool0oooo0?ooo`000000603oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo01h0oooo00D000000?ooo`3oool0oooo0000000@0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool05`3oool01@000000oooo0?ooo`3oool0000000L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`00:03oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool002P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo000X0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo01h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?oo
o`00:03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0303oool002P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00`0oooo000X0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0<0?ooo`00:03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0303oool002P0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo000X0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`00:03oool00`000000oooo
0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool00000
00X0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000002P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003`3oool002P0oooo00<000000?ooo`3oool0
2P3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000:0?oo
o`050000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000000X0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
1P3oool01@000000oooo0?ooo`3oool0000000l0oooo000X0?ooo`<000002P3oool01@000000oooo
0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo
0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
0000000:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool01@000000oooo
0?ooo`3oool0000000l0oooo000X0?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0
oooo0000000:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0
000000X0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
2P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0
oooo0000000?0?ooo`00:03oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00D0
oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`00000;0?ooo`040000003oool0
oooo000000/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo00D0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00H0oooo00@000000?ooo`3oool00000403oool002P0oooo00<000000?ooo`3oool0
2`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000/0oooo00@000000?oo
o`3oool000002`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo00000100
oooo000X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`000000303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01P3oool00`000000oooo
0000000<0?ooo`030000003oool0000000`0oooo00<000000?ooo`000000303oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0000000<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0000000@0?ooo`00:03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0000000`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`000000303oool00`000000oooo0000000<0?ooo`030000003oool0000000`0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`000000303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`000000403oool002P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0000000<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0000000`0oooo00<000000?ooo`000000303oool00`000000oooo0000000<
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool000000100oooo000X0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`000000303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool01P3oool00`000000oooo0000000<0?ooo`030000003oool0000000`0oooo00<000000?oo
o`000000303oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0000000<0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0000000@0?ooo`000P3oool01@3o_g@00000000000000000M;oo
00D0oooo00<0_g@000000000M;l0103oool00`3o_g@000000000000300000004001d_`3oool0oono
07@000D0000000<0M;oo0?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
000000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`000000303oool00`000000oooo0000000<0?ooo`030000003oool0
000000`0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`000000403oool00080oooo00H0W4Qd0;ooo`3oool0oono07@0M02o
ool40?ooo`030;md0000000007Bo00L0oooo00<0W4Q809cOo`3oool00`3oool00`2oM000001d0;oo
o`020?ooo`030=nLM02Lgol0oooo00@0oooo00<000000?ooo`3oool0303oool2000000d0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00H0oooo0P00
000=0?ooo`8000003@3oool2000000d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo00H0oooo0P00000=0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01`3oool200000140oooo00000`3oool0okmd001d_`030?ooo`030=nLB018W=l0
oooo00d0oooo00<0W4Q809cOo`3oool0103oool00`3o_g@0001809cOo`080?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0?0?ooo`0000<0oooo0=nL
B018W=l00`3oool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0oooo00D0oooo00<0omnL04P0
0018W=l01`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool03`3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool03@3oool00`2LB4P0
W=oo0?ooo`070?ooo`0309a80018W=l0oooo00D0oooo1000000;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool03`3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool0
3@3oool00`2LB4P0W=oo0?ooo`080?ooo`0309a8M02oool0oooo00@0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01/0oooo00000`3oool0okmd04RL
g`030?ooo`030=nLB018W=l0oooo00d0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0M;oo0?oo
o`020?ooo`030;md001d_ol0oooo00@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0=03oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01/0oooo00020?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo
2`3oool01@3OW4P000000018W02LB4P0W=oo00@0oooo00L0okmd0000M02oool0oooo0?noM00004P0
W=oo00D0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo01/0oooo00020?ooo`050?oo_`1d000000000000B02Lgol03P3oool00`3OW4P0001809cOo`05
0?ooo`050?noM000000000000000B02Lgol01P3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool06`3oool002P0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo000X0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0K0?ooo`00:03oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool002P0oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo
000X0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0K0?ooo`00:03oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool06`3oool002P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01/0oooo000X0?ooo`<00000703oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo01/0oooo000X0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0K0?ooo`00:03oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0g0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0703oool002P0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01`0oooo000X0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0L0?ooo`00:03oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0703oool002P0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01`0oooo
000X0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0L0?ooo`00:03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0703oool002P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01`0oooo000X0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0L0?ooo`00:03oool3000001d0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0L0?ooo`00:03oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0703oool002P0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo01`0oooo000X0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`00:03oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?oo
o`050000003oool0oooo0?ooo`0000007`3oool002P0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool01@00
0000oooo0?ooo`3oool000000140oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0703oool01@000000oooo0?ooo`3o
ool0000001l0oooo000X0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo0000
000A0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo01`0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`00:03o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00D000000?ooo`3oool0oooo
0000000B0?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool00000
0180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?ooo`050000003oool0oooo
0?ooo`0000007`3oool002P0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?oo
o`040000003oool0oooo00000180oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`040000003o
ool0oooo00000180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?ooo`050000
003oool0oooo0?ooo`0000007`3oool002P0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0D0?ooo`040000003oool0oooo00000180oooo00D000000?ooo`3oool0oooo0000000B0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?oo
o`040000003oool0oooo00000180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0L
0?ooo`050000003oool0oooo0?ooo`0000007`3oool002P0oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000001<0oooo00@000000?ooo`3oool00000
4P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
303oool010000000oooo0?ooo`00000C0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool07P3oool010000000oooo0?ooo`00000O0?ooo`00:03oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo01@0oooo00@000000?ooo`3oool000004`3oool010000000oooo0?ooo`00000B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<
0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0N0?ooo`040000003oool0oooo000001l0oooo000X0?ooo`<000007P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0D0?ooo`040000003oool0oooo000001<0oooo00@000000?ooo`3oool000004P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0k0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool010000000
oooo0?ooo`00000C0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool01000
0000oooo0?ooo`00000O0?ooo`00:03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
01@0oooo00@000000?ooo`3oool000004`3oool010000000oooo0?ooo`00000B0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`040000003o
ool0oooo000001<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0N0?ooo`040000
003oool0oooo000001l0oooo000X0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0000000C0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0?03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`00
00004`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01h0oooo00@000000?ooo`3o
ool000007`3oool002P0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0000001<0oooo00@000000?ooo`3oool000004`3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool03@3oool00`000000oooo0000000C0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool010000000oooo0?ooo`00000O
0?ooo`00:03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`000000503oool00`000000oooo0000000C0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03`0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0000001@0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0O0?ooo`030000003oool0000001l0oooo000X0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool05@3oool00`000000oooo0000000D0?ooo`03
0000003oool0000001<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`000000503oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`0000007`3oool002P0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0000001@0oooo0P00000D0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo03`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0000001@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0O0?ooo`800000
803oool002P0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0E0?ooo`8000005@3o
ool2000001@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00d0oooo0P00000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3o
ool200000200oooo00020?ooo`050?noM000000000000000001d_ol01@3oool00`2oM0000000001d
_`040?ooo`030?noM0000000000000<0000000<007Bo0?ooo`3oool00P3oool01@3ogi`0B0000000
00000000M;oo00D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0E0?ooo`800000
5@3oool2000001@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00d0oooo0P00000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
7`3oool200000200oooo00020?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM000
0000001d_`070?ooo`0309a8B02Lgol0oooo00L0oooo00<0_g@007Boo`3oool01@3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool04`3oool2000001D0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01l0
oooo0P00000P0?ooo`0000<0oooo0?noM000M;l00`3oool00`3OW4P0B9cO0?ooo`0=0?ooo`0309a8
B02Lgol0oooo00L0oooo00<0_g@007Boo`3oool01@3oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo03h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo01h0oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0oooo00d0oooo00<0
W4Q809cOo`3oool00`3oool00`3OW4P00000000000030000000307Boo`3oool0oooo00<0oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0N0?ooo`0000<0oooo0=nLB018W=l00`3oool0
0`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00H0okmd0000M02oool0oooo0;md
001d_ol60?ooo`@000007P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0N0?ooo`0000<0oooo0=nLB018W=l00`3o
ool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0oooo00@0oooo00D0gia8001d_`3oool0_g@0
07Boo`060?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0440oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018
W=l0oooo00d0oooo00<0W4Q809cOo`3oool01@3oool0102LB000B9cO0;md001d_ol60?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0n0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo0440oooo00020?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo2`3oool01@3OW4P0
00000018W02LB4P0W=oo00H0oooo00@0omnL04P0B018B000M;oo1P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`12
0?ooo`000P3oool01@3ookl0M0000000000004P0W=oo00h0oooo00<0gia80000B02Lgol01`3oool0
0`3o_g@0000007Boo`060?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A03oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0480oooo000X0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0480oooo000X0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0480oooo000X0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0480oooo
000X0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0480oooo000X0?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0A@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0480oooo000X0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0o0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0480oooo000X0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0A@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0480oooo000X0?ooo`<00000
803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
@P3oool002P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`150?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0@P3oool002P0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0@P3oool0
02P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0@P3oool002P0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0@P3oool002P0oooo
00<000000?ooo`3oool0803oool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0400oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0@P3oool002P0oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooo`00000B0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`110?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0480oooo000X0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool0
00004P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0@@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`120?ooo`00:03oool00`000000oooo0?ooo`0Q0?ooo`040000
003oool0oooo00000180oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`160?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0440oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0@P3oool002P0oooo00<000000?ooo`3oool0
8@3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0AP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0:@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04<0oooo000X0?ooo`030000
003oool0oooo0240oooo00@000000?ooo`3oool000004P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo04H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`130?ooo`00
:03oool300000240oooo00@000000?ooo`3oool000004P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo04H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`130?ooo`00
:03oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0Z0?ooo`050000003oool0oooo0?ooo`000000A@3oool002P0
oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0:P3oool01@000000oooo0?ooo`3oool0000004D0oooo000X0?oo
o`030000003oool0oooo0240oooo00@000000?ooo`3oool000004P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo02X0oooo00D000000?ooo`3oool0oooo000000150?ooo`00:03oool0
0`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0Z0?ooo`050000003oool0oooo0?ooo`000000A@3oool002P0oooo00<0
00000?ooo`3oool08@3oool010000000oooo0?ooo`00000C0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0:P3oool01@000000oooo0?ooo`3oool0000004D0oooo000X0?ooo`030000
003oool0oooo0240oooo00@000000?ooo`3oool000004`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo04L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo02X0oooo00D000000?ooo`3oool0oooo000000150?ooo`00:03oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0000001<0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0Z0?ooo`050000003oool0oooo0?ooo`000000A@3oool002P0oooo00<000000?ooo`3o
ool08P3oool00`000000oooo0000000C0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0:`3oool010000000oooo0?ooo`0000150?ooo`00:03oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0000001<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0480oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0[0?ooo`04
0000003oool0oooo000004D0oooo000X0?ooo`030000003oool0oooo0280oooo00<000000?ooo`00
00004`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0@P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02/0oooo00@000000?ooo`3o
ool00000A@3oool002P0oooo00<000000?ooo`3oool08P3oool00`000000oooo0000000C0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`120?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0:`3oool010000000oooo0?ooo`0000150?oo
o`00:03oool300000280oooo00<000000?ooo`0000004`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo02/0oooo00@000000?ooo`3oool00000A@3oool002P0oooo00<000000?ooo`3o
ool08P3oool00`000000oooo0000000C0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0:`3oool010000000oooo0?ooo`0000150?ooo`00:03oool00`000000oooo0?ooo`0R0?ooo`80
0000503oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0@`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`00
0000A@3oool002P0oooo00<000000?ooo`3oool08P3oool2000001@0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0000004D0oooo000X0?ooo`030000003o
ool0oooo0280oooo0P00000D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0;@3o
ool2000004H0oooo000X0?ooo`030000003oool0oooo0280oooo0P00000D0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`130?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0;@3oool2000004H0oooo000X0?ooo`030000003oool0oooo
0280oooo0P00000E0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0;@3oool20000
04H0oooo000X0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo02d0oooo0P0000160?ooo`000P3oool01@3o_g@00000
000000000000M;oo00D0oooo00<0_g@000000000M;l0103oool00`3o_g@000000000000300000003
001d_`3oool0oooo0080oooo00D0_g@0000000000000001d0;ooo`050?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
02d0oooo0P0000160?ooo`000P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`@0oooo00<0_g@0
00000000M;l01`3oool00`2LB4P0W=oo0?ooo`040?ooo`060=nLB000M;l0oooo0?ooo`3o_g@007Bo
1@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04@0oooo00000`3oool0okmd001d
_`030?ooo`030=nLB018W=l0oooo00d0oooo00<0W4Q809cOo`3oool00`3oool00`3ookl0M00007Bo
o`020?ooo`030?oo_`1dB9`0oooo00@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`140?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0
oooo00<0oooo00L0okmd0018B01d07@0_ooo0?ooo`3OW4P007Bo00D0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`140?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?oo
o`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00<0omnL04Q8W03o_g@00P0000000`00B9`0oooo0?oo
o`040?ooo`@000008P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo2000
00160?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`140?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0
oooo00<0oooo00<0oono07@0M02oool02@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo05l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1e0?ooo`0000<0oooo0?no
M018W=l00`3oool00`3OW4P0B9cO0?ooo`0=0?ooo`0309a8B02Lgol0oooo00@0oooo00<0_g@004RL
g`3oool0203oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo05l0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`1e0?ooo`000P3oool01P2LB000M;oo0?ooo`3ogi`0B01d
0;ooo`/0oooo00D0gia800000000B9`0W4Q809cOo`050?ooo`030?oo_`1d000007Bo00P0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04T0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0M@3oool00080oooo00D0oono07@000000000001809cOo`0>0?ooo`030=nLB000
04P0W=oo00L0oooo00@0_g@000000000000004RL1@3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo05l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1e0?ooo`00:03o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`1e0?ooo`00:03oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0600oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1e0?ooo`00:03oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`1e0?ooo`00:03oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0600
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1e0?ooo`00:03oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0B`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`1e0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0B`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0600oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`1e0?ooo`00:03oool00`000000oooo0?ooo`0k
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1e
0?ooo`00:03oool3000003/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo07D0oooo000X0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0H03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo07D0oooo000X0?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1;0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo07D0oooo000X0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H03o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo07D0oooo000X0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo07D0oooo000X0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`1;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H03oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo07D0oooo000X0?ooo`030000003oool0oooo03`0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo07D0
oooo000X0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo07D0oooo000X0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0H@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo07D0oooo000X
0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1<
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo07H0oooo000X0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0HP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07H0oooo000X0?ooo`<0
0000?@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0MP3oool002P0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo04`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1R0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<000000?ooo`3oool0?@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0MP3o
ool002P0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo04`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1R0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<000000?ooo`3oool0?P3oool01@00
0000oooo0?ooo`3oool0000004h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1R
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<000000?oo
o`3oool0?P3oool01@000000oooo0?ooo`3oool0000004h0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0MP3oool0
02P0oooo00<000000?ooo`3oool0?P3oool01@000000oooo0?ooo`3oool0000004h0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0MP3oool002P0oooo00<000000?ooo`3oool0?P3oool01@000000oooo0?ooo`3oool0
000004l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<000000?ooo`3oool0?P3oool01@00
0000oooo0?ooo`3oool0000004l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<000000?oo
o`3oool0?P3oool01@000000oooo0?ooo`3oool0000004l0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0MP3oool0
02P0oooo00<000000?ooo`3oool0?`3oool010000000oooo0?ooo`00001?0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo07H0oooo000X0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`000000D03oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`1f0?ooo`00:03oool3000003l0oooo00<000000?ooo`000000D03oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1f0?ooo`00:03oool00`000000oooo0?ooo`0o0?ooo`030000003oool000000500oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0MP3oool002P0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0000
001@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo07H0oooo000X0?ooo`030000003oool0oooo03l0oooo00<00000
0?ooo`000000D03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`1f0?ooo`00:03oool00`000000oooo0?ooo`100?oo
o`800000D03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`1f0?ooo`00:03oool00`000000oooo0?ooo`100?ooo`80
0000D03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`1f0?ooo`00:03oool00`000000oooo0?ooo`100?ooo`800000
D03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`1f0?ooo`00:03oool00`000000oooo0?ooo`100?ooo`800000D@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1f0?ooo`000P3oool01@3o_g@00000000000000000M;oo00D0oooo00<0
_g@000000000M;l0103oool00`3o_g@000000000000300000005001d_`3oool0oooo0?ooo`2oM000
0`0000000`00M;l0oooo0?ooo`040?ooo`030000003oool0oooo0400oooo0P00001A0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo07H0oooo00020?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM000
0000001d_`070?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd001d_`3oool00P3oool00`2oM4P0
W=oo0?ooo`040?ooo`030000003oool0oooo0400oooo0P00001A0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07H0
oooo00000`3oool0okmd001d_`030?ooo`030=nLB018W=l0oooo00d0oooo00<0W4Q809cOo`3oool0
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030;md001d_ol0oooo00@0oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07H0oooo00000`3oool0gia804RL
g`030?ooo`030?noM000M;l0oooo00d0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@004RL0?oo
o`020?ooo`0309a8B02Lgol0oooo00@0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`1?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo07H0oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0
oooo00d0oooo00<0W4Q809cOo`3oool0103oool01@3OW4P00000000000000000B9cO00H0oooo1000
00100?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`1T0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0MP3oool000030?ooo`3OW4P0
B9cO00<0oooo00<0okmd001d_`3oool03@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?oo_`1dB9`0
oooo0080oooo00<0W4Qd0;ooo`3oool0103oool00`000000oooo0?ooo`2C0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo07H0oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018W=l0oooo00d0oooo00<0W4Q809cO
o`3oool00`3oool00`3o_g@0B9cO0?ooo`020?ooo`030;md001d_ol0oooo00@0oooo00<000000?oo
o`3oool0T`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06@0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`1f0?ooo`000P3oool01P2LB000M;oo0?ooo`3ogi`0B01d
0;ooo`/0oooo00D0gia800000000B9`0W4Q809cOo`040?ooo`070?oOW01807@0_ooo0?ooo`3ogi`0
B01d0;ooo`050?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`1U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0M`3oool00080oooo
00D0oono07@000000000001809cOo`0>0?ooo`030=nLB00004P0W=oo00D0oooo00D0okmd00000000
0000001809cOo`060?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`1V0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0M`3oool002P0
oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06H0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1g0?ooo`00:03oool00`000000oooo
0?ooo`2D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0IP3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo07L0oooo000X0?ooo`030000003oool0oooo09@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0M`3oool002P0oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1g
0?ooo`00:03oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0IP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo07L0oooo000X0?ooo`03
0000003oool0oooo09@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1V0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0M`3oool002P0oooo00<000000?ooo`3oool0
U@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`1g0?ooo`00:03oool3000009D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0M`3o
ool002P0oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo06L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1g0?ooo`00:03oool00`00
0000oooo0?ooo`2E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0I`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo07L0oooo000X0?ooo`030000003oool0oooo09D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0M`3oool002P0oooo00<000000?ooo`3oool0U@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1g0?ooo`00:03oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0J03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07L0oooo000X
0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1X
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0M`3oool002P0oooo00<000000?oo
o`3oool0UP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo06P0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1g0?ooo`00:03oool00`000000oooo0?ooo`2F0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo07L0oooo000X0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
M`3oool002P0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo06P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1g0?ooo`00:03oool3
000009H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0M`3oool002P0oooo00<000000?ooo`3oool0U`3oool01@00
0000oooo0?ooo`3oool0000006/0oooo00D000000?ooo`3oool0oooo0000001i0?ooo`00:03oool0
0`000000oooo0?ooo`2G0?ooo`050000003oool0oooo0?ooo`000000J`3oool01@000000oooo0?oo
o`3oool0000007T0oooo000X0?ooo`030000003oool0oooo09L0oooo00D000000?ooo`3oool0oooo
0000001[0?ooo`050000003oool0oooo0?ooo`000000N@3oool002P0oooo00<000000?ooo`3oool0
U`3oool01@000000oooo0?ooo`3oool0000006/0oooo00D000000?ooo`3oool0oooo0000001i0?oo
o`00:03oool00`000000oooo0?ooo`2G0?ooo`050000003oool0oooo0?ooo`000000J`3oool01@00
0000oooo0?ooo`3oool0000007T0oooo000X0?ooo`030000003oool0oooo09L0oooo00D000000?oo
o`3oool0oooo0000001[0?ooo`050000003oool0oooo0?ooo`000000N@3oool002P0oooo00<00000
0?ooo`3oool0U`3oool01@000000oooo0?ooo`3oool0000006/0oooo00D000000?ooo`3oool0oooo
0000001i0?ooo`00:03oool00`000000oooo0?ooo`2H0?ooo`040000003oool0oooo000006`0oooo
00@000000?ooo`3oool00000N@3oool002P0oooo00<000000?ooo`3oool0V03oool010000000oooo
0?ooo`00001/0?ooo`040000003oool0oooo000007T0oooo000X0?ooo`030000003oool0oooo09P0
oooo00<000000?ooo`000000K@3oool00`000000oooo0000001j0?ooo`00:03oool00`000000oooo
0?ooo`2H0?ooo`030000003oool0000006d0oooo00<000000?ooo`000000NP3oool002P0oooo0`00
002H0?ooo`030000003oool0000006d0oooo00<000000?ooo`000000NP3oool002P0oooo00<00000
0?ooo`3oool0V03oool00`000000oooo0000001]0?ooo`030000003oool0000007X0oooo000X0?oo
o`030000003oool0oooo09T0oooo0P00001^0?ooo`800000NP3oool002P0oooo00<000000?ooo`3o
ool0V@3oool2000006h0oooo0P00001j0?ooo`00:03oool00`000000oooo0?ooo`2I0?ooo`800000
KP3oool2000007X0oooo000X0?ooo`030000003oool0oooo09T0oooo0P00001^0?ooo`800000NP3o
ool002P0oooo00<000000?ooo`3oool0V@3oool2000006h0oooo0P00001j0?ooo`00:03oool00`00
0000oooo0?ooo`2I0?ooo`800000KP3oool2000007X0oooo000X0?ooo`030000003oool0oooo09T0
oooo0P00001^0?ooo`800000NP3oool000/0oooo00D0okmd000000000000000007Boo`050?ooo`03
0;md0000000007Bo00<0oooo00<0oono07@000000000100000000`1d_ol0oooo0?ooo`030?ooo`03
0000003oool0oooo09X0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1h0?ooo`00
2`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`@0oooo00<0_g@000000000M;l0103oool00`2o
M000001d0;ooo`020?ooo`030=nLM02Lgol0oooo00@0oooo00<000000?ooo`3oool0VP3oool00`00
0000oooo0?ooo`1]0?ooo`030000003oool0oooo07P0oooo000:0?ooo`030?noM000M;l0oooo0080
oooo00<0gia804RLg`3oool02`3oool00`3o_g@0001809cOo`080?ooo`030000003oool0oooo09X0
oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1h0?ooo`002P3oool00`3OW4P0B9cO
0?ooo`020?ooo`030?noM000M;l0oooo00`0oooo00<0omnL04P00018W=l01`3oool4000009T0oooo
00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1h0?ooo`002P3oool00`3OW4P0B9cO0?oo
o`020?ooo`030?noM000M;l0oooo00h0oooo00<0W4P004RLg`3oool01@3oool00`000000oooo0?oo
o`3o0?ooohH0oooo000:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool03`3oool0
0`2LB7@0_ooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooQP3oool000X0oooo00<0okmd04RL
g`3oool00P3oool00`3OW4P0B9cO0?ooo`0:0?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@007Bo
o`3oool0103oool00`000000oooo0?ooo`3o0?ooohH0oooo000;0?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo2`3oool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol01@3oool00`000000oooo
0?ooo`3o0?ooohH0oooo000;0?ooo`050?oo_`1d000000000000B02Lgol03@3oool01@3o_g@00000
0000000004P0W=oo00H0oooo00<000000?ooo`3oool0o`3ooon60?ooo`00:03oool00`000000oooo
0?ooo`3o0?ooohH0oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287.313}, {177.25, 0}} -> {-5, 0, 0, 0}},
  CellTags->"b:4.1.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "It is also possible to select data from multiple columns in multiple \
tables. You can select multiple tables by giving a second argument that is a \
list of the table names. A list of column names should be used as the third \
parameter as shown previously. You can also associate a specific table with a \
column by pairing a column name with a table name in a list in the third \
argument. This is important if the same column name is used in more than one \
table. The following example of a data join generates an outer product of the \
data in the two tables and it uses the option ",
  StyleBox["MaxRows", "MR"],
  " to show only the first five results."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[
        conn, \ {"\<TITLES\>", "\<ROYSCHED\>"}, \ {{"\<TITLES\>", \ \
"\<TITLE\>"}, \ {"\<TITLES\>", \ "\<TITLE_ID\>"}, \ {"\<ROYSCHED\>", \ \
"\<TITLE_ID\>"}, {"\<ROYSCHED\>", \ "\<ROYALTY\>"}}, MaxRows \[Rule] 5, 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TITLE\"\>", "\<\"TITLE_ID\"\>", "\<\"TITLE_ID\"\>", \
"\<\"ROYALTY\"\>"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1011\"\>", "0.1`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1011\"\>", "0.12`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.1`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.12`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.16`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//TableForm=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "The following example repeats the previous query, adding a condition that \
the ",
  StyleBox["TITLE_ID", "TI"],
  " in the two tables must be equal. Using a condition is often a useful way \
to narrow the search results."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[
        conn, \ {"\<TITLES\>", "\<ROYSCHED\>"}, \ {{"\<TITLES\>", \ \
"\<TITLE\>"}, \ {"\<TITLES\>", \ "\<TITLE_ID\>"}, \ {"\<ROYSCHED\>", \ \
"\<TITLE_ID\>"}, {"\<ROYSCHED\>", \ "\<ROYALTY\>"}}, \ 
        SQLColumn[{"\<TITLES\>", \ "\<TITLE_ID\>"}]\  \[Equal] \ 
          SQLColumn[{"\<ROYSCHED\>", \ "\<TITLE_ID\>"}], MaxRows \[Rule] 5, 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TITLE\"\>", "\<\"TITLE_ID\"\>", "\<\"TITLE_ID\"\>", \
"\<\"ROYALTY\"\>"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.1`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.12`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.16`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.18`"},
          {"\<\"Self Hypnosis: A Beginner's Guide\"\>", "\<\"PY2002\"\>", "\<\
\"PY2002\"\>", "0.1`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[7]//TableForm=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be between certain values.\
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[
      conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, \  .10 < \ 
        SQLColumn["\<ROYALTY\>"]\  < \  .15]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"BS1011", 0.12`}, {"CP5018", 0.1`}, {"CP5018", 
        0.12`}, {"BS1001", 0.1`}, {"BS1001", 0.12`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2002", 0.12`}, {"PY2002", 
        0.14`}, {"PY2003", 0.1`}, {"PY2003", 0.12`}, {"PY2003", 
        0.14`}, {"UK3004", 0.1`}, {"UK3004", 0.12`}, {"UK3004", 
        0.14`}, {"CK4005", 0.1`}, {"CK4005", 0.12`}, {"CP5010", 
        0.1`}, {"CP5010", 0.12`}, {"PY2012", 0.1`}, {"PY2012", 
        0.12`}, {"PY2013", 0.1`}, {"PY2013", 0.12`}, {"UK3006", 
        0.1`}, {"UK3006", 0.12`}, {"UK3006", 0.14`}, {"BS1014", 
        0.1`}, {"BS1014", 0.12`}, {"BS1014", 0.14`}, {"UK3015", 
        0.1`}, {"UK3015", 0.12`}, {"UK3015", 0.14`}, {"CK4016", 
        0.1`}, {"CK4016", 0.12`}, {"CK4017", 0.1`}, {"CK4017", 
        0.12`}, {"CK4017", 0.14`}, {"BS1007", 0.1`}, {"BS1007", 
        0.12`}, {"PY2008", 0.1`}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[
      conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, \  .13\  > \
\ SQLColumn["\<ROYALTY\>"]\  > \  .10]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"BS1011", 0.12`}, {"CP5018", 0.1`}, {"CP5018", 
        0.12`}, {"BS1001", 0.1`}, {"BS1001", 0.12`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2002", 0.12`}, {"PY2003", 
        0.1`}, {"PY2003", 0.12`}, {"UK3004", 0.1`}, {"UK3004", 
        0.12`}, {"CK4005", 0.1`}, {"CK4005", 0.12`}, {"CP5010", 
        0.1`}, {"CP5010", 0.12`}, {"PY2012", 0.1`}, {"PY2012", 
        0.12`}, {"PY2013", 0.1`}, {"PY2013", 0.12`}, {"UK3006", 
        0.1`}, {"UK3006", 0.12`}, {"BS1014", 0.1`}, {"BS1014", 
        0.12`}, {"UK3015", 0.1`}, {"UK3015", 0.12`}, {"CK4016", 
        0.1`}, {"CK4016", 0.12`}, {"CK4017", 0.1`}, {"CK4017", 
        0.12`}, {"BS1007", 0.1`}, {"BS1007", 0.12`}, {"PY2008", 
        0.1`}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be equal to a certain value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  == \  .12]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.12`}, {"CP5018", 0.12`}, {"BS1001", 0.12`}, {"PY2002", 
        0.12`}, {"PY2003", 0.12`}, {"UK3004", 0.12`}, {"CK4005", 
        0.12`}, {"CP5010", 0.12`}, {"PY2012", 0.12`}, {"PY2013", 
        0.12`}, {"UK3006", 0.12`}, {"BS1014", 0.12`}, {"UK3015", 
        0.12`}, {"CK4016", 0.12`}, {"CK4017", 0.12`}, {"BS1007", 
        0.12`}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must not be equal to a certain value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  != \  .12]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"CP5018", 0.1`}, {"CP5018", 0.16`}, {"BS1001", 
        0.1`}, {"BS1001", 0.16`}, {"BS1001", 0.18`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2002", 0.14`}, {"PY2003", 
        0.1`}, {"PY2003", 0.14`}, {"UK3004", 0.1`}, {"UK3004", 
        0.14`}, {"UK3004", 0.18`}, {"UK3004", 0.2`}, {"CK4005", 
        0.1`}, {"CK4005", 0.16`}, {"CK4005", 0.16`}, {"CP5010", 
        0.1`}, {"PY2012", 0.1`}, {"PY2013", 0.1`}, {"UK3006", 
        0.1`}, {"UK3006", 0.14`}, {"UK3006", 0.18`}, {"UK3006", 
        0.2`}, {"BS1014", 0.1`}, {"BS1014", 0.14`}, {"UK3015", 
        0.1`}, {"UK3015", 0.14`}, {"UK3015", 0.16`}, {"CK4016", 
        0.1`}, {"CK4017", 0.1`}, {"CK4017", 0.14`}, {"BS1007", 
        0.1`}, {"PY2008", 0.1`}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be greater than a certain value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  > \  .12]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"CP5018", 0.16`}, {"BS1001", 0.16`}, {"BS1001", 0.18`}, {"PY2002", 
        0.14`}, {"PY2003", 0.14`}, {"UK3004", 0.14`}, {"UK3004", 
        0.18`}, {"UK3004", 0.2`}, {"CK4005", 0.16`}, {"CK4005", 
        0.16`}, {"UK3006", 0.14`}, {"UK3006", 0.18`}, {"UK3006", 
        0.2`}, {"BS1014", 0.14`}, {"UK3015", 0.14`}, {"UK3015", 
        0.16`}, {"CK4017", 0.14`}}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be less than a certain value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  < \  .12]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"CP5018", 0.1`}, {"BS1001", 0.1`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2003", 0.1`}, {"UK3004", 
        0.1`}, {"CK4005", 0.1`}, {"CP5010", 0.1`}, {"PY2012", 
        0.1`}, {"PY2013", 0.1`}, {"UK3006", 0.1`}, {"BS1014", 
        0.1`}, {"UK3015", 0.1`}, {"CK4016", 0.1`}, {"CK4017", 
        0.1`}, {"BS1007", 0.1`}, {"PY2008", 0.1`}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be greater than or equal to a \
certain value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  >= \  .12]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.12`}, {"CP5018", 0.12`}, {"CP5018", 0.16`}, {"BS1001", 
        0.12`}, {"BS1001", 0.16`}, {"BS1001", 0.18`}, {"PY2002", 
        0.12`}, {"PY2002", 0.14`}, {"PY2003", 0.12`}, {"PY2003", 
        0.14`}, {"UK3004", 0.12`}, {"UK3004", 0.14`}, {"UK3004", 
        0.18`}, {"UK3004", 0.2`}, {"CK4005", 0.12`}, {"CK4005", 
        0.16`}, {"CK4005", 0.16`}, {"CP5010", 0.12`}, {"PY2012", 
        0.12`}, {"PY2013", 0.12`}, {"UK3006", 0.12`}, {"UK3006", 
        0.14`}, {"UK3006", 0.18`}, {"UK3006", 0.2`}, {"BS1014", 
        0.12`}, {"BS1014", 0.14`}, {"UK3015", 0.12`}, {"UK3015", 
        0.14`}, {"UK3015", 0.16`}, {"CK4016", 0.12`}, {"CK4017", 
        0.12`}, {"CK4017", 0.14`}, {"BS1007", 0.12`}}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "You may specify that a column value must match a certain pattern using the \
meta-characters '%' for matching zero or more characters and '",
  StyleBox["_'", "MR"],
  " for matching a single character."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLStringMatchQ[SQLColumn["\<TITLE_ID\>"], \ "\<C%\>"]]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"CP5018", 0.1`}, {"CP5018", 0.12`}, {"CP5018", 0.16`}, {"CK4005", 
        0.1`}, {"CK4005", 0.12`}, {"CK4005", 0.16`}, {"CK4005", 
        0.16`}, {"CP5010", 0.1`}, {"CP5010", 0.12`}, {"CK4016", 
        0.1`}, {"CK4016", 0.12`}, {"CK4017", 0.1`}, {"CK4017", 
        0.12`}, {"CK4017", 0.14`}}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLStringMatchQ[SQLColumn["\<TITLE_ID\>"], \ "\<_S%\>"]]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"BS1011", 0.12`}, {"BS1001", 0.1`}, {"BS1001", 
        0.12`}, {"BS1001", 0.16`}, {"BS1001", 0.18`}, {"PS9999", 
        0.1`}, {"BS1014", 0.1`}, {"BS1014", 0.12`}, {"BS1014", 
        0.14`}, {"BS1007", 0.1`}, {"BS1007", 0.12`}}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be contained as a member of a \
list.\
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLMemberQ[{ .14, \  .16}, \ SQLColumn["\<ROYALTY\>"]]]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"CP5018", 0.16`}, {"BS1001", 0.16`}, {"PY2002", 0.14`}, {"PY2003", 
        0.14`}, {"UK3004", 0.14`}, {"CK4005", 0.16`}, {"CK4005", 
        0.16`}, {"UK3006", 0.14`}, {"BS1014", 0.14`}, {"UK3015", 
        0.14`}, {"UK3015", 0.16`}, {"CK4017", 0.14`}}\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["\<\
You may specify that a column value must be less than or equal to a certain \
value. \
\>", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  <= \  .12]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.1`}, {"BS1011", 0.12`}, {"CP5018", 0.1`}, {"CP5018", 
        0.12`}, {"BS1001", 0.1`}, {"BS1001", 0.12`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2002", 0.12`}, {"PY2003", 
        0.1`}, {"PY2003", 0.12`}, {"UK3004", 0.1`}, {"UK3004", 
        0.12`}, {"CK4005", 0.1`}, {"CK4005", 0.12`}, {"CP5010", 
        0.1`}, {"CP5010", 0.12`}, {"PY2012", 0.1`}, {"PY2012", 
        0.12`}, {"PY2013", 0.1`}, {"PY2013", 0.12`}, {"UK3006", 
        0.1`}, {"UK3006", 0.12`}, {"BS1014", 0.1`}, {"BS1014", 
        0.12`}, {"UK3015", 0.1`}, {"UK3015", 0.12`}, {"CK4016", 
        0.1`}, {"CK4016", 0.12`}, {"CK4017", 0.1`}, {"CK4017", 
        0.12`}, {"BS1007", 0.1`}, {"BS1007", 0.12`}, {"PY2008", 
        0.1`}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "You may also combine any conditions using ",
  StyleBox["And", "MR"],
  " or ",
  StyleBox["Or", "MR"],
  "."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[
      conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<LORANGE\>", \
"\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  == \  .12\  && \ 
        SQLColumn["\<LORANGE\>"]\  > \ 1000]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 5001, 0.12`}, {"CP5018", 2001, 0.12`}, {"BS1001", 1001, 
        0.12`}, {"PY2002", 1001, 0.12`}, {"PY2003", 2001, 0.12`}, {"UK3004", 
        1001, 0.12`}, {"CK4005", 2001, 0.12`}, {"CP5010", 5001, 
        0.12`}, {"PY2012", 5001, 0.12`}, {"PY2013", 5001, 0.12`}, {"UK3006", 
        1001, 0.12`}, {"BS1014", 4001, 0.12`}, {"UK3015", 2001, 
        0.12`}, {"CK4016", 5001, 0.12`}, {"CK4017", 2001, 0.12`}, {"BS1007", 
        5001, 0.12`}}\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
      SQLColumn["\<ROYALTY\>"]\  == \  .12\  || \ 
        SQLColumn["\<ROYALTY\>"]\  == \  .14]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1011", 0.12`}, {"CP5018", 0.12`}, {"BS1001", 0.12`}, {"PY2002", 
        0.12`}, {"PY2002", 0.14`}, {"PY2003", 0.12`}, {"PY2003", 
        0.14`}, {"UK3004", 0.12`}, {"UK3004", 0.14`}, {"CK4005", 
        0.12`}, {"CP5010", 0.12`}, {"PY2012", 0.12`}, {"PY2013", 
        0.12`}, {"UK3006", 0.12`}, {"UK3006", 0.14`}, {"BS1014", 
        0.12`}, {"BS1014", 0.14`}, {"UK3015", 0.12`}, {"UK3015", 
        0.14`}, {"CK4016", 0.12`}, {"CK4017", 0.12`}, {"CK4017", 
        0.14`}, {"BS1007", 0.12`}}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[TextData[{
  "You may also use the option ",
  StyleBox["SortingColumns", "MR"],
  " to specify how to sort the data.  This option takes a list of rules.  The \
left side of the rule specifies the column and the right side specifies \
whether to sort that data ascending or descending.  The first item in the \
list takes precedence over the supplemental items."
}], "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(data\  = 
      SQLSelect[conn, \ "\<ROYSCHED\>", \ {"\<TITLE_ID\>", \ "\<ROYALTY\>"}, 
        SortingColumns \[Rule] {SQLColumn["\<ROYALTY\>"] -> "\<Ascending\>", \
\ SQLColumn["\<TITLE_ID\>"] -> "\<Ascending\>"}]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \({{"BS1001", 0.1`}, {"BS1007", 0.1`}, {"BS1011", 0.1`}, {"BS1014", 
        0.1`}, {"CK4005", 0.1`}, {"CK4016", 0.1`}, {"CK4017", 
        0.1`}, {"CP5010", 0.1`}, {"CP5018", 0.1`}, {"PS9999", 
        0.1`}, {"PY2002", 0.1`}, {"PY2003", 0.1`}, {"PY2008", 
        0.1`}, {"PY2012", 0.1`}, {"PY2013", 0.1`}, {"UK3004", 
        0.1`}, {"UK3006", 0.1`}, {"UK3015", 0.1`}, {"BS1001", 
        0.12`}, {"BS1007", 0.12`}, {"BS1011", 0.12`}, {"BS1014", 
        0.12`}, {"CK4005", 0.12`}, {"CK4016", 0.12`}, {"CK4017", 
        0.12`}, {"CP5010", 0.12`}, {"CP5018", 0.12`}, {"PY2002", 
        0.12`}, {"PY2003", 0.12`}, {"PY2012", 0.12`}, {"PY2013", 
        0.12`}, {"UK3004", 0.12`}, {"UK3006", 0.12`}, {"UK3015", 
        0.12`}, {"BS1014", 0.14`}, {"CK4017", 0.14`}, {"PY2002", 
        0.14`}, {"PY2003", 0.14`}, {"UK3004", 0.14`}, {"UK3006", 
        0.14`}, {"UK3015", 0.14`}, {"BS1001", 0.16`}, {"CK4005", 
        0.16`}, {"CK4005", 0.16`}, {"CP5018", 0.16`}, {"UK3015", 
        0.16`}, {"BS1001", 0.18`}, {"UK3004", 0.18`}, {"UK3006", 
        0.18`}, {"UK3004", 0.2`}, {"UK3006", 0.2`}}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["The following plot shows that the data is now sorted.", "Text",
  CellTags->"b:4.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Last\  /@ \ data, \ PlotJoined \[Rule] True]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"b:4.1.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0186741 -0.573889 5.88604 [
[.21055 .00222 -6 -9 ]
[.21055 .00222 6 0 ]
[.39729 .00222 -6 -9 ]
[.39729 .00222 6 0 ]
[.58403 .00222 -6 -9 ]
[.58403 .00222 6 0 ]
[.77077 .00222 -6 -9 ]
[.77077 .00222 6 0 ]
[.95752 .00222 -6 -9 ]
[.95752 .00222 6 0 ]
[.01131 .13244 -24 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -24 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -24 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -24 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .01472 m
.21055 .02097 L
s
[(10)] .21055 .00222 0 1 Mshowa
.39729 .01472 m
.39729 .02097 L
s
[(20)] .39729 .00222 0 1 Mshowa
.58403 .01472 m
.58403 .02097 L
s
[(30)] .58403 .00222 0 1 Mshowa
.77077 .01472 m
.77077 .02097 L
s
[(40)] .77077 .00222 0 1 Mshowa
.95752 .01472 m
.95752 .02097 L
s
[(50)] .95752 .00222 0 1 Mshowa
.125 Mabswid
.06116 .01472 m
.06116 .01847 L
s
.09851 .01472 m
.09851 .01847 L
s
.13585 .01472 m
.13585 .01847 L
s
.1732 .01472 m
.1732 .01847 L
s
.2479 .01472 m
.2479 .01847 L
s
.28525 .01472 m
.28525 .01847 L
s
.3226 .01472 m
.3226 .01847 L
s
.35994 .01472 m
.35994 .01847 L
s
.43464 .01472 m
.43464 .01847 L
s
.47199 .01472 m
.47199 .01847 L
s
.50934 .01472 m
.50934 .01847 L
s
.54669 .01472 m
.54669 .01847 L
s
.62138 .01472 m
.62138 .01847 L
s
.65873 .01472 m
.65873 .01847 L
s
.69608 .01472 m
.69608 .01847 L
s
.73343 .01472 m
.73343 .01847 L
s
.80812 .01472 m
.80812 .01847 L
s
.84547 .01472 m
.84547 .01847 L
s
.88282 .01472 m
.88282 .01847 L
s
.92017 .01472 m
.92017 .01847 L
s
.99486 .01472 m
.99486 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.12)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.14)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.16)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.18)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.2)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04248 .01472 m
.06116 .01472 L
.07983 .01472 L
.09851 .01472 L
.11718 .01472 L
.13585 .01472 L
.15453 .01472 L
.1732 .01472 L
.19188 .01472 L
.21055 .01472 L
.22923 .01472 L
.2479 .01472 L
.26657 .01472 L
.28525 .01472 L
.30392 .01472 L
.3226 .01472 L
.34127 .01472 L
.35994 .01472 L
.37862 .13244 L
.39729 .13244 L
.41597 .13244 L
.43464 .13244 L
.45331 .13244 L
.47199 .13244 L
.49066 .13244 L
.50934 .13244 L
.52801 .13244 L
.54669 .13244 L
.56536 .13244 L
.58403 .13244 L
.60271 .13244 L
.62138 .13244 L
.64006 .13244 L
.65873 .13244 L
.6774 .25016 L
.69608 .25016 L
.71475 .25016 L
.73343 .25016 L
.7521 .25016 L
.77077 .25016 L
.78945 .25016 L
.80812 .36788 L
.8268 .36788 L
.84547 .36788 L
.86415 .36788 L
.88282 .36788 L
.90149 .4856 L
.92017 .4856 L
.93884 .4856 L
.95752 .60332 L
Mistroke
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00J`3oool00`3o_g@000000000
000300000005001d_`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0oooo0?ooo`0i0?ooo`030?oo
_`1d0000000000@0000000D0M;oo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo03X0
oooo00D0_g@0000000000000000004RLg`040?ooo`050?noM000000000000000001d_ol0?P3oool0
1@3ogi`0B000000000000000M;oo00<0oooo00D0okmd000000000000000007Boo`0m0?ooo`050;md
0000000000000000001d_ol0103oool01@3o_g@00000000000000000M;oo00/0oooo001^0?ooo`03
09a8B02Lgol0oooo00@0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolk0?ooo`030;md000007@0
_ooo0080oooo00<0giad09cOo`3oool00P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooocX0oooo
00L0_g@0001d_`3oool0oooo0?oo_`1d0000B9cO00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02o
oolo0?ooo`030;md001d_ol0oooo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolk0?ooo`07
0;md0000M;l0oooo0?ooo`3ogi`0B00007Boo`030?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo
2P3oool006h0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018
W=l0oooo03/0oooo00<0okmd0000B02Lgol01@3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018
W=l0oooo03h0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo03h0
oooo00<0_g@007Boo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo03l0
oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo00T0oooo001^0?oo
o`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0l0?oo
o`030?oOW0180000B9cO00@0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0m0?oo
o`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0j0?oo
o`030=nLB0000000000000<0000000D0M;oo0?ooo`3oool0gia804RLg`030?ooo`030?noM000M;l0
oooo03l0oooo00H0okmd001d_`3oool0oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo00T0oooo
001^0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?oo
o`0n0?ooo`0309a80018W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?oo
o`0k0?ooo`040=nLB0000000001809cOo`<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo
0?ooo`0j0?ooo`060?noM00007@0_ooo0?ooo`2oM000M;oo0`3oool00`3OW4P0B9cO0?ooo`020?oo
o`030?noM000M;l0oooo03l0oooo00H0W4P007Boo`3oool0oooo0=nLB018W=l30?ooo`030?noM000
M;l0oooo00T0oooo001^0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool0
0`3o_g@007Bo0?ooo`0o0?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo
0?ooo`0m0?ooo`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo
0?ooo`0k0?ooo`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0B9cO0?ooo`020?ooo`03
0?noM000M;l0oooo03X0oooo00<0oono07@0000000000P0000001P18W=l0oooo0?ooo`3oool0gia8
04RLg`<0oooo00<0okmd001d_`3oool02@3oool006h0oooo00<0W4Q809cOo`3oool00`3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo00<0gia807Boo`3oool00P3oool01P2o
M000M;oo0?ooo`3oool0okmd04RLg`<0oooo00<0gia804RLg`3oool0?P3oool01P2oM000M;oo0?oo
o`3oool0okmd04RLg`<0oooo00<0gia804RLg`3oool0?03oool0102LB000B9cO0;md001d_ol30?oo
o`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool0>P3oool00`3ookl0M01d0;ooo`060?oo
o`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool02@3oool006/0oooo00D0gia800000000
B9`0W4Q809cOo`050?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo>`3oool01`3o_g@0001d0;oo
o`3oool0okmd0000B02Lgol00`3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooocX0oooo00L0okmd
0000B02Lgol0oooo0?oOW01804P0W=oo00<0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolm0?oo
o`040?oOW01804P0B4P007Boo`@0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolk0?ooo`030?oo
_`1d07@0_ooo00L0oooo00H0W4P007Boo`3oool0omnL04P0M02oool:0?ooo`00K@3oool00`3OW4P0
001809cOo`050?ooo`050?oo_`1d000000000000B02Lgol0?@3oool01@3o_g@000000000000004P0
W=oo00@0oooo00D0oono07@000000000001809cOo`0l0?ooo`050?oOW018000000000000001d_ol0
103oool01@3ookl0M0000000000004P0W=oo03l0oooo00<0okmd0000001d_ol0103oool01@3ookl0
M0000000000004P0W=oo03`0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`020?oo
o`050?oo_`1d000000000000B02Lgol02`3oool00?l0oooo/@3oool00?l0oooo/@3oool002P0oooo
00<000000?ooo`3oool0o`3ooon60?ooo`00:03oool00`000000oooo0?ooo`3o0?ooohH0oooo000X
0?ooo`030000003oool0oooo0?l0ooooQP3oool002P0oooo00<000000?ooo`3oool0o`3ooon60?oo
o`00:03oool00`000000oooo0?ooo`3o0?ooohH0oooo000X0?ooo`030000003oool0oooo0?l0oooo
QP3oool001l0ooooo`00002A00000040oooo000X0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`010?ooo`00:03oool00`000000oooo0?ooo`180?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`170?oo
o`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0?0?oo
o`00:03oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo0?h0oooo000X0?ooo`030000
003oool0oooo08D0oooo00<000000?ooo`3oool0o@3oool002P0oooo00<000000?ooo`3oool0Q@3o
ool00`000000oooo0?ooo`3m0?ooo`00:03oool00`000000oooo0?ooo`250?ooo`030000003oool0
oooo0?d0oooo000X0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0o@3oool002P0
oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`3m0?ooo`00:03oool00`000000oooo
0?ooo`250?ooo`030000003oool0oooo0?d0oooo000X0?ooo`030000003oool0oooo08D0oooo00<0
00000?ooo`3oool0o@3oool002P0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`3l
0?ooo`00:03oool3000008H0oooo00<000000?ooo`3oool0o03oool002P0oooo00<000000?ooo`3o
ool0QP3oool00`000000oooo0?ooo`3l0?ooo`00:03oool00`000000oooo0?ooo`260?ooo`030000
003oool0oooo0?`0oooo000X0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0o03o
ool002P0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`3l0?ooo`00:03oool00`00
0000oooo0?ooo`270?ooo`030000003oool0oooo0?/0oooo000X0?ooo`030000003oool0oooo08L0
oooo00<000000?ooo`3oool0n`3oool002P0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo
0?ooo`3k0?ooo`00:03oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo0?/0oooo000X
0?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0n`3oool002P0oooo00<000000?oo
o`3oool0Q`3oool00`000000oooo0?ooo`3k0?ooo`00:03oool3000008L0oooo00<000000?ooo`3o
ool0n`3oool002P0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`3j0?ooo`00:03o
ool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0?X0oooo000X0?ooo`030000003oool0
oooo08P0oooo00<000000?ooo`3oool0nP3oool002P0oooo00<000000?ooo`3oool0R03oool00`00
0000oooo0?ooo`3j0?ooo`00:03oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0?X0
oooo000X0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool0nP3oool002P0oooo00<0
00000?ooo`3oool0R03oool00`000000oooo0?ooo`3j0?ooo`00:03oool00`000000oooo0?ooo`29
0?ooo`030000003oool0oooo0?T0oooo000X0?ooo`030000003oool0oooo08T0oooo00<000000?oo
o`3oool0n@3oool002P0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`3i0?ooo`00
:03oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo0?T0oooo000X0?ooo`<00000R@3o
ool00`000000oooo0?ooo`3i0?ooo`00:03oool00`000000oooo0?ooo`290?ooo`030000003oool0
oooo0?T0oooo000X0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0n03oool002P0
oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`3h0?ooo`00:03oool00`000000oooo
0?ooo`2:0?ooo`030000003oool0oooo0?P0oooo000X0?ooo`030000003oool0oooo08X0oooo00<0
00000?ooo`3oool0n03oool002P0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`3h
0?ooo`00:03oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo0?P0oooo00020?ooo`05
0?noM000000000000000001d_ol01@3oool00`2oM0000000001d_`040?ooo`030?noM00000000000
00<0000000@007Bo0?ooo`3ookl0M0001@0000000`1d_ol0oooo0?ooo`030?ooo`030000003oool0
oooo08X0oooo00<000000?ooo`3oool0n03oool00080oooo00H0W4Qd0;ooo`3oool0oono07@0M02o
ool40?ooo`030;md0000000007Bo00L0oooo00<0W4Q809cOo`3oool00`3oool00`2oM000001d0;oo
o`020?ooo`030=nLM02Lgol0oooo00@0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?oo
o`3g0?ooo`0000<0oooo0?noM000M;l00`3oool00`3OW4P0B9cO0?ooo`0=0?ooo`0309a8B02Lgol0
oooo00@0oooo00<0okmd0000B02Lgol0203oool00`000000oooo0?ooo`2;0?ooo`030000003oool0
oooo0?L0oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0oooo00d0oooo00<0W4Q809cO
o`3oool01@3oool00`3ogi`0B00004RLg`070?ooo`030000003oool0oooo08/0oooo00<000000?oo
o`3oool0m`3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool03@3oool00`2LB4P0
W=oo0?ooo`070?ooo`0309a80018W=l0oooo00D0oooo1000002:0?ooog400000R@3oool000030?oo
o`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool03@3oool00`2LB4P0W=oo0?ooo`080?ooo`0309a8
M02oool0oooo00@0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?ooo`270?ooo`0000<0
oooo0?noM018W=l00`3oool00`3OW4P0B9cO0?ooo`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00<0
gia807Boo`3oool00P3oool00`2oM000M;oo0?ooo`040?ooo`030000003oool0oooo0?/0oooo00<0
00000?ooo`3oool0Q`3oool00080oooo00H0W4P007Boo`3oool0omnL04P0M02oool;0?ooo`050=nL
B000000004RL09a8B02Lgol0103oool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol01@3oool0
0`000000oooo0?ooo`3l0?ooo`030000003oool0oooo08H0oooo00020?ooo`050?oo_`1d00000000
0000B02Lgol03P3oool00`3OW4P0001809cOo`050?ooo`050?noM000000000000000B02Lgol01P3o
ool00`000000oooo0?ooo`3l0?ooo`030000003oool0oooo08H0oooo000X0?ooo`030000003oool0
oooo0?`0oooo00<000000?ooo`3oool0QP3oool002P0oooo00<000000?ooo`3oool0o03oool00`00
0000oooo0?ooo`260?ooo`00:03oool00`000000oooo0?ooo`3l0?ooo`030000003oool0oooo08H0
oooo000X0?ooo`030000003oool0oooo0?`0oooo00<000000?ooo`3oool0QP3oool002P0oooo00<0
00000?ooo`3oool0o@3oool00`000000oooo0?ooo`250?ooo`00:03oool00`000000oooo0?ooo`3m
0?ooo`030000003oool0oooo08D0oooo000X0?ooo`030000003oool0oooo0?d0oooo00<000000?oo
o`3oool0Q@3oool002P0oooo0`00003m0?ooo`030000003oool0oooo08D0oooo000X0?ooo`030000
003oool0oooo0?d0oooo00<000000?ooo`3oool0Q@3oool002P0oooo00<000000?ooo`3oool0o@3o
ool00`000000oooo0?ooo`250?ooo`00:03oool00`000000oooo0?ooo`3n0?ooo`030000003oool0
oooo08@0oooo000X0?ooo`030000003oool0oooo0?h0oooo00<000000?ooo`3oool0Q03oool002P0
oooo00<000000?ooo`3oool0oP3oool00`000000oooo0?ooo`240?ooo`00:03oool00`000000oooo
0?ooo`3n0?ooo`030000003oool0oooo08@0oooo000X0?ooo`030000003oool0oooo0?h0oooo00<0
00000?ooo`3oool0Q03oool002P0oooo00<000000?ooo`3oool0oP3oool00`000000oooo0?ooo`24
0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooo`030000003oool0oooo08<0oooo000X0?ooo`03
0000003oool0oooo0?l0oooo00<000000?ooo`3oool0P`3oool002P0oooo0`00003o0?ooo`030000
003oool0oooo08<0oooo000X0?ooo`030000003oool0oooo0?l0oooo00<000000?ooo`3oool0P`3o
ool002P0oooo00<000000?ooo`3oool0o`3oool00`000000oooo0?ooo`230?ooo`00:03oool00`00
0000oooo0?ooo`3o0?ooo`030000003oool0oooo08<0oooo000X0?ooo`030000003oool0oooo0?l0
oooo0@3oool00`000000oooo0?ooo`220?ooo`00:03oool00`000000oooo0?ooo`3o0?ooo`40oooo
00<000000?ooo`3oool0PP3oool002P0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003o
ool0oooo0880oooo000X0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`22
0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?ooo`3oool0PP3oool002P0
oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo0880oooo000X0?ooo`030000
003oool0oooo0?l0oooo0P3oool00`000000oooo0?ooo`210?ooo`00:03oool00`000000oooo0?oo
o`3o0?ooo`80oooo00<000000?ooo`3oool0P@3oool002P0oooo0`00003o0?ooo`80oooo00<00000
0?ooo`3oool0P@3oool002P0oooo00<000000?ooo`3oool0o`3oool20?ooo`030000003oool0oooo
0840oooo000X0?ooo`030000003oool0oooo0?l0oooo0P3oool00`000000oooo0?ooo`210?ooo`00
:03oool00`000000oooo0?ooo`3o0?ooo`80oooo00<000000?ooo`3oool0P@3oool002P0oooo00<0
00000?ooo`3oool0o`3oool30?ooo`030000003oool0oooo0800oooo000X0?ooo`030000003oool0
oooo0?l0oooo0`3oool00`000000oooo0?ooo`200?ooo`00:03oool00`000000oooo0?ooo`3o0?oo
o`<0oooo00<000000?ooo`3oool0P03oool002P0oooo00<000000?ooo`3oool0o`3oool30?ooo`03
0000003oool0oooo0800oooo00020?ooo`050?noM000000000000000001d_ol01@3oool00`2oM000
0000001d_`040?ooo`030?noM0000000000000<0000000<007Bo0?ooo`3oool00P3oool01@3ogi`0
B000000000000000M;oo00D0oooo00<000000?ooo`3oool0o`3oool30?ooo`030000003oool0oooo
0800oooo00020?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM0000000001d_`07
0?ooo`0309a8B02Lgol0oooo00L0oooo00<0_g@007Boo`3oool01@3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo00<000000?ooo`3oool0P03oool000030?ooo`3o_g@007Bo00<0oooo00<0gia804RL
g`3oool03@3oool00`2LB4P0W=oo0?ooo`070?ooo`030;md001d_ol0oooo00D0oooo00<000000?oo
o`3oool0o`3oool40?ooo`030000003oool0oooo07l0oooo00000`3oool0gia804RLg`030?ooo`03
0?noM000M;l0oooo00d0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P000000000000300000003
07Boo`3oool0oooo00<0oooo00<000000?ooo`3oool0o`3oool40?ooo`030000003oool0oooo07l0
oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0oooo00d0oooo00<0W4Q809cOo`3oool0
0`3oool01P3o_g@0001d0;ooo`3oool0_g@007Boo`H0oooo1000003o0?ooo`<0oooo;@00001E0?oo
o`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0oooo00@0
oooo00D0gia8001d_`3oool0_g@007Boo`060?ooo`030000003oool0oooo0?l0oooo<03oool00`00
0000oooo0?ooo`1C0?ooo`0000<0oooo0?noM018W=l00`3oool00`3OW4P0B9cO0?ooo`0=0?ooo`03
09a8B02Lgol0oooo00D0oooo00@0W4P004RLg`2oM000M;oo1P3oool00`000000oooo0?ooo`3o0?oo
oc00oooo00<000000?ooo`3oool0D`3oool00080oooo00H0W4P007Boo`3oool0omnL04P0M02oool;
0?ooo`050=nLB000000004RL09a8B02Lgol01P3oool0103ogi`0B01804Q8001d_ol60?ooo`030000
003oool0oooo0?l0oooo<@3oool00`000000oooo0?ooo`1B0?ooo`000P3oool01@3ookl0M0000000
000004P0W=oo00h0oooo00<0gia80000B02Lgol01`3oool00`3o_g@0000007Boo`060?ooo`030000
003oool0oooo0?l0oooo<@3oool00`000000oooo0?ooo`1B0?ooo`00:03oool00`000000oooo0?oo
o`3o0?oooc40oooo00<000000?ooo`3oool0DP3oool002P0oooo00<000000?ooo`3oool0o`3ooola
0?ooo`030000003oool0oooo0580oooo000X0?ooo`030000003oool0oooo0?l0oooo<@3oool00`00
0000oooo0?ooo`1B0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooc40oooo00<000000?ooo`3o
ool0DP3oool002P0oooo00<000000?ooo`3oool0o`3ooolb0?ooo`030000003oool0oooo0540oooo
000X0?ooo`030000003oool0oooo0?l0oooo<P3oool00`000000oooo0?ooo`1A0?ooo`00:03oool0
0`000000oooo0?ooo`3o0?oooc80oooo00<000000?ooo`3oool0D@3oool002P0oooo0`00003o0?oo
oc80oooo00<000000?ooo`3oool0D@3oool002P0oooo00<000000?ooo`3oool0o`3ooolb0?ooo`03
0000003oool0oooo0540oooo000X0?ooo`030000003oool0oooo0?l0oooo<P3oool00`000000oooo
0?ooo`1A0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooc<0oooo00<000000?ooo`3oool0D03o
ool002P0oooo00<000000?ooo`3oool0o`3ooolc0?ooo`030000003oool0oooo0500oooo000X0?oo
o`030000003oool0oooo0?l0oooo<`3oool00`000000oooo0?ooo`1@0?ooo`00:03oool00`000000
oooo0?ooo`3o0?oooc<0oooo00<000000?ooo`3oool0D03oool002P0oooo00<000000?ooo`3oool0
o`3ooolc0?ooo`030000003oool0oooo0500oooo000X0?ooo`030000003oool0oooo0?l0oooo<`3o
ool00`000000oooo0?ooo`1@0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooc@0oooo00<00000
0?ooo`3oool0C`3oool002P0oooo00<000000?ooo`3oool0o`3ooold0?ooo`030000003oool0oooo
04l0oooo000X0?ooo`<00000o`3ooold0?ooo`030000003oool0oooo04l0oooo000X0?ooo`030000
003oool0oooo0?l0oooo=03oool00`000000oooo0?ooo`1?0?ooo`00:03oool00`000000oooo0?oo
o`3o0?oooc@0oooo00<000000?ooo`3oool0C`3oool002P0oooo00<000000?ooo`3oool0o`3ooold
0?ooo`030000003oool0oooo04l0oooo000X0?ooo`030000003oool0oooo0?l0oooo=@3oool00`00
0000oooo0?ooo`1>0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooocD0oooo00<000000?ooo`3o
ool0CP3oool002P0oooo00<000000?ooo`3oool0o`3ooole0?ooo`030000003oool0oooo04h0oooo
000X0?ooo`030000003oool0oooo0?l0oooo=@3oool00`000000oooo0?ooo`1>0?ooo`00:03oool0
0`000000oooo0?ooo`3o0?ooocD0oooo00<000000?ooo`3oool0CP3oool002P0oooo00<000000?oo
o`3oool0o`3ooole0?ooo`030000003oool0oooo04h0oooo000X0?ooo`030000003oool0oooo0?l0
oooo=P3oool00`000000oooo0?ooo`1=0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooocH0oooo
00<000000?ooo`3oool0C@3oool002P0oooo0`00003o0?ooocH0oooo00<000000?ooo`3oool0C@3o
ool002P0oooo00<000000?ooo`3oool0o`3ooolf0?ooo`030000003oool0oooo04d0oooo000X0?oo
o`030000003oool0oooo0?l0oooo=P3oool00`000000oooo0?ooo`1=0?ooo`00:03oool00`000000
oooo0?ooo`3o0?ooocH0oooo00<000000?ooo`3oool0C@3oool002P0oooo00<000000?ooo`3oool0
o`3ooolg0?ooo`030000003oool0oooo04`0oooo000X0?ooo`030000003oool0oooo0?l0oooo=`3o
ool00`000000oooo0?ooo`1<0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooocL0oooo00<00000
0?ooo`3oool0C03oool002P0oooo00<000000?ooo`3oool0o`3ooolg0?ooo`030000003oool0oooo
04`0oooo00020?ooo`050?noM000000000000000001d_ol01@3oool00`2oM0000000001d_`040?oo
o`030?noM0000000000000<0000000<007Bo0?ooo`3oool00P3oool01@2oM00000000000000007@0
_ooo00D0oooo00<000000?ooo`3oool0o`3ooolg0?ooo`030000003oool0oooo04`0oooo00020?oo
o`0609a8M02oool0oooo0?oo_`1d07@0_ooo103oool00`2oM0000000001d_`070?ooo`0309a8B02L
gol0oooo00@0oooo00H0gia8001d_`3oool0oooo0?noM000M;l50?ooo`030000003oool0oooo0?l0
oooo=`3oool00`000000oooo0?ooo`1<0?ooo`0000<0oooo0?noM000M;l00`3oool00`3OW4P0B9cO
0?ooo`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00<0oono07@0001d_ol00P3oool00`3ookl0M4RL
0?ooo`040?ooo`030000003oool0oooo0?l0oooo>03oool00`000000oooo0?ooo`1;0?ooo`0000<0
oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00L0
okmd0018B01d07@0_ooo0?ooo`3OW4P007Bo00D0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`03
0000003oool0oooo04/0oooo00000`3oool0gia804RLg`030?ooo`030?noM000M;l0oooo00d0oooo
00<0W4Q809cOo`3oool00`3oool00`3ogi`0B4RL0?noM002000000030018W03oool0oooo00@0oooo
1000003o0?ooocL0oooo7`00000_0?ooo`0000<0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?oo
o`0=0?ooo`0309a8B02Lgol0oooo00<0oooo00<0oono07@0M02oool02@3oool00`000000oooo0?oo
o`3o0?oooeH0oooo00<000000?ooo`3oool0;@3oool000030?ooo`3o_g@0B9cO00<0oooo00<0gia8
04RLg`3oool03@3oool00`2LB4P0W=oo0?ooo`040?ooo`030;md0018W=l0oooo00P0oooo00<00000
0?ooo`3oool0o`3ooomF0?ooo`030000003oool0oooo02d0oooo00020?ooo`0609a8001d_ol0oooo
0?oOW01807@0_ooo2`3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00<0oono07@00000M;l0
203oool00`000000oooo0?ooo`3o0?oooeH0oooo00<000000?ooo`3oool0;@3oool00080oooo00D0
oono07@000000000001809cOo`0>0?ooo`030=nLB00004P0W=oo00L0oooo00@0_g@0000000000000
04RL1@3oool00`000000oooo0?ooo`3o0?oooeL0oooo00<000000?ooo`3oool0;03oool002P0oooo
00<000000?ooo`3oool0o`3ooomG0?ooo`030000003oool0oooo02`0oooo000X0?ooo`030000003o
ool0oooo0?l0ooooE`3oool00`000000oooo0?ooo`0/0?ooo`00:03oool00`000000oooo0?ooo`3o
0?oooeL0oooo00<000000?ooo`3oool0;03oool002P0oooo00<000000?ooo`3oool0o`3ooomG0?oo
o`030000003oool0oooo02`0oooo000X0?ooo`030000003oool0oooo0?l0ooooE`3oool00`000000
oooo0?ooo`0/0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooeL0oooo00<000000?ooo`3oool0
;03oool002P0oooo00<000000?ooo`3oool0o`3ooomH0?ooo`030000003oool0oooo02/0oooo000X
0?ooo`<00000o`3ooomH0?ooo`030000003oool0oooo02/0oooo000X0?ooo`030000003oool0oooo
0?l0ooooF03oool00`000000oooo0?ooo`0[0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooeP0
oooo00<000000?ooo`3oool0:`3oool002P0oooo00<000000?ooo`3oool0o`3ooomH0?ooo`030000
003oool0oooo02/0oooo000X0?ooo`030000003oool0oooo0?l0ooooF03oool00`000000oooo0?oo
o`0[0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooeT0oooo00<000000?ooo`3oool0:P3oool0
02P0oooo00<000000?ooo`3oool0o`3ooomI0?ooo`030000003oool0oooo02X0oooo000X0?ooo`03
0000003oool0oooo0?l0ooooF@3oool00`000000oooo0?ooo`0Z0?ooo`00:03oool00`000000oooo
0?ooo`3o0?oooeT0oooo00<000000?ooo`3oool0:P3oool002P0oooo00<000000?ooo`3oool0o`3o
oomI0?ooo`030000003oool0oooo02X0oooo000X0?ooo`030000003oool0oooo0?l0ooooF@3oool0
0`000000oooo0?ooo`0Z0?ooo`00:03oool300000?l0ooooF@3oool00`000000oooo0?ooo`0Z0?oo
o`00:03oool00`000000oooo0?ooo`3o0?oooeX0oooo00<000000?ooo`3oool0:@3oool002P0oooo
00<000000?ooo`3oool0o`3ooomJ0?ooo`030000003oool0oooo02T0oooo000X0?ooo`030000003o
ool0oooo0?l0ooooFP3oool00`000000oooo0?ooo`0Y0?ooo`00:03oool00`000000oooo0?ooo`3o
0?oooeX0oooo00<000000?ooo`3oool0:@3oool002P0oooo00<000000?ooo`3oool0o`3ooomJ0?oo
o`030000003oool0oooo02T0oooo000X0?ooo`030000003oool0oooo0?l0ooooFP3oool00`000000
oooo0?ooo`0Y0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooeX0oooo00<000000?ooo`3oool0
:@3oool002P0oooo00<000000?ooo`3oool0o`3ooomK0?ooo`030000003oool0oooo02P0oooo000X
0?ooo`030000003oool0oooo0?l0ooooF`3oool00`000000oooo0?ooo`0X0?ooo`00:03oool00`00
0000oooo0?ooo`3o0?oooe/0oooo00<000000?ooo`3oool0:03oool002P0oooo00<000000?ooo`3o
ool0o`3ooomK0?ooo`030000003oool0oooo02P0oooo000X0?ooo`<00000o`3ooomK0?ooo`030000
003oool0oooo02P0oooo000X0?ooo`030000003oool0oooo0?l0ooooF`3oool00`000000oooo0?oo
o`0X0?ooo`00:03oool00`000000oooo0?ooo`3o0?oooe`0oooo00<000000?ooo`3oool09`3oool0
02P0oooo00<000000?ooo`3oool0o`3ooomL0?ooo`030000003oool0oooo02L0oooo000X0?ooo`03
0000003oool0oooo0?l0ooooG03oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo
0?ooo`3o0?oooe`0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0o`3o
oomL0?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo0?l0ooooG03oool0
0`000000oooo0?ooo`0W0?ooo`000P3oool01@3o_g@00000000000000000M;oo00D0oooo00<0_g@0
00000000M;l0103oool00`3o_g@000000000000300000005001d_`3oool0oooo0?ooo`2oM0000`00
00000`00M;l0oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooG03oool00`000000oooo0?oo
o`0W0?ooo`000P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`@0oooo00<0_g@000000000M;l0
1`3oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM000M;l0oooo0080oooo00<0_gA809cOo`3oool0
103oool00`000000oooo0?ooo`3o0?oooed0oooo00<000000?ooo`3oool09P3oool000030?ooo`3o
_g@007Bo00<0oooo00<0gia804RLg`3oool03@3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018
W=l0oooo0080oooo00<0_g@007Boo`3oool0103oool00`000000oooo0?ooo`3o0?oooed0oooo00<0
00000?ooo`3oool09P3oool000030?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool03@3oool0
0`2LB4P0W=oo0?ooo`030?ooo`030?noM000B9`0oooo0080oooo00<0W4Q809cOo`3oool0103oool0
0`000000oooo0?ooo`3o0?oooed0oooo00<000000?ooo`3oool09P3oool000030?ooo`3OW4P0B9cO
00<0oooo00<0okmd001d_`3oool03@3oool00`2LB4P0W=oo0?ooo`040?ooo`050=nLB00000000000
00000018W=l01P3oool400000?l0ooooG03oool@000001T0oooo00000`3oool0gia804RLg`030?oo
o`030?noM000M;l0oooo00d0oooo00<0W4Q809cOo`3oool00`3oool00`3ookl0M4RL0?ooo`020?oo
o`0309a8M02oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooom/0?ooo`030000003oool0oooo
01L0oooo00000`3oool0okmd04RLg`030?ooo`030=nLB018W=l0oooo00d0oooo00<0W4Q809cOo`3o
ool00`3oool00`3o_g@0B9cO0?ooo`020?ooo`030;md001d_ol0oooo00@0oooo00<000000?ooo`3o
ool0o`3ooom/0?ooo`030000003oool0oooo01L0oooo00020?ooo`0609a8001d_ol0oooo0?oOW018
07@0_ooo2`3oool01@3OW4P000000018W02LB4P0W=oo00@0oooo00L0omnL04P0M02oool0oooo0?oO
W01807@0_ooo00D0oooo00<000000?ooo`3oool0o`3ooom]0?ooo`030000003oool0oooo01H0oooo
00020?ooo`050?oo_`1d000000000000B02Lgol03P3oool00`3OW4P0001809cOo`050?ooo`050?no
M000000000000000B02Lgol01P3oool00`000000oooo0?ooo`3o0?ooofd0oooo00<000000?ooo`3o
ool05P3oool002P0oooo00<000000?ooo`3oool0o`3ooom]0?ooo`030000003oool0oooo01H0oooo
000X0?ooo`030000003oool0oooo0?l0ooooK@3oool00`000000oooo0?ooo`0F0?ooo`00:03oool0
0`000000oooo0?ooo`3o0?ooofd0oooo00<000000?ooo`3oool05P3oool002P0oooo00<000000?oo
o`3oool0o`3ooom]0?ooo`030000003oool0oooo01H0oooo000X0?ooo`030000003oool0oooo0?l0
ooooKP3oool00`000000oooo0?ooo`0E0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooofh0oooo
00<000000?ooo`3oool05@3oool002P0oooo00<000000?ooo`3oool0o`3ooom^0?ooo`030000003o
ool0oooo01D0oooo000X0?ooo`<00000o`3ooom^0?ooo`030000003oool0oooo01D0oooo000X0?oo
o`030000003oool0oooo0?l0ooooKP3oool00`000000oooo0?ooo`0E0?ooo`00:03oool00`000000
oooo0?ooo`3o0?ooofh0oooo00<000000?ooo`3oool05@3oool002P0oooo00<000000?ooo`3oool0
o`3ooom_0?ooo`030000003oool0oooo01@0oooo000X0?ooo`030000003oool0oooo0?l0ooooK`3o
ool00`000000oooo0?ooo`0D0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooofl0oooo00<00000
0?ooo`3oool0503oool002P0oooo00<000000?ooo`3oool0o`3ooom_0?ooo`030000003oool0oooo
01@0oooo000X0?ooo`030000003oool0oooo0?l0ooooK`3oool00`000000oooo0?ooo`0D0?ooo`00
:03oool00`000000oooo0?ooo`3o0?ooofl0oooo00<000000?ooo`3oool0503oool002P0oooo00<0
00000?ooo`3oool0o`3ooom`0?ooo`030000003oool0oooo01<0oooo000X0?ooo`030000003oool0
oooo0?l0ooooL03oool00`000000oooo0?ooo`0C0?ooo`00:03oool300000?l0ooooL03oool00`00
0000oooo0?ooo`0C0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooog00oooo00<000000?ooo`3o
ool04`3oool002P0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`030000003oool0oooo01<0oooo
000X0?ooo`030000003oool0oooo0?l0ooooL03oool00`000000oooo0?ooo`0C0?ooo`00:03oool0
0`000000oooo0?ooo`3o0?ooog40oooo00<000000?ooo`3oool04P3oool002P0oooo00<000000?oo
o`3oool0o`3oooma0?ooo`030000003oool0oooo0180oooo000X0?ooo`030000003oool0oooo0?l0
ooooL@3oool00`000000oooo0?ooo`0B0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooog40oooo
00<000000?ooo`3oool04P3oool002P0oooo00<000000?ooo`3oool0o`3oooma0?ooo`030000003o
ool0oooo0180oooo000X0?ooo`030000003oool0oooo0?l0ooooL@3oool00`000000oooo0?ooo`0B
0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooog80oooo00<000000?ooo`3oool04@3oool002P0
oooo00<000000?ooo`3oool0o`3ooomb0?ooo`030000003oool0oooo0140oooo000X0?ooo`<00000
o`3ooomb0?ooo`030000003oool0oooo0140oooo000X0?ooo`030000003oool0oooo0?l0ooooLP3o
ool00`000000oooo0?ooo`0A0?ooo`00:03oool00`000000oooo0?ooo`3o0?ooog80oooo00<00000
0?ooo`3oool04@3oool002P0oooo00<000000?ooo`3oool0o`3ooomb0?ooo`030000003oool0oooo
0140oooo000X0?ooo`030000003oool0oooo0?l0ooooL`3oool00`000000oooo0?ooo`0@0?ooo`00
:03oool00`000000oooo0?ooo`3o0?ooog<0oooo00<000000?ooo`3oool0403oool002P0oooo00<0
00000?ooo`3oool0o`3ooomc0?ooo`030000003oool0oooo0100oooo000X0?ooo`030000003oool0
oooo0?l0ooooL`3oool00`000000oooo0?ooo`0@0?ooo`00:03oool00`000000oooo0?ooo`3o0?oo
og<0oooo00<000000?ooo`3oool0403oool000/0oooo00D0okmd000000000000000007Boo`050?oo
o`030;md0000000007Bo00<0oooo00<0oono07@000000000100000000`1d_ol0oooo0?ooo`030?oo
o`030000003oool0oooo0?l0ooooL`3oool00`000000oooo0?ooo`0@0?ooo`002`3oool01P2LB7@0
_ooo0?ooo`3ookl0M01d0;ooo`@0oooo00<0_g@000000000M;l0103oool00`2oM000001d0;ooo`02
0?ooo`030=nLM02Lgol0oooo00@0oooo00<000000?ooo`3oool0o`3ooomd0?ooo`030000003oool0
oooo00l0oooo000:0?ooo`030?noM000M;l0oooo0080oooo00<0gia804RLg`3oool02`3oool00`3o
_g@0001809cOo`080?ooo`030000003oool0oooo0?l0ooooM03oool00`000000oooo0?ooo`0?0?oo
o`002P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00`0oooo00<0omnL04P00018
W=l01`3oool400000?l0ooooL`3oool8000000X0oooo000:0?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool03P3oool00`2LB000B9cO0?ooo`050?ooo`030000003oool0oooo0?l0oooo
QP3oool000X0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0?0?ooo`0309a8M02o
ool0oooo00@0oooo00<000000?ooo`3oool0o`3ooon60?ooo`002P3oool00`3o_g@0B9cO0?ooo`02
0?ooo`030=nLB018W=l0oooo00X0oooo00<0gia807Boo`3oool00P3oool00`2oM000M;oo0?ooo`04
0?ooo`030000003oool0oooo0?l0ooooQP3oool000/0oooo00H0W4P007Boo`3oool0omnL04P0M02o
ool;0?ooo`070?noM00007@0_ooo0?ooo`3o_g@0001809cOo`050?ooo`030000003oool0oooo0?l0
ooooQP3oool000/0oooo00D0oono07@000000000001809cOo`0=0?ooo`050?noM000000000000000
B02Lgol01P3oool00`000000oooo0?ooo`3o0?ooohH0oooo000X0?ooo`030000003oool0oooo0?l0
ooooQP3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287.313}, {177.25, 0}} -> {-5, 0, 0, 0}},
  CellTags->"b:4.1.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[22]=",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:4.1.1"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"b:4.1.1"],

Cell[TextData[{
  "The details of how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions are mapped to types stored in the database is discussed in \
the ",
  ButtonBox["Data Type Mapping",
    ButtonData:>{"DatabaseLink6.1.0", "xref:141"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:4.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Tables", "Subsubsection",
  CellTags->{"xref:32", "c:45", "b:4.1.2"}],

Cell[TextData[{
  StyleBox["SQLCreateTable", "MR"],
  " creates a new table in a database. An alternative, using raw SQL, is \
described in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.3", "xref:39"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[TextData[{
  "When creating a table, the result of ",
  StyleBox["SQLCreateTable", "MR"],
  " is an integer specifying the number of rows affected by the query. If the \
table is created correctly, this integer will always be zero as no rows are \
affected when creating a new table."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLCreateTable[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, table, {columns..}, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"create an SQL table\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.2"}],

Cell["Creating a table in a database.", "Caption",
  CellTags->"b:4.1.2"],

Cell[TextData[{
  "Here is an example that creates a table. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.2"],

Cell[TextData[{
  StyleBox["SQLCreateTable", "MR"],
  " creates a table. The columns are given as a list of ",
  ButtonBox["SQLColumn",
    ButtonData:>{"DatabaseLink3.4", "xref:78"},
    ButtonStyle->"AddOnsLink"],
  " expressions. In the following example, a new table, ",
  StyleBox["DATATYPESTABLE", "TI"],
  ", is created that has one column for each of the data types returned from \
",
  ButtonBox["SQLDataTypeNames",
    ButtonData:>{"DatabaseLink3.5", "xref:27"},
    ButtonStyle->"AddOnsLink"],
  ". The column, ",
  StyleBox["TINYINTCOL", "TI"],
  ", is configured so that it cannot be set to ",
  StyleBox["Null", "MR"],
  ".  However, each binary column can be set to ",
  StyleBox["Null", "MR"],
  ". The database default for ",
  StyleBox["Nullable", "MR"],
  " is used for every other column that does not specify the ",
  StyleBox["Nullable", "MR"],
  " option. The character-based columns are limited to a specific data \
length; other columns use the default data length for their type."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDataTypeNames[conn]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.2"],

Cell[BoxData[
    \({"TINYINT", "BIGINT", "LONGVARBINARY", "VARBINARY", "BINARY", 
      "LONGVARCHAR", "CHAR", "NUMERIC", "DECIMAL", "INTEGER", "SMALLINT", 
      "FLOAT", "REAL", "DOUBLE", "VARCHAR", "VARCHAR_IGNORECASE", "BOOLEAN", 
      "DATE", "TIME", "TIMESTAMP", "OTHER"}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:4.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLCreateTable[
      conn, \ "\<DATATYPESTABLE\>", \ \
\[IndentingNewLine]{\[IndentingNewLine]SQLColumn["\<TINYINTCOL\>", \ 
          DataTypeName -> "\<TINYINT\>", \ 
          Nullable \[Rule] 
            False], \[IndentingNewLine]SQLColumn["\<SMALLINTCOL\>", \ 
          DataTypeName -> "\<SMALLINT\>"], \
\[IndentingNewLine]SQLColumn["\<INTEGERCOL\>", \ 
          DataTypeName -> "\<INTEGER\>"], \
\[IndentingNewLine]SQLColumn["\<BIGINTCOL\>", \ 
          DataTypeName -> "\<BIGINT\>"], \
\[IndentingNewLine]SQLColumn["\<NUMERICCOL\>", \ 
          DataTypeName -> "\<NUMERIC\>"], 
        SQLColumn["\<DECIMALCOL\>", \ 
          DataTypeName -> "\<DECIMAL\>"], \
\[IndentingNewLine]SQLColumn["\<FLOATCOL\>", \ 
          DataTypeName -> "\<FLOAT\>"], \
\[IndentingNewLine]SQLColumn["\<REALCOL\>", \ 
          DataTypeName -> "\<REAL\>"], \
\[IndentingNewLine]SQLColumn["\<DOUBLECOL\>", \ 
          DataTypeName -> "\<DOUBLE\>"], 
        SQLColumn["\<BITCOL\>", \ 
          DataTypeName -> "\<BIT\>"], \
\[IndentingNewLine]SQLColumn["\<LONGVARBINARYCOL\>", \ 
          DataTypeName -> "\<LONGVARBINARY\>", \ 
          Nullable \[Rule] 
            True], \[IndentingNewLine]SQLColumn["\<VARBINARYCOL\>", \ 
          DataTypeName -> "\<VARBINARY\>", \ 
          Nullable \[Rule] 
            True], \[IndentingNewLine]SQLColumn["\<BINARYCOL\>", \ 
          DataTypeName -> "\<BINARY\>", \ 
          Nullable \[Rule] 
            True], \[IndentingNewLine]SQLColumn["\<LONGVARCHARCOL\>", \ 
          DataTypeName -> "\<LONGVARCHAR\>"], \
\[IndentingNewLine]SQLColumn["\<VARCHARCOL\>", \ 
          DataTypeName -> "\<VARCHAR\>", \ Nullable \[Rule] True, \ 
          DataLength \[Rule] 5], 
        SQLColumn["\<CHARCOL\>", \ DataTypeName -> "\<CHAR\>", \ 
          Nullable \[Rule] True, \ 
          DataLength \[Rule] 
            3], \[IndentingNewLine]SQLColumn["\<DATECOL\>", \ 
          DataTypeName -> "\<DATE\>"], 
        SQLColumn["\<TIMECOL\>", \ 
          DataTypeName -> "\<TIME\>"], \
\[IndentingNewLine]SQLColumn["\<TIMESTAMPCOL\>", \ 
          DataTypeName -> "\<TIMESTAMP\>"], \
\[IndentingNewLine]SQLColumn["\<OBJECTCOL\>", \ 
          DataTypeName -> "\<OBJECT\>", \ 
          Nullable \[Rule] True]\[IndentingNewLine]}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.1.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.1.2"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLTableNames", "MR"],
  " verifies that the table exists in the database."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, "\<DATATYPESTABLE\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.1.2"],

Cell[BoxData[
    \({"DATATYPESTABLE"}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.2"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumnNames", "MR"],
  " verifies the columns in the table."
}], "Text",
  CellTags->"b:4.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ "\<DATATYPESTABLE\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.2"],

Cell[BoxData[
    \({{"DATATYPESTABLE", "TINYINTCOL"}, {"DATATYPESTABLE", 
        "SMALLINTCOL"}, {"DATATYPESTABLE", "INTEGERCOL"}, {"DATATYPESTABLE", 
        "BIGINTCOL"}, {"DATATYPESTABLE", "NUMERICCOL"}, {"DATATYPESTABLE", 
        "DECIMALCOL"}, {"DATATYPESTABLE", "FLOATCOL"}, {"DATATYPESTABLE", 
        "REALCOL"}, {"DATATYPESTABLE", "DOUBLECOL"}, {"DATATYPESTABLE", 
        "BITCOL"}, {"DATATYPESTABLE", "LONGVARBINARYCOL"}, {"DATATYPESTABLE", 
        "VARBINARYCOL"}, {"DATATYPESTABLE", "BINARYCOL"}, {"DATATYPESTABLE", 
        "LONGVARCHARCOL"}, {"DATATYPESTABLE", 
        "VARCHARCOL"}, {"DATATYPESTABLE", "CHARCOL"}, {"DATATYPESTABLE", 
        "DATECOL"}, {"DATATYPESTABLE", "TIMECOL"}, {"DATATYPESTABLE", 
        "TIMESTAMPCOL"}, {"DATATYPESTABLE", "OBJECTCOL"}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.1.2"]
}, Closed]],

Cell["This drops the table and closes the connection.", "Text",
  CellTags->"b:4.1.2"],

Cell[BoxData[{
    \(SQLDropTable[conn, \ "\<DATATYPESTABLE\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.1.2"],

Cell[TextData[{
  "Certain databases support further options for columns, such as whether a \
column is a key or it auto-increments. If these options are desired, then a \
raw SQL statement should be used to create the table. The ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.2.3", "xref:39"},
    ButtonStyle->"AddOnsLinkText"],
  " section in SQL-Based Queries has some ideas and examples. "
}], "Text",
  CellTags->"b:4.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inserting Data", "Subsubsection",
  CellTags->{"xref:33", "c:46", "b:4.1.3"}],

Cell[TextData[{
  StyleBox["SQLInsert", "MR"],
  " inserts data into a database. An alternative, using raw SQL, is described \
in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.4", "xref:40"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[TextData[{
  "The result of ",
  StyleBox["SQLInsert", "MR"],
  " is an integer specifying the number of rows affected by the query. For a \
single insert this will be one, since you can only insert one row at a time. \
",
  StyleBox["SQLInsert", "MR"],
  " also supports a batch insert, as demonstrated in the ",
  ButtonBox["Batch Input",
    ButtonData:>{"DatabaseLink6.3.0", "xref:79"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLInsert[\"\>",
                        "MR"], 
                      
                      StyleBox["\<\"conn, table, {columns..}, {values..}\"\>",
                        
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"insert data into a database\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLInsert[\"\>",
                        "MR"], 
                      
                      StyleBox["\<\"conn, table, {columns..}, \
{{values..}..}\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"batch insert data into a \
database\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.3"}],

Cell["Inserting data into a database.", "Caption",
  CellTags->"b:4.1.3"],

Cell[TextData[{
  "Here is an example that inserts data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.3"],

Cell[TextData[{
  "A new table, ",
  StyleBox["TEST", "TI"],
  ", is created. The details of this command are described in the ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.1.2", "xref:32"},
    ButtonStyle->"AddOnsLinkText"],
  " section. "
}], "Text",
  CellTags->"b:4.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLCreateTable[
      conn, \ "\<TEST\>", \ \
\[IndentingNewLine]{\[IndentingNewLine]SQLColumn["\<COL1\>", \ 
          DataTypeName -> "\<INTEGER\>"], \
\[IndentingNewLine]SQLColumn["\<COL2\>", \ 
          DataTypeName -> "\<DOUBLE\>"]\[IndentingNewLine]}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLInsert", "MR"],
  " inserts data into this table."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {10, \ 
        10.5}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " verifies the data stored in the database."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    \({{10, 10.5`}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell["\<\
Finally, a batch insert is carried out. The result is a list of the number of \
lines that are modified.\
\>", "Text",
  CellTags->"b:4.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ {{10, \ 10.5}, {20, 
          55.1}}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " shows that there are now three rows in this table."
}], "Text",
  CellTags->"b:4.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.1.3"],

Cell[BoxData[
    \({{10, 10.5`}, {10, 10.5`}, {20, 55.1`}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell["This drops the table and closes the connection.", "Text",
  CellTags->"b:4.1.3"],

Cell[BoxData[{
    \(SQLDropTable[conn, \ "\<TEST\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.1.3"],

Cell[TextData[{
  "The details of how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions are mapped to types stored in the database is discussed in \
the ",
  ButtonBox["Data Type Mapping",
    ButtonData:>{"DatabaseLink6.1.0", "xref:141"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:4.1.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Updating Data", "Subsubsection",
  CellTags->{"xref:34", "c:47", "b:4.1.4"}],

Cell[TextData[{
  StyleBox["SQLUpdate", "MR"],
  " modifies data in a database. An alternative, using raw SQL, is described \
in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.5", "xref:41"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[TextData[{
  "The result of ",
  StyleBox["SQLUpdate", "MR"],
  " is an integer specifying the number of rows affected by the query."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLUpdate[\"\>",
                        "MR"], 
                      StyleBox["\<\"conn,table\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({columns .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({values .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"update data in a database\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLUpdate[\"\>",
                        "MR"], 
                      StyleBox["\<\"conn,table\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({columns .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox[\({values .. }\),
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["condition",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"update data in a database using a \
condition\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.4"}],

Cell["Updating data in a database.", "Caption",
  CellTags->"b:4.1.4"],

Cell[TextData[{
  "Here is an example that updates data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.4"],

Cell[TextData[{
  "A new table, ",
  StyleBox["TEST", "TI"],
  ", is created and data is inserted."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[BoxData[{
    \(SQLCreateTable[
      conn, \ "\<TEST\>", \ \
\[IndentingNewLine]{\[IndentingNewLine]SQLColumn["\<COL1\>", \ 
          DataTypeName -> "\<INTEGER\>"], \
\[IndentingNewLine]SQLColumn["\<COL2\>", \ 
          DataTypeName -> "\<DOUBLE\>"]\[IndentingNewLine]}]; \), "\n", 
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {10, \ 
        10.5}]; \)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.4"],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " shows the values in the table."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.1.4"],

Cell[BoxData[
    \({{10, 10.5`}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.4"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLUpdate", "MR"],
  " updates the elements in the database and ",
  StyleBox["SQLSelect", "MR"],
  " shows the result."
}], "Text",
  CellTags->"b:4.1.4"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLUpdate[
      conn, \ "\<TEST\>", {"\<COL1\>", \ "\<COL2\>"}, {12, \ 
        12.5}]; \), "\n", 
    \(SQLSelect[conn, \ "\<TEST\>"]\)}], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.4"],

Cell[BoxData[
    \({{12, 12.5`}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.1.4"]
}, Closed]],

Cell[TextData[{
  "Typically, it is useful to set a condition for an update, with the \
condition specifying which rows should be updated. (For more information on \
conditions, see the ",
  ButtonBox["Selecting Data",
    ButtonData:>{"DatabaseLink4.1.1", "xref:31"},
    ButtonStyle->"AddOnsLinkText"],
  " section.)  In the following example, another row is inserted into the \
database. "
}], "Text",
  CellTags->"b:4.1.4"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {20, \ 
        20.5}]; \), "\n", 
    \(SQLSelect[conn, \ "\<TEST\>"]\)}], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.1.4"],

Cell[BoxData[
    \({{12, 12.5`}, {20, 20.5`}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.1.4"]
}, Closed]],

Cell["\<\
Here an update is given for rows for which the entry in the first column is \
less than 15.\
\>", "Text",
  CellTags->"b:4.1.4"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLUpdate[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ {4, 1.1}, \ 
      SQLColumn["\<COL1\>"]\  < \ 15\ ]; \), "\n", 
    \(SQLSelect[conn, "\<TEST\>"]\)}], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:4.1.4"],

Cell[BoxData[
    \({{20, 20.5`}, {4, 1.1`}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.1.4"]
}, Closed]],

Cell["This drops the table and closes the connection.", "Text",
  CellTags->"b:4.1.4"],

Cell[BoxData[{
    \(SQLDropTable[conn, \ "\<TEST\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.1.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deleting Data", "Subsubsection",
  CellTags->{"xref:35", "c:48", "b:4.1.5"}],

Cell[TextData[{
  StyleBox["SQLDelete", "MR"],
  " deletes data from a database. An alternative, using raw SQL, is described \
in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.6", "xref:42"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[TextData[{
  "The result of ",
  StyleBox["SQLDelete", "MR"],
  " is an integer specifying the number of rows affected by the query. Thus, \
if three rows are removed, the result is three, and if no rows are removed, \
the result is zero."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLDelete[\"\>",
                      "MR"], 
                    StyleBox["\<\"table\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"delete data from a database\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLDelete[\"\>",
                        "MR"], 
                      StyleBox["\<\"table\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox["condition",
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"delete data from a database using \
a condition\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.5"}],

Cell["Deleting data from a database.", "Caption",
  CellTags->"b:4.1.5"],

Cell[TextData[{
  "Here is an example that deletes data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.5"],

Cell[TextData[{
  "A new table, ",
  StyleBox["TEST", "TI"],
  ", is created and data is inserted."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLCreateTable[
      conn, \ "\<TEST\>", \ \
\[IndentingNewLine]{\[IndentingNewLine]SQLColumn["\<COL1\>", \ 
          DataTypeName -> "\<INTEGER\>"], \
\[IndentingNewLine]SQLColumn["\<COL2\>", \ 
          DataTypeName -> "\<DOUBLE\>"]\[IndentingNewLine]}]; \), "\n", 
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {{10, \ 
          10.5}, {20, \ 17.5}}]; \), "\n", 
    \(SQLSelect[conn, \ "\<TEST\>"]\)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \({{10, 10.5`}, {20, 17.5`}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell["\<\
The following deletes all the data from the table. Two rows were deleted, and \
the result is two.\
\>", "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDelete[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " verifies that all the data has been removed from the table."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell["This restores the data in the database.", "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {{10, \ 
          10.5}, {20, \ 17.5}}]; \), "\n", 
    \(SQLSelect[conn, \ "\<TEST\>"]\)}], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \({{10, 10.5`}, {20, 17.5`}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell[TextData[{
  "Here, a condition is used in the ",
  StyleBox["SQLDelete", "MR"],
  " command, so that only rows for which the entry in the first column is \
greater than 15 are deleted. This deletes one row, and hence the result is \
one."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stmt\  = \ 
      SQLDelete[conn, \ "\<TEST\>", \ 
        SQLColumn["\<COL1\>"]\  > \ 15]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLSelect", "MR"],
  " verifies that one row was removed from the table."
}], "Text",
  CellTags->"b:4.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.1.5"],

Cell[BoxData[
    \({{10, 10.5`}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell["This drops the table and closes the connection.", "Text",
  CellTags->"b:4.1.5"],

Cell[BoxData[{
    \(SQLDropTable[conn, \ "\<TEST\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.1.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Dropping Tables", "Subsubsection",
  CellTags->{"xref:36", "c:49", "b:4.1.6"}],

Cell[TextData[{
  StyleBox["SQLDropTable", "MR"],
  " drops tables from a database. An alternative, using raw SQL, is \
demonstrated in the ",
  ButtonBox["SQL-Based Queries",
    ButtonData:>{"DatabaseLink4.2.7", "xref:43"},
    ButtonStyle->"AddOnsLinkText"],
  " section. If you find that the examples in this section do not work as \
shown, you may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.1.6"],

Cell[TextData[{
  "The result of ",
  StyleBox["SQLDropTable", "MR"],
  " is an integer specifying the number of rows affected by the query."
}], "Text",
  CellTags->"b:4.1.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLDropTable[\"\>",
                      "MR"], 
                    StyleBox["\<\"table\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"drop a table from a database\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.1.6"}],

Cell["Dropping a table from a database.", "Caption",
  CellTags->"b:4.1.6"],

Cell[TextData[{
  "Here is an example that drops a table. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.1.6"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.1.6"],

Cell[TextData[{
  "A new table, ",
  StyleBox["TEST", "TI"],
  ", is created and data is inserted."
}], "Text",
  CellTags->"b:4.1.6"],

Cell[BoxData[{
    \(SQLCreateTable[
      conn, \ "\<TEST\>", \ \
\[IndentingNewLine]{\[IndentingNewLine]SQLColumn["\<COL1\>", \ 
          DataTypeName -> "\<INTEGER\>"], \
\[IndentingNewLine]SQLColumn["\<COL2\>", \ 
          DataTypeName -> "\<DOUBLE\>"]\[IndentingNewLine]}]; \), "\n", 
    \(SQLInsert[
      conn, \ "\<TEST\>", \ {"\<COL1\>", \ "\<COL2\>"}, \ \ {10, \ 
        10.5}]; \)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.1.6"],

Cell["This drops the table.", "Text",
  CellTags->"b:4.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLDropTable[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.1.6"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.1.6"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLTableNames", "MR"],
  " verifies that the table is removed from the database."
}], "Text",
  CellTags->"b:4.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.1.6"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.1.6"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:4.1.6"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.1.6"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SQL-Based Queries", "Subsection",
  CellTags->{"c:50", "xref:148"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"xref:37", "c:51", "b:4.2.0"}],

Cell[TextData[{
  "This section describes how to carry out database queries using raw SQL, \
rather than ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-based queries. SQL is more flexible than the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands and can be desirable for users who are already familiar with \
it."
}], "Text",
  CellTags->"b:4.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["SQLExecute", "Subsubsection",
  CellTags->{"xref:29", "c:52", "b:4.2.1"}],

Cell[TextData[{
  StyleBox["SQLExecute", "MR"],
  " allows SQL statements to be executed.  Statements can be used to select \
data, create tables, insert data, update data, remove data, and drop tables. \
The statement used by ",
  StyleBox["SQLExecute", "MR"],
  " is a string that can contain all arguments. However, it is also possible \
to give the arguments separately, which makes the statement a prepared \
statement. ",
  StyleBox["SQLExecute", "MR"],
  " can also be used to execute a batch of prepared statements with different \
arguments, as described in the ",
  ButtonBox["Batch Input",
    ButtonData:>{"DatabaseLink6.3.0", "xref:79"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:4.2.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["\<\"SQLExecute[\"\>",
                        "MR"], 
                      StyleBox["\<\"conn\"\>",
                        "TI"]}], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    StyleBox["statement",
                      "TI"], 
                    StyleBox[",",
                      "TI"], 
                    StyleBox[" ",
                      "TI"], 
                    RowBox[{
                      StyleBox[\(opts ... \),
                        "TI"], 
                      StyleBox["\<\"]\"\>",
                        "MR"], "\<\" \"\>"}]}], 
                  TraditionalForm]]], "\<\"execute an SQL statement\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLExecute[\"\>",
                      "MR"], 
                    StyleBox["\<\"conn, statement, {args..}, opts...\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"execute a prepared statement with \
arguments\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SQLExecute[\"\>",
                      "MR"], 
                    
                    StyleBox["\<\"conn, statement, {{args..}..}, opts...\"\>",
                      
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"execute a batch of prepared \
statements with different arguments\"\>"}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"S1.8.3", "b:4.2.1"}],

Cell["Executing SQL statements.", "Caption",
  CellTags->"b:4.2.1"],

Cell["\<\
The following sections show how to use SQL statements to carry out different \
types of manipulations.\
\>", "Text",
  CellTags->"b:4.2.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting Data", "Subsubsection",
  CellTags->{"xref:38", "c:53", "b:4.2.2"}],

Cell[TextData[{
  "The SQL command SELECT selects and returns data from a database. An \
alternative is to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLSelect",
    ButtonData:>{"DatabaseLink4.1.1", "xref:31"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[TextData[{
  "This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["publisher", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<publisher\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.2"],

Cell[TextData[{
  "This retrieves data within the table, ",
  StyleBox["ROYSCHED", "TI"],
  ", for which the data in the ",
  StyleBox["ROYALTY", "TI"],
  " column is in between 0.11 and 0.12."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT * FROM ROYSCHED WHERE ROYALTY >= .11 AND ROYALTY <= \
.12\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{"BS1011", 5001, 50000, 0.12`}, {"CP5018", 2001, 4000, 
        0.12`}, {"BS1001", 1001, 5000, 0.12`}, {"PY2002", 1001, 5000, 
        0.12`}, {"PY2003", 2001, 5000, 0.12`}, {"UK3004", 1001, 2000, 
        0.12`}, {"CK4005", 2001, 6000, 0.12`}, {"CP5010", 5001, 50000, 
        0.12`}, {"PY2012", 5001, 50000, 0.12`}, {"PY2013", 5001, 50000, 
        0.12`}, {"UK3006", 1001, 2000, 0.12`}, {"BS1014", 4001, 8000, 
        0.12`}, {"UK3015", 2001, 4000, 0.12`}, {"CK4016", 5001, 15000, 
        0.12`}, {"CK4017", 2001, 8000, 0.12`}, {"BS1007", 5001, 50000, 
        0.12`}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[TextData[{
  "This carries out the same SELECT statement but uses a prepared statement. \
The arguments to the statement are given as the third element of the ",
  StyleBox["SQLExecute", "MR"],
  " command. The first argument is placed in the location of the `1` and the \
second in the location of the `2`."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT * FROM ROYSCHED WHERE ROYALTY >= `1` AND ROYALTY <= \
`2`\>", {0.11, 0.12}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{"BS1011", 5001, 50000, 0.12`}, {"CP5018", 2001, 4000, 
        0.12`}, {"BS1001", 1001, 5000, 0.12`}, {"PY2002", 1001, 5000, 
        0.12`}, {"PY2003", 2001, 5000, 0.12`}, {"UK3004", 1001, 2000, 
        0.12`}, {"CK4005", 2001, 6000, 0.12`}, {"CP5010", 5001, 50000, 
        0.12`}, {"PY2012", 5001, 50000, 0.12`}, {"PY2013", 5001, 50000, 
        0.12`}, {"UK3006", 1001, 2000, 0.12`}, {"BS1014", 4001, 8000, 
        0.12`}, {"UK3015", 2001, 4000, 0.12`}, {"CK4016", 5001, 15000, 
        0.12`}, {"CK4017", 2001, 8000, 0.12`}, {"BS1007", 5001, 50000, 
        0.12`}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[TextData[{
  "Column and table names must be wrapped in ",
  StyleBox["SQLColumn", "MR"],
  " and ",
  StyleBox["SQLTable", "MR"],
  ", respectively. This will ensure they are not quoted as strings. The \
following selects elements of the ",
  StyleBox["ROYALTY", "TI"],
  " column in the ",
  StyleBox["ROYSCHED", "TI"],
  " table for which the ",
  StyleBox["TITLE_ID", "TI"],
  " column value is ",
  StyleBox["BS1011", "MR"],
  "."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>", \
{SQLColumn["\<ROYALTY\>"], "\<BS1011\>"}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0.1`}, {0.12`}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[TextData[{
  "If you want to give a sequence of arguments to a prepared statement, you \
can use ",
  StyleBox["SQLArgument", "MR"],
  ". This is described in the section on ",
  ButtonBox["Argument Sequences",
    ButtonData:>{"DatabaseLink6.0", "xref:46"},
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>", \
{SQLArgument[SQLColumn["\<LORANGE\>"], SQLColumn["\<HIRANGE\>"], 
          SQLColumn["\<ROYALTY\>"]], "\<BS1011\>"}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0, 5000, 0.1`}, {5001, 50000, 0.12`}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["\<\
Many databases offer functions that apply to the results of a select \
operation. Typical examples are COUNT, MIN, MAX, SUM, and AVG. The \
documentation for your database will describe the details of the functions \
that are available. The following examples demonstrate some of these \
functions.\
\>", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT COUNT(ROYALTY) FROM ROYSCHED\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{51}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT MIN(ROYALTY) FROM ROYSCHED\>"]\)], "Input",\

  CellLabel->"In[8]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0.1`}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["\<\
Many databases allow you to apply mathematical functions such as +, -, *, or \
/ to the results.\
\>", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT ROYALTY * 2 FROM ROYSCHED\>"]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0.2`}, {0.24`}, {0.2`}, {0.24`}, {0.32`}, {0.2`}, {0.24`}, {0.32`}, \
{0.36`}, {0.2`}, {0.2`}, {0.24`}, {0.28`}, {0.2`}, {0.24`}, {0.28`}, {0.2`}, \
{0.24`}, {0.28`}, {0.36`}, {0.4`}, {0.2`}, {0.24`}, {0.32`}, {0.32`}, {0.2`}, \
{0.24`}, {0.2`}, {0.24`}, {0.2`}, {0.24`}, {0.2`}, {0.24`}, {0.28`}, {0.36`}, \
{0.4`}, {0.2`}, {0.24`}, {0.28`}, {0.2`}, {0.24`}, {0.28`}, {0.32`}, {0.2`}, \
{0.24`}, {0.2`}, {0.24`}, {0.28`}, {0.2`}, {0.24`}, {0.2`}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT ROYALTY / 10 FROM ROYSCHED\>"]\)], "Input",\

  CellLabel->"In[10]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0.01`}, {0.012`}, {0.01`}, {0.012`}, {0.016`}, {0.01`}, {0.012`}, \
{0.016`}, {0.018`}, {0.01`}, {0.01`}, {0.012`}, {0.014000000000000002`}, \
{0.01`}, {0.012`}, {0.014000000000000002`}, {0.01`}, {0.012`}, \
{0.014000000000000002`}, {0.018`}, {0.02`}, {0.01`}, {0.012`}, {0.016`}, \
{0.016`}, {0.01`}, {0.012`}, {0.01`}, {0.012`}, {0.01`}, {0.012`}, {0.01`}, \
{0.012`}, {0.014000000000000002`}, {0.018`}, {0.02`}, {0.01`}, {0.012`}, \
{0.014000000000000002`}, {0.01`}, {0.012`}, {0.014000000000000002`}, \
{0.016`}, {0.01`}, {0.012`}, {0.01`}, {0.012`}, {0.014000000000000002`}, \
{0.01`}, {0.012`}, {0.01`}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT - ROYALTY FROM ROYSCHED\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.16`\)}, \
{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.16`\)}, {\(-0.18`\)}, {\(-0.1`\)}, \
{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.14`\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.14`\
\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.14`\)}, {\(-0.18`\)}, {\(-0.2`\)}, \
{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.16`\)}, {\(-0.16`\)}, {\(-0.1`\)}, {\(-0.12`\
\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.1`\)}, \
{\(-0.12`\)}, {\(-0.14`\)}, {\(-0.18`\)}, {\(-0.2`\)}, {\(-0.1`\)}, {\(-0.12`\
\)}, {\(-0.14`\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.14`\)}, {\(-0.16`\)}, \
{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.1`\)}, {\(-0.12`\)}, {\(-0.14`\)}, \
{\(-0.1`\)}, {\(-0.12`\)}, {\(-0.1`\)}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["You can also select only distinct values.", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT DISTINCT ROYALTY FROM ROYSCHED\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{0.1`}, {0.12`}, {0.14`}, {0.16`}, {0.18`}, {0.2`}}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["You can also group values.", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, "\<SELECT TITLE_ID,
     MIN(ROYALTY) FROM ROYSCHED GROUP BY TITLE_ID\>", 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TITLE_ID\"\>", "\<\"ROYALTY\"\>"},
          {"\<\"BS1011\"\>", "0.1`"},
          {"\<\"CP5018\"\>", "0.1`"},
          {"\<\"BS1001\"\>", "0.1`"},
          {"\<\"PS9999\"\>", "0.1`"},
          {"\<\"PY2002\"\>", "0.1`"},
          {"\<\"PY2003\"\>", "0.1`"},
          {"\<\"UK3004\"\>", "0.1`"},
          {"\<\"CK4005\"\>", "0.1`"},
          {"\<\"CP5010\"\>", "0.1`"},
          {"\<\"PY2012\"\>", "0.1`"},
          {"\<\"PY2013\"\>", "0.1`"},
          {"\<\"UK3006\"\>", "0.1`"},
          {"\<\"BS1014\"\>", "0.1`"},
          {"\<\"UK3015\"\>", "0.1`"},
          {"\<\"CK4016\"\>", "0.1`"},
          {"\<\"CK4017\"\>", "0.1`"},
          {"\<\"BS1007\"\>", "0.1`"},
          {"\<\"PY2008\"\>", "0.1`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[13]//TableForm=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["Many databases also support retrieving a range of results.  ", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT TOP 5 * FROM ROYSCHED\>"]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{"BS1011", 0, 5000, 0.1`}, {"BS1011", 5001, 50000, 0.12`}, {"CP5018", 
        0, 2000, 0.1`}, {"CP5018", 2001, 4000, 0.12`}, {"CP5018", 4001, 
        50000, 0.16`}}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT LIMIT 5 10 * FROM ROYSCHED\>"]\)], "Input",\

  CellLabel->"In[15]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{"BS1001", 0, 1000, 0.1`}, {"BS1001", 1001, 5000, 0.12`}, {"BS1001", 
        5001, 7000, 0.16`}, {"BS1001", 7001, 50000, 0.18`}, {"PS9999", 0, 
        50000, 0.1`}, {"PY2002", 0, 1000, 0.1`}, {"PY2002", 1001, 5000, 
        0.12`}, {"PY2002", 5001, 50000, 0.14`}, {"PY2003", 0, 2000, 
        0.1`}, {"PY2003", 2001, 5000, 0.12`}}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["\<\
More complex SELECT statements using INNER JOIN and OUTER JOIN can be used in \
a FROM clause to combine records from two tables.  \
\>", "Text",
  CellTags->"b:4.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<SELECT DISTINCT TITLES.TITLE FROM TITLES INNER JOIN ROYSCHED \
ON TITLES.TITLE_ID=ROYSCHED.TITLE_ID WHERE TITLES.PUB_ID='0877' AND \
ROYSCHED.ROYALTY > .1\>"]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \({{"Hamburger Again!"}, {"How to Burn a Compact Disk"}, {"Let Them Eat \
Cake!"}, {"Made to Wonder: Cooking the Macabre"}, {"Too Many Cooks"}, \
{"Treasures of the Sierra Madre"}}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
        conn, "\<SELECT T.TITLE, T.TITLE_ID, MIN(R.ROYALTY) FROM ROYSCHED R, \
TITLES T LEFT
OUTER JOIN ROYSCHED ON T.TITLE_ID = R.TITLE_ID GROUP BY T.TITLE, T.TITLE_ID
ORDER BY R.ROYALTY, T.TITLE DESC\>", ShowColumnHeadings \[Rule] True] // 
      TableForm\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"TITLE\"\>", "\<\"TITLE_ID\"\>", "\<\"ROYALTY\"\>"},
          {"\<\"Where Minds Meat: The Impact of Diet on Behavior\"\>", \
"\<\"PY2013\"\>", "0.1`"},
          {"\<\"Treasures of the Sierra Madre\"\>", "\<\"UK3015\"\>", 
            "0.1`"},
          {"\<\"Too Many Cooks\"\>", "\<\"CK4016\"\>", "0.1`"},
          {"\<\"The Net: Feeding Trolls and Eating Spam\"\>", \
"\<\"CP5009\"\>", "0.1`"},
          {"\<\"Taiwan Trails\"\>", "\<\"CP5010\"\>", "0.1`"},
          {"\<\"Sticky Software: UI and GUI\"\>", "\<\"CP5018\"\>", "0.1`"},
          {"\<\"Self Hypnosis: A Beginner's Guide\"\>", "\<\"PY2002\"\>", 
            "0.1`"},
          {"\<\"Phobic Psychology\"\>", "\<\"PY2003\"\>", "0.1`"},
          {"\<\"Modems for Morons\"\>", "\<\"BS1007\"\>", "0.1`"},
          {"\<\"Made to Wonder: Cooking the Macabre\"\>", "\<\"CK4005\"\>", 
            "0.1`"},
          {"\<\"Let Them Eat Cake!\"\>", "\<\"CK4017\"\>", "0.1`"},
          {"\<\"Know Thyself\"\>", "\<\"PY2012\"\>", "0.1`"},
          {"\<\"How to Burn a Compact Disk\"\>", "\<\"UK3006\"\>", "0.1`"},
          {"\<\"How Green Is My Valley?\"\>", "\<\"PY2008\"\>", "0.1`"},
          {"\<\"Hamburger Again!\"\>", "\<\"UK3004\"\>", "0.1`"},
          {"\<\"Guide to Impractical Databases\"\>", "\<\"BS1011\"\>", 
            "0.1`"},
          {"\<\"Exit Interviews\"\>", "\<\"BS1014\"\>", "0.1`"},
          {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", "0.1`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[17]//TableForm=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:4.2.2"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"b:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Tables", "Subsubsection",
  CellTags->{"xref:39", "c:54", "b:4.2.3"}],

Cell[TextData[{
  "The SQL command CREATE TABLE creates tables in a database. An alternative \
is to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLCreateTable",
    ButtonData:>{"DatabaseLink4.1.2", "xref:32"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[TextData[{
  "When creating a table, the result of ",
  StyleBox["SQLExecute", "MR"],
  " is an integer specifying the number of rows affected by the query.  If \
the table is created correctly, this integer will always be zero as no rows \
are affected when creating a new table."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[TextData[{
  "Here is an example that creates a table. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.3"],

Cell[TextData[{
  "When a table is created, options can be given to restrict how data is \
stored within the database. In the following, a table is created with four \
columns. The ",
  StyleBox["USERNAME", "TI"],
  " is a string-based column that cannot be ",
  StyleBox["Null", "MR"],
  " and is the primary key. (A primary key is important to a table as it \
uniquely identifies a row within the table.)  The other three columns (",
  StyleBox["ADDRESSES", "TI"],
  ", ",
  StyleBox["CITY", "TI"],
  ", and ",
  StyleBox["ZIPCODE)", "TI"],
  " are regular string-based columns. However, they must be unique among all \
rows."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ \[IndentingNewLine]"\<CREATE TABLE ADDRESSES (
    USERNAME VARCHAR NOT NULL PRIMARY KEY, 
    ADDRESS VARCHAR,
    CITY VARCHAR, 
    ZIPCODE VARCHAR, 
    UNIQUE (ADDRESS, CITY, ZIPCODE))\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[TextData[{
  "In this second example, a table with three columns is created. The first \
column is an integer that is an identity. This means that it is the primary \
key for the table and its value will be automatically incremented in each \
row. In other words, the value is not required when data is inserted; \
instead, the value will be the next available increment. The ",
  StyleBox["USERNAME", "TI"],
  " is a string-based column that is the foreign key to the ",
  StyleBox["ADDRESSES", "TI"],
  " table. The third column is a bit that has a default of 1 (i.e. if a value \
is not supplied when data is inserted it will be set to 1)."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<CREATE TABLE MAILER (
  MAILERID INT IDENTITY, 
  USERNAME VARCHAR NOT NULL, 
  SENDMAILER BIT DEFAULT '1' NOT NULL,
  FOREIGN KEY (USERNAME) REFERENCES ADDRESSES (USERNAME))\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLTableNames", "MR"],
  " verifies the tables exist in the database."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, "\<ADDRESSES\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \({"ADDRESSES"}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, "\<MAILER\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \({"MAILER"}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[TextData[{
  StyleBox["SQLColumnNames", "MR"],
  " verifies the columns were created in the database."
}], "Text",
  CellTags->"b:4.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ "\<ADDRESSES\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \({{"ADDRESSES", "USERNAME"}, {"ADDRESSES", "ADDRESS"}, {"ADDRESSES", 
        "CITY"}, {"ADDRESSES", "ZIPCODE"}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ "\<MAILER\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.2.3"],

Cell[BoxData[
    \({{"MAILER", "MAILERID"}, {"MAILER", "USERNAME"}, {"MAILER", 
        "SENDMAILER"}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell["This deletes the tables and closes the connection.", "Text",
  CellTags->"b:4.2.3"],

Cell[BoxData[{
    \(SQLExecute[conn, "\<DROP TABLE MAILER\>"]; \), "\n", 
    \(SQLExecute[conn, "\<DROP TABLE ADDRESSES\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.3"],

Cell["\<\
Other options may be available to you when creating tables depending on the \
database being used.  These are some examples showing what is possible.   See \
your database documentation for information on what options are specifically \
available.  \
\>", "Text",
  CellTags->"b:4.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inserting Data", "Subsubsection",
  CellTags->{"xref:40", "c:55", "b:4.2.4"}],

Cell[TextData[{
  "The SQL command INSERT inserts data into a database. An alternative is to \
use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLInsert",
    ButtonData:>{"DatabaseLink4.1.3", "xref:33"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[TextData[{
  "When inserting data, the result of ",
  StyleBox["SQLExecute", "MR"],
  " is an integer specifying the number of rows affected by the query."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[TextData[{
  "Here is an example that inserts data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.4"],

Cell[TextData[{
  "As discussed in the ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.2.3", "xref:39"},
    ButtonStyle->"AddOnsLinkText"],
  " example, the ",
  StyleBox["ADDRESSES", "TI"],
  " and ",
  StyleBox["MAILER", "TI"],
  " tables should be created."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[BoxData[{
    \(SQLExecute[conn, \ \[IndentingNewLine]"\<CREATE TABLE ADDRESSES (
    USERNAME VARCHAR NOT NULL PRIMARY KEY, 
    ADDRESS VARCHAR,
    CITY VARCHAR, 
    ZIPCODE VARCHAR, 
    UNIQUE (ADDRESS, CITY, ZIPCODE))\>"]; \), "\n", 
    \(SQLExecute[conn, \ "\<CREATE TABLE MAILER (
  MAILERID INT IDENTITY, 
  USERNAME VARCHAR NOT NULL, 
  SENDMAILER BIT DEFAULT '1' NOT NULL,
  FOREIGN KEY (USERNAME) REFERENCES ADDRESSES (USERNAME))\>"]; \)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.4"],

Cell[TextData[{
  "This demonstrates an SQL statement that inserts a row into the ",
  StyleBox["ADDRESSES", "TI"],
  " table. "
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<INSERT INTO ADDRESSES (USERNAME, \
ADDRESS, CITY, ZIPCODE) VALUES 
     ('user1', '100 Trade Center', 'Champaign, IL', '61820')\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \({{"user1", "100 Trade Center", "Champaign, IL", "61820"}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["USERNAME", "TI"],
  " column is made to be a primary key, which means that it must be unique. \
If you try to insert the same data again, there is an error and the result is \
",
  StyleBox["$Failed", "MR"],
  "."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<INSERT INTO ADDRESSES (USERNAME, \
ADDRESS, CITY, ZIPCODE) VALUES 
     ('user1', '100 Trade Center', 'Champaign, IL', '61820')\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(JDBC::"error" \(\(:\)\(\ \)\) 
      "JDBC error: \!\(\"Unique constraint violation:  in st\"\[Ellipsis]\" \
Center', 'Champaign, IL', '61820')]\"\)"\)], "Message",
  CellLabel->"From In[7]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "This makes the ",
  StyleBox["USERNAME", "TI"],
  " parameter unique but not the ",
  StyleBox["ADDRESS", "TI"],
  ", ",
  StyleBox["CITY", "TI"],
  ", and ",
  StyleBox["ZIPCODE", "TI"],
  " entries. These must also be unique and again there is an error."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<INSERT INTO ADDRESSES (USERNAME, \
ADDRESS, CITY, ZIPCODE) VALUES 
     ('user2', '100 Trade Center', 'Champaign, IL', '61820')\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(JDBC::"error" \(\(:\)\(\ \)\) 
      "JDBC error: \!\(\"Unique constraint violation: SYS_CT\"\[Ellipsis]\" \
Center', 'Champaign, IL', '61820')]\"\)"\)], "Message",
  CellLabel->"From In[8]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "This inserts unique values of ",
  StyleBox["ADDRESS", "TI"],
  ", ",
  StyleBox["CITY", "TI"],
  ", and ",
  StyleBox["ZIPCODE", "TI"],
  "."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<INSERT INTO ADDRESSES (USERNAME, \
ADDRESS, CITY, ZIPCODE) VALUES 
     ('user2', '200 Trade Center', 'Champaign, IL', '61820')\>"]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \({{"user1", "100 Trade Center", "Champaign, IL", "61820"}, {"user2", 
        "200 Trade Center", "Champaign, IL", "61820"}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "A prepared statement may be more useful for working with data to insert. \
In addition, ",
  StyleBox["SQLArgument", "MR"],
  " may be useful to reduce the number of arguments fields in the prepared \
statement. ",
  StyleBox["SQLArgument", "MR"],
  " is described in the ",
  ButtonBox["Argument Sequences",
    ButtonData:>{"DatabaseLink6.0", "xref:46"},
    ButtonStyle->"AddOnsLinkText"],
  " section."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \[IndentingNewLine]\ \ "\<INSERT INTO ADDRESSES (USERNAME, \
ADDRESS, CITY, ZIPCODE) VALUES 
     (`1`)\>", \ {SQLArgument["\<user3\>", "\<300 Trade Center\>", \
"\<Champaign, IL\>", "\<61820\>"]}]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \({{"user1", "100 Trade Center", "Champaign, IL", "61820"}, {"user2", 
        "200 Trade Center", "Champaign, IL", "61820"}, {"user3", 
        "300 Trade Center", "Champaign, IL", "61820"}}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "Identity columns are very useful as they automatically increment their \
values and do not require a value. They are also the primary key for the \
table, which means they uniquely identify a row. Identity values should be \
set to ",
  StyleBox["Null", "MR"],
  " in a SQL statement.  "
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLColumnNames[conn, \ "\<MAILER\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \({{"MAILER", "MAILERID"}, {"MAILER", "USERNAME"}, {"MAILER", 
        "SENDMAILER"}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(NULL, 'user1', 0)\>"]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM MAILER\>"]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \({{0, "user1", False}}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "Since ",
  StyleBox["USERNAME", "TI"],
  " is a foreign key, its value must be present in ",
  StyleBox["ADDRESSES", "TI"],
  ". The following fails because ",
  StyleBox["user4", "MR"],
  " is not present in ",
  StyleBox["ADDRESSES", "TI"],
  "."
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(NULL, 'user4', 0)\>"]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(JDBC::"error" \(\(:\)\(\ \)\) 
      "JDBC error: \!\(\"Integrity constraint violation - \
no\"\[Ellipsis]\"NDMAILER) VALUES (NULL, 'user4', 0)]\"\)"\)], "Message",
  CellLabel->"From In[16]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["SENDMAILER", "TI"],
  " column has a default value and is therefore not required when data is \
inserted.  "
}], "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ "\<INSERT INTO MAILER (MAILERID, USERNAME) VALUES (NULL, \
'user2')\>"]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data exists in the database and ties the \
values together.  \
\>", "Text",
  CellTags->"b:4.2.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
        conn, \ "\<SELECT USERNAME, ADDRESS, CITY, ZIPCODE, SENDMAILER FROM \
ADDRESSES, MAILER WHERE ADDRESSES.USERNAME = MAILER.USERNAME\>", \ 
        ShowColumnHeadings \[Rule] True] // TableForm\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"b:4.2.4"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"USERNAME\"\>", "\<\"ADDRESS\"\>", "\<\"CITY\"\>", \
"\<\"ZIPCODE\"\>", "\<\"SENDMAILER\"\>"},
          {"\<\"user1\"\>", "\<\"100 Trade Center\"\>", "\<\"Champaign, \
IL\"\>", "\<\"61820\"\>", "False"},
          {"\<\"user2\"\>", "\<\"200 Trade Center\"\>", "\<\"Champaign, \
IL\"\>", "\<\"61820\"\>", "False"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[18]//TableForm=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell["This deletes the tables and closes the connection.", "Text",
  CellTags->"b:4.2.4"],

Cell[BoxData[{
    \(SQLExecute[conn, "\<DROP TABLE MAILER\>"]; \), "\n", 
    \(SQLExecute[conn, "\<DROP TABLE ADDRESSES\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:4.2.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Updating Data", "Subsubsection",
  CellTags->{"xref:41", "c:56", "b:4.2.5"}],

Cell[TextData[{
  "The SQL command UPDATE updates data in a database. An alternative is to \
use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLUpdate",
    ButtonData:>{"DatabaseLink4.1.4", "xref:34"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.5"],

Cell[TextData[{
  "When updating data, the result of ",
  StyleBox["SQLExecute", "MR"],
  " is an integer specifying the number of rows affected by the query."
}], "Text",
  CellTags->"b:4.2.5"],

Cell[TextData[{
  "Here is an example that updates data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.5"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.5"],

Cell[TextData[{
  "As discussed in the ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.2.3", "xref:39"},
    ButtonStyle->"AddOnsLinkText"],
  " example, the ",
  StyleBox["ADDRESSES", "TI"],
  " and ",
  StyleBox["MAILER", "TI"],
  " tables should be created."
}], "Text",
  CellTags->"b:4.2.5"],

Cell[BoxData[{
    \(SQLExecute[conn, \ \[IndentingNewLine]"\<CREATE TABLE ADDRESSES (
    USERNAME VARCHAR NOT NULL PRIMARY KEY, 
    ADDRESS VARCHAR,
    CITY VARCHAR, 
    ZIPCODE VARCHAR, 
    UNIQUE (ADDRESS, CITY, ZIPCODE))\>"]; \), "\n", 
    \(SQLExecute[conn, \ "\<CREATE TABLE MAILER (
  MAILERID INT IDENTITY, 
  USERNAME VARCHAR NOT NULL, 
  SENDMAILER BIT DEFAULT '1' NOT NULL,
  FOREIGN KEY (USERNAME) REFERENCES ADDRESSES (USERNAME))\>"]; \), "\n", 
    \(SQLExecute[
      conn, "\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) \
VALUES (`1`)\>", \[IndentingNewLine]{{SQLArgument["\<user1\>", "\<100 Trade \
Center\>", "\<Champaign, IL\>", "\<61820\>"]}, {SQLArgument["\<user2\>", \
"\<200 Trade Center\>", "\<Champaign, IL\>", "\<61820\>"]}, \
{SQLArgument["\<user3\>", "\<300 Trade Center\>", "\<Champaign, IL\>", \
"\<61820\>"]}}\[IndentingNewLine]]; \), "\n", 
    \(SQLExecute[
      conn, "\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(`1`)\>", \[IndentingNewLine]{{SQLArgument[Null, "\<user1\>", 
            False]}, \[IndentingNewLine]{SQLArgument[Null, "\<user2\>", 
            False]}}\[IndentingNewLine]]; \)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.5"],

Cell[TextData[{
  "This executes an SQL statement that updates a row in the ",
  StyleBox["MAILER", "TI"],
  " table. This query updates the ",
  StyleBox["SENDMAILER", "TI"],
  " column based on the value of ",
  StyleBox["USERNAME", "TI"],
  ".  Many update statements may be created using conditions that work with \
values in columns."
}], "Text",
  CellTags->"b:4.2.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<UPDATE MAILER SET SENDMAILER = 1 \
WHERE USERNAME = 'user1'\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
  CellTags->"b:4.2.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM MAILER\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \({{0, "user1", True}, {1, "user2", False}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell[TextData[{
  "Using prepared statements, you can dynamically create SQL statements that \
update data within the database. You can combine this with a simple ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. This example updates the address for a particular user.  "
}], "Text",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \(SetAddress[username_String, \ 
        address_String] := \[IndentingNewLine]SQLExecute[
        conn, \ \[IndentingNewLine]\ \ "\<UPDATE ADDRESSES SET ADDRESS = `2` \
WHERE USERNAME = `1`\>", \ {username, \ address}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetAddress["\<user1\>", \ "\<100 Trade Center Office 123\>"]\)], "Input",\

  CellLabel->"In[10]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
  CellTags->"b:4.2.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \({{"user1", "100 Trade Center Office 123", "Champaign, IL", 
        "61820"}, {"user2", "200 Trade Center", "Champaign, IL", 
        "61820"}, {"user3", "300 Trade Center", "Champaign, IL", 
        "61820"}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell["\<\
The same restrictions that apply to inserts also apply to updates. Thus, if \
you try to update an ADDRESS value to equal the ADDRESS value of another row, \
an error will be returned; this table requires them to be unique.\
\>", "Text",
  CellTags->"b:4.2.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetAddress["\<user1\>", \ "\<200 Trade Center\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \(JDBC::"error" \(\(:\)\(\ \)\) 
      "JDBC error: \!\(\"Unique constraint violation: SYS_CT\"\[Ellipsis]\" \
SET ADDRESS = ? WHERE USERNAME = ?]\"\)"\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"b:4.2.5"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell["This deletes the tables and closes the connection.", "Text",
  CellTags->"b:4.2.5"],

Cell[BoxData[{
    \(SQLExecute[conn, "\<DROP TABLE MAILER\>"]; \), "\n", 
    \(SQLExecute[conn, "\<DROP TABLE ADDRESSES\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deleting Data", "Subsubsection",
  CellTags->{"xref:42", "c:57", "b:4.2.6"}],

Cell[TextData[{
  "The SQL command DELETE deletes data from a database. An alternative is to \
use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLDelete",
    ButtonData:>{"DatabaseLink4.1.5", "xref:35"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[TextData[{
  "When deleting data, the result of ",
  StyleBox["SQLExecute", "MR"],
  " is an integer specifying the number of rows affected by the query."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[TextData[{
  "Here is an example that removes data. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.6"],

Cell[TextData[{
  "As discussed in the ",
  ButtonBox["Creating Tables",
    ButtonData:>{"DatabaseLink4.2.3", "xref:39"},
    ButtonStyle->"AddOnsLinkText"],
  " example, the ",
  StyleBox["ADDRESSES", "TI"],
  " and ",
  StyleBox["MAILER", "TI"],
  " tables should be created."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[BoxData[{
    \(SQLExecute[conn, \ \[IndentingNewLine]"\<CREATE TABLE ADDRESSES (
    USERNAME VARCHAR NOT NULL PRIMARY KEY, 
    ADDRESS VARCHAR,
    CITY VARCHAR, 
    ZIPCODE VARCHAR, 
    UNIQUE (ADDRESS, CITY, ZIPCODE))\>"]; \), "\n", 
    \(SQLExecute[conn, \ "\<CREATE TABLE MAILER (
  MAILERID INT IDENTITY, 
  USERNAME VARCHAR NOT NULL, 
  SENDMAILER BIT DEFAULT '1' NOT NULL,
  FOREIGN KEY (USERNAME) REFERENCES ADDRESSES (USERNAME))\>"]; \), "\n", 
    \(SQLExecute[
      conn, "\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) \
VALUES (`1`)\>", \[IndentingNewLine]{{SQLArgument["\<user1\>", "\<100 Trade \
Center\>", "\<Champaign, IL\>", "\<61820\>"]}, {SQLArgument["\<user2\>", \
"\<200 Trade Center\>", "\<Champaign, IL\>", "\<61820\>"]}, \
{SQLArgument["\<user3\>", "\<300 Trade Center\>", "\<Champaign, IL\>", \
"\<61820\>"]}}\[IndentingNewLine]]; \), "\n", 
    \(SQLExecute[
      conn, "\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(`1`)\>", \[IndentingNewLine]{{SQLArgument[Null, "\<user1\>", 
            False]}, \[IndentingNewLine]{SQLArgument[Null, "\<user2\>", 
            True]}}\[IndentingNewLine]]; \)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.6"],

Cell[TextData[{
  "Here are the contents of the ",
  StyleBox["ADDRESSES", "TI"],
  " table."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \({{"user1", "100 Trade Center", "Champaign, IL", "61820"}, {"user2", 
        "200 Trade Center", "Champaign, IL", "61820"}, {"user3", 
        "300 Trade Center", "Champaign, IL", "61820"}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell[TextData[{
  "Here are the contents of the ",
  StyleBox["MAILER", "TI"],
  " table."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM MAILER\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \({{0, "user1", False}, {1, "user2", True}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell[TextData[{
  "This executes an SQL statement that deletes a row in the ",
  StyleBox["MAILER", "TI"],
  " table. It deletes any rows for which the value in the ",
  StyleBox["SENDMAILER", "TI"],
  " column is 0 (or ",
  StyleBox["False", "MR"],
  "). Delete statements can be created using conditions that depend on the \
values in columns. Since one row has been deleted, the result is 1."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[
      conn, \ \[IndentingNewLine]\ \ "\<DELETE FROM MAILER WHERE SENDMAILER = \
0\>"]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM MAILER\>"]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \({{1, "user2", True}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell[TextData[{
  "Using prepared statements, you can dynamically create SQL statements that \
delete data within the database. You can combine this with a simple ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. This example deletes an address for a particular user.  "
}], "Text",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \(DeleteAddress[username_String] := \[IndentingNewLine]SQLExecute[
        conn, \ \[IndentingNewLine]\ \ "\<DELETE FROM ADDRESSES WHERE \
USERNAME = `1`\>", \ {username}]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeleteAddress["\<user3\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<SELECT * FROM ADDRESSES\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \({{"user1", "100 Trade Center", "Champaign, IL", "61820"}, {"user2", 
        "200 Trade Center", "Champaign, IL", "61820"}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell[TextData[{
  "Any restrictions on the values in tables also apply when data is deleted. \
Thus, if you try to delete an ",
  StyleBox["ADDRESS", "TI"],
  " value that is referenced by an item in the ",
  StyleBox["MAILER", "TI"],
  " table, an error occurs."
}], "Text",
  CellTags->"b:4.2.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeleteAddress["\<user2\>"]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \(JDBC::"error" \(\(:\)\(\ \)\) 
      "JDBC error: \!\(\"Integrity constraint violation SYS_\"\[Ellipsis]\"E \
FROM ADDRESSES WHERE USERNAME = ?]\"\)"\)], "Message",
  CellLabel->"From In[14]:=",
  CellTags->"b:4.2.6"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell["This deletes the tables and closes the connection.", "Text",
  CellTags->"b:4.2.6"],

Cell[BoxData[{
    \(SQLExecute[conn, "\<DROP TABLE MAILER\>"]; \), "\n", 
    \(SQLExecute[conn, "\<DROP TABLE ADDRESSES\>"]; \), "\n", 
    \(CloseSQLConnection[conn]\)}], "Input",
  CellLabel->"In[15]:=",
  CellTags->"b:4.2.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Dropping Tables", "Subsubsection",
  CellTags->{"xref:43", "c:58", "b:4.2.7"}],

Cell[TextData[{
  "The SQL command DROP TABLE drops tables from a database. An alternative is \
to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  ButtonBox["SQLDropTable",
    ButtonData:>{"DatabaseLink4.1.6", "xref:36"},
    ButtonStyle->"AddOnsLink"],
  ". If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.2.7"],

Cell[TextData[{
  "When dropping a table, the result of ",
  StyleBox["SQLExecute", "MR"],
  " will be ",
  StyleBox["$Failed", "MR"],
  " if there is an error."
}], "Text",
  CellTags->"b:4.2.7"],

Cell[TextData[{
  "Here is an example that drops a table. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.2.7"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.2.7"],

Cell["A simple table is created and two rows are inserted.", "Text",
  CellTags->"b:4.2.7"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SQLExecute[
      conn, \ \[IndentingNewLine]"\<CREATE TABLE TEST (COL1 INTEGER, COL2 \
INTEGER)\>"]; \), "\n", 
    \(SQLExecute[
      conn, "\<INSERT INTO TEST (COL1, COL2) VALUES (`1`)\>", \
\[IndentingNewLine]{{SQLArgument[5, 6]}, {SQLArgument[7, 
            9]}}\[IndentingNewLine]]; \), "\n", 
    \(SQLExecute[conn, "\<SELECT * FROM TEST\>"]\)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.2.7"],

Cell[BoxData[
    \({{5, 6}, {7, 9}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:4.2.7"]
}, Closed]],

Cell[TextData[{
  "An SQL statement that drops the ",
  StyleBox["TEST", "TI"],
  " table is executed.  "
}], "Text",
  CellTags->"b:4.2.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLExecute[conn, \ "\<DROP TABLE TEST\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.2.7"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:4.2.7"]
}, Closed]],

Cell[TextData[{
  "This confirms that the ",
  StyleBox["TEST", "TI"],
  " table is no longer in the database."
}], "Text",
  CellTags->"b:4.2.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLTableNames[conn, \ "\<TEST\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:4.2.7"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:4.2.7"]
}, Closed]],

Cell["This closes the connection.", "Text",
  CellTags->"b:4.2.7"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:4.2.7"],

Cell["\<\
It should be noted that it is not permitted to drop a table that is \
referenced by another.\
\>", "Text",
  CellTags->"b:4.2.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Subsection",
  CellTags->{"xref:44", "c:59", "b:4.3"}],

Cell[TextData[{
  "There are a number of options that can be given to ",
  StyleBox["SQLExecute", "MR"],
  ", ",
  StyleBox["SQLCreateTable", "MR"],
  ", ",
  StyleBox["SQLDropTable", "MR"],
  ", ",
  StyleBox["SQLInsert", "MR"],
  ", ",
  StyleBox["SQLDelete", "MR"],
  ", ",
  StyleBox["SQLSelect", "MR"],
  ", and ",
  StyleBox["SQLUpdate", "MR"],
  ". ",
  "If you find that the examples in this section do not work as shown, you \
may need to install or restore the example database with the ",
  ButtonBox["DatabaseExamples`",
    ButtonData:>{"DatabaseLink9.1", "xref:62"},
    ButtonStyle->"AddOnsLink"],
  " package."
}], "Text",
  CellTags->"b:4.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"GetAsStrings\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"return the results as \
strings\"\>"},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"MaxRows\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"set the maximum number of rows \
returned\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ShowColumnHeadings\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"return the columns with the \
results\"\>"},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Timeout\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], 
                  TraditionalForm]]], "\<\"set the timeout for a query\"\>"}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"S5.27.1", "b:4.3"}],

Cell[TextData[{
  "Options of ",
  StyleBox["SQLExecute", "MR"],
  "."
}], "Caption",
  CellTags->"b:4.3"],

Cell[TextData[{
  "Here is an example of these options. This loads ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and connects to the ",
  StyleBox["demo", "TI"],
  " database."
}], "Text",
  CellTags->"b:4.3"],

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(conn\  = \ OpenSQLConnection[\ "\<demo\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:4.3"],

Cell[TextData[{
  "The option ",
  StyleBox["GetAsStrings", "MR"],
  " can retrieve data without converting it to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " type. This can be used with ",
  StyleBox["SQLExecute", "MR"],
  " and ",
  StyleBox["SQLSelect", "MR"],
  "."
}], "Text",
  CellTags->"b:4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<SAMPLETABLE1\>", \ GetAsStrings \[Rule] True] // 
      InputForm\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:4.3"],

Cell["\<\
{{\"1\", \"5.6\", \"Day1\"}, {\"2\", \"5.9\", \"Day2\"}, 
 {\"3\", \"7.2\", \"Day3\"}, {\"4\", \"6.2\", \"Day4\"}, 
 {\"5\", \"6.0\", \"Day5\"}}\
\>", "Output",
  CellLabel->"Out[3]//InputForm=",
  CellTags->"b:4.3"]
}, Closed]],

Cell[TextData[{
  "The option ",
  StyleBox["MaxRows", "MR"],
  " can limit the number of rows returned. This can be used with ",
  StyleBox["SQLExecute", "MR"],
  " and ",
  StyleBox["SQLSelect", "MR"],
  "."
}], "Text",
  CellTags->"b:4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<SAMPLETABLE1\>", \ MaxRows \[Rule] 2]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:4.3"],

Cell[BoxData[
    \({{1, 5.6`, "Day1"}, {2, 5.9`, "Day2"}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:4.3"]
}, Closed]],

Cell[TextData[{
  "The option ",
  StyleBox["ShowColumnHeadings", "MR"],
  " can retrieve the column headings with the results. This can be used with \
",
  StyleBox["SQLExecute", "MR"],
  " and ",
  StyleBox["SQLSelect", "MR"],
  "."
}], "Text",
  CellTags->"b:4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SQLSelect[conn, \ "\<SAMPLETABLE1\>", \ 
        ShowColumnHeadings \[Rule] True]\  // TableForm\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:4.3"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
          {"1", "5.6`", "\<\"Day1\"\>"},
          {"2", "5.9`", "\<\"Day2\"\>"},
          {"3", "7.2`", "\<\"Day3\"\>"},
          {"4", "6.2`", "\<\"Day4\"\>"},
          {"5", "6.`", "\<\"Day5\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//TableForm=",
  CellTags->"b:4.3"]
}, Closed]],

Cell[TextData[{
  "The option ",
  StyleBox["Timeout", "MR"],
  " can be used to cancel a query if it takes too long to execute. ",
  StyleBox["SQLExecute", "MR"],
  ", ",
  StyleBox["SQLCreateTable", "MR"],
  ", ",
  StyleBox["SQLDropTable", "MR"],
  ", ",
  StyleBox["SQLInsert", "MR"],
  ", ",
  StyleBox["SQLDelete", "MR"],
  ", ",
  StyleBox["SQLSelect", "MR"],
  ", and ",
  StyleBox["SQLUpdate", "MR"],
  " can each use the ",
  StyleBox["Timeout", "MR"],
  " option."
}], "Text",
  CellTags->"b:4.3"],

Cell["This closes the connection.", "Text",
  CellTags->"b:4.3"],

Cell[BoxData[
    \(CloseSQLConnection[conn]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:4.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Database Explorer", "Section",
  CellTags->{"xref:55", "c:60"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"xref:139", "c:61", "i:44", "b:5.0"}],

Cell[TextData[{
  "The Database Explorer is a graphical interface to ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  ". It provides a number of useful functions, such as managing connections \
and working with the data in a database. It can be launched by loading ",
  StyleBox["DatabaseLink",
    FontSlant->"Italic"],
  " and executing the command ",
  StyleBox["DatabaseExplorer[]", "MR"],
  "."
}], "Text",
  CellTags->"b:5.0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Needs["\<DatabaseLink`\>"]; \), "\n", 
    \(DatabaseExplorer[]\)}], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:5.0"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject551504855433217, 
        JLink`Objects`JavaObject497998857502721]]], "Output",
  CellLabel->"Out[18]=",
  CellTags->"b:5.0"]
}, Closed]],

Cell["\<\
On Windows it appears as follows.
\
\>", "Text",
  CellTags->"b:5.0"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007X0001_B000`400?l00000o`00003oo`1VIWkY
06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?gU0?_lo@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^n@0
Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0o`1VIWkS06IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`3ooooQ0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWko09bLW^00W9bN00@0oooo06IVOP2XZK/0nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2L
W9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk
06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh00006
06IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooo`3Pgn?M0>3Oh`0509bLWP3oool0IVIn0:RY^`3k
o?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0ooooW@3Pgn<00`000000h=oS0>3Oh`3o0>3O
hcd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3o
oonM0>3Oh`030000003Pgn<0h=oS0?l0h=oS?@3Pgn<01@2LW9h0oooo06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0W9bN0?ooo`H0h=oS0`0000030>3Oh`<000000P3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03000000<0h=oS0`000002
0>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`000000
103Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS0`0000020>3Oh`8000001@3Pgn<010000000
h=oS0>3Oh`3Pgn<3000000<0h=oS0P000000103Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0
h=oS0080000000D0h=oS0000003Pgn<0h=oS000000070>3Oh`030000003Pgn<0h=oS00<0h=oS00<0
00000>3Oh`3Pgn<00`0000030>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`0000030>3Oh`<00000
1P3Pgn<300000080h=oS00@000000>3Oh`00000000000`3Pgn<300000080h=oS00D000000>3Oh`3P
gn<0h=oS000000050>3Oh`80000000<0h=oS0000003Pgn<0103Pgn<3000000<0h=oS0`0000020>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0h=oS00<000000`3P
gn<300000080h=oS0P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D000000>3Oh`3Pgn<0
h=oS000000020>3Oh`030000003Pgn<0h=oS0>P0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3oool50>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000060>3Oh`040000003Pgn<0h=oS
000000<0h=oS00<000000>3Oh`0000000P3Pgn<2000000030>3Oh`000000h=oS0080h=oS00<00000
0>3Oh`0000000P3Pgn<2000000X0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS00000003
0>3Oh`030000003Pgn<000000080h=oS0P0000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`800000
0P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`02000000@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`3[0>3Oh`0509bLWP3oool0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP2LW9h0oooo103Pgn<00`000000h=oS0>3O
h`040>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`030>3Oh`060000003Pgn<0h=oS0000
003Pgn<000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0080h=oS00L00000
0>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000001P3Pgn<010000000h=oS
0>3Oh`0000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS00P0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000
h=oS000000050>3Oh`050000003Pgn<0h=oS0>3Oh`000000103Pgn<010000000h=oS0>3Oh`000008
0>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000D0h=oS
00D000000>3Oh`3Pgn<0h=oS000000040>3Oh`050000003Pgn<0h=oS0>3Oh`000000103Pgn<00`00
0000h=oS0>3Oh`030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`030>3Oh`060000003P
gn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0>/0
h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3oool4
0>3Oh`030000003Pgn<0h=oS00@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000004000000030>3Oh`000000h=oS00@0h=oS
00H000000>3Oh`3Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<00P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00060>3Oh`040000003Pgn<0h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0203Pgn<400000080h=oS
00<000000>3Oh`000000100000020>3Oh`@000000P3Pgn<2000000<0h=oS1@0000040>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000@0000000<0h=oS0000
003Pgn<00P3Pgn<00`000000h=oS0>3Oh`030>3Oh`@00000103Pgn<00`000000h=oS0>3Oh`030>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<0
00000>3Oh`000000100000000`3Pgn<000000>3Oh`040>3Oh`060000003Pgn<0h=oS0000003Pgn<0
00000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0>/0h=oS00D0W9bN0?ooo`1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3oool40>3Oh`030000003Pgn<0
h=oS00@0h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00@000000>3Oh`000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000P3Pgn<00`000000h=oS000000030>3Oh`040000003Pgn<0000000000080h=oS00<000000>3O
h`3Pgn<00P3Pgn<200000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000060>3O
h`040000003Pgn<0h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS00000000
00020>3Oh`030000003Pgn<000000080h=oS0P00000:0>3Oh`090000003Pgn<0h=oS0>3Oh`000000
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`040000003Pgn<0000000000080h=oS
00<000000>3Oh`3Pgn<00P3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000@0h=oS00L000000>3Oh`3P
gn<0h=oS0000003Pgn<0000000<0h=oS00@000000>3Oh`00000000000P3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000020>3Oh`030000003Pgn<0000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000
h=oS0>3Oh`3[0>3Oh`0509bLWP3oool0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IV
OP2LW9h0oooo103Pgn<00`000000h=oS0>3Oh`050>3Oh`<000000P3Pgn<010000000h=oS00000000
00020>3Oh`040000003Pgn<00000000000<0h=oS0`0000030>3Oh`<0000000H0h=oS000000000000
00000>3Oh`0000020>3Oh`<000000P3Pgn<010000000h=oS0000000000050>3Oh`040000003Pgn<0
0000000000<0h=oS0`000000103Pgn<000000000000000040>3Oh`<000000P3Pgn<300000080h=oS
00P000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`8000000`3Pgn<2000000030>3Oh`000000
h=oS00T0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<000000080h=oS0`0000030>3Oh`<00000
0`3Pgn<3000000<0h=oS0`0000060>3Oh`<000000P3Pgn<010000000h=oS0000000000030>3Oh`<0
00000P3Pgn<010000000h=oS0000000000060>3Oh`<000001P3Pgn<3000000<0h=oS0`0000020>3O
h`040000003Pgn<0000000000080h=oS00@000000>3Oh`00000000000`3Pgn<3000000<0h=oS0`00
00001P3Pgn<00000000000000000h=oS00000080h=oS0`0000020>3Oh`040000003Pgn<000000000
0>h0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3o
ool50>3Oh`050000003Pgn<0h=oS0>3Oh`0000007`3Pgn<00`000000h=oS0>3Oh`0M0>3Oh`030000
003Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<05P3Pgn<00`000000h=oS0>3Oh`080>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS0000001T0>3Oh`030000003Pgn<0h=oS0?X0h=oS00D0W9bN0?oo
o`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3oool60>3Oh`<00000803P
gn<010000000h=oS0>3Oh`00000L0>3Oh`030000003Pgn<0h=oS00D0h=oS00<000000>3Oh`3Pgn<0
5@3Pgn<00`000000h=oS0>3Oh`080>3Oh`@000000P3Pgn<00`000000h=oS0>3Oh`1R0>3Oh`040000
003Pgn<0h=oS00000?T0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn
0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk
0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN0?ooo`1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS00D0W9bN
0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3Ohmd0h=oS
00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn09bLWP3ooooo0>3O
hmd0h=oS00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn09bLWP3o
0?ooomh0oooo00D0W9bN0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`2L
W9kP09bLWP040?ooo`1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Ohn40h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT08d0lNoR0`3Pgn<00`1aKf@0lNoR0?7_hP3o0?7_hTd0lNoR
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS
0>3Oh`3Pgn<0LFmT0?l0h=oSCP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01P3Pgn<00`3M`Xd0i9Ll0>J;;00U
0>J;;0030>^G;P3QaXh0h=oS0?l0h=oS7@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3QaXh0kYla
0?^n>@0V0?o8?0030?Vi>03^Wc40hLJ>0?l0h=oS7@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3M
XE<0nKPh0?o7?00W0?o7?0050?Vh>03MXE<0h=oS0<SAc@2Q/k/08P2AYk@00`2Y^Kl0d=K@0>3Oh`3d
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0h=oS00D0
lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`03096KW03lo?h0o?cn01d0o?cn00<000000?cloP3lo?h0
203lo?h0102AVi`0d=K@0;K4c@3]lO<R0?ooo`030>CYk02fa<d0d=K@0?@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0
LFmT00D0h=oS00<0TI^L0?cloP3lo?h07P3lo?h00`000000o?cn0?cloP070?cloP04096KW02Y^Kl0
hnW[0?knoB80oooo00<0o_kn0>?Yk02Y^Kl0m03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`2AVi`0
o?cn0?cloP060?cloP<0000000@0o?cn0000003lo?h0o?cn0P000000103lo?h000000?cloP3lo?h3
00000080o?cn00<000000?cloP3lo?h00`3lo?h00`000000o?cn0?cloP070?cloP03096KW02AYk@0
m_Cb02@0oooo00<0oOgl096W]03Pgn<0l`3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`2AVi`0o?cn
0?cloP050?cloP050000003lo?h0o?cn0?cloP0000000P3lo?h00`000000o?cn0?cloP0200000003
0?cloP000000o?cn0080o?cn00<000000?cloP0000001@3lo?h00`000000o?cn0?cloP070?cloP03
096KW02AYk@0oooo02D0oooo00<0TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<0
0`2AVi`0o?cn0?cloP040?cloP030000003lo?h0o?cn0080000000@0o?cn0000003lo?h000000`3l
o?h00`000000o?cn000000050?cloP030000003lo?h0o?cn0080o?cn00<000000?cloP000000203l
o?h00`2AVi`0TJNd0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`00
00030?ooo`<000000`3oool2000000050?ooo`000000oooo0000003oool00P0000050?ooo`03096W
]03Pgn<0h=oS0?80h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00<0TI^L0?cloP3lo?h0103lo?h00`00
0000o?cn0?cloP030?cloP030000003lo?h0000000<0o?cn00<000000?cloP000000100000000`3l
o?h000000?cloP030?cloP030000003lo?h0000000P0o?cn00<0TI^L096W]03jnOh00`3jnOh01@00
0000n_Wn0?[ioP3jnOh000000080n_Wn00L000000?[ioP3jnOh0n_Wn0000003jnOh0000000<0n_Wn
00<000000?[ioP0000000P3jnOh2000000040?[ioP000000n_Wn000000H0n_Wn00<0TJNd0>3Oh`3P
gn<0lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
hh80Oifi00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`03096KW03lo?h0o?cn00@0o?cn00<00000
0?cloP3lo?h00`3lo?h00`000000o?cn000000030?cloP030000003lo?h0000000<0o?cn00@00000
0?cloP00000000000P3lo?h01@000000o?cn0?cloP3lo?h0000000L0o?cn00<0TI^L096W]03em?d0
0`3em?d01@000000mOCm0?Gdo@3em?d000000080mOCm00<000000?Gdo@3em?d01P3em?d010000000
mOCm0?Gdo@0000030?Gdo@050000003em?d000000?Gdo@000000103em?d00`3fm?d0mOCm096W]03d
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0
TI^L0?cloP3lo?h0103lo?h00`000000o?cn0?cloP030?cloP030000003lo?h0000000<0o?cn00<0
00000?cloP3lo?h00`0000020?cloP050000003lo?h000000?cloP0000000`3lo?h00`000000o?cn
0?cloP050?cloP03096KW02AYk@0lO7m00<0lO7m00@000000?7ao@3alOd000000`3alOd500000080
lO7m0P0000030?7ao@090000003alOd0lO7m0?7ao@000000lO7m0000003alOd0000000H0lO7m00<0
TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`03096KW03lo?h0o?cn00D0o?cn00D000000?cloP3lo?h0o?cn0000000N0?cloP03
096KW02AYk@0j^[i00<0j^[i1@0000020>[Zn@070000003Zj_T0j^[i0>[Zn@000000j^[i00000003
0>[Zn@030000003Zj_T0000000<0j^[i00D000000>[Zn@000000j^[i000000060>[Zn@03096W]03P
gn<0h=oS0?80h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<00`2AVi`0o?cn0?cloP060?cloP<000007`3lo?h00`2AVi`0TJNd0>[Zn0030>[Zn0030000
003Zj_P0j^[h0080j^[h00<000000>[Zn03Zj_P00`0000030>[Zn0<000000P3Zj_P01P000000j^[h
0>[Zn03Zj_P000000>[Zn0@000001@3Zj_P00`2AYk@0h=oS0>3Oh`3b0>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0TI^L0?cloP3lo?h0:03lo?h0
0`2AVi`0TJNd0>GVm0030>GVm0030000003Ui_@0iNKd0080iNKd00<000000>GVm03Ui_@04@3Ui_@0
0`000000iNKd000000060>GVm003096W]03Pgn<0h=oS0?80h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`2AVi`0o?cn0?cloP0X0?cloP03096KW02A
Yk@0gmoa00<0gmoa1@00000D0=oOl@030000003Ogo40000000H0gmoa00<0TJNd0>3Oh`3Pgn<0lP3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03096K
W03lo?h0o?cn02P0o?cn00<0TI^L096W]03Kg>d03@3KgNd50=_LkA<0fmg]00<0TJNd0>3Oh`3Pgn<0
lP3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03
096KW03lo?h0o?cn02P0o?cn00<0TI^L096W]03EenT09@3EenT00`2AYk@0h=oS0>3Oh`3b0>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?oo
o`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0TI^L0?cl
oP3lo?h0:03lo?h00`2AVi`0TJNd0<c=hP0U0<c=hP03096W]03Pgn<0h=oS0?80h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`2AVi`0o?cn0?cloP0X
0?cloP03096KW02AYk@0a/SM02D0a/SM00<0TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`03096KW03lo?h0o?cn02P0o?cn00<0
TI^L096W]02n_]P08@2n_]P20;jof080_[kH00<0TJNd0>3Oh`3Pgn<0lP3Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Ohol0LFmTA01aKf@50>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo09fMX@2M
WJ40o`2MWJ5009fMX@03075_I03Pgn<0h=oS00<0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0o`3P
gn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`07
0?ooo`3Pgn<0hN3T0>KUj03/jnh0l?3b0?;bm0190??cm4H0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00H0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00R0??cm1l0n?Oh0P3clo@01@3cloD0m?Ce
0?GemP3dloD0iNCX0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0g]cO0>CRh01kUjd09EN5T`00
?7@0100GCGh0Jh^V0?;akP3blO<60>3Oh`040=kLg`3Th^00NiN]02EGQDD003ad00@05den06^;YP3b
lNh0l_7cD@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Jf=T0IXFQ04YaT`2b_L>C0<K5e`040<36
a@18KY00JXZT0>o_l@H0h=oS00@0f]SI06J5X@1:LI<0/[g3A@36aML01030a/D0B6j@06Z:Y03_ko5A
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=SEeP0GCGh0_lO:09D0a/GG00<0][fm01M=OP3[j^d0
1P3Pgn<00`3HeMH05den0;o7bP170<K5e`030;Jm_@0GCGh0jn[]0540h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`05
0?ooo`3Pgn<0fMGE000lM03oool0U@3=c=l00`3oool003ad0>SWjP060>3Oh`030=WEe@00?7@0oooo
04L0cLcO00<0oooo000lM03XinX0D@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?oo
o`1Z0=;Ai0030000003BdN@0d]7T02P0d]7T00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?oo
o`170=;Ai0030?ooo`00?7@0inKY0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0fMGE000lM03o
ool0JP3FenL00`000000e]OW0=KGi`0X0=KGi`030?ooo`00?7@0inKY00H0h=oS00<0fMGE000lM03o
ool0A`3FenL00`3oool003ad0>OVj@1A0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0
oooo00h0fM[W100000020=WJi`050000003If^L0fM[W0=WJi`0000000P3If^L3000000@0fM[W00D0
00000=WJi`3If^L0fM[W000000060=WJi`030000003If^L0fM[W00<0fM[W00<000000=WJi`3If^L0
0P0000000`3If^L000000=WJi`020=WJi`030000003If^L0fM[W0080fM[W0P000000103If^L00000
0=WJi`0000030=WJi`030000003If^L0fM[W00<000000`3If^L3000000<0fM[W0P0000000`3If^L0
00000=WJi`050=WJi`<000000`3If^L010000000fM[W0000000000020=WJi`80000000@0fM[W0000
003If^L0fM[W0`0000020=WJi`050000003If^L0fM[W0=WJi`0000000P3If^L300000100fM[W00<0
oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0>0=WJi`@000000`3If^L300000080fM[W00<0
00000=WJi`3If^L00`0000030=WJi`<000000P3If^L2000000@0fM[W00<000000=WJi`3If^L00`3I
f^L01@000000fM[W0000003If^L0000000h0fM[W00<0oooo000lM03Wi^T0D@3Pgn<00`2MWJ40LFmT
0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0=0=WJi`030000003If^L0fM[W0080fM[W00<000000=WJ
i`0000000`3If^L00`000000fM[W000000030=WJi`050000003If^L0fM[W0=WJi`0000000`3If^L0
0`000000fM[W0=WJi`040=WJi`030000003If^L0fM[W00<0fM[W00<000000=WJi`0000000P3If^L2
000000<0fM[W00D000000=WJi`3If^L0fM[W000000020=WJi`80000000<0fM[W0000003If^L00P3I
f^L00`000000fM[W000000030=WJi`030000003If^L0000000<0fM[W00<000000=WJi`0000000P3I
f^L2000000D0fM[W00D000000=WJi`3If^L0fM[W000000020=WJi`8000000P3If^L00`000000fM[W
000000020=WJi`030000003If^L0000000<0fM[W00<000000=WJi`0000000`3If^L00`000000fM[W
000000030=WJi`030000003If^L0fM[W00d0fM[W00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad
0?ooo`0=0=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`0000000`3If^L01@000000fM[W
0000003If^L0000000<0fM[W00<000000=WJi`0000000`3If^L00`000000fM[W000000050=WJi`03
0000003If^L0fM[W00<0fM[W00D000000=WJi`000000fM[W0000000>0=WJi`030?ooo`00?7@0inKY
0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0fMGE000lM03oool04P3Ngn`00`000000g]o/0000
00030=kOk0030000003Ngn`0000000<0g]o/00X000000=kOk03Ngn`000000=kOk0000000g]o/0000
003Ngn`000001P3Ngn`500000080g]o/00D000000=kOk03Ngn`0g]o/000000020=kOk0030000003N
gn`000000080g]o/00L000000=kOk03Ngn`0g]o/0000003Ngn`0000000<0g]o/00<000000=kOk000
00001@3Ngn`00`000000g]o/0=kOk0030=kOk0050000003Ngn`0g]o/0=kOk0000000103Ngn`00`00
0000g]o/0=kOk0030=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk00000000P3Ngn`00`00
0000g]o/000000030=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`00P3Ngn`00`00
0000g]o/0=kOk00>0=kOk0030?ooo`00?7@0inKY00H0h=oS00<0fMGE000lM03oool04P3Ngn`00`00
0000g]o/000000050=kOk0030000003Ngn`0000000D0g]o/00<000000=kOk03Ngn`00`3Ngn`00`00
0000g]o/0=kOk0040=kOk0D000000P3Ngn`00`000000g]o/0000000>0=kOk0030?ooo`00?7@0inKY
0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0fMGE000lM03oool0403SiO0200000080hnG`00L0
00000>?Ul03SiO00hnG`0000003SiO00000000<0hnG`00X000000>?Ul03SiO0000000>?Ul0000000
hnG`0000003SiO0000001P3SiO001@000000hnG`0>?Ul03SiO0000000080hnG`00D000000>?Ul03S
iO00hnG`000000020>?Ul0030000003SiO00000000<0hnG`100000000`3SiO0000000>?Ul0020>?U
l0030000003SiO00000000D0hnG`1@0000000`3SiO0000000>?Ul0020>?Ul0030000003SiO00hnG`
0080hnG`00<000000>?Ul03SiO000`3SiO000`000000hnG`000000030>?Ul0030000003SiO000000
0080hnG`00<000000>?Ul00000000`3SiO000`000000hnG`000000030>?Ul0030000003SiO00hnG`
008000004@3SiO000`3oool003ad0>OVj@060>3Oh`030=WEe@00?7@0oooo0100hnG`0P0000020>?U
l0D0000000<0hnG`0000003SiO001@0000000`3SiO0000000>?Ul0040>?Ul0030000003SiO00hnG`
00@0hnG`00D000000>?Ul03SiO00hnG`000000020>?Ul0030000003SiO00000000h0hnG`00<0oooo
000lM03Wi^T0D@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0>0>W[m@800000
103YjoD200000080jN_e00<000000>W[m@0000000`3YjoD00`000000jN_e000000020>W[m@030000
003YjoD000000080jN_e00<000000>W[m@3YjoD0103YjoD00`000000jN_e000000030>W[m@030000
003YjoD0jN_e0080000000<0jN_e0000003YjoD00P3YjoD00`000000jN_e000000030>W[m@040000
003YjoD0000000000080jN_e00<000000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@03
0000003YjoD000000080jN_e0P0000040>W[m@030000003YjoD0jN_e00<0jN_e00@000000>W[m@00
000000000P3YjoD00`000000jN_e000000020>W[m@030000003YjoD0000000<0jN_e00@000000>W[
m@00000000000P3YjoD00`000000jN_e000000030>W[m@030000003YjoD0jN_e00d0jN_e00<0oooo
000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0>0>W[m@800000103YjoD02@000000jN_e0>W[m@3Y
joD000000>W[m@000000jN_e000000030>W[m@030000003YjoD0000000<0jN_e00<000000>W[m@00
00001`3YjoD00`000000jN_e000000030>W[m@030000003YjoD0000000h0jN_e00<0oooo000lM03W
i^T0D@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3O
h`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`0=0?3ao0030000003`lO`0
l?7l00@0l?7l00@000000?3ao000000000000`3`lO`300000080l?7l00D000000?3ao03`lO`0l?7l
000000030?3ao0030000003`lO`0l?7l00@0l?7l00<000000?3ao0000000103`lO`2000000040?3a
o0000000l?7l000000<0l?7l00<000000?3ao03`lO`00`0000020?3ao0040000003`lO`000000000
00<0l?7l0`0000030?3ao0<000000`3`lO`2000000030?3ao0000000l?7l00<0l?7l00<000000?3a
o03`lO`00`3`lO`010000000l?7l0000003`lO`2000000060?3ao000000000000000003`lO`00000
0P3`lO`300000080l?7l00@000000?3ao000000000000`3`lO`300000100l?7l00<0oooo000lM03W
i^T01P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`lO`0l?7l00D0l?7l0`0000020?3ao003
0000003`lO`0l?7l00<000000`3`lO`3000000040?3ao00000000000000000H0l?7l00<000000?3a
o00000000`3`lO`00`000000l?7l0000000>0?3ao0030?ooo`00?7@0inKY0540h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`050?ooo`3Pgn<0fMGE000lM03oool03@3dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003d
mOd0000001X0m?Gm00<000000?Ceo@0000001`3dmOd00`000000m?Gm0?Ceo@0Q0?Ceo@030000003d
mOd0m?Gm00<0m?Gm00D000000?Ceo@3dmOd0m?Gm000000080?Ceo@030000003dmOd0m?Gm0280m?Gm
00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0=0?Ceo@030000003dmOd0m?Gm0080m?Gm
00<000000?Ceo@3dmOd01@3dmOd00`000000m?Gm0?Ceo@0;0?Ceo@030000003dmOd0m?Gm00D0m?Gm
00<000000?Ceo@0000000`3dmOd00`000000m?Gm0000000>0?Ceo@030?ooo`00?7@0inKY0540h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0
h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0fMGE000lM03oool03P3fmod400000080m_Om00<000000?Kg
o@3fmod06@3fmod00`000000m_Om0?Kgo@060?Kgo@030000003fmod0m_Om0240m_Om00<000000?Kg
o@3fmod0103fmod3000000T0m_Om00@000000?Kgo@3fmod000008@3fmod00`3oool003ad0>OVj@06
0>3Oh`030=WEe@00?7@0oooo00h0m_Om100000080?Kgo@030000003fmod0m_Om00/0m_Om00<00000
0?Kgo@3fmod01P3fmod00`000000m_Om0?Kgo@020?Kgo@030000003fmod0000000h0m_Om00<0oooo
000lM03Wi^T0D@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3O
h`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3IeMD003ad0?ooo`2E0?Slo@030?oo
o`00?7@0inKY00H0h=oS00<0fMGE000lM03oool0A`3ho?d00`3oool003ad0>OVj@1A0>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01@3oool0h=oS0=WEe@00?7@0oooo09D0oOgm00<0oooo000lM03Wi^T01P3Pgn<00`3I
eMD003ad0?ooo`170?gmo@030?ooo`00?7@0inKY0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0
oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`050?ooo`3Pgn<0
fMGE000lM03oool0U@3moOd00`3oool003ad0>KVj@060>3Oh`030=WEe@00?7@0oooo04L0oOgm00<0
oooo000lM03Vi^T0D@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00D0oooo0>3Oh`3He=@003ad0?ooo`2E0?gmo@03
0?ooo`00?7@0iNGX00H0h=oS00<0f=CD000lM03oool0A`3moOd00`3oool003ad0>GUj01A0>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS0=WEe@0UEhD0_lkL09D0oooo00<0_lkK02EGQ@3QhN@01P3Pgn<0
0`3IeMD09EN50;o>g0170?ooo`030;o>f`0UEhD0hN7T0540h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0fMGE07VDZ@1EOJ80`<oMT`3oool0103EgnP0EGfR07VEZ`3OgN060>3Oh`040=WEe@1iU:T0EGfR
0<3?gDD0oooo00@0eMoX05EmXP1iUJ/0gmgPD@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3JemT0
gmcH07VDZ@0UEhFC000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS00@0f]OI0=oLf01iU:T09EN5A@00
?7@0100GCGh0IXJQ0>3NfP3LfmeA0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01@3oool0h=oS0=oMh03JemT0f=CD
04/0em?DAP3Cc/`30=OCe0040=SDe03IeMD0f]OI0=oMh0H0h=oS00<0gmgP0=[Gf@3He=@0903Gdm@O
0=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgPD@3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0
o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool0
0`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o
0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0
LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM
^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?oo
o`3Pgn<0h=oS0>3OhiX0oooo1`3Pgn>I0?ooo`<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0h=oS
0>3OhiT0W9bN00<0oooo0>3Oh`3Pgn<01@3Pgn>H09bLWP060?ooo`3Pgn<0h=oS0>3Oh`2MWJ40LFmT
1@3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooUP3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0
h=oS09@0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3ooonF0>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0U03Pgn<00`2LW9h0
oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oSTP1o
WKT20>3Oh`0309bLWP3oool0h=oS00H0h=oS00@0W9bN0?ooo`3Pgn<0h=oST@1oWKT20>3Oh`0309bL
WP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0
h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03P
gn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo
00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<0
1@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fM
X@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3P
gn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool0
1@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1o
WKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3o
ool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bL
WP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:
0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`03
0>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM
^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3a
kn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80
h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?oo
o`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3O
h`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS
00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS
00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3O
h`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3P
gn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<0
0`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3O
h`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1o
WKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3o
ool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0SP3oool01@1oWKT0h=oS0>3O
h`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM^@2?0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`070>3Oh`0509bLWP3oool0h=oS0>3O
h`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3o
ool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`2>0?ooo`0507nM^@3Pgn<0h=oS09bL
WP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS
00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?oo
o`3oool0SP3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00L0h=oS00D0W9bN0?ooo`3Pgn<0h=oS07nM
^@2?0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool00`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3o
ool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3P
gn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo08h0oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?oo
o`070>3Oh`0509bLWP3oool0h=oS0>3Oh`1oWKT0S`3oool01@1oWKT0h=oS0>3Oh`2LW9h0oooo00<0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?oo
o`2>0?ooo`0507nM^@3Pgn<0h=oS09bLWP3oool01`3Pgn<01@2LW9h0oooo0>3Oh`3Pgn<0Oifi08l0
oooo00D0Oifi0>3Oh`3Pgn<0W9bN0?ooo`030>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n
0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3P
gn<0W9bN0?ooo`80h=oSTP1oWKT20>3Oh`0309bLWP3oool0h=oS00H0h=oS00@0W9bN0?ooo`3Pgn<0
h=oST@1oWKT20>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo
07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS
0>3Oh`2LW9h0ooooUP3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS09@0h=oS00<0
W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR
0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooonF0>3O
h`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0U03Pgn<00`2LW9h0oooo0>3Oh`020>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT
0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oooiH0h=oS00<0W9bN0?ooo`3Pgn<0
1P3Pgn<00`2LW9h0oooo0>3Oh`2D0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`03
07nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`06
0?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooUP3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0
h=oS09@0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3o
ool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS
09bLWP3ooonF0>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0U03Pgn<00`2LW9h0
oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS
0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?oooiH0h=oS00<0
W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo0>3Oh`2D0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS
0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooUP3Pgn<00`2LW9h0oooo0>3Oh`060>3O
h`0309bLWP3oool0h=oS09@0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3ooonF0>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0W9bN0?ooo`3Pgn<0
U03Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<2000000050>3Oh`000000h=oS0000003Pgn<00P00
00020>3Oh`030000003Pgn<0h=oS00<000000`3Pgn<3000007<0h=oS00<0W9bN0?ooo`3Pgn<01P3P
gn<00`2LW9h0oooo0>3Oh`060>3Oh`<000000`3Pgn<300000080h=oS00<000000>3Oh`3Pgn<00P00
0000103Pgn<000000>3Oh`0000020>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`00
0000h=oS0>3Oh`03000006T0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi
0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3oool70>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<200000003
0>3Oh`00000000000080h=oS00D000000>3Oh`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`3Pgn<0L03Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS
00D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS
000000020>3Oh`80000000D0h=oS0000003Pgn<0h=oS000000020>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`1V0>3Oh`0309bLWP3oool0h=oS0080
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1a
Kf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo1`3Pgn<01@000000h=oS0>3O
h`3Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000P0
h=oS00<000000>3Oh`3Pgn<0L@3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`0309bLWP3oool0h=oS00@0
h=oS00<000000>3Oh`3Pgn<0103Pgn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`0000030>3Oh`03
0000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0I`3Pgn<00`2LW9h0oooo0>3Oh`020>3Oh`03
09fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3O
h`3Pgn<00`3Pgn<01@3oool0h=oS0>3Oh`3Pgn<0W9bN00D0oooo0`3Pgn<00`000000h=oS0>3Oh`02
0>3Oh`@0000000<0h=oS0000003Pgn<00P3Pgn<010000000h=oS0000003Pgn<500000080h=oS0P00
00040>3Ohg00oooo00<0W9bN0?ooo`3Pgn<01P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`030>3Oh`00
0000h=oS00D0h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`0000000`3Pgn<00`00
0000h=oS000000020>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3O
h`02000000@0h=oSIP3oool00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0
lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo
0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103oool0h=oS
0>3Oh`3Pgn<609bLWP<0h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`040000003Pgn<00000
00000080h=oS00D000000>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<0
00000>3Oh`3Pgn<0L@2LW9h00`3oool0h=oS0>3Oh`050>3Oh`H0W9bN00<0h=oS0000003Pgn<01@3P
gn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS000000030>3Oh`050000003Pgn<00000
0000003Pgn<00P0000000`3Pgn<000000>3Oh`0200000080h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS0>3Oh`1W09bLWP060?ooo`3Pgn<0h=oS0>3Oh`2MWJ40LFmT1@3Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0
oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS00X0
h=oS00<000000>3Oh`3Pgn<00P3Pgn<300000080h=oS00@000000>3Oh`00000000000P3Pgn<00`00
0000h=oS0>3Oh`03000000<0h=oS0`0000230>3Oh`030000003Pgn<0h=oS00D0h=oS0`0000020>3O
h`030000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS000000020>3Oh`050000003Pgn<0
h=oS0000003Pgn<00P0000030>3Oh`<00000KP3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0
OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0
2P3Pgn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0
S@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000L0h=oS00<000000>3Oh`3Pgn<0Q@3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00<0oooo0>3Oh`3Pgn<0203Pgn<5000000L0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`00
0000h=oS0>3Oh`2>0>3Oh`<00000203Pgn<00`000000h=oS0>3Oh`250>3Oh`0309fMX@1aKf@0h=oS
00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<0
0`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<0
0`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0
Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0
oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0
h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_
hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2M
WJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0
h=oS00<0h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?oo
o`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3O
h`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<0
0P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`030?ooo`3Pgn<0h=oS0?l0h=oS?`3Pgn<00`2MWJ40LFmT
0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0
h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0
h=oS00<0oooo0>3Oh`3Pgn<0o`3Pgn<o0>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@02P3Pgn<00`1oWKT0oooo0?ooo`1n0?oo
o`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<00`3oool0h=oS0>3Oh`3o0>3O
hcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I00:0>3Oh`0307nM^@3oool0oooo07h0oooo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`040?ooo`3Pgn<0h=oS0>3Ohol0oooo>`3oool30>3Oh`0309fMX@1a
Kf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
2P3Pgn<00`1oWKT0oooo0?ooo`1n0?ooo`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<0
0`3Pgn<0103oool0h=oS0>3Oh`3Pgn?o09bLWSX0W9bN00H0oooo0>3Oh`3Pgn<0h=oS09fMX@1aKf@5
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0
Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0
oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0?ooo`3oool0OP3oool00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Ohol0Oifi<`1oWKT20>3O
h`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi
0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo
0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0k>gd08^<V@2MWZ/0302MWZ/00`2:RiT0];Nn
07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0/[Bo07h0
/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3O
h`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0U9FR0=gNh@3If^@0303If^@0
0`3Mg^40U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b
];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0U9FR0?ooo`3;
c=X0303;c=X00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03P
gn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3O
h`0307nM^@2b];l0/[Bo07h0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0
U9FR0?ooo`3;c=X0303;c=X00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I00:0>3Oh`0307nM^@2b];l0/[Bo00@000000P2b];l01P000000/[Bo0;:d_`2b];l000000;:d
_`80000000<0/[Bo0000002b];l00P000000102b];l000000;:d_`2b];l3000000<0/[Bo0P000000
0`2b];l000000;:d_`060;:d_`030000002b];l0/[Bo05<0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<0
0`1aKf@0h=oS0>3Oh`030>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo
0?ooo`3o0?oooah0oooo00<0U9FR0?ooo`3;c=X0303;c=X00`3oool0U9FR07nM^@020>3Oh`0309bL
WP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l0000000@0/[Bo00<000000;:d_`00
00000`2b];l00`000000/[Bo000000020;:d_`030000002b];l000000080/[Bo00<000000;:d_`00
00000`2b];l00`000000/[Bo000000020;:d_`8000001`2b];l00`000000/[Bo0;:d_`1C0;:d_`03
07nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN
0?ooo`80h=oS00<0Oifi0?ooo`3oool0o`3ooolN0?ooo`0309BEXP3oool0blcJ00D0blcJ00<0?cdm
0<_<fP3;c=X0103;c=X00`3oool0U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ
075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I00:0>3Oh`0307nM^@2b];l0000000@0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo0000
00020;:d_`030000002b];l000000080/[Bo00<000000;:d_`0000001@2b];l01P000000/[Bo0;:d
_`2b];l000000;:d_`<000000`2b];l00`000000/[Bo0;:d_`1C0;:d_`0307nM^@3akn80h=oS0080
h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi
0?ooo`3oool0o`3ooolN0?ooo`0309BEXP3oool0c<gK00@0c<gK0`0o?Cd50<c=f`030?ooo`2DUJ80
Oifi0080h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`000000102b
];l00`000000/[Bo000000030;:d_`030000002b];l000000080/[Bo00<000000;:d_`0000000P2b
];l00`000000/[Bo00000004000000030;:d_`000000/[Bo0080/[Bo00<000000;:d_`2b];l01@2b
];l00`000000/[Bo0;:d_`1C0;:d_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3P
gn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0o`3ooolN0?ooo`03
09BEXP3oool0dM;P00<0dM;P1@0o?Cd40=7Bh0030?ooo`2DUJ80Oifi0080h=oS00<0W9bN0?ooo`3P
gn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`000000102b];l010000000/[Bo000000000002
0;:d_`030000002b];l000000080/[Bo00<000000;:d_`0000000P2b];l00`000000/[Bo00000003
0;:d_`030000002b];l000000080/[Bo0P0000070;:d_`070000002b];l0/[Bo0;:d_`000000/[Bo
0000001?0;:d_`0307nM^@3akn80h=oS0080h=oS00<0LFmT0>3Oh`3Pgn<00`3Pgn<01P3oool0h=oS
0>3Oh`3Pgn<0W9bN0?ooo`80h=oS00<0Oifi0?ooo`3oool0o`3ooolN0?ooo`0309BEXP3oool0fM[T
0080fM[T0`0o?Cd0103If^@0?cdm03lm?@0o?Cd30=WJi0030?ooo`2DUJ80Oifi0080h=oS00<0W9bN
0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`000000102b];l010000000/[Bo0000
002b];l2000000050;:d_`00000000000000002b];l010000000102b];l000000;:d_`2b];l30000
00<0/[Bo0P0000000`2b];l000000;:d_`040;:d_`030000002b];l0000000@0/[Bo00<000000;:d
_`2b];l0CP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3O
h`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo0?l0oooo7P3oool0102DUJ80oooo0=WJ
i03If^@303lm?@<0fM[T0`0o?Cd20=WJi0030?ooo`2DUJ80Oifi0080h=oS00<0W9bN0?ooo`3Pgn<0
0P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`000000102b];l00`000000/[Bo0;:d_`050;:d_`03
0000002b];l0/[Bo0080/[Bo00@000000;:d_`2b];l000002`2b];l00`000000/[Bo0;:d_`040;:d
_`8000000`2b];l3000004l0/[Bo00<0Oifi0?7_hP3Pgn<00P3Pgn<00`1aKf@0h=oS0>3Oh`030>3O
h`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0oooo0P3Pgn<00`1oWKT0oooo0?ooo`3o0?oooah0oooo00<0
U9FR0?ooo`3Shn/00P3Shn/00`0o?Cd0hn?[0>?Sj`030>?Sj`0703lm?@3Shn/0hn?[0>?Sj`3oool0
U9FR07nM^@020>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00:0>3Oh`0307nM^@2b];l00000
00@0/[Bo00<000000;:d_`2b];l01@2b];l01P000000/[Bo0;:d_`000000/[Bo00000080/[Bo00<0
00000;:d_`2b];l02@2b];l00`000000/[Bo0;:d_`050;:d_`030000002b];l0/[Bo0080/[Bo00<0
00000;:d_`2b];l0CP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0
oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo0?l0oooo7P3oool00`2DUJ80
oooo0>c/l@0<0>c/l@030?ooo`2DUJ80Oifi0080h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS
00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo0?l0oooo7P3o
ool00`2DUJ80oooo0?Cdm`0<0?Cdm`030?ooo`2DUJ80Oifi0080h=oS00<0W9bN0?ooo`3Pgn<00P3P
gn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR0>3Oh`020>3Oh`03075_
I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM^@3oool0oooo
0?l0oooo7P3oool00`2DUJ80oooo0?_lo00<0?_lo0030?ooo`2DUJ80Oifi0080h=oS00<0W9bN0?oo
o`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo0?l0oooo7P3oool00`2DUJ80oooo0?ooo`0=0?ooo`0609BEXP1oWKT0h=oS0>3Oh`2L
W9h0oooo0`3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0lNoR0>3Oh`02
0>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool20>3Oh`0307nM
^@3oool0oooo0?l0oooo7P3oool00`2DUJ80e]KK0?ooo`0<0?ooo`030=KFf`2DUJ80Oifi0080h=oS
00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00X0h=oS00<0Oifi0;:d_`2b];l0OP2b];l00`1oWKT0
lNoR0>3Oh`020>3Oh`03075_I03Pgn<0h=oS00<0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool2
0>3Oh`0307nM^@3oool0oooo0?l0oooo7`3oool00`2?T9h0]KFn0;Bd_P050;Bd_@090;>d_@2d];d0
];Bm0;>d_@2d];d0/k>m08b=W02d]kh0Oifi0080h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40
LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
00X0h=oSPP1oWKT01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bL
WP3oool20>3Ohol0Oifi<`1oWKT20>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooool0h=oS=`3P
gn<00`2LW9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0
h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2L
W9h0ooooo`3Pgn<g0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooool0h=oS=`3Pgn<00`2LW9h0
oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT00D0h=oS00H0oooo
0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT
0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0
h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I0050>3Oh`060?ooo`3Pgn<0h=oS0>3Oh`2LW9h0ooooo`3P
gn<g0>3Oh`0309bLWP3oool0h=oS0080h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00?0>3Oh`<0000000@0h=oS0000003Pgn<0
h=oS0P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D000000>3Oh`3Pgn<0h=oS00000002
0>3Oh`<000000`3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0EP3Pgn<01@3akn80h=oS0>3Oh`3P
gn<0LFmT00D0h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3ooooo0>3OhcL0h=oS00<0W9bN0?ooo`3P
gn<00P3Pgn<00`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT00h0h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`030000003Pgn<0
h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`1H0>3Oh`050?7_hP3Pgn<0
h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0h=oS0>3Oh`3Pgn<0W9bN0?ooool0h=oS=`3Pgn<00`2LW9h0
oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1aKf@03@3Pgn<00`000000h=oS0>3Oh`02000000040>3Oh`000000h=oS
000000<0h=oS00<000000>3Oh`0000001@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
203Pgn<00`000000h=oS0>3Oh`1I0>3Oh`050?7_hP000000h=oS0>3Oh`1aKf@01@3Pgn<01P3oool0
h=oS0>3Oh`3Pgn<0W9bN0?ooo`L0h=oS0`0000030>3Oh`<000000P3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03000000<0h=oS0`0000020>3Oh`800000
00@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`000000o03Pgn<00`2L
W9h0oooo0>3Oh`020>3Oh`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@03@3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`000000100000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0
000000@000000P3Pgn<2000005`0h=oS00D0lNoR000000000000h=oS075_I0050>3Oh`060?ooo`3P
gn<0h=oS0>3Oh`2LW9h0oooo1P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<0h=oS0?X0h=oS00<0W9bN0?ooo`3Pgn<00P3Pgn<0
0`2MWJ40LFmT0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT00d0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0F03Pgn<01@3akn800000000000000000LFmT00D0
h=oS00H0oooo0>3Oh`3Pgn<0h=oS09bLWP3oool50>3Oh`030000003Pgn<0h=oS00@0h=oS00L00000
0>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000050>3Oh`030000003Pgn<0h=oS00<0h=oS00H000000>3Oh`3Pgn<000000>3Oh`0000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0nP3Pgn<00`2LW9h0oooo0>3Oh`020>3O
h`0309fMX@1aKf@0h=oS00@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@03@3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`3Pgn<00`0000020>3Oh`050000003Pgn<000000>3Oh`0000000P3Pgn<3000000<0h=oS0`00
00020>3Oh`030000003Pgn<0h=oS05H0h=oS00D0lNoR000000000000h=oS075_I0050>3Oh`050?oo
o`3Pgn<0h=oS0>3Oh`2LW9h01@3oool00`3Pgn<000000>3Oh`050>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`00000010000000
0`3Pgn<000000>3Oh`040>3Oh`060000003Pgn<0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS0?X0oooo00<0W9bN0?ooo`3Pgn<00P3Pgn<00`2MWJ40LFmT
0>3Oh`040>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT00h0
h=oS00D000000>3Oh`3Pgn<0h=oS0000001i0>3Oh`050?7_hP000000h=oS0>3Oh`1aKf@01@3Pgn<0
103oool0h=oS0>3Oh`3Pgn<609bLWP030>3Oh`000000h=oS00D0h=oS00H000000>3Oh`3Pgn<0h=oS
0000003Pgn<200000080h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3O
h`040000003Pgn<0000000000080h=oS00<000000>3Oh`3Pgn<0n`2LW9h01P3oool0h=oS0>3Oh`3P
gn<0WIfQ075_I0D0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@03`3Pgn<3000001<0h=oS00<000000>3Oh`3Pgn<0I03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT
00D0h=oS00<0oooo0>3Oh`3Pgn<0203Pgn<00`000000h=oS0>3Oh`050>3Oh`<000000P3Pgn<01000
0000h=oS0000000000020>3Oh`040000003Pgn<00000000000<0h=oS0`0000030>3Oh`<0000000H0
h=oS00000000000000000>3Oh`0000020>3Oh`<000000P3Pgn<010000000h=oS00000000003o0>3O
h`<0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3O
h`090>3Oh`050000003Pgn<0h=oS0>3Oh`0000007`3Pgn<00`000000h=oS0>3Oh`3o0>3Oh`l0h=oS
00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3Oh`0:0>3O
h`<00000803Pgn<010000000h=oS0>3Oh`00003o0>3Oh`h0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3P
gn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0
103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`05
0?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_
I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<
0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0h=oS00<0
WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@01@3Pgn<00`3oool0h=oS0>3Oh`3o0>3Ohcl0
h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0000001aKf@01@3Pgn<00`3oool0h=oS0>3Oh`3o
0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<000000000001aKf@01@3Pgn<00`3oool0h=oS
0>3Oh`3o0>3Ohcl0h=oS00<0WIfQ075_I03Pgn<0103Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP00000000000000001aKf@01@3Pgn?o0?oo
od<0oooo00<0LFmT0>3Oh`3Pgn<00`3Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<000000000001aKf@0o`3Pgn=>0>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0h=oS00D0lNoR0>3Oh`3Pgn<0
0000075_I03o0>3Ohdh0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0S03Pgn<01@3akn80h=oS0>3Oh`3Pgn<0LFmT0?l0h=oSCP3Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I02<0>3Oh`050?7_hP3Pgn<0h=oS0>3Oh`1aKf@0
o`3Pgn=>0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08`0
h=oS00D0lNoR0>3Oh`3Pgn<0h=oS075_I03o0>3Ohdh0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOXh0LFmT0`3Pgn?o075_I4l0LFmT00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIno`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh30>3Oh`030;>`X`2=R7X0oooo0?l0h=oSf`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0`3Pgn<00`3FclH0/k2[0>o[i`3o0>3Ohm/0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0`3Pgn<00`3WinL0oooo0?oko`0A0>3Oh`050?ooo`000000oooo0>3Oh`3oool0
503Pgn<00`3oool0h=oS0>3Oh`1C0>3Oh`030?;blP3Pgn<0h=oS0?l0h=oSF03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`2c/:<0SHQj0?ooo`0:0>3Oh`0;0?oo
o`3bl_80oooo0?;blP3oool0h=oS00d=3@3Pgn<03@d=0>3Oh`0=3@d0303Pgn<60?ooo`80h=oS00<0
00000?ooo`3Pgn<0303Pgn<90?ooo`l0h=oS00X0l_;b0?ooo`3bl_80oooo0?;blP3oool0l_;b0?oo
o`3bl_80oooo303Pgn<90?oooa00h=oS00<0l_;b00d=3@3bl_80503Pgn<00`0K6a/0oooo0>3Oh`3o
0>3Ohd80h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0e/o6
0;>`Z`3_jnL02@3Pgn<01@0=3@d0000000d=3@0000003@d=0080h=oS00H0l_;b00d=3@3bl_803@d=
0>3Oh`3oool:0>3Oh`H000000P3Pgn<00`3oool000000?ooo`020?ooo`X0h=oS2P0000000`3oool0
h=oS0>3Oh`0<0>3Oh`0:00d=3@0000003@d=0000000=3@d0000000d=3@0000003@d=0?;blP/0h=oS
2@0c<c<00`3oool0h=oS0>3Oh`0=0>3Oh`050?;blP0=3@d000000?ooo`3bl_803`3Pgn<02P3oool0
l_;b0?ooo`3bl_80:2PX01/K6`3oool0l_;b0?ooo`3bl_;o0>3Ohcl0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPl0h=oS00d000000?ooo`3>c?00fMOk0<C3j@3Pgn<00000
00d=3@3bl_803@d=0?;blP0=3@d0000000X0h=oS00L000000?ooo`3Vi_l0];C<0>KVo`2XYl40h=oS
00D000002P3Pgn<00`000000oooo06IVIP060?ooo`0406IVIP3<c<`000000?ooo`X0h=oS00d0oooo
0?;blP3oool000000?ooo`2o_kl0oooo0?;blP3oool0l_;b0?ooo`000000oooo00/0h=oS00@0<c<c
0?ooo`3<c<`0c<c<0`2IVIT00`1VIVH0<c<c0?ooo`0>0>3Oh`080?;blP0=3@d0`/;b0<o?o`000000
3@d=0?;blP3oool<0>3Oh`0;00d=3@0000003@d=0000000=3@d06a/K0=;CD`0K6a/0Shn?0?;blP3o
ool0o`3Pgn<o0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`03
0>OWi`3oool0oo_o00T0h=oS00D03@d=0?;blP3GeOX0c/c`0=[Go0030>3Oh`0500d=3@3bl_803@d=
0>3Oh`3oool02P3Pgn<01P000000oooo0;Bdc03Vi_l0];C<0>KVo`<0h=oS00<000000?ooo`3Pgn<0
2P3Pgn<010000000oooo06IVIP3oool40<c<c0050?ooo`1VIVH0c<c<0000003oool02@3Pgn<03P3o
ool0000000d=3@0000003@d=0?;blP0=3@d0_kno0<c<c02o_kl0c<c<0?;blP0=3@d0l_;b2`3Pgn<0
2P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool>0>3Oh`0900d=3@2ATL80WYk?
096A`P3?col0`/;b00d=3@000000oooo00/0h=oS00/000000?ooo`3>c?00fMOk0<C3j@0X:2P0aLI6
0;i>H@0K6a/0oooo0?;blP3o0>3Ohcl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOP<0h=oS00<0/k2S08f8NP3oool02@3Pgn<030000000oooo0<?2i`3Fe?T0cL__0=_Io@3P
gn<03@d=0>3Oh`0=3@d0l_;b00d=3@/0h=oS00X000000?ooo`3Vi_l0];C<0>KVo`2d]<`0i^Ko0:RW
`@3Pgn<00000303Pgn<010000000oooo06IVIP3oool40<c<c0050?ooo`1VIVH0c<c<0000003oool0
2@3Pgn<03P000000oooo065QH@3oool000000?ooo`000000c<c<0;no_`3<c<`0_kno0?ooo`000000
oooo2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool>0>3Oh`0:0000
002NW/l0TI7209jNc`2ATL80WYk?0<;2lP3?col000000?ooo`X0h=oS00/03@d=0?;blP3GeOX0c/c`
0=[Go037aNX0:2PX0<G6AP2nCV406a/K0?ooo`3o0>3Ohcl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0e/o60;>`Z`3_jnL02@3Pgn<01P0=3@d0l_;b0<O6k@31
`>H0e=?h0<c:kP<0h=oS00<000000>3Oh`3Pgn<02`3Pgn<020000000oooo0:JV`03Vi_l0];C<0>KV
o`2d]<`0i^Ko3P3Pgn<00`000000oooo06IVIP060?ooo`0406IVIP3<c<`000000?ooo`T0h=oS00h0
3@d=0?;blP1^KVh0l_;b00d=3@3bl_80c<c<0?;blP3oool0l_;b0?ooo`3bl_803@d=0?;blP/0h=oS
00X0<c<c0?ooo`2IVIT0c<c<06IVIP2IVIT0<c<c06IVIP0c<c<0oooo2`3Pgn<03@3bl_80oooo0?;b
lP3oool0000009jNc`2ATL803@d=096A`P2NW/l0`/;b00d=3@3bl_802P3Pgn<02`000000oooo0<?2
i`3Fe?T0cL__0=_Io@0K6a/0d]=C0;51E00X:2P0l_;b0?l0h=oS?`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn3`3Pgn<020000000oooo0;:bf@35a>`0_kkT0=;AmP3;bNh0
f]Wm3`3Pgn<02`000000oooo0<c<i@2VY/00i^Ko0;Bdc03Vi_l0];C<0>KVo`000000oooo00/0h=oS
00<000000?ooo`1VIVH01`1VIVH00`3<c<`000000?ooo`090>3Oh`0>0000003oool0HF5Q0?ooo`00
0000?Ce^030`H@0m?Fh0<31Q03dmKP0`<640?Ce^0000003oool;0>3Oh`0:03<c<`3oool0VIVI0<c<
c01VIVH0VIVI03<c<`1VIVH0<c<c0?ooo`/0h=oS00h03@d=0000000=3@d000000?ooo`0000003@d=
0>3Oh`0=3@d0TI7209jNc`32`_803@d=0?;blPT0h=oS00`03@d=0?;blP37a^d0`L3V0=CCn03<b^h0
fmWm01/K6`3Bde<0/D5D02PX:03bl_;o0>3Ohch0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP<0h=oS00<0inOW0?ooo`3onol02@3Pgn<02`0=3@d0l_;b0;Rih@2a/MP0`l?Z
0;jmh`3@d?H0b/S/0=_Ho0000000oooo00`0h=oS00/000000?ooo`2;Rj@0c<cU0:JV`03Vi_l0];C<
0>KVo`2d]<`000000?ooo`0;0>3Oh`030000003oool0c<c<00L0oooo00<0c<c<0000003oool02@3P
gn<03P0=3@d0l_;b06i^KP3bl_803@d=0000000=3@d0000000d=3@0000003@d=0000000=3@d0l_;b
2`3Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool;0>3Oh`0>0000003?
col0TI7200d=3@3bl_80h=oS0000003oool0h=oS00d=3@2ATL80cloo0000003oool90>3Oh`0<0000
003oool0/[;I0<G4k02o_^@0d]7f0<_9kP0X:2P0aLI60;i>H@0K6a/0ooooo`3Pgn<n0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030;>`X`2=R7X0oooo00T0h=oS
00/000000?ooo`2RY<d0]KKP0:n`e`31`NP0^k[Q0<o>m00000003@d=0?;blP0<0>3Oh`080000003o
ool0];C<08^;Y03<c>D0YZK00>KVo`2d]<`2000000030?ooo`3Pgn<0h=oS00T0h=oS00<000000?oo
o`1VIVH00`3<c<`3000000040?ooo`3<c<`000000?ooo`T0h=oS00`000000?ooo`1QHF40KVi^065Q
H@1^KVh0HF5Q06i^KP1QHF40clo?0000003oool=0>3Oh`0:03<c<`3oool0VIVI0<c<c01VIVH0VIVI
03<c<`1VIVH0<c<c0?ooo`/0h=oS00h03@d=0<;2lP2NW/l0TI7200d=3@3bl_803@d=0000003oool0
000000d=3@0000003@d=0?;blPT0h=oS00d03@d=0?;blP2h^N40/K7H0<?3jP2n_N<0d=3f0<[8k00X
:2P0aLI60;i>H@0K6a/0oooo0?l0h=oS?@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn0`3Pgn<00`3FclH0/k2[0>o[i`090>3Oh`0:00d=3@3bl_80ZJ[D0:6Rc02d]Mh0[ZkF
0;noi`0000003@d=0?;blPd0h=oS00L000000?ooo`20P9T0];C<08^;Y03<c>D0YZK00080000000<0
oooo0>3Oh`3Pgn<02P3Pgn<00`000000oooo06IVIP030<c<c0070000003<c<`000000?ooo`3<c<`0
00000?ooo`090>3Oh`0<00d=3@3bl_80clo?0?;blP3oool0l_;b0?ooo`3bl_80oooo0<;2`P0=3@d0
l_;b3@3Pgn<0100c<c<0oooo0<c<c03<c<`309VIV@0406IVIP0c<c<0oooo0?ooo`/0h=oS00T03@d=
0<;2lP2NW/l0TI7200d=3@2ATL80WYk?0000003oool03@3Pgn<03@000000oooo0::Tc@2e]^00[k3G
0<71j02k^^40clkd01/K6`3Bde<06a/K02PX:03bl_80o`3Pgn<m0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh?0>3Oh`0:0000003oool0UiW30:RZd`2OX<X0/[?L0000003?
col000000?ooo`d0h=oS00X000000?ooo`2d]<`0P82I0;Bdc02;Rj@000000<c<o`000000oooo303P
gn<00`000000oooo06IVIP030<c<c0070000003<c<`000000?ooo`3<c<`000000?ooo`090>3Oh`0<
0000003oool0HF5Q0<o?c`32`/803@d=0000000=3@d0l_;b0<o?c`000000oooo303Pgn<;03<c<`03
0?ooo`3Pgn<0h=oS00T0h=oS00X000000<o?o`32`_80WYk?096A`P2NW/l0TI7209jNc`000000oooo
303Pgn<03P0=3@d0l_;b0:VZe02QX/`0];GN0:j^eP2o_nL0000000d=3@0K6a/0^He=0;51E00X:2P0
l_;bo`3Pgn<l0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`03
0>OWi`3oool0oo_o00T0h=oS00X03@d=0?;blP3oool0l_;b0?ooo`3bl_80oooo0000003oool0][Jf
3@3Pgn<00`000000oooo0?ooo`040?ooo`030000003oool0h=oS00`0h=oS00<000000?ooo`1VIVH0
0`3oool300000080oooo00<000000>3Oh`3Pgn<0203Pgn<0300=3@d0l_;b06i^KP32`/80clo?0000
003?cll000000?ooo`32`/803@d=0?;blP`0h=oS00<0<c<c0<c<c03<c<`00P3<c<`409VIV@0306IV
IP0c<c<0oooo00`0h=oS00T0000000d=3@32`_80cloo096A`P2NW/l0TI7200d=3@3bl_80303Pgn<0
3P000000oooo09NI``2XZ]<0Wj3:0;:cg0000000cloo0000000X:2P0fJn]0>Jl^P0K6a/0ooooo`3P
gn<l0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`030;>`X`2=
R7X0oooo00T0h=oS00X0000000d=3@0000003@d=0000000=3@d0000000d=3@2f][H0`l?33@3Pgn<8
000000l0h=oS2P00000;0>3Oh`0<0000003oool0HF5Q0?ooo`3bl_803@d=0000000=3@d0l_;b0?oo
o`000000oooo303Pgn<;03<c<`l0h=oS00D03@d=0000003?col0`/;b00d=3@0>0>3Oh`0>00d=3@3b
l_80oooo0?;blP3oool0l_;b0?ooo`000000oooo0;Jf]P0X:2P0fJn]02PX:03bl_;o0>3Ohc`0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS00<0e/o60;>`Z`3_jnL0
C@3Pgn<02P0000003@d=0000000=3@d0000000d=3@0000003@d=0000003ooolA0>3Oh`<0<c<c5@3P
gn<00`0000003@d=0>3Oh`0>0>3Oh`0>0000000=3@d0000000d=3@0000003@d=0000000=3@d0][Jf
0<?3``0K6a/0:2PX08^;R`3ooooo0>3Ohc`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOXH0h=oS00<03@d=0>3Oh`3Pgn<0o`3Pgn=H0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWko0>3Ohn40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO_l0h=oSh@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
o`3Pgn?Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Ohn40h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2MWJ40o`3ooooN0?ooo`0509fM
X@3oool0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0WIfQh02MWJ40103oool0
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Rjn40h>;[00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVO_l0h>;[h@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIno`3Ph^_Q0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiE0>3R
j`030000003Ph^/0h>;[0?l0h>;[R@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInE@3Ph^/00`000000h>;[0>3Rj`3o0>3RjhT0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPH0h>;[00<000000>3Rj`3Ph^/00`3Ph^/00`000000h>;[000000020>3R
j`<000004@3Ph^/01@000000h>;[0>3Rj`3Ph^/000000080h>;[0`0000030>3Rj`050000003Ph^/0
h>;[0>3Rj`0000003`3Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00<000000P3P
h^/00`000000h>;[0000000300000?l0h>;[R03Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn1P3Ph^/00`000000h>;[0>3Rj`030>3Rj`050000003Ph^/000000>3Rj`000000
0`3Ph^/00`000000h>;[0>3Rj`0>0>3Rj`070000003Ph^/0h>;[0>3Rj`000000h>;[000000030>3R
j`040000003Ph^/0h>;[000000<0h>;[00<000000>3Rj`3Ph^/03@3Ph^/00`000000h>;[0>3Rj`02
0>3Rj`030000003Ph^/0000000<0h>;[00D000000>3Rj`000000h>;[000000030>3Rj`030000003P
h^/0h>;[0?l0h>;[Q@3Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P3P
h^/00`000000h>;[0>3Rj`030>3Rj`050000003Ph^/000000>3Rj`0000004`3Ph^/00`000000h>;[
000000020>3Rj`030000003Ph^/0000000D0h>;[00L000000>3Rj`000000h>;[0000003Ph^/00000
00h0h>;[00<000000>3Rj`3Ph^/00P3Ph^/00`000000h>;[000000050>3Rj`030000003Ph^/00000
00<0h>;[00<000000>3Rj`3Ph^/0o`3Ph^^50>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh60>3Rj`030000003Ph^/0h>;[00<0h>;[00@000000>3Rj`000000h>;[1@00000?
0>3Rj`030000003Ph^/000000080h>;[00<000000>3Rj`00000010000000203Ph^/000000>3Rj`00
0000h>;[0000003Ph^/000003P3Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0000000@0
000000@0h>;[0000003Ph^/000000`3Ph^/00`000000h>;[0>3Rj`3o0>3RjhD0h>;[00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0h>;[1@0000001P3Ph^/000000>3Rj`000000
h>;[000000<0h>;[00<000000>3Rj`3Ph^/03@3Ph^/00`000000h>;[000000020>3Rj`030000003P
h^/0000000<0h>;[00<000000>3Rj`0000000P3Ph^/010000000h>;[0>3Rj`00000>0>3Rj`H00000
00<0h>;[0000003Ph^/00P3Ph^/01@000000h>;[0000003Ph^/0000000<0h>;[00<000000>3Rj`3P
h^/0o`3Ph^^50>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Rj`03
0000003Ph^/0h>;[00<0h>;[00<000000>3Rj`0000000P3Ph^/3000000l0h>;[00L000000>3Rj`3P
h^/0h>;[0000003Ph^/000000080h>;[0`0000020>3Rj`040000003Ph^/0h>;[00000080h>;[00<0
00000>3Rj`3Ph^/0303Ph^/00`000000h>;[0>3Rj`020>3Rj`030000003Ph^/0h>;[00<000000P3P
h^/00`000000h>;[0000000300000?l0h>;[R03Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn1P3Ph^/00`000000h>;[0>3Rj`050>3Rj`030000003Ph^/0h>;[0180h>;[00D0
00000>3Rj`3Ph^/0h>;[0000000N0>3Rj`030000003Ph^/0h>;[0080h>;[00<000000>3Rj`3Ph^/0
1@3Ph^/00`000000h>;[0>3Rj`3o0>3Rjh/0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOPH0h>;[1@000000103Ph^/000000>3Rj`00000D0>3Rj`070000003Ph^/0h>;[0>3R
j`000000h>;[0000000L0>3Rj`030000003Ph^/0h>;[0080h>;[00<000000>3Rj`3Ph^/01@3Ph^/0
0`000000h>;[0>3Rj`3o0>3Rjh/0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOPh0h>;[00<000000>3Rj`3Ph^/0@P3Ph^/00`000000h>;[0>3Rj`3o0>3Rjh/0h>;[00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h>;[h@3Ph