Widget["Frame", 
  {
    "title"-> "Connection Tool",
    
    Script[Needs["DatabaseLink`"]],
    
    Widget["DatabaseLink/Dialogs/SelectDataSource", ExposeWidgetReferences -> {"connectionList", "ok", "cancel"} ],

    Widget["Dialog", 
      {
        "title"-> "Enter Password",
        "modal"->True,
     
        Widget["DatabaseLink/Dialogs/Password", ExposeWidgetReferences -> {"passwordField", "ok"->"passwordOk", "cancel"->"passwordCancel"} ],
        
        BindEvent[{"passwordField", "action"},
          {
            InvokeMethod[{"passwordDialog", "dispose"}]
          }
        ],

        BindEvent[{"passwordOk", "action"},
          {
            InvokeMethod[{"passwordDialog", "dispose"}]
          }
        ],

        BindEvent[{"passwordCancel", "action"},
          {
            InvokeMethod[{"passwordDialog", "dispose"}]
          }
        ]
    
      }, Name -> "passwordDialog", InitialArguments -> {WidgetReference["dataSourceFrame"]}
    ],
    
    Script[
      conn = Null;
    ],

    BindEvent[{"ok", "action"},
      Script[
        If[PropertyValue[{"connectionList", "selectedValues"}] =!= Null,          
          If[Length[PropertyValue[{"connectionList", "selectedValues"}]] > 0, 
            connName = First[PropertyValue[{"connectionList", "selectedValues"}]];
            sqlConn = DataSources[][[First[Flatten[Position[DataSourceNames[], connName]]]]];
            password = "Password" /. Options[sqlConn];
            If[StringMatchQ[password, "$Prompt"], 
              InvokeMethod[{"passwordDialog", "show"}];
              password = PropertyValue[{"passwordField", "text"}];
              sqlConn = sqlConn /. {("Password" -> _) -> ("Password" -> password)};
            ];
            conn = OpenSQLConnection[sqlConn];
            If[conn =!= Null && conn =!= $Failed,
              KeepJavaObject[conn[[2]]];
            ]
          ];
        ];
        InvokeMethod[{"dataSourceFrame", "dispose"}];
      ]
    ],

    BindEvent[{"cancel", "action"},
      Script[
        InvokeMethod[{"dataSourceFrame", "dispose"}];
      ]
    ],
    
    BindEvent["endModal",
      Script[
        conn
      ]
    ]
    
  }, Name -> "dataSourceFrame"
]
