Widget["Dialog", 
  {
    Script[Needs["DatabaseLink`"];],

    "modal" -> True,
    "title" -> "Edit JDBC Driver",
    
    "resizable"->False,

    Widget["Color", InitialArguments->{0,0,0}, Name->"black"],
    Widget["Color", InitialArguments->{255,0,0}, Name->"red"],                                     
    
    Widget["Panel", 
      {
       "preferredSize" -> 
          Widget["Dimension", {"width" -> 400, "height" -> 175}],
        WidgetGroup[
          {
            { 
              Widget["Label", {"text" -> "Name: "}, Name->"nameLabel"],
              Widget["ComboBox", 
                {
                  "editable" -> True, 
                  "autoComplete"->False,
                  "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                  PropertyValue[{"name", "editor"}, Name->"nameEditor"],
                  Script[                  
                    nec = WidgetReference["nameEditor"]@getEditorComponent[];
                    PropertyValue[{nec, "document"}, Name->"nameDocument"];
                  ],
                  (*
                  PropertyValue[{"nameEditor", "editorComponent"}, Name->"nameEditorComponent"],
                  PropertyValue[{"nameEditorComponent", "document"}, Name->"nameDocument"],
                  *)
                  BindEvent[{"nameDocument", "document"},
                    Script[ValidatePanel[];]],
                  BindEvent["action", 
                    Script[ValidatePanel[];]]
                }, Name -> "name"],
              Widget["Button", {"text"->"+"}, Name -> "add"]
            },
            { 
              Widget["Label", {"text" -> "Description: "}],
              Widget["TextField", Name -> "description"],
              WidgetFill[]
              
            },
            { 
              Widget["Label", {"text" -> "Location: "}, Name->"locationLabel"],
              Widget["ComboBox", 
                {
                  "editable" -> True, 
                  "autoComplete"->False,
                  "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                  PropertyValue[{"location", "editor"}, Name->"locationEditor"],
                  Script[
                    lec = WidgetReference["locationEditor"]@getEditorComponent[];   
                    PropertyValue[{lec, "document"}, Name->"locationDocument"];               
                  ],
                  (*
                  PropertyValue[{"locationEditor", "editorComponent"}, Name->"locationEditorComponent"],
                  PropertyValue[{"locationEditorComponent", "document"}, Name->"locationDocument"],
                  *)
                  BindEvent[{"locationDocument", "document"},
                    Script[ValidatePanel[];]],
                  BindEvent["action", 
                    Script[ValidatePanel[];]]
                }, Name -> "location"]
            }            
          }, WidgetLayout->Grid
        ],
        WidgetGroup[
          {
            WidgetGroup[
              {
                { 
                  Widget["Label", {"text" -> "Driver: "}, Name->"driverLabel"],
                  Widget["TextField", 
                    {
                      PropertyValue[{"driver", "document"}, Name -> "driverDocument"],
                      BindEvent[{"driverDocument", "document"},
                        Script[ValidatePanel[];]]
                    }, Name -> "driver"]
                },
                { 
                  Widget["Label", {"text" -> "Protocol: "}, Name->"protocolLabel"],
                  Widget["TextField", 
                    {
                      PropertyValue[{"protocol", "document"}, Name -> "protocolDocument"],
                      BindEvent[{"protocolDocument", "document"},
                        Script[ValidatePanel[];]]
                    }, Name -> "protocol"]
                }
              }, WidgetLayout -> Grid
            ]
          },
          WidgetLayout-> {"Border"->"JDBC Driver"}
        ],
        {
          WidgetFill[],
          Widget["Button", {"text" -> "Ok"}, Name -> "ok"],
          Widget["Button", {"text" -> "Cancel"}, Name -> "cancel" ],
          WidgetFill[]
        },
        WidgetFill[]
      }
    ],

    Script[
      shorten[str_String] := 
        If[StringLength[str] > 50, 
          StringTake[str, 25] <> "..." <> StringTake[str, -25], 
          str
        ];          

      locationChoices = DatabaseResourcesPath[];
      shortLocationChoices = (shorten /@ Drop[DatabaseResourcesPath[], {1, 2}]);
      PrependTo[shortLocationChoices, "$BaseDirectory/DatabaseResources"];
      PrependTo[shortLocationChoices, "$UserBaseDirectory/DatabaseResources"];
       
      initDialog[name_String] :=
        If[!MemberQ[JDBCDriverNames[], name], 
          SetPropertyValue[{"description", "text"}, ""];
          SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, ""]];
          SetPropertyValue[{"driver", "text"}, ""];
          SetPropertyValue[{"protocol", "text"}, ""],
      
          Block[{jdbc, pos, driver, protocol, file, description}, 
                    
            pos = First[Flatten[Position[JDBCDriverNames[], name]]];
            jdbc = JDBCDrivers[][[pos]];
                               
            description = "Description" /. Options[jdbc] /. Options[ JDBCDriver ]; 
            file = "Location" /. Options[jdbc] /. Options[ JDBCDriver ];
            driver = "Driver" /. Options[jdbc] /. Options[ JDBCDriver ]; 
            protocol = "Protocol" /. Options[jdbc] /. Options[ JDBCDriver ]; 
                                     
            SetPropertyValue[{"description", "text"}, description];
     
            locationChoices = Prepend[locationChoices, file];
            shortLocationChoices = Prepend[shortLocationChoices, shorten[file]];
            SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, file]];
            SetPropertyValue[{"location", "selectedItem"}, file];
                  
            SetPropertyValue[{"driver", "text"}, driver];
            SetPropertyValue[{"protocol", "text"}, protocol];             
          ]
        ];

      ValidatePanel[] := 
        Module[{txt, isValid1 = False, isValid2 = False, isValid3 = False, isValid4 = False, nec, loc},
          nec = WidgetReference["nameEditor"]@getEditorComponent[];
          txt = PropertyValue[{nec, "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["black"]];            
            isValid1 = True,
            SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["red"]];            
          ];
          lec = WidgetReference["locationEditor"]@getEditorComponent[];
          txt = PropertyValue[{lec, "text"}];
          If[ TrueQ[StringMatchQ[txt,"*.m"]],
            SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["black"]];            
            isValid2 = True,
            SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["red"]];            
          ];
          txt = PropertyValue[{"driver", "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"driverLabel", "foreground"}, WidgetReference["black"]];            
            isValid3 = True,
            SetPropertyValue[{"driverLabel", "foreground"}, WidgetReference["red"]];            
          ];
          txt = PropertyValue[{"protocol", "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"protocolLabel", "foreground"}, WidgetReference["black"]];            
            isValid4 = True,
            SetPropertyValue[{"protocolLabel", "foreground"}, WidgetReference["red"]];            
          ];
          SetPropertyValue[{"ok", "enabled"}, isValid1 && isValid2 && isValid3 && isValid4];
        ];  

    createDir[filename_String] :=
      Module[{
        file = filename, 
        dir = DirectoryName[filename], 
        shortfilename, 
        lst = {}}, 
        shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file]}];
        While[dir =!= file && FileNames[shortfilename, dir] == {},
          PrependTo[lst, shortfilename];
          file = dir;
          dir = DirectoryName[file];
          shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file] - 1}];
        ];
        If[lst === {}, Return[]];
        If[dir === file, lst = Drop[lst, 1]];
        lst = Drop[lst , -1];
        (file = ToFileName[file, #];
           CreateDirectory[file]) & /@ lst;
      ];

    ],

    BindEvent[{"jdbcDriverDialog", "windowActivated"},
      Script[
        If[WidgetReference["jdbcDriver"] =!= Null, 
          If[!MemberQ[JDBCDriverNames[], WidgetReference["jdbcDriver"]],
            SetPropertyValue[{"name", "items"}, 
              Prepend[JDBCDriverNames[], WidgetReference["jdbcDriver"]]],
            SetPropertyValue[{"name", "items"}, 
              Prepend[
                Select[JDBCDriverNames[], !StringMatchQ[#, WidgetReference["jdbcDriver"]]&], 
                WidgetReference["jdbcDriver"]
              ]
            ];
          ];
        ];
        SetWidgetReference["resultDriver", MakeJavaExpr[Null]];
        SetWidgetReference["jdbcDriver", MakeJavaExpr[Null]]
      ]
    ],

    BindEvent[{"name", "action"}, 
      Script[
        Block[{name}, 
          name = PropertyValue[{"name", "selectedItem"}];
          initDialog[name];
        ]  
      ] 
    ],

    BindEvent[{"location", "action"}, 
      Script[
        Block[{loc, file}, 
          loc = PropertyValue[{"location", "selectedIndex"}];
          If[loc > 0, 
            file = locationChoices[[loc]];
            If[StringMatchQ[file, "*\\"] || StringMatchQ[file, "/"], 
              file = ToFileName[file, PropertyValue[{"name", "selectedItem"}] <> ".m"];
            ];
            SetPropertyValue[{"location", "items"}, 
              Prepend[shortLocationChoices, file]];
            SetPropertyValue[{"location", "selectedItem"}, file];
          ]
        ]  
      ] 
    ],
    
    BindEvent[{"add", "action"}, 
      Script[
         SetPropertyValue[{"name", "items"}, Prepend[JDBCDriverNames[], ""]];
      ] 
    ],

    BindEvent[{"ok", "action"},
      Script[
        Block[{name, desc, loc, driver, prot},
          name   = PropertyValue[{"name", "selectedItem"}];
          desc   = PropertyValue[{"description", "text"}];
          loc    = PropertyValue[{"location", "selectedItem"}];
          driver   = PropertyValue[{"driver", "text"}];
          prot = PropertyValue[{"protocol", "text"}];
          drv = JDBCDriver[
                           "Name" -> name,
                           "Description" -> desc,
                           "Driver" -> driver, 
                           "Protocol" -> prot,
                           "Version"->DatabaseLink`Information`$VersionNumber];
          createDir[loc];
          Put[drv, loc];
          SetWidgetReference["resultDriver", name];
          InvokeMethod[{"jdbcDriverDialog", "dispose"}];
        ]
      ]
    ],
    
    BindEvent[{"cancel", "action"},
      Script[
        SetWidgetReference["resultDriver", Null];
        InvokeMethod[{"jdbcDriverDialog", "dispose"}];
      ]
    ]
  },
  Name -> "jdbcDriverDialog"
]