
Widget["Wizard", 
  {

    Script[Needs["DatabaseLink`"];],
    
    "title" -> "JDBC Driver Wizard",
    "sideBarTitle" -> "Steps",
    
    "pages" -> {
  
    Widget["WizardPage", {
      "title" -> "Overview",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["WizardHTMLPanel", {
        "text" -> "This wizard will help you create a JDBCDriver used to connect to a certain database with DatabaseLink."
          }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "<b>1. Overview</b><p>2. Specify Name and Description<p>3. Specify Driver Class<p>4. Specify Protocol<p>5. Choose Save Location<p>6. Review"
          }]
      }, Name -> "overviewPage"],
      
    Widget["WizardPage", {
      "title" -> "Name and Description",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateNameSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the name and description for this JDBCDriver.  <p><b>Name</b><br>The name should be unique among all JDBC drivers.  It is generally short and somewhat descriptive."}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"nameField", "document"}, Name -> "nameFieldDocument"],
          BindEvent[{"nameFieldDocument", "document"},
            Script[ ValidateNameSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateNameSourcePage[];]]
        }, Name -> "nameField"],
        Widget["WizardHTMLPanel", {
          "text" -> "<p><b>Description</b><br>The description can be any text that further describes the JDBCDriver."}],
        Widget["TextField", {
          "text" -> "",
          BindEvent["action", 
             Script[ ValidateNameSourcePage[];]]
        }, Name -> "descriptionField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the name and description, choose 'Next' to select a driver class."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p><b>2. Specify Name and Description</b><p>3. Specify Driver Class<p>4. Specify Protocol<p>5. Choose Save Location<p>6. Review"
          }]
      }, Name -> "nameChoicePage"],
            
    Widget["WizardPage", {
      "title" -> "Driver Class",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateDriverSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Select the JDBC driver class.  This class should be located on the Java classpath as directed by JLink.  It can be automatically found in the Java directory of this application or any other application.<p>Examples:<ul><li>org.hsqldb.jdbcDriver</li><li>com.mysql.jdbc.Driver</li></ul>"}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"driverField", "document"}, Name -> "driverFieldDocument"],
          BindEvent[{"driverFieldDocument", "document"},
            Script[ ValidateDriverSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateDriverSourcePage[];]]
        }, Name -> "driverField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the driver class, choose 'Next' to specify a protocol."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p><b>3. Specify Driver Class</b><p>4. Specify Protocol<p>5. Choose Save Location<p>6. Review"
          }]
      }, Name -> "driverChoicePage"],   
      
    Widget["WizardPage", {
      "title" -> "Protocol",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateProtocolSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the protocol used to prefix the URL which connects to the database.  By specifying the protocol users can omit the protocol when specifying a URL in a SQLConnection.  The protocol specified by the JDBCDriver is automatically prepended to the URL.<p>Examples:<ul><li>jdbc:hsqldb:</li><li>jdbc:mysql://</li></ul>"}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"protocolField", "document"}, Name -> "protocolFieldDocument"],
          BindEvent[{"protocolFieldDocument", "document"},
            Script[ ValidateProtocolSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateProtocolSourcePage[];]]
        }, Name -> "protocolField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the protocol, choose 'Next' to select the location to the save the JDBCDriver."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Driver Class<p><b>4. Specify Protocol</b><p>5. Choose Save Location<p>6. Review"
          }]
      }, Name -> "protocolChoicePage"],
      
    Widget["WizardPage", {
      "title" -> "Save Location",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          UpdateLocationField[];
        ]
      ],      
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Select the location to save the JDBCDriver.  <p>This should be on DatabaseResourcesPath[] if it is to be found by DatabaseLink automatically.  The items in the list are the directories on the DatabaseResourcesPath[].  Also the file name chosen should end with .m"}],
        Widget["ComboBox", 
          {
            "editable" -> True, 
            "autoComplete"->False,
            "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
            PropertyValue[{"locationField", "editor"}, Name->"locationFieldEditor"],
            Script[
              lec = WidgetReference["locationFieldEditor"]@getEditorComponent[];
              PropertyValue[{lec, "document"}, Name->"locationFieldDocument"];
            ], 
            (*
            PropertyValue[{"locationFieldEditor", "editorComponent"}, Name->"locationFieldEditorComponent"],
            PropertyValue[{"locationFieldEditorComponent", "document"}, Name->"locationFieldDocument"],
            *)
            BindEvent[{"locationFieldDocument", "document"},
              Script[ ValidateLocationSourcePage[];]],
            BindEvent["action", 
              Script[ ValidateLocationSourcePage[];]]
          }, Name -> "locationField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the location, choose 'Next' to verify and save the SQLConnection configuration."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Driver Class<p>4. Specify Protocol<p><b>5. Choose Save Location</b><p>6. Review"
          }]
      }, Name -> "locationChoicePage"], 
            
    Widget["WizardPage", {
      "title" -> "Review",
      "navigationNames" -> {"Back", "Finish", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          SetPropertyValue[{"reviewPanel", "text"}, buildReviewText[]];
        ]
      ],
      "content" -> Widget["WizardHTMLPanel", Name->"reviewPanel"],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Driver Class<p>4. Specify Protocol<p>5. Choose Save Location<p><b>6. Review</b>"}]
      }, Name -> "reviewPage"]

    },    
  
  Script[
    shorten[str_String] := 
      If[StringLength[str] > 50, 
        StringTake[str, 25] <> "..." <> StringTake[str, -25], 
        str
      ];          

    locationChoices = DatabaseResourcesPath[];
    shortLocationChoices = (shorten /@ Drop[DatabaseResourcesPath[], {1, 2}]);
    PrependTo[shortLocationChoices, "$BaseDirectory/DatabaseResources"];
    PrependTo[shortLocationChoices, "$UserBaseDirectory/DatabaseResources"];

    buildReviewText[] := 
      StringJoin[
        "<table border='1'>
          <tr><td>Name:</td><td>", PropertyValue[{"nameField", "text"}], "</td></tr>
          <tr><td>Description:</td><td>", PropertyValue[{"descriptionField", "text"}], "</td></tr>
          <tr><td>Driver:</td><td>", PropertyValue[{"driverField", "text"}], "</td></tr>
          <tr><td>Protocol:</td><td>", PropertyValue[{"protocolField", "text"}], "</td></tr>
          <tr><td>Location:</td><td>", PropertyValue[{"locationField", "selectedItem"}], "</td></tr>
         </table><br>", 
        If[FileNames[PropertyValue[{"locationField", "selectedItem"}]] =!= {},
          {"<b>Warning: ", PropertyValue[{"locationField", "selectedItem"}], " already exists?  Choose 'Back' to select a different file.</b><br><br>"},
          ""
        ], 
        "After reviewing the configuration, choose 'Finish' to save the JDBCDriver configuration."];

    ValidateNameSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"nameField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"nameChoicePage", "allowNext"}, isValid];
      ];

    ValidateLocationSourcePage[] := 
      Module[{txt, isValid = False, lec},
        lec = WidgetReference["locationFieldEditor"]@getEditorComponent[];
        txt = PropertyValue[{lec, "text"}];
        If[ TrueQ[StringMatchQ[txt,"*.m"]],
          isValid = True;
        ];
        SetPropertyValue[{"locationChoicePage", "allowNext"}, isValid];
      ];

    ValidateDriverSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"driverField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"driverChoicePage", "allowNext"}, isValid];
      ];

    ValidateProtocolSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"protocolField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"protocolChoicePage", "allowFinish"}, isValid];
      ];
    
    UpdateLocationField[] := 
      Module[{selected= PropertyValue[{"locationField", "selectedItem"}]},
        If[selected =!= Null,         
          SetPropertyValue[{"locationField", "items"}, Prepend[shortLocationChoices, selected]];
          SetPropertyValue[{"locationField", "selectedItem"}, selected],
          SetPropertyValue[{"locationField", "items"}, Prepend[shortLocationChoices, ""]];
        ]
      ];

    createDir[filename_String] :=
      Module[{
        file = filename, 
        dir = DirectoryName[filename], 
        shortfilename, 
        lst = {}}, 
        shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file]}];
        While[dir =!= file && FileNames[shortfilename, dir] == {},
          PrependTo[lst, shortfilename];
          file = dir;
          dir = DirectoryName[file];
          shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file] - 1}];
        ];
        If[lst === {}, Return[]];
        If[dir === file, lst = Drop[lst, 1]];
        lst = Drop[lst , -1];
        (file = ToFileName[file, #];
           CreateDirectory[file]) & /@ lst;
      ];
          
  ],
  
  BindEvent[{"locationField", "action"}, 
    Script[
      Block[{loc, file}, 
        loc = PropertyValue[{"locationField", "selectedIndex"}];
        If[loc > 0, 
          file = locationChoices[[loc]];
          If[StringMatchQ[file, "*\\"] || StringMatchQ[file, "/"], 
            file = ToFileName[file, PropertyValue[{"nameField", "text"}] <> ".m"];
          ];
          SetPropertyValue[{"locationField", "items"}, 
            Prepend[shortLocationChoices, file]];
          SetPropertyValue[{"locationField", "selectedItem"}, file];
        ]
      ]  
    ] 
  ],
  
  BindEvent[{"wizard", "wizardFinished"}, 
    Script[
      Block[{name, desc, loc, driver, protocol},
        name   = PropertyValue[{"nameField", "text"}];
        desc   = PropertyValue[{"descriptionField", "text"}];
        loc    = PropertyValue[{"locationField", "selectedItem"}];
        driver = PropertyValue[{"driverField", "text"}];
        protocol = PropertyValue[{"protocolField", "text"}];
        
        jdbc = JDBCDriver[
                          "Name" -> name,
                          "Description" -> desc,
                          "Driver" -> driver,
                          "Protocol" -> protocol,
                          "Version"->DatabaseLink`Information`$VersionNumber];
        createDir[loc];
        Put[jdbc, loc];
      ]
    ]
  ],
  
  BindEvent[{"wizard", "wizardDidReset"}, 
    Script[ 
      SetPropertyValue[{"nameField", "text"}, ""];
      SetPropertyValue[{"descriptionField", "text"}, ""];
      SetPropertyValue[{"driverField", "text"}, ""];
      SetPropertyValue[{"protocolField", "text"}, ""];
    ] 
  ]
  
}, Name -> "wizard"]
  