Widget["Dialog", 
  {
    Script[Needs["DatabaseLink`"];],

    "modal" -> True,
    "title" -> "Edit Connection",
    
    "resizable"->False, 
    
    Widget["Color", InitialArguments->{0,0,0}, Name->"black"],
    Widget["Color", InitialArguments->{255,0,0}, Name->"red"],
                                     
    Widget["Panel", 
      {
       "preferredSize" -> 
          Widget["Dimension", {"width" -> 400, "height" -> 240}],
        WidgetGroup[
          {
            { 
              Widget["Label", {"text" -> "Name: "}, Name->"nameLabel"],
              Widget["TextField", 
                {
                  PropertyValue[{"name", "document"}, Name -> "nameDocument"],
                  BindEvent[{"nameDocument", "document"},
                    Script[ ValidatePanel[];]]
                }, Name -> "name"],
              WidgetFill[]            
            },
            { 
              Widget["Label", {"text" -> "Description: "}],
              Widget["TextField", Name -> "description"],
              WidgetFill[]
              
            },
            { 
              Widget["Label", {"text" -> "Location: "}, Name->"locationLabel"],
              Widget["ComboBox", 
                {
                  "editable" -> True, 
                  "autoComplete"->False,
                  "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                  PropertyValue[{"location", "editor"}, Name->"locationEditor"],
                  Script[
                    lec = WidgetReference["locationEditor"]@getEditorComponent[];
                    PropertyValue[{lec, "document"}, Name->"locationDocument"];
                  ], 
                  (*
                  PropertyValue[{"locationEditor", "editorComponent"}, Name->"locationEditorComponent"],
                  PropertyValue[{"locationEditorComponent", "document"}, Name->"locationDocument"],
                  *)
                  BindEvent[{"locationDocument", "document"},
                    Script[ ValidatePanel[];]],
                  BindEvent["action", 
                    Script[ ValidatePanel[];]]
                }, Name -> "location"]
            }            
          }, WidgetLayout->Grid
        ],
        WidgetGroup[
          {    
            {
              WidgetGroup[
                {
                  { 
                    Widget["Label", {"text" -> "Driver: "}, Name->"driverLabel"],
                    Widget["ComboBox", 
                      {
                        "editable" -> True, 
                        "autoComplete"->False,
                        "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                        PropertyValue[{"driver", "editor"}, Name->"driverEditor"],
                        Script[
                          dec = WidgetReference["driverEditor"]@getEditorComponent[];
                          PropertyValue[{dec, "document"}, Name->"driverDocument"];
                        ], 
                        (*
                        PropertyValue[{"driverEditor", "editorComponent"}, Name->"driverEditorComponent"],
                        PropertyValue[{"driverEditorComponent", "document"}, Name->"driverDocument"],
                        *)
                        BindEvent[{"driverDocument", "document"},
                          Script[ ValidatePanel[];]],
                        BindEvent["action", 
                          Script[ ValidatePanel[];]]
                      }, Name->"driver"],
                    Widget["Button", {"text"->"Properties"}, Name -> "driverButton"]
                  },
                  { 
                    Widget["Label", {"text" -> "URL: "}, Name->"urlLabel"],
                    Widget["TextField",
                      {
                        PropertyValue[{"url", "document"}, Name -> "urlDocument"],
                        BindEvent[{"urlDocument", "document"},
                          Script[ ValidatePanel[];]]
                      }, Name -> "url"],
                    Widget["CheckBox", {"text"->"Relative"}, Name-> "relative"]
                  },
                  { 
                    Widget["Label", {"text" -> "Username: "}],
                    Widget["TextField", Name -> "username"],
                    WidgetFill[]
                  },
                  { 
                    WidgetFill[],
                    Widget["CheckBox", {"text"->"Prompt for password"}, Name-> "prompt"], 
                    WidgetFill[]
                  }
                }, WidgetLayout -> Grid              
              ]
            }
          },
          WidgetLayout-> {"Border"->"Database"}
        ],
        {
          WidgetFill[],
          Widget["Button", {"text" -> "Ok"}, Name -> "ok"],
          Widget["Button", {"text" -> "Cancel"}, Name -> "cancel" ],
          WidgetFill[]
        }, 
        WidgetFill[]
      }
    ],

    Script[
      shorten[str_String] := 
        If[StringLength[str] > 50, 
          StringTake[str, 25] <> "..." <> StringTake[str, -25], 
          str
        ];          

      locationChoices = DatabaseResourcesPath[];
      shortLocationChoices = (shorten /@ Drop[DatabaseResourcesPath[], {1, 2}]);
      PrependTo[shortLocationChoices, "$BaseDirectory/DatabaseResources"];
      PrependTo[shortLocationChoices, "$UserBaseDirectory/DatabaseResources"];

      ValidatePanel[] := 
        Module[{txt, isValid1 = False, isValid2 = False, isValid3 = False, isValid4 = False, lec, dec},
          txt = PropertyValue[{"name", "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["black"]];            
            isValid1 = True,
            SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["red"]];            
          ];
          lec = WidgetReference["locationEditor"]@getEditorComponent[];
          txt = PropertyValue[{lec, "text"}];
          If[ TrueQ[StringMatchQ[txt,"*.m"]],
            SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["black"]];            
            isValid2 = True,
            SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["red"]];            
          ];
          txt = PropertyValue[{"url", "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"urlLabel", "foreground"}, WidgetReference["black"]];            
            isValid3 = True,
            SetPropertyValue[{"urlLabel", "foreground"}, WidgetReference["red"]];            
          ];
          dec = WidgetReference["driverEditor"]@getEditorComponent[];
          txt = PropertyValue[{dec, "text"}];
          If[ TrueQ[txt =!= ""],
            SetPropertyValue[{"driverLabel", "foreground"}, WidgetReference["black"]];            
            isValid4 = True,
            SetPropertyValue[{"driverLabel", "foreground"}, WidgetReference["red"]];            
          ];
          SetPropertyValue[{"ok", "enabled"}, isValid1 && isValid2 && isValid3 && isValid4];
        ];

      GetWindow[] :=   
        Module[{window = WidgetReference["sqlConnectionDialog"],
                next = PropertyValue[{"sqlConnectionDialog", "parent"}]},
          While[next =!= Null,
            window = next;           
            next = PropertyValue[{window, "parent"}];
          ];
          window
        ];

      jdbcDriver = Null;

      createDir[filename_String] :=
        Module[{
          file = filename, 
          dir = DirectoryName[filename], 
          shortfilename, 
          lst = {}}, 
          shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file]}];
          While[dir =!= file && FileNames[shortfilename, dir] == {},
            PrependTo[lst, shortfilename];
            file = dir;
            dir = DirectoryName[file];
            shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file] - 1}];
          ];
          If[lst === {}, Return[]];
          If[dir === file, lst = Drop[lst, 1]];
          lst = Drop[lst , -1];
          (file = ToFileName[file, #];
             CreateDirectory[file]) & /@ lst;
        ];
      
    ],

    BindEvent[{"sqlConnectionDialog", "windowActivated"},
      Script[
        If[WidgetReference["connection"] === "", 
          SetPropertyValue[{"name", "text"}, ""];
          SetPropertyValue[{"description", "text"}, ""];
          SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, ""]];
          SetPropertyValue[{"driver", "items"}, Prepend[JDBCDriverNames[], ""]];
          SetPropertyValue[{"url", "text"}, ""];
          SetPropertyValue[{"username", "text"}, ""];
          password = "", 

          If[WidgetReference["connection"] =!= Null, 
            Block[{conn, username, name, driver, url, description, file, relative}, 
              
              conn = WidgetReference["connection"];
              
              name = "Name" /. Options[conn] /. Options[ SQLConnection ]; 
              description = "Description" /. Options[conn] /. Options[ SQLConnection ]; 
              username = "Username" /. Options[conn] /. Options[ SQLConnection ]; 
              password = "Password" /. Options[conn] /. Options[ SQLConnection ]; 
              relative = "RelativePath" /. Options[conn] /. Options[ SQLConnection ]; 
              file = "Location" /. Options[conn] /. Options[ SQLConnection ];
              
              driver = conn[[1,1]];
              url = conn[[1,2]];
              
              SetPropertyValue[{"name", "text"}, name];
              SetPropertyValue[{"description", "text"}, description];

              locationChoices = Prepend[locationChoices, file];
              shortLocationChoices = Prepend[shortLocationChoices, shorten[file]];
              SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, file]];
              SetPropertyValue[{"location", "selectedItem"}, file];
            
              If[MemberQ[JDBCDriverNames[], driver], 
                SetPropertyValue[{"driver", "items"}, JDBCDriverNames[]];
                SetPropertyValue[{"driver", "selectedItem"}, driver],
                SetPropertyValue[{"driver", "items"}, Prepend[JDBCDriverNames[], driver]]
              ];
              SetPropertyValue[{"url", "text"}, url];
              SetPropertyValue[{"relative", "selected"}, relative];
              SetPropertyValue[{"username", "text"}, username];
              If[password === "$Prompt", 
                SetPropertyValue[{"prompt", "selected"}, True],
                SetPropertyValue[{"prompt", "selected"}, False]
              ];
            ]
          ]
        ];
        SetWidgetReference["connection", ""]
      ]
    ],

    BindEvent[{"location", "action"}, 
      Script[
        Block[{loc, file}, 
          loc = PropertyValue[{"location", "selectedIndex"}];
          If[loc > 0, 
            file = locationChoices[[loc]];
            If[StringMatchQ[file, "*\\"] || StringMatchQ[file, "/"], 
              file = ToFileName[file, PropertyValue[{"name", "text"}] <> ".m"];
            ];
            SetPropertyValue[{"location", "items"}, 
              Prepend[shortLocationChoices, file]];
            SetPropertyValue[{"location", "selectedItem"}, file];
          ]
        ]  
      ] 
    ],
                
    BindEvent[{"driverButton", "action"}, 
      Script[
        If[jdbcDriver === Null, 
          jdbcDriver =         
            Widget["DatabaseLink/Dialogs/JDBCDriver",
              Name->"jdbcDriverDialog",
              ExposeWidgetReferences -> {"resultDriver"},
              InitialArguments->{Script[GetWindow[]]}];
        ];
        SetWidgetReference["jdbcDriver", PropertyValue[{"driver", "selectedItem"}]];
        InvokeMethod[{"jdbcDriverDialog", "show"}];
        Block[{drvr},
          drvr = WidgetReference["resultDriver"];
          If[drvr === Null, 
            drvr = PropertyValue[{"driver", "selectedItem"}];
          ];
          SetPropertyValue[{"driver", "items"}, JDBCDriverNames[]];
          SetPropertyValue[{"driver", "selectedItem"}, drvr]
        ]
      ] 
    ],

    BindEvent[{"ok", "action"},
      Script[
        Block[{name, desc, loc, driver, url, user, passwd, conn},
          name   = PropertyValue[{"name", "text"}];
          desc   = PropertyValue[{"description", "text"}];
          loc    = PropertyValue[{"location", "selectedItem"}];
          driver = PropertyValue[{"driver", "selectedItem"}];
          url    = PropertyValue[{"url", "text"}];
          user   = PropertyValue[{"username", "text"}];
          rel    = PropertyValue[{"relative", "selected"}];

          If[PropertyValue[{"prompt", "selected"}], 
            passwd = "$Prompt", 
            If[password === "$Prompt", 
              passwd = "", 
              passwd = password
            ]
          ];        

          conn = SQLConnection[JDBC[driver, url],
                               "Name" -> name,
                               "Description" -> desc,
                               "Username" -> user, 
                               "Password" -> passwd,
                               "RelativePath" -> TrueQ[rel],
                               "Version"->DatabaseLink`Information`$VersionNumber];
          createDir[loc];
          Put[conn, loc];          
          InvokeMethod[{"sqlConnectionDialog", "dispose"}];
        ]
      ]
    ],
    
    BindEvent[{"cancel", "action"},
      Script[
        InvokeMethod[{"sqlConnectionDialog", "dispose"}];
      ]
    ]
  },
  Name -> "sqlConnectionDialog", ExposeWidgetReferences -> {"jdbcDriver"}
]