
Widget["Wizard", 
  {
  
    Script[Needs["DatabaseLink`"];],
       
    "title" -> "SQLConnection Wizard",
    "sideBarTitle" -> "Steps",
    
    "pages" -> {
  
    Widget["WizardPage", {
      "title" -> "Overview",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["WizardHTMLPanel", {
        "text" -> "This wizard will help you create a SQLConnection used to connect to a data source with DatabaseLink."
          }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "<b>1. Overview</b><p>2. Specify Name and Description<p>3. Select Type of Database<p>4. Specify URL<p>5. Specify Username and Password<p>6. Choose Save Location<p>7. Review"
          }]
      }, Name -> "overviewPage"],
      
    Widget["WizardPage", {
      "title" -> "Name and Description",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateNameSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the name and description for this SQLConnection.  <p><b>Name</b><br>The name should be unique among all data sources.  It is generally short and somewhat descriptive."}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"nameField", "document"}, Name -> "nameFieldDocument"],
          BindEvent[{"nameFieldDocument", "document"},
            Script[ ValidateNameSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateNameSourcePage[];]]
        }, Name -> "nameField"],
        Widget["WizardHTMLPanel", {
          "text" -> "<p><b>Description</b><br>The description can be any text that further describes the SQLConnection."}],
        Widget["TextField", {
          "text" -> "",
          BindEvent["action", 
             Script[ ValidateNameSourcePage[];]]
        }, Name -> "descriptionField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the name and description, choose 'Next' to select a database."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p><b>2. Specify Name and Description</b><p>3. Select Type of Database<p>4. Specify URL<p>5. Specify Username and Password<p>6. Choose Save Location<p>7. Review"
          }]
      }, Name -> "nameChoicePage"],
            
    Widget["WizardPage", {
      "title" -> "Type of Database",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          UpdateDatabaseField[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Select the type of database."}],
        Widget["ComboBox", {"editable" -> False, 
                            "autoComplete"->False,
                            "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                            "items" ->JDBCDriverNames[]
                           }, 
                           Name -> "databaseField"],
        {
          Widget["Button", {"text"->"New"}, Name -> "databaseNewButton"],
          Widget["Button", {"text"->"Properties"}, Name -> "databasePropertiesButton"]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the type of database, choose 'Next' to specify a URL."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p><b>3. Select Type of Database</b><p>4. Specify URL<p>5. Specify Username and Password<p>6. Choose Save Location<p>7. Review"
          }]
      }, Name -> "databaseChoicePage"],   
      
    Widget["WizardPage", {
      "title" -> "URL",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateUrlSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the URL used to connect to the database.  The protocol will be assigned based on the database that was chosen in the previous step.  If the URL specifies a file, the path can be made relative by checking the box below."}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"urlField", "document"}, Name -> "urlFieldDocument"],
          BindEvent[{"urlFieldDocument", "document"},
            Script[ ValidateUrlSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateUrlSourcePage[];]]
        }, Name -> "urlField"],
        Widget["CheckBox", {
          "text" -> "Relative Path"
        }, Name -> "relativePathCheckBox"],
        Widget["WizardHTMLPanel", {
          "text" -> "<p>Examples:<ul><li>localhost:3324/test<li>c:/databases/test<li>Examples/dbcreate</ul><p>After specifying the URL, choose 'Next' to specify a username and password."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Select Type of Database<p><b>4. Specify URL</b><p>5. Specify Username and Password<p>6. Choose Save Location<p>7. Review"
          }]
      }, Name -> "urlChoicePage"],   
      
    Widget["WizardPage", {
      "title" -> "Username and Password",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the username used to authenticate this SQLConnection.  Select the checkbox to prompt for password.  The password will be an empty string if not checked.<p><b>Username</b>"}],
        Widget["TextField", {"text" -> ""}, Name -> "usernameField"],
        Widget["CheckBox", {"text" -> "Prompt for password?"}, Name -> "promptCheckBox"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the username and password, choose 'Next' to select the location to the save the SQLConnection."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Select Type of Database<p>4. Specify URL<p><b>5. Specify Username and Password</b><p>6. Choose Save Location<p>7. Review"
          }]
      }, Name -> "usernameChoicePage"],
      
    Widget["WizardPage", {
      "title" -> "Save Location",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          UpdateLocationField[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Select the location to save the SQLConnection.  <p>This should be on DatabaseResourcesPath[] if it is to be found by DatabaseLink automatically.  The items in the list are the directories on the DatabaseResourcesPath[].  Also the file name chosen should end with .m"}],
        Widget["ComboBox", 
          {
            "editable" -> True, 
            "autoComplete"->False,
            "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
            PropertyValue[{"locationField", "editor"}, Name->"locationFieldEditor"],
            Script[
              lec = WidgetReference["locationFieldEditor"]@getEditorComponent[];
              PropertyValue[{lec, "document"}, Name->"locationFieldDocument"];
            ],
            (*
            PropertyValue[{"locationFieldEditor", "editorComponent"}, Name->"locationFieldEditorComponent"],
            PropertyValue[{"locationFieldEditorComponent", "document"}, Name->"locationFieldDocument"],
            *)
            BindEvent[{"locationFieldDocument", "document"},
              Script[ ValidateLocationSourcePage[];]],
            BindEvent["action", 
              Script[ ValidateLocationSourcePage[];]]
          }, Name -> "locationField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the location, choose 'Next' to verify and save the SQLConnection configuration."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Select Type of Database<p>4. Specify URL<p>5. Specify Username and Password<p><b>6. Choose Save Location</b><p>7. Review"
          }]
      }, Name -> "locationChoicePage"], 

    Widget["WizardPage", {
      "title" -> "Review",
      "navigationNames" -> {"Back", "Finish", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          SetPropertyValue[{"reviewPanel", "text"}, buildReviewText[]];
        ]
      ],
      "content" -> Widget["WizardHTMLPanel", Name->"reviewPanel"],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Select Type of Database<p>4. Specify URL<p>5. Specify Username and Password<p>6. Choose Save Location<p><b>7. Review</b>"          }]
      }, Name -> "reviewPage"]
    },
          
  Script[
    shorten[str_String] := 
      If[StringLength[str] > 50, 
        StringTake[str, 25] <> "..." <> StringTake[str, -25], 
        str
      ];          

    locationChoices = DatabaseResourcesPath[];
    shortLocationChoices = (shorten /@ Drop[DatabaseResourcesPath[], {1, 2}]);
    PrependTo[shortLocationChoices, "$BaseDirectory/DatabaseResources"];
    PrependTo[shortLocationChoices, "$UserBaseDirectory/DatabaseResources"];
    
    jdbcDriverDialog = Null;
    jdbcDriverWizardDialog = Null;

    buildReviewText[] := 
      StringJoin[
        "<table border='1'>
          <tr><td>Name:</td><td>", PropertyValue[{"nameField", "text"}], "</td></tr>
          <tr><td>Description:</td><td>", PropertyValue[{"descriptionField", "text"}], "</td></tr>
          <tr><td>Database:</td><td>", PropertyValue[{"databaseField", "selectedItem"}], "</td></tr>
          <tr><td>URL:</td><td>", PropertyValue[{"urlField", "text"}], "</td></tr>
          <tr><td>Username:</td><td>", PropertyValue[{"usernameField", "text"}], "</td></tr>
          <tr><td>Location:</td><td>", PropertyValue[{"locationField", "selectedItem"}], "</td></tr>
         </table><br>", 
        If[FileNames[PropertyValue[{"locationField", "selectedItem"}]] =!= {},
          {"<b>Warning: ", PropertyValue[{"locationField", "selectedItem"}], " already exists?  Choose 'Back' to select a different file.</b><br><br>"},
          ""
        ], 
        "After reviewing the configuration, choose 'Finish' to save the SQLConnection configuration."];

    ValidateNameSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"nameField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"nameChoicePage", "allowNext"}, isValid];
      ];

    ValidateLocationSourcePage[] := 
      Module[{txt, isValid = False, lec},
        lec = WidgetReference["locationFieldEditor"]@getEditorComponent[];
        txt = PropertyValue[{lec, "text"}];
        If[ TrueQ[StringMatchQ[txt,"*.m"]],
          isValid = True;
        ];
        SetPropertyValue[{"locationChoicePage", "allowNext"}, isValid];
      ];

    ValidateUrlSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"urlField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"urlChoicePage", "allowNext"}, isValid];
      ];
    
    UpdateLocationField[] := 
      Module[{selected= PropertyValue[{"locationField", "selectedItem"}]},
        If[selected =!= Null,         
          SetPropertyValue[{"locationField", "items"}, Prepend[shortLocationChoices, selected]];
          SetPropertyValue[{"locationField", "selectedItem"}, selected],
          SetPropertyValue[{"locationField", "items"}, Prepend[shortLocationChoices, ""]];
        ]
      ];

    UpdateDatabaseField[] := 
      Module[{selected= PropertyValue[{"databaseField", "selectedItem"}]},       
        If[selected =!= Null,         
          SetPropertyValue[{"databaseField", "items"}, JDBCDriverNames[]];
          SetPropertyValue[{"databaseField", "selectedItem"}, selected],
          SetPropertyValue[{"databaseField", "items"}, JDBCDriverNames[]];
        ];
      ];

    GetWindow[] :=   
      Module[{window = WidgetReference["sqlConnectionWizard"],
              next = PropertyValue[{"sqlConnectionWizard", "parent"}]},
        While[next =!= Null,
          window = next;           
          next = PropertyValue[{window, "parent"}];
        ];
        window
      ];    
                
    createDir[filename_String] :=
      Module[{
        file = filename, 
        dir = DirectoryName[filename], 
        shortfilename, 
        lst = {}}, 
        shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file]}];
        While[dir =!= file && FileNames[shortfilename, dir] == {},
          PrependTo[lst, shortfilename];
          file = dir;
          dir = DirectoryName[file];
          shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file] - 1}];
        ];
        If[lst === {}, Return[]];
        If[dir === file, lst = Drop[lst, 1]];
        lst = Drop[lst , -1];
        (file = ToFileName[file, #];
           CreateDirectory[file]) & /@ lst;
      ];
  ],
    
  BindEvent[{"locationField", "action"}, 
    Script[
      Block[{loc, file}, 
        loc = PropertyValue[{"locationField", "selectedIndex"}];
        If[loc > 0, 
          file = locationChoices[[loc]];
          If[StringMatchQ[file, "*\\"] || StringMatchQ[file, "/"], 
            file = ToFileName[file, PropertyValue[{"nameField", "text"}] <> ".m"];
          ];
          SetPropertyValue[{"locationField", "items"}, 
            Prepend[shortLocationChoices, file]];
          SetPropertyValue[{"locationField", "selectedItem"}, file];
        ]
      ]  
    ] 
  ],
  
  BindEvent[{"sqlConnectionWizard", "wizardFinished"}, 
    Script[
      Block[{name, desc, loc, driver, url, user, passwd, conn},
        name   = PropertyValue[{"nameField", "text"}];
        desc   = PropertyValue[{"descriptionField", "text"}];
        loc    = PropertyValue[{"locationField", "selectedItem"}];
        driver = PropertyValue[{"databaseField", "selectedItem"}];
        url    = PropertyValue[{"urlField", "text"}];
        user   = PropertyValue[{"usernameField", "text"}];
        If[PropertyValue[{"promptCheckBox", "selected"}], 
          passwd = "$Prompt", 
          passwd = ""
        ];
          
        rel    = PropertyValue[{"relativePathCheckBox", "selected"}];
        
        conn = SQLConnection[JDBC[driver, url],
                               "Name" -> name,
                               "Description" -> desc,
                               "Username" -> user, 
                               "Password" -> passwd,
                               "RelativePath"->TrueQ[rel],
                               "Version"->DatabaseLink`Information`$VersionNumber];
        createDir[loc];
        Put[conn, loc];          
      ]
    ]
  ],
  
  BindEvent[{"sqlConnectionWizard", "wizardDidReset"}, 
    Script[ 
      SetPropertyValue[{"nameField", "text"}, ""];
      SetPropertyValue[{"descriptionField", "text"}, ""];
      SetPropertyValue[{"databaseField", "selectedIndex"}, 0];
      SetPropertyValue[{"urlField", "text"}, ""];
      SetPropertyValue[{"usernameField", "text"}, ""];
      SetPropertyValue[{"relativePathCheckBox", "selected"}, False];
      SetPropertyValue[{"promptCheckBox", "selected"}, False];
    ] 
  ],

  BindEvent[{"databasePropertiesButton", "action"}, 
    Script[
      If[jdbcDriverDialog === Null, 
        jdbcDriverDialog = 
          Widget["DatabaseLink/Dialogs/JDBCDriver", 
            Name -> "jdbcDriverDialog",
            InitialArguments->{Script[GetWindow[]]}];
      ];
      SetWidgetReference["jdbcDriver", PropertyValue[{"databaseField", "selectedItem"}]];
      InvokeMethod[{"jdbcDriverDialog", "show"}];
    ] 
  ],

  BindEvent[{"databaseNewButton", "action"}, 
    Script[
      If[jdbcDriverWizardDialog === Null, 
        jdbcDriverWizardDialog = 
          Widget["DatabaseLink/Dialogs/JDBCDriverWizardDialog", 
            Name ->"jdbcDriverWizardDialog",
            InitialArguments->{Script[GetWindow[]]}];
      ];
      InvokeMethod[{"jdbcDriverWizardDialog", "reset"}];
      InvokeMethod[{"jdbcDriverWizardDialog", "show"}];
      UpdateDatabaseField[];
    ] 
  ]
  
}, Name -> "sqlConnectionWizard"]
    