/*
 * Created on Jul 13, 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.wolfram.databaselink.gui;

import java.awt.BorderLayout;
import java.util.ArrayList;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;

import com.odellengineeringltd.glazedlists.*;
import com.odellengineeringltd.glazedlists.jtable.*;
import com.wolfram.jlink.Expr;

/**
 * @author chrisw
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ConditionPanel extends JPanel{

    protected String operator = "AND";
    public BasicEventList conditions = null;
    public ListTable listTable = null;
    public JList list = null;

    private boolean enabled = true;

    private static final Expr SYM_AND = new Expr(Expr.SYMBOL, "And");
    private static final Expr SYM_OR = new Expr(Expr.SYMBOL, "Or");
    private static final Expr SYM_LIST = new Expr(Expr.SYMBOL, "List");
    private static final Expr SYM_NONE = new Expr(Expr.SYMBOL, "None");

    public ConditionPanel()
    {
        super(new BorderLayout());

        conditions = new BasicEventList();
        listTable = new WritableListTable(conditions, new ConditionTableCell());
        add(listTable.getTableScrollPane(), BorderLayout.CENTER);

        listTable.getTable().setRowHeight(25);
    }

    public String getOperator()
    {
        return operator;
    }

    public void setOperator(String operator)
    {
        this.operator = operator;
    }

    public void addCondition(Condition condition)
    {
        condition.setConditionPanel(this);
        conditions.add(condition);
        condition.setEnabled(enabled);

        Condition c = (Condition)conditions.get(0);
        if(conditions.size() == 1)
            c.setRemoveButtonEnabled(false);
        if(conditions.size() > 1)
            c.setRemoveButtonEnabled(true);
    }

    public void removeCondition(Condition condition)
    {
        JTable table = listTable.getTable();
        if( table.isEditing() )
        {
            int row = table.getEditingRow();
            int col = table.getEditingColumn();
            table.getCellEditor(row, col).stopCellEditing();
            if(row >= 0)
            {
              conditions.remove(row);

              Condition c = (Condition)conditions.get(0);
              if(conditions.size() == 1)
                  c.setRemoveButtonEnabled(false);
              if(conditions.size() > 1)
                  c.setRemoveButtonEnabled(true);

              listTable.fireTableDataChanged();
            }
        }
    }

    public void setConditions(Condition[] array)
    {
        conditions.clear();
        for(int i = 0; i < array.length; i++)
        {
            addCondition(array[i]);
        }
    }

    public Condition[] getConditions()
    {
        return ((Condition[])conditions.toArray(new Condition[conditions.size()]));
    }

    public int count()
    {
      return conditions.size();
    }

    public String toString()
    {
        StringBuffer buf = new StringBuffer("");
        for(int i = 0; i < conditions.size(); i++)
        {
            buf.append(((Condition)conditions.get(i)).toString());
            if(i != conditions.size() - 1)
                buf.append(operator);
        }
        return buf.toString();
    }

    public Expr toExpr()
    {
        ArrayList arrayList = new ArrayList();
        for(int i = 0; i < conditions.size(); i++)
        {
            Expr expr = ((Condition)conditions.get(i)).toExpr();
            if(expr != null)
                arrayList.add(expr);
        }
        Expr sym = null;
        if(operator == null)
            return null;
        if(operator.equalsIgnoreCase("AND"))
            sym = SYM_AND;
        if(operator.equalsIgnoreCase("OR"))
            sym = SYM_OR;
        if(operator.equalsIgnoreCase("LIST"))
            sym = SYM_LIST;
        if(arrayList.size() < 1)
            return SYM_NONE;
        return new Expr(sym, (Expr[])arrayList.toArray(new Expr[arrayList.size()]));
    }

    public void setEnabled(boolean e)
    {
        enabled = e;
        JTable table = listTable.getTable();
        stopEditing();
        for(int i = 0; i < table.getRowCount(); i++)
        {
            Condition condition = ((Condition)table.getValueAt(i,0));
            condition.setEnabled(e);
        }
        listTable.fireTableDataChanged();
    }

    public boolean isEnabled()
    {
        return enabled;
    }

    public void stopEditing()
    {
        JTable table = listTable.getTable();
        if( table.isEditing() )
        {
            int row = table.getEditingRow();
            int col = table.getEditingColumn();
            table.getCellEditor(row, col).stopCellEditing();
            Condition cond = (Condition)table.getValueAt(row,col);
            cond.stopEditing();
        }

    }

    public void dataChanged()
    {
        listTable.fireTableDataChanged();
    }
}
