# Python 2.1.1 or newer setup style build information
# You will need to change the include_dirs and library_dirs
# entries to locations appropriate for your installation of
# the MathLink library.
import sys,re
from distutils.core import setup, Extension

pythonlinkversion = "0.0.3"

if(not re.search(r'win32',sys.platform)):
	setup(name="mathlink", version=pythonlinkversion, 
		ext_modules=[
			Extension(
				"mathlink",
				["mathlink.c"],
				include_dirs = ["/usr/local/Wolfram/Mathematica/5.0/AddOns/MathLink/DeveloperKit/Linux/CompilerAdditions"],
				library_dirs = ["/usr/local/Wolfram/Mathematica/5.0/AddOns/MathLink/DeveloperKit/Linux/CompilerAdditions"],
				libraries = ["ML","m"]
			)
		]
	)
elif(re.search(r'win32',sys.platform)):
	setup(name="mathlink",version=pythonlinkversion,
		ext_modules=[
			Extension(
				"mathlink",
				["mathlink.c"],
				include_dirs = ["C:\\Program Files\\Wolfram Research\\Mathematica\\5.0\\AddOns\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\include"],
				library_dirs = ["C:\\Program Files\\Wolfram Research\\Mathematica\\5.0\\AddOns\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\lib"],
				define_macros=[("WINDOWS_MATHLINK",None)],
				libraries = ["ml32i2"]
			)
		]
	)

print "\nFinished building the mathlink extionsion module version %s." % (pythonlinkversion)
