(* :Name: Algebra`Horner` *)

(* :Title: Horner Form Factorization Of Polynomials. *)

(* :Author: Mark Sofroniou *)

(* :Summary:
This package adds the function Horner for factoring univariate and
multivariate polynomials in efficient computational form.
*)

(* :Context: Algebra`Horner` *)

(* :Package Version: 1.1 *)

(* :Copyright: Copyright 1995-2005, Wolfram Research, Inc.
*)

(* :History:
 Tidied up the interface, February 1997.
 Rewritten for release with version 3.0, November 1995.
 (Original Version by Mark Sofroniou, September 1993.) *)

(* :Keywords:
 Horner, Nested, Polynomial. *)

(* :Source:
 D. E. Knuth, The Art of Computer Programming  Vol 2: Seminumerical Algorithms,
 Second Edition, Addison Wesley, New York, 1981. *)

(* :Mathematica Version: 3.0 *)

(* :Limitations:
 Stack recursion limits. *)

(* :Discussion:
Pre-conditioning of the coefficients can sometimes improve numerical stability
and further reduce the operation count.  Various other considerations arise such
as if the polynomial is not dense, if we require evaluations on an evenly spaced
grid, or if computations are performed in parallel.

The continued fraction form is usually preferable for rational functions
of polynomials.
*)

BeginPackage["Algebra`Horner`"]

Horner::usage = "Horner[p] gives the polynomial or rational function of
polynomials p in Horner or nested form with respect to the default variables
Variables[p].  Horner[p, v] gives p in Horner form with respect
to the variable or variable list v.  Horner[p1/p2, v1, v2] gives the
rational function of polynomials p1/p2 in Horner form using the variables
or variable lists v1 and v2 for p1 and p2 respectively."

Unprotect[Horner];

Begin["`Private`"]

(* Now implemented as a StartUp package *)

Horner[ args__ ]:=
  Module[{ans},
    ans = Algebra`Horner[args];
    ans /; UnsameQ[Head[ans], Algebra`Horner]
  ];

End[]; (* End `Private` context. *)

(* Protect exported symbols. *)

SetAttributes[Horner, {Protected, ReadProtected}];

EndPackage[]; (* End package context. *)
