(*:Copyright: Copyright 1988-2005 Wolfram Research, Inc. *)

(*:Mathematica Version: 5.0 *)

(*:Package Version: 2.0 *)

(*:Name: Algebra`SymmetricPolynomials` *)

(*:Title: The Fundamental Theorem of Symmetric Polynomials *) 

(*:Author: Adam Strzebonski *)

(*:Keywords: symmetric polynomials, elementary symmetric polynomials *)

(*:Sources: T.Becker, V.Weispfenning, "Groebner bases. A computational
   approach to commutative algebra", Springer-Verlag 1993, section 10.7. 
*)

(*:Summary:
The Fundamental Theorem of Symmetric Polynomials says that
every symmetric polynomial in x_1, ..., x_n can be represented
as a polynomial in elementary symmetric polynomials:

s_1 = x_1 + x_2 + ... + x_n
s_2 = x_1*x_2 + x_1*x_3 + ... + x_{n-1}*x_n
...
s_n = x_1*x_2*...*x_n

When the ordering of variables is fixed, every polynomial can
be uniquely represented as a sum of its "symmetric part" and
the "remainder":

f(x1,...,xn) = p(s1,...,sn) + q(x1,...,xn),

The polynomial f is symmetric if and only if the remainder q is
zero. The uniqueness of this representation is guaranteed by
requiring that q does not contain descending monomials, where
a monomial c*x_1^e_1* ... *x_n^e_n is called descending iff
e_1>=...>=e_n.
   
Function SymmetricReduction[f, {x1,...,xn}] gives the symmetic part 
and the remainder of f as a polynomial in x1, ..., xn.
SymmetricReduction[f, {x1,...,xn}, {s1,...,sn}] gives the symmetic
part and the remainder of f as a polynomial in x1, ..., xn,
with the elementary symmetric polynomials replaced by s1, ..., sn.
   
Function SymmetricPolynomial[{x1,...,xn}, k] gives the k-th symmetric 
polynomial of variables {x1,...,xn}.

The functions are implemented in the kernel. The package just introduces
their usage messages.
*)

BeginPackage["Algebra`SymmetricPolynomials`"]

SymmetricReduction::usage = "SymmetricReduction[f, {x1,...,xn}] gives a pair {p, q} of polynomials such that f=p+q, p is a polynomial in the elementary symmetric polynomials in x1,...,xn and q does not contain descending terms, in particular q is zero iff f is symmetric. SymmetricReduction[f, {x1,...,xn}, {s1,...,sn}] gives the pair {p, q} with the elementary symmetric polynomials in p replaced by s1,...,sn."

SymmetricPolynomial::usage = "SymmetricPolynomial[{x1,...,xn}, k] gives the k-th symmetric polynomial of variables {x1,...,xn}."

EndPackage[]  (* Algebra`SymmetricPolynomials` *)

            
