(* :Title: Master Declarations File for Geometry *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:18 *)

If[! MemberQ[$Packages, "Geometry`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Geometry`"];
     Protect @@ System`Private`p
];

(* Declarations for package Geometry`Polytopes` *)

DeclarePackage["Geometry`Polytopes`",
     {"Area", "CircumscribedRadius", "Cube", "Decagon", "Digon", "Dodecagon", 
      "Dodecahedron", "Dual", "Faces", "Heptagon", "Hexagon", "Hexahedron", 
      "Icosahedron", "InscribedRadius", "Nonagon", "NumberOfEdges", 
      "NumberOfFaces", "NumberOfVertices", "Octagon", "Octahedron", "Pentagon", 
      "Schlafli", "Square", "Tetrahedron", "Triangle", "Undecagon", "Vertices", 
      "Volume"}]


(* Declarations for package Geometry`Rotations` *)

DeclarePackage["Geometry`Rotations`",
     {"Rotate2D", "Rotate3D", "RotationMatrix2D", "RotationMatrix3D"}]


(* End of Master package *)

Null

