(*:Copyright: Copyright 1991-2005, Wolfram Research, Inc. *)

(*:Mathematica Version: 3.0 *)

(*:Title:  ArgColors  *)

(*:Author: R. Maeder *)

(*:Keywords: Arg, Hue, GrayLevel *)

(*:Summary:
This package provides functions for specifying the color or
gray level of graphics elements using the argument of a complex
number.
*)

(*:Sources: 
        Adapted from
        Roman E. Maeder: Programming in Mathematica,
        Third Edition, Addison-Wesley, 1996.
*)


BeginPackage["Graphics`ArgColors`"]

Unprotect[ArgColor, ArgShade, ColorCircle]

ArgColor::usage = 
"ArgColor[z] gives a color value whose hue is proportional
to the argument of the complex number z."

ArgShade::usage = 
"ArgShade[z] gives a gray level proportional
to the argument of the complex number z."

ColorCircle::usage = 
"ColorCircle[r, (light:1)] gives a color value whose hue
is proportional to r (mod 2Pi) with lightness light."

Begin["`Private`"]

ArgColor[z_] /; z == 0.0 := Hue[0, 0, 1]
ArgColor[z_?NumericQ] := ColorCircle[ Arg[z] ]

ArgShade[z_] /; z == 0.0 := GrayLevel[1]
ArgShade[z_?NumericQ] := GrayLevel[ N[(Pi + Arg[z])/(2Pi)] ]

ColorCircle[r_?NumericQ, light_:1] := Hue[ N[r/(2Pi)], 1, light ]

End[]

Protect[ArgColor, ArgShade, ColorCircle]

EndPackage[]
