(* :Title: Master Declarations File for Graphics *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:18 *)

If[! MemberQ[$Packages, "Graphics`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Graphics`"];
     Protect @@ System`Private`p
];

(* Declarations for package Graphics`Animation` *)

DeclarePackage["Graphics`Animation`",
     {"Animate", "Animation", "AnimationFunction", "Frames", 
      "MovieContourPlot", "MovieDensityPlot", "MovieParametricPlot", 
      "MoviePlot", "MoviePlot3D", "RasterFunction", "RotateLights", 
      "ShowAnimation", "SpinDistance", "SpinOrigin", "SpinRange", "SpinShow", 
      "SpinTilt"}]


(* Declarations for package Graphics`ArgColors` *)

DeclarePackage["Graphics`ArgColors`",{"ArgColor", "ArgShade", "ColorCircle"}]


(* Declarations for package Graphics`Arrow` *)

DeclarePackage["Graphics`Arrow`",
     {"Absolute", "Arrow", "HeadCenter", "HeadLength", "HeadScaling", 
      "HeadShape", "HeadWidth", "Relative", "ZeroShape"}]


(* Declarations for package Graphics`Colors` *)

DeclarePackage["Graphics`Colors`",
     {"AliceBlue", "AlizarinCrimson", "AllColors", "Antique", "Apricot", 
      "Aquamarine", "AquamarineMedium", "AureolineYellow", "Azure", "Banana", 
      "Beige", "Bisque", "BlanchedAlmond", "BlueLight", "BlueMedium", 
      "BlueViolet", "Brick", "BrownMadder", "BrownOchre", "Burlywood", 
      "BurntSienna", "BurntUmber", "Cadet", "CadetBlue", "CadmiumLemon", 
      "CadmiumOrange", "CadmiumRedDeep", "CadmiumRedLight", "CadmiumYellow", 
      "CadmiumYellowLight", "Carrot", "Cerulean", "Chartreuse", "Chocolate", 
      "ChromeOxideGreen", "CinnabarGreen", "CMYColor", "Cobalt", "CobaltGreen", 
      "CobaltVioletDeep", "ColdGray", "Coral", "CoralLight", "CornflowerBlue", 
      "Cornsilk", "CyanWhite", "DarkGoldenrod", "DarkGreen", "DarkKhaki", 
      "DarkOliveGreen", "DarkOrange", "DarkOrchid", "DarkSeaGreen", 
      "DarkSlateBlue", "DarkSlateGray", "DarkTurquoise", "DarkViolet", 
      "DeepCadmiumRed", "DeepCobaltViolet", "DeepMadderLake", 
      "DeepNaplesYellow", "DeepOchre", "DeepPink", "DeepSkyBlue", "DimGray", 
      "DodgerBlue", "Eggshell", "EmeraldGreen", "EnglishRed", "Firebrick", 
      "Floral", "ForestGreen", "Gainsboro", "GeraniumLake", "Ghost", "Gold", 
      "Goldenrod", "GoldenrodDark", "GoldenrodLight", "GoldenrodPale", 
      "GoldOchre", "GreenDark", "GreenishUmber", "GreenPale", "GreenYellow", 
      "HLSColor", "Honeydew", "HotPink", "HSBColor", "IndianRed", "Indigo", 
      "Ivory", "IvoryBlack", "Khaki", "KhakiDark", "LampBlack", "Lavender", 
      "LavenderBlush", "LawnGreen", "LemonChiffon", "LightBeige", "LightBlue", 
      "LightCadmiumRed", "LightCadmiumYellow", "LightCoral", "LightGoldenrod", 
      "LightGray", "LightPink", "LightSalmon", "LightSeaGreen", "LightSkyBlue", 
      "LightSlateBlue", "LightSlateGray", "LightSteelBlue", "LightViridian", 
      "LightYellow", "LimeGreen", "Linen", "MadderLakeDeep", "ManganeseBlue", 
      "Maroon", "MarsOrange", "MarsYellow", "MediumAquamarine", "MediumBlue", 
      "MediumOrchid", "MediumPurple", "MediumSeaGreen", "MediumSlateBlue", 
      "MediumSpringGreen", "MediumTurquoise", "MediumVioletRed", "Melon", 
      "MidnightBlue", "Mint", "MintCream", "MistyRose", "Moccasin", 
      "NaplesYellowDeep", "Navajo", "Navy", "NavyBlue", "Oak", "OldLace", 
      "Olive", "OliveDrab", "OliveGreenDark", "OrangeRed", "Orchid", 
      "OrchidDark", "OrchidMedium", "PaleGoldenrod", "PaleGreen", 
      "PaleTurquoise", "PaleVioletRed", "PapayaWhip", "Peach", "PeachPuff", 
      "Peacock", "PermanentGreen", "PermanentRedViolet", "Peru", "PinkLight", 
      "Plum", "PowderBlue", "PrussianBlue", "PurpleMedium", "Raspberry", 
      "RawSienna", "RawUmber", "RoseMadder", "RosyBrown", "RoyalBlue", 
      "SaddleBrown", "Salmon", "SandyBrown", "SapGreen", "SeaGreen", 
      "SeaGreenDark", "SeaGreenLight", "SeaGreenMedium", "Seashell", "Sepia", 
      "Sienna", "SkyBlue", "SkyBlueDeep", "SkyBlueLight", "SlateBlue", 
      "SlateBlueDark", "SlateBlueLight", "SlateBlueMedium", "SlateGray", 
      "SlateGrayDark", "SlateGrayLight", "Smoke", "Snow", "SpringGreen", 
      "SpringGreenMedium", "SteelBlue", "SteelBlueLight", "TerreVerte", 
      "Thistle", "Titanium", "Tomato", "Turquoise", "TurquoiseBlue", 
      "TurquoiseDark", "TurquoiseMedium", "TurquoisePale", "Ultramarine", 
      "UltramarineViolet", "VanDykeBrown", "VenetianRed", "Violet", 
      "VioletDark", "VioletRed", "VioletRedMedium", "VioletRedPale", 
      "ViridianLight", "WarmGray", "Wheat", "YellowBrown", "YellowGreen", 
      "YellowLight", "YellowOchre", "YIQColor", "Zinc"}]


(* Declarations for package Graphics`Common`GraphicsCommon` *)

DeclarePackage["Graphics`Common`GraphicsCommon`",
     {"ApproximateIntervals", "FrequencyData", "HistogramCategories", 
      "HistogramRange", "HistogramScale", "IntervalBoundaries", 
      "IntervalCenters", "MaxArrowLength", "ScaleFactor", "ScaleFunction"}]


(* Declarations for package Graphics`ComplexMap` *)

DeclarePackage["Graphics`ComplexMap`",
     {"CartesianMap", "Lines", "PolarMap", "$Lines"}]


(* Declarations for package Graphics`ContourPlot3D` *)

DeclarePackage["Graphics`ContourPlot3D`",{"ContourPlot3D", "ListContourPlot3D"}]


(* Declarations for package Graphics`FilledPlot` *)

DeclarePackage["Graphics`FilledPlot`",
     {"AxesFront", "Back", "Curves", "FilledListPlot", "FilledPlot", "Fills", 
      "Front", "ListFilledPlot"}]


(* Declarations for package Graphics`Graphics3D` *)

DeclarePackage["Graphics`Graphics3D`",
     {"BarChart3D", "Color", "GeneralizedBarChart3D", "Histogram3D", 
      "ListShadowPlot3D", "ListSurfacePlot3D", "Project", "ScatterPlot3D", 
      "Shadow", "ShadowMesh", "ShadowMeshStyle", "ShadowPlot3D", 
      "ShadowPosition", "SkewGraphics3D", "SolidBarEdges", "SolidBarEdgeStyle", 
      "SolidBarStyle", "StackGraphics", "SurfaceMesh", "SurfaceMeshStyle", 
      "TransformGraphics3D", "XShadow", "XShadowPosition", "XSpacing", 
      "YShadow", "YShadowPosition", "YSpacing", "ZShadow", "ZShadowPosition"}]


(* Declarations for package Graphics`Graphics` *)

DeclarePackage["Graphics`Graphics`",
     {"BarChart", "BarEdges", "BarEdgeStyle", "BarGroupSpacing", "BarLabels", 
      "BarOrientation", "BarSpacing", "BarStyle", "BarValues", 
      "DisplayTogether", "DisplayTogetherArray", "ErrorListPlot", 
      "GeneralizedBarChart", "Histogram", "LabeledListPlot", 
      "LinearLogListPlot", "LinearLogPlot", "LinearScale", "ListAndCurvePlot", 
      "LogGridMajor", "LogGridMinor", "LogLinearListPlot", "LogLinearPlot", 
      "LogListPlot", "LogLogListPlot", "LogLogPlot", "LogPlot", "LogScale", 
      "PercentileBarChart", "PieChart", "PieExploded", "PieLabels", 
      "PieLineStyle", "PieStyle", "PiScale", "PolarListPlot", "PolarPlot", 
      "ScaledListPlot", "ScaledPlot", "SkewGraphics", "StackedBarChart", 
      "TextListPlot", "TransformGraphics", "UnitScale"}]


(* Declarations for package Graphics`ImplicitPlot` *)

DeclarePackage["Graphics`ImplicitPlot`",{"ImplicitPlot"}]


(* Declarations for package Graphics`InequalityGraphics` *)

DeclarePackage["Graphics`InequalityGraphics`",
     {"BoundaryStyle", "ComplexInequalityPlot", "InequalityPlot", 
      "InequalityPlot3D"}]


(* Declarations for package Graphics`Legend` *)

DeclarePackage["Graphics`Legend`",
     {"Legend", "LegendBackground", "LegendBorder", "LegendBorderSpace", 
      "LegendLabel", "LegendLabelSpace", "LegendOrientation", "LegendPosition", 
      "LegendShadow", "LegendSize", "LegendSpacing", "LegendTextDirection", 
      "LegendTextOffset", "LegendTextSpace", "PlotLegend", "ShadowBackground", 
      "ShadowBorder", "ShadowBox", "ShadowForeground", "ShadowOffset", 
      "ShowLegend"}]


(* Declarations for package Graphics`MultipleListPlot` *)

DeclarePackage["Graphics`MultipleListPlot`",
     {"Dash", "Diamond", "DotShapes", "ErrorBar", "ErrorBarFunction", "Filled", 
      "LineStyles", "LongDash", "MakeSymbol", "MultipleListPlot", "PlotSymbol", 
      "RegularPolygon", "Star", "Stem", "SymbolLabel", "SymbolShape", 
      "SymbolStyle", "Triangle", "ZeroOffsets", "$DotShapes", "$LineStyles"}]


(* Declarations for package Graphics`ParametricPlot3D` *)

DeclarePackage["Graphics`ParametricPlot3D`",
     {"CylindricalPlot3D", "PointParametricPlot3D", "SphericalPlot3D"}]


(* Declarations for package Graphics`PlotField3D` *)

DeclarePackage["Graphics`PlotField3D`",
     {"ListPlotVectorField3D", "PlotGradientField3D", "PlotVectorField3D", 
      "VectorHeads"}]


(* Declarations for package Graphics`PlotField` *)

DeclarePackage["Graphics`PlotField`",
     {"ListPlotVectorField", "PlotGradientField", "PlotHamiltonianField", 
      "PlotPolyaField", "PlotVectorField"}]


(* Declarations for package Graphics`Polyhedra` *)

DeclarePackage["Graphics`Polyhedra`",
     {"Geodesate", "GreatDodecahedron", "GreatIcosahedron", 
      "GreatStellatedDodecahedron", "OpenTruncate", "Polyhedra", "Polyhedron", 
      "SmallStellatedDodecahedron", "Stellate", "Truncate"}]


(* Declarations for package Graphics`Shapes` *)

DeclarePackage["Graphics`Shapes`",
     {"AffineShape", "Cone", "Cylinder", "DoubleHelix", "Helix", 
      "MoebiusStrip", "OutlinePolygons", "PerforatePolygons", "RotateShape", 
      "ShrinkPolygons", "Sphere", "Torus", "TranslateShape", "WireFrame"}]


(* Declarations for package Graphics`Spline` *)

DeclarePackage["Graphics`Spline`",
     {"RenderSpline", "Spline", "SplineDivision", "SplineDots", "SplinePoints"}]


(* Declarations for package Graphics`SurfaceOfRevolution` *)

DeclarePackage["Graphics`SurfaceOfRevolution`",
     {"ListSurfaceOfRevolution", "RevolutionAxis", "SurfaceOfRevolution"}]


(* Declarations for package Graphics`ThreeScript` *)

DeclarePackage["Graphics`ThreeScript`",{"ThreeScript"}]


(* End of Master package *)

Null

