(* :Title: Master Declarations File for Miscellaneous *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:18 *)

If[! MemberQ[$Packages, "Miscellaneous`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Miscellaneous`"];
     Protect @@ System`Private`p
];

(* Declarations for package Miscellaneous`Audio` *)

DeclarePackage["Miscellaneous`Audio`",
     {"AmplitudeModulation", "Cascade", "FrequencyModulation", "ListWaveform", 
      "ModulationType", "Overtones", "Parallel", "PlaySoundFile", 
      "PrintHeader", "ReadSoundfile", "ReadSoundFile", "Ring", 
      "RingModulation", "Sawtooth", "Sinusoid", "Square", "Standard", 
      "Triangle", "Type", "Waveform"}]


(* Declarations for package Miscellaneous`BlackBodyRadiation` *)

DeclarePackage["Miscellaneous`BlackBodyRadiation`",
     {"BlackBodyProfile", "MaxPower", "PeakWavelength", "TotalPower"}]


(* Declarations for package Miscellaneous`Calendar` *)

DeclarePackage["Miscellaneous`Calendar`",
     {"Calendar", "CalendarChange", "DayOfWeek", "DaysBetween", "DaysPlus", 
      "EasterSunday", "EasterSundayGreekOrthodox", "Friday", "Gregorian", 
      "Islamic", "JewishNewYear", "Julian", "Monday", "Saturday", "Sunday", 
      "Thursday", "Tuesday", "Wednesday"}]


(* Declarations for package Miscellaneous`ChemicalElements` *)

DeclarePackage["Miscellaneous`ChemicalElements`",
     {"Abbreviation", "Actinium", "Aluminium", "Aluminum", "Americium", 
      "Antimony", "Argon", "Arsenic", "Astatine", "AtomicNumber", 
      "AtomicWeight", "Barium", "Berkelium", "Beryllium", "Bismuth", "Bohrium", 
      "BoilingPoint", "Boron", "Bromine", "Cadmium", "Caesium", "Calcium", 
      "Californium", "Carbon", "Cerium", "Cesium", "Chlorine", "Chromium", 
      "Cobalt", "Copper", "Curium", "Density", "Dubnium", "Dysprosium", 
      "EarthCrustAbundance", "EarthOceanAbundance", "Einsteinium", 
      "ElectronConfiguration", "ElectronConfigurationFormat", 
      "ElementAbbreviations", "Elements", "Erbium", "Europium", "Fermium", 
      "Fluorine", "Francium", "Gadolinium", "Gallium", "Germanium", "Gold", 
      "Hafnium", "Hassium", "HeatOfFusion", "HeatOfVaporization", "Helium", 
      "Holmium", "Hydrogen", "Indium", "Iodine", "IonizationPotential", 
      "Iridium", "Iron", "Kalium", "Krypton", "Kurchatovium", "Lanthanum", 
      "Lawrencium", "Lead", "Lithium", "Lutetium", "Magnesium", "Manganese", 
      "Meitnerium", "MeltingPoint", "Mendelevium", "Mercury", "Molybdenum", 
      "Natrium", "Neodymium", "Neon", "Neptunium", "Nickel", "Niobium", 
      "Nitrogen", "Nobelium", "Osmium", "Oxygen", "Palladium", "Phosphorus", 
      "Platinum", "Plutonium", "Polonium", "Potassium", "Praseodymium", 
      "Promethium", "Protactinium", "Radium", "Radon", "Rhenium", "Rhodium", 
      "Rubidium", "Ruthenium", "Rutherfordium", "Samarium", "Scandium", 
      "Seaborgium", "Selenium", "Silicon", "Silver", "Sodium", 
      "SolarSystemAbundance", "SpecificHeat", "StableIsotopes", "Stibium", 
      "Strontium", "Sulfur", "Sulphur", "Tantalum", "Technetium", "Tellurium", 
      "Terbium", "Thallium", "ThermalConductivity", "Thorium", "Thulium", 
      "Tin", "Titanium", "Tungsten", "Unknown", "Unnilhexium", "Unnilpentium", 
      "Unnilquadium", "Ununbium", "Ununnilium", "Unununium", "Uranium", 
      "Vanadium", "Wolfram", "Xenon", "Ytterbium", "Yttrium", "Zinc", 
      "Zirconium"}]


(* Declarations for package Miscellaneous`CityData` *)

DeclarePackage["Miscellaneous`CityData`",
     {"CityData", "CityDistance", "CityDistanceMethod", "CityPosition", 
      "$CityFields"}]


(* Declarations for package Miscellaneous`Dictionary` *)

DeclarePackage["Miscellaneous`Dictionary`",
     {"Anagrams", "DictionaryWordQ", "FindWords", "GetDictionary", 
      "SpellCheck", "$DefaultDictionaryFile", "$Dictionary"}]


(* Declarations for package Miscellaneous`Geodesy` *)

DeclarePackage["Miscellaneous`Geodesy`",
     {"Eccentricity", "GeodeticToAuthalic", "Radius", "SemimajorAxis", 
      "SphericalDistance", "SpheroidalDistance", "ToAuthalicRadius", 
      "ToDegrees", "ToDMS"}]


(* Declarations for package Miscellaneous`Music` *)

DeclarePackage["Miscellaneous`Music`",
     {"A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "Aflat0", "Aflat1", 
      "Aflat2", "Aflat3", "Aflat4", "Aflat5", "Aflat6", "Aflat7", "Asharp0", 
      "Asharp1", "Asharp2", "Asharp3", "Asharp4", "Asharp5", "Asharp6", 
      "Asharp7", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "Bflat0", 
      "Bflat1", "Bflat2", "Bflat3", "Bflat4", "Bflat5", "Bflat6", "Bflat7", 
      "Bsharp0", "Bsharp1", "Bsharp2", "Bsharp3", "Bsharp4", "Bsharp5", 
      "Bsharp6", "Bsharp7", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", 
      "CentsToHertz", "Cflat0", "Cflat1", "Cflat2", "Cflat3", "Cflat4", 
      "Cflat5", "Cflat6", "Cflat7", "Csharp0", "Csharp1", "Csharp2", "Csharp3", 
      "Csharp4", "Csharp5", "Csharp6", "Csharp7", "D0", "D1", "D2", "D3", "D4", 
      "D5", "D6", "D7", "Dflat0", "Dflat1", "Dflat2", "Dflat3", "Dflat4", 
      "Dflat5", "Dflat6", "Dflat7", "Dsharp0", "Dsharp1", "Dsharp2", "Dsharp3", 
      "Dsharp4", "Dsharp5", "Dsharp6", "Dsharp7", "E0", "E1", "E2", "E3", "E4", 
      "E5", "E6", "E7", "Eflat0", "Eflat1", "Eflat2", "Eflat3", "Eflat4", 
      "Eflat5", "Eflat6", "Eflat7", "Esharp0", "Esharp1", "Esharp2", "Esharp3", 
      "Esharp4", "Esharp5", "Esharp6", "Esharp7", "F0", "F1", "F2", "F3", "F4", 
      "F5", "F6", "F7", "Fflat0", "Fflat1", "Fflat2", "Fflat3", "Fflat4", 
      "Fflat5", "Fflat6", "Fflat7", "Fsharp0", "Fsharp1", "Fsharp2", "Fsharp3", 
      "Fsharp4", "Fsharp5", "Fsharp6", "Fsharp7", "G0", "G1", "G2", "G3", "G4", 
      "G5", "G6", "G7", "Gflat0", "Gflat1", "Gflat2", "Gflat3", "Gflat4", 
      "Gflat5", "Gflat6", "Gflat7", "Gsharp0", "Gsharp1", "Gsharp2", "Gsharp3", 
      "Gsharp4", "Gsharp5", "Gsharp6", "Gsharp7", "HertzToCents", "JustMajor", 
      "JustMinor", "MeanChromatic", "MeanMajor", "MeanMinor", 
      "PythagoreanChromatic", "PythagoreanMajor", "QuarterTone", "Scale", 
      "SixthTone", "TemperedChromatic", "TemperedMajor", "TemperedMinor"}]


(* Declarations for package Miscellaneous`PhysicalConstants` *)

DeclarePackage["Miscellaneous`PhysicalConstants`",
     {"AccelerationDueToGravity", "AgeOfUniverse", "AvogadroConstant", 
      "BohrRadius", "BoltzmannConstant", "ClassicalElectronRadius", 
      "CosmicBackgroundTemperature", "DeuteronMagneticMoment", "DeuteronMass", 
      "EarthMass", "EarthRadius", "ElectronCharge", 
      "ElectronComptonWavelength", "ElectronGFactor", "ElectronMagneticMoment", 
      "ElectronMass", "FaradayConstant", "FineStructureConstant", 
      "GalacticUnit", "GravitationalConstant", "HubbleConstant", "IcePoint", 
      "MagneticFluxQuantum", "MolarGasConstant", "MolarVolume", "MuonGFactor", 
      "MuonMagneticMoment", "MuonMass", "NeutronComptonWavelength", 
      "NeutronMagneticMoment", "NeutronMass", "PlanckConstant", 
      "PlanckConstantReduced", "PlanckMass", "ProtonComptonWavelength", 
      "ProtonMagneticMoment", "ProtonMass", "QuantizedHallConductance", 
      "RydbergConstant", "SackurTetrodeConstant", "SolarConstant", 
      "SolarLuminosity", "SolarRadius", "SolarSchwarzschildRadius", 
      "SpeedOfLight", "SpeedOfSound", "StefanConstant", "ThomsonCrossSection", 
      "VacuumPermeability", "VacuumPermittivity", "WeakMixingAngle"}]


(* Declarations for package Miscellaneous`RealOnly` *)

DeclarePackage["Miscellaneous`RealOnly`",{"Nonreal"}]


(* Declarations for package Miscellaneous`ResonanceAbsorptionLines` *)

DeclarePackage["Miscellaneous`ResonanceAbsorptionLines`",
     {"AirWavelength", "AtomicData", "DampingConstant", "Deuterium", 
      "ElementAbsorptionMap", "FindIons", "IonStage", "LowerStatisticalWeight", 
      "LowerTermFineStructureEnergy", "OscillatorStrength", "RelativeStrength", 
      "TransitionProbability", "UpperStatisticalWeight", "VacuumWavelength", 
      "WavelengthAbsorptionMap"}]


(* Declarations for package Miscellaneous`SIUnits` *)

DeclarePackage["Miscellaneous`SIUnits`",
     {"Amp", "Ampere", "Becquerel", "Candela", "Coulomb", "Farad", "GrayDose", 
      "Henry", "Hertz", "Joule", "Kelvin", "Kilogram", "Lumen", "Lux", "Meter", 
      "Mole", "Ohm", "Pascal", "Siemens", "Tesla", "Volt", "Watt", "Weber"}]


(* Declarations for package Miscellaneous`StandardAtmosphere` *)

DeclarePackage["Miscellaneous`StandardAtmosphere`",
     {"AtmosphericPlot", "CollisionFrequency", "DynamicViscosity", 
      "GravityAcceleration", "KinematicViscosity", "KineticTemperature", 
      "MeanDensity", "MeanFreePath", "MeanMolecularWeight", 
      "MeanParticleSpeed", "NumberDensity", "Pressure", "PressureScaleHeight", 
      "SoundSpeed", "ThermalConductivityCoefficient"}]


(* Declarations for package Miscellaneous`Units` *)

DeclarePackage["Miscellaneous`Units`",
     {"Abampere", "Abcoulomb", "Abfarad", "Abhenry", "Abmho", "Abohm", 
      "Abvolt", "Acre", "AMU", "Angstrom", "Apostilb", "ArcMinute", 
      "ArcSecond", "Are", "AssayTon", "AstronomicalUnit", "Atmosphere", 
      "AtomicMassUnit", "Atto", "AU", "AvoirdupoisOunce", "AvoirdupoisPound", 
      "Bag", "BakersDozen", "Bale", "Bar", "Barn", "Barrel", "Barye", "Baud", 
      "Biot", "Bit", "BoardFoot", "BohrMagneton", "Bolt", "BritishThermalUnit", 
      "BTU", "Bucket", "Bushel", "Butt", "Cable", "Caliber", "Calorie", 
      "Candle", "Carat", "Celsius", "Cental", "Centi", "Centigrade", 
      "Centimeter", "Century", "CGS", "Chain", "ChevalVapeur", "Cicero", 
      "Convert", "ConvertTemperature", "Cord", "Cubit", "Cup", "Curie", 
      "Dalton", "Day", "Deca", "Decade", "Deci", "Denier", "Didot", 
      "DidotPoint", "Diopter", "Dozen", "Drachma", "Dyne", "ElectronVolt", 
      "Ell", "Ephah", "Erg", "Exa", "Fahrenheit", "Fathom", "Feet", "Femto", 
      "Fermi", "Fifth", "Firkin", "FluidDram", "FluidOunce", "Foot", 
      "FootCandle", "Fortnight", "Furlong", "Gal", "Gallon", "Gauss", 
      "Geepound", "Giga", "Gilbert", "Gill", "Grade", "Grain", "Gram", 
      "GramWeight", "Gravity", "Gross", "GrossHundredweight", "Hand", 
      "Hectare", "Hecto", "Hefner", "Hogshead", "Horsepower", "Hour", 
      "Hundredweight", "ImperialGallon", "ImperialPint", "Inch", "InchMercury", 
      "Jeroboam", "Jigger", "Kayser", "Kilo", "KilogramForce", 
      "KilogramWeight", "Knot", "Lambert", "League", "Libra", "LightYear", 
      "Link", "Liter", "Lumerg", "Magnum", "Maxwell", "Mega", "MetricTon", 
      "Mho", "Micro", "Micron", "Mil", "Mile", "Millennium", "Milli", 
      "MillimeterMercury", "Mina", "Minim", "Minute", "MKS", "Month", "Nano", 
      "NauticalMile", "NetHundredweight", "Nibble", "Nit", "Noggin", 
      "NuclearMagneton", "Obolos", "Oersted", "Omer", "Ounce", "Parsec", 
      "Peck", "Pennyweight", "Percent", "Perch", "Peta", "Phot", "Pica", 
      "Pico", "Pint", "Poise", "Pole", "Pondus", "Pony", "Pound", "Poundal", 
      "PoundForce", "PoundsPerSquareInch", "PoundWeight", "PrintersPoint", 
      "PSI", "Puncheon", "Quadrant", "Quart", "Quintal", "Rad", "Radian", 
      "Rankine", "RegisterTon", "Reyn", "Rhes", "RightAngle", "Rod", 
      "Roentgen", "Rontgen", "Rood", "Rope", "Rutherford", "Rydberg", "Seam", 
      "Section", "Shekel", "ShortHundredweight", "ShortTon", "Shot", "SI", 
      "SiderealSecond", "SiderealYear", "Skein", "Slug", "SolarMass", "Span", 
      "Stadion", "Stadium", "Statampere", "Statcoulomb", "Statfarad", 
      "Stathenry", "Statohm", "StatuteMile", "Statvolt", "Steradian", "Stere", 
      "Stilb", "Stokes", "Stone", "SurveyMile", "Tablespoon", "Talbot", 
      "Talent", "Teaspoon", "Tera", "Therm", "Ton", "TonForce", "Tonne", 
      "Torr", "Township", "TropicalYear", "TroyOunce", "Tun", "UKGallon", 
      "UKPint", "Week", "Wey", "WineBottle", "XUnit", "Yard", "Year", "Yocto", 
      "Yotta", "Zepto", "Zetta"}]


(* Declarations for package Miscellaneous`WorldData` *)

DeclarePackage["Miscellaneous`WorldData`",{"WorldData"}]


(* Declarations for package Miscellaneous`WorldNames` *)

DeclarePackage["Miscellaneous`WorldNames`",
     {"Africa", "Asia", "ContiguousUSStates", "Europe", "MiddleEast", 
      "NorthAmerica", "Oceania", "SouthAmerica", "USStates", "World"}]


(* Declarations for package Miscellaneous`WorldPlot` *)

DeclarePackage["Miscellaneous`WorldPlot`",
     {"Albers", "Equirectangular", "LambertAzimuthal", "LambertCylindrical", 
      "Mercator", "Mollweide", "Orthographic", "RandomColors", "RandomGrays", 
      "Simple", "Sinusoidal", "ToMinutes", "WorldBackground", "WorldBorders", 
      "WorldClipping", "WorldCountries", "WorldDatabase", "WorldFrame", 
      "WorldFrameParts", "WorldGraphics", "WorldGrid", "WorldGridBehind", 
      "WorldGridStyle", "WorldPlot", "WorldPoints", "WorldProjection", 
      "WorldRange", "WorldRotatedRange", "WorldRotation", "WorldToGraphics"}]


(* End of Master package *)

Null

