(*:Copyright: Copyright 1988-2005 Wolfram Research, Inc. *)

(*:Mathematica Version: 5.0 *)

(*:Package Version: 1.0 *)

(*:Name: NumberTheory`AlgebraicNumberFields` *)

(*:Title: Functions for computation in finite algebraic extensions 
   of rationals.
*) 

(*:Author: Adam Strzebonski *)

(*:Keywords: algebraic numbers, number fields *)

(*:Sources: H. Cohen, A Course In Computational Algebraic Number Theory, 
   Springer-Verlag, 1993.  
*)

(*:Summary:
The package provides usage messages for functions in 
NumberTheory`AlgebraicNumberFields`
context implemented in the kernel. 
*)

BeginPackage["NumberTheory`AlgebraicNumberFields`"]

Algebraic::usage = "Algebraic[f, {c0,...,cl}, k] represents the algebraic number c0 + c1*r + c2*r^2 +...+ cl*r^l, where r is the number represented by Root[f, k]." 

AlgebraicIntegerQ::usage = "AlgebraicIntegerQ[a], for an algebraic number a, gives True if a is an algebraic integer and False otherwise."

AlgebraicNumberDenominator::usage = "AlgebraicNumberDenominator[a], for an algebraic number a, gives the smallest positive integer n such that n*a is an algebraic integer." 

AlgebraicNumberNorm::usage = "AlgebraicNumberNorm[a] gives the norm of the algebraic number a."

AlgebraicNumberTrace::usage = "AlgebraicNumberTrace[a] gives the trace of the algebraic number a."

AlgebraicUnitQ::usage = "AlgebraicUnitQ[a], for an algebraic number a, gives True if a is an algebraic unit and False otherwise."

FundamentalUnits::usage = "FundamentalUnits[f, k] gives a list of fundamental units of the field \[DoubleStruckCapitalQ](r), where r is the algebraic number represented by Root[f, k]. FundamentalUnits[a], for an algebraic number a, gives a list of fundamental units of the field \[DoubleStruckCapitalQ](a)."

IntegralBasis::usage = "IntegralBasis[f, k] gives an integral basis of the field \[DoubleStruckCapitalQ](r), where r is the algebraic number represented by Root[f, k]. IntegralBasis[a], for an algebraic number a, gives an integral basis of the field \[DoubleStruckCapitalQ](a)."

MinimalPolynomial::usage = "MinimalPolynomial[a] gives a pure function representation of the minimal polynomial (over the integers) of the algebraic number a. MinimalPolynomial[a, x] gives the minimal polynomial of a, expressed as a polynomial in x." 

NormRepresentatives::usage = "NormRepresentatives[m, f, k] gives representatives of classes of algebraic integers of norm \[PlusMinus]m in the field \[DoubleStruckCapitalQ](r), up to multiplication by a unit, where r is the algebraic number represented by Root[f, k]. NormRepresentatives[m, a], for an algebraic number a, gives representatives of classes of algebraic integers of norm \[PlusMinus]m in the field \[DoubleStruckCapitalQ](a), up to multiplication by a unit. "

NumberFieldCharacteristicPolynomial::usage = "NumberFieldCharacteristicPolynomial[a] gives a pure function representation of the characteristic polynomial of the Algebraic object a, relative to its number field. NumberFieldCharacteristicPolynomial[a, x] gives the characteristic polynomial of the Algebraic object a, relative to its number field, expressed as a polynomial in x."

NumberFieldDiscriminant::usage = "NumberFieldDiscriminant[f], for an irreducible polynomial function f with rational coefficients, gives the discriminant of the number field generated by a root of f. NumberFieldDiscriminant[a], for an algebraic number a, gives the discriminant of the field \[DoubleStruckCapitalQ](a)."

NumberFieldNorm::usage = "NumberFieldNorm[a] gives the norm of the Algebraic object a, relative to its number field." 

NumberFieldRegulator::usage = "NumberFieldRegulator[f], for an irreducible polynomial function f with rational coefficients, gives the regulator of the number field generated by a root of f. NumberFieldRegulator[a], for an algebraic number a, gives the regulator of the field \[DoubleStruckCapitalQ](a)."

NumberFieldSignature::usage = "NumberFieldSignature[f], for an irreducible polynomial function f with rational coefficients, returns {s, t}, where s is the number of real roots of f and t is the number of pairs of complex roots of f. NumberFieldSignature[a], for an algebraic number a, returns {s, t}, where s is the number of real embeddings of \[DoubleStruckCapitalQ](a) in \[DoubleStruckCapitalC], and t is the number of conjugate pairs of complex embeddings of \[DoubleStruckCapitalQ](a) in \[DoubleStruckCapitalC]."

NumberFieldTrace::usage = "NumberFieldTrace[a] gives the trace of the Algebraic object a, relative to its number field." 

RootOfUnityQ::usage = "RootOfUnityQ[a], for an algebraic number a, gives True if a is a root of unity and False otherwise."

RootsOfUnity::usage = "RootsOfUnity[f, k] gives the roots of unity in the field \[DoubleStruckCapitalQ](r), where r is the algebraic number represented by Root[f, k]. RootsOfUnity[a], for an algebraic number a, gives the roots of unity in the field \[DoubleStruckCapitalQ](a)."

SmallestField::usage = "SmallestField is an option for ToCommonField which specifies whether the common field in which the algebraic numbers are represented needs to be the smallest possible."

ToCommonField::usage = "ToCommonField[{a1,...,an}] takes a list of algebraic numbers, and returns a list of Algebraic objects representing the numbers as elements of a common finite algebraic extension of rationals."

ToNumberFieldElement::usage = "ToNumberFieldElement[a, f, k] represents the algebraic number a as an Algebraic object in the number field specified by Root[f, k]."

EndPackage[]  (* NumberTheory`AlgebraicNumberFields` *)

            
