(* :Title: Master Declarations File for NumberTheory *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:18 *)

If[! MemberQ[$Packages, "NumberTheory`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "NumberTheory`"];
     Protect @@ System`Private`p
];

(* Load package NumberTheory`AlgebraicNumberFields` *)

Needs["NumberTheory`AlgebraicNumberFields`"]

(* Declarations for package NumberTheory`ContinuedFractions` *)

DeclarePackage["NumberTheory`ContinuedFractions`",
     {"ContinuedFractionForm", "Convergents", "PeriodicForm", 
      "QuadraticIrrationalQ"}]


(* Declarations for package NumberTheory`FactorIntegerECM` *)

DeclarePackage["NumberTheory`FactorIntegerECM`",
     {"CurveCountLimit", "CurveNumber", "FactorIntegerECM", "FactorSize"}]


(* Declarations for package NumberTheory`Frobenius` *)

DeclarePackage["NumberTheory`Frobenius`",
     {"FrobeniusInstance", "FrobeniusSolve", "FrobeniusF"}]


(* Declarations for package NumberTheory`NumberTheoryFunctions` *)

DeclarePackage["NumberTheory`NumberTheoryFunctions`",
     {"AliquotCycle", "AliquotSequence", "Biunitary", "ChineseRemainder", 
      "ChineseRemainderTheorem", "ClassList", "ClassNumber", "Exponential", 
      "FundamentalDiscriminantQ", "Infinitary", "KroneckerSymbol", 
      "LeastPrimeFactor", "MaxTerms", "ModifiedExponential", "NextPrime", 
      "OrderedSumOfSquaresRepresentations", "PreviousPrime", "PrimeFactorList", 
      "PrimePowerQ", "PrimitiveRoot", "QuadraticRepresentation", 
      "ShowProgress", "SqrtMod", "SqrtModList", "SquareFreeQ", "SumOfFactors", 
      "SumOfFactorsType", "SumOfSquaresR", "SumOfSquaresRepresentations", 
      "TermIncrement", "Unitary", "WhichRootOfUnity"}]


(* Declarations for package NumberTheory`PrimeQ` *)

DeclarePackage["NumberTheory`PrimeQ`",
     {"Certificate", "CertificateDiscriminant", "CertificateK", "CertificateM", 
      "CertificateNextPrime", "CertificatePoint", "CertificatePrime", 
      "HilbertPolynomial", "ModularInvariantj", "PointEC", "PointECQ", 
      "PollardPTest", "PollardRhoTest", "PrimeQCertificate", 
      "PrimeQCertificateCheck", "PrimeQMessages", "ProvablePrimeQ", 
      "SmallPrime", "TrialDivisionLimit"}]


(* Declarations for package NumberTheory`PrimitiveElement` *)

DeclarePackage["NumberTheory`PrimitiveElement`",{"PrimitiveElement"}]


(* Declarations for package NumberTheory`Ramanujan` *)

DeclarePackage["NumberTheory`Ramanujan`",
     {"RamanujanTau", "RamanujanTauDirichletSeries", 
      "RamanujanTauGeneratingFunction", "RamanujanTauTheta", "RamanujanTauZ"}]


(* Declarations for package NumberTheory`Rationalize` *)

DeclarePackage["NumberTheory`Rationalize`",
     {"AffineRationalize", "ProjectiveRationalize"}]


(* Declarations for package NumberTheory`Recognize` *)

DeclarePackage["NumberTheory`Recognize`",{"Recognize"}]


(* Declarations for package NumberTheory`SiegelTheta` *)

DeclarePackage["NumberTheory`SiegelTheta`",{"SiegelTheta"}]


(* End of Master package *)

Null

