(*:Copyright: Copyright 1988-2005 Wolfram Research, Inc. *)

(*:Mathematica Version: 3.0 *)

(*:Package Version: 1.0 *)

(*:Name: NumberTheory`PrimitiveElement` *)

(*:Title: Primitive elements of algebraic extensions of rationals.*) 

(*:Author: Adam Strzebonski *)

(*:Keywords: primitive elements, algebraic field extensions *)

(*:Requirements: None. *)

(*:Sources:
	Computing in Algebraic Extensions, R.Loos, Computing, Suppl.4,
	173-187 (1982).
*)

(*:Summary:
This package defines function for finding primitive elements of multiple
algebraic extensions of rationals.
*)

(*:History:
Moved the function for computing the primitive element of two numbers
to StartUp/Algebra/NumberField.m. (adams 10/19/2000)
*)

BeginPackage["NumberTheory`PrimitiveElement`"]

Unprotect[PrimitiveElement]

PrimitiveElement::usage = "PrimitiveElement[z, {a1,...,an}] returns a pair {r, {f1,...,fn}}, where r is a primitive element for the extension of rationals by algebraic numbers a1,...,an, and f1,...,fn are polynomials in z such that ai==fi/.z->r for 1<=i<=n."

Begin["`Private`"]

NumberTheory`AlgebraicNumberFields`Algebraic; 
(This loads StartUp/Algebra/NumberField.m)

validinput[z_, as_] := Head[z]===Symbol && ListQ[as] && Length[as]>0 &&
                       And@@(System`Private`AlgebraicNumberQ/@as)
		
PrimitiveElement[z_, as_]/;validinput[z, as]:=
   Module[{a=as[[1]], b, p, fs={z}, i},
      Do[b=as[[i]];
         b=System`NumberFieldDump`primel2[z, a, b];
         a=b[[1]]; 
         p=NumberTheory`AlgebraicNumberFields`MinimalPolynomial[a, z];
         fs=fs/.z->b[[2]];
         fs=PolynomialRemainder[#, p, z]&/@fs;
         fs=Append[fs, b[[3]]],
         {i, 2, Length[as]}];
      {a, fs}]
		
End[] (* `Private` *)

Protect[PrimitiveElement]
		
EndPackage[]		
