(* :Title: Master Declarations File for NumericalMath *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:18 *)

If[! MemberQ[$Packages, "NumericalMath`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "NumericalMath`"];
     Protect @@ System`Private`p
];

(* Declarations for package NumericalMath`Approximations` *)

DeclarePackage["NumericalMath`Approximations`",
     {"Bias", "Brake", "Derivatives", "GeneralMiniMaxApproximation", 
      "GeneralRationalInterpolation", "MiniMaxApproximation", "PlotFlag", 
      "PrintFlag", "RationalInterpolation"}]


(* Declarations for package NumericalMath`BesselZeros` *)

DeclarePackage["NumericalMath`BesselZeros`",
     {"BesselJPrimeYJYPrimeZeros", "BesselJPrimeYJYPrimeZerosInterval", 
      "BesselJPrimeYPrimeJPrimeYPrimeZeros", 
      "BesselJPrimeYPrimeJPrimeYPrimeZerosInterval", "BesselJPrimeZeros", 
      "BesselJPrimeZerosInterval", "BesselJYJYZeros", 
      "BesselJYJYZerosInterval", "BesselJZeros", "BesselJZerosInterval", 
      "BesselYPrimeZeros", "BesselYPrimeZerosInterval", "BesselYZeros", 
      "BesselYZerosInterval"}]


(* Declarations for package NumericalMath`Butcher` *)

DeclarePackage["NumericalMath`Butcher`",
     {"ButcherAlpha", "ButcherBeta", "ButcherBetaBar", 
      "ButcherColumnConditions", "ButcherGamma", "ButcherHeight", 
      "ButcherOrder", "ButcherPhi", "ButcherPlot", "ButcherPlotColumns", 
      "ButcherPlotLabel", "ButcherPlotNodeSize", "ButcherPlotRootSize", 
      "ButcherPrincipalError", "ButcherQuadratureConditions", 
      "ButcherRowConditions", "ButcherRowSum", "ButcherSigma", 
      "ButcherSimplify", "ButcherTreeCount", "ButcherTreeQ", "ButcherTrees", 
      "ButcherTreeSimplify", "ButcherWidth", "ContinuousExtension", 
      "DiagonallyImplicit", "Explicit", "Implicit", "RungeKuttaMethod", 
      "RungeKuttaOrderConditions", "SymbolicTable", "$ContinuousExtension", 
      "$RungeKuttaMethod"}]


(* Declarations for package NumericalMath`CauchyPrincipalValue` *)

DeclarePackage["NumericalMath`CauchyPrincipalValue`",{"CauchyPrincipalValue"}]


(* Declarations for package NumericalMath`ComputerArithmetic` *)

DeclarePackage["NumericalMath`ComputerArithmetic`",
     {"Arithmetic", "ComputerNumber", "ExponentRange", "IdealDivide", 
      "MixedMode", "NaN", "RoundingRule", "RoundToEven", "RoundToInfinity", 
      "SetArithmetic", "Truncation"}]


(* Declarations for package NumericalMath`EquationTrekker` *)

DeclarePackage["NumericalMath`EquationTrekker`",
     {"DifferentialEquationTrek", "EquationTrekker", "EquationTrekkerNonModal", 
      "EquationTrekkerState", "InitializeGenerator", "PoincareSection", 
      "TrekData", "TrekGenerator", "TrekParameters"}]


(* Declarations for package NumericalMath`GaussianQuadrature` *)

DeclarePackage["NumericalMath`GaussianQuadrature`",
     {"GaussianQuadratureError", "GaussianQuadratureWeights"}]


(* Declarations for package NumericalMath`InterpolateRoot` *)

DeclarePackage["NumericalMath`InterpolateRoot`",
     {"InterpolateRoot", "ShowProgress"}]


(* Declarations for package NumericalMath`IntervalRoots` *)

DeclarePackage["NumericalMath`IntervalRoots`",
     {"IntervalBisection", "IntervalNewton", "IntervalSecant"}]


(* Declarations for package NumericalMath`ListIntegrate` *)

DeclarePackage["NumericalMath`ListIntegrate`",{"ListIntegrate"}]


(* Declarations for package NumericalMath`Microscope` *)

DeclarePackage["NumericalMath`Microscope`",
     {"MachineError", "Microscope", "MicroscopicError", "Ulp", "Ulps"}]


(* Declarations for package NumericalMath`NewtonCotes` *)

DeclarePackage["NumericalMath`NewtonCotes`",
     {"NewtonCotesError", "NewtonCotesWeights", "QuadratureType", "Type"}]


(* Declarations for package NumericalMath`NIntegrateInterpolatingFunct` *)

DeclarePackage["NumericalMath`NIntegrateInterpolatingFunct`",
     {"NIntegrateInterpolatingFunction"}]


(* Declarations for package NumericalMath`NLimit` *)

DeclarePackage["NumericalMath`NLimit`",
     {"EulerRatio", "EulerSum", "ExtraTerms", "ND", "NLimit", "Scale", "Terms"}]


(* Declarations for package NumericalMath`NResidue` *)

DeclarePackage["NumericalMath`NResidue`",{"NResidue", "Radius"}]


(* Declarations for package NumericalMath`NSeries` *)

DeclarePackage["NumericalMath`NSeries`",{"NSeries", "Radius"}]


(* Declarations for package NumericalMath`OrderStar` *)

DeclarePackage["NumericalMath`OrderStar`",
     {"OrderStar", "OrderStarInterpolation", "OrderStarKind", 
      "OrderStarLegend", "OrderStarPoles", "OrderStarSubPlots", 
      "OrderStarSymbolSize", "OrderStarSymbolThickness", "OrderStarZeros"}]


(* Declarations for package NumericalMath`PolynomialFit` *)

DeclarePackage["NumericalMath`PolynomialFit`",
     {"FittingPolynomial", "PolynomialFit"}]


(* Declarations for package NumericalMath`SplineFit` *)

DeclarePackage["NumericalMath`SplineFit`",
     {"Bezier", "CompositeBezier", "Cubic", "SplineFit", "SplineFunction"}]


(* Declarations for package NumericalMath`TrigFit` *)

DeclarePackage["NumericalMath`TrigFit`",{"TrigFit"}]


(* End of Master package *)

Null

