(* Obsolete.m *)
(* Generate warning messages and install certain functionality *)
(* for symbols which are obsolete or superseded with this version. *)

Begin["System`"]

Unprotect[Message]

General::obsopt = "`1` is an obsolete graphics option, superseded by `2`."

ContourLevels::usage =
"ContourLevels is an obsolete graphics option, superseded by Contours."
Message[_, HoldForm[ContourLevels], _] :=
    Message[ContourLevels::obsopt, ContourLevels, Contours]

ContourSpacing::usage =
"ContourSpacing is an obsolete graphics option, superseded by Contours."
Message[_, HoldForm[ContourSpacing], _] :=
    Message[ContourSpacing::obsopt, ContourSpacing, Contours]

PlotColor::usage =
"PlotColor is an obsolete graphics option, superseded by ColorOutput."
Message[_, HoldForm[PlotColor], _] :=
    Message[PlotColor::obsopt, PlotColor, ColorOutput]

Framed::usage =
"Framed is an obsolete graphics option, superseded by Frame."
Message[_, HoldForm[Framed], _] :=
    Message[Framed::obsopt, Framed, Frame]

Plot3Matrix::usage =
"Plot3Matrix is an obsolete graphics option, superseded by
ViewCenter and ViewVertical."
Message[_, HoldForm[Plot3Matrix], _] :=
    Message[Plot3Matrix::obsopt, Plot3Matrix, {ViewCenter, ViewVertical}]


Unprotect[ Accumulate]
Accumulate::usage =
"Accumulate is an obsolete function, superseded by FoldList.\n
Accumulate[f, g[e1, e2, ...]] gives g[e1, f[e1, e2], f[f[e1, e2], e3], ...]."
Protect[ Accumulate]


Protect[Message]

General::obsfn = "`1` is an obsolete function, superseded by `2`."

RealInterval::usage =
	"RealInterval is an obsolete function, superseded by Interval."
	
Begin["Obsolete`"]
RealInterval[x_List] := 
	(Message[RealInterval::obsfn, RealInterval, Interval]; Interval[x])
End[]

Unprotect[Accumulate]

Begin["Obsolete`"]
Accumulate[x___] :=
    With[{result = oAccumulate[x]}, result /; result =!= $Failed]
oAccumulate[x___] := Module[{f,g,len=Length[{x}], result},
    Message[Accumulate::obsfn, Accumulate, FoldList];
    Which[
        len === 2,
            {f, g} = {x};
            Which[
                Length[g] > 0,
                    result = Hold[Evaluate[FoldList[f, First[g], Rest[g]]]];
                    If[result[[1,0]]===FoldList, $Failed, result[[1]]],
                MemberQ[{Symbol,Real,Complex,Integer,String}, Head[g]],
                    Message[Accumulate::accnorm, g]; $Failed,
                True, g
            ],
        len === 1,
            Message[Accumulate::argr, Accumulate, 2]; $Failed,
        True,
            Message[Accumulate::argrx, Accumulate, len, 2]; $Failed
    ]
]
Accumulate::accnorm = "Argument `1` should be a normal expression."
End[]
Protect[Accumulate]

Unprotect[Alias]
Alias::usage =
"Alias is an obsolete function, superseded by $Pre and $PreRead."
Alias[___] := $Failed /;
    (If[!$Linked, Message[Alias::obsfn, Alias, {$Pre, $PreRead}]]; False)
Protect[Alias]

(* CellArray *)
Unprotect[CellArray]
CellArray::usage =
"CellArray[{{a11, a12, ...}, ...}] is a two-dimensional graphics
 primitive which represents a rectangular array of gray cells."

Begin["Obsolete`"]

CellArray[x_] :=
(Message[CellArray::obsfn, CellArray, {Raster, RasterArray}];
Raster[x, {{0,0}, {1,1}}])

CellArray[x___] :=
(Message[CellArray::obsfn, CellArray, {Raster, RasterArray}]; Raster[x])

SetAttributes[ CellArray, {Protected, ReadProtected}]

End[]

Protect[CellArray]

Unprotect[Compose]
Compose::usage =
"Compose is an obsolete function, superseded by Composition.\n
Compose[a,b,c,d] gives a[b[c[d]]]."
Compose[___] := $Failed /; Message[Compose::obsfn, Compose, Composition]
Protect[Compose]

Unprotect[Debug]
Debug[___] := $Failed /; (Message[Debug::obsfn, Debug, Trace]; False)
Protect[Debug]

Unprotect[DownValue]
Attributes[DownValue] = HoldAll
DownValue::usage =
"DownValue is an obsolete function, superseded by DownValues.\n
DownValues[f] gives a list of transformation rules corresponding to all
downvalues (values for f[x,..], etc.) defined for the symbol f."
Begin["Obsolete`"]
DownValue[args___] := (
    Message[DownValue::obsfn, DownValue, DownValues];
    DownValues[args] )
End[]
Protect[DownValue]

(* FontForm *)
Unprotect[FontForm]

FontForm::obsff =
"FontForm[expr, font, size] is an obsolete use of FontForm, \
superseded by FontForm[expr, {font, size}]." 

Begin["Obsolete`"]

FontForm[ expr_, font_String, size_] :=
(Message[FontForm::obsff]; FontForm[ expr, {font, size}])

SetAttributes[ FontForm, {Protected, ReadProtected}]

End[]

Protect[ FontForm]

Unprotect[ Axes]

Axes::obaxes = "This is an obsolete use of Axes, superseded by AxesOrigin."

Begin["Obsolete`"]

Axes /:
Axes -> {x_,y_} /; ((NumberQ[x] && NumberQ[y]) && (Message[Axes::obaxes]; True)) :=
Sequence[ Axes -> Automatic, AxesOrigin -> {x,y}]

Axes /:
Axes -> {x_,y_} /; ((NumberQ[x] && ! NumberQ[y]) && (Message[Axes::obaxes]; True)) :=
Sequence[ Axes -> {Automatic,y} , AxesOrigin -> {x,y}]

Axes /:
Axes -> {x_,y_} /; ((!NumberQ[x] && NumberQ[y]) && (Message[Axes::obaxes]; True)) :=
Sequence[ Axes -> {x,Automatic}, AxesOrigin -> {x,y}]

End[]

Protect[ Axes]

Unprotect[FromASCII]
FromASCII::usage =
"FromASCII is an obsolete function, superseded by FromCharacterCode.\n
FromASCII[\"c\"] gives the ASCII integer code corresponding to the character c."
Begin["Obsolete`"] 
FromASCII[x___] := With[{result = oFromASCII[x]}, result /; result =!= $Failed]
oFromASCII[x___] := (
    Message[FromASCII::obsfn, FromASCII, FromCharacterCode];
    If[Length[{x}] === 1,
        If[IntegerQ[x] && 0 <= x && x <= 255,
            Check[FromCharacterCode[x], $Failed], 
            Message[FromASCII::fromascii, x]; $Failed
        ],  
        Message[FromASCII::argx, FromASCII, Length[{x}]]; $Failed
    ])
FromASCII::fromascii =
"Argument `1` is not an 8-bit ASCII code (integer in the range 0 to 255)."
End[]
Protect[FromASCII]

Unprotect[ToASCII]
ToASCII::usage =
"ToASCII is an obsolete function, superseded by ToCharacterCode.\n
ToASCII[\"c\"] gives the ASCII integer code corresponding to the character c."
Begin["Obsolete`"] 
ToASCII[x___] := With[{result = oToASCII[x]}, result /; result =!= $Failed]
oToASCII[x___] := (
    Message[ToASCII::obsfn, ToASCII, ToCharacterCode];
    If[Length[{x}] === 1,
        If[StringLength[x] === 1,
            Check[First[ToCharacterCode[x]], $Failed],
            Message[ToASCII::toascii, x]; $Failed
        ],
        Message[ToASCII::argx, ToASCII, Length[{x}]]; $Failed
    ])   
ToASCII::toascii = "Argument `1` is not a single-character string." 
End[]
Protect[ToASCII]

(*
Release is an obsolete function.
Messages for Release can be found in msg.m.
*)

Unprotect[ResetMedium]
ResetMedium[___] := $Failed /;
    (If[!$Linked, Message[ResetMedium::obsfn, ResetMedium, SetOptions]]; False)
Protect[ResetMedium]

Unprotect[StartProcess]
StartProcess[___] :=
    $Failed /; (Message[StartProcess::obsfn, StartProcess,"MathLink"]; False)
Protect[StartProcess]

Unprotect[CallProcess]
CallProcess[___] :=
    $Failed /; (Message[CallProcess::obsfn, CallProcess, "MathLink"]; False)
Protect[CallProcess]

Unprotect[EndProcess]
EndProcess[___] :=
    $Failed /; (Message[EndProcess::obsfn, EndProcess, "MathLink"]; False)
Protect[EndProcess]

Unprotect[$$Media]
$$Media::usage = $$Media::obsym =
"$$Media is an obsolete symbol, superseded by Streams[ ]."
$$Media := (Message[$$Media::obsym]; Streams[])
Protect[$$Media]

End[]

Null

