(*:Mathematica Version: 2.0 *)

(*:Package Version: 1.1 *)

(*:Name: Statistics`Common`DistributionsCommon` *)

(*:Context: Statistics`Common`DistributionsCommon` *)

(*:Title: Functions of Statistical Distributions *)

(*:Author:
  David Withoff (Wolfram Research) March 1991
*)

(*:Copyright: Copyright 1991-2005, Wolfram Research, Inc. *)

(*:History:
  original version by David Withoff (Wolfram Research) March 1991
  updated by E. C. Martin (Wolfram Research) October 1993
*)

(*:Reference: Usage messages only. *)

(*:Summary:
This package defines functions and introduces symbols in a common context for
use in statistical probability distribution packages.
*)

(*:Keywords: Distribution, functional *)

(*:Requirements: No special system requirements. *)

(*:Warning: This package is a subsidiary package to
	NormalDistribution.m, ContinuousDistributions.m, 
	DiscreteDistributions.m, and LinearRegression.m.  It is
	not meant to be loaded as an individual package. *)

(*:Sources:  
*)

BeginPackage["Statistics`Common`DistributionsCommon`"]

(* Define usage messages for symbols shared among distribution packages only 
	if the messages are not already defined. 
*)

If[Head[Domain::usage] =!= String,

Domain::usage =
"Domain[distribution] gives the domain of the specified distribution.";

PDF::usage =
"PDF[distribution, x] gives the probability density function
of the specified statistical distribution evaluated at x.";

CDF::usage =
"CDF[distribution, x] gives the cumulative distribution function of the
specified statistical distribution evaluated at x.  For continuous
distributions, this is defined as the integral of the probability density
function from the lowest value in the domain to x.  For discrete
distributions, this is defined as the sum of the probability density
function from the lowest value in the domain to x.";

CharacteristicFunction::usage =
"CharacteristicFunction[distribution, t] gives the characteristic
function of the specified statistical distribution as a function of
the variable t.  Denoting the probability density function by f[x], the
characteristic function is given by the integral of f[x] Exp[I t x] over the
domain of x for a continuous distribution, and by the sum of f[x] Exp[I t x] 
over the domain of x for a discrete distribution.";

ParameterQ::usage =
"ParameterQ[distribution] gives False if the parameter(s) of the specified
statistical distribution are invalid, and True otherwise.";

DomainQ::usage =
"DomainQ[distribution, x] gives True if x belongs to the domain of the
specified distribution, and False otherwise.  DomainQ[distribution, list]
gives True if each element in the list belongs to the domain of the
specified distribution, and False otherwise."; 

RegionProbability::usage =
"RegionProbability[distribution, domain] gives the integral of the
probability density function of the specified distribution over the
specified domain.";

RandomArray::usage =
"RandomArray[distribution, n] generates a list of length n, where each
element is a random number with the specified statistical distribution.
RandomArray[distribution, {n1, n2, ...}] generates an n1 X n2 X ... array
of nested lists of random numbers.";

]

(* Extend the usage of Random.  Look for the indicated phrase
	to determine if this has already been done.
*)

If[StringQ[Random::usage] &&
   StringPosition[Random::usage, "specified statistical distribution"] === {},
	
Random::usage = Random::usage <> " " <>
"Random[distribution] gives a random number with the specified
statistical distribution."

]

EndPackage[]

