(* :Title: Master Declarations File for Statistics *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 26 September 2004 at 12:19 *)

If[! MemberQ[$Packages, "Statistics`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Statistics`"];
     Protect @@ System`Private`p
];

(* Declarations for package Statistics`ANOVA` *)

DeclarePackage["Statistics`ANOVA`",
     {"ANOVA", "Bonferroni", "CellMeans", "Duncan", "Dunnett", "PostTests", 
      "StudentNewmanKeuls", "Tukey"}]


(* Load package Statistics`ClusterAnalysis` *)

Needs["Statistics`ClusterAnalysis`"]

(* Declarations for package Statistics`Common`DistributionsCommon` *)

DeclarePackage["Statistics`Common`DistributionsCommon`",
     {"CDF", "CharacteristicFunction", "Domain", "DomainQ", "ParameterQ", 
      "PDF", "RandomArray", "RegionProbability"}]


(* Declarations for package Statistics`Common`MultivariateCommon` *)

DeclarePackage["Statistics`Common`MultivariateCommon`",
     {"CorrelationMatrix", "CovarianceMatrix", "Ellipsoid", "Polytope"}]


(* Declarations for package Statistics`Common`PopulationsCommon` *)

DeclarePackage["Statistics`Common`PopulationsCommon`",
     {"EqualVariances", "KnownStandardDeviation", "KnownVariance"}]


(* Declarations for package Statistics`Common`RegressionCommon` *)

DeclarePackage["Statistics`Common`RegressionCommon`",
     {"AdjustedRSquared", "ANOVATable", "BasisNames", "BestFit", 
      "BestFitParameters", "BestFitParametersDelta", "CatcherMatrix", "CookD", 
      "CovarianceMatrixDetRatio", "DurbinWatsonD", "EigenstructureTable", 
      "EstimatedVariance", "FitResiduals", "HatDiagonal", "JackknifedVariance", 
      "MeanPredictionCITable", "ParameterCITable", "ParameterConfidenceRegion", 
      "ParameterTable", "PartialSumOfSquares", "PredictedResponse", 
      "PredictedResponseDelta", "RegressionReport", "RegressionReportValues", 
      "RSquared", "SequentialSumOfSquares", "SinglePredictionCITable", 
      "StandardizedResiduals", "StudentizedResiduals", "SummaryReport", 
      "VarianceInflation", "Weights"}]


(* Declarations for package Statistics`ConfidenceIntervals` *)

DeclarePackage["Statistics`ConfidenceIntervals`",
     {"ChiSquareCI", "ConfidenceLevel", "FRatioCI", "MeanCI", 
      "MeanDifferenceCI", "NormalCI", "StudentTCI", "VarianceCI", 
      "VarianceRatioCI"}]


(* Declarations for package Statistics`ContinuousDistributions` *)

DeclarePackage["Statistics`ContinuousDistributions`",
     {"BetaDistribution", "CauchyDistribution", "ChiDistribution", 
      "ExponentialDistribution", "ExtremeValueDistribution", 
      "GammaDistribution", "HalfNormalDistribution", "LaplaceDistribution", 
      "LogisticDistribution", "LogNormalDistribution", 
      "NoncentralChiSquareDistribution", "NoncentralFRatioDistribution", 
      "NoncentralStudentTDistribution", "ParetoDistribution", 
      "RayleighDistribution", "UniformDistribution", "WeibullDistribution"}]


(* Declarations for package Statistics`DataManipulation` *)

DeclarePackage["Statistics`DataManipulation`",
     {"BinCounts", "BinLists", "BooleanSelect", "CategoryCounts", 
      "CategoryLists", "ColumnDrop", "ColumnJoin", "ColumnTake", 
      "CumulativeSums", "DropNonNumeric", "DropNonNumericColumn", 
      "Frequencies", "LengthWhile", "QuantileForm", "RangeCounts", 
      "RangeLists", "RowJoin", "TakeWhile"}]


(* Declarations for package Statistics`DataSmoothing` *)

DeclarePackage["Statistics`DataSmoothing`",
     {"ExponentialSmoothing", "LinearFilter", "MovingAverage", "MovingMedian", 
      "RepeatedSmoothing"}]


(* Declarations for package Statistics`DescriptiveStatistics` *)

DeclarePackage["Statistics`DescriptiveStatistics`",
     {"CentralMoment", "CoefficientOfVariation", "DispersionReport", 
      "ExpectedValue", "GeometricMean", "HarmonicMean", "InterpolatedQuantile", 
      "InterquartileRange", "Kurtosis", "KurtosisExcess", "LocationReport", 
      "MeanDeviation", "MedianDeviation", "MLE", "PearsonSkewness1", 
      "PearsonSkewness2", "QuantileQ", "QuartileDeviation", "Quartiles", 
      "QuartileSkewness", "RootMeanSquare", "SampleRange", "ShapeReport", 
      "Skewness", "StandardDeviationMLE", "StandardErrorOfSampleMean", 
      "Standardize", "TrimmedMean", "VarianceMLE", "VarianceOfSampleMean", 
      "ZeroMean"}]


(* Declarations for package Statistics`DiscreteDistributions` *)

DeclarePackage["Statistics`DiscreteDistributions`",
     {"BernoulliDistribution", "BinomialDistribution", 
      "DiscreteUniformDistribution", "GeometricDistribution", 
      "HypergeometricDistribution", "LogSeriesDistribution", 
      "NegativeBinomialDistribution", "PoissonDistribution"}]


(* Declarations for package Statistics`HypothesisTests` *)

DeclarePackage["Statistics`HypothesisTests`",
     {"ChiSquarePValue", "FRatioPValue", "FullReport", "LargeSampleSize", 
      "MeanDifferenceTest", "MeanTest", "NormalPValue", "OneSidedPValue", 
      "PValueTable", "ResultOfTest", "SignificanceLevel", "StudentTPValue", 
      "TwoSided", "TwoSidedPValue", "VarianceRatioTest", "VarianceTest"}]


(* Declarations for package Statistics`LinearRegression` *)

DeclarePackage["Statistics`LinearRegression`",
     {"BestFitCoefficients", "ConfidenceIntervalTable", "DesignedRegress", 
      "DesignMatrix", "IncludeConstant", "NoPrint", "OutputControl", 
      "OutputList", "Regress"}]


(* Declarations for package Statistics`MultiDescriptiveStatistics` *)

DeclarePackage["Statistics`MultiDescriptiveStatistics`",
     {"AssociationMatrix", "ConvexHullArea", "ConvexHullMedian", "Correlation", 
      "Covariance", "CovarianceMatrixMLE", "CovarianceMatrixOfSampleMean", 
      "CovarianceMLE", "Decorrelate", "DispersionMatrix", "EllipsoidQuantile", 
      "EllipsoidQuartiles", "EstimateDOF", "GeneralizedVariance", 
      "KendallRankCorrelation", "MedianMethod", "MultivariateKurtosis", 
      "MultivariateKurtosisExcess", "MultivariateMeanDeviation", 
      "MultivariateMedianDeviation", "MultivariateMode", 
      "MultivariatePearsonSkewness1", "MultivariatePearsonSkewness2", 
      "MultivariateSkewness", "MultivariateTrimmedMean", "PolytopeQuantile", 
      "PolytopeQuartiles", "PrincipalComponents", "ScaleMethod", 
      "SimplexMedian", "SpatialMedian", "SpearmanRankCorrelation", 
      "TotalVariation"}]


(* Declarations for package Statistics`MultiDiscreteDistributions` *)

DeclarePackage["Statistics`MultiDiscreteDistributions`",
     {"MultinomialDistribution", "MultiPoissonDistribution", 
      "NegativeMultinomialDistribution"}]


(* Declarations for package Statistics`MultinormalDistribution` *)

DeclarePackage["Statistics`MultinormalDistribution`",
     {"HotellingTSquareDistribution", "MultinormalDistribution", 
      "MultivariateTDistribution", "QuadraticFormDistribution", 
      "WishartDistribution"}]


(* Declarations for package Statistics`NonlinearFit` *)

DeclarePackage["Statistics`NonlinearFit`",
     {"AsymptoticCorrelationMatrix", "AsymptoticCovarianceMatrix", 
      "FitCurvatureTable", "LevenbergMarquardt", "NonlinearFit", 
      "NonlinearRegress", "ParameterBias", "ShowProgress", "StartingParameters"}
      ]


(* Declarations for package Statistics`NormalDistribution` *)

DeclarePackage["Statistics`NormalDistribution`",
     {"ChiSquareDistribution", "FRatioDistribution", "NormalDistribution", 
      "PercentagePoint", "StudentTDistribution"}]


(* Declarations for package Statistics`StatisticsPlots` *)

DeclarePackage["Statistics`StatisticsPlots`",
     {"BoxExtraSpacing", "BoxLabels", "BoxLineStyle", "BoxMedianStyle", 
      "BoxOrientation", "BoxOutliers", "BoxOutlierShapes", "BoxQuantile", 
      "BoxWhiskerPlot", "DataLabels", "DataRanges", "DataSpacing", "DataTicks", 
      "PairwiseScatterPlot", "ParetoPlot", "QuantilePlot", "ReferenceLineStyle",
      "ColumnLabels", "IncludeEmptyStems", "IncludeStemCounts", "IncludeStemUnits", 
      "Leaves", "StemExponent", "StemLeafPlot"}
      ]


(* End of Master package *)

Null

