(* :Title: Binary File Operations *)

(* :Copyright: Copyright 1991-2005, Wolfram Research, Inc.*)

(* :Summary:
The Utilities`BinaryFiles` package is obsolete. All functionality is now
provided by BinaryRead, BinaryReadList, and BinaryWrite.
I have tried to add wrapper functions so that most stuff will continue to
work. The biggest changes are that reals now obey the byte order specification;
and that the read functions no longer hold arguments (which elminates the
cute feature of reading an expression with type specs embedded -- hopefully
an infrequently used one). Note that the write function uses $ByteOrdering,
so as to be consistent with the read functions (which are just calls to 
the kernel equivalents). Also note, the file opening operations will 
emit the obsolete message to drive home the issue.
*)

BeginPackage["Utilities`BinaryFiles`"]

BinaryFiles::obslt = "The Utilities`BinaryFiles` package is obsolete. All functionality is now
provided by BinaryRead, BinaryReadList, and BinaryWrite."

OpenReadBinary::usage =
"OpenReadBinary is obsolete, superseded by OpenRead[\"file\", BinaryFormat -> True].";

OpenAppendBinary::usage =
"OpenAppendBinary is obsolete, superseded by OpenAppend[\"file\", BinaryFormat -> True].";

OpenWriteBinary::usage =
"OpenWriteBinary is obsolete, superseded by OpenWrite[\"file\", BinaryFormat -> True].";

WriteBinary::usage =
"WriteBinary is obsolete, superseded by BinaryWrite.";

ByteConversion::usage =
"ByteConversion is an obsolete option for WriteBinary.";

ToBytes::usage =
"ToBytes[expr] maps to the leaves of expr and converts
them to a list of integers representing their binary form.
This works best on lists and arrays of numerical data.
Options are available for controlling which binary type each
object is to be converted to.  Objects handled
are Real, Integer, and String.  Options controlling
conversion of these types are RealConvert, IntegerConvert,
and StringConvert.  ToBytes[expr,type] forces conversion of
the leaves of expr to the named type, overriding the above
options.  Note that in the binary form of integers, negative
numbers are automatically converted to the signed representation
of the named type.";

RealConvert::usage =
"RealConvert is an option for ToBytes.  It gives the
type of byte form to convert Reals to.
The default is Double.";

IntegerConvert::usage =
"IntegerConvert is an option for ToBytes.  It gives the
type of byte form to convert Integers to.
The default is Int16.";

StringConvert::usage =
"StringConvert is an option for ToBytes.  It gives the
type of byte form to convert Strings to.
The default is CString.";

ReadBinary::usage =
"ReadBinary is obsolete, superseded by BinaryRead.";

ReadListBinary::usage =
"ReadListBinary is obsolete, superseded by BinaryReadList.";

ByteOrder::usage =
"ByteOrder is an obsolete option, superseded by ByteOrdering.";

ByteOrder = ByteOrdering;

MostSignificantByteFirst::usage =
"MostSignificantByteFirst is an obsolete value for the ByteOrder option.";

MostSignificantByteFirst = +1;

LeastSignificantByteFirst::usage =
"LeastSignificantByteFirst is an obsolete value for the ByteOrder option.";

LeastSignificantByteFirst = -1;

SignedByte::usage =
"SignedByte is an obsolete binary type for use with ReadBinary.  It takes integer values
between -128 and 127, inclusive.";

SignedByte = "Integer8";

Int8::usage =
"Int8 is an obsolete binary type for use with ReadBinary.  It takes values between 0
and 255, inclusive.  Int8 is equivalent to Byte." 

Int8 = "Byte";

SignedInt8::usage =
"SignedInt8 is an obsolete binary type for use with ReadBinary.
SignedInt8 is equivalent to SignedByte.";

SignedInt8 = "Integer8";

Int16::usage =
"Int16 is an obsolete binary type for use with ReadBinary.
It represents an unsigned 16-bit integer.";

Int16 = "UnsignedInteger16";

SignedInt16::usage =
"SignedInt16 is an obsolete binary type for use with ReadBinary.
It represents a signed 16-bit integer.";

SignedInt16 = "Integer16";

Int32::usage =
"Int32 is an obsolete binary type for use with ReadBinary.
It represents an unsigned 32-bit integer.";

Int32 = "UnsignedInteger32";

SignedInt32::usage =
"SignedInt32 is an obsolete binary type for use with ReadBinary.
It represents a signed 32-bit integer.";

SignedInt32 = "Integer32";

Single::usage =
"Single is an obsolete binary type for use with ReadBinary.  Single precision
floating point in IEEE format: 4 bytes long.";

Single = "Real32";

Double::usage =
"Double is an obsolete binary type for use with ReadBinary.  Double precision
floating point in IEEE format: 8 bytes long.";

Double = "Real64";

CString::usage =
"CString is an obsolete binary type for use with ReadBinary.  Null terminated
string of characters, ASCII values between 1 and 255
inclusive.";

CString = "TerminatedString";

Begin["`Private`"]

OpenReadBinary[f_, opts___] :=
    (Message[BinaryFiles::obslt]; OpenRead[f, BinaryFormat -> True, opts]);

OpenAppendBinary[f_, opts___] :=
    (Message[BinaryFiles::obslt]; OpenAppend[f, BinaryFormat -> True, opts]);

OpenWriteBinary[f_, opts___] :=
    (Message[BinaryFiles::obslt]; OpenWrite[f, BinaryFormat -> True, opts]);

(* unfortunately, because I can't do an assignment to Byte,  I have to coerce it
   in the read/write functions. *)
ReadBinary[args___] := BinaryRead @@ ({args}/.Byte -> "Byte");
ReadListBinary[args___] := BinaryReadList @@ ({args}/.Byte -> "Byte");

(* Because of a difference in WriteBinary semantics, I still need the full defn. *)
Options[WriteBinary] =
	{ByteConversion -> ToBytes};

WriteBinary[filename_String, rest___] :=
		WriteBinary[OpenWriteBinary[filename], rest]

WriteBinary[stream_OutputStream, towrite_, opts___] :=
	Module[{func},
		{func} = {ByteConversion}/.{opts}/.Options[WriteBinary];
		writebinary[stream, func[towrite]]
	]

writebinary[stream_,bytes:(_Integer | {__Integer})] :=
	WriteString[stream, FromCharacterCode[bytes]]

writebinary[stream_,bytes___] :=
	With[{flat = Flatten[{bytes}]},
		WriteString[stream, FromCharacterCode[flat]]/;
			MatchQ[flat,{___Integer}]
	]

(* To Bytes utility, which may still be useful to some folks. *)

ToBytes::noconv =
"Unable to convert `1` to byte form.";

ToBytes::cast =
"Warning: converting object of type `1` to type `2`.";

Options[ToBytes] =
	{ByteOrdering -> $ByteOrdering,
	IntegerConvert -> "UnsignedInteger16",
	RealConvert -> "Real64",
	StringConvert -> "TerminatedString"};

ToBytes[expr_, type_String:"None", opts___] :=
	Module[{itype, rtype, stype, endian, ctype = type},
		{itype, rtype, stype, endian} = {IntegerConvert,
				RealConvert, StringConvert, ByteOrdering}/.
			{opts}/.Options[ToBytes];
        If[itype === Byte, itype = "Byte"];
        If[ctype === Byte, ctype = "Byte"];
		endian = If[endian === -1, False, True];
		If[ctype =!= "None",
			itype = rtype = stype = ctype
		];
		If[!AtomQ[expr],
			Map[tobytes[#, itype, rtype, stype, endian]&,
				expr,
				{-1}
			],
			tobytes[expr, itype, rtype, stype, endian]
		]
	]

(* endian *)
tobytes[num:(_Real | _Integer), t1_, t2_, t3_, False]/;
        (t1 != "TerminatedString" && t2 != "TerminatedString") :=
	Reverse[tobytes[num, t1, t2, t3, True]]

(* conversions *)
tobytes[num_Real, _, "Real32", _, _] :=
    {0,0,0,0}/; Last[RealDigits[num,2]] < -127

tobytes[num_Real, _, "Real32", _, _] :=
    {255, 255, 255, 255}/; Last[RealDigits[num,2]] > 128

tobytes[num_Real,_,"Real32",_,_] :=
	Module[{frac, exp},
		{frac, exp} = RealDigits[num,2];
		Map[bitstointeger, Partition[Join[
				If[Negative[num],
					{1},
					{0}
				],
				exp = IntegerDigits[exp + 126,2];
				If[Length[exp] < 8,
					Join[zeropad[8 - Length[exp]],exp],
					exp
				],
				frac = Drop[frac,1];
				If[Length[frac] < 23,
					Join[frac, zeropad[23 - Length[frac]]],
					Take[frac,23]
				]],8]
		]/; -127 <= exp <= 128
	]

tobytes[0, "Real32", "Real32", _, _] :=
	{0,0,0,0}

tobytes[num_Real, _, "Real64", _, _] :=
    {0, 0, 0, 0, 0, 0, 0, 0}/; Last[RealDigits[num,2]] < -1023

tobytes[num_Real, _, "Real64", _, _] :=
    {255, 255, 255, 255, 255, 255, 255, 255}/; Last[RealDigits[num,2]] > 1024

tobytes[num_Real,_,"Real64",_,_] :=
	Module[{frac, exp},
		{frac, exp} = RealDigits[num,2];
		Map[bitstointeger, Partition[Join[
				If[Negative[num],
					{1},
					{0}
				],
				exp = IntegerDigits[exp + 1022,2];
				If[Length[exp] < 11,
					Join[zeropad[11 - Length[exp]],exp],
					exp
				],
				frac = Drop[frac,1];
				If[Length[frac] < 52,
					Join[frac, zeropad[52 - Length[frac]]],
					Take[frac,52]
				]],8]
		]/; -1023 <= exp <= 1024
	]

tobytes[0, "Real64", "Real64", _, _] :=
	{0, 0, 0, 0, 0, 0, 0, 0}

tobytes[num_Real,_,type:("Byte" | "UnsignedInteger16" | "UnsignedInteger32" |
                         "Integer8" | "Integer16" | "Integer32"),_,end_] :=
	(Message[ToBytes::cast, Real, type];
	tobytes[Round[num],type,Null,Null,end])

tobytes[num_Real,_,type:("TerminatedString"),_,_] :=
	(Message[ToBytes::cast, Real, type];
	tobytes[ToString[num],Null,Null,type,Null])

tobytes[num_Integer,"Byte" | "Integer8",_,_,_] :=
	{Mod[num,256]}

tobytes[num_Integer,"UnsignedInteger16" | "Integer16",_,_,True] :=
	{Quotient[#,256], Mod[#,256]}&[Mod[num, 65536]]

tobytes[num_Integer,"UnsignedInteger32" | "Integer32",_,_,True] :=
	{Quotient[#,16777216],
	Quotient[Mod[#,16777216],65536],
	Quotient[Mod[#,65536],256],
	Mod[#,256]}&[Mod[num, 4294967296]]

tobytes[num_Integer,type:("Real32" | "Real64"),_,_,_] :=
	(Message[ToBytes::cast, Integer, type];
	tobytes[N[num],Null,type,Null,Null])

tobytes[num_Integer,type:("TerminatedString"),_,_,_] :=
	(Message[ToBytes::cast, Integer, type];
	tobytes[ToString[num],Null,Null,type,Null])

tobytes[str_String,_,_,"TerminatedString",_] :=
	ToCharacterCode[str<>"\000"]

tobytes[str_String,_,_,type_,end_] :=
	(Message[ToBytes::cast, String, type];
	tobytes[ToExpression[str], type, type, Null, end])

tobytes[anything_, ___] :=
	(Message[ToBytes::noconv,anything];
	anything)

(* ToBytes utility functions; bitstointeger takes a list of
	ones and zeros, assumes they are bits, and converts it
	to the integer represented.  zeropad takes an integer n,
	and creates a list of zeros of length n. *)

bitstointeger[bits_] :=
	ToExpression["2^^" <>
		StringJoin[Map[ToString,bits]]
	]

zeropad[n_] := Table[0,{n}]


End[]

EndPackage[]

Message[BinaryFiles::obslt]

Null

