(* :Title: FilterOptions *)

(* :Author: Roman E. Maeder *)

(* :Summary:
This package provides a function for selecting valid options when passing
options from one function to another.
*)

(* :Context: Utilities`FilterOptions` *)

(* :Copyright: Copyright 1991-2005, Wolfram Research, Inc.*)
 
(* :Source: Roman E. Maeder: Programming in Mathematica,
        Third Edition, Addison-Wesley, 1996.
*)

(* :Package Version: 1.1 *)

(* :Mathematica Version: 3.0 *)

BeginPackage["Utilities`FilterOptions`"]

Unprotect[ FilterOptions ]

FilterOptions::usage = "FilterOptions[symbol, options..] returns a sequence
	of those options that are valid options for symbol.
	FilterOptions[{opts..}, options..] filters out options with names opts."

Begin["`Private`"]

FilterOptions[ command_Symbol, options___ ] :=
	FilterOptions[ First /@ Options[command], options ]

FilterOptions[ opts_List, options___ ] :=
	Sequence @@ Select[ Flatten[{options}], MemberQ[opts, First[#]]& ]

End[ ]

Protect[ FilterOptions ]

EndPackage[ ]
