/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.OAD;
import com.visigenic.vbroker.Activation.OADHelper;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.extension.CreationImplDefImpl;
import com.visigenic.vbroker.extension.Policy;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.PrintVersion;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.SystemException;

public abstract class OADaccessor {
    private CreationImplDef _implDef;
    private String _oad_host;
    private boolean _verbose;
    private OAD _oad;
    private ORB _orb;

    protected CreationImplDef ImplDef() {
        if (this._implDef == null) {
            this._implDef = new CreationImplDefImpl();
        }
        return this._implDef;
    }

    protected String OADhost() {
        return this._oad_host;
    }

    protected boolean Verbose() {
        return this._verbose;
    }

    protected OAD oad() {
        block3: {
            if (this._oad != null) break block3;
            try {
                this._oad = OADHelper.bind(this._orb, null, this.OADhost(), null);
            }
            catch (SystemException systemException) {
                if (this.Verbose()) {
                    systemException.printStackTrace();
                }
                this.Error("Failed to bind to OAD");
            }
        }
        return this._oad;
    }

    protected abstract String ProgramName();

    protected abstract void Execute();

    public String toString() {
        try {
            return "CreationImplDef=[RepositoryId=" + this.ImplDef().repository_id() + ";Instance=" + this.ImplDef().object_name() + ";Path=" + this.ImplDef().path_name() + ";Policy=" + this.ImplDef().activation_policy() + ";Arguments=" + this.ImplDef().args() + ";Environment=" + this.ImplDef().env() + "]" + ";OADhost=" + this._oad_host + "; ";
        }
        catch (SystemException systemException) {
            if (this.Verbose()) {
                systemException.printStackTrace();
            }
            this.Error("Unexpected SystemException caught: " + systemException);
            return null;
        }
    }

    protected boolean CheckParams(CreationImplDef creationImplDef) {
        if (creationImplDef.repository_id() == null || creationImplDef.repository_id().equals("")) {
            System.out.println("Repository ID (or IDL name) must be specified");
            return false;
        }
        return true;
    }

    protected String RequiredUsage() {
        return "    -i interface_name [-o object name] or\n    -r repository_id  [-o object_name] or\n    -s service_name (for service Activators)\n       Specifies the IDL interface name (or Repository ID) and instance name\n";
    }

    protected String OptionalUsage() {
        return "    -?                  Prints usage information\n    -host oad_hostname  Specifies hostname on which the remote OAD is running\n    -verbose            Verbose mode prints debugging information to console\n    -version            Prints version information for oadutil\n";
    }

    protected boolean ReadAdditionalArgs(String string) {
        return true;
    }

    protected void Error(String string) {
        System.out.println(String.valueOf(this.ProgramName()) + ": " + string);
        if (this.Verbose()) {
            System.out.println(this);
        }
        System.exit(1);
    }

    public static String ArrayToString(String[] stringArray) {
        int n;
        if (stringArray == null || (n = stringArray.length) == 0) {
            return "NONE";
        }
        String string = "(length=" + n + ")";
        string = String.valueOf(string) + "[";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + stringArray[n2] + "; ";
            ++n2;
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    public static String PolicyString(Policy policy) {
        String string;
        switch (policy.value()) {
            case 0: {
                string = "SHARED_SERVER";
                break;
            }
            case 1: {
                string = "UNSHARED_SERVER";
                break;
            }
            case 2: {
                string = "SERVER_PER_METHOD";
                break;
            }
            default: {
                string = "Invalid policy (" + policy + ")";
            }
        }
        return string;
    }

    public static String PrintImpl(CreationImplDef creationImplDef) {
        try {
            String string = OADaccessor.ArrayToString(creationImplDef.args());
            String string2 = OADaccessor.ArrayToString(creationImplDef.env());
            return "repository_id     =   " + creationImplDef.repository_id() + "\n" + "object_name       =   " + creationImplDef.object_name() + "\n" + "reference data    =   " + new String(creationImplDef.id(), 0) + "\n" + "path_name         =   " + creationImplDef.path_name() + "\n" + "activation_policy =   " + OADaccessor.PolicyString(creationImplDef.activation_policy()) + "\n" + "args              =   " + string + "\n" + "env               =   " + string2 + "\n";
        }
        catch (SystemException systemException) {
            System.out.println("Unexpected SystemException:");
            systemException.printStackTrace();
            return null;
        }
    }

    public static String getMultiWordArgument(String[] stringArray, IntHolder intHolder) {
        String string = new String(stringArray[intHolder.value++]);
        while (intHolder.value < stringArray.length && !stringArray[intHolder.value].startsWith("-")) {
            string = String.valueOf(string) + " " + stringArray[intHolder.value++];
        }
        --intHolder.value;
        return string;
    }

    protected String NameString(CreationImplDef creationImplDef) {
        String string = "RepositoryId: " + creationImplDef.repository_id();
        if (creationImplDef.object_name() != null && !creationImplDef.object_name().equals("")) {
            string = String.valueOf(string) + ", Object: " + creationImplDef.object_name();
        }
        return string;
    }

    public String StringToRepId(String string) {
        String string2;
        if (string.startsWith("IDL:")) {
            return string;
        }
        String string3 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            if (string3.length() > 0) {
                string3 = string3.concat("/");
            }
            string3 = string3.concat(string2);
        }
        string2 = "IDL:" + string3 + ":1.0";
        if (this.Verbose()) {
            System.out.println("Converted {" + string + "} ===> {" + string2 + "}");
        }
        return string2;
    }

    OADaccessor(ORB oRB, String[] stringArray) {
        this._orb = oRB;
        this._implDef = null;
        this._oad_host = null;
        this._verbose = false;
        this._oad = null;
        this.ReadArgs(stringArray);
    }

    private String[] ArgToStringSeq(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            block3: {
                try {
                    stringArray[n] = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.out.println("Internal error: " + noSuchElementException);
                    if (!this.Verbose()) break block3;
                    noSuchElementException.printStackTrace();
                }
            }
            ++n;
        }
        return stringArray;
    }

    private String[] _addToStrings(String[] stringArray, String[] stringArray2, boolean bl) {
        int n;
        String[] stringArray3 = stringArray == null ? new String[stringArray2.length] : new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        if (!bl) {
            n = 0;
            while (n < stringArray.length) {
                stringArray3[n2] = stringArray[n];
                ++n;
                ++n2;
            }
        }
        n = 0;
        while (n < stringArray2.length) {
            stringArray3[n2] = stringArray2[n];
            ++n;
            ++n2;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray3[n2] = stringArray[n3];
                ++n3;
                ++n2;
            }
        }
        return stringArray3;
    }

    protected void ReadArgs(String[] stringArray) {
        boolean bl;
        block56: {
            try {
                this._oad_host = ORB.inetAddressBytesToString(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                if (this.Verbose()) {
                    unknownHostException.printStackTrace();
                }
                this.Error("Failed to obtain local host with exception" + unknownHostException);
            }
            try {
                int n = 1;
                while (n < stringArray.length) {
                    block55: {
                        if (this.Verbose()) {
                            System.out.println("Processing argument (" + n + "/" + stringArray.length + ")" + " [" + stringArray[n] + "]");
                        }
                        if (stringArray[n].startsWith("-i") || stringArray[n].startsWith("-r") || stringArray[n].startsWith("-s")) {
                            if (this.ImplDef().repository_id() != null && !this.ImplDef().repository_id().equals("")) {
                                System.out.println("Only one of -s or -r or -i arguments allowed");
                                this.printUsageAndExit(1);
                            }
                            try {
                                boolean bl2 = stringArray[n].startsWith("-i");
                                boolean bl3 = stringArray[n].startsWith("-s");
                                String string = stringArray[++n];
                                if (bl2) {
                                    string = this.StringToRepId(string);
                                }
                                if (bl3) {
                                    if (this.ImplDef().object_name() != null && !this.ImplDef().object_name().equals("")) {
                                        System.out.println("Argument -s not allowed if object_name is specified with -o");
                                        this.printUsageAndExit(1);
                                    }
                                    this.ImplDef().repository_id("*");
                                    this.ImplDef().object_name(string);
                                    break block55;
                                }
                                this.ImplDef().repository_id(string);
                            }
                            catch (SystemException systemException) {
                                System.out.println("Unexpected error " + systemException);
                                if (this.Verbose()) {
                                    systemException.printStackTrace();
                                }
                                System.exit(1);
                            }
                        } else if (stringArray[n].startsWith("-o")) {
                            if (this.ImplDef().object_name() != null && !this.ImplDef().object_name().equals("")) {
                                if (this.ImplDef().repository_id().equals("*")) {
                                    System.out.println("Argument -s not allowed if object_name is specified with -o");
                                } else {
                                    System.out.println("Only one '-o object_name' argument may be specified");
                                }
                                this.printUsageAndExit(1);
                            }
                            IntHolder intHolder = new IntHolder();
                            intHolder.value = ++n;
                            this.ImplDef().object_name(OADaccessor.getMultiWordArgument(stringArray, intHolder));
                            n = intHolder.value;
                        } else if (stringArray[n].equals("-cpp")) {
                            this.ImplDef().path_name(stringArray[++n]);
                        } else if (stringArray[n].equals("-java")) {
                            this.ImplDef().path_name("vbj");
                            String[] stringArray2 = new String[]{stringArray[++n]};
                            this.ImplDef().args(this._addToStrings(this.ImplDef().args(), stringArray2, true));
                        } else if (stringArray[n].startsWith("-d")) {
                            String string = stringArray[++n];
                            byte[] byArray = new byte[string.length()];
                            string.getBytes(0, string.length(), byArray, 0);
                            this.ImplDef().id(byArray);
                        } else if (stringArray[n].startsWith("-p")) {
                            if (stringArray[++n].equalsIgnoreCase("shared")) {
                                this.ImplDef().activation_policy(Policy.SHARED_SERVER);
                            } else if (stringArray[n].equalsIgnoreCase("unshared")) {
                                this.ImplDef().activation_policy(Policy.UNSHARED_SERVER);
                            } else if (stringArray[n].equalsIgnoreCase("per-method")) {
                                this.ImplDef().activation_policy(Policy.SERVER_PER_METHOD);
                            } else {
                                System.out.println("Activation policy must be one of: shared, unshared, per-method");
                                this.printUsageAndExit(1);
                            }
                        } else if (stringArray[n].startsWith("-a")) {
                            this.ImplDef().args(this._addToStrings(this.ImplDef().args(), this.ArgToStringSeq(stringArray[++n]), false));
                        } else if (stringArray[n].startsWith("-e")) {
                            this.ImplDef().env(this._addToStrings(this.ImplDef().env(), this.ArgToStringSeq(stringArray[++n]), false));
                        } else if (stringArray[n].startsWith("-h")) {
                            this._oad_host = stringArray[++n];
                        } else if (stringArray[n].startsWith("-version")) {
                            PrintVersion.main(stringArray);
                            System.exit(0);
                        } else if (stringArray[n].startsWith("-v")) {
                            this._verbose = true;
                        } else if (stringArray[n].startsWith("-u") || stringArray[n].startsWith("-?")) {
                            this.printUsageAndExit(0);
                        } else if (!this.ReadAdditionalArgs(stringArray[n])) {
                            this.printUsageAndExit(1);
                        }
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.Verbose()) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                this.printUsageAndExit(1);
            }
            catch (SystemException systemException) {
                System.out.println(String.valueOf(this.ProgramName()) + ": Unexpected system exception: " + systemException);
                if (this.Verbose()) {
                    systemException.printStackTrace();
                }
                System.exit(1);
            }
            if (this.Verbose()) {
                System.out.println("After parsing arguments, accessor=" + this);
            }
            bl = false;
            try {
                bl = !this.CheckParams(this.ImplDef());
            }
            catch (SystemException systemException) {
                bl = true;
                System.out.println(String.valueOf(this.ProgramName()) + " caught system exception: " + systemException);
                if (!this.Verbose()) break block56;
                systemException.printStackTrace();
            }
        }
        if (bl) {
            this.printUsageAndExit(1);
        }
    }

    protected void printUsageAndExit(int n) {
        System.out.println("Usage: " + this.ProgramName() + " {-required flags} [-options]\n\n" + "where required flags include:\n" + this.RequiredUsage() + "\n" + "where options include:\n" + this.OptionalUsage());
        System.exit(n);
    }

    protected ORB orb() {
        return this._orb;
    }
}

