/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.ImplementationStatus;
import com.visigenic.vbroker.Activation.ObjectStatus;
import com.visigenic.vbroker.Activation.State;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.activationImpl.Forwarder;
import com.visigenic.vbroker.activationImpl.ForwarderFactory;
import com.visigenic.vbroker.activationImpl.ObjectStatusWrapper;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.extension.Policy;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.BOA;
import org.omg.CORBA.BindOptions;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.MethodPointer;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Skeleton;

abstract class SkelForwarder
extends Skeleton
implements Forwarder {
    private String[] __ids;
    protected ForwarderFactory _factory;
    protected CreationImplDef _impl;
    protected Vector _status_list;
    protected boolean _verbose;
    protected BOA _boa;

    SkelForwarder(CreationImplDef creationImplDef, ForwarderFactory forwarderFactory, BOA bOA, boolean bl) {
        this._factory = forwarderFactory;
        this.__ids = null;
        this._impl = creationImplDef;
        this._status_list = new Vector();
        this._verbose = bl;
        this._boa = bOA;
    }

    public CreationImplDef registration_info() {
        return this._impl;
    }

    public boolean isActive() {
        return this._status_list.size() != 0;
    }

    public ImplementationStatus status() {
        Enumeration enumeration;
        ImplementationStatus implementationStatus = new ImplementationStatus();
        implementationStatus.impl = this.registration_info();
        Vector vector = this._status_list;
        synchronized (vector) {
            implementationStatus.status = new ObjectStatus[this._status_list.size()];
            enumeration = this._status_list.elements();
        }
        try {
            int n = 0;
            while (enumeration.hasMoreElements()) {
                implementationStatus.status[n++] = ((ObjectStatusWrapper)enumeration.nextElement()).status();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL();
        }
        return implementationStatus;
    }

    public void setObject(int n, Object object) {
        try {
            if (this._verbose) {
                System.out.println("setObject: [" + n + ";" + object + "]");
            }
            BindOptions bindOptions = new BindOptions(true, false);
            object._bind_options(bindOptions);
            ObjectStatusWrapper objectStatusWrapper = this.getStatus(n, object);
            if (objectStatusWrapper == null) {
                objectStatusWrapper = this.createObjectStatusWrapper(n, State.ACTIVE, object);
                this._status_list.addElement(objectStatusWrapper);
                return;
            }
            ObjectStatusWrapper objectStatusWrapper2 = objectStatusWrapper;
            synchronized (objectStatusWrapper2) {
                if (objectStatusWrapper.status().activation_state == State.WAITING_FOR_ACTIVATION) {
                    if (this._verbose) {
                        System.out.println("setObject: [" + objectStatusWrapper.status().unique_id + "/" + n + "]");
                    }
                    objectStatusWrapper.status().unique_id = n;
                    objectStatusWrapper.status().objRef = object;
                    objectStatusWrapper.status().activation_state = State.ACTIVE;
                    objectStatusWrapper.notify();
                } else if (this._verbose) {
                    System.out.println("Received notification but already active: {UID=" + n + ";Obj=" + object);
                }
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void removeChild(int n, Object object) {
        if (this._verbose) {
            System.out.println("removeChild: [" + n + ";" + object + "]");
        }
        ObjectStatusWrapper objectStatusWrapper = null;
        java.lang.Object object2 = this._status_list;
        synchronized (object2) {
            objectStatusWrapper = this.getStatus(n, object);
            if (objectStatusWrapper != null) {
                this._status_list.removeElement(objectStatusWrapper);
            }
        }
        if (objectStatusWrapper != null) {
            object2 = objectStatusWrapper;
            synchronized (object2) {
                objectStatusWrapper.status().activation_state = State.INACTIVE;
                if (this._factory.destroy_on_removal()) {
                    this.destroyForStatus(objectStatusWrapper);
                }
                return;
            }
        }
    }

    public void removeChildren() {
        if (this._verbose) {
            System.out.println("OAD::(" + this._impl.repository_id() + ";" + this._object_name() + ") cleanup...");
        }
        this._boa.deactivate_obj(this);
        Vector vector = this._status_list;
        synchronized (vector) {
            Enumeration enumeration = this._status_list.elements();
            while (enumeration.hasMoreElements()) {
                ObjectStatusWrapper objectStatusWrapper = (ObjectStatusWrapper)enumeration.nextElement();
                objectStatusWrapper.status().activation_state = State.INACTIVE;
                this._status_list.removeElement(objectStatusWrapper);
                if (!this._factory.destroy_on_removal()) continue;
                this.destroyForStatus(objectStatusWrapper);
            }
            this._status_list.removeAllElements();
            return;
        }
    }

    ObjectStatusWrapper _getStatusForWaiting() {
        ObjectStatusWrapper objectStatusWrapper = null;
        Enumeration enumeration = this._status_list.elements();
        while (enumeration.hasMoreElements()) {
            objectStatusWrapper = (ObjectStatusWrapper)enumeration.nextElement();
            if (objectStatusWrapper.status().activation_state != State.WAITING_FOR_ACTIVATION) continue;
            return objectStatusWrapper;
        }
        return null;
    }

    ObjectStatusWrapper _getStatusForUID(int n) {
        ObjectStatusWrapper objectStatusWrapper = null;
        if (n != 0) {
            Enumeration enumeration = this._status_list.elements();
            while (enumeration.hasMoreElements()) {
                objectStatusWrapper = (ObjectStatusWrapper)enumeration.nextElement();
                if (objectStatusWrapper.status().unique_id == n) break;
                objectStatusWrapper = null;
            }
        }
        return objectStatusWrapper;
    }

    ObjectStatusWrapper _getStatusForObjRef(Object object) {
        ObjectStatusWrapper objectStatusWrapper = null;
        if (object != null) {
            Enumeration enumeration = this._status_list.elements();
            while (enumeration.hasMoreElements()) {
                objectStatusWrapper = (ObjectStatusWrapper)enumeration.nextElement();
                if (objectStatusWrapper.status().objRef._is_equivalent(object)) break;
                objectStatusWrapper = null;
            }
        }
        return objectStatusWrapper;
    }

    public Object currentlyActive() {
        ObjectStatusWrapper objectStatusWrapper = null;
        if (this._impl.activation_policy() == Policy.SHARED_SERVER && (objectStatusWrapper = this._findActiveObject()) != null) {
            if (this._verbose) {
                System.out.println("Forwarder: already active=[" + objectStatusWrapper.status().objRef + "]");
            }
            return objectStatusWrapper.status().objRef;
        }
        return null;
    }

    int _nextUID() {
        int n = this._factory.nextUID();
        while (n == 0) {
            n = this._factory.nextUID();
        }
        return n;
    }

    ObjectStatusWrapper _findActiveObject() {
        ObjectStatusWrapper objectStatusWrapper = null;
        Vector vector = this._status_list;
        synchronized (vector) {
            int n = this._status_list.size();
            int n2 = 0;
            while (n2 < n) {
                objectStatusWrapper = (ObjectStatusWrapper)this._status_list.elementAt(n2);
                if (objectStatusWrapper.status().activation_state == State.ACTIVE) {
                    if (n2 < n - 1) {
                        this._status_list.removeElementAt(n2);
                        this._status_list.insertElementAt(objectStatusWrapper, n - 1);
                    }
                    ObjectStatusWrapper objectStatusWrapper2 = objectStatusWrapper;
                    java.lang.Object var4_6 = null;
                    return objectStatusWrapper2;
                }
                ++n2;
            }
        }
        return null;
    }

    public MethodPointer[] _methods() {
        return null;
    }

    public boolean _execute(MethodPointer methodPointer, InputStream inputStream, OutputStream outputStream) {
        GiopInputStream cfr_ignored_0 = (GiopInputStream)inputStream;
        GiopOutputStream giopOutputStream = (GiopOutputStream)outputStream;
        RequestHeader requestHeader = giopOutputStream.request();
        throw new INTERNAL("Forwarder interceptor failed for [" + this.__ids[0] + "/" + this._object_name() + "]: " + requestHeader);
    }

    public String[] _ids() {
        if (this.__ids == null) {
            this.__ids = new String[1];
            this.__ids[0] = this._impl.repository_id();
        }
        return this.__ids;
    }

    public String _object_name() {
        return this._impl.object_name();
    }

    ORB orb() {
        return (ORB)super._orb();
    }

    public abstract Object getObject();

    public abstract ObjectStatusWrapper createObjectStatusWrapper(int var1, State var2, Object var3);

    public abstract ObjectStatusWrapper getStatus(int var1, Object var2);

    public abstract void destroyForStatus(ObjectStatusWrapper var1);
}

