/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.IStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;

public class OStream {
    private static final int BOUNDARY = 4;
    private static final Object SEND_SYNCHRONIZER = new Object();
    private ByteArrayOutputStream _out = new ByteArrayOutputStream();
    private static final String CLASS_PREFIX = "com.visigenic.vbroker.ds.";
    private static final int CLASS_PREFIX_LENGTH = "com.visigenic.vbroker.ds.".length();
    public static boolean debug;

    public OStream() {
        this.write_int(0);
    }

    public void flush(DatagramSocket datagramSocket, IStream iStream) {
        this.flush(datagramSocket, iStream._packet.getAddress(), iStream._packet.getPort());
    }

    public void flush(DatagramSocket datagramSocket, InetAddress inetAddress, int n) {
        byte[] byArray = this._out.toByteArray();
        int n2 = byArray.length;
        byArray[0] = (byte)(n2 >> 24);
        byArray[1] = (byte)(n2 >> 16);
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        try {
            Object object = SEND_SYNCHRONIZER;
            synchronized (object) {
                datagramSocket.send(new DatagramPacket(byArray, byArray.length, inetAddress, n));
            }
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(iOException.toString());
        }
        if (debug) {
            System.out.println("Sent packet with " + byArray.length + " bytes");
        }
    }

    public void write_int(int n) {
        if (debug) {
            System.out.print("[write_int(" + n + ")]");
            System.out.flush();
        }
        this._out.write(n >> 24 & 0xFF);
        this._out.write(n >> 16 & 0xFF);
        this._out.write(n >> 8 & 0xFF);
        this._out.write(n & 0xFF);
    }

    public void write_char(char c) {
        if (debug) {
            System.out.print("[write_char(" + c + ")]");
            System.out.flush();
        }
        this._out.write(c & 0xFF);
        this._out.write(0);
        this._out.write(0);
        this._out.write(0);
    }

    public void write_bytes(byte[] byArray) {
        if (debug) {
            System.out.print("[write_bytes(" + byArray.length + ")]");
            System.out.flush();
        }
        this._out.write(byArray, 0, byArray.length);
    }

    public void write_String(String string) {
        if (debug) {
            System.out.print("[write_String(" + string + ")]");
            System.out.flush();
        }
        int n = string.length();
        int n2 = n + (4 - (n & 3));
        this.write_int(n2);
        byte[] byArray = new byte[n2];
        string.getBytes(0, n, byArray, 0);
        this.write_bytes(byArray);
    }

    public void write_Resource(DSResource dSResource) {
        if (debug) {
            System.out.print("[write_Resource(" + dSResource + ")]");
            System.out.flush();
        }
        this.write_char(':');
        if (dSResource == null) {
            this.write_String("::");
            return;
        }
        String string = dSResource.getClass().getName();
        if (!string.startsWith(CLASS_PREFIX)) {
            throw new MARSHAL();
        }
        String string2 = string.substring(CLASS_PREFIX_LENGTH, string.length());
        this.write_String(string2);
        dSResource.write(this);
    }
}

