/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.extension.ActivationImplDefImpl;
import com.visigenic.vbroker.extension.Activator;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.DynamicImplementationDispatcher;
import com.visigenic.vbroker.orb.GarbageCollector;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.PersistentId;
import com.visigenic.vbroker.orb.ProtocolManager;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.ServiceId;
import com.visigenic.vbroker.orb.ServiceSkeleton;
import com.visigenic.vbroker.orb.SkeletonDelegate;
import com.visigenic.vbroker.orb.TransientId;
import com.visigenic.vbroker.util.PropertyManager;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.portable.Skeleton;

public abstract class AdapterImpl
extends Adapter
implements GarbageCollector.Collectable,
Observer {
    protected ORB _orb;
    protected Properties _properties;
    protected PropertyManager _propertiesManager;
    protected Vector _oaList = new Vector();
    protected AdapterListener _listener;
    protected boolean _shutdown = false;
    protected Vector _connections = new Vector();
    protected ProtocolManager.Protocol _protocol;
    protected Hashtable _skeletons = new Hashtable();
    protected Dictionary _serviceSkeletons = new Hashtable();
    protected Dictionary _typeIds = new Hashtable();
    protected int _maxConnections;
    protected long _connectionIdleTime;

    public PropertyManager getPropertyManager() {
        return this._propertiesManager;
    }

    public void collect(long l) {
        if (this._connectionIdleTime == 0L) {
            return;
        }
        Enumeration enumeration = ((Vector)this._connections.clone()).elements();
        long l2 = l - this._connectionIdleTime;
        while (enumeration.hasMoreElements()) {
            Adapter.Dispatcher dispatcher = (Adapter.Dispatcher)enumeration.nextElement();
            dispatcher.deactivateIfNotUsedSince(l2);
        }
    }

    public synchronized Adapter.Dispatcher newConnection(Connection connection) {
        if (this._shutdown) {
            return null;
        }
        if (this._maxConnections != 0 && this._connections.size() >= this._maxConnections && !this.detachAgedConnection()) {
            connection.close();
            return null;
        }
        Adapter.Dispatcher dispatcher = this.createDispatcher(connection);
        this._connections.addElement(dispatcher);
        dispatcher.activate();
        return dispatcher;
    }

    public abstract Adapter.Dispatcher createDispatcher(Connection var1);

    public synchronized void dispatcherCompleted(Adapter.Dispatcher dispatcher) {
        this._connections.removeElement(dispatcher);
    }

    public boolean detachAgedConnection() {
        Adapter.Dispatcher dispatcher = null;
        long l = Long.MAX_VALUE;
        AdapterImpl adapterImpl = this;
        synchronized (adapterImpl) {
            Enumeration enumeration = this._connections.elements();
            while (enumeration.hasMoreElements()) {
                Adapter.Dispatcher dispatcher2 = (Adapter.Dispatcher)enumeration.nextElement();
                if (!dispatcher2.holdIfNotUsedSince(l)) continue;
                l = dispatcher2.lastUsed();
                if (dispatcher != null) {
                    dispatcher.activate();
                }
                dispatcher = dispatcher2;
            }
            if (dispatcher == null) {
                boolean bl = false;
                java.lang.Object var7_7 = null;
                return bl;
            }
        }
        dispatcher.deactivate();
        return true;
    }

    protected int getValue(Properties properties, String string, int n) {
        int n2 = n;
        if (properties == null) {
            return n;
        }
        try {
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n2;
    }

    public void init(ORB oRB, Properties properties) {
        this._orb = oRB;
        this._properties = properties;
        this._orb.garbageCollector().addCollectable(this);
        this.update(this._propertiesManager, "OAconnectionMax");
        this.update(this._propertiesManager, "OAconnectionMaxIdle");
    }

    public void listen(TaggedProfile taggedProfile) {
        this._protocol = this._orb.protocolManager().getProtocol(taggedProfile);
        this._listener = (AdapterListener)this._orb.create(37, this);
        this._listener.listen(this, taggedProfile);
    }

    public void obj_is_ready(Object object) {
        this.obj_is_ready(object, null, null);
    }

    protected Skeleton getSkeleton(Object object) {
        if (object instanceof Skeleton) {
            return (Skeleton)object;
        }
        if (object instanceof DynamicImplementation) {
            String string;
            try {
                string = (String)object.getClass().getMethod("_object_name", new Class[0]).invoke((java.lang.Object)object, new java.lang.Object[0]);
            }
            catch (Throwable throwable) {
                string = null;
            }
            return new DynamicImplementationDispatcher((DynamicImplementation)object, string);
        }
        throw new BAD_PARAM("obj_is_ready() may only be called on implementations");
    }

    protected ObjectId createObjectId(Skeleton skeleton, String string, byte[] byArray) {
        ObjectId objectId = null;
        if (string != null) {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            objectId = new ServiceId(this._orb, string, byArray);
        } else {
            String string2 = skeleton._ids()[0];
            String string3 = skeleton._object_name();
            objectId = string3 != null ? new PersistentId(this._orb, string2, string3) : new TransientId(this._orb, string2);
        }
        if (this._orb.debug) {
            this._orb.println("new ObjectId: " + objectId);
        }
        return objectId;
    }

    protected void registerPersistentObject(Skeleton skeleton, PersistentId persistentId) {
        String[] stringArray = skeleton._ids();
        String string = persistentId.objectName();
        int n = 0;
        while (n < stringArray.length) {
            java.lang.Object v;
            Hashtable<String, Skeleton> hashtable = (Hashtable<String, Skeleton>)this._typeIds.get(stringArray[n]);
            if (hashtable == null) {
                hashtable = new Hashtable<String, Skeleton>();
                this._typeIds.put(stringArray[n], hashtable);
            }
            if ((v = hashtable.get(string)) != null) {
                if (v != skeleton) {
                    throw new BAD_PARAM("Another skeleton with same name/type is already registered.");
                }
            } else {
                String string2;
                hashtable.put(string, skeleton);
                if (this._orb.backwardCompatible && stringArray[n].startsWith("IDL:") && stringArray[n].endsWith(":1.0") && this._typeIds.get(string2 = this._orb.repIdToIdlName(stringArray[n])) == null) {
                    this._typeIds.put(string2, hashtable);
                }
            }
            ++n;
        }
    }

    protected void addSkeleton(Skeleton skeleton, ObjectId objectId) {
        java.lang.Object[] objectArray = new java.lang.Object[]{skeleton, objectId};
        SkeletonDelegate skeletonDelegate = (SkeletonDelegate)this._orb.create(2, objectArray);
        skeleton._set_delegate(skeletonDelegate);
        this._skeletons.put(skeletonDelegate.key_id(skeleton), skeleton);
        skeletonDelegate.addAdapter(this);
    }

    public void obj_is_ready(Object object, String string, byte[] byArray) {
        if (this._shutdown) {
            return;
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Skeleton skeleton = null;
        Hashtable hashtable = this._skeletons;
        synchronized (hashtable) {
            java.lang.Object object2;
            skeleton = this.getSkeleton(object);
            try {
                object2 = (SkeletonDelegate)skeleton._get_delegate();
                if (this._skeletons.containsKey(((SkeletonDelegate)object2).key_id(skeleton))) {
                    java.lang.Object var6_7 = null;
                    return;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {}
            object2 = this.createObjectId(skeleton, string, byArray);
            this.addSkeleton(skeleton, (ObjectId)object2);
            if (object2 instanceof PersistentId) {
                this.registerPersistentObject(skeleton, (PersistentId)object2);
            } else {
                this._skeletons.put(object2, skeleton);
            }
            if (this._orb.debug) {
                this._orb.println(String.valueOf(this.getClass().getName()) + ".obj_is_ready(" + skeleton + ")");
            }
        }
        this._orb.adapterManager().registerSkeleton(skeleton);
    }

    protected void unregisterPersistentObject(Skeleton skeleton, PersistentId persistentId) {
        String[] stringArray = skeleton._ids();
        String string = persistentId.objectName();
        int n = 0;
        while (n < stringArray.length) {
            Dictionary dictionary = (Dictionary)this._typeIds.get(stringArray[n]);
            dictionary.remove(string);
            ++n;
        }
    }

    public void deactivate_obj(Object object) {
        Skeleton skeleton;
        if (this._shutdown) {
            return;
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Hashtable hashtable = this._skeletons;
        synchronized (hashtable) {
            SkeletonDelegate skeletonDelegate;
            try {
                skeletonDelegate = (SkeletonDelegate)this._orb.getDelegate(object);
                skeleton = (Skeleton)this._skeletons.get(skeletonDelegate.key_id(object));
                if (skeleton == null) {
                    throw new BAD_PARAM("skeleton: " + object + " not known to this adapter.");
                }
            }
            catch (Exception exception) {
                throw new BAD_PARAM("deactivate_obj() may only be called on implementations");
            }
            if (this._orb.debug) {
                this._orb.println("BOA.deactivate_obj(" + skeleton + ")");
            }
            this._skeletons.remove(skeletonDelegate.key_id(skeleton));
            ObjectId objectId = skeletonDelegate.object_id(skeleton);
            if (objectId instanceof PersistentId) {
                this.unregisterPersistentObject(skeleton, (PersistentId)objectId);
            } else {
                this._skeletons.remove(objectId);
            }
        }
        this._orb.adapterManager().unregisterSkeleton(skeleton);
    }

    public Principal get_principal(Object object) {
        ServerThreadInfo serverThreadInfo = (ServerThreadInfo)this._orb.getThreadLocalObject("com.visigenic.vbroker.orb.ServerThreadInfo");
        if (serverThreadInfo != null && serverThreadInfo.target == object && serverThreadInfo.principal != null) {
            return this._orb.create_Principal(serverThreadInfo.principal);
        }
        return null;
    }

    public void shutdown() {
        java.lang.Object object = this;
        synchronized (object) {
            if (this._shutdown) {
                java.lang.Object var2_2 = null;
                return;
            }
            this._shutdown = true;
        }
        this._listener.shutdown();
        while (this._connections.size() > 0) {
            object = ((Vector)this._connections.clone()).elements();
            while (object.hasMoreElements()) {
                Adapter.Dispatcher dispatcher = (Adapter.Dispatcher)object.nextElement();
                dispatcher.deactivate();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
            return;
        }
    }

    public synchronized void impl_is_ready() {
        while (!this._shutdown) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void impl_is_ready(String string, Activator activator) {
        this.impl_is_ready(string, activator, true);
    }

    public void impl_is_ready(String string, Activator activator, boolean bl) {
        ActivationImplDefImpl activationImplDefImpl = new ActivationImplDefImpl(string, new byte[0], activator);
        ServiceSkeleton serviceSkeleton = new ServiceSkeleton(activationImplDefImpl);
        this._serviceSkeletons.put(string, serviceSkeleton);
        this.obj_is_ready(serviceSkeleton);
        if (bl) {
            this.impl_is_ready();
        }
    }

    public void add(Adapter adapter) {
        this._oaList.addElement(adapter);
    }

    public int getNumObjects() {
        return this._skeletons.size();
    }

    public Enumeration getObjects() {
        return ((Hashtable)this._skeletons.clone()).elements();
    }

    public int activatedConnections() {
        return this._connections.size();
    }

    public Object getObject(TaggedProfile taggedProfile) {
        Skeleton skeleton = this.getSkeleton(taggedProfile);
        if (skeleton instanceof DynamicImplementationDispatcher) {
            return ((DynamicImplementationDispatcher)skeleton).getObject();
        }
        return skeleton;
    }

    public Object getObject(ObjectId objectId) {
        Skeleton skeleton = this.getSkeleton(objectId);
        if (skeleton instanceof DynamicImplementationDispatcher) {
            return ((DynamicImplementationDispatcher)skeleton).getObject();
        }
        return skeleton;
    }

    public Skeleton getSkeleton(ObjectId objectId) {
        Skeleton skeleton = (Skeleton)this._skeletons.get(objectId);
        if (skeleton != null) {
            return skeleton;
        }
        if (objectId instanceof PersistentId) {
            PersistentId persistentId = (PersistentId)objectId;
            Dictionary dictionary = (Dictionary)this._typeIds.get(persistentId.repId());
            if (dictionary != null) {
                String string = persistentId.objectName();
                if (string == null || string.equals("")) {
                    try {
                        return (Skeleton)dictionary.elements().nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        return null;
                    }
                }
                return (Skeleton)dictionary.get(persistentId.objectName());
            }
            return null;
        }
        if (objectId instanceof ServiceId) {
            ServiceId serviceId = (ServiceId)objectId;
            ServiceSkeleton serviceSkeleton = (ServiceSkeleton)this._serviceSkeletons.get(serviceId.serviceName());
            if (serviceSkeleton == null) {
                return null;
            }
            skeleton = (Skeleton)serviceSkeleton.activate(serviceId.id());
            this.obj_is_ready(skeleton, serviceId.serviceName(), serviceId.id());
            return skeleton;
        }
        return null;
    }

    public IOR keyIor(Object object) {
        SkeletonDelegate skeletonDelegate = (SkeletonDelegate)this._orb.getDelegate(object);
        IOR iOR = new IOR();
        iOR.type_id = skeletonDelegate.repository_id(object);
        iOR.profiles = new TaggedProfile[1];
        iOR.profiles[0] = this.profile(skeletonDelegate.key_id(object));
        return iOR;
    }

    public void maxConnection(int n) {
        this._maxConnections = n;
    }

    public void idleConnection(int n) {
        this._connectionIdleTime = n * 1000;
    }

    public void update(Observable observable, java.lang.Object object) {
        String string = (String)object;
        PropertyManager propertyManager = (PropertyManager)observable;
        if (string.equals("OAconnectionMax")) {
            this.maxConnection(propertyManager.getInt(string));
        } else {
            string.equals("OAconnectionMaxIdle");
        }
        this.idleConnection(propertyManager.getInt(string));
    }

    public interface AdapterListener {
        public void listen(Adapter var1, TaggedProfile var2);

        public void connectionCompleted(Connection var1);

        public void shutdown();

        public TaggedProfile listenEndpoint();
    }
}

