/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.AdapterManager;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.PseudoObject;
import com.visigenic.vbroker.orb.Registrar;
import com.visigenic.vbroker.orb.TPIiopAdapter;
import com.visigenic.vbroker.orb.TSIiopAdapter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.BOA;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Skeleton;

public class AdapterManagerImpl
extends PseudoObject
implements AdapterManager,
OrbObject {
    private Dictionary _adapters = new Hashtable();
    private Dictionary _factories = new Hashtable();
    private Vector _registrars = new Vector();
    private ORB _orb;

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        this.addAdapterFactory("TSession", new TSIiopAdapter());
        this.addAdapterFactory("TPool", new TPIiopAdapter());
        java.lang.Object object = this._orb.locator();
        if (object instanceof Registrar) {
            this._registrars.addElement(object);
        }
    }

    public synchronized BOA init(String string, Properties properties) {
        Adapter adapter = (Adapter)this._adapters.get(string);
        if (adapter == null) {
            try {
                Adapter.Factory factory = (Adapter.Factory)this._factories.get(string);
                if (factory == null) {
                    throw new OBJ_ADAPTER("Unknown adapter type: " + string);
                }
                adapter = factory.create(string);
                this._adapters.put(string, adapter);
            }
            catch (Exception exception) {
                throw new OBJ_ADAPTER("Could not instantiate adapter: " + exception);
            }
        }
        adapter.init(this._orb, properties);
        return adapter;
    }

    public void addAdapterFactory(String string, Adapter.Factory factory) {
        this._factories.put(string, factory);
    }

    public void removeAdapterFactory(String string) {
        this._factories.remove(string);
    }

    public void addRegistrar(Registrar registrar) {
        this._registrars.addElement(registrar);
    }

    public void removeRegistrar(Registrar registrar) {
        this._registrars.removeElement(registrar);
    }

    public void registerSkeleton(Skeleton skeleton) {
        Enumeration enumeration = this._registrars.elements();
        while (enumeration.hasMoreElements()) {
            Registrar registrar = (Registrar)enumeration.nextElement();
            registrar.registerSkeleton(skeleton);
        }
    }

    public void unregisterSkeleton(Skeleton skeleton) {
        Enumeration enumeration = this._registrars.elements();
        while (enumeration.hasMoreElements()) {
            Registrar registrar = (Registrar)enumeration.nextElement();
            registrar.unregisterSkeleton(skeleton);
        }
    }

    public Object getObject(IOR iOR) {
        Enumeration enumeration = this._adapters.elements();
        while (enumeration.hasMoreElements()) {
            Adapter adapter = (Adapter)enumeration.nextElement();
            int n = 0;
            while (n < iOR.profiles.length) {
                Object object = adapter.getObject(iOR.profiles[n]);
                if (object != null) {
                    return object;
                }
                ++n;
            }
        }
        return null;
    }

    public Object getObject(ObjectId objectId) {
        Enumeration enumeration = this._adapters.elements();
        while (enumeration.hasMoreElements()) {
            Adapter adapter = (Adapter)enumeration.nextElement();
            Object object = adapter.getObject(objectId);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Adapter getAdapter(String string) {
        return (Adapter)this._adapters.get(string);
    }

    public Enumeration getAdapters() {
        return this._adapters.keys();
    }

    public int getNumAdapters() {
        return this._adapters.size();
    }

    public void shutdown() {
        Enumeration enumeration = this._adapters.elements();
        while (enumeration.hasMoreElements()) {
            Adapter adapter = (Adapter)enumeration.nextElement();
            adapter.shutdown();
        }
    }
}

