/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.IORHelper;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopStream;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.TypeCode;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;

public class GiopInputStreamImpl
extends GiopInputStream
implements GiopStream,
OrbObject {
    private ORB _orb;
    private byte[] _bytes;
    private int _offset;
    private int _dataOffset;
    private boolean _byteOrder = false;
    private Dictionary _typeCodes;
    private int _length;
    private int _nesting;
    private Vector _encapsulations = new Vector();
    private int _align;

    GiopInputStreamImpl() {
    }

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        this._bytes = (byte[])objectArray[0];
        this._length = this._bytes.length;
    }

    public int offset() {
        return this._offset;
    }

    public void offset(int n) {
        this._offset = n;
    }

    public int dataOffset() {
        return this._dataOffset;
    }

    public void dataOffset(int n) {
        this._dataOffset = n;
    }

    public void length(int n) {
        this._length = n;
    }

    public int length() {
        return this._length;
    }

    public boolean byteOrder() {
        return this._byteOrder;
    }

    public void byteOrder(boolean bl) {
        this._byteOrder = bl;
    }

    public void startEncapsulation() {
        this.read_long();
        this._encapsulations.addElement(new EncapsulationState(this._align, this._byteOrder));
        this._align = this._offset;
        this._byteOrder = this.read_boolean();
    }

    public void endEncapsulation() {
        EncapsulationState encapsulationState = (EncapsulationState)this._encapsulations.lastElement();
        this._encapsulations.removeElement(encapsulationState);
        this._align = encapsulationState.align;
        this._byteOrder = encapsulationState.byteOrder;
    }

    final void align(int n) {
        int n2 = (this._offset - this._align) % n;
        if (n2 != 0) {
            this._offset += n - n2;
        }
    }

    public byte[] bytes() {
        return this._bytes;
    }

    public Object read_Object() {
        return this._orb.iorToObject(IORHelper.read(this));
    }

    public org.omg.CORBA.TypeCode read_TypeCode() {
        TypeCode typeCode;
        block8: {
            int n = this._offset;
            int n2 = this.read_long();
            typeCode = null;
            try {
                if (this._nesting++ == 0) {
                    this._typeCodes = new Hashtable();
                }
                if (n2 == -1) {
                    n = this._offset + 4;
                    int n3 = this.read_long();
                    n += n3;
                    if (!this._orb.backwardCompatible) {
                        n -= 4;
                    }
                    if ((typeCode = (TypeCode)this._typeCodes.get(new Integer(n))) == null) {
                        throw new MARSHAL("Invalid TypeCode offset: " + n + "/" + n3);
                    }
                    break block8;
                }
                this._offset = n;
                typeCode = this._orb.create_tc();
                this._typeCodes.put(new Integer(n), typeCode);
                typeCode.read(this, this._orb.backwardCompatible);
            }
            catch (Throwable throwable) {
                java.lang.Object var5_6 = null;
                if (!this._orb.backwardCompatible && --this._nesting == 0) {
                    this._typeCodes = null;
                }
                throw throwable;
            }
        }
        java.lang.Object var5_5 = null;
        if (!this._orb.backwardCompatible && --this._nesting == 0) {
            this._typeCodes = null;
        }
        return typeCode;
    }

    public Principal read_Principal() {
        return this._orb.create_Principal(this.readByteArray(this.read_long()));
    }

    public Any read_any() {
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode();
        Any any = this._orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public boolean read_boolean() {
        return this.read_octet() != 0;
    }

    public char read_char() {
        return (char)this.read_octet();
    }

    public char read_wchar() {
        short s = this.read_short();
        if (s <= -8193 && s >= -10240) {
            throw new DATA_CONVERSION("Cannot convert UTF-16 value to Unicode");
        }
        return (char)s;
    }

    public byte read_octet() {
        try {
            return this._bytes[this._offset++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public short read_ushort() {
        return this.read_short();
    }

    public short read_short() {
        try {
            this.align(2);
            int n = this._bytes[this._offset++] & 0xFF;
            int n2 = this._bytes[this._offset++] & 0xFF;
            int n3 = !this._byteOrder ? (n << 8) + n2 : n + (n2 << 8);
            return (short)n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public int read_long() {
        try {
            this.align(4);
            int n = this._bytes[this._offset++] & 0xFF;
            int n2 = this._bytes[this._offset++] & 0xFF;
            int n3 = this._bytes[this._offset++] & 0xFF;
            int n4 = this._bytes[this._offset++] & 0xFF;
            int n5 = !this._byteOrder ? (n << 24) + (n2 << 16) + (n3 << 8) + n4 : n + (n2 << 8) + (n3 << 16) + (n4 << 24);
            return n5;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public long read_longlong() {
        try {
            this.align(8);
            long l = this._bytes[this._offset++] & 0xFF;
            long l2 = this._bytes[this._offset++] & 0xFF;
            long l3 = this._bytes[this._offset++] & 0xFF;
            long l4 = this._bytes[this._offset++] & 0xFF;
            long l5 = this._bytes[this._offset++] & 0xFF;
            long l6 = this._bytes[this._offset++] & 0xFF;
            long l7 = this._bytes[this._offset++] & 0xFF;
            long l8 = this._bytes[this._offset++] & 0xFF;
            long l9 = !this._byteOrder ? (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8 : l + (l2 << 8) + (l3 << 16) + (l4 << 24) + (l5 << 32) + (l6 << 40) + (l7 << 48) + (l8 << 56);
            return l9;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String read_string() {
        int n = this.read_long();
        if (n != 0) return new String(this.readByteArray(n), 0, 0, n - 1);
        if (!this._orb.nullString) throw new MARSHAL("null Strings are illegal in IIOP.  Please correct your application or run the ORB in backward compatibility mode.");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String read_wstring() {
        int n = this.read_long();
        if (n == 0) {
            if (!this._orb.nullString) throw new MARSHAL("null Strings are illegal in IIOP.  Please correct your application or run the ORB in backward compatibility mode.");
            return null;
        }
        char[] cArray = new char[n - 1];
        this.read_wchar_array(cArray, 0, n - 1);
        this.read_wchar();
        return new String(cArray);
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(this._bytes, this._offset, byArray, n, n2);
            this._offset += n2;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public byte[] readByteArray(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this._orb.println("Forcing garbage collection due to limited memory...");
                System.gc();
                try {
                    byArray = new byte[n];
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    throw new NO_RESOURCES("Could not allocate " + n + " bytes");
                }
            }
        }
        this.read_octet_array(byArray, 0, n);
        return byArray;
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            blArray[n3] = this.read_boolean();
            ++n3;
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = this.read_char();
            ++n3;
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = this.read_wchar();
            ++n3;
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            sArray[n3] = this.read_short();
            ++n3;
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            nArray[n3] = this.read_long();
            ++n3;
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            lArray[n3] = this.read_longlong();
            ++n3;
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            fArray[n3] = this.read_float();
            ++n3;
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            dArray[n3] = this.read_double();
            ++n3;
        }
    }

    public int available() {
        int n = this._length - this.offset();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void close() throws IOException {
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long l) throws IOException {
        int n = this.available();
        if (l <= (long)n) {
            this._offset = (int)((long)this._offset + l);
            return l;
        }
        this._offset = this._bytes.length;
        return n;
    }

    public int read() throws IOException {
        if (this.available() > 0) {
            return this.read_octet() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return (int)this.skip(n2);
        }
        int n3 = this.available();
        if (n3 > 0) {
            int n4;
            if (n3 < n2) {
                n2 = n3;
            }
            if ((n4 = byArray.length - n) < n2) {
                n2 = n4;
            }
            System.arraycopy(this._bytes, this._offset, byArray, n, n2);
            this._offset += n2;
            return n2;
        }
        return -1;
    }

    final class EncapsulationState {
        int align;
        boolean byteOrder;

        EncapsulationState(int n, boolean bl) {
            GiopInputStreamImpl.this = GiopInputStreamImpl.this;
            this.align = n;
            this.byteOrder = bl;
        }
    }
}

