/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.Version;
import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IIOP_1_1.ProfileBodyHelper;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.AdapterImpl;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.portable.Skeleton;

public abstract class IiopAdapter
extends AdapterImpl {
    protected IiopProtocol _protocol;
    protected ProfileBody _serverProfile;
    protected String _type;

    public void init(ORB oRB, Properties properties) {
        super.init(oRB, properties);
        Version version = new Version(1, 0);
        int n = this.getValue(properties, "OAport", 0);
        String string = null;
        if (properties != null) {
            string = properties.getProperty("OAipAddr");
        }
        if (string == null) {
            string = "";
        }
        int n2 = this.getValue(properties, "OAproxyPort", 0);
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("OAproxyIPaddr");
        }
        this._serverProfile = new ProfileBody(version, string, (short)n, new byte[0], null);
        GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
        giopOutputStream.byteOrder(false);
        giopOutputStream.write_boolean(false);
        ProfileBodyHelper.write(giopOutputStream, this._serverProfile);
        byte[] byArray = giopOutputStream.toByteArray();
        TaggedProfile taggedProfile = new TaggedProfile(0, byArray);
        ProtocolManager.Protocol protocol = this._orb.protocolManager().getProtocol(taggedProfile);
        if (!(protocol instanceof IiopProtocol)) {
            throw new OBJ_ADAPTER("No IIOP Protocol Support Installed.");
        }
        this._protocol = (IiopProtocol)protocol;
        this.listen(taggedProfile);
        ProfileBody profileBody = this._protocol.profileBody(this._listener.listenEndpoint());
        this._serverProfile.port = (short)(n2 == 0 ? (int)profileBody.port : n2);
        this._serverProfile.host = string2 == null ? profileBody.host : string2;
    }

    public synchronized TaggedProfile profile(ObjectId objectId) {
        this._serverProfile.object_key = objectId.bytes();
        return this._protocol.taggedProfile(this._serverProfile);
    }

    public Skeleton getSkeleton(TaggedProfile taggedProfile) {
        ProfileBody profileBody;
        try {
            profileBody = this._protocol.profileBody(taggedProfile);
        }
        catch (BAD_PARAM bAD_PARAM) {
            return null;
        }
        if (profileBody.host.equals(this._serverProfile.host) && profileBody.port == this._serverProfile.port) {
            return this.getSkeleton(this._orb.toObjectId(profileBody.object_key));
        }
        return null;
    }
}

