/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.fe.idl;

import com.visigenic.vbroker.util.fe.idl.IDLParser;
import com.visigenic.vbroker.util.fe.idl.Node;
import com.visigenic.vbroker.util.fe.idl.ParseException;
import com.visigenic.vbroker.util.fe.idl.SemanticException;
import com.visigenic.vbroker.util.fe.idl.SimpleNode;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.OutputStream;

public class ASTLiteral
extends SimpleNode {
    private Object _value;

    ASTLiteral(int n) {
        super(n);
    }

    ASTLiteral(IDLParser iDLParser, int n) {
        super(iDLParser, n);
    }

    public static Node jjtCreate(int n) {
        return new ASTLiteral(n);
    }

    public static Node jjtCreate(IDLParser iDLParser, int n) {
        return new ASTLiteral(iDLParser, n);
    }

    void initLiteral(ASTLiteral aSTLiteral) {
        this._value = aSTLiteral._value;
    }

    void initNameValue(Object object) {
        this._value = object;
    }

    void initPositiveInteger(ASTLiteral aSTLiteral) throws ParseException {
        if (aSTLiteral.longValue() <= 0L) {
            throw new SemanticException("Expected a positive integer", this);
        }
        this._value = aSTLiteral._value;
    }

    void initBoolean(boolean bl) {
        this._value = new Boolean(bl);
    }

    void initInt(int n) {
        this._value = new Long(n);
    }

    void initChar(char c) {
        this._value = new Character(c);
    }

    void initFloat(double d) {
        this._value = new Double(d);
    }

    void initLong(long l) {
        this._value = new Long(l);
    }

    void initString(String string) {
        this._value = string;
    }

    Object value() {
        return this._value;
    }

    long longValue() throws ParseException {
        if (this._value instanceof Long) {
            return (Long)this._value;
        }
        throw new SemanticException("Expected an integer value", this);
    }

    double doubleValue() throws ParseException {
        if (this._value instanceof Double) {
            return (Double)this._value;
        }
        throw new SemanticException("Expected a floating point value", this);
    }

    boolean booleanValue() throws ParseException {
        if (this._value instanceof Boolean) {
            return (Boolean)this._value;
        }
        throw new SemanticException("Expected a boolean value", this);
    }

    char charValue() throws ParseException {
        if (this._value instanceof Character) {
            return ((Character)this._value).charValue();
        }
        throw new SemanticException("Expected a character value", this);
    }

    String stringValue() throws ParseException {
        if (this._value instanceof String) {
            return (String)this._value;
        }
        throw new SemanticException("Expected a string value", this);
    }

    int toPositiveInteger() throws ParseException {
        int n;
        if (this._value instanceof Long && (n = ((Long)this._value).intValue()) > 0) {
            return n;
        }
        throw new SemanticException("Expected a positive integer", this);
    }

    void print() {
        System.out.println(" Value = " + this._value.toString());
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doBinary(int n, ASTLiteral aSTLiteral) throws ParseException {
        switch (n) {
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                if (!(this._value instanceof Long)) throw new SemanticException("Bitwise operators require integer arguments", this);
                if (!(aSTLiteral._value instanceof Long)) {
                    throw new SemanticException("Bitwise operators require integer arguments", this);
                }
                long l = (Long)this._value;
                long l2 = (Long)aSTLiteral._value;
                switch (n) {
                    case 58: {
                        this._value = new Long(l & l2);
                        return;
                    }
                    case 59: {
                        this._value = new Long(l | l2);
                        return;
                    }
                    case 60: {
                        this._value = new Long(l ^ l2);
                        return;
                    }
                    case 61: {
                        this._value = new Long(l >>> (int)l2);
                        return;
                    }
                    case 62: {
                        this._value = new Long(l << (int)l2);
                        return;
                    }
                    default: {
                        throw new SemanticException("Invalid binary operation", this);
                    }
                }
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                boolean bl = this._value instanceof Double;
                boolean bl2 = aSTLiteral._value instanceof Double;
                boolean bl3 = this._value instanceof Long;
                boolean bl4 = aSTLiteral._value instanceof Long;
                if (!(bl || bl2 || bl3 || bl4)) {
                    throw new SemanticException("Binary operators require numeric arguments", this);
                }
                if (bl && bl2) {
                    double d = (Double)this._value;
                    double d2 = (Double)aSTLiteral._value;
                    try {
                        switch (n) {
                            case 63: {
                                this._value = new Double(d + d2);
                                return;
                            }
                            case 64: {
                                this._value = new Double(d - d2);
                                return;
                            }
                            case 65: {
                                this._value = new Double(d * d2);
                                return;
                            }
                            case 66: {
                                this._value = new Double(d / d2);
                                return;
                            }
                            case 67: {
                                throw new SemanticException("Cannot perform MOD on floatingpoint values", this);
                            }
                            default: {
                                throw new SemanticException("Invalid binary operation", this);
                            }
                        }
                    }
                    catch (ArithmeticException arithmeticException) {
                        new SemanticException("Arithmetic exception occured: " + arithmeticException, this);
                        throw new SemanticException("Invalid binary operation", this);
                    }
                }
                if (!bl3) throw new SemanticException("Cannot mix integer and floating point numbers in binary operations", this);
                if (!bl4) throw new SemanticException("Cannot mix integer and floating point numbers in binary operations", this);
                long l = (Long)this._value;
                long l3 = (Long)aSTLiteral._value;
                try {
                    switch (n) {
                        case 63: {
                            this._value = new Long(l + l3);
                            return;
                        }
                        case 64: {
                            this._value = new Long(l - l3);
                            return;
                        }
                        case 65: {
                            this._value = new Long(l * l3);
                            return;
                        }
                        case 66: {
                            this._value = new Long(l / l3);
                            return;
                        }
                        case 67: {
                            this._value = new Long(l % l3);
                            return;
                        }
                        default: {
                            throw new SemanticException("Invalid binary operation", this);
                        }
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    new SemanticException("Arithmetic exception occured: " + arithmeticException, this);
                    throw new SemanticException("Invalid binary operation", this);
                }
            }
        }
        throw new SemanticException("Invalid binary operation", this);
    }

    void doUnary(int n, ASTLiteral aSTLiteral) throws ParseException {
        if (!(aSTLiteral._value instanceof Long)) {
            throw new SemanticException("Unary operators require integer arguments", this);
        }
        long l = aSTLiteral.longValue();
        switch (n) {
            case 64: {
                this._value = new Long(-l);
                return;
            }
            case 63: {
                this._value = new Long(l);
                return;
            }
            case 68: {
                this._value = new Long(l ^ 0xFFFFFFFFFFFFFFFFL);
                return;
            }
        }
        throw new SemanticException("Invalid unary operation", this);
    }

    Any toAny(TypeCode typeCode) throws ParseException, BadKind {
        Any any = ORB.init().create_any();
        switch (typeCode.kind().value()) {
            case 2: {
                any.insert_short((short)this.longValue());
                return any;
            }
            case 3: {
                any.insert_long((int)this.longValue());
                return any;
            }
            case 23: {
                any.insert_longlong(this.longValue());
                return any;
            }
            case 4: {
                any.insert_ushort((short)this.longValue());
                return any;
            }
            case 5: {
                any.insert_ulong((int)this.longValue());
                return any;
            }
            case 24: {
                any.insert_ulonglong(this.longValue());
                return any;
            }
            case 9: {
                any.insert_char(this.charValue());
                return any;
            }
            case 26: {
                any.insert_wchar(this.charValue());
                return any;
            }
            case 10: {
                any.insert_octet((byte)this.longValue());
                return any;
            }
            case 17: {
                if (this._value instanceof Any) {
                    return (Any)this._value;
                }
                throw new SemanticException("Expected an enum value of type " + typeCode + " (got: " + this._value + ")", this);
            }
            case 6: {
                any.insert_float((float)this.doubleValue());
                return any;
            }
            case 7: {
                any.insert_double(this.doubleValue());
                return any;
            }
            case 8: {
                any.insert_boolean(this.booleanValue());
                return any;
            }
            case 18: 
            case 27: {
                OutputStream outputStream = any.create_output_stream();
                if (typeCode.kind() == TCKind.tk_string) {
                    outputStream.write_string(this.stringValue());
                } else {
                    outputStream.write_wstring(this.stringValue());
                }
                any.read_value(outputStream.create_input_stream(), typeCode);
                return any;
            }
            case 21: {
                return this.toAny(typeCode.content_type());
            }
        }
        throw new SemanticException("Invalid constant type: " + typeCode, this);
    }

    static long hexToLong(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        throw new NumberFormatException("Hexacecimal digit should not contain: " + c);
    }
}

