/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.fe.idl;

import com.visigenic.vbroker.ir.EstructDef;
import com.visigenic.vbroker.ir.IRObjectHelper;
import com.visigenic.vbroker.ir.InterfaceDefHelper;
import com.visigenic.vbroker.util.fe.idl.ASTCase;
import com.visigenic.vbroker.util.fe.idl.ASTDeclarator;
import com.visigenic.vbroker.util.fe.idl.ASTIdentifier;
import com.visigenic.vbroker.util.fe.idl.ASTLiteral;
import com.visigenic.vbroker.util.fe.idl.ASTParameter;
import com.visigenic.vbroker.util.fe.idl.ASTScopedName;
import com.visigenic.vbroker.util.fe.idl.ASTStructMember;
import com.visigenic.vbroker.util.fe.idl.ASTTokens;
import com.visigenic.vbroker.util.fe.idl.ASTType;
import com.visigenic.vbroker.util.fe.idl.ASTUnionMember;
import com.visigenic.vbroker.util.fe.idl.IDLParser;
import com.visigenic.vbroker.util.fe.idl.ParseException;
import com.visigenic.vbroker.util.fe.idl.RuntimeParserException;
import com.visigenic.vbroker.util.fe.idl.SemanticException;
import com.visigenic.vbroker.util.fe.idl.SimpleNode;
import com.visigenic.vbroker.util.fe.idl.Token;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDef;
import org.omg.CORBA.AttributeDefHelper;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ConstantDefHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.Container;
import org.omg.CORBA.ContainerHelper;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.EstructDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.IDLTypeHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.portable.OutputStream;

public class Manager {
    public static boolean DEBUG = System.getProperty("com.visigenic.vbroker.util.fe.idl.debug") != null;
    public static boolean DEBUGPARSER = System.getProperty("com.visigenic.vbroker.util.fe.idl.debugParser") != null;
    private static final String SCOPE = "::";
    private Repository _ir;
    private String _fileName;
    private boolean _replace;
    private static IDLParser _parser = null;
    private String _version = "1.0";
    private Vector _containers = new Vector();
    private Vector _prefixes = new Vector();
    private Dictionary _definitions = new Hashtable();
    private Dictionary _builtinTypes = new Hashtable();
    private String _currentComment;
    private static Hashtable _cppDirectives = new Hashtable();
    private static final int STRUCT = 1;
    private static final int ESTRUCT = 2;
    private static final int EXCEPTION = 3;

    private Manager(Repository repository, String string, InputStream inputStream, boolean bl) throws ParseException {
        this._ir = repository;
        this._fileName = string;
        this._replace = bl;
        IDLParser.setManager(this);
        this._containers.addElement(this.ir());
        this._prefixes.addElement(null);
        if (_parser == null) {
            _parser = new IDLParser(inputStream);
        } else {
            IDLParser.resetErrors();
            IDLParser.ReInit(inputStream);
        }
        if (!DEBUGPARSER) {
            IDLParser.disable_tracing();
        }
        this.addBuiltinType("Object", this.ir().get_primitive(PrimitiveKind.pk_objref));
        this.addBuiltinType("TypeCode", this.ir().get_primitive(PrimitiveKind.pk_TypeCode));
        this.addBuiltinType("Principal", this.ir().get_primitive(PrimitiveKind.pk_Principal));
    }

    private void addBuiltinType(String string, IDLType iDLType) {
        this._builtinTypes.put(string, iDLType);
        this._builtinTypes.put("CORBA::" + string, iDLType);
        this._builtinTypes.put("::CORBA::" + string, iDLType);
    }

    public String getFileName() {
        return this._fileName;
    }

    public static void parse(Repository repository, String string, InputStream inputStream, boolean bl) throws ParseException {
        Manager manager = null;
        long l = 0L;
        long l2 = 0L;
        try {
            manager = new Manager(repository, string, inputStream, bl);
            if (DEBUG) {
                l = System.currentTimeMillis();
            }
            IDLParser.specification();
        }
        catch (ParseException parseException) {
            IDLParser.ReportError(parseException);
        }
        if (DEBUG) {
            l2 = System.currentTimeMillis() - l;
            System.out.println("Time taken: " + l2);
        }
        if (IDLParser.numErrors() > 0L) {
            System.out.println("Encountered " + IDLParser.numErrors() + " errors and " + IDLParser.numWarnings() + " warnings.");
            throw new ParseException("Errors during compilation.");
        }
    }

    private void throwRuntimeParserException(String string, SimpleNode simpleNode) {
        throw new RuntimeParserException(string, simpleNode);
    }

    public void error(String string, Object object) {
        this.throwRuntimeParserException(string, null);
    }

    public Token next() throws ParseException {
        return IDLParser.getNextToken();
    }

    public Repository ir() throws ParseException {
        return this._ir;
    }

    String repId(String string, String string2) throws ParseException {
        return "IDL:" + this.prefix() + string + ":" + string2;
    }

    String version() {
        return this._version;
    }

    void checkUpdate(ASTIdentifier aSTIdentifier) throws ParseException {
        this.checkUpdate(aSTIdentifier.name(), aSTIdentifier, false);
    }

    void checkUpdate(String string, SimpleNode simpleNode) throws ParseException {
        this.checkUpdate(string, simpleNode, false);
    }

    void checkUpdate(String string, SimpleNode simpleNode, boolean bl) throws ParseException {
        InterfaceDef interfaceDef;
        String string2 = ContainedHelper.narrow(this.container()) == null ? SCOPE + string : String.valueOf(ContainedHelper.narrow(this.container()).absolute_name()) + SCOPE + string;
        String string3 = string2.toLowerCase();
        if (this._definitions.get(string3) != null) {
            throw new SemanticException("Attempt to redefine \"" + string2 + "\"", simpleNode);
        }
        if (bl && (interfaceDef = org.omg.CORBA.InterfaceDefHelper.narrow(this.container())) != null && (interfaceDef.lookup_name(string, 1, DefinitionKind.dk_Operation, false).length != 0 || interfaceDef.lookup_name(string, 1, DefinitionKind.dk_Attribute, false).length != 0)) {
            throw new SemanticException("Attempt to redefine operation/attribute \"" + string2 + "\"", simpleNode);
        }
        this._definitions.put(string3, simpleNode);
    }

    boolean needsUpdate(Contained contained, String string, String string2) throws ParseException {
        if (this._replace) {
            return true;
        }
        if (contained == null) {
            return true;
        }
        if (!contained.id().equals(string)) {
            return true;
        }
        String string3 = contained.version();
        if (!string2.equals(string3)) {
            return true;
        }
        Container container = contained.defined_in();
        if (this.container().def_kind() == DefinitionKind.dk_Repository && container.def_kind() == DefinitionKind.dk_Repository) {
            return false;
        }
        return !this.container()._is_equivalent(container);
    }

    private IRObject resolveAliases(IDLType iDLType) throws ParseException {
        if (iDLType == null) {
            return null;
        }
        if (iDLType.def_kind() == DefinitionKind.dk_Alias) {
            return this.resolveAliases(AliasDefHelper.narrow(iDLType).original_type_def());
        }
        return iDLType;
    }

    private static Contained lookupScopedName(Container container, String string) throws ParseException {
        Contained[] containedArray;
        Contained contained = container.lookup(string);
        if (contained != null || string.startsWith(SCOPE)) {
            return contained;
        }
        InterfaceDef interfaceDef = org.omg.CORBA.InterfaceDefHelper.narrow(container);
        if (interfaceDef != null) {
            containedArray = interfaceDef.lookup_name(string, 1, DefinitionKind.dk_all, false);
            switch (containedArray.length) {
                case 1: {
                    return containedArray[0];
                }
                default: {
                    throw new SemanticException("The scoped name \"" + string + "\" within scope \"" + interfaceDef.absolute_name() + "\" is ambiguous", null);
                }
                case 0: 
            }
        }
        if ((containedArray = ContainedHelper.narrow(container)) != null) {
            return Manager.lookupScopedName(containedArray.defined_in(), string);
        }
        return null;
    }

    private void beginContainer(Container container) throws ParseException {
        this._containers.insertElementAt(container, 0);
        this._prefixes.insertElementAt(String.valueOf(this.prefix()) + ContainedHelper.narrow(container).name(), 0);
    }

    public void endContainer() throws ParseException {
        this._containers.removeElementAt(0);
        this._prefixes.removeElementAt(0);
        this._currentComment = null;
    }

    private String prefix() {
        String string = (String)this._prefixes.firstElement();
        if (string == null || string.length() == 0) {
            return "";
        }
        return String.valueOf(string) + "/";
    }

    private void prefix(String string) {
        this._prefixes.setElementAt(string, 0);
    }

    private com.visigenic.vbroker.ir.Container container() {
        return (com.visigenic.vbroker.ir.Container)this._containers.firstElement();
    }

    public void beginModule(ASTIdentifier aSTIdentifier) throws ParseException {
        if (DEBUG) {
            System.out.println("begin module: " + aSTIdentifier);
        }
        String string = aSTIdentifier.name();
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        ModuleDef moduleDef = ModuleDefHelper.narrow(this.container().lookup(string));
        if (this.needsUpdate(moduleDef, string3, string2)) {
            moduleDef = this.container().create_module(string3, string, string2);
        }
        this.annotate(moduleDef);
        this.beginContainer(moduleDef);
    }

    public void forwardDeclareInterface(ASTIdentifier aSTIdentifier) throws ParseException {
        this.declareInterface(aSTIdentifier, null, true);
    }

    public void beginInterface(ASTIdentifier aSTIdentifier, ASTTokens aSTTokens) throws ParseException {
        this.beginContainer(this.declareInterface(aSTIdentifier, aSTTokens, false));
    }

    private InterfaceDef declareInterface(ASTIdentifier aSTIdentifier, ASTTokens aSTTokens, boolean bl) throws ParseException {
        if (DEBUG) {
            System.out.println("declareInterface: " + aSTIdentifier);
        }
        if (!bl) {
            this.checkUpdate(aSTIdentifier);
        }
        String string = aSTIdentifier.name();
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        InterfaceDef[] interfaceDefArray = new InterfaceDef[]{};
        InterfaceDef interfaceDef = org.omg.CORBA.InterfaceDefHelper.narrow(this.container().lookup(string));
        boolean bl2 = false;
        if (this.needsUpdate(interfaceDef, string3, string2)) {
            if (bl) {
                interfaceDef = this.container().forward_declare_interface(string3, string, string2);
            } else {
                bl2 = true;
            }
        }
        if (bl) {
            return interfaceDef;
        }
        if (aSTTokens != null) {
            Object[] objectArray = new ASTScopedName[aSTTokens.tokens().size()];
            aSTTokens.tokens().copyInto(objectArray);
            interfaceDefArray = new InterfaceDef[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                com.visigenic.vbroker.ir.InterfaceDef interfaceDef2 = InterfaceDefHelper.narrow(this.resolveAliases(IDLTypeHelper.narrow(Manager.lookupScopedName(this.container(), ((ASTScopedName)objectArray[n]).name()))));
                if (interfaceDef2 == null) {
                    throw new SemanticException("The scoped name \"" + ((ASTScopedName)objectArray[n]).name() + "\" does not correspond to an interface", (SimpleNode)objectArray[n]);
                }
                if (interfaceDef2.forward_declared()) {
                    throw new SemanticException("The interface \"" + ((ASTScopedName)objectArray[n]).name() + "\" must be declared before being used", (SimpleNode)objectArray[n]);
                }
                interfaceDefArray[n] = interfaceDef2;
                ++n;
            }
        }
        if (bl2) {
            interfaceDef = this.container().create_interface(string3, string, string2, interfaceDefArray);
        }
        interfaceDef.base_interfaces(interfaceDefArray);
        this.annotate(interfaceDef);
        return interfaceDef;
    }

    void declareConstant(ASTType aSTType, ASTIdentifier aSTIdentifier, ASTLiteral aSTLiteral) throws ParseException {
        Any any;
        if (DEBUG) {
            System.out.println("declareConstant: " + aSTType + " " + aSTIdentifier + " " + aSTLiteral);
        }
        this.checkUpdate(aSTIdentifier);
        String string = aSTIdentifier.name();
        IDLType iDLType = aSTType.type(this);
        TypeCode typeCode = iDLType.type();
        try {
            any = aSTLiteral.toAny(typeCode);
        }
        catch (BadKind badKind) {
            throw new ParseException(badKind.getMessage());
        }
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        ConstantDef constantDef = ConstantDefHelper.narrow(this.container().lookup(string));
        if (this.needsUpdate(constantDef, string3, string2)) {
            constantDef = this.container().create_constant(string3, string, string2, iDLType, any);
        } else {
            constantDef.type_def(iDLType);
            constantDef.value(any);
        }
        this.annotate(constantDef);
    }

    private boolean equals(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    IDLType declareEnum(ASTIdentifier aSTIdentifier, ASTTokens aSTTokens) throws ParseException {
        if (DEBUG) {
            System.out.println("declareEnum: " + aSTIdentifier + " " + aSTTokens);
        }
        this.checkUpdate(aSTIdentifier);
        String string = aSTIdentifier.name();
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        String[] stringArray = new String[aSTTokens.tokens().size()];
        Object[] objectArray = new ASTIdentifier[stringArray.length];
        aSTTokens.tokens().copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = ((ASTIdentifier)objectArray[n]).name();
            ++n;
        }
        EnumDef enumDef = EnumDefHelper.narrow(this.container().lookup(string));
        if (this.needsUpdate(enumDef, string3, string2)) {
            enumDef = this.container().create_enum(string3, string, string2, stringArray);
        } else {
            enumDef.members(stringArray);
        }
        this.annotate(enumDef);
        return enumDef;
    }

    void declareAttribute(ASTType aSTType, ASTTokens aSTTokens, boolean bl) throws ParseException {
        if (DEBUG) {
            System.out.println(String.valueOf(bl ? "readonly " : "") + "attribute " + aSTType + aSTTokens);
        }
        IDLType iDLType = aSTType.type(this);
        Object[] objectArray = new ASTDeclarator[aSTTokens.tokens().size()];
        aSTTokens.tokens().copyInto(objectArray);
        AttributeMode attributeMode = bl ? AttributeMode.ATTR_READONLY : AttributeMode.ATTR_NORMAL;
        String string = this.version();
        int n = 0;
        while (n < objectArray.length) {
            String string2 = ((ASTDeclarator)objectArray[n]).name();
            this.checkUpdate(string2, (SimpleNode)objectArray[n], true);
            IDLType iDLType2 = ((ASTDeclarator)objectArray[n]).type(this.ir(), iDLType);
            String string3 = this.repId(string2, string);
            AttributeDef attributeDef = AttributeDefHelper.narrow(this.container().lookup(string2));
            if (this.needsUpdate(attributeDef, string3, string)) {
                attributeDef = org.omg.CORBA.InterfaceDefHelper.narrow(this.container()).create_attribute(string3, string2, string, iDLType2, attributeMode);
            } else {
                attributeDef.type_def(iDLType2);
                attributeDef.mode(attributeMode);
            }
            this.annotate(attributeDef);
            ++n;
        }
    }

    void declareTypedef(ASTType aSTType, ASTTokens aSTTokens) throws ParseException {
        if (DEBUG) {
            System.out.println("typedef " + aSTType + " " + aSTTokens);
        }
        if (aSTTokens.tokens().size() < 1) {
            throw new SemanticException("Missing idenitifer", aSTType);
        }
        IDLType iDLType = aSTType.type(this);
        Object[] objectArray = new ASTDeclarator[aSTTokens.tokens().size()];
        aSTTokens.tokens().copyInto(objectArray);
        String string = this.version();
        int n = 0;
        while (n < objectArray.length) {
            String string2 = ((ASTDeclarator)objectArray[n]).name();
            this.checkUpdate(string2, (SimpleNode)objectArray[n]);
            IDLType iDLType2 = ((ASTDeclarator)objectArray[n]).type(this.ir(), iDLType);
            String string3 = this.repId(string2, string);
            AliasDef aliasDef = AliasDefHelper.narrow(this.container().lookup(string2));
            if (this.needsUpdate(aliasDef, string3, string)) {
                aliasDef = this.container().create_alias(string3, string2, string, iDLType2);
            } else {
                aliasDef.original_type_def(iDLType2);
            }
            this.annotate(aliasDef);
            ++n;
        }
    }

    Container forwardDeclareStruct(ASTIdentifier aSTIdentifier) throws ParseException {
        return this.declareClass(aSTIdentifier, null, null, 1);
    }

    void beginStruct(ASTIdentifier aSTIdentifier) throws ParseException {
        this.beginContainer(this.forwardDeclareStruct(aSTIdentifier));
    }

    IDLType declareStruct(ASTIdentifier aSTIdentifier, ASTTokens aSTTokens) throws ParseException {
        return IDLTypeHelper.narrow(this.declareClass(aSTIdentifier, null, aSTTokens, 1));
    }

    Container forwardDeclareEstruct(ASTIdentifier aSTIdentifier) throws ParseException {
        return this.declareClass(aSTIdentifier, null, null, 2);
    }

    void beginEstruct(ASTIdentifier aSTIdentifier) throws ParseException {
        this.beginContainer(this.forwardDeclareEstruct(aSTIdentifier));
    }

    IDLType declareEstruct(ASTIdentifier aSTIdentifier, ASTScopedName aSTScopedName, ASTTokens aSTTokens) throws ParseException {
        return IDLTypeHelper.narrow(this.declareClass(aSTIdentifier, aSTScopedName, aSTTokens, 2));
    }

    void beginException(ASTIdentifier aSTIdentifier) throws ParseException {
        this.beginContainer(this.declareClass(aSTIdentifier, null, null, 3));
    }

    void declareException(ASTIdentifier aSTIdentifier, ASTTokens aSTTokens) throws ParseException {
        this.declareClass(aSTIdentifier, null, aSTTokens, 3);
    }

    private StructMember[] toStructMembers(ASTTokens aSTTokens) throws ParseException {
        Object object;
        Vector<String> vector = new Vector<String>();
        Vector<StructMember> vector2 = new Vector<StructMember>();
        Object[] objectArray = new ASTStructMember[aSTTokens.tokens().size()];
        aSTTokens.tokens().copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            object = ((ASTStructMember)objectArray[n]).type().type(this);
            Object[] objectArray2 = new ASTDeclarator[((ASTStructMember)objectArray[n]).decls().tokens().size()];
            ((ASTStructMember)objectArray[n]).decls().tokens().copyInto(objectArray2);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                String string = ((ASTDeclarator)objectArray2[n2]).name();
                if (vector.contains(string)) {
                    throw new SemanticException("The member \"" + string + "\" cannot appear multiple times " + "in type declaration", (SimpleNode)objectArray2[n2]);
                }
                vector.addElement(string);
                IDLType iDLType = ((ASTDeclarator)objectArray2[n2]).type(this.ir(), (IDLType)object);
                vector2.addElement(new StructMember(string, iDLType.type(), iDLType));
                ++n2;
            }
            ++n;
        }
        object = new StructMember[vector2.size()];
        vector2.copyInto((Object[])object);
        return object;
    }

    Container declareClass(ASTIdentifier aSTIdentifier, ASTScopedName aSTScopedName, ASTTokens aSTTokens, int n) throws ParseException {
        String string;
        if (DEBUG) {
            string = null;
            if (n == 1) {
                string = "struct";
            } else if (n == 2) {
                string = "estruct";
            } else if (n == 3) {
                string = "exception";
            }
            System.out.print(String.valueOf(string) + " " + aSTIdentifier.name());
            if (aSTScopedName != null) {
                System.out.print(" : " + aSTScopedName.name());
            }
            if (aSTTokens != null) {
                System.out.println(" { " + aSTTokens.tokens() + " };");
            } else {
                System.out.println("");
            }
        }
        if (aSTTokens != null) {
            this.checkUpdate(aSTIdentifier);
        }
        string = aSTIdentifier.name();
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        StructMember[] structMemberArray = new StructMember[]{};
        switch (n) {
            case 1: {
                StructDef structDef = StructDefHelper.narrow(this.container().lookup(string));
                if (this.needsUpdate(structDef, string3, string2)) {
                    structDef = this.container().create_struct(string3, string, string2, structMemberArray);
                }
                if (aSTTokens != null && aSTTokens.tokens().size() != 0) {
                    structDef.members(this.toStructMembers(aSTTokens));
                }
                this.annotate(structDef);
                return structDef;
            }
            case 2: {
                org.omg.CORBA.EstructDef estructDef = EstructDefHelper.narrow(this.container().lookup(string));
                if (this.needsUpdate(estructDef, string3, string2)) {
                    estructDef = aSTTokens == null ? this.container().forward_declare_estruct(string3, string, string2) : this.container().create_estruct(string3, string, string2, null, structMemberArray);
                }
                if (aSTTokens == null) {
                    return estructDef;
                }
                if (aSTTokens != null && aSTTokens.tokens().size() != 0) {
                    estructDef.members(this.toStructMembers(aSTTokens));
                }
                if (aSTScopedName != null) {
                    EstructDef estructDef2 = com.visigenic.vbroker.ir.EstructDefHelper.narrow(this.resolveAliases(IDLTypeHelper.narrow(Manager.lookupScopedName(this.container(), aSTScopedName.name()))));
                    if (estructDef2 == null) {
                        throw new SemanticException("The scoped name \"" + aSTScopedName.name() + "\" does not correspond to an extensible struct", aSTScopedName);
                    }
                    estructDef.base_def(estructDef2);
                }
                this.annotate(estructDef);
                return estructDef;
            }
            case 3: {
                ExceptionDef exceptionDef = ExceptionDefHelper.narrow(this.container().lookup(string));
                if (this.needsUpdate(exceptionDef, string3, string2)) {
                    exceptionDef = this.container().create_exception(string3, string, string2, structMemberArray);
                }
                if (aSTTokens != null && aSTTokens.tokens().size() != 0) {
                    exceptionDef.members(this.toStructMembers(aSTTokens));
                }
                this.annotate(exceptionDef);
                return exceptionDef;
            }
        }
        throw new SemanticException("Invalid type in declareClass: " + n, aSTIdentifier);
    }

    Container forwardDeclareUnion(ASTIdentifier aSTIdentifier, ASTType aSTType) throws ParseException {
        return ContainerHelper.narrow(this.declareUnion(aSTIdentifier, aSTType, null));
    }

    void beginUnion(ASTIdentifier aSTIdentifier, ASTType aSTType) throws ParseException {
        this.beginContainer(this.forwardDeclareUnion(aSTIdentifier, aSTType));
    }

    IDLType declareUnion(ASTIdentifier aSTIdentifier, ASTType aSTType, ASTTokens aSTTokens) throws ParseException {
        Object object;
        Object object2;
        if (DEBUG) {
            System.out.println("union " + aSTIdentifier.name() + "(" + aSTType + ") { " + aSTTokens + " };");
        }
        if (aSTTokens != null) {
            this.checkUpdate(aSTIdentifier);
        }
        String string = aSTIdentifier.name();
        IDLType iDLType = aSTType.type(this);
        TypeCode typeCode = iDLType.type();
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        Vector<UnionMember> vector = new Vector<UnionMember>();
        if (aSTTokens != null && aSTTokens.tokens().size() != 0) {
            object2 = new Hashtable();
            object = new ASTUnionMember[aSTTokens.tokens().size()];
            aSTTokens.tokens().copyInto((Object[])object);
            int n = 0;
            while (n < ((Object[])object).length) {
                String string4 = ((ASTUnionMember)object[n]).decl().name();
                IDLType iDLType2 = object[n].decl().type(this.ir(), object[n].type().type(this));
                Object[] objectArray = new ASTCase[object[n].labels().tokens().size()];
                object[n].labels().tokens().copyInto(objectArray);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Any any;
                    if (((ASTCase)objectArray[n2]).label() == null) {
                        any = ORB.init().create_any();
                        any.insert_octet((byte)0);
                    } else {
                        try {
                            any = ((ASTCase)objectArray[n2]).label().toAny(typeCode);
                        }
                        catch (BadKind badKind) {
                            throw new ParseException(badKind.getMessage());
                        }
                    }
                    if (((Hashtable)object2).containsKey(any)) {
                        throw new SemanticException("Encountered duplicate label \"" + any + "\" in union " + string, (SimpleNode)objectArray[n2]);
                    }
                    ((Hashtable)object2).put(any, any);
                    vector.addElement(new UnionMember(string4, any, iDLType2.type(), iDLType2));
                    ++n2;
                }
                ++n;
            }
        }
        object2 = new UnionMember[vector.size()];
        vector.copyInto((Object[])object2);
        object = UnionDefHelper.narrow(this.container().lookup(string));
        if (this.needsUpdate((Contained)object, string3, string2)) {
            object = this.container().create_union(string3, string, string2, iDLType, (UnionMember[])object2);
        } else {
            object.discriminator_type_def(iDLType);
            object.members((UnionMember[])object2);
        }
        this.annotate((IRObject)object);
        return object;
    }

    void declareOperation(ASTLiteral aSTLiteral, ASTType aSTType, ASTIdentifier aSTIdentifier, ASTTokens aSTTokens, ASTTokens aSTTokens2, ASTTokens aSTTokens3) throws ParseException {
        Object object;
        Object object2;
        ExceptionDef[] exceptionDefArray;
        if (DEBUG) {
            System.out.println("operation:\n\tmode: " + aSTLiteral + "\n\ttype: " + aSTType + "\n\tid  : " + aSTIdentifier + "\n\tpars: " + aSTTokens + "\n\texcs: " + aSTTokens2 + "\n\tctxs: " + aSTTokens3);
        }
        String string = aSTIdentifier.name();
        this.checkUpdate(string, aSTIdentifier, true);
        String string2 = this.version();
        String string3 = this.repId(string, string2);
        OperationMode operationMode = OperationMode.from_int((int)aSTLiteral.longValue());
        IDLType iDLType = aSTType.type(this);
        ParameterDescription[] parameterDescriptionArray = new ParameterDescription[aSTTokens.tokens().size()];
        Object[] objectArray = new ASTParameter[parameterDescriptionArray.length];
        aSTTokens.tokens().copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            exceptionDefArray = ((ASTParameter)objectArray[n]).decl().name();
            object2 = ((ASTParameter)objectArray[n]).decl().type(this.ir(), ((ASTParameter)objectArray[n]).type().type(this));
            object = ParameterMode.from_int((int)((ASTParameter)objectArray[n]).mode().longValue());
            parameterDescriptionArray[n] = new ParameterDescription((String)exceptionDefArray, object2.type(), (IDLType)object2, (ParameterMode)object);
            ++n;
        }
        exceptionDefArray = null;
        if (aSTTokens2 != null) {
            exceptionDefArray = new ExceptionDef[aSTTokens2.tokens().size()];
            object2 = new ASTScopedName[exceptionDefArray.length];
            aSTTokens2.tokens().copyInto((Object[])object2);
            int n2 = 0;
            while (n2 < ((Object[])object2).length) {
                ExceptionDef exceptionDef = ExceptionDefHelper.narrow(Manager.lookupScopedName(this.container(), ((ASTScopedName)object2[n2]).name()));
                if (exceptionDef == null) {
                    throw new SemanticException("The scoped name \"" + ((ASTScopedName)object2[n2]).name() + "\" does not correspond to an exception", (SimpleNode)object2[n2]);
                }
                exceptionDefArray[n2] = exceptionDef;
                ++n2;
            }
        }
        object2 = null;
        if (aSTTokens3 != null) {
            object2 = new String[aSTTokens3.tokens().size()];
            object = new ASTLiteral[((Object[])object2).length];
            aSTTokens3.tokens().copyInto((Object[])object);
            int n3 = 0;
            while (n3 < ((Object[])object).length) {
                object2[n3] = ((ASTLiteral)object[n3]).stringValue();
                ++n3;
            }
        }
        if (this.needsUpdate((Contained)(object = OperationDefHelper.narrow(this.container().lookup(string))), string3, string2)) {
            object = org.omg.CORBA.InterfaceDefHelper.narrow(this.container()).create_operation(string3, string, string2, iDLType, operationMode, parameterDescriptionArray, exceptionDefArray, (String[])object2);
        } else {
            object.result_def(iDLType);
            object.mode(operationMode);
            object.params(parameterDescriptionArray);
            object.exceptions(exceptionDefArray);
            object.contexts((String[])object2);
        }
        this.annotate((IRObject)object);
    }

    void typeFromScopedName(ASTType aSTType, ASTScopedName aSTScopedName) throws ParseException {
        IDLType iDLType = IDLTypeHelper.narrow(Manager.lookupScopedName(this.container(), aSTScopedName.name()));
        if (iDLType == null) {
            iDLType = (IDLType)this._builtinTypes.get(aSTScopedName.name());
        }
        if (iDLType == null) {
            throw new SemanticException("The scoped name \"" + aSTScopedName.name() + "\" does not correspond to a type", aSTScopedName);
        }
        aSTType.initType(iDLType);
    }

    void literalFromScopedName(ASTLiteral aSTLiteral, ASTScopedName aSTScopedName) throws ParseException {
        Object object;
        Any any = null;
        boolean bl = false;
        String string = aSTScopedName.name();
        int n = string.lastIndexOf(SCOPE);
        Container container = this.container();
        if (n != -1) {
            object = string.substring(0, n);
            string = string.substring(n + 2, string.length());
            if (DEBUG) {
                System.out.println("Broke " + aSTScopedName.name() + " into " + (String)object + " / " + string);
            }
            if ((container = ContainerHelper.narrow(Manager.lookupScopedName(this.container(), (String)object))) == null) {
                throw new SemanticException("The scoped name \"" + (String)object + "\" does not correspond to a valid" + " scope", aSTScopedName);
            }
            bl = true;
        }
        block21: while (true) {
            object = container.lookup_name(string, 1, DefinitionKind.dk_Constant, true);
            switch (((Contained[])object).length) {
                case 1: {
                    Contained[] containedArray = ConstantDefHelper.narrow(object[0]);
                    if (containedArray == null) break block21;
                    any = containedArray.value();
                    break block21;
                }
                default: {
                    throw new SemanticException("The scoped name \"" + aSTScopedName.name() + "\" is ambiguous", aSTScopedName);
                }
                case 0: {
                    Contained contained;
                    Contained[] containedArray = container.contents(DefinitionKind.dk_Enum, true);
                    int n2 = 0;
                    while (n2 < containedArray.length) {
                        contained = EnumDefHelper.narrow(containedArray[n2]);
                        String[] stringArray = contained.members();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (string.equals(stringArray[n3])) {
                                any = ORB.init().create_any();
                                OutputStream outputStream = any.create_output_stream();
                                outputStream.write_long(n3);
                                any.read_value(outputStream.create_input_stream(), contained.type());
                                break block21;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    contained = com.visigenic.vbroker.ir.ContainedHelper.narrow(container);
                    if (contained == null) break block21;
                    container = contained.defined_in();
                    if (!bl && container != null) continue block21;
                }
            }
            break;
        }
        if (any == null) {
            throw new SemanticException("The scoped name \"" + aSTScopedName.name() + "\" is not a valid value of it's type.", aSTScopedName);
        }
        object = any.type();
        switch (((TypeCode)object).kind().value()) {
            case 2: {
                aSTLiteral.initNameValue(new Long(any.extract_short()));
                return;
            }
            case 3: {
                aSTLiteral.initNameValue(new Long(any.extract_long()));
                return;
            }
            case 23: {
                aSTLiteral.initNameValue(new Long(any.extract_longlong()));
                return;
            }
            case 4: {
                aSTLiteral.initNameValue(new Long(any.extract_ushort()));
                return;
            }
            case 5: {
                aSTLiteral.initNameValue(new Long(any.extract_ulong()));
                return;
            }
            case 24: {
                aSTLiteral.initNameValue(new Long(any.extract_ulonglong()));
                return;
            }
            case 10: {
                aSTLiteral.initNameValue(new Long(any.extract_octet()));
                return;
            }
            case 9: {
                aSTLiteral.initNameValue(new Character(any.extract_char()));
                return;
            }
            case 26: {
                aSTLiteral.initNameValue(new Character(any.extract_wchar()));
                return;
            }
            case 17: {
                aSTLiteral.initNameValue(any);
                return;
            }
            case 6: {
                aSTLiteral.initNameValue(new Double(any.extract_float()));
                return;
            }
            case 7: {
                aSTLiteral.initNameValue(new Double(any.extract_double()));
                return;
            }
            case 8: {
                aSTLiteral.initNameValue(new Boolean(any.extract_boolean()));
                return;
            }
            case 18: {
                aSTLiteral.initNameValue(any.extract_string());
                return;
            }
            case 27: {
                aSTLiteral.initNameValue(any.extract_wstring());
                return;
            }
        }
        throw new SemanticException("Invalid constant type: " + object, aSTScopedName);
    }

    void doPragmaPrefix(String string) {
        if (DEBUG) {
            System.out.println("Processing #pragma prefix \"" + string + "\"");
        }
        this.prefix(string);
    }

    void doPragmaID(String string, String string2) {
        if (DEBUG) {
            System.out.println("Processing #pragma ID \"" + string + "\" \"" + string2 + "\"");
        }
        try {
            Contained contained = this.container().lookup(string);
            if (contained == null) {
                throw new Exception();
            }
            contained.id(string2);
            return;
        }
        catch (Exception exception) {
            this.throwRuntimeParserException("Could not set repository id of \"" + string + "\" to \"" + string2 + "\"", null);
            return;
        }
    }

    void doPragmaVersion(String string, String string2) {
        if (DEBUG) {
            System.out.println("Processing #pragma prefix \"" + string + "\" \"" + string2 + "\"");
        }
        try {
            Contained contained = this.container().lookup(string);
            if (contained == null) {
                throw new Exception();
            }
            contained.version(string2);
            return;
        }
        catch (Exception exception) {
            this.throwRuntimeParserException("Could not set version of \"" + string + "\" to " + string2, null);
            return;
        }
    }

    void doHashExpression(String string) {
        try {
            if (DEBUG) {
                System.out.println("Pre-processor directive: #" + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("pragma")) {
                    String string3;
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals("prefix")) {
                        string4 = stringTokenizer.nextToken();
                        if (string4 == null) {
                            this.doPragmaPrefix("");
                        }
                        if (string4.charAt(0) != '\"' || string4.charAt(string4.length() - 1) != '\"') {
                            this.throwRuntimeParserException("Invalid prefix (must be delimited by double-quotes) [" + string4 + "]", null);
                        }
                        this.doPragmaPrefix(string4.substring(1, string4.length() - 1));
                        continue;
                    }
                    if (string5.equals("ID")) {
                        string4 = stringTokenizer.nextToken();
                        string3 = stringTokenizer.nextToken();
                        if (string3.charAt(0) != '\"' || string3.charAt(string3.length() - 1) != '\"') {
                            this.throwRuntimeParserException("Invalid repository id (must be delimited by double-quotes) [" + string3 + "]", null);
                        }
                        string3 = string3.substring(1, string3.length() - 1);
                        this.doPragmaID(string4, string3);
                        continue;
                    }
                    if (!string5.equals("version")) continue;
                    string4 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    this.doPragmaVersion(string4, string3);
                    continue;
                }
                if (_cppDirectives.get(string2) == null) continue;
                this.throwRuntimeParserException("Need to run a pre-processor on the input file containg: #" + string, null);
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.throwRuntimeParserException("Invalid pre-processor directive: #" + string, null);
            return;
        }
    }

    public void comment(boolean bl, String string) {
        if (DEBUG) {
            System.out.println("Adding " + (bl ? "C" : "C++") + " style comment: " + string);
        }
        if (bl && string.startsWith("*")) {
            this._currentComment = string;
        }
    }

    private void annotate(IRObject iRObject) {
        com.visigenic.vbroker.ir.IRObject iRObject2 = IRObjectHelper.narrow(iRObject);
        if (this._currentComment != null) {
            iRObject2.comment(this._currentComment);
            this._currentComment = null;
        }
        iRObject2.file_name(IDLParser.getFileName());
    }

    static {
        _cppDirectives.put("include", _cppDirectives);
        _cppDirectives.put("if", _cppDirectives);
        _cppDirectives.put("ifdef", _cppDirectives);
        _cppDirectives.put("ifndef", _cppDirectives);
        _cppDirectives.put("else", _cppDirectives);
        _cppDirectives.put("elif", _cppDirectives);
        _cppDirectives.put("endif", _cppDirectives);
        _cppDirectives.put("define", _cppDirectives);
        _cppDirectives.put("undef", _cppDirectives);
    }
}

