/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.gui;

import java.awt.TextArea;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ConsoleOutput
extends OutputStream {
    private TextArea _textArea;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream();
    private int _maxChars;

    public ConsoleOutput(TextArea textArea, int n) {
        this(textArea);
        this._maxChars = n;
    }

    public ConsoleOutput(TextArea textArea) {
        this._textArea = textArea;
    }

    public void write(int n) throws IOException {
        this._buffer.write(n);
        if (n == 10) {
            this.flush();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this._buffer.write(byArray);
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 10) {
                this.flush();
                return;
            }
            ++n;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this._buffer.write(byArray, n, n2);
        int n3 = n;
        while (n3 < n + n2) {
            if (byArray[n3] == 10) {
                this.flush();
                return;
            }
            ++n3;
        }
    }

    public void flush() throws IOException {
        String string = this._textArea.getText();
        int n = string.length();
        if (this._maxChars > 0 && n > this._maxChars) {
            this._textArea.setText(string.substring(this._maxChars / 2, n));
        }
        byte[] byArray = this._buffer.toByteArray();
        this._buffer.reset();
        this._textArea.insertText(new String(byArray, 0), n);
        int n2 = n + byArray.length;
        this._textArea.select(n2, n2);
    }
}

