/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.ipp;

import com.visigenic.vbroker.util.ipp.IppException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class CmdLineOptions {
    public boolean _filter_comments = true;
    public boolean _print_paths = false;
    public boolean _print_lineno = true;
    public boolean _debug = false;
    public Vector _incl_paths = new Vector();
    public String _source_file;
    public String _initial_text = "";
    public PrintStream _out = System.out;
    public PipedOutputStream _out_pipe;
    public String _out_name = "System.out";

    public String getOpt() {
        String string = "";
        string = String.valueOf(string) + "\n_filter_comments: " + this._filter_comments;
        string = String.valueOf(string) + "\n_print_paths: " + this._print_paths;
        string = String.valueOf(string) + "\n_print_lineno: " + this._print_lineno;
        string = String.valueOf(string) + "\n_debug: " + this._debug;
        string = String.valueOf(string) + "\n_incl_paths:\n" + this._incl_paths.toString();
        string = String.valueOf(string) + "\n_source_file: " + this._source_file;
        string = String.valueOf(string) + "\n_initial_text:\n" + this._initial_text;
        return string;
    }

    private void fail() throws IppException {
        throw new IppException("erroneous cmd-line syntax", null);
    }

    CmdLineOptions(String[] stringArray, PipedInputStream pipedInputStream, PrintStream printStream) throws IppException, IOException {
        String string = ".";
        String string2 = "";
        if (printStream != null) {
            this._out = printStream;
        }
        int n = 0;
        while (n < stringArray.length) {
            block30: {
                if (stringArray[n].charAt(0) == '-') {
                    int n2 = 1;
                    char c = stringArray[n].charAt(n2);
                    while (c == 'C' || c == 'H' || c == 'P' || c == 'd') {
                        switch (c) {
                            case 'C': {
                                this._filter_comments = false;
                                break;
                            }
                            case 'H': {
                                this._print_paths = true;
                                break;
                            }
                            case 'P': {
                                this._print_lineno = false;
                                break;
                            }
                            case 'd': {
                                this._debug = true;
                                break;
                            }
                        }
                        ++n2;
                        try {
                            c = stringArray[n].charAt(n2);
                        }
                        catch (Exception exception) {
                            break block30;
                        }
                    }
                    switch (c) {
                        case 'o': {
                            if (stringArray[n].length() < 3) {
                                this.fail();
                            }
                            this._out_name = stringArray[n].substring(2);
                            this._out = new PrintStream(new FileOutputStream(this._out_name));
                            break;
                        }
                        case 'I': {
                            if (stringArray[n].length() < 3) {
                                this.fail();
                            }
                            this._incl_paths.addElement(stringArray[n].substring(2));
                            break;
                        }
                        case 'D': {
                            if (stringArray[n].length() < 3) {
                                this.fail();
                            }
                            String string3 = null;
                            String string4 = null;
                            String string5 = stringArray[n].substring(2);
                            int n3 = string5.indexOf("=");
                            if (n3 < 0) {
                                string3 = string5;
                                string4 = "";
                            } else {
                                string3 = string5.substring(0, n3);
                                string4 = string5.substring(n3 + 1);
                            }
                            this._initial_text = String.valueOf(this._initial_text) + "#define " + string3 + " " + string4 + "\n";
                            break;
                        }
                        case 'U': {
                            if (stringArray[n].length() < 3) {
                                this.fail();
                            }
                            string2 = String.valueOf(string2) + "#undef " + stringArray[n].substring(2) + "\n";
                            break;
                        }
                        default: {
                            this.fail();
                            break;
                        }
                    }
                } else {
                    if (this._source_file != null) {
                        this.fail();
                    }
                    this._source_file = stringArray[n];
                    string = new File(this._source_file).getAbsolutePath();
                    string = string != null ? string.substring(0, string.lastIndexOf(File.separator)) : ".";
                    if (string != ".") {
                        this._incl_paths.insertElementAt(".", 0);
                    }
                    this._incl_paths.insertElementAt(string, 0);
                }
            }
            ++n;
        }
        if (this._source_file == null) {
            this.fail();
        }
        this._initial_text = String.valueOf(this._initial_text) + string2;
        this._initial_text = String.valueOf(this._initial_text) + "#include \"" + this._source_file + "\"\n";
        if (pipedInputStream != null) {
            if (this._out != System.out) {
                this._out.close();
            }
            this._out_name = "PipedOutputStream";
            this._out_pipe = new PipedOutputStream(pipedInputStream);
            this._out = new PrintStream(this._out_pipe);
        }
    }
}

