/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.DatabaseStatistics;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public final class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection connection_;
    private Statement systemTableQuery_ = null;
    private JDBCNet jdbcNet_;
    String userName_ = null;
    String databaseProductVersion_ = null;
    int ibMajorVersion_;
    int odsMajorVersion_;
    int odsMinorVersion_;
    int pageSize_;
    int pageAllocation_;
    int databaseSQLDialect_;
    boolean databaseReadOnly_;
    private static final int CATALOG_ALL_PROCEDURES_ARE_CALLABLE__ = 16;
    private static final int CATALOG_ALL_TABLES_ARE_SELECTABLE__ = 17;
    private static final int CATALOG_GET_PROCEDURES__ = 1;
    private static final int CATALOG_GET_PROCEDURE_COLUMNS__ = 2;
    private static final int CATALOG_GET_TABLES__ = 3;
    private static final int CATALOG_GET_TABLE_TYPES__ = 14;
    private static final int CATALOG_GET_COLUMNS__ = 4;
    private static final int CATALOG_GET_COLUMN_PRIVILEGES__ = 5;
    private static final int CATALOG_GET_TABLE_PRIVILEGES__ = 6;
    private static final int CATALOG_GET_BEST_ROW_IDENTIFIER__ = 7;
    private static final int CATALOG_GET_VERSION_COLUMNS__ = 8;
    private static final int CATALOG_GET_PRIMARY_KEYS__ = 9;
    private static final int CATALOG_GET_IMPORTED_KEYS__ = 10;
    private static final int CATALOG_GET_EXPORTED_KEYS__ = 11;
    private static final int CATALOG_GET_CROSS_REFERENCE__ = 12;
    private static final int CATALOG_GET_INDEX_INFO__ = 13;
    private static final int CATALOG_GET_TYPE_INFO__ = 15;
    private static final int REMARKS_PRECISION__ = 31;
    private static final int GET_PROCEDURES_RESULT_COLS__ = 9;
    private static final String[] GET_PROCEDURES_RESULT_COLUMN_NAMES__ = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "reserved", "reserved", "reserved", "REMARKS", "PROCEDURE_TYPE", "PROCEDURE_OWNER"};
    private static final boolean[] GET_PROCEDURES_RESULT_NULLABLES__ = new boolean[]{true, true, false, true, true, true, true, false, false};
    private static final int[] GET_PROCEDURES_RESULT_TYPES__ = new int[]{9, 9, 9, 0, 0, 0, 9, 1, 9};
    private static final int[] GET_PROCEDURES_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 0, 0, 0, 31, 5, 31};
    private static final int[] GET_PROCEDURES_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int procedureResultUnknown = 0;
    public static final int procedureNoResult = 1;
    public static final int procedureReturnsResult = 2;
    private static final int GET_PROCEDURE_COLUMNS_RESULT_COLS__ = 13;
    private static final String[] GET_PROCEDURE_COLUMNS_RESULT_COLUMN_NAMES__ = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
    private static final boolean[] GET_PROCEDURE_COLUMNS_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, true};
    private static final int[] GET_PROCEDURE_COLUMNS_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 1, 1, 9, 2, 2, 1, 1, 1, 9};
    private static final int[] GET_PROCEDURE_COLUMNS_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 5, 5, 16, 10, 10, 5, 5, 5, 31};
    private static final int[] GET_PROCEDURE_COLUMNS_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int procedureColumnUnknown = 0;
    public static final int procedureColumnIn = 1;
    public static final int procedureColumnInOut = 2;
    public static final int procedureColumnOut = 4;
    public static final int procedureColumnReturn = 5;
    public static final int procedureColumnResult = 3;
    public static final int procedureNoNulls = 0;
    public static final int procedureNullable = 1;
    public static final int procedureNullableUnknown = 2;
    private static final int GET_TABLES_RESULT_COLS__ = 6;
    private static final String[] GET_TABLES_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TABLE_OWNER"};
    private static final boolean[] GET_TABLES_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, true, false};
    private static final int[] GET_TABLES_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 9, 9};
    private static final int[] GET_TABLES_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 12, 31, 31};
    private static final int[] GET_TABLES_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0};
    private static final int GET_TABLE_TYPES_RESULT_COLS__ = 1;
    private static final String[] GET_TABLE_TYPES_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_TYPE"};
    private static final boolean[] GET_TABLE_TYPES_RESULT_NULLABLES__ = new boolean[]{false};
    private static final int[] GET_TABLE_TYPES_RESULT_TYPES__ = new int[]{9};
    private static final int[] GET_TABLE_TYPES_RESULT_PRECISIONS__ = new int[]{12};
    private static final int[] GET_TABLE_TYPES_RESULT_SCALES__ = new int[]{0};
    private static final int GET_COLUMNS_RESULT_COLS__ = 18;
    private static final String[] GET_COLUMNS_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final boolean[] GET_COLUMNS_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, true, true, true, true, false, false, false};
    private static final int[] GET_COLUMNS_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 1, 9, 2, 2, 2, 2, 2, 9, 9, 2, 2, 2, 2, 9};
    private static final int[] GET_COLUMNS_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 5, 16, 10, 10, 10, 10, 10, 31, 0, 10, 10, 10, 10, 3};
    private static final int[] GET_COLUMNS_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 1;
    public static final int columnNullableUnknown = 2;
    private static final int GET_COLUMN_PRIVILEGES_RESULT_COLS__ = 8;
    private static final String[] GET_COLUMN_PRIVILEGES_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final boolean[] GET_COLUMN_PRIVILEGES_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, true, false, false, true};
    private static final int[] GET_COLUMN_PRIVILEGES_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 9, 9, 9, 9};
    private static final int[] GET_COLUMN_PRIVILEGES_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 31, 31, 10, 3};
    private static final int[] GET_COLUMN_PRIVILEGES_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int GET_TABLE_PRIVILEGES_RESULT_COLS__ = 7;
    private static final String[] GET_TABLE_PRIVILEGES_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final boolean[] GET_TABLE_PRIVILEGES_RESULT_NULLABLES__ = new boolean[]{true, true, false, true, false, false, false};
    private static final int[] GET_TABLE_PRIVILEGES_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 9, 9, 9};
    private static final int[] GET_TABLE_PRIVILEGES_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 31, 10, 3};
    private static final int[] GET_TABLE_PRIVILEGES_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0};
    private static final int GET_BEST_ROW_IDENTIFIER_RESULT_COLS__ = 8;
    private static final String[] GET_BEST_ROW_IDENTIFIER_RESULT_COLUMN_NAMES__ = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
    private static final boolean[] GET_BEST_ROW_IDENTIFIER_RESULT_NULLABLES__ = new boolean[]{false, false, false, false, false, false, false, false};
    private static final int[] GET_BEST_ROW_IDENTIFIER_RESULT_TYPES__ = new int[]{1, 9, 1, 9, 2, 2, 1, 1};
    private static final int[] GET_BEST_ROW_IDENTIFIER_RESULT_PRECISIONS__ = new int[]{5, 31, 5, 16, 10, 10, 5, 5};
    private static final int[] GET_BEST_ROW_IDENTIFIER_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final int bestRowTemporary = 0;
    public static final int bestRowTransaction = 1;
    public static final int bestRowSession = 2;
    public static final int bestRowUnknown = 0;
    public static final int bestRowNotPseudo = 1;
    public static final int bestRowPseudo = 2;
    private static final int GET_VERSION_COLUMNS_RESULT_COLS__ = 8;
    private static final String[] GET_VERSION_COLUMNS_RESULT_COLUMN_NAMES__ = GET_BEST_ROW_IDENTIFIER_RESULT_COLUMN_NAMES__;
    private static final boolean[] GET_VERSION_COLUMNS_RESULT_NULLABLES__ = GET_BEST_ROW_IDENTIFIER_RESULT_NULLABLES__;
    private static final int[] GET_VERSION_COLUMNS_RESULT_TYPES__ = GET_BEST_ROW_IDENTIFIER_RESULT_TYPES__;
    private static final int[] GET_VERSION_COLUMNS_RESULT_PRECISIONS__ = GET_BEST_ROW_IDENTIFIER_RESULT_PRECISIONS__;
    private static final int[] GET_VERSION_COLUMNS_RESULT_SCALES__ = GET_BEST_ROW_IDENTIFIER_RESULT_SCALES__;
    public static final int versionColumnUnknown = 0;
    public static final int versionColumnNotPseudo = 1;
    public static final int versionColumnPseudo = 2;
    private static final int GET_PRIMARY_KEYS_RESULT_COLS__ = 6;
    private static final String[] GET_PRIMARY_KEYS_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
    private static final boolean[] GET_PRIMARY_KEYS_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, false, true};
    private static final int[] GET_PRIMARY_KEYS_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 1, 9};
    private static final int[] GET_PRIMARY_KEYS_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 5, 31};
    private static final int[] GET_PRIMARY_KEYS_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0};
    private static final int GET_IMPORTED_KEYS_RESULT_COLS__ = 14;
    private static final String[] GET_IMPORTED_KEYS_RESULT_COLUMN_NAMES__ = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    private static final boolean[] GET_IMPORTED_KEYS_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, true, true, false, false, false, false, false, true, true, false};
    private static final int[] GET_IMPORTED_KEYS_RESULT_TYPES__ = new int[]{9, 9, 9, 9, 9, 9, 9, 9, 1, 1, 1, 9, 9, 1};
    private static final int[] GET_IMPORTED_KEYS_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 31, 0, 0, 31, 31, 5, 5, 5, 31, 31, 5};
    private static final int[] GET_IMPORTED_KEYS_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int importedKeyCascade = 0;
    public static final int importedKeyRestrict = 1;
    public static final int importedKeySetNull = 2;
    public static final int importedKeyNoAction = 3;
    public static final int importedKeySetDefault = 4;
    public static final int importedKeyInitiallyDeferred = 5;
    public static final int importedKeyInitiallyImmediate = 6;
    public static final int importedKeyNotDeferrable = 7;
    private static final int GET_EXPORTED_KEYS_RESULT_COLS__ = 14;
    private static final String[] GET_EXPORTED_KEYS_RESULT_COLUMN_NAMES__ = GET_IMPORTED_KEYS_RESULT_COLUMN_NAMES__;
    private static final boolean[] GET_EXPORTED_KEYS_RESULT_NULLABLES__ = GET_IMPORTED_KEYS_RESULT_NULLABLES__;
    private static final int[] GET_EXPORTED_KEYS_RESULT_TYPES__ = GET_IMPORTED_KEYS_RESULT_TYPES__;
    private static final int[] GET_EXPORTED_KEYS_RESULT_PRECISIONS__ = GET_IMPORTED_KEYS_RESULT_PRECISIONS__;
    private static final int[] GET_EXPORTED_KEYS_RESULT_SCALES__ = GET_IMPORTED_KEYS_RESULT_SCALES__;
    private static final int GET_CROSS_REFERENCE_RESULT_COLS__ = 14;
    private static final String[] GET_CROSS_REFERENCE_RESULT_COLUMN_NAMES__ = GET_IMPORTED_KEYS_RESULT_COLUMN_NAMES__;
    private static final boolean[] GET_CROSS_REFERENCE_RESULT_NULLABLES__ = GET_IMPORTED_KEYS_RESULT_NULLABLES__;
    private static final int[] GET_CROSS_REFERENCE_RESULT_TYPES__ = GET_IMPORTED_KEYS_RESULT_TYPES__;
    private static final int[] GET_CROSS_REFERENCE_RESULT_PRECISIONS__ = GET_IMPORTED_KEYS_RESULT_PRECISIONS__;
    private static final int[] GET_CROSS_REFERENCE_RESULT_SCALES__ = GET_IMPORTED_KEYS_RESULT_SCALES__;
    private static final int GET_TYPE_INFO_RESULT_COLS__ = 18;
    private static final String[] GET_TYPE_INFO_RESULT_COLUMN_NAMES__ = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
    private static final boolean[] GET_TYPE_INFO_RESULT_NULLABLES__ = new boolean[]{false, false, false, true, true, true, false, false, false, false, false, false, true, false, false, true, true, false};
    private static final int[] GET_TYPE_INFO_RESULT_TYPES__ = new int[]{9, 1, 2, 9, 9, 9, 1, 1, 1, 1, 1, 1, 9, 1, 1, 2, 2, 2};
    private static final int[] GET_TYPE_INFO_RESULT_PRECISIONS__ = new int[]{16, 5, 10, 1, 1, 0, 5, 5, 5, 5, 5, 5, 16, 5, 5, 10, 10, 10};
    private static final int[] GET_TYPE_INFO_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int typeNoNulls = 0;
    public static final int typeNullable = 1;
    public static final int typeNullableUnknown = 2;
    public static final int typePredNone = 0;
    public static final int typePredChar = 1;
    public static final int typePredBasic = 2;
    public static final int typeSearchable = 3;
    private static final int GET_INDEX_INFO_RESULT_COLS__ = 13;
    private static final String[] GET_INDEX_INFO_RESULT_COLUMN_NAMES__ = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
    private static final boolean[] GET_INDEX_INFO_RESULT_NULLABLES__ = new boolean[]{true, true, false, false, true, false, false, false, false, true, true, false, true};
    private static final int[] GET_INDEX_INFO_RESULT_TYPES__ = new int[]{9, 9, 9, 1, 9, 9, 1, 1, 9, 9, 2, 2, 9};
    private static final int[] GET_INDEX_INFO_RESULT_PRECISIONS__ = new int[]{0, 0, 31, 5, 0, 31, 5, 5, 31, 1, 10, 10, 0};
    private static final int[] GET_INDEX_INFO_RESULT_SCALES__ = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final short tableIndexStatistic = 0;
    public static final short tableIndexClustered = 1;
    public static final short tableIndexHashed = 2;
    public static final short tableIndexOther = 3;

    DatabaseMetaData(Connection connection, JDBCNet jDBCNet) {
        this.connection_ = connection;
        this.jdbcNet_ = jDBCNet;
    }

    void checkForClosedConnection() throws SQLException {
        if (!this.connection_.open_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__connection_closed__);
        }
    }

    public synchronized boolean allProceduresAreCallable() throws SQLException {
        boolean bl;
        this.checkForClosedConnection();
        if (this.userName_.equals("SYSDBA")) {
            return true;
        }
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(16);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            bl = recvMessage.readBoolean();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
        return bl;
    }

    public synchronized boolean allTablesAreSelectable() throws SQLException {
        boolean bl;
        this.checkForClosedConnection();
        if (this.userName_.equals("SYSDBA")) {
            return true;
        }
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(17);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            bl = recvMessage.readBoolean();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
        return bl;
    }

    public String getURL() throws SQLException {
        this.checkForClosedConnection();
        return "jdbc:interbase://" + this.connection_.serverName_ + "/" + this.connection_.database_;
    }

    public String getUserName() throws SQLException {
        this.checkForClosedConnection();
        return this.userName_;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkForClosedConnection();
        return this.databaseReadOnly_;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        this.checkForClosedConnection();
        return Globals.getResource("96");
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.databaseProductVersion_;
    }

    public int getDatabaseSQLDialect() throws SQLException {
        this.checkForClosedConnection();
        return this.databaseSQLDialect_;
    }

    public String getDriverName() throws SQLException {
        this.checkForClosedConnection();
        return Globals.getResource("94");
    }

    public String getDriverVersion() throws SQLException {
        this.checkForClosedConnection();
        return "2.50.5 for JRE 1.3 and InterBase v6";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 50;
    }

    public boolean usesLocalFiles() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_ > 10 || this.databaseSQLDialect_ >= 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_ > 10 || this.databaseSQLDialect_ >= 3;
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.checkForClosedConnection();
        if (this.odsMajorVersion_ <= 10 && this.databaseSQLDialect_ < 3) {
            return " ";
        }
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        this.checkForClosedConnection();
        return "ACTIVE,AFTER,ASCENDING,BASE_NAME,BEFORE,BLOB,CACHE,CHECK_POINT_LENGTH,COMPUTED,CONDITIONAL,CONTAINING,CSTRING,DATABASE,RDB$DB_KEY,DEBUG,DESCENDING,DO,ENTRY_POINT,EXIT,FILE,FILTER,FUNCTION,GDSCODE,GENERATOR,GEN_ID,GROUP_COMMIT_WAIT_TIME,IF,INACTIVE,INPUT_TYPE,INDEX,LOGFILE,LOG_BUFFER_SIZE,MANUAL,MAXIMUM_SEGMENT,MERGE,MESSAGE,MODULE_NAME,NCHAR,NUM_LOG_BUFFERS,OUTPUT_TYPE,OVERFLOW,PAGE,PAGES,PAGE_SIZE,PARAMETER,PASSWORD,PLAN,POST_EVENT,PROTECTED,RAW_PARTITIONS,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,SEGMENT,SHADOW,SHARED,SINGULAR,SNAPSHOT,SORT,STABILITY,STARTS,STARTING,STATISTICS,SUB_TYPE,SUSPEND,TRIGGER,VARIABLE,RECORD_VERSION,WAIT,WHILE,WORK";
    }

    public String getNumericFunctions() throws SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getStringFunctions() throws SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        this.checkForClosedConnection();
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        this.checkForClosedConnection();
        return "$";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__schemas__);
    }

    public String getProcedureTerm() throws SQLException {
        this.checkForClosedConnection();
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__catalogs__);
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__catalogs__);
    }

    public String getCatalogSeparator() throws SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__binary_literals__);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        return 1024;
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.checkForClosedConnection();
        return 31;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.checkForClosedConnection();
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.checkForClosedConnection();
        return Short.MAX_VALUE;
    }

    public int getMaxConnections() throws SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.checkForClosedConnection();
        return 31;
    }

    public int getMaxIndexLength() throws SQLException {
        this.checkForClosedConnection();
        return 198;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__schemas__);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.checkForClosedConnection();
        return 27;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__catalogs__);
    }

    public int getMaxRowSize() throws SQLException {
        this.checkForClosedConnection();
        return 32664;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        this.checkForClosedConnection();
        return 640;
    }

    public int getMaxStatements() throws SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        this.checkForClosedConnection();
        return 31;
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        this.checkForClosedConnection();
        return 31;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.checkForClosedConnection();
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.checkForClosedConnection();
        switch (n) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
            case 0: 
            case 1: {
                return false;
            }
        }
        throw new InvalidArgumentException(ErrorKey.invalidArgument__isolation_0__, (Object)String.valueOf(n));
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    private void systemTableQueryPreamble(String string, String string2) throws SQLException {
        if (string != null && !string.equals("")) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__catalogs__);
        }
        if (string2 != null && !string2.equals("") && !string2.equals("%")) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__schemas__);
        }
        if (this.systemTableQuery_ == null) {
            this.systemTableQuery_ = this.connection_.createStatement();
        }
    }

    private java.sql.ResultSet remoteCatalogQuery(MessageBufferOutputStream messageBufferOutputStream, int n, String[] stringArray, boolean[] blArray, int[] nArray, int[] nArray2, int[] nArray3) throws SQLException {
        ResultSet resultSet = null;
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            int n2 = recvMessage.readInt();
            resultSet = new ResultSet(this.connection_, n2, recvMessage, this.jdbcNet_, n, stringArray, blArray, nArray, nArray2, nArray3);
            resultSet.numRows_ = recvMessage.readInt();
            resultSet.setNumDataPositions(n);
            resultSet.saveRowPosition();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                resultSet.local_Close();
            }
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw sQLException;
        }
        return resultSet;
    }

    public synchronized java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(1);
        if (string3 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        }
        return this.remoteCatalogQuery(messageBufferOutputStream, 9, GET_PROCEDURES_RESULT_COLUMN_NAMES__, GET_PROCEDURES_RESULT_NULLABLES__, GET_PROCEDURES_RESULT_TYPES__, GET_PROCEDURES_RESULT_PRECISIONS__, GET_PROCEDURES_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(2);
        if (string3 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        }
        if (string4 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string4));
        }
        return this.remoteCatalogQuery(messageBufferOutputStream, 13, GET_PROCEDURE_COLUMNS_RESULT_COLUMN_NAMES__, GET_PROCEDURE_COLUMNS_RESULT_NULLABLES__, GET_PROCEDURE_COLUMNS_RESULT_TYPES__, GET_PROCEDURE_COLUMNS_RESULT_PRECISIONS__, GET_PROCEDURE_COLUMNS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        boolean[] blArray = new boolean[3];
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(3);
        if (string3 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        }
        if (stringArray == null) {
            blArray[2] = true;
            blArray[1] = true;
            blArray[0] = true;
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if ("TABLE".equals(stringArray[n])) {
                    blArray[0] = true;
                } else if ("SYSTEM TABLE".equals(stringArray[n])) {
                    blArray[1] = true;
                } else if ("VIEW".equals(stringArray[n])) {
                    blArray[2] = true;
                }
                ++n;
            }
        }
        messageBufferOutputStream.writeBoolean(blArray[0]);
        messageBufferOutputStream.writeBoolean(blArray[1]);
        messageBufferOutputStream.writeBoolean(blArray[2]);
        return this.remoteCatalogQuery(messageBufferOutputStream, 6, GET_TABLES_RESULT_COLUMN_NAMES__, GET_TABLES_RESULT_NULLABLES__, GET_TABLES_RESULT_TYPES__, GET_TABLES_RESULT_PRECISIONS__, GET_TABLES_RESULT_SCALES__);
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__schemas__);
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        this.checkForClosedConnection();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__catalogs__);
    }

    public synchronized java.sql.ResultSet getTableTypes() throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(null, null);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(14);
        return this.remoteCatalogQuery(messageBufferOutputStream, 1, GET_TABLE_TYPES_RESULT_COLUMN_NAMES__, GET_TABLE_TYPES_RESULT_NULLABLES__, GET_TABLE_TYPES_RESULT_TYPES__, GET_TABLE_TYPES_RESULT_PRECISIONS__, GET_TABLE_TYPES_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(4);
        if (string3 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        }
        if (string4 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string4));
        }
        return this.remoteCatalogQuery(messageBufferOutputStream, 18, GET_COLUMNS_RESULT_COLUMN_NAMES__, GET_COLUMNS_RESULT_NULLABLES__, GET_COLUMNS_RESULT_TYPES__, GET_COLUMNS_RESULT_PRECISIONS__, GET_COLUMNS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(5);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        if (string4 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string4));
        }
        return this.remoteCatalogQuery(messageBufferOutputStream, 8, GET_COLUMN_PRIVILEGES_RESULT_COLUMN_NAMES__, GET_COLUMN_PRIVILEGES_RESULT_NULLABLES__, GET_COLUMN_PRIVILEGES_RESULT_TYPES__, GET_COLUMN_PRIVILEGES_RESULT_PRECISIONS__, GET_COLUMN_PRIVILEGES_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(6);
        if (string3 == null) {
            messageBufferOutputStream.writeLDSQLText("%");
        } else {
            messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        }
        return this.remoteCatalogQuery(messageBufferOutputStream, 7, GET_TABLE_PRIVILEGES_RESULT_COLUMN_NAMES__, GET_TABLE_PRIVILEGES_RESULT_NULLABLES__, GET_TABLE_PRIVILEGES_RESULT_TYPES__, GET_TABLE_PRIVILEGES_RESULT_PRECISIONS__, GET_TABLE_PRIVILEGES_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(7);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        messageBufferOutputStream.writeInt(n);
        messageBufferOutputStream.writeBoolean(bl);
        return this.remoteCatalogQuery(messageBufferOutputStream, 8, GET_BEST_ROW_IDENTIFIER_RESULT_COLUMN_NAMES__, GET_BEST_ROW_IDENTIFIER_RESULT_NULLABLES__, GET_BEST_ROW_IDENTIFIER_RESULT_TYPES__, GET_BEST_ROW_IDENTIFIER_RESULT_PRECISIONS__, GET_BEST_ROW_IDENTIFIER_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(8);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        return this.remoteCatalogQuery(messageBufferOutputStream, 8, GET_VERSION_COLUMNS_RESULT_COLUMN_NAMES__, GET_VERSION_COLUMNS_RESULT_NULLABLES__, GET_VERSION_COLUMNS_RESULT_TYPES__, GET_VERSION_COLUMNS_RESULT_PRECISIONS__, GET_VERSION_COLUMNS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(9);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        return this.remoteCatalogQuery(messageBufferOutputStream, 6, GET_PRIMARY_KEYS_RESULT_COLUMN_NAMES__, GET_PRIMARY_KEYS_RESULT_NULLABLES__, GET_PRIMARY_KEYS_RESULT_TYPES__, GET_PRIMARY_KEYS_RESULT_PRECISIONS__, GET_PRIMARY_KEYS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(10);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        return this.remoteCatalogQuery(messageBufferOutputStream, 14, GET_IMPORTED_KEYS_RESULT_COLUMN_NAMES__, GET_IMPORTED_KEYS_RESULT_NULLABLES__, GET_IMPORTED_KEYS_RESULT_TYPES__, GET_IMPORTED_KEYS_RESULT_PRECISIONS__, GET_IMPORTED_KEYS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(11);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        return this.remoteCatalogQuery(messageBufferOutputStream, 14, GET_EXPORTED_KEYS_RESULT_COLUMN_NAMES__, GET_EXPORTED_KEYS_RESULT_NULLABLES__, GET_EXPORTED_KEYS_RESULT_TYPES__, GET_EXPORTED_KEYS_RESULT_PRECISIONS__, GET_EXPORTED_KEYS_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        this.systemTableQueryPreamble(string4, string5);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(12);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string6));
        return this.remoteCatalogQuery(messageBufferOutputStream, 14, GET_CROSS_REFERENCE_RESULT_COLUMN_NAMES__, GET_CROSS_REFERENCE_RESULT_NULLABLES__, GET_CROSS_REFERENCE_RESULT_TYPES__, GET_CROSS_REFERENCE_RESULT_PRECISIONS__, GET_CROSS_REFERENCE_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getTypeInfo() throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(null, null);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(15);
        return this.remoteCatalogQuery(messageBufferOutputStream, 18, GET_TYPE_INFO_RESULT_COLUMN_NAMES__, GET_TYPE_INFO_RESULT_NULLABLES__, GET_TYPE_INFO_RESULT_TYPES__, GET_TYPE_INFO_RESULT_PRECISIONS__, GET_TYPE_INFO_RESULT_SCALES__);
    }

    public synchronized java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(40);
        messageBufferOutputStream.writeByte(13);
        messageBufferOutputStream.writeLDSQLText(this.systemTableValue(string3));
        messageBufferOutputStream.writeBoolean(bl);
        messageBufferOutputStream.writeBoolean(bl2);
        return this.remoteCatalogQuery(messageBufferOutputStream, 13, GET_INDEX_INFO_RESULT_COLUMN_NAMES__, GET_INDEX_INFO_RESULT_NULLABLES__, GET_INDEX_INFO_RESULT_TYPES__, GET_INDEX_INFO_RESULT_PRECISIONS__, GET_INDEX_INFO_RESULT_SCALES__);
    }

    public synchronized boolean supportsResultSetType(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean ownUpdatesAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean ownDeletesAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean ownInsertsAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean othersUpdatesAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean othersDeletesAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean othersInsertsAreVisible(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean updatesAreDetected(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean deletesAreDetected(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean insertsAreDetected(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean supportsBatchUpdates() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.connection_;
    }

    public String getInterServerVersion() {
        String string = String.valueOf(this.jdbcNet_.serverVersionInformation_.majorVersion_) + "." + String.valueOf(this.jdbcNet_.serverVersionInformation_.minorVersion_) + "." + String.valueOf(this.jdbcNet_.serverVersionInformation_.buildNumber_) + (this.jdbcNet_.serverVersionInformation_.buildLevel_ == 0 ? " Test Build" : (this.jdbcNet_.serverVersionInformation_.buildLevel_ == 1 ? " Beta" : ""));
        return string;
    }

    public int getInterServerMajorVersion() {
        return this.jdbcNet_.serverVersionInformation_.majorVersion_;
    }

    public int getInterServerMinorVersion() {
        return this.jdbcNet_.serverVersionInformation_.minorVersion_;
    }

    public int getInterServerJDBCNetProtocolVersion() {
        return this.jdbcNet_.serverVersionInformation_.jdbcNetProtocolVersion_;
    }

    public Date getInterServerExpirationDate() {
        return this.jdbcNet_.serverVersionInformation_.expirationDate_;
    }

    public int getInterServerPort() {
        return this.connection_.port_;
    }

    public int getDriverJDBCNetProtocolVersion() {
        return 25005;
    }

    public Date getDriverExpirationDate() {
        return Globals.interclientExpirationDate__;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.ibMajorVersion_;
    }

    public int getODSMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_;
    }

    public int getODSMinorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.odsMinorVersion_;
    }

    public synchronized int getActualCachePagesInUse() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getPersistentDatabaseCachePages() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public int getPageAllocation() throws SQLException {
        this.checkForClosedConnection();
        return this.pageAllocation_;
    }

    public int getPageSize() throws SQLException {
        this.checkForClosedConnection();
        return this.pageSize_;
    }

    public synchronized boolean getSweepInterval() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean isDatabaseReadWrite() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean reservingSpaceForVersioning() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean usingSynchronousWrites() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized DatabaseStatistics getStatistics() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String[] getUsersConnected() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String getUDFs() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    private String systemTableValue(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }
}

