/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeClauseParser;
import interbase.interclient.EscapeLexer;
import interbase.interclient.EscapeSyntaxException;
import java.sql.SQLException;
import java.util.NoSuchElementException;

final class EscapeFunctionParser
implements EscapeClauseParser {
    EscapeFunctionParser() {
    }

    private synchronized boolean matchStringToTokens(String string, String[] stringArray, boolean bl) throws SQLException {
        EscapeLexer escapeLexer = new EscapeLexer(string);
        if (!escapeLexer.hasMoreTokens()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 123);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            try {
                string2 = escapeLexer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
            if (string2.toUpperCase().compareTo(stringArray[n]) != 0) {
                return false;
            }
            ++n;
        }
        return !escapeLexer.hasMoreTokens() || !bl;
    }

    public synchronized String parse(String string) throws SQLException {
        String[] stringArray = new String[]{"FN", "USER", "(", ")"};
        String[] stringArray2 = new String[]{"FN", "NOW", "(", ")"};
        String[] stringArray3 = new String[]{"FN", "CURDATE", "(", ")"};
        String[] stringArray4 = new String[]{"FN", "UCASE", "("};
        if (this.matchStringToTokens(string, stringArray, true)) {
            return "USER";
        }
        if (this.matchStringToTokens(string, stringArray2, true)) {
            return "'NOW'";
        }
        if (this.matchStringToTokens(string, stringArray3, true)) {
            return "'TODAY'";
        }
        if (this.matchStringToTokens(string, stringArray4, false)) {
            int n = string.indexOf("(");
            if (n == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "UPPER " + string.substring(n);
        }
        int n = string.toUpperCase().indexOf("FN");
        if (n == -1) {
            throw new EscapeSyntaxException(ErrorKey.escapeSyntax__fn_0__, string);
        }
        return string.substring(n + 2);
    }
}

