/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.ExpiredDriverWarning;
import interbase.interclient.Globals;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.Utils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Map;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public final class ServerManager {
    private int sessionRef_ = 0;
    private SQLWarning sqlWarnings_ = null;
    private boolean open_ = true;
    private JDBCNet jdbcNet_;
    private String interserverHost_;
    private String interbaseHost_;
    private int port_;
    private String user_;
    private String role_;

    ServerManager(int n, String string, String string2, int n2, String string3, String string4, String string5) throws SQLException {
        this.interserverHost_ = string;
        this.interbaseHost_ = this.interbaseHost_;
        this.port_ = n2;
        this.user_ = string3;
        this.role_ = string5;
        this.connect(n, string4);
    }

    private void checkForClosedConnection() throws SQLException {
        if (!this.open_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__server_connection_closed__);
        }
    }

    private void connect(int n, String string) throws SQLException {
        try {
            this.jdbcNet_ = new JDBCNet(n, this.interserverHost_, this.port_, ByteToCharConverter.getConverter((String)"8859_1"), CharToByteConverter.getConverter((String)"8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, "8859_1");
        }
        Date date = new Date();
        if (this.jdbcNet_.serverVersionInformation_.expirationDate_ != null && date.after(this.jdbcNet_.serverVersionInformation_.expirationDate_)) {
            this.setWarning(new ExpiredDriverWarning(ErrorKey.expiredDriverWarning__01__, Globals.getResource("95"), this.jdbcNet_.serverVersionInformation_.expirationDate_));
        }
        try {
            this.remote_ATTACH_SERVER_MANAGER(string);
        }
        catch (SQLException sQLException) {
            try {
                this.jdbcNet_.disconnectSocket();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private void send_properties(MessageBufferOutputStream messageBufferOutputStream, String string, String string2) throws SQLException {
        messageBufferOutputStream.writeByte(2);
        messageBufferOutputStream.writeLDSQLText("user");
        byte[] byArray = this.jdbcNet_.crypter_.stringCrypt(string.toUpperCase());
        messageBufferOutputStream.writeLDBytes(byArray);
        messageBufferOutputStream.writeLDSQLText("password");
        byte[] byArray2 = this.jdbcNet_.crypter_.stringCrypt(string2);
        messageBufferOutputStream.writeLDBytes(byArray2);
    }

    private void remote_ATTACH_SERVER_MANAGER(String string) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(5);
        this.send_properties(messageBufferOutputStream, this.user_, string);
        messageBufferOutputStream.writeShort(this.jdbcNet_.socketTimeout_);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.sessionRef_ = recvMessage.readInt();
            this.setWarning(recvMessage.get_WARNINGS());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public int getInterServerMajorVersion() {
        return this.jdbcNet_.serverVersionInformation_.majorVersion_;
    }

    public int getInterServerMinorVersion() {
        return this.jdbcNet_.serverVersionInformation_.minorVersion_;
    }

    public int getInterServerBuildNumber() {
        return this.jdbcNet_.serverVersionInformation_.buildNumber_;
    }

    public int getInterServerBuildCertificationLevel() {
        return this.jdbcNet_.serverVersionInformation_.buildLevel_;
    }

    public int getInterServerJDBCNetProtocolVersion() {
        return this.jdbcNet_.serverVersionInformation_.jdbcNetProtocolVersion_;
    }

    public Date getInterServerExpirationDate() {
        return this.jdbcNet_.serverVersionInformation_.expirationDate_;
    }

    public int getInterServerPort() {
        return this.port_;
    }

    public synchronized String getInterBaseVersion() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String[] getDatabasesInUse() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getNumberOfInterBaseConnectionsInUse() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String[][] getInterBaseLicenses() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized Map getRegisteredUsers() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized InputStream getLockActivityStream(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void startInterBase(int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void stopInterBase() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void addInterBaseLicense(String string, String string2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void deleteInterBaseLicense(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void addUser(String string, String string2, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void deleteUser(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void modifyUser(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void modifyUser(String string, String string2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void reserveSpaceForVersioning(String string, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void setDatabaseCachePages(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void setDatabaseReadWrite(String string, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void setSweepInterval(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void useSynchronousWrites(String string, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void takeOffline(String string, boolean bl, boolean bl2, boolean bl3, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void bringOnline(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String backup(String string, String[] stringArray, int[] nArray, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String backup(String string, String string2, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String restore(String string, String[] stringArray, int[] nArray, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String restore(String string, String string2, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String sweep(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String verify(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String repair(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void createShadow(String string, String[] stringArray, int[] nArray, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void createShadow(String string, String string2, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void activateShadow(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void deleteShadow(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void createDatabase(String string, Map map) throws SQLException {
        this.checkForClosedConnection();
        this.remote_CREATE_DATABASE(string);
    }

    private void remote_CREATE_DATABASE(String string) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(100);
        messageBufferOutputStream.writeByte(101);
        messageBufferOutputStream.writeLDSQLText(string);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public synchronized void deleteDatabase(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized Object[] getLimboTransactions(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void rollbackTransactions(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void commitTransactions(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void twoPhaseCommitTransactions(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String getStatisticsText(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarnings_;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    synchronized void setWarning(SQLWarning sQLWarning) {
        if (this.sqlWarnings_ == null) {
            this.sqlWarnings_ = sQLWarning;
        } else {
            this.sqlWarnings_.setNextException(sQLWarning);
        }
    }

    protected void finalize() throws Throwable {
        if (this.open_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized void close() throws SQLException {
        if (!this.open_) {
            return;
        }
        SQLException sQLException = null;
        try {
            this.remote_DETACH_SERVER_MANAGER();
        }
        catch (SQLException sQLException2) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException2);
        }
        this.open_ = false;
        try {
            this.jdbcNet_.disconnectSocket();
        }
        catch (SQLException sQLException3) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private void remote_DETACH_SERVER_MANAGER() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(6);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }
}

