/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BlobIOException;
import interbase.interclient.BlobInputStream;
import interbase.interclient.BugCheckException;
import interbase.interclient.ByteToUnicodeConverterStream;
import interbase.interclient.CharacterEncodingException;
import interbase.interclient.CommunicationException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.Statement;
import interbase.interclient.Utils;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import sun.io.ByteToCharConverter;

class BlobOutput {
    BlobInputStream blobInputStream_ = null;
    InputStreamReader reader_ = null;
    private JDBCNet jdbcNet_;
    private int[] blobId_;
    private Statement statement_;
    int actualSegmentSize_;
    boolean lastSegment_ = false;
    int blobSize_;
    int blobRef_;
    ByteToCharConverter btc_;
    String encoding_;

    BlobOutput(JDBCNet jDBCNet, Statement statement, int[] nArray, ByteToCharConverter byteToCharConverter) throws SQLException {
        this.jdbcNet_ = jDBCNet;
        this.statement_ = statement;
        this.blobId_ = nArray;
        this.btc_ = byteToCharConverter;
        this.encoding_ = this.btc_.getCharacterEncoding();
        this.remote_OPEN_BLOB();
        this.blobInputStream_ = new BlobInputStream(this, this.jdbcNet_.inputStream_);
        try {
            this.reader_ = new InputStreamReader((InputStream)this.blobInputStream_, this.encoding_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 129);
        }
    }

    void close() throws SQLException {
        try {
            this.blobInputStream_.close();
        }
        catch (BlobIOException blobIOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_blob_close_01__, this.jdbcNet_.server_, Utils.getMessage(blobIOException));
        }
    }

    void remote_sendPrefetch() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.write(34);
        messageBufferOutputStream.writeInt(this.blobRef_);
        this.jdbcNet_.sendPrefetchBlobMessage(messageBufferOutputStream);
    }

    void remote_recvPrefetch() throws SQLException {
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.receivePrefetchBlobMessage();
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.lastSegment_ = recvMessage.getHeaderEndOfStream();
            this.actualSegmentSize_ = recvMessage.getHeaderReserved();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    void remote_OPEN_BLOB() throws SQLException {
        RecvMessage recvMessage = null;
        try {
            MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
            messageBufferOutputStream.write(32);
            messageBufferOutputStream.writeInt(this.statement_.statementRef_);
            messageBufferOutputStream.writeBlobId(this.blobId_);
            recvMessage = this.jdbcNet_.sendAndReceiveBlobMessage(messageBufferOutputStream, this);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.lastSegment_ = recvMessage.getHeaderEndOfStream();
            this.actualSegmentSize_ = recvMessage.getHeaderReserved();
            this.blobRef_ = recvMessage.readInt();
            this.blobSize_ = recvMessage.readInt();
            if (!this.lastSegment_) {
                this.remote_sendPrefetch();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    void remote_GET_BLOB_SEGMENT() throws SQLException {
        this.remote_recvPrefetch();
        if (!this.lastSegment_) {
            this.remote_sendPrefetch();
        }
    }

    void remote_CLOSE_BLOB() throws SQLException {
        RecvMessage recvMessage = null;
        try {
            MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
            messageBufferOutputStream.write(36);
            messageBufferOutputStream.writeInt(this.blobRef_);
            recvMessage = this.jdbcNet_.sendAndReceiveBlobMessage(messageBufferOutputStream, this);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    InputStream getInputStream() {
        return this.blobInputStream_;
    }

    InputStream getUnicodeInputStream() {
        return new ByteToUnicodeConverterStream(this.blobInputStream_, this.reader_);
    }

    byte[] getBytes() throws SQLException {
        byte[] byArray = new byte[this.blobSize_];
        this.getBytes(byArray, 0, this.blobSize_);
        return byArray;
    }

    private void getBytes(byte[] byArray, int n, int n2) throws SQLException {
        try {
            int n3 = 0;
            while (n3 < n2) {
                n3 += this.blobInputStream_.read(byArray, n + n3, n2 - n3);
            }
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_blob_read_01__, this.jdbcNet_.server_, Utils.getMessage(iOException));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 130);
        }
    }

    String getString() throws SQLException {
        char[] cArray = Globals.cache__.takeCharBuffer(this.blobSize_);
        byte[] byArray = Globals.cache__.takeBuffer(this.blobSize_);
        try {
            this.getBytes(byArray, 0, this.blobSize_);
            try {
                int n = this.btc_.convert(byArray, 0, this.blobSize_, cArray, 0, this.blobSize_);
                int n2 = this.statement_.maxFieldSize_ == 0 ? n : Math.min(n, this.statement_.maxFieldSize_);
                String string = new String(cArray, 0, n2);
                Object var7_7 = null;
                Globals.cache__.returnCharBuffer(cArray);
                Globals.cache__.returnBuffer(byArray);
                return string;
            }
            catch (CharConversionException charConversionException) {
                throw new CharacterEncodingException(ErrorKey.characterEncoding__read_0__, Utils.getMessage(charConversionException));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Globals.cache__.returnCharBuffer(cArray);
            Globals.cache__.returnBuffer(byArray);
            throw throwable;
        }
    }
}

