/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.ServerManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DataSource
implements javax.sql.DataSource,
Referenceable,
Serializable {
    private int loginTimeout = 0;
    private PrintWriter logWriter_ = null;
    private String databaseName = null;
    private String dataSourceName = null;
    private String description = null;
    private String networkProtocol = null;
    private String password = null;
    private int portNumber = 3060;
    private String roleName = null;
    private String serverName = null;
    private String user = null;
    private int sqlDialect = 0;
    private String charSet = "NONE";
    private String interBaseLicense = null;
    private String serverManagerHost = null;
    private int suggestedCachePages = 0;
    private boolean sweepOnConnect = false;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public synchronized void setNetworkProtocol(String string) {
        this.networkProtocol = string;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public synchronized void setRoleName(String string) {
        this.roleName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public synchronized void setCharSet(String string) {
        this.charSet = string;
    }

    public String getInterBaseLicense() {
        return this.interBaseLicense;
    }

    public synchronized void setInterBaseLicense(String string) {
        this.interBaseLicense = string;
    }

    public String getServerManagerHost() {
        return this.serverManagerHost;
    }

    public synchronized void setServerManagerHost(String string) {
        this.serverManagerHost = string;
    }

    public int getSuggestedCachePages() {
        return this.suggestedCachePages;
    }

    public synchronized void setSuggestedCachePages(int n) {
        this.suggestedCachePages = n;
    }

    public boolean getSweepOnConnect() {
        return this.sweepOnConnect;
    }

    public synchronized void setSweepOnConnect(boolean bl) {
        this.sweepOnConnect = bl;
    }

    public int getSQLDialect() {
        return this.sqlDialect;
    }

    public synchronized void setSQLDialect(int n) {
        this.sqlDialect = n;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public java.sql.Connection getConnection(String string, String string2) throws SQLException {
        if (this.networkProtocol != null && !this.networkProtocol.equals("jdbc:interbase:")) {
            throw new SQLException("invalid network protocol");
        }
        Properties properties = new Properties();
        if (string != null) {
            ((Hashtable)properties).put("user", string);
        }
        if (string2 != null) {
            ((Hashtable)properties).put("password", string2);
        }
        if (this.roleName != null) {
            ((Hashtable)properties).put("roleName", this.roleName);
        }
        if (this.charSet != null) {
            ((Hashtable)properties).put("charSet", this.charSet);
        }
        if (this.interBaseLicense != null) {
            ((Hashtable)properties).put("interBaseLicense", this.interBaseLicense);
        }
        if (this.sweepOnConnect) {
            ((Hashtable)properties).put("sweepOnConnect", String.valueOf(this.sweepOnConnect));
        }
        if (this.suggestedCachePages != 0) {
            ((Hashtable)properties).put("suggestedCachePages", String.valueOf(this.suggestedCachePages));
        }
        return new Connection(this.loginTimeout * 1000, this.serverName, this.portNumber, this.databaseName, properties);
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter_ = printWriter;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter_;
    }

    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "interbase.interclient.ObjectFactory", null);
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("portNumber", String.valueOf(this.getPortNumber())));
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("roleName", this.getRoleName()));
        reference.add(new StringRefAddr("charSet", this.getCharSet()));
        reference.add(new StringRefAddr("interBaseLicense", this.getInterBaseLicense()));
        reference.add(new StringRefAddr("sweepOnConnect", String.valueOf(this.getSweepOnConnect())));
        reference.add(new StringRefAddr("suggestedCachePages", String.valueOf(this.getSuggestedCachePages())));
        reference.add(new StringRefAddr("serverManagerHost", String.valueOf(this.getServerManagerHost())));
        return reference;
    }

    synchronized void log(Object object) {
        if (this.logWriter_ != null) {
            this.logWriter_.print(object);
        }
    }

    synchronized void logln(Object object) {
        if (this.logWriter_ != null) {
            this.logWriter_.println(object);
        }
    }

    public ServerManager getServerManager() throws SQLException {
        return this.getServerManager(this.user, this.password);
    }

    public ServerManager getServerManager(String string, String string2) throws SQLException {
        ServerManager serverManager = new ServerManager(this.loginTimeout * 1000, this.serverName, this.serverManagerHost, this.portNumber, string, string2, this.roleName);
        return serverManager;
    }
}

