/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.CharacterEncodingException;
import interbase.interclient.CommunicationException;
import interbase.interclient.CorruptDatabaseException;
import interbase.interclient.DeadlockException;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.LockConflictException;
import interbase.interclient.OutOfMemoryException;
import interbase.interclient.RemoteProtocolException;
import interbase.interclient.SQLDialectException;
import interbase.interclient.SQLException;
import interbase.interclient.UnauthorizedUserException;
import interbase.interclient.UnavailableDatabaseFileException;
import interbase.interclient.UnavailableInterBaseServerException;
import interbase.interclient.UnlicensedComponentException;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.UpdateConflictException;
import interbase.interclient.Utils;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLWarning;
import sun.io.ByteToCharConverter;

final class RecvMessage {
    private boolean buffered_;
    private byte[] buf_;
    private int pos_;
    private int oldPos_;
    private int count_;
    private int messageLength_;
    private InputStream in_;
    private boolean byteswap_;
    private int mark_;
    boolean headerEndOfStream_;
    int headerReserved_;
    ByteToCharConverter btc_;
    String encoding_;

    RecvMessage(int n, InputStream inputStream, boolean bl, int n2, int n3, ByteToCharConverter byteToCharConverter) {
        this.messageLength_ = n;
        this.in_ = inputStream;
        this.byteswap_ = bl;
        this.headerEndOfStream_ = n2 != 0;
        this.headerReserved_ = n3;
        this.btc_ = byteToCharConverter;
        this.encoding_ = byteToCharConverter.getCharacterEncoding();
        this.buffered_ = false;
        this.oldPos_ = 0;
        this.pos_ = 0;
        this.count_ = n;
    }

    int getPosition() {
        return this.pos_;
    }

    void setPosition(int n) {
        this.pos_ = n;
    }

    void mark() {
        this.mark_ = this.pos_;
    }

    void reset() {
        this.pos_ = this.mark_;
    }

    synchronized void bufferOut() throws java.sql.SQLException {
        try {
            if (!this.buffered_) {
                int n = this.messageLength_ - this.pos_;
                this.buf_ = Globals.cache__.takeBuffer(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.in_.read(this.buf_, n2, n - n2);
                    n2 += n3;
                }
                this.oldPos_ = this.pos_;
                this.pos_ = 0;
                this.count_ = n;
                this.buffered_ = true;
                this.in_ = null;
            }
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    void destroy() throws java.sql.SQLException {
        if (this.buffered_) {
            Globals.cache__.returnBuffer(this.buf_);
            this.buf_ = null;
        } else {
            int n = this.count_ - this.pos_;
            this.skip(n);
            this.in_ = null;
        }
    }

    boolean getHeaderEndOfStream() {
        return this.headerEndOfStream_;
    }

    int getHeaderReserved() {
        return this.headerReserved_;
    }

    private void align(int n) throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 101);
        }
        int n2 = (this.pos_ + this.oldPos_) % n;
        if (n2 != 0) {
            this.skip(n - n2);
        }
    }

    private void skip(int n) throws java.sql.SQLException {
        this.pos_ += n;
        if (!this.buffered_) {
            try {
                int n2 = 0;
                while (n2 < n) {
                    n2 = (int)((long)n2 + this.in_.skip(n - n2));
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    boolean readBoolean() throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 102);
        }
        if (this.buffered_) {
            return this.buf_[this.pos_++] != 0;
        }
        try {
            ++this.pos_;
            return this.in_.read() != 0;
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    byte readByte() throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 103);
        }
        if (this.buffered_) {
            return this.buf_[this.pos_++];
        }
        try {
            ++this.pos_;
            return (byte)this.in_.read();
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    int readUnsignedByte() throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 104);
        }
        if (this.buffered_) {
            return this.buf_[this.pos_++] & 0xFF;
        }
        try {
            ++this.pos_;
            return this.in_.read();
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    short readShort() throws java.sql.SQLException {
        try {
            int n;
            int n2;
            this.align(2);
            if (this.buffered_) {
                n2 = this.buf_[this.pos_++] & 0xFF;
                n = this.buf_[this.pos_++] & 0xFF;
            } else {
                this.pos_ += 2;
                n2 = this.in_.read();
                n = this.in_.read();
            }
            if (this.byteswap_) {
                return (short)((n2 << 0) + (n << 8));
            }
            return (short)((n2 << 8) + (n << 0));
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    int readUnsignedShort() throws java.sql.SQLException {
        try {
            int n;
            int n2;
            this.align(2);
            if (this.buffered_) {
                n2 = this.buf_[this.pos_++] & 0xFF;
                n = this.buf_[this.pos_++] & 0xFF;
            } else {
                this.pos_ += 2;
                n2 = this.in_.read();
                n = this.in_.read();
            }
            if (this.byteswap_) {
                return (n2 << 0) + (n << 8);
            }
            return (n2 << 8) + (n << 0);
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    int readInt() throws java.sql.SQLException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            this.align(4);
            if (this.buffered_) {
                n4 = this.buf_[this.pos_++] & 0xFF;
                n3 = this.buf_[this.pos_++] & 0xFF;
                n2 = this.buf_[this.pos_++] & 0xFF;
                n = this.buf_[this.pos_++] & 0xFF;
            } else {
                this.pos_ += 4;
                n4 = this.in_.read();
                n3 = this.in_.read();
                n2 = this.in_.read();
                n = this.in_.read();
            }
            if (this.byteswap_) {
                return (n4 << 0) + (n3 << 8) + (n2 << 16) + (n << 24);
            }
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    long readLong() throws java.sql.SQLException {
        this.align(8);
        if (this.byteswap_) {
            return ((long)this.readInt() & 0xFFFFFFFFL) + ((long)this.readInt() << 32);
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    float readFloat() throws java.sql.SQLException {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() throws java.sql.SQLException {
        return Double.longBitsToDouble(this.readLong());
    }

    byte[] readLDBytes(int n) throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 105);
        }
        int n2 = this.readUnsignedShort();
        int n3 = n == 0 ? n2 : Math.min(n2, n);
        byte[] byArray = new byte[n3];
        if (this.buffered_) {
            System.arraycopy(this.buf_, this.pos_, byArray, 0, n3);
            this.pos_ += n2;
            return byArray;
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 106);
    }

    int readLDChars(char[] cArray, int n) throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 107);
        }
        try {
            int n2 = this.readUnsignedShort();
            if (this.buffered_) {
                int n3 = this.btc_.convert(this.buf_, this.pos_, this.pos_ + n2, cArray, 0, n);
                this.pos_ += n2;
                return n3;
            }
            throw new BugCheckException(ErrorKey.bugCheck__0__, 108);
        }
        catch (CharConversionException charConversionException) {
            throw new CharacterEncodingException(ErrorKey.characterEncoding__read_0__, Utils.getMessage(charConversionException));
        }
    }

    String readLDString(String string) throws java.sql.SQLException {
        try {
            int n = this.readUnsignedShort();
            if (this.buffered_) {
                String string2 = new String(this.buf_, this.pos_, n, string);
                this.pos_ += n;
                return string2;
            }
            throw new BugCheckException(ErrorKey.bugCheck__0__, 109);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, string);
        }
    }

    String readLDString() throws java.sql.SQLException {
        return this.readLDString(this.encoding_);
    }

    String readLDSQLText() throws java.sql.SQLException {
        return this.readLDString("8859_1");
    }

    int[] readTimestampId() throws java.sql.SQLException {
        int[] nArray = new int[]{this.readInt(), this.readInt()};
        return nArray;
    }

    int[] readBlobId() throws java.sql.SQLException {
        int[] nArray = new int[]{this.readInt(), this.readInt()};
        return nArray;
    }

    int[] readArrayId() throws java.sql.SQLException {
        int[] nArray = new int[]{this.readInt(), this.readInt()};
        return nArray;
    }

    void skipShort() throws java.sql.SQLException {
        this.align(2);
        this.skip(2);
    }

    void skipInt() throws java.sql.SQLException {
        this.align(4);
        this.skip(4);
    }

    void skipFloat() throws java.sql.SQLException {
        this.align(4);
        this.skip(4);
    }

    void skipDouble() throws java.sql.SQLException {
        this.align(8);
        this.skip(8);
    }

    void skipBlobId() throws java.sql.SQLException {
        this.align(4);
        this.skip(8);
    }

    void skipTimestampId() throws java.sql.SQLException {
        this.align(4);
        this.skip(8);
    }

    void skipLDBytes() throws java.sql.SQLException {
        if (this.pos_ >= this.count_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 110);
        }
        this.skip(this.readUnsignedShort());
    }

    void skipLong() throws java.sql.SQLException {
        this.align(8);
        this.skip(8);
    }

    boolean get_SUCCESS() throws java.sql.SQLException {
        switch (this.readUnsignedByte()) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 100);
    }

    SQLWarning get_WARNINGS() throws java.sql.SQLException {
        int n;
        SQLWarning sQLWarning = null;
        while ((n = this.readUnsignedByte()) == 1) {
            sQLWarning = (SQLWarning)Utils.accumulateSQLExceptions(sQLWarning, this.makeSQLWarning());
        }
        if (n != 2) {
            throw new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 101);
        }
        return sQLWarning;
    }

    java.sql.SQLException get_EXCEPTIONS() throws java.sql.SQLException {
        int n;
        java.sql.SQLException sQLException = null;
        while ((n = this.readUnsignedByte()) == 1) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, this.makeSQLException());
        }
        if (n != 2) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 102));
        }
        return sQLException;
    }

    SQLWarning makeSQLWarning() throws java.sql.SQLException {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        String string = this.readLDString();
        return this.createSQLWarning(n, n2, n3, n4, string);
    }

    java.sql.SQLException makeSQLException() throws java.sql.SQLException {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        String string = this.readLDString();
        return this.createSQLException(n, n2, n3, n4, string);
    }

    boolean get_ROW_DATUM() throws java.sql.SQLException {
        switch (this.readUnsignedByte()) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 103);
    }

    SQLException createSQLException(int n, int n2, int n3, int n4, String string) {
        switch (n3) {
            case 335544389: 
            case 335544430: {
                return new OutOfMemoryException(n, n3, n4, string);
            }
            case 335544333: {
                return new BugCheckException(n, n3, n4, string);
            }
            case 335544452: {
                return new UnlicensedComponentException(n, n3, n4, string);
            }
            case 335544344: {
                return new UnavailableDatabaseFileException(n, n3, n4, string);
            }
            case 335544375: {
                return new UnavailableInterBaseServerException(n, n3, n4, string);
            }
            case 335544345: {
                return new LockConflictException(n, n3, n4, string);
            }
            case 335544451: {
                return new UpdateConflictException(n, n3, n4, string);
            }
            case 0x14000010: {
                return new DeadlockException(n, n3, n4, string);
            }
            case 335544335: 
            case 335544405: 
            case 335544649: {
                return new CorruptDatabaseException(n, n3, n4, string);
            }
            case 335544472: {
                return new UnauthorizedUserException(n, n3, n4, string);
            }
            case 11: {
                return new OutOfMemoryException(n);
            }
            case 9: {
                return new BugCheckException(n, n2);
            }
            case 8: {
                return new UnlicensedComponentException(n);
            }
            case 10: {
                return new RemoteProtocolException(n);
            }
            case 7: {
                return new DriverNotCapableException(n);
            }
            case 2: {
                return new InvalidOperationException(n);
            }
            case 129: {
                return new InvalidArgumentException(n);
            }
            case 1: {
                return new CommunicationException(n);
            }
            case 128: {
                return new UnsupportedCharacterSetException(n, n2);
            }
            case 130: {
                return new SQLDialectException(n, n2);
            }
        }
        return new SQLException(n, n3, n4, string);
    }

    SQLWarning createSQLWarning(int n, int n2, int n3, int n4, String string) {
        SQLException sQLException = this.createSQLException(n, n2, n3, n4, string);
        return new SQLWarning(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
    }
}

