/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import com.inprise.sql.SQLAdapter;
import interbase.interclient.Adaptor;
import interbase.interclient.Array;
import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BugCheckException;
import interbase.interclient.ByteToUnicodeConverterStream;
import interbase.interclient.ColumnConversionException;
import interbase.interclient.ColumnIndexOutOfBoundsException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.IBTimestamp;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.ResultSetMetaData;
import interbase.interclient.Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public final class ResultSet
implements java.sql.ResultSet,
Adaptor,
borland.jdbc.SQLAdapter,
SQLAdapter {
    int numRows_;
    private RecvMessage recvMsg_;
    private int[] columnDataPositions_;
    JDBCNet jdbcNet_;
    private ResultSetMetaData resultSetMetaData_;
    Statement statement_;
    Hashtable columnNameToIndexCache_ = null;
    private SQLWarning sqlWarnings_;
    private boolean[] isNull_;
    private static final int WAS_NULL__ = 1;
    private static final int WAS_NOT_NULL__ = 2;
    private static final int WAS_NULL_UNSET__ = 0;
    private int wasNull_ = 0;
    int resultCols_;
    String[] resultTableNames_;
    String[] resultColumnNames_;
    String[] resultColumnLabels_;
    boolean[] resultNullables_;
    int[] resultTypes_;
    int[] resultPrecisions_;
    int[] resultScales_;
    int[] resultCharSets_;
    int[] resultCharLengths_;
    ArrayDescriptor[] arrayDescriptors_;
    char[] cbuf_;
    private int rowsRead_;
    private boolean openOnClient_ = true;
    boolean openOnServer_;
    String cursorName_ = null;
    boolean validCursorPosition_ = false;
    boolean adaptToRightTrimString_ = false;
    boolean adaptToSingleInstanceTime_ = false;
    IBTimestamp adaptableIBTimestamp_ = null;
    Date adaptableDate_ = null;
    Time adaptableTime_ = null;
    Timestamp adaptableTimestamp_ = null;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    ResultSet(Statement statement, JDBCNet jDBCNet, RecvMessage recvMessage, int n, boolean bl) {
        this.resultCols_ = n;
        this.isNull_ = new boolean[this.resultCols_];
        this.resultTableNames_ = new String[this.resultCols_];
        this.resultColumnNames_ = new String[this.resultCols_];
        this.resultColumnLabels_ = new String[this.resultCols_];
        this.resultNullables_ = new boolean[this.resultCols_];
        this.resultTypes_ = new int[this.resultCols_];
        this.resultPrecisions_ = new int[this.resultCols_];
        this.resultScales_ = new int[this.resultCols_];
        this.resultCharSets_ = new int[this.resultCols_];
        this.resultCharLengths_ = new int[this.resultCols_];
        this.arrayDescriptors_ = new ArrayDescriptor[this.resultCols_];
        this.statement_ = statement;
        this.jdbcNet_ = jDBCNet;
        this.recvMsg_ = recvMessage;
        this.rowsRead_ = 0;
        this.openOnServer_ = bl;
    }

    ResultSet(Connection connection, int n, RecvMessage recvMessage, JDBCNet jDBCNet, int n2, String[] stringArray, boolean[] blArray, int[] nArray, int[] nArray2, int[] nArray3) {
        this.statement_ = new Statement(jDBCNet, connection);
        this.statement_.statementRef_ = n;
        this.recvMsg_ = recvMessage;
        this.resultCols_ = n2;
        this.resultTableNames_ = new String[this.resultCols_];
        this.resultColumnNames_ = stringArray;
        this.resultNullables_ = blArray;
        this.resultTypes_ = nArray;
        this.resultPrecisions_ = nArray2;
        this.resultScales_ = nArray3;
        this.resultCharSets_ = new int[n2];
        this.resultCharLengths_ = nArray2;
        int n3 = 0;
        while (n3 < n2) {
            this.resultCharSets_[n3] = 0;
            ++n3;
        }
        this.allocateCbuf();
        this.isNull_ = new boolean[this.resultCols_];
        this.jdbcNet_ = jDBCNet;
        this.rowsRead_ = 0;
        this.openOnServer_ = true;
        this.resultColumnLabels_ = this.resultColumnNames_;
        this.resultSetMetaData_ = new ResultSetMetaData(this, this.jdbcNet_);
        this.resultSetMetaData_.writables_ = new boolean[this.resultCols_];
        this.resultSetMetaData_.metaDataRetrieved_ = true;
    }

    synchronized void allocateCbuf() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.resultCols_) {
            if (this.resultCharLengths_[n2] > n) {
                n = this.resultCharLengths_[n2];
            }
            ++n2;
        }
        this.cbuf_ = Globals.cache__.takeCharBuffer(n);
    }

    protected void finalize() throws Throwable {
        if (this.openOnServer_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized boolean next() throws SQLException {
        this.checkForClosedCursor();
        this.clearWarnings();
        this.validCursorPosition_ = this.getNextCursorPosition();
        return this.validCursorPosition_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getNextCursorPosition() throws SQLException {
        if (this.recvMsg_ == null) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__read_at_end_of_cursor__);
        }
        if (this.statement_.maxRows_ > 0 && this.rowsRead_ >= this.statement_.maxRows_) {
            return false;
        }
        try {
            this.restoreRowPosition();
            while (true) {
                Object var3_1;
                block8: {
                    boolean bl;
                    if (this.recvMsg_.get_ROW_DATUM()) {
                        this.saveBufferedDataPositions();
                        this.saveRowPosition();
                        ++this.rowsRead_;
                        this.wasNull_ = 0;
                        return true;
                    }
                    this.setWarning(this.recvMsg_.get_WARNINGS());
                    try {
                        if (!this.recvMsg_.getHeaderEndOfStream()) break block8;
                        this.openOnServer_ = false;
                        bl = false;
                        var3_1 = null;
                    }
                    catch (Throwable throwable) {
                        var3_1 = null;
                        this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
                        this.recvMsg_ = null;
                        throw throwable;
                    }
                    this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
                    this.recvMsg_ = null;
                    return bl;
                }
                var3_1 = null;
                this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
                this.recvMsg_ = null;
                this.remote_FETCH_ROWS();
            }
        }
        catch (SQLException sQLException) {
            this.local_Close();
            this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
            this.recvMsg_ = null;
            throw sQLException;
        }
    }

    void remote_FETCH_ROWS() throws SQLException {
        this.recvMsg_ = this.statement_.remote_recvPrefetch();
        this.setNumDataPositions(this.resultCols_);
        this.saveRowPosition();
        this.restoreRowPosition();
        if (!this.recvMsg_.getHeaderEndOfStream()) {
            this.statement_.remote_sendPrefetch();
        }
    }

    void checkForClosedCursor() throws SQLException {
        if (!this.openOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__result_set_closed__);
        }
    }

    void saveRowPosition() {
        this.recvMsg_.mark();
    }

    void restoreRowPosition() {
        this.recvMsg_.reset();
    }

    void setNumDataPositions(int n) {
        this.columnDataPositions_ = new int[n];
    }

    void saveColumnDataPosition(int n) {
        this.columnDataPositions_[n] = this.recvMsg_.getPosition();
    }

    private void restoreColumnDataPosition(int n) {
        this.recvMsg_.setPosition(this.columnDataPositions_[n]);
    }

    short getRowData_short(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readShort();
    }

    int getRowData_int(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readInt();
    }

    long getRowData_long(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readLong();
    }

    float getRowData_float(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readFloat();
    }

    double getRowData_double(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readDouble();
    }

    int[] getRowData_timestampId(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readTimestampId();
    }

    int[] getRowData_blobId(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readBlobId();
    }

    int[] getRowData_arrayId(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readArrayId();
    }

    String getRowData_char(int n) throws SQLException {
        int n2;
        this.restoreColumnDataPosition(n);
        int n3 = this.recvMsg_.readLDChars(this.cbuf_, this.resultCharLengths_[n]);
        int n4 = n2 = this.statement_.maxFieldSize_ == 0 ? n3 : Math.min(n3, this.statement_.maxFieldSize_);
        if (this.adaptToRightTrimString_) {
            while (n2 > 0 && this.cbuf_[n2 - 1] == ' ') {
                --n2;
            }
        } else {
            int n5 = this.statement_.maxFieldSize_ == 0 ? this.resultCharLengths_[n] : Math.min(this.resultCharLengths_[n], this.statement_.maxFieldSize_);
            while (n2 < n5) {
                this.cbuf_[n2++] = 32;
            }
        }
        return new String(this.cbuf_, 0, n2);
    }

    String getRowData_varchar(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        int n2 = this.recvMsg_.readLDChars(this.cbuf_, this.resultCharLengths_[n]);
        int n3 = this.statement_.maxFieldSize_ == 0 ? n2 : Math.min(n2, this.statement_.maxFieldSize_);
        return new String(this.cbuf_, 0, n3);
    }

    byte[] getRowData_bytes(int n) throws SQLException {
        this.restoreColumnDataPosition(n);
        return this.recvMsg_.readLDBytes(this.statement_.maxFieldSize_);
    }

    void saveBufferedDataPositions() throws SQLException {
        int n = 0;
        while (n < this.resultCols_) {
            this.isNull_[n] = false;
            if (this.resultNullables_[n]) {
                this.isNull_[n] = this.recvMsg_.readBoolean();
            }
            if (!this.isNull_[n]) {
                this.saveColumnDataPosition(n);
                switch (this.resultTypes_[n]) {
                    case 1: 
                    case 7: {
                        this.recvMsg_.skipShort();
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.recvMsg_.skipInt();
                        break;
                    }
                    case 3: {
                        this.recvMsg_.skipFloat();
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.recvMsg_.skipDouble();
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.recvMsg_.skipLDBytes();
                        break;
                    }
                    case 11: {
                        this.recvMsg_.skipTimestampId();
                        break;
                    }
                    case 10: 
                    case 12: 
                    case 14: {
                        this.recvMsg_.skipBlobId();
                        break;
                    }
                    case 17: 
                    case 18: {
                        this.recvMsg_.skipLong();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 19: {
                        this.recvMsg_.skipInt();
                    }
                }
            }
            ++n;
        }
    }

    void setRecvBuffer(RecvMessage recvMessage) {
        this.recvMsg_ = recvMessage;
        this.setNumDataPositions(this.resultCols_);
        this.saveRowPosition();
    }

    void local_open() {
        this.openOnServer_ = true;
        this.openOnClient_ = true;
        this.rowsRead_ = 0;
        if (this.cbuf_ == null) {
            this.allocateCbuf();
        }
    }

    void local_Close() throws SQLException {
        this.openOnServer_ = false;
        this.openOnClient_ = false;
        this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
        this.recvMsg_ = null;
        Globals.cache__.returnCharBuffer(this.cbuf_);
        this.cbuf_ = null;
    }

    public synchronized void close() throws SQLException {
        this.jdbcNet_.destroyRecvMessage(this.recvMsg_);
        this.recvMsg_ = null;
        if (this.openOnServer_) {
            this.remote_CLOSE_CURSOR();
        }
        this.local_Close();
    }

    synchronized void remote_CLOSE_CURSOR() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(26);
        messageBufferOutputStream.writeInt(this.statement_.statementRef_);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    void checkForValidCursorPosition() throws SQLException {
        if (!this.validCursorPosition_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__read_at_invalid_cursor_position__);
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkForClosedCursor();
        if (this.wasNull_ == 0) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__was_null_with_no_data_retrieved__);
        }
        return this.wasNull_ == 1;
    }

    public synchronized String getString(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 8: {
                return this.getRowData_char(n - 1);
            }
            case 9: {
                return this.getRowData_varchar(n - 1);
            }
            case 14: {
                return "";
            }
            case 10: 
            case 12: {
                int[] nArray = this.getRowData_blobId(n - 1);
                return this.jdbcNet_.openBlobOutput(this.statement_, nArray).getString();
            }
            case 1: {
                return String.valueOf(this.getRowData_short(n - 1));
            }
            case 2: {
                return String.valueOf(this.getRowData_int(n - 1));
            }
            case 3: {
                return String.valueOf(this.getRowData_float(n - 1));
            }
            case 4: {
                return String.valueOf(this.getRowData_double(n - 1));
            }
            case 5: 
            case 6: 
            case 7: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]).toString();
            }
            case 11: {
                return this.getTimestamp(n).toString();
            }
            case 15: {
                return this.getDate(n).toString();
            }
            case 16: {
                return this.getTime(n).toString();
            }
            case 17: 
            case 18: 
            case 19: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]).toString();
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 114);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) != 0;
    }

    public synchronized byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public synchronized short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public synchronized int getInt(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0;
        }
        switch (this.resultTypes_[n - 1]) {
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 4: 
            case 5: {
                return (int)this.getRowData_double(n - 1);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 3: {
                return (int)this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized long getLong(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0L;
        }
        switch (this.resultTypes_[n - 1]) {
            case 4: 
            case 5: {
                return (long)this.getRowData_double(n - 1);
            }
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 3: {
                return (long)this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized float getFloat(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0.0f;
        }
        switch (this.resultTypes_[n - 1]) {
            case 3: {
                return this.getRowData_float(n - 1);
            }
            case 4: 
            case 5: {
                return (float)this.getRowData_double(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized double getDouble(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0.0;
        }
        switch (this.resultTypes_[n - 1]) {
            case 4: 
            case 5: {
                return this.getRowData_double(n - 1);
            }
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 3: {
                return this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        Object var3_3 = null;
        switch (this.resultTypes_[n - 1]) {
            case 1: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), n2);
            }
            case 2: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), n2);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 4: 
            case 5: {
                return new BigDecimal(this.getRowData_double(n - 1)).setScale(n2, 6);
            }
            case 3: {
                return new BigDecimal(this.getRowData_float(n - 1)).setScale(n2, 6);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return new BigDecimal(string).setScale(n2, 6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                int[] nArray = this.getRowData_blobId(n - 1);
                return this.jdbcNet_.openBlobOutput(this.statement_, nArray).getBytes();
            }
            case 8: 
            case 9: {
                return this.getRowData_bytes(n - 1);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Date getDate(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                int[] nArray = this.getRowData_timestampId(n - 1);
                IBTimestamp iBTimestamp = new IBTimestamp(0, nArray);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableDate_.setTime(iBTimestamp.getTimeInMillis());
                    return this.adaptableDate_;
                }
                return new Date(iBTimestamp.getTimeInMillis());
            }
            case 15: {
                int n2 = this.getRowData_int(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setDateTime(0, n2);
                    this.adaptableDate_.setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    return this.adaptableDate_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(0, n2);
                return new Date(iBTimestamp.getTimeInMillis());
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Date.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Time getTime(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                int[] nArray = this.getRowData_timestampId(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setTimestampId(1, nArray);
                    this.adaptableTime_.setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    return this.adaptableTime_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(1, nArray);
                return new Time(iBTimestamp.getTimeInMillis());
            }
            case 16: {
                int n2 = this.getRowData_int(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setDateTime(1, n2);
                    this.adaptableTime_.setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    return this.adaptableTime_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(1, n2);
                return new Time(iBTimestamp.getTimeInMillis());
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Time.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                int[] nArray = this.getRowData_timestampId(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setTimestampId(2, nArray);
                    ((java.util.Date)this.adaptableTimestamp_).setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    this.adaptableTimestamp_.setNanos(this.adaptableIBTimestamp_.getNanos());
                    return this.adaptableTimestamp_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(2, nArray);
                Timestamp timestamp = new Timestamp(iBTimestamp.getTimeInMillis());
                timestamp.setNanos(iBTimestamp.getNanos());
                return timestamp;
            }
            case 15: {
                int n2 = this.getRowData_int(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setDateTime(0, n2);
                    ((java.util.Date)this.adaptableTimestamp_).setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    this.adaptableTimestamp_.setNanos(this.adaptableIBTimestamp_.getNanos());
                    return this.adaptableTimestamp_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(0, n2);
                Timestamp timestamp = new Timestamp(iBTimestamp.getTimeInMillis());
                timestamp.setNanos(iBTimestamp.getNanos());
                return timestamp;
            }
            case 16: {
                int n3 = this.getRowData_int(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setDateTime(1, n3);
                    ((java.util.Date)this.adaptableTimestamp_).setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    this.adaptableTimestamp_.setNanos(this.adaptableIBTimestamp_.getNanos());
                    return this.adaptableTimestamp_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(1, n3);
                Timestamp timestamp = new Timestamp(iBTimestamp.getTimeInMillis());
                timestamp.setNanos(iBTimestamp.getNanos());
                return timestamp;
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return Timestamp.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                int[] nArray = this.getRowData_blobId(n - 1);
                return this.jdbcNet_.openBlobOutput(this.statement_, nArray).getInputStream();
            }
            case 8: 
            case 9: {
                return new ByteArrayInputStream(this.getRowData_bytes(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                int[] nArray = this.getRowData_blobId(n - 1);
                return this.jdbcNet_.openBlobOutput(this.statement_, nArray).getUnicodeInputStream();
            }
            case 8: {
                return new ByteToUnicodeConverterStream(this.getRowData_char(n - 1));
            }
            case 9: {
                return new ByteToUnicodeConverterStream(this.getRowData_varchar(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                int[] nArray = this.getRowData_blobId(n - 1);
                return this.jdbcNet_.openBlobOutput(this.statement_, nArray).getInputStream();
            }
            case 8: 
            case 9: {
                return new ByteArrayInputStream(this.getRowData_bytes(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarnings_;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    synchronized void setWarning(SQLWarning sQLWarning) {
        if (this.sqlWarnings_ != null) {
            this.sqlWarnings_.setNextException(sQLWarning);
        } else {
            this.sqlWarnings_ = sQLWarning;
        }
    }

    public String getCursorName() throws SQLException {
        return this.cursorName_;
    }

    public synchronized java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkForClosedCursor();
        if (this.resultSetMetaData_ == null) {
            this.resultSetMetaData_ = new ResultSetMetaData(this, this.jdbcNet_);
        }
        return this.resultSetMetaData_;
    }

    public synchronized Object getObject(int n) throws SQLException {
        switch (this.resultTypes_[n - 1]) {
            case 8: 
            case 9: 
            case 10: {
                return this.getString(n);
            }
            case 12: {
                return this.getBytes(n);
            }
            case 14: {
                return this.getArray(n);
            }
            case 11: {
                return this.getTimestamp(n);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]);
            }
            case 17: 
            case 18: 
            case 19: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]);
            }
            case 15: {
                return this.getDate(n);
            }
            case 16: {
                return this.getTime(n);
            }
            case 4: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return new Float(this.getFloat(n));
            }
            case 1: {
                return new Integer(this.getShort(n));
            }
            case 2: {
                return new Integer(this.getInt(n));
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 115);
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        } else {
            Integer n = (Integer)this.columnNameToIndexCache_.get(string);
            if (n != null) {
                return n;
            }
        }
        int n = 0;
        while (n < this.resultCols_) {
            if (this.resultColumnNames_[n].equalsIgnoreCase(string) || this.resultColumnLabels_[n].equalsIgnoreCase(string)) {
                this.columnNameToIndexCache_.put(string, new Integer(n + 1));
                return n + 1;
            }
            ++n;
        }
        throw new InvalidArgumentException(ErrorKey.invalidArgument__column_name_0__, (Object)string);
    }

    void recv_ResultMetaData(RecvMessage recvMessage) throws SQLException {
        int n = 0;
        while (n < this.resultCols_) {
            this.resultTableNames_[n] = recvMessage.readLDSQLText();
            this.resultColumnNames_[n] = recvMessage.readLDSQLText();
            this.resultColumnLabels_[n] = recvMessage.readBoolean() ? this.resultColumnNames_[n] : recvMessage.readLDSQLText();
            this.resultNullables_[n] = recvMessage.readBoolean();
            this.resultTypes_[n] = recvMessage.readUnsignedByte();
            this.resultPrecisions_[n] = recvMessage.readUnsignedShort();
            this.resultScales_[n] = recvMessage.readUnsignedByte();
            this.resultCharSets_[n] = recvMessage.readUnsignedShort();
            this.resultCharLengths_[n] = recvMessage.readUnsignedShort();
            if (this.resultTypes_[n] == 14 && recvMessage.readBoolean()) {
                this.arrayDescriptors_[n] = new ArrayDescriptor(recvMessage);
            }
            ++n;
        }
        this.allocateCbuf();
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        Object var2_2 = null;
        switch (this.resultTypes_[n - 1]) {
            case 1: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]);
            }
            case 2: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 4: 
            case 5: {
                return new BigDecimal(this.getRowData_double(n - 1)).setScale(this.resultScales_[n - 1], 6);
            }
            case 3: {
                return new BigDecimal(this.getRowData_float(n - 1)).setScale(this.resultScales_[n - 1], 6);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 8: 
            case 9: 
            case 10: {
                String string = this.getString(n);
                try {
                    return new BigDecimal(string).setScale(this.resultScales_[n - 1], 6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean isAfterLast() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean isFirst() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean isLast() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void beforeFirst() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void afterLast() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean first() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean last() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean absolute(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean relative(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean previous() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getFetchDirection() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getFetchSize() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getType() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getConcurrency() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean rowUpdated() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean rowInserted() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateNull(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateNull(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void insertRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void deleteRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void refreshRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void moveToInsertRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Statement getStatement() throws SQLException {
        return this.statement_;
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Array getArray(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 14: {
                return new Array(this.getRowData_arrayId(n - 1), this.arrayDescriptors_[n - 1], this.statement_.connection_);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Clob getClob(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public boolean isNull(int n) throws SQLException {
        this.checkForClosedCursor();
        this.checkForValidCursorPosition();
        try {
            return this.isNull_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public synchronized boolean adapt(int n, Object object) throws SQLException {
        switch (n) {
            case 1: {
                this.adaptToRightTrimString_ = true;
                return true;
            }
            case 2: {
                this.adaptToSingleInstanceTime_ = true;
                this.adaptableIBTimestamp_ = new IBTimestamp(0, 0, 1);
                this.adaptableDate_ = new Date(0L);
                this.adaptableTime_ = new Time(0L);
                this.adaptableTimestamp_ = new Timestamp(0L);
                return true;
            }
        }
        return false;
    }

    public synchronized void revert(int n) throws SQLException {
        switch (n) {
            case 1: {
                this.adaptToRightTrimString_ = false;
                break;
            }
            case 2: {
                this.adaptToSingleInstanceTime_ = false;
                break;
            }
        }
    }

    private boolean isNullPreamble(int n) throws SQLException {
        this.checkForClosedCursor();
        this.checkForValidCursorPosition();
        try {
            if (this.isNull_[n - 1]) {
                this.wasNull_ = 1;
                return true;
            }
            this.wasNull_ = 2;
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }
}

