/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient.utils;

import interbase.interclient.Connection;
import interbase.interclient.ConnectionProperties;
import interbase.interclient.DatabaseMetaData;
import interbase.interclient.Driver;
import interbase.interclient.utils.CommDiag;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;

final class InstallationVerifier {
    private static final int isc_sys_request = 335544373;
    private static final int initialStringBufferSize__ = 8000;
    private static final char newline__ = '\n';
    Driver driver_;

    InstallationVerifier() {
    }

    String loadDriver() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.driver_ = new Driver();
            stringBuffer.append(CommDiag.getResource("42"));
            stringBuffer.append('\n');
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("43"));
            stringBuffer.append('\n');
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("44"));
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            stringBuffer.append(CommDiag.getResource("45", noClassDefFoundError.getMessage()));
            return this.problemDetected(stringBuffer);
        }
        catch (Throwable throwable) {
            stringBuffer.append(CommDiag.getResource("41"));
            stringBuffer.append('\n');
            stringBuffer.append(throwable.getClass().getName());
            stringBuffer.append(": ");
            stringBuffer.append(throwable.getMessage());
            return this.problemDetected(stringBuffer);
        }
    }

    String verifyInstallation(String string, String string2, String string3, String string4, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(8000);
        try {
            stringBuffer.append(CommDiag.getResource("1", this.driver_.getMajorVersion(), this.driver_.getMinorVersion(), this.driver_.getBuildNumber()));
            if (this.driver_.getBuildCertificationLevel() == 0) {
                stringBuffer.append(" Test Build");
            }
            if (this.driver_.getBuildCertificationLevel() == 1) {
                stringBuffer.append(" Beta");
            }
            if (this.driver_.clientServerEdition()) {
                stringBuffer.append(CommDiag.getResource("2"));
            } else {
                stringBuffer.append(CommDiag.getResource("3"));
            }
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("57"));
            String[] stringArray = this.driver_.getCompatibleJREVersions();
            stringBuffer.append(stringArray[0]);
            int n2 = 1;
            while (n2 < stringArray.length) {
                stringBuffer.append(", " + stringArray[n2]);
                ++n2;
            }
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("58"));
            int[] nArray = this.driver_.getCompatibleIBVersions();
            stringBuffer.append(nArray[0]);
            int n3 = 1;
            while (n3 < nArray.length) {
                stringBuffer.append(", " + nArray[n3]);
                ++n3;
            }
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("6"));
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("7", this.driver_.getJDBCNetProtocol()));
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("8", String.valueOf(this.driver_.getJDBCNetProtocolVersion())));
            stringBuffer.append('\n');
            Date date = this.driver_.getExpirationDate();
            if (date == null) {
                stringBuffer.append(CommDiag.getResource("10"));
            } else {
                stringBuffer.append(CommDiag.getResource("9", date));
                stringBuffer.append('\n');
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("11"));
            }
            stringBuffer.append('\n');
            stringBuffer.append('\n');
            if (this.driver_.expiredDriver()) {
                stringBuffer.append(CommDiag.getResource("12"));
                stringBuffer.append('\n');
                stringBuffer.append('\n');
            }
            String string5 = "jdbc:interbase://" + string + "/" + string2;
            stringBuffer.append(CommDiag.getResource("13", string5));
            stringBuffer.append('\n');
            Connection connection = null;
            try {
                SQLWarning sQLWarning;
                ConnectionProperties connectionProperties = new ConnectionProperties();
                connectionProperties.setUser(string3, string4);
                DriverManager.setLoginTimeout(n);
                connection = (Connection)this.driver_.connect(string5, connectionProperties);
                stringBuffer.append(CommDiag.getResource("15", string5));
                stringBuffer.append('\n');
                stringBuffer.append('\n');
                DatabaseMetaData databaseMetaData = (DatabaseMetaData)connection.getMetaData();
                stringBuffer.append(CommDiag.getResource("17", databaseMetaData.getDatabaseProductName()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("18", databaseMetaData.getDatabaseProductVersion()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("19", databaseMetaData.getODSMajorVersion(), databaseMetaData.getODSMinorVersion()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("20", databaseMetaData.getPageSize()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("21", databaseMetaData.getPageAllocation()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("22", databaseMetaData.getPageAllocation() * databaseMetaData.getPageSize() / 1024));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("59", databaseMetaData.getDatabaseSQLDialect()));
                stringBuffer.append('\n');
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("23"));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("24", databaseMetaData.getInterServerVersion()));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("26", String.valueOf(databaseMetaData.getInterServerJDBCNetProtocolVersion())));
                stringBuffer.append('\n');
                if (databaseMetaData.getInterServerExpirationDate() == null) {
                    stringBuffer.append(CommDiag.getResource("28"));
                } else {
                    stringBuffer.append(CommDiag.getResource("27", databaseMetaData.getInterServerExpirationDate()));
                }
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("29", String.valueOf(databaseMetaData.getInterServerPort())));
                stringBuffer.append('\n');
                stringBuffer.append('\n');
                if (databaseMetaData.getInterServerExpirationDate() != null) {
                    stringBuffer.append(CommDiag.getResource("31"));
                    stringBuffer.append('\n');
                }
                if ((sQLWarning = connection.getWarnings()) != null) {
                    stringBuffer.append('\n');
                    stringBuffer.append(CommDiag.getResource("34"));
                    stringBuffer.append('\n');
                    stringBuffer.append(this.formatSQLException(sQLWarning));
                }
                connection.close();
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("16"));
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("33"));
                stringBuffer.append('\n');
                return stringBuffer.toString();
            }
            catch (SQLException sQLException) {
                stringBuffer.append('\n');
                stringBuffer.append(CommDiag.getResource("35"));
                stringBuffer.append('\n');
                stringBuffer.append(this.formatSQLException(sQLException));
                if (sQLException.getErrorCode() == 335544373) {
                    stringBuffer.append(CommDiag.getResource("39"));
                    stringBuffer.append('\n');
                }
                if (sQLException.getErrorCode() == 335544721) {
                    // empty if block
                }
                return this.problemDetected(stringBuffer);
            }
        }
        catch (Throwable throwable) {
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("41"));
            stringBuffer.append('\n');
            stringBuffer.append(throwable.getClass().getName());
            stringBuffer.append(": ");
            stringBuffer.append(throwable.getMessage());
            return this.problemDetected(stringBuffer);
        }
    }

    private String problemDetected(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append(CommDiag.getResource("32"));
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private String formatSQLException(SQLException sQLException) {
        StringBuffer stringBuffer = new StringBuffer();
        while (sQLException != null) {
            stringBuffer.append(CommDiag.getResource("36", sQLException.getSQLState()));
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("37", String.valueOf(sQLException.getErrorCode())));
            stringBuffer.append('\n');
            stringBuffer.append(CommDiag.getResource("38", sQLException.getMessage()));
            stringBuffer.append('\n');
            sQLException = sQLException.getNextException();
        }
        return stringBuffer.toString();
    }
}

