/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CardLockedException;
import com.sun.smartcard.scf.CardRemovedException;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.DoubleLockException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.SCFException;
import com.sun.smartcard.scf.TimeoutException;
import com.sun.smartcard.scf.spi.CardProvider;

class LockManager {
    private CardProvider cardProvider;
    private boolean isLockOwner;
    private final Logger logger = Logger.createLogger("LockManager");

    LockManager() {
    }

    void init(CardProvider cardProvider) {
        this.cardProvider = cardProvider;
        this.isLockOwner = false;
    }

    synchronized void close() {
        if (this.isLockOwner) {
            try {
                this.cardProvider.unlock();
            }
            catch (SCFException sCFException) {
                this.logger.log("close", sCFException.toString());
            }
            this.isLockOwner = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLock(int n) throws InvalidStateException, CommException, InternalException, TimeoutException, CardRemovedException, DoubleLockException {
        if (this.isLockOwner) {
            throw new DoubleLockException();
        }
        this.cardProvider.lock(2147483);
        LockManager lockManager = this;
        synchronized (lockManager) {
            this.isLockOwner = true;
        }
        this.logger.log("lock", "obtained");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock() throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        this.logger.log("unlock", "");
        if (!this.isLockOwner) {
            return;
        }
        this.cardProvider.unlock();
        LockManager lockManager = this;
        synchronized (lockManager) {
            this.isLockOwner = false;
        }
    }
}

