/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.utils.OCFUtils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.terminal.CardID;

public abstract class CardServiceFactory
extends opencard.core.service.CardServiceFactory {
    private final String cardName;
    protected final Vector services;
    protected final Vector validAIDs;

    protected CardServiceFactory(String string) {
        this.cardName = string;
        this.services = new Vector();
        this.validAIDs = new Vector();
    }

    public Enumeration cardServiceClasses(CardID cardID) {
        return this.services.elements();
    }

    public boolean knows(String string) {
        return string == null || string.equals("") || this.validAIDs.contains(string);
    }

    public boolean knows(CardID cardID) {
        String string;
        String string2 = null;
        try {
            string = OCFConstants.OCF_SERVER_PROPERTY_PREFIX + this.cardName + ".ATR";
            string2 = OCFUtils.getProperty(string, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        string = ServiceUtil.toHexString(cardID.getATR());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equalsIgnoreCase(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.cardName;
    }
}

