/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class PinCardService
extends CardService {
    int apdu_status;
    boolean isValidated = false;
    byte[] pinType_default = new byte[]{0};
    protected OCFCode ocf_codes;

    public boolean validatePin(byte[] byArray) throws OpenCardException, OCFCardException {
        this.isValidated = this.validateUserPin(byArray, this.pinType_default);
        return this.isValidated;
    }

    public boolean validateAndUnlock(byte[] byArray) throws OpenCardException, OCFCardException {
        this.isValidated = this.validateUserPin(byArray, this.pinType_default);
        return this.isValidated;
    }

    public void changePin(byte[] byArray, byte[] byArray2) throws OpenCardException, OCFCardException {
        this.changeUserPin(byArray, byArray2, this.pinType_default);
    }

    public void setPin(byte[] byArray) throws OpenCardException, OCFCardException {
    }

    public void clearPin(Short s) throws OpenCardException, OCFCardException {
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private void setupPinService() throws OpenCardException, OCFCardException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        this.selectByAID(this.ocf_codes.AIDBytes());
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    private ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException, OCFCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateUserPin(byte[] byArray, byte[] byArray2) throws OpenCardException, OCFCardException {
        boolean bl;
        try {
            this.setupPinService();
            byte[] byArray3 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USERPIN_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.paddingZero(byArray2, 1);
            byte[] byArray5 = ServiceUtil.arrayJoin(byArray3, byArray4);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.VALIDATE_USERPIN_Byte(), (int)byArray4[0], 0, byArray5, 1);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
            bl = responseAPDU.data()[0] == 0;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUserPin(byte[] byArray, byte[] byArray2, byte[] byArray3) throws OpenCardException, OCFCardException {
        try {
            this.setupPinService();
            byte[] byArray4 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USERPIN_LENGTH_Byte());
            byte[] byArray5 = ServiceUtil.paddingZero(byArray2, this.ocf_codes.USERPIN_LENGTH_Byte());
            byte[] byArray6 = ServiceUtil.paddingZero(byArray3, 1);
            byte[] byArray7 = new byte[byArray4.length + byArray5.length + 2];
            byArray7[0] = (byte)byArray4.length;
            System.arraycopy(byArray4, 0, byArray7, 1, byArray4.length);
            byArray7[byArray4.length + 1] = (byte)byArray5.length;
            System.arraycopy(byArray5, 0, byArray7, byArray4.length + 2, byArray5.length);
            byte[] byArray8 = ServiceUtil.arrayJoin(byArray7, byArray6);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.CHANGE_USERPIN_Byte(), (int)byArray6[0], 0, byArray8);
            this.sendAPDU(iSOCommandAPDU);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    protected void selectByAID(byte[] byArray) throws OpenCardException, OCFCardException {
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        this.sendAPDU(iSOCommandAPDU);
    }
}

