/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.cyberflex;

import com.sun.opencard.opt.security.CertificateAlias;
import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.service.common.KeyImportCardService;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.cyberflex.CyberFlexCode;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class CyberFlexKeyImportCardService
extends KeyImportCardService {
    int apdu_status;
    private static int PACKET_SIZE = 128;
    private static int MAX_CERT = 1022;
    private static int MAX_KEY = 384;
    private Certificate cert;
    private PrivateKey privKey;

    public CyberFlexKeyImportCardService() {
        this.ocf_codes = new CyberFlexCode();
    }

    public void setup() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            openCardException.printStackTrace();
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    public ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importCertificate(byte[] byArray, CertificateAlias certificateAlias, byte[] byArray2) throws CardServiceException, CardTerminalException, CertificateException, OpenCardException, OCFCardException {
        boolean bl = false;
        boolean bl2 = true;
        try {
            try {
                byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
                this.setup();
                byte[] byArray3 = certificateAlias.getAlias().getBytes();
                byte[] byArray4 = new byte[byArray.length + 1];
                byArray4[0] = (byte)byArray.length;
                System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
                if (byArray2.length > MAX_CERT) {
                    throw new OCFCardException(-28410, "Certificate is too big");
                }
                byte[] byArray5 = ServiceUtil.shortToByteArray((short)byArray2.length);
                byte[] byArray6 = new byte[byArray2.length + 2];
                int n = 0;
                short s = 0;
                int n2 = byArray2.length + 2;
                boolean bl3 = false;
                byArray6[0] = byArray5[0];
                byArray6[1] = byArray5[1];
                System.arraycopy(byArray2, 0, byArray6, 2, byArray2.length);
                int n3 = 0;
                while (n2 > 0) {
                    s = n2 <= PACKET_SIZE ? (short)n2 : (short)PACKET_SIZE;
                    byte[] byArray7 = new byte[s];
                    System.arraycopy(byArray6, n, byArray7, 0, s);
                    byte[] byArray8 = ServiceUtil.arrayJoin(byArray, byArray7);
                    ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 80, 0, (int)((byte)(++n3)), byArray8);
                    ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
                    n += s;
                    n2 -= s;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                Object var20_21 = null;
                this.releaseCardChannel();
                return;
            }
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    public Vector readCertificates() throws CardServiceException {
        try {
            this.setup();
            Vector<String> vector = new Vector<String>();
            byte[] byArray = new byte[]{};
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 82, 0, 0, byArray, PACKET_SIZE);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
            byte[] byArray2 = responseAPDU.data();
            short s = (short)(byArray2[0] * 256 + byArray2[1]);
            byte[] byArray3 = new byte[s];
            System.arraycopy(byArray2, 2, byArray3, 0, responseAPDU.data().length - 2);
            int n = responseAPDU.data().length - 2;
            int n2 = 2;
            while (n < s) {
                int n3 = PACKET_SIZE < s - n ? PACKET_SIZE : s - n;
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 82, 0, (int)((byte)n2), byArray, PACKET_SIZE);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byte[] byArray4 = responseAPDU.data();
                System.arraycopy(byArray4, 0, byArray3, n, n3);
                n += n3;
                ++n2;
            }
            String string = ServiceUtil.toHexString(byArray3);
            vector.add(string);
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CardServiceException("Error reading certificate");
        }
    }

    public void importPrivateKey(byte[] byArray, PrivateKeyAlias privateKeyAlias, PrivateKey privateKey) throws CardServiceException, CardTerminalException, InvalidKeyException, OpenCardException, OCFCardException {
        int n = 0;
        try {
            try {
                ResponseAPDU responseAPDU;
                ISOCommandAPDU iSOCommandAPDU;
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4;
                Object object;
                BigInteger bigInteger;
                Object object2;
                Serializable serializable;
                Object object3;
                Object object4;
                BigInteger bigInteger2;
                BigInteger bigInteger3;
                byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
                if (privateKey instanceof RSAPrivateCrtKey) {
                    bigInteger3 = ((RSAPrivateCrtKey)privateKey).getModulus();
                    bigInteger2 = ((RSAPrivateCrtKey)privateKey).getPrivateExponent();
                    object4 = this.toBigInt(ServiceUtil.parseHexString("010001"));
                    object3 = ((RSAPrivateCrtKey)privateKey).getPrimeP().abs();
                    serializable = bigInteger3.divide((BigInteger)object3).abs();
                    BigInteger bigInteger4 = ((BigInteger)object3).abs().modInverse(((BigInteger)serializable).abs());
                    object2 = bigInteger2.mod(((BigInteger)object3).subtract(new BigInteger("1")));
                    BigInteger bigInteger5 = bigInteger2.mod(((BigInteger)serializable).subtract(new BigInteger("1")));
                    bigInteger = ((BigInteger)serializable).subtract(new BigInteger("1")).multiply(((BigInteger)object3).subtract(new BigInteger("1")));
                    n = bigInteger3.toByteArray().length >= 128 ? 64 : 32;
                    object = ((BigInteger)object3).toByteArray();
                    byArray4 = ((BigInteger)serializable).toByteArray();
                    byArray3 = bigInteger4.toByteArray();
                    byArray2 = ((BigInteger)object2).toByteArray();
                    byte[] byArray5 = bigInteger5.toByteArray();
                    byte[] byArray6 = new byte[n];
                    byte[] byArray7 = new byte[n];
                    byte[] byArray8 = new byte[n];
                    byte[] byArray9 = new byte[n];
                    byte[] byArray10 = new byte[n];
                    System.arraycopy(object, object[0] == 0 ? 1 : 0, byArray6, 0, n);
                    System.arraycopy(byArray4, byArray4[0] == 0 ? 1 : 0, byArray7, 0, n);
                    System.arraycopy(byArray3, byArray3[0] == 0 ? 1 : 0, byArray8, 0, n);
                    System.arraycopy(byArray2, byArray2[0] == 0 ? 1 : 0, byArray9, 0, n);
                    System.arraycopy(byArray5, byArray5[0] == 0 ? 1 : 0, byArray10, 0, n);
                    if (byArray6.length != n || byArray7.length != n || byArray9.length != n || byArray10.length != n || byArray8.length != n) {
                        System.out.println("invalidate key component length");
                        throw new InvalidKeyException();
                    }
                    byte[] byArray11 = new byte[(n + 3) * 2 + 8];
                    byte[] byArray12 = new byte[(n + 3) * 3];
                    byArray11[0] = -62;
                    byArray11[1] = 6;
                    byArray11[2] = -63;
                    byArray11[3] = 8;
                    byArray11[4] = 48;
                    byArray11[5] = 0;
                    byArray11[6] = 0;
                    byArray11[7] = 5;
                    this.setCRT(byArray11, 8, byArray6, (byte)(n + 1), (byte)0, n);
                    this.setCRT(byArray11, 11 + n, byArray7, (byte)(n + 1), (byte)0, n);
                    this.setCRT(byArray12, 0, bigInteger4.toByteArray(), (byte)(n + 1), (byte)0, n);
                    this.setCRT(byArray12, 3 + n, byArray9, (byte)(n + 1), (byte)0, n);
                    this.setCRT(byArray12, 2 * (3 + n), byArray10, (byte)(n + 1), (byte)0, n);
                    this.setup();
                    byte[] byArray13 = privateKeyAlias.getAlias().getBytes();
                    byte[] byArray14 = new byte[(n + 3) * 5 + 8];
                    System.arraycopy(byArray11, 0, byArray14, 0, byArray11.length);
                    System.arraycopy(byArray12, 0, byArray14, byArray11.length, byArray12.length);
                    byte[] byArray15 = new byte[MAX_KEY];
                    int n2 = 0;
                    short s = 0;
                    int n3 = byArray15.length;
                    boolean bl = false;
                    System.arraycopy(byArray14, 0, byArray15, 0, byArray14.length);
                    int n4 = byArray14.length;
                    while (n4 < byArray15.length) {
                        byArray15[n4] = -1;
                        ++n4;
                    }
                    int n5 = 0;
                    while (n3 > 0) {
                        s = n3 <= PACKET_SIZE ? (short)n3 : (short)PACKET_SIZE;
                        byte[] byArray16 = new byte[s];
                        System.arraycopy(byArray15, n2, byArray16, 0, s);
                        byte[] byArray17 = ServiceUtil.arrayJoin(byArray, byArray16);
                        iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 56, 0, (int)((byte)(++n5)), byArray17);
                        responseAPDU = this.sendAPDU(iSOCommandAPDU);
                        n2 += s;
                        n3 -= s;
                    }
                } else {
                    throw new InvalidKeyException();
                }
                object4 = new byte[9];
                object4[0] = 8;
                System.arraycopy(byArray, 0, object4, 1, byArray.length);
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.CREATE_PRIVKEY_Byte(), 0, 0, (byte[])object4, -1);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                object3 = new byte[20];
                serializable = null;
                try {
                    serializable = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((SecureRandom)serializable).nextBytes((byte[])object3);
                int n6 = 2 * n;
                object2 = new byte[n6];
                object2[0] = false;
                object2[1] = true;
                int n7 = 2;
                while (n7 < n6 - 1 - ((Object)object3).length) {
                    object2[n7] = -1;
                    ++n7;
                }
                object2[n7] = false;
                System.arraycopy(object3, 0, object2, n7 + 1, ((Object)object3).length);
                bigInteger = new BigInteger((byte[])object2);
                object = bigInteger.modPow(bigInteger2, bigInteger3);
                byArray4 = ((BigInteger)object).toByteArray();
                byArray3 = ServiceUtil.arrayJoin(byArray, (byte[])object2);
                iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 72, 0, 0, byArray3);
                responseAPDU = this.sendAPDU(iSOCommandAPDU);
                byArray2 = responseAPDU.data();
                int n8 = byArray4[0] == 0 ? 1 : 0;
                int n9 = 0;
                while (n9 < byArray2.length) {
                    if (byArray2[n9] != byArray4[n9 + n8]) {
                        System.out.println("bad key");
                        throw new InvalidKeyException();
                    }
                    ++n9;
                }
                System.out.println("good key");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(exception.getMessage());
                throw new InvalidKeyException(exception.getMessage());
            }
            Object var43_45 = null;
        }
        catch (Throwable throwable) {
            Object var43_46 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    private void setCRT(byte[] byArray, int n, byte[] byArray2, byte by, byte by2, int n2) {
        byArray[n] = -62;
        byArray[n + 1] = by;
        byArray[n + 2] = by2;
        System.arraycopy(byArray2, 0, byArray, n + 3, n2);
    }

    public BigInteger toBigInt(byte[] byArray) throws Exception {
        String string = new String("");
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) < 16) {
                string = string + "0";
            }
            string = string + Integer.toHexString(byArray[n] & 0xFF).toUpperCase();
            ++n;
        }
        return new BigInteger(string, 16);
    }
}

